/**
 * MIT License
 *
 * Copyright (c) 2017 Microsoft
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof sap.ui.define === 'function')
		sap.ui.define([], factory);
	else if(typeof exports === 'object')
		exports["AdaptiveCards"] = factory();
	else
		root["AdaptiveCards"] = factory();
})(window, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./src/adaptivecards.ts");
/******/ })
/************************************************************************/
/******/ ({

			/***/ "./src/adaptivecards.ts":
			/*!******************************!*\
  !*** ./src/adaptivecards.ts ***!
  \******************************/
			/*! no static exports found */
			/***/ (function(module, exports, __webpack_require__) {

				"use strict";

				function __export(m) {
					for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
				}
				Object.defineProperty(exports, "__esModule", { value: true });
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
				__export(__webpack_require__(/*! ./card-elements */ "./src/card-elements.ts"));
				__export(__webpack_require__(/*! ./enums */ "./src/enums.ts"));
				__export(__webpack_require__(/*! ./host-config */ "./src/host-config.ts"));
				__export(__webpack_require__(/*! ./shared */ "./src/shared.ts"));
				__export(__webpack_require__(/*! ./utils */ "./src/utils.ts"));


				/***/ }),

			/***/ "./src/card-elements.ts":
			/*!******************************!*\
  !*** ./src/card-elements.ts ***!
  \******************************/
			/*! no static exports found */
			/***/ (function(module, exports, __webpack_require__) {

				"use strict";

				var __extends = (this && this.__extends) || (function () {
					var extendStatics = function (d, b) {
						extendStatics = Object.setPrototypeOf ||
							({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
							function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
						return extendStatics(d, b);
					};
					return function (d, b) {
						extendStatics(d, b);
						function __() { this.constructor = d; }
						d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
					};
				})();
				Object.defineProperty(exports, "__esModule", { value: true });
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
				var Enums = __webpack_require__(/*! ./enums */ "./src/enums.ts");
				var Shared = __webpack_require__(/*! ./shared */ "./src/shared.ts");
				var Utils = __webpack_require__(/*! ./utils */ "./src/utils.ts");
				var HostConfig = __webpack_require__(/*! ./host-config */ "./src/host-config.ts");
				var TextFormatters = __webpack_require__(/*! ./text-formatters */ "./src/text-formatters.ts");
				function invokeSetCollection(action, collection) {
					if (action) {
						// Closest emulation of "internal" in TypeScript.
						action["setCollection"](collection);
					}
				}
				function isActionAllowed(action, forbiddenActionTypes) {
					if (forbiddenActionTypes) {
						for (var i = 0; i < forbiddenActionTypes.length; i++) {
							if (action.getJsonTypeName() === forbiddenActionTypes[i]) {
								return false;
							}
						}
					}
					return true;
				}
				var InstanceCreationErrorType;
				(function (InstanceCreationErrorType) {
					InstanceCreationErrorType[InstanceCreationErrorType["UnknownType"] = 0] = "UnknownType";
					InstanceCreationErrorType[InstanceCreationErrorType["ForbiddenType"] = 1] = "ForbiddenType";
				})(InstanceCreationErrorType || (InstanceCreationErrorType = {}));
				function createCardObjectInstance(parent, json, forbiddenTypeNames, allowFallback, createInstanceCallback, createValidationErrorCallback, errors) {
					var result = null;
					if (json && typeof json === "object") {
						var tryToFallback = false;
						var typeName = Utils.getStringValue(json["type"]);
						if (forbiddenTypeNames && forbiddenTypeNames.indexOf(typeName) >= 0) {
							raiseParseError(createValidationErrorCallback(typeName, InstanceCreationErrorType.ForbiddenType), errors);
						}
						else {
							result = createInstanceCallback(typeName);
							if (!result) {
								tryToFallback = allowFallback;
								raiseParseError(createValidationErrorCallback(typeName, InstanceCreationErrorType.UnknownType), errors);
							}
							else {
								result.setParent(parent);
								result.parse(json, errors);
								tryToFallback = result.shouldFallback() && allowFallback;
							}
							if (tryToFallback) {
								var fallback = json["fallback"];
								if (!fallback) {
									parent.setShouldFallback(true);
								}
								if (typeof fallback === "string" && fallback.toLowerCase() === "drop") {
									result = null;
								}
								else if (typeof fallback === "object") {
									result = createCardObjectInstance(parent, fallback, forbiddenTypeNames, true, createInstanceCallback, createValidationErrorCallback, errors);
								}
							}
						}
					}
					return result;
				}
				function createActionInstance(parent, json, forbiddenActionTypes, allowFallback, errors) {
					return createCardObjectInstance(parent, json, forbiddenActionTypes, allowFallback, function (typeName) { return AdaptiveCard.actionTypeRegistry.createInstance(typeName); }, function (typeName, errorType) {
						if (errorType == InstanceCreationErrorType.UnknownType) {
							return {
								error: Enums.ValidationError.UnknownActionType,
								message: "Unknown action type: " + typeName + ". Fallback will be used if present."
							};
						}
						else {
							return {
								error: Enums.ValidationError.ActionTypeNotAllowed,
								message: "Action type " + typeName + " is not allowed in this context."
							};
						}
					}, errors);
				}
				exports.createActionInstance = createActionInstance;
				function createElementInstance(parent, json, allowFallback, errors) {
					return createCardObjectInstance(parent, json, [], // Forbidden types not supported for elements for now
						allowFallback, function (typeName) { return AdaptiveCard.elementTypeRegistry.createInstance(typeName); }, function (typeName, errorType) {
							if (errorType == InstanceCreationErrorType.UnknownType) {
								return {
									error: Enums.ValidationError.UnknownElementType,
									message: "Unknown element type: " + typeName + ". Fallback will be used if present."
								};
							}
							else {
								return {
									error: Enums.ValidationError.ElementTypeNotAllowed,
									message: "Element type " + typeName + " is not allowed in this context."
								};
							}
						}, errors);
				}
				exports.createElementInstance = createElementInstance;
				var SerializableObject = /** @class */ (function () {
					function SerializableObject() {
						this._rawProperties = {};
					}
					SerializableObject.prototype.parse = function (json, errors) {
						this._rawProperties = AdaptiveCard.enableFullJsonRoundTrip ? json : {};
					};
					SerializableObject.prototype.toJSON = function () {
						var result;
						if (AdaptiveCard.enableFullJsonRoundTrip && this._rawProperties && typeof this._rawProperties === "object") {
							result = this._rawProperties;
						}
						else {
							result = {};
						}
						return result;
					};
					SerializableObject.prototype.setCustomProperty = function (name, value) {
						var shouldDeleteProperty = (typeof value === "string" && Utils.isNullOrEmpty(value)) || value === undefined || value === null;
						if (shouldDeleteProperty) {
							delete this._rawProperties[name];
						}
						else {
							this._rawProperties[name] = value;
						}
					};
					SerializableObject.prototype.getCustomProperty = function (name) {
						return this._rawProperties[name];
					};
					return SerializableObject;
				}());
				exports.SerializableObject = SerializableObject;
				var ValidationFailure = /** @class */ (function () {
					function ValidationFailure(cardObject) {
						this.cardObject = cardObject;
						this.errors = [];
					}
					return ValidationFailure;
				}());
				exports.ValidationFailure = ValidationFailure;
				var ValidationResults = /** @class */ (function () {
					function ValidationResults() {
						this.allIds = {};
						this.failures = [];
					}
					ValidationResults.prototype.getFailureIndex = function (cardObject) {
						for (var i = 0; i < this.failures.length; i++) {
							if (this.failures[i].cardObject === cardObject) {
								return i;
							}
						}
						return -1;
					};
					ValidationResults.prototype.addFailure = function (cardObject, error) {
						var index = this.getFailureIndex(cardObject);
						var failure;
						if (index < 0) {
							failure = new ValidationFailure(cardObject);
							this.failures.push(failure);
						}
						else {
							failure = this.failures[index];
						}
						failure.errors.push(error);
					};
					return ValidationResults;
				}());
				exports.ValidationResults = ValidationResults;
				var CardObject = /** @class */ (function (_super) {
					__extends(CardObject, _super);
					function CardObject() {
						return _super !== null && _super.apply(this, arguments) || this;
					}
					CardObject.prototype.internalValidateProperties = function (context) {
						if (!Utils.isNullOrEmpty(this.id)) {
							if (context.allIds.hasOwnProperty(this.id)) {
								if (context.allIds[this.id] == 1) {
									context.addFailure(this, {
										error: Enums.ValidationError.DuplicateId,
										message: "Duplicate Id: " + this.id
									});
								}
								context.allIds[this.id] += 1;
							}
							else {
								context.allIds[this.id] = 1;
							}
						}
					};
					CardObject.prototype.parse = function (json, errors) {
						_super.prototype.parse.call(this, json, errors);
						this.id = Utils.getStringValue(json["id"]);
					};
					CardObject.prototype.toJSON = function () {
						var result = _super.prototype.toJSON.call(this);
						Utils.setProperty(result, "type", this.getJsonTypeName());
						Utils.setProperty(result, "id", this.id);
						return result;
					};
					CardObject.prototype.validateProperties = function () {
						var result = new ValidationResults();
						this.internalValidateProperties(result);
						return result;
					};
					return CardObject;
				}(SerializableObject));
				exports.CardObject = CardObject;
				var CardElement = /** @class */ (function (_super) {
					__extends(CardElement, _super);
					function CardElement() {
						var _this = _super !== null && _super.apply(this, arguments) || this;
						_this._shouldFallback = false;
						_this._lang = undefined;
						_this._hostConfig = null;
						_this._parent = null;
						_this._renderedElement = null;
						_this._separatorElement = null;
						_this._isVisible = true;
						_this._truncatedDueToOverflow = false;
						_this._defaultRenderedElementDisplayMode = null;
						_this._padding = null;
						_this.requires = new HostConfig.HostCapabilities();
						_this.horizontalAlignment = null;
						_this.spacing = Enums.Spacing.Default;
						_this.separator = false;
						_this.customCssSelector = null;
						_this.height = "auto";
						_this.minPixelHeight = null;
						return _this;
					}
					CardElement.prototype.internalRenderSeparator = function () {
						var renderedSeparator = Utils.renderSeparation(this.hostConfig, {
							spacing: this.hostConfig.getEffectiveSpacing(this.spacing),
							lineThickness: this.separator ? this.hostConfig.separator.lineThickness : null,
							lineColor: this.separator ? this.hostConfig.separator.lineColor : null
						}, this.separatorOrientation);
						if (AdaptiveCard.alwaysBleedSeparators && renderedSeparator && this.separatorOrientation == Enums.Orientation.Horizontal) {
							// Adjust separator's margins if the option to always bleed separators is turned on
							var parentContainer = this.getParentContainer();
							if (parentContainer && parentContainer.getEffectivePadding()) {
								var parentPhysicalPadding = this.hostConfig.paddingDefinitionToSpacingDefinition(parentContainer.getEffectivePadding());
								renderedSeparator.style.marginLeft = "-" + parentPhysicalPadding.left + "px";
								renderedSeparator.style.marginRight = "-" + parentPhysicalPadding.right + "px";
							}
						}
						return renderedSeparator;
					};
					CardElement.prototype.updateRenderedElementVisibility = function () {
						var displayMode = this.isDesignMode() || this.isVisible ? this._defaultRenderedElementDisplayMode : "none";
						if (this._renderedElement) {
							this._renderedElement.style.display = displayMode;
						}
						if (this._separatorElement) {
							if (this.parent && this.parent.isFirstElement(this)) {
								this._separatorElement.style.display = "none";
							}
							else {
								this._separatorElement.style.display = displayMode;
							}
						}
					};
					CardElement.prototype.hideElementDueToOverflow = function () {
						if (this._renderedElement && this.isVisible) {
							this._renderedElement.style.visibility = 'hidden';
							this.isVisible = false;
							raiseElementVisibilityChangedEvent(this, false);
						}
					};
					CardElement.prototype.showElementHiddenDueToOverflow = function () {
						if (this._renderedElement && !this.isVisible) {
							this._renderedElement.style.visibility = null;
							this.isVisible = true;
							raiseElementVisibilityChangedEvent(this, false);
						}
					};
					// Marked private to emulate internal access
					CardElement.prototype.handleOverflow = function (maxHeight) {
						if (this.isVisible || this.isHiddenDueToOverflow()) {
							var handled = this.truncateOverflow(maxHeight);
							// Even if we were unable to truncate the element to fit this time,
							// it still could have been previously truncated
							this._truncatedDueToOverflow = handled || this._truncatedDueToOverflow;
							if (!handled) {
								this.hideElementDueToOverflow();
							}
							else if (handled && !this.isVisible) {
								this.showElementHiddenDueToOverflow();
							}
						}
					};
					// Marked private to emulate internal access
					CardElement.prototype.resetOverflow = function () {
						var sizeChanged = false;
						if (this._truncatedDueToOverflow) {
							this.undoOverflowTruncation();
							this._truncatedDueToOverflow = false;
							sizeChanged = true;
						}
						if (this.isHiddenDueToOverflow) {
							this.showElementHiddenDueToOverflow();
						}
						return sizeChanged;
					};
					CardElement.prototype.createPlaceholderElement = function () {
						var element = document.createElement("div");
						element.style.border = "1px dashed #DDDDDD";
						element.style.padding = "4px";
						element.style.minHeight = "32px";
						element.style.fontSize = "10px";
						element.innerText = "Empty " + this.getJsonTypeName();
						return element;
					};
					CardElement.prototype.adjustRenderedElementSize = function (renderedElement) {
						if (this.height === "auto") {
							renderedElement.style.flex = "0 0 auto";
						}
						else {
							renderedElement.style.flex = "1 1 auto";
						}
						if (this.minPixelHeight) {
							renderedElement.style.minHeight = this.minPixelHeight + "px";
						}
					};
					CardElement.prototype.overrideInternalRender = function () {
						return this.internalRender();
					};
					CardElement.prototype.applyPadding = function () {
						if (this.separatorElement) {
							if (AdaptiveCard.alwaysBleedSeparators && this.separatorOrientation == Enums.Orientation.Horizontal && !this.isBleeding()) {
								var padding = new Shared.PaddingDefinition();
								this.getImmediateSurroundingPadding(padding);
								var physicalPadding = this.hostConfig.paddingDefinitionToSpacingDefinition(padding);
								this.separatorElement.style.marginLeft = "-" + physicalPadding.left + "px";
								this.separatorElement.style.marginRight = "-" + physicalPadding.right + "px";
							}
							else {
								this.separatorElement.style.marginRight = "0";
								this.separatorElement.style.marginLeft = "0";
							}
						}
					};
					/*
     * Called when this element overflows the bottom of the card.
     * maxHeight will be the amount of space still available on the card (0 if
     * the element is fully off the card).
     */
					CardElement.prototype.truncateOverflow = function (maxHeight) {
						// Child implementations should return true if the element handled
						// the truncation request such that its content fits within maxHeight,
						// false if the element should fall back to being hidden
						return false;
					};
					/*
     * This should reverse any changes performed in truncateOverflow().
     */
					CardElement.prototype.undoOverflowTruncation = function () { };
					CardElement.prototype.getDefaultPadding = function () {
						return new Shared.PaddingDefinition();
					};
					CardElement.prototype.getHasBackground = function () {
						return false;
					};
					CardElement.prototype.getPadding = function () {
						return this._padding;
					};
					CardElement.prototype.setPadding = function (value) {
						this._padding = value;
					};
					Object.defineProperty(CardElement.prototype, "supportsMinHeight", {
						get: function () {
							return false;
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(CardElement.prototype, "useDefaultSizing", {
						get: function () {
							return true;
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(CardElement.prototype, "allowCustomPadding", {
						get: function () {
							return true;
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(CardElement.prototype, "separatorOrientation", {
						get: function () {
							return Enums.Orientation.Horizontal;
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(CardElement.prototype, "defaultStyle", {
						get: function () {
							return Enums.ContainerStyle.Default;
						},
						enumerable: true,
						configurable: true
					});
					CardElement.prototype.asString = function () {
						return "";
					};
					CardElement.prototype.isBleeding = function () {
						return false;
					};
					CardElement.prototype.toJSON = function () {
						var result = _super.prototype.toJSON.call(this);
						Utils.setProperty(result, "isVisible", this.isVisible, true);
						if (this.horizontalAlignment !== null) {
							Utils.setEnumProperty(Enums.HorizontalAlignment, result, "horizontalAlignment", this.horizontalAlignment);
						}
						Utils.setEnumProperty(Enums.Spacing, result, "spacing", this.spacing, Enums.Spacing.Default);
						Utils.setProperty(result, "separator", this.separator, false);
						Utils.setProperty(result, "height", this.height, "auto");
						if (this.supportsMinHeight) {
							Utils.setProperty(result, "minHeight", typeof this.minPixelHeight === "number" && !isNaN(this.minPixelHeight) ? this.minPixelHeight + "px" : undefined);
						}
						return result;
					};
					CardElement.prototype.setParent = function (value) {
						this._parent = value;
					};
					CardElement.prototype.getEffectiveStyle = function () {
						if (this.parent) {
							return this.parent.getEffectiveStyle();
						}
						return this.defaultStyle;
					};
					CardElement.prototype.getForbiddenElementTypes = function () {
						return null;
					};
					CardElement.prototype.getForbiddenActionTypes = function () {
						return null;
					};
					CardElement.prototype.getImmediateSurroundingPadding = function (result, processTop, processRight, processBottom, processLeft) {
						if (processTop === void 0) { processTop = true; }
						if (processRight === void 0) { processRight = true; }
						if (processBottom === void 0) { processBottom = true; }
						if (processLeft === void 0) { processLeft = true; }
						if (this.parent) {
							var doProcessTop = processTop && this.parent.isTopElement(this);
							var doProcessRight = processRight && this.parent.isRightMostElement(this);
							var doProcessBottom = processBottom && this.parent.isBottomElement(this);
							var doProcessLeft = processLeft && this.parent.isLeftMostElement(this);
							var effectivePadding = this.parent.getEffectivePadding();
							if (effectivePadding) {
								if (doProcessTop && effectivePadding.top != Enums.Spacing.None) {
									result.top = effectivePadding.top;
									doProcessTop = false;
								}
								if (doProcessRight && effectivePadding.right != Enums.Spacing.None) {
									result.right = effectivePadding.right;
									doProcessRight = false;
								}
								if (doProcessBottom && effectivePadding.bottom != Enums.Spacing.None) {
									result.bottom = effectivePadding.bottom;
									doProcessBottom = false;
								}
								if (doProcessLeft && effectivePadding.left != Enums.Spacing.None) {
									result.left = effectivePadding.left;
									doProcessLeft = false;
								}
							}
							if (doProcessTop || doProcessRight || doProcessBottom || doProcessLeft) {
								this.parent.getImmediateSurroundingPadding(result, doProcessTop, doProcessRight, doProcessBottom, doProcessLeft);
							}
						}
					};
					CardElement.prototype.parse = function (json, errors) {
						_super.prototype.parse.call(this, json, errors);
						raiseParseElementEvent(this, json, errors);
						this.requires.parse(json["requires"], errors);
						this.isVisible = Utils.getBoolValue(json["isVisible"], this.isVisible);
						this.horizontalAlignment = Utils.getEnumValue(Enums.HorizontalAlignment, json["horizontalAlignment"], this.horizontalAlignment);
						this.spacing = Utils.getEnumValue(Enums.Spacing, json["spacing"], Enums.Spacing.Default);
						this.separator = Utils.getBoolValue(json["separator"], this.separator);
						var jsonSeparation = json["separation"];
						if (jsonSeparation !== undefined) {
							if (jsonSeparation === "none") {
								this.spacing = Enums.Spacing.None;
								this.separator = false;
							}
							else if (jsonSeparation === "strong") {
								this.spacing = Enums.Spacing.Large;
								this.separator = true;
							}
							else if (jsonSeparation === "default") {
								this.spacing = Enums.Spacing.Default;
								this.separator = false;
							}
							raiseParseError({
								error: Enums.ValidationError.Deprecated,
								message: "The \"separation\" property is deprecated and will be removed. Use the \"spacing\" and \"separator\" properties instead."
							}, errors);
						}
						var jsonHeight = json["height"];
						if (jsonHeight === "auto" || jsonHeight === "stretch") {
							this.height = jsonHeight;
						}
						if (this.supportsMinHeight) {
							var jsonMinHeight = json["minHeight"];
							if (jsonMinHeight && typeof jsonMinHeight === "string") {
								var isValid = false;
								try {
									var size = Shared.SizeAndUnit.parse(jsonMinHeight, true);
									if (size.unit == Enums.SizeUnit.Pixel) {
										this.minPixelHeight = size.physicalSize;
										isValid = true;
									}
								}
								catch (_a) {
									// Do nothing. A parse error is emitted below
								}
								if (!isValid) {
									raiseParseError({
										error: Enums.ValidationError.InvalidPropertyValue,
										message: "Invalid \"minHeight\" value: " + jsonMinHeight
									}, errors);
								}
							}
						}
						else {
							this.minPixelHeight = null;
						}
					};
					CardElement.prototype.getActionCount = function () {
						return 0;
					};
					CardElement.prototype.getActionAt = function (index) {
						throw new Error("Index out of range.");
					};
					CardElement.prototype.remove = function () {
						if (this.parent && this.parent instanceof CardElementContainer) {
							return this.parent.removeItem(this);
						}
						return false;
					};
					CardElement.prototype.render = function () {
						this._renderedElement = this.overrideInternalRender();
						this._separatorElement = this.internalRenderSeparator();
						if (this._renderedElement) {
							if (this.customCssSelector) {
								this._renderedElement.classList.add(this.customCssSelector);
							}
							this._renderedElement.style.boxSizing = "border-box";
							this._defaultRenderedElementDisplayMode = this._renderedElement.style.display;
							this.adjustRenderedElementSize(this._renderedElement);
							this.updateLayout(false);
						}
						else if (this.isDesignMode()) {
							this._renderedElement = this.createPlaceholderElement();
						}
						return this._renderedElement;
					};
					CardElement.prototype.updateLayout = function (processChildren) {
						if (processChildren === void 0) { processChildren = true; }
						this.updateRenderedElementVisibility();
						this.applyPadding();
					};
					CardElement.prototype.indexOf = function (cardElement) {
						return -1;
					};
					CardElement.prototype.isDesignMode = function () {
						var rootElement = this.getRootElement();
						return rootElement instanceof AdaptiveCard && rootElement.designMode;
					};
					CardElement.prototype.isRendered = function () {
						return this._renderedElement && this._renderedElement.offsetHeight > 0;
					};
					CardElement.prototype.isFirstElement = function (element) {
						return true;
					};
					CardElement.prototype.isLastElement = function (element) {
						return true;
					};
					CardElement.prototype.isAtTheVeryLeft = function () {
						return this.parent ? this.parent.isLeftMostElement(this) && this.parent.isAtTheVeryLeft() : true;
					};
					CardElement.prototype.isAtTheVeryRight = function () {
						return this.parent ? this.parent.isRightMostElement(this) && this.parent.isAtTheVeryRight() : true;
					};
					CardElement.prototype.isAtTheVeryTop = function () {
						return this.parent ? this.parent.isFirstElement(this) && this.parent.isAtTheVeryTop() : true;
					};
					CardElement.prototype.isAtTheVeryBottom = function () {
						return this.parent ? this.parent.isLastElement(this) && this.parent.isAtTheVeryBottom() : true;
					};
					CardElement.prototype.isBleedingAtTop = function () {
						return false;
					};
					CardElement.prototype.isBleedingAtBottom = function () {
						return false;
					};
					CardElement.prototype.isLeftMostElement = function (element) {
						return true;
					};
					CardElement.prototype.isRightMostElement = function (element) {
						return true;
					};
					CardElement.prototype.isTopElement = function (element) {
						return this.isFirstElement(element);
					};
					CardElement.prototype.isBottomElement = function (element) {
						return this.isLastElement(element);
					};
					CardElement.prototype.isHiddenDueToOverflow = function () {
						return this._renderedElement && this._renderedElement.style.visibility == 'hidden';
					};
					CardElement.prototype.getRootElement = function () {
						var rootElement = this;
						while (rootElement.parent) {
							rootElement = rootElement.parent;
						}
						return rootElement;
					};
					CardElement.prototype.getParentContainer = function () {
						var currentElement = this.parent;
						while (currentElement) {
							if (currentElement instanceof Container) {
								return currentElement;
							}
							currentElement = currentElement.parent;
						}
						return null;
					};
					CardElement.prototype.getAllInputs = function () {
						return [];
					};
					CardElement.prototype.getResourceInformation = function () {
						return [];
					};
					CardElement.prototype.getElementById = function (id) {
						return this.id === id ? this : null;
					};
					CardElement.prototype.getActionById = function (id) {
						return null;
					};
					CardElement.prototype.shouldFallback = function () {
						return this._shouldFallback || !this.requires.areAllMet(this.hostConfig.hostCapabilities);
					};
					CardElement.prototype.setShouldFallback = function (value) {
						this._shouldFallback = value;
					};
					CardElement.prototype.getEffectivePadding = function () {
						var padding = this.getPadding();
						return (padding && this.allowCustomPadding) ? padding : this.getDefaultPadding();
					};
					Object.defineProperty(CardElement.prototype, "lang", {
						get: function () {
							if (this._lang) {
								return this._lang;
							}
							else {
								if (this.parent) {
									return this.parent.lang;
								}
								else {
									return undefined;
								}
							}
						},
						set: function (value) {
							if (value && value != "") {
								var regEx = /^[a-z]{2,3}$/ig;
								var matches = regEx.exec(value);
								if (!matches) {
									throw new Error("Invalid language identifier: " + value);
								}
							}
							this._lang = value;
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(CardElement.prototype, "hostConfig", {
						get: function () {
							if (this._hostConfig) {
								return this._hostConfig;
							}
							else {
								if (this.parent) {
									return this.parent.hostConfig;
								}
								else {
									return defaultHostConfig;
								}
							}
						},
						set: function (value) {
							this._hostConfig = value;
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(CardElement.prototype, "index", {
						get: function () {
							if (this.parent) {
								return this.parent.indexOf(this);
							}
							else {
								return 0;
							}
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(CardElement.prototype, "isInteractive", {
						get: function () {
							return false;
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(CardElement.prototype, "isStandalone", {
						get: function () {
							return true;
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(CardElement.prototype, "isInline", {
						get: function () {
							return false;
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(CardElement.prototype, "parent", {
						get: function () {
							return this._parent;
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(CardElement.prototype, "isVisible", {
						get: function () {
							return this._isVisible;
						},
						set: function (value) {
							// If the element is going to be hidden, reset any changes that were due
							// to overflow truncation (this ensures that if the element is later
							// un-hidden it has the right content)
							if (AdaptiveCard.useAdvancedCardBottomTruncation && !value) {
								this.undoOverflowTruncation();
							}
							if (this._isVisible != value) {
								this._isVisible = value;
								this.updateRenderedElementVisibility();
								if (this._renderedElement) {
									raiseElementVisibilityChangedEvent(this);
								}
							}
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(CardElement.prototype, "hasVisibleSeparator", {
						get: function () {
							if (this.parent && this.separatorElement) {
								return !this.parent.isFirstElement(this) && (this.isVisible || this.isDesignMode());
							}
							else {
								return false;
							}
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(CardElement.prototype, "renderedElement", {
						get: function () {
							return this._renderedElement;
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(CardElement.prototype, "separatorElement", {
						get: function () {
							return this._separatorElement;
						},
						enumerable: true,
						configurable: true
					});
					return CardElement;
				}(CardObject));
				exports.CardElement = CardElement;
				var BaseTextBlock = /** @class */ (function (_super) {
					__extends(BaseTextBlock, _super);
					function BaseTextBlock() {
						var _this = _super !== null && _super.apply(this, arguments) || this;
						_this._selectAction = null;
						_this.size = Enums.TextSize.Default;
						_this.weight = Enums.TextWeight.Default;
						_this.color = Enums.TextColor.Default;
						_this.isSubtle = false;
						_this.fontType = null;
						return _this;
					}
					BaseTextBlock.prototype.getEffectiveStyleDefinition = function () {
						return this.hostConfig.containerStyles.getStyleByName(this.getEffectiveStyle());
					};
					BaseTextBlock.prototype.getFontSize = function (fontType) {
						switch (this.size) {
							case Enums.TextSize.Small:
								return fontType.fontSizes.small;
							case Enums.TextSize.Medium:
								return fontType.fontSizes.medium;
							case Enums.TextSize.Large:
								return fontType.fontSizes.large;
							case Enums.TextSize.ExtraLarge:
								return fontType.fontSizes.extraLarge;
							default:
								return fontType.fontSizes.default;
						}
					};
					BaseTextBlock.prototype.getColorDefinition = function (colorSet, color) {
						switch (color) {
							case Enums.TextColor.Accent:
								return colorSet.accent;
							case Enums.TextColor.Dark:
								return colorSet.dark;
							case Enums.TextColor.Light:
								return colorSet.light;
							case Enums.TextColor.Good:
								return colorSet.good;
							case Enums.TextColor.Warning:
								return colorSet.warning;
							case Enums.TextColor.Attention:
								return colorSet.attention;
							default:
								return colorSet.default;
						}
					};
					BaseTextBlock.prototype.setText = function (value) {
						this._text = value;
					};
					BaseTextBlock.prototype.asString = function () {
						return this.text;
					};
					BaseTextBlock.prototype.toJSON = function () {
						var result = _super.prototype.toJSON.call(this);
						Utils.setEnumProperty(Enums.TextSize, result, "size", this.size, Enums.TextSize.Default);
						Utils.setEnumProperty(Enums.TextWeight, result, "weight", this.weight, Enums.TextWeight.Default);
						Utils.setEnumProperty(Enums.TextColor, result, "color", this.color, Enums.TextColor.Default);
						Utils.setProperty(result, "text", this.text);
						Utils.setProperty(result, "isSubtle", this.isSubtle, false);
						Utils.setEnumProperty(Enums.FontType, result, "fontType", this.fontType, Enums.FontType.Default);
						return result;
					};
					BaseTextBlock.prototype.applyStylesTo = function (targetElement) {
						var fontType = this.hostConfig.getFontTypeDefinition(this.fontType);
						if (fontType.fontFamily) {
							targetElement.style.fontFamily = fontType.fontFamily;
						}
						var fontSize;
						switch (this.size) {
							case Enums.TextSize.Small:
								fontSize = fontType.fontSizes.small;
								break;
							case Enums.TextSize.Medium:
								fontSize = fontType.fontSizes.medium;
								break;
							case Enums.TextSize.Large:
								fontSize = fontType.fontSizes.large;
								break;
							case Enums.TextSize.ExtraLarge:
								fontSize = fontType.fontSizes.extraLarge;
								break;
							default:
								fontSize = fontType.fontSizes.default;
								break;
						}
						targetElement.style.fontSize = fontSize + "px";
						var colorDefinition = this.getColorDefinition(this.getEffectiveStyleDefinition().foregroundColors, this.effectiveColor);
						targetElement.style.color = Utils.stringToCssColor(this.isSubtle ? colorDefinition.subtle : colorDefinition.default);
						var fontWeight;
						switch (this.weight) {
							case Enums.TextWeight.Lighter:
								fontWeight = fontType.fontWeights.lighter;
								break;
							case Enums.TextWeight.Bolder:
								fontWeight = fontType.fontWeights.bolder;
								break;
							default:
								fontWeight = fontType.fontWeights.default;
								break;
						}
						targetElement.style.fontWeight = fontWeight.toString();
					};
					BaseTextBlock.prototype.parse = function (json, errors) {
						_super.prototype.parse.call(this, json, errors);
						this.text = Utils.getStringValue(json["text"]);
						var sizeString = Utils.getStringValue(json["size"]);
						if (sizeString && sizeString.toLowerCase() === "normal") {
							this.size = Enums.TextSize.Default;
							raiseParseError({
								error: Enums.ValidationError.Deprecated,
								message: "The TextBlock.size value \"normal\" is deprecated and will be removed. Use \"default\" instead."
							}, errors);
						}
						else {
							this.size = Utils.getEnumValue(Enums.TextSize, sizeString, this.size);
						}
						var weightString = Utils.getStringValue(json["weight"]);
						if (weightString && weightString.toLowerCase() === "normal") {
							this.weight = Enums.TextWeight.Default;
							raiseParseError({
								error: Enums.ValidationError.Deprecated,
								message: "The TextBlock.weight value \"normal\" is deprecated and will be removed. Use \"default\" instead."
							}, errors);
						}
						else {
							this.weight = Utils.getEnumValue(Enums.TextWeight, weightString, this.weight);
						}
						this.color = Utils.getEnumValue(Enums.TextColor, json["color"], this.color);
						this.isSubtle = Utils.getBoolValue(json["isSubtle"], this.isSubtle);
						this.fontType = Utils.getEnumValue(Enums.FontType, json["fontType"], this.fontType);
					};
					Object.defineProperty(BaseTextBlock.prototype, "effectiveColor", {
						get: function () {
							return this.color ? this.color : Enums.TextColor.Default;
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(BaseTextBlock.prototype, "text", {
						get: function () {
							return this._text;
						},
						set: function (value) {
							this.setText(value);
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(BaseTextBlock.prototype, "selectAction", {
						get: function () {
							return this._selectAction;
						},
						set: function (value) {
							this._selectAction = value;
							if (this._selectAction) {
								this._selectAction.setParent(this);
							}
						},
						enumerable: true,
						configurable: true
					});
					return BaseTextBlock;
				}(CardElement));
				exports.BaseTextBlock = BaseTextBlock;
				var TextBlock = /** @class */ (function (_super) {
					__extends(TextBlock, _super);
					function TextBlock() {
						var _this = _super !== null && _super.apply(this, arguments) || this;
						_this._processedText = null;
						_this._treatAsPlainText = true;
						_this.wrap = false;
						_this.useMarkdown = true;
						return _this;
					}
					TextBlock.prototype.restoreOriginalContent = function () {
						var maxHeight = this.maxLines
							? (this._computedLineHeight * this.maxLines) + 'px'
							: null;
						this.renderedElement.style.maxHeight = maxHeight;
						this.renderedElement.innerHTML = this._originalInnerHtml;
					};
					TextBlock.prototype.truncateIfSupported = function (maxHeight) {
						// For now, only truncate TextBlocks that contain just a single
						// paragraph -- since the maxLines calculation doesn't take into
						// account Markdown lists
						var children = this.renderedElement.children;
						var isTextOnly = !children.length;
						var truncationSupported = isTextOnly || children.length == 1
							&& children[0].tagName.toLowerCase() == 'p';
						if (truncationSupported) {
							var element = isTextOnly
								? this.renderedElement
								: children[0];
							Utils.truncate(element, maxHeight, this._computedLineHeight);
							return true;
						}
						return false;
					};
					TextBlock.prototype.setText = function (value) {
						_super.prototype.setText.call(this, value);
						this._processedText = null;
					};
					TextBlock.prototype.getRenderedDomElementType = function () {
						return "div";
					};
					TextBlock.prototype.internalRender = function () {
						var _this = this;
						this._processedText = null;
						if (!Utils.isNullOrEmpty(this.text)) {
							var hostConfig = this.hostConfig;
							var element = document.createElement(this.getRenderedDomElementType());
							element.classList.add(hostConfig.makeCssClassName("ac-textBlock"));
							element.style.overflow = "hidden";
							this.applyStylesTo(element);
							if (this.selectAction) {
								element.onclick = function (e) {
									e.preventDefault();
									e.cancelBubble = true;
									_this.selectAction.execute();
								};
								if (hostConfig.supportsInteractivity) {
									element.tabIndex = 0;
									element.setAttribute("role", "button");
									element.setAttribute("aria-label", this.selectAction.title);
									element.classList.add(hostConfig.makeCssClassName("ac-selectable"));
								}
							}
							if (!this._processedText) {
								this._treatAsPlainText = true;
								var formattedText = TextFormatters.formatText(this.lang, this.text);
								if (this.useMarkdown) {
									if (AdaptiveCard.allowMarkForTextHighlighting) {
										formattedText = formattedText.replace(/<mark>/g, "===").replace(/<\/mark>/g, "/==");
									}
									var markdownProcessingResult = AdaptiveCard.applyMarkdown(formattedText);
									if (markdownProcessingResult.didProcess && markdownProcessingResult.outputHtml) {
										this._processedText = markdownProcessingResult.outputHtml;
										this._treatAsPlainText = false;
										// Only process <mark> tag if markdown processing was applied because
										// markdown processing is also responsible for sanitizing the input string
										if (AdaptiveCard.allowMarkForTextHighlighting) {
											var markStyle = "";
											var effectiveStyle = this.getEffectiveStyleDefinition();
											if (effectiveStyle.highlightBackgroundColor) {
												markStyle += "background-color: " + effectiveStyle.highlightBackgroundColor + ";";
											}
											if (effectiveStyle.highlightForegroundColor) {
												markStyle += "color: " + effectiveStyle.highlightForegroundColor + ";";
											}
											if (!Utils.isNullOrEmpty(markStyle)) {
												markStyle = 'style="' + markStyle + '"';
											}
											this._processedText = this._processedText.replace(/===/g, "<mark " + markStyle + ">").replace(/\/==/g, "</mark>");
										}
									}
									else {
										this._processedText = formattedText;
										this._treatAsPlainText = true;
									}
								}
								else {
									this._processedText = formattedText;
									this._treatAsPlainText = true;
								}
							}
							if (this._treatAsPlainText) {
								element.innerText = this._processedText;
							}
							else {
								element.innerHTML = this._processedText;
							}
							if (element.firstElementChild instanceof HTMLElement) {
								var firstElementChild = element.firstElementChild;
								firstElementChild.style.marginTop = "0px";
								firstElementChild.style.width = "100%";
								if (!this.wrap) {
									firstElementChild.style.overflow = "hidden";
									firstElementChild.style.textOverflow = "ellipsis";
								}
							}
							if (element.lastElementChild instanceof HTMLElement) {
								element.lastElementChild.style.marginBottom = "0px";
							}
							var anchors = element.getElementsByTagName("a");
							for (var i = 0; i < anchors.length; i++) {
								var anchor = anchors[i];
								anchor.classList.add(hostConfig.makeCssClassName("ac-anchor"));
								anchor.target = "_blank";
								anchor.onclick = function (e) {
									if (raiseAnchorClickedEvent(_this, e.target)) {
										e.preventDefault();
										e.cancelBubble = true;
									}
								};
							}
							if (this.wrap) {
								element.style.wordWrap = "break-word";
								if (this.maxLines > 0) {
									element.style.maxHeight = (this._computedLineHeight * this.maxLines) + "px";
									element.style.overflow = "hidden";
								}
							}
							else {
								element.style.whiteSpace = "nowrap";
								element.style.textOverflow = "ellipsis";
							}
							if (AdaptiveCard.useAdvancedTextBlockTruncation || AdaptiveCard.useAdvancedCardBottomTruncation) {
								this._originalInnerHtml = element.innerHTML;
							}
							return element;
						}
						else {
							return null;
						}
					};
					TextBlock.prototype.truncateOverflow = function (maxHeight) {
						if (maxHeight >= this._computedLineHeight) {
							return this.truncateIfSupported(maxHeight);
						}
						return false;
					};
					TextBlock.prototype.undoOverflowTruncation = function () {
						this.restoreOriginalContent();
						if (AdaptiveCard.useAdvancedTextBlockTruncation && this.maxLines) {
							var maxHeight = this._computedLineHeight * this.maxLines;
							this.truncateIfSupported(maxHeight);
						}
					};
					TextBlock.prototype.toJSON = function () {
						var result = _super.prototype.toJSON.call(this);
						Utils.setProperty(result, "wrap", this.wrap, false);
						Utils.setNumberProperty(result, "maxLines", this.maxLines);
						return result;
					};
					TextBlock.prototype.applyStylesTo = function (targetElement) {
						_super.prototype.applyStylesTo.call(this, targetElement);
						var parentContainer = this.getParentContainer();
						var isRtl = parentContainer ? parentContainer.isRtl() : false;
						switch (this.horizontalAlignment) {
							case Enums.HorizontalAlignment.Center:
								targetElement.style.textAlign = "center";
								break;
							case Enums.HorizontalAlignment.Right:
								targetElement.style.textAlign = isRtl ? "left" : "right";
								break;
							default:
								targetElement.style.textAlign = isRtl ? "right" : "left";
								break;
						}
						var lineHeights = this.hostConfig.lineHeights;
						if (lineHeights) {
							switch (this.size) {
								case Enums.TextSize.Small:
									this._computedLineHeight = lineHeights.small;
									break;
								case Enums.TextSize.Medium:
									this._computedLineHeight = lineHeights.medium;
									break;
								case Enums.TextSize.Large:
									this._computedLineHeight = lineHeights.large;
									break;
								case Enums.TextSize.ExtraLarge:
									this._computedLineHeight = lineHeights.extraLarge;
									break;
								default:
									this._computedLineHeight = lineHeights.default;
									break;
							}
						}
						else {
							// Looks like 1.33 is the magic number to compute line-height
							// from font size.
							this._computedLineHeight = this.getFontSize(this.hostConfig.getFontTypeDefinition(this.fontType)) * 1.33;
						}
						targetElement.style.lineHeight = this._computedLineHeight + "px";
					};
					TextBlock.prototype.parse = function (json, errors) {
						_super.prototype.parse.call(this, json, errors);
						this.wrap = Utils.getBoolValue(json["wrap"], this.wrap);
						this.maxLines = Utils.getNumberValue(json["maxLines"]);
					};
					TextBlock.prototype.getJsonTypeName = function () {
						return "TextBlock";
					};
					TextBlock.prototype.updateLayout = function (processChildren) {
						if (processChildren === void 0) { processChildren = false; }
						_super.prototype.updateLayout.call(this, processChildren);
						if (AdaptiveCard.useAdvancedTextBlockTruncation && this.maxLines && this.isRendered()) {
							// Reset the element's innerHTML in case the available room for
							// content has increased
							this.restoreOriginalContent();
							this.truncateIfSupported(this._computedLineHeight * this.maxLines);
						}
					};
					return TextBlock;
				}(BaseTextBlock));
				exports.TextBlock = TextBlock;
				var Label = /** @class */ (function (_super) {
					__extends(Label, _super);
					function Label() {
						return _super !== null && _super.apply(this, arguments) || this;
					}
					Label.prototype.getRenderedDomElementType = function () {
						return "label";
					};
					Label.prototype.internalRender = function () {
						var renderedElement = _super.prototype.internalRender.call(this);
						if (!Utils.isNullOrEmpty(this.forElementId)) {
							renderedElement.htmlFor = this.forElementId;
						}
						return renderedElement;
					};
					return Label;
				}(TextBlock));
				var TextRun = /** @class */ (function (_super) {
					__extends(TextRun, _super);
					function TextRun() {
						var _this = _super !== null && _super.apply(this, arguments) || this;
						_this.italic = false;
						_this.strikethrough = false;
						_this.highlight = false;
						return _this;
					}
					TextRun.prototype.internalRender = function () {
						var _this = this;
						if (!Utils.isNullOrEmpty(this.text)) {
							var hostConfig = this.hostConfig;
							var formattedText = TextFormatters.formatText(this.lang, this.text);
							var element = document.createElement("span");
							element.classList.add(hostConfig.makeCssClassName("ac-textRun"));
							this.applyStylesTo(element);
							if (this.selectAction && hostConfig.supportsInteractivity) {
								var anchor = document.createElement("a");
								anchor.classList.add(hostConfig.makeCssClassName("ac-anchor"));
								anchor.href = this.selectAction.getHref();
								anchor.target = "_blank";
								anchor.onclick = function (e) {
									e.preventDefault();
									e.cancelBubble = true;
									_this.selectAction.execute();
								};
								anchor.innerText = formattedText;
								element.appendChild(anchor);
							}
							else {
								element.innerText = formattedText;
							}
							return element;
						}
						else {
							return null;
						}
					};
					TextRun.prototype.applyStylesTo = function (targetElement) {
						_super.prototype.applyStylesTo.call(this, targetElement);
						if (this.italic) {
							targetElement.style.fontStyle = "italic";
						}
						if (this.strikethrough) {
							targetElement.style.textDecoration = "line-through";
						}
						if (this.highlight) {
							var colorDefinition = this.getColorDefinition(this.getEffectiveStyleDefinition().foregroundColors, this.effectiveColor);
							targetElement.style.backgroundColor = Utils.stringToCssColor(this.isSubtle ? colorDefinition.highlightColors.subtle : colorDefinition.highlightColors.default);
						}
					};
					TextRun.prototype.toJSON = function () {
						var result = _super.prototype.toJSON.call(this);
						Utils.setProperty(result, "italic", this.italic, false);
						Utils.setProperty(result, "strikethrough", this.strikethrough, false);
						Utils.setProperty(result, "highlight", this.highlight, false);
						if (this.selectAction) {
							Utils.setProperty(result, "selectAction", this.selectAction.toJSON());
						}
						return result;
					};
					TextRun.prototype.parse = function (json, errors) {
						_super.prototype.parse.call(this, json, errors);
						this.italic = Utils.getBoolValue(json["italic"], this.italic);
						this.strikethrough = Utils.getBoolValue(json["strikethrough"], this.strikethrough);
						this.highlight = Utils.getBoolValue(json["highlight"], this.highlight);
						this.selectAction = createActionInstance(this, json["selectAction"], [ShowCardAction.JsonTypeName], !this.isDesignMode(), errors);
					};
					TextRun.prototype.getJsonTypeName = function () {
						return "TextRun";
					};
					Object.defineProperty(TextRun.prototype, "isStandalone", {
						get: function () {
							return false;
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(TextRun.prototype, "isInline", {
						get: function () {
							return true;
						},
						enumerable: true,
						configurable: true
					});
					return TextRun;
				}(BaseTextBlock));
				exports.TextRun = TextRun;
				var RichTextBlock = /** @class */ (function (_super) {
					__extends(RichTextBlock, _super);
					function RichTextBlock() {
						var _this = _super !== null && _super.apply(this, arguments) || this;
						_this._inlines = [];
						return _this;
					}
					RichTextBlock.prototype.internalAddInline = function (inline, forceAdd) {
						if (forceAdd === void 0) { forceAdd = false; }
						if (!inline.isInline) {
							throw new Error("RichTextBlock.addInline: the specified card element cannot be used as a RichTextBlock inline.");
						}
						var doAdd = inline.parent == null || forceAdd;
						if (!doAdd && inline.parent != this) {
							throw new Error("RichTextBlock.addInline: the specified inline already belongs to another RichTextBlock.");
						}
						else {
							inline.setParent(this);
							this._inlines.push(inline);
						}
					};
					RichTextBlock.prototype.internalRender = function () {
						if (this._inlines.length > 0) {
							var element = document.createElement("div");
							element.className = this.hostConfig.makeCssClassName("ac-richTextBlock");
							var parentContainer = this.getParentContainer();
							var isRtl = parentContainer ? parentContainer.isRtl() : false;
							switch (this.horizontalAlignment) {
								case Enums.HorizontalAlignment.Center:
									element.style.textAlign = "center";
									break;
								case Enums.HorizontalAlignment.Right:
									element.style.textAlign = isRtl ? "left" : "right";
									break;
								default:
									element.style.textAlign = isRtl ? "right" : "left";
									break;
							}
							for (var _i = 0, _a = this._inlines; _i < _a.length; _i++) {
								var inline = _a[_i];
								element.appendChild(inline.render());
							}
							return element;
						}
						else {
							return null;
						}
					};
					RichTextBlock.prototype.asString = function () {
						var result = "";
						for (var _i = 0, _a = this._inlines; _i < _a.length; _i++) {
							var inline = _a[_i];
							result += inline.asString();
						}
						return result;
					};
					RichTextBlock.prototype.parse = function (json, errors) {
						_super.prototype.parse.call(this, json, errors);
						this._inlines = [];
						if (Array.isArray(json["inlines"])) {
							for (var _i = 0, _a = json["inlines"]; _i < _a.length; _i++) {
								var jsonInline = _a[_i];
								var inline = void 0;
								if (typeof jsonInline === "string") {
									var textRun = new TextRun();
									textRun.text = jsonInline;
									inline = textRun;
								}
								else {
									inline = createElementInstance(this, jsonInline, false, // No fallback for inlines in 1.2
										errors);
								}
								if (inline) {
									this.internalAddInline(inline, true);
								}
							}
						}
					};
					RichTextBlock.prototype.toJSON = function () {
						var result = _super.prototype.toJSON.call(this);
						if (this._inlines.length > 0) {
							var jsonInlines = [];
							for (var _i = 0, _a = this._inlines; _i < _a.length; _i++) {
								var inline = _a[_i];
								jsonInlines.push(inline.toJSON());
							}
							Utils.setProperty(result, "inlines", jsonInlines);
						}
						return result;
					};
					RichTextBlock.prototype.getJsonTypeName = function () {
						return "RichTextBlock";
					};
					RichTextBlock.prototype.getInlineCount = function () {
						return this._inlines.length;
					};
					RichTextBlock.prototype.getInlineAt = function (index) {
						if (index >= 0 && index < this._inlines.length) {
							return this._inlines[index];
						}
						else {
							throw new Error("RichTextBlock.getInlineAt: Index out of range (" + index + ")");
						}
					};
					RichTextBlock.prototype.addInline = function (inline) {
						this.internalAddInline(inline);
					};
					RichTextBlock.prototype.removeInline = function (inline) {
						var index = this._inlines.indexOf(inline);
						if (index >= 0) {
							this._inlines[index].setParent(null);
							this._inlines.splice(index, 1);
							return true;
						}
						return false;
					};
					return RichTextBlock;
				}(CardElement));
				exports.RichTextBlock = RichTextBlock;
				var Fact = /** @class */ (function (_super) {
					__extends(Fact, _super);
					function Fact(name, value) {
						if (name === void 0) { name = undefined; }
						if (value === void 0) { value = undefined; }
						var _this = _super.call(this) || this;
						_this.name = name;
						_this.value = value;
						return _this;
					}
					Fact.prototype.parse = function (json) {
						_super.prototype.parse.call(this, json);
						this.name = Utils.getStringValue(json["title"]);
						this.value = Utils.getStringValue(json["value"]);
					};
					Fact.prototype.toJSON = function () {
						var result = _super.prototype.toJSON.call(this);
						Utils.setProperty(result, "title", this.name);
						Utils.setProperty(result, "value", this.value);
						return result;
					};
					return Fact;
				}(SerializableObject));
				exports.Fact = Fact;
				var FactSet = /** @class */ (function (_super) {
					__extends(FactSet, _super);
					function FactSet() {
						var _this = _super !== null && _super.apply(this, arguments) || this;
						_this.facts = [];
						return _this;
					}
					Object.defineProperty(FactSet.prototype, "useDefaultSizing", {
						get: function () {
							return false;
						},
						enumerable: true,
						configurable: true
					});
					FactSet.prototype.internalRender = function () {
						var element = null;
						var hostConfig = this.hostConfig;
						if (this.facts.length > 0) {
							element = document.createElement("table");
							element.style.borderWidth = "0px";
							element.style.borderSpacing = "0px";
							element.style.borderStyle = "none";
							element.style.borderCollapse = "collapse";
							element.style.display = "block";
							element.style.overflow = "hidden";
							element.classList.add(hostConfig.makeCssClassName("ac-factset"));
							for (var i = 0; i < this.facts.length; i++) {
								var trElement = document.createElement("tr");
								if (i > 0) {
									trElement.style.marginTop = hostConfig.factSet.spacing + "px";
								}
								// Title column
								var tdElement = document.createElement("td");
								tdElement.style.padding = "0";
								tdElement.classList.add(hostConfig.makeCssClassName("ac-fact-title"));
								if (hostConfig.factSet.title.maxWidth) {
									tdElement.style.maxWidth = hostConfig.factSet.title.maxWidth + "px";
								}
								tdElement.style.verticalAlign = "top";
								var textBlock = new TextBlock();
								textBlock.setParent(this);
								textBlock.text = Utils.isNullOrEmpty(this.facts[i].name) ? "Title" : this.facts[i].name;
								textBlock.size = hostConfig.factSet.title.size;
								textBlock.color = hostConfig.factSet.title.color;
								textBlock.isSubtle = hostConfig.factSet.title.isSubtle;
								textBlock.weight = hostConfig.factSet.title.weight;
								textBlock.wrap = hostConfig.factSet.title.wrap;
								textBlock.spacing = Enums.Spacing.None;
								Utils.appendChild(tdElement, textBlock.render());
								Utils.appendChild(trElement, tdElement);
								// Spacer column
								tdElement = document.createElement("td");
								tdElement.style.width = "10px";
								Utils.appendChild(trElement, tdElement);
								// Value column
								tdElement = document.createElement("td");
								tdElement.style.padding = "0";
								tdElement.style.verticalAlign = "top";
								tdElement.classList.add(hostConfig.makeCssClassName("ac-fact-value"));
								textBlock = new TextBlock();
								textBlock.setParent(this);
								textBlock.text = this.facts[i].value;
								textBlock.size = hostConfig.factSet.value.size;
								textBlock.color = hostConfig.factSet.value.color;
								textBlock.isSubtle = hostConfig.factSet.value.isSubtle;
								textBlock.weight = hostConfig.factSet.value.weight;
								textBlock.wrap = hostConfig.factSet.value.wrap;
								textBlock.spacing = Enums.Spacing.None;
								Utils.appendChild(tdElement, textBlock.render());
								Utils.appendChild(trElement, tdElement);
								Utils.appendChild(element, trElement);
							}
						}
						return element;
					};
					FactSet.prototype.getJsonTypeName = function () {
						return "FactSet";
					};
					FactSet.prototype.toJSON = function () {
						var result = _super.prototype.toJSON.call(this);
						Utils.setArrayProperty(result, "facts", this.facts);
						/*
        let facts = [];

        if (this.facts) {
            for (let fact of this.facts) {
                facts.push(fact.toJSON());
            }
        }

        Utils.setProperty(result, "facts", facts);
        */
						return result;
					};
					FactSet.prototype.parse = function (json, errors) {
						_super.prototype.parse.call(this, json, errors);
						this.facts = [];
						var jsonFacts = json["facts"];
						if (Array.isArray(jsonFacts)) {
							for (var _i = 0, jsonFacts_1 = jsonFacts; _i < jsonFacts_1.length; _i++) {
								var jsonFact = jsonFacts_1[_i];
								var fact = new Fact();
								fact.parse(jsonFact);
								this.facts.push(fact);
							}
						}
					};
					return FactSet;
				}(CardElement));
				exports.FactSet = FactSet;
				var Image = /** @class */ (function (_super) {
					__extends(Image, _super);
					function Image() {
						var _this = _super !== null && _super.apply(this, arguments) || this;
						_this.style = Enums.ImageStyle.Default;
						_this.size = Enums.Size.Auto;
						_this.pixelWidth = null;
						_this.pixelHeight = null;
						_this.altText = "";
						return _this;
					}
					Image.prototype.parseDimension = function (name, value, errors) {
						if (value) {
							if (typeof value === "string") {
								try {
									var size = Shared.SizeAndUnit.parse(value);
									if (size.unit == Enums.SizeUnit.Pixel) {
										return size.physicalSize;
									}
								}
								catch (_a) {
									// Ignore error
								}
							}
							raiseParseError({
								error: Enums.ValidationError.InvalidPropertyValue,
								message: "Invalid image " + name + ": " + value
							}, errors);
						}
						return 0;
					};
					Image.prototype.applySize = function (element) {
						if (this.pixelWidth || this.pixelHeight) {
							if (this.pixelWidth) {
								element.style.width = this.pixelWidth + "px";
							}
							if (this.pixelHeight) {
								element.style.height = this.pixelHeight + "px";
							}
						}
						else {
							switch (this.size) {
								case Enums.Size.Stretch:
									element.style.width = "100%";
									break;
								case Enums.Size.Auto:
									element.style.maxWidth = "100%";
									break;
								case Enums.Size.Small:
									element.style.width = this.hostConfig.imageSizes.small + "px";
									break;
								case Enums.Size.Large:
									element.style.width = this.hostConfig.imageSizes.large + "px";
									break;
								case Enums.Size.Medium:
									element.style.width = this.hostConfig.imageSizes.medium + "px";
									break;
							}
						}
					};
					Object.defineProperty(Image.prototype, "useDefaultSizing", {
						get: function () {
							return false;
						},
						enumerable: true,
						configurable: true
					});
					Image.prototype.internalRender = function () {
						var _this = this;
						var element = null;
						if (!Utils.isNullOrEmpty(this.url)) {
							element = document.createElement("div");
							element.style.display = "flex";
							element.style.alignItems = "flex-start";
							element.onkeypress = function (e) {
								if (_this.selectAction && (e.keyCode == 13 || e.keyCode == 32)) { // enter or space pressed
									e.preventDefault();
									e.cancelBubble = true;
									_this.selectAction.execute();
								}
							};
							element.onclick = function (e) {
								if (_this.selectAction) {
									e.preventDefault();
									e.cancelBubble = true;
									_this.selectAction.execute();
								}
							};
							switch (this.horizontalAlignment) {
								case Enums.HorizontalAlignment.Center:
									element.style.justifyContent = "center";
									break;
								case Enums.HorizontalAlignment.Right:
									element.style.justifyContent = "flex-end";
									break;
								default:
									element.style.justifyContent = "flex-start";
									break;
							}
							// Cache hostConfig to avoid walking the parent hierarchy multiple times
							var hostConfig = this.hostConfig;
							var imageElement = document.createElement("img");
							imageElement.onload = function (e) {
								raiseImageLoadedEvent(_this);
							};
							imageElement.onerror = function (e) {
								var card = _this.getRootElement();
								_this.renderedElement.innerHTML = "";
								if (card && card.designMode) {
									var errorElement = document.createElement("div");
									errorElement.style.display = "flex";
									errorElement.style.alignItems = "center";
									errorElement.style.justifyContent = "center";
									errorElement.style.backgroundColor = "#EEEEEE";
									errorElement.style.color = "black";
									errorElement.innerText = ":-(";
									errorElement.style.padding = "10px";
									_this.applySize(errorElement);
									_this.renderedElement.appendChild(errorElement);
								}
								raiseImageLoadedEvent(_this);
							};
							imageElement.style.maxHeight = "100%";
							imageElement.style.minWidth = "0";
							imageElement.classList.add(hostConfig.makeCssClassName("ac-image"));
							if (this.selectAction != null && hostConfig.supportsInteractivity) {
								imageElement.tabIndex = 0;
								imageElement.setAttribute("role", "button");
								imageElement.setAttribute("aria-label", this.selectAction.title);
								imageElement.classList.add(hostConfig.makeCssClassName("ac-selectable"));
							}
							this.applySize(imageElement);
							if (this.style === Enums.ImageStyle.Person) {
								imageElement.style.borderRadius = "50%";
								imageElement.style.backgroundPosition = "50% 50%";
								imageElement.style.backgroundRepeat = "no-repeat";
							}
							if (!Utils.isNullOrEmpty(this.backgroundColor)) {
								imageElement.style.backgroundColor = Utils.stringToCssColor(this.backgroundColor);
							}
							imageElement.src = this.url;
							imageElement.alt = this.altText;
							element.appendChild(imageElement);
						}
						return element;
					};
					Image.prototype.toJSON = function () {
						var result = _super.prototype.toJSON.call(this);
						if (this._selectAction) {
							Utils.setProperty(result, "selectAction", this._selectAction.toJSON());
						}
						Utils.setEnumProperty(Enums.ImageStyle, result, "style", this.style, Enums.ImageStyle.Default);
						Utils.setProperty(result, "backgroundColor", this.backgroundColor);
						Utils.setProperty(result, "url", this.url);
						Utils.setEnumProperty(Enums.Size, result, "size", this.size, Enums.Size.Auto);
						if (this.pixelWidth) {
							Utils.setProperty(result, "width", this.pixelWidth + "px");
						}
						if (this.pixelHeight) {
							Utils.setProperty(result, "height", this.pixelHeight + "px");
						}
						Utils.setProperty(result, "altText", this.altText);
						return result;
					};
					Image.prototype.getJsonTypeName = function () {
						return "Image";
					};
					Image.prototype.getActionById = function (id) {
						var result = _super.prototype.getActionById.call(this, id);
						if (!result && this.selectAction) {
							result = this.selectAction.getActionById(id);
						}
						return result;
					};
					Image.prototype.parse = function (json, errors) {
						_super.prototype.parse.call(this, json, errors);
						this.url = Utils.getStringValue(json["url"]);
						this.backgroundColor = Utils.getStringValue(json["backgroundColor"]);
						var styleString = Utils.getStringValue(json["style"]);
						if (styleString && styleString.toLowerCase() === "normal") {
							this.style = Enums.ImageStyle.Default;
							raiseParseError({
								error: Enums.ValidationError.Deprecated,
								message: "The Image.style value \"normal\" is deprecated and will be removed. Use \"default\" instead."
							}, errors);
						}
						else {
							this.style = Utils.getEnumValue(Enums.ImageStyle, styleString, this.style);
						}
						this.size = Utils.getEnumValue(Enums.Size, json["size"], this.size);
						this.altText = Utils.getStringValue(json["altText"]);
						// pixelWidth and pixelHeight are only parsed for backwards compatibility.
						// Payloads should use the width and height proerties instead.
						if (json["pixelWidth"] && typeof json["pixelWidth"] === "number") {
							this.pixelWidth = json["pixelWidth"];
							raiseParseError({
								error: Enums.ValidationError.Deprecated,
								message: "The pixelWidth property is deprecated and will be removed. Use the width property instead."
							}, errors);
						}
						if (json["pixelHeight"] && typeof json["pixelHeight"] === "number") {
							this.pixelHeight = json["pixelHeight"];
							raiseParseError({
								error: Enums.ValidationError.Deprecated,
								message: "The pixelHeight property is deprecated and will be removed. Use the height property instead."
							}, errors);
						}
						var size = this.parseDimension("width", json["width"], errors);
						if (size > 0) {
							this.pixelWidth = size;
						}
						size = this.parseDimension("height", json["height"], errors);
						if (size > 0) {
							this.pixelHeight = size;
						}
						this.selectAction = createActionInstance(this, json["selectAction"], [ShowCardAction.JsonTypeName], !this.isDesignMode(), errors);
					};
					Image.prototype.getResourceInformation = function () {
						if (!Utils.isNullOrEmpty(this.url)) {
							return [{ url: this.url, mimeType: "image" }];
						}
						else {
							return [];
						}
					};
					Object.defineProperty(Image.prototype, "selectAction", {
						get: function () {
							return this._selectAction;
						},
						set: function (value) {
							this._selectAction = value;
							if (this._selectAction) {
								this._selectAction.setParent(this);
							}
						},
						enumerable: true,
						configurable: true
					});
					return Image;
				}(CardElement));
				exports.Image = Image;
				var CardElementContainer = /** @class */ (function (_super) {
					__extends(CardElementContainer, _super);
					function CardElementContainer() {
						var _this = _super !== null && _super.apply(this, arguments) || this;
						_this._selectAction = null;
						_this.allowVerticalOverflow = false;
						return _this;
					}
					CardElementContainer.prototype.isElementAllowed = function (element, forbiddenElementTypes) {
						if (!this.hostConfig.supportsInteractivity && element.isInteractive) {
							return false;
						}
						if (forbiddenElementTypes) {
							for (var _i = 0, forbiddenElementTypes_1 = forbiddenElementTypes; _i < forbiddenElementTypes_1.length; _i++) {
								var forbiddenElementType = forbiddenElementTypes_1[_i];
								if (element.getJsonTypeName() === forbiddenElementType) {
									return false;
								}
							}
						}
						return true;
					};
					CardElementContainer.prototype.applyPadding = function () {
						_super.prototype.applyPadding.call(this);
						if (!this.renderedElement) {
							return;
						}
						var physicalPadding = new Shared.SpacingDefinition();
						if (this.getEffectivePadding()) {
							physicalPadding = this.hostConfig.paddingDefinitionToSpacingDefinition(this.getEffectivePadding());
						}
						this.renderedElement.style.paddingTop = physicalPadding.top + "px";
						this.renderedElement.style.paddingRight = physicalPadding.right + "px";
						this.renderedElement.style.paddingBottom = physicalPadding.bottom + "px";
						this.renderedElement.style.paddingLeft = physicalPadding.left + "px";
						this.renderedElement.style.marginRight = "0";
						this.renderedElement.style.marginLeft = "0";
					};
					CardElementContainer.prototype.getSelectAction = function () {
						return this._selectAction;
					};
					CardElementContainer.prototype.setSelectAction = function (value) {
						this._selectAction = value;
						if (this._selectAction) {
							this._selectAction.setParent(this);
						}
					};
					Object.defineProperty(CardElementContainer.prototype, "isSelectable", {
						get: function () {
							return false;
						},
						enumerable: true,
						configurable: true
					});
					CardElementContainer.prototype.parse = function (json, errors) {
						_super.prototype.parse.call(this, json, errors);
						if (this.isSelectable) {
							this._selectAction = createActionInstance(this, json["selectAction"], [ShowCardAction.JsonTypeName], !this.isDesignMode(), errors);
						}
					};
					CardElementContainer.prototype.toJSON = function () {
						var result = _super.prototype.toJSON.call(this);
						if (this._selectAction && this.isSelectable) {
							Utils.setProperty(result, "selectAction", this._selectAction.toJSON());
						}
						return result;
					};
					CardElementContainer.prototype.internalValidateProperties = function (context) {
						_super.prototype.internalValidateProperties.call(this, context);
						for (var i = 0; i < this.getItemCount(); i++) {
							var item = this.getItemAt(i);
							if (!this.hostConfig.supportsInteractivity && item.isInteractive) {
								context.addFailure(this, {
									error: Enums.ValidationError.InteractivityNotAllowed,
									message: "Interactivity is not allowed."
								});
							}
							if (!this.isElementAllowed(item, this.getForbiddenElementTypes())) {
								context.addFailure(this, {
									error: Enums.ValidationError.InteractivityNotAllowed,
									message: "Elements of type " + item.getJsonTypeName() + " are not allowed in this container."
								});
							}
							item.internalValidateProperties(context);
						}
						if (this._selectAction) {
							this._selectAction.internalValidateProperties(context);
						}
					};
					CardElementContainer.prototype.render = function () {
						var _this = this;
						var element = _super.prototype.render.call(this);
						var hostConfig = this.hostConfig;
						if (this.allowVerticalOverflow) {
							element.style.overflowX = "hidden";
							element.style.overflowY = "auto";
						}
						if (element && this.isSelectable && this._selectAction && hostConfig.supportsInteractivity) {
							element.classList.add(hostConfig.makeCssClassName("ac-selectable"));
							element.tabIndex = 0;
							element.setAttribute("role", "button");
							element.setAttribute("aria-label", this._selectAction.title);
							element.onclick = function (e) {
								if (_this._selectAction != null) {
									e.preventDefault();
									e.cancelBubble = true;
									_this._selectAction.execute();
								}
							};
							element.onkeypress = function (e) {
								if (_this._selectAction != null && (e.keyCode == 13 || e.keyCode == 32)) {
									// Enter or space pressed
									e.preventDefault();
									e.cancelBubble = true;
									_this._selectAction.execute();
								}
							};
						}
						return element;
					};
					CardElementContainer.prototype.updateLayout = function (processChildren) {
						if (processChildren === void 0) { processChildren = true; }
						_super.prototype.updateLayout.call(this, processChildren);
						if (processChildren) {
							for (var i = 0; i < this.getItemCount(); i++) {
								this.getItemAt(i).updateLayout();
							}
						}
					};
					CardElementContainer.prototype.getAllInputs = function () {
						var result = [];
						for (var i = 0; i < this.getItemCount(); i++) {
							result = result.concat(this.getItemAt(i).getAllInputs());
						}
						return result;
					};
					CardElementContainer.prototype.getResourceInformation = function () {
						var result = [];
						for (var i = 0; i < this.getItemCount(); i++) {
							result = result.concat(this.getItemAt(i).getResourceInformation());
						}
						return result;
					};
					CardElementContainer.prototype.getElementById = function (id) {
						var result = _super.prototype.getElementById.call(this, id);
						if (!result) {
							for (var i = 0; i < this.getItemCount(); i++) {
								result = this.getItemAt(i).getElementById(id);
								if (result) {
									break;
								}
							}
						}
						return result;
					};
					return CardElementContainer;
				}(CardElement));
				exports.CardElementContainer = CardElementContainer;
				var ImageSet = /** @class */ (function (_super) {
					__extends(ImageSet, _super);
					function ImageSet() {
						var _this = _super !== null && _super.apply(this, arguments) || this;
						_this._images = [];
						_this.imageSize = Enums.Size.Medium;
						return _this;
					}
					ImageSet.prototype.internalRender = function () {
						var element = null;
						if (this._images.length > 0) {
							element = document.createElement("div");
							element.style.display = "flex";
							element.style.flexWrap = "wrap";
							for (var i = 0; i < this._images.length; i++) {
								this._images[i].size = this.imageSize;
								var renderedImage = this._images[i].render();
								renderedImage.style.display = "inline-flex";
								renderedImage.style.margin = "0px";
								renderedImage.style.marginRight = "10px";
								renderedImage.style.maxHeight = this.hostConfig.imageSet.maxImageHeight + "px";
								Utils.appendChild(element, renderedImage);
							}
						}
						return element;
					};
					ImageSet.prototype.getItemCount = function () {
						return this._images.length;
					};
					ImageSet.prototype.getItemAt = function (index) {
						return this._images[index];
					};
					ImageSet.prototype.getFirstVisibleRenderedItem = function () {
						return this._images && this._images.length > 0 ? this._images[0] : null;
					};
					ImageSet.prototype.getLastVisibleRenderedItem = function () {
						return this._images && this._images.length > 0 ? this._images[this._images.length - 1] : null;
					};
					ImageSet.prototype.removeItem = function (item) {
						if (item instanceof Image) {
							var itemIndex = this._images.indexOf(item);
							if (itemIndex >= 0) {
								this._images.splice(itemIndex, 1);
								item.setParent(null);
								this.updateLayout();
								return true;
							}
						}
						return false;
					};
					ImageSet.prototype.getJsonTypeName = function () {
						return "ImageSet";
					};
					ImageSet.prototype.toJSON = function () {
						var result = _super.prototype.toJSON.call(this);
						Utils.setEnumProperty(Enums.Size, result, "imageSize", this.imageSize, Enums.Size.Medium);
						if (this._images.length > 0) {
							var images = [];
							for (var _i = 0, _a = this._images; _i < _a.length; _i++) {
								var image = _a[_i];
								images.push(image.toJSON());
							}
							Utils.setProperty(result, "images", images);
						}
						return result;
					};
					ImageSet.prototype.parse = function (json, errors) {
						_super.prototype.parse.call(this, json, errors);
						this.imageSize = Utils.getEnumValue(Enums.Size, json["imageSize"], Enums.Size.Medium);
						if (json["images"] != null) {
							var jsonImages = json["images"];
							this._images = [];
							for (var i = 0; i < jsonImages.length; i++) {
								var image = new Image();
								image.parse(jsonImages[i], errors);
								this.addImage(image);
							}
						}
					};
					ImageSet.prototype.addImage = function (image) {
						if (!image.parent) {
							this._images.push(image);
							image.setParent(this);
						}
						else {
							throw new Error("This image already belongs to another ImageSet");
						}
					};
					ImageSet.prototype.indexOf = function (cardElement) {
						return cardElement instanceof Image ? this._images.indexOf(cardElement) : -1;
					};
					return ImageSet;
				}(CardElementContainer));
				exports.ImageSet = ImageSet;
				var MediaSource = /** @class */ (function (_super) {
					__extends(MediaSource, _super);
					function MediaSource(url, mimeType) {
						if (url === void 0) { url = undefined; }
						if (mimeType === void 0) { mimeType = undefined; }
						var _this = _super.call(this) || this;
						_this.url = url;
						_this.mimeType = mimeType;
						return _this;
					}
					MediaSource.prototype.parse = function (json, errors) {
						_super.prototype.parse.call(this, json, errors);
						this.mimeType = Utils.getStringValue(json["mimeType"]);
						this.url = Utils.getStringValue(json["url"]);
					};
					MediaSource.prototype.toJSON = function () {
						var result = _super.prototype.toJSON.call(this);
						Utils.setProperty(result, "mimeType", this.mimeType);
						Utils.setProperty(result, "url", this.url);
						return result;
					};
					return MediaSource;
				}(SerializableObject));
				exports.MediaSource = MediaSource;
				var Media = /** @class */ (function (_super) {
					__extends(Media, _super);
					function Media() {
						var _this = _super !== null && _super.apply(this, arguments) || this;
						_this.sources = [];
						return _this;
					}
					Media.prototype.getPosterUrl = function () {
						return this.poster ? this.poster : this.hostConfig.media.defaultPoster;
					};
					Media.prototype.processSources = function () {
						this._selectedSources = [];
						this._selectedMediaType = undefined;
						for (var _i = 0, _a = this.sources; _i < _a.length; _i++) {
							var source = _a[_i];
							var mimeComponents = source.mimeType ? source.mimeType.split('/') : [];
							if (mimeComponents.length == 2) {
								if (!this._selectedMediaType) {
									var index = Media.supportedMediaTypes.indexOf(mimeComponents[0]);
									if (index >= 0) {
										this._selectedMediaType = Media.supportedMediaTypes[index];
									}
								}
								if (mimeComponents[0] == this._selectedMediaType) {
									this._selectedSources.push(source);
								}
							}
						}
					};
					Media.prototype.renderPoster = function () {
						var _this = this;
						var playButtonArrowWidth = 12;
						var playButtonArrowHeight = 15;
						var posterRootElement = document.createElement("div");
						posterRootElement.className = this.hostConfig.makeCssClassName("ac-media-poster");
						posterRootElement.setAttribute("role", "contentinfo");
						posterRootElement.setAttribute("aria-label", this.altText ? this.altText : "Media content");
						posterRootElement.style.position = "relative";
						posterRootElement.style.display = "flex";
						var posterUrl = this.getPosterUrl();
						if (posterUrl) {
							var posterImageElement_1 = document.createElement("img");
							posterImageElement_1.style.width = "100%";
							posterImageElement_1.style.height = "100%";
							posterImageElement_1.onerror = function (e) {
								posterImageElement_1.parentNode.removeChild(posterImageElement_1);
								posterRootElement.classList.add("empty");
								posterRootElement.style.minHeight = "150px";
							};
							posterImageElement_1.src = posterUrl;
							posterRootElement.appendChild(posterImageElement_1);
						}
						else {
							posterRootElement.classList.add("empty");
							posterRootElement.style.minHeight = "150px";
						}
						if (this.hostConfig.supportsInteractivity && this._selectedSources.length > 0) {
							var playButtonOuterElement = document.createElement("div");
							playButtonOuterElement.setAttribute("role", "button");
							playButtonOuterElement.setAttribute("aria-label", "Play media");
							playButtonOuterElement.className = this.hostConfig.makeCssClassName("ac-media-playButton");
							playButtonOuterElement.style.display = "flex";
							playButtonOuterElement.style.alignItems = "center";
							playButtonOuterElement.style.justifyContent = "center";
							playButtonOuterElement.onclick = function (e) {
								if (_this.hostConfig.media.allowInlinePlayback) {
									e.preventDefault();
									e.cancelBubble = true;
									var mediaPlayerElement = _this.renderMediaPlayer();
									_this.renderedElement.innerHTML = "";
									_this.renderedElement.appendChild(mediaPlayerElement);
									mediaPlayerElement.play();
								}
								else {
									if (Media.onPlay) {
										e.preventDefault();
										e.cancelBubble = true;
										Media.onPlay(_this);
									}
								}
							};
							var playButtonInnerElement = document.createElement("div");
							playButtonInnerElement.className = this.hostConfig.makeCssClassName("ac-media-playButton-arrow");
							playButtonInnerElement.style.width = playButtonArrowWidth + "px";
							playButtonInnerElement.style.height = playButtonArrowHeight + "px";
							playButtonInnerElement.style.borderTopWidth = (playButtonArrowHeight / 2) + "px";
							playButtonInnerElement.style.borderBottomWidth = (playButtonArrowHeight / 2) + "px";
							playButtonInnerElement.style.borderLeftWidth = playButtonArrowWidth + "px";
							playButtonInnerElement.style.borderRightWidth = "0";
							playButtonInnerElement.style.borderStyle = "solid";
							playButtonInnerElement.style.borderTopColor = "transparent";
							playButtonInnerElement.style.borderRightColor = "transparent";
							playButtonInnerElement.style.borderBottomColor = "transparent";
							playButtonInnerElement.style.transform = "translate(" + (playButtonArrowWidth / 10) + "px,0px)";
							playButtonOuterElement.appendChild(playButtonInnerElement);
							var playButtonContainer = document.createElement("div");
							playButtonContainer.style.position = "absolute";
							playButtonContainer.style.left = "0";
							playButtonContainer.style.top = "0";
							playButtonContainer.style.width = "100%";
							playButtonContainer.style.height = "100%";
							playButtonContainer.style.display = "flex";
							playButtonContainer.style.justifyContent = "center";
							playButtonContainer.style.alignItems = "center";
							playButtonContainer.appendChild(playButtonOuterElement);
							posterRootElement.appendChild(playButtonContainer);
						}
						return posterRootElement;
					};
					Media.prototype.renderMediaPlayer = function () {
						var mediaElement;
						if (this._selectedMediaType == "video") {
							var videoPlayer = document.createElement("video");
							var posterUrl = this.getPosterUrl();
							if (posterUrl) {
								videoPlayer.poster = posterUrl;
							}
							mediaElement = videoPlayer;
						}
						else {
							mediaElement = document.createElement("audio");
						}
						mediaElement.controls = true;
						mediaElement.preload = "none";
						mediaElement.style.width = "100%";
						for (var _i = 0, _a = this.sources; _i < _a.length; _i++) {
							var source = _a[_i];
							var src = document.createElement("source");
							src.src = source.url;
							src.type = source.mimeType;
							mediaElement.appendChild(src);
						}
						return mediaElement;
					};
					Media.prototype.internalRender = function () {
						var element = document.createElement("div");
						element.className = this.hostConfig.makeCssClassName("ac-media");
						this.processSources();
						element.appendChild(this.renderPoster());
						return element;
					};
					Media.prototype.parse = function (json, errors) {
						_super.prototype.parse.call(this, json, errors);
						this.poster = Utils.getStringValue(json["poster"]);
						this.altText = Utils.getStringValue(json["altText"]);
						this.sources = [];
						if (Array.isArray(json["sources"])) {
							for (var _i = 0, _a = json["sources"]; _i < _a.length; _i++) {
								var jsonSource = _a[_i];
								var source = new MediaSource();
								source.parse(jsonSource, errors);
								this.sources.push(source);
							}
						}
					};
					Media.prototype.toJSON = function () {
						var result = _super.prototype.toJSON.call(this);
						Utils.setProperty(result, "poster", this.poster);
						Utils.setProperty(result, "altText", this.altText);
						/*
        if (this.sources.length > 0) {
            let serializedSources = [];

            for (let source of this.sources) {
                serializedSources.push(source.toJSON());
            }

            Utils.setProperty(result, "sources", serializedSources);
        }
        */
						Utils.setArrayProperty(result, "sources", this.sources);
						return result;
					};
					Media.prototype.getJsonTypeName = function () {
						return "Media";
					};
					Media.prototype.getResourceInformation = function () {
						var result = [];
						var posterUrl = this.getPosterUrl();
						if (!Utils.isNullOrEmpty(posterUrl)) {
							result.push({ url: posterUrl, mimeType: "image" });
						}
						for (var _i = 0, _a = this.sources; _i < _a.length; _i++) {
							var mediaSource = _a[_i];
							if (!Utils.isNullOrEmpty(mediaSource.url)) {
								result.push({ url: mediaSource.url, mimeType: mediaSource.mimeType });
							}
						}
						return result;
					};
					Object.defineProperty(Media.prototype, "selectedMediaType", {
						get: function () {
							return this._selectedMediaType;
						},
						enumerable: true,
						configurable: true
					});
					Media.supportedMediaTypes = ["audio", "video"];
					return Media;
				}(CardElement));
				exports.Media = Media;
				var InputValidationOptions = /** @class */ (function (_super) {
					__extends(InputValidationOptions, _super);
					function InputValidationOptions() {
						var _this = _super !== null && _super.apply(this, arguments) || this;
						_this.necessity = Enums.InputValidationNecessity.Optional;
						_this.errorMessage = undefined;
						return _this;
					}
					InputValidationOptions.prototype.parse = function (json) {
						_super.prototype.parse.call(this, json);
						this.necessity = Utils.getEnumValue(Enums.InputValidationNecessity, json["necessity"], this.necessity);
						this.errorMessage = Utils.getStringValue(json["errorMessage"]);
					};
					InputValidationOptions.prototype.toJSON = function () {
						if (this.necessity != Enums.InputValidationNecessity.Optional || !Utils.isNullOrEmpty(this.errorMessage)) {
							var result = _super.prototype.toJSON.call(this);
							Utils.setEnumProperty(Enums.InputValidationNecessity, result, "necessity", this.necessity, Enums.InputValidationNecessity.Optional);
							Utils.setProperty(result, "errorMessage", this.errorMessage);
							return result;
						}
						else {
							return null;
						}
					};
					return InputValidationOptions;
				}(SerializableObject));
				exports.InputValidationOptions = InputValidationOptions;
				var Input = /** @class */ (function (_super) {
					__extends(Input, _super);
					function Input() {
						var _this = _super !== null && _super.apply(this, arguments) || this;
						_this.validation = new InputValidationOptions();
						return _this;
					}
					Object.defineProperty(Input.prototype, "isNullable", {
						get: function () {
							return true;
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(Input.prototype, "renderedInputControlElement", {
						get: function () {
							return this._renderedInputControlElement;
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(Input.prototype, "inputControlContainerElement", {
						get: function () {
							return this._inputControlContainerElement;
						},
						enumerable: true,
						configurable: true
					});
					Input.prototype.overrideInternalRender = function () {
						var hostConfig = this.hostConfig;
						this._outerContainerElement = document.createElement("div");
						this._outerContainerElement.style.display = "flex";
						this._outerContainerElement.style.flexDirection = "column";
						this._inputControlContainerElement = document.createElement("div");
						this._inputControlContainerElement.className = hostConfig.makeCssClassName("ac-input-container");
						this._inputControlContainerElement.style.display = "flex";
						this._renderedInputControlElement = this.internalRender();
						this._renderedInputControlElement.style.minWidth = "0px";
						if (AdaptiveCard.useBuiltInInputValidation && this.isNullable && this.validation.necessity == Enums.InputValidationNecessity.RequiredWithVisualCue) {
							this._renderedInputControlElement.classList.add(hostConfig.makeCssClassName("ac-input-required"));
						}
						this._inputControlContainerElement.appendChild(this._renderedInputControlElement);
						this._outerContainerElement.appendChild(this._inputControlContainerElement);
						return this._outerContainerElement;
					};
					Input.prototype.valueChanged = function () {
						this.resetValidationFailureCue();
						if (this.onValueChanged) {
							this.onValueChanged(this);
						}
						raiseInputValueChangedEvent(this);
					};
					Input.prototype.resetValidationFailureCue = function () {
						if (AdaptiveCard.useBuiltInInputValidation && this.renderedElement) {
							this._renderedInputControlElement.classList.remove(this.hostConfig.makeCssClassName("ac-input-validation-failed"));
							if (this._errorMessageElement) {
								this._outerContainerElement.removeChild(this._errorMessageElement);
								this._errorMessageElement = null;
							}
						}
					};
					Input.prototype.showValidationErrorMessage = function () {
						if (this.renderedElement && AdaptiveCard.useBuiltInInputValidation && AdaptiveCard.displayInputValidationErrors && !Utils.isNullOrEmpty(this.validation.errorMessage)) {
							this._errorMessageElement = document.createElement("span");
							this._errorMessageElement.className = this.hostConfig.makeCssClassName("ac-input-validation-error-message");
							this._errorMessageElement.textContent = this.validation.errorMessage;
							this._outerContainerElement.appendChild(this._errorMessageElement);
						}
					};
					Input.prototype.parseInputValue = function (value) {
						return value;
					};
					Input.prototype.toJSON = function () {
						var result = _super.prototype.toJSON.call(this);
						Utils.setProperty(result, "title", this.title);
						Utils.setProperty(result, "value", this.renderedElement && !Utils.isNullOrEmpty(this.value) ? this.value : this.defaultValue);
						if (AdaptiveCard.useBuiltInInputValidation) {
							Utils.setProperty(result, "validation", this.validation.toJSON());
						}
						return result;
					};
					Input.prototype.internalValidateProperties = function (context) {
						_super.prototype.internalValidateProperties.call(this, context);
						if (Utils.isNullOrEmpty(this.id)) {
							context.addFailure(this, {
								error: Enums.ValidationError.PropertyCantBeNull,
								message: "All inputs must have a unique Id"
							});
						}
					};
					Input.prototype.validateValue = function () {
						if (AdaptiveCard.useBuiltInInputValidation) {
							this.resetValidationFailureCue();
							var result = this.validation.necessity != Enums.InputValidationNecessity.Optional ? !Utils.isNullOrEmpty(this.value) : true;
							if (!result && this.renderedElement) {
								this._renderedInputControlElement.classList.add(this.hostConfig.makeCssClassName("ac-input-validation-failed"));
								this.showValidationErrorMessage();
							}
							return result;
						}
						else {
							return true;
						}
					};
					Input.prototype.parse = function (json, errors) {
						_super.prototype.parse.call(this, json, errors);
						this.id = Utils.getStringValue(json["id"]);
						this.defaultValue = Utils.getStringValue(json["value"]);
						if (AdaptiveCard.useBuiltInInputValidation) {
							var jsonValidation = json["validation"];
							if (jsonValidation) {
								this.validation.parse(jsonValidation);
							}
						}
					};
					Input.prototype.getAllInputs = function () {
						return [this];
					};
					Object.defineProperty(Input.prototype, "defaultValue", {
						get: function () {
							return this._defaultValue;
						},
						set: function (value) {
							this._defaultValue = this.parseInputValue(value);
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(Input.prototype, "isInteractive", {
						get: function () {
							return true;
						},
						enumerable: true,
						configurable: true
					});
					return Input;
				}(CardElement));
				exports.Input = Input;
				var TextInput = /** @class */ (function (_super) {
					__extends(TextInput, _super);
					function TextInput() {
						var _this = _super !== null && _super.apply(this, arguments) || this;
						_this.isMultiline = false;
						_this.style = Enums.InputTextStyle.Text;
						return _this;
					}
					TextInput.prototype.internalRender = function () {
						var _this = this;
						if (this.isMultiline) {
							var textareaElement = document.createElement("textarea");
							textareaElement.className = this.hostConfig.makeCssClassName("ac-input", "ac-textInput", "ac-multiline");
							textareaElement.style.flex = "1 1 auto";
							textareaElement.tabIndex = 0;
							if (!Utils.isNullOrEmpty(this.placeholder)) {
								textareaElement.placeholder = this.placeholder;
								textareaElement.setAttribute("aria-label", this.placeholder);
							}
							if (!Utils.isNullOrEmpty(this.defaultValue)) {
								textareaElement.value = this.defaultValue;
							}
							if (this.maxLength && this.maxLength > 0) {
								textareaElement.maxLength = this.maxLength;
							}
							textareaElement.oninput = function () { _this.valueChanged(); };
							textareaElement.onkeypress = function (e) {
								// Ctrl+Enter pressed
								if (e.keyCode == 10 && _this.inlineAction) {
									_this.inlineAction.execute();
								}
							};
							return textareaElement;
						}
						else {
							var inputElement = document.createElement("input");
							inputElement.type = Enums.InputTextStyle[this.style].toLowerCase();
							inputElement.className = this.hostConfig.makeCssClassName("ac-input", "ac-textInput");
							inputElement.style.flex = "1 1 auto";
							inputElement.tabIndex = 0;
							if (!Utils.isNullOrEmpty(this.placeholder)) {
								inputElement.placeholder = this.placeholder;
								inputElement.setAttribute("aria-label", this.placeholder);
							}
							if (!Utils.isNullOrEmpty(this.defaultValue)) {
								inputElement.value = this.defaultValue;
							}
							if (this.maxLength && this.maxLength > 0) {
								inputElement.maxLength = this.maxLength;
							}
							inputElement.oninput = function () { _this.valueChanged(); };
							inputElement.onkeypress = function (e) {
								// Enter pressed
								if (e.keyCode == 13 && _this.inlineAction) {
									_this.inlineAction.execute();
								}
							};
							return inputElement;
						}
					};
					TextInput.prototype.overrideInternalRender = function () {
						var _this = this;
						var renderedInputControl = _super.prototype.overrideInternalRender.call(this);
						if (this.inlineAction) {
							var button_1 = document.createElement("button");
							button_1.className = this.hostConfig.makeCssClassName("ac-inlineActionButton");
							button_1.onclick = function (e) {
								e.preventDefault();
								e.cancelBubble = true;
								_this.inlineAction.execute();
							};
							if (!Utils.isNullOrEmpty(this.inlineAction.iconUrl)) {
								button_1.classList.add("iconOnly");
								var icon_1 = document.createElement("img");
								icon_1.style.height = "100%";
								// The below trick is necessary as a workaround in Chrome where the icon is initially displayed
								// at its native size then resized to 100% of the button's height. This cfreates an unpleasant
								// flicker. On top of that, Chrome's flex implementation fails to prperly re-layout the button
								// after the image has loaded and been gicven its final size. The below trick also fixes that.
								icon_1.style.display = "none";
								icon_1.onload = function () {
									icon_1.style.removeProperty("display");
								};
								icon_1.onerror = function () {
									button_1.removeChild(icon_1);
									button_1.classList.remove("iconOnly");
									button_1.classList.add("textOnly");
									button_1.textContent = !Utils.isNullOrEmpty(_this.inlineAction.title) ? _this.inlineAction.title : "Title";
								};
								icon_1.src = this.inlineAction.iconUrl;
								button_1.appendChild(icon_1);
								if (!Utils.isNullOrEmpty(this.inlineAction.title)) {
									button_1.title = this.inlineAction.title;
								}
							}
							else {
								button_1.classList.add("textOnly");
								button_1.textContent = !Utils.isNullOrEmpty(this.inlineAction.title) ? this.inlineAction.title : "Title";
							}
							button_1.style.marginLeft = "8px";
							this.inputControlContainerElement.appendChild(button_1);
						}
						return renderedInputControl;
					};
					TextInput.prototype.getJsonTypeName = function () {
						return "Input.Text";
					};
					TextInput.prototype.getActionById = function (id) {
						var result = _super.prototype.getActionById.call(this, id);
						if (!result && this.inlineAction) {
							result = this.inlineAction.getActionById(id);
						}
						return result;
					};
					TextInput.prototype.toJSON = function () {
						var result = _super.prototype.toJSON.call(this);
						Utils.setProperty(result, "placeholder", this.placeholder);
						Utils.setNumberProperty(result, "maxLength", this.maxLength);
						Utils.setProperty(result, "isMultiline", this.isMultiline, false);
						Utils.setEnumProperty(Enums.InputTextStyle, result, "style", this.style, Enums.InputTextStyle.Text);
						if (this._inlineAction) {
							Utils.setProperty(result, "inlineAction", this._inlineAction.toJSON());
						}
						return result;
					};
					TextInput.prototype.parse = function (json, errors) {
						_super.prototype.parse.call(this, json, errors);
						this.maxLength = Utils.getNumberValue(json["maxLength"]);
						this.isMultiline = Utils.getBoolValue(json["isMultiline"], this.isMultiline);
						this.placeholder = Utils.getStringValue(json["placeholder"]);
						this.style = Utils.getEnumValue(Enums.InputTextStyle, json["style"], this.style);
						this.inlineAction = createActionInstance(this, json["inlineAction"], [ShowCardAction.JsonTypeName], !this.isDesignMode(), errors);
					};
					Object.defineProperty(TextInput.prototype, "inlineAction", {
						get: function () {
							return this._inlineAction;
						},
						set: function (value) {
							this._inlineAction = value;
							if (this._inlineAction) {
								this._inlineAction.setParent(this);
							}
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(TextInput.prototype, "value", {
						get: function () {
							if (this.renderedInputControlElement) {
								if (this.isMultiline) {
									return this.renderedInputControlElement.value;
								}
								else {
									return this.renderedInputControlElement.value;
								}
							}
							else {
								return null;
							}
						},
						enumerable: true,
						configurable: true
					});
					return TextInput;
				}(Input));
				exports.TextInput = TextInput;
				var ToggleInput = /** @class */ (function (_super) {
					__extends(ToggleInput, _super);
					function ToggleInput() {
						var _this = _super !== null && _super.apply(this, arguments) || this;
						_this.valueOn = "true";
						_this.valueOff = "false";
						_this.wrap = false;
						return _this;
					}
					ToggleInput.prototype.internalRender = function () {
						var _this = this;
						var element = document.createElement("div");
						element.className = this.hostConfig.makeCssClassName("ac-input", "ac-toggleInput");
						element.style.width = "100%";
						element.style.display = "flex";
						element.style.alignItems = "center";
						this._checkboxInputElement = document.createElement("input");
						this._checkboxInputElement.id = Utils.generateUniqueId();
						this._checkboxInputElement.type = "checkbox";
						this._checkboxInputElement.style.display = "inline-block";
						this._checkboxInputElement.style.verticalAlign = "middle";
						this._checkboxInputElement.style.margin = "0";
						this._checkboxInputElement.style.flex = "0 0 auto";
						this._checkboxInputElement.setAttribute("aria-label", this.title);
						this._checkboxInputElement.tabIndex = 0;
						if (this.defaultValue == this.valueOn) {
							this._checkboxInputElement.checked = true;
						}
						this._checkboxInputElement.onchange = function () { _this.valueChanged(); };
						Utils.appendChild(element, this._checkboxInputElement);
						if (!Utils.isNullOrEmpty(this.title) || this.isDesignMode()) {
							var label = new Label();
							label.setParent(this);
							label.forElementId = this._checkboxInputElement.id;
							label.hostConfig = this.hostConfig;
							label.text = Utils.isNullOrEmpty(this.title) ? this.getJsonTypeName() : this.title;
							label.useMarkdown = AdaptiveCard.useMarkdownInRadioButtonAndCheckbox;
							label.wrap = this.wrap;
							var labelElement = label.render();
							labelElement.style.display = "inline-block";
							labelElement.style.flex = "1 1 auto";
							labelElement.style.marginLeft = "6px";
							labelElement.style.verticalAlign = "middle";
							var spacerElement = document.createElement("div");
							spacerElement.style.width = "6px";
							Utils.appendChild(element, spacerElement);
							Utils.appendChild(element, labelElement);
						}
						return element;
					};
					Object.defineProperty(ToggleInput.prototype, "isNullable", {
						get: function () {
							return false;
						},
						enumerable: true,
						configurable: true
					});
					ToggleInput.prototype.getJsonTypeName = function () {
						return "Input.Toggle";
					};
					ToggleInput.prototype.toJSON = function () {
						var result = _super.prototype.toJSON.call(this);
						Utils.setProperty(result, "valueOn", this.valueOn, "true");
						Utils.setProperty(result, "valueOff", this.valueOff, "false");
						Utils.setProperty(result, "wrap", this.wrap);
						return result;
					};
					ToggleInput.prototype.parse = function (json, errors) {
						_super.prototype.parse.call(this, json, errors);
						this.title = Utils.getStringValue(json["title"]);
						this.valueOn = Utils.getStringValue(json["valueOn"], this.valueOn);
						this.valueOff = Utils.getStringValue(json["valueOff"], this.valueOff);
						this.wrap = Utils.getBoolValue(json["wrap"], this.wrap);
					};
					Object.defineProperty(ToggleInput.prototype, "value", {
						get: function () {
							if (this._checkboxInputElement) {
								return this._checkboxInputElement.checked ? this.valueOn : this.valueOff;
							}
							else {
								return null;
							}
						},
						enumerable: true,
						configurable: true
					});
					return ToggleInput;
				}(Input));
				exports.ToggleInput = ToggleInput;
				var Choice = /** @class */ (function (_super) {
					__extends(Choice, _super);
					function Choice(title, value) {
						if (title === void 0) { title = undefined; }
						if (value === void 0) { value = undefined; }
						var _this = _super.call(this) || this;
						_this.title = title;
						_this.value = value;
						return _this;
					}
					Choice.prototype.parse = function (json) {
						_super.prototype.parse.call(this, json);
						this.title = Utils.getStringValue(json["title"], "");
						this.value = Utils.getStringValue(json["value"], "");
					};
					Choice.prototype.toJSON = function () {
						var result = _super.prototype.toJSON.call(this);
						Utils.setProperty(result, "title", this.title);
						Utils.setProperty(result, "value", this.value);
						return result;
					};
					return Choice;
				}(SerializableObject));
				exports.Choice = Choice;
				var ChoiceSetInput = /** @class */ (function (_super) {
					__extends(ChoiceSetInput, _super);
					function ChoiceSetInput() {
						var _this = _super !== null && _super.apply(this, arguments) || this;
						_this.choices = [];
						_this.isCompact = false;
						_this.isMultiSelect = false;
						_this.wrap = false;
						return _this;
					}
					ChoiceSetInput.getUniqueCategoryName = function () {
						var uniqueCwtegoryName = "__ac-category" + ChoiceSetInput.uniqueCategoryCounter;
						ChoiceSetInput.uniqueCategoryCounter++;
						return uniqueCwtegoryName;
					};
					ChoiceSetInput.prototype.internalRender = function () {
						var _this = this;
						if (!this.isMultiSelect) {
							if (this.isCompact) {
								// Render as a combo box
								this._selectElement = document.createElement("select");
								this._selectElement.className = this.hostConfig.makeCssClassName("ac-input", "ac-multichoiceInput", "ac-choiceSetInput-compact");
								this._selectElement.style.width = "100%";
								var option = document.createElement("option");
								option.selected = true;
								option.disabled = true;
								option.hidden = true;
								option.value = "";
								if (this.placeholder) {
									option.text = this.placeholder;
								}
								Utils.appendChild(this._selectElement, option);
								for (var i = 0; i < this.choices.length; i++) {
									var option_1 = document.createElement("option");
									option_1.value = this.choices[i].value;
									option_1.text = this.choices[i].title;
									option_1.setAttribute("aria-label", this.choices[i].title);
									if (this.choices[i].value == this.defaultValue) {
										option_1.selected = true;
									}
									Utils.appendChild(this._selectElement, option_1);
								}
								this._selectElement.onchange = function () { _this.valueChanged(); };
								return this._selectElement;
							}
							else {
								// Render as a series of radio buttons
								var uniqueCategoryName = ChoiceSetInput.getUniqueCategoryName();
								var element = document.createElement("div");
								element.className = this.hostConfig.makeCssClassName("ac-input", "ac-choiceSetInput-expanded");
								element.style.width = "100%";
								this._toggleInputs = [];
								for (var i_1 = 0; i_1 < this.choices.length; i_1++) {
									var radioInput = document.createElement("input");
									radioInput.id = Utils.generateUniqueId();
									radioInput.type = "radio";
									radioInput.style.margin = "0";
									radioInput.style.display = "inline-block";
									radioInput.style.verticalAlign = "middle";
									radioInput.name = Utils.isNullOrEmpty(this.id) ? uniqueCategoryName : this.id;
									radioInput.value = this.choices[i_1].value;
									radioInput.style.flex = "0 0 auto";
									radioInput.setAttribute("aria-label", this.choices[i_1].title);
									if (this.choices[i_1].value == this.defaultValue) {
										radioInput.checked = true;
									}
									radioInput.onchange = function () { _this.valueChanged(); };
									this._toggleInputs.push(radioInput);
									var label = new Label();
									label.setParent(this);
									label.forElementId = radioInput.id;
									label.hostConfig = this.hostConfig;
									label.text = Utils.isNullOrEmpty(this.choices[i_1].title) ? "Choice " + i_1 : this.choices[i_1].title;
									label.useMarkdown = AdaptiveCard.useMarkdownInRadioButtonAndCheckbox;
									label.wrap = this.wrap;
									var labelElement = label.render();
									labelElement.style.display = "inline-block";
									labelElement.style.flex = "1 1 auto";
									labelElement.style.marginLeft = "6px";
									labelElement.style.verticalAlign = "middle";
									var spacerElement = document.createElement("div");
									spacerElement.style.width = "6px";
									var compoundInput = document.createElement("div");
									compoundInput.style.display = "flex";
									compoundInput.style.alignItems = "center";
									Utils.appendChild(compoundInput, radioInput);
									Utils.appendChild(compoundInput, spacerElement);
									Utils.appendChild(compoundInput, labelElement);
									Utils.appendChild(element, compoundInput);
								}
								return element;
							}
						}
						else {
							// Render as a list of toggle inputs
							var defaultValues = this.defaultValue ? this.defaultValue.split(this.hostConfig.choiceSetInputValueSeparator) : null;
							var element = document.createElement("div");
							element.className = this.hostConfig.makeCssClassName("ac-input", "ac-choiceSetInput-multiSelect");
							element.style.width = "100%";
							this._toggleInputs = [];
							for (var i_2 = 0; i_2 < this.choices.length; i_2++) {
								var checkboxInput = document.createElement("input");
								checkboxInput.id = Utils.generateUniqueId();
								checkboxInput.type = "checkbox";
								checkboxInput.style.margin = "0";
								checkboxInput.style.display = "inline-block";
								checkboxInput.style.verticalAlign = "middle";
								checkboxInput.value = this.choices[i_2].value;
								checkboxInput.style.flex = "0 0 auto";
								checkboxInput.setAttribute("aria-label", this.choices[i_2].title);
								if (defaultValues) {
									if (defaultValues.indexOf(this.choices[i_2].value) >= 0) {
										checkboxInput.checked = true;
									}
								}
								checkboxInput.onchange = function () { _this.valueChanged(); };
								this._toggleInputs.push(checkboxInput);
								var label = new Label();
								label.setParent(this);
								label.forElementId = checkboxInput.id;
								label.hostConfig = this.hostConfig;
								label.text = Utils.isNullOrEmpty(this.choices[i_2].title) ? "Choice " + i_2 : this.choices[i_2].title;
								label.useMarkdown = AdaptiveCard.useMarkdownInRadioButtonAndCheckbox;
								label.wrap = this.wrap;
								var labelElement = label.render();
								labelElement.style.display = "inline-block";
								labelElement.style.flex = "1 1 auto";
								labelElement.style.marginLeft = "6px";
								labelElement.style.verticalAlign = "middle";
								var spacerElement = document.createElement("div");
								spacerElement.style.width = "6px";
								var compoundInput = document.createElement("div");
								compoundInput.style.display = "flex";
								compoundInput.style.alignItems = "center";
								Utils.appendChild(compoundInput, checkboxInput);
								Utils.appendChild(compoundInput, spacerElement);
								Utils.appendChild(compoundInput, labelElement);
								Utils.appendChild(element, compoundInput);
							}
							return element;
						}
					};
					ChoiceSetInput.prototype.getJsonTypeName = function () {
						return "Input.ChoiceSet";
					};
					ChoiceSetInput.prototype.toJSON = function () {
						var result = _super.prototype.toJSON.call(this);
						Utils.setProperty(result, "placeholder", this.placeholder);
						/*
        let choices = [];

        if (this.choices) {
            for (let choice of this.choices) {
                choices.push(choice.toJSON());
            }
        }

        Utils.setProperty(result, "choices", choices);
        */
						Utils.setArrayProperty(result, "choices", this.choices);
						Utils.setProperty(result, "style", this.isCompact ? null : "expanded");
						Utils.setProperty(result, "isMultiSelect", this.isMultiSelect, false);
						Utils.setProperty(result, "wrap", this.wrap, false);
						return result;
					};
					ChoiceSetInput.prototype.internalValidateProperties = function (context) {
						_super.prototype.internalValidateProperties.call(this, context);
						if (this.choices.length == 0) {
							context.addFailure(this, {
								error: Enums.ValidationError.CollectionCantBeEmpty,
								message: "An Input.ChoiceSet must have at least one choice defined."
							});
						}
						for (var _i = 0, _a = this.choices; _i < _a.length; _i++) {
							var choice = _a[_i];
							if (!choice.title || !choice.value) {
								context.addFailure(this, {
									error: Enums.ValidationError.PropertyCantBeNull,
									message: "All choices in an Input.ChoiceSet must have their title and value properties set."
								});
							}
						}
					};
					ChoiceSetInput.prototype.parse = function (json, errors) {
						_super.prototype.parse.call(this, json, errors);
						this.isCompact = !(json["style"] === "expanded");
						this.isMultiSelect = Utils.getBoolValue(json["isMultiSelect"], this.isMultiSelect);
						this.placeholder = Utils.getStringValue(json["placeholder"]);
						this.choices = [];
						if (Array.isArray(json["choices"])) {
							for (var _i = 0, _a = json["choices"]; _i < _a.length; _i++) {
								var jsonChoice = _a[_i];
								var choice = new Choice();
								choice.parse(jsonChoice);
								this.choices.push(choice);
							}
						}
						this.wrap = Utils.getBoolValue(json["wrap"], this.wrap);
					};
					Object.defineProperty(ChoiceSetInput.prototype, "value", {
						get: function () {
							if (!this.isMultiSelect) {
								if (this.isCompact) {
									if (this._selectElement) {
										return this._selectElement.selectedIndex > 0 ? this._selectElement.value : null;
									}
									return null;
								}
								else {
									if (!this._toggleInputs || this._toggleInputs.length == 0) {
										return null;
									}
									for (var i = 0; i < this._toggleInputs.length; i++) {
										if (this._toggleInputs[i].checked) {
											return this._toggleInputs[i].value;
										}
									}
									return null;
								}
							}
							else {
								if (!this._toggleInputs || this._toggleInputs.length == 0) {
									return null;
								}
								var result = "";
								for (var i = 0; i < this._toggleInputs.length; i++) {
									if (this._toggleInputs[i].checked) {
										if (result != "") {
											result += this.hostConfig.choiceSetInputValueSeparator;
										}
										result += this._toggleInputs[i].value;
									}
								}
								return result == "" ? null : result;
							}
						},
						enumerable: true,
						configurable: true
					});
					ChoiceSetInput.uniqueCategoryCounter = 0;
					return ChoiceSetInput;
				}(Input));
				exports.ChoiceSetInput = ChoiceSetInput;
				var NumberInput = /** @class */ (function (_super) {
					__extends(NumberInput, _super);
					function NumberInput() {
						return _super !== null && _super.apply(this, arguments) || this;
					}
					NumberInput.prototype.internalRender = function () {
						var _this = this;
						this._numberInputElement = document.createElement("input");
						this._numberInputElement.setAttribute("type", "number");
						if (this.min) {
							this._numberInputElement.setAttribute("min", this.min.toString());
						}
						if (this.max) {
							this._numberInputElement.setAttribute("max", this.max.toString());
						}
						this._numberInputElement.className = this.hostConfig.makeCssClassName("ac-input", "ac-numberInput");
						this._numberInputElement.style.width = "100%";
						this._numberInputElement.tabIndex = 0;
						if (!Utils.isNullOrEmpty(this.defaultValue)) {
							this._numberInputElement.value = this.defaultValue;
						}
						if (!Utils.isNullOrEmpty(this.placeholder)) {
							this._numberInputElement.placeholder = this.placeholder;
							this._numberInputElement.setAttribute("aria-label", this.placeholder);
						}
						this._numberInputElement.oninput = function () { _this.valueChanged(); };
						return this._numberInputElement;
					};
					NumberInput.prototype.getJsonTypeName = function () {
						return "Input.Number";
					};
					NumberInput.prototype.toJSON = function () {
						var result = _super.prototype.toJSON.call(this);
						Utils.setProperty(result, "placeholder", this.placeholder);
						Utils.setNumberProperty(result, "min", this.min);
						Utils.setNumberProperty(result, "max", this.max);
						return result;
					};
					NumberInput.prototype.parse = function (json, errors) {
						_super.prototype.parse.call(this, json, errors);
						this.placeholder = Utils.getStringValue(json["placeholder"]);
						this.min = Utils.getNumberValue(json["min"]);
						this.max = Utils.getNumberValue(json["max"]);
					};
					Object.defineProperty(NumberInput.prototype, "min", {
						get: function () {
							return this._min;
						},
						set: function (value) {
							this._min = value;
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(NumberInput.prototype, "max", {
						get: function () {
							return this._max;
						},
						set: function (value) {
							this._max = value;
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(NumberInput.prototype, "value", {
						get: function () {
							return this._numberInputElement ? this._numberInputElement.value : undefined;
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(NumberInput.prototype, "valueAsNumber", {
						get: function () {
							return this._numberInputElement ? this._numberInputElement.valueAsNumber : undefined;
						},
						enumerable: true,
						configurable: true
					});
					return NumberInput;
				}(Input));
				exports.NumberInput = NumberInput;
				var DateInput = /** @class */ (function (_super) {
					__extends(DateInput, _super);
					function DateInput() {
						return _super !== null && _super.apply(this, arguments) || this;
					}
					DateInput.prototype.internalRender = function () {
						var _this = this;
						this._dateInputElement = document.createElement("input");
						this._dateInputElement.setAttribute("type", "date");
						this._dateInputElement.setAttribute("min", this.min);
						this._dateInputElement.setAttribute("max", this.max);
						this._dateInputElement.className = this.hostConfig.makeCssClassName("ac-input", "ac-dateInput");
						this._dateInputElement.style.width = "100%";
						this._dateInputElement.oninput = function () { _this.valueChanged(); };
						if (!Utils.isNullOrEmpty(this.defaultValue)) {
							this._dateInputElement.value = this.defaultValue;
						}
						return this._dateInputElement;
					};
					DateInput.prototype.getJsonTypeName = function () {
						return "Input.Date";
					};
					DateInput.prototype.toJSON = function () {
						var result = _super.prototype.toJSON.call(this);
						Utils.setProperty(result, "min", this.min);
						Utils.setProperty(result, "max", this.max);
						return result;
					};
					DateInput.prototype.parse = function (json, errors) {
						_super.prototype.parse.call(this, json, errors);
						this.min = Utils.getStringValue(json["min"]);
						this.max = Utils.getStringValue(json["max"]);
					};
					Object.defineProperty(DateInput.prototype, "min", {
						get: function () {
							return this._min;
						},
						set: function (value) {
							this._min = this.parseInputValue(value);
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(DateInput.prototype, "max", {
						get: function () {
							return this._max;
						},
						set: function (value) {
							this._max = this.parseInputValue(value);
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(DateInput.prototype, "value", {
						get: function () {
							return this._dateInputElement ? this._dateInputElement.value : null;
						},
						enumerable: true,
						configurable: true
					});
					return DateInput;
				}(Input));
				exports.DateInput = DateInput;
				var TimeInput = /** @class */ (function (_super) {
					__extends(TimeInput, _super);
					function TimeInput() {
						return _super !== null && _super.apply(this, arguments) || this;
					}
					TimeInput.prototype.internalRender = function () {
						var _this = this;
						this._timeInputElement = document.createElement("input");
						this._timeInputElement.setAttribute("type", "time");
						this._timeInputElement.setAttribute("min", this.min);
						this._timeInputElement.setAttribute("max", this.max);
						this._timeInputElement.className = this.hostConfig.makeCssClassName("ac-input", "ac-timeInput");
						this._timeInputElement.style.width = "100%";
						this._timeInputElement.oninput = function () { _this.valueChanged(); };
						if (!Utils.isNullOrEmpty(this.defaultValue)) {
							this._timeInputElement.value = this.defaultValue;
						}
						return this._timeInputElement;
					};
					TimeInput.prototype.parseInputValue = function (value) {
						if (/^[0-9]{2}:[0-9]{2}$/.test(value)) {
							return value;
						}
						else {
							return null;
						}
					};
					TimeInput.prototype.getJsonTypeName = function () {
						return "Input.Time";
					};
					TimeInput.prototype.toJSON = function () {
						var result = _super.prototype.toJSON.call(this);
						Utils.setProperty(result, "min", this.min);
						Utils.setProperty(result, "max", this.max);
						return result;
					};
					TimeInput.prototype.parse = function (json, errors) {
						_super.prototype.parse.call(this, json, errors);
						this.min = Utils.getStringValue(json["min"]);
						this.max = Utils.getStringValue(json["max"]);
					};
					Object.defineProperty(TimeInput.prototype, "min", {
						get: function () {
							return this._min;
						},
						set: function (value) {
							this._min = this.parseInputValue(value);
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(TimeInput.prototype, "max", {
						get: function () {
							return this._max;
						},
						set: function (value) {
							this._max = this.parseInputValue(value);
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(TimeInput.prototype, "value", {
						get: function () {
							return this._timeInputElement ? this._timeInputElement.value : null;
						},
						enumerable: true,
						configurable: true
					});
					return TimeInput;
				}(Input));
				exports.TimeInput = TimeInput;
				var ActionButtonState;
				(function (ActionButtonState) {
					ActionButtonState[ActionButtonState["Normal"] = 0] = "Normal";
					ActionButtonState[ActionButtonState["Expanded"] = 1] = "Expanded";
					ActionButtonState[ActionButtonState["Subdued"] = 2] = "Subdued";
				})(ActionButtonState || (ActionButtonState = {}));
				var ActionButton = /** @class */ (function () {
					function ActionButton(action, parentContainerStyle) {
						this._state = ActionButtonState.Normal;
						this.onClick = null;
						this.action = action;
						this._parentContainerStyle = parentContainerStyle;
					}
					ActionButton.prototype.updateCssStyle = function () {
						var _a, _b;
						var hostConfig = this.action.parent.hostConfig;
						this.action.renderedElement.className = hostConfig.makeCssClassName("ac-pushButton");
						if (!Utils.isNullOrEmpty(this._parentContainerStyle)) {
							this.action.renderedElement.classList.add("style-" + this._parentContainerStyle);
						}
						if (this.action instanceof ShowCardAction) {
							this.action.renderedElement.classList.add(hostConfig.makeCssClassName("expandable"));
						}
						this.action.renderedElement.classList.remove(hostConfig.makeCssClassName("expanded"));
						this.action.renderedElement.classList.remove(hostConfig.makeCssClassName("subdued"));
						switch (this._state) {
							case ActionButtonState.Expanded:
								this.action.renderedElement.classList.add(hostConfig.makeCssClassName("expanded"));
								break;
							case ActionButtonState.Subdued:
								this.action.renderedElement.classList.add(hostConfig.makeCssClassName("subdued"));
								break;
						}
						if (!Utils.isNullOrEmpty(this.action.style)) {
							if (this.action.style === Enums.ActionStyle.Positive) {
								(_a = this.action.renderedElement.classList).add.apply(_a, hostConfig.makeCssClassNames("primary", "style-positive"));
							}
							else {
								(_b = this.action.renderedElement.classList).add.apply(_b, hostConfig.makeCssClassNames("style-" + this.action.style.toLowerCase()));
							}
						}
					};
					ActionButton.prototype.render = function () {
						var _this = this;
						this.action.render();
						this.action.renderedElement.onclick = function (e) {
							e.preventDefault();
							e.cancelBubble = true;
							_this.click();
						};
						this.updateCssStyle();
					};
					ActionButton.prototype.click = function () {
						if (this.onClick != null) {
							this.onClick(this);
						}
					};
					Object.defineProperty(ActionButton.prototype, "state", {
						get: function () {
							return this._state;
						},
						set: function (value) {
							this._state = value;
							this.updateCssStyle();
						},
						enumerable: true,
						configurable: true
					});
					return ActionButton;
				}());
				var Action = /** @class */ (function (_super) {
					__extends(Action, _super);
					function Action() {
						var _this = _super !== null && _super.apply(this, arguments) || this;
						_this._shouldFallback = false;
						_this._parent = null;
						_this._actionCollection = null; // hold the reference to its action collection
						_this._renderedElement = null;
						_this.requires = new HostConfig.HostCapabilities();
						_this.style = Enums.ActionStyle.Default;
						return _this;
					}
					Action.prototype.setCollection = function (actionCollection) {
						this._actionCollection = actionCollection;
					};
					Action.prototype.addCssClasses = function (element) {
						// Do nothing in base implementation
					};
					Action.prototype.internalGetReferencedInputs = function (allInputs) {
						return {};
					};
					Action.prototype.internalPrepareForExecution = function (inputs) {
						// Do nothing in base implementation
					};
					Action.prototype.internalValidateInputs = function (referencedInputs) {
						var result = [];
						if (AdaptiveCard.useBuiltInInputValidation && !this.ignoreInputValidation) {
							for (var _i = 0, _a = Object.keys(referencedInputs); _i < _a.length; _i++) {
								var key = _a[_i];
								var input = referencedInputs[key];
								if (!input.validateValue()) {
									result.push(input);
								}
							}
						}
						return result;
					};
					Action.prototype.getHref = function () {
						return "";
					};
					Action.prototype.toJSON = function () {
						var result = _super.prototype.toJSON.call(this);
						Utils.setProperty(result, "type", this.getJsonTypeName());
						Utils.setProperty(result, "title", this.title);
						Utils.setProperty(result, "iconUrl", this.iconUrl);
						Utils.setProperty(result, "style", this.style, Enums.ActionStyle.Default);
						return result;
					};
					Action.prototype.render = function (baseCssClass) {
						if (baseCssClass === void 0) { baseCssClass = "ac-pushButton"; }
						// Cache hostConfig for perf
						var hostConfig = this.parent.hostConfig;
						var buttonElement = document.createElement("button");
						this.addCssClasses(buttonElement);
						buttonElement.setAttribute("aria-label", this.title);
						buttonElement.type = "button";
						buttonElement.style.display = "flex";
						buttonElement.style.alignItems = "center";
						buttonElement.style.justifyContent = "center";
						var hasTitle = !Utils.isNullOrEmpty(this.title);
						var titleElement = document.createElement("div");
						titleElement.style.overflow = "hidden";
						titleElement.style.textOverflow = "ellipsis";
						if (!(hostConfig.actions.iconPlacement == Enums.ActionIconPlacement.AboveTitle || hostConfig.actions.allowTitleToWrap)) {
							titleElement.style.whiteSpace = "nowrap";
						}
						if (hasTitle) {
							titleElement.innerText = this.title;
						}
						if (Utils.isNullOrEmpty(this.iconUrl)) {
							buttonElement.classList.add("noIcon");
							buttonElement.appendChild(titleElement);
						}
						else {
							var iconElement = document.createElement("img");
							iconElement.src = this.iconUrl;
							iconElement.style.width = hostConfig.actions.iconSize + "px";
							iconElement.style.height = hostConfig.actions.iconSize + "px";
							iconElement.style.flex = "0 0 auto";
							if (hostConfig.actions.iconPlacement == Enums.ActionIconPlacement.AboveTitle) {
								buttonElement.classList.add("iconAbove");
								buttonElement.style.flexDirection = "column";
								if (hasTitle) {
									iconElement.style.marginBottom = "4px";
								}
							}
							else {
								buttonElement.classList.add("iconLeft");
								if (hasTitle) {
									iconElement.style.marginRight = "4px";
								}
							}
							buttonElement.appendChild(iconElement);
							buttonElement.appendChild(titleElement);
						}
						this._renderedElement = buttonElement;
					};
					Action.prototype.setParent = function (value) {
						this._parent = value;
					};
					Action.prototype.execute = function () {
						if (this.onExecute) {
							this.onExecute(this);
						}
						raiseExecuteActionEvent(this);
					};
					Action.prototype.prepareForExecution = function () {
						var referencedInputs = this.getReferencedInputs();
						if (this.internalValidateInputs(referencedInputs).length > 0) {
							return false;
						}
						this.internalPrepareForExecution(referencedInputs);
						return true;
					};
					;
					Action.prototype.parse = function (json, errors) {
						_super.prototype.parse.call(this, json, errors);
						raiseParseActionEvent(this, json, errors);
						this.requires.parse(json["requires"], errors);
						if (!json["title"] && json["title"] !== "") {
							raiseParseError({
								error: Enums.ValidationError.PropertyCantBeNull,
								message: "Actions should always have a title."
							}, errors);
						}
						this.title = Utils.getStringValue(json["title"]);
						this.iconUrl = Utils.getStringValue(json["iconUrl"]);
						this.style = Utils.getStringValue(json["style"], this.style);
					};
					Action.prototype.remove = function () {
						if (this._actionCollection) {
							return this._actionCollection.removeAction(this);
						}
						return false;
					};
					Action.prototype.getAllInputs = function () {
						return [];
					};
					Action.prototype.getResourceInformation = function () {
						if (!Utils.isNullOrEmpty(this.iconUrl)) {
							return [{ url: this.iconUrl, mimeType: "image" }];
						}
						else {
							return [];
						}
					};
					Action.prototype.getActionById = function (id) {
						if (this.id == id) {
							return this;
						}
					};
					Action.prototype.getReferencedInputs = function () {
						return this.internalGetReferencedInputs(this.parent.getRootElement().getAllInputs());
					};
					Action.prototype.validateInputs = function () {
						return this.internalValidateInputs(this.getReferencedInputs());
					};
					Action.prototype.shouldFallback = function () {
						return this._shouldFallback || !this.requires.areAllMet(this.parent.hostConfig.hostCapabilities);
					};
					Object.defineProperty(Action.prototype, "isPrimary", {
						get: function () {
							return this.style == Enums.ActionStyle.Positive;
						},
						set: function (value) {
							if (value) {
								this.style = Enums.ActionStyle.Positive;
							}
							else {
								if (this.style == Enums.ActionStyle.Positive) {
									this.style = Enums.ActionStyle.Default;
								}
							}
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(Action.prototype, "ignoreInputValidation", {
						get: function () {
							return true;
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(Action.prototype, "parent", {
						get: function () {
							return this._parent;
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(Action.prototype, "renderedElement", {
						get: function () {
							return this._renderedElement;
						},
						enumerable: true,
						configurable: true
					});
					return Action;
				}(CardObject));
				exports.Action = Action;
				var SubmitAction = /** @class */ (function (_super) {
					__extends(SubmitAction, _super);
					function SubmitAction() {
						var _this = _super !== null && _super.apply(this, arguments) || this;
						_this._isPrepared = false;
						_this._ignoreInputValidation = false;
						return _this;
					}
					SubmitAction.prototype.internalGetReferencedInputs = function (allInputs) {
						var result = {};
						for (var _i = 0, allInputs_1 = allInputs; _i < allInputs_1.length; _i++) {
							var input = allInputs_1[_i];
							result[input.id] = input;
						}
						return result;
					};
					SubmitAction.prototype.internalPrepareForExecution = function (inputs) {
						if (this._originalData) {
							this._processedData = JSON.parse(JSON.stringify(this._originalData));
						}
						else {
							this._processedData = {};
						}
						for (var _i = 0, _a = Object.keys(inputs); _i < _a.length; _i++) {
							var key = _a[_i];
							var input = inputs[key];
							if (input.value != null) {
								this._processedData[input.id] = input.value;
							}
						}
						this._isPrepared = true;
					};
					SubmitAction.prototype.getJsonTypeName = function () {
						return SubmitAction.JsonTypeName;
					};
					SubmitAction.prototype.toJSON = function () {
						var result = _super.prototype.toJSON.call(this);
						Utils.setProperty(result, "ignoreInputValidation", this.ignoreInputValidation, false);
						Utils.setProperty(result, "data", this._originalData);
						return result;
					};
					SubmitAction.prototype.parse = function (json, errors) {
						_super.prototype.parse.call(this, json, errors);
						this._ignoreInputValidation = Utils.getBoolValue(json["ignoreInputValidation"], this._ignoreInputValidation);
						this.data = json["data"];
					};
					Object.defineProperty(SubmitAction.prototype, "ignoreInputValidation", {
						get: function () {
							return this._ignoreInputValidation;
						},
						set: function (value) {
							this._ignoreInputValidation = value;
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(SubmitAction.prototype, "data", {
						get: function () {
							return this._isPrepared ? this._processedData : this._originalData;
						},
						set: function (value) {
							this._originalData = value;
							this._isPrepared = false;
						},
						enumerable: true,
						configurable: true
					});
					// Note the "weird" way this field is declared is to work around a breaking
					// change introduced in TS 3.1 wrt d.ts generation. DO NOT CHANGE
					SubmitAction.JsonTypeName = "Action.Submit";
					return SubmitAction;
				}(Action));
				exports.SubmitAction = SubmitAction;
				var OpenUrlAction = /** @class */ (function (_super) {
					__extends(OpenUrlAction, _super);
					function OpenUrlAction() {
						return _super !== null && _super.apply(this, arguments) || this;
					}
					OpenUrlAction.prototype.getJsonTypeName = function () {
						return OpenUrlAction.JsonTypeName;
					};
					OpenUrlAction.prototype.toJSON = function () {
						var result = _super.prototype.toJSON.call(this);
						Utils.setProperty(result, "url", this.url);
						return result;
					};
					OpenUrlAction.prototype.internalValidateProperties = function (context) {
						_super.prototype.internalValidateProperties.call(this, context);
						if (Utils.isNullOrEmpty(this.url)) {
							context.addFailure(this, {
								error: Enums.ValidationError.PropertyCantBeNull,
								message: "An Action.OpenUrl must have its url property set."
							});
						}
					};
					OpenUrlAction.prototype.parse = function (json, errors) {
						_super.prototype.parse.call(this, json, errors);
						this.url = Utils.getStringValue(json["url"]);
					};
					OpenUrlAction.prototype.getHref = function () {
						return this.url;
					};
					// Note the "weird" way this field is declared is to work around a breaking
					// change introduced in TS 3.1 wrt d.ts generation. DO NOT CHANGE
					OpenUrlAction.JsonTypeName = "Action.OpenUrl";
					return OpenUrlAction;
				}(Action));
				exports.OpenUrlAction = OpenUrlAction;
				var ToggleVisibilityAction = /** @class */ (function (_super) {
					__extends(ToggleVisibilityAction, _super);
					function ToggleVisibilityAction() {
						var _this = _super !== null && _super.apply(this, arguments) || this;
						_this.targetElements = {};
						return _this;
					}
					ToggleVisibilityAction.prototype.getJsonTypeName = function () {
						return ToggleVisibilityAction.JsonTypeName;
					};
					ToggleVisibilityAction.prototype.execute = function () {
						for (var _i = 0, _a = Object.keys(this.targetElements); _i < _a.length; _i++) {
							var elementId = _a[_i];
							var targetElement = this.parent.getRootElement().getElementById(elementId);
							if (targetElement) {
								if (typeof this.targetElements[elementId] === "boolean") {
									targetElement.isVisible = this.targetElements[elementId];
								}
								else {
									targetElement.isVisible = !targetElement.isVisible;
								}
							}
						}
					};
					ToggleVisibilityAction.prototype.parse = function (json) {
						_super.prototype.parse.call(this, json);
						this.targetElements = {};
						var jsonTargetElements = json["targetElements"];
						if (jsonTargetElements && Array.isArray(jsonTargetElements)) {
							for (var _i = 0, jsonTargetElements_1 = jsonTargetElements; _i < jsonTargetElements_1.length; _i++) {
								var item = jsonTargetElements_1[_i];
								if (typeof item === "string") {
									this.targetElements[item] = undefined;
								}
								else if (typeof item === "object") {
									var jsonElementId = item["elementId"];
									if (jsonElementId && typeof jsonElementId === "string") {
										this.targetElements[jsonElementId] = Utils.getBoolValue(item["isVisible"], undefined);
									}
								}
							}
						}
					};
					ToggleVisibilityAction.prototype.toJSON = function () {
						var result = _super.prototype.toJSON.call(this);
						var targetElements = [];
						for (var _i = 0, _a = Object.keys(this.targetElements); _i < _a.length; _i++) {
							var id = _a[_i];
							if (typeof this.targetElements[id] === "boolean") {
								targetElements.push({
									elementId: id,
									isVisible: this.targetElements[id]
								});
							}
							else {
								targetElements.push(id);
							}
						}
						result["targetElements"] = targetElements;
						return result;
					};
					ToggleVisibilityAction.prototype.addTargetElement = function (elementId, isVisible) {
						if (isVisible === void 0) { isVisible = undefined; }
						this.targetElements[elementId] = isVisible;
					};
					ToggleVisibilityAction.prototype.removeTargetElement = function (elementId) {
						delete this.targetElements[elementId];
					};
					// Note the "weird" way this field is declared is to work around a breaking
					// change introduced in TS 3.1 wrt d.ts generation. DO NOT CHANGE
					ToggleVisibilityAction.JsonTypeName = "Action.ToggleVisibility";
					return ToggleVisibilityAction;
				}(Action));
				exports.ToggleVisibilityAction = ToggleVisibilityAction;
				var HttpHeader = /** @class */ (function (_super) {
					__extends(HttpHeader, _super);
					function HttpHeader(name, value) {
						if (name === void 0) { name = ""; }
						if (value === void 0) { value = ""; }
						var _this = _super.call(this) || this;
						_this._value = new Shared.StringWithSubstitutions();
						_this.name = name;
						_this.value = value;
						return _this;
					}
					HttpHeader.prototype.parse = function (json) {
						_super.prototype.parse.call(this, json);
						this.name = Utils.getStringValue(json["name"]);
						this.value = Utils.getStringValue(json["value"]);
					};
					HttpHeader.prototype.toJSON = function () {
						var result = _super.prototype.toJSON.call(this);
						Utils.setProperty(result, "name", this.name);
						Utils.setProperty(result, "value", this._value.getOriginal());
						return result;
					};
					HttpHeader.prototype.getReferencedInputs = function (inputs, referencedInputs) {
						this._value.getReferencedInputs(inputs, referencedInputs);
					};
					HttpHeader.prototype.prepareForExecution = function (inputs) {
						this._value.substituteInputValues(inputs, Shared.ContentTypes.applicationXWwwFormUrlencoded);
					};
					Object.defineProperty(HttpHeader.prototype, "value", {
						get: function () {
							return this._value.get();
						},
						set: function (newValue) {
							this._value.set(newValue);
						},
						enumerable: true,
						configurable: true
					});
					return HttpHeader;
				}(SerializableObject));
				exports.HttpHeader = HttpHeader;
				var HttpAction = /** @class */ (function (_super) {
					__extends(HttpAction, _super);
					function HttpAction() {
						var _this = _super !== null && _super.apply(this, arguments) || this;
						_this._url = new Shared.StringWithSubstitutions();
						_this._body = new Shared.StringWithSubstitutions();
						_this._headers = [];
						_this._ignoreInputValidation = false;
						return _this;
					}
					HttpAction.prototype.internalGetReferencedInputs = function (allInputs) {
						var result = {};
						this._url.getReferencedInputs(allInputs, result);
						for (var _i = 0, _a = this._headers; _i < _a.length; _i++) {
							var header = _a[_i];
							header.getReferencedInputs(allInputs, result);
						}
						this._body.getReferencedInputs(allInputs, result);
						return result;
					};
					HttpAction.prototype.internalPrepareForExecution = function (inputs) {
						this._url.substituteInputValues(inputs, Shared.ContentTypes.applicationXWwwFormUrlencoded);
						var contentType = Shared.ContentTypes.applicationJson;
						for (var _i = 0, _a = this._headers; _i < _a.length; _i++) {
							var header = _a[_i];
							header.prepareForExecution(inputs);
							if (header.name && header.name.toLowerCase() == "content-type") {
								contentType = header.value;
							}
						}
						this._body.substituteInputValues(inputs, contentType);
					};
					;
					HttpAction.prototype.getJsonTypeName = function () {
						return HttpAction.JsonTypeName;
					};
					HttpAction.prototype.toJSON = function () {
						var result = _super.prototype.toJSON.call(this);
						Utils.setProperty(result, "method", this.method);
						Utils.setProperty(result, "url", this._url.getOriginal());
						Utils.setProperty(result, "body", this._body.getOriginal());
						Utils.setProperty(result, "ignoreInputValidation", this.ignoreInputValidation, false);
						Utils.setArrayProperty(result, "headers", this.headers);
						return result;
					};
					HttpAction.prototype.internalValidateProperties = function (context) {
						_super.prototype.internalValidateProperties.call(this, context);
						if (Utils.isNullOrEmpty(this.url)) {
							context.addFailure(this, {
								error: Enums.ValidationError.PropertyCantBeNull,
								message: "An Action.Http must have its url property set."
							});
						}
						if (this.headers.length > 0) {
							for (var _i = 0, _a = this.headers; _i < _a.length; _i++) {
								var header = _a[_i];
								if (!header.name) {
									context.addFailure(this, {
										error: Enums.ValidationError.PropertyCantBeNull,
										message: "All headers of an Action.Http must have their name and value properties set."
									});
								}
							}
						}
					};
					HttpAction.prototype.parse = function (json, errors) {
						_super.prototype.parse.call(this, json, errors);
						this.url = Utils.getStringValue(json["url"]);
						this.method = Utils.getStringValue(json["method"]);
						this.body = Utils.getStringValue(json["body"]);
						this._ignoreInputValidation = Utils.getBoolValue(json["ignoreInputValidation"], this._ignoreInputValidation);
						this._headers = [];
						if (Array.isArray(json["headers"])) {
							for (var _i = 0, _a = json["headers"]; _i < _a.length; _i++) {
								var jsonHeader = _a[_i];
								var httpHeader = new HttpHeader();
								httpHeader.parse(jsonHeader);
								this.headers.push(httpHeader);
							}
						}
					};
					Object.defineProperty(HttpAction.prototype, "ignoreInputValidation", {
						get: function () {
							return this._ignoreInputValidation;
						},
						set: function (value) {
							this._ignoreInputValidation = value;
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(HttpAction.prototype, "url", {
						get: function () {
							return this._url.get();
						},
						set: function (value) {
							this._url.set(value);
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(HttpAction.prototype, "body", {
						get: function () {
							return this._body.get();
						},
						set: function (value) {
							this._body.set(value);
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(HttpAction.prototype, "headers", {
						get: function () {
							return this._headers ? this._headers : [];
						},
						set: function (value) {
							this._headers = value;
						},
						enumerable: true,
						configurable: true
					});
					// Note the "weird" way this field is declared is to work around a breaking
					// change introduced in TS 3.1 wrt d.ts generation. DO NOT CHANGE
					HttpAction.JsonTypeName = "Action.Http";
					return HttpAction;
				}(Action));
				exports.HttpAction = HttpAction;
				var ShowCardAction = /** @class */ (function (_super) {
					__extends(ShowCardAction, _super);
					function ShowCardAction() {
						var _this = _super !== null && _super.apply(this, arguments) || this;
						_this.card = new InlineAdaptiveCard();
						return _this;
					}
					ShowCardAction.prototype.addCssClasses = function (element) {
						_super.prototype.addCssClasses.call(this, element);
						element.classList.add(this.parent.hostConfig.makeCssClassName("expandable"));
					};
					ShowCardAction.prototype.getJsonTypeName = function () {
						return ShowCardAction.JsonTypeName;
					};
					ShowCardAction.prototype.toJSON = function () {
						var result = _super.prototype.toJSON.call(this);
						if (this.card) {
							Utils.setProperty(result, "card", this.card.toJSON());
						}
						return result;
					};
					ShowCardAction.prototype.internalValidateProperties = function (context) {
						_super.prototype.internalValidateProperties.call(this, context);
						this.card.internalValidateProperties(context);
					};
					ShowCardAction.prototype.parse = function (json, errors) {
						_super.prototype.parse.call(this, json, errors);
						var jsonCard = json["card"];
						if (jsonCard) {
							this.card.parse(jsonCard, errors);
						}
						else {
							raiseParseError({
								error: Enums.ValidationError.PropertyCantBeNull,
								message: "An Action.ShowCard must have its \"card\" property set to a valid AdaptiveCard object."
							}, errors);
						}
					};
					ShowCardAction.prototype.setParent = function (value) {
						_super.prototype.setParent.call(this, value);
						this.card.setParent(value);
					};
					ShowCardAction.prototype.getAllInputs = function () {
						return this.card.getAllInputs();
					};
					ShowCardAction.prototype.getResourceInformation = function () {
						return _super.prototype.getResourceInformation.call(this).concat(this.card.getResourceInformation());
					};
					ShowCardAction.prototype.getActionById = function (id) {
						var result = _super.prototype.getActionById.call(this, id);
						if (!result) {
							result = this.card.getActionById(id);
						}
						return result;
					};
					// Note the "weird" way this field is declared is to work around a breaking
					// change introduced in TS 3.1 wrt d.ts generation. DO NOT CHANGE
					ShowCardAction.JsonTypeName = "Action.ShowCard";
					return ShowCardAction;
				}(Action));
				exports.ShowCardAction = ShowCardAction;
				var ActionCollection = /** @class */ (function () {
					function ActionCollection(owner) {
						this._expandedAction = null;
						this._renderedActionCount = 0;
						this._actionCard = null;
						this.items = [];
						this.buttons = [];
						this._owner = owner;
					}
					ActionCollection.prototype.refreshContainer = function () {
						this._actionCardContainer.innerHTML = "";
						if (this._actionCard === null) {
							this._actionCardContainer.style.marginTop = "0px";
							return;
						}
						this._actionCardContainer.style.marginTop = this._renderedActionCount > 0 ? this._owner.hostConfig.actions.showCard.inlineTopMargin + "px" : "0px";
						var padding = this._owner.getEffectivePadding();
						this._owner.getImmediateSurroundingPadding(padding);
						var physicalPadding = this._owner.hostConfig.paddingDefinitionToSpacingDefinition(padding);
						if (this._actionCard !== null) {
							this._actionCard.style.paddingLeft = physicalPadding.left + "px";
							this._actionCard.style.paddingRight = physicalPadding.right + "px";
							this._actionCard.style.marginLeft = "-" + physicalPadding.left + "px";
							this._actionCard.style.marginRight = "-" + physicalPadding.right + "px";
							if (physicalPadding.bottom != 0 && !this._owner.isDesignMode()) {
								this._actionCard.style.paddingBottom = physicalPadding.bottom + "px";
								this._actionCard.style.marginBottom = "-" + physicalPadding.bottom + "px";
							}
							Utils.appendChild(this._actionCardContainer, this._actionCard);
						}
					};
					ActionCollection.prototype.layoutChanged = function () {
						this._owner.getRootElement().updateLayout();
					};
					ActionCollection.prototype.hideActionCard = function () {
						var previouslyExpandedAction = this._expandedAction;
						this._expandedAction = null;
						this._actionCard = null;
						this.refreshContainer();
						if (previouslyExpandedAction) {
							this.layoutChanged();
							raiseInlineCardExpandedEvent(previouslyExpandedAction, false);
						}
					};
					ActionCollection.prototype.showActionCard = function (action, suppressStyle, raiseEvent) {
						if (suppressStyle === void 0) { suppressStyle = false; }
						if (raiseEvent === void 0) { raiseEvent = true; }
						if (action.card == null) {
							return;
						}
						action.card.suppressStyle = suppressStyle;
						var renderedCard = action.card.render();
						this._actionCard = renderedCard;
						this._expandedAction = action;
						this.refreshContainer();
						if (raiseEvent) {
							this.layoutChanged();
							raiseInlineCardExpandedEvent(action, true);
						}
					};
					ActionCollection.prototype.collapseExpandedAction = function () {
						for (var i = 0; i < this.buttons.length; i++) {
							this.buttons[i].state = ActionButtonState.Normal;
						}
						this.hideActionCard();
					};
					ActionCollection.prototype.expandShowCardAction = function (action, raiseEvent) {
						for (var i = 0; i < this.buttons.length; i++) {
							if (this.buttons[i].action !== action) {
								this.buttons[i].state = ActionButtonState.Subdued;
							}
							else {
								this.buttons[i].state = ActionButtonState.Expanded;
							}
						}
						this.showActionCard(action, !(this._owner.isAtTheVeryLeft() && this._owner.isAtTheVeryRight()), raiseEvent);
					};
					ActionCollection.prototype.actionClicked = function (actionButton) {
						if (!(actionButton.action instanceof ShowCardAction)) {
							for (var i = 0; i < this.buttons.length; i++) {
								this.buttons[i].state = ActionButtonState.Normal;
							}
							this.hideActionCard();
							actionButton.action.execute();
						}
						else {
							if (this._owner.hostConfig.actions.showCard.actionMode === Enums.ShowCardActionMode.Popup) {
								actionButton.action.execute();
							}
							else if (actionButton.action === this._expandedAction) {
								this.collapseExpandedAction();
							}
							else {
								this.expandShowCardAction(actionButton.action, true);
							}
						}
					};
					ActionCollection.prototype.getParentContainer = function () {
						if (this._owner instanceof Container) {
							return this._owner;
						}
						else {
							return this._owner.getParentContainer();
						}
					};
					ActionCollection.prototype.findActionButton = function (action) {
						for (var _i = 0, _a = this.buttons; _i < _a.length; _i++) {
							var actionButton = _a[_i];
							if (actionButton.action == action) {
								return actionButton;
							}
						}
						return null;
					};
					ActionCollection.prototype.parse = function (json, errors) {
						this.clear();
						if (json && json instanceof Array) {
							for (var _i = 0, json_1 = json; _i < json_1.length; _i++) {
								var jsonAction = json_1[_i];
								var action = createActionInstance(this._owner, jsonAction, [], !this._owner.isDesignMode(), errors);
								if (action) {
									this.addAction(action);
								}
							}
						}
					};
					ActionCollection.prototype.toJSON = function () {
						if (this.items.length > 0) {
							var result = [];
							for (var _i = 0, _a = this.items; _i < _a.length; _i++) {
								var action = _a[_i];
								result.push(action.toJSON());
							}
							return result;
						}
						else {
							return null;
						}
					};
					ActionCollection.prototype.getActionById = function (id) {
						var result = null;
						for (var i = 0; i < this.items.length; i++) {
							result = this.items[i].getActionById(id);
							if (result) {
								break;
							}
						}
						return result;
					};
					ActionCollection.prototype.validateProperties = function (context) {
						if (this._owner.hostConfig.actions.maxActions && this.items.length > this._owner.hostConfig.actions.maxActions) {
							context.addFailure(this._owner, {
								error: Enums.ValidationError.TooManyActions,
								message: "A maximum of " + this._owner.hostConfig.actions.maxActions + " actions are allowed."
							});
						}
						if (this.items.length > 0 && !this._owner.hostConfig.supportsInteractivity) {
							context.addFailure(this._owner, {
								error: Enums.ValidationError.InteractivityNotAllowed,
								message: "Interactivity is not allowed."
							});
						}
						for (var _i = 0, _a = this.items; _i < _a.length; _i++) {
							var item = _a[_i];
							if (!isActionAllowed(item, this._owner.getForbiddenActionTypes())) {
								context.addFailure(this._owner, {
									error: Enums.ValidationError.ActionTypeNotAllowed,
									message: "Actions of type " + item.getJsonTypeName() + " are not allowe."
								});
							}
							item.internalValidateProperties(context);
						}
					};
					ActionCollection.prototype.render = function (orientation, isDesignMode) {
						var _this = this;
						// Cache hostConfig for better perf
						var hostConfig = this._owner.hostConfig;
						if (!hostConfig.supportsInteractivity) {
							return null;
						}
						var element = document.createElement("div");
						var maxActions = hostConfig.actions.maxActions ? Math.min(hostConfig.actions.maxActions, this.items.length) : this.items.length;
						var forbiddenActionTypes = this._owner.getForbiddenActionTypes();
						this._actionCardContainer = document.createElement("div");
						this._renderedActionCount = 0;
						if (hostConfig.actions.preExpandSingleShowCardAction && maxActions == 1 && this.items[0] instanceof ShowCardAction && isActionAllowed(this.items[0], forbiddenActionTypes)) {
							this.showActionCard(this.items[0], true);
							this._renderedActionCount = 1;
						}
						else {
							var buttonStrip = document.createElement("div");
							buttonStrip.className = hostConfig.makeCssClassName("ac-actionSet");
							buttonStrip.style.display = "flex";
							if (orientation == Enums.Orientation.Horizontal) {
								buttonStrip.style.flexDirection = "row";
								if (this._owner.horizontalAlignment && hostConfig.actions.actionAlignment != Enums.ActionAlignment.Stretch) {
									switch (this._owner.horizontalAlignment) {
										case Enums.HorizontalAlignment.Center:
											buttonStrip.style.justifyContent = "center";
											break;
										case Enums.HorizontalAlignment.Right:
											buttonStrip.style.justifyContent = "flex-end";
											break;
										default:
											buttonStrip.style.justifyContent = "flex-start";
											break;
									}
								}
								else {
									switch (hostConfig.actions.actionAlignment) {
										case Enums.ActionAlignment.Center:
											buttonStrip.style.justifyContent = "center";
											break;
										case Enums.ActionAlignment.Right:
											buttonStrip.style.justifyContent = "flex-end";
											break;
										default:
											buttonStrip.style.justifyContent = "flex-start";
											break;
									}
								}
							}
							else {
								buttonStrip.style.flexDirection = "column";
								if (this._owner.horizontalAlignment && hostConfig.actions.actionAlignment != Enums.ActionAlignment.Stretch) {
									switch (this._owner.horizontalAlignment) {
										case Enums.HorizontalAlignment.Center:
											buttonStrip.style.alignItems = "center";
											break;
										case Enums.HorizontalAlignment.Right:
											buttonStrip.style.alignItems = "flex-end";
											break;
										default:
											buttonStrip.style.alignItems = "flex-start";
											break;
									}
								}
								else {
									switch (hostConfig.actions.actionAlignment) {
										case Enums.ActionAlignment.Center:
											buttonStrip.style.alignItems = "center";
											break;
										case Enums.ActionAlignment.Right:
											buttonStrip.style.alignItems = "flex-end";
											break;
										case Enums.ActionAlignment.Stretch:
											buttonStrip.style.alignItems = "stretch";
											break;
										default:
											buttonStrip.style.alignItems = "flex-start";
											break;
									}
								}
							}
							var parentContainerStyle = this.getParentContainer().getEffectiveStyle();
							for (var i = 0; i < this.items.length; i++) {
								if (isActionAllowed(this.items[i], forbiddenActionTypes)) {
									var actionButton = this.findActionButton(this.items[i]);
									if (!actionButton) {
										actionButton = new ActionButton(this.items[i], parentContainerStyle);
										actionButton.onClick = function (ab) { _this.actionClicked(ab); };
										this.buttons.push(actionButton);
									}
									actionButton.render();
									if (hostConfig.actions.actionsOrientation == Enums.Orientation.Horizontal && hostConfig.actions.actionAlignment == Enums.ActionAlignment.Stretch) {
										actionButton.action.renderedElement.style.flex = "0 1 100%";
									}
									else {
										actionButton.action.renderedElement.style.flex = "0 1 auto";
									}
									buttonStrip.appendChild(actionButton.action.renderedElement);
									this._renderedActionCount++;
									if (this._renderedActionCount >= hostConfig.actions.maxActions || i == this.items.length - 1) {
										break;
									}
									else if (hostConfig.actions.buttonSpacing > 0) {
										var spacer = document.createElement("div");
										if (orientation === Enums.Orientation.Horizontal) {
											spacer.style.flex = "0 0 auto";
											spacer.style.width = hostConfig.actions.buttonSpacing + "px";
										}
										else {
											spacer.style.height = hostConfig.actions.buttonSpacing + "px";
										}
										Utils.appendChild(buttonStrip, spacer);
									}
								}
							}
							var buttonStripContainer = document.createElement("div");
							buttonStripContainer.style.overflow = "hidden";
							buttonStripContainer.appendChild(buttonStrip);
							Utils.appendChild(element, buttonStripContainer);
						}
						Utils.appendChild(element, this._actionCardContainer);
						for (var i = 0; i < this.buttons.length; i++) {
							if (this.buttons[i].state == ActionButtonState.Expanded) {
								this.expandShowCardAction(this.buttons[i].action, false);
								break;
							}
						}
						return this._renderedActionCount > 0 ? element : null;
					};
					ActionCollection.prototype.addAction = function (action) {
						if (!action) {
							throw new Error("The action parameter cannot be null.");
						}
						if ((!action.parent || action.parent === this._owner) && this.items.indexOf(action) < 0) {
							this.items.push(action);
							if (!action.parent) {
								action.setParent(this._owner);
							}
							invokeSetCollection(action, this);
						}
						else {
							throw new Error("The action already belongs to another element.");
						}
					};
					ActionCollection.prototype.removeAction = function (action) {
						if (this.expandedAction && this._expandedAction == action) {
							this.collapseExpandedAction();
						}
						var actionIndex = this.items.indexOf(action);
						if (actionIndex >= 0) {
							this.items.splice(actionIndex, 1);
							action.setParent(null);
							invokeSetCollection(action, null);
							for (var i = 0; i < this.buttons.length; i++) {
								if (this.buttons[i].action == action) {
									this.buttons.splice(i, 1);
									break;
								}
							}
							return true;
						}
						return false;
					};
					ActionCollection.prototype.clear = function () {
						this.items = [];
						this.buttons = [];
						this._expandedAction = null;
						this._renderedActionCount = 0;
					};
					ActionCollection.prototype.getAllInputs = function () {
						var result = [];
						for (var i = 0; i < this.items.length; i++) {
							var action = this.items[i];
							result = result.concat(action.getAllInputs());
						}
						return result;
					};
					ActionCollection.prototype.getResourceInformation = function () {
						var result = [];
						for (var i = 0; i < this.items.length; i++) {
							result = result.concat(this.items[i].getResourceInformation());
						}
						return result;
					};
					Object.defineProperty(ActionCollection.prototype, "renderedActionCount", {
						get: function () {
							return this._renderedActionCount;
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(ActionCollection.prototype, "expandedAction", {
						get: function () {
							return this._expandedAction;
						},
						enumerable: true,
						configurable: true
					});
					return ActionCollection;
				}());
				var ActionSet = /** @class */ (function (_super) {
					__extends(ActionSet, _super);
					function ActionSet() {
						var _this = _super.call(this) || this;
						_this.orientation = null;
						_this._actionCollection = new ActionCollection(_this);
						return _this;
					}
					ActionSet.prototype.internalRender = function () {
						return this._actionCollection.render(this.orientation ? this.orientation : this.hostConfig.actions.actionsOrientation, this.isDesignMode());
					};
					ActionSet.prototype.toJSON = function () {
						var result = _super.prototype.toJSON.call(this);
						Utils.setEnumProperty(Enums.Orientation, result, "orientation", this.orientation);
						Utils.setProperty(result, "actions", this._actionCollection.toJSON());
						return result;
					};
					ActionSet.prototype.isBleedingAtBottom = function () {
						if (this._actionCollection.renderedActionCount == 0) {
							return _super.prototype.isBleedingAtBottom.call(this);
						}
						else {
							if (this._actionCollection.items.length == 1) {
								return this._actionCollection.expandedAction != null && !this.hostConfig.actions.preExpandSingleShowCardAction;
							}
							else {
								return this._actionCollection.expandedAction != null;
							}
						}
					};
					ActionSet.prototype.getJsonTypeName = function () {
						return "ActionSet";
					};
					ActionSet.prototype.getActionCount = function () {
						return this._actionCollection.items.length;
					};
					ActionSet.prototype.getActionAt = function (index) {
						if (index >= 0 && index < this.getActionCount()) {
							return this._actionCollection.items[index];
						}
						else {
							_super.prototype.getActionAt.call(this, index);
						}
					};
					ActionSet.prototype.internalValidateProperties = function (context) {
						_super.prototype.internalValidateProperties.call(this, context);
						this._actionCollection.validateProperties(context);
					};
					ActionSet.prototype.parse = function (json, errors) {
						_super.prototype.parse.call(this, json, errors);
						var jsonOrientation = json["orientation"];
						if (jsonOrientation) {
							this.orientation = Utils.getEnumValue(Enums.Orientation, jsonOrientation, Enums.Orientation.Horizontal);
						}
						this._actionCollection.parse(json["actions"], errors);
					};
					ActionSet.prototype.addAction = function (action) {
						this._actionCollection.addAction(action);
					};
					ActionSet.prototype.getAllInputs = function () {
						return this._actionCollection.getAllInputs();
					};
					ActionSet.prototype.getResourceInformation = function () {
						return this._actionCollection.getResourceInformation();
					};
					Object.defineProperty(ActionSet.prototype, "isInteractive", {
						get: function () {
							return true;
						},
						enumerable: true,
						configurable: true
					});
					return ActionSet;
				}(CardElement));
				exports.ActionSet = ActionSet;
				var StylableCardElementContainer = /** @class */ (function (_super) {
					__extends(StylableCardElementContainer, _super);
					function StylableCardElementContainer() {
						var _this = _super !== null && _super.apply(this, arguments) || this;
						_this._style = null;
						_this._bleed = false;
						return _this;
					}
					StylableCardElementContainer.prototype.applyBackground = function () {
						var styleDefinition = this.hostConfig.containerStyles.getStyleByName(this.style, this.hostConfig.containerStyles.getStyleByName(this.defaultStyle));
						if (!Utils.isNullOrEmpty(styleDefinition.backgroundColor)) {
							this.renderedElement.style.backgroundColor = Utils.stringToCssColor(styleDefinition.backgroundColor);
						}
					};
					StylableCardElementContainer.prototype.applyPadding = function () {
						_super.prototype.applyPadding.call(this);
						if (!this.renderedElement) {
							return;
						}
						var physicalPadding = new Shared.SpacingDefinition();
						if (this.getEffectivePadding()) {
							physicalPadding = this.hostConfig.paddingDefinitionToSpacingDefinition(this.getEffectivePadding());
						}
						this.renderedElement.style.paddingTop = physicalPadding.top + "px";
						this.renderedElement.style.paddingRight = physicalPadding.right + "px";
						this.renderedElement.style.paddingBottom = physicalPadding.bottom + "px";
						this.renderedElement.style.paddingLeft = physicalPadding.left + "px";
						if (this.isBleeding()) {
							// Bleed into the first parent that does have padding
							var padding = new Shared.PaddingDefinition();
							this.getImmediateSurroundingPadding(padding);
							var surroundingPadding = this.hostConfig.paddingDefinitionToSpacingDefinition(padding);
							this.renderedElement.style.marginRight = "-" + surroundingPadding.right + "px";
							this.renderedElement.style.marginLeft = "-" + surroundingPadding.left + "px";
							if (!this.isDesignMode()) {
								this.renderedElement.style.marginTop = "-" + surroundingPadding.top + "px";
								this.renderedElement.style.marginBottom = "-" + surroundingPadding.bottom + "px";
							}
							if (this.separatorElement && this.separatorOrientation == Enums.Orientation.Horizontal) {
								this.separatorElement.style.marginLeft = "-" + surroundingPadding.left + "px";
								this.separatorElement.style.marginRight = "-" + surroundingPadding.right + "px";
							}
						}
						else {
							this.renderedElement.style.marginRight = "0";
							this.renderedElement.style.marginLeft = "0";
							this.renderedElement.style.marginTop = "0";
							this.renderedElement.style.marginBottom = "0";
							if (this.separatorElement) {
								this.separatorElement.style.marginRight = "0";
								this.separatorElement.style.marginLeft = "0";
							}
						}
					};
					StylableCardElementContainer.prototype.getHasBackground = function () {
						var currentElement = this.parent;
						while (currentElement) {
							var currentElementHasBackgroundImage = currentElement instanceof Container ? currentElement.backgroundImage.isValid() : false;
							if (currentElement instanceof StylableCardElementContainer) {
								if (this.hasExplicitStyle && (currentElement.getEffectiveStyle() != this.getEffectiveStyle() || currentElementHasBackgroundImage)) {
									return true;
								}
							}
							currentElement = currentElement.parent;
						}
						return false;
					};
					StylableCardElementContainer.prototype.getDefaultPadding = function () {
						return this.getHasBackground() ?
							new Shared.PaddingDefinition(Enums.Spacing.Padding, Enums.Spacing.Padding, Enums.Spacing.Padding, Enums.Spacing.Padding) : _super.prototype.getDefaultPadding.call(this);
					};
					StylableCardElementContainer.prototype.getHasExpandedAction = function () {
						return false;
					};
					StylableCardElementContainer.prototype.getBleed = function () {
						return this._bleed;
					};
					StylableCardElementContainer.prototype.setBleed = function (value) {
						this._bleed = value;
					};
					Object.defineProperty(StylableCardElementContainer.prototype, "renderedActionCount", {
						get: function () {
							return 0;
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(StylableCardElementContainer.prototype, "hasExplicitStyle", {
						get: function () {
							return this._style != null;
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(StylableCardElementContainer.prototype, "allowCustomStyle", {
						get: function () {
							return true;
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(StylableCardElementContainer.prototype, "supportsMinHeight", {
						get: function () {
							return true;
						},
						enumerable: true,
						configurable: true
					});
					StylableCardElementContainer.prototype.isBleeding = function () {
						return (this.getHasBackground() || this.hostConfig.alwaysAllowBleed) && this.getBleed();
					};
					StylableCardElementContainer.prototype.toJSON = function () {
						var result = _super.prototype.toJSON.call(this);
						Utils.setProperty(result, "style", this.style);
						return result;
					};
					StylableCardElementContainer.prototype.internalValidateProperties = function (context) {
						_super.prototype.internalValidateProperties.call(this, context);
						if (this._style) {
							var styleDefinition = this.hostConfig.containerStyles.getStyleByName(this._style);
							if (!styleDefinition) {
								context.addFailure(this, {
									error: Enums.ValidationError.InvalidPropertyValue,
									message: "Unknown container style: " + this._style
								});
							}
						}
					};
					StylableCardElementContainer.prototype.parse = function (json, errors) {
						_super.prototype.parse.call(this, json, errors);
						this._style = Utils.getStringValue(json["style"]);
					};
					StylableCardElementContainer.prototype.render = function () {
						var renderedElement = _super.prototype.render.call(this);
						if (renderedElement && this.getHasBackground()) {
							this.applyBackground();
						}
						return renderedElement;
					};
					StylableCardElementContainer.prototype.getEffectiveStyle = function () {
						var effectiveStyle = this.style;
						return effectiveStyle ? effectiveStyle : _super.prototype.getEffectiveStyle.call(this);
					};
					Object.defineProperty(StylableCardElementContainer.prototype, "style", {
						get: function () {
							if (this.allowCustomStyle) {
								if (this._style && this.hostConfig.containerStyles.getStyleByName(this._style)) {
									return this._style;
								}
							}
							return null;
						},
						set: function (value) {
							this._style = value;
						},
						enumerable: true,
						configurable: true
					});
					return StylableCardElementContainer;
				}(CardElementContainer));
				exports.StylableCardElementContainer = StylableCardElementContainer;
				var BackgroundImage = /** @class */ (function (_super) {
					__extends(BackgroundImage, _super);
					function BackgroundImage() {
						var _this = _super !== null && _super.apply(this, arguments) || this;
						_this.fillMode = BackgroundImage.defaultFillMode;
						_this.horizontalAlignment = BackgroundImage.defaultHorizontalAlignment;
						_this.verticalAlignment = BackgroundImage.defaultVerticalAlignment;
						return _this;
					}
					BackgroundImage.prototype.reset = function () {
						this.url = undefined;
						this.fillMode = BackgroundImage.defaultFillMode;
						this.horizontalAlignment = BackgroundImage.defaultHorizontalAlignment;
						this.verticalAlignment = BackgroundImage.defaultVerticalAlignment;
					};
					BackgroundImage.prototype.parse = function (json, errors) {
						_super.prototype.parse.call(this, json, errors);
						this.url = Utils.getStringValue(json["url"]);
						this.fillMode = Utils.getEnumValue(Enums.FillMode, json["fillMode"], this.fillMode);
						this.horizontalAlignment = Utils.getEnumValue(Enums.HorizontalAlignment, json["horizontalAlignment"], this.horizontalAlignment);
						this.verticalAlignment = Utils.getEnumValue(Enums.VerticalAlignment, json["verticalAlignment"], this.verticalAlignment);
					};
					BackgroundImage.prototype.toJSON = function () {
						if (!this.isValid()) {
							return null;
						}
						if (this.fillMode == BackgroundImage.defaultFillMode &&
							this.horizontalAlignment == BackgroundImage.defaultHorizontalAlignment &&
							this.verticalAlignment == BackgroundImage.defaultVerticalAlignment) {
							return this.url;
						}
						else {
							var result = _super.prototype.toJSON.call(this);
							Utils.setProperty(result, "url", this.url);
							Utils.setEnumProperty(Enums.FillMode, result, "fillMode", this.fillMode, BackgroundImage.defaultFillMode);
							Utils.setEnumProperty(Enums.HorizontalAlignment, result, "horizontalAlignment", this.horizontalAlignment, BackgroundImage.defaultHorizontalAlignment);
							Utils.setEnumProperty(Enums.VerticalAlignment, result, "verticalAlignment", this.verticalAlignment, BackgroundImage.defaultVerticalAlignment);
							return result;
						}
					};
					BackgroundImage.prototype.apply = function (element) {
						if (this.url) {
							element.style.backgroundImage = "url('" + this.url + "')";
							switch (this.fillMode) {
								case Enums.FillMode.Repeat:
									element.style.backgroundRepeat = "repeat";
									break;
								case Enums.FillMode.RepeatHorizontally:
									element.style.backgroundRepeat = "repeat-x";
									break;
								case Enums.FillMode.RepeatVertically:
									element.style.backgroundRepeat = "repeat-y";
									break;
								case Enums.FillMode.Cover:
								default:
									element.style.backgroundRepeat = "no-repeat";
									element.style.backgroundSize = "cover";
									break;
							}
							switch (this.horizontalAlignment) {
								case Enums.HorizontalAlignment.Center:
									element.style.backgroundPositionX = "center";
									break;
								case Enums.HorizontalAlignment.Right:
									element.style.backgroundPositionX = "right";
									break;
							}
							switch (this.verticalAlignment) {
								case Enums.VerticalAlignment.Center:
									element.style.backgroundPositionY = "center";
									break;
								case Enums.VerticalAlignment.Bottom:
									element.style.backgroundPositionY = "bottom";
									break;
							}
						}
					};
					BackgroundImage.prototype.isValid = function () {
						return !Utils.isNullOrEmpty(this.url);
					};
					BackgroundImage.defaultFillMode = Enums.FillMode.Cover;
					BackgroundImage.defaultHorizontalAlignment = Enums.HorizontalAlignment.Left;
					BackgroundImage.defaultVerticalAlignment = Enums.VerticalAlignment.Top;
					return BackgroundImage;
				}(SerializableObject));
				exports.BackgroundImage = BackgroundImage;
				var Container = /** @class */ (function (_super) {
					__extends(Container, _super);
					function Container() {
						var _this = _super !== null && _super.apply(this, arguments) || this;
						_this._items = [];
						_this._renderedItems = [];
						_this.backgroundImage = new BackgroundImage();
						_this.verticalContentAlignment = Enums.VerticalAlignment.Top;
						_this.rtl = null;
						return _this;
					}
					Container.prototype.insertItemAt = function (item, index, forceInsert) {
						if (!item.parent || forceInsert) {
							if (item.isStandalone) {
								if (index < 0 || index >= this._items.length) {
									this._items.push(item);
								}
								else {
									this._items.splice(index, 0, item);
								}
								item.setParent(this);
							}
							else {
								throw new Error("Elements of type " + item.getJsonTypeName() + " cannot be used as standalone elements.");
							}
						}
						else {
							throw new Error("The element already belongs to another container.");
						}
					};
					Container.prototype.supportsExcplitiHeight = function () {
						return true;
					};
					Container.prototype.getItemsCollectionPropertyName = function () {
						return "items";
					};
					Container.prototype.applyBackground = function () {
						if (this.backgroundImage.isValid()) {
							this.backgroundImage.apply(this.renderedElement);
						}
						_super.prototype.applyBackground.call(this);
					};
					Container.prototype.internalRender = function () {
						this._renderedItems = [];
						// Cache hostConfig to avoid walking the parent hierarchy several times
						var hostConfig = this.hostConfig;
						var element = document.createElement("div");
						if (this.rtl != null && this.rtl) {
							element.dir = "rtl";
						}
						element.classList.add(hostConfig.makeCssClassName("ac-container"));
						element.style.display = "flex";
						element.style.flexDirection = "column";
						if (AdaptiveCard.useAdvancedCardBottomTruncation) {
							// Forces the container to be at least as tall as its content.
							//
							// Fixes a quirk in Chrome where, for nested flex elements, the
							// inner element's height would never exceed the outer element's
							// height. This caused overflow truncation to break -- containers
							// would always be measured as not overflowing, since their heights
							// were constrained by their parents as opposed to truly reflecting
							// the height of their content.
							//
							// See the "Browser Rendering Notes" section of this answer:
							// https://stackoverflow.com/questions/36247140/why-doesnt-flex-item-shrink-past-content-size
							element.style.minHeight = '-webkit-min-content';
						}
						switch (this.verticalContentAlignment) {
							case Enums.VerticalAlignment.Center:
								element.style.justifyContent = "center";
								break;
							case Enums.VerticalAlignment.Bottom:
								element.style.justifyContent = "flex-end";
								break;
							default:
								element.style.justifyContent = "flex-start";
								break;
						}
						if (this._items.length > 0) {
							for (var i = 0; i < this._items.length; i++) {
								var renderedElement = this.isElementAllowed(this._items[i], this.getForbiddenElementTypes()) ? this._items[i].render() : null;
								if (renderedElement) {
									if (this._renderedItems.length > 0 && this._items[i].separatorElement) {
										this._items[i].separatorElement.style.flex = "0 0 auto";
										Utils.appendChild(element, this._items[i].separatorElement);
									}
									Utils.appendChild(element, renderedElement);
									this._renderedItems.push(this._items[i]);
								}
							}
						}
						else {
							if (this.isDesignMode()) {
								var placeholderElement = this.createPlaceholderElement();
								placeholderElement.style.width = "100%";
								placeholderElement.style.height = "100%";
								element.appendChild(placeholderElement);
							}
						}
						return element;
					};
					Container.prototype.truncateOverflow = function (maxHeight) {
						// Add 1 to account for rounding differences between browsers
						var boundary = this.renderedElement.offsetTop + maxHeight + 1;
						var handleElement = function (cardElement) {
							var elt = cardElement.renderedElement;
							if (elt) {
								switch (Utils.getFitStatus(elt, boundary)) {
									case Enums.ContainerFitStatus.FullyInContainer:
										var sizeChanged = cardElement['resetOverflow']();
										// If the element's size changed after resetting content,
										// we have to check if it still fits fully in the card
										if (sizeChanged) {
											handleElement(cardElement);
										}
										break;
									case Enums.ContainerFitStatus.Overflowing:
										var maxHeight_1 = boundary - elt.offsetTop;
										cardElement['handleOverflow'](maxHeight_1);
										break;
									case Enums.ContainerFitStatus.FullyOutOfContainer:
										cardElement['handleOverflow'](0);
										break;
								}
							}
						};
						for (var _i = 0, _a = this._items; _i < _a.length; _i++) {
							var item = _a[_i];
							handleElement(item);
						}
						return true;
					};
					Container.prototype.undoOverflowTruncation = function () {
						for (var _i = 0, _a = this._items; _i < _a.length; _i++) {
							var item = _a[_i];
							item['resetOverflow']();
						}
					};
					Container.prototype.getHasBackground = function () {
						return this.backgroundImage.isValid() || _super.prototype.getHasBackground.call(this);
					};
					Object.defineProperty(Container.prototype, "isSelectable", {
						get: function () {
							return true;
						},
						enumerable: true,
						configurable: true
					});
					Container.prototype.toJSON = function () {
						var result = _super.prototype.toJSON.call(this);
						Utils.setProperty(result, "backgroundImage", this.backgroundImage.toJSON());
						Utils.setEnumProperty(Enums.VerticalAlignment, result, "verticalContentAlignment", this.verticalContentAlignment, Enums.VerticalAlignment.Top);
						if (this._items.length > 0) {
							var elements = [];
							for (var _i = 0, _a = this._items; _i < _a.length; _i++) {
								var element = _a[_i];
								elements.push(element.toJSON());
							}
							Utils.setProperty(result, this.getItemsCollectionPropertyName(), elements);
						}
						Utils.setProperty(result, "bleed", this.bleed, false);
						return result;
					};
					Container.prototype.getItemCount = function () {
						return this._items.length;
					};
					Container.prototype.getItemAt = function (index) {
						return this._items[index];
					};
					Container.prototype.getFirstVisibleRenderedItem = function () {
						if (this.renderedElement && this._renderedItems && this._renderedItems.length > 0) {
							for (var _i = 0, _a = this._renderedItems; _i < _a.length; _i++) {
								var item = _a[_i];
								if (item.isVisible) {
									return item;
								}
							}
							;
						}
						return null;
					};
					Container.prototype.getLastVisibleRenderedItem = function () {
						if (this.renderedElement && this._renderedItems && this._renderedItems.length > 0) {
							for (var i = this._renderedItems.length - 1; i >= 0; i--) {
								if (this._renderedItems[i].isVisible) {
									return this._renderedItems[i];
								}
							}
						}
						return null;
					};
					Container.prototype.getJsonTypeName = function () {
						return "Container";
					};
					Container.prototype.isFirstElement = function (element) {
						var designMode = this.isDesignMode();
						for (var i = 0; i < this._items.length; i++) {
							if (this._items[i].isVisible || designMode) {
								return this._items[i] == element;
							}
						}
						return false;
					};
					Container.prototype.isLastElement = function (element) {
						var designMode = this.isDesignMode();
						for (var i = this._items.length - 1; i >= 0; i--) {
							if (this._items[i].isVisible || designMode) {
								return this._items[i] == element;
							}
						}
						return false;
					};
					Container.prototype.isRtl = function () {
						if (this.rtl != null) {
							return this.rtl;
						}
						else {
							var parentContainer = this.getParentContainer();
							return parentContainer ? parentContainer.isRtl() : false;
						}
					};
					Container.prototype.isBleedingAtTop = function () {
						var firstRenderedItem = this.getFirstVisibleRenderedItem();
						return this.isBleeding() || (firstRenderedItem ? firstRenderedItem.isBleedingAtTop() : false);
					};
					Container.prototype.isBleedingAtBottom = function () {
						var lastRenderedItem = this.getLastVisibleRenderedItem();
						return this.isBleeding() || (lastRenderedItem ? lastRenderedItem.isBleedingAtBottom() && lastRenderedItem.getEffectiveStyle() == this.getEffectiveStyle() : false);
					};
					Container.prototype.parse = function (json, errors) {
						_super.prototype.parse.call(this, json, errors);
						this.setShouldFallback(false);
						this._items = [];
						this._renderedItems = [];
						this.backgroundImage.reset();
						var jsonBackgroundImage = json["backgroundImage"];
						if (jsonBackgroundImage) {
							if (typeof jsonBackgroundImage === "string") {
								this.backgroundImage.url = jsonBackgroundImage;
								this.backgroundImage.fillMode = Enums.FillMode.Cover;
							}
							else if (typeof jsonBackgroundImage === "object") {
								this.backgroundImage.parse(jsonBackgroundImage, errors);
							}
						}
						this.verticalContentAlignment = Utils.getEnumValue(Enums.VerticalAlignment, json["verticalContentAlignment"], this.verticalContentAlignment);
						if (json[this.getItemsCollectionPropertyName()] != null) {
							var items = json[this.getItemsCollectionPropertyName()];
							this.clear();
							for (var i = 0; i < items.length; i++) {
								var element = createElementInstance(this, items[i], !this.isDesignMode(), errors);
								if (element) {
									this.insertItemAt(element, -1, true);
								}
							}
						}
						this.bleed = Utils.getBoolValue(json["bleed"], this.bleed);
					};
					Container.prototype.indexOf = function (cardElement) {
						return this._items.indexOf(cardElement);
					};
					Container.prototype.addItem = function (item) {
						this.insertItemAt(item, -1, false);
					};
					Container.prototype.insertItemBefore = function (item, insertBefore) {
						this.insertItemAt(item, this._items.indexOf(insertBefore), false);
					};
					Container.prototype.insertItemAfter = function (item, insertAfter) {
						this.insertItemAt(item, this._items.indexOf(insertAfter) + 1, false);
					};
					Container.prototype.removeItem = function (item) {
						var itemIndex = this._items.indexOf(item);
						if (itemIndex >= 0) {
							this._items.splice(itemIndex, 1);
							item.setParent(null);
							this.updateLayout();
							return true;
						}
						return false;
					};
					Container.prototype.clear = function () {
						this._items = [];
					};
					Container.prototype.getResourceInformation = function () {
						var result = _super.prototype.getResourceInformation.call(this);
						if (this.backgroundImage.isValid()) {
							result.push({ url: this.backgroundImage.url, mimeType: "image" });
						}
						return result;
					};
					Container.prototype.getActionById = function (id) {
						var result = _super.prototype.getActionById.call(this, id);
						if (!result) {
							if (this.selectAction) {
								result = this.selectAction.getActionById(id);
							}
							if (!result) {
								for (var i = 0; i < this._items.length; i++) {
									result = this._items[i].getActionById(id);
									if (result) {
										break;
									}
								}
							}
						}
						return result;
					};
					Object.defineProperty(Container.prototype, "padding", {
						get: function () {
							return this.getPadding();
						},
						set: function (value) {
							this.setPadding(value);
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(Container.prototype, "selectAction", {
						get: function () {
							return this.getSelectAction();
						},
						set: function (value) {
							this.setSelectAction(value);
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(Container.prototype, "bleed", {
						get: function () {
							return this.getBleed();
						},
						set: function (value) {
							this.setBleed(value);
						},
						enumerable: true,
						configurable: true
					});
					return Container;
				}(StylableCardElementContainer));
				exports.Container = Container;
				var Column = /** @class */ (function (_super) {
					__extends(Column, _super);
					function Column(width) {
						if (width === void 0) { width = "auto"; }
						var _this = _super.call(this) || this;
						_this._computedWeight = 0;
						_this.width = "auto";
						_this.width = width;
						return _this;
					}
					Column.prototype.adjustRenderedElementSize = function (renderedElement) {
						var minDesignTimeColumnHeight = 20;
						if (this.isDesignMode()) {
							renderedElement.style.minWidth = "20px";
							renderedElement.style.minHeight = (!this.minPixelHeight ? minDesignTimeColumnHeight : Math.max(this.minPixelHeight, minDesignTimeColumnHeight)) + "px";
						}
						else {
							renderedElement.style.minWidth = "0";
							if (this.minPixelHeight) {
								renderedElement.style.minHeight = this.minPixelHeight + "px";
							}
						}
						if (this.width === "auto") {
							renderedElement.style.flex = "0 1 auto";
						}
						else if (this.width === "stretch") {
							renderedElement.style.flex = "1 1 50px";
						}
						else {
							var sizeAndUnit = this.width;
							if (sizeAndUnit.unit == Enums.SizeUnit.Pixel) {
								renderedElement.style.flex = "0 0 auto";
								renderedElement.style.width = sizeAndUnit.physicalSize + "px";
							}
							else {
								renderedElement.style.flex = "1 1 " + (this._computedWeight > 0 ? this._computedWeight : sizeAndUnit.physicalSize) + "%";
							}
						}
					};
					Object.defineProperty(Column.prototype, "separatorOrientation", {
						get: function () {
							return Enums.Orientation.Vertical;
						},
						enumerable: true,
						configurable: true
					});
					Column.prototype.getJsonTypeName = function () {
						return "Column";
					};
					Column.prototype.toJSON = function () {
						var result = _super.prototype.toJSON.call(this);
						if (this.width instanceof Shared.SizeAndUnit) {
							if (this.width.unit == Enums.SizeUnit.Pixel) {
								Utils.setProperty(result, "width", this.width.physicalSize + "px");
							}
							else {
								Utils.setProperty(result, "width", this.width.physicalSize);
							}
						}
						else {
							Utils.setProperty(result, "width", this.width);
						}
						return result;
					};
					Column.prototype.parse = function (json, errors) {
						_super.prototype.parse.call(this, json, errors);
						var jsonWidth = json["width"];
						if (jsonWidth === undefined) {
							jsonWidth = json["size"];
							if (jsonWidth !== undefined) {
								raiseParseError({
									error: Enums.ValidationError.Deprecated,
									message: "The \"Column.size\" property is deprecated and will be removed. Use the \"Column.width\" property instead."
								}, errors);
							}
						}
						if (jsonWidth) {
							var invalidWidth = false;
							try {
								this.width = Shared.SizeAndUnit.parse(jsonWidth);
							}
							catch (e) {
								if (typeof jsonWidth === "string" && (jsonWidth === "auto" || jsonWidth === "stretch")) {
									this.width = jsonWidth;
								}
								else {
									invalidWidth = true;
								}
							}
							if (invalidWidth) {
								raiseParseError({
									error: Enums.ValidationError.InvalidPropertyValue,
									message: "Invalid column width:" + jsonWidth + " - defaulting to \"auto\""
								}, errors);
							}
						}
					};
					Object.defineProperty(Column.prototype, "hasVisibleSeparator", {
						get: function () {
							if (this.parent && this.parent instanceof ColumnSet) {
								return this.separatorElement && !this.parent.isLeftMostElement(this);
							}
							else {
								return false;
							}
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(Column.prototype, "isStandalone", {
						get: function () {
							return false;
						},
						enumerable: true,
						configurable: true
					});
					return Column;
				}(Container));
				exports.Column = Column;
				var ColumnSet = /** @class */ (function (_super) {
					__extends(ColumnSet, _super);
					function ColumnSet() {
						var _this = _super !== null && _super.apply(this, arguments) || this;
						_this._columns = [];
						return _this;
					}
					ColumnSet.prototype.createColumnInstance = function (json, errors) {
						return createCardObjectInstance(this, json, [], // Forbidden types not supported for elements for now
							!this.isDesignMode(), function (typeName) {
								return !typeName || typeName === "Column" ? new Column() : null;
							}, function (typeName, errorType) {
								if (errorType == InstanceCreationErrorType.UnknownType) {
									return {
										error: Enums.ValidationError.UnknownElementType,
										message: "Unknown element type: " + typeName + ". Fallback will be used if present."
									};
								}
								else {
									return {
										error: Enums.ValidationError.ElementTypeNotAllowed,
										message: "Element type " + typeName + " isn't allowed in a ColumnSet."
									};
								}
							}, errors);
					};
					ColumnSet.prototype.internalRender = function () {
						this._renderedColumns = [];
						if (this._columns.length > 0) {
							// Cache hostConfig to avoid walking the parent hierarchy several times
							var hostConfig = this.hostConfig;
							var element = document.createElement("div");
							element.className = hostConfig.makeCssClassName("ac-columnSet");
							element.style.display = "flex";
							if (AdaptiveCard.useAdvancedCardBottomTruncation) {
								// See comment in Container.internalRender()
								element.style.minHeight = '-webkit-min-content';
							}
							switch (this.horizontalAlignment) {
								case Enums.HorizontalAlignment.Center:
									element.style.justifyContent = "center";
									break;
								case Enums.HorizontalAlignment.Right:
									element.style.justifyContent = "flex-end";
									break;
								default:
									element.style.justifyContent = "flex-start";
									break;
							}
							var totalWeight = 0;
							for (var _i = 0, _a = this._columns; _i < _a.length; _i++) {
								var column = _a[_i];
								if (column.width instanceof Shared.SizeAndUnit && (column.width.unit == Enums.SizeUnit.Weight)) {
									totalWeight += column.width.physicalSize;
								}
							}
							for (var _b = 0, _c = this._columns; _b < _c.length; _b++) {
								var column = _c[_b];
								if (column.width instanceof Shared.SizeAndUnit && column.width.unit == Enums.SizeUnit.Weight && totalWeight > 0) {
									var computedWeight = 100 / totalWeight * column.width.physicalSize;
									// Best way to emulate "internal" access I know of
									column["_computedWeight"] = computedWeight;
								}
								var renderedColumn = column.render();
								if (renderedColumn) {
									if (this._renderedColumns.length > 0 && column.separatorElement) {
										column.separatorElement.style.flex = "0 0 auto";
										Utils.appendChild(element, column.separatorElement);
									}
									Utils.appendChild(element, renderedColumn);
									this._renderedColumns.push(column);
								}
							}
							return this._renderedColumns.length > 0 ? element : null;
						}
						else {
							return null;
						}
					};
					ColumnSet.prototype.truncateOverflow = function (maxHeight) {
						for (var _i = 0, _a = this._columns; _i < _a.length; _i++) {
							var column = _a[_i];
							column['handleOverflow'](maxHeight);
						}
						return true;
					};
					ColumnSet.prototype.undoOverflowTruncation = function () {
						for (var _i = 0, _a = this._columns; _i < _a.length; _i++) {
							var column = _a[_i];
							column['resetOverflow']();
						}
					};
					Object.defineProperty(ColumnSet.prototype, "isSelectable", {
						get: function () {
							return true;
						},
						enumerable: true,
						configurable: true
					});
					ColumnSet.prototype.toJSON = function () {
						var result = _super.prototype.toJSON.call(this);
						if (this._columns.length > 0) {
							var columns = [];
							for (var _i = 0, _a = this._columns; _i < _a.length; _i++) {
								var column = _a[_i];
								columns.push(column.toJSON());
							}
							Utils.setProperty(result, "columns", columns);
						}
						Utils.setProperty(result, "bleed", this.bleed, false);
						return result;
					};
					ColumnSet.prototype.isFirstElement = function (element) {
						for (var i = 0; i < this._columns.length; i++) {
							if (this._columns[i].isVisible) {
								return this._columns[i] == element;
							}
						}
						return false;
					};
					ColumnSet.prototype.isBleedingAtTop = function () {
						if (this.isBleeding()) {
							return true;
						}
						if (this._renderedColumns && this._renderedColumns.length > 0) {
							for (var _i = 0, _a = this._columns; _i < _a.length; _i++) {
								var column = _a[_i];
								if (column.isBleedingAtTop()) {
									return true;
								}
							}
						}
						return false;
					};
					ColumnSet.prototype.isBleedingAtBottom = function () {
						if (this.isBleeding()) {
							return true;
						}
						if (this._renderedColumns && this._renderedColumns.length > 0) {
							for (var _i = 0, _a = this._columns; _i < _a.length; _i++) {
								var column = _a[_i];
								if (column.isBleedingAtBottom()) {
									return true;
								}
							}
						}
						return false;
					};
					ColumnSet.prototype.getCount = function () {
						return this._columns.length;
					};
					ColumnSet.prototype.getItemCount = function () {
						return this.getCount();
					};
					ColumnSet.prototype.getFirstVisibleRenderedItem = function () {
						if (this.renderedElement && this._renderedColumns && this._renderedColumns.length > 0) {
							return this._renderedColumns[0];
						}
						else {
							return null;
						}
					};
					ColumnSet.prototype.getLastVisibleRenderedItem = function () {
						if (this.renderedElement && this._renderedColumns && this._renderedColumns.length > 0) {
							return this._renderedColumns[this._renderedColumns.length - 1];
						}
						else {
							return null;
						}
					};
					ColumnSet.prototype.getColumnAt = function (index) {
						return this._columns[index];
					};
					ColumnSet.prototype.getItemAt = function (index) {
						return this.getColumnAt(index);
					};
					ColumnSet.prototype.getJsonTypeName = function () {
						return "ColumnSet";
					};
					ColumnSet.prototype.parse = function (json, errors) {
						_super.prototype.parse.call(this, json, errors);
						if (json["columns"] != null) {
							var jsonColumns = json["columns"];
							this._columns = [];
							for (var i = 0; i < jsonColumns.length; i++) {
								var column = this.createColumnInstance(jsonColumns[i], errors);
								this._columns.push(column);
							}
						}
						this.bleed = Utils.getBoolValue(json["bleed"], this.bleed);
					};
					ColumnSet.prototype.internalValidateProperties = function (context) {
						_super.prototype.internalValidateProperties.call(this, context);
						var weightedColumns = 0;
						var stretchedColumns = 0;
						for (var _i = 0, _a = this._columns; _i < _a.length; _i++) {
							var column = _a[_i];
							if (typeof column.width === "number") {
								weightedColumns++;
							}
							else if (column.width === "stretch") {
								stretchedColumns++;
							}
						}
						if (weightedColumns > 0 && stretchedColumns > 0) {
							context.addFailure(this, {
								error: Enums.ValidationError.Hint,
								message: "It is not recommended to use weighted and stretched columns in the same ColumnSet, because in such a situation stretched columns will always get the minimum amount of space."
							});
						}
					};
					ColumnSet.prototype.addColumn = function (column) {
						if (!column.parent) {
							this._columns.push(column);
							column.setParent(this);
						}
						else {
							throw new Error("This column already belongs to another ColumnSet.");
						}
					};
					ColumnSet.prototype.removeItem = function (item) {
						if (item instanceof Column) {
							var itemIndex = this._columns.indexOf(item);
							if (itemIndex >= 0) {
								this._columns.splice(itemIndex, 1);
								item.setParent(null);
								this.updateLayout();
								return true;
							}
						}
						return false;
					};
					ColumnSet.prototype.indexOf = function (cardElement) {
						return cardElement instanceof Column ? this._columns.indexOf(cardElement) : -1;
					};
					ColumnSet.prototype.isLeftMostElement = function (element) {
						return this._columns.indexOf(element) == 0;
					};
					ColumnSet.prototype.isRightMostElement = function (element) {
						return this._columns.indexOf(element) == this._columns.length - 1;
					};
					ColumnSet.prototype.isTopElement = function (element) {
						return this._columns.indexOf(element) >= 0;
					};
					ColumnSet.prototype.isBottomElement = function (element) {
						return this._columns.indexOf(element) >= 0;
					};
					ColumnSet.prototype.getActionById = function (id) {
						var result = null;
						for (var i = 0; i < this._columns.length; i++) {
							result = this._columns[i].getActionById(id);
							if (result) {
								break;
							}
						}
						return result;
					};
					Object.defineProperty(ColumnSet.prototype, "bleed", {
						get: function () {
							return this.getBleed();
						},
						set: function (value) {
							this.setBleed(value);
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(ColumnSet.prototype, "padding", {
						get: function () {
							return this.getPadding();
						},
						set: function (value) {
							this.setPadding(value);
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(ColumnSet.prototype, "selectAction", {
						get: function () {
							return this.getSelectAction();
						},
						set: function (value) {
							this.setSelectAction(value);
						},
						enumerable: true,
						configurable: true
					});
					return ColumnSet;
				}(StylableCardElementContainer));
				exports.ColumnSet = ColumnSet;
				function raiseImageLoadedEvent(image) {
					var card = image.getRootElement();
					var onImageLoadedHandler = (card && card.onImageLoaded) ? card.onImageLoaded : AdaptiveCard.onImageLoaded;
					if (onImageLoadedHandler) {
						onImageLoadedHandler(image);
					}
				}
				function raiseAnchorClickedEvent(element, anchor) {
					var card = element.getRootElement();
					var onAnchorClickedHandler = (card && card.onAnchorClicked) ? card.onAnchorClicked : AdaptiveCard.onAnchorClicked;
					return onAnchorClickedHandler != null ? onAnchorClickedHandler(element, anchor) : false;
				}
				function raiseExecuteActionEvent(action) {
					var card = action.parent.getRootElement();
					var onExecuteActionHandler = (card && card.onExecuteAction) ? card.onExecuteAction : AdaptiveCard.onExecuteAction;
					if (onExecuteActionHandler) {
						if (action.prepareForExecution()) {
							onExecuteActionHandler(action);
						}
					}
				}
				function raiseInlineCardExpandedEvent(action, isExpanded) {
					var card = action.parent.getRootElement();
					var onInlineCardExpandedHandler = (card && card.onInlineCardExpanded) ? card.onInlineCardExpanded : AdaptiveCard.onInlineCardExpanded;
					if (onInlineCardExpandedHandler) {
						onInlineCardExpandedHandler(action, isExpanded);
					}
				}
				function raiseInputValueChangedEvent(input) {
					var card = input.getRootElement();
					var onInputValueChangedHandler = (card && card.onInputValueChanged) ? card.onInputValueChanged : AdaptiveCard.onInputValueChanged;
					if (onInputValueChangedHandler) {
						onInputValueChangedHandler(input);
					}
				}
				function raiseElementVisibilityChangedEvent(element, shouldUpdateLayout) {
					if (shouldUpdateLayout === void 0) { shouldUpdateLayout = true; }
					var rootElement = element.getRootElement();
					if (shouldUpdateLayout) {
						rootElement.updateLayout();
					}
					var card = rootElement;
					var onElementVisibilityChangedHandler = (card && card.onElementVisibilityChanged) ? card.onElementVisibilityChanged : AdaptiveCard.onElementVisibilityChanged;
					if (onElementVisibilityChangedHandler != null) {
						onElementVisibilityChangedHandler(element);
					}
				}
				function raiseParseElementEvent(element, json, errors) {
					var card = element.getRootElement();
					var onParseElementHandler = (card && card.onParseElement) ? card.onParseElement : AdaptiveCard.onParseElement;
					if (onParseElementHandler != null) {
						onParseElementHandler(element, json, errors);
					}
				}
				function raiseParseActionEvent(action, json, errors) {
					var card = action.parent ? action.parent.getRootElement() : null;
					var onParseActionHandler = (card && card.onParseAction) ? card.onParseAction : AdaptiveCard.onParseAction;
					if (onParseActionHandler != null) {
						onParseActionHandler(action, json, errors);
					}
				}
				function raiseParseError(error, errors) {
					if (errors) {
						errors.push(error);
					}
					if (AdaptiveCard.onParseError != null) {
						AdaptiveCard.onParseError(error);
					}
				}
				var ContainerWithActions = /** @class */ (function (_super) {
					__extends(ContainerWithActions, _super);
					function ContainerWithActions() {
						var _this = _super.call(this) || this;
						_this._actionCollection = new ActionCollection(_this);
						return _this;
					}
					ContainerWithActions.prototype.internalRender = function () {
						var element = _super.prototype.internalRender.call(this);
						var renderedActions = this._actionCollection.render(this.hostConfig.actions.actionsOrientation, false);
						if (renderedActions) {
							Utils.appendChild(element, Utils.renderSeparation(this.hostConfig, {
								spacing: this.hostConfig.getEffectiveSpacing(this.hostConfig.actions.spacing),
								lineThickness: null,
								lineColor: null
							}, Enums.Orientation.Horizontal));
							Utils.appendChild(element, renderedActions);
						}
						if (this.renderIfEmpty) {
							return element;
						}
						else {
							return element.children.length > 0 ? element : null;
						}
					};
					ContainerWithActions.prototype.getHasExpandedAction = function () {
						if (this.renderedActionCount == 0) {
							return false;
						}
						else if (this.renderedActionCount == 1) {
							return this._actionCollection.expandedAction != null && !this.hostConfig.actions.preExpandSingleShowCardAction;
						}
						else {
							return this._actionCollection.expandedAction != null;
						}
					};
					Object.defineProperty(ContainerWithActions.prototype, "renderedActionCount", {
						get: function () {
							return this._actionCollection.renderedActionCount;
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(ContainerWithActions.prototype, "renderIfEmpty", {
						get: function () {
							return false;
						},
						enumerable: true,
						configurable: true
					});
					ContainerWithActions.prototype.toJSON = function () {
						var result = _super.prototype.toJSON.call(this);
						Utils.setProperty(result, "actions", this._actionCollection.toJSON());
						return result;
					};
					ContainerWithActions.prototype.getActionCount = function () {
						return this._actionCollection.items.length;
					};
					ContainerWithActions.prototype.getActionAt = function (index) {
						if (index >= 0 && index < this.getActionCount()) {
							return this._actionCollection.items[index];
						}
						else {
							_super.prototype.getActionAt.call(this, index);
						}
					};
					ContainerWithActions.prototype.getActionById = function (id) {
						var result = this._actionCollection.getActionById(id);
						return result ? result : _super.prototype.getActionById.call(this, id);
					};
					ContainerWithActions.prototype.parse = function (json, errors) {
						_super.prototype.parse.call(this, json, errors);
						this._actionCollection.parse(json["actions"], errors);
					};
					ContainerWithActions.prototype.internalValidateProperties = function (context) {
						_super.prototype.internalValidateProperties.call(this, context);
						if (this._actionCollection) {
							this._actionCollection.validateProperties(context);
						}
					};
					ContainerWithActions.prototype.isLastElement = function (element) {
						return _super.prototype.isLastElement.call(this, element) && this._actionCollection.items.length == 0;
					};
					ContainerWithActions.prototype.addAction = function (action) {
						this._actionCollection.addAction(action);
					};
					ContainerWithActions.prototype.clear = function () {
						_super.prototype.clear.call(this);
						this._actionCollection.clear();
					};
					ContainerWithActions.prototype.getAllInputs = function () {
						return _super.prototype.getAllInputs.call(this).concat(this._actionCollection.getAllInputs());
					};
					ContainerWithActions.prototype.getResourceInformation = function () {
						return _super.prototype.getResourceInformation.call(this).concat(this._actionCollection.getResourceInformation());
					};
					ContainerWithActions.prototype.isBleedingAtBottom = function () {
						if (this._actionCollection.renderedActionCount == 0) {
							return _super.prototype.isBleedingAtBottom.call(this);
						}
						else {
							if (this._actionCollection.items.length == 1) {
								return this._actionCollection.expandedAction != null && !this.hostConfig.actions.preExpandSingleShowCardAction;
							}
							else {
								return this._actionCollection.expandedAction != null;
							}
						}
					};
					Object.defineProperty(ContainerWithActions.prototype, "isStandalone", {
						get: function () {
							return false;
						},
						enumerable: true,
						configurable: true
					});
					return ContainerWithActions;
				}(Container));
				exports.ContainerWithActions = ContainerWithActions;
				var TypeRegistry = /** @class */ (function () {
					function TypeRegistry() {
						this._items = [];
						this.reset();
					}
					TypeRegistry.prototype.findTypeRegistration = function (typeName) {
						for (var i = 0; i < this._items.length; i++) {
							if (this._items[i].typeName === typeName) {
								return this._items[i];
							}
						}
						return null;
					};
					TypeRegistry.prototype.clear = function () {
						this._items = [];
					};
					TypeRegistry.prototype.registerType = function (typeName, createInstance) {
						var registrationInfo = this.findTypeRegistration(typeName);
						if (registrationInfo != null) {
							registrationInfo.createInstance = createInstance;
						}
						else {
							registrationInfo = {
								typeName: typeName,
								createInstance: createInstance
							};
							this._items.push(registrationInfo);
						}
					};
					TypeRegistry.prototype.unregisterType = function (typeName) {
						for (var i = 0; i < this._items.length; i++) {
							if (this._items[i].typeName === typeName) {
								this._items.splice(i, 1);
								return;
							}
						}
					};
					TypeRegistry.prototype.createInstance = function (typeName) {
						var registrationInfo = this.findTypeRegistration(typeName);
						return registrationInfo ? registrationInfo.createInstance() : null;
					};
					TypeRegistry.prototype.getItemCount = function () {
						return this._items.length;
					};
					TypeRegistry.prototype.getItemAt = function (index) {
						return this._items[index];
					};
					return TypeRegistry;
				}());
				exports.TypeRegistry = TypeRegistry;
				var ElementTypeRegistry = /** @class */ (function (_super) {
					__extends(ElementTypeRegistry, _super);
					function ElementTypeRegistry() {
						return _super !== null && _super.apply(this, arguments) || this;
					}
					ElementTypeRegistry.prototype.reset = function () {
						this.clear();
						this.registerType("Container", function () { return new Container(); });
						this.registerType("TextBlock", function () { return new TextBlock(); });
						this.registerType("RichTextBlock", function () { return new RichTextBlock(); });
						this.registerType("TextRun", function () { return new TextRun(); });
						this.registerType("Image", function () { return new Image(); });
						this.registerType("ImageSet", function () { return new ImageSet(); });
						this.registerType("Media", function () { return new Media(); });
						this.registerType("FactSet", function () { return new FactSet(); });
						this.registerType("ColumnSet", function () { return new ColumnSet(); });
						this.registerType("ActionSet", function () { return new ActionSet(); });
						this.registerType("Input.Text", function () { return new TextInput(); });
						this.registerType("Input.Date", function () { return new DateInput(); });
						this.registerType("Input.Time", function () { return new TimeInput(); });
						this.registerType("Input.Number", function () { return new NumberInput(); });
						this.registerType("Input.ChoiceSet", function () { return new ChoiceSetInput(); });
						this.registerType("Input.Toggle", function () { return new ToggleInput(); });
					};
					return ElementTypeRegistry;
				}(TypeRegistry));
				exports.ElementTypeRegistry = ElementTypeRegistry;
				var ActionTypeRegistry = /** @class */ (function (_super) {
					__extends(ActionTypeRegistry, _super);
					function ActionTypeRegistry() {
						return _super !== null && _super.apply(this, arguments) || this;
					}
					ActionTypeRegistry.prototype.reset = function () {
						this.clear();
						this.registerType(OpenUrlAction.JsonTypeName, function () { return new OpenUrlAction(); });
						this.registerType(SubmitAction.JsonTypeName, function () { return new SubmitAction(); });
						this.registerType(ShowCardAction.JsonTypeName, function () { return new ShowCardAction(); });
						this.registerType(ToggleVisibilityAction.JsonTypeName, function () { return new ToggleVisibilityAction(); });
					};
					return ActionTypeRegistry;
				}(TypeRegistry));
				exports.ActionTypeRegistry = ActionTypeRegistry;
				var AdaptiveCard = /** @class */ (function (_super) {
					__extends(AdaptiveCard, _super);
					function AdaptiveCard() {
						var _this = _super !== null && _super.apply(this, arguments) || this;
						_this._cardTypeName = "AdaptiveCard";
						_this._fallbackCard = null;
						_this.onAnchorClicked = null;
						_this.onExecuteAction = null;
						_this.onElementVisibilityChanged = null;
						_this.onImageLoaded = null;
						_this.onInlineCardExpanded = null;
						_this.onInputValueChanged = null;
						_this.onParseElement = null;
						_this.onParseAction = null;
						_this.version = new HostConfig.Version(1, 0);
						_this.designMode = false;
						return _this;
					}
					Object.defineProperty(AdaptiveCard, "processMarkdown", {
						get: function () {
							throw new Error("The processMarkdown event has been removed. Please update your code and set onProcessMarkdown instead.");
						},
						set: function (value) {
							throw new Error("The processMarkdown event has been removed. Please update your code and set onProcessMarkdown instead.");
						},
						enumerable: true,
						configurable: true
					});
					AdaptiveCard.applyMarkdown = function (text) {
						var result = {
							didProcess: false
						};
						if (AdaptiveCard.onProcessMarkdown) {
							AdaptiveCard.onProcessMarkdown(text, result);
						}
						else if (window["markdownit"]) {
							// Check for markdownit
							result.outputHtml = window["markdownit"]().render(text);
							result.didProcess = true;
						}
						else {
							console.warn("Markdown processing isn't enabled. Please see https://www.npmjs.com/package/adaptivecards#supporting-markdown");
						}
						return result;
					};
					AdaptiveCard.prototype.isVersionSupported = function () {
						if (this.bypassVersionCheck) {
							return true;
						}
						else {
							var unsupportedVersion = !this.version ||
								!this.version.isValid ||
								(AdaptiveCard.currentVersion.major < this.version.major) ||
								(AdaptiveCard.currentVersion.major == this.version.major && AdaptiveCard.currentVersion.minor < this.version.minor);
							return !unsupportedVersion;
						}
					};
					AdaptiveCard.prototype.getItemsCollectionPropertyName = function () {
						return "body";
					};
					AdaptiveCard.prototype.internalRender = function () {
						var renderedElement = _super.prototype.internalRender.call(this);
						if (AdaptiveCard.useAdvancedCardBottomTruncation) {
							// Unlike containers, the root card element should be allowed to
							// be shorter than its content (otherwise the overflow truncation
							// logic would never get triggered)
							renderedElement.style.minHeight = null;
						}
						return renderedElement;
					};
					AdaptiveCard.prototype.getHasBackground = function () {
						return true;
					};
					AdaptiveCard.prototype.getDefaultPadding = function () {
						return new Shared.PaddingDefinition(Enums.Spacing.Padding, Enums.Spacing.Padding, Enums.Spacing.Padding, Enums.Spacing.Padding);
					};
					Object.defineProperty(AdaptiveCard.prototype, "renderIfEmpty", {
						get: function () {
							return true;
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(AdaptiveCard.prototype, "bypassVersionCheck", {
						get: function () {
							return false;
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(AdaptiveCard.prototype, "allowCustomStyle", {
						get: function () {
							return this.hostConfig.adaptiveCard && this.hostConfig.adaptiveCard.allowCustomStyle;
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(AdaptiveCard.prototype, "hasBackground", {
						get: function () {
							return true;
						},
						enumerable: true,
						configurable: true
					});
					AdaptiveCard.prototype.getJsonTypeName = function () {
						return "AdaptiveCard";
					};
					AdaptiveCard.prototype.toJSON = function () {
						var result = _super.prototype.toJSON.call(this);
						Utils.setProperty(result, "$schema", "http://adaptivecards.io/schemas/adaptive-card.json");
						if (!this.bypassVersionCheck && this.version) {
							Utils.setProperty(result, "version", this.version.toString());
						}
						Utils.setProperty(result, "fallbackText", this.fallbackText);
						Utils.setProperty(result, "lang", this.lang);
						Utils.setProperty(result, "speak", this.speak);
						return result;
					};
					AdaptiveCard.prototype.internalValidateProperties = function (context) {
						_super.prototype.internalValidateProperties.call(this, context);
						if (this._cardTypeName != "AdaptiveCard") {
							context.addFailure(this, {
								error: Enums.ValidationError.MissingCardType,
								message: "Invalid or missing card type. Make sure the card's type property is set to \"AdaptiveCard\"."
							});
						}
						if (!this.bypassVersionCheck && !this.version) {
							context.addFailure(this, {
								error: Enums.ValidationError.PropertyCantBeNull,
								message: "The version property must be specified."
							});
						}
						else if (!this.isVersionSupported()) {
							context.addFailure(this, {
								error: Enums.ValidationError.UnsupportedCardVersion,
								message: "The specified card version (" + this.version + ") is not supported. The maximum supported card version is " + AdaptiveCard.currentVersion
							});
						}
					};
					AdaptiveCard.prototype.parse = function (json, errors) {
						this._fallbackCard = null;
						this._cardTypeName = Utils.getStringValue(json["type"]);
						this.speak = Utils.getStringValue(json["speak"]);
						var langId = Utils.getStringValue(json["lang"]);
						if (langId && typeof langId === "string") {
							try {
								this.lang = langId;
							}
							catch (e) {
								raiseParseError({
									error: Enums.ValidationError.InvalidPropertyValue,
									message: e.message
								}, errors);
							}
						}
						this.version = HostConfig.Version.parse(json["version"], errors);
						this.fallbackText = Utils.getStringValue(json["fallbackText"]);
						var fallbackElement = createElementInstance(null, json["fallback"], !this.isDesignMode(), errors);
						if (fallbackElement) {
							this._fallbackCard = new AdaptiveCard();
							this._fallbackCard.addItem(fallbackElement);
						}
						_super.prototype.parse.call(this, json, errors);
					};
					AdaptiveCard.prototype.render = function (target) {
						var renderedCard;
						if (this.shouldFallback() && this._fallbackCard) {
							this._fallbackCard.hostConfig = this.hostConfig;
							renderedCard = this._fallbackCard.render();
						}
						else {
							renderedCard = _super.prototype.render.call(this);
							if (renderedCard) {
								renderedCard.classList.add(this.hostConfig.makeCssClassName("ac-adaptiveCard"));
								renderedCard.tabIndex = 0;
								if (!Utils.isNullOrEmpty(this.speak)) {
									renderedCard.setAttribute("aria-label", this.speak);
								}
							}
						}
						if (target) {
							target.appendChild(renderedCard);
							this.updateLayout();
						}
						return renderedCard;
					};
					AdaptiveCard.prototype.updateLayout = function (processChildren) {
						if (processChildren === void 0) { processChildren = true; }
						_super.prototype.updateLayout.call(this, processChildren);
						if (AdaptiveCard.useAdvancedCardBottomTruncation && this.isRendered()) {
							var card = this.renderedElement;
							var padding = this.hostConfig.getEffectiveSpacing(Enums.Spacing.Default);
							this['handleOverflow'](card.offsetHeight - padding);
						}
					};
					AdaptiveCard.prototype.shouldFallback = function () {
						return _super.prototype.shouldFallback.call(this) || !this.isVersionSupported();
					};
					Object.defineProperty(AdaptiveCard.prototype, "hasVisibleSeparator", {
						get: function () {
							return false;
						},
						enumerable: true,
						configurable: true
					});
					AdaptiveCard.currentVersion = new HostConfig.Version(1, 2);
					AdaptiveCard.useAdvancedTextBlockTruncation = true;
					AdaptiveCard.useAdvancedCardBottomTruncation = false;
					AdaptiveCard.useMarkdownInRadioButtonAndCheckbox = true;
					AdaptiveCard.allowMarkForTextHighlighting = false;
					AdaptiveCard.alwaysBleedSeparators = false;
					AdaptiveCard.enableFullJsonRoundTrip = false;
					AdaptiveCard.useBuiltInInputValidation = true;
					AdaptiveCard.displayInputValidationErrors = true;
					AdaptiveCard.elementTypeRegistry = new ElementTypeRegistry();
					AdaptiveCard.actionTypeRegistry = new ActionTypeRegistry();
					AdaptiveCard.onAnchorClicked = null;
					AdaptiveCard.onExecuteAction = null;
					AdaptiveCard.onElementVisibilityChanged = null;
					AdaptiveCard.onImageLoaded = null;
					AdaptiveCard.onInlineCardExpanded = null;
					AdaptiveCard.onInputValueChanged = null;
					AdaptiveCard.onParseElement = null;
					AdaptiveCard.onParseAction = null;
					AdaptiveCard.onParseError = null;
					AdaptiveCard.onProcessMarkdown = null;
					return AdaptiveCard;
				}(ContainerWithActions));
				exports.AdaptiveCard = AdaptiveCard;
				var InlineAdaptiveCard = /** @class */ (function (_super) {
					__extends(InlineAdaptiveCard, _super);
					function InlineAdaptiveCard() {
						var _this = _super !== null && _super.apply(this, arguments) || this;
						_this.suppressStyle = false;
						return _this;
					}
					InlineAdaptiveCard.prototype.getDefaultPadding = function () {
						return new Shared.PaddingDefinition(this.suppressStyle ? Enums.Spacing.None : Enums.Spacing.Padding, Enums.Spacing.Padding, this.suppressStyle ? Enums.Spacing.None : Enums.Spacing.Padding, Enums.Spacing.Padding);
					};
					Object.defineProperty(InlineAdaptiveCard.prototype, "bypassVersionCheck", {
						get: function () {
							return true;
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(InlineAdaptiveCard.prototype, "defaultStyle", {
						get: function () {
							if (this.suppressStyle) {
								return Enums.ContainerStyle.Default;
							}
							else {
								return this.hostConfig.actions.showCard.style ? this.hostConfig.actions.showCard.style : Enums.ContainerStyle.Emphasis;
							}
						},
						enumerable: true,
						configurable: true
					});
					InlineAdaptiveCard.prototype.render = function (target) {
						var renderedCard = _super.prototype.render.call(this, target);
						renderedCard.setAttribute("aria-live", "polite");
						renderedCard.removeAttribute("tabindex");
						return renderedCard;
					};
					InlineAdaptiveCard.prototype.getForbiddenActionTypes = function () {
						return [ShowCardAction];
					};
					return InlineAdaptiveCard;
				}(AdaptiveCard));
				var defaultHostConfig = new HostConfig.HostConfig({
					supportsInteractivity: true,
					spacing: {
						small: 10,
						default: 20,
						medium: 30,
						large: 40,
						extraLarge: 50,
						padding: 20
					},
					separator: {
						lineThickness: 1,
						lineColor: "#EEEEEE"
					},
					fontTypes: {
						default: {
							fontFamily: "'Segoe UI', Tahoma, Geneva, Verdana, sans-serif",
							fontSizes: {
								small: 12,
								default: 14,
								medium: 17,
								large: 21,
								extraLarge: 26
							},
							fontWeights: {
								lighter: 200,
								default: 400,
								bolder: 600
							}
						},
						monospace: {
							fontFamily: "'Courier New', Courier, monospace",
							fontSizes: {
								small: 12,
								default: 14,
								medium: 17,
								large: 21,
								extraLarge: 26
							},
							fontWeights: {
								lighter: 200,
								default: 400,
								bolder: 600
							}
						}
					},
					imageSizes: {
						small: 40,
						medium: 80,
						large: 160
					},
					containerStyles: {
						default: {
							backgroundColor: "#FFFFFF",
							foregroundColors: {
								default: {
									default: "#333333",
									subtle: "#EE333333"
								},
								dark: {
									default: "#000000",
									subtle: "#66000000"
								},
								light: {
									default: "#FFFFFF",
									subtle: "#33000000"
								},
								accent: {
									default: "#2E89FC",
									subtle: "#882E89FC"
								},
								attention: {
									default: "#cc3300",
									subtle: "#DDcc3300"
								},
								good: {
									default: "#54a254",
									subtle: "#DD54a254"
								},
								warning: {
									default: "#e69500",
									subtle: "#DDe69500"
								}
							}
						},
						emphasis: {
							backgroundColor: "#08000000",
							foregroundColors: {
								default: {
									default: "#333333",
									subtle: "#EE333333"
								},
								dark: {
									default: "#000000",
									subtle: "#66000000"
								},
								light: {
									default: "#FFFFFF",
									subtle: "#33000000"
								},
								accent: {
									default: "#2E89FC",
									subtle: "#882E89FC"
								},
								attention: {
									default: "#cc3300",
									subtle: "#DDcc3300"
								},
								good: {
									default: "#54a254",
									subtle: "#DD54a254"
								},
								warning: {
									default: "#e69500",
									subtle: "#DDe69500"
								}
							}
						},
						accent: {
							backgroundColor: "#C7DEF9",
							foregroundColors: {
								default: {
									default: "#333333",
									subtle: "#EE333333"
								},
								dark: {
									default: "#000000",
									subtle: "#66000000"
								},
								light: {
									default: "#FFFFFF",
									subtle: "#33000000"
								},
								accent: {
									default: "#2E89FC",
									subtle: "#882E89FC"
								},
								attention: {
									default: "#cc3300",
									subtle: "#DDcc3300"
								},
								good: {
									default: "#54a254",
									subtle: "#DD54a254"
								},
								warning: {
									default: "#e69500",
									subtle: "#DDe69500"
								}
							}
						},
						good: {
							backgroundColor: "#CCFFCC",
							foregroundColors: {
								default: {
									default: "#333333",
									subtle: "#EE333333"
								},
								dark: {
									default: "#000000",
									subtle: "#66000000"
								},
								light: {
									default: "#FFFFFF",
									subtle: "#33000000"
								},
								accent: {
									default: "#2E89FC",
									subtle: "#882E89FC"
								},
								attention: {
									default: "#cc3300",
									subtle: "#DDcc3300"
								},
								good: {
									default: "#54a254",
									subtle: "#DD54a254"
								},
								warning: {
									default: "#e69500",
									subtle: "#DDe69500"
								}
							}
						},
						attention: {
							backgroundColor: "#FFC5B2",
							foregroundColors: {
								default: {
									default: "#333333",
									subtle: "#EE333333"
								},
								dark: {
									default: "#000000",
									subtle: "#66000000"
								},
								light: {
									default: "#FFFFFF",
									subtle: "#33000000"
								},
								accent: {
									default: "#2E89FC",
									subtle: "#882E89FC"
								},
								attention: {
									default: "#cc3300",
									subtle: "#DDcc3300"
								},
								good: {
									default: "#54a254",
									subtle: "#DD54a254"
								},
								warning: {
									default: "#e69500",
									subtle: "#DDe69500"
								}
							}
						},
						warning: {
							backgroundColor: "#FFE2B2",
							foregroundColors: {
								default: {
									default: "#333333",
									subtle: "#EE333333"
								},
								dark: {
									default: "#000000",
									subtle: "#66000000"
								},
								light: {
									default: "#FFFFFF",
									subtle: "#33000000"
								},
								accent: {
									default: "#2E89FC",
									subtle: "#882E89FC"
								},
								attention: {
									default: "#cc3300",
									subtle: "#DDcc3300"
								},
								good: {
									default: "#54a254",
									subtle: "#DD54a254"
								},
								warning: {
									default: "#e69500",
									subtle: "#DDe69500"
								}
							}
						}
					},
					actions: {
						maxActions: 5,
						spacing: Enums.Spacing.Default,
						buttonSpacing: 10,
						showCard: {
							actionMode: Enums.ShowCardActionMode.Inline,
							inlineTopMargin: 16
						},
						actionsOrientation: Enums.Orientation.Horizontal,
						actionAlignment: Enums.ActionAlignment.Left
					},
					adaptiveCard: {
						allowCustomStyle: false
					},
					imageSet: {
						imageSize: Enums.Size.Medium,
						maxImageHeight: 100
					},
					factSet: {
						title: {
							color: Enums.TextColor.Default,
							size: Enums.TextSize.Default,
							isSubtle: false,
							weight: Enums.TextWeight.Bolder,
							wrap: true,
							maxWidth: 150,
						},
						value: {
							color: Enums.TextColor.Default,
							size: Enums.TextSize.Default,
							isSubtle: false,
							weight: Enums.TextWeight.Default,
							wrap: true,
						},
						spacing: 10
					}
				});


				/***/ }),

			/***/ "./src/enums.ts":
			/*!**********************!*\
  !*** ./src/enums.ts ***!
  \**********************/
			/*! no static exports found */
			/***/ (function(module, exports, __webpack_require__) {

				"use strict";

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
				Object.defineProperty(exports, "__esModule", { value: true });
// Note the "weird" way these readonly fields are declared is to work around
// a breaking change introduced in TS 3.1 wrt d.ts generation. DO NOT CHANGE
// and adopt this syntax for all other static readonly fields.
				var ActionStyle = /** @class */ (function () {
					function ActionStyle() {
					}
					ActionStyle.Default = "default";
					ActionStyle.Positive = "positive";
					ActionStyle.Destructive = "destructive";
					return ActionStyle;
				}());
				exports.ActionStyle = ActionStyle;
				var Size;
				(function (Size) {
					Size[Size["Auto"] = 0] = "Auto";
					Size[Size["Stretch"] = 1] = "Stretch";
					Size[Size["Small"] = 2] = "Small";
					Size[Size["Medium"] = 3] = "Medium";
					Size[Size["Large"] = 4] = "Large";
				})(Size = exports.Size || (exports.Size = {}));
				var SizeUnit;
				(function (SizeUnit) {
					SizeUnit[SizeUnit["Weight"] = 0] = "Weight";
					SizeUnit[SizeUnit["Pixel"] = 1] = "Pixel";
				})(SizeUnit = exports.SizeUnit || (exports.SizeUnit = {}));
				var TextSize;
				(function (TextSize) {
					TextSize[TextSize["Small"] = 0] = "Small";
					TextSize[TextSize["Default"] = 1] = "Default";
					TextSize[TextSize["Medium"] = 2] = "Medium";
					TextSize[TextSize["Large"] = 3] = "Large";
					TextSize[TextSize["ExtraLarge"] = 4] = "ExtraLarge";
				})(TextSize = exports.TextSize || (exports.TextSize = {}));
				var TextWeight;
				(function (TextWeight) {
					TextWeight[TextWeight["Lighter"] = 0] = "Lighter";
					TextWeight[TextWeight["Default"] = 1] = "Default";
					TextWeight[TextWeight["Bolder"] = 2] = "Bolder";
				})(TextWeight = exports.TextWeight || (exports.TextWeight = {}));
				var FontType;
				(function (FontType) {
					FontType[FontType["Default"] = 0] = "Default";
					FontType[FontType["Monospace"] = 1] = "Monospace";
				})(FontType = exports.FontType || (exports.FontType = {}));
				var Spacing;
				(function (Spacing) {
					Spacing[Spacing["None"] = 0] = "None";
					Spacing[Spacing["Small"] = 1] = "Small";
					Spacing[Spacing["Default"] = 2] = "Default";
					Spacing[Spacing["Medium"] = 3] = "Medium";
					Spacing[Spacing["Large"] = 4] = "Large";
					Spacing[Spacing["ExtraLarge"] = 5] = "ExtraLarge";
					Spacing[Spacing["Padding"] = 6] = "Padding";
				})(Spacing = exports.Spacing || (exports.Spacing = {}));
				var TextColor;
				(function (TextColor) {
					TextColor[TextColor["Default"] = 0] = "Default";
					TextColor[TextColor["Dark"] = 1] = "Dark";
					TextColor[TextColor["Light"] = 2] = "Light";
					TextColor[TextColor["Accent"] = 3] = "Accent";
					TextColor[TextColor["Good"] = 4] = "Good";
					TextColor[TextColor["Warning"] = 5] = "Warning";
					TextColor[TextColor["Attention"] = 6] = "Attention";
				})(TextColor = exports.TextColor || (exports.TextColor = {}));
				var HorizontalAlignment;
				(function (HorizontalAlignment) {
					HorizontalAlignment[HorizontalAlignment["Left"] = 0] = "Left";
					HorizontalAlignment[HorizontalAlignment["Center"] = 1] = "Center";
					HorizontalAlignment[HorizontalAlignment["Right"] = 2] = "Right";
				})(HorizontalAlignment = exports.HorizontalAlignment || (exports.HorizontalAlignment = {}));
				var VerticalAlignment;
				(function (VerticalAlignment) {
					VerticalAlignment[VerticalAlignment["Top"] = 0] = "Top";
					VerticalAlignment[VerticalAlignment["Center"] = 1] = "Center";
					VerticalAlignment[VerticalAlignment["Bottom"] = 2] = "Bottom";
				})(VerticalAlignment = exports.VerticalAlignment || (exports.VerticalAlignment = {}));
				var ActionAlignment;
				(function (ActionAlignment) {
					ActionAlignment[ActionAlignment["Left"] = 0] = "Left";
					ActionAlignment[ActionAlignment["Center"] = 1] = "Center";
					ActionAlignment[ActionAlignment["Right"] = 2] = "Right";
					ActionAlignment[ActionAlignment["Stretch"] = 3] = "Stretch";
				})(ActionAlignment = exports.ActionAlignment || (exports.ActionAlignment = {}));
				var ImageStyle;
				(function (ImageStyle) {
					ImageStyle[ImageStyle["Default"] = 0] = "Default";
					ImageStyle[ImageStyle["Person"] = 1] = "Person";
				})(ImageStyle = exports.ImageStyle || (exports.ImageStyle = {}));
				var ShowCardActionMode;
				(function (ShowCardActionMode) {
					ShowCardActionMode[ShowCardActionMode["Inline"] = 0] = "Inline";
					ShowCardActionMode[ShowCardActionMode["Popup"] = 1] = "Popup";
				})(ShowCardActionMode = exports.ShowCardActionMode || (exports.ShowCardActionMode = {}));
				var Orientation;
				(function (Orientation) {
					Orientation[Orientation["Horizontal"] = 0] = "Horizontal";
					Orientation[Orientation["Vertical"] = 1] = "Vertical";
				})(Orientation = exports.Orientation || (exports.Orientation = {}));
				var FillMode;
				(function (FillMode) {
					FillMode[FillMode["Cover"] = 0] = "Cover";
					FillMode[FillMode["RepeatHorizontally"] = 1] = "RepeatHorizontally";
					FillMode[FillMode["RepeatVertically"] = 2] = "RepeatVertically";
					FillMode[FillMode["Repeat"] = 3] = "Repeat";
				})(FillMode = exports.FillMode || (exports.FillMode = {}));
				var ActionIconPlacement;
				(function (ActionIconPlacement) {
					ActionIconPlacement[ActionIconPlacement["LeftOfTitle"] = 0] = "LeftOfTitle";
					ActionIconPlacement[ActionIconPlacement["AboveTitle"] = 1] = "AboveTitle";
				})(ActionIconPlacement = exports.ActionIconPlacement || (exports.ActionIconPlacement = {}));
				var InputTextStyle;
				(function (InputTextStyle) {
					InputTextStyle[InputTextStyle["Text"] = 0] = "Text";
					InputTextStyle[InputTextStyle["Tel"] = 1] = "Tel";
					InputTextStyle[InputTextStyle["Url"] = 2] = "Url";
					InputTextStyle[InputTextStyle["Email"] = 3] = "Email";
				})(InputTextStyle = exports.InputTextStyle || (exports.InputTextStyle = {}));
				var InputValidationNecessity;
				(function (InputValidationNecessity) {
					InputValidationNecessity[InputValidationNecessity["Optional"] = 0] = "Optional";
					InputValidationNecessity[InputValidationNecessity["Required"] = 1] = "Required";
					InputValidationNecessity[InputValidationNecessity["RequiredWithVisualCue"] = 2] = "RequiredWithVisualCue";
				})(InputValidationNecessity = exports.InputValidationNecessity || (exports.InputValidationNecessity = {}));
				/*
    This should really be a string enum, e.g.

        export enum ContainerStyle {
            Default = "default",
            Emphasis = "emphasis"
        }

    However, some hosts do not use a version of TypeScript
    recent enough to understand string enums. This is
    a compatible construct that does not require using
    a more recent version of TypeScript.

    Also note the "weird" way these readonly fields are declared is to work around
    a breaking change introduced in TS 3.1 wrt d.ts generation. DO NOT CHANGE
    and adopt this syntax for all other static readonly fields.
*/
				var ContainerStyle = /** @class */ (function () {
					function ContainerStyle() {
					}
					ContainerStyle.Default = "default";
					ContainerStyle.Emphasis = "emphasis";
					ContainerStyle.Accent = "accent";
					ContainerStyle.Good = "good";
					ContainerStyle.Attention = "attention";
					ContainerStyle.Warning = "warning";
					return ContainerStyle;
				}());
				exports.ContainerStyle = ContainerStyle;
				var ValidationError;
				(function (ValidationError) {
					ValidationError[ValidationError["Hint"] = 0] = "Hint";
					ValidationError[ValidationError["ActionTypeNotAllowed"] = 1] = "ActionTypeNotAllowed";
					ValidationError[ValidationError["CollectionCantBeEmpty"] = 2] = "CollectionCantBeEmpty";
					ValidationError[ValidationError["Deprecated"] = 3] = "Deprecated";
					ValidationError[ValidationError["ElementTypeNotAllowed"] = 4] = "ElementTypeNotAllowed";
					ValidationError[ValidationError["InteractivityNotAllowed"] = 5] = "InteractivityNotAllowed";
					ValidationError[ValidationError["InvalidPropertyValue"] = 6] = "InvalidPropertyValue";
					ValidationError[ValidationError["MissingCardType"] = 7] = "MissingCardType";
					ValidationError[ValidationError["PropertyCantBeNull"] = 8] = "PropertyCantBeNull";
					ValidationError[ValidationError["TooManyActions"] = 9] = "TooManyActions";
					ValidationError[ValidationError["UnknownActionType"] = 10] = "UnknownActionType";
					ValidationError[ValidationError["UnknownElementType"] = 11] = "UnknownElementType";
					ValidationError[ValidationError["UnsupportedCardVersion"] = 12] = "UnsupportedCardVersion";
					ValidationError[ValidationError["DuplicateId"] = 13] = "DuplicateId";
				})(ValidationError = exports.ValidationError || (exports.ValidationError = {}));
				var ContainerFitStatus;
				(function (ContainerFitStatus) {
					ContainerFitStatus[ContainerFitStatus["FullyInContainer"] = 0] = "FullyInContainer";
					ContainerFitStatus[ContainerFitStatus["Overflowing"] = 1] = "Overflowing";
					ContainerFitStatus[ContainerFitStatus["FullyOutOfContainer"] = 2] = "FullyOutOfContainer";
				})(ContainerFitStatus = exports.ContainerFitStatus || (exports.ContainerFitStatus = {}));


				/***/ }),

			/***/ "./src/host-config.ts":
			/*!****************************!*\
  !*** ./src/host-config.ts ***!
  \****************************/
			/*! no static exports found */
			/***/ (function(module, exports, __webpack_require__) {

				"use strict";

				var __extends = (this && this.__extends) || (function () {
					var extendStatics = function (d, b) {
						extendStatics = Object.setPrototypeOf ||
							({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
							function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
						return extendStatics(d, b);
					};
					return function (d, b) {
						extendStatics(d, b);
						function __() { this.constructor = d; }
						d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
					};
				})();
				Object.defineProperty(exports, "__esModule", { value: true });
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
				var Enums = __webpack_require__(/*! ./enums */ "./src/enums.ts");
				var Utils = __webpack_require__(/*! ./utils */ "./src/utils.ts");
				var Shared = __webpack_require__(/*! ./shared */ "./src/shared.ts");
				var ColorDefinition = /** @class */ (function () {
					function ColorDefinition(defaultColor, subtleColor) {
						this.default = "#000000";
						this.subtle = "#666666";
						if (defaultColor) {
							this.default = defaultColor;
						}
						if (subtleColor) {
							this.subtle = subtleColor;
						}
					}
					ColorDefinition.prototype.parse = function (obj) {
						if (obj) {
							this.default = obj["default"] || this.default;
							this.subtle = obj["subtle"] || this.subtle;
						}
					};
					return ColorDefinition;
				}());
				exports.ColorDefinition = ColorDefinition;
				var TextColorDefinition = /** @class */ (function (_super) {
					__extends(TextColorDefinition, _super);
					function TextColorDefinition() {
						var _this = _super !== null && _super.apply(this, arguments) || this;
						_this.highlightColors = new ColorDefinition("#22000000", "#11000000");
						return _this;
					}
					TextColorDefinition.prototype.parse = function (obj) {
						_super.prototype.parse.call(this, obj);
						if (obj) {
							this.highlightColors.parse(obj["highlightColors"]);
						}
					};
					return TextColorDefinition;
				}(ColorDefinition));
				exports.TextColorDefinition = TextColorDefinition;
				var AdaptiveCardConfig = /** @class */ (function () {
					function AdaptiveCardConfig(obj) {
						this.allowCustomStyle = false;
						if (obj) {
							this.allowCustomStyle = obj["allowCustomStyle"] || this.allowCustomStyle;
						}
					}
					return AdaptiveCardConfig;
				}());
				exports.AdaptiveCardConfig = AdaptiveCardConfig;
				var ImageSetConfig = /** @class */ (function () {
					function ImageSetConfig(obj) {
						this.imageSize = Enums.Size.Medium;
						this.maxImageHeight = 100;
						if (obj) {
							this.imageSize = obj["imageSize"] != null ? obj["imageSize"] : this.imageSize;
							this.maxImageHeight = Utils.getNumberValue(obj["maxImageHeight"], 100);
						}
					}
					ImageSetConfig.prototype.toJSON = function () {
						return {
							imageSize: Enums.Size[this.imageSize],
							maxImageHeight: this.maxImageHeight
						};
					};
					return ImageSetConfig;
				}());
				exports.ImageSetConfig = ImageSetConfig;
				var MediaConfig = /** @class */ (function () {
					function MediaConfig(obj) {
						this.allowInlinePlayback = true;
						if (obj) {
							this.defaultPoster = obj["defaultPoster"];
							this.allowInlinePlayback = obj["allowInlinePlayback"] || this.allowInlinePlayback;
						}
					}
					MediaConfig.prototype.toJSON = function () {
						return {
							defaultPoster: this.defaultPoster,
							allowInlinePlayback: this.allowInlinePlayback
						};
					};
					return MediaConfig;
				}());
				exports.MediaConfig = MediaConfig;
				var FactTextDefinition = /** @class */ (function () {
					function FactTextDefinition(obj) {
						this.size = Enums.TextSize.Default;
						this.color = Enums.TextColor.Default;
						this.isSubtle = false;
						this.weight = Enums.TextWeight.Default;
						this.wrap = true;
						if (obj) {
							this.size = Utils.parseHostConfigEnum(Enums.TextSize, obj["size"], Enums.TextSize.Default);
							this.color = Utils.parseHostConfigEnum(Enums.TextColor, obj["color"], Enums.TextColor.Default);
							this.isSubtle = obj["isSubtle"] || this.isSubtle;
							this.weight = Utils.parseHostConfigEnum(Enums.TextWeight, obj["weight"], this.getDefaultWeight());
							this.wrap = obj["wrap"] != null ? obj["wrap"] : this.wrap;
						}
					}
					;
					FactTextDefinition.prototype.getDefaultWeight = function () {
						return Enums.TextWeight.Default;
					};
					FactTextDefinition.prototype.toJSON = function () {
						return {
							size: Enums.TextSize[this.size],
							color: Enums.TextColor[this.color],
							isSubtle: this.isSubtle,
							weight: Enums.TextWeight[this.weight],
							wrap: this.wrap
						};
					};
					return FactTextDefinition;
				}());
				exports.FactTextDefinition = FactTextDefinition;
				var FactTitleDefinition = /** @class */ (function (_super) {
					__extends(FactTitleDefinition, _super);
					function FactTitleDefinition(obj) {
						var _this = _super.call(this, obj) || this;
						_this.maxWidth = 150;
						_this.weight = Enums.TextWeight.Bolder;
						if (obj) {
							_this.maxWidth = obj["maxWidth"] != null ? obj["maxWidth"] : _this.maxWidth;
							_this.weight = Utils.parseHostConfigEnum(Enums.TextWeight, obj["weight"], Enums.TextWeight.Bolder);
						}
						return _this;
					}
					FactTitleDefinition.prototype.getDefaultWeight = function () {
						return Enums.TextWeight.Bolder;
					};
					return FactTitleDefinition;
				}(FactTextDefinition));
				exports.FactTitleDefinition = FactTitleDefinition;
				var FactSetConfig = /** @class */ (function () {
					function FactSetConfig(obj) {
						this.title = new FactTitleDefinition();
						this.value = new FactTextDefinition();
						this.spacing = 10;
						if (obj) {
							this.title = new FactTitleDefinition(obj["title"]);
							this.value = new FactTextDefinition(obj["value"]);
							this.spacing = obj.spacing && obj.spacing != null ? obj.spacing && obj.spacing : this.spacing;
						}
					}
					return FactSetConfig;
				}());
				exports.FactSetConfig = FactSetConfig;
				var ShowCardActionConfig = /** @class */ (function () {
					function ShowCardActionConfig(obj) {
						this.actionMode = Enums.ShowCardActionMode.Inline;
						this.inlineTopMargin = 16;
						this.style = Enums.ContainerStyle.Emphasis;
						if (obj) {
							this.actionMode = Utils.parseHostConfigEnum(Enums.ShowCardActionMode, obj["actionMode"], Enums.ShowCardActionMode.Inline);
							this.inlineTopMargin = obj["inlineTopMargin"] != null ? obj["inlineTopMargin"] : this.inlineTopMargin;
							this.style = obj["style"] && typeof obj["style"] === "string" ? obj["style"] : Enums.ContainerStyle.Emphasis;
						}
					}
					ShowCardActionConfig.prototype.toJSON = function () {
						return {
							actionMode: Enums.ShowCardActionMode[this.actionMode],
							inlineTopMargin: this.inlineTopMargin,
							style: this.style
						};
					};
					return ShowCardActionConfig;
				}());
				exports.ShowCardActionConfig = ShowCardActionConfig;
				var ActionsConfig = /** @class */ (function () {
					function ActionsConfig(obj) {
						this.maxActions = 5;
						this.spacing = Enums.Spacing.Default;
						this.buttonSpacing = 20;
						this.showCard = new ShowCardActionConfig();
						this.preExpandSingleShowCardAction = false;
						this.actionsOrientation = Enums.Orientation.Horizontal;
						this.actionAlignment = Enums.ActionAlignment.Left;
						this.iconPlacement = Enums.ActionIconPlacement.LeftOfTitle;
						this.allowTitleToWrap = false;
						this.iconSize = 24;
						if (obj) {
							this.maxActions = obj["maxActions"] != null ? obj["maxActions"] : this.maxActions;
							this.spacing = Utils.parseHostConfigEnum(Enums.Spacing, obj.spacing && obj.spacing, Enums.Spacing.Default);
							this.buttonSpacing = obj["buttonSpacing"] != null ? obj["buttonSpacing"] : this.buttonSpacing;
							this.showCard = new ShowCardActionConfig(obj["showCard"]);
							this.preExpandSingleShowCardAction = Utils.getBoolValue(obj["preExpandSingleShowCardAction"], false);
							this.actionsOrientation = Utils.parseHostConfigEnum(Enums.Orientation, obj["actionsOrientation"], Enums.Orientation.Horizontal);
							this.actionAlignment = Utils.parseHostConfigEnum(Enums.ActionAlignment, obj["actionAlignment"], Enums.ActionAlignment.Left);
							this.iconPlacement = Utils.parseHostConfigEnum(Enums.ActionIconPlacement, obj["iconPlacement"], Enums.ActionIconPlacement.LeftOfTitle);
							this.allowTitleToWrap = obj["allowTitleToWrap"] != null ? obj["allowTitleToWrap"] : this.allowTitleToWrap;
							try {
								var sizeAndUnit = Shared.SizeAndUnit.parse(obj["iconSize"]);
								if (sizeAndUnit.unit == Enums.SizeUnit.Pixel) {
									this.iconSize = sizeAndUnit.physicalSize;
								}
							}
							catch (e) {
								// Swallow this, keep default icon size
							}
						}
					}
					ActionsConfig.prototype.toJSON = function () {
						return {
							maxActions: this.maxActions,
							spacing: Enums.Spacing[this.spacing],
							buttonSpacing: this.buttonSpacing,
							showCard: this.showCard,
							preExpandSingleShowCardAction: this.preExpandSingleShowCardAction,
							actionsOrientation: Enums.Orientation[this.actionsOrientation],
							actionAlignment: Enums.ActionAlignment[this.actionAlignment]
						};
					};
					return ActionsConfig;
				}());
				exports.ActionsConfig = ActionsConfig;
				var ColorSetDefinition = /** @class */ (function () {
					function ColorSetDefinition(obj) {
						this.default = new TextColorDefinition();
						this.dark = new TextColorDefinition();
						this.light = new TextColorDefinition();
						this.accent = new TextColorDefinition();
						this.good = new TextColorDefinition();
						this.warning = new TextColorDefinition();
						this.attention = new TextColorDefinition();
						this.parse(obj);
					}
					ColorSetDefinition.prototype.parseSingleColor = function (obj, propertyName) {
						if (obj) {
							this[propertyName].parse(obj[propertyName]);
						}
					};
					ColorSetDefinition.prototype.parse = function (obj) {
						if (obj) {
							this.parseSingleColor(obj, "default");
							this.parseSingleColor(obj, "dark");
							this.parseSingleColor(obj, "light");
							this.parseSingleColor(obj, "accent");
							this.parseSingleColor(obj, "good");
							this.parseSingleColor(obj, "warning");
							this.parseSingleColor(obj, "attention");
						}
					};
					return ColorSetDefinition;
				}());
				exports.ColorSetDefinition = ColorSetDefinition;
				var ContainerStyleDefinition = /** @class */ (function () {
					function ContainerStyleDefinition(obj) {
						this.foregroundColors = new ColorSetDefinition({
							"default": { default: "#333333", subtle: "#EE333333" },
							"dark": { default: "#000000", subtle: "#66000000" },
							"light": { default: "#FFFFFF", subtle: "#33000000" },
							"accent": { default: "#2E89FC", subtle: "#882E89FC" },
							"good": { default: "#54A254", subtle: "#DD54A254" },
							"warning": { default: "#E69500", subtle: "#DDE69500" },
							"attention": { default: "#CC3300", subtle: "#DDCC3300" }
						});
						this.parse(obj);
					}
					ContainerStyleDefinition.prototype.parse = function (obj) {
						if (obj) {
							this.backgroundColor = obj["backgroundColor"];
							this.foregroundColors.parse(obj["foregroundColors"]);
							this.highlightBackgroundColor = obj["highlightBackgroundColor"];
							this.highlightForegroundColor = obj["highlightForegroundColor"];
						}
					};
					Object.defineProperty(ContainerStyleDefinition.prototype, "isBuiltIn", {
						get: function () {
							return false;
						},
						enumerable: true,
						configurable: true
					});
					return ContainerStyleDefinition;
				}());
				exports.ContainerStyleDefinition = ContainerStyleDefinition;
				var BuiltInContainerStyleDefinition = /** @class */ (function (_super) {
					__extends(BuiltInContainerStyleDefinition, _super);
					function BuiltInContainerStyleDefinition() {
						return _super !== null && _super.apply(this, arguments) || this;
					}
					Object.defineProperty(BuiltInContainerStyleDefinition.prototype, "isBuiltIn", {
						get: function () {
							return true;
						},
						enumerable: true,
						configurable: true
					});
					return BuiltInContainerStyleDefinition;
				}(ContainerStyleDefinition));
				var ContainerStyleSet = /** @class */ (function () {
					function ContainerStyleSet(obj) {
						this._allStyles = {};
						this._allStyles[Enums.ContainerStyle.Default] = new BuiltInContainerStyleDefinition();
						this._allStyles[Enums.ContainerStyle.Emphasis] = new BuiltInContainerStyleDefinition();
						this._allStyles[Enums.ContainerStyle.Accent] = new BuiltInContainerStyleDefinition();
						this._allStyles[Enums.ContainerStyle.Good] = new BuiltInContainerStyleDefinition();
						this._allStyles[Enums.ContainerStyle.Attention] = new BuiltInContainerStyleDefinition();
						this._allStyles[Enums.ContainerStyle.Warning] = new BuiltInContainerStyleDefinition();
						if (obj) {
							this._allStyles[Enums.ContainerStyle.Default].parse(obj[Enums.ContainerStyle.Default]);
							this._allStyles[Enums.ContainerStyle.Emphasis].parse(obj[Enums.ContainerStyle.Emphasis]);
							this._allStyles[Enums.ContainerStyle.Accent].parse(obj[Enums.ContainerStyle.Accent]);
							this._allStyles[Enums.ContainerStyle.Good].parse(obj[Enums.ContainerStyle.Good]);
							this._allStyles[Enums.ContainerStyle.Attention].parse(obj[Enums.ContainerStyle.Attention]);
							this._allStyles[Enums.ContainerStyle.Warning].parse(obj[Enums.ContainerStyle.Warning]);
							var customStyleArray = obj["customStyles"];
							if (customStyleArray && Array.isArray(customStyleArray)) {
								for (var _i = 0, customStyleArray_1 = customStyleArray; _i < customStyleArray_1.length; _i++) {
									var customStyle = customStyleArray_1[_i];
									if (customStyle) {
										var styleName = customStyle["name"];
										if (styleName && typeof styleName === "string") {
											if (this._allStyles.hasOwnProperty(styleName)) {
												this._allStyles[styleName].parse(customStyle["style"]);
											}
											else {
												this._allStyles[styleName] = new ContainerStyleDefinition(customStyle["style"]);
											}
										}
									}
								}
							}
						}
					}
					ContainerStyleSet.prototype.toJSON = function () {
						var _this = this;
						var customStyleArray = [];
						Object.keys(this._allStyles).forEach(function (key) {
							if (!_this._allStyles[key].isBuiltIn) {
								customStyleArray.push({
									name: key,
									style: _this._allStyles[key]
								});
							}
						});
						var result = {
							default: this.default,
							emphasis: this.emphasis
						};
						if (customStyleArray.length > 0) {
							result.customStyles = customStyleArray;
						}
						return result;
					};
					ContainerStyleSet.prototype.getStyleByName = function (name, defaultValue) {
						if (defaultValue === void 0) { defaultValue = null; }
						return this._allStyles.hasOwnProperty(name) ? this._allStyles[name] : defaultValue;
					};
					Object.defineProperty(ContainerStyleSet.prototype, "default", {
						get: function () {
							return this._allStyles[Enums.ContainerStyle.Default];
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(ContainerStyleSet.prototype, "emphasis", {
						get: function () {
							return this._allStyles[Enums.ContainerStyle.Emphasis];
						},
						enumerable: true,
						configurable: true
					});
					return ContainerStyleSet;
				}());
				exports.ContainerStyleSet = ContainerStyleSet;
				var Version = /** @class */ (function () {
					function Version(major, minor, label) {
						if (major === void 0) { major = 1; }
						if (minor === void 0) { minor = 1; }
						this._isValid = true;
						this._major = major;
						this._minor = minor;
						this._label = label;
					}
					Version.parse = function (versionString, errors) {
						if (!versionString) {
							return null;
						}
						var result = new Version();
						result._versionString = versionString;
						var regEx = /(\d+).(\d+)/gi;
						var matches = regEx.exec(versionString);
						if (matches != null && matches.length == 3) {
							result._major = parseInt(matches[1]);
							result._minor = parseInt(matches[2]);
						}
						else {
							result._isValid = false;
						}
						if (!result._isValid && errors) {
							errors.push({
								error: Enums.ValidationError.InvalidPropertyValue,
								message: "Invalid version string: " + result._versionString
							});
						}
						return result;
					};
					Version.prototype.toString = function () {
						return !this._isValid ? this._versionString : this._major + "." + this._minor;
					};
					Version.prototype.compareTo = function (otherVersion) {
						if (!this.isValid || !otherVersion.isValid) {
							throw new Error("Cannot compare invalid version.");
						}
						if (this.major > otherVersion.major) {
							return 1;
						}
						else if (this.major < otherVersion.major) {
							return -1;
						}
						else if (this.minor > otherVersion.minor) {
							return 1;
						}
						else if (this.minor < otherVersion.minor) {
							return -1;
						}
						return 0;
					};
					Object.defineProperty(Version.prototype, "label", {
						get: function () {
							return this._label ? this._label : this.toString();
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(Version.prototype, "major", {
						get: function () {
							return this._major;
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(Version.prototype, "minor", {
						get: function () {
							return this._minor;
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(Version.prototype, "isValid", {
						get: function () {
							return this._isValid;
						},
						enumerable: true,
						configurable: true
					});
					return Version;
				}());
				exports.Version = Version;
				var HostCapabilities = /** @class */ (function () {
					function HostCapabilities() {
						this.capabilities = null;
					}
					HostCapabilities.prototype.setCapability = function (name, version) {
						if (!this.capabilities) {
							this.capabilities = {};
						}
						this.capabilities[name] = version;
					};
					HostCapabilities.prototype.parse = function (json, errors) {
						if (json) {
							for (var name_1 in json) {
								var jsonVersion = json[name_1];
								if (typeof jsonVersion === "string") {
									if (jsonVersion == "*") {
										this.setCapability(name_1, "*");
									}
									else {
										var version = Version.parse(jsonVersion, errors);
										if (version.isValid) {
											this.setCapability(name_1, version);
										}
									}
								}
							}
						}
					};
					HostCapabilities.prototype.hasCapability = function (name, version) {
						if (this.capabilities && this.capabilities.hasOwnProperty(name)) {
							if (version == "*" || this.capabilities[name] == "*") {
								return true;
							}
							return version.compareTo(this.capabilities[name]) <= 0;
						}
						return false;
					};
					HostCapabilities.prototype.areAllMet = function (hostCapabilities) {
						if (this.capabilities) {
							for (var capabilityName in this.capabilities) {
								if (!hostCapabilities.hasCapability(capabilityName, this.capabilities[capabilityName])) {
									return false;
								}
							}
						}
						return true;
					};
					return HostCapabilities;
				}());
				exports.HostCapabilities = HostCapabilities;
				var FontTypeDefinition = /** @class */ (function () {
					function FontTypeDefinition(fontFamily) {
						this.fontFamily = "Segoe UI,Segoe,Segoe WP,Helvetica Neue,Helvetica,sans-serif";
						this.fontSizes = {
							small: 12,
							default: 14,
							medium: 17,
							large: 21,
							extraLarge: 26
						};
						this.fontWeights = {
							lighter: 200,
							default: 400,
							bolder: 600
						};
						if (fontFamily) {
							this.fontFamily = fontFamily;
						}
					}
					FontTypeDefinition.prototype.parse = function (obj) {
						this.fontFamily = obj["fontFamily"] || this.fontFamily;
						this.fontSizes = {
							small: obj.fontSizes && obj.fontSizes["small"] || this.fontSizes.small,
							default: obj.fontSizes && obj.fontSizes["default"] || this.fontSizes.default,
							medium: obj.fontSizes && obj.fontSizes["medium"] || this.fontSizes.medium,
							large: obj.fontSizes && obj.fontSizes["large"] || this.fontSizes.large,
							extraLarge: obj.fontSizes && obj.fontSizes["extraLarge"] || this.fontSizes.extraLarge
						};
						this.fontWeights = {
							lighter: obj.fontWeights && obj.fontWeights["lighter"] || this.fontWeights.lighter,
							default: obj.fontWeights && obj.fontWeights["default"] || this.fontWeights.default,
							bolder: obj.fontWeights && obj.fontWeights["bolder"] || this.fontWeights.bolder
						};
					};
					FontTypeDefinition.monospace = new FontTypeDefinition("'Courier New', Courier, monospace");
					return FontTypeDefinition;
				}());
				exports.FontTypeDefinition = FontTypeDefinition;
				var FontTypeSet = /** @class */ (function () {
					function FontTypeSet(obj) {
						this.default = new FontTypeDefinition();
						this.monospace = new FontTypeDefinition("'Courier New', Courier, monospace");
						if (obj) {
							this.default.parse(obj["default"]);
							this.monospace.parse(obj["monospace"]);
						}
					}
					FontTypeSet.prototype.getStyleDefinition = function (style) {
						switch (style) {
							case Enums.FontType.Monospace:
								return this.monospace;
							case Enums.FontType.Default:
							default:
								return this.default;
						}
					};
					return FontTypeSet;
				}());
				exports.FontTypeSet = FontTypeSet;
				var HostConfig = /** @class */ (function () {
					function HostConfig(obj) {
						this.hostCapabilities = new HostCapabilities();
						this.choiceSetInputValueSeparator = ",";
						this.supportsInteractivity = true;
						this.fontTypes = null;
						this.spacing = {
							small: 3,
							default: 8,
							medium: 20,
							large: 30,
							extraLarge: 40,
							padding: 15
						};
						this.separator = {
							lineThickness: 1,
							lineColor: "#EEEEEE"
						};
						this.imageSizes = {
							small: 40,
							medium: 80,
							large: 160
						};
						this.containerStyles = new ContainerStyleSet();
						this.actions = new ActionsConfig();
						this.adaptiveCard = new AdaptiveCardConfig();
						this.imageSet = new ImageSetConfig();
						this.media = new MediaConfig();
						this.factSet = new FactSetConfig();
						this.cssClassNamePrefix = null;
						this.alwaysAllowBleed = false;
						if (obj) {
							if (typeof obj === "string" || obj instanceof String) {
								obj = JSON.parse(obj);
							}
							this.choiceSetInputValueSeparator = (obj && typeof obj["choiceSetInputValueSeparator"] === "string") ? obj["choiceSetInputValueSeparator"] : this.choiceSetInputValueSeparator;
							this.supportsInteractivity = (obj && typeof obj["supportsInteractivity"] === "boolean") ? obj["supportsInteractivity"] : this.supportsInteractivity;
							this._legacyFontType = new FontTypeDefinition();
							this._legacyFontType.parse(obj);
							if (obj.fontTypes) {
								this.fontTypes = new FontTypeSet(obj.fontTypes);
							}
							if (obj.lineHeights) {
								this.lineHeights = {
									small: obj.lineHeights["small"],
									default: obj.lineHeights["default"],
									medium: obj.lineHeights["medium"],
									large: obj.lineHeights["large"],
									extraLarge: obj.lineHeights["extraLarge"]
								};
							}
							;
							this.imageSizes = {
								small: obj.imageSizes && obj.imageSizes["small"] || this.imageSizes.small,
								medium: obj.imageSizes && obj.imageSizes["medium"] || this.imageSizes.medium,
								large: obj.imageSizes && obj.imageSizes["large"] || this.imageSizes.large,
							};
							this.containerStyles = new ContainerStyleSet(obj["containerStyles"]);
							this.spacing = {
								small: obj.spacing && obj.spacing["small"] || this.spacing.small,
								default: obj.spacing && obj.spacing["default"] || this.spacing.default,
								medium: obj.spacing && obj.spacing["medium"] || this.spacing.medium,
								large: obj.spacing && obj.spacing["large"] || this.spacing.large,
								extraLarge: obj.spacing && obj.spacing["extraLarge"] || this.spacing.extraLarge,
								padding: obj.spacing && obj.spacing["padding"] || this.spacing.padding
							};
							this.separator = {
								lineThickness: obj.separator && obj.separator["lineThickness"] || this.separator.lineThickness,
								lineColor: obj.separator && obj.separator["lineColor"] || this.separator.lineColor
							};
							this.actions = new ActionsConfig(obj.actions || this.actions);
							this.adaptiveCard = new AdaptiveCardConfig(obj.adaptiveCard || this.adaptiveCard);
							this.imageSet = new ImageSetConfig(obj["imageSet"]);
							this.factSet = new FactSetConfig(obj["factSet"]);
						}
					}
					HostConfig.prototype.getFontTypeDefinition = function (style) {
						if (this.fontTypes) {
							return this.fontTypes.getStyleDefinition(style);
						}
						else {
							return style == Enums.FontType.Monospace ? FontTypeDefinition.monospace : this._legacyFontType;
						}
					};
					HostConfig.prototype.getEffectiveSpacing = function (spacing) {
						switch (spacing) {
							case Enums.Spacing.Small:
								return this.spacing.small;
							case Enums.Spacing.Default:
								return this.spacing.default;
							case Enums.Spacing.Medium:
								return this.spacing.medium;
							case Enums.Spacing.Large:
								return this.spacing.large;
							case Enums.Spacing.ExtraLarge:
								return this.spacing.extraLarge;
							case Enums.Spacing.Padding:
								return this.spacing.padding;
							default:
								return 0;
						}
					};
					HostConfig.prototype.paddingDefinitionToSpacingDefinition = function (paddingDefinition) {
						return new Shared.SpacingDefinition(this.getEffectiveSpacing(paddingDefinition.top), this.getEffectiveSpacing(paddingDefinition.right), this.getEffectiveSpacing(paddingDefinition.bottom), this.getEffectiveSpacing(paddingDefinition.left));
					};
					HostConfig.prototype.makeCssClassNames = function () {
						var classNames = [];
						for (var _i = 0; _i < arguments.length; _i++) {
							classNames[_i] = arguments[_i];
						}
						var result = [];
						for (var _a = 0, classNames_1 = classNames; _a < classNames_1.length; _a++) {
							var className = classNames_1[_a];
							result.push((this.cssClassNamePrefix ? this.cssClassNamePrefix + "-" : "") + className);
						}
						return result;
					};
					HostConfig.prototype.makeCssClassName = function () {
						var classNames = [];
						for (var _i = 0; _i < arguments.length; _i++) {
							classNames[_i] = arguments[_i];
						}
						var result = this.makeCssClassNames.apply(this, classNames).join(" ");
						return result ? result : "";
					};
					Object.defineProperty(HostConfig.prototype, "fontFamily", {
						get: function () {
							return this._legacyFontType.fontFamily;
						},
						set: function (value) {
							this._legacyFontType.fontFamily = value;
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(HostConfig.prototype, "fontSizes", {
						get: function () {
							return this._legacyFontType.fontSizes;
						},
						enumerable: true,
						configurable: true
					});
					Object.defineProperty(HostConfig.prototype, "fontWeights", {
						get: function () {
							return this._legacyFontType.fontWeights;
						},
						enumerable: true,
						configurable: true
					});
					return HostConfig;
				}());
				exports.HostConfig = HostConfig;


				/***/ }),

			/***/ "./src/shared.ts":
			/*!***********************!*\
  !*** ./src/shared.ts ***!
  \***********************/
			/*! no static exports found */
			/***/ (function(module, exports, __webpack_require__) {

				"use strict";

				Object.defineProperty(exports, "__esModule", { value: true });
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
				var Enums = __webpack_require__(/*! ./enums */ "./src/enums.ts");
				exports.ContentTypes = {
					applicationJson: "application/json",
					applicationXWwwFormUrlencoded: "application/x-www-form-urlencoded"
				};
				var StringWithSubstitutions = /** @class */ (function () {
					function StringWithSubstitutions() {
						this._isProcessed = false;
						this._original = null;
						this._processed = null;
					}
					StringWithSubstitutions.prototype.getReferencedInputs = function (inputs, referencedInputs) {
						if (!referencedInputs) {
							throw new Error("The referencedInputs parameter cannot be null.");
						}
						for (var _i = 0, inputs_1 = inputs; _i < inputs_1.length; _i++) {
							var input = inputs_1[_i];
							var matches = new RegExp("\\{{2}(" + input.id + ").value\\}{2}", "gi").exec(this._original);
							if (matches != null) {
								referencedInputs[input.id] = input;
							}
						}
					};
					StringWithSubstitutions.prototype.substituteInputValues = function (inputs, contentType) {
						this._processed = this._original;
						var regEx = /\{{2}([a-z0-9_$@]+).value\}{2}/gi;
						var matches;
						while ((matches = regEx.exec(this._original)) != null) {
							var matchedInput = null;
							for (var _i = 0, _a = Object.keys(inputs); _i < _a.length; _i++) {
								var key = _a[_i];
								if (key.toLowerCase() == matches[1].toLowerCase()) {
									matchedInput = inputs[key];
									break;
								}
							}
							if (matchedInput) {
								var valueForReplace = "";
								if (matchedInput.value) {
									valueForReplace = matchedInput.value;
								}
								if (contentType === exports.ContentTypes.applicationJson) {
									valueForReplace = JSON.stringify(valueForReplace);
									valueForReplace = valueForReplace.slice(1, -1);
								}
								else if (contentType === exports.ContentTypes.applicationXWwwFormUrlencoded) {
									valueForReplace = encodeURIComponent(valueForReplace);
								}
								this._processed = this._processed.replace(matches[0], valueForReplace);
							}
						}
						;
						this._isProcessed = true;
					};
					StringWithSubstitutions.prototype.getOriginal = function () {
						return this._original;
					};
					StringWithSubstitutions.prototype.get = function () {
						if (!this._isProcessed) {
							return this._original;
						}
						else {
							return this._processed;
						}
					};
					StringWithSubstitutions.prototype.set = function (value) {
						this._original = value;
						this._isProcessed = false;
					};
					return StringWithSubstitutions;
				}());
				exports.StringWithSubstitutions = StringWithSubstitutions;
				var SpacingDefinition = /** @class */ (function () {
					function SpacingDefinition(top, right, bottom, left) {
						if (top === void 0) { top = 0; }
						if (right === void 0) { right = 0; }
						if (bottom === void 0) { bottom = 0; }
						if (left === void 0) { left = 0; }
						this.left = 0;
						this.top = 0;
						this.right = 0;
						this.bottom = 0;
						this.top = top;
						this.right = right;
						this.bottom = bottom;
						this.left = left;
					}
					return SpacingDefinition;
				}());
				exports.SpacingDefinition = SpacingDefinition;
				var PaddingDefinition = /** @class */ (function () {
					function PaddingDefinition(top, right, bottom, left) {
						if (top === void 0) { top = Enums.Spacing.None; }
						if (right === void 0) { right = Enums.Spacing.None; }
						if (bottom === void 0) { bottom = Enums.Spacing.None; }
						if (left === void 0) { left = Enums.Spacing.None; }
						this.top = Enums.Spacing.None;
						this.right = Enums.Spacing.None;
						this.bottom = Enums.Spacing.None;
						this.left = Enums.Spacing.None;
						this.top = top;
						this.right = right;
						this.bottom = bottom;
						this.left = left;
					}
					return PaddingDefinition;
				}());
				exports.PaddingDefinition = PaddingDefinition;
				var SizeAndUnit = /** @class */ (function () {
					function SizeAndUnit(physicalSize, unit) {
						this.physicalSize = physicalSize;
						this.unit = unit;
					}
					SizeAndUnit.parse = function (input, requireUnitSpecifier) {
						if (requireUnitSpecifier === void 0) { requireUnitSpecifier = false; }
						var result = new SizeAndUnit(0, Enums.SizeUnit.Weight);
						var regExp = /^([0-9]+)(px|\*)?$/g;
						var matches = regExp.exec(input);
						var expectedMatchCount = requireUnitSpecifier ? 3 : 2;
						if (matches && matches.length >= expectedMatchCount) {
							result.physicalSize = parseInt(matches[1]);
							if (matches.length == 3) {
								if (matches[2] == "px") {
									result.unit = Enums.SizeUnit.Pixel;
								}
							}
							return result;
						}
						throw new Error("Invalid size: " + input);
					};
					return SizeAndUnit;
				}());
				exports.SizeAndUnit = SizeAndUnit;
				/**
				 * Fast UUID generator, RFC4122 version 4 compliant.
				 * @author Jeff Ward (jcward.com).
				 * @license MIT license
				 * @link http://stackoverflow.com/questions/105034/how-to-create-a-guid-uuid-in-javascript/21963136#21963136
				 **/
				var UUID = /** @class */ (function () {
					function UUID() {
					}
					UUID.generate = function () {
						var d0 = Math.random() * 0xffffffff | 0;
						var d1 = Math.random() * 0xffffffff | 0;
						var d2 = Math.random() * 0xffffffff | 0;
						var d3 = Math.random() * 0xffffffff | 0;
						return UUID.lut[d0 & 0xff] + UUID.lut[d0 >> 8 & 0xff] + UUID.lut[d0 >> 16 & 0xff] + UUID.lut[d0 >> 24 & 0xff] + '-' +
							UUID.lut[d1 & 0xff] + UUID.lut[d1 >> 8 & 0xff] + '-' + UUID.lut[d1 >> 16 & 0x0f | 0x40] + UUID.lut[d1 >> 24 & 0xff] + '-' +
							UUID.lut[d2 & 0x3f | 0x80] + UUID.lut[d2 >> 8 & 0xff] + '-' + UUID.lut[d2 >> 16 & 0xff] + UUID.lut[d2 >> 24 & 0xff] +
							UUID.lut[d3 & 0xff] + UUID.lut[d3 >> 8 & 0xff] + UUID.lut[d3 >> 16 & 0xff] + UUID.lut[d3 >> 24 & 0xff];
					};
					UUID.initialize = function () {
						for (var i = 0; i < 256; i++) {
							UUID.lut[i] = (i < 16 ? '0' : '') + i.toString(16);
						}
					};
					UUID.lut = [];
					return UUID;
				}());
				exports.UUID = UUID;
				UUID.initialize();


				/***/ }),

			/***/ "./src/text-formatters.ts":
			/*!********************************!*\
  !*** ./src/text-formatters.ts ***!
  \********************************/
			/*! no static exports found */
			/***/ (function(module, exports, __webpack_require__) {

				"use strict";

				var __extends = (this && this.__extends) || (function () {
					var extendStatics = function (d, b) {
						extendStatics = Object.setPrototypeOf ||
							({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
							function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
						return extendStatics(d, b);
					};
					return function (d, b) {
						extendStatics(d, b);
						function __() { this.constructor = d; }
						d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
					};
				})();
				Object.defineProperty(exports, "__esModule", { value: true });
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
				var AbstractTextFormatter = /** @class */ (function () {
					function AbstractTextFormatter(regularExpression) {
						this._regularExpression = regularExpression;
					}
					AbstractTextFormatter.prototype.format = function (lang, input) {
						var matches;
						var result = input;
						while ((matches = this._regularExpression.exec(input)) != null) {
							result = result.replace(matches[0], this.internalFormat(lang, matches));
						}
						;
						return result;
					};
					return AbstractTextFormatter;
				}());
				var DateFormatter = /** @class */ (function (_super) {
					__extends(DateFormatter, _super);
					function DateFormatter() {
						return _super !== null && _super.apply(this, arguments) || this;
					}
					DateFormatter.prototype.internalFormat = function (lang, matches) {
						var date = new Date(Date.parse(matches[1]));
						var format = matches[2] != undefined ? matches[2].toLowerCase() : "compact";
						if (format != "compact") {
							return date.toLocaleDateString(lang, { day: "numeric", weekday: format, month: format, year: "numeric" });
						}
						else {
							return date.toLocaleDateString();
						}
					};
					return DateFormatter;
				}(AbstractTextFormatter));
				var TimeFormatter = /** @class */ (function (_super) {
					__extends(TimeFormatter, _super);
					function TimeFormatter() {
						return _super !== null && _super.apply(this, arguments) || this;
					}
					TimeFormatter.prototype.internalFormat = function (lang, matches) {
						var date = new Date(Date.parse(matches[1]));
						return date.toLocaleTimeString(lang, { hour: 'numeric', minute: '2-digit' });
					};
					return TimeFormatter;
				}(AbstractTextFormatter));
				function formatText(lang, text) {
					var formatters = [
						new DateFormatter(/\{{2}DATE\((\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(?:Z|(?:(?:-|\+)\d{2}:\d{2})))(?:, ?(COMPACT|LONG|SHORT))?\)\}{2}/g),
						new TimeFormatter(/\{{2}TIME\((\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(?:Z|(?:(?:-|\+)\d{2}:\d{2})))\)\}{2}/g)
					];
					var result = text;
					for (var i = 0; i < formatters.length; i++) {
						result = formatters[i].format(lang, result);
					}
					return result;
				}
				exports.formatText = formatText;


				/***/ }),

			/***/ "./src/utils.ts":
			/*!**********************!*\
  !*** ./src/utils.ts ***!
  \**********************/
			/*! no static exports found */
			/***/ (function(module, exports, __webpack_require__) {

				"use strict";

				Object.defineProperty(exports, "__esModule", { value: true });
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
				var Enums = __webpack_require__(/*! ./enums */ "./src/enums.ts");
				var Shared = __webpack_require__(/*! ./shared */ "./src/shared.ts");
				function generateUniqueId() {
					return "__ac-" + Shared.UUID.generate();
				}
				exports.generateUniqueId = generateUniqueId;
				function isNullOrEmpty(value) {
					return value === undefined || value === null || value === "";
				}
				exports.isNullOrEmpty = isNullOrEmpty;
				function appendChild(node, child) {
					if (child != null && child != undefined) {
						node.appendChild(child);
					}
				}
				exports.appendChild = appendChild;
				function getStringValue(obj, defaultValue) {
					if (defaultValue === void 0) { defaultValue = undefined; }
					return typeof obj === "string" ? obj.toString() : defaultValue;
				}
				exports.getStringValue = getStringValue;
				function getNumberValue(obj, defaultValue) {
					if (defaultValue === void 0) { defaultValue = undefined; }
					return typeof obj === "number" ? obj : defaultValue;
				}
				exports.getNumberValue = getNumberValue;
				function getBoolValue(value, defaultValue) {
					if (typeof value === "boolean") {
						return value;
					}
					else if (typeof value === "string") {
						switch (value.toLowerCase()) {
							case "true":
								return true;
							case "false":
								return false;
							default:
								return defaultValue;
						}
					}
					return defaultValue;
				}
				exports.getBoolValue = getBoolValue;
				function getEnumValue(targetEnum, name, defaultValue) {
					if (isNullOrEmpty(name)) {
						return defaultValue;
					}
					for (var key in targetEnum) {
						var isValueProperty = parseInt(key, 10) >= 0;
						if (isValueProperty) {
							var value = targetEnum[key];
							if (value && typeof value === "string") {
								if (value.toLowerCase() === name.toLowerCase()) {
									return parseInt(key, 10);
								}
							}
						}
					}
					return defaultValue;
				}
				exports.getEnumValue = getEnumValue;
				function setProperty(target, propertyName, propertyValue, defaultValue) {
					if (defaultValue === void 0) { defaultValue = undefined; }
					if (propertyValue === null || propertyValue === undefined || propertyValue === defaultValue) {
						delete target[propertyName];
					}
					else {
						target[propertyName] = propertyValue;
					}
				}
				exports.setProperty = setProperty;
				function setNumberProperty(target, propertyName, propertyValue, defaultValue) {
					if (defaultValue === void 0) { defaultValue = undefined; }
					if (propertyValue === null || propertyValue === undefined || propertyValue === defaultValue || isNaN(propertyValue)) {
						delete target[propertyName];
					}
					else {
						target[propertyName] = propertyValue;
					}
				}
				exports.setNumberProperty = setNumberProperty;
				function setEnumProperty(enumType, target, propertyName, propertyValue, defaultValue) {
					if (defaultValue === void 0) { defaultValue = undefined; }
					var targetValue = target[propertyName];
					var canDeleteTarget = targetValue == undefined ? true : enumType[targetValue] !== undefined;
					if (propertyValue == defaultValue) {
						if (canDeleteTarget) {
							delete target[propertyName];
						}
					}
					else {
						if (propertyValue == undefined) {
							if (canDeleteTarget) {
								delete target[propertyName];
							}
						}
						else {
							target[propertyName] = enumType[propertyValue];
						}
					}
				}
				exports.setEnumProperty = setEnumProperty;
				function setArrayProperty(target, propertyName, propertyValue) {
					var items = [];
					if (propertyValue) {
						for (var _i = 0, propertyValue_1 = propertyValue; _i < propertyValue_1.length; _i++) {
							var item = propertyValue_1[_i];
							items.push(item.toJSON());
						}
					}
					if (items.length == 0) {
						if (target.hasOwnProperty(propertyName) && Array.isArray(target[propertyName])) {
							delete target[propertyName];
						}
					}
					else {
						setProperty(target, propertyName, items);
					}
				}
				exports.setArrayProperty = setArrayProperty;
				function parseHostConfigEnum(targetEnum, value, defaultValue) {
					if (typeof value === "string") {
						return getEnumValue(targetEnum, value, defaultValue);
					}
					else if (typeof value === "number") {
						return value;
					}
					else {
						return defaultValue;
					}
				}
				exports.parseHostConfigEnum = parseHostConfigEnum;
				function renderSeparation(hostConfig, separationDefinition, orientation) {
					if (separationDefinition.spacing > 0 || separationDefinition.lineThickness > 0) {
						var separator = document.createElement("div");
						separator.className = hostConfig.makeCssClassName("ac-" + (orientation == Enums.Orientation.Horizontal ? "horizontal" : "vertical") + "-separator");
						if (orientation == Enums.Orientation.Horizontal) {
							if (separationDefinition.lineThickness) {
								separator.style.paddingTop = (separationDefinition.spacing / 2) + "px";
								separator.style.marginBottom = (separationDefinition.spacing / 2) + "px";
								separator.style.borderBottom = separationDefinition.lineThickness + "px solid " + stringToCssColor(separationDefinition.lineColor);
							}
							else {
								separator.style.height = separationDefinition.spacing + "px";
							}
						}
						else {
							if (separationDefinition.lineThickness) {
								separator.style.paddingLeft = (separationDefinition.spacing / 2) + "px";
								separator.style.marginRight = (separationDefinition.spacing / 2) + "px";
								separator.style.borderRight = separationDefinition.lineThickness + "px solid " + stringToCssColor(separationDefinition.lineColor);
							}
							else {
								separator.style.width = separationDefinition.spacing + "px";
							}
						}
						separator.style.overflow = "hidden";
						return separator;
					}
					else {
						return null;
					}
				}
				exports.renderSeparation = renderSeparation;
				function stringToCssColor(color) {
					var regEx = /#([0-9A-F]{2})([0-9A-F]{2})([0-9A-F]{2})([0-9A-F]{2})?/gi;
					var matches = regEx.exec(color);
					if (matches && matches[4]) {
						var a = parseInt(matches[1], 16) / 255;
						var r = parseInt(matches[2], 16);
						var g = parseInt(matches[3], 16);
						var b = parseInt(matches[4], 16);
						return "rgba(" + r + "," + g + "," + b + "," + a + ")";
					}
					else {
						return color;
					}
				}
				exports.stringToCssColor = stringToCssColor;
				function truncate(element, maxHeight, lineHeight) {
					var fits = function () {
						// Allow a one pixel overflow to account for rounding differences
						// between browsers
						return maxHeight - element.scrollHeight >= -1.0;
					};
					if (fits())
						return;
					var fullText = element.innerHTML;
					var truncateAt = function (idx) {
						element.innerHTML = fullText.substring(0, idx) + '...';
					};
					var breakableIndices = findBreakableIndices(fullText);
					var lo = 0;
					var hi = breakableIndices.length;
					var bestBreakIdx = 0;
					// Do a binary search for the longest string that fits
					while (lo < hi) {
						var mid = Math.floor((lo + hi) / 2);
						truncateAt(breakableIndices[mid]);
						if (fits()) {
							bestBreakIdx = breakableIndices[mid];
							lo = mid + 1;
						}
						else {
							hi = mid;
						}
					}
					truncateAt(bestBreakIdx);
					// If we have extra room, try to expand the string letter by letter
					// (covers the case where we have to break in the middle of a long word)
					if (lineHeight && maxHeight - element.scrollHeight >= lineHeight - 1.0) {
						var idx = findNextCharacter(fullText, bestBreakIdx);
						while (idx < fullText.length) {
							truncateAt(idx);
							if (fits()) {
								bestBreakIdx = idx;
								idx = findNextCharacter(fullText, idx);
							}
							else {
								break;
							}
						}
						truncateAt(bestBreakIdx);
					}
				}
				exports.truncate = truncate;
				function findBreakableIndices(html) {
					var results = [];
					var idx = findNextCharacter(html, -1);
					while (idx < html.length) {
						if (html[idx] == ' ') {
							results.push(idx);
						}
						idx = findNextCharacter(html, idx);
					}
					return results;
				}
				function findNextCharacter(html, currIdx) {
					currIdx += 1;
					// If we found the start of an HTML tag, keep advancing until we get
					// past it, so we don't end up truncating in the middle of the tag
					while (currIdx < html.length && html[currIdx] == '<') {
						while (currIdx < html.length && html[currIdx++] != '>')
							;
					}
					return currIdx;
				}
				function getFitStatus(element, containerEnd) {
					var start = element.offsetTop;
					var end = start + element.clientHeight;
					if (end <= containerEnd) {
						return Enums.ContainerFitStatus.FullyInContainer;
					}
					else if (start < containerEnd) {
						return Enums.ContainerFitStatus.Overflowing;
					}
					else {
						return Enums.ContainerFitStatus.FullyOutOfContainer;
					}
				}
				exports.getFitStatus = getFitStatus;


				/***/ })

			/******/ });
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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