/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/base/EventProvider',"sap/base/assert"],function(E,c){"use strict";var S=E.extend("sap.ui.model.SelectionModel",{constructor:function(s){E.apply(this);this.iSelectionMode=s||S.SINGLE_SELECTION;this.aSelectedIndices=[];this.iLeadIndex=-1;this.fnSort=function(a,b){return a-b;};this.fnSortReverse=function(a,b){return b-a;};}});S.SINGLE_SELECTION=0;S.MULTI_SELECTION=1;S.prototype.getSelectionMode=function(){return this.iSelectionMode;};S.prototype.setSelectionMode=function(s){this.iSelectionMode=s||S.SINGLE_SELECTION;};S.prototype.isSelectedIndex=function(i){return this.aSelectedIndices.indexOf(i)!==-1;};S.prototype.getLeadSelectedIndex=function(){return this.iLeadIndex;};S.prototype.setLeadSelectedIndex=function(l){c(typeof l==="number","iLeadIndex must be an integer");this.setSelectionInterval(l,l);return this;};S.prototype.getMinSelectionIndex=function(){if(this.aSelectedIndices.length>0){var i=this.aSelectedIndices.sort(this.fnSort);return i[0];}else{return-1;}};S.prototype.getMaxSelectionIndex=function(){if(this.aSelectedIndices.length>0){var i=this.aSelectedIndices.sort(this.fnSortReverse);return i[0];}else{return-1;}};S.prototype.getSelectedIndices=function(){var i=this.aSelectedIndices.sort(this.fnSort);return i;};S.prototype.setSelectionInterval=function(f,t){c(typeof f==="number","iFromIndex must be an integer");c(typeof t==="number","iToIndex must be an integer");if(this.iSelectionMode===S.SINGLE_SELECTION){f=t;}var F=Math.min(f,t);var T=Math.max(f,t);var o=this.aSelectedIndices.slice();var l={};var C=[];for(var i=0;i<o.length;i++){l[o[i]]=true;if(o[i]<f||o[i]>t){C.push(o[i]);}}var s=[];for(var I=F;I<=T;I++){s.push(I);if(!l[I]){C.push(I);}}this._update(s,t,C);return this;};S.prototype.addSelectionInterval=function(f,t){c(typeof f==="number","iFromIndex must be an integer");c(typeof t==="number","iToIndex must be an integer");if(this.iSelectionMode===S.SINGLE_SELECTION){return this.setSelectionInterval(f,t);}var F=Math.min(f,t);var T=Math.max(f,t);var C=[];var s=this.aSelectedIndices;for(var i=F;i<=T;i++){if(s.indexOf(i)===-1){s.push(i);C.push(i);}}this._update(s,T,C);return this;};S.prototype.moveSelectionInterval=function(s,m){c(typeof s==="number","iFromIndex must be an integer");c(typeof m==="number","iToIndex must be an integer");var C=[];var a=this.aSelectedIndices;var l=this.iLeadIndex;for(var i=0;i<a.length;i++){var I=a[i];if(I>=s){C.push(a[i]);a[i]+=m;C.push(a[i]);if(I===this.iLeadIndex){l+=m;}}}this._update(a,l,C);return this;};S.prototype.removeSelectionInterval=function(f,t){c(typeof f==="number","iFromIndex must be an integer");c(typeof t==="number","iToIndex must be an integer");if(this.iSelectionMode===S.SINGLE_SELECTION){f=t;}var F=Math.min(f,t);var T=Math.max(f,t);var C=[];var s=this.aSelectedIndices;var l=this.iLeadIndex;for(var i=F;i<=T;i++){var I=s.indexOf(i);if(I>-1){s.splice(I,1);C.push(i);}if(i===this.iLeadIndex){l=-1;}}this._update(s,l,C);return this;};S.prototype.sliceSelectionInterval=function(f,t){c(typeof f==="number","iFromIndex must be an integer");c(typeof t==="number","iToIndex must be an integer");var F=Math.min(f,t);var T=Math.max(f,t);var C=[];var r=[];var o=this.aSelectedIndices.slice(0);var s=this.aSelectedIndices;var l=this.iLeadIndex;var R=T-F+1;for(var I=T;I>=F;I--){var a=s.indexOf(I);if(a>-1){s.splice(a,1);r.push(I);}if(I===this.iLeadIndex){l=-1;}}for(var I=0;I<s.length;I++){var O=s[I];if(O>=F){var n=s[I]-R;if(O===l){l=n;}s[I]=n;if(o.indexOf(n)===-1){C.push(n);}}}for(var i=0;i<r.length;i++){var I=o[o.length-1-i];if(C.indexOf(I)===-1){C.push(I);}}for(var i=0;i<r.length;i++){if(s.indexOf(r[i])===-1&&C.indexOf(r[i])===-1){C.push(r[i]);}}this._update(s,l,C);return this;};S.prototype.clearSelection=function(){if(this.aSelectedIndices.length>0||this.iLeadIndex!==-1){this._update([],-1,this.aSelectedIndices.slice());}return this;};S.prototype.attachSelectionChanged=function(d,f,l){this.attachEvent("selectionChanged",d,f,l);return this;};S.prototype.detachSelectionChanged=function(f,l){this.detachEvent("selectionChanged",f,l);return this;};S.prototype.fireSelectionChanged=function(p){this.fireEvent("selectionChanged",p);return this;};S.prototype._update=function(s,l,C,b){var p={rowIndices:C&&C.sort(this.fnSort),selectAll:b};this.aSelectedIndices=s;p.oldIndex=this.iLeadIndex;if(this.iLeadIndex!==l){this.iLeadIndex=l;p.leadIndex=this.iLeadIndex;}if(C.length>0||typeof p.leadIndex!=="undefined"){this.fireSelectionChanged(p);}};S.prototype.selectAll=function(t){c(typeof t==="number","iToIndex must be an integer");var o=this.aSelectedIndices.slice();var l={};var C=[];var s=[];var i=0;for(i=0;i<o.length;i++){l[o[i]]=true;if(o[i]>t){C.push(o[i]);}}for(i=0;i<=t;i++){s.push(i);if(!l[i]){C.push(i);}}this._update(s,0,C,true);return this;};return S;});
