/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/performance/Measurement","sap/ui/performance/XHRInterceptor","sap/base/util/LoaderExtensions","sap/base/util/now","sap/base/util/uid","sap/base/Log","sap/ui/thirdparty/URI"],function(M,X,L,a,u,b,U){"use strict";var H=window.location.host,I="INTERACTION",c=[],p=e(),C={"application/zip":true,"application/vnd.rar":true,"application/gzip":true,"application/x-tar":true,"application/java-archive":true,"image/jpeg":true,"application/pdf":true},s="zip,rar,arj,z,gz,tar,lzh,cab,hqx,ace,jar,ear,war,jpg,jpeg,pdf,gzip";function d(i){var l=new U(i).host();return l&&l!==H;}function h(V){var i=V.toString();var l='';for(var n=0;n<i.length;n+=2){l+=String.fromCharCode(parseInt(i.substr(n,2),16));}return l.trim();}function e(T){return{event:"startup",trigger:"undetermined",component:"undetermined",appVersion:"undetermined",start:T||window.performance.timing.fetchStart,end:0,navigation:0,roundtrip:0,processing:0,duration:0,requests:[],measurements:[],sapStatistics:[],requestTime:0,networkTime:0,bytesSent:0,bytesReceived:0,requestCompression:"X",busyDuration:0,id:u(),passportAction:"undetermined_startup_0"};}function f(i){if(i.start>p.start&&i.end<p.end){return i;}}function g(R){var i=R.startTime>0&&R.startTime<=R.requestStart&&R.requestStart<=R.responseEnd;return i&&R.initiatorType==="xmlhttprequest";}function j(R){this.end=R.responseEnd>this.end?R.responseEnd:this.end;p.requestTime+=(R.responseEnd-R.startTime);if(this.roundtripHigherLimit<=R.startTime){p.navigation+=(this.navigationHigherLimit-this.navigationLowerLimit);p.roundtrip+=(this.roundtripHigherLimit-this.roundtripLowerLimit);this.navigationLowerLimit=R.startTime;this.roundtripLowerLimit=R.startTime;}if(R.responseEnd>this.roundtripHigherLimit){this.roundtripHigherLimit=R.responseEnd;}if(R.requestStart>this.navigationHigherLimit){this.navigationHigherLimit=R.requestStart;}}function k(R){var T={start:R[0].startTime,end:R[0].responseEnd,navigationLowerLimit:R[0].startTime,navigationHigherLimit:R[0].requestStart,roundtripLowerLimit:R[0].startTime,roundtripHigherLimit:R[0].responseEnd};R.forEach(j,T);p.navigation+=(T.navigationHigherLimit-T.navigationLowerLimit);p.roundtrip+=(T.roundtripHigherLimit-T.roundtripLowerLimit);if(p.networkTime){var i=p.requestTime-p.networkTime;p.networkTime=i/R.length;}else{p.networkTime=0;}if(p.processing===0){var l=p.start-window.performance.timing.fetchStart;p.duration=T.end-l;p.processing=T.start-l;}}function m(T){if(p){var i=window.performance.getEntriesByType("resource");p.end=T;p.duration=p.processing;p.requests=i.filter(g);p.completeRoundtrips=0;p.measurements=M.filterMeasurements(f,true);if(p.requests.length>0){k(p.requests);}p.completeRoundtrips=p.requests.length;var P=p.processing-p.navigation-p.roundtrip;p.processing=P>-1?P:0;p.completed=true;Object.freeze(p);c.push(p);var l=c[c.length-1];if(F.onInteractionFinished&&l){F.onInteractionFinished(l);}if(b.isLoggable()){b.debug("Interaction step finished: trigger: "+p.trigger+"; duration: "+p.duration+"; requests: "+p.requests.length,"Interaction.js");}p=null;}}function o(i){var l,V;if(i){var n,G;n=sap.ui.require("sap/ui/core/Component");while(n&&i&&i.getParent){G=n.getOwnerComponentFor(i);if(G||i instanceof n){G=G||i;var J=G.getManifestEntry("sap.app");l=J&&J.id||G.getMetadata().getName();V=J&&J.applicationVersion&&J.applicationVersion.version;}i=i.getParent();}}return{id:l?l:"undetermined",version:V?V:""};}var q=false,r=false,t,v,w=false,S=false,x=0,y=0,z=Object.getOwnPropertyDescriptor(HTMLScriptElement.prototype,"src");function A(){Object.defineProperty(HTMLScriptElement.prototype,"src",{set:function(i){var l;if(!this.dataset.sapUiCoreInteractionHandled){l=F.notifyAsyncStep();this.addEventListener("load",function(){l();});this.addEventListener("error",function(){l();});this.dataset.sapUiCoreInteractionHandled="true";}z.set.call(this,i);},get:z.get});}function B(){X.register(I,"send",function(){if(this.pendingInteraction){this.pendingInteraction.bytesSent+=arguments[0]?arguments[0].length:0;}});X.register(I,"setRequestHeader",function(i,V){if(!this.requestHeaderLength){this.requestHeaderLength=0;}this.requestHeaderLength+=(i+"").length+(V+"").length;});X.register(I,"open",function(){var i,l,R;function n(G){if(this.readyState===4){G();}}if(p){if(!d(arguments[1])){i=F.passportHeader.get(this);if(i&&i.length>=370){l=h(i.substring(150,230));if(parseInt(i.substring(8,10),16)>2){R=i.substring(372,404);}}if(!i||l&&R&&p.passportAction.endsWith(l)){this.addEventListener("readystatechange",E.bind(this,p.id));}}this.addEventListener("readystatechange",n.bind(this,F.notifyAsyncStep()));this.pendingInteraction=p;this._ui5RequestUrl=arguments[1]||"";}});}function D(i,l,n,G){var J=i.split('.').pop().split(/\#|\?/)[0];if(l==='gzip'||l==='br'||n in C||(J&&s.indexOf(J)!==-1)||G<1024){return true;}else{return false;}}function E(i){if(this.readyState===4){if(this.pendingInteraction&&!this.pendingInteraction.completed&&p.id===i){var l=this.getResponseHeader("content-length"),n=D(this.responseURL||this._ui5RequestUrl,this.getResponseHeader("content-encoding"),this.getResponseHeader("content-type"),l),G=this.getResponseHeader("sap-perf-fesrec");this.pendingInteraction.bytesReceived+=l?parseInt(l):0;this.pendingInteraction.bytesReceived+=this.getAllResponseHeaders().length;this.pendingInteraction.bytesSent+=this.requestHeaderLength||0;this.pendingInteraction.requestCompression=n&&(this.pendingInteraction.requestCompression!==false);this.pendingInteraction.networkTime+=G?Math.round(parseFloat(G,10)/1000):0;var J=this.getResponseHeader("sap-statistics");if(J){var T=window.performance.getEntriesByType("resource");this.pendingInteraction.sapStatistics.push({url:this.responseURL,statistics:J,timing:T?T[T.length-1]:undefined});}delete this.requestHeaderLength;delete this.pendingInteraction;}}}var F={getAll:function(i){if(i){F.end(true);}return c;},filter:function(n){var G=[];if(n){for(var i=0,l=c.length;i<l;i++){if(n(c[i])){G.push(c[i]);}}}return G;},getPending:function(){return p;},clear:function(){c=[];},start:function(T,i){var l=a();if(p){m(l);}if(v){clearTimeout(v);}x=0;if(window.performance.clearResourceTimings){window.performance.clearResourceTimings();}var n=o(i);p=e(l);p.event=T;p.component=n.id;p.appVersion=n.version;p.start=l;if(i&&i.getId){p.trigger=i.getId();}if(b.isLoggable(null,"sap.ui.Performance")){console.time("INTERACTION: "+p.trigger+" - "+p.event);}if(b.isLoggable()){b.debug("Interaction step started: trigger: "+p.trigger+"; type: "+p.event,"Interaction.js");}},end:function(i){if(p){if(i){if(b.isLoggable(null,"sap.ui.Performance")){console.timeEnd("INTERACTION: "+p.trigger+" - "+p.event);}m(p.preliminaryEnd||a());if(b.isLoggable()){b.debug("Interaction ended...");}}else{p.preliminaryEnd=a();p.processing=p.preliminaryEnd-p.start;}}},getActive:function(){return q;},setActive:function(i){if(i&&!q){B();A();L.notifyResourceLoading=F.notifyAsyncStep;}q=i;},notifyShowBusyIndicator:function(i){i._sapui_fesr_fDelayedStartTime=a()+i.getBusyIndicatorDelay();},notifyHideBusyIndicator:function(i){if(i._sapui_fesr_fDelayedStartTime){var l=a()-i._sapui_fesr_fDelayedStartTime;F.addBusyDuration((l>0)?l:0);delete i._sapui_fesr_fDelayedStartTime;}},notifyStepStart:function(i,l){if(q){if((!p&&t&&!r)||l){var T;if(l){T="startup";}else if(t.originalEvent){T=t.originalEvent.type;}else{T=t.type;}F.start(T,i);p=F.getPending();if(p&&!p.completed&&F.onInteractionStarted){p.passportAction=F.onInteractionStarted(p,l);}t=null;r=true;setTimeout(function(){t=null;r=false;},0);}}},notifyAsyncStep:function(i){if(p){if(b.isLoggable(null,"sap.ui.Performance")&&i){console.time(i);}var l=p.id;F.notifyAsyncStepStart();return function(){F.notifyAsyncStepEnd(l);if(b.isLoggable(null,"sap.ui.Performance")&&i){console.timeEnd(i);}};}else{return function(){};}},notifyAsyncStepStart:function(){if(p){x++;clearTimeout(v);w=false;if(b.isLoggable()){b.debug("Interaction relevant step started - Number of pending steps: "+x);}}},notifyAsyncStepEnd:function(i){if(p&&i===p.id){x--;F.notifyStepEnd(true);if(b.isLoggable()){b.debug("Interaction relevant step stopped - Number of pending steps: "+x);}}},notifyStepEnd:function(i){if(q&&!S){if(x===0||!i){if(w||!i){F.end(true);if(b.isLoggable()){b.debug("Interaction stopped");}w=false;}else{F.end();w=true;if(v){clearTimeout(v);}v=setTimeout(F.notifyStepEnd,250);if(b.isLoggable()){b.debug("Interaction check for idle time - Number of pending steps: "+x);}}}}},notifyEventStart:function(i){t=q?i:null;},notifyScrollEvent:function(i){if(q){if(!y){F.notifyEventStart(i);}else{clearTimeout(y);}y=setTimeout(function(){F.notifyStepStart(i.sourceElement);y=0;F.notifyStepEnd();},250);}},notifyEventEnd:function(){if(t){if(t.type.match(/^(mousedown|touchstart|keydown)$/)){F.end(true);}}},onInteractionStarted:null,onInteractionFinished:null,setStepComponent:function(i){if(q&&p&&i&&!p.stepComponent){p.stepComponent=i;}},addBusyDuration:function(i){if(q&&p){if(!p.busyDuration){p.busyDuration=0;}p.busyDuration+=i;}}};return F;});
