/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObject","sap/ui/rta/toolbar/Fiori","sap/ui/rta/toolbar/Standalone","sap/ui/rta/toolbar/Personalization","sap/ui/dt/DesignTime","sap/ui/dt/Overlay","sap/ui/rta/command/Stack","sap/ui/rta/command/CommandFactory","sap/ui/rta/command/LREPSerializer","sap/ui/rta/plugin/Rename","sap/ui/rta/plugin/DragDrop","sap/ui/rta/plugin/RTAElementMover","sap/ui/rta/plugin/CutPaste","sap/ui/rta/plugin/Remove","sap/ui/rta/plugin/CreateContainer","sap/ui/rta/plugin/additionalElements/AdditionalElementsPlugin","sap/ui/rta/plugin/additionalElements/AddElementsDialog","sap/ui/rta/plugin/additionalElements/AdditionalElementsAnalyzer","sap/ui/rta/plugin/Combine","sap/ui/rta/plugin/Split","sap/ui/rta/plugin/Selection","sap/ui/rta/plugin/Settings","sap/ui/rta/plugin/Stretch","sap/ui/rta/plugin/ControlVariant","sap/ui/rta/plugin/iframe/AddIFrame","sap/ui/dt/plugin/ToolHooks","sap/ui/dt/plugin/ContextMenu","sap/ui/dt/plugin/TabHandling","sap/ui/rta/Utils","sap/ui/dt/Util","sap/ui/dt/ElementUtil","sap/ui/fl/Utils","sap/ui/fl/LayerUtils","sap/ui/fl/Layer","sap/ui/fl/write/api/ReloadInfoAPI","sap/ui/fl/write/api/FeaturesAPI","sap/ui/fl/write/api/VersionsAPI","sap/ui/fl/write/api/PersistenceWriteAPI","sap/m/MessageBox","sap/m/MessageToast","sap/ui/rta/util/PopupManager","sap/ui/core/BusyIndicator","sap/ui/dt/DOMUtil","sap/ui/rta/util/StylesLoader","sap/ui/rta/appVariant/Feature","sap/ui/Device","sap/ui/rta/service/index","sap/ui/rta/util/ServiceEventBus","sap/ui/dt/OverlayRegistry","sap/base/strings/capitalize","sap/base/util/UriParameters","sap/ui/performance/Measurement","sap/base/Log","sap/ui/events/KeyCodes","sap/ui/model/json/JSONModel","sap/ui/rta/util/validateFlexEnabled"],function(q,M,F,S,P,D,O,C,a,L,R,b,c,d,e,f,A,g,h,i,j,k,l,m,n,o,T,p,r,U,s,E,t,u,v,w,x,V,y,z,B,G,H,I,J,K,N,Q,W,X,Y,Z,$,_,a1,b1,c1){"use strict";var d1="STARTING";var e1="STARTED";var f1="STOPPED";var g1="FAILED";var h1="SERVICE_STARTING";var i1="SERVICE_STARTED";var j1="SERVICE_FAILED";var k1=M.extend("sap.ui.rta.RuntimeAuthoring",{metadata:{library:"sap.ui.rta",associations:{rootControl:{type:"sap.ui.base.ManagedObject"}},properties:{customFieldUrl:"string",showCreateCustomField:"boolean",showToolbars:{type:"boolean",defaultValue:true},triggeredFromDialog:{type:"boolean",defaultValue:false},showWindowUnloadDialog:{type:"boolean",defaultValue:true},commandStack:{type:"any"},plugins:{type:"any",defaultValue:{}},flexSettings:{type:"object",defaultValue:{layer:v.CUSTOMER,developerMode:true}},mode:{type:"string",defaultValue:"adaptation"},metadataScope:{type:"string",defaultValue:"default"},validateAppVersion:{type:"boolean",defaultValue:false}},events:{start:{parameters:{editablePluginsCount:{type:"int"}}},stop:{},failed:{},selectionChange:{parameters:{selection:{type:"sap.ui.dt.Overlay[]"}}},modeChanged:{},undoRedoStackModified:{}}},_sAppTitle:null,_dependents:null,_sStatus:f1,constructor:function(){M.apply(this,arguments);this._dependents={};this._mServices={};this._mCustomServicesDictinary={};this.iEditableOverlaysCount=0;this.addDependent(new G(),'popupManager');if(this.getShowToolbars()){this.getPopupManager().attachOpen(this.onPopupOpen,this);this.getPopupManager().attachClose(this.onPopupClose,this);}if(window.parent!==window){this.startService('receiver');}if(this._shouldValidateFlexEnabled()){this.attachEvent("start",c1.bind(null,this));}},_RELOAD:{NOT_NEEDED:"NO_RELOAD",VIA_HASH:"CROSS_APP_NAVIGATION",RELOAD_PAGE:"HARD_RELOAD"}});k1.prototype._shouldValidateFlexEnabled=function(){var o1=document.location.hostname;return o1.endsWith(".sap"+".corp")||o1==="localhost";};k1.prototype.getDefaultPlugins=function(){if(!this._mDefaultPlugins){var o1=new a({flexSettings:this.getFlexSettings()});this._mDefaultPlugins={};this._mDefaultPlugins["selection"]=new k({commandFactory:o1,multiSelectionRequiredPlugins:[i.getMetadata().getName(),e.getMetadata().getName()],elementEditableChange:this._onElementEditableChange.bind(this)});var p1=new c({commandFactory:o1});this._mDefaultPlugins["dragDrop"]=new b({elementMover:p1,commandFactory:o1,dragStarted:this._handleStopCutPaste.bind(this)});this._mDefaultPlugins["rename"]=new R({commandFactory:o1,editable:this._handleStopCutPaste.bind(this)});this._mDefaultPlugins["additionalElements"]=new A({commandFactory:o1,analyzer:h,dialog:new g()});this._mDefaultPlugins["createContainer"]=new f({commandFactory:o1});this._mDefaultPlugins["remove"]=new e({commandFactory:o1});this._mDefaultPlugins["cutPaste"]=new d({elementMover:p1,commandFactory:o1});this._mDefaultPlugins["settings"]=new l({commandFactory:o1});this._mDefaultPlugins["combine"]=new i({commandFactory:o1});this._mDefaultPlugins["split"]=new j({commandFactory:o1});this._mDefaultPlugins["contextMenu"]=new p();this._mDefaultPlugins["tabHandling"]=new r();this._mDefaultPlugins["stretch"]=new m();this._mDefaultPlugins["controlVariant"]=new n({commandFactory:o1});this._mDefaultPlugins["addIFrame"]=new o({commandFactory:o1});this._mDefaultPlugins["toolHooks"]=new T();}return q.extend({},this._mDefaultPlugins);};k1.prototype.addDependent=function(o1,p1,q1){q1=typeof q1==='undefined'?true:!!q1;if(!(p1 in this._dependents)){if(p1&&q1){this['get'+Y(p1,0)]=this.getDependent.bind(this,p1);}this._dependents[p1||o1.getId()]=o1;}else{throw s.createError("RuntimeAuthoring#addDependent",s.printf("Can't add dependency with same key '{0}'",p1),"sap.ui.rta");}};k1.prototype.getDependent=function(o1){return this._dependents[o1];};k1.prototype.getDependents=function(){return this._dependents;};k1.prototype.removeDependent=function(o1){delete this._dependents[o1];};k1.prototype._destroyDefaultPlugins=function(o1){for(var p1 in this._mDefaultPlugins){var q1=this._mDefaultPlugins[p1];if(q1&&!q1.bIsDestroyed){if(!o1||o1[p1]!==q1){q1.destroy();}}}if(!o1){this._mDefaultPlugins=null;}};k1.prototype.onPopupOpen=function(o1){var p1=o1.getParameters().getSource();if(p1.isA("sap.m.Dialog")&&this.getToolbar().isA("sap.ui.rta.toolbar.Fiori")){this.getToolbar().setColor("contrast");}this.getToolbar().bringToFront();};k1.prototype.onPopupClose=function(o1){if(o1.getParameters()instanceof sap.m.Dialog){this.getToolbar().setColor();}};k1.prototype.setPlugins=function(o1){if(this._oDesignTime){throw new Error('Cannot replace plugins: runtime authoring already started');}this.setProperty("plugins",o1);};k1.prototype.setFlexSettings=function(o1){var p1=Z.fromQuery(window.location.search);var q1=p1.get("sap-ui-layer");o1=q.extend({},this.getFlexSettings(),o1);if(q1){o1.layer=q1.toUpperCase();}if(o1.scenario||o1.baseId){var r1=t.buildLrepRootNamespace(o1.baseId,o1.scenario,o1.projectId);o1.rootNamespace=r1;o1.namespace=r1+"changes/";}U.setRtaStyleClassName(o1.layer);this.setProperty("flexSettings",o1);};k1.prototype.getLayer=function(){return this.getFlexSettings().layer;};k1.prototype.getRootControlInstance=function(){if(!this._oRootControl){this._oRootControl=E.getElementInstance(this.getRootControl());}return this._oRootControl;};k1.prototype._getTextResources=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");};k1.prototype._initVersioning=function(){return V.initialize({selector:this.getRootControlInstance(),layer:this.getLayer()}).then(function(o1){this._oVersionsModel=o1;}.bind(this));};k1.prototype.start=function(){this._sStatus=d1;var o1;var p1;var q1=this.getRootControlInstance();if(!this._oDesignTime){if(!q1){p1=new Error("Root control not found");_.error(p1);return Promise.reject(p1);}if(this.getValidateAppVersion()&&!t.isCorrectAppVersionFormat(t.getAppVersionFromManifest(t.getAppComponentForControl(q1).getManifest()))){p1=this._getTextResources().getText("MSG_INCORRECT_APP_VERSION_ERROR");_.error(p1);return Promise.reject(p1);}return this._initVersioning().then(this._determineReload.bind(this)).then(function(r1){if(r1){return Promise.reject("Reload triggered");}if(!this.getPlugins()||!Object.keys(this.getPlugins()).length){this.setPlugins(this.getDefaultPlugins());}this._destroyDefaultPlugins(this.getPlugins());Object.keys(this.getPlugins()).forEach(function(u1){if(this.getPlugins()[u1].attachElementModified){this.getPlugins()[u1].attachElementModified(this._handleElementModified,this);}}.bind(this));if(this.getPlugins()["settings"]){this.getPlugins()["settings"].setCommandStack(this.getCommandStack());}this._oSerializer=new L({commandStack:this.getCommandStack(),rootControl:this.getRootControl()});var s1=Object.keys(this.getPlugins());var t1=s1.map(function(u1){return this.getPlugins()[u1];},this);o1=new Promise(function(u1,v1){$.start("rta.dt.startup","Measurement of RTA: DesignTime start up");this._oDesignTime=new D({scope:this.getMetadataScope(),plugins:t1});this._oDesignTime.addRootElement(this._oRootControl);q(O.getOverlayContainer()).addClass("sapUiRta");if(this.getLayer()===v.USER){q(O.getOverlayContainer()).addClass("sapUiRtaPersonalize");}else{q("body").addClass("sapUiRtaMode");}this._oDesignTime.getSelectionManager().attachChange(function(w1){this.fireSelectionChange({selection:w1.getParameter("selection")});},this);this._oDesignTime.attachEventOnce("synced",function(){u1();$.end("rta.dt.startup","Measurement of RTA: DesignTime start up");},this);this._oDesignTime.attachEventOnce("syncFailed",function(w1){v1(w1.getParameter("error"));});}.bind(this));this._oldUnloadHandler=window.onbeforeunload;window.onbeforeunload=this._onUnload.bind(this);}.bind(this)).then(function(){var r1={selector:this.getRootControlInstance(),layer:this.getLayer()};return y.getResetAndPublishInfo(r1).then(function(s1){this.bInitialResetEnabled=s1.isResetEnabled;this.bInitialPublishEnabled=s1.isPublishEnabled;}.bind(this));}.bind(this)).then(function(){if(this.getShowToolbars()){return this._getToolbarButtonsVisibility().then(this._createToolsMenu.bind(this));}}.bind(this)).then(this._onStackModified.bind(this)).then(function(){J.loadStyles('InPageStyles').then(function(r1){var s1=r1.replace(/%scrollWidth%/g,I.getScrollbarWidth()+'px');I.insertStyles(s1,O.getOverlayContainer().get(0));});}).then(function(){return o1;}).then(function(){this.getPopupManager().setRta(this);if(this.getShowToolbars()){return this.getToolbar().show();}}.bind(this)).then(function(){if(N.browser.name==="ff"){q(document).on('contextmenu',l1);}}).then(function(){this.fnKeyDown=this._onKeyDown.bind(this);q(document).on("keydown",this.fnKeyDown);var r1=X.getOverlay(this.getRootControl());this._$RootControl=r1.getAssociatedDomRef();if(this._$RootControl){this._$RootControl.addClass("sapUiRtaRoot");}}.bind(this)).then(function(){this._sStatus=e1;this.fireStart({editablePluginsCount:this.iEditableOverlaysCount});}.bind(this)).catch(function(p1){if(p1!=="Reload triggered"){this._sStatus=g1;this.fireFailed(p1);}if(p1){this.destroy();return Promise.reject(p1);}}.bind(this));}};function l1(){return false;}k1.prototype._getToolbarButtonsVisibility=function(){return x.isPublishAvailable().then(function(o1){return K.isSaveAsAvailable(this.getRootControlInstance(),this.getLayer(),this._oSerializer).then(function(p1){return{publishAvailable:o1,saveAsAvailable:o1&&p1};});}.bind(this));};k1.prototype._isDraftAvailable=function(){return V.isDraftAvailable({selector:this.getRootControlInstance(),layer:this.getLayer()});};var m1=function(o1){H.hide();var p1=o1.userMessage||o1.stack||o1.message||o1.status||o1;var q1=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");_.error("Failed to transfer changes",p1);var r1=q1.getText("MSG_LREP_TRANSFER_ERROR")+"\n"+q1.getText("MSG_ERROR_REASON",p1);z.error(r1,{styleClass:U.getRtaStyleClassName()});};k1.prototype.setCommandStack=function(o1){var p1=this.getProperty("commandStack");if(p1){p1.detachModified(this._onStackModified,this);}if(this._oInternalCommandStack){this._oInternalCommandStack.destroy();delete this._oInternalCommandStack;}var q1=this.setProperty("commandStack",o1);if(o1){o1.attachModified(this._onStackModified,this);}if(this.getPlugins()&&this.getPlugins()["settings"]){this.getPlugins()["settings"].setCommandStack(o1);}return q1;};k1.prototype.getCommandStack=function(){var o1=this.getProperty("commandStack");if(!o1){o1=new C();this._oInternalCommandStack=o1;this.setCommandStack(o1);}return o1;};k1.prototype._onStackModified=function(){var o1=this.getCommandStack();var p1=o1.canUndo();var q1=o1.canRedo();if(this.getShowToolbars()){var r1=this.getToolbar().getModel("versions");r1.setDirtyChanges(p1);this._oToolbarControlsModel.setProperty("/undoEnabled",p1);this._oToolbarControlsModel.setProperty("/redoEnabled",q1);this._oToolbarControlsModel.setProperty("/publishEnabled",this.bInitialPublishEnabled||p1);this._oToolbarControlsModel.setProperty("/restoreEnabled",this.bInitialResetEnabled||p1);}this.fireUndoRedoStackModified();};k1.prototype._checkToolbarAndExecuteFunction=function(o1,p1){if(this.getShowToolbars()&&this.getToolbar&&this.getToolbar()){return this.getToolbar()[o1](p1);}};k1.prototype.getSelection=function(){if(this._oDesignTime){return this._oDesignTime.getSelectionManager().get();}return[];};k1.prototype.stop=function(o1,p1){this._checkToolbarAndExecuteFunction("setBusy",true);return this._handleReloadOnExit(p1).then(function(q1){return((o1)?Promise.resolve():this._serializeToLrep(this)).then(this._checkToolbarAndExecuteFunction.bind(this,"hide")).then(function(){this.fireStop();if(q1.reloadMethod&&(q1.reloadMethod!==this._RELOAD.NOT_NEEDED)){q1.deleteMaxLayer=true;q1.triggerHardReload=(q1.reloadMethod===this._RELOAD.RELOAD_PAGE);return this._handleUrlParameterOnExit(q1);}}.bind(this));}.bind(this)).catch(m1).then(function(){this._checkToolbarAndExecuteFunction("setBusy",false);this._sStatus=f1;q("body").removeClass("sapUiRtaMode");}.bind(this));};k1.prototype.restore=function(){return this._onRestore();};k1.prototype.transport=function(){return this._onTransport();};k1.prototype.undo=function(){return this._onUndo();};k1.prototype.redo=function(){return this._onRedo();};k1.prototype.canUndo=function(){return this.getCommandStack().canUndo();};k1.prototype.canRedo=function(){return this.getCommandStack().canRedo();};k1.prototype._onKeyDown=function(o1){var p1=N.os.macintosh;var q1=O.getOverlayContainer().get(0).contains(document.activeElement);var r1=this.getShowToolbars()&&this.getToolbar().getDomRef().contains(document.activeElement);var s1=false;q(".sapUiDtContextMenu").each(function(w1,x1){if(x1.contains(document.activeElement)){s1=true;}});var t1=document.body===document.activeElement;var u1=q(document.activeElement).parents('.sapUiRtaEditableField').length>0;if((q1||r1||s1||t1)&&!u1){var v1=p1?o1.metaKey:o1.ctrlKey;if(o1.keyCode===a1.Z&&o1.shiftKey===false&&o1.altKey===false&&v1===true){this._onUndo().then(o1.stopPropagation.bind(o1));}else if(((p1&&o1.keyCode===a1.Z&&o1.shiftKey===true)||(!p1&&o1.keyCode===a1.Y&&o1.shiftKey===false))&&o1.altKey===false&&v1===true){this._onRedo().then(o1.stopPropagation.bind(o1));}}};k1.prototype._onUnload=function(){var o1=this.getCommandStack();var p1=o1.canUndo()||o1.canRedo();if(p1&&this.getShowWindowUnloadDialog()){var q1=this._getTextResources().getText("MSG_UNSAVED_CHANGES");return q1;}window.onbeforeunload=this._oldUnloadHandler;};k1.prototype._serializeAndSave=function(){return this._oSerializer.saveCommands(this._oVersionsModel.getProperty("/versioningEnabled"));};k1.prototype._serializeToLrep=function(){if(!this._bReloadNeeded){return this._oSerializer.needsReload().then(function(o1){this._bReloadNeeded=o1;return this._serializeAndSave();}.bind(this));}return this._serializeAndSave();};k1.prototype._onUndo=function(){this._handleStopCutPaste();return this.getCommandStack().undo();};k1.prototype._onRedo=function(){this._handleStopCutPaste();return this.getCommandStack().redo();};k1.prototype._onActivateDraft=function(o1){var p1=this.getLayer();var q1=this.getRootControlInstance();return V.activateDraft({layer:p1,selector:q1,title:o1.getParameter("versionTitle")}).then(function(){this._showMessageToast("MSG_DRAFT_ACTIVATION_SUCCESS");this.bInitialResetEnabled=true;this._oToolbarControlsModel.setProperty("/restoreEnabled",true);this.getCommandStack().removeAllCommands();}.bind(this)).catch(function(r1){U.showMessageBox("error","MSG_DRAFT_ACTIVATION_FAILED",{error:r1});});};k1.prototype._handleDiscard=function(){var o1=this.getLayer();k1.enableRestart(o1,this.getRootControlInstance());if(!t.getUshellContainer()){var p1={hasDraftChanges:false,layer:o1};this.getCommandStack().removeAllCommands();return this._triggerHardReload(p1);}var q1=true;var r1=this._removeVersionParameterForFLP(t.getParsedURLHash(),q1);this.getCommandStack().removeAllCommands();this._triggerCrossAppNavigation(r1);return this.stop(true,true);};k1.prototype._onDiscardDraft=function(){return U.showMessageBox("warning","MSG_DRAFT_DISCARD_DIALOG",{actions:[z.Action.OK,z.Action.CANCEL],emphasizedAction:z.Action.OK}).then(function(o1){if(o1===z.Action.OK){return V.discardDraft({layer:this.getLayer(),selector:this.getRootControlInstance(),updateState:true}).then(this._handleDiscard.bind(this));}}.bind(this));};k1.prototype._createToolsMenu=function(o1){if(!this.getDependent('toolbar')){var p1;if(this.getLayer()===v.USER){p1=P;}else if(U.getFiori2Renderer()){p1=F;}else{p1=S;}if(this.getLayer()===v.USER){this.addDependent(new p1({textResources:this._getTextResources(),exit:this.stop.bind(this,false,true),restore:this._onRestore.bind(this)}),'toolbar');}else{this.addDependent(new p1({modeSwitcher:this.getMode(),textResources:this._getTextResources(),exit:this.stop.bind(this,false,false),transport:this._onTransport.bind(this),restore:this._onRestore.bind(this),undo:this._onUndo.bind(this),redo:this._onRedo.bind(this),modeChange:this._onModeChange.bind(this),manageApps:K.onGetOverview.bind(null,true,this.getLayer()),appVariantOverview:this._onGetAppVariantOverview.bind(this),saveAs:K.onSaveAs.bind(K,true,true,this.getLayer(),null),activateDraft:this._onActivateDraft.bind(this),discardDraft:this._onDiscardDraft.bind(this)}),'toolbar');}var q1=o1.saveAsAvailable;var r1=q1&&K.isOverviewExtended();this._oToolbarControlsModel=new b1({undoEnabled:false,redoEnabled:false,publishVisible:o1.publishAvailable,publishEnabled:this.bInitialPublishEnabled,restoreEnabled:this.bInitialResetEnabled,appVariantsOverviewVisible:q1&&r1,appVariantsOverviewEnabled:q1&&r1,saveAsVisible:q1,saveAsEnabled:false,manageAppsVisible:q1&&!r1,manageAppsEnabled:q1&&!r1});if(q1){K.isManifestSupported().then(function(s1){this._oToolbarControlsModel.setProperty("/saveAsEnabled",s1);this._oToolbarControlsModel.setProperty("/appVariantsOverviewEnabled",s1);this._oToolbarControlsModel.setProperty("/manageAppsEnabled",s1);}.bind(this));}}this.getToolbar().setModel(this._oVersionsModel,"versions");this.getToolbar().setModel(this._oToolbarControlsModel,"controls");};k1.prototype._onGetAppVariantOverview=function(o1){var p1=o1.getParameter("item");var q1=p1.getId()==='keyUser';return K.onGetOverview(q1,this.getLayer());};k1.prototype.destroy=function(){q.map(this._dependents,function(o1,p1){this.removeDependent(p1);o1.destroy(true);}.bind(this));Object.keys(this._mServices).forEach(function(o1){this.stopService(o1);},this);if(this._oDesignTime){this._oDesignTime.destroy();this._oDesignTime=null;q(document).off("keydown",this.fnKeyDown);this._destroyDefaultPlugins();this.setPlugins(null);}if(this._$RootControl){this._$RootControl.removeClass("sapUiRtaRoot");}this.setCommandStack(null);if(this._oServiceEventBus){this._oServiceEventBus.destroy();}if(N.browser.name==="ff"){q(document).off("contextmenu",l1);}window.onbeforeunload=this._oldUnloadHandler;M.prototype.destroy.apply(this,arguments);};k1.prototype._onTransport=function(){this._handleStopCutPaste();H.show(500);return this._serializeToLrep().then(function(){H.hide();var o1=t.isApplicationVariant(this._oRootControl)&&!t.isVariantByStartupParameter(this._oRootControl);return((o1)?K.getAppVariantDescriptor(this._oRootControl):Promise.resolve()).then(function(p1){var q1=[];if(p1){q1.push(p1);}return y.publish({selector:this.getRootControlInstance(),styleClass:U.getRtaStyleClassName(),layer:this.getLayer(),appVariantDescriptors:q1}).then(function(r1){if(r1!=="Error"&&r1!=="Cancel"){B.show(r1);if(this.getShowToolbars()){y.getResetAndPublishInfo({selector:this.getRootControlInstance(),layer:this.getLayer()}).then(function(s1){this._oToolbarControlsModel.setProperty("/publishEnabled",s1.isPublishEnabled);this._oToolbarControlsModel.setProperty("/restoreEnabled",s1.isResetEnabled);}.bind(this));}}}.bind(this));}.bind(this));}.bind(this))['catch'](m1);};k1.prototype._deleteChanges=function(){var o1=this.getLayer();return y.reset({selector:t.getAppComponentForControl(this.getRootControlInstance()),layer:o1,generator:"Change.createInitialFileContent"}).then(function(){var p1={hasDraftChanges:w.hasVersionParameterWithValue({value:o1}),layer:o1,deleteMaxLayer:false,triggerHardReload:true};return this._handleUrlParameterOnExit(p1);}.bind(this)).catch(function(p1){if(p1!=="cancel"){U.showMessageBox("error","MSG_RESTORE_FAILED",{error:p1});}});};k1.prototype._reloadPage=function(){window.location.reload();};k1.prototype._showMessageToast=function(o1){var p1=this._getTextResources().getText(o1);B.show(p1);};k1.needsRestart=function(o1){var p1=!!window.sessionStorage.getItem("sap.ui.rta.restart."+o1);return p1;};k1.enableRestart=function(o1,p1){var q1=t.getComponentClassName(p1);var r1=q1||true;window.sessionStorage.setItem("sap.ui.rta.restart."+o1,r1);};k1.disableRestart=function(o1){window.sessionStorage.removeItem("sap.ui.rta.restart."+o1);};k1.prototype._onRestore=function(){var o1=this.getLayer();var p1=o1===v.USER?this._getTextResources().getText("FORM_PERS_RESET_MESSAGE_PERSONALIZATION"):this._getTextResources().getText("FORM_PERS_RESET_MESSAGE");var q1=o1===v.USER?this._getTextResources().getText("BTN_RESTORE"):this._getTextResources().getText("FORM_PERS_RESET_TITLE");this._handleStopCutPaste();return U.showMessageBox("warning",p1,{titleKey:q1,actions:[z.Action.OK,z.Action.CANCEL],emphasizedAction:z.Action.OK}).then(function(r1){if(r1===z.Action.OK){k1.enableRestart(o1,this.getRootControlInstance());this._deleteChanges();this.getCommandStack().removeAllCommands();}}.bind(this));};k1.prototype._scheduleOnCreated=function(o1,p1){function q1(r1){var s1=r1.getParameter("elementOverlay");if(s1.getElement().getId()===o1){this._oDesignTime.detachEvent("elementOverlayCreated",q1,this);p1(s1);}}this._oDesignTime.attachEvent("elementOverlayCreated",q1,this);};k1.prototype._scheduleOnCreatedAndVisible=function(o1,p1){function q1(s1){var t1=s1.getSource();if(t1.getGeometry()&&t1.getGeometry().visible){t1.detachEvent("geometryChanged",q1);p1(t1);}}function r1(s1){if(!s1.getGeometry()||!s1.getGeometry().visible){s1.attachEvent('geometryChanged',q1);}else{p1(s1);}}this._scheduleOnCreated(o1,function(s1){if(s1.isRendered()){r1(s1);}else{s1.attachEventOnce('afterRendering',function(t1){r1(t1.getSource());});}});};k1.prototype._scheduleRenameOnCreatedContainer=function(o1,p1){var q1=function(r1){r1.setSelected(true);this.getPlugins()["rename"].startEdit(r1);}.bind(this);this._scheduleOnCreatedAndVisible(p1,function(r1){var s1=this.getPlugins()["createContainer"].getCreatedContainerId(o1,r1.getElement().getId());var t1=X.getOverlay(s1);if(t1){q1(t1);}else{this._scheduleOnCreatedAndVisible(s1,q1);}}.bind(this));};k1.prototype._handleElementModified=function(o1){this._handleStopCutPaste();var p1=o1.getParameter("action");var q1=o1.getParameter("newControlId");var r1=o1.getParameter("command");if(r1 instanceof sap.ui.rta.command.BaseCommand){if(q1){this._scheduleOnCreated(q1,function(s1){var t1=s1.getDesignTimeMetadata();var u1=t1.getData().select;if(typeof u1==="function"){u1(s1.getElement());}});if(p1){this._scheduleRenameOnCreatedContainer(p1,q1);}}return this.getCommandStack().pushAndExecute(r1).catch(function(s1){if(s1&&s1.message&&s1.message.indexOf("The following Change cannot be applied because of a dependency")>-1){U.showMessageBox("error","MSG_DEPENDENCY_ERROR",{error:s1});}_.error("sap.ui.rta: "+s1.message);});}return Promise.resolve();};k1.prototype._onElementEditableChange=function(o1){var p1=o1.getParameter("editable");if(p1){this.iEditableOverlaysCount+=1;}else{this.iEditableOverlaysCount-=1;}};k1.prototype._handleStopCutPaste=function(){if(this.getPlugins()["cutPaste"]){this.getPlugins()["cutPaste"].stopCutAndPaste();}};k1.prototype._buildNavigationArguments=function(o1){return{target:{semanticObject:o1.semanticObject,action:o1.action,context:o1.contextRaw},params:o1.params,appSpecificRoute:o1.appSpecificRoute,writeHistory:false};};k1.prototype._triggerCrossAppNavigation=function(o1){if(this.getLayer()!==v.USER){return t.ifUShellContainerThen(function(p1){p1[0].toExternal(this._buildNavigationArguments(o1));return Promise.resolve(true);}.bind(this),["CrossApplicationNavigation"]);}};k1.prototype._removeVersionParameterForFLP=function(o1,p1){var q1=this.getLayer();if(q1===v.USER){return o1;}var r1=t.getParameter(sap.ui.fl.Versions.UrlParameter);if(r1){delete o1.params[sap.ui.fl.Versions.UrlParameter];}else if(this._isDraftAvailable()||p1){var s1=this._oVersionsModel.getProperty("/activeVersion").toString();o1.params[sap.ui.fl.Versions.UrlParameter]=[s1];}return o1;};k1.prototype._removeMaxLayerParameterForFLP=function(o1,p1){if(o1.deleteMaxLayer&&o1.hasHigherLayerChanges){delete p1.params[u.FL_MAX_LAYER_PARAM];}return p1;};k1.prototype._handleUrlParameterOnExit=function(o1){if(!t.getUshellContainer()){return this._triggerHardReload(o1);}var p1=t.getParsedURLHash();if(!p1){return;}p1=this._removeMaxLayerParameterForFLP(o1,p1);p1=this._removeVersionParameterForFLP(p1);this._triggerCrossAppNavigation(p1);if(o1.triggerHardReload){this._reloadPage();}};k1.prototype._getReloadMessageOnStart=function(o1){var p1;var q1=o1.layer===v.CUSTOMER;if(o1.hasHigherLayerChanges&&o1.hasDraftChanges){p1=q1?"MSG_PERSONALIZATION_AND_DRAFT_EXISTS":"MSG_HIGHER_LAYER_CHANGES_AND_DRAFT_EXISTS";}else if(o1.hasHigherLayerChanges){p1=q1?"MSG_PERSONALIZATION_EXISTS":"MSG_HIGHER_LAYER_CHANGES_EXIST";}else if(o1.hasDraftChanges){p1="MSG_DRAFT_EXISTS";}return p1;};k1.prototype._getReloadMessageOnExit=function(o1){var p1=o1.layer===v.CUSTOMER;if(o1.hasHigherLayerChanges){if(!p1){return"MSG_RELOAD_WITH_ALL_CHANGES";}if(o1.hasDraft){return"MSG_RELOAD_WITH_PERSONALIZATION_AND_WITHOUT_DRAFT";}return"MSG_RELOAD_WITH_PERSONALIZATION";}if(o1.initialDraftGotActivated){return"MSG_RELOAD_ACTIVATED_DRAFT";}if(o1.hasDraft){return"MSG_RELOAD_WITHOUT_DRAFT";}if(o1.changesNeedReload){return"MSG_RELOAD_NEEDED";}};k1.prototype._handleReloadMessageBoxOnExit=function(o1){var p1=this._getReloadMessageOnExit(o1);if(p1){return U.showMessageBox("information",p1,{titleKey:"HEADER_RELOAD_NEEDED"});}return Promise.resolve();};k1.prototype._triggerReloadOnStart=function(o1){t.ifUShellContainerThen(function(){V.loadDraftForApplication({selector:o1.selector,layer:o1.layer});},["CrossApplicationNavigation"]);var p1=this._getReloadMessageOnStart(o1);if(!p1){return Promise.resolve();}return U.showMessageBox("information",p1).then(function(){k1.enableRestart(o1.layer);if(t.getUshellContainer()){var q1=w.handleParametersOnStart(o1);return this._triggerCrossAppNavigation(q1);}return this._triggerHardReload(o1);}.bind(this));};k1.prototype._determineReload=function(){var o1={hasHigherLayerChanges:false,hasDraftChanges:false,layer:this.getLayer(),selector:this.getRootControlInstance(),ignoreMaxLayerParameter:false};return w.getReloadReasonsForStart(o1).then(function(o1){if(o1.hasHigherLayerChanges||o1.hasDraftChanges){return this._triggerReloadOnStart(o1);}}.bind(this));};k1.prototype._triggerHardReload=function(o1){o1.parameters=document.location.search;var p1=w.handleUrlParametersForStandalone(o1);if(document.location.search!==p1){document.location.search=p1;return Promise.resolve();}return this._reloadPage();};k1.prototype._handleReloadOnExit=function(o1){if(o1){return Promise.resolve({reloadMethod:this._RELOAD.NOT_NEEDED});}var p1=this._bReloadNeeded?Promise.resolve(this._bReloadNeeded):this._oSerializer.needsReload();return p1.then(function(q1){var r1={layer:this.getLayer(),selector:this.getRootControlInstance(),changesNeedReload:q1,hasDirtyDraftChanges:this._oVersionsModel.getProperty("/draftAvailable")&&this._oVersionsModel.getProperty("/dirtyChanges"),versioningEnabled:this._oVersionsModel.getProperty("/versioningEnabled"),activeVersion:this._oVersionsModel.getProperty("/activeVersion")};r1=w.getReloadMethod(r1);return this._handleReloadMessageBoxOnExit(r1).then(function(){return r1;});}.bind(this));};k1.prototype._onModeChange=function(o1){this.setMode(o1.getParameter("item").getKey());};k1.prototype.setMode=function(o1){if(this.getProperty('mode')!==o1){var p1=this.getShowToolbars()&&this.getToolbar().getControl('modeSwitcher');var q1=o1==='adaptation';if(p1){p1.setSelectedButton(p1.getItems().filter(function(r1){return r1.getKey()===o1;}).pop().getId());}this._oDesignTime.setEnabled(q1);this.getPlugins()['tabHandling'][q1?'removeTabIndex':'restoreTabIndex']();this.setProperty('mode',o1);this.fireModeChanged({mode:o1});}};k1.prototype.setMetadataScope=function(o1){if(this._oDesignTime){_.error("sap.ui.rta: Failed to set metadata scope on RTA instance after RTA is started");return;}this.setProperty('metadataScope',o1);};function n1(o1){if(Q.hasOwnProperty(o1)){return Q[o1].replace(/\./g,'/');}}k1.prototype.startService=function(o1){if(this._sStatus!==e1){return new Promise(function(r1,s1){this.attachEventOnce('start',r1);this.attachEventOnce('failed',s1);}.bind(this)).then(function(){return this.startService(o1);}.bind(this),function(){return Promise.reject(s.createError("RuntimeAuthoring#startService",s.printf("Can't start the service '{0}' while RTA has been failed during a startup",o1),"sap.ui.rta"));});}var p1=n1(o1);var q1;if(!p1){return Promise.reject(s.createError("RuntimeAuthoring#startService",s.printf("Unknown service. Can't find any registered service by name '{0}'",o1),"sap.ui.rta"));}q1=this._mServices[o1];if(q1){switch(q1.status){case i1:{return Promise.resolve(q1.exports);}case h1:{return q1.initPromise;}case j1:{return q1.initPromise;}default:{return Promise.reject(s.createError("RuntimeAuthoring#startService",s.printf("Unknown service status. Service name = '{0}'",o1),"sap.ui.rta"));}}}else{this._mServices[o1]=q1={status:h1,location:p1,initPromise:new Promise(function(r1,s1){sap.ui.require([p1],function(t1){q1.factory=t1;if(!this._oServiceEventBus){this._oServiceEventBus=new W();}s.wrapIntoPromise(t1)(this,this._oServiceEventBus.publish.bind(this._oServiceEventBus,o1)).then(function(u1){if(this.bIsDestroyed){throw s.createError("RuntimeAuthoring#startService",s.printf("RuntimeAuthoring instance is destroyed while initialising the service '{0}'",o1),"sap.ui.rta");}if(!q.isPlainObject(u1)){throw s.createError("RuntimeAuthoring#startService",s.printf("Invalid service format. Service should return simple javascript object after initialisation. Service name = '{0}'",o1),"sap.ui.rta");}q1.service=u1;q1.exports={};if(Array.isArray(u1.events)&&u1.events.length>0){q.extend(q1.exports,{attachEvent:this._oServiceEventBus.subscribe.bind(this._oServiceEventBus,o1),detachEvent:this._oServiceEventBus.unsubscribe.bind(this._oServiceEventBus,o1),attachEventOnce:this._oServiceEventBus.subscribeOnce.bind(this._oServiceEventBus,o1)});}var v1=u1.exports||{};q.extend(q1.exports,Object.keys(v1).reduce(function(w1,x1){var y1=v1[x1];w1[x1]=typeof y1==="function"?s.waitForSynced(this._oDesignTime,y1):y1;return w1;}.bind(this),{}));q1.status=i1;r1(Object.freeze(q1.exports));}.bind(this)).catch(s1);}.bind(this),function(t1){q1.status=j1;s1(s.propagateError(t1,"RuntimeAuthoring#startService",s.printf("Can't load service '{0}' by its name: {1}",o1,p1),"sap.ui.rta"));});}.bind(this)).catch(function(r1){q1.status=j1;return Promise.reject(s.propagateError(r1,"RuntimeAuthoring#startService",s.printf("Error during service '{0}' initialisation.",o1),"sap.ui.rta"));})};return q1.initPromise;}};k1.prototype.stopService=function(o1){var p1=this._mServices[o1];if(p1){if(p1.status===i1){if(typeof p1.service.destroy==="function"){p1.service.destroy();}}delete this._mServices[o1];}else{throw s.createError("RuntimeAuthoring#stopService",s.printf("Can't destroy service: unable to find service with name '{0}'",o1),"sap.ui.rta");}};k1.prototype.getService=function(o1){return this.startService(o1);};return k1;});
