/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/fl/Utils","sap/m/MessageBox","sap/ui/rta/Utils","sap/ui/core/BusyIndicator","sap/base/util/uid","sap/base/Log","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/write/api/AppVariantWriteAPI","sap/ui/fl/write/api/ChangesWriteAPI"],function(F,M,R,B,u,L,P,A,C){"use strict";var a={};var H=56;a._newAppVariantId=null;a.getManifirstSupport=function(r){var m='/sap/bc/ui2/app_index/ui5_app_mani_first_supported/?id='+r;return new Promise(function(b,c){var x=new XMLHttpRequest();x.open("GET",m);x.send();x.onload=function(){if(x.status>=200&&x.status<400){b(x.response);}else{c({status:x.status,message:x.statusText});}};});};a.getNewAppVariantId=function(){return a._newAppVariantId;};a.setNewAppVariantId=function(n){a._newAppVariantId=n;};a.trimIdIfRequired=function(i){if(i.length>H){var I=i.split('.');var t;var g=I[I.length-1].length;var G=I.pop();t=I.join(".");if(t.length>g){t=t.substring(0,t.length-g);}else{return i.substr(0,H);}if(t[t.length-1]==='.'){t=t+G;}else{t=t+"."+G;}return this.trimIdIfRequired(t);}return i;};a.getId=function(b){var c;var i=b.split('.');if(i[0]!=="customer"){i[0]="customer."+i[0];}var r=false;var d=/^id.*/i;i.forEach(function(s,e,f){if(s.match(d)){s=s.replace(d,u().replace(/-/g,"_"));f[e]=s;r=true;}});c=i.join(".");if(!r){c=c+"."+u().replace(/-/g,"_");}c=this.trimIdIfRequired(c);this.setNewAppVariantId(c);return c;};a.createAppVariant=function(s,p){p.version="1.0.0";return A.saveAs(Object.assign({selector:s},p));};a.getInlineChangeInput=function(v,c){return{type:"XTIT",maxLength:50,comment:c,value:{"":v}};};a.prepareTextsChange=function(p,s){var c="New "+p+" entered by a key user via RTA tool";return this.getInlineChangeInput(s,c);};a.getInlineChangeInputIcon=function(i){return{content:{icon:i}};};a.prepareRemoveAllInboundsExceptOneChange=function(i){return{content:{inboundId:i}};};a.getInboundInfo=function(i){var I={};if(!i){I.currentRunningInbound="customer.savedAsAppVariant";I.addNewInboundRequired=true;return I;}var p=F.getParsedURLHash();var b=Object.keys(i);var c=[];if(b.length===1&&b[0]==="customer.savedAsAppVariant"){return{currentRunningInbound:"customer.savedAsAppVariant",addNewInboundRequired:false};}b.forEach(function(s){if((i[s].action===p.action)&&(i[s].semanticObject===p.semanticObject)){c.push(s);}});switch(c.length){case 0:I.currentRunningInbound="customer.savedAsAppVariant";I.addNewInboundRequired=true;break;case 1:I.currentRunningInbound=c[0];I.addNewInboundRequired=false;break;default:I.currentRunningInbound="customer.savedAsAppVariant";I.addNewInboundRequired=true;break;}return I;};a.getInboundPropertiesKey=function(s,c,p){return s+"_sap.app.crossNavigation.inbounds."+c+"."+p;};a.getInlineChangeForInboundPropertySaveAs=function(c,s){return{inboundId:c,entityPropertyChange:{propertyPath:"signature/parameters/sap-appvar-id",operation:"UPSERT",propertyValue:{required:true,filter:{value:s,format:"plain"},launcherValue:{value:s}}}};};a.prepareAddNewInboundChange=function(c,s,o){var p=F.getParsedURLHash();var b={content:{inbound:{}},texts:{}};var i=this.getInboundPropertiesKey(o.referenceAppId,c,"title");var I=this.getInboundPropertiesKey(o.referenceAppId,c,"subTitle");b.content.inbound[c]={semanticObject:p.semanticObject,action:p.action,title:"{{"+i+"}}",subTitle:"{{"+I+"}}",icon:o.icon,signature:{parameters:{"sap-appvar-id":{required:true,filter:{value:s,format:"plain"},launcherValue:{value:s}}},additionalParameters:"ignored"}};b.texts[i]=this.prepareTextsChange("title",o.title);b.texts[I]=this.prepareTextsChange("subTitle",o.subTitle);return b;};a.prepareChangeInboundChange=function(c,s,o){var p={content:{},texts:{}};var i=this.getInboundPropertiesKey(o.referenceAppId,c,"title");var I=this.getInboundPropertiesKey(o.referenceAppId,c,"subTitle");p.content={inboundId:c,entityPropertyChange:[{propertyPath:"signature/parameters/sap-appvar-id",operation:"UPSERT",propertyValue:{required:true,filter:{value:s,format:"plain"},launcherValue:{value:s}}},{propertyPath:"title",operation:"UPSERT",propertyValue:"{{"+i+"}}"},{propertyPath:"subTitle",operation:"UPSERT",propertyValue:"{{"+I+"}}"},{propertyPath:"icon",operation:"UPSERT",propertyValue:o.icon}]};p.texts[i]=this.prepareTextsChange("title",o.title);p.texts[I]=this.prepareTextsChange("subTitle",o.subTitle);return p;};a.createInlineChange=function(p,i,s){var c={changeType:i,content:p.content};if(p.texts){c.texts=p.texts;}return C.create({changeSpecificData:c,selector:s});};a.addChangesToPersistence=function(b,s){b.forEach(function(c){return P.add({change:c,selector:s});});return Promise.resolve();};a.getTransportInput=function(p,n,N,t){return{getPackage:function(){return p;},getNamespace:function(){return n;},getId:function(){return N;},getDefinition:function(){return{fileType:t};}};};a.triggerCatalogAssignment=function(s,l,r){return A.assignCatalogs({selector:{appId:s},action:"assignCatalogs",assignFromAppId:r,layer:l});};a.triggerCatalogUnAssignment=function(s,l){return A.unassignCatalogs({selector:{appId:s},action:"unassignCatalogs",layer:l});};a.isS4HanaCloud=function(s){return s.isAtoEnabled()&&s.isAtoAvailable();};a.copyId=function(i){var t=document.createElement("textarea");t.value=i;document.body.appendChild(t);t.select();document.execCommand('copy');document.body.removeChild(t);return true;};a.getTextResources=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");};a.getText=function(m,t){var T=this.getTextResources();return t?T.getText(m,t):T.getText(m);};a._getErrorMessageText=function(e){var E;if(e.messages&&e.messages.length){E=e.messages.map(function(e){return e.text;}).join("\n");}else if(e.iamAppId){E="IAM App Id: "+e.iamAppId;}else{E=e.stack||e.message||e.status||e;}return E;};a.buildErrorInfo=function(m,e,s){var E=this._getErrorMessageText(e);var b=a.getText(m)+"\n\n";if(s){b+=a.getText("MSG_APP_VARIANT_ID",s)+"\n";}b+=a.getText("MSG_TECHNICAL_ERROR",E);L.error("App variant error: ",E);return{text:b,appVariantId:s,error:true};};a.buildSuccessInfo=function(s,S,i){var b=i?"CLOUD":"ON_PREMISE";var o=S?"":"_OVERVIEW_LIST";var t=i?undefined:s;var m=a.getText("SAVE_APP_VARIANT_SUCCESS_MESSAGE")+"\n\n";m+=a.getText("SAVE_APP_VARIANT_SUCCESS_S4HANA_"+b+"_MESSAGE"+o,t);return{text:m,appVariantId:s,copyId:!i};};a.buildFinalSuccessInfoS4HANACloud=function(){var m=a.getText("MSG_SAVE_APP_VARIANT_NEW_TILE_AVAILABLE");return{text:m};};a.buildDeleteSuccessMessage=function(s,i){var m=i?"DELETE_APP_VARIANT_SUCCESS_MESSAGE_CLOUD":"DELETE_APP_VARIANT_SUCCESS_MESSAGE";var b=a.getText(m,s);return{text:b};};a.showRelevantDialog=function(i,s){B.hide();var t;var r;var o;var c;var b=[];if(s){t=this.getText("SAVE_APP_VARIANT_SUCCESS_MESSAGE_TITLE");r=this.getText("SAVE_APP_VARIANT_OK_TEXT");}else{t=this.getText("HEADER_SAVE_APP_VARIANT_FAILED");r=this.getText("SAVE_APP_VARIANT_CLOSE_TEXT");}if(i&&i.copyId){c=this.getText("SAVE_APP_VARIANT_COPY_ID_TEXT");b.push(c);}else if(i&&i.deleteAppVariant){t=this.getText("DELETE_APP_VARIANT_INFO_MESSAGE_TITLE");o=this.getText("DELETE_APP_VARIANT_OK_TEXT");b.push(o);r=this.getText("DELETE_APP_VARIANT_CLOSE_TEXT");}b.push(r);return new Promise(function(d,e){var f=function(g){if(g===c){a.copyId(i.appVariantId);}if(s){d();}else if(i.overviewDialog){d(false);}else if(i.deleteAppVariant&&g===o){d();}else if(i.deleteAppVariant&&g===r){e(i.deleteAppVariant);}else if(i.error){e(i.error);}else{d();}};M.show(i.text,{icon:(s||i.deleteAppVariant)?M.Icon.INFORMATION:M.Icon.ERROR,onClose:f,title:t,actions:b,styleClass:R.getRtaStyleClassName()});});};a.closeOverviewDialog=function(){sap.ui.getCore().getEventBus().publish("sap.ui.rta.appVariant.manageApps.controller.ManageApps","navigate");};a.navigateToFLPHomepage=function(){var o=sap.ushell.services.AppConfiguration.getCurrentApplication();var c=o.componentHandle.getInstance();if(c){F.ifUShellContainerThen(function(s){var b=s[0];if(b&&b.toExternal){b.toExternal({target:{shellHash:"#"}},c);}},["CrossApplicationNavigation"]);}return Promise.resolve();};a.deleteAppVariant=function(s,l){B.hide();return A.deleteAppVariant({selector:s,layer:l});};a.handleBeforeUnloadEvent=function(){var m=a.getText("MSG_DO_NOT_CLOSE_BROWSER");return m;};a.showMessage=function(m){var s=a.getText(m);var i={text:s,copyId:false};return a.showRelevantDialog(i,true);};a.catchErrorDialog=function(e,m,i){B.hide();var E=a.buildErrorInfo(m,e,i);return a.showRelevantDialog(E,false);};return a;},true);
