/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./List','./library','sap/ui/model/ChangeReason','sap/ui/model/Filter','./FacetFilterListRenderer','./FacetFilterItem',"sap/base/Log","sap/ui/model/FilterOperator","sap/ui/model/FilterType"],function(L,l,C,F,a,b,c,d,e){"use strict";var f=l.ListMode;var g=l.FacetFilterListDataType;var h=L.extend("sap.m.FacetFilterList",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Appearance",defaultValue:null},wordWrap:{type:"boolean",group:"Appearance",defaultValue:false},multiSelect:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true},active:{type:"boolean",group:"Behavior",defaultValue:true},enableCaseInsensitiveSearch:{type:"boolean",group:"Behavior",defaultValue:false,deprecated:false},allCount:{type:"int",group:"Appearance",defaultValue:null},sequence:{type:"int",group:"Behavior",defaultValue:-1},key:{type:"string",group:"Identification",defaultValue:null},showRemoveFacetIcon:{type:"boolean",group:"Misc",defaultValue:true},retainListSequence:{type:"boolean",group:"Misc",defaultValue:false},dataType:{type:"sap.m.FacetFilterListDataType",group:"Misc",defaultValue:g.String}},events:{listOpen:{allowPreventDefault:true},listClose:{parameters:{selectedItems:{type:"sap.m.FacetFilterItem[]"},allSelected:{type:"boolean"},selectedKeys:{type:"object"}}},search:{allowPreventDefault:true,parameters:{term:{type:"string"}}}}}});h.prototype.setTitle=function(t){this.setProperty("title",t,true);this._updateFacetFilterButtonText();return this;};h.prototype.setMultiSelect=function(v){this.setProperty("multiSelect",v,true);var m=v?f.MultiSelect:f.SingleSelectMaster;this.setMode(m);return this;};h.prototype.setMode=function(m){if(m===f.MultiSelect||m===f.SingleSelectMaster){L.prototype.setMode.call(this,m);this.setProperty("multiSelect",m===f.MultiSelect?true:false,true);}return this;};h.prototype._applySearch=function(){var s=this._getSearchValue();if(s===null){return;}this._bSearchEventDefaultBehavior&&this._search(s,true);this._updateSelectAllCheckBox();};h.prototype.getSelectedItems=function(){var s=[];var o={};var i=L.prototype.getSelectedItems.apply(this,arguments);i.forEach(function(I){s.push(new b({text:I.getText(),key:I.getKey(),selected:true}));o[I.getKey()]=true;});var S=this.getSelectedKeys();var j=Object.getOwnPropertyNames(S);if(i.length<j.length){j.forEach(function(k){if(!o[k]){s.push(new b({text:S[k],key:k,selected:true}));}});}return s;};h.prototype.getSelectedItem=function(){var i=L.prototype.getSelectedItem.apply(this,arguments);var s=Object.getOwnPropertyNames(this.getSelectedKeys());if(!i&&s.length>0){i=new b({text:this.getSelectedKeys()[s[0]],key:s[0],selected:true});}return i;};h.prototype.removeSelections=function(A){if(this._allowRemoveSelections){A?this.setSelectedKeys():L.prototype.removeSelections.call(this,A);}return this;};h.prototype.getSelectedKeys=function(){var r={};var k=this._oSelectedKeys;Object.getOwnPropertyNames(k).forEach(function(i){r[i]=k[i];});return r;};h.prototype.setSelectedKeys=function(k){this._oSelectedKeys={};var K=false;k&&Object.getOwnPropertyNames(k).forEach(function(i){this._addSelectedKey(i,k[i]);K=true;},this);if(K){if(this.getMode()===f.MultiSelect){this.setActive(true);}this._selectItemsByKeys();}else{L.prototype.removeSelections.call(this);}};h.prototype._getNonGroupItems=function(){var i=[];this.getItems().forEach(function(I){if(I.getMode()!==f.None){i.push(I);}});return i;};h.prototype.removeSelectedKey=function(k,t){if(this._removeSelectedKey(k,t)){this._getNonGroupItems().forEach(function(i){var I=i.getKey()||i.getText();k===I&&i.setSelected(false);});}};h.prototype.removeSelectedKeys=function(){this._oSelectedKeys={};L.prototype.removeSelections.call(this,true);};h.prototype.removeItem=function(i){var I=L.prototype.removeItem.apply(this,arguments);if(!this._filtering){I&&I.getSelected()&&this.removeSelectedKey(I.getKey(),I.getText());return I;}};h.prototype.init=function(){this._firstTime=true;this._bSearchEventDefaultBehavior=true;this._saveBindInfo;this._oSelectedKeys={};L.prototype.init.call(this);this.setMode(f.MultiSelect);this.setIncludeItemInSelection(true);this.setGrowing(true);this.setRememberSelections(false);this._searchValue="";this.attachUpdateFinished(function(E){var u=E.getParameter("reason");u=u?u.toLowerCase():u;if(u==="change"){var B=this.getBinding("items"),m=B?B.getModel():null;if(m&&m.getProperty(B.getPath())){this._iAllItemsCount=m.getProperty(B.getPath()).length||0;}this._oSelectedKeys={};this._getNonGroupItems().forEach(function(i){if(i.getSelected()){this._addSelectedKey(i.getKey(),i.getText());}},this);}if(u!==C.Filter.toLowerCase()){this._selectItemsByKeys();}this._updateFacetFilterButtonText();this._updateSelectAllCheckBox();});this._allowRemoveSelections=true;this._bOriginalActiveState;this._iAllItemsCount;};h.prototype._resetItemsBinding=function(){if(this.isBound("items")){this._setSearchValue("");this._allowRemoveSelections=false;L.prototype._resetItemsBinding.apply(this,arguments);this._allowRemoveSelections=true;}};h.prototype._fireListCloseEvent=function(){var s=this.getSelectedItems();var S=this.getSelectedKeys();var A=s.length===0;this._firstTime=true;this.fireListClose({selectedItems:s,selectedKeys:S,allSelected:A});};h.prototype._updateActiveState=function(){var o=sap.ui.getCore().byId(this.getAssociation("allcheckbox"));if(Object.getOwnPropertyNames(this._oSelectedKeys).length>0||(o&&o.getSelected())){this.setActive(true);}};h.prototype._handleSearchEvent=function(E){var s=E.getParameters()["query"];if(s===undefined){s=E.getParameters()["newValue"];}this._bSearchEventDefaultBehavior=this.fireSearch({term:s,clearButtonPressed:E.getParameters()["clearButtonPressed"]});this._bSearchEventDefaultBehavior?this._search(s):this._setSearchValue(s);this._updateSelectAllCheckBox();};h.prototype._search=function(s,i){var j,B,u,U,p,o,P,k,n=0,m=this.getBinding("items"),q=this.getBindingInfo("items");function r(M){return M instanceof sap.ui.model.odata.ODataModel||M instanceof sap.ui.model.odata.v2.ODataModel||M instanceof sap.ui.model.odata.v4.ODataModel;}if(i||(s!==this._searchValue)){this._searchValue=s;if(q&&q.binding){j=q.binding.aFilters;if(j.length>0){n=j[0].aFilters.length;if(this._firstTime){this._saveBindInfo=j[0].aFilters[0][0];this._firstTime=false;}}}if(m){if(s||n>0){k=q.template?q.template:q.factory();B=k.getBindingInfo("text").parts;p=B[0].path;if(p||p===""){u=[];B.forEach(function(t){u.push(new F(t.path,d.Contains,s));});if(this.getEnableCaseInsensitiveSearch()&&r(m.getModel())){u.forEach(function(t){t.bCaseSensitive=false;});}P=new F(u,false);if(n>1){o=new F([P,this._saveBindInfo],true);}else{if(this._saveBindInfo>""&&U.sPath!=this._saveBindInfo.sPath){o=new F([P,this._saveBindInfo],true);}else{if(s==""){o=[];}else{o=new F([P],true);}}}m.filter(o,e.Control);}}else{m.filter([],e.Control);}}else{c.warning("No filtering performed","The list must be defined with a binding for search to work",this);}}};h.prototype._getSearchValue=function(){return this._searchValue;};h.prototype._updateSelectAllCheckBox=function(){var i=this._getNonGroupItems(),I=i.length,o,A,s;function j(k){return k.getSelected();}if(this.getMultiSelect()){o=sap.ui.getCore().byId(this.getAssociation("allcheckbox"));A=I>0&&I===i.filter(j).length;s=this.getActive()&&A;o&&o.setSelected(s);}};h.prototype._addSelectedKey=function(k,t){if(!k&&!t){c.error("Both sKey and sText are not defined. At least one must be defined.");return;}if(this.getMode()===f.SingleSelectMaster){this.removeSelectedKeys();}if(!k){k=t;}this._oSelectedKeys[k]=t||k;};h.prototype._removeSelectedKey=function(k,t){if(!k&&!t){c.error("Both sKey and sText are not defined. At least one must be defined.");return false;}if(!k){k=t;}delete this._oSelectedKeys[k];return true;};h.prototype._setSearchValue=function(v){this._searchValue=v;};h.prototype._isItemSelected=function(i){return!!(this._oSelectedKeys[i&&(i.getKey()||i.getText())]);};h.prototype._updateFacetFilterButtonText=function(){if(this.getParent()&&this.getParent()._setButtonText){this.getParent()._setButtonText(this);}};h.prototype._selectItemsByKeys=function(){this._getNonGroupItems().forEach(function(i){i.setSelected(this._isItemSelected(i));},this);this._updateFacetFilterButtonText();};h.prototype._handleSelectAllClick=function(s){var A,i,I=this._getNonGroupItems(),j=I.length;I.forEach(function(o){if(s){this._addSelectedKey(o.getKey(),o.getText());}else{this._removeSelectedKey(o.getKey(),o.getText());}o.setSelected(s,true);},this);function k(o){return o.getSelected();}if(this.getMode()===f.MultiSelect){i=j>0&&j===I.filter(k).length;A=this._getOriginalActiveState()||(s&&i);this.setActive(A);}setTimeout(this._updateSelectAllCheckBox.bind(this),0);};h.prototype.onItemTextChange=function(i,n){var k=i.getKey();if(this._oSelectedKeys[k]&&n&&!this._filtering){this._oSelectedKeys[k]=n;}};h.prototype.onItemSelectedChange=function(i,s){var A;if(s){this._addSelectedKey(i.getKey(),i.getText());}else{this._removeSelectedKey(i.getKey(),i.getText());}L.prototype.onItemSelectedChange.apply(this,arguments);if(this.getMode()===f.MultiSelect){A=this._getOriginalActiveState()||s||this.getSelectedItems().length>1;this.setActive(A);}!this.getDomRef()&&this.getParent()&&this.getParent().getDomRef()&&this.getParent().invalidate();setTimeout(this._updateSelectAllCheckBox.bind(this),0);};h.prototype.updateItems=function(r){var p=document.activeElement;this._filtering=r===C.Filter;L.prototype.updateItems.apply(this,arguments);this._filtering=false;if(p&&p.getAttribute("id")!==document.activeElement.getAttribute("id")){this.focus();}if(!this.getGrowing()||r===C.Filter){this._selectItemsByKeys();}};h.prototype._getOriginalActiveState=function(){return this._bOriginalActiveState;};h.prototype._preserveOriginalActiveState=function(){this._bOriginalActiveState=this.getActive();};h.prototype._showBusyIndicator=function(){L.prototype._showBusyIndicator.apply(this,arguments);this.fireEvent("listItemsChange");};h.prototype._hideBusyIndicator=function(){L.prototype._hideBusyIndicator.apply(this,arguments);this.fireEvent("listItemsChange");};return h;});
