/*
 * ! OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./P13nConditionPanel','./P13nPanel','./library','sap/m/Panel','./P13nFilterItem','./P13nOperationsHelper'],function(P,a,l,b,c,d){"use strict";var e=l.P13nPanelType;var f=l.P13nConditionOperation;var g=a.extend("sap.m.P13nFilterPanel",{metadata:{library:"sap.m",properties:{maxIncludes:{type:"string",group:"Misc",defaultValue:'-1'},maxExcludes:{type:"string",group:"Misc",defaultValue:'-1'},containerQuery:{type:"boolean",group:"Misc",defaultValue:false},layoutMode:{type:"string",group:"Misc",defaultValue:null},enableEmptyOperations:{type:"boolean",group:"Misc",defaultValue:false}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"},filterItems:{type:"sap.m.P13nFilterItem",multiple:true,singularName:"filterItem",bindable:"bindable"},messageStrip:{type:"sap.m.MessageStrip",multiple:false}},events:{addFilterItem:{},removeFilterItem:{},updateFilterItem:{},filterItemChanged:{parameters:{reason:{type:"string"},key:{type:"string"},index:{type:"int"},itemData:{type:"object"}}}}},renderer:{apiVersion:2,render:function(r,C){r.openStart("section",C);r.class("sapMFilterPanel");r.openEnd();r.openStart("div");r.class("sapMFilterPanelContent");r.class("sapMFilterPanelBG");r.openEnd();C.getAggregation("content").forEach(function(o){r.renderControl(o);});r.close("div");r.close("section");}}});g.prototype.setConditions=function(C){var I=[];var E=[];if(C.length){for(var i=0;i<C.length;i++){var o=C[i];if(!o.exclude){I.push(o);}else{E.push(o);}}}this._oIncludeFilterPanel.setConditions(I);this._oExcludeFilterPanel.setConditions(E);if(E.length>0){this._oExcludePanel.setExpanded(true);}return this;};g.prototype.getConditions=function(){var i=this._oIncludeFilterPanel.getConditions();var E=this._oExcludeFilterPanel.getConditions();return i.concat(E);};g.prototype.setContainerQuery=function(C){this.setProperty("containerQuery",C);this._oIncludeFilterPanel.setContainerQuery(C);this._oExcludeFilterPanel.setContainerQuery(C);return this;};g.prototype.setLayoutMode=function(m){this.setProperty("layoutMode",m);this._oIncludeFilterPanel.setLayoutMode(m);this._oExcludeFilterPanel.setLayoutMode(m);return this;};g.prototype.validateConditions=function(){return this._oIncludeFilterPanel.validateConditions()&&this._oExcludeFilterPanel.validateConditions();};g.prototype.removeInvalidConditions=function(){this._oIncludeFilterPanel.removeInvalidConditions();this._oExcludeFilterPanel.removeInvalidConditions();};g.prototype.removeValidationErrors=function(){this._oIncludeFilterPanel.removeValidationErrors();this._oExcludeFilterPanel.removeValidationErrors();};g.prototype.onBeforeNavigationFrom=function(){return this.validateConditions();};g.prototype.onAfterNavigationFrom=function(){return this.removeInvalidConditions();};g.prototype.setIncludeOperations=function(o,t){t=t||"default";this._aIncludeOperations[t]=o;if(this._oIncludeFilterPanel){this._oIncludeFilterPanel.setOperations(this._aIncludeOperations[t],t);}};g.prototype.getIncludeOperations=function(t){if(this._oIncludeFilterPanel){return this._oIncludeFilterPanel.getOperations(t);}};g.prototype.setExcludeOperations=function(o,t){t=t||"default";this._aExcludeOperations[t]=o;if(this._oExcludeFilterPanel){this._oExcludeFilterPanel.setOperations(this._aExcludeOperations[t],t);}};g.prototype.getExcludeOperations=function(t){if(this._oExcludeFilterPanel){return this._oExcludeFilterPanel.getOperations(t);}};g.prototype.setKeyFields=function(k,K){this._aKeyFields=k;if(this._oIncludeFilterPanel){k.some(function(o){if(o.isDefault){this._oIncludeFilterPanel.setAutoAddNewRow(true);}}.bind(this));this._oIncludeFilterPanel.setKeyFields(k);}if(this._oExcludeFilterPanel){this._oExcludeFilterPanel.setKeyFields((Array.isArray(K)&&K.length>0)?K:k);}};g.prototype.getKeyFields=function(){return this._aKeyFields;};g.prototype.setMaxIncludes=function(m){this.setProperty("maxIncludes",m);if(this._oIncludeFilterPanel){this._oIncludeFilterPanel.setMaxConditions(m);}this._updatePanel();return this;};g.prototype.setMaxExcludes=function(m){this.setProperty("maxExcludes",m);if(this._oExcludeFilterPanel){this._oExcludeFilterPanel.setMaxConditions(m);}this._updatePanel();return this;};g.prototype._updatePanel=function(){var m=this.getMaxIncludes()==="-1"?1000:parseInt(this.getMaxIncludes());var M=this.getMaxExcludes()==="-1"?1000:parseInt(this.getMaxExcludes());if(m>0){if(M<=0){this._oIncludePanel.setHeaderText(null);this._oIncludePanel.setExpandable(false);this._oIncludePanel.addStyleClass("panelTopMargin");this._oIncludePanel.addStyleClass("panelNoHeader");}}if(M===0){this._oExcludePanel.setHeaderText(null);this._oExcludePanel.setExpandable(false);this._oExcludePanel.addStyleClass("panelNoHeader");}};g.prototype.init=function(){this.setType(e.filter);this.setTitle(sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("FILTERPANEL_TITLE"));sap.ui.getCore().loadLibrary("sap.ui.layout");this._aKeyFields=[];this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._aIncludeOperations={};this._aExcludeOperations={};this._oIncludePanel=new b({expanded:true,expandable:true,headerText:this._oRb.getText("FILTERPANEL_INCLUDES"),width:"auto"}).addStyleClass("sapMFilterPadding");this._oIncludeFilterPanel=new P({maxConditions:this.getMaxIncludes(),alwaysShowAddIcon:false,layoutMode:this.getLayoutMode(),dataChange:this._handleDataChange()});this._oIncludeFilterPanel._sAddRemoveIconTooltipKey="FILTER";this._oIncludePanel.addContent(this._oIncludeFilterPanel);this.addAggregation("content",this._oIncludePanel);this._oExcludePanel=new b({expanded:false,expandable:true,headerText:this._oRb.getText("FILTERPANEL_EXCLUDES"),width:"auto"}).addStyleClass("sapMFilterPadding");this._oExcludeFilterPanel=new P({exclude:true,maxConditions:this.getMaxExcludes(),alwaysShowAddIcon:false,layoutMode:this.getLayoutMode(),dataChange:this._handleDataChange()});this._oExcludeFilterPanel._sAddRemoveIconTooltipKey="FILTER";if(!this._oOperationsHelper){this._oOperationsHelper=new d();}this._updateOperations();var t;for(t in this._aExcludeOperations){this._oExcludeFilterPanel.setOperations(this._aExcludeOperations[t],t);}for(t in this._aIncludeOperations){this._oIncludeFilterPanel.setOperations(this._aIncludeOperations[t],t);}this._oExcludePanel.addContent(this._oExcludeFilterPanel);this.addAggregation("content",this._oExcludePanel);this._updatePanel();};g.prototype.exit=function(){var h=function(o){if(o&&o.destroy){o.destroy();}return null;};this._oOperationsHelper=h(this._oOperationsHelper);this._aKeyFields=h(this._aKeyFields);this._aIncludeOperations=h(this._aIncludeOperations);this._aExcludeOperations=h(this._aExcludeOperations);this._oRb=h(this._oRb);};g.prototype.onBeforeRendering=function(){var k=[],K,m,E=this.getEnableEmptyOperations();if(this._bUpdateRequired){this._bUpdateRequired=false;var M=this.getMessageStrip();if(M){M.addStyleClass("sapUiResponsiveMargin");this.insertAggregation("content",M,0);}K=[];m=(this.getBindingInfo("items")||{}).model;var G=function(n,o,i){var B=i.getBinding(n),h;if(B&&o){return o.getObject()[B.getPath()];}h=i.getMetadata();return h.hasProperty(n)?h.getProperty(n).get(i):h.getAggregation(n).get(i);};this.getItems().forEach(function(i){var o=i.getBindingContext(m),F,n,h;if(i.getBinding("key")){o.getObject()[i.getBinding("key").getPath()]=i.getKey();}K.push(F={key:i.getColumnKey(),text:G("text",o,i),tooltip:G("tooltip",o,i),maxLength:G("maxLength",o,i),type:G("type",o,i),typeInstance:G("typeInstance",o,i),formatSettings:G("formatSettings",o,i),precision:G("precision",o,i),scale:G("scale",o,i),isDefault:G("isDefault",o,i),values:G("values",o,i)});if(E){n=i.getNullable();h={};Object.keys(F).forEach(function(s){h[s]=F[s];});k.push(h);this._enhanceFieldOperationsWithEmpty(h,n,true);this._enhanceFieldOperationsWithEmpty(F,n);this._modifyFieldOperationsBasedOnMaxLength(h);}this._modifyFieldOperationsBasedOnMaxLength(F);},this);this.setKeyFields(K,k);var C=[];m=(this.getBindingInfo("filterItems")||{}).model;this.getFilterItems().forEach(function(F){var o=F.getBindingContext(m);if(F.getBinding("key")&&o){o.getObject()[F.getBinding("key").getPath()]=F.getKey();}C.push({key:F.getKey(),keyField:G("columnKey",o,F),operation:G("operation",o,F),value1:G("value1",o,F),value2:G("value2",o,F),exclude:G("exclude",o,F)});});this.setConditions(C);}};g.prototype._updateOperations=function(){this._oOperationsHelper.getIncludeTypes().forEach(function(t){this.setIncludeOperations(this._oOperationsHelper.getIncludeOperationsByType(t),t);}.bind(this));this._oOperationsHelper.getExcludeTypes().forEach(function(t){this.setExcludeOperations(this._oOperationsHelper.getExcludeOperationsByType(t),t);}.bind(this));};g.prototype._enableEnhancedExcludeOperations=function(){if(this._oOperationsHelper){this._oOperationsHelper.setUseExcludeOperationsExtended();}this._updateOperations();};g.prototype._modifyFieldOperationsBasedOnMaxLength=function(F){var o;if(F.maxLength===1||F.maxLength==="1"){o=F.operations?F.operations:this._oIncludeFilterPanel.getOperations(F.type);F.operations=[];o.forEach(function(O){if([f.Contains,f.StartsWith,f.EndsWith].indexOf(O)===-1){F.operations.push(O);}},this);}};g.prototype._enhanceFieldOperationsWithEmpty=function(F,n,E){var o,O;if(["string","stringdate"].indexOf(F.type)>-1||(["date","datetime"].indexOf(F.type)>-1&&n)){o=this[E?"_oExcludeFilterPanel":"_oIncludeFilterPanel"];O=o.getOperations(F.type);if(!O){O=o.getOperations();}if(!Array.isArray(F.operations)){F.operations=[];}O.forEach(function(s){F.operations.push(s);});if(F.operations.indexOf(f.Empty)===-1){F.operations.push(f.Empty);}}};g.prototype.addItem=function(i){a.prototype.addItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};g.prototype.removeItem=function(i){var r=a.prototype.removeItem.apply(this,arguments);this._bUpdateRequired=true;return r;};g.prototype.destroyItems=function(){this.destroyAggregation("items");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};g.prototype.addFilterItem=function(F){this.addAggregation("filterItems",F,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};g.prototype.insertFilterItem=function(F,i){this.insertAggregation("filterItems",F,i,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};g.prototype.updateFilterItems=function(r){this.updateAggregation("filterItems");if(r==="change"&&!this._bIgnoreBindCalls){this._bUpdateRequired=true;this.invalidate();}};g.prototype.setMessageStrip=function(m){this.setAggregation("messageStrip",m,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};g.prototype.updateMessageStrip=function(r){this.updateAggregation("messageStrip");if(r==="change"&&!this._bIgnoreBindCalls){this._bUpdateRequired=true;}};g.prototype.removeFilterItem=function(F){F=this.removeAggregation("filterItems",F,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return F;};g.prototype.removeAllFilterItems=function(){var F=this.removeAllAggregation("filterItems",true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return F;};g.prototype.destroyFilterItems=function(){this.destroyAggregation("filterItems");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};g.prototype._handleDataChange=function(){var t=this;return function(E){var n=E.getParameter("newData");var o=E.getParameter("operation");var k=E.getParameter("key");var C=E.getParameter("index");var F;var I=-1;var h=E.getSource()===t._oExcludeFilterPanel;t.getFilterItems().some(function(j,i){if((!j.getExclude()&&!h)||(j.getExclude()&&h)){C--;}I=i;return C<0;},this);switch(o){case"update":F=t.getFilterItems()[I];if(F){F.setExclude(n.exclude);F.setColumnKey(n.keyField);F.setOperation(n.operation);F.setValue1(n.value1);F.setValue2(n.value2);}t.fireUpdateFilterItem({key:k,index:I,filterItemData:F});t.fireFilterItemChanged({reason:"updated",key:k,index:I,itemData:{columnKey:n.keyField,operation:n.operation,exclude:n.exclude,value1:n.value1,value2:n.value2}});break;case"add":if(C>=0){I++;}F=new c({columnKey:n.keyField,exclude:n.exclude,operation:n.operation});F.setValue1(n.value1);F.setValue2(n.value2);t._bIgnoreBindCalls=true;t.fireAddFilterItem({key:k,index:I,filterItemData:F});t.fireFilterItemChanged({reason:"added",key:k,index:I,itemData:{columnKey:n.keyField,operation:n.operation,exclude:n.exclude,value1:n.value1,value2:n.value2}});t._bIgnoreBindCalls=false;break;case"remove":t._bIgnoreBindCalls=true;t.fireRemoveFilterItem({key:k,index:I});t.fireFilterItemChanged({reason:"removed",key:k,index:I});t._bIgnoreBindCalls=false;break;default:throw"Operation'"+o+"' is not supported yet";}t._notifyChange();};};g.prototype._notifyChange=function(){var L=this.getChangeNotifier();if(L){L(this);}};return g;});
