/*!
* OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(['./library','./TitleAlignmentMixin','sap/ui/core/Control','sap/ui/core/IconPool','./Toolbar','./CheckBox','./SearchField','./List','./StandardListItem','./Dialog','./Button','./ToggleButton','./Title','./Label','./NavContainer','./Bar','./SegmentedButton','./Page','./ViewSettingsItem','sap/ui/base/ManagedObject','sap/ui/base/ManagedObjectObserver','sap/ui/base/EventProvider','sap/ui/Device','sap/ui/core/InvisibleText','./ViewSettingsDialogRenderer',"sap/m/GroupHeaderListItem","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/Focusable"],function(l,T,C,I,a,b,S,L,c,D,B,d,e,f,N,g,h,P,V,M,m,E,n,o,p,G,q,Q){"use strict";var r=l.ListMode;var s=l.ListType;var t=l.StringFilterOperator;var u=l.TitleAlignment;var v=l.ButtonType;var w="-list-item";var x=C.extend("sap.m.ViewSettingsDialog",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Behavior",defaultValue:null},sortDescending:{type:"boolean",group:"Behavior",defaultValue:false},groupDescending:{type:"boolean",group:"Behavior",defaultValue:false},filterSearchOperator:{type:"sap.m.StringFilterOperator",group:"Behavior",defaultValue:t.StartsWith},titleAlignment:{type:"sap.m.TitleAlignment",group:"Misc",defaultValue:u.Auto}},aggregations:{sortItems:{type:"sap.m.ViewSettingsItem",multiple:true,singularName:"sortItem",bindable:"bindable"},groupItems:{type:"sap.m.ViewSettingsItem",multiple:true,singularName:"groupItem",bindable:"bindable"},filterItems:{type:"sap.m.ViewSettingsItem",multiple:true,singularName:"filterItem",bindable:"bindable"},presetFilterItems:{type:"sap.m.ViewSettingsItem",multiple:true,singularName:"presetFilterItem",bindable:"bindable"},customTabs:{type:"sap.m.ViewSettingsCustomTab",multiple:true,singularName:"customTab",bindable:"bindable"}},associations:{selectedSortItem:{type:"sap.m.ViewSettingsItem",multiple:false},selectedGroupItem:{type:"sap.m.ViewSettingsItem",multiple:false},selectedPresetFilterItem:{type:"sap.m.ViewSettingsItem",multiple:false}},events:{confirm:{parameters:{sortItem:{type:"sap.m.ViewSettingsItem"},sortDescending:{type:"boolean"},groupItem:{type:"sap.m.ViewSettingsItem"},groupDescending:{type:"boolean"},presetFilterItem:{type:"sap.m.ViewSettingsItem"},filterItems:{type:"sap.m.ViewSettingsItem[]"},filterKeys:{type:"object",deprecated:true},filterCompoundKeys:{type:"object"},filterString:{type:"string"}}},cancel:{},resetFilters:{},reset:{},filterDetailPageOpened:{parameters:{parentFilterItem:{type:"sap.m.ViewSettingsFilterItem"}}}}}});x.prototype.init=function(){var j=this.getId();this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._sDialogWidth="350px";this._sDialogHeight="434px";this._bAppendedToUIArea=false;this._showSubHeader=false;this._filterDetailList=undefined;this._vContentPage=-1;this._oContentItem=null;this._oPreviousState={};this._sCustomTabsButtonsIdPrefix='-custom-button-';this._sTitleLabelId=j+"-title";this._sFilterDetailTitleLabelId=j+"-detailtitle";this._oFiltersSelectedOnly={};this._oKeylessFilters={};this._aggregationToListItems("sortItems",{text:{listProp:"title"},selected:{}},{tooltip:{}},{type:s.Active},{mode:r.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(k){var X=k.getParameter('listItem'),Y=this.getSortItems(),Z=this._getVSItem(X),i;Z.setProperty('selected',k.getParameter('selected'),true,false);this.setAssociation('selectedSortItem',Z,true);for(i=0;i<Y.length;i++){if(Z!==Y[i]){Y[i].setProperty('selected',false,true,false);}}this._checkResetStatus();}.bind(this)});};x.prototype.exit=function(){this._rb=null;this._sDialogWidth=null;this._sDialogHeight=null;this._bAppendedToUIArea=null;this._showSubHeader=null;this._vContentPage=null;this._oContentItem=null;this._oPreviousState=null;this._sortContent=null;this._groupContent=null;this._filterContent=null;this._sCustomTabsButtonsIdPrefix=null;this._fnFilterSearchCallback=null;this._oKeylessFilters=null;if(this._bAppendedToUIArea&&this._dialog){var i=sap.ui.getCore().getStaticAreaRef();i=sap.ui.getCore().getUIArea(i);i.removeContent(this._dialog,true);}if(this._dialog){this._dialog.destroy();this._dialog=null;}if(this._navContainer){this._navContainer.destroy();this._navContainer=null;}if(this._titleLabel){this._titleLabel.destroy();this._titleLabel=null;}if(this._page1){this._page1.destroy();this._page1=null;}if(this._header){this._header.destroy();this._header=null;}if(this._resetButton){this._resetButton.destroy();this._resetButton=null;}if(this._subHeader){this._subHeader.destroy();this._subHeader=null;}if(this._segmentedButton){this._segmentedButton.destroy();this._segmentedButton=null;}if(this._sortButton){this._sortButton.destroy();this._sortButton=null;}if(this._groupButton){this._groupButton.destroy();this._groupButton=null;}if(this._filterButton){this._filterButton.destroy();this._filterButton=null;}if(this._sortList){this._sortList.destroy();this._sortList=null;}if(this._ariaSortListInvisibleText){this._ariaSortListInvisibleText.destroy();this._ariaSortListInvisibleText=null;}if(this._sortOrderList){this._sortOrderList.destroy();this._sortOrderList=null;this._ariaSortOrderInvisibleText.destroy();this._ariaSortOrderInvisibleText=null;}if(this._oGroupingNoneItem){this._oGroupingNoneItem.destroy();this._oGroupingNoneItem=null;}if(this._groupList){this._groupList.destroy();this._groupList=null;this._ariaGroupListInvisibleText.destroy();this._ariaGroupListInvisibleText=null;}if(this._groupOrderList){this._groupOrderList.destroy();this._groupOrderList=null;this._ariaGroupOrderInvisibleText.destroy();this._ariaGroupOrderInvisibleText=null;}if(this._presetFilterList){this._presetFilterList.destroy();this._presetFilterList=null;}if(this._filterList){this._filterList.destroy();this._filterList=null;}if(this._page2){this._page2.destroy();this._page2=null;}if(this._detailTitleLabel){this._detailTitleLabel.destroy();this._detailTitleLabel=null;}if(this._filterDetailList){this._filterDetailList.destroy();this._filterDetailList=null;}if(this._oStringFilter){this._oStringFilter=null;}if(this._oSelectedFilterKeys){this._oSelectedFilterKeys=null;}};x.prototype._aggregationToListItems=function(i,j,k,X,Y){var Z=this._getListType(i),$="_"+Z+"List";if(!this.mToList){this.mToList={};}this.mToList[Z]={"itemPropertyMap":j,"itemAggregationMap":k,"listItemOptions":X,"listOptions":Y,"listName":$};};x.prototype._getListType=function(i){return i.replace('Items','');};x.prototype._createList=function(i){var j=this.getId()+"-"+i+"list",k=new L(j,this.mToList[i].listOptions),X=this._createGroupHeaderItem(i);k.addItem(X);this[this.mToList[i].listName]=k;return k;};x.prototype._createGroupHeaderItem=function(i){return new G({title:this._rb.getText("VIEWSETTINGS_"+i.toUpperCase()+"_OBJECT")});};x.prototype._getList=function(i){if(!this.mToList||!this.mToList[i]){return;}return this[this.mToList[i].listName];};x.prototype._createListItem=function(i,j){var k=this.mToList[i].listItemOptions,X=this.mToList[i].itemPropertyMap,Y=this.mToList[i].itemAggregationMap,Z,$;for(var _ in X){if(X.hasOwnProperty(_)){Z=X[_].listProp||_;k[Z]=this._createListItemPropertyValue(i,_,j);}}for(var a1 in Y){if(Y.hasOwnProperty(a1)){k[a1]=j.getAggregation(a1);}}$=new c(k).data('item',j);return $;};x.prototype._createListItemPropertyValue=function(i,j,k){var X=k.getMetadata().getAllProperties()[j].get(k),Y=this.mToList[i].itemPropertyMap[j].fn;return Y?Y(X):X;};x.prototype._getListItem=function(i,j){var k=this._getList(i).getItems().filter(function(X){return X.data('item')===j;});return k.length?k[0]:null;};x.prototype._getVSItem=function(i){return i.data('item');};x.prototype.addCustomTab=function(i){var j=i.getId();if(j==='sort'||j==='filter'||j==='group'){throw'Id "'+j+'" is reserved and cannot be used as custom tab id.';}this.addAggregation('customTabs',i);return this;};x.prototype.invalidate=function(){if(this._dialog&&(!arguments[0]||arguments[0]&&arguments[0].getId()!==this.getId()+"-dialog")){this._dialog.invalidate(arguments);}};x.prototype.addStyleClass=function(){var i=this._getDialog();i.addStyleClass.apply(i,arguments);return this;};x.prototype.removeStyleClass=function(){var i=this._getDialog();i.removeStyleClass.apply(i,arguments);return this;};x.prototype.toggleStyleClass=function(){var i=this._getDialog();i.toggleStyleClass.apply(i,arguments);return this;};x.prototype.hasStyleClass=function(){var i=this._getDialog();return i.hasStyleClass.apply(i,arguments);};x.prototype.getDomRef=function(){if(this._dialog){return this._dialog.getDomRef.apply(this._dialog,arguments);}else{return null;}};x.prototype.setTitle=function(i){this._getTitleLabel().setText(i);this.setProperty("title",i);return this;};x.prototype.addAggregation=function(i,j,k){C.prototype.addAggregation.apply(this,arguments);var X=this._getListType(i);if(this.mToList[X]){var Y=this._createListItem(X,j);var Z=this._getList(X);if(!Z){Z=this._createList(X);}else if(!Z.getItems().length){Z.addItem(this._createGroupHeaderItem(X));}Z.addItem(Y);this._attachItemPropertyChange(X,j);}else{this._attachItemEventHandlers(i,j);}if(i==="filterItems"){this._observeItem(j);}return this;};x.prototype.insertAggregation=function(i,j,k,X){C.prototype.insertAggregation.apply(this,arguments);var Y=this._getListType(i);if(this.mToList[Y]){var Z=this._createListItem(Y,j);var $=this._getList(Y);if(!$){$=this._createList(Y);$.insertItem(Z,k);}else if(!$.getItems().length){$.addItem(this._createGroupHeaderItem(Y));$.insertItem(Z,k+1);}else{$.insertItem(Z,k);}this._attachItemPropertyChange(Y,j);}else{this._attachItemEventHandlers(i,j);}if(i==="filterItems"){this._observeItem(j);}return this;};x.prototype.removeAggregation=function(i,j,k){H.call(this,i,j);var X=C.prototype.removeAggregation.apply(this,arguments);var Y=this._getListType(i);if(this.mToList[Y]){var Z=this._getListItem(Y,X);var $=this._getList(Y);var _=$.removeItem(Z);_.destroy();this._detachItemPropertyChange(X);}if(i==="filterItems"){this._unobserveItem(X);if(!this.getFilterItems().length){this._disconnectAndDestroyFilterItemsObserver();}}return X;};x.prototype.removeAllAggregation=function(i,j){H.call(this);var k=C.prototype.removeAllAggregation.apply(this,arguments);var X=this._getListType(i);if(this.mToList[X]){var Y=this._getList(X);if(Y){var Z=Y.removeAllItems();Z.forEach(function($){$.destroy();});}k.forEach(function($){this._detachItemPropertyChange($);},this);}if(i==="filterItems"){this._disconnectAndDestroyFilterItemsObserver();}return k;};x.prototype.destroyAggregation=function(i,j){H.call(this);C.prototype.destroyAggregation.apply(this,arguments);var k=this._getListType(i);if(this.mToList[k]){var X=this._getList(k);if(X){X.destroyItems();}}if(i==="filterItems"){this._disconnectAndDestroyFilterItemsObserver();}return this;};x.prototype._detachItemPropertyChange=function(i){delete E.getEventList(i)["itemPropertyChanged"];};x.prototype._attachItemPropertyChange=function(i,j){j.attachEvent('itemPropertyChanged',function fnHandleItemPropertyChanged(k){var X,Y,Z,$,_,a1;X=this._getListItem(i,j);Y=k.getParameter('propertyKey');if(!this.mToList[i].itemPropertyMap[Y]){return;}Z=this.mToList[i].itemPropertyMap[Y].listProp||Y;$=k.getParameter('propertyValue');_=this.mToList[i].itemPropertyMap[Y].fn;a1=_?_($):$;X.getMetadata().getAllProperties()[Z].set(X,a1);},this);};x.prototype._getFilterItemsObserver=function(){if(!this._oFilterItemsObserver){this._oFilterItemsObserver=new m(function(){if(this._oSelectedFilterKeys){this.setSelectedFilterCompoundKeys(this._oSelectedFilterKeys);}}.bind(this));}return this._oFilterItemsObserver;};x.prototype._observeItem=function(i){this._getFilterItemsObserver().observe(i,{aggregations:["items"]});};x.prototype._unobserveItem=function(i){this._getFilterItemsObserver().unobserve(i,{aggregations:["items"]});};x.prototype._disconnectAndDestroyFilterItemsObserver=function(){if(this._oFilterItemsObserver){this._oFilterItemsObserver.disconnect();this._oFilterItemsObserver.destroy();this._oFilterItemsObserver=null;}};x.prototype._attachItemEventHandlers=function(i,j){if(i!=='groupItems'&&i!=='filterItems'){return this;}var k=i.replace('Items','');k=k.charAt(0).toUpperCase()+k.slice(1);j.attachEvent('itemPropertyChanged',function(i,X){if(i==='filterItems'&&X.getParameter('changedItem').getParent().getMetadata().getName()==='sap.m.ViewSettingsFilterItem'){if(X.getParameter('propertyKey')!=='selected'){if(this._vContentPage===3&&this._oContentItem){this._setFilterDetailTitle(this._oContentItem);this._initFilterDetailItems(this._oContentItem);}}else{if(this._filterDetailList){var Y=this._filterDetailList.getItems();Y.forEach(function(Z){if(Z.data('item').getId()===X.getParameter('changedItem').getId()){Z.setSelected(X.getParameter('propertyValue'));}});this._updateSelectAllCheckBoxState();}}this._updateFilterCounters();}else{if(typeof this['_init'+k+'Content']==='function'){this['_init'+k+'Content']();}if(typeof this['_init'+k+'Items']==='function'){this['_init'+k+'Items']();}}}.bind(this,i));j.attachEvent('filterDetailItemsAggregationChange',function(X){if(this._vContentPage===3&&this._oContentItem){this._setFilterDetailTitle(this._oContentItem);this._initFilterDetailItems(this._oContentItem);}}.bind(this));return this;};x.prototype._setFilterDetailTitle=function(i){var j=this._rb.getText("VIEWSETTINGS_TITLE_FILTERBY")+" "+i.getText();this._getDetailTitleLabel().setText(j);this._toggleDialogTitle(this._sFilterDetailTitleLabelId);};x.prototype._toggleDialogTitle=function(i){var j=this._getDialog(),k=j.getAriaLabelledBy(),X=[this._sTitleLabelId,this._sFilterDetailTitleLabelId];if(X.indexOf(i)===-1&&k.indexOf(i)>-1){return this;}for(var Y in X){j.removeAriaLabelledBy(X[Y]);}j.addAriaLabelledBy(i);return this;};x.prototype.updateAggregation=function(i){C.prototype.updateAggregation.apply(this,arguments);if(i!=='groupItems'&&i!=='filterItems'){return this;}var j=i.replace('Items','');j=j.charAt(0).toUpperCase()+j.slice(1);if(typeof this['_init'+j+'Content']==='function'){this['_init'+j+'Content']();}if(typeof this['_init'+j+'Items']==='function'){this['_init'+j+'Items']();}};x.prototype.addSortItem=function(i){this.addAggregation("sortItems",i);if(i.getSelected()){this.setSelectedSortItem(i);}return this;};x.prototype.addGroupItem=function(i){this.addAggregation("groupItems",i);if(i.getSelected()){this.setSelectedGroupItem(i);}return this;};x.prototype.addPresetFilterItem=function(i){this.addAggregation("presetFilterItems",i);if(i.getSelected()){this.setSelectedPresetFilterItem(i);}return this;};x.prototype.setSelectedSortItem=function(j){var k=this.getSortItems(),i=0,X=A(j,k,"Could not set selected sort item. Item is not found: '"+j+"'");if(F(X)){for(i=0;i<k.length;i++){if(k[i].getId()!==X.getId()){k[i].setProperty('selected',false,true);}}if(X.getProperty('selected')!==true){X.setProperty('selected',true,true);}if(this._getDialog().isOpen()){this._updateListSelection(this._sortList,X);}this.setAssociation("selectedSortItem",X,true);}return this;};x.prototype.setSelectedGroupItem=function(j){var k=this.getGroupItems(),i=0,X=A(j,k,"Could not set selected group item. Item is not found: '"+j+"'");if(!X&&!j){X=this._oGroupingNoneItem;}if(F(X)){for(i=0;i<k.length;i++){k[i].setProperty('selected',false,true);}X.setProperty('selected',true,true);if(this._getDialog().isOpen()){this._updateListSelection(this._groupList,X);}this.setAssociation("selectedGroupItem",X,true);}return this;};x.prototype.setSelectedPresetFilterItem=function(j){var k=this.getPresetFilterItems(),i=0,X=A(j,k,"Could not set selected preset filter item. Item is not found: '"+j+"'");if(F(X)||X===null){for(i=0;i<k.length;i++){k[i].setProperty('selected',false,true);}if(X!==null){X.setProperty('selected',true,true);}this._clearSelectedFilters();this.setAssociation("selectedPresetFilterItem",X,true);}return this;};x.prototype.open=function(i){if(!this.getParent()&&!this._bAppendedToUIArea){var j=sap.ui.getCore().getStaticAreaRef();j=sap.ui.getCore().getUIArea(j);j.addContent(this._getDialog(),true);this._bAppendedToUIArea=true;}if(i&&this._vContentPage===3){setTimeout(this._getNavContainer()["to"].bind(this._getNavContainer(),this._getPage1().getId(),"show"),0);}this._initDialogContent(i);this._oPreviousState={sortItem:sap.ui.getCore().byId(this.getSelectedSortItem()),sortDescending:this.getSortDescending(),groupItem:sap.ui.getCore().byId(this.getSelectedGroupItem()),groupDescending:this.getGroupDescending(),presetFilterItem:sap.ui.getCore().byId(this.getSelectedPresetFilterItem()),filterKeys:this.getSelectedFilterKeys(),filterCompoundKeys:this.getSelectedFilterCompoundKeys(),navPage:this._getNavContainer().getCurrentPage(),contentPage:this._vContentPage,contentItem:this._oContentItem};if(!this._oInitialState){this._oInitialState={sortItem:this.getSelectedSortItem(),sortDescending:this.getSortDescending(),groupItem:this.getSelectedGroupItem(),groupDescending:this.getGroupDescending(),presetFilterItem:this.getSelectedPresetFilterItem()};}if(n.system.desktop){this._getDialog().attachEventOnce("afterOpen",function(){var k=this._getNavContainer().getCurrentPage(),$;if(k){$=k.$("cont").firstFocusableDomRef();if($){if(Q($).hasClass('sapMListUl')){var X=Q($).find('.sapMLIB');X.length&&X[0].focus();return;}$.focus();}}},this);}this._checkResetStatus();this._getDialog().open();return this;};x.prototype.getSelectedFilterItems=function(){var k=[],X=this.getFilterItems(),Y,Z=true,i=0,j;for(;i<X.length;i++){if(X[i]instanceof sap.m.ViewSettingsCustomItem){if(X[i].getSelected()){k.push(X[i]);}}else if(X[i]instanceof sap.m.ViewSettingsFilterItem){Y=X[i].getItems();Z=X[i].getMultiSelect();for(j=0;j<Y.length;j++){if(Y[j].getSelected()){k.push(Y[j]);if(!Z){break;}}}}}return k;};x.prototype.getSelectedFilterString=function(){var k="",X,Y=this.getSelectedPresetFilterItem(),Z=this.getFilterItems(),$,_=true,i=0,j;if(Y){k=this._rb.getText("VIEWSETTINGS_FILTERTEXT").concat(" "+sap.ui.getCore().byId(Y).getText());}else{for(;i<Z.length;i++){if(Z[i]instanceof sap.m.ViewSettingsCustomItem){if(Z[i].getSelected()){k+=Z[i].getText()+", ";}}else if(Z[i]instanceof sap.m.ViewSettingsFilterItem){$=Z[i].getItems();_=Z[i].getMultiSelect();X="";for(j=0;j<$.length;j++){if($[j].getSelected()){X+=$[j].getText()+", ";if(!_){break;}}}X=X.substring(0,X.length-2);if(X){X=" ("+X+")";k+=Z[i].getText()+X+", ";}}}k=k.substring(0,k.length-2);if(k){k=this._rb.getText("VIEWSETTINGS_FILTERTEXT").concat(" "+k);}}return k;};x.prototype.getSelectedFilterKeys=function(){var j={},k=this.getSelectedFilterItems(),i=0;for(;i<k.length;i++){j[k[i].getKey()]=k[i].getSelected();}return j;};x.prototype.getSelectedFilterCompoundKeys=function(){var j={},k=this.getSelectedFilterItems(),i,X,Y,Z;this._oKeylessFilters={};for(i=0;i<k.length;i++){Z=k[i];if(Z instanceof sap.m.ViewSettingsCustomItem){X=Z.getKey();j[X]=Z.getSelected();}else{X=Z.getKey();Y=Z.getParent().getKey();if(!j[Y]){j[Y]={};}j[Y][X]=Z.getSelected();if(X===""){if(!this._oKeylessFilters[Y]){this._oKeylessFilters[Y]={};}this._oKeylessFilters[Y][Z.getText()]=true;}}}return j;};x.prototype.setSelectedFilterKeys=function(X){var Y=this.getFilterItems(),Z={},$,_,i,j,k;if(Object.keys(X).length){this._clearPresetFilter();}for(var a1 in X){$=null;if(X.hasOwnProperty(a1)){for(i=0;i<Y.length;i++){if(Y[i]instanceof sap.m.ViewSettingsCustomItem){if(Y[i].getKey()===a1){$=Y[i];Y[i].setProperty('selected',X[a1],true);}}else if(Y[i]instanceof sap.m.ViewSettingsFilterItem){Z=Y[i].getItems();_=Y[i].getMultiSelect();for(j=0;j<Z.length;j++){if(Z[j].getKey()===a1){$=Z[j];if(!_){for(k=0;k<Z.length;k++){Z[k].setProperty('selected',false,true);}}break;}}}if($){break;}}if($===null){q.warning('Cannot set state for key "'+a1+'" because there is no filter with these keys');continue;}$.setProperty('selected',X[a1],true);}}return this;};x.prototype.setSelectedFilterCompoundKeys=function(i){var j=this.getFilterItems(),k,X,Y,Z,$,_,a1,b1,c1,d1;this._oSelectedFilterKeys=i;if(Object.keys(i).length){this._clearPresetFilter();for(k in i){Z=null;for(d1=0;d1<j.length;d1++){X=j[d1].getKey();if(X===k){Z=j[d1];break;}}if(Z instanceof sap.m.ViewSettingsCustomItem){Z.setProperty('selected',i[k],true);}else if(Z instanceof sap.m.ViewSettingsFilterItem){$=i[k];_=Z.getItems();a1=Z.getMultiSelect();c1=false;for(d1=0;d1<_.length;d1++){X=_[d1].getKey();Y=_[d1].getText();if((X!==""&&$[X])||(X===""&&this._oKeylessFilters[k]&&this._oKeylessFilters[k][Y])){b1=c1?false:$[X];}else{b1=false;}_[d1].setProperty("selected",b1,true);if(b1&&!a1){c1=true;}}}}}return this;};x.prototype._checkForInnerCustomItems=function(j){for(var i=0;i<j.length;i++){if(j[i].isA("sap.m.ViewSettingsCustomItem")){return true;}}return false;};x.prototype._checkForCustomItems=function(){var i=this.getSortItems(),j=this.getGroupItems(),k=this.getFilterItems(),X=this.getPresetFilterItems();return this.getAggregation("customTabs").length||i.length&&this._checkForInnerCustomItems(i)||j.length&&this._checkForInnerCustomItems(j)||k.length&&this._checkForInnerCustomItems(k)||X.length&&this._checkForInnerCustomItems(X);};x.prototype._checkResetStatus=function(){var i=false,j=this.getSelectedFilterItems();if(this._checkForCustomItems()){i=true;}else{if(this._oInitialState){if(j.length>0){i=true;}if((this._oInitialState.sortItem&&this._oInitialState.sortItem!==this.getSelectedSortItem())||this._oInitialState.sortDescending!==this.getSortDescending()){i=true;}if((this._oInitialState.groupItem&&this._oInitialState.groupItem!==this.getSelectedGroupItem())||this._oInitialState.groupDescending!==this.getGroupDescending()){i=true;}if(this._oInitialState.presetFilterItem!==undefined&&this.getSelectedPresetFilterItem()!==null){i=true;}}}if(this._resetButton){this._resetButton.setEnabled(i);}if(this._detailResetButton){this._detailResetButton.setEnabled(i);}};x.prototype._globalReset=function(){this.clearFilters();this._oInitialState.sortItem!==undefined&&this.setSelectedSortItem(sap.ui.getCore().byId(this._oInitialState.sortItem));this.setSortDescending(this._oInitialState.sortDescending);this._updateListSelection(this._sortOrderList,this._oInitialState.sortDescending);this._oInitialState.groupItem!==undefined&&this.setSelectedGroupItem(sap.ui.getCore().byId(this._oInitialState.groupItem));this.setGroupDescending(this._oInitialState.groupDescending);this._updateListSelection(this._groupOrderList,this._oInitialState.groupDescending);this._checkResetStatus();this.fireReset();};x.prototype._getDialog=function(){var i=this;if(this._dialog===undefined){this._dialog=new D(this.getId()+"-dialog",{ariaLabelledBy:this._sTitleLabelId,showHeader:false,stretch:n.system.phone,verticalScrolling:true,horizontalScrolling:false,contentWidth:this._sDialogWidth,contentHeight:this._sDialogHeight,content:this._getNavContainer(),titleAlignment:this.getTitleAlignment(),beginButton:new B(this.getId()+"-acceptbutton",{text:this._rb.getText("VIEWSETTINGS_ACCEPT"),type:v.Emphasized}).attachPress(this._onConfirm,this),endButton:new B(this.getId()+"-cancelbutton",{text:this._rb.getText("VIEWSETTINGS_CANCEL")}).attachPress(this._onCancel,this)}).addStyleClass("sapMVSD");this.addDependent(this._dialog);var j=this._dialog.onsapescape;this._dialog.onsapescape=function(k){if(j){j.call(i._dialog,k);}i._onCancel();};this._dialog.onsapentermodifiers=function(k){if(k.shiftKey&&!k.ctrlKey&&!k.altKey){i._pressBackButton();}};}return this._dialog;};x.prototype._getNavContainer=function(){if(this._navContainer===undefined){this._navContainer=new N(this.getId()+'-navcontainer',{pages:[]});}return this._navContainer;};x.prototype._getTitleLabel=function(){if(this._titleLabel===undefined){this._titleLabel=new f(this._sTitleLabelId,{text:this._rb.getText("VIEWSETTINGS_TITLE")}).addStyleClass("sapMVSDTitle");}return this._titleLabel;};x.prototype._getResetButton=function(){if(!this._resetButton){this._resetButton=new B(this.getId()+"-resetbutton",{press:function(){this._globalReset();}.bind(this),text:this._rb.getText("VIEWSETTINGS_RESET")});}return this._resetButton;};x.prototype._getDetailResetButton=function(){if(this._detailResetButton===undefined){this._detailResetButton=new B(this.getId()+"-detailresetbutton",{press:function(){this._globalReset();}.bind(this),text:this._rb.getText("VIEWSETTINGS_RESET")});}return this._detailResetButton;};x.prototype._getDetailTitleLabel=function(){if(this._detailTitleLabel===undefined){this._detailTitleLabel=new f(this.getId()+"-detailtitle",{text:this._rb.getText("VIEWSETTINGS_TITLE_FILTERBY")}).addStyleClass("sapMVSDTitle");}return this._detailTitleLabel;};x.prototype._getHeader=function(){if(this._header===undefined){this._header=new g({contentMiddle:[this._getTitleLabel()]}).addStyleClass("sapMVSDBar");}this._setupBarTitleAlignment(this._header,this.getId()+'_header');return this._header;};x.prototype._getSubHeader=function(){if(this._subHeader===undefined){this._subHeader=new g({contentLeft:[this._getSegmentedButton()]}).addStyleClass("sapMVSDBar");}return this._subHeader;};x.prototype._getSegmentedButton=function(){var j=this,k=this.getCustomTabs(),X=k.length,i=0;if(this._segmentedButton===undefined){this._segmentedButton=new h({select:function(Y){var Z=Y.getParameter('id');if(Z===j.getId()+"-sortbutton"){j._switchToPage(0);}else if(Z===j.getId()+"-groupbutton"){j._switchToPage(1);}else if(Z===j.getId()+"-filterbutton"){j._switchToPage(2);}else{for(i=0;i<X;i++){var $=k[i],_=j.getId()+j._sCustomTabsButtonsIdPrefix+$.getId();if(!j._isEmptyTab($)&&Z===_){j._switchToPage($.getId());break;}}}q.info('press event segmented: '+Y.getParameter('id'));}}).addStyleClass("sapMVSDSeg");this._segmentedButton._bPreventWidthRecalculationOnAfterRendering=true;}return this._segmentedButton;};x.prototype._getSortButton=function(){if(this._sortButton===undefined){this._sortButton=new B(this.getId()+"-sortbutton",{icon:I.getIconURI("sort"),tooltip:this._rb.getText("VIEWSETTINGS_TITLE_SORT")});}return this._sortButton;};x.prototype._getGroupButton=function(){if(this._groupButton===undefined){this._groupButton=new B(this.getId()+"-groupbutton",{icon:I.getIconURI("group-2"),tooltip:this._rb.getText("VIEWSETTINGS_TITLE_GROUP")});}return this._groupButton;};x.prototype._getFilterButton=function(){if(this._filterButton===undefined){this._filterButton=new B(this.getId()+"-filterbutton",{icon:I.getIconURI("filter"),tooltip:this._rb.getText("VIEWSETTINGS_TITLE_FILTER")});}return this._filterButton;};x.prototype._getPage1=function(i){if(this._page1===undefined&&!i){this._page1=new P(this.getId()+'-page1',{title:this._rb.getText("VIEWSETTINGS_TITLE"),customHeader:this._getHeader()});this._getNavContainer().addPage(this._page1);}return this._page1;};x.prototype._getPage2=function(){var i,j,k;if(this._page2===undefined){j=new B(this.getId()+"-backbutton",{icon:I.getIconURI("nav-back"),press:[this._pressBackButton,this]});k=this._getDetailResetButton();i=new g({contentLeft:[j],contentMiddle:[this._getDetailTitleLabel()],contentRight:[k]}).addStyleClass("sapMVSDBar");this._setupBarTitleAlignment(i,this.getId()+"_page2_header");this._page2=new P(this.getId()+'-page2',{title:this._rb.getText("VIEWSETTINGS_TITLE_FILTERBY"),customHeader:i});this._getNavContainer().addPage(this._page2);}return this._page2;};x.prototype._initFilterDetailItems=function(k){if(!(k instanceof sap.m.ViewSettingsFilterItem)){return;}var X;var Y=k.getMultiSelect();var Z=k.getItems();var $=this;if(this._filterDetailList){this._filterDetailList.destroy();}this._getPage2().removeAllAggregation('content');this._filterDetailList=new L({mode:(Y?r.MultiSelect:r.SingleSelectLeft),includeItemInSelection:true,selectionChange:function(_){var a1,b1=_.getParameter("listItems"),c1,i=0,d1;$._clearPresetFilter();if(Y){this._updateSelectAllCheckBoxState();}if(b1.length>1&&Y){c1=k.getItems();for(;i<c1.length;i++){for(var j=0;j<b1.length;j++){if(c1[i].getKey()===b1[j].getCustomData()[0].getValue().getKey()){c1[i].setProperty('selected',b1[j].getSelected(),true);}}}}else{a1=_.getParameter("listItem").data("item");if(!k.getMultiSelect()){c1=k.getItems();for(;i<c1.length;i++){if(c1[i].getId()!==a1.getId()){c1[i].setProperty('selected',false,true);}}}d1=_.getParameter("listItem").getSelected();if(a1.getProperty('selected')!==d1){a1.setProperty('selected',d1,true);}}this._checkResetStatus();}.bind(this)});for(var i=0;i<Z.length;i++){X=new c({title:M.escapeSettingsValue(Z[i].getText()),type:s.Active,selected:Z[i].getSelected(),tooltip:Z[i].getTooltip()}).data("item",Z[i]);this._filterDetailList.addItem(X);}this._filterSearchField=this._getFilterSearchField(this._filterDetailList);this._showOnlySelectedButton=this._getShowOnlySelectedButton();this._searchBar=new a({content:[this._filterSearchField.addStyleClass('sapMVSDFilterSearchField').addStyleClass('sapMTBShrinkItem'),this._showOnlySelectedButton]});this._getPage2().addContent(this._searchBar);this._getPage2().getCustomHeader().addStyleClass('sapMVSDBarWithSearch');if(Y){this._selectAllCheckBox=this._createSelectAllCheckbox(Z,this._filterDetailList);if(this._filterDetailList.getItems().length===0){this._selectAllCheckBox.setEnabled(false);}this._filterDetailList.setHeaderToolbar(new a({content:[this._selectAllCheckBox]}).addStyleClass('sapMVSDFilterHeaderToolbar'));}this._setFilterDetailItemsVisibility(this._filterDetailList,true);this._getPage2().addContent(this._filterDetailList);};x.prototype._initSortContent=function(){if(this._sortContent){return;}this._vContentPage=-1;this._ariaSortOrderInvisibleText=new o(this.getId()+"-sortOrderLabel",{text:this._rb.getText("VIEWSETTINGS_SORT_DIRECTION")});this._sortOrderList=new L(this.getId()+"-sortorderlist",{mode:r.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(i){this.setProperty('sortDescending',i.getParameter("listItem").data("item"),true);this._checkResetStatus();}.bind(this),ariaLabelledBy:this._ariaSortOrderInvisibleText});this._sortOrderList.addItem(new G({title:this._rb.getText("VIEWSETTINGS_SORT_BY")}));this._sortOrderList.addItem(new c({title:this._rb.getText("VIEWSETTINGS_ASCENDING_ITEM")}).data("item",false).setSelected(true));this._sortOrderList.addItem(new c({title:this._rb.getText("VIEWSETTINGS_DESCENDING_ITEM")}).data("item",true));this._ariaSortListInvisibleText=new o(this.getId()+"-sortListLabel",{text:this._rb.getText("VIEWSETTINGS_TITLE_SORT")});this._sortList.addAriaLabelledBy(this._ariaSortListInvisibleText);this._sortContent=[this._ariaSortOrderInvisibleText,this._sortOrderList,this._ariaSortListInvisibleText,this._sortList];};x.prototype._initGroupItems=function(){var i,j,k=this.getGroupItems(),X=this._rb.getText("VIEWSETTINGS_GROUP_OBJECT");this._groupList.destroyItems();if(!!k.length){this._groupList.addItem(new G({title:X}));k.forEach(function(Y){i=new c({id:Y.getId()+w,title:M.escapeSettingsValue(Y.getText()),type:s.Active,selected:Y.getSelected(),tooltip:Y.getTooltip()}).data("item",Y);this._groupList.addItem(i);},this);if(!this._oGroupingNoneItem||this._oGroupingNoneItem.bIsDestroyed){j=!!this.getSelectedGroupItem();this._oGroupingNoneItem=new V({text:this._rb.getText("VIEWSETTINGS_NONE_ITEM"),selected:!j,itemPropertyChanged:function(){this._initGroupContent();this._initGroupItems();}.bind(this)});!j&&this.setAssociation("selectedGroupItem",this._oGroupingNoneItem,true);}i=new c({id:this._oGroupingNoneItem.getId()+w,title:this._oGroupingNoneItem.getText(),type:s.Active,selected:this._oGroupingNoneItem.getSelected()}).data("item",this._oGroupingNoneItem);this._groupList.addItem(i);}};x.prototype._initGroupContent=function(){var i=this._rb.getText("VIEWSETTINGS_GROUP_BY");if(this._groupContent){return;}this._vContentPage=-1;this._ariaGroupOrderInvisibleText=new o(this.getId()+"-groupOrderLabel",{text:this._rb.getText("VIEWSETTINGS_GROUP_DIRECTION")});this._groupOrderList=new L(this.getId()+"-grouporderlist",{mode:r.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(j){this.setProperty('groupDescending',j.getParameter("listItem").data("item"),true);this._checkResetStatus();}.bind(this),ariaLabelledBy:this._ariaGroupOrderInvisibleText});this._groupOrderList.addItem(new G({title:i}));this._groupOrderList.addItem(new c({title:this._rb.getText("VIEWSETTINGS_ASCENDING_ITEM")}).data("item",false).setSelected(true));this._groupOrderList.addItem(new c({title:this._rb.getText("VIEWSETTINGS_DESCENDING_ITEM")}).data("item",true));this._ariaGroupListInvisibleText=new o(this.getId()+"-groupListLabel",{text:this._rb.getText("VIEWSETTINGS_TITLE_GROUP")});this._groupList=new L(this.getId()+"-grouplist",{mode:r.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(j){var k=j.getParameter("listItem").data("item");this.setSelectedGroupItem(k);this._checkResetStatus();}.bind(this),ariaLabelledBy:this._ariaGroupListInvisibleText});this._groupContent=[this._ariaGroupOrderInvisibleText,this._groupOrderList,this._ariaGroupListInvisibleText,this._groupList];};x.prototype._initFilterItems=function(){var i,j,k,X=this,Y=this._rb.getText("VIEWSETTINGS_FILTER_BY");this._presetFilterList.destroyItems();i=this.getPresetFilterItems();if(i.length){i.forEach(function(Z){k=new c({id:Z.getId()+w,title:M.escapeSettingsValue(Z.getText()),type:s.Active,selected:Z.getSelected(),tooltip:Z.getTooltip()}).data("item",Z);this._presetFilterList.addItem(k);},this);}if(i.length){k=new c({id:this._presetFilterList.getId()+"-none"+w,title:this._rb.getText("VIEWSETTINGS_NONE_ITEM"),selected:!!this.getSelectedPresetFilterItem()});this._presetFilterList.addItem(k);}this._filterList.destroyItems();j=this.getFilterItems();this._filterList.addItem(new G({title:Y}));if(j.length){j.forEach(function(Z){k=new c({id:Z.getId()+w,title:M.escapeSettingsValue(Z.getText()),type:s.Active,tooltip:Z.getTooltip(),press:(function(Z){return function($){if(X._navContainer.getCurrentPage().getId()!==X.getId()+'-page2'){X._switchToPage(3,Z);X._prevSelectedFilterItem=this;setTimeout(X._navContainer["to"].bind(X._navContainer,X.getId()+'-page2',"slide"),0);}if(n.system.desktop&&X._filterDetailList&&X._filterDetailList.getItems()[0]){X._getNavContainer().attachEventOnce("afterNavigate",function(){X._filterDetailList.getItems()[0].focus();});}};}(Z))}).data("item",Z);this._filterList.addItem(k);},this);}};x.prototype._initFilterContent=function(){if(this._filterContent){return;}this._vContentPage=-1;this._presetFilterList=new L(this.getId()+"-predefinedfilterlist",{mode:r.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(i){var j=i.getParameter("listItem").data("item");if(j){j.setProperty('selected',i.getParameter("listItem").getSelected(),true);}this.setAssociation("selectedPresetFilterItem",j,true);this._clearSelectedFilters();this._checkResetStatus();}.bind(this)});this._filterList=new L(this.getId()+"-filterlist",{});this._filterContent=[this._presetFilterList,this._filterList];};x.prototype._initDialogContent=function(i){var j=!!this.getSortItems().length,k=!!this.getGroupItems().length,X=!!this.getPresetFilterItems().length,Y=!!this.getFilterItems().length;if(j){this._initSortContent();}if(k){this._initGroupContent();this._initGroupItems();}if(X||Y){this._initFilterContent();this._initFilterItems();}this._updateDialogState(i);this._updateListSelections();};x.prototype._getTabButton=function(i,j){var k=j+i.getId(),X=sap.ui.getCore().byId(k);if(X){return X;}else{return new B({id:k,icon:i.getIcon(),tooltip:i.getTooltip()});}};x.prototype._updateDialogState=function(i){var j=!!this.getSortItems().length,k=!!this.getGroupItems().length,X=!!this.getPresetFilterItems().length,Y=!!this.getFilterItems().length,Z=!!this.getCustomTabs().length,$=this._getSegmentedButton(),_=null,a1=false,b1={"sort":0,"group":1,"filter":2};$.removeAllButtons();if(this._filterContent){this._presetFilterList.setVisible(true);this._filterList.setVisible(true);}if(j){$.addButton(this._getSortButton());}if(X||Y){$.addButton(this._getFilterButton());if(!X){this._presetFilterList.setVisible(false);}if(!Y){this._filterList.setVisible(false);}}if(k){$.addButton(this._getGroupButton());}if(Z){this.getCustomTabs().forEach(function(d1){if(!this._isEmptyTab(d1)){var e1=this.getId()+this._sCustomTabsButtonsIdPrefix,f1=this._getTabButton(d1,e1);$.addButton(f1);}}.bind(this));}this._showSubHeader=this._hasSubHeader();if(i===undefined&&this._vContentPage!==-1){i=this._vContentPage;switch(i){case 0:i='sort';break;case 1:i='group';break;case 2:i='filter';break;}}if(i===this._vContentPage&&this._vContentPage===3){this._vContentPage=-1;this._switchToPage(3,this._oContentItem);}else{i=this._determineValidPageId(i);for(var c1 in b1){if(i===c1){a1=true;_=this.getId()+'-'+i+'button';i=b1[c1];break;}}if(!a1){_=this.getId()+this._sCustomTabsButtonsIdPrefix+i;}this._getSegmentedButton().setSelectedButton(_);this._switchToPage(i);if(this._getNavContainer().getCurrentPage()!==this._getPage1()){this._getNavContainer().to(this._getPage1().getId());}}};x.prototype._determineValidPageId=function(i){var j='sort',k=false,X=[];X=this._fetchValidPagesIds();if(X.length){j=X[0];}else{q.warning('No available pages to load - missing items.');}if(!i){i=j;}else{X.filter(function(Y){if(Y===i){k=true;return false;}return true;});if(!k){i=j;}}return i;};x.prototype._fetchValidPagesIds=function(){var i,j=this.getCustomTabs(),k=j.length,X=[];var Y=['sort','filter','group'];Y.forEach(function($){if(this._isValidPredefinedPageId($)){X.push($);}},this);for(i=0;i<k;i++){var Z=j[i];if(!this._isEmptyTab(Z)){X.push(Z.getId());}}return X;};x.prototype._isEmptyTab=function(i){return!(i.getContent().length||this._vContentPage===i.getId()&&this._getPage1().getContent().length);};x.prototype._isValidPredefinedPageId=function(i){if(!i){q.warning('Missing mandatory parameter.');return false;}var j=false;switch(i){case'sort':j=!!this.getSortItems().length;break;case'filter':j=!!this.getFilterItems().length||!!this.getPresetFilterItems().length;break;case'group':j=!!this.getGroupItems().length;break;}return j;};x.prototype._pressBackButton=function(){var i=this;if(this._vContentPage===3){this._updateFilterCounters();this._getNavContainer().attachEvent("afterNavigate",function(){if(i._prevSelectedFilterItem){i._prevSelectedFilterItem.focus();}});setTimeout(this._getNavContainer()['back'].bind(this._getNavContainer()),0);this._switchToPage(2);this._segmentedButton.setSelectedButton(this._filterButton);}};x.prototype.setModel=function(i,j){if(this._vContentPage===3&&this._oContentItem){y.call(this);}return M.prototype.setModel.call(this,i,j);};x.prototype.removeFilterItem=function(i){var j="";if(this._vContentPage===3&&this._oContentItem){if(typeof(i)==="object"){j=i.getId();}else if(typeof(i)==="string"){j=i;}else if(typeof(i)==="number"){j=this.getFilterItems()[i].getId();}if(this._oContentItem.getId()===j){y.call(this);}}return this.removeAggregation('filterItems',i);};x.prototype.removeAllFilterItems=function(){if(this._vContentPage===3&&this._oContentItem){y.call(this);}return this.removeAllAggregation('filterItems');};x.prototype.setFilterSearchCallback=function(i){this._fnFilterSearchCallback=i;return this;};x.prototype._switchToPage=function(j,k){var i=0,X=this._getTitleLabel(),Y=this._getHeader(),Z=this._getSubHeader();this._checkResetStatus();this._getPage2().getCustomHeader().removeStyleClass('sapMVSDBarWithSearch');if(J.call(this)){H.call(this);}Y.removeAllContentRight();Z.removeAllContentRight();this._vContentPage=j;this._oContentItem=k;if(j!==3){this._getPage1().removeAllAggregation("content",true);this._addResetButtonToPage1();}else if(j===3){this._getPage2().removeAllAggregation("content",true);}if(this.getTitle()){X.setText(this.getTitle());}else{X.setText(this._rb.getText("VIEWSETTINGS_TITLE"));}this._toggleDialogTitle(this._sTitleLabelId);switch(j){case 1:if(!this._showSubHeader&&!this.getTitle()){X.setText(this._rb.getText("VIEWSETTINGS_TITLE_GROUP"));}for(;i<this._groupContent.length;i++){this._getPage1().addContent(this._groupContent[i]);}break;case 2:if(!this._showSubHeader&&!this.getTitle()){X.setText(this._rb.getText("VIEWSETTINGS_TITLE_FILTER"));}this._updateListSelection(this._presetFilterList,sap.ui.getCore().byId(this.getSelectedPresetFilterItem()));this._updateFilterCounters();for(;i<this._filterContent.length;i++){this._getPage1().addContent(this._filterContent[i]);}break;case 3:this._setFilterDetailTitle(k);if(k instanceof sap.m.ViewSettingsCustomItem&&k.getCustomControl()){this._clearPresetFilter();this._getPage2().addContent(k.getCustomControl());}else if(k instanceof sap.m.ViewSettingsFilterItem&&k.getItems()){this._initFilterDetailItems(k);}break;case 0:if(!this._getPage1().getSubHeader()&&!this.getTitle()){X.setText(this._rb.getText("VIEWSETTINGS_TITLE_SORT"));}if(this._sortContent){for(;i<this._sortContent.length;i++){this._getPage1().addContent(this._sortContent[i]);}}break;default:this._getPage1().removeAllAggregation("content",true);var $="VIEWSETTINGS_TITLE";var _=this.getCustomTabs();if(_.length<2){$=_[0].getTitle();}if(!this._getPage1().getSubHeader()&&!this.getTitle()){X.setText($);}_.forEach(function(a1){if(a1.getId()===j){a1.getContent().forEach(function(b1){this._getPage1().addContent(b1);},this);}},this);break;}if(j===3){this.fireFilterDetailPageOpened({parentFilterItem:k});}};x.prototype._createSelectAllCheckbox=function(i,j){var k=false;if(i&&i.length!==0){k=i.every(function(Y){return Y.getSelected();});}var X=new b({text:this._rb.getText("COLUMNSPANEL_SELECT_ALL"),selected:k,select:function(Y){var Z=Y.getParameter('selected');j.getItems().filter(function($){return $.getVisible();}).forEach(function($){var _=$.data("item");_.setSelected(Z);});this._checkResetStatus();}.bind(this)});return X;};x.prototype._updateSelectAllCheckBoxState=function(){var i=false,j=this._filterDetailList.getItems(),k=[];if(!this._selectAllCheckBox){return;}if(j&&j.length!==0){k=j.filter(function(X){return X.getVisible();});}if(k.length!==0){this._selectAllCheckBox.setEnabled(true);i=k.every(function(X){return X.getSelected();});}else{this._selectAllCheckBox.setEnabled(false);}this._selectAllCheckBox.setSelected(i);};x.prototype._visibilityBySearchField=function(i){var j=this._filterSearchField.getValue(),k=this._getStringFilter(),X=k(j,i.getTitle());return X;};x.prototype._visibilityByToggleButton=function(i){var j=this._showOnlySelectedButton.getPressed()?i.getSelected():true;return j;};x.prototype._getFilterSearchField=function(i){var j=new S({liveChange:function(){this._setFilterDetailItemsVisibility(i);}.bind(this)});return j;};x.prototype._setFilterDetailItemsVisibility=function(i,j){i.getItems().forEach(function(k){k.setVisible(this._visibilityByToggleButton(k)&&(j||this._visibilityBySearchField(k)));}.bind(this));this._updateSelectAllCheckBoxState();};x.prototype._getShowOnlySelectedButton=function(){var i=this._oContentItem&&this._oFiltersSelectedOnly[this._oContentItem.getId()]?true:false,j=new d({icon:I.getIconURI("multi-select"),tooltip:this._rb.getText("SHOW_SELECTED_ONLY"),type:v.Transparent,pressed:i,press:function(){var k=this._showOnlySelectedButton.getPressed(),X=this._oContentItem.getId();if(k){this._oFiltersSelectedOnly[X]=true;}else{delete this._oFiltersSelectedOnly[X];}this._setFilterDetailItemsVisibility(this._filterDetailList);}.bind(this)});return j;};x.prototype._getStringFilter=function(){if(this._fnFilterSearchCallback){return this._fnFilterSearchCallback;}if(!this._oStringFilter||this._oStringFilter.sOperator!==this.getFilterSearchOperator()){this._oStringFilter=new K(this.getFilterSearchOperator());}return this._oStringFilter.filter.bind(this._oStringFilter);};x.prototype._updateListSelections=function(){this._updateListSelection(this._sortList,sap.ui.getCore().byId(this.getSelectedSortItem()));this._updateListSelection(this._sortOrderList,this.getSortDescending());this._updateListSelection(this._groupList,sap.ui.getCore().byId(this.getSelectedGroupItem()));this._updateListSelection(this._groupOrderList,this.getGroupDescending());this._updateListSelection(this._presetFilterList,sap.ui.getCore().byId(this.getSelectedPresetFilterItem()));this._updateFilterCounters();};x.prototype._updateListSelection=function(j,k){var X,i=0,Y;if(!j){return false;}X=j.getItems();j.removeSelections();for(;i<X.length;i++){Y=X[i].isA("sap.m.GroupHeaderListItem");if(!Y&&(X[i].data("item")===k||X[i].data("item")===null)){j.setSelectedItem(X[i],(k&&k.getSelected?k.getSelected():true));return true;}}return false;};x.prototype._updateFilterCounters=function(){var k=(this._filterList?this._filterList.getItems():[]),X,Y,Z=0,i=0,j;for(;i<k.length;i++){X=k[i].data("item");Z=0;if(X){if(X instanceof sap.m.ViewSettingsCustomItem){Z=X.getFilterCount();}else if(X instanceof sap.m.ViewSettingsFilterItem){Z=0;Y=X.getItems();for(j=0;j<Y.length;j++){if(Y[j].getSelected()){Z++;}}}}k[i].setCounter(Z);}};x.prototype._clearSelectedFilters=function(){var k=this.getFilterItems(),X,i=0,j;for(;i<k.length;i++){if(k[i]instanceof sap.m.ViewSettingsFilterItem){X=k[i].getItems();for(j=0;j<X.length;j++){X[j].setProperty('selected',false,true);}}k[i].setProperty('selected',false,true);}if(this._vContentPage===2&&this._getDialog().isOpen()){this._updateFilterCounters();}};x.prototype._clearPresetFilter=function(){if(this.getSelectedPresetFilterItem()){this.setSelectedPresetFilterItem(null);}};x.prototype._calculateNumberOfPages=function(){var i=0,j=!!this.getSortItems().length,k=!!this.getGroupItems().length,X=!!this.getPresetFilterItems().length,Y=!!this.getFilterItems().length;if(j){i++;}if(X||Y){i++;}if(k){i++;}this.getCustomTabs().forEach(function(Z){if(!this._isEmptyTab(Z)){i++;}},this);return i;};x.prototype._hasSubHeader=function(){return!(this._calculateNumberOfPages()<2);};function y(){this._vContentPage=2;this._oContentItem=null;this._navContainer.to(this._getPage1().getId(),"show");}function z(j,k){var i,X;for(i=0;i<j.length;i++){if(j[i].getKey()===k){X=j[i];break;}}return X;}function A(i,j,k){var X;if(typeof i==="string"){X=z(j,i);if(!X){q.error(k);}}else{X=i;}return X;}function F(i){return i&&i instanceof sap.m.ViewSettingsItem;}x.prototype._onConfirm=function(i){var j=this._getDialog(),k=this,X=function(){var Y,Z,$=k.getSelectedGroupItem();if(!k._oGroupingNoneItem||$!=k._oGroupingNoneItem.getId()){Z=sap.ui.getCore().byId($);}k._toggleDialogTitle(k._sTitleLabelId);Y={sortItem:sap.ui.getCore().byId(k.getSelectedSortItem()),sortDescending:k.getSortDescending(),groupItem:Z,groupDescending:k.getGroupDescending(),presetFilterItem:sap.ui.getCore().byId(k.getSelectedPresetFilterItem()),filterItems:k.getSelectedFilterItems(),filterKeys:k.getSelectedFilterKeys(),filterCompoundKeys:k.getSelectedFilterCompoundKeys(),filterString:k.getSelectedFilterString()};k._dialog.detachAfterClose(X);k.fireConfirm(Y);};j.attachAfterClose(X);j.close();};x.prototype._onCancel=function(i){var j=this,k=this._getDialog(),X=function(){j._toggleDialogTitle(j._sTitleLabelId);j.setSelectedSortItem(j._oPreviousState.sortItem);j.setSortDescending(j._oPreviousState.sortDescending);j.setSelectedGroupItem(j._oPreviousState.groupItem);j.setGroupDescending(j._oPreviousState.groupDescending);j.setSelectedPresetFilterItem(j._oPreviousState.presetFilterItem);j._clearSelectedFilters();j.setSelectedFilterCompoundKeys(j._oPreviousState.filterCompoundKeys);if(j._navContainer.getCurrentPage()!==j._oPreviousState.navPage){setTimeout(j._navContainer["to"].bind(j._navContainer,j._oPreviousState.navPage.getId(),"show"),0);}j._switchToPage(j._oPreviousState.contentPage,j._oPreviousState.contentItem);j._dialog.detachAfterClose(X);j.fireCancel();};k.attachAfterClose(X);k.close();};x.prototype.clearFilters=function(){this._clearSelectedFilters();this._clearPresetFilter();this.fireResetFilters();this._updateFilterCounters();if(this._vContentPage===3){setTimeout(this._getNavContainer()['to'].bind(this._getNavContainer(),this._getPage1().getId()),0);this._switchToPage(2);this._getSegmentedButton().setSelectedButton(this._getFilterButton());}this._updateListSelection(this._presetFilterList,sap.ui.getCore().byId(this.getSelectedPresetFilterItem()));return this;};x.prototype._addResetButtonToPage1=function(){var i=this._getHeader(),j=this._getSubHeader(),k=this._getResetButton();if(this._showSubHeader){if(!this._getPage1().getSubHeader()){this._getPage1().setSubHeader(j);}}else{if(this._getPage1().getSubHeader()){this._getPage1().setSubHeader();}}i.addContentRight(k);};x.prototype._applyContextualSettings=function(){M.prototype._applyContextualSettings.call(this,M._defaultContextualSettings);};function H(i,j){if(!this._getPage1(true)){return;}if(i==='customTabs'&&j){if(j.getMetadata().getName()===this.getMetadata().getManagedAggregation(i).type&&this._vContentPage===j.getId()){var k=this._getPage1().getContent();k.forEach(function(X){j.addAggregation('content',X,true);});}}else if(!i&&!j){var k=this._getPage1().getContent();this.getCustomTabs().forEach(function(j){if(this._vContentPage===j.getId()){k.forEach(function(X){j.addAggregation('content',X,true);});}},this);}}function J(){var i=[-1,0,1,2,3];return(this._getPage1().getContent().length&&i.indexOf(this._vContentPage)===-1);}x.prototype.setBusy=function(i){this._getDialog().setBusy(i);return this;};var K=function(i){this.sOperator=i||t.StartsWith;switch(this.sOperator){case t.Equals:this.fnOperator=O;break;case t.Contains:this.fnOperator=R;break;case t.StartsWith:this.fnOperator=U;break;case t.AnyWordStartsWith:this.fnOperator=W;break;default:q.warning("Unknown string compare operator. Use values from sap.m.StringFilterOperator. Default operator should be used.");this.fnOperator=R;break;}};K.prototype.filter=function(i,j){if(!i){return true;}if(!j){return false;}j=j.toLowerCase();i=i.toLowerCase();return this.fnOperator(i,j);};function O(i,j){return j===i;}function R(i,j){return j.indexOf(i)>-1;}function U(i,j){return j.indexOf(i)===0;}function W(i,j){var k=new RegExp(".*\\b"+i+".*");return k.test(j);}T.mixInto(x.prototype);return x;});
