/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Control","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ItemNavigation","sap/ui/Device","sap/m/ActionSheet","./WizardProgressNavigatorRenderer","./Button","sap/ui/thirdparty/jquery"],function(l,C,R,I,D,A,W,B,q){"use strict";var a=C.extend("sap.m.WizardProgressNavigator",{metadata:{properties:{stepCount:{type:"int",group:"Data",defaultValue:3},stepTitles:{type:"string[]",group:"Appearance",defaultValue:[]},stepIcons:{type:"sap.ui.core.URI[]",group:"Appearance",defaultValue:[]},varyingStepCount:{type:"boolean",group:"Appearance",defaultValue:false}},events:{stepChanged:{parameters:{current:{type:"int"}}}}}});a.CONSTANTS={MINIMUM_STEPS:3,MAXIMUM_STEPS:8,MIN_STEP_WIDTH_NO_TITLE:64,MIN_STEP_WIDTH_WITH_TITLE:200};a.TEXT={STEP:"WIZARD_PROG_NAV_STEP_TITLE",OPTIONAL_STEP:"WIZARD_STEP_OPTIONAL_STEP_TEXT"};a.prototype.init=function(){this._iCurrentStep=1;this._iActiveStep=1;this._aCachedSteps=[];this._aStepOptionalIndication=[];this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oActionSheet=new A();this._createStepNavigation();};a.prototype.onBeforeRendering=function(){if(this.getStepCount()!==this.getStepIcons().filter(String).length){this.setStepIcons([]);}if(this.getStepCount()!==this.getStepTitles().filter(String).length){this.setStepTitles([]);}};a.prototype.onAfterRendering=function(){var $,z=this._iActiveStep-1,Z=this._iCurrentStep-1;this._cacheDOMElements();this._updateStepZIndex();this._updateStepNavigation(z);this._updateStepActiveAttribute(z);this._removeStepAriaDisabledAttribute(z);this._updateStepCurrentAttribute(Z);this._updateStepAriaLabelAttribute(Z);this._updateOpenSteps();R.register(this.getDomRef(),this._updateOpenSteps.bind(this));if(D.os.name===D.os.OS.IOS){$=this.$().find(".sapMWizardProgressNavStep").css("display","block");setTimeout($["css"].bind($,"display",""),0);}};a.prototype.ontap=function(e){if(this._isGroupAtStart(e.target)){return this._showActionSheet(e.target,true);}if(this._isGroupAtEnd(e.target)){return this._showActionSheet(e.target,false);}if(!this._isOpenStep(e.target)||!this._isActiveStep(this._getStepNumber(e.target))){return;}this._updateCurrentStep(this._getStepNumber(e.target));this.fireStepChanged({current:this._getStepNumber(e.target)});};a.prototype.onsapspace=function(e){if(this._onEnter){this._onEnter(e,this._oStepNavigation.getFocusedIndex());}this.ontap(e);};a.prototype.onsapenter=a.prototype.onsapspace;a.prototype.exit=function(){R.deregisterAllForControl(this.getId());this.removeDelegate(this._oStepNavigation);this._oStepNavigation.destroy();this._oStepNavigation=null;this._oActionSheet.destroy();this._oActionSheet=null;this._iCurrentStep=null;this._iActiveStep=null;this._aCachedSteps=null;this._aStepOptionalIndication=null;};a.prototype.getCurrentStep=function(){return this._iCurrentStep;};a.prototype.getProgress=function(){return this._iActiveStep;};a.prototype.previousStep=function(){var c=this.getCurrentStep();if(c<2){return this;}return this._moveToStep(c-1);};a.prototype.nextStep=function(){return this._moveToStep(this.getCurrentStep()+1);};a.prototype.incrementProgress=function(){return this._moveToStep(this.getProgress()+1);};a.prototype.discardProgress=function(i){if(i<=0||i>this._iActiveStep){return this;}this._updateCurrentStep(i,this._iCurrentStep);this._updateStepActiveAttribute(i-1,this._iActiveStep-1);this._addStepAriaDisabledAttribute(i-1);this._updateStepNavigation(i-1);this._iCurrentStep=i;this._iActiveStep=i;};a.prototype._setOnEnter=function(c){this._onEnter=c;};a.prototype._createStepNavigation=function(){var t=this;this._oStepNavigation=new I();this._oStepNavigation.setCycling(false);this._oStepNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"]});this._oStepNavigation.attachEvent("AfterFocus",function(p){var e=p.mParameters.oEvent;if(!e||!e.relatedTarget||q(e.relatedTarget).hasClass(W.CLASSES.STEP)){return;}t._oStepNavigation.focusItem(t._iCurrentStep-1);});this.addDelegate(this._oStepNavigation);};a.prototype._cacheDOMElements=function(){var d=this.getDomRef();this._aCachedSteps=d.querySelectorAll("."+W.CLASSES.STEP);};a.prototype._updateStepZIndex=function(){var z=this._iCurrentStep-1,s=this._aCachedSteps.length,Z=a.CONSTANTS.MAXIMUM_STEPS;for(var i=0;i<s;i++){if(i<=z){this._aCachedSteps[i].style.zIndex=0;}else{this._aCachedSteps[i].style.zIndex=Z;Z-=1;}}};a.prototype._updateStepNavigation=function(b){var n=this.getDomRef(),f=[];for(var i=0;i<=b;i++){if(this._aCachedSteps[i]){f.push(this._aCachedSteps[i]);}}this._oStepNavigation.setRootDomRef(n);this._oStepNavigation.setItemDomRefs(f);this._oStepNavigation.setPageSize(b);this._oStepNavigation.setFocusedIndex(b);};a.prototype._updateStepActiveAttribute=function(n,o){if(o!==undefined&&this._aCachedSteps[o]){this._aCachedSteps[o].removeAttribute(W.ATTRIBUTES.ACTIVE_STEP);}if(this._aCachedSteps[n]){this._aCachedSteps[n].setAttribute(W.ATTRIBUTES.ACTIVE_STEP,true);}};a.prototype._updateStepCurrentAttribute=function(n,o){if(o!==undefined&&this._aCachedSteps[o]){this._aCachedSteps[o].removeAttribute(W.ATTRIBUTES.CURRENT_STEP);}if(this._aCachedSteps[n]){this._aCachedSteps[n].setAttribute(W.ATTRIBUTES.CURRENT_STEP,true);}};a.prototype._addStepAriaDisabledAttribute=function(b){var s=this._aCachedSteps.length,S;for(var i=b+1;i<s;i++){S=this._aCachedSteps[i];S.setAttribute(W.ATTRIBUTES.ARIA_DISABLED,true);}};a.prototype._removeStepAriaDisabledAttribute=function(i){if(this._aCachedSteps[i]){this._aCachedSteps[i].removeAttribute(W.ATTRIBUTES.ARIA_DISABLED);}};a.prototype._updateStepAriaLabelAttribute=function(n,o){if(o!==undefined&&this._aCachedSteps[o]){this._aCachedSteps[o].removeAttribute(W.ATTRIBUTES.ARIA_CURRENT);}if(this._aCachedSteps[n]){this._aCachedSteps[n].setAttribute(W.ATTRIBUTES.ARIA_CURRENT,"step");}};a.prototype._moveToStep=function(n){var s=this.getStepCount(),o=this.getCurrentStep();if(n>s){return this;}if(n>this._iActiveStep){this._updateActiveStep(n);}return this._updateCurrentStep(n,o);};a.prototype._updateActiveStep=function(n,o){var z=n-1,Z=(o||this._iActiveStep)-1;this._iActiveStep=n;this._updateStepNavigation(z);this._removeStepAriaDisabledAttribute(z);this._updateStepActiveAttribute(z,Z);};a.prototype._updateCurrentStep=function(n,o){var z=n-1,Z=(o||this.getCurrentStep())-1;this._iCurrentStep=n;this._updateStepZIndex();this._updateOpenSteps();this._updateStepCurrentAttribute(z,Z);this._updateStepAriaLabelAttribute(z,Z);return this;};a.prototype._updateOpenSteps=function(){var w=this.$().width(),c=this._iCurrentStep-1,b=0,d=true,s=this.getStepTitles().length?Math.floor(w/a.CONSTANTS.MIN_STEP_WIDTH_WITH_TITLE):Math.floor(w/a.CONSTANTS.MIN_STEP_WIDTH_NO_TITLE);if(!this._aCachedSteps){return;}[].forEach.call(this._aCachedSteps,function(e){e.setAttribute(W.ATTRIBUTES.OPEN_STEP,false);e.setAttribute(W.ATTRIBUTES.OPEN_STEP_PREV,false);e.setAttribute(W.ATTRIBUTES.OPEN_STEP_NEXT,false);});if(this._aCachedSteps[c]){this._aCachedSteps[c].setAttribute(W.ATTRIBUTES.OPEN_STEP,true);}for(var i=1;i<s;i++){if(d){b+=1;}if(d&&this._aCachedSteps[c+b]){this._aCachedSteps[c+b].setAttribute(W.ATTRIBUTES.OPEN_STEP,true);d=!d;}else if(!d&&this._aCachedSteps[c-b]){this._aCachedSteps[c-b].setAttribute(W.ATTRIBUTES.OPEN_STEP,true);d=!d;}else if(this._aCachedSteps[c+b+1]){b+=1;this._aCachedSteps[c+b].setAttribute(W.ATTRIBUTES.OPEN_STEP,true);d=true;}else if(this._aCachedSteps[c-b]){this._aCachedSteps[c-b].setAttribute(W.ATTRIBUTES.OPEN_STEP,true);b+=1;d=false;}}for(i=0;i<this._aCachedSteps.length;i++){if(this._aCachedSteps[i].getAttribute(W.ATTRIBUTES.OPEN_STEP)=="true"&&this._aCachedSteps[i-1]&&this._aCachedSteps[i-1].getAttribute(W.ATTRIBUTES.OPEN_STEP)=="false"){this._aCachedSteps[i-1].setAttribute(W.ATTRIBUTES.OPEN_STEP_PREV,true);}if(this._aCachedSteps[i].getAttribute(W.ATTRIBUTES.OPEN_STEP)=="false"&&this._aCachedSteps[i-1]&&this._aCachedSteps[i-1].getAttribute(W.ATTRIBUTES.OPEN_STEP)=="true"){this._aCachedSteps[i].setAttribute(W.ATTRIBUTES.OPEN_STEP_NEXT,true);break;}}};a.prototype._isGroupAtStart=function(d){var $=q(d).closest("."+W.CLASSES.STEP);var s=this._getStepNumber($);return $.attr(W.ATTRIBUTES.OPEN_STEP_PREV)==="true"&&s>1;};a.prototype._isGroupAtEnd=function(d){var $=q(d).closest("."+W.CLASSES.STEP);var s=this._getStepNumber($);return $.attr(W.ATTRIBUTES.OPEN_STEP_NEXT)==="true"&&s<this._aCachedSteps.length;};a.prototype._showActionSheet=function(d,b){var f=b?0:this._getStepNumber(d)-1;var t=b?this._getStepNumber(d):this._aCachedSteps.length;var s,T;this._oActionSheet.removeAllButtons();for(var i=f;i<t;i++){s=this.getStepIcons()[i];T=this._aCachedSteps[i].getAttribute("aria-roledescription");this._oActionSheet.addButton(new B({width:"200px",text:T,icon:s,enabled:this._iActiveStep>=(i+1),press:function(c){this._moveToStep(c);this.fireStepChanged({current:c});}.bind(this,i+1)}));}this._oActionSheet.openBy(d);};a.prototype._isOpenStep=function(d){var $=q(d).closest("."+W.CLASSES.STEP);return $.attr(W.ATTRIBUTES.OPEN_STEP)==="true"||($.attr(W.ATTRIBUTES.OPEN_STEP)==="false"&&$.attr(W.ATTRIBUTES.OPEN_STEP_PREV)==="true")||($.attr(W.ATTRIBUTES.OPEN_STEP)==="false"&&$.attr(W.ATTRIBUTES.OPEN_STEP_NEXT)==="true");};a.prototype._isActiveStep=function(s){return s<=this._iActiveStep;};a.prototype._getStepNumber=function(d){var $=q(d).closest("."+W.CLASSES.STEP).attr(W.ATTRIBUTES.STEP);return parseInt($);};return a;});
