/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log",'sap/ui/core/format/NumberFormat','sap/ui/model/CompositeType','sap/ui/model/FormatException','sap/ui/model/ParseException','sap/ui/model/ValidateException',"sap/ui/thirdparty/jquery","sap/base/util/isEmptyObject"],function(L,N,C,F,P,V,q,i){"use strict";var a=C.extend("sap.ui.model.type.Currency",{constructor:function(){C.apply(this,arguments);this.sName="Currency";this.bUseRawValues=true;}});a.prototype.formatValue=function(v,t){var b=v;if(v==undefined||v==null){return null;}if(this.oInputFormat){b=this.oInputFormat.parse(v);}if(!Array.isArray(b)){throw new F("Cannot format currency: "+v+" has the wrong format");}if(b[0]==undefined||b[0]==null){return null;}switch(this.getPrimitiveType(t)){case"string":return this.oOutputFormat.format(b);default:throw new F("Don't know how to format currency to "+t);}};a.prototype.parseValue=function(v,s){var r,b;switch(this.getPrimitiveType(s)){case"string":r=this.oOutputFormat.parse(v);if(!Array.isArray(r)||isNaN(r[0])){b=sap.ui.getCore().getLibraryResourceBundle();throw new P(b.getText("Currency.Invalid",[v]));}break;default:throw new P("Don't know how to parse Currency from "+s);}if(this.oInputFormat){r=this.oInputFormat.format(r);}return r;};a.prototype.validateValue=function(v){if(this.oConstraints){var b=sap.ui.getCore().getLibraryResourceBundle(),c=[],m=[],d=v,e;if(this.oInputFormat){d=this.oInputFormat.parse(v);}e=d[0];q.each(this.oConstraints,function(n,o){switch(n){case"minimum":if(e<o){c.push("minimum");m.push(b.getText("Currency.Minimum",[o]));}break;case"maximum":if(e>o){c.push("maximum");m.push(b.getText("Currency.Maximum",[o]));}break;default:L.warning("Unknown constraint '"+n+"': Value is not validated.",null,"sap.ui.model.type.Currency");}});if(c.length>0){throw new V(this.combineMessages(m),c);}}};a.prototype.setFormatOptions=function(f){this.oFormatOptions=f;this._createFormats();};a.prototype._handleLocalizationChange=function(){this._createFormats();};a.prototype._createFormats=function(){var s=this.oFormatOptions.source;this.oOutputFormat=N.getCurrencyInstance(this.oFormatOptions);if(s){if(i(s)){s={groupingEnabled:false,groupingSeparator:",",decimalSeparator:"."};}this.oInputFormat=N.getCurrencyInstance(s);}};a.prototype.getPartsIgnoringMessages=function(){if(this.oFormatOptions.showMeasure===false){return[1];}return[];};return a;});
