S2 = Manifold(2, 'S^2')
U = S2.open_subset('U')
XS = U.chart(r'th:(0,pi):\theta ph:(0,2*pi):\phi')
th, ph = XS[:]
R3 = Manifold(3, 'R^3')
X3 = R3.chart('x y z')
F = S2.diff_map(R3, {(XS, X3): [sin(th)*cos(ph), sin(th)*sin(ph),
                                cos(th)]}, name='F')
t = manifolds.RealLine().canonical_coordinate()
c = S2.curve([2*atan(exp(-t/10)), t], (t, -oo, +oo), name='c')
graph_c = c.plot(mapping=F, max_range=40, plot_points=200,
                 thickness=2, label_axes=False)
graph_S2 = XS.plot(X3, mapping=F, number_values=11, color='black')
sphinx_plot(graph_c + graph_S2)