M = Manifold(2, 'M', structure="Riemannian")
C= M.chart(names = ("x", "y"), coord_restrictions=lambda x,y: x**2+y**2 < 3**2)
x, y = C[:]
P = M.chart(names = ("r", "th"), coord_restrictions=lambda r,th: r > 2)
r, th = P[:]
P_to_C = P.transition_map(C,(r*cos(th), r*sin(th)))
C_to_P = C.transition_map(P,(sqrt(x**2+y**2), atan2(y,x)))
g = M.metric()
g[0,0,C] = 1
g[1,1,C] = 1
g[P.frame(), : , P]
phi = M.diff_map(M, {(C,C): [x, y], (P,C): [r*cos(th), r*sin(th)]})
fig = P.plot(number_values=9, chart=C, mapping=phi, color='grey',
             ranges= {r:(2, 6), th:(0,2*pi)})
fig += C.plot(number_values=13, chart=C, mapping=phi, color='grey',
              ranges= {x:(-3, 3), y:(-3, 3)})
t = var('t')
p = M((5,pi+0.3), P)
Tp = M.tangent_space(p)
v = Tp((-1,-0.03), P.frame().at(p))
c = M.integrated_geodesic(g, (t, 0, 10), v, across_charts=True)
sol = c.solve_across_charts(step=0.1, verbose=True)
interp = c.interpolate()
fig += c.plot_integrated(mapping=phi, color=["green","red"],
            thickness=3, plot_points=100, across_charts=True)
sphinx_plot(fig)