def label(element):
    if isinstance(element, str):
        return element
    try:
        return element._name
    except AttributeError:
        return '[' + ', '.join(sorted(x._name for x in element)) + ']'
M = Manifold(2, 'M', structure='topological')
A = M.subset('A', is_open=True)
AA = A.subset('AA')
A.declare_empty()
AD = A.subset('AD')
B = M.subset('B')
b = B.point(name='b')

D = M.subset_digraph(open_covers=True, points=[b])
g1 = D.relabel(label, inplace=False).plot(layout='spring')
P = M.subset_poset(open_covers=True, points=[b])
g2 = P.plot(element_labels={element: label(element) for element in P})
sphinx_plot(graphics_array([g1, g2]), figsize=(8, 5))