def label(element):
    return element._name
M = Manifold(2, 'M')
U = M.open_subset('U')
V = M.open_subset('V')
Vs = [M.open_subset(f'V{i}') for i in range(2)]
UV = U.intersection(V)
W = UV.open_subset('W')
P = M.subset_poset()
g1 = P.plot(element_labels={element: label(element) for element in P})
V.declare_equal(Vs)
P = M.subset_poset()
g2 = P.plot(element_labels={element: label(element) for element in P})
W.declare_equal(U)
P = M.subset_poset()
g3 = P.plot(element_labels={element: label(element) for element in P})
sphinx_plot(graphics_array([g1, g2, g3]), figsize=(8, 3))