def label(element):
    return element._name
M = Manifold(2, 'M')
U1 = M.open_subset('U1')
U2 = M.open_subset('U2')
V = M.open_subset('V')
P = M.subset_poset()
g1 = P.plot(element_labels={element: label(element) for element in P})
V.declare_subset(U1, U2)
P = M.subset_poset()
g2 = P.plot(element_labels={element: label(element) for element in P})
M.declare_subset(V)
P = M.subset_poset()
g3 = P.plot(element_labels={element: label(element) for element in P})
sphinx_plot(graphics_array([g1, g2, g3]), figsize=(8, 3))