def label(element):
    try:
        return element._name
    except AttributeError:
        return '[' + ', '.join(sorted(x._name for x in element)) + ']'
M = Manifold(2, 'M', structure='topological')
AB = M.subset('AB')
A = AB.subset('A')
B = AB.subset('B')
P = M.subset_poset(open_covers=True); P
g1 = P.plot(element_labels={element: label(element) for element in P})
AB.declare_union(A, B)
A.union(B)
P = M.subset_poset(open_covers=True); P
g2 = P.plot(element_labels={element: label(element) for element in P})
B1 = B.subset('B1', is_open=True)
B2 = B.subset('B2', is_open=True)
B.declare_union(B1, B2, disjoint=True)
P = M.subset_poset(open_covers=True); P
g3 = P.plot(element_labels={element: label(element) for element in P})
sphinx_plot(graphics_array([g1, g2, g3]), figsize=(8, 3))