def label(element):
    if isinstance(element, str):
        return element
    try:
        return element._name.replace('_inter_', '∩')
    except AttributeError:
        return '[' + ', '.join(sorted(label(x) for x in element)) + ']'

M = Manifold(2, 'M', structure='topological')
a = M.subset('A')
b = M.subset('B')
c = a.intersection(b); c
P = M.subset_poset(open_covers=True)
g1 = P.plot(element_labels={element: label(element) for element in P})

T = Manifold(2, 'T', structure='topological')
from sage.typeset.unicode_art import unicode_subscript
S = [T.subset(f'S{unicode_subscript(i)}') for i in range(6)]
[S[i].intersection(S[i+3]) for i in range(3)]
T.intersection(*S, name='⋂ᵢSᵢ')
P = T.subset_poset(open_covers=True)
g2 = P.plot(element_labels={element: label(element) for element in P})

sphinx_plot(graphics_array([g1, g2]), figsize=(8, 3))