def label(element):
    try:
        return element._name
    except AttributeError:
        return '[' + ', '.join(sorted(x._name for x in element)) + ']'
M = Manifold(3, 'M')
U = M.open_subset('U'); V = M.open_subset('V'); W = M.open_subset('W')
D = M.subset_digraph()
g1 = D.relabel(label, inplace=False).plot(layout='acyclic')
VW = V.union(W)
D = M.subset_digraph()
g2 = D.relabel(label, inplace=False).plot(layout='acyclic')
D = M.subset_digraph(open_covers=True)
g3 = D.relabel(label, inplace=False).plot(layout='acyclic')
sphinx_plot(graphics_array([g1, g2, g3]), figsize=(8, 3))