def label(element):
    try:
        return element._name
    except AttributeError:
        return '[' + ', '.join(sorted(x._name for x in element)) + ']'
M = Manifold(3, 'M')
U = M.open_subset('U'); V = M.open_subset('V'); W = M.open_subset('W')
P = M.subset_poset()
g1 = P.plot(element_labels={element: label(element) for element in P})
VW = V.union(W)
P = M.subset_poset()
g2 = P.plot(element_labels={element: label(element) for element in P})
P = M.subset_poset(open_covers=True)
g3 = P.plot(element_labels={element: label(element) for element in P})
sphinx_plot(graphics_array([g1, g2, g3]), figsize=(8, 3))