def label(element):
    if isinstance(element, str):
        return element
    try:
        return element._name.replace('_union_', '∪')
    except AttributeError:
        return '[' + ', '.join(sorted(label(x) for x in element)) + ']'

M = Manifold(2, 'M', structure='topological')
a = M.subset('A')
b = M.subset('B')
c = a.union(b); c
P = M.subset_poset(open_covers=True)
g1 = P.plot(element_labels={element: label(element) for element in P})

T = Manifold(2, 'T', structure='topological')
from sage.typeset.unicode_art import unicode_subscript
S = [T.subset(f'S{unicode_subscript(i)}') for i in range(6)]
[S[i].union(S[i+3]) for i in range(3)]
union_S_i = S[0].union(S[1:], name='⋃ᵢSᵢ'); union_S_i
P = T.subset_poset(open_covers=True)
g2 = P.plot(element_labels={element: label(element) for element in P})

sphinx_plot(graphics_array([g1, g2]), figsize=(8, 3))