/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.Predef$;
import scala.collection.Factory;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.IterableOnce$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedSeqFactory;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.GrowableBuilder;
import scala.math.Integral;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.util.ChainingOps$;
import scala.util.package$chaining$;

public final class ArrayBuffer$
implements StrictOptimizedSeqFactory<ArrayBuffer> {
    public static final ArrayBuffer$ MODULE$ = new ArrayBuffer$();
    private static final long serialVersionUID = 3L;

    static {
        IterableFactory.$init$(MODULE$);
        SeqFactory.$init$(MODULE$);
        StrictOptimizedSeqFactory.$init$(MODULE$);
    }

    @Override
    public SeqOps fill(int n, Function0 elem) {
        return StrictOptimizedSeqFactory.fill$(this, n, elem);
    }

    @Override
    public SeqOps tabulate(int n, Function1 f) {
        return StrictOptimizedSeqFactory.tabulate$(this, n, f);
    }

    @Override
    public SeqOps concat(Seq xss) {
        return StrictOptimizedSeqFactory.concat$(this, xss);
    }

    @Override
    public final SeqOps unapplySeq(SeqOps x) {
        return SeqFactory.unapplySeq$(this, x);
    }

    @Override
    public Object apply(Seq elems) {
        return IterableFactory.apply$(this, elems);
    }

    @Override
    public Object iterate(Object start, int len, Function1 f) {
        return IterableFactory.iterate$(this, start, len, f);
    }

    @Override
    public Object unfold(Object init, Function1 f) {
        return IterableFactory.unfold$(this, init, f);
    }

    @Override
    public Object range(Object start, Object end, Integral evidence$3) {
        return IterableFactory.range$(this, start, end, evidence$3);
    }

    @Override
    public Object range(Object start, Object end, Object step, Integral evidence$4) {
        return IterableFactory.range$(this, start, end, step, evidence$4);
    }

    @Override
    public Object fill(int n1, int n2, Function0 elem) {
        return IterableFactory.fill$(this, n1, n2, elem);
    }

    @Override
    public Object fill(int n1, int n2, int n3, Function0 elem) {
        return IterableFactory.fill$(this, n1, n2, n3, elem);
    }

    @Override
    public Object fill(int n1, int n2, int n3, int n4, Function0 elem) {
        return IterableFactory.fill$(this, n1, n2, n3, n4, elem);
    }

    @Override
    public Object fill(int n1, int n2, int n3, int n4, int n5, Function0 elem) {
        return IterableFactory.fill$(this, n1, n2, n3, n4, n5, elem);
    }

    @Override
    public Object tabulate(int n1, int n2, Function2 f) {
        return IterableFactory.tabulate$(this, n1, n2, f);
    }

    @Override
    public Object tabulate(int n1, int n2, int n3, Function3 f) {
        return IterableFactory.tabulate$(this, n1, n2, n3, f);
    }

    @Override
    public Object tabulate(int n1, int n2, int n3, int n4, Function4 f) {
        return IterableFactory.tabulate$(this, n1, n2, n3, n4, f);
    }

    @Override
    public Object tabulate(int n1, int n2, int n3, int n4, int n5, Function5 f) {
        return IterableFactory.tabulate$(this, n1, n2, n3, n4, n5, f);
    }

    @Override
    public <A> Factory<A, ArrayBuffer<A>> iterableFactory() {
        return IterableFactory.iterableFactory$(this);
    }

    public final int DefaultInitialSize() {
        return 16;
    }

    @Override
    public <B> ArrayBuffer<B> from(IterableOnce<B> coll) {
        ArrayBuffer arrayBuffer;
        int k = coll.knownSize();
        if (k >= 0) {
            Object[] array = new Object[RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(k), 16)];
            IterableOnce$.MODULE$.copyElemsToArray(coll, array, IterableOnce$.MODULE$.copyElemsToArray$default$3(), IterableOnce$.MODULE$.copyElemsToArray$default$4());
            arrayBuffer = new ArrayBuffer(array, k);
        } else {
            arrayBuffer = (ArrayBuffer)new ArrayBuffer<B>().$plus$plus$eq(coll);
        }
        return arrayBuffer;
    }

    @Override
    public <A> Builder<A, ArrayBuffer<A>> newBuilder() {
        return new GrowableBuilder<A, ArrayBuffer<A>>(){

            public void sizeHint(int size) {
                ((ArrayBuffer)this.elems()).ensureSize(size);
            }
        };
    }

    @Override
    public <A> ArrayBuffer<A> empty() {
        return new ArrayBuffer();
    }

    public Object[] scala$collection$mutable$ArrayBuffer$$ensureSize(Object[] array, int end, int n) {
        return n <= array.length ? array : ChainingOps$.MODULE$.tap$extension(package$chaining$.MODULE$.scalaUtilChainingOps(new Object[ArrayBuffer$.resizeEnsuring$1(array.length, end, n)]), (Function1<Object[], Object> & Serializable)x$1 -> {
            Array$.MODULE$.copy(array, 0, x$1, 0, end);
            return BoxedUnit.UNIT;
        });
    }

    public Object[] scala$collection$mutable$ArrayBuffer$$downsize(Object[] array, int requiredLength) {
        return requiredLength >= array.length ? array : ChainingOps$.MODULE$.tap$extension(package$chaining$.MODULE$.scalaUtilChainingOps(new Object[ArrayBuffer$.resizeDown$1(array.length, requiredLength)]), (Function1<Object[], Object> & Serializable)x$2 -> {
            Array$.MODULE$.copy(array, 0, x$2, 0, requiredLength);
            return BoxedUnit.UNIT;
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ArrayBuffer$.class);
    }

    private static final int resizeEnsuring$1(int length, int end, int n) {
        int n2;
        long newSize = length;
        for (newSize = package$.MODULE$.max(newSize * 2L, 16L); newSize < (long)n; newSize *= 2L) {
        }
        if (newSize <= Integer.MAX_VALUE) {
            n2 = (int)newSize;
        } else {
            if (end == Integer.MAX_VALUE) {
                throw new Exception(new StringBuilder(44).append("Collections can not have more than ").append(Integer.MAX_VALUE).append(" elements").toString());
            }
            n2 = Integer.MAX_VALUE;
        }
        return n2;
    }

    private static final int resizeDown$1(int length, int requiredLength) {
        long newSize = length;
        if (newSize == Integer.MAX_VALUE) {
            ++newSize;
        }
        int minLength = package$.MODULE$.max(requiredLength, 16);
        while (newSize / 2L >= (long)minLength) {
            newSize /= 2L;
        }
        return newSize <= Integer.MAX_VALUE ? (int)newSize : Integer.MAX_VALUE;
    }

    private ArrayBuffer$() {
    }
}

