/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.duration;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.AbstractIterable;
import scala.collection.StringOps$;
import scala.collection.StringParsers$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichChar$;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;

public final class Duration$
implements Serializable {
    public static final Duration$ MODULE$ = new Duration$();
    private static final List<Tuple2<TimeUnit, String>> timeUnitLabels = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(TimeUnit.DAYS), "d day"), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(TimeUnit.HOURS), "h hr hour"), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(TimeUnit.MINUTES), "m min minute"), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(TimeUnit.SECONDS), "s sec second"), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(TimeUnit.MILLISECONDS), "ms milli millisecond"), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(TimeUnit.MICROSECONDS), "\u00b5s micro microsecond"), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(TimeUnit.NANOSECONDS), "ns nano nanosecond")}));
    private static final Map<TimeUnit, String> timeUnitName = timeUnitLabels.toMap($less$colon$less$.MODULE$.refl()).view().mapValues((Function1<String, String> & Serializable)s -> MODULE$.words((String)s).last()).toMap($less$colon$less$.MODULE$.refl());
    private static final Map<String, TimeUnit> timeUnit = ((AbstractIterable)timeUnitLabels.flatMap((Function1<Tuple2, List> & Serializable)x0$1 -> {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        TimeUnit unit = (TimeUnit)((Object)((Object)tuple2._1()));
        String names = (String)tuple2._2();
        Object object = MODULE$.expandLabels(names).map((Function1<String, Tuple2> & Serializable)x$5 -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$5), unit));
        return object;
    })).toMap($less$colon$less$.MODULE$.refl());
    private static final FiniteDuration Zero = new FiniteDuration(0L, TimeUnit.DAYS);
    private static final Duration.Infinite Undefined = new Duration.Infinite(){

        public String toString() {
            return "Duration.Undefined";
        }

        public boolean equals(Object other) {
            return false;
        }

        public Duration $plus(Duration other) {
            return this;
        }

        public Duration $minus(Duration other) {
            return this;
        }

        public Duration $times(double factor) {
            return this;
        }

        public Duration $div(double factor) {
            return this;
        }

        public double $div(Duration other) {
            return Double.NaN;
        }

        public int compare(Duration other) {
            return other == this ? 0 : 1;
        }

        public Duration unary_$minus() {
            return this;
        }

        public double toUnit(TimeUnit unit) {
            return Double.NaN;
        }

        private Object readResolve() {
            return Duration$.MODULE$.Undefined();
        }
    };
    private static final Duration.Infinite Inf = new Duration.Infinite(){

        public String toString() {
            return "Duration.Inf";
        }

        public int compare(Duration other) {
            Duration duration = other;
            int n = duration == Duration$.MODULE$.Undefined() ? -1 : (duration == this ? 0 : 1);
            return n;
        }

        public Duration unary_$minus() {
            return Duration$.MODULE$.MinusInf();
        }

        public double toUnit(TimeUnit unit) {
            return Double.POSITIVE_INFINITY;
        }

        private Object readResolve() {
            return Duration$.MODULE$.Inf();
        }
    };
    private static final Duration.Infinite MinusInf = new Duration.Infinite(){

        public String toString() {
            return "Duration.MinusInf";
        }

        public int compare(Duration other) {
            return other == this ? 0 : -1;
        }

        public Duration unary_$minus() {
            return Duration$.MODULE$.Inf();
        }

        public double toUnit(TimeUnit unit) {
            return Double.NEGATIVE_INFINITY;
        }

        private Object readResolve() {
            return Duration$.MODULE$.MinusInf();
        }
    };

    public Duration apply(double length, TimeUnit unit) {
        return this.fromNanos((double)unit.toNanos(1L) * length);
    }

    public FiniteDuration apply(long length, TimeUnit unit) {
        return new FiniteDuration(length, unit);
    }

    public FiniteDuration apply(long length, String unit) {
        return new FiniteDuration(length, (TimeUnit)((Object)this.timeUnit().apply(unit)));
    }

    public Duration apply(String s) {
        Duration duration;
        block18: {
            String s1;
            block15: {
                block17: {
                    block16: {
                        s1 = StringOps$.MODULE$.filterNot$extension(Predef$.MODULE$.augmentString(s), (Function1<Object, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar(x$1)))));
                        String string = s1;
                        switch (string == null ? 0 : string.hashCode()) {
                            case -1772306297: {
                                if ("Duration.Inf".equals(string)) {
                                    break;
                                }
                                break block15;
                            }
                            case -1283193487: {
                                if (!"MinusInf".equals(string)) break block15;
                                break block16;
                            }
                            case 73665: {
                                if ("Inf".equals(string)) {
                                    break;
                                }
                                break block15;
                            }
                            case 1354678: {
                                if ("+Inf".equals(string)) {
                                    break;
                                }
                                break block15;
                            }
                            case 1414260: {
                                if (!"-Inf".equals(string)) break block15;
                                break block16;
                            }
                            case 784790902: {
                                if (!"Duration.Undefined".equals(string)) break block15;
                                break block17;
                            }
                            case 927723627: {
                                if (!"Duration.MinusInf".equals(string)) break block15;
                                break block16;
                            }
                            case 1189350343: {
                                if ("PlusInf".equals(string)) {
                                    break;
                                }
                                break block15;
                            }
                            default: {
                                break block15;
                            }
                        }
                        duration = this.Inf();
                        break block18;
                    }
                    duration = this.MinusInf();
                    break block18;
                }
                duration = this.Undefined();
                break block18;
            }
            String unitName = StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(s1))), (Function1<Object, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(RichChar$.MODULE$.isLetter$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar(x$2)))))));
            Option option = this.timeUnit().get(unitName);
            if (!(option instanceof Some)) {
                throw new NumberFormatException(new StringBuilder(13).append("format error ").append(s).toString());
            }
            Some some = (Some)option;
            TimeUnit unit = (TimeUnit)((Object)some.value());
            String valueStr = StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(s1), unitName.length());
            Duration duration2 = (Duration)StringParsers$.MODULE$.parseLong(valueStr).map((Function1<Object, FiniteDuration> & Serializable)x$3 -> Duration$.MODULE$.apply(BoxesRunTime.unboxToLong(x$3), unit)).getOrElse((Function0<Duration> & Serializable)() -> MODULE$.apply(Double.parseDouble(valueStr), unit));
            duration = duration2;
        }
        return duration;
    }

    private List<String> words(String s) {
        return Predef$.MODULE$.wrapRefArray((Object[])s.trim().split("\\s+")).toList();
    }

    private List<String> expandLabels(String labels) {
        List<String> list = this.words(labels);
        if (!(list instanceof $colon$colon)) {
            throw new MatchError(list);
        }
        $colon$colon $colon$colon = ($colon$colon)list;
        String hd = (String)$colon$colon.head();
        List rest = $colon$colon.next$access$1();
        Tuple2 tuple2 = new Tuple2(hd, rest);
        Tuple2 tuple22 = tuple2;
        String hd2 = tuple22._1();
        List rest2 = tuple22._2();
        String string = hd2;
        return ((List)rest2.flatMap((Function1<String, List> & Serializable)s -> (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{s, new StringBuilder(1).append((String)s).append("s").toString()})))).$colon$colon(string);
    }

    public Map<TimeUnit, String> timeUnitName() {
        return timeUnitName;
    }

    public Map<String, TimeUnit> timeUnit() {
        return timeUnit;
    }

    public Option<Tuple2<Object, TimeUnit>> unapply(String s) {
        Option option;
        try {
            option = new Some<Duration>(this.apply(s));
        }
        catch (RuntimeException runtimeException) {
            option = None$.MODULE$;
        }
        return option.flatMap((Function1<Duration, Option> & Serializable)d -> MODULE$.unapply((Duration)d));
    }

    public Option<Tuple2<Object, TimeUnit>> unapply(Duration d) {
        return d.isFinite() ? new Some<Tuple2<Long, TimeUnit>>(new Tuple2<Long, TimeUnit>(BoxesRunTime.boxToLong(d.length()), d.unit())) : None$.MODULE$;
    }

    public Duration fromNanos(double nanos) {
        Duration duration;
        if (Double.isInfinite(nanos)) {
            duration = nanos > 0.0 ? this.Inf() : this.MinusInf();
        } else if (Double.isNaN(nanos)) {
            duration = this.Undefined();
        } else {
            if (nanos > (double)Long.MAX_VALUE || nanos < (double)Long.MIN_VALUE) {
                throw new IllegalArgumentException(new StringBuilder(46).append("trying to construct too large duration with ").append(nanos).append("ns").toString());
            }
            duration = this.fromNanos(RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(nanos)));
        }
        return duration;
    }

    public FiniteDuration fromNanos(long nanos) {
        return nanos % 86400000000000L == 0L ? this.apply(nanos / 86400000000000L, TimeUnit.DAYS) : (nanos % 3600000000000L == 0L ? this.apply(nanos / 3600000000000L, TimeUnit.HOURS) : (nanos % 60000000000L == 0L ? this.apply(nanos / 60000000000L, TimeUnit.MINUTES) : (nanos % 1000000000L == 0L ? this.apply(nanos / 1000000000L, TimeUnit.SECONDS) : (nanos % 1000000L == 0L ? this.apply(nanos / 1000000L, TimeUnit.MILLISECONDS) : (nanos % 1000L == 0L ? this.apply(nanos / 1000L, TimeUnit.MICROSECONDS) : this.apply(nanos, TimeUnit.NANOSECONDS))))));
    }

    public FiniteDuration Zero() {
        return Zero;
    }

    public Duration.Infinite Undefined() {
        return Undefined;
    }

    public Duration.Infinite Inf() {
        return Inf;
    }

    public Duration.Infinite MinusInf() {
        return MinusInf;
    }

    public FiniteDuration create(long length, TimeUnit unit) {
        return this.apply(length, unit);
    }

    public Duration create(double length, TimeUnit unit) {
        return this.apply(length, unit);
    }

    public FiniteDuration create(long length, String unit) {
        return this.apply(length, unit);
    }

    public Duration create(String s) {
        return this.apply(s);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Duration$.class);
    }

    private Duration$() {
    }
}

