/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.interpreter.jline;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jline.builtins.InputRC;
import org.jline.reader.Completer;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Parser;
import org.jline.reader.impl.history.DefaultHistory;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.AbstractIterable;
import scala.collection.StringOps$;
import scala.collection.immutable.LazyList;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.internal.util.OwnerOnlyChmod$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.tools.nsc.interpreter.Repl;
import scala.tools.nsc.interpreter.jline.Completion;
import scala.tools.nsc.interpreter.jline.Reader;
import scala.tools.nsc.interpreter.shell.Accumulator;
import scala.tools.nsc.interpreter.shell.ShellConfig;
import scala.util.Using;
import scala.util.Using$;
import scala.util.control.NonFatal$;

public final class Reader$ {
    public static final Reader$ MODULE$ = new Reader$();

    public Reader apply(ShellConfig config, Repl repl, scala.tools.nsc.interpreter.shell.Completion completion, Accumulator accumulator) {
        LazyRef inputrcFileContents$lzy = new LazyRef();
        Predef$.MODULE$.require(repl != null);
        if (config.isReplDebug()) {
            this.initLogging(config.isReplTrace());
        }
        System.setProperty("org.jline.reader.support.parsedline", Boolean.TRUE.toString());
        Terminal jlineTerminal = TerminalBuilder.builder().jna(true).build();
        Completion completer = new Completion(completion);
        Reader.ReplParser parser = new Reader.ReplParser(repl);
        DefaultHistory history = new DefaultHistory();
        LineReaderBuilder builder = LineReaderBuilder.builder().appName("scala").completer((Completer)completer).history((History)history).parser((Parser)parser).terminal(jlineTerminal);
        Predef$.MODULE$.locally(builder.option(LineReader.Option.AUTO_GROUP, false).option(LineReader.Option.LIST_PACKED, true).option(LineReader.Option.INSERT_TAB, true).variable("history-file", (Object)config.historyFile()).variable("secondary-prompt-pattern", (Object)config.encolor(config.continueText())).variable("WORDCHARS", (Object)StringOps$.MODULE$.filterNot$extension(Predef$.MODULE$.augmentString("*?_-.[]~=/&;!#$%^(){}<>"), Predef$.MODULE$.wrapString("*?.[]~=/&;!#%^(){}<>").toSet())).option(LineReader.Option.DISABLE_EVENT_EXPANSION, true));
        LineReader reader = builder.build();
        try {
            Reader$.inputrcFileContents$1(inputrcFileContents$lzy).foreach((Function1<byte[], Object> & Serializable)f -> {
                Reader$.$anonfun$apply$9(reader, f);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        String keymap = config.viMode() ? "viins" : "emacs";
        Predef$.MODULE$.locally(reader.getKeyMaps().put("main", reader.getKeyMaps().get(keymap)));
        Reader$.secure$1(Paths.get(config.historyFile(), new String[0]), config);
        try {
            history.attach(reader);
        }
        catch (Throwable throwable) {
            IllegalArgumentException illegalArgumentException;
            Throwable throwable3 = throwable;
            if (throwable3 instanceof IllegalArgumentException && (illegalArgumentException = (IllegalArgumentException)throwable3).getMessage().contains("Bad history file syntax")) {
                Reader$.backupHistory$1(config);
                history.attach(reader);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            if (throwable3 instanceof NumberFormatException) {
                Reader$.backupHistory$1(config);
                history.attach(reader);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        return new Reader(config, reader, accumulator, completer, jlineTerminal);
    }

    private void initLogging(boolean trace) {
        Logger logger = Logger.getLogger("org.jline");
        ConsoleHandler handler = new ConsoleHandler();
        Level level = trace ? Level.FINEST : Level.FINE;
        logger.setLevel(level);
        handler.setLevel(level);
        logger.addHandler(handler);
    }

    private static final Option inputrcFileUrl$1() {
        return scala.sys.package$.MODULE$.props().get("jline.inputrc").flatMap((Function1<String, Some> & Serializable)path -> {
            Some<URL> some;
            try {
                some = new Some<URL>(new URL((String)path));
            }
            catch (MalformedURLException malformedURLException) {
                some = new Some<URL>(new File((String)path).toURI().toURL());
            }
            return some;
        }).orElse((Function0<Option> & Serializable)() -> scala.sys.package$.MODULE$.props().get("user.home").map((Function1<String, URL> & Serializable)home -> {
            File f = new File((String)home).toPath().resolve(".inputrc").toFile();
            return (f.isFile() ? f : new File("/etc/inputrc")).toURI().toURL();
        }));
    }

    public static final /* synthetic */ byte $anonfun$apply$7(int x$2) {
        return (byte)x$2;
    }

    private static final byte[] urlByteArray$1(URL url) {
        return (byte[])Using$.MODULE$.resource(Source$.MODULE$.fromURL(url, Codec$.MODULE$.fallbackSystemCodec()).bufferedReader(), (Function1<BufferedReader, byte[]> & Serializable)bufferedReader -> (byte[])((AbstractIterable)((LazyList)package$.MODULE$.LazyList().continually(() -> bufferedReader.read()).takeWhile(x$1 -> x$1 != -1)).map((Function1<Object, Object> & Serializable)x$2 -> BoxesRunTime.boxToByte(Reader$.$anonfun$apply$7(BoxesRunTime.unboxToInt(x$2))))).toArray(ClassTag$.MODULE$.Byte()), Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private static final /* synthetic */ Option inputrcFileContents$lzycompute$1(LazyRef inputrcFileContents$lzy$1) {
        Option option;
        LazyRef lazyRef = inputrcFileContents$lzy$1;
        synchronized (lazyRef) {
            option = inputrcFileContents$lzy$1.initialized() ? (Option)inputrcFileContents$lzy$1.value() : inputrcFileContents$lzy$1.initialize(Reader$.inputrcFileUrl$1().map((Function1<URL, byte[]> & Serializable)in -> Reader$.urlByteArray$1(in)));
        }
        return option;
    }

    private static final Option inputrcFileContents$1(LazyRef inputrcFileContents$lzy$1) {
        return inputrcFileContents$lzy$1.initialized() ? (Option)inputrcFileContents$lzy$1.value() : Reader$.inputrcFileContents$lzycompute$1(inputrcFileContents$lzy$1);
    }

    public static final /* synthetic */ void $anonfun$apply$9(LineReader reader$1, byte[] f) {
        InputRC.configure((LineReader)reader$1, (InputStream)new ByteArrayInputStream(f));
    }

    private static final void secure$1(Path p, ShellConfig config$1) {
        try {
            OwnerOnlyChmod$.MODULE$.chmodFileOrCreateEmpty(p);
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = option.get();
                if (config$1.isReplDebug()) {
                    e.printStackTrace();
                }
                config$1.replinfo((Function0<String> & Serializable)() -> new StringBuilder(75).append("Warning: history file ").append(p).append("'s permissions could not be restricted to owner-only.").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private static final void backupHistory$1(ShellConfig config$1) {
        Path hf = Paths.get(config$1.historyFile(), new String[0]);
        Path bk = Paths.get(new StringBuilder(3).append(config$1.historyFile()).append(".bk").toString(), new String[0]);
        Files.move(hf, bk, StandardCopyOption.REPLACE_EXISTING);
        Reader$.secure$1(bk, config$1);
    }

    private Reader$() {
    }
}

