/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.serialize;

import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import schemacrawler.schema.Catalog;
import schemacrawler.tools.command.serialize.options.SerializationFormat;
import schemacrawler.tools.command.serialize.options.SerializationOptions;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;
import schemacrawler.tools.formatter.serialize.CatalogSerializer;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.OutputOptionsBuilder;

public final class SerializationCommand
extends BaseSchemaCrawlerCommand<SerializationOptions> {
    static final String COMMAND = "serialize";

    public SerializationCommand() {
        super(COMMAND);
    }

    public void checkAvailability() throws Exception {
    }

    public void execute() throws Exception {
        this.checkCatalog();
        SerializationFormat serializationFormat = SerializationFormat.fromFormat(this.outputOptions.getOutputFormatValue());
        String serializerClassName = serializationFormat.getSerializerClassName();
        Class<?> serializableCatalogClass = Class.forName(serializerClassName);
        CatalogSerializer serializableCatalog = (CatalogSerializer)serializableCatalogClass.getDeclaredConstructor(Catalog.class).newInstance(this.catalog);
        if (serializationFormat.isBinaryFormat()) {
            Path outputFile = this.outputOptions.getOutputFile(serializationFormat.getFileExtension());
            this.outputOptions = OutputOptionsBuilder.builder((OutputOptions)this.outputOptions).withOutputFile(outputFile).toOptions();
            try (OutputStream out = Files.newOutputStream(outputFile, new OpenOption[0]);){
                serializableCatalog.save(out);
            }
        } else {
            Writer out = this.outputOptions.openNewOutputWriter();
            serializableCatalog.save(out);
        }
    }

    public boolean usesConnection() {
        return false;
    }
}

