/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.template;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.command.template.BaseTemplateRenderer;
import schemacrawler.tools.options.OutputOptions;
import us.fatehi.utility.ioresource.InputResource;
import us.fatehi.utility.ioresource.InputResourceUtility;

public final class MustacheRenderer
extends BaseTemplateRenderer {
    @Override
    public void execute() throws Exception {
        OutputOptions outputOptions = this.getOutputOptions();
        String templateLocation = this.getResourceFilename();
        InputResource inputResource = (InputResource)InputResourceUtility.createInputResource((String)templateLocation).orElseThrow(() -> new SchemaCrawlerException("No template found, " + templateLocation));
        DefaultMustacheFactory mustacheFactory = new DefaultMustacheFactory();
        Mustache mustache = mustacheFactory.compile(inputResource.openNewInputReader(StandardCharsets.UTF_8), templateLocation);
        try (Writer writer = outputOptions.openNewOutputWriter();){
            Map<String, Object> context = this.getContext();
            mustache.execute(writer, context).flush();
        }
    }
}

