/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.text.operation.options;

import schemacrawler.schemacrawler.Query;
import schemacrawler.tools.command.text.operation.options.Operation;
import schemacrawler.tools.command.text.operation.options.OperationOptions;
import schemacrawler.tools.command.text.operation.options.OperationType;
import schemacrawler.tools.command.text.operation.options.QueryOperation;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.text.options.BaseTextOptionsBuilder;

public final class OperationOptionsBuilder
extends BaseTextOptionsBuilder<OperationOptionsBuilder, OperationOptions> {
    private static final String SHOW_LOBS = "schemacrawler.format.data.show_lobs";
    private String command;
    protected Operation operation;
    protected boolean isShowLobs;

    public static OperationOptionsBuilder builder() {
        return new OperationOptionsBuilder();
    }

    private OperationOptionsBuilder() {
    }

    @Override
    public OperationOptionsBuilder fromConfig(Config config) {
        if (config == null) {
            return this;
        }
        super.fromConfig(config);
        this.isShowLobs = config.getBooleanValue(SHOW_LOBS, false);
        this.operation = this.getQueryFromCommand(config);
        return this;
    }

    @Override
    public OperationOptionsBuilder fromOptions(OperationOptions options) {
        if (options == null) {
            return this;
        }
        super.fromOptions(options);
        this.isShowLobs = options.isShowLobs();
        return this;
    }

    public OperationOptionsBuilder showLobs() {
        return this.showLobs(true);
    }

    public OperationOptionsBuilder showLobs(boolean value) {
        this.isShowLobs = value;
        return this;
    }

    @Override
    public Config toConfig() {
        Config config = super.toConfig();
        config.put(SHOW_LOBS, (Object)this.isShowLobs);
        return config;
    }

    public OperationOptions toOptions() {
        return new OperationOptions(this);
    }

    public OperationOptionsBuilder withCommand(String command) {
        this.command = command;
        this.operation = this.getOperationFromCommand();
        return this;
    }

    private Operation getOperationFromCommand() {
        Operation operation = null;
        try {
            operation = OperationType.valueOf(this.command);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            operation = this.operation;
        }
        return operation;
    }

    private Operation getQueryFromCommand(Config config) {
        Operation operation;
        if (config.containsKey(this.command)) {
            String queryName = this.command;
            String queryString = config.getStringValue(queryName, null);
            operation = new QueryOperation(new Query(queryName, queryString));
        } else {
            operation = this.operation;
        }
        return operation;
    }
}

