/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.formatter.schema;

import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.CrawlInfo;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.Routine;
import schemacrawler.schema.Sequence;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.command.text.schema.options.SchemaTextDetailType;
import schemacrawler.tools.command.text.schema.options.SchemaTextOptions;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.formatter.base.BaseFormatter;
import schemacrawler.tools.text.formatter.base.helper.TextFormattingHelper;
import schemacrawler.tools.traversal.SchemaTraversalHandler;
import us.fatehi.utility.Utility;
import us.fatehi.utility.html.Alignment;

public final class SchemaListFormatter
extends BaseFormatter<SchemaTextOptions>
implements SchemaTraversalHandler {
    public SchemaListFormatter(SchemaTextDetailType schemaTextDetailType, SchemaTextOptions options, OutputOptions outputOptions, String identifierQuoteString) throws SchemaCrawlerException {
        super(options, schemaTextDetailType == SchemaTextDetailType.details, outputOptions, identifierQuoteString);
    }

    @Override
    public void begin() {
        this.formattingHelper.writeDocumentStart();
    }

    @Override
    public void end() throws SchemaCrawlerException {
        this.formattingHelper.writeDocumentEnd();
        super.end();
    }

    @Override
    public void handle(ColumnDataType columnDataType) {
    }

    @Override
    public void handle(CrawlInfo crawlInfo) {
        if (crawlInfo == null) {
            return;
        }
        String title = this.outputOptions.getTitle();
        if (!Utility.isBlank((CharSequence)title)) {
            this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.title, title);
        }
        if (((SchemaTextOptions)this.options).isNoInfo() || ((SchemaTextOptions)this.options).isNoSchemaCrawlerInfo() && !((SchemaTextOptions)this.options).isShowDatabaseInfo() && !((SchemaTextOptions)this.options).isShowJdbcDriverInfo()) {
            return;
        }
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "System Information");
        if (!((SchemaTextOptions)this.options).isNoSchemaCrawlerInfo()) {
            this.formattingHelper.writeObjectStart();
            this.formattingHelper.writeNameValueRow("generated by", crawlInfo.getSchemaCrawlerVersion().toString(), Alignment.inherit);
            this.formattingHelper.writeNameValueRow("generated on", crawlInfo.getCrawlTimestamp(), Alignment.inherit);
        }
        if (((SchemaTextOptions)this.options).isShowDatabaseInfo()) {
            this.formattingHelper.writeNameValueRow("database version", crawlInfo.getDatabaseVersion().toString(), Alignment.inherit);
        }
        if (((SchemaTextOptions)this.options).isShowJdbcDriverInfo()) {
            this.formattingHelper.writeNameValueRow("driver version", crawlInfo.getJdbcDriverVersion().toString(), Alignment.inherit);
        }
        this.formattingHelper.writeObjectEnd();
    }

    @Override
    public void handle(DatabaseInfo dbInfo) {
    }

    @Override
    public void handle(JdbcDriverInfo driverInfo) {
    }

    @Override
    public void handle(Routine routine) {
        String routineTypeDetail = String.format("%s, %s", routine.getRoutineType(), routine.getReturnType());
        String routineName = this.quoteName((DatabaseObject)routine);
        String routineType = "[" + routineTypeDetail + "]";
        this.formattingHelper.writeNameRow(routineName, routineType);
        this.printRemarks((DatabaseObject)routine);
    }

    @Override
    public void handle(Sequence sequence) {
        String sequenceName = this.quoteName((DatabaseObject)sequence);
        String sequenceType = "[sequence]";
        this.formattingHelper.writeNameRow(sequenceName, "[sequence]");
        this.printRemarks((DatabaseObject)sequence);
    }

    @Override
    public void handle(Synonym synonym) {
        String synonymName = this.quoteName((DatabaseObject)synonym);
        String synonymType = "[synonym]";
        this.formattingHelper.writeNameRow(synonymName, "[synonym]");
        this.printRemarks((DatabaseObject)synonym);
    }

    @Override
    public void handle(Table table) {
        String tableName = this.quoteName((DatabaseObject)table);
        String tableType = "[" + table.getTableType() + "]";
        this.formattingHelper.writeNameRow(tableName, tableType);
        this.printRemarks((DatabaseObject)table);
    }

    @Override
    public void handleColumnDataTypesEnd() {
    }

    @Override
    public void handleColumnDataTypesStart() {
    }

    @Override
    public void handleHeaderEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleHeaderStart() throws SchemaCrawlerException {
    }

    @Override
    public void handleInfoEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleInfoStart() throws SchemaCrawlerException {
    }

    @Override
    public void handleRoutinesEnd() throws SchemaCrawlerException {
        this.formattingHelper.writeObjectEnd();
    }

    @Override
    public void handleRoutinesStart() throws SchemaCrawlerException {
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Routines");
        this.formattingHelper.writeObjectStart();
    }

    @Override
    public void handleSequencesEnd() throws SchemaCrawlerException {
        this.formattingHelper.writeObjectEnd();
    }

    @Override
    public void handleSequencesStart() throws SchemaCrawlerException {
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Sequences");
        this.formattingHelper.writeObjectStart();
    }

    @Override
    public void handleSynonymsEnd() throws SchemaCrawlerException {
        this.formattingHelper.writeObjectEnd();
    }

    @Override
    public void handleSynonymsStart() throws SchemaCrawlerException {
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Synonyms");
        this.formattingHelper.writeObjectStart();
    }

    @Override
    public void handleTablesEnd() throws SchemaCrawlerException {
        this.formattingHelper.writeObjectEnd();
    }

    @Override
    public void handleTablesStart() throws SchemaCrawlerException {
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Tables");
        this.formattingHelper.writeObjectStart();
    }

    private void printRemarks(DatabaseObject object) {
        if (object == null || !object.hasRemarks() || ((SchemaTextOptions)this.options).isHideRemarks()) {
            return;
        }
        this.formattingHelper.writeDescriptionRow(object.getRemarks());
    }
}

