/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.loader.attributes;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AlternateKeyBuilder;
import schemacrawler.crawl.WeakAssociationBuilder;
import schemacrawler.loader.attributes.model.AlternateKeyAttributes;
import schemacrawler.loader.attributes.model.CatalogAttributes;
import schemacrawler.loader.attributes.model.CatalogAttributesUtility;
import schemacrawler.loader.attributes.model.ColumnAttributes;
import schemacrawler.loader.attributes.model.TableAttributes;
import schemacrawler.loader.attributes.model.WeakAssociationAttributes;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.PrimaryKey;
import schemacrawler.schema.Table;
import schemacrawler.schema.WeakAssociation;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.catalogloader.BaseCatalogLoader;
import schemacrawler.tools.executable.CommandDescription;
import schemacrawler.tools.executable.commandline.PluginCommand;
import schemacrawler.tools.options.Config;
import us.fatehi.utility.StopWatch;
import us.fatehi.utility.Utility;
import us.fatehi.utility.ioresource.InputResource;
import us.fatehi.utility.ioresource.InputResourceUtility;
import us.fatehi.utility.string.StringFormat;

public class AttributesCatalogLoader
extends BaseCatalogLoader {
    private static final Logger LOGGER = Logger.getLogger(AttributesCatalogLoader.class.getName());
    private static final String OPTION_ATTRIBUTES_FILE = "attributes-file";

    public AttributesCatalogLoader() {
        super(new CommandDescription("attributesloader", "Loader for catalog attributes, such as remarks or tags"), 2);
    }

    public PluginCommand getCommandLineCommand() {
        CommandDescription commandDescription = this.getCommandDescription();
        PluginCommand pluginCommand = PluginCommand.newCatalogLoaderCommand((String)commandDescription.getName(), (String)commandDescription.getDescription());
        pluginCommand.addOption(OPTION_ATTRIBUTES_FILE, String.class, new String[]{"Path to a YAML file with table and column attributes to add to the schema"});
        return pluginCommand;
    }

    public void loadCatalog() throws SchemaCrawlerException {
        if (!this.isLoaded()) {
            return;
        }
        LOGGER.log(Level.INFO, "Retrieving catalog attributes");
        StopWatch stopWatch = new StopWatch("loadTableRowCounts");
        try {
            Catalog catalog = this.getCatalog();
            Config config = this.getAdditionalConfiguration();
            stopWatch.time("retrieveCatalogAttributes", () -> {
                String catalogAttributesFile = (String)config.getObject(OPTION_ATTRIBUTES_FILE, null);
                if (Utility.isBlank((CharSequence)catalogAttributesFile)) {
                    return null;
                }
                InputResource inputResource = (InputResource)InputResourceUtility.createInputResource((String)catalogAttributesFile).orElseThrow(() -> new SchemaCrawlerException("Cannot locate catalog attributes file, " + catalogAttributesFile));
                CatalogAttributes catalogAttributes = CatalogAttributesUtility.readCatalogAttributes(inputResource);
                this.loadRemarks(catalog, catalogAttributes);
                this.loadAlternateKeys(catalog, catalogAttributes);
                this.loadWeakAssociations(catalog, catalogAttributes);
                return null;
            });
            LOGGER.log(Level.INFO, stopWatch.stringify());
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Exception loading catalog attributes", (Throwable)e);
        }
    }

    private void loadAlternateKeys(Catalog catalog, CatalogAttributes catalogAttributes) {
        AlternateKeyBuilder alternateKeyBuilder = AlternateKeyBuilder.builder((Catalog)catalog);
        for (AlternateKeyAttributes alternateKeyAttributes : catalogAttributes.getAlternateKeys()) {
            AlternateKeyBuilder.AlternateKeyDefinition alternateKeyDefinition = new AlternateKeyBuilder.AlternateKeyDefinition(alternateKeyAttributes.getSchema(), alternateKeyAttributes.getTableName(), alternateKeyAttributes.getName(), alternateKeyAttributes.getColumns());
            Optional optionalAlternateKey = alternateKeyBuilder.addAlternateKey(alternateKeyDefinition);
            if (!optionalAlternateKey.isPresent()) continue;
            PrimaryKey alternateKey = (PrimaryKey)optionalAlternateKey.get();
            alternateKey.setRemarks(alternateKeyAttributes.getRemarks());
            for (Map.Entry<String, String> attribute : alternateKeyAttributes.getAttributes().entrySet()) {
                alternateKey.setAttribute(attribute.getKey(), (Object)attribute.getValue());
            }
        }
    }

    private void loadRemarks(Catalog catalog, CatalogAttributes catalogAttributes) {
        for (TableAttributes tableAttributes : catalogAttributes.getTables()) {
            Optional lookupTable = catalog.lookupTable(tableAttributes.getSchema(), tableAttributes.getName());
            if (!lookupTable.isPresent()) {
                LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Table %s not found", new Object[]{tableAttributes}));
                continue;
            }
            Table table = (Table)lookupTable.get();
            if (tableAttributes.hasRemarks()) {
                table.setRemarks(tableAttributes.getRemarks());
            }
            for (ColumnAttributes columnAttributes : tableAttributes) {
                if (!columnAttributes.hasRemarks()) continue;
                Optional lookupColumn = table.lookupColumn(columnAttributes.getName());
                if (lookupColumn.isPresent()) {
                    Column column = (Column)lookupColumn.get();
                    column.setRemarks(columnAttributes.getRemarks());
                    continue;
                }
                LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Column %s not found", new Object[]{columnAttributes}));
            }
        }
    }

    private void loadWeakAssociations(Catalog catalog, CatalogAttributes catalogAttributes) {
        for (WeakAssociationAttributes weakAssociationAttributes : catalogAttributes.getWeakAssociations()) {
            TableAttributes pkTableAttributes = weakAssociationAttributes.getReferencedTable();
            TableAttributes fkTableAttributes = weakAssociationAttributes.getReferencingTable();
            WeakAssociationBuilder weakAssociationBuilder = WeakAssociationBuilder.builder((Catalog)catalog);
            for (Map.Entry<String, String> entry : weakAssociationAttributes.getColumnReferences().entrySet()) {
                String fkColumnName = entry.getKey();
                String pkColumnName = entry.getValue();
                WeakAssociationBuilder.WeakAssociationColumn fkColumn = new WeakAssociationBuilder.WeakAssociationColumn(fkTableAttributes.getSchema(), fkTableAttributes.getName(), fkColumnName);
                WeakAssociationBuilder.WeakAssociationColumn pkColumn = new WeakAssociationBuilder.WeakAssociationColumn(pkTableAttributes.getSchema(), pkTableAttributes.getName(), pkColumnName);
                weakAssociationBuilder.addColumnReference(fkColumn, pkColumn);
            }
            WeakAssociation weakAssociation = weakAssociationBuilder.build(weakAssociationAttributes.getName());
            if (weakAssociation == null) continue;
            weakAssociation.setRemarks(weakAssociationAttributes.getRemarks());
            for (Map.Entry<String, String> attribute : weakAssociationAttributes.getAttributes().entrySet()) {
                weakAssociation.setAttribute(attribute.getKey(), (Object)attribute.getValue());
            }
        }
    }
}

