/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.loader.counts;

import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.filter.ReducerFactory;
import schemacrawler.loader.counts.TableRowCountsFilter;
import schemacrawler.loader.counts.TableRowCountsRetriever;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.catalogloader.BaseCatalogLoader;
import schemacrawler.tools.executable.CommandDescription;
import schemacrawler.tools.executable.commandline.PluginCommand;
import schemacrawler.tools.options.Config;
import us.fatehi.utility.StopWatch;

public class TableRowCountsCatalogLoader
extends BaseCatalogLoader {
    private static final Logger LOGGER = Logger.getLogger(TableRowCountsCatalogLoader.class.getName());
    private static final String OPTION_NO_EMPTY_TABLES = "no-empty-tables";
    private static final String OPTION_LOAD_ROW_COUNTS = "load-row-counts";

    public TableRowCountsCatalogLoader() {
        super(new CommandDescription("countsloader", "Loader for table row counts"), 2);
    }

    public PluginCommand getCommandLineCommand() {
        CommandDescription commandDescription = this.getCommandDescription();
        PluginCommand pluginCommand = PluginCommand.newCatalogLoaderCommand((String)commandDescription.getName(), (String)commandDescription.getDescription());
        pluginCommand.addOption(OPTION_LOAD_ROW_COUNTS, Boolean.class, new String[]{"Loads row counts for each table", "This can be a time consuming operation", "Optional, defaults to false"}).addOption(OPTION_NO_EMPTY_TABLES, Boolean.class, new String[]{"Includes only tables that have rows of data", "Requires table row counts to be loaded", "Optional, default is false"});
        return pluginCommand;
    }

    public void loadCatalog() throws SchemaCrawlerException {
        if (!this.isLoaded()) {
            return;
        }
        LOGGER.log(Level.INFO, "Retrieving table row counts");
        StopWatch stopWatch = new StopWatch("loadTableRowCounts");
        try {
            Catalog catalog = this.getCatalog();
            TableRowCountsRetriever rowCountsRetriever = new TableRowCountsRetriever(this.getConnection(), catalog);
            Config config = this.getAdditionalConfiguration();
            stopWatch.time("retrieveTableRowCounts", () -> {
                boolean loadRowCounts = config.getBooleanValue(OPTION_LOAD_ROW_COUNTS, false);
                if (loadRowCounts) {
                    rowCountsRetriever.retrieveTableRowCounts();
                } else {
                    LOGGER.log(Level.INFO, "Not retrieving table row counts, since this was not requested");
                }
                return null;
            });
            stopWatch.time("filterEmptyTables", () -> {
                boolean noEmptyTables = config.getBooleanValue(OPTION_NO_EMPTY_TABLES, false);
                catalog.reduce(Table.class, ReducerFactory.getTableReducer((Predicate)new TableRowCountsFilter(noEmptyTables)));
                return null;
            });
            LOGGER.log(Level.INFO, stopWatch.stringify());
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Exception retrieving table row counts", (Throwable)e);
        }
    }
}

