/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.text.diagram;

import java.nio.file.Path;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.command.text.diagram.AbstractGraphProcessExecutor;
import schemacrawler.tools.command.text.diagram.GraphvizJavaExecutorUtility;
import schemacrawler.tools.command.text.diagram.GraphvizUtility;
import schemacrawler.tools.command.text.diagram.options.DiagramOutputFormat;
import us.fatehi.utility.string.StringFormat;

final class GraphvizJavaExecutor
extends AbstractGraphProcessExecutor {
    private static final Logger LOGGER = Logger.getLogger(GraphvizJavaExecutor.class.getName());

    GraphvizJavaExecutor(Path dotFile, Path outputFile, DiagramOutputFormat diagramOutputFormat) throws SchemaCrawlerException {
        super(dotFile, outputFile, diagramOutputFormat);
    }

    @Override
    public Boolean call() {
        try {
            GraphvizJavaExecutorUtility.generateGraph(this.dotFile, this.outputFile, this.diagramOutputFormat);
        }
        catch (SchemaCrawlerException e) {
            LOGGER.log(Level.INFO, String.format("Could not generate diagram from:%n%s", this.dotFile), e);
            return false;
        }
        LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Generated diagram <%s>", new Object[]{this.outputFile}));
        return true;
    }

    @Override
    public boolean canGenerate() {
        return GraphvizUtility.isGraphvizJavaAvailable(this.diagramOutputFormat);
    }
}

