/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Objects;
import java.util.logging.Logger;
import schemacrawler.crawl.ImmutableConnectionInfo;
import schemacrawler.schema.ConnectionInfo;

public final class ConnectionInfoBuilder {
    private static final Logger LOGGER = Logger.getLogger(ConnectionInfoBuilder.class.getName());
    private final Connection connection;

    public static ConnectionInfoBuilder builder(Connection connection) {
        return new ConnectionInfoBuilder(connection);
    }

    private ConnectionInfoBuilder(Connection connection) {
        this.connection = Objects.requireNonNull(connection, "No connection provided");
    }

    public ConnectionInfo build() throws SQLException {
        DatabaseMetaData dbMetaData = this.connection.getMetaData();
        ImmutableConnectionInfo connectionInfo = new ImmutableConnectionInfo(dbMetaData.getDatabaseProductName(), dbMetaData.getDatabaseProductVersion(), dbMetaData.getURL(), dbMetaData.getUserName(), dbMetaData.getDriverName(), dbMetaData.getDriverVersion(), dbMetaData.getDriverMajorVersion(), dbMetaData.getDriverMinorVersion(), dbMetaData.getJDBCMajorVersion(), dbMetaData.getJDBCMinorVersion());
        return connectionInfo;
    }
}

