/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline.state;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.FilterOptions;
import schemacrawler.schemacrawler.GrepOptions;
import schemacrawler.schemacrawler.LimitOptions;
import schemacrawler.schemacrawler.LoadOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.tools.options.Config;
import us.fatehi.utility.string.StringFormat;

public class ShellState {
    private static final Logger LOGGER = Logger.getLogger(ShellState.class.getName());
    private Config baseConfig;
    private Config commandOptions;
    private Config catalogLoaderOptions;
    private Catalog catalog;
    private Supplier<Connection> dataSource;
    private Throwable lastException;
    private SchemaCrawlerOptions schemaCrawlerOptions;
    private SchemaRetrievalOptions schemaRetrievalOptions;
    private boolean isDeferCatalogLoad;

    public void disconnect() {
        if (this.dataSource == null) {
            return;
        }
        try (Connection connection = this.dataSource.get();){
            LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Closing connection <%s>", new Object[]{connection}));
            this.dataSource = null;
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Cannot close connection");
        }
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public Config getConfig() {
        Config config = new Config();
        config.merge(this.baseConfig);
        config.merge(this.commandOptions);
        config.merge(this.catalogLoaderOptions);
        return config;
    }

    public Supplier<Connection> getDataSource() {
        return this.dataSource;
    }

    public Throwable getLastException() {
        return this.lastException;
    }

    public SchemaCrawlerOptions getSchemaCrawlerOptions() {
        return this.schemaCrawlerOptions;
    }

    public SchemaRetrievalOptions getSchemaRetrievalOptions() {
        return this.schemaRetrievalOptions;
    }

    public boolean isConnected() {
        return this.dataSource != null;
    }

    public boolean isDeferCatalogLoad() {
        return this.isDeferCatalogLoad;
    }

    public boolean isLoaded() {
        return this.catalog != null;
    }

    public void setBaseConfig(Config baseConfig) {
        this.baseConfig = baseConfig != null ? baseConfig : new Config();
    }

    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
    }

    public void setCatalogLoaderOptions(Map<String, Object> catalogLoaderOptions) {
        this.catalogLoaderOptions = catalogLoaderOptions != null ? new Config(catalogLoaderOptions) : null;
    }

    public void setCommandOptions(Map<String, Object> commandOptions) {
        this.commandOptions = commandOptions != null ? new Config(commandOptions) : null;
    }

    public void setDataSource(Supplier<Connection> dataSource) {
        this.dataSource = dataSource;
    }

    public void setDeferCatalogLoad(boolean isDeferCatalogLoad) {
        this.isDeferCatalogLoad = isDeferCatalogLoad;
    }

    public void setLastException(Throwable lastException) {
        this.lastException = lastException;
    }

    public void setSchemaCrawlerOptions(SchemaCrawlerOptions schemaCrawlerOptions) {
        this.schemaCrawlerOptions = schemaCrawlerOptions;
    }

    public void setSchemaRetrievalOptions(SchemaRetrievalOptions schemaRetrievalOptions) {
        this.schemaRetrievalOptions = schemaRetrievalOptions;
    }

    public void sweep() {
        this.catalog = null;
        this.baseConfig = null;
        this.commandOptions = null;
        this.schemaCrawlerOptions = null;
        this.schemaRetrievalOptions = null;
        this.lastException = null;
        this.disconnect();
    }

    public void withFilterOptions(FilterOptions filterOptions) {
        this.schemaCrawlerOptions = this.schemaCrawlerOptions.withFilterOptions(filterOptions);
    }

    public void withGrepOptions(GrepOptions grepOptions) {
        this.schemaCrawlerOptions = this.schemaCrawlerOptions.withGrepOptions(grepOptions);
    }

    public void withLimitOptions(LimitOptions limitOptions) {
        this.schemaCrawlerOptions = this.schemaCrawlerOptions.withLimitOptions(limitOptions);
    }

    public void withLoadOptions(LoadOptions loadOptions) {
        this.schemaCrawlerOptions = this.schemaCrawlerOptions.withLoadOptions(loadOptions);
    }
}

