/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline.utility;

import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.tools.commandline.utility.CommandLineUtility;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

public final class CommandLineLoggingUtility {
    private static final Logger LOGGER = Logger.getLogger(CommandLineLoggingUtility.class.getName());

    public static void logFatalStackTrace(Throwable t) {
        if (t == null || !LOGGER.isLoggable(Level.SEVERE)) {
            return;
        }
        LOGGER.log(Level.SEVERE, t.getMessage(), t);
    }

    public static void logSafeArguments(String[] args) {
        if (!LOGGER.isLoggable(Level.INFO)) {
            return;
        }
        LOGGER.log(Level.INFO, CommandLineUtility.getEnvironment());
        if (args == null) {
            return;
        }
        String passwordRedacted = "<password provided>";
        StringJoiner argsList = new StringJoiner(System.lineSeparator());
        Iterator<String> iterator = Arrays.asList(args).iterator();
        while (iterator.hasNext()) {
            String arg = iterator.next();
            if (arg == null) continue;
            if (arg.matches("--password.*=.*")) {
                argsList.add("<password provided>");
                continue;
            }
            if (arg.startsWith("--password")) {
                argsList.add("<password provided>");
                if (!iterator.hasNext()) continue;
                iterator.next();
                continue;
            }
            argsList.add(arg);
        }
        LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Command line: %n%s", new Object[]{argsList.toString()}));
    }

    public static void logSystemClasspath() {
        if (!LOGGER.isLoggable(Level.CONFIG)) {
            return;
        }
        LOGGER.log(Level.CONFIG, String.format("Classpath: %n%s", CommandLineLoggingUtility.printPath(System.getProperty("java.class.path"))));
        LOGGER.log(Level.CONFIG, String.format("LD_LIBRARY_PATH: %n%s", CommandLineLoggingUtility.printPath(System.getenv("LD_LIBRARY_PATH"))));
    }

    public static void logSystemProperties() {
        if (!LOGGER.isLoggable(Level.CONFIG)) {
            return;
        }
        TreeMap<String, String> systemProperties = new TreeMap<String, String>();
        for (Map.Entry<Object, Object> propertyValue : System.getProperties().entrySet()) {
            String name = (String)propertyValue.getKey();
            if (!name.startsWith("java.") && !name.startsWith("os.") || name.endsWith(".path")) continue;
            systemProperties.put(name, (String)propertyValue.getValue());
        }
        LOGGER.log(Level.CONFIG, String.format("System properties: %n%s", Utility.join(systemProperties, (String)System.lineSeparator())));
    }

    private static String printPath(String path) {
        if (path == null) {
            return "";
        }
        return String.join((CharSequence)System.lineSeparator(), path.split(File.pathSeparator));
    }

    private CommandLineLoggingUtility() {
    }
}

