/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.offline.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.file.Path;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Objects;
import schemacrawler.tools.offline.jdbc.OfflineConnection;

public class OfflineConnectionUtility {
    public static OfflineConnection newOfflineConnection(Path offlineDatabasePath) {
        Objects.requireNonNull(offlineDatabasePath, "No offline database path provided");
        return (OfflineConnection)Proxy.newProxyInstance(OfflineConnectionUtility.class.getClassLoader(), new Class[]{OfflineConnection.class}, (InvocationHandler)new OfflineConnectionInvocationHandler(offlineDatabasePath));
    }

    private OfflineConnectionUtility() {
    }

    private static class OfflineConnectionInvocationHandler
    implements InvocationHandler {
        private final Path offlineDatabasePath;

        public OfflineConnectionInvocationHandler(Path offlineDatabasePath) {
            this.offlineDatabasePath = offlineDatabasePath;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws SQLFeatureNotSupportedException {
            String methodName;
            switch (methodName = method.getName()) {
                case "close": 
                case "setAutoCommit": {
                    return null;
                }
                case "getOfflineDatabasePath": {
                    return this.offlineDatabasePath;
                }
                case "isWrapperFor": 
                case "isClosed": {
                    return false;
                }
                case "isValid": {
                    return true;
                }
            }
            throw new SQLFeatureNotSupportedException("Offline connection does not support method, " + methodName, "HYC00");
        }
    }
}

