/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.DataTypeRetriever;
import schemacrawler.crawl.DatabaseInfoRetriever;
import schemacrawler.crawl.ForeignKeyRetriever;
import schemacrawler.crawl.FunctionParameterRetriever;
import schemacrawler.crawl.IndexRetriever;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableRoutine;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.PrimaryKeyRetriever;
import schemacrawler.crawl.ProcedureParameterRetriever;
import schemacrawler.crawl.RetrievalStopWatch;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.crawl.RoutineExtRetriever;
import schemacrawler.crawl.RoutineRetriever;
import schemacrawler.crawl.SchemaRetriever;
import schemacrawler.crawl.SequenceRetriever;
import schemacrawler.crawl.SynonymRetriever;
import schemacrawler.crawl.TableColumnRetriever;
import schemacrawler.crawl.TableConstraintRetriever;
import schemacrawler.crawl.TableExtRetriever;
import schemacrawler.crawl.TableRetriever;
import schemacrawler.crawl.TablesGraph;
import schemacrawler.filter.ReducerFactory;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Routine;
import schemacrawler.schema.RoutineType;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Sequence;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.DatabaseObjectRuleForInclusion;
import schemacrawler.schemacrawler.LimitOptions;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerSQLException;
import schemacrawler.schemacrawler.SchemaInfoLevel;
import schemacrawler.schemacrawler.SchemaInfoRetrieval;
import schemacrawler.schemacrawler.SchemaReference;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import us.fatehi.utility.string.StringFormat;

public final class SchemaCrawler {
    private static final Logger LOGGER = Logger.getLogger(SchemaCrawler.class.getName());
    private final SchemaCrawlerOptions options;
    private final RetrieverConnection retrieverConnection;
    private final SchemaInfoLevel infoLevel;
    private final RetrievalStopWatch stopWatch;
    private MutableCatalog catalog;

    public SchemaCrawler(Connection connection, SchemaRetrievalOptions schemaRetrievalOptions, SchemaCrawlerOptions options) throws SchemaCrawlerException {
        try {
            this.retrieverConnection = new RetrieverConnection(connection, schemaRetrievalOptions);
            this.options = Objects.requireNonNull(options, "No SchemaCrawler options provided");
            this.infoLevel = options.getLoadOptions().getSchemaInfoLevel();
            this.stopWatch = new RetrievalStopWatch(this.infoLevel);
        }
        catch (SQLException e) {
            throw new SchemaCrawlerException(e.getMessage(), e);
        }
    }

    public Catalog crawl() throws SchemaCrawlerException {
        try {
            this.catalog = new MutableCatalog("catalog", this.retrieverConnection.getConnectionInfo());
            this.crawlDatabaseInfo();
            LOGGER.log(Level.INFO, String.format("%n%s", this.catalog.getCrawlInfo()));
            this.crawlSchemas();
            this.crawlColumnDataTypes();
            this.crawlTables();
            this.crawlRoutines();
            this.crawlSynonyms();
            this.crawlSequences();
            return this.catalog;
        }
        catch (SchemaCrawlerSQLException e) {
            throw new SchemaCrawlerException(e.getMessage(), e.getCause());
        }
        catch (SchemaCrawlerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchemaCrawlerException(e.getMessage(), e);
        }
    }

    private void crawlAdditionalTableColumnInformation(TableExtRetriever retrieverExtra) throws Exception {
        LOGGER.log(Level.INFO, "Retrieving additional table column information");
        this.stopWatch.time(SchemaInfoRetrieval.retrieveAdditionalColumnAttributes, retrieverExtra::retrieveAdditionalColumnAttributes, SchemaInfoRetrieval.retrieveTableColumns);
        this.stopWatch.time(SchemaInfoRetrieval.retrieveAdditionalColumnMetadata, retrieverExtra::retrieveAdditionalColumnMetadata, SchemaInfoRetrieval.retrieveTableColumns);
        this.stopWatch.time(SchemaInfoRetrieval.retrieveTableColumnPrivileges, retrieverExtra::retrieveTableColumnPrivileges, SchemaInfoRetrieval.retrieveTableColumns);
    }

    private void crawlAdditionalTableInformation(TableConstraintRetriever constraintRetriever, TableExtRetriever retrieverExtra) throws Exception {
        this.stopWatch.time(SchemaInfoRetrieval.retrieveTableConstraintDefinitions, constraintRetriever::retrieveTableConstraintDefinitions, SchemaInfoRetrieval.retrieveTableConstraints);
        this.stopWatch.time(SchemaInfoRetrieval.retrieveViewInformation, retrieverExtra::retrieveViewInformation, new SchemaInfoRetrieval[0]);
        this.stopWatch.time(SchemaInfoRetrieval.retrieveViewTableUsage, retrieverExtra::retrieveViewTableUsage, new SchemaInfoRetrieval[0]);
        this.stopWatch.time(SchemaInfoRetrieval.retrieveTableDefinitionsInformation, retrieverExtra::retrieveTableDefinitions, new SchemaInfoRetrieval[0]);
        this.stopWatch.time(SchemaInfoRetrieval.retrieveIndexInformation, () -> retrieverExtra.retrieveIndexInformation(), SchemaInfoRetrieval.retrieveIndexes);
        this.stopWatch.time(SchemaInfoRetrieval.retrieveAdditionalTableAttributes, () -> retrieverExtra.retrieveAdditionalTableAttributes(), new SchemaInfoRetrieval[0]);
        this.stopWatch.time(SchemaInfoRetrieval.retrieveTablePrivileges, () -> retrieverExtra.retrieveTablePrivileges(), new SchemaInfoRetrieval[0]);
    }

    private void crawlColumnDataTypes() throws Exception {
        this.stopWatch.reset("crawlColumnDataTypes");
        DataTypeRetriever retriever = new DataTypeRetriever(this.retrieverConnection, this.catalog, this.options);
        this.stopWatch.time(SchemaInfoRetrieval.retrieveColumnDataTypes, retriever::retrieveSystemColumnDataTypes, new SchemaInfoRetrieval[0]);
        this.stopWatch.time(SchemaInfoRetrieval.retrieveUserDefinedColumnDataTypes, retriever::retrieveUserDefinedColumnDataTypes, new SchemaInfoRetrieval[0]);
        this.stopWatch.stopAndLogTime();
    }

    private void crawlDatabaseInfo() throws Exception {
        if (!this.infoLevel.is(SchemaInfoRetrieval.retrieveDatabaseInfo)) {
            LOGGER.log(Level.INFO, "Not retrieving database information, since this was not requested");
            return;
        }
        this.stopWatch.reset("crawlDatabaseInfo");
        DatabaseInfoRetriever retriever = new DatabaseInfoRetriever(this.retrieverConnection, this.catalog, this.options);
        this.stopWatch.time(SchemaInfoRetrieval.retrieveAdditionalDatabaseInfo, retriever::retrieveAdditionalDatabaseInfo, new SchemaInfoRetrieval[0]);
        this.stopWatch.time(SchemaInfoRetrieval.retrieveServerInfo, retriever::retrieveServerInfo, new SchemaInfoRetrieval[0]);
        this.stopWatch.time(SchemaInfoRetrieval.retrieveDatabaseUsers, retriever::retrieveDatabaseUsers, new SchemaInfoRetrieval[0]);
        this.stopWatch.time(SchemaInfoRetrieval.retrieveAdditionalJdbcDriverInfo, retriever::retrieveAdditionalJdbcDriverInfo, new SchemaInfoRetrieval[0]);
        this.stopWatch.stopAndLogTime();
    }

    private void crawlRoutines() throws Exception {
        LimitOptions limitOptions = this.options.getLimitOptions();
        if (!this.infoLevel.is(SchemaInfoRetrieval.retrieveRoutines) || limitOptions.isExcludeAll(DatabaseObjectRuleForInclusion.ruleForRoutineInclusion)) {
            LOGGER.log(Level.INFO, "Not retrieving routines, since this was not requested");
            return;
        }
        this.stopWatch.reset("crawlRoutines");
        RoutineRetriever retriever = new RoutineRetriever(this.retrieverConnection, this.catalog, this.options);
        RoutineExtRetriever retrieverExtra = new RoutineExtRetriever(this.retrieverConnection, this.catalog, this.options);
        ProcedureParameterRetriever procedureParameterRetriever = new ProcedureParameterRetriever(this.retrieverConnection, this.catalog, this.options);
        FunctionParameterRetriever functionParameterRetriever = new FunctionParameterRetriever(this.retrieverConnection, this.catalog, this.options);
        Collection<RoutineType> routineTypes = limitOptions.getRoutineTypes();
        this.stopWatch.time(SchemaInfoRetrieval.retrieveRoutines, () -> retriever.retrieveRoutines(routineTypes, limitOptions.get(DatabaseObjectRuleForInclusion.ruleForRoutineInclusion)), new SchemaInfoRetrieval[0]);
        NamedObjectList<MutableRoutine> allRoutines = this.catalog.getAllRoutines();
        LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Retrieved %d routines", new Object[]{allRoutines.size()}));
        if (allRoutines.isEmpty()) {
            return;
        }
        this.stopWatch.time(SchemaInfoRetrieval.retrieveRoutineParameters, () -> {
            LOGGER.log(Level.INFO, "Retrieving routine columns");
            if (!limitOptions.isExcludeAll(DatabaseObjectRuleForInclusion.ruleForRoutineParameterInclusion)) {
                if (routineTypes.contains((Object)RoutineType.procedure)) {
                    procedureParameterRetriever.retrieveProcedureParameters(allRoutines, limitOptions.get(DatabaseObjectRuleForInclusion.ruleForRoutineParameterInclusion));
                }
                if (routineTypes.contains((Object)RoutineType.function)) {
                    functionParameterRetriever.retrieveFunctionParameters(allRoutines, limitOptions.get(DatabaseObjectRuleForInclusion.ruleForRoutineParameterInclusion));
                }
            }
        }, new SchemaInfoRetrieval[0]);
        this.stopWatch.time("filterAndSortRoutines", () -> this.catalog.reduce(Routine.class, ReducerFactory.getRoutineReducer(this.options)), new SchemaInfoRetrieval[0]);
        this.stopWatch.time(SchemaInfoRetrieval.retrieveRoutineInformation, retrieverExtra::retrieveRoutineInformation, new SchemaInfoRetrieval[0]);
        this.stopWatch.stopAndLogTime();
    }

    private void crawlSchemas() throws Exception {
        this.stopWatch.reset("crawlSchemas");
        SchemaRetriever retriever = new SchemaRetriever(this.retrieverConnection, this.catalog, this.options);
        this.stopWatch.time("retrieveSchemas", () -> retriever.retrieveSchemas(this.options.getLimitOptions().get(DatabaseObjectRuleForInclusion.ruleForSchemaInclusion)), new SchemaInfoRetrieval[0]);
        this.stopWatch.time("filterAndSortSchemas", () -> this.catalog.reduce(Schema.class, ReducerFactory.getSchemaReducer(this.options)), new SchemaInfoRetrieval[0]);
        this.stopWatch.stopAndLogTime();
        NamedObjectList<SchemaReference> schemas = retriever.getAllSchemas();
        if (schemas.isEmpty()) {
            throw new SchemaCrawlerException("No matching schemas found");
        }
        LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Retrieved %d schemas", new Object[]{schemas.size()}));
    }

    private void crawlSequences() throws Exception {
        LimitOptions limitOptions = this.options.getLimitOptions();
        if (!this.infoLevel.is(SchemaInfoRetrieval.retrieveSequenceInformation) || limitOptions.isExcludeAll(DatabaseObjectRuleForInclusion.ruleForSequenceInclusion)) {
            LOGGER.log(Level.INFO, "Not retrieving sequences, since this was not requested");
            return;
        }
        this.stopWatch.reset("crawlSequences");
        SequenceRetriever retrieverExtra = new SequenceRetriever(this.retrieverConnection, this.catalog, this.options);
        this.stopWatch.time(SchemaInfoRetrieval.retrieveSequenceInformation, () -> retrieverExtra.retrieveSequenceInformation(limitOptions.get(DatabaseObjectRuleForInclusion.ruleForSequenceInclusion)), new SchemaInfoRetrieval[0]);
        this.stopWatch.time("filterAndSortSequences", () -> this.catalog.reduce(Sequence.class, ReducerFactory.getSequenceReducer(this.options)), new SchemaInfoRetrieval[0]);
        this.stopWatch.stopAndLogTime();
    }

    private void crawlSynonyms() throws Exception {
        LimitOptions limitOptions = this.options.getLimitOptions();
        if (!this.infoLevel.is(SchemaInfoRetrieval.retrieveSynonymInformation) || limitOptions.isExcludeAll(DatabaseObjectRuleForInclusion.ruleForSynonymInclusion)) {
            LOGGER.log(Level.INFO, "Not retrieving synonyms, since this was not requested");
            return;
        }
        this.stopWatch.reset("crawlSynonyms");
        SynonymRetriever retrieverExtra = new SynonymRetriever(this.retrieverConnection, this.catalog, this.options);
        this.stopWatch.time(SchemaInfoRetrieval.retrieveSynonymInformation, () -> retrieverExtra.retrieveSynonymInformation(limitOptions.get(DatabaseObjectRuleForInclusion.ruleForSynonymInclusion)), new SchemaInfoRetrieval[0]);
        this.stopWatch.time("filterAndSortSynonms", () -> this.catalog.reduce(Synonym.class, ReducerFactory.getSynonymReducer(this.options)), new SchemaInfoRetrieval[0]);
        this.stopWatch.stopAndLogTime();
    }

    private void crawlTables() throws Exception {
        LimitOptions limitOptions = this.options.getLimitOptions();
        if (!this.infoLevel.is(SchemaInfoRetrieval.retrieveTables) || limitOptions.isExcludeAll(DatabaseObjectRuleForInclusion.ruleForTableInclusion)) {
            LOGGER.log(Level.INFO, "Not retrieving tables, since this was not requested");
            return;
        }
        this.stopWatch.reset("crawlTables");
        TableRetriever retriever = new TableRetriever(this.retrieverConnection, this.catalog, this.options);
        TableColumnRetriever columnRetriever = new TableColumnRetriever(this.retrieverConnection, this.catalog, this.options);
        PrimaryKeyRetriever pkRetriever = new PrimaryKeyRetriever(this.retrieverConnection, this.catalog, this.options);
        ForeignKeyRetriever fkRetriever = new ForeignKeyRetriever(this.retrieverConnection, this.catalog, this.options);
        TableConstraintRetriever constraintRetriever = new TableConstraintRetriever(this.retrieverConnection, this.catalog, this.options);
        TableExtRetriever retrieverExtra = new TableExtRetriever(this.retrieverConnection, this.catalog, this.options);
        IndexRetriever indexRetriever = new IndexRetriever(this.retrieverConnection, this.catalog, this.options);
        this.stopWatch.time(SchemaInfoRetrieval.retrieveTables, () -> {
            LOGGER.log(Level.INFO, "Retrieving table names");
            retriever.retrieveTables(limitOptions.getTableNamePattern(), limitOptions.getTableTypes(), limitOptions.get(DatabaseObjectRuleForInclusion.ruleForTableInclusion));
        }, new SchemaInfoRetrieval[0]);
        NamedObjectList<MutableTable> allTables = this.catalog.getAllTables();
        LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Retrieved %d tables", new Object[]{allTables.size()}));
        if (allTables.isEmpty()) {
            return;
        }
        this.stopWatch.time(SchemaInfoRetrieval.retrieveTableColumns, () -> {
            if (!limitOptions.isExcludeAll(DatabaseObjectRuleForInclusion.ruleForColumnInclusion)) {
                columnRetriever.retrieveTableColumns(allTables, limitOptions.get(DatabaseObjectRuleForInclusion.ruleForColumnInclusion));
            }
        }, new SchemaInfoRetrieval[0]);
        this.stopWatch.time(SchemaInfoRetrieval.retrievePrimaryKeys, () -> pkRetriever.retrievePrimaryKeys(allTables), SchemaInfoRetrieval.retrieveTableColumns);
        this.stopWatch.time(SchemaInfoRetrieval.retrieveForeignKeys, () -> fkRetriever.retrieveForeignKeys(allTables), SchemaInfoRetrieval.retrieveTableColumns);
        this.stopWatch.time("filterAndSortTables", () -> {
            this.catalog.reduce(Table.class, ReducerFactory.getTableReducer(this.options));
            TablesGraph tablesGraph = new TablesGraph(allTables);
            tablesGraph.setTablesSortIndexes();
        }, new SchemaInfoRetrieval[0]);
        this.stopWatch.time(SchemaInfoRetrieval.retrieveIndexes, () -> indexRetriever.retrieveIndexes(allTables), SchemaInfoRetrieval.retrieveTableColumns);
        LOGGER.log(Level.INFO, "Retrieving additional table information");
        this.stopWatch.time(SchemaInfoRetrieval.retrieveTableConstraints, constraintRetriever::retrieveTableConstraints, new SchemaInfoRetrieval[0]);
        this.stopWatch.time(SchemaInfoRetrieval.retrieveTableConstraintInformation, constraintRetriever::retrieveTableConstraintInformation, SchemaInfoRetrieval.retrieveTableConstraints);
        this.stopWatch.time("matchTableConstraints", () -> constraintRetriever.matchTableConstraints(allTables), SchemaInfoRetrieval.retrieveTableColumns);
        this.stopWatch.time(SchemaInfoRetrieval.retrieveTriggerInformation, retrieverExtra::retrieveTriggerInformation, new SchemaInfoRetrieval[0]);
        this.crawlAdditionalTableInformation(constraintRetriever, retrieverExtra);
        this.crawlAdditionalTableColumnInformation(retrieverExtra);
        this.stopWatch.stopAndLogTime();
    }
}

