/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.mcl.protocol.oldmapi;

import java.nio.CharBuffer;
import nl.cwi.monetdb.mcl.protocol.ProtocolException;

final class OldMapiTableHeaderParser {
    private OldMapiTableHeaderParser() {
    }

    static int getNextTableHeader(CharBuffer lineBuffer, String[] columnNames, int[] columnLengths, String[] types, String[] tableNames) throws ProtocolException {
        int res = 0;
        int currentLength = lineBuffer.limit();
        char[] array = lineBuffer.array();
        int pos = 0;
        boolean foundChar = false;
        boolean nameFound = false;
        block9: for (int i = currentLength - 1; i >= 0; --i) {
            switch (array[i]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (!foundChar) {
                        currentLength = i - 1;
                        continue block9;
                    }
                    pos = i + 1;
                    continue block9;
                }
                case '#': {
                    nameFound = true;
                    if (pos == 0) {
                        pos = i + 1;
                    }
                    i = 0;
                    continue block9;
                }
                default: {
                    foundChar = true;
                    pos = 0;
                }
            }
        }
        if (!nameFound) {
            throw new ProtocolException("Invalid header, no header name found", pos);
        }
        switch (array[pos]) {
            case 'n': {
                if (currentLength - pos != 4) break;
                OldMapiTableHeaderParser.getStringValues(array, pos - 3, columnNames);
                res = 1;
                break;
            }
            case 'l': {
                if (currentLength - pos != 6) break;
                OldMapiTableHeaderParser.getIntValues(array, pos - 3, columnLengths);
                res = 2;
                break;
            }
            case 't': {
                if (currentLength - pos == 4) {
                    OldMapiTableHeaderParser.getStringValues(array, pos - 3, types);
                    res = 8;
                    break;
                }
                if (currentLength - pos != 10) break;
                OldMapiTableHeaderParser.getStringValues(array, pos - 3, tableNames);
                res = 4;
                break;
            }
            default: {
                throw new ProtocolException("Unknown header: " + new String(array, pos, currentLength - pos));
            }
        }
        return res;
    }

    private static void getStringValues(char[] array, int stop, String[] stringValues) {
        int elem = 0;
        int start = 2;
        boolean inString = false;
        boolean escaped = false;
        block5: for (int i = start; i < stop; ++i) {
            switch (array[i]) {
                case '\\': {
                    escaped = !escaped;
                    continue block5;
                }
                case '\"': {
                    if (!inString) {
                        inString = true;
                    } else if (!escaped) {
                        inString = false;
                    }
                    escaped = false;
                    continue block5;
                }
                case ',': {
                    if (!inString && array[i + 1] == '\t') {
                        if (array[start] == '\"') {
                            ++start;
                        }
                        if (elem < stringValues.length) {
                            stringValues[elem++] = new String(array, start, i - (array[i - 1] == '\"' ? 1 : 0) - start);
                        }
                        start = ++i + 1;
                    }
                    escaped = false;
                    continue block5;
                }
                default: {
                    escaped = false;
                }
            }
        }
        if (array[start] == '\"') {
            ++start;
        }
        if (elem < stringValues.length) {
            stringValues[elem] = new String(array, start, stop - (array[stop - 1] == '\"' ? 1 : 0) - start);
        }
    }

    private static void getIntValues(char[] array, int stop, int[] intValues) throws ProtocolException {
        int start;
        int elem = 0;
        int tmp = 0;
        for (int i = start = 2; i < stop; ++i) {
            if (array[i] == ',' && array[i + 1] == '\t') {
                intValues[elem++] = tmp;
                tmp = 0;
                ++i;
                continue;
            }
            tmp *= 10;
            if (array[i] >= '0' && array[i] <= '9') {
                tmp += array[i] - 48;
                continue;
            }
            throw new ProtocolException("Expected a digit in " + new String(array) + " at " + i);
        }
        intValues[elem] = tmp;
    }
}

