/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
abstract class GeneratedPhysicalConnection
extends OracleConnection {
    boolean autocommit;
    int commitOption;
    int ociConnectionPoolMinLimit;
    int ociConnectionPoolMaxLimit;
    int ociConnectionPoolIncrement;
    int ociConnectionPoolTimeout;
    boolean ociConnectionPoolNoWait;
    boolean ociConnectionPoolTransactionDistributed;
    String ociConnectionPoolLogonMode;
    boolean ociConnectionPoolIsPooling;
    Object ociConnectionPoolObject;
    Object ociConnectionPoolConnID;
    String ociConnectionPoolProxyType;
    Integer ociConnectionPoolProxyNumRoles;
    Object ociConnectionPoolProxyRoles;
    String ociConnectionPoolProxyUserName;
    OpaqueString ociConnectionPoolProxyPassword;
    String ociConnectionPoolProxyDistinguishedName;
    Object ociConnectionPoolProxyCertificate;
    boolean retainV9BindBehavior;
    String userName;
    OpaqueString newPasswordValue;
    String database;
    boolean defaultautocommit;
    boolean bindUseDBA;
    String protocol;
    int streamChunkSize;
    boolean setFloatAndDoubleUseBinary;
    String thinVsessionTerminal;
    String thinVsessionMachine;
    String thinVsessionOsuser;
    String thinVsessionProgram;
    String thinVsessionProcess;
    String thinVsessionIname;
    String thinVsessionEname;
    String thinNetProfile;
    String thinNetAuthenticationServices;
    String thinNetAuthenticationKrb5Mutual;
    String thinNetAuthenticationKrb5CcName;
    String thinNetAuthenticationKrbRealm;
    String thinNetSetFIPSMode;
    boolean thinNetAllowWeakCrypto;
    String thinNetEncryptionLevel;
    String thinNetEncryptionTypes;
    String thinNetChecksumLevel;
    String thinNetChecksumTypes;
    String thinNetCryptoSeed;
    boolean thinUseJCEAPI;
    boolean thinTcpNoDelay;
    String thinReadTimeout;
    String thinOutboundConnectTimeout;
    String thinNetConnectTimeout;
    boolean thinNetDisableOutOfBandBreak;
    boolean thinNetUseZeroCopyIO;
    boolean use1900AsYearForTime;
    boolean timestamptzInGmt;
    boolean timezoneAsRegion;
    String thinSslCertificateAlias;
    String thinSslServerDnMatch;
    String thinSslServerCertDn;
    String thinSslVersion;
    String thinSslCipherSuites;
    String thinJavaxNetSslKeystore;
    String thinJavaxNetSslKeystoretype;
    OpaqueString thinJavaxNetSslKeystorepassword;
    String thinJavaxNetSslTruststore;
    String thinJavaxNetSslTruststoretype;
    OpaqueString thinJavaxNetSslTruststorepassword;
    String thinSslKeymanagerfactoryAlgorithm;
    String thinSslTrustmanagerfactoryAlgorithm;
    String thinNetOldsyntax;
    String thinJndiLdapConnectTimeout;
    String thinJndiLdapReadTimeout;
    String walletLocation;
    OpaqueString walletPassword;
    String thinLdapSslCipherSuites;
    String thinLdapSslVersions;
    String thinLdapSslKeyStore;
    String thinLdapSslKeyStoreType;
    OpaqueString thinLdapSslKeyStorePwd;
    String thinLdapSslKeyManagerFactoryAlgo;
    String thinLdapSslTrustStore;
    String thinLdapSslTrustStoreType;
    OpaqueString thinLdapSslTrustStorePassword;
    String thinLdapSslTrustManagerFactoryAlgo;
    String thinLdapSslWalletLocation;
    OpaqueString thinLdapSslWalletPassword;
    String thinLdapSecurityAuthentication;
    String thinLdapSecurityPrincipal;
    OpaqueString thinLdapSecurityCredetials;
    String thinLdapsslContextProtocol;
    String proxyClientName;
    boolean useNio;
    String thinHttpsProxyHost;
    int thinHttpsProxyPort;
    String thinNetConnectionIdPrefix;
    String ociDriverCharset;
    String editionName;
    String logonCap;
    boolean useOCIDefaultDefines;
    String internalLogon;
    boolean createDescriptorUseCurrentSchemaForSchemaName;
    long ociSvcCtxHandle;
    long ociEnvHandle;
    long ociErrHandle;
    boolean prelimAuth;
    boolean jmsNotificationConnection;
    boolean nlsLangBackdoor;
    OpaqueString setNewPassword;
    int defaultExecuteBatch;
    int defaultRowPrefetch;
    int defaultLobPrefetchSize;
    boolean enableDataInLocator;
    boolean enableReadDataInLocator;
    boolean overrideEnableReadDataInLocator;
    boolean reportRemarks;
    boolean includeSynonyms;
    boolean restrictGettables;
    boolean accumulateBatchResult;
    boolean useFetchSizeWithLongColumn;
    boolean processEscapes;
    boolean fixedString;
    boolean defaultnchar;
    boolean permitTimestampDateMismatch;
    String resourceManagerId;
    boolean disableDefinecolumntype;
    boolean convertNcharLiterals;
    boolean autoCommitSpecCompliant;
    boolean jdbcStandardBehavior;
    boolean j2ee13Compliant;
    String dmsParentName;
    String dmsParentType;
    boolean dmsStmtMetrics;
    boolean dmsStmtCachingMetrics;
    boolean mapDateToTimestamp;
    boolean useThreadLocalBufferCache;
    String driverNameAttribute;
    int maxCachedBufferSize;
    int implicitStatementCacheSize;
    boolean lobStreamPosStandardCompliant;
    boolean isStrictAsciiConversion;
    boolean isQuickAsciiConversion;
    String drcpConnectionClass;
    String drcpTagName;
    String drcpConnectionPurity;
    boolean useDRCPMultipletag;
    String drcpPLSQLCallback;
    String blockSourceImpl;
    boolean thinForceDnsLoadBalancing;
    boolean enableTempLobRefCnt;
    boolean keepAlive;
    String sqlTranslationProfile;
    String sqlErrorTranslationFile;
    boolean ignoreReplayContextFromAuthentication;
    boolean javaNetNio;
    boolean nsDirectBuffer;
    boolean plsqlVarcharParameter4KOnly;
    String targetInstanceName;
    String targetServiceName;
    String targetShardingKey;
    String targetSuperShardingKey;
    boolean readOnlyInstanceAllowed;
    boolean enableOCIFAN;
    boolean isResultSetCacheEnabled_IGNORED;
    boolean isResultSetCacheEnabled_IGNORED2;
    boolean isResultSetCacheEnabled;
    boolean isOldUpdateableResultSet;
    String allowedLogonVersion;
    String commitOptionProperty;
    String calculateChecksumProperty;
    String javaNetLocalIPForMsgq;
    String javaNetMsgqTransport;
    int javaNetMsgqBusyWait;
    int javaNetMsgqKernelWait;
    int downHostsTimeout;
    boolean fanEnabled;
    String tnsAdmin;
    String networkCompression;
    String networkCompressionLevels;
    int networkCompressionThreshold;
    String configFile;
    String websocketUser;
    OpaqueString websocketPassword;
    String socksProxyHost;
    int socksProxyPort;
    boolean socksRemoteDNS;
    OracleConnection.ConnectionValidation defaultConnectionValidation;
    boolean enableACSupport;
    boolean enableTGSupport;
    boolean enableImplicitRequests;
    boolean drcpMultiplexingInRequestAPIs;
    boolean continueBatchOnError;
    int tcpKeepIdle;
    int tcpKeepInterval;
    boolean useShardingDriverConnection;
    int tcpKeepCount;
    int requestSizeLimit;
    String onsWalletFile;
    OpaqueString onsWalletPassword;
    String onsProtocol;
    int loginTimeout;
    boolean inbandNotification;
    String sslContextProtocol;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;

    GeneratedPhysicalConnection() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$19, null, new Object[0]);
            }
            this.ociConnectionPoolMinLimit = 0;
            this.ociConnectionPoolMaxLimit = 0;
            this.ociConnectionPoolIncrement = 0;
            this.ociConnectionPoolTimeout = 0;
            this.ociConnectionPoolNoWait = false;
            this.ociConnectionPoolTransactionDistributed = false;
            this.ociConnectionPoolLogonMode = null;
            this.ociConnectionPoolIsPooling = false;
            this.ociConnectionPoolObject = null;
            this.ociConnectionPoolConnID = null;
            this.ociConnectionPoolProxyType = null;
            this.ociConnectionPoolProxyNumRoles = 0;
            this.ociConnectionPoolProxyRoles = null;
            this.ociConnectionPoolProxyUserName = null;
            this.ociConnectionPoolProxyPassword = null;
            this.ociConnectionPoolProxyDistinguishedName = null;
            this.ociConnectionPoolProxyCertificate = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$19, null);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$19, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$19, null, throwable2);
            }
            throw throwable;
        }
    }

    GeneratedPhysicalConnection(Monitor.CloseableLock monitorLock) {
        super(monitorLock);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$20, null, monitorLock);
            }
            this.ociConnectionPoolMinLimit = 0;
            this.ociConnectionPoolMaxLimit = 0;
            this.ociConnectionPoolIncrement = 0;
            this.ociConnectionPoolTimeout = 0;
            this.ociConnectionPoolNoWait = false;
            this.ociConnectionPoolTransactionDistributed = false;
            this.ociConnectionPoolLogonMode = null;
            this.ociConnectionPoolIsPooling = false;
            this.ociConnectionPoolObject = null;
            this.ociConnectionPoolConnID = null;
            this.ociConnectionPoolProxyType = null;
            this.ociConnectionPoolProxyNumRoles = 0;
            this.ociConnectionPoolProxyRoles = null;
            this.ociConnectionPoolProxyUserName = null;
            this.ociConnectionPoolProxyPassword = null;
            this.ociConnectionPoolProxyDistinguishedName = null;
            this.ociConnectionPoolProxyCertificate = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$20, null);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$20, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$20, null, throwable2);
            }
            throw throwable;
        }
    }

    static String getSystemPropertyPollInterval() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$0, null, new Object[0]);
            }
            String string = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.TimeoutPollInterval", "1000");
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$0, null, string);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$0, null, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    static String getSystemPropertySqlTranslationProfile() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$1, null, new Object[0]);
            }
            String string = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.sqlTranslationProfile", null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$1, null, string);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$1, null, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    static String getSystemPropertyFastConnectionFailover(String string) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            String defaultValue;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$2, null, string);
            }
            String string2 = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.FastConnectionFailover", defaultValue);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$2, null, string2);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$2, null, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$2, null, throwable2);
            }
            throw throwable;
        }
    }

    static String getSystemPropertyUserName() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$3, null, new Object[0]);
            }
            String string = GeneratedPhysicalConnection.getSystemProperty("user.name", null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$3, null, string);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$3, null, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$3, null, throwable2);
            }
            throw throwable;
        }
    }

    static String getSystemPropertyTrace() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$4, null, new Object[0]);
            }
            String string = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.Trace", null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$4, null, string);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$4, null, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$4, null, throwable2);
            }
            throw throwable;
        }
    }

    static String getSystemPropertyDateZeroTime(String string) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            String defaultValue;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$5, null, string);
            }
            String string2 = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.DateZeroTime", defaultValue);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$5, null, string2);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$5, null, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$5, null, throwable2);
            }
            throw throwable;
        }
    }

    static String getSystemPropertyDateZeroTimeExtra(String string) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            String defaultValue;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$6, null, string);
            }
            String string2 = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.DateZeroTimeExtra", defaultValue);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$6, null, string2);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$6, null, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$6, null, throwable2);
            }
            throw throwable;
        }
    }

    static String getSystemPropertyConfigFile(String string) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            String defaultValue;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$7, null, string);
            }
            String string2 = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.config.file", defaultValue);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$7, null, string2);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$7, null, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$7, null, throwable2);
            }
            throw throwable;
        }
    }

    static String getSystemPropertyTnsAdmin(String string) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            String defaultValue;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$8, null, string);
            }
            String string2 = GeneratedPhysicalConnection.getSystemProperty("oracle.net.tns_admin", defaultValue);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$8, null, string2);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$8, null, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$8, null, throwable2);
            }
            throw throwable;
        }
    }

    static String getSystemPropertyDatabase(String string) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            String defaultValue;
            String database;
            String string2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$9, null, string);
            }
            String string3 = string2 = (database = GeneratedPhysicalConnection.getSystemProperty("database", null)) != null ? database : GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.database", defaultValue);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$9, null, string2);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$9, null, null);
            }
            return string3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$9, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String getSystemProperty(String string, String string2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void defaultValue;
            String str;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$10, null, string, string2);
            }
            if (str != null) {
                String string3 = AccessController.doPrivileged(new PrivilegedAction<String>((String)defaultValue){
                    final /* synthetic */ String val$defaultValue;
                    private static Executable $$$methodRef$$$0;
                    private static Logger $$$loggerRef$$$0;
                    private static Executable $$$methodRef$$$1;
                    private static Logger $$$loggerRef$$$1;
                    private static Executable $$$methodRef$$$2;
                    private static Logger $$$loggerRef$$$2;
                    {
                        this.val$defaultValue = string2;
                    }

                    @Override
                    public String run() {
                        return System.getProperty(str, this.val$defaultValue);
                    }

                    static {
                        try {
                            $$$methodRef$$$2 = 1.class.getDeclaredConstructor(String.class, String.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                        try {
                            $$$methodRef$$$1 = 1.class.getDeclaredMethod("run", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                        try {
                            $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    }
                });
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$10, null, string3);
                    ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$10, null, null);
                }
                return string3;
            }
            void var3_4 = defaultValue;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$10, null, var3_4);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$10, null, null);
            }
            return var3_4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$10, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readDeprecatedConnectionProperties(@Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void info;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$11, this, TraceControllerImpl.blind(PropertiesBlinder.class, properties));
            }
            this.includeSynonyms = this.parseConnectionProperty((Properties)info, "synonyms", (byte)3, this.includeSynonyms);
            this.reportRemarks = this.parseConnectionProperty((Properties)info, "remarks", (byte)3, this.reportRemarks);
            this.defaultRowPrefetch = this.parseConnectionProperty((Properties)info, "prefetch", (byte)3, this.defaultRowPrefetch);
            this.defaultRowPrefetch = this.parseConnectionProperty((Properties)info, "rowPrefetch", (byte)3, this.defaultRowPrefetch);
            this.defaultExecuteBatch = this.parseConnectionProperty((Properties)info, "batch", (byte)3, this.defaultExecuteBatch);
            this.defaultExecuteBatch = this.parseConnectionProperty((Properties)info, "executeBatch", (byte)3, this.defaultExecuteBatch);
            this.proxyClientName = this.parseConnectionProperty((Properties)info, "PROXY_CLIENT_NAME", (byte)1, this.proxyClientName);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String parseConnectionProperty(@Blind(value=PropertiesBlinder.class) Properties properties, String string, byte by, String string2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void name;
            void props;
            void mode;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$12, this, TraceControllerImpl.blind(PropertiesBlinder.class, properties), string, by, string2);
            }
            String ret = null;
            if (!(mode != true && mode != 3 || props == null || (ret = props.getProperty((String)name)) != null || name.startsWith("oracle.") || name.startsWith("java.") || name.startsWith("javax."))) {
                ret = props.getProperty("oracle.jdbc." + (String)name);
            }
            if (ret == null && (mode == 2 || mode == 3)) {
                ret = name.startsWith("oracle.") || name.startsWith("java.") || name.startsWith("javax.") ? GeneratedPhysicalConnection.getSystemProperty((String)name, null) : GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc." + (String)name, null);
            }
            if (ret == null) {
                void def;
                ret = def;
            }
            String string3 = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$12, this, string3);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$12, this, null);
            }
            return string3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int parseConnectionProperty(@Blind(value=PropertiesBlinder.class) Properties properties, String string, byte by, int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void mode;
            void name;
            void props;
            void def;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$13, this, TraceControllerImpl.blind(PropertiesBlinder.class, properties), string, by, n2);
            }
            int ret = def;
            String val = this.parseConnectionProperty((Properties)props, (String)name, (byte)mode, null);
            if (val != null) {
                try {
                    ret = Integer.parseInt(val);
                }
                catch (NumberFormatException nfe) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is '" + (String)name + "' and value is '" + val + "'").fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$13, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            void var9_11 = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$13, this, (int)var9_11);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$13, this, null);
            }
            return (int)var9_11;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private long parseConnectionProperty(@Blind(value=PropertiesBlinder.class) Properties properties, String string, byte by, long l2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void mode;
            void name;
            void props;
            void def;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$14, this, TraceControllerImpl.blind(PropertiesBlinder.class, properties), string, by, l2);
            }
            long ret = def;
            String val = this.parseConnectionProperty((Properties)props, (String)name, (byte)mode, null);
            if (val != null) {
                try {
                    ret = Long.parseLong(val);
                }
                catch (NumberFormatException nfe) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is '" + (String)name + "' and value is '" + val + "'").fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$14, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$14, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            void var11_11 = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$14, this, (long)var11_11);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$14, this, null);
            }
            return (long)var11_11;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean parseConnectionProperty(@Blind(value=PropertiesBlinder.class) Properties properties, String string, byte by, boolean bl) throws SQLException {
        boolean bl2 = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void mode;
            void name;
            void props;
            void def;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$15, this, TraceControllerImpl.blind(PropertiesBlinder.class, properties), string, by, bl);
            }
            boolean ret = def;
            String val = this.parseConnectionProperty((Properties)props, (String)name, (byte)mode, null);
            if (val != null) {
                if (val.equalsIgnoreCase("false")) {
                    ret = false;
                } else if (val.equalsIgnoreCase("true")) {
                    ret = true;
                }
            }
            void var8_8 = ret;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$15, this, (boolean)var8_8);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$15, this, null);
            }
            return (boolean)var8_8;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void readOCIConnectionPoolProperties(@Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void info;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$16, this, TraceControllerImpl.blind(PropertiesBlinder.class, properties));
            }
            this.ociConnectionPoolMinLimit = this.parseConnectionProperty((Properties)info, "connpool_min_limit", (byte)1, 0);
            this.ociConnectionPoolMaxLimit = this.parseConnectionProperty((Properties)info, "connpool_max_limit", (byte)1, 0);
            this.ociConnectionPoolIncrement = this.parseConnectionProperty((Properties)info, "connpool_increment", (byte)1, 0);
            this.ociConnectionPoolTimeout = this.parseConnectionProperty((Properties)info, "connpool_timeout", (byte)1, 0);
            this.ociConnectionPoolNoWait = this.parseConnectionProperty((Properties)info, "connpool_nowait", (byte)1, false);
            this.ociConnectionPoolTransactionDistributed = this.parseConnectionProperty((Properties)info, "transactions_distributed", (byte)1, false);
            this.ociConnectionPoolLogonMode = this.parseConnectionProperty((Properties)info, "connection_pool", (byte)1, null);
            this.ociConnectionPoolIsPooling = this.parseConnectionProperty((Properties)info, "is_connection_pooling", (byte)1, false);
            this.ociConnectionPoolObject = this.parseOCIConnectionPoolProperty((Properties)info, "connpool_object", null);
            this.ociConnectionPoolConnID = this.parseOCIConnectionPoolProperty((Properties)info, "connection_id", null);
            this.ociConnectionPoolProxyType = this.parseConnectionProperty((Properties)info, "proxytype", (byte)1, null);
            this.ociConnectionPoolProxyNumRoles = (Integer)this.parseOCIConnectionPoolProperty((Properties)info, "proxy_num_roles", 0);
            this.ociConnectionPoolProxyRoles = this.parseOCIConnectionPoolProperty((Properties)info, "proxy_roles", null);
            this.ociConnectionPoolProxyUserName = this.parseConnectionProperty((Properties)info, "proxy_user_name", (byte)1, null);
            this.ociConnectionPoolProxyPassword = OpaqueString.newOpaqueString(this.parseConnectionProperty((Properties)info, "proxy_password", (byte)1, null));
            this.ociConnectionPoolProxyDistinguishedName = this.parseConnectionProperty((Properties)info, "proxy_distinguished_name", (byte)1, null);
            this.ociConnectionPoolProxyCertificate = this.parseOCIConnectionPoolProperty((Properties)info, "proxy_certificate", null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$16, this);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$16, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Object parseOCIConnectionPoolProperty(@Blind(value=PropertiesBlinder.class) Properties properties, String string, Object object) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void name;
            Object val;
            void props;
            void def;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$17, this, TraceControllerImpl.blind(PropertiesBlinder.class, properties), string, object);
            }
            Object ret = def;
            if (props != null && (val = props.get(name)) != null) {
                ret = val;
            }
            void var7_7 = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$17, this, var7_7);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$17, this, null);
            }
            return var7_7;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void readConnectionProperties(String string, @Blind(value=PropertiesBlinder.class) Properties properties, @Blind(value=PropertiesBlinder.class) Properties properties2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void fromFile;
            void info;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$18, this, string, TraceControllerImpl.blind(PropertiesBlinder.class, properties), TraceControllerImpl.blind(PropertiesBlinder.class, properties2));
            }
            String tempval = null;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.RetainV9LongBindBehavior");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.RetainV9LongBindBehavior", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.RetainV9LongBindBehavior");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.retainV9BindBehavior = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("user")) == null) {
                tempval = info.getProperty("oracle.jdbc.user");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.user", null);
            }
            if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("user")) == null) {
                tempval = fromFile.getProperty("oracle.jdbc.user");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.userName = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.newPassword");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.newPasswordValue = OpaqueString.newOpaqueString(tempval);
            tempval = null;
            if (info != null && (tempval = info.getProperty("database")) == null) {
                tempval = info.getProperty("oracle.jdbc.database");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.database", null);
            }
            if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("database")) == null) {
                tempval = fromFile.getProperty("oracle.jdbc.database");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.database = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("autoCommit")) == null) {
                tempval = info.getProperty("oracle.jdbc.autoCommit");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.autoCommit", null);
            }
            if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("autoCommit")) == null) {
                tempval = fromFile.getProperty("oracle.jdbc.autoCommit");
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.defaultautocommit = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.bindUseDBA");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.bindUseDBA", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.bindUseDBA");
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.bindUseDBA = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("protocol")) == null) {
                tempval = info.getProperty("oracle.jdbc.protocol");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.protocol", null);
            }
            if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("protocol")) == null) {
                tempval = fromFile.getProperty("oracle.jdbc.protocol");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.protocol = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.StreamChunkSize");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.StreamChunkSize", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.StreamChunkSize");
            }
            if (tempval == null) {
                tempval = "32767";
            }
            try {
                this.streamChunkSize = Integer.parseInt(tempval);
            }
            catch (NumberFormatException nfe) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'streamChunkSize'").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$18, this, sQLException);
                }
                throw sQLException;
            }
            tempval = null;
            if (info != null && (tempval = info.getProperty("SetFloatAndDoubleUseBinary")) == null) {
                tempval = info.getProperty("oracle.jdbc.SetFloatAndDoubleUseBinary");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.SetFloatAndDoubleUseBinary", null);
            }
            if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("SetFloatAndDoubleUseBinary")) == null) {
                tempval = fromFile.getProperty("oracle.jdbc.SetFloatAndDoubleUseBinary");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.setFloatAndDoubleUseBinary = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("v$session.terminal")) == null) {
                tempval = info.getProperty("oracle.jdbc.v$session.terminal");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.v$session.terminal", null);
            }
            if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("v$session.terminal")) == null) {
                tempval = fromFile.getProperty("oracle.jdbc.v$session.terminal");
            }
            if (tempval == null) {
                tempval = "unknown";
            }
            this.thinVsessionTerminal = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("v$session.machine")) == null) {
                tempval = info.getProperty("oracle.jdbc.v$session.machine");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.v$session.machine", null);
            }
            if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("v$session.machine")) == null) {
                tempval = fromFile.getProperty("oracle.jdbc.v$session.machine");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinVsessionMachine = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("v$session.osuser")) == null) {
                tempval = info.getProperty("oracle.jdbc.v$session.osuser");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.v$session.osuser", null);
            }
            if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("v$session.osuser")) == null) {
                tempval = fromFile.getProperty("oracle.jdbc.v$session.osuser");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinVsessionOsuser = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("v$session.program")) == null) {
                tempval = info.getProperty("oracle.jdbc.v$session.program");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.v$session.program", null);
            }
            if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("v$session.program")) == null) {
                tempval = fromFile.getProperty("oracle.jdbc.v$session.program");
            }
            if (tempval == null) {
                tempval = "JDBC Thin Client";
            }
            this.thinVsessionProgram = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("v$session.process")) == null) {
                tempval = info.getProperty("oracle.jdbc.v$session.process");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.v$session.process", null);
            }
            if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("v$session.process")) == null) {
                tempval = fromFile.getProperty("oracle.jdbc.v$session.process");
            }
            if (tempval == null) {
                tempval = "1234";
            }
            this.thinVsessionProcess = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("v$session.iname")) == null) {
                tempval = info.getProperty("oracle.jdbc.v$session.iname");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.v$session.iname", null);
            }
            if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("v$session.iname")) == null) {
                tempval = fromFile.getProperty("oracle.jdbc.v$session.iname");
            }
            if (tempval == null) {
                tempval = "jdbc_ttc_impl";
            }
            this.thinVsessionIname = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("v$session.ename")) == null) {
                tempval = info.getProperty("oracle.jdbc.v$session.ename");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.v$session.ename", null);
            }
            if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("v$session.ename")) == null) {
                tempval = fromFile.getProperty("oracle.jdbc.v$session.ename");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinVsessionEname = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.profile");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.profile", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.profile");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNetProfile = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.authentication_services");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.authentication_services", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.authentication_services");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNetAuthenticationServices = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.kerberos5_mutual_authentication");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.kerberos5_mutual_authentication", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.kerberos5_mutual_authentication");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNetAuthenticationKrb5Mutual = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.kerberos5_cc_name");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.kerberos5_cc_name", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.kerberos5_cc_name");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNetAuthenticationKrb5CcName = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.KerberosRealm");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.KerberosRealm", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.KerberosRealm");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNetAuthenticationKrbRealm = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.setFIPSMode");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.setFIPSMode", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.setFIPSMode");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNetSetFIPSMode = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.allow_weak_crypto");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.allow_weak_crypto", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.allow_weak_crypto");
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.thinNetAllowWeakCrypto = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.encryption_client");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.encryption_client", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.encryption_client");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNetEncryptionLevel = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.encryption_types_client");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.encryption_types_client", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.encryption_types_client");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNetEncryptionTypes = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.crypto_checksum_client");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.crypto_checksum_client", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.crypto_checksum_client");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNetChecksumLevel = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.crypto_checksum_types_client");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.crypto_checksum_types_client", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.crypto_checksum_types_client");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNetChecksumTypes = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.crypto_seed");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.crypto_seed", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.crypto_seed");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNetCryptoSeed = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.useJCEAPI");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.useJCEAPI", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.useJCEAPI");
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.thinUseJCEAPI = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.TcpNoDelay");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.TcpNoDelay", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.TcpNoDelay");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.thinTcpNoDelay = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.ReadTimeout");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.ReadTimeout", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.ReadTimeout");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinReadTimeout = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.OUTBOUND_CONNECT_TIMEOUT");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.OUTBOUND_CONNECT_TIMEOUT", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.OUTBOUND_CONNECT_TIMEOUT");
            }
            if (tempval == null) {
                tempval = "0";
            }
            this.thinOutboundConnectTimeout = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.CONNECT_TIMEOUT");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.CONNECT_TIMEOUT", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.CONNECT_TIMEOUT");
            }
            if (tempval == null) {
                tempval = "0";
            }
            this.thinNetConnectTimeout = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.disableOob");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.disableOob", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.disableOob");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.thinNetDisableOutOfBandBreak = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.useZeroCopyIO");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.useZeroCopyIO", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.useZeroCopyIO");
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.thinNetUseZeroCopyIO = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.use1900AsYearForTime");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.use1900AsYearForTime", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.use1900AsYearForTime");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.use1900AsYearForTime = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.timestampTzInGmt");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.timestampTzInGmt", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.timestampTzInGmt");
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.timestamptzInGmt = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.timezoneAsRegion");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.timezoneAsRegion", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.timezoneAsRegion");
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.timezoneAsRegion = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.ssl_certificate_alias");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ssl_certificate_alias", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.ssl_certificate_alias");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinSslCertificateAlias = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.ssl_server_dn_match");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ssl_server_dn_match", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.ssl_server_dn_match");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinSslServerDnMatch = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.ssl_server_cert_dn");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ssl_server_cert_dn", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.ssl_server_cert_dn");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinSslServerCertDn = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.ssl_version");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ssl_version", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.ssl_version");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinSslVersion = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.ssl_cipher_suites");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ssl_cipher_suites", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.ssl_cipher_suites");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinSslCipherSuites = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("javax.net.ssl.keyStore");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("javax.net.ssl.keyStore", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("javax.net.ssl.keyStore");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinJavaxNetSslKeystore = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("javax.net.ssl.keyStoreType");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("javax.net.ssl.keyStoreType", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("javax.net.ssl.keyStoreType");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinJavaxNetSslKeystoretype = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("javax.net.ssl.keyStorePassword");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("javax.net.ssl.keyStorePassword", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("javax.net.ssl.keyStorePassword");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinJavaxNetSslKeystorepassword = OpaqueString.newOpaqueString(tempval);
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("javax.net.ssl.trustStore");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("javax.net.ssl.trustStore", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("javax.net.ssl.trustStore");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinJavaxNetSslTruststore = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("javax.net.ssl.trustStoreType");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("javax.net.ssl.trustStoreType", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("javax.net.ssl.trustStoreType");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinJavaxNetSslTruststoretype = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("javax.net.ssl.trustStorePassword");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("javax.net.ssl.trustStorePassword", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("javax.net.ssl.trustStorePassword");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinJavaxNetSslTruststorepassword = OpaqueString.newOpaqueString(tempval);
            tempval = null;
            if (info != null && (tempval = info.getProperty("ssl.keyManagerFactory.algorithm")) == null) {
                tempval = info.getProperty("oracle.jdbc.ssl.keyManagerFactory.algorithm");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.ssl.keyManagerFactory.algorithm", null);
            }
            if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("ssl.keyManagerFactory.algorithm")) == null) {
                tempval = fromFile.getProperty("oracle.jdbc.ssl.keyManagerFactory.algorithm");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinSslKeymanagerfactoryAlgorithm = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("ssl.trustManagerFactory.algorithm")) == null) {
                tempval = info.getProperty("oracle.jdbc.ssl.trustManagerFactory.algorithm");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.ssl.trustManagerFactory.algorithm", null);
            }
            if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("ssl.trustManagerFactory.algorithm")) == null) {
                tempval = fromFile.getProperty("oracle.jdbc.ssl.trustManagerFactory.algorithm");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinSslTrustmanagerfactoryAlgorithm = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.oldSyntax");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.oldSyntax", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.oldSyntax");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNetOldsyntax = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("com.sun.jndi.ldap.connect.timeout")) == null) {
                tempval = info.getProperty("oracle.jdbc.com.sun.jndi.ldap.connect.timeout");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.com.sun.jndi.ldap.connect.timeout", null);
            }
            if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("com.sun.jndi.ldap.connect.timeout")) == null) {
                tempval = fromFile.getProperty("oracle.jdbc.com.sun.jndi.ldap.connect.timeout");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinJndiLdapConnectTimeout = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("com.sun.jndi.ldap.read.timeout")) == null) {
                tempval = info.getProperty("oracle.jdbc.com.sun.jndi.ldap.read.timeout");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.com.sun.jndi.ldap.read.timeout", null);
            }
            if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("com.sun.jndi.ldap.read.timeout")) == null) {
                tempval = fromFile.getProperty("oracle.jdbc.com.sun.jndi.ldap.read.timeout");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinJndiLdapReadTimeout = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.wallet_location");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.wallet_location", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.wallet_location");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.walletLocation = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.wallet_password");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.wallet_password", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.wallet_password");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.walletPassword = OpaqueString.newOpaqueString(tempval);
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.ldap.ssl.supportedCiphers");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ldap.ssl.supportedCiphers", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.ldap.ssl.supportedCiphers");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinLdapSslCipherSuites = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.ldap.ssl.supportedVersions");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ldap.ssl.supportedVersions", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.ldap.ssl.supportedVersions");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinLdapSslVersions = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.ldap.ssl.keyStore");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ldap.ssl.keyStore", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.ldap.ssl.keyStore");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinLdapSslKeyStore = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.ldap.ssl.keyStoreType");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ldap.ssl.keyStoreType", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.ldap.ssl.keyStoreType");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinLdapSslKeyStoreType = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.ldap.ssl.keyStorePassword");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ldap.ssl.keyStorePassword", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.ldap.ssl.keyStorePassword");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinLdapSslKeyStorePwd = OpaqueString.newOpaqueString(tempval);
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.ldap.ssl.keyManagerFactory.algorithm");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ldap.ssl.keyManagerFactory.algorithm", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.ldap.ssl.keyManagerFactory.algorithm");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinLdapSslKeyManagerFactoryAlgo = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.ldap.ssl.trustStore");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ldap.ssl.trustStore", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.ldap.ssl.trustStore");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinLdapSslTrustStore = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.ldap.ssl.trustStoreType");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ldap.ssl.trustStoreType", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.ldap.ssl.trustStoreType");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinLdapSslTrustStoreType = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.ldap.ssl.trustStorePassword");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ldap.ssl.trustStorePassword", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.ldap.ssl.trustStorePassword");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinLdapSslTrustStorePassword = OpaqueString.newOpaqueString(tempval);
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.ldap.ssl.trustManagerFactory.algorithm");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ldap.ssl.trustManagerFactory.algorithm", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.ldap.ssl.trustManagerFactory.algorithm");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinLdapSslTrustManagerFactoryAlgo = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.ldap.ssl.walletLocation");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ldap.ssl.walletLocation", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.ldap.ssl.walletLocation");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinLdapSslWalletLocation = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.ldap.ssl.walletPassword");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ldap.ssl.walletPassword", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.ldap.ssl.walletPassword");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinLdapSslWalletPassword = OpaqueString.newOpaqueString(tempval);
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.ldap.security.authentication");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ldap.security.authentication", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.ldap.security.authentication");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinLdapSecurityAuthentication = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.ldap.security.principal");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ldap.security.principal", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.ldap.security.principal");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinLdapSecurityPrincipal = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.ldap.security.credentials");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ldap.security.credentials", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.ldap.security.credentials");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinLdapSecurityCredetials = OpaqueString.newOpaqueString(tempval);
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.ldap.ssl.ssl_context_protocol");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ldap.ssl.ssl_context_protocol", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.ldap.ssl.ssl_context_protocol");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinLdapsslContextProtocol = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.proxyClientName");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.proxyClientName", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.proxyClientName");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.proxyClientName = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.useNio");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.useNio", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.useNio");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.useNio = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.httpsProxyHost");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.httpsProxyHost", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.httpsProxyHost");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinHttpsProxyHost = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.httpsProxyPort");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.httpsProxyPort", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.httpsProxyPort");
            }
            if (tempval == null) {
                tempval = "0";
            }
            try {
                this.thinHttpsProxyPort = Integer.parseInt(tempval);
            }
            catch (NumberFormatException nfe) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'thinHttpsProxyPort'").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$18, this, sQLException);
                }
                throw sQLException;
            }
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.connectionIdPrefix");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.connectionIdPrefix", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.connectionIdPrefix");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNetConnectionIdPrefix = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("JDBCDriverCharSetId")) == null) {
                tempval = info.getProperty("oracle.jdbc.JDBCDriverCharSetId");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.JDBCDriverCharSetId", null);
            }
            if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("JDBCDriverCharSetId")) == null) {
                tempval = fromFile.getProperty("oracle.jdbc.JDBCDriverCharSetId");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.ociDriverCharset = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.editionName");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.editionName", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.editionName");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.editionName = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.thinLogonCapability");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.thinLogonCapability", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.thinLogonCapability");
            }
            if (tempval == null) {
                tempval = "o5";
            }
            this.logonCap = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.useOCIDefaultDefines");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.useOCIDefaultDefines", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.useOCIDefaultDefines");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.useOCIDefaultDefines = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("internal_logon")) == null) {
                tempval = info.getProperty("oracle.jdbc.internal_logon");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.internal_logon", null);
            }
            if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("internal_logon")) == null) {
                tempval = fromFile.getProperty("oracle.jdbc.internal_logon");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.internalLogon = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.createDescriptorUseCurrentSchemaForSchemaName");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.createDescriptorUseCurrentSchemaForSchemaName", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.createDescriptorUseCurrentSchemaForSchemaName");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.createDescriptorUseCurrentSchemaForSchemaName = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("OCISvcCtxHandle")) == null) {
                tempval = info.getProperty("oracle.jdbc.OCISvcCtxHandle");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.OCISvcCtxHandle", null);
            }
            if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("OCISvcCtxHandle")) == null) {
                tempval = fromFile.getProperty("oracle.jdbc.OCISvcCtxHandle");
            }
            if (tempval == null) {
                tempval = "0";
            }
            try {
                this.ociSvcCtxHandle = Long.parseLong(tempval);
            }
            catch (NumberFormatException nfe) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'ociSvcCtxHandle'").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$18, this, sQLException);
                }
                throw sQLException;
            }
            tempval = null;
            if (info != null && (tempval = info.getProperty("OCIEnvHandle")) == null) {
                tempval = info.getProperty("oracle.jdbc.OCIEnvHandle");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.OCIEnvHandle", null);
            }
            if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("OCIEnvHandle")) == null) {
                tempval = fromFile.getProperty("oracle.jdbc.OCIEnvHandle");
            }
            if (tempval == null) {
                tempval = "0";
            }
            try {
                this.ociEnvHandle = Long.parseLong(tempval);
            }
            catch (NumberFormatException nfe) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'ociEnvHandle'").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$18, this, sQLException);
                }
                throw sQLException;
            }
            tempval = null;
            if (info != null && (tempval = info.getProperty("OCIErrHandle")) == null) {
                tempval = info.getProperty("oracle.jdbc.OCIErrHandle");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.OCIErrHandle", null);
            }
            if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("OCIErrHandle")) == null) {
                tempval = fromFile.getProperty("oracle.jdbc.OCIErrHandle");
            }
            if (tempval == null) {
                tempval = "0";
            }
            try {
                this.ociErrHandle = Long.parseLong(tempval);
            }
            catch (NumberFormatException nfe) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'ociErrHandle'").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$18, this, sQLException);
                }
                throw sQLException;
            }
            tempval = null;
            if (info != null && (tempval = info.getProperty("prelim_auth")) == null) {
                tempval = info.getProperty("oracle.jdbc.prelim_auth");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.prelim_auth", null);
            }
            if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("prelim_auth")) == null) {
                tempval = fromFile.getProperty("oracle.jdbc.prelim_auth");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.prelimAuth = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.jmsNotification");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.jmsNotification", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.jmsNotification");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.jmsNotificationConnection = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.ociNlsLangBackwardCompatible");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.ociNlsLangBackwardCompatible", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.ociNlsLangBackwardCompatible");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.nlsLangBackdoor = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("OCINewPassword")) == null) {
                tempval = info.getProperty("oracle.jdbc.OCINewPassword");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.OCINewPassword", null);
            }
            if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("OCINewPassword")) == null) {
                tempval = fromFile.getProperty("oracle.jdbc.OCINewPassword");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.setNewPassword = OpaqueString.newOpaqueString(tempval);
            tempval = null;
            if (info != null && (tempval = info.getProperty("defaultExecuteBatch")) == null) {
                tempval = info.getProperty("oracle.jdbc.defaultExecuteBatch");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.defaultExecuteBatch", null);
            }
            if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("defaultExecuteBatch")) == null) {
                tempval = fromFile.getProperty("oracle.jdbc.defaultExecuteBatch");
            }
            if (tempval == null) {
                tempval = "1";
            }
            try {
                this.defaultExecuteBatch = Integer.parseInt(tempval);
            }
            catch (NumberFormatException nfe) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'defaultExecuteBatch'").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$18, this, sQLException);
                }
                throw sQLException;
            }
            tempval = null;
            if (info != null && (tempval = info.getProperty("defaultRowPrefetch")) == null) {
                tempval = info.getProperty("oracle.jdbc.defaultRowPrefetch");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.defaultRowPrefetch", null);
            }
            if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("defaultRowPrefetch")) == null) {
                tempval = fromFile.getProperty("oracle.jdbc.defaultRowPrefetch");
            }
            if (tempval == null) {
                tempval = "10";
            }
            try {
                this.defaultRowPrefetch = Integer.parseInt(tempval);
            }
            catch (NumberFormatException nfe) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'defaultRowPrefetch'").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$18, this, sQLException);
                }
                throw sQLException;
            }
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.defaultLobPrefetchSize");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.defaultLobPrefetchSize", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.defaultLobPrefetchSize");
            }
            if (tempval == null) {
                tempval = "32768";
            }
            try {
                this.defaultLobPrefetchSize = Integer.parseInt(tempval);
            }
            catch (NumberFormatException nfe) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'defaultLobPrefetchSize'").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$18, this, sQLException);
                }
                throw sQLException;
            }
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.enableDataInLocator");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.enableDataInLocator", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.enableDataInLocator");
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.enableDataInLocator = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.enableReadDataInLocator");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.enableReadDataInLocator", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.enableReadDataInLocator");
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.enableReadDataInLocator = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.overrideEnableReadDataInLocator");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.overrideEnableReadDataInLocator", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.overrideEnableReadDataInLocator");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.overrideEnableReadDataInLocator = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("remarksReporting")) == null) {
                tempval = info.getProperty("oracle.jdbc.remarksReporting");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.remarksReporting", null);
            }
            if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("remarksReporting")) == null) {
                tempval = fromFile.getProperty("oracle.jdbc.remarksReporting");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.reportRemarks = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("includeSynonyms")) == null) {
                tempval = info.getProperty("oracle.jdbc.includeSynonyms");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.includeSynonyms", null);
            }
            if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("includeSynonyms")) == null) {
                tempval = fromFile.getProperty("oracle.jdbc.includeSynonyms");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.includeSynonyms = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("restrictGetTables")) == null) {
                tempval = info.getProperty("oracle.jdbc.restrictGetTables");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.restrictGetTables", null);
            }
            if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("restrictGetTables")) == null) {
                tempval = fromFile.getProperty("oracle.jdbc.restrictGetTables");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.restrictGettables = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("AccumulateBatchResult")) == null) {
                tempval = info.getProperty("oracle.jdbc.AccumulateBatchResult");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.AccumulateBatchResult", null);
            }
            if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("AccumulateBatchResult")) == null) {
                tempval = fromFile.getProperty("oracle.jdbc.AccumulateBatchResult");
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.accumulateBatchResult = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("useFetchSizeWithLongColumn")) == null) {
                tempval = info.getProperty("oracle.jdbc.useFetchSizeWithLongColumn");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.useFetchSizeWithLongColumn", null);
            }
            if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("useFetchSizeWithLongColumn")) == null) {
                tempval = fromFile.getProperty("oracle.jdbc.useFetchSizeWithLongColumn");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.useFetchSizeWithLongColumn = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("processEscapes")) == null) {
                tempval = info.getProperty("oracle.jdbc.processEscapes");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.processEscapes", null);
            }
            if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("processEscapes")) == null) {
                tempval = fromFile.getProperty("oracle.jdbc.processEscapes");
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.processEscapes = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("fixedString")) == null) {
                tempval = info.getProperty("oracle.jdbc.fixedString");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.fixedString", null);
            }
            if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("fixedString")) == null) {
                tempval = fromFile.getProperty("oracle.jdbc.fixedString");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.fixedString = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("defaultNChar")) == null) {
                tempval = info.getProperty("oracle.jdbc.defaultNChar");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.defaultNChar", null);
            }
            if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("defaultNChar")) == null) {
                tempval = fromFile.getProperty("oracle.jdbc.defaultNChar");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.defaultnchar = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.internal.permitBindDateDefineTimestampMismatch");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.internal.permitBindDateDefineTimestampMismatch", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.internal.permitBindDateDefineTimestampMismatch");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.permitTimestampDateMismatch = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("RessourceManagerId")) == null) {
                tempval = info.getProperty("oracle.jdbc.RessourceManagerId");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.RessourceManagerId", null);
            }
            if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("RessourceManagerId")) == null) {
                tempval = fromFile.getProperty("oracle.jdbc.RessourceManagerId");
            }
            if (tempval == null) {
                tempval = "0000";
            }
            this.resourceManagerId = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("disableDefineColumnType")) == null) {
                tempval = info.getProperty("oracle.jdbc.disableDefineColumnType");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.disableDefineColumnType", null);
            }
            if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("disableDefineColumnType")) == null) {
                tempval = fromFile.getProperty("oracle.jdbc.disableDefineColumnType");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.disableDefinecolumntype = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.convertNcharLiterals");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.convertNcharLiterals", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.convertNcharLiterals");
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.convertNcharLiterals = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.autoCommitSpecCompliant");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.autoCommitSpecCompliant", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.autoCommitSpecCompliant");
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.autoCommitSpecCompliant = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.JDBCStandardBehavior");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.JDBCStandardBehavior", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.JDBCStandardBehavior");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.jdbcStandardBehavior = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.J2EE13Compliant");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.J2EE13Compliant", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.J2EE13Compliant");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.j2ee13Compliant = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("DMSName")) == null) {
                tempval = info.getProperty("oracle.jdbc.DMSName");
            }
            if (tempval == null) {
                tempval = "Driver";
            }
            this.dmsParentName = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("DMSType")) == null) {
                tempval = info.getProperty("oracle.jdbc.DMSType");
            }
            if (tempval == null) {
                tempval = "JDBC_Driver";
            }
            this.dmsParentType = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.DMSStatementMetrics");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.dmsStmtMetrics = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.DMSStatementCachingMetrics");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.dmsStmtCachingMetrics = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.mapDateToTimestamp");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.mapDateToTimestamp", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.mapDateToTimestamp");
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.mapDateToTimestamp = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.useThreadLocalBufferCache");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.useThreadLocalBufferCache", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.useThreadLocalBufferCache");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.useThreadLocalBufferCache = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.driverNameAttribute");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.driverNameAttribute", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.driverNameAttribute");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.driverNameAttribute = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.maxCachedBufferSize");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.maxCachedBufferSize", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.maxCachedBufferSize");
            }
            if (tempval == null) {
                tempval = "30";
            }
            try {
                this.maxCachedBufferSize = Integer.parseInt(tempval);
            }
            catch (NumberFormatException nfe) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'maxCachedBufferSize'").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$18, this, sQLException);
                }
                throw sQLException;
            }
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.implicitStatementCacheSize");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.implicitStatementCacheSize", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.implicitStatementCacheSize");
            }
            if (tempval == null) {
                tempval = "0";
            }
            try {
                this.implicitStatementCacheSize = Integer.parseInt(tempval);
            }
            catch (NumberFormatException nfe) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'implicitStatementCacheSize'").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$18, this, sQLException);
                }
                throw sQLException;
            }
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.LobStreamPosStandardCompliant");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.LobStreamPosStandardCompliant", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.LobStreamPosStandardCompliant");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.lobStreamPosStandardCompliant = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.strictASCIIConversion");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.strictASCIIConversion", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.strictASCIIConversion");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.isStrictAsciiConversion = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.quickASCIIConversion");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.quickASCIIConversion", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.quickASCIIConversion");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.isQuickAsciiConversion = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.DRCPConnectionClass");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.DRCPConnectionClass", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.DRCPConnectionClass");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.drcpConnectionClass = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.DRCPTagName");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.drcpTagName = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.DRCPConnectionPurity");
            }
            if (tempval == null) {
                tempval = "SELF";
            }
            this.drcpConnectionPurity = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.UseDRCPMultipletag");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.useDRCPMultipletag = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.DRCPPLSQLCallback");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.drcpPLSQLCallback = tempval;
            tempval = null;
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.blockSourceImplementation", null);
            }
            if (tempval == null) {
                tempval = "THREADED";
            }
            this.blockSourceImpl = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.thinForceDNSLoadBalancing");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.thinForceDNSLoadBalancing", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.thinForceDNSLoadBalancing");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.thinForceDnsLoadBalancing = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.enableTempLobRefCnt");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.enableTempLobRefCnt", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.enableTempLobRefCnt");
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.enableTempLobRefCnt = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.keepAlive");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.keepAlive", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.keepAlive");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.keepAlive = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.sqlTranslationProfile");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.sqlTranslationProfile", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.sqlTranslationProfile = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.sqlErrorTranslationFile");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.sqlErrorTranslationFile", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.sqlErrorTranslationFile = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.ignoreReplayContextFromAuthentication");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.ignoreReplayContextFromAuthentication = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.javaNetNio");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.javaNetNio", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.javaNetNio");
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.javaNetNio = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.nsDirectBuffer");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.nsDirectBuffer", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.nsDirectBuffer");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.nsDirectBuffer = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.plsqlVarcharParameter4KOnly");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.plsqlVarcharParameter4KOnly", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.plsqlVarcharParameter4KOnly");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.plsqlVarcharParameter4KOnly = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.targetInstanceName");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.targetInstanceName", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.targetInstanceName");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.targetInstanceName = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.targetServiceName");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.targetServiceName = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.targetShardingKey");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.targetShardingKey = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.targetSuperShardingKey");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.targetSuperShardingKey = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.readOnlyInstanceAllowed");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.readOnlyInstanceAllowed", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.readOnlyInstanceAllowed");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.readOnlyInstanceAllowed = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.enableOCIFastApplicationNotification");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.enableOCIFastApplicationNotification", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.enableOCIFastApplicationNotification");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.enableOCIFAN = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.enableResultSetCache");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.enableResultSetCache", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.enableResultSetCache");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.isResultSetCacheEnabled_IGNORED = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.enableResultSetCache");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.enableResultSetCache", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.enableResultSetCache");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.isResultSetCacheEnabled_IGNORED2 = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.enableQueryResultCache");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.enableQueryResultCache", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.enableQueryResultCache");
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.isResultSetCacheEnabled = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.backwardCompatibileUpdateableResultSet");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.backwardCompatibileUpdateableResultSet", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.backwardCompatibileUpdateableResultSet");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.isOldUpdateableResultSet = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.allowedLogonVersion");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.allowedLogonVersion", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.allowedLogonVersion");
            }
            if (tempval == null) {
                tempval = "8";
            }
            this.allowedLogonVersion = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.commitOption");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.commitOption", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.commitOption");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.commitOptionProperty = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.calculateChecksum");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.calculateChecksum", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.calculateChecksum");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.calculateChecksumProperty = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.javaNetLocalIPForMsgq");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.javaNetLocalIPForMsgq", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.javaNetLocalIPForMsgq");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.javaNetLocalIPForMsgq = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.javaNetMsgqTransport");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.javaNetMsgqTransport", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.javaNetMsgqTransport");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.javaNetMsgqTransport = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.javaNetMsgqBusyWait");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.javaNetMsgqBusyWait", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.javaNetMsgqBusyWait");
            }
            if (tempval == null) {
                tempval = "40";
            }
            try {
                this.javaNetMsgqBusyWait = Integer.parseInt(tempval);
            }
            catch (NumberFormatException nfe) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'javaNetMsgqBusyWait'").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$18, this, sQLException);
                }
                throw sQLException;
            }
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.javaNetMsgqKernelWait");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.javaNetMsgqKernelWait", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.javaNetMsgqKernelWait");
            }
            if (tempval == null) {
                tempval = "50";
            }
            try {
                this.javaNetMsgqKernelWait = Integer.parseInt(tempval);
            }
            catch (NumberFormatException nfe) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'javaNetMsgqKernelWait'").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$18, this, sQLException);
                }
                throw sQLException;
            }
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.DOWN_HOSTS_TIMEOUT");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.DOWN_HOSTS_TIMEOUT", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.DOWN_HOSTS_TIMEOUT");
            }
            if (tempval == null) {
                tempval = "600";
            }
            try {
                this.downHostsTimeout = Integer.parseInt(tempval);
            }
            catch (NumberFormatException nfe) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'downHostsTimeout'").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$18, this, sQLException);
                }
                throw sQLException;
            }
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.fanEnabled");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.fanEnabled", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.fanEnabled");
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.fanEnabled = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.tns_admin");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.tns_admin", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.tns_admin");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.tnsAdmin = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.networkCompression");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.networkCompression", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.networkCompression");
            }
            if (tempval == null) {
                tempval = "off";
            }
            this.networkCompression = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.networkCompressionLevels");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.networkCompressionLevels", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.networkCompressionLevels");
            }
            if (tempval == null) {
                tempval = "(high)";
            }
            this.networkCompressionLevels = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.networkCompressionThreshold");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.networkCompressionThreshold", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.networkCompressionThreshold");
            }
            if (tempval == null) {
                tempval = "1024";
            }
            try {
                this.networkCompressionThreshold = Integer.parseInt(tempval);
            }
            catch (NumberFormatException nfe) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'networkCompressionThreshold'").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$18, this, sQLException);
                }
                throw sQLException;
            }
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.config.file");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.config.file", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.configFile = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.websocketUser");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.websocketUser", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.websocketUser");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.websocketUser = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.websocketPassword");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.websocketPassword", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.websocketPassword");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.websocketPassword = OpaqueString.newOpaqueString(tempval);
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.socksProxyHost");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.socksProxyHost", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.socksProxyHost");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.socksProxyHost = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.socksProxyPort");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.socksProxyPort", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.socksProxyPort");
            }
            if (tempval == null) {
                tempval = "1080";
            }
            try {
                this.socksProxyPort = Integer.parseInt(tempval);
            }
            catch (NumberFormatException nfe) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'socksProxyPort'").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$18, this, sQLException);
                }
                throw sQLException;
            }
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.socksRemoteDNS");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.socksRemoteDNS", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.socksRemoteDNS");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.socksRemoteDNS = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.defaultConnectionValidation");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.defaultConnectionValidation", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.defaultConnectionValidation");
            }
            if (tempval == null) {
                tempval = "NETWORK";
            }
            try {
                this.defaultConnectionValidation = OracleConnection.ConnectionValidation.valueOf(tempval);
            }
            catch (IllegalArgumentException ex) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'defaultConnectionValidation'").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$18, this, sQLException);
                }
                throw sQLException;
            }
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.enableACSupport");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.enableACSupport", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.enableACSupport");
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.enableACSupport = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.enableTGSupport");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.enableTGSupport", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.enableTGSupport");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.enableTGSupport = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.enableImplicitRequests");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.enableImplicitRequests", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.enableImplicitRequests");
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.enableImplicitRequests = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.DRCPMultiplexingInRequestAPIs");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.DRCPMultiplexingInRequestAPIs", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.DRCPMultiplexingInRequestAPIs");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.drcpMultiplexingInRequestAPIs = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.continueBatchOnError");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.continueBatchOnError", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.continueBatchOnError");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.continueBatchOnError = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.TCP_KEEPIDLE");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.TCP_KEEPIDLE", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.TCP_KEEPIDLE");
            }
            if (tempval == null) {
                tempval = "-1";
            }
            try {
                this.tcpKeepIdle = Integer.parseInt(tempval);
            }
            catch (NumberFormatException nfe) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'tcpKeepIdle'").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$18, this, sQLException);
                }
                throw sQLException;
            }
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.TCP_KEEPINTERVAL");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.TCP_KEEPINTERVAL", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.TCP_KEEPINTERVAL");
            }
            if (tempval == null) {
                tempval = "-1";
            }
            try {
                this.tcpKeepInterval = Integer.parseInt(tempval);
            }
            catch (NumberFormatException nfe) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'tcpKeepInterval'").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$18, this, sQLException);
                }
                throw sQLException;
            }
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.useShardingDriverConnection");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.useShardingDriverConnection", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.useShardingDriverConnection");
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.useShardingDriverConnection = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.TCP_KEEPCOUNT");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.TCP_KEEPCOUNT", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.TCP_KEEPCOUNT");
            }
            if (tempval == null) {
                tempval = "-1";
            }
            try {
                this.tcpKeepCount = Integer.parseInt(tempval);
            }
            catch (NumberFormatException nfe) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'tcpKeepCount'").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$18, this, sQLException);
                }
                throw sQLException;
            }
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.replay.protectedRequestSizeLimit");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.replay.protectedRequestSizeLimit", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.replay.protectedRequestSizeLimit");
            }
            if (tempval == null) {
                tempval = "2147483647";
            }
            try {
                this.requestSizeLimit = Integer.parseInt(tempval);
            }
            catch (NumberFormatException nfe) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'requestSizeLimit'").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$18, this, sQLException);
                }
                throw sQLException;
            }
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.ons.walletfile");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.ons.walletfile", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.ons.walletfile");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.onsWalletFile = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.ons.walletpassword");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.ons.walletpassword", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.ons.walletpassword");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.onsWalletPassword = OpaqueString.newOpaqueString(tempval);
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.ons.protocol");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.ons.protocol", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.ons.protocol");
            }
            if (tempval == null) {
                tempval = "TCP";
            }
            this.onsProtocol = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.loginTimeout");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.loginTimeout", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.loginTimeout");
            }
            if (tempval == null) {
                tempval = "0";
            }
            try {
                this.loginTimeout = Integer.parseInt(tempval);
            }
            catch (NumberFormatException nfe) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'loginTimeout'").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$18, this, sQLException);
                }
                throw sQLException;
            }
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.inbandNotification");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.inbandNotification", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.jdbc.inbandNotification");
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.inbandNotification = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.ssl_context_protocol");
            }
            if (tempval == null) {
                tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ssl_context_protocol", null);
            }
            if (tempval == null && fromFile != null) {
                tempval = fromFile.getProperty("oracle.net.ssl_context_protocol");
            }
            if (tempval == null) {
                tempval = "TLS";
            }
            this.sslContextProtocol = tempval;
            this.readDeprecatedConnectionProperties((Properties)info);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$18, this);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$18, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, GeneratedPhysicalConnection.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$20 = GeneratedPhysicalConnection.class.getDeclaredConstructor(Monitor.CloseableLock.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = GeneratedPhysicalConnection.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = GeneratedPhysicalConnection.class.getDeclaredMethod("readConnectionProperties", String.class, Properties.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = GeneratedPhysicalConnection.class.getDeclaredMethod("parseOCIConnectionPoolProperty", Properties.class, String.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = GeneratedPhysicalConnection.class.getDeclaredMethod("readOCIConnectionPoolProperties", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = GeneratedPhysicalConnection.class.getDeclaredMethod("parseConnectionProperty", Properties.class, String.class, Byte.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = GeneratedPhysicalConnection.class.getDeclaredMethod("parseConnectionProperty", Properties.class, String.class, Byte.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = GeneratedPhysicalConnection.class.getDeclaredMethod("parseConnectionProperty", Properties.class, String.class, Byte.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = GeneratedPhysicalConnection.class.getDeclaredMethod("parseConnectionProperty", Properties.class, String.class, Byte.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = GeneratedPhysicalConnection.class.getDeclaredMethod("readDeprecatedConnectionProperties", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = GeneratedPhysicalConnection.class.getDeclaredMethod("getSystemProperty", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = GeneratedPhysicalConnection.class.getDeclaredMethod("getSystemPropertyDatabase", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = GeneratedPhysicalConnection.class.getDeclaredMethod("getSystemPropertyTnsAdmin", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = GeneratedPhysicalConnection.class.getDeclaredMethod("getSystemPropertyConfigFile", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = GeneratedPhysicalConnection.class.getDeclaredMethod("getSystemPropertyDateZeroTimeExtra", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = GeneratedPhysicalConnection.class.getDeclaredMethod("getSystemPropertyDateZeroTime", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = GeneratedPhysicalConnection.class.getDeclaredMethod("getSystemPropertyTrace", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = GeneratedPhysicalConnection.class.getDeclaredMethod("getSystemPropertyUserName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = GeneratedPhysicalConnection.class.getDeclaredMethod("getSystemPropertyFastConnectionFailover", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = GeneratedPhysicalConnection.class.getDeclaredMethod("getSystemPropertySqlTranslationProfile", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = GeneratedPhysicalConnection.class.getDeclaredMethod("getSystemPropertyPollInterval", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

