/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Executable;
import java.net.SocketException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import oracle.jdbc.diagnostics.SecuredLogger;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.net.ns.NetException;
import oracle.net.nt.AsyncOutboundTimeoutHandler;
import oracle.net.nt.ConnOption;
import oracle.net.nt.ConnectDescription;
import oracle.net.nt.DownHostsCache;
import oracle.net.nt.TimeoutInterruptHandler;
import oracle.net.resolver.EnvVariableResolver;
import oracle.net.resolver.TimeUnitSuffixUtility;

public class ConnStrategy {
    static final boolean DEBUG = false;
    private boolean optFound = false;
    public boolean reuseOpt = false;
    private ConnOption copt;
    public int sdu;
    public int tdu;
    public int nextOptToTry = 0;
    public Properties socketOptions = new Properties();
    private String osuser;
    private String programName;
    public int retryCount = 0;
    private int lastRetryCounter = 0;
    private int lastRetryConnectDescription = 0;
    private final Properties userProp;
    private ConnectDescription currentDescription;
    private ArrayList<ConnectDescription> descriptionList = new ArrayList(4);
    private final SecuredLogger securedLogger;
    private final SSLContext sslContext;
    private int outboundConnectTimeout = 0;
    private String connectionIdPrefix;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;

    public ConnStrategy(@Blind(value=PropertiesBlinder.class) Properties up) {
        this(up, null, SecuredLogger.noOpLogger());
    }

    public ConnStrategy(@Blind(value=PropertiesBlinder.class) Properties up, SSLContext sslContext, SecuredLogger securedLogger) {
        this.osuser = up.getProperty("oracle.jdbc.v$session.osuser");
        this.programName = up.getProperty("oracle.jdbc.v$session.program");
        DownHostsCache.DOWN_HOSTS_TIMEOUT = Integer.parseInt(up.getProperty("oracle.net.DOWN_HOSTS_TIMEOUT", "600"));
        this.userProp = up;
        this.createSocketOptions(up);
        this.sslContext = sslContext;
        this.securedLogger = securedLogger;
        if (securedLogger != null) {
            this.socketOptions.put((Object)32, securedLogger.getId());
        }
    }

    public String getOSUsername() {
        return this.osuser;
    }

    public String getProgramName() {
        return this.programName;
    }

    public void createSocketOptions(@Blind(value=PropertiesBlinder.class) Properties up) {
        ConnStrategy.createSocketOptions(up, this.socketOptions, !this.reuseOpt);
    }

    static void createSocketOptions(@Blind(value=PropertiesBlinder.class) Properties up, @Blind(value=PropertiesBlinder.class) Properties socketOptions) {
        ConnStrategy.createSocketOptions(up, socketOptions, true);
    }

    static void createSocketOptions(@Blind(value=PropertiesBlinder.class) Properties up, @Blind(value=PropertiesBlinder.class) Properties socketOptions, boolean setDefaultNoDelay) {
        String propertyKey = null;
        String propertyValue = null;
        boolean tcpNoDelayParam = false;
        Enumeration<Object> e2 = up.keys();
        while (e2.hasMoreElements()) {
            Object password;
            propertyKey = (String)e2.nextElement();
            if (propertyKey.equalsIgnoreCase("TCP.NODELAY")) {
                tcpNoDelayParam = true;
                propertyValue = up.getProperty("TCP.NODELAY").toUpperCase();
                if (propertyValue.equals("NO")) {
                    socketOptions.put((Object)0, "NO");
                    continue;
                }
                socketOptions.put((Object)0, "YES");
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.READ_TIMEOUT")) {
                propertyValue = up.getProperty("oracle.net.READ_TIMEOUT");
                socketOptions.put((Object)3, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.CONNECT_TIMEOUT")) {
                propertyValue = up.getProperty("oracle.net.CONNECT_TIMEOUT");
                socketOptions.put((Object)2, String.valueOf(TimeUnitSuffixUtility.getTimeInMilliseconds(propertyValue, false, 0)));
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ssl_server_dn_match")) {
                propertyValue = up.getProperty("oracle.net.ssl_server_dn_match");
                socketOptions.put((Object)4, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ssl_server_cert_dn")) {
                propertyValue = up.getProperty("oracle.net.ssl_server_cert_dn");
                socketOptions.put((Object)28, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.wallet_location")) {
                propertyValue = up.getProperty("oracle.net.wallet_location");
                socketOptions.put((Object)5, EnvVariableResolver.resolveEnvPlaceHolders(propertyValue, up));
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.wallet_password")) {
                password = up.get("oracle.net.wallet_password");
                socketOptions.put((Object)16, password instanceof String ? OpaqueString.newOpaqueString((String)password) : (OpaqueString)password);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ssl_version")) {
                propertyValue = up.getProperty("oracle.net.ssl_version");
                socketOptions.put((Object)6, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ssl_cipher_suites")) {
                propertyValue = up.getProperty("oracle.net.ssl_cipher_suites");
                socketOptions.put((Object)7, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("javax.net.ssl.keyStore")) {
                propertyValue = up.getProperty("javax.net.ssl.keyStore");
                socketOptions.put((Object)8, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("javax.net.ssl.keyStoreType")) {
                propertyValue = up.getProperty("javax.net.ssl.keyStoreType");
                socketOptions.put((Object)9, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("javax.net.ssl.keyStorePassword")) {
                password = up.get("javax.net.ssl.keyStorePassword");
                socketOptions.put((Object)10, password instanceof String ? OpaqueString.newOpaqueString((String)password) : (OpaqueString)password);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("javax.net.ssl.trustStore")) {
                propertyValue = up.getProperty("javax.net.ssl.trustStore");
                socketOptions.put((Object)11, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("javax.net.ssl.trustStoreType")) {
                propertyValue = up.getProperty("javax.net.ssl.trustStoreType");
                socketOptions.put((Object)12, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("javax.net.ssl.trustStorePassword")) {
                password = up.get("javax.net.ssl.trustStorePassword");
                socketOptions.put((Object)13, password instanceof String ? OpaqueString.newOpaqueString((String)password) : (OpaqueString)password);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("ssl.keyManagerFactory.algorithm")) {
                propertyValue = up.getProperty("ssl.keyManagerFactory.algorithm");
                socketOptions.put((Object)14, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("FORCE_DNS_LOAD_BALANCING")) {
                propertyValue = up.getProperty("FORCE_DNS_LOAD_BALANCING");
                socketOptions.put((Object)18, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.keepAlive")) {
                propertyValue = up.getProperty("oracle.net.keepAlive");
                if (Boolean.parseBoolean(propertyValue)) {
                    socketOptions.put((Object)1, "YES");
                    continue;
                }
                socketOptions.put((Object)1, "NO");
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.jdbc.useNio")) {
                propertyValue = up.getProperty("oracle.jdbc.useNio");
                socketOptions.put((Object)20, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.jdbc.javaNetLocalIPForMsgq")) {
                propertyValue = up.getProperty("oracle.jdbc.javaNetLocalIPForMsgq");
                socketOptions.put((Object)21, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.jdbc.javaNetMsgqTransport")) {
                propertyValue = up.getProperty("oracle.jdbc.javaNetMsgqTransport");
                socketOptions.put((Object)22, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.jdbc.javaNetMsgqBusyWait")) {
                propertyValue = up.getProperty("oracle.jdbc.javaNetMsgqBusyWait");
                socketOptions.put((Object)23, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.jdbc.javaNetMsgqKernelWait")) {
                propertyValue = up.getProperty("oracle.jdbc.javaNetMsgqKernelWait");
                socketOptions.put((Object)24, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.OUTBOUND_CONNECT_TIMEOUT")) {
                propertyValue = up.getProperty("oracle.net.OUTBOUND_CONNECT_TIMEOUT");
                socketOptions.put((Object)25, String.valueOf(TimeUnitSuffixUtility.getTimeInMilliseconds(propertyValue, true, 0)));
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.websocketUser")) {
                propertyValue = up.getProperty("oracle.net.websocketUser");
                socketOptions.put((Object)26, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.websocketPassword")) {
                password = up.get("oracle.net.websocketPassword");
                socketOptions.put((Object)27, password instanceof String ? OpaqueString.newOpaqueString((String)password) : (OpaqueString)password);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ssl_certificate_alias")) {
                propertyValue = up.getProperty("oracle.net.ssl_certificate_alias");
                socketOptions.put((Object)29, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.httpsProxyHost")) {
                propertyValue = up.getProperty("oracle.net.httpsProxyHost");
                socketOptions.put((Object)30, propertyValue);
                socketOptions.put((Object)31, up.getProperty("oracle.net.httpsProxyPort"));
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.socksProxyHost")) {
                propertyValue = up.getProperty("oracle.net.socksProxyHost");
                socketOptions.put((Object)36, propertyValue);
                socketOptions.put((Object)37, up.getProperty("oracle.net.socksProxyPort"));
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.socksRemoteDNS")) {
                propertyValue = up.getProperty("oracle.net.socksRemoteDNS");
                socketOptions.put((Object)39, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.TCP_KEEPIDLE")) {
                socketOptions.put((Object)33, up.getProperty("oracle.net.TCP_KEEPIDLE"));
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.TCP_KEEPINTERVAL")) {
                socketOptions.put((Object)34, up.getProperty("oracle.net.TCP_KEEPINTERVAL"));
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.TCP_KEEPCOUNT")) {
                socketOptions.put((Object)35, up.getProperty("oracle.net.TCP_KEEPCOUNT"));
                continue;
            }
            if (!propertyKey.equalsIgnoreCase("oracle.net.ssl_context_protocol")) continue;
            socketOptions.put((Object)38, up.getProperty("oracle.net.ssl_context_protocol"));
        }
        if (!tcpNoDelayParam && setDefaultNoDelay) {
            socketOptions.put((Object)0, "YES");
        }
    }

    public void addSocketOptions(boolean keepAlive) {
        if (keepAlive) {
            this.socketOptions.put((Object)1, "YES");
        } else if (!this.reuseOpt && !this.socketOptions.containsKey(1)) {
            this.socketOptions.put((Object)1, "NO");
        }
    }

    public void addSocketOptions_FORCE_DNS_LOAD_BALANCING_OFF() {
        this.socketOptions.put((Object)18, "true");
    }

    public boolean hasMoreOptions() {
        int cOptsSize = 0;
        for (ConnectDescription desc : this.descriptionList) {
            cOptsSize += desc.getConnectOptions().size();
        }
        return this.nextOptToTry < cOptsSize;
    }

    public ConnOption execute(boolean startNewOCTOInterruptTask, DMSFactory.DMSNoun dmsParent) throws NetException, InterruptedIOException {
        IOException causeException = null;
        for (int d2 = this.lastRetryConnectDescription; d2 < this.descriptionList.size(); ++d2) {
            ConnectDescription desc = this.descriptionList.get(d2);
            ArrayList<ConnOption> cOpts = desc.getConnectOptions();
            DownHostsCache.getInstance().reorderAddresses(cOpts);
            this.prepareForExecuteDescription(desc);
            this.outboundConnectTimeout = this.getOutboundConnectTimeout(desc);
            int delay = desc.getDelayInMillis();
            for (int i2 = this.lastRetryCounter; i2 <= this.retryCount; ++i2) {
                while (this.nextOptToTry < cOpts.size()) {
                    try {
                        this.copt = cOpts.get(this.nextOptToTry);
                        this.prepareForExecuteConnOption(this.copt);
                        this.executeConnOption(this.copt, dmsParent, desc.getTransportConnectTimeout(), startNewOCTOInterruptTask, this.outboundConnectTimeout);
                        this.handleExecuteConnOptionCompletion(this.copt);
                        this.lastRetryCounter = i2;
                        this.lastRetryConnectDescription = d2;
                        return this.copt;
                    }
                    catch (InterruptedIOException interruptErr) {
                        this.handleExecuteConnOptionFailure(this.copt, interruptErr);
                        throw interruptErr;
                    }
                    catch (IOException err) {
                        this.handleExecuteConnOptionFailure(this.copt, err);
                        causeException = err;
                    }
                }
                this.nextOptToTry = 0;
                if (delay <= 0 || i2 >= this.retryCount) continue;
                try {
                    Thread.sleep(delay);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.lastRetryCounter = 0;
        }
        if (causeException == null) {
            throw new NetException(20);
        }
        throw (NetException)new NetException(20).initCause(causeException);
    }

    public String getConnectionIdPrefix() {
        return this.connectionIdPrefix;
    }

    private void prepareForExecuteDescription(ConnectDescription desc) {
        this.setSecurityOptions(desc);
        if (desc.getTransportConnectTimeout() >= 0) {
            this.socketOptions.put((Object)2, Integer.toString(desc.getTransportConnectTimeout()));
        }
        this.sdu = desc.getSdu();
        this.tdu = desc.getTdu();
        this.retryCount = desc.getRetryCount();
        if (this.retryCount < 0) {
            this.retryCount = 0;
        }
        this.socketOptions.put((Object)17, Integer.toString(this.retryCount));
        this.setExpireTimeSocketOption(desc.getExpireTime(), this.socketOptions);
        this.connectionIdPrefix = this.userProp.getProperty("oracle.net.connectionIdPrefix", desc.getConnectionIdPrefix());
    }

    private void setSecurityOptions(ConnectDescription desc) {
        if (desc.getEncryptionClient() != null) {
            this.userProp.setProperty("oracle.net.encryption_client", desc.getEncryptionClient());
        }
        if (desc.getEncryptionClientTypes() != null) {
            this.userProp.setProperty("oracle.net.encryption_types_client", desc.getEncryptionClientTypes());
        }
        if (desc.getChecksumClient() != null) {
            this.userProp.setProperty("oracle.net.crypto_checksum_client", desc.getChecksumClient());
        }
        if (desc.getChecksumClientTypes() != null) {
            this.userProp.setProperty("oracle.net.crypto_checksum_types_client", desc.getChecksumClientTypes());
        }
        if (desc.getAllowWeakCrypto() != null) {
            this.userProp.setProperty("oracle.net.allow_weak_crypto", desc.getAllowWeakCrypto());
        }
    }

    private void prepareForExecuteConnOption(ConnOption option) {
        if (option.walletDirectory != null) {
            this.socketOptions.put((Object)5, EnvVariableResolver.resolveFilePath(option.walletDirectory, this.userProp));
        }
        if (option.sslServerCertDN == null) {
            option.sslServerCertDN = (String)this.socketOptions.get(28);
        }
        if (option.sslServerCertDN != null && this.socketOptions.get(4) == null) {
            this.socketOptions.put((Object)4, "TRUE");
        }
    }

    private void handleExecuteConnOptionCompletion(ConnOption option) {
        option.sdu = this.sdu;
        option.tdu = this.tdu;
        this.optFound = true;
        if (!option.nt.hasMoreInetAddresses()) {
            ++this.nextOptToTry;
        }
    }

    private void handleExecuteConnOptionFailure(ConnOption option, IOException err) {
        DownHostsCache.getInstance().markDownHost(option);
        if (option.nt == null || !option.nt.hasMoreInetAddresses()) {
            ++this.nextOptToTry;
        }
    }

    private void executeConnOption(ConnOption option, DMSFactory.DMSNoun dmsParent, int transportConnectTimeout, boolean startNewOCTOInterruptTask, int outboundConnectTimeout) throws IOException, InterruptedIOException {
        if (outboundConnectTimeout > 0 && startNewOCTOInterruptTask) {
            TimeoutInterruptHandler.scheduleInterrupt(TimeoutInterruptHandler.InterruptTaskType.OUTBOUND_TIMEOUT, outboundConnectTimeout, Thread.currentThread());
        }
        option.connectTimeout = outboundConnectTimeout;
        option.transportConnectTimeout = transportConnectTimeout;
        try {
            option.connect(this.socketOptions, dmsParent, this.sslContext);
        }
        catch (InterruptedIOException interruptException) {
            if (outboundConnectTimeout > 0 && !this.cancelOutboundTimeout()) {
                throw new IOException("Outbound connect timeout expired", interruptException);
            }
            throw interruptException;
        }
        catch (IOException connectException) {
            if (outboundConnectTimeout > 0) {
                this.cancelOutboundTimeout();
            }
            throw connectException;
        }
    }

    private boolean cancelOutboundTimeout() {
        TimeoutInterruptHandler.InterruptTask outboundTimeoutTask = TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.OUTBOUND_TIMEOUT, Thread.currentThread());
        return outboundTimeoutTask != null && !outboundTimeoutTask.isInterrupted();
    }

    private final int getOutboundConnectTimeout(ConnectDescription desc) {
        if (desc.getConnectTimeout() >= 0) {
            return desc.getConnectTimeout();
        }
        String timeoutSocketOption = (String)this.socketOptions.get(25);
        if (timeoutSocketOption != null) {
            try {
                return Integer.parseInt(timeoutSocketOption);
            }
            catch (NumberFormatException ne) {
                return 0;
            }
        }
        return 0;
    }

    public CompletionStage<ConnOption> executeAsync(boolean startNewOCTOInterruptTask, DMSFactory.DMSNoun dmsParent, AsyncOutboundTimeoutHandler outboundTimeoutHandler, Executor asyncExecutor) {
        if (this.lastRetryConnectDescription >= this.descriptionList.size()) {
            return CompletionStageUtil.completedStage(null);
        }
        return this.executeDescriptionAsync(this.lastRetryConnectDescription, dmsParent, startNewOCTOInterruptTask, outboundTimeoutHandler, asyncExecutor).handle(CompletionStageUtil.completionHandler(option -> {
            if (option != null) {
                return option;
            }
            throw new NetException(20);
        }, IOException.class, causeException -> {
            throw (NetException)new NetException(20).initCause(causeException);
        }));
    }

    private final CompletionStage<ConnOption> executeDescriptionAsync(int descriptionIndex, DMSFactory.DMSNoun dmsParent, boolean startNewOCTOInterruptTask, AsyncOutboundTimeoutHandler outboundTimeoutHandler, Executor asyncExecutor) {
        ConnectDescription desc = this.descriptionList.get(descriptionIndex);
        ArrayList<ConnOption> cOpts = desc.getConnectOptions();
        DownHostsCache.getInstance().reorderAddresses(cOpts);
        this.prepareForExecuteDescription(desc);
        this.outboundConnectTimeout = this.getOutboundConnectTimeout(desc);
        int delay = desc.getDelayInMillis();
        CompletionStage<Object> executeStage = this.lastRetryCounter <= this.retryCount ? this.executeConnOptionListAsync(this.lastRetryCounter, cOpts, delay, desc.getTransportConnectTimeout(), dmsParent, startNewOCTOInterruptTask, this.outboundConnectTimeout, outboundTimeoutHandler, asyncExecutor) : CompletionStageUtil.completedStage(null);
        int nextDescriptionIndex = descriptionIndex + 1;
        return executeStage.exceptionally(CompletionStageUtil.exceptionalCompletionHandler(IOException.class, causeException -> {
            if (nextDescriptionIndex < this.descriptionList.size()) {
                return null;
            }
            throw causeException;
        })).thenCompose(CompletionStageUtil.normalCompletionHandler(option -> {
            if (option != null) {
                this.lastRetryConnectDescription = descriptionIndex;
                return CompletionStageUtil.completedStage(option);
            }
            this.lastRetryCounter = 0;
            return nextDescriptionIndex < this.descriptionList.size() ? this.executeDescriptionAsync(nextDescriptionIndex, dmsParent, startNewOCTOInterruptTask, outboundTimeoutHandler, asyncExecutor) : CompletionStageUtil.completedStage(null);
        }));
    }

    private CompletionStage<ConnOption> executeConnOptionListAsync(int currentRetryCount, List<ConnOption> cOpts, int delay, int transportConnectTimeout, DMSFactory.DMSNoun dmsParent, boolean startNewOCTOInterruptTask, int outboundConnectTimeout, AsyncOutboundTimeoutHandler outboundTimeoutHandler, Executor asyncExecutor) {
        CompletionStage<Object> executeStage = this.nextOptToTry < cOpts.size() ? this.executeNextConnOptionAsync(cOpts, dmsParent, transportConnectTimeout, startNewOCTOInterruptTask, outboundConnectTimeout, outboundTimeoutHandler, asyncExecutor) : CompletionStageUtil.completedStage(null);
        return executeStage.exceptionally(CompletionStageUtil.exceptionalCompletionHandler(IOException.class, causeException -> {
            if (currentRetryCount < this.retryCount) {
                return null;
            }
            throw causeException;
        })).thenCompose(CompletionStageUtil.normalCompletionHandler(option -> {
            if (option != null) {
                this.lastRetryCounter = currentRetryCount;
                return CompletionStageUtil.completedStage(option);
            }
            this.nextOptToTry = 0;
            if (currentRetryCount < this.retryCount) {
                CompletableFuture delayedFuture = new CompletableFuture();
                if (delay <= 0) {
                    delayedFuture.complete(null);
                } else {
                    TimeoutInterruptHandler.scheduleTask(() -> delayedFuture.complete(null), delay);
                }
                return delayedFuture.thenCompose(nil -> this.executeConnOptionListAsync(currentRetryCount + 1, cOpts, delay, transportConnectTimeout, dmsParent, startNewOCTOInterruptTask, outboundConnectTimeout, outboundTimeoutHandler, asyncExecutor));
            }
            return CompletionStageUtil.completedStage(null);
        }));
    }

    private final CompletionStage<ConnOption> executeNextConnOptionAsync(List<ConnOption> cOpts, DMSFactory.DMSNoun dmsParent, int transportConnectTimeout, boolean startNewOCTOInterruptTask, int outboundConnectTimeout, AsyncOutboundTimeoutHandler outboundTimeoutHandler, Executor asyncExecutor) {
        this.copt = cOpts.get(this.nextOptToTry);
        this.prepareForExecuteConnOption(this.copt);
        CompletionStage<CompletionStage> executeComposedStage = this.executeConnOptionAsync(this.copt, dmsParent, startNewOCTOInterruptTask, outboundConnectTimeout, outboundTimeoutHandler, transportConnectTimeout, asyncExecutor).handle(CompletionStageUtil.completionHandler(nil -> {
            this.handleExecuteConnOptionCompletion(this.copt);
            return CompletionStageUtil.completedStage(this.copt);
        }, IOException.class, causeException -> {
            this.handleExecuteConnOptionFailure(this.copt, (IOException)causeException);
            return this.nextOptToTry < cOpts.size() ? this.executeNextConnOptionAsync(cOpts, dmsParent, transportConnectTimeout, startNewOCTOInterruptTask, outboundConnectTimeout, outboundTimeoutHandler, asyncExecutor) : CompletionStageUtil.failedStage(causeException);
        }));
        return executeComposedStage.thenCompose(Function.identity());
    }

    private final CompletionStage<Void> executeConnOptionAsync(ConnOption option, DMSFactory.DMSNoun dmsParent, boolean startNewOCTOInterruptTask, int outboundConnectTimeout, AsyncOutboundTimeoutHandler outboundTimeoutHandler, int transportConnectTimeout, Executor asyncExecutor) {
        if (outboundConnectTimeout > 0 && startNewOCTOInterruptTask) {
            try {
                outboundTimeoutHandler.scheduleTimeout(Duration.ofMillis(outboundConnectTimeout));
            }
            catch (IOException timeoutExpired) {
                return CompletionStageUtil.failedStage(timeoutExpired);
            }
        }
        option.connectTimeout = outboundConnectTimeout;
        option.transportConnectTimeout = transportConnectTimeout;
        CompletionStage<Void> connectStage = option.connectAsync(this.socketOptions, dmsParent, this.sslContext, outboundTimeoutHandler, asyncExecutor);
        if (outboundConnectTimeout > 0) {
            return connectStage.whenComplete((result, connectException) -> {
                if (connectException != null) {
                    outboundTimeoutHandler.cancelTimeout();
                }
            });
        }
        return connectStage;
    }

    public boolean optAvailable() {
        return this.optFound;
    }

    public void clearElements() {
        this.descriptionList = null;
    }

    public ConnOption getOption() {
        return this.copt;
    }

    public boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.copt.isConnectionSocketKeepAlive();
    }

    public ConnectDescription newConnectDescription() {
        this.currentDescription = new ConnectDescription();
        return this.currentDescription;
    }

    public ConnectDescription currentDescription() {
        return this.currentDescription;
    }

    public void closeDescription() {
        this.descriptionList.add(this.currentDescription);
        this.currentDescription = null;
    }

    public List<ConnectDescription> getAllDescriptions() {
        return this.descriptionList;
    }

    public int getOutboundConnectTimeout() {
        return this.outboundConnectTimeout;
    }

    private final void setExpireTimeSocketOption(int expireTimeMinutes, @Blind(value=PropertiesBlinder.class) Properties socketOptions) {
        if (expireTimeMinutes < 0) {
            return;
        }
        int expireTimeSeconds = expireTimeMinutes * 60;
        socketOptions.putIfAbsent((Object)33, Integer.toString(expireTimeSeconds));
    }

    static {
        try {
            $$$methodRef$$$45 = ConnStrategy.class.getDeclaredConstructor(Properties.class, SSLContext.class, SecuredLogger.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = ConnStrategy.class.getDeclaredConstructor(Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = ConnStrategy.class.getDeclaredMethod("lambda$executeAsync$0", ConnOption.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = ConnStrategy.class.getDeclaredMethod("lambda$executeAsync$1", IOException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = ConnStrategy.class.getDeclaredMethod("lambda$executeDescriptionAsync$2", Integer.TYPE, IOException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = ConnStrategy.class.getDeclaredMethod("lambda$executeDescriptionAsync$3", Integer.TYPE, Integer.TYPE, DMSFactory.DMSNoun.class, Boolean.TYPE, AsyncOutboundTimeoutHandler.class, Executor.class, ConnOption.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = ConnStrategy.class.getDeclaredMethod("lambda$executeConnOptionListAsync$4", Integer.TYPE, IOException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = ConnStrategy.class.getDeclaredMethod("lambda$null$5", CompletableFuture.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = ConnStrategy.class.getDeclaredMethod("lambda$null$6", Integer.TYPE, List.class, Integer.TYPE, Integer.TYPE, DMSFactory.DMSNoun.class, Boolean.TYPE, Integer.TYPE, AsyncOutboundTimeoutHandler.class, Executor.class, Void.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = ConnStrategy.class.getDeclaredMethod("lambda$executeConnOptionListAsync$7", Integer.TYPE, Integer.TYPE, List.class, Integer.TYPE, DMSFactory.DMSNoun.class, Boolean.TYPE, Integer.TYPE, AsyncOutboundTimeoutHandler.class, Executor.class, ConnOption.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = ConnStrategy.class.getDeclaredMethod("lambda$executeNextConnOptionAsync$8", Void.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = ConnStrategy.class.getDeclaredMethod("lambda$executeNextConnOptionAsync$9", List.class, DMSFactory.DMSNoun.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, AsyncOutboundTimeoutHandler.class, Executor.class, IOException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = ConnStrategy.class.getDeclaredMethod("lambda$executeConnOptionAsync$10", AsyncOutboundTimeoutHandler.class, Void.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = ConnStrategy.class.getDeclaredMethod("setExpireTimeSocketOption", Integer.TYPE, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = ConnStrategy.class.getDeclaredMethod("getOutboundConnectTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = ConnStrategy.class.getDeclaredMethod("getAllDescriptions", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = ConnStrategy.class.getDeclaredMethod("closeDescription", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = ConnStrategy.class.getDeclaredMethod("currentDescription", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = ConnStrategy.class.getDeclaredMethod("newConnectDescription", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = ConnStrategy.class.getDeclaredMethod("isConnectionSocketKeepAlive", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = ConnStrategy.class.getDeclaredMethod("getOption", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = ConnStrategy.class.getDeclaredMethod("clearElements", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = ConnStrategy.class.getDeclaredMethod("optAvailable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = ConnStrategy.class.getDeclaredMethod("executeConnOptionAsync", ConnOption.class, DMSFactory.DMSNoun.class, Boolean.TYPE, Integer.TYPE, AsyncOutboundTimeoutHandler.class, Integer.TYPE, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = ConnStrategy.class.getDeclaredMethod("executeNextConnOptionAsync", List.class, DMSFactory.DMSNoun.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, AsyncOutboundTimeoutHandler.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = ConnStrategy.class.getDeclaredMethod("executeConnOptionListAsync", Integer.TYPE, List.class, Integer.TYPE, Integer.TYPE, DMSFactory.DMSNoun.class, Boolean.TYPE, Integer.TYPE, AsyncOutboundTimeoutHandler.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = ConnStrategy.class.getDeclaredMethod("executeDescriptionAsync", Integer.TYPE, DMSFactory.DMSNoun.class, Boolean.TYPE, AsyncOutboundTimeoutHandler.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = ConnStrategy.class.getDeclaredMethod("executeAsync", Boolean.TYPE, DMSFactory.DMSNoun.class, AsyncOutboundTimeoutHandler.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = ConnStrategy.class.getDeclaredMethod("getOutboundConnectTimeout", ConnectDescription.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = ConnStrategy.class.getDeclaredMethod("cancelOutboundTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = ConnStrategy.class.getDeclaredMethod("executeConnOption", ConnOption.class, DMSFactory.DMSNoun.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = ConnStrategy.class.getDeclaredMethod("handleExecuteConnOptionFailure", ConnOption.class, IOException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = ConnStrategy.class.getDeclaredMethod("handleExecuteConnOptionCompletion", ConnOption.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = ConnStrategy.class.getDeclaredMethod("prepareForExecuteConnOption", ConnOption.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = ConnStrategy.class.getDeclaredMethod("setSecurityOptions", ConnectDescription.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = ConnStrategy.class.getDeclaredMethod("prepareForExecuteDescription", ConnectDescription.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = ConnStrategy.class.getDeclaredMethod("getConnectionIdPrefix", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = ConnStrategy.class.getDeclaredMethod("execute", Boolean.TYPE, DMSFactory.DMSNoun.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = ConnStrategy.class.getDeclaredMethod("hasMoreOptions", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = ConnStrategy.class.getDeclaredMethod("addSocketOptions_FORCE_DNS_LOAD_BALANCING_OFF", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = ConnStrategy.class.getDeclaredMethod("addSocketOptions", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = ConnStrategy.class.getDeclaredMethod("createSocketOptions", Properties.class, Properties.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = ConnStrategy.class.getDeclaredMethod("createSocketOptions", Properties.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = ConnStrategy.class.getDeclaredMethod("createSocketOptions", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = ConnStrategy.class.getDeclaredMethod("getProgramName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = ConnStrategy.class.getDeclaredMethod("getOSUsername", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

