/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import oracle.jdbc.datasource.impl.OracleConnectionBuilderImpl;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.driver.T4CXAConnection;
import oracle.jdbc.internal.AbstractConnectionBuilder;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.xa.OracleXAConnectionBuilderImpl;
import oracle.jdbc.xa.client.OracleXAConnection;
import oracle.jdbc.xa.client.OracleXAHeteroCloseCallback;
import oracle.jdbc.xa.client.OracleXAHeteroConnection;

@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.XA, Feature.HIGH_AVAILABILITY, Feature.CONN_POOL, Feature.APPLICATION_CONTINUITY})
public class OracleXADataSource
extends oracle.jdbc.xa.OracleXADataSource {
    private static final boolean DEBUG = false;
    private int rmid;
    private String xaOpenString;
    private static boolean libraryLoaded;
    private static Monitor LOAD_LIBRARY_MONITOR;
    private static final String dbSuffix = "HeteroXA";
    private static final String dllName = "heteroxa21";
    private static final char atSignChar = '@';
    private static int rmidSeed;
    private static Monitor RMID_SEED_MONITOR;
    private static final int MAX_RMID_SEED = 65536;
    private String driverCharSetIdString;
    private String oldTnsEntry;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;

    public OracleXADataSource() throws SQLException {
        boolean bl = (0x4000010C000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$19, null, new Object[0]);
            }
            this.rmid = -1;
            this.xaOpenString = null;
            this.driverCharSetIdString = null;
            this.oldTnsEntry = null;
            this.isOracleDataSource = true;
            this.setConnectionProperty("oracle.jdbc.enableACSupport", "false");
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$19, null);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$19, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$19, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        boolean bl = (0x4000010C000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$0, this, new Object[0]);
            }
            Properties prop = new Properties(this.connectionProperties);
            if (this.user != null && this.password != null && this.password != OpaqueString.NULL) {
                prop.setProperty("user", this.user);
                prop.setProperty("password", this.password.get());
            }
            XAConnection xAConnection = this.getXAConnection(prop.getProperty("user"), prop.getProperty("password"));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$0, this, xAConnection);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$0, this, null);
            }
            return xAConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public XAConnection getXAConnection(String string, @Blind String string2) throws SQLException {
        boolean bl = (0x4000010C000000L & TraceControllerImpl.feature) != 0L;
        try {
            void passwd;
            void userName;
            String tempval;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$1, this, string, "*****");
            }
            if ((tempval = OracleXADataSource.getSystemProperty("oracle.jdbc.enableACSupport", null)) == null) {
                tempval = this.getConnectionProperty("oracle.jdbc.enableACSupport");
            }
            if (tempval == null) {
                tempval = "true";
            }
            boolean useProxy = tempval != null && tempval.equalsIgnoreCase("true");
            XAConnection xAConnection = this.getXAConnectionInternal((OracleXAConnectionBuilderImpl)((OracleXAConnectionBuilderImpl)this.createXAConnectionBuilder().user((String)userName)).password(OpaqueString.newOpaqueString((String)passwd)), useProxy);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$1, this, xAConnection);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$1, this, null);
            }
            return xAConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public XAConnection getXAConnection(@Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        boolean bl = (0x4000010C000000L & TraceControllerImpl.feature) != 0L;
        try {
            void prop;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$2, this, TraceControllerImpl.blind(PropertiesBlinder.class, properties));
            }
            XAConnection xAConnection = (XAConnection)this.getPooledConnection((Properties)prop);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$2, this, xAConnection);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$2, this, null);
            }
            return xAConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public XAConnection getXAConnection(OracleXAConnectionBuilderImpl oracleXAConnectionBuilderImpl) throws SQLException {
        boolean bl = (0x4000010C000000L & TraceControllerImpl.feature) != 0L;
        try {
            void builder;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$3, this, oracleXAConnectionBuilderImpl);
            }
            Properties prop = new Properties(this.connectionProperties);
            OpaqueString passwd = builder.getPassword();
            if (builder.getUser() != null && passwd != null && passwd != OpaqueString.NULL) {
                prop.setProperty("user", builder.getUser());
                prop.setProperty("password", passwd.get());
            }
            if (builder.getServiceName() != null) {
                prop.setProperty("oracle.jdbc.targetServiceName", builder.getServiceName());
            }
            if (builder.getShardingKey() != null) {
                String b64EncodedShardingKey = builder.getShardingKey().encodeKeyinB64Format();
                prop.setProperty("oracle.jdbc.targetShardingKey", b64EncodedShardingKey);
            }
            if (builder.getSuperShardingKey() != null) {
                String b64EncodedSuperKey = builder.getSuperShardingKey().encodeKeyinB64Format();
                prop.setProperty("oracle.jdbc.targetSuperShardingKey", b64EncodedSuperKey);
            }
            if (builder.getReadOnlyInstanceAllowed()) {
                prop.setProperty("oracle.jdbc.readOnlyInstanceAllowed", "true");
            }
            XAConnection xAConnection = (XAConnection)this.getPooledConnection(prop, (OracleXAConnectionBuilderImpl)builder);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$3, this, xAConnection);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$3, this, null);
            }
            return xAConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public OracleXAConnectionBuilderImpl createXAConnectionBuilder() {
        boolean bl = (0x4000010C000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$4, this, new Object[0]);
            }
            OracleXAConnectionBuilderImpl oracleXAConnectionBuilderImpl = new OracleXAConnectionBuilderImpl(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                public oracle.jdbc.datasource.OracleXAConnection build() throws SQLException {
                    if (this.getGSSCredential() != null && (this.getUser() != null || this.getPassword() != null && this.getPassword() != OpaqueString.NULL)) {
                        throw (SQLException)DatabaseError.createSqlException(1702).fillInStackTrace();
                    }
                    String tempval = OracleXADataSource.access$000("oracle.jdbc.enableACSupport", null);
                    if (tempval == null) {
                        tempval = OracleXADataSource.this.getConnectionProperty("oracle.jdbc.enableACSupport");
                    }
                    if (tempval == null) {
                        tempval = "true";
                    }
                    boolean useProxy = tempval != null && tempval.equalsIgnoreCase("true");
                    return (OracleXAConnection)OracleXADataSource.access$100(OracleXADataSource.this, this, useProxy);
                }

                static {
                    try {
                        $$$methodRef$$$2 = 1.class.getDeclaredConstructor(OracleXADataSource.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$1 = 1.class.getDeclaredMethod("build", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("build", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$4, this, oracleXAConnectionBuilderImpl);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$4, this, null);
            }
            return oracleXAConnectionBuilderImpl;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private XAConnection getXAConnectionInternal(OracleXAConnectionBuilderImpl oracleXAConnectionBuilderImpl, boolean bl) throws SQLException {
        boolean bl2 = (0x4000010C000000L & TraceControllerImpl.feature) != 0L;
        try {
            void builder;
            void useProxy;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$5, this, oracleXAConnectionBuilderImpl, bl);
            }
            if (useProxy == false) {
                XAConnection xAConnection = this.getXAConnection((OracleXAConnectionBuilderImpl)builder);
                if (bl2) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$5, this, xAConnection);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$5, this, null);
                }
                return xAConnection;
            }
            this.setupACSpecificProperties((boolean)useProxy);
            OraclePooledConnection pc = (OraclePooledConnection)((Object)this.getXAConnection((OracleXAConnectionBuilderImpl)builder));
            Connection _pconn = pc.getPhysicalHandle();
            OracleConnectionBuilderImpl connBldr = builder == null ? null : (OracleConnectionBuilderImpl)this.createConnectionBuilder().copy((AbstractConnectionBuilder<?, ?>)builder);
            Connection retConn = this.enableACAndProxifyIfNecessary(_pconn, connBldr);
            if (_pconn != retConn) {
                pc.setConnection((OracleConnection)retConn);
            }
            XAConnection xAConnection = (XAConnection)((Object)pc);
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$5, this, xAConnection);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$5, this, null);
            }
            return xAConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PooledConnection getPooledConnection(String string, @Blind String string2) throws SQLException {
        boolean bl = (0x4000010C000000L & TraceControllerImpl.feature) != 0L;
        try {
            void passwd;
            void userName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$6, this, string, "*****");
            }
            Properties prop = new Properties();
            prop.setProperty("user", (String)userName);
            prop.setProperty("password", (String)passwd);
            PooledConnection pooledConnection = this.getPooledConnection(prop);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$6, this, pooledConnection);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$6, this, null);
            }
            return pooledConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public PooledConnection getPooledConnection(@Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        boolean bl = (0x4000010C000000L & TraceControllerImpl.feature) != 0L;
        try {
            void info;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$7, this, TraceControllerImpl.blind(PropertiesBlinder.class, properties));
            }
            PooledConnection pooledConnection = this.getPooledConnection((Properties)info, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$7, this, pooledConnection);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$7, this, null);
            }
            return pooledConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    private final PooledConnection getPooledConnection(@Blind(value=PropertiesBlinder.class) Properties properties, OracleXAConnectionBuilderImpl oracleXAConnectionBuilderImpl) throws SQLException {
        boolean bl = (0x4000010C000000L & TraceControllerImpl.feature) != 0L;
        try {
            OracleXAConnection oracleXAConnection;
            block172: {
                Throwable l_xaLoose322222222;
                Properties prop;
                block170: {
                    Monitor.CloseableLock lock;
                    block171: {
                        String isReadOnlyInstanceAllowed;
                        String superShardingKeyStr;
                        String shardingKeyStr;
                        String localServiceName;
                        String localInstanceName;
                        String passwd;
                        String userName;
                        block164: {
                            T4CXAConnection t4CXAConnection;
                            block169: {
                                void builder;
                                Properties prop2;
                                block167: {
                                    Throwable propNlsLangBackdoor222222222;
                                    Monitor.CloseableLock lock2;
                                    block168: {
                                        block165: {
                                            Throwable throwable;
                                            Monitor.CloseableLock rmidLock;
                                            block166: {
                                                String url;
                                                block153: {
                                                    OracleXAHeteroConnection oracleXAHeteroConnection;
                                                    block163: {
                                                        if (bl) {
                                                            ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$8, this, TraceControllerImpl.blind(PropertiesBlinder.class, properties), oracleXAConnectionBuilderImpl);
                                                        }
                                                        try {
                                                            int status;
                                                            long[] ociHandles;
                                                            int localRmid;
                                                            String localXaOpenString;
                                                            String xaclsstr;
                                                            String rmName;
                                                            void info;
                                                            block161: {
                                                                Monitor.CloseableLock lock3;
                                                                Throwable throwable2;
                                                                block162: {
                                                                    String tnsentry;
                                                                    block158: {
                                                                        Monitor.CloseableLock rmidLock2;
                                                                        Throwable throwable3;
                                                                        block159: {
                                                                            String propNlsLangBackdoor222222222;
                                                                            block156: {
                                                                                Monitor.CloseableLock lock4;
                                                                                block157: {
                                                                                    block154: {
                                                                                        url = this.getURL();
                                                                                        userName = info.getProperty("user");
                                                                                        passwd = info.getProperty("password");
                                                                                        localInstanceName = info.getProperty("oracle.jdbc.targetInstanceName");
                                                                                        localServiceName = info.getProperty("oracle.jdbc.targetServiceName");
                                                                                        shardingKeyStr = info.getProperty("oracle.jdbc.targetShardingKey");
                                                                                        superShardingKeyStr = info.getProperty("oracle.jdbc.targetSuperShardingKey");
                                                                                        isReadOnlyInstanceAllowed = info.getProperty("oracle.jdbc.readOnlyInstanceAllowed");
                                                                                        rmName = null;
                                                                                        xaclsstr = null;
                                                                                        localXaOpenString = null;
                                                                                        localRmid = 0;
                                                                                        if (!this.useNativeXA || !url.startsWith("jdbc:oracle:oci8") && !url.startsWith("jdbc:oracle:oci")) break block153;
                                                                                        ociHandles = new long[]{0L, 0L};
                                                                                        tnsentry = null;
                                                                                        propNlsLangBackdoor222222222 = null;
                                                                                        lock4 = this.acquireCloseableLock();
                                                                                        throwable2 = null;
                                                                                        tnsentry = this.tnsEntry != null ? this.tnsEntry : this.getTNSEntryFromUrl(url);
                                                                                        if (tnsentry != null && tnsentry.length() == 0 || tnsentry.startsWith("(DESCRIPTION")) {
                                                                                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(207).fillInStackTrace();
                                                                                            if (bl) {
                                                                                                ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$8, this, sQLException);
                                                                                            }
                                                                                            throw sQLException;
                                                                                        }
                                                                                        if (!libraryLoaded) {
                                                                                            Monitor.CloseableLock libLock;
                                                                                            block155: {
                                                                                                libLock = LOAD_LIBRARY_MONITOR.acquireCloseableLock();
                                                                                                throwable3 = null;
                                                                                                if (!libraryLoaded) {
                                                                                                    try {
                                                                                                        System.loadLibrary(dllName);
                                                                                                        libraryLoaded = true;
                                                                                                    }
                                                                                                    catch (Error exc) {
                                                                                                        if (bl) {
                                                                                                            this.debug($$$loggerRef$$$8, Level.FINEST, $$$methodRef$$$8, "------ JNI JDBC XA lib not loaded properly. ------");
                                                                                                        }
                                                                                                        libraryLoaded = false;
                                                                                                        Error error = exc;
                                                                                                        if (bl) {
                                                                                                            ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$8, this, error);
                                                                                                        }
                                                                                                        throw error;
                                                                                                    }
                                                                                                }
                                                                                                if (libLock == null) break block154;
                                                                                                if (throwable3 == null) break block155;
                                                                                                try {
                                                                                                    libLock.close();
                                                                                                }
                                                                                                catch (Throwable throwable4) {
                                                                                                    throwable3.addSuppressed(throwable4);
                                                                                                }
                                                                                                break block154;
                                                                                            }
                                                                                            libLock.close();
                                                                                            break block154;
                                                                                            catch (Throwable throwable5) {
                                                                                                try {
                                                                                                    throwable3 = throwable5;
                                                                                                    Throwable throwable6 = throwable5;
                                                                                                    if (bl) {
                                                                                                        ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$8, this, throwable6);
                                                                                                    }
                                                                                                    throw throwable6;
                                                                                                }
                                                                                                catch (Throwable throwable7) {
                                                                                                    if (libLock != null) {
                                                                                                        if (throwable3 != null) {
                                                                                                            try {
                                                                                                                libLock.close();
                                                                                                            }
                                                                                                            catch (Throwable throwable8) {
                                                                                                                throwable3.addSuppressed(throwable8);
                                                                                                            }
                                                                                                        } else {
                                                                                                            libLock.close();
                                                                                                        }
                                                                                                    }
                                                                                                    Throwable throwable9 = throwable7;
                                                                                                    if (bl) {
                                                                                                        ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$8, this, throwable9);
                                                                                                    }
                                                                                                    throw throwable9;
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                    if (this.connectionProperties != null) {
                                                                                        propNlsLangBackdoor222222222 = this.connectionProperties.getProperty("oracle.jdbc.ociNlsLangBackwardCompatible");
                                                                                    }
                                                                                    if (lock4 == null) break block156;
                                                                                    if (throwable2 == null) break block157;
                                                                                    try {
                                                                                        lock4.close();
                                                                                    }
                                                                                    catch (Throwable libLock) {
                                                                                        throwable2.addSuppressed(libLock);
                                                                                    }
                                                                                    break block156;
                                                                                }
                                                                                lock4.close();
                                                                                break block156;
                                                                                catch (Throwable libLock) {
                                                                                    try {
                                                                                        throwable2 = libLock;
                                                                                        Throwable throwable10 = libLock;
                                                                                        if (bl) {
                                                                                            ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$8, this, throwable10);
                                                                                        }
                                                                                        throw throwable10;
                                                                                    }
                                                                                    catch (Throwable throwable11) {
                                                                                        if (lock4 != null) {
                                                                                            if (throwable2 != null) {
                                                                                                try {
                                                                                                    lock4.close();
                                                                                                }
                                                                                                catch (Throwable throwable12) {
                                                                                                    throwable2.addSuppressed(throwable12);
                                                                                                }
                                                                                            } else {
                                                                                                lock4.close();
                                                                                            }
                                                                                        }
                                                                                        Throwable throwable13 = throwable11;
                                                                                        if (bl) {
                                                                                            ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$8, this, throwable13);
                                                                                        }
                                                                                        throw throwable13;
                                                                                    }
                                                                                }
                                                                            }
                                                                            if (propNlsLangBackdoor222222222 != null && propNlsLangBackdoor222222222.equalsIgnoreCase("true")) {
                                                                                short driverCharSetId = T2CConnection.getDriverCharSetIdFromNLS_LANG();
                                                                                this.driverCharSetIdString = Integer.toString(driverCharSetId);
                                                                            } else if (!tnsentry.equals(this.oldTnsEntry)) {
                                                                                short driverCharSetId = T2CConnection.getClientCharSetId();
                                                                                this.driverCharSetIdString = Integer.toString(driverCharSetId);
                                                                                this.oldTnsEntry = tnsentry;
                                                                            }
                                                                            lock3 = this.acquireCloseableLock();
                                                                            throwable2 = null;
                                                                            rmName = this.databaseName + dbSuffix + rmidSeed;
                                                                            this.rmid = localRmid = rmidSeed;
                                                                            rmidLock2 = RMID_SEED_MONITOR.acquireCloseableLock();
                                                                            throwable3 = null;
                                                                            rmidSeed = (rmidSeed + 1) % 65536;
                                                                            if (rmidLock2 == null) break block158;
                                                                            if (throwable3 == null) break block159;
                                                                            try {
                                                                                rmidLock2.close();
                                                                            }
                                                                            catch (Throwable throwable14) {
                                                                                throwable3.addSuppressed(throwable14);
                                                                            }
                                                                            break block158;
                                                                        }
                                                                        rmidLock2.close();
                                                                        break block158;
                                                                        catch (Throwable throwable15) {
                                                                            try {
                                                                                throwable3 = throwable15;
                                                                                Throwable throwable16 = throwable15;
                                                                                if (bl) {
                                                                                    ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$8, this, throwable16);
                                                                                }
                                                                                throw throwable16;
                                                                            }
                                                                            catch (Throwable throwable17) {
                                                                                if (rmidLock2 != null) {
                                                                                    if (throwable3 != null) {
                                                                                        try {
                                                                                            rmidLock2.close();
                                                                                        }
                                                                                        catch (Throwable throwable18) {
                                                                                            throwable3.addSuppressed(throwable18);
                                                                                        }
                                                                                    } else {
                                                                                        rmidLock2.close();
                                                                                    }
                                                                                }
                                                                                Throwable throwable19 = throwable17;
                                                                                if (bl) {
                                                                                    ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$8, this, throwable19);
                                                                                }
                                                                                throw throwable19;
                                                                            }
                                                                        }
                                                                    }
                                                                    int trcLevel2333333332 = 0;
                                                                    if (TRACE && OracleLog.recursiveEnter()) {
                                                                        block160: {
                                                                            try {
                                                                                trcLevel2333333332 = 7;
                                                                                if (!bl) break block160;
                                                                                this.debug($$$loggerRef$$$8, Level.FINEST, $$$methodRef$$$8, "getXAConnection(user, pwd): trcLevel = " + trcLevel2333333332);
                                                                            }
                                                                            catch (Throwable throwable20) {
                                                                                OracleLog.recursiveExit();
                                                                                Throwable throwable21 = throwable20;
                                                                                if (bl) {
                                                                                    ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$8, this, throwable21);
                                                                                }
                                                                                throw throwable21;
                                                                            }
                                                                        }
                                                                        OracleLog.recursiveExit();
                                                                    }
                                                                    String l_xaLoose2 = this.connectionProperties != null ? this.connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
                                                                    this.xaOpenString = localXaOpenString = this.generateXAOpenString(rmName, tnsentry, userName, passwd, 60, 2000, true, true, ".", trcLevel2333333332, false, l_xaLoose2 != null && l_xaLoose2.equalsIgnoreCase("true"), this.driverCharSetIdString, this.driverCharSetIdString);
                                                                    xaclsstr = this.generateXACloseString(rmName, false);
                                                                    if (lock3 == null) break block161;
                                                                    if (throwable2 == null) break block162;
                                                                    try {
                                                                        lock3.close();
                                                                    }
                                                                    catch (Throwable trcLevel2333333332) {
                                                                        throwable2.addSuppressed(trcLevel2333333332);
                                                                    }
                                                                    break block161;
                                                                }
                                                                lock3.close();
                                                                break block161;
                                                                catch (Throwable trcLevel2333333332) {
                                                                    try {
                                                                        throwable2 = trcLevel2333333332;
                                                                        Throwable throwable22 = trcLevel2333333332;
                                                                        if (bl) {
                                                                            ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$8, this, throwable22);
                                                                        }
                                                                        throw throwable22;
                                                                    }
                                                                    catch (Throwable throwable23) {
                                                                        if (lock3 != null) {
                                                                            if (throwable2 != null) {
                                                                                try {
                                                                                    lock3.close();
                                                                                }
                                                                                catch (Throwable throwable24) {
                                                                                    throwable2.addSuppressed(throwable24);
                                                                                }
                                                                            } else {
                                                                                lock3.close();
                                                                            }
                                                                        }
                                                                        Throwable throwable25 = throwable23;
                                                                        if (bl) {
                                                                            ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$8, this, throwable25);
                                                                        }
                                                                        throw throwable25;
                                                                    }
                                                                }
                                                            }
                                                            if (bl) {
                                                                this.debug($$$loggerRef$$$8, Level.FINEST, $$$methodRef$$$8, "getPooledConnection(user, pwd): before t2cDoXaOpen()");
                                                            }
                                                            if ((status = this.t2cDoXaOpen(localXaOpenString, localRmid, 0, 0)) != 0) {
                                                                SQLException sQLException = (SQLException)DatabaseError.createSqlException(null, -1 * status).fillInStackTrace();
                                                                if (bl) {
                                                                    ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$8, this, sQLException);
                                                                }
                                                                throw sQLException;
                                                            }
                                                            if (bl) {
                                                                this.debug($$$loggerRef$$$8, Level.FINEST, $$$methodRef$$$8, "getPooledConnection(user, pwd): before t2cConvertOciHandles()");
                                                            }
                                                            if ((status = this.t2cConvertOciHandles(rmName, ociHandles)) != 0) {
                                                                SQLException sQLException = (SQLException)DatabaseError.createSqlException(null, -1 * status).fillInStackTrace();
                                                                if (bl) {
                                                                    ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$8, this, sQLException);
                                                                }
                                                                throw sQLException;
                                                            }
                                                            info.put("OCISvcCtxHandle", String.valueOf(ociHandles[0]));
                                                            info.put("OCIEnvHandle", String.valueOf(ociHandles[1]));
                                                            info.put("JDBCDriverCharSetId", this.driverCharSetIdString);
                                                            if (this.loginTimeout != 0) {
                                                                info.put("oracle.net.CONNECT_TIMEOUT", "" + this.loginTimeout * 1000);
                                                            }
                                                            if (bl) {
                                                                this.debug($$$loggerRef$$$8, Level.FINEST, $$$methodRef$$$8, "getPooledConnection(user, pwd): before getConnection(url, info)");
                                                            }
                                                            Connection conn = this.driver.connect(this.getURL(), (Properties)info);
                                                            if (this.maxStatementsSet) {
                                                                ((OracleConnection)conn).setStatementCacheSize(this.maxStatements);
                                                            }
                                                            if (this.explicitCachingEnabledSet) {
                                                                ((OracleConnection)conn).setExplicitCachingEnabled(this.explicitCachingEnabled);
                                                            }
                                                            if (this.implicitCachingEnabledSet) {
                                                                ((OracleConnection)conn).setImplicitCachingEnabled(this.implicitCachingEnabled);
                                                            }
                                                            if (this.maxStatements > 0 && !this.explicitCachingEnabled && !this.implicitCachingEnabled) {
                                                                ((OracleConnection)conn).setImplicitCachingEnabled(true);
                                                                ((OracleConnection)conn).setExplicitCachingEnabled(true);
                                                            }
                                                            OracleXAHeteroConnection xaconn = new OracleXAHeteroConnection(conn);
                                                            xaconn.setRmid(localRmid);
                                                            xaconn.setXaCloseString(xaclsstr);
                                                            xaconn.registerCloseCallback(new OracleXAHeteroCloseCallback(), xaconn);
                                                            oracleXAHeteroConnection = xaconn;
                                                            if (!bl) break block163;
                                                        }
                                                        catch (XAException xae) {
                                                            if (bl) {
                                                                this.debug($$$loggerRef$$$8, Level.FINEST, $$$methodRef$$$8, "getPooledConnection(user, pwd): XAException at end " + xae);
                                                            }
                                                            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), xae);
                                                            if (bl) {
                                                                ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$8, this, sQLException);
                                                            }
                                                            throw sQLException;
                                                        }
                                                        ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$8, this, oracleXAHeteroConnection);
                                                        ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$8, this, null);
                                                    }
                                                    return oracleXAHeteroConnection;
                                                }
                                                if (!this.useNativeXA || !url.startsWith("jdbc:oracle:thin")) break block164;
                                                prop2 = new Properties();
                                                lock2 = this.acquireCloseableLock();
                                                propNlsLangBackdoor222222222 = null;
                                                rmidLock = RMID_SEED_MONITOR.acquireCloseableLock();
                                                throwable = null;
                                                this.rmid = rmidSeed = (rmidSeed + 1) % 65536;
                                                if (rmidLock == null) break block165;
                                                if (throwable == null) break block166;
                                                try {
                                                    rmidLock.close();
                                                }
                                                catch (Throwable throwable26) {
                                                    throwable.addSuppressed(throwable26);
                                                }
                                                break block165;
                                            }
                                            rmidLock.close();
                                            break block165;
                                            catch (Throwable throwable27) {
                                                try {
                                                    throwable = throwable27;
                                                    Throwable throwable28 = throwable27;
                                                    if (bl) {
                                                        ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$8, this, throwable28);
                                                    }
                                                    throw throwable28;
                                                }
                                                catch (Throwable throwable29) {
                                                    if (rmidLock != null) {
                                                        if (throwable != null) {
                                                            try {
                                                                rmidLock.close();
                                                            }
                                                            catch (Throwable throwable30) {
                                                                throwable.addSuppressed(throwable30);
                                                            }
                                                        } else {
                                                            rmidLock.close();
                                                        }
                                                    }
                                                    Throwable throwable31 = throwable29;
                                                    if (bl) {
                                                        ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$8, this, throwable31);
                                                    }
                                                    throw throwable31;
                                                }
                                            }
                                        }
                                        if (this.connectionProperties == null) {
                                            this.connectionProperties = new Properties();
                                        }
                                        this.connectionProperties.put("RessourceManagerId", Integer.toString(this.rmid));
                                        if (userName != null) {
                                            prop2.setProperty("user", userName);
                                        }
                                        if (passwd != null) {
                                            prop2.setProperty("password", passwd);
                                        }
                                        if (this.maxStatementsSet) {
                                            prop2.setProperty("stmt_cache_size", "" + this.maxStatements);
                                        }
                                        if (this.implicitCachingEnabledSet) {
                                            prop2.setProperty("ImplicitStatementCachingEnabled", "" + this.implicitCachingEnabled);
                                        }
                                        if (this.explicitCachingEnabledSet) {
                                            prop2.setProperty("ExplicitStatementCachingEnabled", "" + this.explicitCachingEnabled);
                                        }
                                        if (this.loginTimeout != 0) {
                                            prop2.setProperty("LoginTimeout", "" + this.loginTimeout);
                                        }
                                        if (localInstanceName != null) {
                                            prop2.setProperty("oracle.jdbc.targetInstanceName", localInstanceName);
                                        }
                                        if (localServiceName != null) {
                                            prop2.setProperty("oracle.jdbc.targetServiceName", localServiceName);
                                        }
                                        if (shardingKeyStr != null) {
                                            prop2.setProperty("oracle.jdbc.targetShardingKey", shardingKeyStr);
                                        }
                                        if (superShardingKeyStr != null) {
                                            prop2.setProperty("oracle.jdbc.targetSuperShardingKey", superShardingKeyStr);
                                        }
                                        if ("true".equalsIgnoreCase(isReadOnlyInstanceAllowed)) {
                                            prop2.setProperty("oracle.jdbc.readOnlyInstanceAllowed", isReadOnlyInstanceAllowed);
                                        }
                                        if (lock2 == null) break block167;
                                        if (propNlsLangBackdoor222222222 == null) break block168;
                                        try {
                                            lock2.close();
                                        }
                                        catch (Throwable throwable) {
                                            propNlsLangBackdoor222222222.addSuppressed(throwable);
                                        }
                                        break block167;
                                    }
                                    lock2.close();
                                    break block167;
                                    catch (Throwable throwable) {
                                        try {
                                            propNlsLangBackdoor222222222 = throwable;
                                            Throwable throwable32 = throwable;
                                            if (bl) {
                                                ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$8, this, throwable32);
                                            }
                                            throw throwable32;
                                        }
                                        catch (Throwable throwable33) {
                                            if (lock2 != null) {
                                                if (propNlsLangBackdoor222222222 != null) {
                                                    try {
                                                        lock2.close();
                                                    }
                                                    catch (Throwable throwable34) {
                                                        propNlsLangBackdoor222222222.addSuppressed(throwable34);
                                                    }
                                                } else {
                                                    lock2.close();
                                                }
                                            }
                                            Throwable throwable35 = throwable33;
                                            if (bl) {
                                                ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$8, this, throwable35);
                                            }
                                            throw throwable35;
                                        }
                                    }
                                }
                                T4CXAConnection conn = new T4CXAConnection(super.getPhysicalConnection(prop2, (AbstractConnectionBuilder)builder));
                                String l_xaLoose322222222 = this.connectionProperties != null ? this.connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
                                conn.isXAResourceTransLoose = l_xaLoose322222222 != null && (l_xaLoose322222222.equals("true") || l_xaLoose322222222.equalsIgnoreCase("true"));
                                t4CXAConnection = conn;
                                if (!bl) break block169;
                                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$8, this, t4CXAConnection);
                                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$8, this, null);
                            }
                            return t4CXAConnection;
                        }
                        if (bl) {
                            this.debug($$$loggerRef$$$8, Level.FINEST, $$$methodRef$$$8, "OracleXADataSource.getPooledConnection(user, pwd) return: non-oci");
                        }
                        prop = new Properties();
                        lock = this.acquireCloseableLock();
                        l_xaLoose322222222 = null;
                        if (userName != null) {
                            prop.setProperty("user", userName);
                        }
                        if (passwd != null) {
                            prop.setProperty("password", passwd);
                        }
                        if (this.maxStatementsSet) {
                            prop.setProperty("stmt_cache_size", "" + this.maxStatements);
                        }
                        if (this.implicitCachingEnabledSet) {
                            prop.setProperty("ImplicitStatementCachingEnabled", "" + this.implicitCachingEnabled);
                        }
                        if (this.explicitCachingEnabledSet) {
                            prop.setProperty("ExplicitStatementCachingEnabled", "" + this.explicitCachingEnabled);
                        }
                        if (this.loginTimeout != 0) {
                            prop.setProperty("LoginTimeout", "" + this.loginTimeout);
                        }
                        if (localInstanceName != null) {
                            prop.setProperty("oracle.jdbc.targetInstanceName", localInstanceName);
                        }
                        if (localServiceName != null) {
                            prop.setProperty("oracle.jdbc.targetServiceName", localServiceName);
                        }
                        if (shardingKeyStr != null) {
                            prop.setProperty("oracle.jdbc.targetShardingKey", shardingKeyStr);
                        }
                        if (superShardingKeyStr != null) {
                            prop.setProperty("oracle.jdbc.targetSuperShardingKey", superShardingKeyStr);
                        }
                        if ("true".equalsIgnoreCase(isReadOnlyInstanceAllowed)) {
                            prop.setProperty("oracle.jdbc.readOnlyInstanceAllowed", isReadOnlyInstanceAllowed);
                        }
                        if (lock == null) break block170;
                        if (l_xaLoose322222222 == null) break block171;
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable) {
                            l_xaLoose322222222.addSuppressed(throwable);
                        }
                        break block170;
                    }
                    lock.close();
                    break block170;
                    catch (Throwable throwable) {
                        try {
                            l_xaLoose322222222 = throwable;
                            Throwable throwable36 = throwable;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$8, this, throwable36);
                            }
                            throw throwable36;
                        }
                        catch (Throwable throwable37) {
                            if (lock != null) {
                                if (l_xaLoose322222222 != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable38) {
                                        l_xaLoose322222222.addSuppressed(throwable38);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable39 = throwable37;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$8, this, throwable39);
                            }
                            throw throwable39;
                        }
                    }
                }
                OracleXAConnection l_xaconn = new OracleXAConnection(super.getPhysicalConnection(prop, null));
                l_xaLoose322222222 = this.connectionProperties != null ? this.connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
                l_xaconn.isXAResourceTransLoose = l_xaLoose322222222 != null && (((String)((Object)l_xaLoose322222222)).equals("true") || ((String)((Object)l_xaLoose322222222)).equalsIgnoreCase("true"));
                oracleXAConnection = l_xaconn;
                if (!bl) break block172;
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$8, this, oracleXAConnection);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$8, this, null);
            }
            return oracleXAConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable40 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$8, this, throwable40);
            }
            throw throwable;
        }
    }

    private native int t2cDoXaOpen(String var1, int var2, int var3, int var4);

    private native int t2cConvertOciHandles(String var1, long[] var2);

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setRmid(int n2) {
        boolean bl = (0x4000010C000000L & TraceControllerImpl.feature) != 0L;
        try {
            block18: {
                Monitor.CloseableLock lock;
                block19: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$9, this, n2);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        void rmid;
                        this.rmid = rmid;
                        if (lock == null) break block18;
                        if (throwable == null) break block19;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$9, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$9, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                lock.close();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$9, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int getRmid() {
        boolean bl = (0x4000010C000000L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            block18: {
                Monitor.CloseableLock lock;
                block19: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$10, this, new Object[0]);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        n2 = this.rmid;
                        if (lock == null) break block18;
                        if (throwable == null) break block19;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$10, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$10, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$10, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$10, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                lock.close();
            }
            int n3 = n2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$10, this, n3);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$10, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$10, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setXaOpenString(String string) {
        boolean bl = (0x4000010C000000L & TraceControllerImpl.feature) != 0L;
        try {
            block18: {
                Monitor.CloseableLock lock;
                block19: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$11, this, string);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        void xaOpenString;
                        this.xaOpenString = xaOpenString;
                        if (lock == null) break block18;
                        if (throwable == null) break block19;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$11, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$11, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                lock.close();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$11, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String getXaOpenString() {
        boolean bl = (0x4000010C000000L & TraceControllerImpl.feature) != 0L;
        try {
            String string;
            block18: {
                Monitor.CloseableLock lock;
                block19: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$12, this, new Object[0]);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        string = this.xaOpenString;
                        if (lock == null) break block18;
                        if (throwable == null) break block19;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$12, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$12, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                lock.close();
            }
            String string2 = string;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$12, this, string2);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$12, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$12, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Blind
    private String generateXAOpenString(String string, String string2, String string3, @Blind String string4, int n2, int n3, boolean bl, boolean bl2, String string5, int n4, boolean bl3, boolean bl4, String string6, String string7) {
        boolean bl5 = (0x4000010C000000L & TraceControllerImpl.feature) != 0L;
        try {
            void dbNCharCsId;
            void dbCsId;
            void isLoose;
            void cacheFlag;
            void traceLevel;
            void objectFlag;
            void threadFlag;
            void connectString;
            void logDir;
            void lockTimeout;
            void sessionTimeout;
            void passwd;
            void userName;
            void rmName;
            if (bl5) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$13, this, string, string2, string3, "*****", n2, n3, bl, bl2, string5, n4, bl3, bl4, string6, string7);
            }
            String string8 = "ORACLE_XA+DB=" + (String)rmName + "+ACC=P/" + (String)userName + "/" + (String)passwd + "+SESTM=" + (int)sessionTimeout + "+SESWT=" + (int)lockTimeout + "+LOGDIR=" + (String)logDir + "+SQLNET=" + (String)connectString + (threadFlag != false ? "+THREADS=true" : "") + (objectFlag != false ? "+OBJECTS=true" : "") + "+DBGFL=0x" + (int)traceLevel + (cacheFlag != false ? "+CONNCACHE=t" : "+CONNCACHE=f") + (isLoose != false ? "+Loose_Coupling=t" : "") + "+CharSet=" + (String)dbCsId + "+NCharSet=" + (String)dbNCharCsId;
            if (bl5) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$13, this, "*****");
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$13, this, null);
            }
            return string8;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl5) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String generateXACloseString(String string, boolean bl) {
        boolean bl2 = (0x4000010C000000L & TraceControllerImpl.feature) != 0L;
        try {
            void cacheFlag;
            void rmName;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$14, this, string, bl);
            }
            String string2 = "ORACLE_XA+DB=" + (String)rmName + (cacheFlag != false ? "+CONNCACHE=t" : "+CONNCACHE=f");
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$14, this, string2);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$14, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getTNSEntryFromUrl(String string) {
        boolean bl = (0x4000010C000000L & TraceControllerImpl.feature) != 0L;
        try {
            void url;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$15, this, string);
            }
            int at_sign = url.indexOf(64);
            String string2 = url.substring(at_sign + 1);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$15, this, string2);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$15, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$000(String string, String string2) {
        boolean bl = (0x4000010C000000L & TraceControllerImpl.feature) != 0L;
        try {
            void x1;
            String x0;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$17, null, string, string2);
            }
            String string3 = OracleXADataSource.getSystemProperty(x0, (String)x1);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$17, null, string3);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$17, null, null);
            }
            return string3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$17, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ XAConnection access$100(OracleXADataSource oracleXADataSource, OracleXAConnectionBuilderImpl oracleXAConnectionBuilderImpl, boolean bl) throws SQLException {
        boolean bl2 = (0x4000010C000000L & TraceControllerImpl.feature) != 0L;
        try {
            void x2;
            void x1;
            OracleXADataSource x0;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$18, null, oracleXADataSource, oracleXAConnectionBuilderImpl, bl);
            }
            XAConnection xAConnection = x0.getXAConnectionInternal((OracleXAConnectionBuilderImpl)x1, (boolean)x2);
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$18, null, xAConnection);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$18, null, null);
            }
            return xAConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$18, null, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$19 = OracleXADataSource.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$18 = OracleXADataSource.class.getDeclaredMethod("access$100", OracleXADataSource.class, OracleXAConnectionBuilderImpl.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$17 = OracleXADataSource.class.getDeclaredMethod("access$000", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$16 = OracleXADataSource.class.getDeclaredMethod("createXAConnectionBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$15 = OracleXADataSource.class.getDeclaredMethod("getTNSEntryFromUrl", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$14 = OracleXADataSource.class.getDeclaredMethod("generateXACloseString", String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$13 = OracleXADataSource.class.getDeclaredMethod("generateXAOpenString", String.class, String.class, String.class, String.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, String.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$12 = OracleXADataSource.class.getDeclaredMethod("getXaOpenString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$11 = OracleXADataSource.class.getDeclaredMethod("setXaOpenString", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$10 = OracleXADataSource.class.getDeclaredMethod("getRmid", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$9 = OracleXADataSource.class.getDeclaredMethod("setRmid", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$8 = OracleXADataSource.class.getDeclaredMethod("getPooledConnection", Properties.class, OracleXAConnectionBuilderImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$7 = OracleXADataSource.class.getDeclaredMethod("getPooledConnection", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$6 = OracleXADataSource.class.getDeclaredMethod("getPooledConnection", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$5 = OracleXADataSource.class.getDeclaredMethod("getXAConnectionInternal", OracleXAConnectionBuilderImpl.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$4 = OracleXADataSource.class.getDeclaredMethod("createXAConnectionBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$3 = OracleXADataSource.class.getDeclaredMethod("getXAConnection", OracleXAConnectionBuilderImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$2 = OracleXADataSource.class.getDeclaredMethod("getXAConnection", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$1 = OracleXADataSource.class.getDeclaredMethod("getXAConnection", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$0 = OracleXADataSource.class.getDeclaredMethod("getXAConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        libraryLoaded = false;
        LOAD_LIBRARY_MONITOR = Monitor.newInstance();
        rmidSeed = 0;
        RMID_SEED_MONITOR = Monitor.newInstance();
    }
}

