/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version10;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.firebirdsql.gds.EventHandle;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.listeners.DefaultDatabaseListener;
import org.firebirdsql.gds.ng.wire.AsynchronousChannelListener;
import org.firebirdsql.gds.ng.wire.AsynchronousChannelListenerDispatcher;
import org.firebirdsql.gds.ng.wire.FbWireAsynchronousChannel;
import org.firebirdsql.gds.ng.wire.FbWireDatabase;
import org.firebirdsql.gds.ng.wire.GenericResponse;
import org.firebirdsql.gds.ng.wire.WireEventHandle;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.util.ByteArrayHelper;

public class V10AsynchronousChannel
implements FbWireAsynchronousChannel {
    private static Logger log = LoggerFactory.getLogger(V10AsynchronousChannel.class);
    private static final int EVENT_BUFFER_SIZE = 2048;
    private final AsynchronousChannelListenerDispatcher channelListenerDispatcher = new AsynchronousChannelListenerDispatcher();
    private final FbWireDatabase database;
    private final ByteBuffer eventBuffer = ByteBuffer.allocate(2048);
    private int auxHandle;
    private SocketChannel socketChannel;
    private final Lock closeLock = new ReentrantLock();

    public V10AsynchronousChannel(FbWireDatabase database) {
        this.database = database;
        database.addDatabaseListener(new ChannelDatabaseListener());
    }

    @Override
    public void connect(String hostName, int portNumber, int auxHandle) throws SQLException {
        if (this.isConnected()) {
            throw new SQLException("Asynchronous channel already established");
        }
        this.auxHandle = auxHandle;
        try {
            this.socketChannel = SocketChannel.open();
            this.socketChannel.socket().setTcpNoDelay(true);
            InetSocketAddress socketAddress = new InetSocketAddress(hostName, portNumber);
            this.socketChannel.connect(socketAddress);
            this.socketChannel.configureBlocking(false);
        }
        catch (IOException ex) {
            throw new FbExceptionBuilder().exception(335544727).cause(ex).toSQLException();
        }
    }

    @Override
    public void close() throws SQLException {
        if (!this.isConnected()) {
            return;
        }
        if (!this.closeLock.tryLock()) {
            return;
        }
        try {
            if (!this.isConnected()) {
                return;
            }
            this.channelListenerDispatcher.channelClosing(this);
            this.socketChannel.close();
        }
        catch (IOException ex) {
            throw FbExceptionBuilder.forException(337248268).cause(ex).toFlatSQLException();
        }
        finally {
            this.socketChannel = null;
            this.closeLock.unlock();
        }
    }

    @Override
    public boolean isConnected() {
        return this.socketChannel != null && this.socketChannel.isConnected();
    }

    @Override
    public void addChannelListener(AsynchronousChannelListener listener) {
        this.channelListenerDispatcher.addListener(listener);
    }

    @Override
    public void removeChannelListener(AsynchronousChannelListener listener) {
        this.channelListenerDispatcher.removeListener(listener);
    }

    @Override
    public SocketChannel getSocketChannel() throws SQLException {
        if (!this.isConnected()) {
            throw new SQLException("Asynchronous channel not connected");
        }
        return this.socketChannel;
    }

    @Override
    public ByteBuffer getEventBuffer() {
        return this.eventBuffer;
    }

    @Override
    public void processEventData() {
        this.eventBuffer.flip();
        try {
            if (log.isDebugEnabled()) {
                if (this.eventBuffer.hasArray()) {
                    log.debug(this.eventBuffer + ": " + ByteArrayHelper.toHexString(this.eventBuffer.array()).substring(0, 2 * this.eventBuffer.limit()));
                } else {
                    log.debug(this.eventBuffer.toString());
                }
            }
            block8: while (this.eventBuffer.remaining() >= 4) {
                this.eventBuffer.mark();
                int operation = this.eventBuffer.getInt();
                switch (operation) {
                    case 71: {
                        continue block8;
                    }
                    case 2: 
                    case 6: {
                        this.close();
                        break block8;
                    }
                    case 52: {
                        if (this.processSingleEvent()) continue block8;
                        log.debug("Could not process entire event, resetting position for next channel read");
                        this.eventBuffer.reset();
                        break block8;
                    }
                    default: {
                        if (!log.isErrorEnabled()) continue block8;
                        log.error("Unexpected event operation received: " + operation + " position " + this.eventBuffer.position() + " limit " + this.eventBuffer.limit());
                        continue block8;
                    }
                }
            }
            this.eventBuffer.compact();
        }
        catch (SQLException e) {
            log.fatal("SQLException processing event data: " + e.getMessage(), e);
        }
        catch (Exception e) {
            log.fatal("Unexpected exception processing events: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queueEvent(EventHandle eventHandle) throws SQLException {
        if (!(eventHandle instanceof WireEventHandle)) {
            throw new SQLNonTransientException("Invalid event handle type: " + eventHandle.getClass().getName());
        }
        WireEventHandle wireEventHandle = (WireEventHandle)eventHandle;
        wireEventHandle.assignNewLocalId();
        this.addChannelListener(wireEventHandle);
        Object object = this.database.getSynchronizationObject();
        synchronized (object) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Queue event: " + wireEventHandle);
                }
                XdrOutputStream dbXdrOut = this.database.getXdrStreamAccess().getXdrOut();
                dbXdrOut.writeInt(48);
                dbXdrOut.writeInt(this.auxHandle);
                dbXdrOut.writeBuffer(wireEventHandle.toByteArray());
                dbXdrOut.writeLong(0L);
                dbXdrOut.writeInt(wireEventHandle.getLocalId());
                dbXdrOut.flush();
            }
            catch (IOException e) {
                throw new FbExceptionBuilder().exception(335544727).cause(e).toSQLException();
            }
            try {
                GenericResponse response = this.database.readGenericResponse(null);
                wireEventHandle.setEventId(response.getObjectHandle());
            }
            catch (IOException e) {
                throw new FbExceptionBuilder().exception(335544726).cause(e).toSQLException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelEvent(EventHandle eventHandle) throws SQLException {
        if (!(eventHandle instanceof WireEventHandle)) {
            throw new SQLNonTransientException("Invalid event handle type: " + eventHandle.getClass().getName());
        }
        WireEventHandle wireEventHandle = (WireEventHandle)eventHandle;
        this.removeChannelListener(wireEventHandle);
        Object object = this.database.getSynchronizationObject();
        synchronized (object) {
            try {
                XdrOutputStream dbXdrOut = this.database.getXdrStreamAccess().getXdrOut();
                dbXdrOut.writeInt(49);
                dbXdrOut.writeInt(this.database.getHandle());
                dbXdrOut.writeInt(wireEventHandle.getLocalId());
                dbXdrOut.flush();
            }
            catch (IOException e) {
                throw new FbExceptionBuilder().exception(335544727).cause(e).toSQLException();
            }
            try {
                this.database.readGenericResponse(null);
            }
            catch (IOException e) {
                throw new FbExceptionBuilder().exception(335544726).cause(e).toSQLException();
            }
        }
    }

    private boolean processSingleEvent() {
        if (this.eventBuffer.remaining() < 20) {
            return false;
        }
        try {
            this.eventBuffer.getInt();
            int bufferLength = this.eventBuffer.getInt();
            int padding = 4 - bufferLength & 3;
            if (this.eventBuffer.remaining() < bufferLength + padding + 12) {
                return false;
            }
            byte[] buffer = new byte[bufferLength];
            this.eventBuffer.get(buffer);
            this.eventBuffer.position(this.eventBuffer.position() + padding);
            int eventCount = 0;
            if (bufferLength > 4) {
                eventCount = VaxEncoding.iscVaxInteger(buffer, bufferLength - 4, 4);
            }
            this.eventBuffer.getLong();
            int eventId = this.eventBuffer.getInt();
            if (log.isDebugEnabled()) {
                log.debug(String.format("Received event id %d, eventCount %d", eventId, eventCount));
            }
            this.channelListenerDispatcher.eventReceived(this, new AsynchronousChannelListener.Event(eventId, eventCount));
            return true;
        }
        catch (BufferUnderflowException ex) {
            return false;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private class ChannelDatabaseListener
    extends DefaultDatabaseListener {
        private ChannelDatabaseListener() {
        }

        @Override
        public void detached(FbDatabase database) {
            try {
                V10AsynchronousChannel.this.close();
            }
            catch (Exception ex) {
                log.error("Exception closing asynchronous channel in response to a FbDatabase detached event", ex);
            }
        }
    }
}

