/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import us.fatehi.utility.Utility;

public final class CommandDescription
implements Serializable,
Comparable<CommandDescription> {
    private static final long serialVersionUID = 2444083929278551904L;
    private static Comparator<CommandDescription> comparator = Comparator.nullsLast(Comparator.comparing(CommandDescription::getName, String.CASE_INSENSITIVE_ORDER));
    private final String name;
    private final String description;

    public CommandDescription(String name, String description) {
        this.name = Utility.requireNotBlank((String)name, (String)"Command name not provided");
        this.description = Utility.isBlank((CharSequence)description) ? null : description;
    }

    @Override
    public int compareTo(CommandDescription otherProperty) {
        return Objects.compare(this, otherProperty, comparator);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommandDescription)) {
            return false;
        }
        CommandDescription other = (CommandDescription)obj;
        return Objects.equals(this.name, other.name);
    }

    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name);
        if (this.description != null) {
            builder.append(" - ").append(this.description);
        }
        return builder.toString();
    }
}

