SELECT
  'HOST_NAME' AS NAME,
  HOST_NAME AS VALUE,
  'Server host name.' AS DESCRIPTION
FROM
  TABLE(SYSPROC.ENV_GET_SYS_INFO()) AS SYSTEMINFO
UNION ALL
SELECT
  'OS_NAME' AS NAME,
  OS_NAME AS VALUE,
  'Server operating system.' AS DESCRIPTION
FROM
  TABLE(SYSPROC.ENV_GET_SYS_INFO()) AS SYSTEMINFO
UNION ALL
SELECT
  'TOTAL_CPUS' AS NAME,
  CAST(TOTAL_CPUS AS VARCHAR) AS VALUE,
  'Server total CPUs.' AS DESCRIPTION
FROM
  TABLE(SYSPROC.ENV_GET_SYS_INFO()) AS SYSTEMINFO
UNION ALL
SELECT
  'TOTAL_MEMORY' AS NAME,
  CAST(TOTAL_MEMORY AS VARCHAR) AS VALUE,
  'Server total memory.' AS DESCRIPTION
FROM
  TABLE(SYSPROC.ENV_GET_SYS_INFO()) AS SYSTEMINFO
