SELECT /*+ PARALLEL(AUTO) */
  NULL AS CONSTRAINT_CATALOG,
  CONSTRAINTS.OWNER AS CONSTRAINT_SCHEMA,
  CONSTRAINTS.CONSTRAINT_NAME,
  CONSTRAINTS.TABLE_NAME,
  DBMS_METADATA.GET_DDL('CONSTRAINT', CONSTRAINTS.CONSTRAINT_NAME, CONSTRAINTS.OWNER) AS CONSTRAINT_DEFINITION,
  NULL AS REMARKS
FROM
  ${catalogscope}_CONSTRAINTS CONSTRAINTS
WHERE
  CONSTRAINTS.OWNER NOT IN 
    ('ANONYMOUS', 'APEX_PUBLIC_USER', 'APPQOSSYS', 'BI', 'CTXSYS', 'DBSNMP', 'DIP', 
    'EXFSYS', 'FLOWS_30000', 'FLOWS_FILES', 'GSMADMIN_INTERNAL', 'IX', 'LBACSYS', 
    'MDDATA', 'MDSYS', 'MGMT_VIEW', 'OE', 'OLAPSYS', 'ORACLE_OCM', 
    'ORDPLUGINS', 'ORDSYS', 'OUTLN', 'OWBSYS', 'PM', 'SCOTT', 'SH', 
    'SI_INFORMTN_SCHEMA', 'SPATIAL_CSW_ADMIN_USR', 'SPATIAL_WFS_ADMIN_USR', 
    'SYS', 'SYSMAN', 'SYSTEM', 'TSMSYS', 'WKPROXY', 'WKSYS', 'WK_TEST', 
    'WMSYS', 'XDB', 'XS$NULL', 'RDSADMIN')  
  AND NOT REGEXP_LIKE(CONSTRAINTS.OWNER, '^APEX_[0-9]{6}$')
  AND NOT REGEXP_LIKE(CONSTRAINTS.OWNER, '^FLOWS_[0-9]{5,6}$')
  AND REGEXP_LIKE(CONSTRAINTS.OWNER, '${schemas}')
  AND CONSTRAINTS.TABLE_NAME NOT LIKE 'BIN$%'
  AND NOT REGEXP_LIKE(CONSTRAINTS.TABLE_NAME, '^(SYS_IOT|MDOS|MDRS|MDRT|MDOT|MDXT)_.*$')
  AND CONSTRAINT_TYPE IN ('C', 'U', 'P')
