"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.gitInstanceFactory = exports.gitExportFactory = exports.esModuleFactory = void 0;
const api_1 = require("./api");
const plugins_1 = require("./plugins");
const utils_1 = require("./utils");
const Git = require('../git');
/**
 * Adds the necessary properties to the supplied object to enable it for use as
 * the default export of a module.
 *
 * Eg: `module.exports = esModuleFactory({ something () {} })`
 */
function esModuleFactory(defaultExport) {
    return Object.defineProperties(defaultExport, {
        __esModule: { value: true },
        default: { value: defaultExport },
    });
}
exports.esModuleFactory = esModuleFactory;
function gitExportFactory(factory, extra) {
    return Object.assign(function (...args) {
        return factory.apply(null, args);
    }, api_1.default, extra || {});
}
exports.gitExportFactory = gitExportFactory;
function gitInstanceFactory(baseDir, options) {
    const plugins = new plugins_1.PluginStore();
    const config = utils_1.createInstanceConfig(baseDir && (typeof baseDir === 'string' ? { baseDir } : baseDir) || {}, options);
    if (!utils_1.folderExists(config.baseDir)) {
        throw new api_1.default.GitConstructError(config, `Cannot use simple-git on a directory that does not exist`);
    }
    if (Array.isArray(config.config)) {
        plugins.add(plugins_1.commandConfigPrefixingPlugin(config.config));
    }
    plugins.add(plugins_1.completionDetectionPlugin(config.completion));
    config.progress && plugins.add(plugins_1.progressMonitorPlugin(config.progress));
    config.timeout && plugins.add(plugins_1.timeoutPlugin(config.timeout));
    config.spawnOptions && plugins.add(plugins_1.spawnOptionsPlugin(config.spawnOptions));
    plugins.add(plugins_1.errorDetectionPlugin(plugins_1.errorDetectionHandler(true)));
    config.errors && plugins.add(plugins_1.errorDetectionPlugin(config.errors));
    return new Git(config, plugins);
}
exports.gitInstanceFactory = gitInstanceFactory;
//# sourceMappingURL=git-factory.js.map