#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 ShellCheck
version:              0.7.2
visibility:           public
id:                   ShellCheck-0.7.2-46Cn7Sah2M14zcXpTRxlga
key:                  ShellCheck-0.7.2-46Cn7Sah2M14zcXpTRxlga
license:              GPL-3.0-only
maintainer:           vidar@vidarholen.net
author:               Vidar Holen
homepage:             https://www.shellcheck.net/
synopsis:             Shell script analysis tool
description:
    The goals of ShellCheck are:

    * To point out and clarify typical beginner'\''s syntax issues,
    that causes a shell to give cryptic error messages.

    * To point out and clarify typical intermediate level semantic problems,
    that causes a shell to behave strangely and counter-intuitively.

    * To point out subtle caveats, corner cases and pitfalls, that may cause an
    advanced user'\''s otherwise working script to fail under future circumstances.

category:             Static Analysis
abi:                  cc6444858586ae0a674f3112c617ff35
exposed:              True
exposed-modules:
    ShellCheck.AST ShellCheck.ASTLib ShellCheck.Analytics
    ShellCheck.Analyzer ShellCheck.AnalyzerLib ShellCheck.Checker
    ShellCheck.Checks.Commands ShellCheck.Checks.Custom
    ShellCheck.Checks.ShellSupport ShellCheck.Data ShellCheck.Fixer
    ShellCheck.Formatter.CheckStyle ShellCheck.Formatter.Diff
    ShellCheck.Formatter.Format ShellCheck.Formatter.GCC
    ShellCheck.Formatter.JSON ShellCheck.Formatter.JSON1
    ShellCheck.Formatter.Quiet ShellCheck.Formatter.TTY
    ShellCheck.Interface ShellCheck.Parser ShellCheck.Regex

hidden-modules:       Paths_ShellCheck
import-dirs:          /usr/lib/ghc-9.0.1/site-local/ShellCheck-0.7.2
library-dirs:         /usr/lib/ghc-9.0.1/site-local/ShellCheck-0.7.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/ShellCheck-0.7.2
hs-libraries:         HSShellCheck-0.7.2-46Cn7Sah2M14zcXpTRxlga
depends:
    Diff-0.4.0-F7vyJzYzam9CwrUJdg8bD2
    QuickCheck-2.14.2-Hi2DusSU1aNLBaKmssS2cn
    aeson-1.5.6.0-6DdSUx8dbuIIjP00Zg5a6S array-0.5.4.0 base-4.15.0.0
    bytestring-0.10.12.1 containers-0.6.4.1 deepseq-1.4.5.0
    directory-1.3.6.1 filepath-1.4.2.1 mtl-2.2.2 parsec-3.1.14.0
    process-1.6.11.0 regex-tdfa-1.3.1.1-8KBKH3EsotI2v3BWqoG8PB

haddock-interfaces:   /usr/share/doc/shellcheck/html/ShellCheck.haddock
haddock-html:         /usr/share/doc/shellcheck/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

