/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/heic-convert/index.js":
/*!********************************************!*\
  !*** ./node_modules/heic-convert/index.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const jpegJs = __webpack_require__(/*! jpeg-js */ "./node_modules/jpeg-js/index.js");
const { PNG } = __webpack_require__(/*! pngjs */ "./node_modules/pngjs/lib/png.js");

const decode = __webpack_require__(/*! heic-decode */ "./node_modules/heic-decode/index.js");

const to = {
  JPEG: ({ data, width, height, quality }) => jpegJs.encode({ data, width, height }, quality).data,
  PNG: ({ data, width, height }) => {
    const png = new PNG({ width, height });
    png.data = data;

    return PNG.sync.write(png, {
      width: width,
      height: height,
      deflateLevel: 9,
      deflateStrategy: 3,
      filterType: -1,
      colorType: 6,
      inputHasAlpha: true
    });
  }
};

const convertImage = async ({ image, format, quality }) => {
  return await to[format]({
    width: image.width,
    height: image.height,
    data: Buffer.from(image.data),
    quality: Math.floor(quality * 100)
  });
};

const convert = async ({ buffer, format, quality, all }) => {
  if (!to[format]) {
    throw new Error(`output format needs to be one of [${Object.keys(to)}]`);
  }

  if (!all) {
    const image = await decode({ buffer });
    return await convertImage({ image, format, quality });
  }

  const images = await decode.all({ buffer });

  return images.map(image => {
    return {
      convert: async () => await convertImage({
        image: await image.decode(),
        format,
        quality
      })
    };
  });
};

module.exports = async ({ buffer, format, quality = 0.92 }) => await convert({ buffer, format, quality, all: false });
module.exports.all = async ({ buffer, format, quality = 0.92 }) => await convert({ buffer, format, quality, all: true });


/***/ }),

/***/ "./node_modules/heic-decode/index.js":
/*!*******************************************!*\
  !*** ./node_modules/heic-decode/index.js ***!
  \*******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const libheif = __webpack_require__(/*! libheif-js */ "./node_modules/libheif-js/libheif/libheif.js");

const uint8ArrayUtf8ByteString = (array, start, end) => {
  return String.fromCharCode(...array.slice(start, end));
};

// brands explained: https://github.com/strukturag/libheif/issues/83
// code adapted from: https://github.com/sindresorhus/file-type/blob/6f901bd82b849a85ca4ddba9c9a4baacece63d31/core.js#L428-L438
const isHeic = (buffer) => {
  const brandMajor = uint8ArrayUtf8ByteString(buffer, 8, 12).replace('\0', ' ').trim();

  switch (brandMajor) {
    case 'mif1':
      return true; // {ext: 'heic', mime: 'image/heif'};
    case 'msf1':
      return true; // {ext: 'heic', mime: 'image/heif-sequence'};
    case 'heic':
    case 'heix':
      return true; // {ext: 'heic', mime: 'image/heic'};
    case 'hevc':
    case 'hevx':
      return true; // {ext: 'heic', mime: 'image/heic-sequence'};
  }

  return false;
};

const decodeImage = async (image) => {
  const width = image.get_width();
  const height = image.get_height();

  const arrayBuffer = await new Promise((resolve, reject) => {
    image.display({ data: new Uint8ClampedArray(width*height*4), width, height }, (displayData) => {
      if (!displayData) {
        return reject(new Error('HEIF processing error'));
      }

      // get the ArrayBuffer from the Uint8Array
      resolve(displayData.data.buffer);
    });
  });

  return { width, height, data: arrayBuffer };
};

const decodeBuffer = async ({ buffer, all }) => {
  if (!isHeic(buffer)) {
    throw new TypeError('input buffer is not a HEIC image');
  }

  const decoder = new libheif.HeifDecoder();
  const data = decoder.decode(buffer);

  if (!data.length) {
    throw new Error('HEIF image not found');
  }

  if (!all) {
    return await decodeImage(data[0]);
  }

  return data.map(image => {
    return {
      decode: async () => await decodeImage(image)
    };
  });
};

module.exports = async ({ buffer }) => await decodeBuffer({ buffer, all: false });
module.exports.all = async ({ buffer }) => await decodeBuffer({ buffer, all: true });


/***/ }),

/***/ "./node_modules/jpeg-js/index.js":
/*!***************************************!*\
  !*** ./node_modules/jpeg-js/index.js ***!
  \***************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var encode = __webpack_require__(/*! ./lib/encoder */ "./node_modules/jpeg-js/lib/encoder.js"),
    decode = __webpack_require__(/*! ./lib/decoder */ "./node_modules/jpeg-js/lib/decoder.js");

module.exports = {
  encode: encode,
  decode: decode
};


/***/ }),

/***/ "./node_modules/jpeg-js/lib/decoder.js":
/*!*********************************************!*\
  !*** ./node_modules/jpeg-js/lib/decoder.js ***!
  \*********************************************/
/***/ ((module) => {

/* -*- tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- /
/* vim: set shiftwidth=2 tabstop=2 autoindent cindent expandtab: */
/*
   Copyright 2011 notmasteryet

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

// - The JPEG specification can be found in the ITU CCITT Recommendation T.81
//   (www.w3.org/Graphics/JPEG/itu-t81.pdf)
// - The JFIF specification can be found in the JPEG File Interchange Format
//   (www.w3.org/Graphics/JPEG/jfif3.pdf)
// - The Adobe Application-Specific JPEG markers in the Supporting the DCT Filters
//   in PostScript Level 2, Technical Note #5116
//   (partners.adobe.com/public/developer/en/ps/sdk/5116.DCT_Filter.pdf)

var JpegImage = (function jpegImage() {
  "use strict";
  var dctZigZag = new Int32Array([
     0,
     1,  8,
    16,  9,  2,
     3, 10, 17, 24,
    32, 25, 18, 11, 4,
     5, 12, 19, 26, 33, 40,
    48, 41, 34, 27, 20, 13,  6,
     7, 14, 21, 28, 35, 42, 49, 56,
    57, 50, 43, 36, 29, 22, 15,
    23, 30, 37, 44, 51, 58,
    59, 52, 45, 38, 31,
    39, 46, 53, 60,
    61, 54, 47,
    55, 62,
    63
  ]);

  var dctCos1  =  4017   // cos(pi/16)
  var dctSin1  =   799   // sin(pi/16)
  var dctCos3  =  3406   // cos(3*pi/16)
  var dctSin3  =  2276   // sin(3*pi/16)
  var dctCos6  =  1567   // cos(6*pi/16)
  var dctSin6  =  3784   // sin(6*pi/16)
  var dctSqrt2 =  5793   // sqrt(2)
  var dctSqrt1d2 = 2896  // sqrt(2) / 2

  function constructor() {
  }

  function buildHuffmanTable(codeLengths, values) {
    var k = 0, code = [], i, j, length = 16;
    while (length > 0 && !codeLengths[length - 1])
      length--;
    code.push({children: [], index: 0});
    var p = code[0], q;
    for (i = 0; i < length; i++) {
      for (j = 0; j < codeLengths[i]; j++) {
        p = code.pop();
        p.children[p.index] = values[k];
        while (p.index > 0) {
          if (code.length === 0)
            throw new Error('Could not recreate Huffman Table');
          p = code.pop();
        }
        p.index++;
        code.push(p);
        while (code.length <= i) {
          code.push(q = {children: [], index: 0});
          p.children[p.index] = q.children;
          p = q;
        }
        k++;
      }
      if (i + 1 < length) {
        // p here points to last code
        code.push(q = {children: [], index: 0});
        p.children[p.index] = q.children;
        p = q;
      }
    }
    return code[0].children;
  }

  function decodeScan(data, offset,
                      frame, components, resetInterval,
                      spectralStart, spectralEnd,
                      successivePrev, successive, opts) {
    var precision = frame.precision;
    var samplesPerLine = frame.samplesPerLine;
    var scanLines = frame.scanLines;
    var mcusPerLine = frame.mcusPerLine;
    var progressive = frame.progressive;
    var maxH = frame.maxH, maxV = frame.maxV;

    var startOffset = offset, bitsData = 0, bitsCount = 0;
    function readBit() {
      if (bitsCount > 0) {
        bitsCount--;
        return (bitsData >> bitsCount) & 1;
      }
      bitsData = data[offset++];
      if (bitsData == 0xFF) {
        var nextByte = data[offset++];
        if (nextByte) {
          throw new Error("unexpected marker: " + ((bitsData << 8) | nextByte).toString(16));
        }
        // unstuff 0
      }
      bitsCount = 7;
      return bitsData >>> 7;
    }
    function decodeHuffman(tree) {
      var node = tree, bit;
      while ((bit = readBit()) !== null) {
        node = node[bit];
        if (typeof node === 'number')
          return node;
        if (typeof node !== 'object')
          throw new Error("invalid huffman sequence");
      }
      return null;
    }
    function receive(length) {
      var n = 0;
      while (length > 0) {
        var bit = readBit();
        if (bit === null) return;
        n = (n << 1) | bit;
        length--;
      }
      return n;
    }
    function receiveAndExtend(length) {
      var n = receive(length);
      if (n >= 1 << (length - 1))
        return n;
      return n + (-1 << length) + 1;
    }
    function decodeBaseline(component, zz) {
      var t = decodeHuffman(component.huffmanTableDC);
      var diff = t === 0 ? 0 : receiveAndExtend(t);
      zz[0]= (component.pred += diff);
      var k = 1;
      while (k < 64) {
        var rs = decodeHuffman(component.huffmanTableAC);
        var s = rs & 15, r = rs >> 4;
        if (s === 0) {
          if (r < 15)
            break;
          k += 16;
          continue;
        }
        k += r;
        var z = dctZigZag[k];
        zz[z] = receiveAndExtend(s);
        k++;
      }
    }
    function decodeDCFirst(component, zz) {
      var t = decodeHuffman(component.huffmanTableDC);
      var diff = t === 0 ? 0 : (receiveAndExtend(t) << successive);
      zz[0] = (component.pred += diff);
    }
    function decodeDCSuccessive(component, zz) {
      zz[0] |= readBit() << successive;
    }
    var eobrun = 0;
    function decodeACFirst(component, zz) {
      if (eobrun > 0) {
        eobrun--;
        return;
      }
      var k = spectralStart, e = spectralEnd;
      while (k <= e) {
        var rs = decodeHuffman(component.huffmanTableAC);
        var s = rs & 15, r = rs >> 4;
        if (s === 0) {
          if (r < 15) {
            eobrun = receive(r) + (1 << r) - 1;
            break;
          }
          k += 16;
          continue;
        }
        k += r;
        var z = dctZigZag[k];
        zz[z] = receiveAndExtend(s) * (1 << successive);
        k++;
      }
    }
    var successiveACState = 0, successiveACNextValue;
    function decodeACSuccessive(component, zz) {
      var k = spectralStart, e = spectralEnd, r = 0;
      while (k <= e) {
        var z = dctZigZag[k];
        var direction = zz[z] < 0 ? -1 : 1;
        switch (successiveACState) {
        case 0: // initial state
          var rs = decodeHuffman(component.huffmanTableAC);
          var s = rs & 15, r = rs >> 4;
          if (s === 0) {
            if (r < 15) {
              eobrun = receive(r) + (1 << r);
              successiveACState = 4;
            } else {
              r = 16;
              successiveACState = 1;
            }
          } else {
            if (s !== 1)
              throw new Error("invalid ACn encoding");
            successiveACNextValue = receiveAndExtend(s);
            successiveACState = r ? 2 : 3;
          }
          continue;
        case 1: // skipping r zero items
        case 2:
          if (zz[z])
            zz[z] += (readBit() << successive) * direction;
          else {
            r--;
            if (r === 0)
              successiveACState = successiveACState == 2 ? 3 : 0;
          }
          break;
        case 3: // set value for a zero item
          if (zz[z])
            zz[z] += (readBit() << successive) * direction;
          else {
            zz[z] = successiveACNextValue << successive;
            successiveACState = 0;
          }
          break;
        case 4: // eob
          if (zz[z])
            zz[z] += (readBit() << successive) * direction;
          break;
        }
        k++;
      }
      if (successiveACState === 4) {
        eobrun--;
        if (eobrun === 0)
          successiveACState = 0;
      }
    }
    function decodeMcu(component, decode, mcu, row, col) {
      var mcuRow = (mcu / mcusPerLine) | 0;
      var mcuCol = mcu % mcusPerLine;
      var blockRow = mcuRow * component.v + row;
      var blockCol = mcuCol * component.h + col;
      // If the block is missing and we're in tolerant mode, just skip it.
      if (component.blocks[blockRow] === undefined && opts.tolerantDecoding)
        return;
      decode(component, component.blocks[blockRow][blockCol]);
    }
    function decodeBlock(component, decode, mcu) {
      var blockRow = (mcu / component.blocksPerLine) | 0;
      var blockCol = mcu % component.blocksPerLine;
      // If the block is missing and we're in tolerant mode, just skip it.
      if (component.blocks[blockRow] === undefined && opts.tolerantDecoding)
        return;
      decode(component, component.blocks[blockRow][blockCol]);
    }

    var componentsLength = components.length;
    var component, i, j, k, n;
    var decodeFn;
    if (progressive) {
      if (spectralStart === 0)
        decodeFn = successivePrev === 0 ? decodeDCFirst : decodeDCSuccessive;
      else
        decodeFn = successivePrev === 0 ? decodeACFirst : decodeACSuccessive;
    } else {
      decodeFn = decodeBaseline;
    }

    var mcu = 0, marker;
    var mcuExpected;
    if (componentsLength == 1) {
      mcuExpected = components[0].blocksPerLine * components[0].blocksPerColumn;
    } else {
      mcuExpected = mcusPerLine * frame.mcusPerColumn;
    }
    if (!resetInterval) resetInterval = mcuExpected;

    var h, v;
    while (mcu < mcuExpected) {
      // reset interval stuff
      for (i = 0; i < componentsLength; i++)
        components[i].pred = 0;
      eobrun = 0;

      if (componentsLength == 1) {
        component = components[0];
        for (n = 0; n < resetInterval; n++) {
          decodeBlock(component, decodeFn, mcu);
          mcu++;
        }
      } else {
        for (n = 0; n < resetInterval; n++) {
          for (i = 0; i < componentsLength; i++) {
            component = components[i];
            h = component.h;
            v = component.v;
            for (j = 0; j < v; j++) {
              for (k = 0; k < h; k++) {
                decodeMcu(component, decodeFn, mcu, j, k);
              }
            }
          }
          mcu++;

          // If we've reached our expected MCU's, stop decoding
          if (mcu === mcuExpected) break;
        }
      }

      if (mcu === mcuExpected) {
        // Skip trailing bytes at the end of the scan - until we reach the next marker
        do {
          if (data[offset] === 0xFF) {
            if (data[offset + 1] !== 0x00) {
              break;
            }
          }
          offset += 1;
        } while (offset < data.length - 2);
      }

      // find marker
      bitsCount = 0;
      marker = (data[offset] << 8) | data[offset + 1];
      if (marker < 0xFF00) {
        throw new Error("marker was not found");
      }

      if (marker >= 0xFFD0 && marker <= 0xFFD7) { // RSTx
        offset += 2;
      }
      else
        break;
    }

    return offset - startOffset;
  }

  function buildComponentData(frame, component) {
    var lines = [];
    var blocksPerLine = component.blocksPerLine;
    var blocksPerColumn = component.blocksPerColumn;
    var samplesPerLine = blocksPerLine << 3;
    // Only 1 used per invocation of this function and garbage collected after invocation, so no need to account for its memory footprint.
    var R = new Int32Array(64), r = new Uint8Array(64);

    // A port of poppler's IDCT method which in turn is taken from:
    //   Christoph Loeffler, Adriaan Ligtenberg, George S. Moschytz,
    //   "Practical Fast 1-D DCT Algorithms with 11 Multiplications",
    //   IEEE Intl. Conf. on Acoustics, Speech & Signal Processing, 1989,
    //   988-991.
    function quantizeAndInverse(zz, dataOut, dataIn) {
      var qt = component.quantizationTable;
      var v0, v1, v2, v3, v4, v5, v6, v7, t;
      var p = dataIn;
      var i;

      // dequant
      for (i = 0; i < 64; i++)
        p[i] = zz[i] * qt[i];

      // inverse DCT on rows
      for (i = 0; i < 8; ++i) {
        var row = 8 * i;

        // check for all-zero AC coefficients
        if (p[1 + row] == 0 && p[2 + row] == 0 && p[3 + row] == 0 &&
            p[4 + row] == 0 && p[5 + row] == 0 && p[6 + row] == 0 &&
            p[7 + row] == 0) {
          t = (dctSqrt2 * p[0 + row] + 512) >> 10;
          p[0 + row] = t;
          p[1 + row] = t;
          p[2 + row] = t;
          p[3 + row] = t;
          p[4 + row] = t;
          p[5 + row] = t;
          p[6 + row] = t;
          p[7 + row] = t;
          continue;
        }

        // stage 4
        v0 = (dctSqrt2 * p[0 + row] + 128) >> 8;
        v1 = (dctSqrt2 * p[4 + row] + 128) >> 8;
        v2 = p[2 + row];
        v3 = p[6 + row];
        v4 = (dctSqrt1d2 * (p[1 + row] - p[7 + row]) + 128) >> 8;
        v7 = (dctSqrt1d2 * (p[1 + row] + p[7 + row]) + 128) >> 8;
        v5 = p[3 + row] << 4;
        v6 = p[5 + row] << 4;

        // stage 3
        t = (v0 - v1+ 1) >> 1;
        v0 = (v0 + v1 + 1) >> 1;
        v1 = t;
        t = (v2 * dctSin6 + v3 * dctCos6 + 128) >> 8;
        v2 = (v2 * dctCos6 - v3 * dctSin6 + 128) >> 8;
        v3 = t;
        t = (v4 - v6 + 1) >> 1;
        v4 = (v4 + v6 + 1) >> 1;
        v6 = t;
        t = (v7 + v5 + 1) >> 1;
        v5 = (v7 - v5 + 1) >> 1;
        v7 = t;

        // stage 2
        t = (v0 - v3 + 1) >> 1;
        v0 = (v0 + v3 + 1) >> 1;
        v3 = t;
        t = (v1 - v2 + 1) >> 1;
        v1 = (v1 + v2 + 1) >> 1;
        v2 = t;
        t = (v4 * dctSin3 + v7 * dctCos3 + 2048) >> 12;
        v4 = (v4 * dctCos3 - v7 * dctSin3 + 2048) >> 12;
        v7 = t;
        t = (v5 * dctSin1 + v6 * dctCos1 + 2048) >> 12;
        v5 = (v5 * dctCos1 - v6 * dctSin1 + 2048) >> 12;
        v6 = t;

        // stage 1
        p[0 + row] = v0 + v7;
        p[7 + row] = v0 - v7;
        p[1 + row] = v1 + v6;
        p[6 + row] = v1 - v6;
        p[2 + row] = v2 + v5;
        p[5 + row] = v2 - v5;
        p[3 + row] = v3 + v4;
        p[4 + row] = v3 - v4;
      }

      // inverse DCT on columns
      for (i = 0; i < 8; ++i) {
        var col = i;

        // check for all-zero AC coefficients
        if (p[1*8 + col] == 0 && p[2*8 + col] == 0 && p[3*8 + col] == 0 &&
            p[4*8 + col] == 0 && p[5*8 + col] == 0 && p[6*8 + col] == 0 &&
            p[7*8 + col] == 0) {
          t = (dctSqrt2 * dataIn[i+0] + 8192) >> 14;
          p[0*8 + col] = t;
          p[1*8 + col] = t;
          p[2*8 + col] = t;
          p[3*8 + col] = t;
          p[4*8 + col] = t;
          p[5*8 + col] = t;
          p[6*8 + col] = t;
          p[7*8 + col] = t;
          continue;
        }

        // stage 4
        v0 = (dctSqrt2 * p[0*8 + col] + 2048) >> 12;
        v1 = (dctSqrt2 * p[4*8 + col] + 2048) >> 12;
        v2 = p[2*8 + col];
        v3 = p[6*8 + col];
        v4 = (dctSqrt1d2 * (p[1*8 + col] - p[7*8 + col]) + 2048) >> 12;
        v7 = (dctSqrt1d2 * (p[1*8 + col] + p[7*8 + col]) + 2048) >> 12;
        v5 = p[3*8 + col];
        v6 = p[5*8 + col];

        // stage 3
        t = (v0 - v1 + 1) >> 1;
        v0 = (v0 + v1 + 1) >> 1;
        v1 = t;
        t = (v2 * dctSin6 + v3 * dctCos6 + 2048) >> 12;
        v2 = (v2 * dctCos6 - v3 * dctSin6 + 2048) >> 12;
        v3 = t;
        t = (v4 - v6 + 1) >> 1;
        v4 = (v4 + v6 + 1) >> 1;
        v6 = t;
        t = (v7 + v5 + 1) >> 1;
        v5 = (v7 - v5 + 1) >> 1;
        v7 = t;

        // stage 2
        t = (v0 - v3 + 1) >> 1;
        v0 = (v0 + v3 + 1) >> 1;
        v3 = t;
        t = (v1 - v2 + 1) >> 1;
        v1 = (v1 + v2 + 1) >> 1;
        v2 = t;
        t = (v4 * dctSin3 + v7 * dctCos3 + 2048) >> 12;
        v4 = (v4 * dctCos3 - v7 * dctSin3 + 2048) >> 12;
        v7 = t;
        t = (v5 * dctSin1 + v6 * dctCos1 + 2048) >> 12;
        v5 = (v5 * dctCos1 - v6 * dctSin1 + 2048) >> 12;
        v6 = t;

        // stage 1
        p[0*8 + col] = v0 + v7;
        p[7*8 + col] = v0 - v7;
        p[1*8 + col] = v1 + v6;
        p[6*8 + col] = v1 - v6;
        p[2*8 + col] = v2 + v5;
        p[5*8 + col] = v2 - v5;
        p[3*8 + col] = v3 + v4;
        p[4*8 + col] = v3 - v4;
      }

      // convert to 8-bit integers
      for (i = 0; i < 64; ++i) {
        var sample = 128 + ((p[i] + 8) >> 4);
        dataOut[i] = sample < 0 ? 0 : sample > 0xFF ? 0xFF : sample;
      }
    }

    requestMemoryAllocation(samplesPerLine * blocksPerColumn * 8);

    var i, j;
    for (var blockRow = 0; blockRow < blocksPerColumn; blockRow++) {
      var scanLine = blockRow << 3;
      for (i = 0; i < 8; i++)
        lines.push(new Uint8Array(samplesPerLine));
      for (var blockCol = 0; blockCol < blocksPerLine; blockCol++) {
        quantizeAndInverse(component.blocks[blockRow][blockCol], r, R);

        var offset = 0, sample = blockCol << 3;
        for (j = 0; j < 8; j++) {
          var line = lines[scanLine + j];
          for (i = 0; i < 8; i++)
            line[sample + i] = r[offset++];
        }
      }
    }
    return lines;
  }

  function clampTo8bit(a) {
    return a < 0 ? 0 : a > 255 ? 255 : a;
  }

  constructor.prototype = {
    load: function load(path) {
      var xhr = new XMLHttpRequest();
      xhr.open("GET", path, true);
      xhr.responseType = "arraybuffer";
      xhr.onload = (function() {
        // TODO catch parse error
        var data = new Uint8Array(xhr.response || xhr.mozResponseArrayBuffer);
        this.parse(data);
        if (this.onload)
          this.onload();
      }).bind(this);
      xhr.send(null);
    },
    parse: function parse(data) {
      var maxResolutionInPixels = this.opts.maxResolutionInMP * 1000 * 1000;
      var offset = 0, length = data.length;
      function readUint16() {
        var value = (data[offset] << 8) | data[offset + 1];
        offset += 2;
        return value;
      }
      function readDataBlock() {
        var length = readUint16();
        var array = data.subarray(offset, offset + length - 2);
        offset += array.length;
        return array;
      }
      function prepareComponents(frame) {
        var maxH = 0, maxV = 0;
        var component, componentId;
        for (componentId in frame.components) {
          if (frame.components.hasOwnProperty(componentId)) {
            component = frame.components[componentId];
            if (maxH < component.h) maxH = component.h;
            if (maxV < component.v) maxV = component.v;
          }
        }
        var mcusPerLine = Math.ceil(frame.samplesPerLine / 8 / maxH);
        var mcusPerColumn = Math.ceil(frame.scanLines / 8 / maxV);
        for (componentId in frame.components) {
          if (frame.components.hasOwnProperty(componentId)) {
            component = frame.components[componentId];
            var blocksPerLine = Math.ceil(Math.ceil(frame.samplesPerLine / 8) * component.h / maxH);
            var blocksPerColumn = Math.ceil(Math.ceil(frame.scanLines  / 8) * component.v / maxV);
            var blocksPerLineForMcu = mcusPerLine * component.h;
            var blocksPerColumnForMcu = mcusPerColumn * component.v;
            var blocksToAllocate = blocksPerColumnForMcu * blocksPerLineForMcu;
            var blocks = [];

            // Each block is a Int32Array of length 64 (4 x 64 = 256 bytes)
            requestMemoryAllocation(blocksToAllocate * 256);

            for (var i = 0; i < blocksPerColumnForMcu; i++) {
              var row = [];
              for (var j = 0; j < blocksPerLineForMcu; j++)
                row.push(new Int32Array(64));
              blocks.push(row);
            }
            component.blocksPerLine = blocksPerLine;
            component.blocksPerColumn = blocksPerColumn;
            component.blocks = blocks;
          }
        }
        frame.maxH = maxH;
        frame.maxV = maxV;
        frame.mcusPerLine = mcusPerLine;
        frame.mcusPerColumn = mcusPerColumn;
      }
      var jfif = null;
      var adobe = null;
      var pixels = null;
      var frame, resetInterval;
      var quantizationTables = [], frames = [];
      var huffmanTablesAC = [], huffmanTablesDC = [];
      var fileMarker = readUint16();
      var malformedDataOffset = -1;
      this.comments = [];
      if (fileMarker != 0xFFD8) { // SOI (Start of Image)
        throw new Error("SOI not found");
      }

      fileMarker = readUint16();
      while (fileMarker != 0xFFD9) { // EOI (End of image)
        var i, j, l;
        switch(fileMarker) {
          case 0xFF00: break;
          case 0xFFE0: // APP0 (Application Specific)
          case 0xFFE1: // APP1
          case 0xFFE2: // APP2
          case 0xFFE3: // APP3
          case 0xFFE4: // APP4
          case 0xFFE5: // APP5
          case 0xFFE6: // APP6
          case 0xFFE7: // APP7
          case 0xFFE8: // APP8
          case 0xFFE9: // APP9
          case 0xFFEA: // APP10
          case 0xFFEB: // APP11
          case 0xFFEC: // APP12
          case 0xFFED: // APP13
          case 0xFFEE: // APP14
          case 0xFFEF: // APP15
          case 0xFFFE: // COM (Comment)
            var appData = readDataBlock();

            if (fileMarker === 0xFFFE) {
              var comment = String.fromCharCode.apply(null, appData);
              this.comments.push(comment);
            }

            if (fileMarker === 0xFFE0) {
              if (appData[0] === 0x4A && appData[1] === 0x46 && appData[2] === 0x49 &&
                appData[3] === 0x46 && appData[4] === 0) { // 'JFIF\x00'
                jfif = {
                  version: { major: appData[5], minor: appData[6] },
                  densityUnits: appData[7],
                  xDensity: (appData[8] << 8) | appData[9],
                  yDensity: (appData[10] << 8) | appData[11],
                  thumbWidth: appData[12],
                  thumbHeight: appData[13],
                  thumbData: appData.subarray(14, 14 + 3 * appData[12] * appData[13])
                };
              }
            }
            // TODO APP1 - Exif
            if (fileMarker === 0xFFE1) {
              if (appData[0] === 0x45 &&
                appData[1] === 0x78 &&
                appData[2] === 0x69 &&
                appData[3] === 0x66 &&
                appData[4] === 0) { // 'EXIF\x00'
                this.exifBuffer = appData.subarray(5, appData.length);
              }
            }

            if (fileMarker === 0xFFEE) {
              if (appData[0] === 0x41 && appData[1] === 0x64 && appData[2] === 0x6F &&
                appData[3] === 0x62 && appData[4] === 0x65 && appData[5] === 0) { // 'Adobe\x00'
                adobe = {
                  version: appData[6],
                  flags0: (appData[7] << 8) | appData[8],
                  flags1: (appData[9] << 8) | appData[10],
                  transformCode: appData[11]
                };
              }
            }
            break;

          case 0xFFDB: // DQT (Define Quantization Tables)
            var quantizationTablesLength = readUint16();
            var quantizationTablesEnd = quantizationTablesLength + offset - 2;
            while (offset < quantizationTablesEnd) {
              var quantizationTableSpec = data[offset++];
              requestMemoryAllocation(64 * 4);
              var tableData = new Int32Array(64);
              if ((quantizationTableSpec >> 4) === 0) { // 8 bit values
                for (j = 0; j < 64; j++) {
                  var z = dctZigZag[j];
                  tableData[z] = data[offset++];
                }
              } else if ((quantizationTableSpec >> 4) === 1) { //16 bit
                for (j = 0; j < 64; j++) {
                  var z = dctZigZag[j];
                  tableData[z] = readUint16();
                }
              } else
                throw new Error("DQT: invalid table spec");
              quantizationTables[quantizationTableSpec & 15] = tableData;
            }
            break;

          case 0xFFC0: // SOF0 (Start of Frame, Baseline DCT)
          case 0xFFC1: // SOF1 (Start of Frame, Extended DCT)
          case 0xFFC2: // SOF2 (Start of Frame, Progressive DCT)
            readUint16(); // skip data length
            frame = {};
            frame.extended = (fileMarker === 0xFFC1);
            frame.progressive = (fileMarker === 0xFFC2);
            frame.precision = data[offset++];
            frame.scanLines = readUint16();
            frame.samplesPerLine = readUint16();
            frame.components = {};
            frame.componentsOrder = [];

            var pixelsInFrame = frame.scanLines * frame.samplesPerLine;
            if (pixelsInFrame > maxResolutionInPixels) {
              var exceededAmount = Math.ceil((pixelsInFrame - maxResolutionInPixels) / 1e6);
              throw new Error(`maxResolutionInMP limit exceeded by ${exceededAmount}MP`);
            }

            var componentsCount = data[offset++], componentId;
            var maxH = 0, maxV = 0;
            for (i = 0; i < componentsCount; i++) {
              componentId = data[offset];
              var h = data[offset + 1] >> 4;
              var v = data[offset + 1] & 15;
              var qId = data[offset + 2];
              frame.componentsOrder.push(componentId);
              frame.components[componentId] = {
                h: h,
                v: v,
                quantizationIdx: qId
              };
              offset += 3;
            }
            prepareComponents(frame);
            frames.push(frame);
            break;

          case 0xFFC4: // DHT (Define Huffman Tables)
            var huffmanLength = readUint16();
            for (i = 2; i < huffmanLength;) {
              var huffmanTableSpec = data[offset++];
              var codeLengths = new Uint8Array(16);
              var codeLengthSum = 0;
              for (j = 0; j < 16; j++, offset++) {
                codeLengthSum += (codeLengths[j] = data[offset]);
              }
              requestMemoryAllocation(16 + codeLengthSum);
              var huffmanValues = new Uint8Array(codeLengthSum);
              for (j = 0; j < codeLengthSum; j++, offset++)
                huffmanValues[j] = data[offset];
              i += 17 + codeLengthSum;

              ((huffmanTableSpec >> 4) === 0 ?
                huffmanTablesDC : huffmanTablesAC)[huffmanTableSpec & 15] =
                buildHuffmanTable(codeLengths, huffmanValues);
            }
            break;

          case 0xFFDD: // DRI (Define Restart Interval)
            readUint16(); // skip data length
            resetInterval = readUint16();
            break;

          case 0xFFDC: // Number of Lines marker
            readUint16() // skip data length
            readUint16() // Ignore this data since it represents the image height
            break;
            
          case 0xFFDA: // SOS (Start of Scan)
            var scanLength = readUint16();
            var selectorsCount = data[offset++];
            var components = [], component;
            for (i = 0; i < selectorsCount; i++) {
              component = frame.components[data[offset++]];
              var tableSpec = data[offset++];
              component.huffmanTableDC = huffmanTablesDC[tableSpec >> 4];
              component.huffmanTableAC = huffmanTablesAC[tableSpec & 15];
              components.push(component);
            }
            var spectralStart = data[offset++];
            var spectralEnd = data[offset++];
            var successiveApproximation = data[offset++];
            var processed = decodeScan(data, offset,
              frame, components, resetInterval,
              spectralStart, spectralEnd,
              successiveApproximation >> 4, successiveApproximation & 15, this.opts);
            offset += processed;
            break;

          case 0xFFFF: // Fill bytes
            if (data[offset] !== 0xFF) { // Avoid skipping a valid marker.
              offset--;
            }
            break;
          default:
            if (data[offset - 3] == 0xFF &&
                data[offset - 2] >= 0xC0 && data[offset - 2] <= 0xFE) {
              // could be incorrect encoding -- last 0xFF byte of the previous
              // block was eaten by the encoder
              offset -= 3;
              break;
            }
            else if (fileMarker === 0xE0 || fileMarker == 0xE1) {
              // Recover from malformed APP1 markers popular in some phone models.
              // See https://github.com/eugeneware/jpeg-js/issues/82
              if (malformedDataOffset !== -1) {
                throw new Error(`first unknown JPEG marker at offset ${malformedDataOffset.toString(16)}, second unknown JPEG marker ${fileMarker.toString(16)} at offset ${(offset - 1).toString(16)}`);
              }
              malformedDataOffset = offset - 1;
              const nextOffset = readUint16();
              if (data[offset + nextOffset - 2] === 0xFF) {
                offset += nextOffset - 2;
                break;
              }
            }
            throw new Error("unknown JPEG marker " + fileMarker.toString(16));
        }
        fileMarker = readUint16();
      }
      if (frames.length != 1)
        throw new Error("only single frame JPEGs supported");

      // set each frame's components quantization table
      for (var i = 0; i < frames.length; i++) {
        var cp = frames[i].components;
        for (var j in cp) {
          cp[j].quantizationTable = quantizationTables[cp[j].quantizationIdx];
          delete cp[j].quantizationIdx;
        }
      }

      this.width = frame.samplesPerLine;
      this.height = frame.scanLines;
      this.jfif = jfif;
      this.adobe = adobe;
      this.components = [];
      for (var i = 0; i < frame.componentsOrder.length; i++) {
        var component = frame.components[frame.componentsOrder[i]];
        this.components.push({
          lines: buildComponentData(frame, component),
          scaleX: component.h / frame.maxH,
          scaleY: component.v / frame.maxV
        });
      }
    },
    getData: function getData(width, height) {
      var scaleX = this.width / width, scaleY = this.height / height;

      var component1, component2, component3, component4;
      var component1Line, component2Line, component3Line, component4Line;
      var x, y;
      var offset = 0;
      var Y, Cb, Cr, K, C, M, Ye, R, G, B;
      var colorTransform;
      var dataLength = width * height * this.components.length;
      requestMemoryAllocation(dataLength);
      var data = new Uint8Array(dataLength);
      switch (this.components.length) {
        case 1:
          component1 = this.components[0];
          for (y = 0; y < height; y++) {
            component1Line = component1.lines[0 | (y * component1.scaleY * scaleY)];
            for (x = 0; x < width; x++) {
              Y = component1Line[0 | (x * component1.scaleX * scaleX)];

              data[offset++] = Y;
            }
          }
          break;
        case 2:
          // PDF might compress two component data in custom colorspace
          component1 = this.components[0];
          component2 = this.components[1];
          for (y = 0; y < height; y++) {
            component1Line = component1.lines[0 | (y * component1.scaleY * scaleY)];
            component2Line = component2.lines[0 | (y * component2.scaleY * scaleY)];
            for (x = 0; x < width; x++) {
              Y = component1Line[0 | (x * component1.scaleX * scaleX)];
              data[offset++] = Y;
              Y = component2Line[0 | (x * component2.scaleX * scaleX)];
              data[offset++] = Y;
            }
          }
          break;
        case 3:
          // The default transform for three components is true
          colorTransform = true;
          // The adobe transform marker overrides any previous setting
          if (this.adobe && this.adobe.transformCode)
            colorTransform = true;
          else if (typeof this.opts.colorTransform !== 'undefined')
            colorTransform = !!this.opts.colorTransform;

          component1 = this.components[0];
          component2 = this.components[1];
          component3 = this.components[2];
          for (y = 0; y < height; y++) {
            component1Line = component1.lines[0 | (y * component1.scaleY * scaleY)];
            component2Line = component2.lines[0 | (y * component2.scaleY * scaleY)];
            component3Line = component3.lines[0 | (y * component3.scaleY * scaleY)];
            for (x = 0; x < width; x++) {
              if (!colorTransform) {
                R = component1Line[0 | (x * component1.scaleX * scaleX)];
                G = component2Line[0 | (x * component2.scaleX * scaleX)];
                B = component3Line[0 | (x * component3.scaleX * scaleX)];
              } else {
                Y = component1Line[0 | (x * component1.scaleX * scaleX)];
                Cb = component2Line[0 | (x * component2.scaleX * scaleX)];
                Cr = component3Line[0 | (x * component3.scaleX * scaleX)];

                R = clampTo8bit(Y + 1.402 * (Cr - 128));
                G = clampTo8bit(Y - 0.3441363 * (Cb - 128) - 0.71413636 * (Cr - 128));
                B = clampTo8bit(Y + 1.772 * (Cb - 128));
              }

              data[offset++] = R;
              data[offset++] = G;
              data[offset++] = B;
            }
          }
          break;
        case 4:
          if (!this.adobe)
            throw new Error('Unsupported color mode (4 components)');
          // The default transform for four components is false
          colorTransform = false;
          // The adobe transform marker overrides any previous setting
          if (this.adobe && this.adobe.transformCode)
            colorTransform = true;
          else if (typeof this.opts.colorTransform !== 'undefined')
            colorTransform = !!this.opts.colorTransform;

          component1 = this.components[0];
          component2 = this.components[1];
          component3 = this.components[2];
          component4 = this.components[3];
          for (y = 0; y < height; y++) {
            component1Line = component1.lines[0 | (y * component1.scaleY * scaleY)];
            component2Line = component2.lines[0 | (y * component2.scaleY * scaleY)];
            component3Line = component3.lines[0 | (y * component3.scaleY * scaleY)];
            component4Line = component4.lines[0 | (y * component4.scaleY * scaleY)];
            for (x = 0; x < width; x++) {
              if (!colorTransform) {
                C = component1Line[0 | (x * component1.scaleX * scaleX)];
                M = component2Line[0 | (x * component2.scaleX * scaleX)];
                Ye = component3Line[0 | (x * component3.scaleX * scaleX)];
                K = component4Line[0 | (x * component4.scaleX * scaleX)];
              } else {
                Y = component1Line[0 | (x * component1.scaleX * scaleX)];
                Cb = component2Line[0 | (x * component2.scaleX * scaleX)];
                Cr = component3Line[0 | (x * component3.scaleX * scaleX)];
                K = component4Line[0 | (x * component4.scaleX * scaleX)];

                C = 255 - clampTo8bit(Y + 1.402 * (Cr - 128));
                M = 255 - clampTo8bit(Y - 0.3441363 * (Cb - 128) - 0.71413636 * (Cr - 128));
                Ye = 255 - clampTo8bit(Y + 1.772 * (Cb - 128));
              }
              data[offset++] = 255-C;
              data[offset++] = 255-M;
              data[offset++] = 255-Ye;
              data[offset++] = 255-K;
            }
          }
          break;
        default:
          throw new Error('Unsupported color mode');
      }
      return data;
    },
    copyToImageData: function copyToImageData(imageData, formatAsRGBA) {
      var width = imageData.width, height = imageData.height;
      var imageDataArray = imageData.data;
      var data = this.getData(width, height);
      var i = 0, j = 0, x, y;
      var Y, K, C, M, R, G, B;
      switch (this.components.length) {
        case 1:
          for (y = 0; y < height; y++) {
            for (x = 0; x < width; x++) {
              Y = data[i++];

              imageDataArray[j++] = Y;
              imageDataArray[j++] = Y;
              imageDataArray[j++] = Y;
              if (formatAsRGBA) {
                imageDataArray[j++] = 255;
              }
            }
          }
          break;
        case 3:
          for (y = 0; y < height; y++) {
            for (x = 0; x < width; x++) {
              R = data[i++];
              G = data[i++];
              B = data[i++];

              imageDataArray[j++] = R;
              imageDataArray[j++] = G;
              imageDataArray[j++] = B;
              if (formatAsRGBA) {
                imageDataArray[j++] = 255;
              }
            }
          }
          break;
        case 4:
          for (y = 0; y < height; y++) {
            for (x = 0; x < width; x++) {
              C = data[i++];
              M = data[i++];
              Y = data[i++];
              K = data[i++];

              R = 255 - clampTo8bit(C * (1 - K / 255) + K);
              G = 255 - clampTo8bit(M * (1 - K / 255) + K);
              B = 255 - clampTo8bit(Y * (1 - K / 255) + K);

              imageDataArray[j++] = R;
              imageDataArray[j++] = G;
              imageDataArray[j++] = B;
              if (formatAsRGBA) {
                imageDataArray[j++] = 255;
              }
            }
          }
          break;
        default:
          throw new Error('Unsupported color mode');
      }
    }
  };


  // We cap the amount of memory used by jpeg-js to avoid unexpected OOMs from untrusted content.
  var totalBytesAllocated = 0;
  var maxMemoryUsageBytes = 0;
  function requestMemoryAllocation(increaseAmount = 0) {
    var totalMemoryImpactBytes = totalBytesAllocated + increaseAmount;
    if (totalMemoryImpactBytes > maxMemoryUsageBytes) {
      var exceededAmount = Math.ceil((totalMemoryImpactBytes - maxMemoryUsageBytes) / 1024 / 1024);
      throw new Error(`maxMemoryUsageInMB limit exceeded by at least ${exceededAmount}MB`);
    }

    totalBytesAllocated = totalMemoryImpactBytes;
  }

  constructor.resetMaxMemoryUsage = function (maxMemoryUsageBytes_) {
    totalBytesAllocated = 0;
    maxMemoryUsageBytes = maxMemoryUsageBytes_;
  };

  constructor.getBytesAllocated = function () {
    return totalBytesAllocated;
  };

  constructor.requestMemoryAllocation = requestMemoryAllocation;

  return constructor;
})();

if (true) {
	module.exports = decode;
} else {}

function decode(jpegData, userOpts = {}) {
  var defaultOpts = {
    // "undefined" means "Choose whether to transform colors based on the image’s color model."
    colorTransform: undefined,
    useTArray: false,
    formatAsRGBA: true,
    tolerantDecoding: true,
    maxResolutionInMP: 100, // Don't decode more than 100 megapixels
    maxMemoryUsageInMB: 512, // Don't decode if memory footprint is more than 512MB
  };

  var opts = {...defaultOpts, ...userOpts};
  var arr = new Uint8Array(jpegData);
  var decoder = new JpegImage();
  decoder.opts = opts;
  // If this constructor ever supports async decoding this will need to be done differently.
  // Until then, treating as singleton limit is fine.
  JpegImage.resetMaxMemoryUsage(opts.maxMemoryUsageInMB * 1024 * 1024);
  decoder.parse(arr);

  var channels = (opts.formatAsRGBA) ? 4 : 3;
  var bytesNeeded = decoder.width * decoder.height * channels;
  try {
    JpegImage.requestMemoryAllocation(bytesNeeded);
    var image = {
      width: decoder.width,
      height: decoder.height,
      exifBuffer: decoder.exifBuffer,
      data: opts.useTArray ?
        new Uint8Array(bytesNeeded) :
        Buffer.alloc(bytesNeeded)
    };
    if(decoder.comments.length > 0) {
      image["comments"] = decoder.comments;
    }
  } catch (err){
    if (err instanceof RangeError){
      throw new Error("Could not allocate enough memory for the image. " +
                      "Required: " + bytesNeeded);
    } else {
      throw err;
    }
  }

  decoder.copyToImageData(image, opts.formatAsRGBA);

  return image;
}


/***/ }),

/***/ "./node_modules/jpeg-js/lib/encoder.js":
/*!*********************************************!*\
  !*** ./node_modules/jpeg-js/lib/encoder.js ***!
  \*********************************************/
/***/ ((module) => {

/*
  Copyright (c) 2008, Adobe Systems Incorporated
  All rights reserved.

  Redistribution and use in source and binary forms, with or without 
  modification, are permitted provided that the following conditions are
  met:

  * Redistributions of source code must retain the above copyright notice, 
    this list of conditions and the following disclaimer.
  
  * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the 
    documentation and/or other materials provided with the distribution.
  
  * Neither the name of Adobe Systems Incorporated nor the names of its 
    contributors may be used to endorse or promote products derived from 
    this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
  THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
  PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*
JPEG encoder ported to JavaScript and optimized by Andreas Ritter, www.bytestrom.eu, 11/2009

Basic GUI blocking jpeg encoder
*/

var btoa = btoa || function(buf) {
  return Buffer.from(buf).toString('base64');
};

function JPEGEncoder(quality) {
  var self = this;
	var fround = Math.round;
	var ffloor = Math.floor;
	var YTable = new Array(64);
	var UVTable = new Array(64);
	var fdtbl_Y = new Array(64);
	var fdtbl_UV = new Array(64);
	var YDC_HT;
	var UVDC_HT;
	var YAC_HT;
	var UVAC_HT;
	
	var bitcode = new Array(65535);
	var category = new Array(65535);
	var outputfDCTQuant = new Array(64);
	var DU = new Array(64);
	var byteout = [];
	var bytenew = 0;
	var bytepos = 7;
	
	var YDU = new Array(64);
	var UDU = new Array(64);
	var VDU = new Array(64);
	var clt = new Array(256);
	var RGB_YUV_TABLE = new Array(2048);
	var currentQuality;
	
	var ZigZag = [
			 0, 1, 5, 6,14,15,27,28,
			 2, 4, 7,13,16,26,29,42,
			 3, 8,12,17,25,30,41,43,
			 9,11,18,24,31,40,44,53,
			10,19,23,32,39,45,52,54,
			20,22,33,38,46,51,55,60,
			21,34,37,47,50,56,59,61,
			35,36,48,49,57,58,62,63
		];
	
	var std_dc_luminance_nrcodes = [0,0,1,5,1,1,1,1,1,1,0,0,0,0,0,0,0];
	var std_dc_luminance_values = [0,1,2,3,4,5,6,7,8,9,10,11];
	var std_ac_luminance_nrcodes = [0,0,2,1,3,3,2,4,3,5,5,4,4,0,0,1,0x7d];
	var std_ac_luminance_values = [
			0x01,0x02,0x03,0x00,0x04,0x11,0x05,0x12,
			0x21,0x31,0x41,0x06,0x13,0x51,0x61,0x07,
			0x22,0x71,0x14,0x32,0x81,0x91,0xa1,0x08,
			0x23,0x42,0xb1,0xc1,0x15,0x52,0xd1,0xf0,
			0x24,0x33,0x62,0x72,0x82,0x09,0x0a,0x16,
			0x17,0x18,0x19,0x1a,0x25,0x26,0x27,0x28,
			0x29,0x2a,0x34,0x35,0x36,0x37,0x38,0x39,
			0x3a,0x43,0x44,0x45,0x46,0x47,0x48,0x49,
			0x4a,0x53,0x54,0x55,0x56,0x57,0x58,0x59,
			0x5a,0x63,0x64,0x65,0x66,0x67,0x68,0x69,
			0x6a,0x73,0x74,0x75,0x76,0x77,0x78,0x79,
			0x7a,0x83,0x84,0x85,0x86,0x87,0x88,0x89,
			0x8a,0x92,0x93,0x94,0x95,0x96,0x97,0x98,
			0x99,0x9a,0xa2,0xa3,0xa4,0xa5,0xa6,0xa7,
			0xa8,0xa9,0xaa,0xb2,0xb3,0xb4,0xb5,0xb6,
			0xb7,0xb8,0xb9,0xba,0xc2,0xc3,0xc4,0xc5,
			0xc6,0xc7,0xc8,0xc9,0xca,0xd2,0xd3,0xd4,
			0xd5,0xd6,0xd7,0xd8,0xd9,0xda,0xe1,0xe2,
			0xe3,0xe4,0xe5,0xe6,0xe7,0xe8,0xe9,0xea,
			0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,0xf8,
			0xf9,0xfa
		];
	
	var std_dc_chrominance_nrcodes = [0,0,3,1,1,1,1,1,1,1,1,1,0,0,0,0,0];
	var std_dc_chrominance_values = [0,1,2,3,4,5,6,7,8,9,10,11];
	var std_ac_chrominance_nrcodes = [0,0,2,1,2,4,4,3,4,7,5,4,4,0,1,2,0x77];
	var std_ac_chrominance_values = [
			0x00,0x01,0x02,0x03,0x11,0x04,0x05,0x21,
			0x31,0x06,0x12,0x41,0x51,0x07,0x61,0x71,
			0x13,0x22,0x32,0x81,0x08,0x14,0x42,0x91,
			0xa1,0xb1,0xc1,0x09,0x23,0x33,0x52,0xf0,
			0x15,0x62,0x72,0xd1,0x0a,0x16,0x24,0x34,
			0xe1,0x25,0xf1,0x17,0x18,0x19,0x1a,0x26,
			0x27,0x28,0x29,0x2a,0x35,0x36,0x37,0x38,
			0x39,0x3a,0x43,0x44,0x45,0x46,0x47,0x48,
			0x49,0x4a,0x53,0x54,0x55,0x56,0x57,0x58,
			0x59,0x5a,0x63,0x64,0x65,0x66,0x67,0x68,
			0x69,0x6a,0x73,0x74,0x75,0x76,0x77,0x78,
			0x79,0x7a,0x82,0x83,0x84,0x85,0x86,0x87,
			0x88,0x89,0x8a,0x92,0x93,0x94,0x95,0x96,
			0x97,0x98,0x99,0x9a,0xa2,0xa3,0xa4,0xa5,
			0xa6,0xa7,0xa8,0xa9,0xaa,0xb2,0xb3,0xb4,
			0xb5,0xb6,0xb7,0xb8,0xb9,0xba,0xc2,0xc3,
			0xc4,0xc5,0xc6,0xc7,0xc8,0xc9,0xca,0xd2,
			0xd3,0xd4,0xd5,0xd6,0xd7,0xd8,0xd9,0xda,
			0xe2,0xe3,0xe4,0xe5,0xe6,0xe7,0xe8,0xe9,
			0xea,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,0xf8,
			0xf9,0xfa
		];
	
	function initQuantTables(sf){
			var YQT = [
				16, 11, 10, 16, 24, 40, 51, 61,
				12, 12, 14, 19, 26, 58, 60, 55,
				14, 13, 16, 24, 40, 57, 69, 56,
				14, 17, 22, 29, 51, 87, 80, 62,
				18, 22, 37, 56, 68,109,103, 77,
				24, 35, 55, 64, 81,104,113, 92,
				49, 64, 78, 87,103,121,120,101,
				72, 92, 95, 98,112,100,103, 99
			];
			
			for (var i = 0; i < 64; i++) {
				var t = ffloor((YQT[i]*sf+50)/100);
				if (t < 1) {
					t = 1;
				} else if (t > 255) {
					t = 255;
				}
				YTable[ZigZag[i]] = t;
			}
			var UVQT = [
				17, 18, 24, 47, 99, 99, 99, 99,
				18, 21, 26, 66, 99, 99, 99, 99,
				24, 26, 56, 99, 99, 99, 99, 99,
				47, 66, 99, 99, 99, 99, 99, 99,
				99, 99, 99, 99, 99, 99, 99, 99,
				99, 99, 99, 99, 99, 99, 99, 99,
				99, 99, 99, 99, 99, 99, 99, 99,
				99, 99, 99, 99, 99, 99, 99, 99
			];
			for (var j = 0; j < 64; j++) {
				var u = ffloor((UVQT[j]*sf+50)/100);
				if (u < 1) {
					u = 1;
				} else if (u > 255) {
					u = 255;
				}
				UVTable[ZigZag[j]] = u;
			}
			var aasf = [
				1.0, 1.387039845, 1.306562965, 1.175875602,
				1.0, 0.785694958, 0.541196100, 0.275899379
			];
			var k = 0;
			for (var row = 0; row < 8; row++)
			{
				for (var col = 0; col < 8; col++)
				{
					fdtbl_Y[k]  = (1.0 / (YTable [ZigZag[k]] * aasf[row] * aasf[col] * 8.0));
					fdtbl_UV[k] = (1.0 / (UVTable[ZigZag[k]] * aasf[row] * aasf[col] * 8.0));
					k++;
				}
			}
		}
		
		function computeHuffmanTbl(nrcodes, std_table){
			var codevalue = 0;
			var pos_in_table = 0;
			var HT = new Array();
			for (var k = 1; k <= 16; k++) {
				for (var j = 1; j <= nrcodes[k]; j++) {
					HT[std_table[pos_in_table]] = [];
					HT[std_table[pos_in_table]][0] = codevalue;
					HT[std_table[pos_in_table]][1] = k;
					pos_in_table++;
					codevalue++;
				}
				codevalue*=2;
			}
			return HT;
		}
		
		function initHuffmanTbl()
		{
			YDC_HT = computeHuffmanTbl(std_dc_luminance_nrcodes,std_dc_luminance_values);
			UVDC_HT = computeHuffmanTbl(std_dc_chrominance_nrcodes,std_dc_chrominance_values);
			YAC_HT = computeHuffmanTbl(std_ac_luminance_nrcodes,std_ac_luminance_values);
			UVAC_HT = computeHuffmanTbl(std_ac_chrominance_nrcodes,std_ac_chrominance_values);
		}
	
		function initCategoryNumber()
		{
			var nrlower = 1;
			var nrupper = 2;
			for (var cat = 1; cat <= 15; cat++) {
				//Positive numbers
				for (var nr = nrlower; nr<nrupper; nr++) {
					category[32767+nr] = cat;
					bitcode[32767+nr] = [];
					bitcode[32767+nr][1] = cat;
					bitcode[32767+nr][0] = nr;
				}
				//Negative numbers
				for (var nrneg =-(nrupper-1); nrneg<=-nrlower; nrneg++) {
					category[32767+nrneg] = cat;
					bitcode[32767+nrneg] = [];
					bitcode[32767+nrneg][1] = cat;
					bitcode[32767+nrneg][0] = nrupper-1+nrneg;
				}
				nrlower <<= 1;
				nrupper <<= 1;
			}
		}
		
		function initRGBYUVTable() {
			for(var i = 0; i < 256;i++) {
				RGB_YUV_TABLE[i]      		=  19595 * i;
				RGB_YUV_TABLE[(i+ 256)>>0] 	=  38470 * i;
				RGB_YUV_TABLE[(i+ 512)>>0] 	=   7471 * i + 0x8000;
				RGB_YUV_TABLE[(i+ 768)>>0] 	= -11059 * i;
				RGB_YUV_TABLE[(i+1024)>>0] 	= -21709 * i;
				RGB_YUV_TABLE[(i+1280)>>0] 	=  32768 * i + 0x807FFF;
				RGB_YUV_TABLE[(i+1536)>>0] 	= -27439 * i;
				RGB_YUV_TABLE[(i+1792)>>0] 	= - 5329 * i;
			}
		}
		
		// IO functions
		function writeBits(bs)
		{
			var value = bs[0];
			var posval = bs[1]-1;
			while ( posval >= 0 ) {
				if (value & (1 << posval) ) {
					bytenew |= (1 << bytepos);
				}
				posval--;
				bytepos--;
				if (bytepos < 0) {
					if (bytenew == 0xFF) {
						writeByte(0xFF);
						writeByte(0);
					}
					else {
						writeByte(bytenew);
					}
					bytepos=7;
					bytenew=0;
				}
			}
		}
	
		function writeByte(value)
		{
			//byteout.push(clt[value]); // write char directly instead of converting later
      byteout.push(value);
		}
	
		function writeWord(value)
		{
			writeByte((value>>8)&0xFF);
			writeByte((value   )&0xFF);
		}
		
		// DCT & quantization core
		function fDCTQuant(data, fdtbl)
		{
			var d0, d1, d2, d3, d4, d5, d6, d7;
			/* Pass 1: process rows. */
			var dataOff=0;
			var i;
			var I8 = 8;
			var I64 = 64;
			for (i=0; i<I8; ++i)
			{
				d0 = data[dataOff];
				d1 = data[dataOff+1];
				d2 = data[dataOff+2];
				d3 = data[dataOff+3];
				d4 = data[dataOff+4];
				d5 = data[dataOff+5];
				d6 = data[dataOff+6];
				d7 = data[dataOff+7];
				
				var tmp0 = d0 + d7;
				var tmp7 = d0 - d7;
				var tmp1 = d1 + d6;
				var tmp6 = d1 - d6;
				var tmp2 = d2 + d5;
				var tmp5 = d2 - d5;
				var tmp3 = d3 + d4;
				var tmp4 = d3 - d4;
	
				/* Even part */
				var tmp10 = tmp0 + tmp3;	/* phase 2 */
				var tmp13 = tmp0 - tmp3;
				var tmp11 = tmp1 + tmp2;
				var tmp12 = tmp1 - tmp2;
	
				data[dataOff] = tmp10 + tmp11; /* phase 3 */
				data[dataOff+4] = tmp10 - tmp11;
	
				var z1 = (tmp12 + tmp13) * 0.707106781; /* c4 */
				data[dataOff+2] = tmp13 + z1; /* phase 5 */
				data[dataOff+6] = tmp13 - z1;
	
				/* Odd part */
				tmp10 = tmp4 + tmp5; /* phase 2 */
				tmp11 = tmp5 + tmp6;
				tmp12 = tmp6 + tmp7;
	
				/* The rotator is modified from fig 4-8 to avoid extra negations. */
				var z5 = (tmp10 - tmp12) * 0.382683433; /* c6 */
				var z2 = 0.541196100 * tmp10 + z5; /* c2-c6 */
				var z4 = 1.306562965 * tmp12 + z5; /* c2+c6 */
				var z3 = tmp11 * 0.707106781; /* c4 */
	
				var z11 = tmp7 + z3;	/* phase 5 */
				var z13 = tmp7 - z3;
	
				data[dataOff+5] = z13 + z2;	/* phase 6 */
				data[dataOff+3] = z13 - z2;
				data[dataOff+1] = z11 + z4;
				data[dataOff+7] = z11 - z4;
	
				dataOff += 8; /* advance pointer to next row */
			}
	
			/* Pass 2: process columns. */
			dataOff = 0;
			for (i=0; i<I8; ++i)
			{
				d0 = data[dataOff];
				d1 = data[dataOff + 8];
				d2 = data[dataOff + 16];
				d3 = data[dataOff + 24];
				d4 = data[dataOff + 32];
				d5 = data[dataOff + 40];
				d6 = data[dataOff + 48];
				d7 = data[dataOff + 56];
				
				var tmp0p2 = d0 + d7;
				var tmp7p2 = d0 - d7;
				var tmp1p2 = d1 + d6;
				var tmp6p2 = d1 - d6;
				var tmp2p2 = d2 + d5;
				var tmp5p2 = d2 - d5;
				var tmp3p2 = d3 + d4;
				var tmp4p2 = d3 - d4;
	
				/* Even part */
				var tmp10p2 = tmp0p2 + tmp3p2;	/* phase 2 */
				var tmp13p2 = tmp0p2 - tmp3p2;
				var tmp11p2 = tmp1p2 + tmp2p2;
				var tmp12p2 = tmp1p2 - tmp2p2;
	
				data[dataOff] = tmp10p2 + tmp11p2; /* phase 3 */
				data[dataOff+32] = tmp10p2 - tmp11p2;
	
				var z1p2 = (tmp12p2 + tmp13p2) * 0.707106781; /* c4 */
				data[dataOff+16] = tmp13p2 + z1p2; /* phase 5 */
				data[dataOff+48] = tmp13p2 - z1p2;
	
				/* Odd part */
				tmp10p2 = tmp4p2 + tmp5p2; /* phase 2 */
				tmp11p2 = tmp5p2 + tmp6p2;
				tmp12p2 = tmp6p2 + tmp7p2;
	
				/* The rotator is modified from fig 4-8 to avoid extra negations. */
				var z5p2 = (tmp10p2 - tmp12p2) * 0.382683433; /* c6 */
				var z2p2 = 0.541196100 * tmp10p2 + z5p2; /* c2-c6 */
				var z4p2 = 1.306562965 * tmp12p2 + z5p2; /* c2+c6 */
				var z3p2 = tmp11p2 * 0.707106781; /* c4 */
	
				var z11p2 = tmp7p2 + z3p2;	/* phase 5 */
				var z13p2 = tmp7p2 - z3p2;
	
				data[dataOff+40] = z13p2 + z2p2; /* phase 6 */
				data[dataOff+24] = z13p2 - z2p2;
				data[dataOff+ 8] = z11p2 + z4p2;
				data[dataOff+56] = z11p2 - z4p2;
	
				dataOff++; /* advance pointer to next column */
			}
	
			// Quantize/descale the coefficients
			var fDCTQuant;
			for (i=0; i<I64; ++i)
			{
				// Apply the quantization and scaling factor & Round to nearest integer
				fDCTQuant = data[i]*fdtbl[i];
				outputfDCTQuant[i] = (fDCTQuant > 0.0) ? ((fDCTQuant + 0.5)|0) : ((fDCTQuant - 0.5)|0);
				//outputfDCTQuant[i] = fround(fDCTQuant);

			}
			return outputfDCTQuant;
		}
		
		function writeAPP0()
		{
			writeWord(0xFFE0); // marker
			writeWord(16); // length
			writeByte(0x4A); // J
			writeByte(0x46); // F
			writeByte(0x49); // I
			writeByte(0x46); // F
			writeByte(0); // = "JFIF",'\0'
			writeByte(1); // versionhi
			writeByte(1); // versionlo
			writeByte(0); // xyunits
			writeWord(1); // xdensity
			writeWord(1); // ydensity
			writeByte(0); // thumbnwidth
			writeByte(0); // thumbnheight
		}

		function writeAPP1(exifBuffer) {
			if (!exifBuffer) return;

			writeWord(0xFFE1); // APP1 marker

			if (exifBuffer[0] === 0x45 &&
					exifBuffer[1] === 0x78 &&
					exifBuffer[2] === 0x69 &&
					exifBuffer[3] === 0x66) {
				// Buffer already starts with EXIF, just use it directly
				writeWord(exifBuffer.length + 2); // length is buffer + length itself!
			} else {
				// Buffer doesn't start with EXIF, write it for them
				writeWord(exifBuffer.length + 5 + 2); // length is buffer + EXIF\0 + length itself!
				writeByte(0x45); // E
				writeByte(0x78); // X
				writeByte(0x69); // I
				writeByte(0x66); // F
				writeByte(0); // = "EXIF",'\0'
			}

			for (var i = 0; i < exifBuffer.length; i++) {
				writeByte(exifBuffer[i]);
			}
		}

		function writeSOF0(width, height)
		{
			writeWord(0xFFC0); // marker
			writeWord(17);   // length, truecolor YUV JPG
			writeByte(8);    // precision
			writeWord(height);
			writeWord(width);
			writeByte(3);    // nrofcomponents
			writeByte(1);    // IdY
			writeByte(0x11); // HVY
			writeByte(0);    // QTY
			writeByte(2);    // IdU
			writeByte(0x11); // HVU
			writeByte(1);    // QTU
			writeByte(3);    // IdV
			writeByte(0x11); // HVV
			writeByte(1);    // QTV
		}
	
		function writeDQT()
		{
			writeWord(0xFFDB); // marker
			writeWord(132);	   // length
			writeByte(0);
			for (var i=0; i<64; i++) {
				writeByte(YTable[i]);
			}
			writeByte(1);
			for (var j=0; j<64; j++) {
				writeByte(UVTable[j]);
			}
		}
	
		function writeDHT()
		{
			writeWord(0xFFC4); // marker
			writeWord(0x01A2); // length
	
			writeByte(0); // HTYDCinfo
			for (var i=0; i<16; i++) {
				writeByte(std_dc_luminance_nrcodes[i+1]);
			}
			for (var j=0; j<=11; j++) {
				writeByte(std_dc_luminance_values[j]);
			}
	
			writeByte(0x10); // HTYACinfo
			for (var k=0; k<16; k++) {
				writeByte(std_ac_luminance_nrcodes[k+1]);
			}
			for (var l=0; l<=161; l++) {
				writeByte(std_ac_luminance_values[l]);
			}
	
			writeByte(1); // HTUDCinfo
			for (var m=0; m<16; m++) {
				writeByte(std_dc_chrominance_nrcodes[m+1]);
			}
			for (var n=0; n<=11; n++) {
				writeByte(std_dc_chrominance_values[n]);
			}
	
			writeByte(0x11); // HTUACinfo
			for (var o=0; o<16; o++) {
				writeByte(std_ac_chrominance_nrcodes[o+1]);
			}
			for (var p=0; p<=161; p++) {
				writeByte(std_ac_chrominance_values[p]);
			}
		}
	
		function writeSOS()
		{
			writeWord(0xFFDA); // marker
			writeWord(12); // length
			writeByte(3); // nrofcomponents
			writeByte(1); // IdY
			writeByte(0); // HTY
			writeByte(2); // IdU
			writeByte(0x11); // HTU
			writeByte(3); // IdV
			writeByte(0x11); // HTV
			writeByte(0); // Ss
			writeByte(0x3f); // Se
			writeByte(0); // Bf
		}
		
		function processDU(CDU, fdtbl, DC, HTDC, HTAC){
			var EOB = HTAC[0x00];
			var M16zeroes = HTAC[0xF0];
			var pos;
			var I16 = 16;
			var I63 = 63;
			var I64 = 64;
			var DU_DCT = fDCTQuant(CDU, fdtbl);
			//ZigZag reorder
			for (var j=0;j<I64;++j) {
				DU[ZigZag[j]]=DU_DCT[j];
			}
			var Diff = DU[0] - DC; DC = DU[0];
			//Encode DC
			if (Diff==0) {
				writeBits(HTDC[0]); // Diff might be 0
			} else {
				pos = 32767+Diff;
				writeBits(HTDC[category[pos]]);
				writeBits(bitcode[pos]);
			}
			//Encode ACs
			var end0pos = 63; // was const... which is crazy
			for (; (end0pos>0)&&(DU[end0pos]==0); end0pos--) {};
			//end0pos = first element in reverse order !=0
			if ( end0pos == 0) {
				writeBits(EOB);
				return DC;
			}
			var i = 1;
			var lng;
			while ( i <= end0pos ) {
				var startpos = i;
				for (; (DU[i]==0) && (i<=end0pos); ++i) {}
				var nrzeroes = i-startpos;
				if ( nrzeroes >= I16 ) {
					lng = nrzeroes>>4;
					for (var nrmarker=1; nrmarker <= lng; ++nrmarker)
						writeBits(M16zeroes);
					nrzeroes = nrzeroes&0xF;
				}
				pos = 32767+DU[i];
				writeBits(HTAC[(nrzeroes<<4)+category[pos]]);
				writeBits(bitcode[pos]);
				i++;
			}
			if ( end0pos != I63 ) {
				writeBits(EOB);
			}
			return DC;
		}

		function initCharLookupTable(){
			var sfcc = String.fromCharCode;
			for(var i=0; i < 256; i++){ ///// ACHTUNG // 255
				clt[i] = sfcc(i);
			}
		}
		
		this.encode = function(image,quality) // image data object
		{
			var time_start = new Date().getTime();
			
			if(quality) setQuality(quality);
			
			// Initialize bit writer
			byteout = new Array();
			bytenew=0;
			bytepos=7;
	
			// Add JPEG headers
			writeWord(0xFFD8); // SOI
			writeAPP0();
			writeAPP1(image.exifBuffer);
			writeDQT();
			writeSOF0(image.width,image.height);
			writeDHT();
			writeSOS();

	
			// Encode 8x8 macroblocks
			var DCY=0;
			var DCU=0;
			var DCV=0;
			
			bytenew=0;
			bytepos=7;
			
			
			this.encode.displayName = "_encode_";

			var imageData = image.data;
			var width = image.width;
			var height = image.height;

			var quadWidth = width*4;
			var tripleWidth = width*3;
			
			var x, y = 0;
			var r, g, b;
			var start,p, col,row,pos;
			while(y < height){
				x = 0;
				while(x < quadWidth){
				start = quadWidth * y + x;
				p = start;
				col = -1;
				row = 0;
				
				for(pos=0; pos < 64; pos++){
					row = pos >> 3;// /8
					col = ( pos & 7 ) * 4; // %8
					p = start + ( row * quadWidth ) + col;		
					
					if(y+row >= height){ // padding bottom
						p-= (quadWidth*(y+1+row-height));
					}

					if(x+col >= quadWidth){ // padding right	
						p-= ((x+col) - quadWidth +4)
					}
					
					r = imageData[ p++ ];
					g = imageData[ p++ ];
					b = imageData[ p++ ];
					
					
					/* // calculate YUV values dynamically
					YDU[pos]=((( 0.29900)*r+( 0.58700)*g+( 0.11400)*b))-128; //-0x80
					UDU[pos]=(((-0.16874)*r+(-0.33126)*g+( 0.50000)*b));
					VDU[pos]=((( 0.50000)*r+(-0.41869)*g+(-0.08131)*b));
					*/
					
					// use lookup table (slightly faster)
					YDU[pos] = ((RGB_YUV_TABLE[r]             + RGB_YUV_TABLE[(g +  256)>>0] + RGB_YUV_TABLE[(b +  512)>>0]) >> 16)-128;
					UDU[pos] = ((RGB_YUV_TABLE[(r +  768)>>0] + RGB_YUV_TABLE[(g + 1024)>>0] + RGB_YUV_TABLE[(b + 1280)>>0]) >> 16)-128;
					VDU[pos] = ((RGB_YUV_TABLE[(r + 1280)>>0] + RGB_YUV_TABLE[(g + 1536)>>0] + RGB_YUV_TABLE[(b + 1792)>>0]) >> 16)-128;

				}
				
				DCY = processDU(YDU, fdtbl_Y, DCY, YDC_HT, YAC_HT);
				DCU = processDU(UDU, fdtbl_UV, DCU, UVDC_HT, UVAC_HT);
				DCV = processDU(VDU, fdtbl_UV, DCV, UVDC_HT, UVAC_HT);
				x+=32;
				}
				y+=8;
			}
			
			
			////////////////////////////////////////////////////////////////
	
			// Do the bit alignment of the EOI marker
			if ( bytepos >= 0 ) {
				var fillbits = [];
				fillbits[1] = bytepos+1;
				fillbits[0] = (1<<(bytepos+1))-1;
				writeBits(fillbits);
			}
	
			writeWord(0xFFD9); //EOI

			if (false) {}
      return Buffer.from(byteout);

			var jpegDataUri = 'data:image/jpeg;base64,' + btoa(byteout.join(''));
			
			byteout = [];
			
			// benchmarking
			var duration = new Date().getTime() - time_start;
    		//console.log('Encoding time: '+ duration + 'ms');
    		//
			
			return jpegDataUri			
	}
	
	function setQuality(quality){
		if (quality <= 0) {
			quality = 1;
		}
		if (quality > 100) {
			quality = 100;
		}
		
		if(currentQuality == quality) return // don't recalc if unchanged
		
		var sf = 0;
		if (quality < 50) {
			sf = Math.floor(5000 / quality);
		} else {
			sf = Math.floor(200 - quality*2);
		}
		
		initQuantTables(sf);
		currentQuality = quality;
		//console.log('Quality set to: '+quality +'%');
	}
	
	function init(){
		var time_start = new Date().getTime();
		if(!quality) quality = 50;
		// Create tables
		initCharLookupTable()
		initHuffmanTbl();
		initCategoryNumber();
		initRGBYUVTable();
		
		setQuality(quality);
		var duration = new Date().getTime() - time_start;
    	//console.log('Initialization '+ duration + 'ms');
	}
	
	init();
	
};

if (true) {
	module.exports = encode;
} else {}

function encode(imgData, qu) {
  if (typeof qu === 'undefined') qu = 50;
  var encoder = new JPEGEncoder(qu);
	var data = encoder.encode(imgData, qu);
  return {
    data: data,
    width: imgData.width,
    height: imgData.height
  };
}

// helper function to get the imageData of an existing image on the current page.
function getImageDataFromImage(idOrElement){
	var theImg = (typeof(idOrElement)=='string')? document.getElementById(idOrElement):idOrElement;
	var cvs = document.createElement('canvas');
	cvs.width = theImg.width;
	cvs.height = theImg.height;
	var ctx = cvs.getContext("2d");
	ctx.drawImage(theImg,0,0);
	
	return (ctx.getImageData(0, 0, cvs.width, cvs.height));
}


/***/ }),

/***/ "./node_modules/libheif-js/libheif/libheif.js":
/*!****************************************************!*\
  !*** ./node_modules/libheif-js/libheif/libheif.js ***!
  \****************************************************/
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;var Module=typeof Module!=="undefined"?Module:{};((function(){var Module={print:(function(text){text=Array.prototype.slice.call(arguments).join(" ");console.log(text)}),printErr:(function(text){text=Array.prototype.slice.call(arguments).join(" ");console.error(text)}),canvas:{},noInitialRun:true};var moduleOverrides={};var key;for(key in Module){if(Module.hasOwnProperty(key)){moduleOverrides[key]=Module[key]}}var ENVIRONMENT_IS_WEB=false;var ENVIRONMENT_IS_WORKER=false;var ENVIRONMENT_IS_NODE=false;var ENVIRONMENT_IS_SHELL=false;if(Module["ENVIRONMENT"]){if(Module["ENVIRONMENT"]==="WEB"){ENVIRONMENT_IS_WEB=true}else if(Module["ENVIRONMENT"]==="WORKER"){ENVIRONMENT_IS_WORKER=true}else if(Module["ENVIRONMENT"]==="NODE"){ENVIRONMENT_IS_NODE=true}else if(Module["ENVIRONMENT"]==="SHELL"){ENVIRONMENT_IS_SHELL=true}else{throw new Error("The provided Module['ENVIRONMENT'] value is not valid. It must be one of: WEB|WORKER|NODE|SHELL.")}}else{ENVIRONMENT_IS_WEB=typeof window==="object";ENVIRONMENT_IS_WORKER=typeof importScripts==="function";ENVIRONMENT_IS_NODE=typeof process==="object"&&"function"==="function"&&!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_WORKER;ENVIRONMENT_IS_SHELL=!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_NODE&&!ENVIRONMENT_IS_WORKER}if(ENVIRONMENT_IS_NODE){if(!Module["print"])Module["print"]=console.log;if(!Module["printErr"])Module["printErr"]=console.warn;var nodeFS;var nodePath;Module["read"]=function shell_read(filename,binary){var ret;ret=tryParseAsDataURI(filename);if(!ret){if(!nodeFS)nodeFS=__webpack_require__(/*! fs */ "fs");if(!nodePath)nodePath=__webpack_require__(/*! path */ "path");filename=nodePath["normalize"](filename);ret=nodeFS["readFileSync"](filename)}return binary?ret:ret.toString()};Module["readBinary"]=function readBinary(filename){var ret=Module["read"](filename,true);if(!ret.buffer){ret=new Uint8Array(ret)}assert(ret.buffer);return ret};if(!Module["thisProgram"]){if(process["argv"].length>1){Module["thisProgram"]=process["argv"][1].replace(/\\/g,"/")}else{Module["thisProgram"]="unknown-program"}}Module["arguments"]=process["argv"].slice(2);if(true){module["exports"]=Module}process["on"]("uncaughtException",(function(ex){if(!(ex instanceof ExitStatus)){throw ex}}));process["on"]("unhandledRejection",(function(reason,p){process["exit"](1)}));Module["inspect"]=(function(){return"[Emscripten Module object]"})}else if(ENVIRONMENT_IS_SHELL){if(!Module["print"])Module["print"]=print;if(typeof printErr!="undefined")Module["printErr"]=printErr;if(typeof read!="undefined"){Module["read"]=function shell_read(f){var data=tryParseAsDataURI(f);if(data){return intArrayToString(data)}return read(f)}}else{Module["read"]=function shell_read(){throw"no read() available"}}Module["readBinary"]=function readBinary(f){var data;data=tryParseAsDataURI(f);if(data){return data}if(typeof readbuffer==="function"){return new Uint8Array(readbuffer(f))}data=read(f,"binary");assert(typeof data==="object");return data};if(typeof scriptArgs!="undefined"){Module["arguments"]=scriptArgs}else if(typeof arguments!="undefined"){Module["arguments"]=arguments}if(typeof quit==="function"){Module["quit"]=(function(status,toThrow){quit(status)})}}else if(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER){Module["read"]=function shell_read(url){try{var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.send(null);return xhr.responseText}catch(err){var data=tryParseAsDataURI(url);if(data){return intArrayToString(data)}throw err}};if(ENVIRONMENT_IS_WORKER){Module["readBinary"]=function readBinary(url){try{var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.responseType="arraybuffer";xhr.send(null);return new Uint8Array(xhr.response)}catch(err){var data=tryParseAsDataURI(url);if(data){return data}throw err}}}Module["readAsync"]=function readAsync(url,onload,onerror){var xhr=new XMLHttpRequest;xhr.open("GET",url,true);xhr.responseType="arraybuffer";xhr.onload=function xhr_onload(){if(xhr.status==200||xhr.status==0&&xhr.response){onload(xhr.response);return}var data=tryParseAsDataURI(url);if(data){onload(data.buffer);return}onerror()};xhr.onerror=onerror;xhr.send(null)};if(typeof arguments!="undefined"){Module["arguments"]=arguments}if(typeof console!=="undefined"){if(!Module["print"])Module["print"]=function shell_print(x){console.log(x)};if(!Module["printErr"])Module["printErr"]=function shell_printErr(x){console.warn(x)}}else{var TRY_USE_DUMP=false;if(!Module["print"])Module["print"]=TRY_USE_DUMP&&typeof dump!=="undefined"?(function(x){dump(x)}):(function(x){})}if(typeof Module["setWindowTitle"]==="undefined"){Module["setWindowTitle"]=(function(title){document.title=title})}}else{throw new Error("Unknown runtime environment. Where are we?")}if(!Module["print"]){Module["print"]=(function(){})}if(!Module["printErr"]){Module["printErr"]=Module["print"]}if(!Module["arguments"]){Module["arguments"]=[]}if(!Module["thisProgram"]){Module["thisProgram"]="./this.program"}if(!Module["quit"]){Module["quit"]=(function(status,toThrow){throw toThrow})}Module.print=Module["print"];Module.printErr=Module["printErr"];Module["preRun"]=[];Module["postRun"]=[];for(key in moduleOverrides){if(moduleOverrides.hasOwnProperty(key)){Module[key]=moduleOverrides[key]}}moduleOverrides=undefined;var Runtime={setTempRet0:(function(value){tempRet0=value;return value}),getTempRet0:(function(){return tempRet0}),stackSave:(function(){return STACKTOP}),stackRestore:(function(stackTop){STACKTOP=stackTop}),getNativeTypeSize:(function(type){switch(type){case"i1":case"i8":return 1;case"i16":return 2;case"i32":return 4;case"i64":return 8;case"float":return 4;case"double":return 8;default:{if(type[type.length-1]==="*"){return Runtime.QUANTUM_SIZE}else if(type[0]==="i"){var bits=parseInt(type.substr(1));assert(bits%8===0);return bits/8}else{return 0}}}}),getNativeFieldSize:(function(type){return Math.max(Runtime.getNativeTypeSize(type),Runtime.QUANTUM_SIZE)}),STACK_ALIGN:16,prepVararg:(function(ptr,type){if(type==="double"||type==="i64"){if(ptr&7){assert((ptr&7)===4);ptr+=4}}else{assert((ptr&3)===0)}return ptr}),getAlignSize:(function(type,size,vararg){if(!vararg&&(type=="i64"||type=="double"))return 8;if(!type)return Math.min(size,8);return Math.min(size||(type?Runtime.getNativeFieldSize(type):0),Runtime.QUANTUM_SIZE)}),dynCall:(function(sig,ptr,args){if(args&&args.length){return Module["dynCall_"+sig].apply(null,[ptr].concat(args))}else{return Module["dynCall_"+sig].call(null,ptr)}}),functionPointers:[],addFunction:(function(func){for(var i=0;i<Runtime.functionPointers.length;i++){if(!Runtime.functionPointers[i]){Runtime.functionPointers[i]=func;return 2*(1+i)}}throw"Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS."}),removeFunction:(function(index){Runtime.functionPointers[(index-2)/2]=null}),warnOnce:(function(text){if(!Runtime.warnOnce.shown)Runtime.warnOnce.shown={};if(!Runtime.warnOnce.shown[text]){Runtime.warnOnce.shown[text]=1;Module.printErr(text)}}),funcWrappers:{},getFuncWrapper:(function(func,sig){if(!func)return;assert(sig);if(!Runtime.funcWrappers[sig]){Runtime.funcWrappers[sig]={}}var sigCache=Runtime.funcWrappers[sig];if(!sigCache[func]){if(sig.length===1){sigCache[func]=function dynCall_wrapper(){return Runtime.dynCall(sig,func)}}else if(sig.length===2){sigCache[func]=function dynCall_wrapper(arg){return Runtime.dynCall(sig,func,[arg])}}else{sigCache[func]=function dynCall_wrapper(){return Runtime.dynCall(sig,func,Array.prototype.slice.call(arguments))}}}return sigCache[func]}),getCompilerSetting:(function(name){throw"You must build with -s RETAIN_COMPILER_SETTINGS=1 for Runtime.getCompilerSetting or emscripten_get_compiler_setting to work"}),stackAlloc:(function(size){var ret=STACKTOP;STACKTOP=STACKTOP+size|0;STACKTOP=STACKTOP+15&-16;return ret}),staticAlloc:(function(size){var ret=STATICTOP;STATICTOP=STATICTOP+size|0;STATICTOP=STATICTOP+15&-16;return ret}),dynamicAlloc:(function(size){var ret=HEAP32[DYNAMICTOP_PTR>>2];var end=(ret+size+15|0)&-16;HEAP32[DYNAMICTOP_PTR>>2]=end;if(end>=TOTAL_MEMORY){var success=enlargeMemory();if(!success){HEAP32[DYNAMICTOP_PTR>>2]=ret;return 0}}return ret}),alignMemory:(function(size,quantum){var ret=size=Math.ceil(size/(quantum?quantum:16))*(quantum?quantum:16);return ret}),makeBigInt:(function(low,high,unsigned){var ret=unsigned?+(low>>>0)+ +(high>>>0)*+4294967296:+(low>>>0)+ +(high|0)*+4294967296;return ret}),GLOBAL_BASE:8,QUANTUM_SIZE:4,__dummy__:0};Module["Runtime"]=Runtime;var ABORT=0;var EXITSTATUS=0;function assert(condition,text){if(!condition){abort("Assertion failed: "+text)}}function getCFunc(ident){var func=Module["_"+ident];assert(func,"Cannot call unknown function "+ident+", make sure it is exported");return func}var JSfuncs={"stackSave":(function(){Runtime.stackSave()}),"stackRestore":(function(){Runtime.stackRestore()}),"arrayToC":(function(arr){var ret=Runtime.stackAlloc(arr.length);writeArrayToMemory(arr,ret);return ret}),"stringToC":(function(str){var ret=0;if(str!==null&&str!==undefined&&str!==0){var len=(str.length<<2)+1;ret=Runtime.stackAlloc(len);stringToUTF8(str,ret,len)}return ret})};var toC={"string":JSfuncs["stringToC"],"array":JSfuncs["arrayToC"]};function ccall(ident,returnType,argTypes,args,opts){var func=getCFunc(ident);var cArgs=[];var stack=0;if(args){for(var i=0;i<args.length;i++){var converter=toC[argTypes[i]];if(converter){if(stack===0)stack=Runtime.stackSave();cArgs[i]=converter(args[i])}else{cArgs[i]=args[i]}}}var ret=func.apply(null,cArgs);if(returnType==="string")ret=Pointer_stringify(ret);if(stack!==0){Runtime.stackRestore(stack)}return ret}function setValue(ptr,value,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":HEAP8[ptr>>0]=value;break;case"i8":HEAP8[ptr>>0]=value;break;case"i16":HEAP16[ptr>>1]=value;break;case"i32":HEAP32[ptr>>2]=value;break;case"i64":tempI64=[value>>>0,(tempDouble=value,+Math_abs(tempDouble)>=+1?tempDouble>+0?(Math_min(+Math_floor(tempDouble/+4294967296),+4294967295)|0)>>>0:~~+Math_ceil((tempDouble- +(~~tempDouble>>>0))/+4294967296)>>>0:0)],HEAP32[ptr>>2]=tempI64[0],HEAP32[ptr+4>>2]=tempI64[1];break;case"float":HEAPF32[ptr>>2]=value;break;case"double":HEAPF64[ptr>>3]=value;break;default:abort("invalid type for setValue: "+type)}}var ALLOC_NORMAL=0;var ALLOC_STACK=1;var ALLOC_STATIC=2;var ALLOC_DYNAMIC=3;var ALLOC_NONE=4;Module["ALLOC_NORMAL"]=ALLOC_NORMAL;Module["ALLOC_STACK"]=ALLOC_STACK;Module["ALLOC_STATIC"]=ALLOC_STATIC;Module["ALLOC_DYNAMIC"]=ALLOC_DYNAMIC;Module["ALLOC_NONE"]=ALLOC_NONE;function allocate(slab,types,allocator,ptr){var zeroinit,size;if(typeof slab==="number"){zeroinit=true;size=slab}else{zeroinit=false;size=slab.length}var singleType=typeof types==="string"?types:null;var ret;if(allocator==ALLOC_NONE){ret=ptr}else{ret=[typeof _malloc==="function"?_malloc:Runtime.staticAlloc,Runtime.stackAlloc,Runtime.staticAlloc,Runtime.dynamicAlloc][allocator===undefined?ALLOC_STATIC:allocator](Math.max(size,singleType?1:types.length))}if(zeroinit){var stop;ptr=ret;assert((ret&3)==0);stop=ret+(size&~3);for(;ptr<stop;ptr+=4){HEAP32[ptr>>2]=0}stop=ret+size;while(ptr<stop){HEAP8[ptr++>>0]=0}return ret}if(singleType==="i8"){if(slab.subarray||slab.slice){HEAPU8.set(slab,ret)}else{HEAPU8.set(new Uint8Array(slab),ret)}return ret}var i=0,type,typeSize,previousType;while(i<size){var curr=slab[i];if(typeof curr==="function"){curr=Runtime.getFunctionIndex(curr)}type=singleType||types[i];if(type===0){i++;continue}if(type=="i64")type="i32";setValue(ret+i,curr,type);if(previousType!==type){typeSize=Runtime.getNativeTypeSize(type);previousType=type}i+=typeSize}return ret}function getMemory(size){if(!staticSealed)return Runtime.staticAlloc(size);if(!runtimeInitialized)return Runtime.dynamicAlloc(size);return _malloc(size)}Module["getMemory"]=getMemory;function Pointer_stringify(ptr,length){if(length===0||!ptr)return"";var hasUtf=0;var t;var i=0;while(1){t=HEAPU8[ptr+i>>0];hasUtf|=t;if(t==0&&!length)break;i++;if(length&&i==length)break}if(!length)length=i;var ret="";if(hasUtf<128){var MAX_CHUNK=1024;var curr;while(length>0){curr=String.fromCharCode.apply(String,HEAPU8.subarray(ptr,ptr+Math.min(length,MAX_CHUNK)));ret=ret?ret+curr:curr;ptr+=MAX_CHUNK;length-=MAX_CHUNK}return ret}return UTF8ToString(ptr)}var UTF8Decoder=typeof TextDecoder!=="undefined"?new TextDecoder("utf8"):undefined;function UTF8ArrayToString(u8Array,idx){var endPtr=idx;while(u8Array[endPtr])++endPtr;if(endPtr-idx>16&&u8Array.subarray&&UTF8Decoder){return UTF8Decoder.decode(u8Array.subarray(idx,endPtr))}else{var u0,u1,u2,u3,u4,u5;var str="";while(1){u0=u8Array[idx++];if(!u0)return str;if(!(u0&128)){str+=String.fromCharCode(u0);continue}u1=u8Array[idx++]&63;if((u0&224)==192){str+=String.fromCharCode((u0&31)<<6|u1);continue}u2=u8Array[idx++]&63;if((u0&240)==224){u0=(u0&15)<<12|u1<<6|u2}else{u3=u8Array[idx++]&63;if((u0&248)==240){u0=(u0&7)<<18|u1<<12|u2<<6|u3}else{u4=u8Array[idx++]&63;if((u0&252)==248){u0=(u0&3)<<24|u1<<18|u2<<12|u3<<6|u4}else{u5=u8Array[idx++]&63;u0=(u0&1)<<30|u1<<24|u2<<18|u3<<12|u4<<6|u5}}}if(u0<65536){str+=String.fromCharCode(u0)}else{var ch=u0-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}}}}function UTF8ToString(ptr){return UTF8ArrayToString(HEAPU8,ptr)}function stringToUTF8Array(str,outU8Array,outIdx,maxBytesToWrite){if(!(maxBytesToWrite>0))return 0;var startIdx=outIdx;var endIdx=outIdx+maxBytesToWrite-1;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){if(outIdx>=endIdx)break;outU8Array[outIdx++]=u}else if(u<=2047){if(outIdx+1>=endIdx)break;outU8Array[outIdx++]=192|u>>6;outU8Array[outIdx++]=128|u&63}else if(u<=65535){if(outIdx+2>=endIdx)break;outU8Array[outIdx++]=224|u>>12;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=2097151){if(outIdx+3>=endIdx)break;outU8Array[outIdx++]=240|u>>18;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=67108863){if(outIdx+4>=endIdx)break;outU8Array[outIdx++]=248|u>>24;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else{if(outIdx+5>=endIdx)break;outU8Array[outIdx++]=252|u>>30;outU8Array[outIdx++]=128|u>>24&63;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}}outU8Array[outIdx]=0;return outIdx-startIdx}function stringToUTF8(str,outPtr,maxBytesToWrite){return stringToUTF8Array(str,HEAPU8,outPtr,maxBytesToWrite)}function lengthBytesUTF8(str){var len=0;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){++len}else if(u<=2047){len+=2}else if(u<=65535){len+=3}else if(u<=2097151){len+=4}else if(u<=67108863){len+=5}else{len+=6}}return len}var UTF16Decoder=typeof TextDecoder!=="undefined"?new TextDecoder("utf-16le"):undefined;function demangle(func){return func}function demangleAll(text){var regex=/__Z[\w\d_]+/g;return text.replace(regex,(function(x){var y=demangle(x);return x===y?x:x+" ["+y+"]"}))}function jsStackTrace(){var err=new Error;if(!err.stack){try{throw new Error(0)}catch(e){err=e}if(!err.stack){return"(no stack trace available)"}}return err.stack.toString()}function stackTrace(){var js=jsStackTrace();if(Module["extraStackTrace"])js+="\n"+Module["extraStackTrace"]();return demangleAll(js)}var WASM_PAGE_SIZE=65536;var ASMJS_PAGE_SIZE=16777216;var MIN_TOTAL_MEMORY=16777216;function alignUp(x,multiple){if(x%multiple>0){x+=multiple-x%multiple}return x}var HEAP,buffer,HEAP8,HEAPU8,HEAP16,HEAPU16,HEAP32,HEAPU32,HEAPF32,HEAPF64;function updateGlobalBuffer(buf){Module["buffer"]=buffer=buf}function updateGlobalBufferViews(){Module["HEAP8"]=HEAP8=new Int8Array(buffer);Module["HEAP16"]=HEAP16=new Int16Array(buffer);Module["HEAP32"]=HEAP32=new Int32Array(buffer);Module["HEAPU8"]=HEAPU8=new Uint8Array(buffer);Module["HEAPU16"]=HEAPU16=new Uint16Array(buffer);Module["HEAPU32"]=HEAPU32=new Uint32Array(buffer);Module["HEAPF32"]=HEAPF32=new Float32Array(buffer);Module["HEAPF64"]=HEAPF64=new Float64Array(buffer)}var STATIC_BASE,STATICTOP,staticSealed;var STACK_BASE,STACKTOP,STACK_MAX;var DYNAMIC_BASE,DYNAMICTOP_PTR;STATIC_BASE=STATICTOP=STACK_BASE=STACKTOP=STACK_MAX=DYNAMIC_BASE=DYNAMICTOP_PTR=0;staticSealed=false;function abortOnCannotGrowMemory(){abort("Cannot enlarge memory arrays. Either (1) compile with  -s TOTAL_MEMORY=X  with X higher than the current value "+TOTAL_MEMORY+", (2) compile with  -s ALLOW_MEMORY_GROWTH=1  which allows increasing the size at runtime but prevents some optimizations, (3) set Module.TOTAL_MEMORY to a higher value before the program runs, or (4) if you want malloc to return NULL (0) instead of this abort, compile with  -s ABORTING_MALLOC=0 ")}if(!Module["reallocBuffer"])Module["reallocBuffer"]=(function(size){var ret;try{if(ArrayBuffer.transfer){ret=ArrayBuffer.transfer(buffer,size)}else{var oldHEAP8=HEAP8;ret=new ArrayBuffer(size);var temp=new Int8Array(ret);temp.set(oldHEAP8)}}catch(e){return false}var success=_emscripten_replace_memory(ret);if(!success)return false;return ret});function enlargeMemory(){var PAGE_MULTIPLE=Module["usingWasm"]?WASM_PAGE_SIZE:ASMJS_PAGE_SIZE;var LIMIT=2147483648-PAGE_MULTIPLE;if(HEAP32[DYNAMICTOP_PTR>>2]>LIMIT){return false}var OLD_TOTAL_MEMORY=TOTAL_MEMORY;TOTAL_MEMORY=Math.max(TOTAL_MEMORY,MIN_TOTAL_MEMORY);while(TOTAL_MEMORY<HEAP32[DYNAMICTOP_PTR>>2]){if(TOTAL_MEMORY<=536870912){TOTAL_MEMORY=alignUp(2*TOTAL_MEMORY,PAGE_MULTIPLE)}else{TOTAL_MEMORY=Math.min(alignUp((3*TOTAL_MEMORY+2147483648)/4,PAGE_MULTIPLE),LIMIT)}}var replacement=Module["reallocBuffer"](TOTAL_MEMORY);if(!replacement||replacement.byteLength!=TOTAL_MEMORY){TOTAL_MEMORY=OLD_TOTAL_MEMORY;return false}updateGlobalBuffer(replacement);updateGlobalBufferViews();return true}var byteLength;try{byteLength=Function.prototype.call.bind(Object.getOwnPropertyDescriptor(ArrayBuffer.prototype,"byteLength").get);byteLength(new ArrayBuffer(4))}catch(e){byteLength=(function(buffer){return buffer.byteLength})}var TOTAL_STACK=Module["TOTAL_STACK"]||5242880;var TOTAL_MEMORY=Module["TOTAL_MEMORY"]||16777216;if(TOTAL_MEMORY<TOTAL_STACK)Module.printErr("TOTAL_MEMORY should be larger than TOTAL_STACK, was "+TOTAL_MEMORY+"! (TOTAL_STACK="+TOTAL_STACK+")");if(Module["buffer"]){buffer=Module["buffer"]}else{{buffer=new ArrayBuffer(TOTAL_MEMORY)}}updateGlobalBufferViews();function getTotalMemory(){return TOTAL_MEMORY}HEAP32[0]=1668509029;HEAP16[1]=25459;if(HEAPU8[2]!==115||HEAPU8[3]!==99)throw"Runtime error: expected the system to be little-endian!";Module["HEAP"]=HEAP;Module["buffer"]=buffer;Module["HEAP8"]=HEAP8;Module["HEAP16"]=HEAP16;Module["HEAP32"]=HEAP32;Module["HEAPU8"]=HEAPU8;Module["HEAPU16"]=HEAPU16;Module["HEAPU32"]=HEAPU32;Module["HEAPF32"]=HEAPF32;Module["HEAPF64"]=HEAPF64;function callRuntimeCallbacks(callbacks){while(callbacks.length>0){var callback=callbacks.shift();if(typeof callback=="function"){callback();continue}var func=callback.func;if(typeof func==="number"){if(callback.arg===undefined){Module["dynCall_v"](func)}else{Module["dynCall_vi"](func,callback.arg)}}else{func(callback.arg===undefined?null:callback.arg)}}}var __ATPRERUN__=[];var __ATINIT__=[];var __ATMAIN__=[];var __ATEXIT__=[];var __ATPOSTRUN__=[];var runtimeInitialized=false;var runtimeExited=false;function preRun(){if(Module["preRun"]){if(typeof Module["preRun"]=="function")Module["preRun"]=[Module["preRun"]];while(Module["preRun"].length){addOnPreRun(Module["preRun"].shift())}}callRuntimeCallbacks(__ATPRERUN__)}function ensureInitRuntime(){if(runtimeInitialized)return;runtimeInitialized=true;callRuntimeCallbacks(__ATINIT__)}function preMain(){callRuntimeCallbacks(__ATMAIN__)}function exitRuntime(){callRuntimeCallbacks(__ATEXIT__);runtimeExited=true}function postRun(){if(Module["postRun"]){if(typeof Module["postRun"]=="function")Module["postRun"]=[Module["postRun"]];while(Module["postRun"].length){addOnPostRun(Module["postRun"].shift())}}callRuntimeCallbacks(__ATPOSTRUN__)}function addOnPreRun(cb){__ATPRERUN__.unshift(cb)}function addOnPostRun(cb){__ATPOSTRUN__.unshift(cb)}function writeArrayToMemory(array,buffer){HEAP8.set(array,buffer)}function writeAsciiToMemory(str,buffer,dontAddNull){for(var i=0;i<str.length;++i){HEAP8[buffer++>>0]=str.charCodeAt(i)}if(!dontAddNull)HEAP8[buffer>>0]=0}if(!Math["imul"]||Math["imul"](4294967295,5)!==-5)Math["imul"]=function imul(a,b){var ah=a>>>16;var al=a&65535;var bh=b>>>16;var bl=b&65535;return al*bl+(ah*bl+al*bh<<16)|0};Math.imul=Math["imul"];if(!Math["clz32"])Math["clz32"]=(function(x){x=x>>>0;for(var i=0;i<32;i++){if(x&1<<31-i)return i}return 32});Math.clz32=Math["clz32"];if(!Math["trunc"])Math["trunc"]=(function(x){return x<0?Math.ceil(x):Math.floor(x)});Math.trunc=Math["trunc"];var Math_abs=Math.abs;var Math_cos=Math.cos;var Math_sin=Math.sin;var Math_tan=Math.tan;var Math_acos=Math.acos;var Math_asin=Math.asin;var Math_atan=Math.atan;var Math_atan2=Math.atan2;var Math_exp=Math.exp;var Math_log=Math.log;var Math_sqrt=Math.sqrt;var Math_ceil=Math.ceil;var Math_floor=Math.floor;var Math_pow=Math.pow;var Math_imul=Math.imul;var Math_fround=Math.fround;var Math_round=Math.round;var Math_min=Math.min;var Math_clz32=Math.clz32;var Math_trunc=Math.trunc;var runDependencies=0;var runDependencyWatcher=null;var dependenciesFulfilled=null;function getUniqueRunDependency(id){return id}function addRunDependency(id){runDependencies++;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}}Module["addRunDependency"]=addRunDependency;function removeRunDependency(id){runDependencies--;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}if(runDependencies==0){if(runDependencyWatcher!==null){clearInterval(runDependencyWatcher);runDependencyWatcher=null}if(dependenciesFulfilled){var callback=dependenciesFulfilled;dependenciesFulfilled=null;callback()}}}Module["removeRunDependency"]=removeRunDependency;Module["preloadedImages"]={};Module["preloadedAudios"]={};var memoryInitializer=null;var ASM_CONSTS=[];STATIC_BASE=Runtime.GLOBAL_BASE;STATICTOP=STATIC_BASE+79888;__ATINIT__.push({func:(function(){__GLOBAL__I_000101()})},{func:(function(){__GLOBAL__sub_I_box_cc()})},{func:(function(){__GLOBAL__sub_I_heif_cc()})},{func:(function(){__GLOBAL__sub_I_heif_plugin_registry_cc()})},{func:(function(){__GLOBAL__sub_I_bind_cpp()})},{func:(function(){__GLOBAL__sub_I_iostream_cpp()})});memoryInitializer="data:application/octet-stream;base64,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";var tempDoublePtr=STATICTOP;STATICTOP+=16;function __ZSt18uncaught_exceptionv(){return!!__ZSt18uncaught_exceptionv.uncaught_exception}function ___assert_fail(condition,filename,line,func){ABORT=true;throw"Assertion failed: "+Pointer_stringify(condition)+", at: "+[filename?Pointer_stringify(filename):"unknown filename",line,func?Pointer_stringify(func):"unknown function"]+" at "+stackTrace()}function ___cxa_allocate_exception(size){return _malloc(size)}var EXCEPTIONS={last:0,caught:[],infos:{},deAdjust:(function(adjusted){if(!adjusted||EXCEPTIONS.infos[adjusted])return adjusted;for(var ptr in EXCEPTIONS.infos){var info=EXCEPTIONS.infos[ptr];if(info.adjusted===adjusted){return ptr}}return adjusted}),addRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];info.refcount++}),decRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];assert(info.refcount>0);info.refcount--;if(info.refcount===0&&!info.rethrown){if(info.destructor){Module["dynCall_vi"](info.destructor,ptr)}delete EXCEPTIONS.infos[ptr];___cxa_free_exception(ptr)}}),clearRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];info.refcount=0})};function ___cxa_begin_catch(ptr){var info=EXCEPTIONS.infos[ptr];if(info&&!info.caught){info.caught=true;__ZSt18uncaught_exceptionv.uncaught_exception--}if(info)info.rethrown=false;EXCEPTIONS.caught.push(ptr);EXCEPTIONS.addRef(EXCEPTIONS.deAdjust(ptr));return ptr}function ___cxa_pure_virtual(){ABORT=true;throw"Pure virtual function called!"}function ___resumeException(ptr){if(!EXCEPTIONS.last){EXCEPTIONS.last=ptr}throw ptr+" - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch."}function ___cxa_find_matching_catch(){var thrown=EXCEPTIONS.last;if(!thrown){return(Runtime.setTempRet0(0),0)|0}var info=EXCEPTIONS.infos[thrown];var throwntype=info.type;if(!throwntype){return(Runtime.setTempRet0(0),thrown)|0}var typeArray=Array.prototype.slice.call(arguments);var pointer=Module["___cxa_is_pointer_type"](throwntype);if(!___cxa_find_matching_catch.buffer)___cxa_find_matching_catch.buffer=_malloc(4);HEAP32[___cxa_find_matching_catch.buffer>>2]=thrown;thrown=___cxa_find_matching_catch.buffer;for(var i=0;i<typeArray.length;i++){if(typeArray[i]&&Module["___cxa_can_catch"](typeArray[i],throwntype,thrown)){thrown=HEAP32[thrown>>2];info.adjusted=thrown;return(Runtime.setTempRet0(typeArray[i]),thrown)|0}}thrown=HEAP32[thrown>>2];return(Runtime.setTempRet0(throwntype),thrown)|0}function ___cxa_throw(ptr,type,destructor){EXCEPTIONS.infos[ptr]={ptr:ptr,adjusted:ptr,type:type,destructor:destructor,refcount:0,caught:false,rethrown:false};EXCEPTIONS.last=ptr;if(!("uncaught_exception"in __ZSt18uncaught_exceptionv)){__ZSt18uncaught_exceptionv.uncaught_exception=1}else{__ZSt18uncaught_exceptionv.uncaught_exception++}throw ptr+" - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch."}function ___gxx_personality_v0(){}function ___lock(){}var ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:42,EIDRM:43,ECHRNG:44,EL2NSYNC:45,EL3HLT:46,EL3RST:47,ELNRNG:48,EUNATCH:49,ENOCSI:50,EL2HLT:51,EDEADLK:35,ENOLCK:37,EBADE:52,EBADR:53,EXFULL:54,ENOANO:55,EBADRQC:56,EBADSLT:57,EDEADLOCK:35,EBFONT:59,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:72,EDOTDOT:73,EBADMSG:74,ENOTUNIQ:76,EBADFD:77,EREMCHG:78,ELIBACC:79,ELIBBAD:80,ELIBSCN:81,ELIBMAX:82,ELIBEXEC:83,ENOSYS:38,ENOTEMPTY:39,ENAMETOOLONG:36,ELOOP:40,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:97,EPROTOTYPE:91,ENOTSOCK:88,ENOPROTOOPT:92,ESHUTDOWN:108,ECONNREFUSED:111,EADDRINUSE:98,ECONNABORTED:103,ENETUNREACH:101,ENETDOWN:100,ETIMEDOUT:110,EHOSTDOWN:112,EHOSTUNREACH:113,EINPROGRESS:115,EALREADY:114,EDESTADDRREQ:89,EMSGSIZE:90,EPROTONOSUPPORT:93,ESOCKTNOSUPPORT:94,EADDRNOTAVAIL:99,ENETRESET:102,EISCONN:106,ENOTCONN:107,ETOOMANYREFS:109,EUSERS:87,EDQUOT:122,ESTALE:116,ENOTSUP:95,ENOMEDIUM:123,EILSEQ:84,EOVERFLOW:75,ECANCELED:125,ENOTRECOVERABLE:131,EOWNERDEAD:130,ESTRPIPE:86};function ___setErrNo(value){if(Module["___errno_location"])HEAP32[Module["___errno_location"]()>>2]=value;return value}function ___map_file(pathname,size){___setErrNo(ERRNO_CODES.EPERM);return-1}var ERRNO_MESSAGES={0:"Success",1:"Not super-user",2:"No such file or directory",3:"No such process",4:"Interrupted system call",5:"I/O error",6:"No such device or address",7:"Arg list too long",8:"Exec format error",9:"Bad file number",10:"No children",11:"No more processes",12:"Not enough core",13:"Permission denied",14:"Bad address",15:"Block device required",16:"Mount device busy",17:"File exists",18:"Cross-device link",19:"No such device",20:"Not a directory",21:"Is a directory",22:"Invalid argument",23:"Too many open files in system",24:"Too many open files",25:"Not a typewriter",26:"Text file busy",27:"File too large",28:"No space left on device",29:"Illegal seek",30:"Read only file system",31:"Too many links",32:"Broken pipe",33:"Math arg out of domain of func",34:"Math result not representable",35:"File locking deadlock error",36:"File or path name too long",37:"No record locks available",38:"Function not implemented",39:"Directory not empty",40:"Too many symbolic links",42:"No message of desired type",43:"Identifier removed",44:"Channel number out of range",45:"Level 2 not synchronized",46:"Level 3 halted",47:"Level 3 reset",48:"Link number out of range",49:"Protocol driver not attached",50:"No CSI structure available",51:"Level 2 halted",52:"Invalid exchange",53:"Invalid request descriptor",54:"Exchange full",55:"No anode",56:"Invalid request code",57:"Invalid slot",59:"Bad font file fmt",60:"Device not a stream",61:"No data (for no delay io)",62:"Timer expired",63:"Out of streams resources",64:"Machine is not on the network",65:"Package not installed",66:"The object is remote",67:"The link has been severed",68:"Advertise error",69:"Srmount error",70:"Communication error on send",71:"Protocol error",72:"Multihop attempted",73:"Cross mount point (not really error)",74:"Trying to read unreadable message",75:"Value too large for defined data type",76:"Given log. name not unique",77:"f.d. invalid for this operation",78:"Remote address changed",79:"Can   access a needed shared lib",80:"Accessing a corrupted shared lib",81:".lib section in a.out corrupted",82:"Attempting to link in too many libs",83:"Attempting to exec a shared library",84:"Illegal byte sequence",86:"Streams pipe error",87:"Too many users",88:"Socket operation on non-socket",89:"Destination address required",90:"Message too long",91:"Protocol wrong type for socket",92:"Protocol not available",93:"Unknown protocol",94:"Socket type not supported",95:"Not supported",96:"Protocol family not supported",97:"Address family not supported by protocol family",98:"Address already in use",99:"Address not available",100:"Network interface is not configured",101:"Network is unreachable",102:"Connection reset by network",103:"Connection aborted",104:"Connection reset by peer",105:"No buffer space available",106:"Socket is already connected",107:"Socket is not connected",108:"Can't send after socket shutdown",109:"Too many references",110:"Connection timed out",111:"Connection refused",112:"Host is down",113:"Host is unreachable",114:"Socket already connected",115:"Connection already in progress",116:"Stale file handle",122:"Quota exceeded",123:"No medium (in tape drive)",125:"Operation canceled",130:"Previous owner died",131:"State not recoverable"};var PATH={splitPath:(function(filename){var splitPathRe=/^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;return splitPathRe.exec(filename).slice(1)}),normalizeArray:(function(parts,allowAboveRoot){var up=0;for(var i=parts.length-1;i>=0;i--){var last=parts[i];if(last==="."){parts.splice(i,1)}else if(last===".."){parts.splice(i,1);up++}else if(up){parts.splice(i,1);up--}}if(allowAboveRoot){for(;up;up--){parts.unshift("..")}}return parts}),normalize:(function(path){var isAbsolute=path.charAt(0)==="/",trailingSlash=path.substr(-1)==="/";path=PATH.normalizeArray(path.split("/").filter((function(p){return!!p})),!isAbsolute).join("/");if(!path&&!isAbsolute){path="."}if(path&&trailingSlash){path+="/"}return(isAbsolute?"/":"")+path}),dirname:(function(path){var result=PATH.splitPath(path),root=result[0],dir=result[1];if(!root&&!dir){return"."}if(dir){dir=dir.substr(0,dir.length-1)}return root+dir}),basename:(function(path){if(path==="/")return"/";var lastSlash=path.lastIndexOf("/");if(lastSlash===-1)return path;return path.substr(lastSlash+1)}),extname:(function(path){return PATH.splitPath(path)[3]}),join:(function(){var paths=Array.prototype.slice.call(arguments,0);return PATH.normalize(paths.join("/"))}),join2:(function(l,r){return PATH.normalize(l+"/"+r)}),resolve:(function(){var resolvedPath="",resolvedAbsolute=false;for(var i=arguments.length-1;i>=-1&&!resolvedAbsolute;i--){var path=i>=0?arguments[i]:FS.cwd();if(typeof path!=="string"){throw new TypeError("Arguments to path.resolve must be strings")}else if(!path){return""}resolvedPath=path+"/"+resolvedPath;resolvedAbsolute=path.charAt(0)==="/"}resolvedPath=PATH.normalizeArray(resolvedPath.split("/").filter((function(p){return!!p})),!resolvedAbsolute).join("/");return(resolvedAbsolute?"/":"")+resolvedPath||"."}),relative:(function(from,to){from=PATH.resolve(from).substr(1);to=PATH.resolve(to).substr(1);function trim(arr){var start=0;for(;start<arr.length;start++){if(arr[start]!=="")break}var end=arr.length-1;for(;end>=0;end--){if(arr[end]!=="")break}if(start>end)return[];return arr.slice(start,end-start+1)}var fromParts=trim(from.split("/"));var toParts=trim(to.split("/"));var length=Math.min(fromParts.length,toParts.length);var samePartsLength=length;for(var i=0;i<length;i++){if(fromParts[i]!==toParts[i]){samePartsLength=i;break}}var outputParts=[];for(var i=samePartsLength;i<fromParts.length;i++){outputParts.push("..")}outputParts=outputParts.concat(toParts.slice(samePartsLength));return outputParts.join("/")})};var TTY={ttys:[],init:(function(){}),shutdown:(function(){}),register:(function(dev,ops){TTY.ttys[dev]={input:[],output:[],ops:ops};FS.registerDevice(dev,TTY.stream_ops)}),stream_ops:{open:(function(stream){var tty=TTY.ttys[stream.node.rdev];if(!tty){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}stream.tty=tty;stream.seekable=false}),close:(function(stream){stream.tty.ops.flush(stream.tty)}),flush:(function(stream){stream.tty.ops.flush(stream.tty)}),read:(function(stream,buffer,offset,length,pos){if(!stream.tty||!stream.tty.ops.get_char){throw new FS.ErrnoError(ERRNO_CODES.ENXIO)}var bytesRead=0;for(var i=0;i<length;i++){var result;try{result=stream.tty.ops.get_char(stream.tty)}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}if(result===undefined&&bytesRead===0){throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}if(result===null||result===undefined)break;bytesRead++;buffer[offset+i]=result}if(bytesRead){stream.node.timestamp=Date.now()}return bytesRead}),write:(function(stream,buffer,offset,length,pos){if(!stream.tty||!stream.tty.ops.put_char){throw new FS.ErrnoError(ERRNO_CODES.ENXIO)}for(var i=0;i<length;i++){try{stream.tty.ops.put_char(stream.tty,buffer[offset+i])}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}}if(length){stream.node.timestamp=Date.now()}return i})},default_tty_ops:{get_char:(function(tty){if(!tty.input.length){var result=null;if(ENVIRONMENT_IS_NODE){var BUFSIZE=256;var buf=new Buffer(BUFSIZE);var bytesRead=0;var isPosixPlatform=process.platform!="win32";var fd=process.stdin.fd;if(isPosixPlatform){var usingDevice=false;try{fd=fs.openSync("/dev/stdin","r");usingDevice=true}catch(e){}}try{bytesRead=fs.readSync(fd,buf,0,BUFSIZE,null)}catch(e){if(e.toString().indexOf("EOF")!=-1)bytesRead=0;else throw e}if(usingDevice){fs.closeSync(fd)}if(bytesRead>0){result=buf.slice(0,bytesRead).toString("utf-8")}else{result=null}}else if(typeof window!="undefined"&&typeof window.prompt=="function"){result=window.prompt("Input: ");if(result!==null){result+="\n"}}else if(typeof readline=="function"){result=readline();if(result!==null){result+="\n"}}if(!result){return null}tty.input=intArrayFromString(result,true)}return tty.input.shift()}),put_char:(function(tty,val){if(val===null||val===10){Module["print"](UTF8ArrayToString(tty.output,0));tty.output=[]}else{if(val!=0)tty.output.push(val)}}),flush:(function(tty){if(tty.output&&tty.output.length>0){Module["print"](UTF8ArrayToString(tty.output,0));tty.output=[]}})},default_tty1_ops:{put_char:(function(tty,val){if(val===null||val===10){Module["printErr"](UTF8ArrayToString(tty.output,0));tty.output=[]}else{if(val!=0)tty.output.push(val)}}),flush:(function(tty){if(tty.output&&tty.output.length>0){Module["printErr"](UTF8ArrayToString(tty.output,0));tty.output=[]}})}};var MEMFS={ops_table:null,mount:(function(mount){return MEMFS.createNode(null,"/",16384|511,0)}),createNode:(function(parent,name,mode,dev){if(FS.isBlkdev(mode)||FS.isFIFO(mode)){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(!MEMFS.ops_table){MEMFS.ops_table={dir:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr,lookup:MEMFS.node_ops.lookup,mknod:MEMFS.node_ops.mknod,rename:MEMFS.node_ops.rename,unlink:MEMFS.node_ops.unlink,rmdir:MEMFS.node_ops.rmdir,readdir:MEMFS.node_ops.readdir,symlink:MEMFS.node_ops.symlink},stream:{llseek:MEMFS.stream_ops.llseek}},file:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr},stream:{llseek:MEMFS.stream_ops.llseek,read:MEMFS.stream_ops.read,write:MEMFS.stream_ops.write,allocate:MEMFS.stream_ops.allocate,mmap:MEMFS.stream_ops.mmap,msync:MEMFS.stream_ops.msync}},link:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr,readlink:MEMFS.node_ops.readlink},stream:{}},chrdev:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr},stream:FS.chrdev_stream_ops}}}var node=FS.createNode(parent,name,mode,dev);if(FS.isDir(node.mode)){node.node_ops=MEMFS.ops_table.dir.node;node.stream_ops=MEMFS.ops_table.dir.stream;node.contents={}}else if(FS.isFile(node.mode)){node.node_ops=MEMFS.ops_table.file.node;node.stream_ops=MEMFS.ops_table.file.stream;node.usedBytes=0;node.contents=null}else if(FS.isLink(node.mode)){node.node_ops=MEMFS.ops_table.link.node;node.stream_ops=MEMFS.ops_table.link.stream}else if(FS.isChrdev(node.mode)){node.node_ops=MEMFS.ops_table.chrdev.node;node.stream_ops=MEMFS.ops_table.chrdev.stream}node.timestamp=Date.now();if(parent){parent.contents[name]=node}return node}),getFileDataAsRegularArray:(function(node){if(node.contents&&node.contents.subarray){var arr=[];for(var i=0;i<node.usedBytes;++i)arr.push(node.contents[i]);return arr}return node.contents}),getFileDataAsTypedArray:(function(node){if(!node.contents)return new Uint8Array;if(node.contents.subarray)return node.contents.subarray(0,node.usedBytes);return new Uint8Array(node.contents)}),expandFileStorage:(function(node,newCapacity){if(node.contents&&node.contents.subarray&&newCapacity>node.contents.length){node.contents=MEMFS.getFileDataAsRegularArray(node);node.usedBytes=node.contents.length}if(!node.contents||node.contents.subarray){var prevCapacity=node.contents?node.contents.length:0;if(prevCapacity>=newCapacity)return;var CAPACITY_DOUBLING_MAX=1024*1024;newCapacity=Math.max(newCapacity,prevCapacity*(prevCapacity<CAPACITY_DOUBLING_MAX?2:1.125)|0);if(prevCapacity!=0)newCapacity=Math.max(newCapacity,256);var oldContents=node.contents;node.contents=new Uint8Array(newCapacity);if(node.usedBytes>0)node.contents.set(oldContents.subarray(0,node.usedBytes),0);return}if(!node.contents&&newCapacity>0)node.contents=[];while(node.contents.length<newCapacity)node.contents.push(0)}),resizeFileStorage:(function(node,newSize){if(node.usedBytes==newSize)return;if(newSize==0){node.contents=null;node.usedBytes=0;return}if(!node.contents||node.contents.subarray){var oldContents=node.contents;node.contents=new Uint8Array(new ArrayBuffer(newSize));if(oldContents){node.contents.set(oldContents.subarray(0,Math.min(newSize,node.usedBytes)))}node.usedBytes=newSize;return}if(!node.contents)node.contents=[];if(node.contents.length>newSize)node.contents.length=newSize;else while(node.contents.length<newSize)node.contents.push(0);node.usedBytes=newSize}),node_ops:{getattr:(function(node){var attr={};attr.dev=FS.isChrdev(node.mode)?node.id:1;attr.ino=node.id;attr.mode=node.mode;attr.nlink=1;attr.uid=0;attr.gid=0;attr.rdev=node.rdev;if(FS.isDir(node.mode)){attr.size=4096}else if(FS.isFile(node.mode)){attr.size=node.usedBytes}else if(FS.isLink(node.mode)){attr.size=node.link.length}else{attr.size=0}attr.atime=new Date(node.timestamp);attr.mtime=new Date(node.timestamp);attr.ctime=new Date(node.timestamp);attr.blksize=4096;attr.blocks=Math.ceil(attr.size/attr.blksize);return attr}),setattr:(function(node,attr){if(attr.mode!==undefined){node.mode=attr.mode}if(attr.timestamp!==undefined){node.timestamp=attr.timestamp}if(attr.size!==undefined){MEMFS.resizeFileStorage(node,attr.size)}}),lookup:(function(parent,name){throw FS.genericErrors[ERRNO_CODES.ENOENT]}),mknod:(function(parent,name,mode,dev){return MEMFS.createNode(parent,name,mode,dev)}),rename:(function(old_node,new_dir,new_name){if(FS.isDir(old_node.mode)){var new_node;try{new_node=FS.lookupNode(new_dir,new_name)}catch(e){}if(new_node){for(var i in new_node.contents){throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)}}}delete old_node.parent.contents[old_node.name];old_node.name=new_name;new_dir.contents[new_name]=old_node;old_node.parent=new_dir}),unlink:(function(parent,name){delete parent.contents[name]}),rmdir:(function(parent,name){var node=FS.lookupNode(parent,name);for(var i in node.contents){throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)}delete parent.contents[name]}),readdir:(function(node){var entries=[".",".."];for(var key in node.contents){if(!node.contents.hasOwnProperty(key)){continue}entries.push(key)}return entries}),symlink:(function(parent,newname,oldpath){var node=MEMFS.createNode(parent,newname,511|40960,0);node.link=oldpath;return node}),readlink:(function(node){if(!FS.isLink(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return node.link})},stream_ops:{read:(function(stream,buffer,offset,length,position){var contents=stream.node.contents;if(position>=stream.node.usedBytes)return 0;var size=Math.min(stream.node.usedBytes-position,length);assert(size>=0);if(size>8&&contents.subarray){buffer.set(contents.subarray(position,position+size),offset)}else{for(var i=0;i<size;i++)buffer[offset+i]=contents[position+i]}return size}),write:(function(stream,buffer,offset,length,position,canOwn){if(!length)return 0;var node=stream.node;node.timestamp=Date.now();if(buffer.subarray&&(!node.contents||node.contents.subarray)){if(canOwn){node.contents=buffer.subarray(offset,offset+length);node.usedBytes=length;return length}else if(node.usedBytes===0&&position===0){node.contents=new Uint8Array(buffer.subarray(offset,offset+length));node.usedBytes=length;return length}else if(position+length<=node.usedBytes){node.contents.set(buffer.subarray(offset,offset+length),position);return length}}MEMFS.expandFileStorage(node,position+length);if(node.contents.subarray&&buffer.subarray)node.contents.set(buffer.subarray(offset,offset+length),position);else{for(var i=0;i<length;i++){node.contents[position+i]=buffer[offset+i]}}node.usedBytes=Math.max(node.usedBytes,position+length);return length}),llseek:(function(stream,offset,whence){var position=offset;if(whence===1){position+=stream.position}else if(whence===2){if(FS.isFile(stream.node.mode)){position+=stream.node.usedBytes}}if(position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return position}),allocate:(function(stream,offset,length){MEMFS.expandFileStorage(stream.node,offset+length);stream.node.usedBytes=Math.max(stream.node.usedBytes,offset+length)}),mmap:(function(stream,buffer,offset,length,position,prot,flags){if(!FS.isFile(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}var ptr;var allocated;var contents=stream.node.contents;if(!(flags&2)&&(contents.buffer===buffer||contents.buffer===buffer.buffer)){allocated=false;ptr=contents.byteOffset}else{if(position>0||position+length<stream.node.usedBytes){if(contents.subarray){contents=contents.subarray(position,position+length)}else{contents=Array.prototype.slice.call(contents,position,position+length)}}allocated=true;ptr=_malloc(length);if(!ptr){throw new FS.ErrnoError(ERRNO_CODES.ENOMEM)}buffer.set(contents,ptr)}return{ptr:ptr,allocated:allocated}}),msync:(function(stream,buffer,offset,length,mmapFlags){if(!FS.isFile(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}if(mmapFlags&2){return 0}var bytesWritten=MEMFS.stream_ops.write(stream,buffer,0,length,offset,false);return 0})}};var IDBFS={dbs:{},indexedDB:(function(){if(typeof indexedDB!=="undefined")return indexedDB;var ret=null;if(typeof window==="object")ret=window.indexedDB||window.mozIndexedDB||window.webkitIndexedDB||window.msIndexedDB;assert(ret,"IDBFS used, but indexedDB not supported");return ret}),DB_VERSION:21,DB_STORE_NAME:"FILE_DATA",mount:(function(mount){return MEMFS.mount.apply(null,arguments)}),syncfs:(function(mount,populate,callback){IDBFS.getLocalSet(mount,(function(err,local){if(err)return callback(err);IDBFS.getRemoteSet(mount,(function(err,remote){if(err)return callback(err);var src=populate?remote:local;var dst=populate?local:remote;IDBFS.reconcile(src,dst,callback)}))}))}),getDB:(function(name,callback){var db=IDBFS.dbs[name];if(db){return callback(null,db)}var req;try{req=IDBFS.indexedDB().open(name,IDBFS.DB_VERSION)}catch(e){return callback(e)}if(!req){return callback("Unable to connect to IndexedDB")}req.onupgradeneeded=(function(e){var db=e.target.result;var transaction=e.target.transaction;var fileStore;if(db.objectStoreNames.contains(IDBFS.DB_STORE_NAME)){fileStore=transaction.objectStore(IDBFS.DB_STORE_NAME)}else{fileStore=db.createObjectStore(IDBFS.DB_STORE_NAME)}if(!fileStore.indexNames.contains("timestamp")){fileStore.createIndex("timestamp","timestamp",{unique:false})}});req.onsuccess=(function(){db=req.result;IDBFS.dbs[name]=db;callback(null,db)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),getLocalSet:(function(mount,callback){var entries={};function isRealDir(p){return p!=="."&&p!==".."}function toAbsolute(root){return(function(p){return PATH.join2(root,p)})}var check=FS.readdir(mount.mountpoint).filter(isRealDir).map(toAbsolute(mount.mountpoint));while(check.length){var path=check.pop();var stat;try{stat=FS.stat(path)}catch(e){return callback(e)}if(FS.isDir(stat.mode)){check.push.apply(check,FS.readdir(path).filter(isRealDir).map(toAbsolute(path)))}entries[path]={timestamp:stat.mtime}}return callback(null,{type:"local",entries:entries})}),getRemoteSet:(function(mount,callback){var entries={};IDBFS.getDB(mount.mountpoint,(function(err,db){if(err)return callback(err);try{var transaction=db.transaction([IDBFS.DB_STORE_NAME],"readonly");transaction.onerror=(function(e){callback(this.error);e.preventDefault()});var store=transaction.objectStore(IDBFS.DB_STORE_NAME);var index=store.index("timestamp");index.openKeyCursor().onsuccess=(function(event){var cursor=event.target.result;if(!cursor){return callback(null,{type:"remote",db:db,entries:entries})}entries[cursor.primaryKey]={timestamp:cursor.key};cursor.continue()})}catch(e){return callback(e)}}))}),loadLocalEntry:(function(path,callback){var stat,node;try{var lookup=FS.lookupPath(path);node=lookup.node;stat=FS.stat(path)}catch(e){return callback(e)}if(FS.isDir(stat.mode)){return callback(null,{timestamp:stat.mtime,mode:stat.mode})}else if(FS.isFile(stat.mode)){node.contents=MEMFS.getFileDataAsTypedArray(node);return callback(null,{timestamp:stat.mtime,mode:stat.mode,contents:node.contents})}else{return callback(new Error("node type not supported"))}}),storeLocalEntry:(function(path,entry,callback){try{if(FS.isDir(entry.mode)){FS.mkdir(path,entry.mode)}else if(FS.isFile(entry.mode)){FS.writeFile(path,entry.contents,{encoding:"binary",canOwn:true})}else{return callback(new Error("node type not supported"))}FS.chmod(path,entry.mode);FS.utime(path,entry.timestamp,entry.timestamp)}catch(e){return callback(e)}callback(null)}),removeLocalEntry:(function(path,callback){try{var lookup=FS.lookupPath(path);var stat=FS.stat(path);if(FS.isDir(stat.mode)){FS.rmdir(path)}else if(FS.isFile(stat.mode)){FS.unlink(path)}}catch(e){return callback(e)}callback(null)}),loadRemoteEntry:(function(store,path,callback){var req=store.get(path);req.onsuccess=(function(event){callback(null,event.target.result)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),storeRemoteEntry:(function(store,path,entry,callback){var req=store.put(entry,path);req.onsuccess=(function(){callback(null)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),removeRemoteEntry:(function(store,path,callback){var req=store.delete(path);req.onsuccess=(function(){callback(null)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),reconcile:(function(src,dst,callback){var total=0;var create=[];Object.keys(src.entries).forEach((function(key){var e=src.entries[key];var e2=dst.entries[key];if(!e2||e.timestamp>e2.timestamp){create.push(key);total++}}));var remove=[];Object.keys(dst.entries).forEach((function(key){var e=dst.entries[key];var e2=src.entries[key];if(!e2){remove.push(key);total++}}));if(!total){return callback(null)}var completed=0;var db=src.type==="remote"?src.db:dst.db;var transaction=db.transaction([IDBFS.DB_STORE_NAME],"readwrite");var store=transaction.objectStore(IDBFS.DB_STORE_NAME);function done(err){if(err){if(!done.errored){done.errored=true;return callback(err)}return}if(++completed>=total){return callback(null)}}transaction.onerror=(function(e){done(this.error);e.preventDefault()});create.sort().forEach((function(path){if(dst.type==="local"){IDBFS.loadRemoteEntry(store,path,(function(err,entry){if(err)return done(err);IDBFS.storeLocalEntry(path,entry,done)}))}else{IDBFS.loadLocalEntry(path,(function(err,entry){if(err)return done(err);IDBFS.storeRemoteEntry(store,path,entry,done)}))}}));remove.sort().reverse().forEach((function(path){if(dst.type==="local"){IDBFS.removeLocalEntry(path,done)}else{IDBFS.removeRemoteEntry(store,path,done)}}))})};var NODEFS={isWindows:false,staticInit:(function(){NODEFS.isWindows=!!process.platform.match(/^win/)}),mount:(function(mount){assert(ENVIRONMENT_IS_NODE);return NODEFS.createNode(null,"/",NODEFS.getMode(mount.opts.root),0)}),createNode:(function(parent,name,mode,dev){if(!FS.isDir(mode)&&!FS.isFile(mode)&&!FS.isLink(mode)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var node=FS.createNode(parent,name,mode);node.node_ops=NODEFS.node_ops;node.stream_ops=NODEFS.stream_ops;return node}),getMode:(function(path){var stat;try{stat=fs.lstatSync(path);if(NODEFS.isWindows){stat.mode=stat.mode|(stat.mode&146)>>1}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}return stat.mode}),realPath:(function(node){var parts=[];while(node.parent!==node){parts.push(node.name);node=node.parent}parts.push(node.mount.opts.root);parts.reverse();return PATH.join.apply(null,parts)}),flagsToPermissionStringMap:{0:"r",1:"r+",2:"r+",64:"r",65:"r+",66:"r+",129:"rx+",193:"rx+",514:"w+",577:"w",578:"w+",705:"wx",706:"wx+",1024:"a",1025:"a",1026:"a+",1089:"a",1090:"a+",1153:"ax",1154:"ax+",1217:"ax",1218:"ax+",4096:"rs",4098:"rs+"},flagsToPermissionString:(function(flags){flags&=~2097152;flags&=~2048;flags&=~32768;flags&=~524288;if(flags in NODEFS.flagsToPermissionStringMap){return NODEFS.flagsToPermissionStringMap[flags]}else{throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}}),node_ops:{getattr:(function(node){var path=NODEFS.realPath(node);var stat;try{stat=fs.lstatSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}if(NODEFS.isWindows&&!stat.blksize){stat.blksize=4096}if(NODEFS.isWindows&&!stat.blocks){stat.blocks=(stat.size+stat.blksize-1)/stat.blksize|0}return{dev:stat.dev,ino:stat.ino,mode:stat.mode,nlink:stat.nlink,uid:stat.uid,gid:stat.gid,rdev:stat.rdev,size:stat.size,atime:stat.atime,mtime:stat.mtime,ctime:stat.ctime,blksize:stat.blksize,blocks:stat.blocks}}),setattr:(function(node,attr){var path=NODEFS.realPath(node);try{if(attr.mode!==undefined){fs.chmodSync(path,attr.mode);node.mode=attr.mode}if(attr.timestamp!==undefined){var date=new Date(attr.timestamp);fs.utimesSync(path,date,date)}if(attr.size!==undefined){fs.truncateSync(path,attr.size)}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),lookup:(function(parent,name){var path=PATH.join2(NODEFS.realPath(parent),name);var mode=NODEFS.getMode(path);return NODEFS.createNode(parent,name,mode)}),mknod:(function(parent,name,mode,dev){var node=NODEFS.createNode(parent,name,mode,dev);var path=NODEFS.realPath(node);try{if(FS.isDir(node.mode)){fs.mkdirSync(path,node.mode)}else{fs.writeFileSync(path,"",{mode:node.mode})}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}return node}),rename:(function(oldNode,newDir,newName){var oldPath=NODEFS.realPath(oldNode);var newPath=PATH.join2(NODEFS.realPath(newDir),newName);try{fs.renameSync(oldPath,newPath)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),unlink:(function(parent,name){var path=PATH.join2(NODEFS.realPath(parent),name);try{fs.unlinkSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),rmdir:(function(parent,name){var path=PATH.join2(NODEFS.realPath(parent),name);try{fs.rmdirSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),readdir:(function(node){var path=NODEFS.realPath(node);try{return fs.readdirSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),symlink:(function(parent,newName,oldPath){var newPath=PATH.join2(NODEFS.realPath(parent),newName);try{fs.symlinkSync(oldPath,newPath)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),readlink:(function(node){var path=NODEFS.realPath(node);try{path=fs.readlinkSync(path);path=NODEJS_PATH.relative(NODEJS_PATH.resolve(node.mount.opts.root),path);return path}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}})},stream_ops:{open:(function(stream){var path=NODEFS.realPath(stream.node);try{if(FS.isFile(stream.node.mode)){stream.nfd=fs.openSync(path,NODEFS.flagsToPermissionString(stream.flags))}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),close:(function(stream){try{if(FS.isFile(stream.node.mode)&&stream.nfd){fs.closeSync(stream.nfd)}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),read:(function(stream,buffer,offset,length,position){if(length===0)return 0;var nbuffer=new Buffer(length);var res;try{res=fs.readSync(stream.nfd,nbuffer,0,length,position)}catch(e){throw new FS.ErrnoError(ERRNO_CODES[e.code])}if(res>0){for(var i=0;i<res;i++){buffer[offset+i]=nbuffer[i]}}return res}),write:(function(stream,buffer,offset,length,position){var nbuffer=new Buffer(buffer.subarray(offset,offset+length));var res;try{res=fs.writeSync(stream.nfd,nbuffer,0,length,position)}catch(e){throw new FS.ErrnoError(ERRNO_CODES[e.code])}return res}),llseek:(function(stream,offset,whence){var position=offset;if(whence===1){position+=stream.position}else if(whence===2){if(FS.isFile(stream.node.mode)){try{var stat=fs.fstatSync(stream.nfd);position+=stat.size}catch(e){throw new FS.ErrnoError(ERRNO_CODES[e.code])}}}if(position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return position})}};var WORKERFS={DIR_MODE:16895,FILE_MODE:33279,reader:null,mount:(function(mount){assert(ENVIRONMENT_IS_WORKER);if(!WORKERFS.reader)WORKERFS.reader=new FileReaderSync;var root=WORKERFS.createNode(null,"/",WORKERFS.DIR_MODE,0);var createdParents={};function ensureParent(path){var parts=path.split("/");var parent=root;for(var i=0;i<parts.length-1;i++){var curr=parts.slice(0,i+1).join("/");if(!createdParents[curr]){createdParents[curr]=WORKERFS.createNode(parent,parts[i],WORKERFS.DIR_MODE,0)}parent=createdParents[curr]}return parent}function base(path){var parts=path.split("/");return parts[parts.length-1]}Array.prototype.forEach.call(mount.opts["files"]||[],(function(file){WORKERFS.createNode(ensureParent(file.name),base(file.name),WORKERFS.FILE_MODE,0,file,file.lastModifiedDate)}));(mount.opts["blobs"]||[]).forEach((function(obj){WORKERFS.createNode(ensureParent(obj["name"]),base(obj["name"]),WORKERFS.FILE_MODE,0,obj["data"])}));(mount.opts["packages"]||[]).forEach((function(pack){pack["metadata"].files.forEach((function(file){var name=file.filename.substr(1);WORKERFS.createNode(ensureParent(name),base(name),WORKERFS.FILE_MODE,0,pack["blob"].slice(file.start,file.end))}))}));return root}),createNode:(function(parent,name,mode,dev,contents,mtime){var node=FS.createNode(parent,name,mode);node.mode=mode;node.node_ops=WORKERFS.node_ops;node.stream_ops=WORKERFS.stream_ops;node.timestamp=(mtime||new Date).getTime();assert(WORKERFS.FILE_MODE!==WORKERFS.DIR_MODE);if(mode===WORKERFS.FILE_MODE){node.size=contents.size;node.contents=contents}else{node.size=4096;node.contents={}}if(parent){parent.contents[name]=node}return node}),node_ops:{getattr:(function(node){return{dev:1,ino:undefined,mode:node.mode,nlink:1,uid:0,gid:0,rdev:undefined,size:node.size,atime:new Date(node.timestamp),mtime:new Date(node.timestamp),ctime:new Date(node.timestamp),blksize:4096,blocks:Math.ceil(node.size/4096)}}),setattr:(function(node,attr){if(attr.mode!==undefined){node.mode=attr.mode}if(attr.timestamp!==undefined){node.timestamp=attr.timestamp}}),lookup:(function(parent,name){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}),mknod:(function(parent,name,mode,dev){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),rename:(function(oldNode,newDir,newName){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),unlink:(function(parent,name){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),rmdir:(function(parent,name){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),readdir:(function(node){var entries=[".",".."];for(var key in node.contents){if(!node.contents.hasOwnProperty(key)){continue}entries.push(key)}return entries}),symlink:(function(parent,newName,oldPath){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),readlink:(function(node){throw new FS.ErrnoError(ERRNO_CODES.EPERM)})},stream_ops:{read:(function(stream,buffer,offset,length,position){if(position>=stream.node.size)return 0;var chunk=stream.node.contents.slice(position,position+length);var ab=WORKERFS.reader.readAsArrayBuffer(chunk);buffer.set(new Uint8Array(ab),offset);return chunk.size}),write:(function(stream,buffer,offset,length,position){throw new FS.ErrnoError(ERRNO_CODES.EIO)}),llseek:(function(stream,offset,whence){var position=offset;if(whence===1){position+=stream.position}else if(whence===2){if(FS.isFile(stream.node.mode)){position+=stream.node.size}}if(position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return position})}};STATICTOP+=16;STATICTOP+=16;STATICTOP+=16;var FS={root:null,mounts:[],devices:[null],streams:[],nextInode:1,nameTable:null,currentPath:"/",initialized:false,ignorePermissions:true,trackingDelegate:{},tracking:{openFlags:{READ:1,WRITE:2}},ErrnoError:null,genericErrors:{},filesystems:null,syncFSRequests:0,handleFSError:(function(e){if(!(e instanceof FS.ErrnoError))throw e+" : "+stackTrace();return ___setErrNo(e.errno)}),lookupPath:(function(path,opts){path=PATH.resolve(FS.cwd(),path);opts=opts||{};if(!path)return{path:"",node:null};var defaults={follow_mount:true,recurse_count:0};for(var key in defaults){if(opts[key]===undefined){opts[key]=defaults[key]}}if(opts.recurse_count>8){throw new FS.ErrnoError(ERRNO_CODES.ELOOP)}var parts=PATH.normalizeArray(path.split("/").filter((function(p){return!!p})),false);var current=FS.root;var current_path="/";for(var i=0;i<parts.length;i++){var islast=i===parts.length-1;if(islast&&opts.parent){break}current=FS.lookupNode(current,parts[i]);current_path=PATH.join2(current_path,parts[i]);if(FS.isMountpoint(current)){if(!islast||islast&&opts.follow_mount){current=current.mounted.root}}if(!islast||opts.follow){var count=0;while(FS.isLink(current.mode)){var link=FS.readlink(current_path);current_path=PATH.resolve(PATH.dirname(current_path),link);var lookup=FS.lookupPath(current_path,{recurse_count:opts.recurse_count});current=lookup.node;if(count++>40){throw new FS.ErrnoError(ERRNO_CODES.ELOOP)}}}}return{path:current_path,node:current}}),getPath:(function(node){var path;while(true){if(FS.isRoot(node)){var mount=node.mount.mountpoint;if(!path)return mount;return mount[mount.length-1]!=="/"?mount+"/"+path:mount+path}path=path?node.name+"/"+path:node.name;node=node.parent}}),hashName:(function(parentid,name){var hash=0;for(var i=0;i<name.length;i++){hash=(hash<<5)-hash+name.charCodeAt(i)|0}return(parentid+hash>>>0)%FS.nameTable.length}),hashAddNode:(function(node){var hash=FS.hashName(node.parent.id,node.name);node.name_next=FS.nameTable[hash];FS.nameTable[hash]=node}),hashRemoveNode:(function(node){var hash=FS.hashName(node.parent.id,node.name);if(FS.nameTable[hash]===node){FS.nameTable[hash]=node.name_next}else{var current=FS.nameTable[hash];while(current){if(current.name_next===node){current.name_next=node.name_next;break}current=current.name_next}}}),lookupNode:(function(parent,name){var err=FS.mayLookup(parent);if(err){throw new FS.ErrnoError(err,parent)}var hash=FS.hashName(parent.id,name);for(var node=FS.nameTable[hash];node;node=node.name_next){var nodeName=node.name;if(node.parent.id===parent.id&&nodeName===name){return node}}return FS.lookup(parent,name)}),createNode:(function(parent,name,mode,rdev){if(!FS.FSNode){FS.FSNode=(function(parent,name,mode,rdev){if(!parent){parent=this}this.parent=parent;this.mount=parent.mount;this.mounted=null;this.id=FS.nextInode++;this.name=name;this.mode=mode;this.node_ops={};this.stream_ops={};this.rdev=rdev});FS.FSNode.prototype={};var readMode=292|73;var writeMode=146;Object.defineProperties(FS.FSNode.prototype,{read:{get:(function(){return(this.mode&readMode)===readMode}),set:(function(val){val?this.mode|=readMode:this.mode&=~readMode})},write:{get:(function(){return(this.mode&writeMode)===writeMode}),set:(function(val){val?this.mode|=writeMode:this.mode&=~writeMode})},isFolder:{get:(function(){return FS.isDir(this.mode)})},isDevice:{get:(function(){return FS.isChrdev(this.mode)})}})}var node=new FS.FSNode(parent,name,mode,rdev);FS.hashAddNode(node);return node}),destroyNode:(function(node){FS.hashRemoveNode(node)}),isRoot:(function(node){return node===node.parent}),isMountpoint:(function(node){return!!node.mounted}),isFile:(function(mode){return(mode&61440)===32768}),isDir:(function(mode){return(mode&61440)===16384}),isLink:(function(mode){return(mode&61440)===40960}),isChrdev:(function(mode){return(mode&61440)===8192}),isBlkdev:(function(mode){return(mode&61440)===24576}),isFIFO:(function(mode){return(mode&61440)===4096}),isSocket:(function(mode){return(mode&49152)===49152}),flagModes:{"r":0,"rs":1052672,"r+":2,"w":577,"wx":705,"xw":705,"w+":578,"wx+":706,"xw+":706,"a":1089,"ax":1217,"xa":1217,"a+":1090,"ax+":1218,"xa+":1218},modeStringToFlags:(function(str){var flags=FS.flagModes[str];if(typeof flags==="undefined"){throw new Error("Unknown file open mode: "+str)}return flags}),flagsToPermissionString:(function(flag){var perms=["r","w","rw"][flag&3];if(flag&512){perms+="w"}return perms}),nodePermissions:(function(node,perms){if(FS.ignorePermissions){return 0}if(perms.indexOf("r")!==-1&&!(node.mode&292)){return ERRNO_CODES.EACCES}else if(perms.indexOf("w")!==-1&&!(node.mode&146)){return ERRNO_CODES.EACCES}else if(perms.indexOf("x")!==-1&&!(node.mode&73)){return ERRNO_CODES.EACCES}return 0}),mayLookup:(function(dir){var err=FS.nodePermissions(dir,"x");if(err)return err;if(!dir.node_ops.lookup)return ERRNO_CODES.EACCES;return 0}),mayCreate:(function(dir,name){try{var node=FS.lookupNode(dir,name);return ERRNO_CODES.EEXIST}catch(e){}return FS.nodePermissions(dir,"wx")}),mayDelete:(function(dir,name,isdir){var node;try{node=FS.lookupNode(dir,name)}catch(e){return e.errno}var err=FS.nodePermissions(dir,"wx");if(err){return err}if(isdir){if(!FS.isDir(node.mode)){return ERRNO_CODES.ENOTDIR}if(FS.isRoot(node)||FS.getPath(node)===FS.cwd()){return ERRNO_CODES.EBUSY}}else{if(FS.isDir(node.mode)){return ERRNO_CODES.EISDIR}}return 0}),mayOpen:(function(node,flags){if(!node){return ERRNO_CODES.ENOENT}if(FS.isLink(node.mode)){return ERRNO_CODES.ELOOP}else if(FS.isDir(node.mode)){if(FS.flagsToPermissionString(flags)!=="r"||flags&512){return ERRNO_CODES.EISDIR}}return FS.nodePermissions(node,FS.flagsToPermissionString(flags))}),MAX_OPEN_FDS:4096,nextfd:(function(fd_start,fd_end){fd_start=fd_start||0;fd_end=fd_end||FS.MAX_OPEN_FDS;for(var fd=fd_start;fd<=fd_end;fd++){if(!FS.streams[fd]){return fd}}throw new FS.ErrnoError(ERRNO_CODES.EMFILE)}),getStream:(function(fd){return FS.streams[fd]}),createStream:(function(stream,fd_start,fd_end){if(!FS.FSStream){FS.FSStream=(function(){});FS.FSStream.prototype={};Object.defineProperties(FS.FSStream.prototype,{object:{get:(function(){return this.node}),set:(function(val){this.node=val})},isRead:{get:(function(){return(this.flags&2097155)!==1})},isWrite:{get:(function(){return(this.flags&2097155)!==0})},isAppend:{get:(function(){return this.flags&1024})}})}var newStream=new FS.FSStream;for(var p in stream){newStream[p]=stream[p]}stream=newStream;var fd=FS.nextfd(fd_start,fd_end);stream.fd=fd;FS.streams[fd]=stream;return stream}),closeStream:(function(fd){FS.streams[fd]=null}),chrdev_stream_ops:{open:(function(stream){var device=FS.getDevice(stream.node.rdev);stream.stream_ops=device.stream_ops;if(stream.stream_ops.open){stream.stream_ops.open(stream)}}),llseek:(function(){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)})},major:(function(dev){return dev>>8}),minor:(function(dev){return dev&255}),makedev:(function(ma,mi){return ma<<8|mi}),registerDevice:(function(dev,ops){FS.devices[dev]={stream_ops:ops}}),getDevice:(function(dev){return FS.devices[dev]}),getMounts:(function(mount){var mounts=[];var check=[mount];while(check.length){var m=check.pop();mounts.push(m);check.push.apply(check,m.mounts)}return mounts}),syncfs:(function(populate,callback){if(typeof populate==="function"){callback=populate;populate=false}FS.syncFSRequests++;if(FS.syncFSRequests>1){console.log("warning: "+FS.syncFSRequests+" FS.syncfs operations in flight at once, probably just doing extra work")}var mounts=FS.getMounts(FS.root.mount);var completed=0;function doCallback(err){assert(FS.syncFSRequests>0);FS.syncFSRequests--;return callback(err)}function done(err){if(err){if(!done.errored){done.errored=true;return doCallback(err)}return}if(++completed>=mounts.length){doCallback(null)}}mounts.forEach((function(mount){if(!mount.type.syncfs){return done(null)}mount.type.syncfs(mount,populate,done)}))}),mount:(function(type,opts,mountpoint){var root=mountpoint==="/";var pseudo=!mountpoint;var node;if(root&&FS.root){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}else if(!root&&!pseudo){var lookup=FS.lookupPath(mountpoint,{follow_mount:false});mountpoint=lookup.path;node=lookup.node;if(FS.isMountpoint(node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}if(!FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}}var mount={type:type,opts:opts,mountpoint:mountpoint,mounts:[]};var mountRoot=type.mount(mount);mountRoot.mount=mount;mount.root=mountRoot;if(root){FS.root=mountRoot}else if(node){node.mounted=mount;if(node.mount){node.mount.mounts.push(mount)}}return mountRoot}),unmount:(function(mountpoint){var lookup=FS.lookupPath(mountpoint,{follow_mount:false});if(!FS.isMountpoint(lookup.node)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var node=lookup.node;var mount=node.mounted;var mounts=FS.getMounts(mount);Object.keys(FS.nameTable).forEach((function(hash){var current=FS.nameTable[hash];while(current){var next=current.name_next;if(mounts.indexOf(current.mount)!==-1){FS.destroyNode(current)}current=next}}));node.mounted=null;var idx=node.mount.mounts.indexOf(mount);assert(idx!==-1);node.mount.mounts.splice(idx,1)}),lookup:(function(parent,name){return parent.node_ops.lookup(parent,name)}),mknod:(function(path,mode,dev){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);if(!name||name==="."||name===".."){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var err=FS.mayCreate(parent,name);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.mknod){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}return parent.node_ops.mknod(parent,name,mode,dev)}),create:(function(path,mode){mode=mode!==undefined?mode:438;mode&=4095;mode|=32768;return FS.mknod(path,mode,0)}),mkdir:(function(path,mode){mode=mode!==undefined?mode:511;mode&=511|512;mode|=16384;return FS.mknod(path,mode,0)}),mkdirTree:(function(path,mode){var dirs=path.split("/");var d="";for(var i=0;i<dirs.length;++i){if(!dirs[i])continue;d+="/"+dirs[i];try{FS.mkdir(d,mode)}catch(e){if(e.errno!=ERRNO_CODES.EEXIST)throw e}}}),mkdev:(function(path,mode,dev){if(typeof dev==="undefined"){dev=mode;mode=438}mode|=8192;return FS.mknod(path,mode,dev)}),symlink:(function(oldpath,newpath){if(!PATH.resolve(oldpath)){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}var lookup=FS.lookupPath(newpath,{parent:true});var parent=lookup.node;if(!parent){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}var newname=PATH.basename(newpath);var err=FS.mayCreate(parent,newname);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.symlink){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}return parent.node_ops.symlink(parent,newname,oldpath)}),rename:(function(old_path,new_path){var old_dirname=PATH.dirname(old_path);var new_dirname=PATH.dirname(new_path);var old_name=PATH.basename(old_path);var new_name=PATH.basename(new_path);var lookup,old_dir,new_dir;try{lookup=FS.lookupPath(old_path,{parent:true});old_dir=lookup.node;lookup=FS.lookupPath(new_path,{parent:true});new_dir=lookup.node}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}if(!old_dir||!new_dir)throw new FS.ErrnoError(ERRNO_CODES.ENOENT);if(old_dir.mount!==new_dir.mount){throw new FS.ErrnoError(ERRNO_CODES.EXDEV)}var old_node=FS.lookupNode(old_dir,old_name);var relative=PATH.relative(old_path,new_dirname);if(relative.charAt(0)!=="."){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}relative=PATH.relative(new_path,old_dirname);if(relative.charAt(0)!=="."){throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)}var new_node;try{new_node=FS.lookupNode(new_dir,new_name)}catch(e){}if(old_node===new_node){return}var isdir=FS.isDir(old_node.mode);var err=FS.mayDelete(old_dir,old_name,isdir);if(err){throw new FS.ErrnoError(err)}err=new_node?FS.mayDelete(new_dir,new_name,isdir):FS.mayCreate(new_dir,new_name);if(err){throw new FS.ErrnoError(err)}if(!old_dir.node_ops.rename){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isMountpoint(old_node)||new_node&&FS.isMountpoint(new_node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}if(new_dir!==old_dir){err=FS.nodePermissions(old_dir,"w");if(err){throw new FS.ErrnoError(err)}}try{if(FS.trackingDelegate["willMovePath"]){FS.trackingDelegate["willMovePath"](old_path,new_path)}}catch(e){console.log("FS.trackingDelegate['willMovePath']('"+old_path+"', '"+new_path+"') threw an exception: "+e.message)}FS.hashRemoveNode(old_node);try{old_dir.node_ops.rename(old_node,new_dir,new_name)}catch(e){throw e}finally{FS.hashAddNode(old_node)}try{if(FS.trackingDelegate["onMovePath"])FS.trackingDelegate["onMovePath"](old_path,new_path)}catch(e){console.log("FS.trackingDelegate['onMovePath']('"+old_path+"', '"+new_path+"') threw an exception: "+e.message)}}),rmdir:(function(path){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);var node=FS.lookupNode(parent,name);var err=FS.mayDelete(parent,name,true);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.rmdir){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isMountpoint(node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}try{if(FS.trackingDelegate["willDeletePath"]){FS.trackingDelegate["willDeletePath"](path)}}catch(e){console.log("FS.trackingDelegate['willDeletePath']('"+path+"') threw an exception: "+e.message)}parent.node_ops.rmdir(parent,name);FS.destroyNode(node);try{if(FS.trackingDelegate["onDeletePath"])FS.trackingDelegate["onDeletePath"](path)}catch(e){console.log("FS.trackingDelegate['onDeletePath']('"+path+"') threw an exception: "+e.message)}}),readdir:(function(path){var lookup=FS.lookupPath(path,{follow:true});var node=lookup.node;if(!node.node_ops.readdir){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}return node.node_ops.readdir(node)}),unlink:(function(path){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);var node=FS.lookupNode(parent,name);var err=FS.mayDelete(parent,name,false);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.unlink){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isMountpoint(node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}try{if(FS.trackingDelegate["willDeletePath"]){FS.trackingDelegate["willDeletePath"](path)}}catch(e){console.log("FS.trackingDelegate['willDeletePath']('"+path+"') threw an exception: "+e.message)}parent.node_ops.unlink(parent,name);FS.destroyNode(node);try{if(FS.trackingDelegate["onDeletePath"])FS.trackingDelegate["onDeletePath"](path)}catch(e){console.log("FS.trackingDelegate['onDeletePath']('"+path+"') threw an exception: "+e.message)}}),readlink:(function(path){var lookup=FS.lookupPath(path);var link=lookup.node;if(!link){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}if(!link.node_ops.readlink){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return PATH.resolve(FS.getPath(link.parent),link.node_ops.readlink(link))}),stat:(function(path,dontFollow){var lookup=FS.lookupPath(path,{follow:!dontFollow});var node=lookup.node;if(!node){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}if(!node.node_ops.getattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}return node.node_ops.getattr(node)}),lstat:(function(path){return FS.stat(path,true)}),chmod:(function(path,mode,dontFollow){var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:!dontFollow});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}node.node_ops.setattr(node,{mode:mode&4095|node.mode&~4095,timestamp:Date.now()})}),lchmod:(function(path,mode){FS.chmod(path,mode,true)}),fchmod:(function(fd,mode){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}FS.chmod(stream.node,mode)}),chown:(function(path,uid,gid,dontFollow){var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:!dontFollow});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}node.node_ops.setattr(node,{timestamp:Date.now()})}),lchown:(function(path,uid,gid){FS.chown(path,uid,gid,true)}),fchown:(function(fd,uid,gid){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}FS.chown(stream.node,uid,gid)}),truncate:(function(path,len){if(len<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:true});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EISDIR)}if(!FS.isFile(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var err=FS.nodePermissions(node,"w");if(err){throw new FS.ErrnoError(err)}node.node_ops.setattr(node,{size:len,timestamp:Date.now()})}),ftruncate:(function(fd,len){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}FS.truncate(stream.node,len)}),utime:(function(path,atime,mtime){var lookup=FS.lookupPath(path,{follow:true});var node=lookup.node;node.node_ops.setattr(node,{timestamp:Math.max(atime,mtime)})}),open:(function(path,flags,mode,fd_start,fd_end){if(path===""){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}flags=typeof flags==="string"?FS.modeStringToFlags(flags):flags;mode=typeof mode==="undefined"?438:mode;if(flags&64){mode=mode&4095|32768}else{mode=0}var node;if(typeof path==="object"){node=path}else{path=PATH.normalize(path);try{var lookup=FS.lookupPath(path,{follow:!(flags&131072)});node=lookup.node}catch(e){}}var created=false;if(flags&64){if(node){if(flags&128){throw new FS.ErrnoError(ERRNO_CODES.EEXIST)}}else{node=FS.mknod(path,mode,0);created=true}}if(!node){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}if(FS.isChrdev(node.mode)){flags&=~512}if(flags&65536&&!FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}if(!created){var err=FS.mayOpen(node,flags);if(err){throw new FS.ErrnoError(err)}}if(flags&512){FS.truncate(node,0)}flags&=~(128|512);var stream=FS.createStream({node:node,path:FS.getPath(node),flags:flags,seekable:true,position:0,stream_ops:node.stream_ops,ungotten:[],error:false},fd_start,fd_end);if(stream.stream_ops.open){stream.stream_ops.open(stream)}if(Module["logReadFiles"]&&!(flags&1)){if(!FS.readFiles)FS.readFiles={};if(!(path in FS.readFiles)){FS.readFiles[path]=1;Module["printErr"]("read file: "+path)}}try{if(FS.trackingDelegate["onOpenFile"]){var trackingFlags=0;if((flags&2097155)!==1){trackingFlags|=FS.tracking.openFlags.READ}if((flags&2097155)!==0){trackingFlags|=FS.tracking.openFlags.WRITE}FS.trackingDelegate["onOpenFile"](path,trackingFlags)}}catch(e){console.log("FS.trackingDelegate['onOpenFile']('"+path+"', flags) threw an exception: "+e.message)}return stream}),close:(function(stream){if(stream.getdents)stream.getdents=null;try{if(stream.stream_ops.close){stream.stream_ops.close(stream)}}catch(e){throw e}finally{FS.closeStream(stream.fd)}}),llseek:(function(stream,offset,whence){if(!stream.seekable||!stream.stream_ops.llseek){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)}stream.position=stream.stream_ops.llseek(stream,offset,whence);stream.ungotten=[];return stream.position}),read:(function(stream,buffer,offset,length,position){if(length<0||position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if((stream.flags&2097155)===1){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(FS.isDir(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EISDIR)}if(!stream.stream_ops.read){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var seeking=true;if(typeof position==="undefined"){position=stream.position;seeking=false}else if(!stream.seekable){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)}var bytesRead=stream.stream_ops.read(stream,buffer,offset,length,position);if(!seeking)stream.position+=bytesRead;return bytesRead}),write:(function(stream,buffer,offset,length,position,canOwn){if(length<0||position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(FS.isDir(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EISDIR)}if(!stream.stream_ops.write){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if(stream.flags&1024){FS.llseek(stream,0,2)}var seeking=true;if(typeof position==="undefined"){position=stream.position;seeking=false}else if(!stream.seekable){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)}var bytesWritten=stream.stream_ops.write(stream,buffer,offset,length,position,canOwn);if(!seeking)stream.position+=bytesWritten;try{if(stream.path&&FS.trackingDelegate["onWriteToFile"])FS.trackingDelegate["onWriteToFile"](stream.path)}catch(e){console.log("FS.trackingDelegate['onWriteToFile']('"+path+"') threw an exception: "+e.message)}return bytesWritten}),allocate:(function(stream,offset,length){if(offset<0||length<=0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(!FS.isFile(stream.node.mode)&&!FS.isDir(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}if(!stream.stream_ops.allocate){throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP)}stream.stream_ops.allocate(stream,offset,length)}),mmap:(function(stream,buffer,offset,length,position,prot,flags){if((stream.flags&2097155)===1){throw new FS.ErrnoError(ERRNO_CODES.EACCES)}if(!stream.stream_ops.mmap){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}return stream.stream_ops.mmap(stream,buffer,offset,length,position,prot,flags)}),msync:(function(stream,buffer,offset,length,mmapFlags){if(!stream||!stream.stream_ops.msync){return 0}return stream.stream_ops.msync(stream,buffer,offset,length,mmapFlags)}),munmap:(function(stream){return 0}),ioctl:(function(stream,cmd,arg){if(!stream.stream_ops.ioctl){throw new FS.ErrnoError(ERRNO_CODES.ENOTTY)}return stream.stream_ops.ioctl(stream,cmd,arg)}),readFile:(function(path,opts){opts=opts||{};opts.flags=opts.flags||"r";opts.encoding=opts.encoding||"binary";if(opts.encoding!=="utf8"&&opts.encoding!=="binary"){throw new Error('Invalid encoding type "'+opts.encoding+'"')}var ret;var stream=FS.open(path,opts.flags);var stat=FS.stat(path);var length=stat.size;var buf=new Uint8Array(length);FS.read(stream,buf,0,length,0);if(opts.encoding==="utf8"){ret=UTF8ArrayToString(buf,0)}else if(opts.encoding==="binary"){ret=buf}FS.close(stream);return ret}),writeFile:(function(path,data,opts){opts=opts||{};opts.flags=opts.flags||"w";opts.encoding=opts.encoding||"utf8";if(opts.encoding!=="utf8"&&opts.encoding!=="binary"){throw new Error('Invalid encoding type "'+opts.encoding+'"')}var stream=FS.open(path,opts.flags,opts.mode);if(opts.encoding==="utf8"){var buf=new Uint8Array(lengthBytesUTF8(data)+1);var actualNumBytes=stringToUTF8Array(data,buf,0,buf.length);FS.write(stream,buf,0,actualNumBytes,0,opts.canOwn)}else if(opts.encoding==="binary"){FS.write(stream,data,0,data.length,0,opts.canOwn)}FS.close(stream)}),cwd:(function(){return FS.currentPath}),chdir:(function(path){var lookup=FS.lookupPath(path,{follow:true});if(lookup.node===null){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}if(!FS.isDir(lookup.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}var err=FS.nodePermissions(lookup.node,"x");if(err){throw new FS.ErrnoError(err)}FS.currentPath=lookup.path}),createDefaultDirectories:(function(){FS.mkdir("/tmp");FS.mkdir("/home");FS.mkdir("/home/web_user")}),createDefaultDevices:(function(){FS.mkdir("/dev");FS.registerDevice(FS.makedev(1,3),{read:(function(){return 0}),write:(function(stream,buffer,offset,length,pos){return length})});FS.mkdev("/dev/null",FS.makedev(1,3));TTY.register(FS.makedev(5,0),TTY.default_tty_ops);TTY.register(FS.makedev(6,0),TTY.default_tty1_ops);FS.mkdev("/dev/tty",FS.makedev(5,0));FS.mkdev("/dev/tty1",FS.makedev(6,0));var random_device;if(typeof crypto!=="undefined"){var randomBuffer=new Uint8Array(1);random_device=(function(){crypto.getRandomValues(randomBuffer);return randomBuffer[0]})}else if(ENVIRONMENT_IS_NODE){random_device=(function(){return __webpack_require__(/*! crypto */ "crypto").randomBytes(1)[0]})}else{random_device=(function(){return Math.random()*256|0})}FS.createDevice("/dev","random",random_device);FS.createDevice("/dev","urandom",random_device);FS.mkdir("/dev/shm");FS.mkdir("/dev/shm/tmp")}),createSpecialDirectories:(function(){FS.mkdir("/proc");FS.mkdir("/proc/self");FS.mkdir("/proc/self/fd");FS.mount({mount:(function(){var node=FS.createNode("/proc/self","fd",16384|511,73);node.node_ops={lookup:(function(parent,name){var fd=+name;var stream=FS.getStream(fd);if(!stream)throw new FS.ErrnoError(ERRNO_CODES.EBADF);var ret={parent:null,mount:{mountpoint:"fake"},node_ops:{readlink:(function(){return stream.path})}};ret.parent=ret;return ret})};return node})},{},"/proc/self/fd")}),createStandardStreams:(function(){if(Module["stdin"]){FS.createDevice("/dev","stdin",Module["stdin"])}else{FS.symlink("/dev/tty","/dev/stdin")}if(Module["stdout"]){FS.createDevice("/dev","stdout",null,Module["stdout"])}else{FS.symlink("/dev/tty","/dev/stdout")}if(Module["stderr"]){FS.createDevice("/dev","stderr",null,Module["stderr"])}else{FS.symlink("/dev/tty1","/dev/stderr")}var stdin=FS.open("/dev/stdin","r");assert(stdin.fd===0,"invalid handle for stdin ("+stdin.fd+")");var stdout=FS.open("/dev/stdout","w");assert(stdout.fd===1,"invalid handle for stdout ("+stdout.fd+")");var stderr=FS.open("/dev/stderr","w");assert(stderr.fd===2,"invalid handle for stderr ("+stderr.fd+")")}),ensureErrnoError:(function(){if(FS.ErrnoError)return;FS.ErrnoError=function ErrnoError(errno,node){this.node=node;this.setErrno=(function(errno){this.errno=errno;for(var key in ERRNO_CODES){if(ERRNO_CODES[key]===errno){this.code=key;break}}});this.setErrno(errno);this.message=ERRNO_MESSAGES[errno];if(this.stack)Object.defineProperty(this,"stack",{value:(new Error).stack})};FS.ErrnoError.prototype=new Error;FS.ErrnoError.prototype.constructor=FS.ErrnoError;[ERRNO_CODES.ENOENT].forEach((function(code){FS.genericErrors[code]=new FS.ErrnoError(code);FS.genericErrors[code].stack="<generic error, no stack>"}))}),staticInit:(function(){FS.ensureErrnoError();FS.nameTable=new Array(4096);FS.mount(MEMFS,{},"/");FS.createDefaultDirectories();FS.createDefaultDevices();FS.createSpecialDirectories();FS.filesystems={"MEMFS":MEMFS,"IDBFS":IDBFS,"NODEFS":NODEFS,"WORKERFS":WORKERFS}}),init:(function(input,output,error){assert(!FS.init.initialized,"FS.init was previously called. If you want to initialize later with custom parameters, remove any earlier calls (note that one is automatically added to the generated code)");FS.init.initialized=true;FS.ensureErrnoError();Module["stdin"]=input||Module["stdin"];Module["stdout"]=output||Module["stdout"];Module["stderr"]=error||Module["stderr"];FS.createStandardStreams()}),quit:(function(){FS.init.initialized=false;var fflush=Module["_fflush"];if(fflush)fflush(0);for(var i=0;i<FS.streams.length;i++){var stream=FS.streams[i];if(!stream){continue}FS.close(stream)}}),getMode:(function(canRead,canWrite){var mode=0;if(canRead)mode|=292|73;if(canWrite)mode|=146;return mode}),joinPath:(function(parts,forceRelative){var path=PATH.join.apply(null,parts);if(forceRelative&&path[0]=="/")path=path.substr(1);return path}),absolutePath:(function(relative,base){return PATH.resolve(base,relative)}),standardizePath:(function(path){return PATH.normalize(path)}),findObject:(function(path,dontResolveLastLink){var ret=FS.analyzePath(path,dontResolveLastLink);if(ret.exists){return ret.object}else{___setErrNo(ret.error);return null}}),analyzePath:(function(path,dontResolveLastLink){try{var lookup=FS.lookupPath(path,{follow:!dontResolveLastLink});path=lookup.path}catch(e){}var ret={isRoot:false,exists:false,error:0,name:null,path:null,object:null,parentExists:false,parentPath:null,parentObject:null};try{var lookup=FS.lookupPath(path,{parent:true});ret.parentExists=true;ret.parentPath=lookup.path;ret.parentObject=lookup.node;ret.name=PATH.basename(path);lookup=FS.lookupPath(path,{follow:!dontResolveLastLink});ret.exists=true;ret.path=lookup.path;ret.object=lookup.node;ret.name=lookup.node.name;ret.isRoot=lookup.path==="/"}catch(e){ret.error=e.errno}return ret}),createFolder:(function(parent,name,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(canRead,canWrite);return FS.mkdir(path,mode)}),createPath:(function(parent,path,canRead,canWrite){parent=typeof parent==="string"?parent:FS.getPath(parent);var parts=path.split("/").reverse();while(parts.length){var part=parts.pop();if(!part)continue;var current=PATH.join2(parent,part);try{FS.mkdir(current)}catch(e){}parent=current}return current}),createFile:(function(parent,name,properties,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(canRead,canWrite);return FS.create(path,mode)}),createDataFile:(function(parent,name,data,canRead,canWrite,canOwn){var path=name?PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name):parent;var mode=FS.getMode(canRead,canWrite);var node=FS.create(path,mode);if(data){if(typeof data==="string"){var arr=new Array(data.length);for(var i=0,len=data.length;i<len;++i)arr[i]=data.charCodeAt(i);data=arr}FS.chmod(node,mode|146);var stream=FS.open(node,"w");FS.write(stream,data,0,data.length,0,canOwn);FS.close(stream);FS.chmod(node,mode)}return node}),createDevice:(function(parent,name,input,output){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(!!input,!!output);if(!FS.createDevice.major)FS.createDevice.major=64;var dev=FS.makedev(FS.createDevice.major++,0);FS.registerDevice(dev,{open:(function(stream){stream.seekable=false}),close:(function(stream){if(output&&output.buffer&&output.buffer.length){output(10)}}),read:(function(stream,buffer,offset,length,pos){var bytesRead=0;for(var i=0;i<length;i++){var result;try{result=input()}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}if(result===undefined&&bytesRead===0){throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}if(result===null||result===undefined)break;bytesRead++;buffer[offset+i]=result}if(bytesRead){stream.node.timestamp=Date.now()}return bytesRead}),write:(function(stream,buffer,offset,length,pos){for(var i=0;i<length;i++){try{output(buffer[offset+i])}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}}if(length){stream.node.timestamp=Date.now()}return i})});return FS.mkdev(path,mode,dev)}),createLink:(function(parent,name,target,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);return FS.symlink(target,path)}),forceLoadFile:(function(obj){if(obj.isDevice||obj.isFolder||obj.link||obj.contents)return true;var success=true;if(typeof XMLHttpRequest!=="undefined"){throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.")}else if(Module["read"]){try{obj.contents=intArrayFromString(Module["read"](obj.url),true);obj.usedBytes=obj.contents.length}catch(e){success=false}}else{throw new Error("Cannot load without read() or XMLHttpRequest.")}if(!success)___setErrNo(ERRNO_CODES.EIO);return success}),createLazyFile:(function(parent,name,url,canRead,canWrite){function LazyUint8Array(){this.lengthKnown=false;this.chunks=[]}LazyUint8Array.prototype.get=function LazyUint8Array_get(idx){if(idx>this.length-1||idx<0){return undefined}var chunkOffset=idx%this.chunkSize;var chunkNum=idx/this.chunkSize|0;return this.getter(chunkNum)[chunkOffset]};LazyUint8Array.prototype.setDataGetter=function LazyUint8Array_setDataGetter(getter){this.getter=getter};LazyUint8Array.prototype.cacheLength=function LazyUint8Array_cacheLength(){var xhr=new XMLHttpRequest;xhr.open("HEAD",url,false);xhr.send(null);if(!(xhr.status>=200&&xhr.status<300||xhr.status===304))throw new Error("Couldn't load "+url+". Status: "+xhr.status);var datalength=Number(xhr.getResponseHeader("Content-length"));var header;var hasByteServing=(header=xhr.getResponseHeader("Accept-Ranges"))&&header==="bytes";var usesGzip=(header=xhr.getResponseHeader("Content-Encoding"))&&header==="gzip";var chunkSize=1024*1024;if(!hasByteServing)chunkSize=datalength;var doXHR=(function(from,to){if(from>to)throw new Error("invalid range ("+from+", "+to+") or no bytes requested!");if(to>datalength-1)throw new Error("only "+datalength+" bytes available! programmer error!");var xhr=new XMLHttpRequest;xhr.open("GET",url,false);if(datalength!==chunkSize)xhr.setRequestHeader("Range","bytes="+from+"-"+to);if(typeof Uint8Array!="undefined")xhr.responseType="arraybuffer";if(xhr.overrideMimeType){xhr.overrideMimeType("text/plain; charset=x-user-defined")}xhr.send(null);if(!(xhr.status>=200&&xhr.status<300||xhr.status===304))throw new Error("Couldn't load "+url+". Status: "+xhr.status);if(xhr.response!==undefined){return new Uint8Array(xhr.response||[])}else{return intArrayFromString(xhr.responseText||"",true)}});var lazyArray=this;lazyArray.setDataGetter((function(chunkNum){var start=chunkNum*chunkSize;var end=(chunkNum+1)*chunkSize-1;end=Math.min(end,datalength-1);if(typeof lazyArray.chunks[chunkNum]==="undefined"){lazyArray.chunks[chunkNum]=doXHR(start,end)}if(typeof lazyArray.chunks[chunkNum]==="undefined")throw new Error("doXHR failed!");return lazyArray.chunks[chunkNum]}));if(usesGzip||!datalength){chunkSize=datalength=1;datalength=this.getter(0).length;chunkSize=datalength;console.log("LazyFiles on gzip forces download of the whole file when length is accessed")}this._length=datalength;this._chunkSize=chunkSize;this.lengthKnown=true};if(typeof XMLHttpRequest!=="undefined"){if(!ENVIRONMENT_IS_WORKER)throw"Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc";var lazyArray=new LazyUint8Array;Object.defineProperties(lazyArray,{length:{get:(function(){if(!this.lengthKnown){this.cacheLength()}return this._length})},chunkSize:{get:(function(){if(!this.lengthKnown){this.cacheLength()}return this._chunkSize})}});var properties={isDevice:false,contents:lazyArray}}else{var properties={isDevice:false,url:url}}var node=FS.createFile(parent,name,properties,canRead,canWrite);if(properties.contents){node.contents=properties.contents}else if(properties.url){node.contents=null;node.url=properties.url}Object.defineProperties(node,{usedBytes:{get:(function(){return this.contents.length})}});var stream_ops={};var keys=Object.keys(node.stream_ops);keys.forEach((function(key){var fn=node.stream_ops[key];stream_ops[key]=function forceLoadLazyFile(){if(!FS.forceLoadFile(node)){throw new FS.ErrnoError(ERRNO_CODES.EIO)}return fn.apply(null,arguments)}}));stream_ops.read=function stream_ops_read(stream,buffer,offset,length,position){if(!FS.forceLoadFile(node)){throw new FS.ErrnoError(ERRNO_CODES.EIO)}var contents=stream.node.contents;if(position>=contents.length)return 0;var size=Math.min(contents.length-position,length);assert(size>=0);if(contents.slice){for(var i=0;i<size;i++){buffer[offset+i]=contents[position+i]}}else{for(var i=0;i<size;i++){buffer[offset+i]=contents.get(position+i)}}return size};node.stream_ops=stream_ops;return node}),createPreloadedFile:(function(parent,name,url,canRead,canWrite,onload,onerror,dontCreateFile,canOwn,preFinish){Browser.init();var fullname=name?PATH.resolve(PATH.join2(parent,name)):parent;var dep=getUniqueRunDependency("cp "+fullname);function processData(byteArray){function finish(byteArray){if(preFinish)preFinish();if(!dontCreateFile){FS.createDataFile(parent,name,byteArray,canRead,canWrite,canOwn)}if(onload)onload();removeRunDependency(dep)}var handled=false;Module["preloadPlugins"].forEach((function(plugin){if(handled)return;if(plugin["canHandle"](fullname)){plugin["handle"](byteArray,fullname,finish,(function(){if(onerror)onerror();removeRunDependency(dep)}));handled=true}}));if(!handled)finish(byteArray)}addRunDependency(dep);if(typeof url=="string"){Browser.asyncLoad(url,(function(byteArray){processData(byteArray)}),onerror)}else{processData(url)}}),indexedDB:(function(){return window.indexedDB||window.mozIndexedDB||window.webkitIndexedDB||window.msIndexedDB}),DB_NAME:(function(){return"EM_FS_"+window.location.pathname}),DB_VERSION:20,DB_STORE_NAME:"FILE_DATA",saveFilesToDB:(function(paths,onload,onerror){onload=onload||(function(){});onerror=onerror||(function(){});var indexedDB=FS.indexedDB();try{var openRequest=indexedDB.open(FS.DB_NAME(),FS.DB_VERSION)}catch(e){return onerror(e)}openRequest.onupgradeneeded=function openRequest_onupgradeneeded(){console.log("creating db");var db=openRequest.result;db.createObjectStore(FS.DB_STORE_NAME)};openRequest.onsuccess=function openRequest_onsuccess(){var db=openRequest.result;var transaction=db.transaction([FS.DB_STORE_NAME],"readwrite");var files=transaction.objectStore(FS.DB_STORE_NAME);var ok=0,fail=0,total=paths.length;function finish(){if(fail==0)onload();else onerror()}paths.forEach((function(path){var putRequest=files.put(FS.analyzePath(path).object.contents,path);putRequest.onsuccess=function putRequest_onsuccess(){ok++;if(ok+fail==total)finish()};putRequest.onerror=function putRequest_onerror(){fail++;if(ok+fail==total)finish()}}));transaction.onerror=onerror};openRequest.onerror=onerror}),loadFilesFromDB:(function(paths,onload,onerror){onload=onload||(function(){});onerror=onerror||(function(){});var indexedDB=FS.indexedDB();try{var openRequest=indexedDB.open(FS.DB_NAME(),FS.DB_VERSION)}catch(e){return onerror(e)}openRequest.onupgradeneeded=onerror;openRequest.onsuccess=function openRequest_onsuccess(){var db=openRequest.result;try{var transaction=db.transaction([FS.DB_STORE_NAME],"readonly")}catch(e){onerror(e);return}var files=transaction.objectStore(FS.DB_STORE_NAME);var ok=0,fail=0,total=paths.length;function finish(){if(fail==0)onload();else onerror()}paths.forEach((function(path){var getRequest=files.get(path);getRequest.onsuccess=function getRequest_onsuccess(){if(FS.analyzePath(path).exists){FS.unlink(path)}FS.createDataFile(PATH.dirname(path),PATH.basename(path),getRequest.result,true,true,true);ok++;if(ok+fail==total)finish()};getRequest.onerror=function getRequest_onerror(){fail++;if(ok+fail==total)finish()}}));transaction.onerror=onerror};openRequest.onerror=onerror})};var SYSCALLS={DEFAULT_POLLMASK:5,mappings:{},umask:511,calculateAt:(function(dirfd,path){if(path[0]!=="/"){var dir;if(dirfd===-100){dir=FS.cwd()}else{var dirstream=FS.getStream(dirfd);if(!dirstream)throw new FS.ErrnoError(ERRNO_CODES.EBADF);dir=dirstream.path}path=PATH.join2(dir,path)}return path}),doStat:(function(func,path,buf){try{var stat=func(path)}catch(e){if(e&&e.node&&PATH.normalize(path)!==PATH.normalize(FS.getPath(e.node))){return-ERRNO_CODES.ENOTDIR}throw e}HEAP32[buf>>2]=stat.dev;HEAP32[buf+4>>2]=0;HEAP32[buf+8>>2]=stat.ino;HEAP32[buf+12>>2]=stat.mode;HEAP32[buf+16>>2]=stat.nlink;HEAP32[buf+20>>2]=stat.uid;HEAP32[buf+24>>2]=stat.gid;HEAP32[buf+28>>2]=stat.rdev;HEAP32[buf+32>>2]=0;HEAP32[buf+36>>2]=stat.size;HEAP32[buf+40>>2]=4096;HEAP32[buf+44>>2]=stat.blocks;HEAP32[buf+48>>2]=stat.atime.getTime()/1e3|0;HEAP32[buf+52>>2]=0;HEAP32[buf+56>>2]=stat.mtime.getTime()/1e3|0;HEAP32[buf+60>>2]=0;HEAP32[buf+64>>2]=stat.ctime.getTime()/1e3|0;HEAP32[buf+68>>2]=0;HEAP32[buf+72>>2]=stat.ino;return 0}),doMsync:(function(addr,stream,len,flags){var buffer=new Uint8Array(HEAPU8.subarray(addr,addr+len));FS.msync(stream,buffer,0,len,flags)}),doMkdir:(function(path,mode){path=PATH.normalize(path);if(path[path.length-1]==="/")path=path.substr(0,path.length-1);FS.mkdir(path,mode,0);return 0}),doMknod:(function(path,mode,dev){switch(mode&61440){case 32768:case 8192:case 24576:case 4096:case 49152:break;default:return-ERRNO_CODES.EINVAL}FS.mknod(path,mode,dev);return 0}),doReadlink:(function(path,buf,bufsize){if(bufsize<=0)return-ERRNO_CODES.EINVAL;var ret=FS.readlink(path);var len=Math.min(bufsize,lengthBytesUTF8(ret));var endChar=HEAP8[buf+len];stringToUTF8(ret,buf,bufsize+1);HEAP8[buf+len]=endChar;return len}),doAccess:(function(path,amode){if(amode&~7){return-ERRNO_CODES.EINVAL}var node;var lookup=FS.lookupPath(path,{follow:true});node=lookup.node;var perms="";if(amode&4)perms+="r";if(amode&2)perms+="w";if(amode&1)perms+="x";if(perms&&FS.nodePermissions(node,perms)){return-ERRNO_CODES.EACCES}return 0}),doDup:(function(path,flags,suggestFD){var suggest=FS.getStream(suggestFD);if(suggest)FS.close(suggest);return FS.open(path,flags,0,suggestFD,suggestFD).fd}),doReadv:(function(stream,iov,iovcnt,offset){var ret=0;for(var i=0;i<iovcnt;i++){var ptr=HEAP32[iov+i*8>>2];var len=HEAP32[iov+(i*8+4)>>2];var curr=FS.read(stream,HEAP8,ptr,len,offset);if(curr<0)return-1;ret+=curr;if(curr<len)break}return ret}),doWritev:(function(stream,iov,iovcnt,offset){var ret=0;for(var i=0;i<iovcnt;i++){var ptr=HEAP32[iov+i*8>>2];var len=HEAP32[iov+(i*8+4)>>2];var curr=FS.write(stream,HEAP8,ptr,len,offset);if(curr<0)return-1;ret+=curr}return ret}),varargs:0,get:(function(varargs){SYSCALLS.varargs+=4;var ret=HEAP32[SYSCALLS.varargs-4>>2];return ret}),getStr:(function(){var ret=Pointer_stringify(SYSCALLS.get());return ret}),getStreamFromFD:(function(){var stream=FS.getStream(SYSCALLS.get());if(!stream)throw new FS.ErrnoError(ERRNO_CODES.EBADF);return stream}),getSocketFromFD:(function(){var socket=SOCKFS.getSocket(SYSCALLS.get());if(!socket)throw new FS.ErrnoError(ERRNO_CODES.EBADF);return socket}),getSocketAddress:(function(allowNull){var addrp=SYSCALLS.get(),addrlen=SYSCALLS.get();if(allowNull&&addrp===0)return null;var info=__read_sockaddr(addrp,addrlen);if(info.errno)throw new FS.ErrnoError(info.errno);info.addr=DNS.lookup_addr(info.addr)||info.addr;return info}),get64:(function(){var low=SYSCALLS.get(),high=SYSCALLS.get();if(low>=0)assert(high===0);else assert(high===-1);return low}),getZero:(function(){assert(SYSCALLS.get()===0)})};function ___syscall140(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),offset_high=SYSCALLS.get(),offset_low=SYSCALLS.get(),result=SYSCALLS.get(),whence=SYSCALLS.get();var offset=offset_low;FS.llseek(stream,offset,whence);HEAP32[result>>2]=stream.position;if(stream.getdents&&offset===0&&whence===0)stream.getdents=null;return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall145(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),iov=SYSCALLS.get(),iovcnt=SYSCALLS.get();return SYSCALLS.doReadv(stream,iov,iovcnt)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall146(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),iov=SYSCALLS.get(),iovcnt=SYSCALLS.get();return SYSCALLS.doWritev(stream,iov,iovcnt)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall54(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),op=SYSCALLS.get();switch(op){case 21505:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;return 0};case 21506:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;return 0};case 21519:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;var argp=SYSCALLS.get();HEAP32[argp>>2]=0;return 0};case 21520:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;return-ERRNO_CODES.EINVAL};case 21531:{var argp=SYSCALLS.get();return FS.ioctl(stream,op,argp)};case 21523:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;return 0};default:abort("bad ioctl syscall "+op)}}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall6(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD();FS.close(stream);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall91(which,varargs){SYSCALLS.varargs=varargs;try{var addr=SYSCALLS.get(),len=SYSCALLS.get();var info=SYSCALLS.mappings[addr];if(!info)return 0;if(len===info.len){var stream=FS.getStream(info.fd);SYSCALLS.doMsync(addr,stream,len,info.flags);FS.munmap(stream);SYSCALLS.mappings[addr]=null;if(info.allocated){_free(info.malloc)}}return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}var cttz_i8=allocate([8,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,7,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0],"i8",ALLOC_STATIC);function ___unlock(){}var structRegistrations={};function runDestructors(destructors){while(destructors.length){var ptr=destructors.pop();var del=destructors.pop();del(ptr)}}function simpleReadValueFromPointer(pointer){return this["fromWireType"](HEAPU32[pointer>>2])}var awaitingDependencies={};var registeredTypes={};var typeDependencies={};var char_0=48;var char_9=57;function makeLegalFunctionName(name){if(undefined===name){return"_unknown"}name=name.replace(/[^a-zA-Z0-9_]/g,"$");var f=name.charCodeAt(0);if(f>=char_0&&f<=char_9){return"_"+name}else{return name}}function createNamedFunction(name,body){name=makeLegalFunctionName(name);return(new Function("body","return function "+name+"() {\n"+'    "use strict";'+"    return body.apply(this, arguments);\n"+"};\n"))(body)}function extendError(baseErrorType,errorName){var errorClass=createNamedFunction(errorName,(function(message){this.name=errorName;this.message=message;var stack=(new Error(message)).stack;if(stack!==undefined){this.stack=this.toString()+"\n"+stack.replace(/^Error(:[^\n]*)?\n/,"")}}));errorClass.prototype=Object.create(baseErrorType.prototype);errorClass.prototype.constructor=errorClass;errorClass.prototype.toString=(function(){if(this.message===undefined){return this.name}else{return this.name+": "+this.message}});return errorClass}var InternalError=undefined;function throwInternalError(message){throw new InternalError(message)}function whenDependentTypesAreResolved(myTypes,dependentTypes,getTypeConverters){myTypes.forEach((function(type){typeDependencies[type]=dependentTypes}));function onComplete(typeConverters){var myTypeConverters=getTypeConverters(typeConverters);if(myTypeConverters.length!==myTypes.length){throwInternalError("Mismatched type converter count")}for(var i=0;i<myTypes.length;++i){registerType(myTypes[i],myTypeConverters[i])}}var typeConverters=new Array(dependentTypes.length);var unregisteredTypes=[];var registered=0;dependentTypes.forEach((function(dt,i){if(registeredTypes.hasOwnProperty(dt)){typeConverters[i]=registeredTypes[dt]}else{unregisteredTypes.push(dt);if(!awaitingDependencies.hasOwnProperty(dt)){awaitingDependencies[dt]=[]}awaitingDependencies[dt].push((function(){typeConverters[i]=registeredTypes[dt];++registered;if(registered===unregisteredTypes.length){onComplete(typeConverters)}}))}}));if(0===unregisteredTypes.length){onComplete(typeConverters)}}function __embind_finalize_value_object(structType){var reg=structRegistrations[structType];delete structRegistrations[structType];var rawConstructor=reg.rawConstructor;var rawDestructor=reg.rawDestructor;var fieldRecords=reg.fields;var fieldTypes=fieldRecords.map((function(field){return field.getterReturnType})).concat(fieldRecords.map((function(field){return field.setterArgumentType})));whenDependentTypesAreResolved([structType],fieldTypes,(function(fieldTypes){var fields={};fieldRecords.forEach((function(field,i){var fieldName=field.fieldName;var getterReturnType=fieldTypes[i];var getter=field.getter;var getterContext=field.getterContext;var setterArgumentType=fieldTypes[i+fieldRecords.length];var setter=field.setter;var setterContext=field.setterContext;fields[fieldName]={read:(function(ptr){return getterReturnType["fromWireType"](getter(getterContext,ptr))}),write:(function(ptr,o){var destructors=[];setter(setterContext,ptr,setterArgumentType["toWireType"](destructors,o));runDestructors(destructors)})}}));return[{name:reg.name,"fromWireType":(function(ptr){var rv={};for(var i in fields){rv[i]=fields[i].read(ptr)}rawDestructor(ptr);return rv}),"toWireType":(function(destructors,o){for(var fieldName in fields){if(!(fieldName in o)){throw new TypeError("Missing field")}}var ptr=rawConstructor();for(fieldName in fields){fields[fieldName].write(ptr,o[fieldName])}if(destructors!==null){destructors.push(rawDestructor,ptr)}return ptr}),"argPackAdvance":8,"readValueFromPointer":simpleReadValueFromPointer,destructorFunction:rawDestructor}]}))}function getShiftFromSize(size){switch(size){case 1:return 0;case 2:return 1;case 4:return 2;case 8:return 3;default:throw new TypeError("Unknown type size: "+size)}}function embind_init_charCodes(){var codes=new Array(256);for(var i=0;i<256;++i){codes[i]=String.fromCharCode(i)}embind_charCodes=codes}var embind_charCodes=undefined;function readLatin1String(ptr){var ret="";var c=ptr;while(HEAPU8[c]){ret+=embind_charCodes[HEAPU8[c++]]}return ret}var BindingError=undefined;function throwBindingError(message){throw new BindingError(message)}function registerType(rawType,registeredInstance,options){options=options||{};if(!("argPackAdvance"in registeredInstance)){throw new TypeError("registerType registeredInstance requires argPackAdvance")}var name=registeredInstance.name;if(!rawType){throwBindingError('type "'+name+'" must have a positive integer typeid pointer')}if(registeredTypes.hasOwnProperty(rawType)){if(options.ignoreDuplicateRegistrations){return}else{throwBindingError("Cannot register type '"+name+"' twice")}}registeredTypes[rawType]=registeredInstance;delete typeDependencies[rawType];if(awaitingDependencies.hasOwnProperty(rawType)){var callbacks=awaitingDependencies[rawType];delete awaitingDependencies[rawType];callbacks.forEach((function(cb){cb()}))}}function __embind_register_bool(rawType,name,size,trueValue,falseValue){var shift=getShiftFromSize(size);name=readLatin1String(name);registerType(rawType,{name:name,"fromWireType":(function(wt){return!!wt}),"toWireType":(function(destructors,o){return o?trueValue:falseValue}),"argPackAdvance":8,"readValueFromPointer":(function(pointer){var heap;if(size===1){heap=HEAP8}else if(size===2){heap=HEAP16}else if(size===4){heap=HEAP32}else{throw new TypeError("Unknown boolean type size: "+name)}return this["fromWireType"](heap[pointer>>shift])}),destructorFunction:null})}function ClassHandle_isAliasOf(other){if(!(this instanceof ClassHandle)){return false}if(!(other instanceof ClassHandle)){return false}var leftClass=this.$$.ptrType.registeredClass;var left=this.$$.ptr;var rightClass=other.$$.ptrType.registeredClass;var right=other.$$.ptr;while(leftClass.baseClass){left=leftClass.upcast(left);leftClass=leftClass.baseClass}while(rightClass.baseClass){right=rightClass.upcast(right);rightClass=rightClass.baseClass}return leftClass===rightClass&&left===right}function shallowCopyInternalPointer(o){return{count:o.count,deleteScheduled:o.deleteScheduled,preservePointerOnDelete:o.preservePointerOnDelete,ptr:o.ptr,ptrType:o.ptrType,smartPtr:o.smartPtr,smartPtrType:o.smartPtrType}}function throwInstanceAlreadyDeleted(obj){function getInstanceTypeName(handle){return handle.$$.ptrType.registeredClass.name}throwBindingError(getInstanceTypeName(obj)+" instance already deleted")}function ClassHandle_clone(){if(!this.$$.ptr){throwInstanceAlreadyDeleted(this)}if(this.$$.preservePointerOnDelete){this.$$.count.value+=1;return this}else{var clone=Object.create(Object.getPrototypeOf(this),{$$:{value:shallowCopyInternalPointer(this.$$)}});clone.$$.count.value+=1;clone.$$.deleteScheduled=false;return clone}}function runDestructor(handle){var $$=handle.$$;if($$.smartPtr){$$.smartPtrType.rawDestructor($$.smartPtr)}else{$$.ptrType.registeredClass.rawDestructor($$.ptr)}}function ClassHandle_delete(){if(!this.$$.ptr){throwInstanceAlreadyDeleted(this)}if(this.$$.deleteScheduled&&!this.$$.preservePointerOnDelete){throwBindingError("Object already scheduled for deletion")}this.$$.count.value-=1;var toDelete=0===this.$$.count.value;if(toDelete){runDestructor(this)}if(!this.$$.preservePointerOnDelete){this.$$.smartPtr=undefined;this.$$.ptr=undefined}}function ClassHandle_isDeleted(){return!this.$$.ptr}var delayFunction=undefined;var deletionQueue=[];function flushPendingDeletes(){while(deletionQueue.length){var obj=deletionQueue.pop();obj.$$.deleteScheduled=false;obj["delete"]()}}function ClassHandle_deleteLater(){if(!this.$$.ptr){throwInstanceAlreadyDeleted(this)}if(this.$$.deleteScheduled&&!this.$$.preservePointerOnDelete){throwBindingError("Object already scheduled for deletion")}deletionQueue.push(this);if(deletionQueue.length===1&&delayFunction){delayFunction(flushPendingDeletes)}this.$$.deleteScheduled=true;return this}function init_ClassHandle(){ClassHandle.prototype["isAliasOf"]=ClassHandle_isAliasOf;ClassHandle.prototype["clone"]=ClassHandle_clone;ClassHandle.prototype["delete"]=ClassHandle_delete;ClassHandle.prototype["isDeleted"]=ClassHandle_isDeleted;ClassHandle.prototype["deleteLater"]=ClassHandle_deleteLater}function ClassHandle(){}var registeredPointers={};function ensureOverloadTable(proto,methodName,humanName){if(undefined===proto[methodName].overloadTable){var prevFunc=proto[methodName];proto[methodName]=(function(){if(!proto[methodName].overloadTable.hasOwnProperty(arguments.length)){throwBindingError("Function '"+humanName+"' called with an invalid number of arguments ("+arguments.length+") - expects one of ("+proto[methodName].overloadTable+")!")}return proto[methodName].overloadTable[arguments.length].apply(this,arguments)});proto[methodName].overloadTable=[];proto[methodName].overloadTable[prevFunc.argCount]=prevFunc}}function exposePublicSymbol(name,value,numArguments){if(Module.hasOwnProperty(name)){if(undefined===numArguments||undefined!==Module[name].overloadTable&&undefined!==Module[name].overloadTable[numArguments]){throwBindingError("Cannot register public name '"+name+"' twice")}ensureOverloadTable(Module,name,name);if(Module.hasOwnProperty(numArguments)){throwBindingError("Cannot register multiple overloads of a function with the same number of arguments ("+numArguments+")!")}Module[name].overloadTable[numArguments]=value}else{Module[name]=value;if(undefined!==numArguments){Module[name].numArguments=numArguments}}}function RegisteredClass(name,constructor,instancePrototype,rawDestructor,baseClass,getActualType,upcast,downcast){this.name=name;this.constructor=constructor;this.instancePrototype=instancePrototype;this.rawDestructor=rawDestructor;this.baseClass=baseClass;this.getActualType=getActualType;this.upcast=upcast;this.downcast=downcast;this.pureVirtualFunctions=[]}function upcastPointer(ptr,ptrClass,desiredClass){while(ptrClass!==desiredClass){if(!ptrClass.upcast){throwBindingError("Expected null or instance of "+desiredClass.name+", got an instance of "+ptrClass.name)}ptr=ptrClass.upcast(ptr);ptrClass=ptrClass.baseClass}return ptr}function constNoSmartPtrRawPointerToWireType(destructors,handle){if(handle===null){if(this.isReference){throwBindingError("null is not a valid "+this.name)}return 0}if(!handle.$$){throwBindingError('Cannot pass "'+_embind_repr(handle)+'" as a '+this.name)}if(!handle.$$.ptr){throwBindingError("Cannot pass deleted object as a pointer of type "+this.name)}var handleClass=handle.$$.ptrType.registeredClass;var ptr=upcastPointer(handle.$$.ptr,handleClass,this.registeredClass);return ptr}function genericPointerToWireType(destructors,handle){var ptr;if(handle===null){if(this.isReference){throwBindingError("null is not a valid "+this.name)}if(this.isSmartPointer){ptr=this.rawConstructor();if(destructors!==null){destructors.push(this.rawDestructor,ptr)}return ptr}else{return 0}}if(!handle.$$){throwBindingError('Cannot pass "'+_embind_repr(handle)+'" as a '+this.name)}if(!handle.$$.ptr){throwBindingError("Cannot pass deleted object as a pointer of type "+this.name)}if(!this.isConst&&handle.$$.ptrType.isConst){throwBindingError("Cannot convert argument of type "+(handle.$$.smartPtrType?handle.$$.smartPtrType.name:handle.$$.ptrType.name)+" to parameter type "+this.name)}var handleClass=handle.$$.ptrType.registeredClass;ptr=upcastPointer(handle.$$.ptr,handleClass,this.registeredClass);if(this.isSmartPointer){if(undefined===handle.$$.smartPtr){throwBindingError("Passing raw pointer to smart pointer is illegal")}switch(this.sharingPolicy){case 0:if(handle.$$.smartPtrType===this){ptr=handle.$$.smartPtr}else{throwBindingError("Cannot convert argument of type "+(handle.$$.smartPtrType?handle.$$.smartPtrType.name:handle.$$.ptrType.name)+" to parameter type "+this.name)}break;case 1:ptr=handle.$$.smartPtr;break;case 2:if(handle.$$.smartPtrType===this){ptr=handle.$$.smartPtr}else{var clonedHandle=handle["clone"]();ptr=this.rawShare(ptr,__emval_register((function(){clonedHandle["delete"]()})));if(destructors!==null){destructors.push(this.rawDestructor,ptr)}}break;default:throwBindingError("Unsupporting sharing policy")}}return ptr}function nonConstNoSmartPtrRawPointerToWireType(destructors,handle){if(handle===null){if(this.isReference){throwBindingError("null is not a valid "+this.name)}return 0}if(!handle.$$){throwBindingError('Cannot pass "'+_embind_repr(handle)+'" as a '+this.name)}if(!handle.$$.ptr){throwBindingError("Cannot pass deleted object as a pointer of type "+this.name)}if(handle.$$.ptrType.isConst){throwBindingError("Cannot convert argument of type "+handle.$$.ptrType.name+" to parameter type "+this.name)}var handleClass=handle.$$.ptrType.registeredClass;var ptr=upcastPointer(handle.$$.ptr,handleClass,this.registeredClass);return ptr}function RegisteredPointer_getPointee(ptr){if(this.rawGetPointee){ptr=this.rawGetPointee(ptr)}return ptr}function RegisteredPointer_destructor(ptr){if(this.rawDestructor){this.rawDestructor(ptr)}}function RegisteredPointer_deleteObject(handle){if(handle!==null){handle["delete"]()}}function downcastPointer(ptr,ptrClass,desiredClass){if(ptrClass===desiredClass){return ptr}if(undefined===desiredClass.baseClass){return null}var rv=downcastPointer(ptr,ptrClass,desiredClass.baseClass);if(rv===null){return null}return desiredClass.downcast(rv)}function getInheritedInstanceCount(){return Object.keys(registeredInstances).length}function getLiveInheritedInstances(){var rv=[];for(var k in registeredInstances){if(registeredInstances.hasOwnProperty(k)){rv.push(registeredInstances[k])}}return rv}function setDelayFunction(fn){delayFunction=fn;if(deletionQueue.length&&delayFunction){delayFunction(flushPendingDeletes)}}function init_embind(){Module["getInheritedInstanceCount"]=getInheritedInstanceCount;Module["getLiveInheritedInstances"]=getLiveInheritedInstances;Module["flushPendingDeletes"]=flushPendingDeletes;Module["setDelayFunction"]=setDelayFunction}var registeredInstances={};function getBasestPointer(class_,ptr){if(ptr===undefined){throwBindingError("ptr should not be undefined")}while(class_.baseClass){ptr=class_.upcast(ptr);class_=class_.baseClass}return ptr}function getInheritedInstance(class_,ptr){ptr=getBasestPointer(class_,ptr);return registeredInstances[ptr]}function makeClassHandle(prototype,record){if(!record.ptrType||!record.ptr){throwInternalError("makeClassHandle requires ptr and ptrType")}var hasSmartPtrType=!!record.smartPtrType;var hasSmartPtr=!!record.smartPtr;if(hasSmartPtrType!==hasSmartPtr){throwInternalError("Both smartPtrType and smartPtr must be specified")}record.count={value:1};return Object.create(prototype,{$$:{value:record}})}function RegisteredPointer_fromWireType(ptr){var rawPointer=this.getPointee(ptr);if(!rawPointer){this.destructor(ptr);return null}var registeredInstance=getInheritedInstance(this.registeredClass,rawPointer);if(undefined!==registeredInstance){if(0===registeredInstance.$$.count.value){registeredInstance.$$.ptr=rawPointer;registeredInstance.$$.smartPtr=ptr;return registeredInstance["clone"]()}else{var rv=registeredInstance["clone"]();this.destructor(ptr);return rv}}function makeDefaultHandle(){if(this.isSmartPointer){return makeClassHandle(this.registeredClass.instancePrototype,{ptrType:this.pointeeType,ptr:rawPointer,smartPtrType:this,smartPtr:ptr})}else{return makeClassHandle(this.registeredClass.instancePrototype,{ptrType:this,ptr:ptr})}}var actualType=this.registeredClass.getActualType(rawPointer);var registeredPointerRecord=registeredPointers[actualType];if(!registeredPointerRecord){return makeDefaultHandle.call(this)}var toType;if(this.isConst){toType=registeredPointerRecord.constPointerType}else{toType=registeredPointerRecord.pointerType}var dp=downcastPointer(rawPointer,this.registeredClass,toType.registeredClass);if(dp===null){return makeDefaultHandle.call(this)}if(this.isSmartPointer){return makeClassHandle(toType.registeredClass.instancePrototype,{ptrType:toType,ptr:dp,smartPtrType:this,smartPtr:ptr})}else{return makeClassHandle(toType.registeredClass.instancePrototype,{ptrType:toType,ptr:dp})}}function init_RegisteredPointer(){RegisteredPointer.prototype.getPointee=RegisteredPointer_getPointee;RegisteredPointer.prototype.destructor=RegisteredPointer_destructor;RegisteredPointer.prototype["argPackAdvance"]=8;RegisteredPointer.prototype["readValueFromPointer"]=simpleReadValueFromPointer;RegisteredPointer.prototype["deleteObject"]=RegisteredPointer_deleteObject;RegisteredPointer.prototype["fromWireType"]=RegisteredPointer_fromWireType}function RegisteredPointer(name,registeredClass,isReference,isConst,isSmartPointer,pointeeType,sharingPolicy,rawGetPointee,rawConstructor,rawShare,rawDestructor){this.name=name;this.registeredClass=registeredClass;this.isReference=isReference;this.isConst=isConst;this.isSmartPointer=isSmartPointer;this.pointeeType=pointeeType;this.sharingPolicy=sharingPolicy;this.rawGetPointee=rawGetPointee;this.rawConstructor=rawConstructor;this.rawShare=rawShare;this.rawDestructor=rawDestructor;if(!isSmartPointer&&registeredClass.baseClass===undefined){if(isConst){this["toWireType"]=constNoSmartPtrRawPointerToWireType;this.destructorFunction=null}else{this["toWireType"]=nonConstNoSmartPtrRawPointerToWireType;this.destructorFunction=null}}else{this["toWireType"]=genericPointerToWireType}}function replacePublicSymbol(name,value,numArguments){if(!Module.hasOwnProperty(name)){throwInternalError("Replacing nonexistant public symbol")}if(undefined!==Module[name].overloadTable&&undefined!==numArguments){Module[name].overloadTable[numArguments]=value}else{Module[name]=value;Module[name].argCount=numArguments}}function requireFunction(signature,rawFunction){signature=readLatin1String(signature);function makeDynCaller(dynCall){var args=[];for(var i=1;i<signature.length;++i){args.push("a"+i)}var name="dynCall_"+signature+"_"+rawFunction;var body="return function "+name+"("+args.join(", ")+") {\n";body+="    return dynCall(rawFunction"+(args.length?", ":"")+args.join(", ")+");\n";body+="};\n";return(new Function("dynCall","rawFunction",body))(dynCall,rawFunction)}var fp;if(Module["FUNCTION_TABLE_"+signature]!==undefined){fp=Module["FUNCTION_TABLE_"+signature][rawFunction]}else if(typeof FUNCTION_TABLE!=="undefined"){fp=FUNCTION_TABLE[rawFunction]}else{var dc=Module["asm"]["dynCall_"+signature];if(dc===undefined){dc=Module["asm"]["dynCall_"+signature.replace(/f/g,"d")];if(dc===undefined){throwBindingError("No dynCall invoker for signature: "+signature)}}fp=makeDynCaller(dc)}if(typeof fp!=="function"){throwBindingError("unknown function pointer with signature "+signature+": "+rawFunction)}return fp}var UnboundTypeError=undefined;function getTypeName(type){var ptr=___getTypeName(type);var rv=readLatin1String(ptr);_free(ptr);return rv}function throwUnboundTypeError(message,types){var unboundTypes=[];var seen={};function visit(type){if(seen[type]){return}if(registeredTypes[type]){return}if(typeDependencies[type]){typeDependencies[type].forEach(visit);return}unboundTypes.push(type);seen[type]=true}types.forEach(visit);throw new UnboundTypeError(message+": "+unboundTypes.map(getTypeName).join([", "]))}function __embind_register_class(rawType,rawPointerType,rawConstPointerType,baseClassRawType,getActualTypeSignature,getActualType,upcastSignature,upcast,downcastSignature,downcast,name,destructorSignature,rawDestructor){name=readLatin1String(name);getActualType=requireFunction(getActualTypeSignature,getActualType);if(upcast){upcast=requireFunction(upcastSignature,upcast)}if(downcast){downcast=requireFunction(downcastSignature,downcast)}rawDestructor=requireFunction(destructorSignature,rawDestructor);var legalFunctionName=makeLegalFunctionName(name);exposePublicSymbol(legalFunctionName,(function(){throwUnboundTypeError("Cannot construct "+name+" due to unbound types",[baseClassRawType])}));whenDependentTypesAreResolved([rawType,rawPointerType,rawConstPointerType],baseClassRawType?[baseClassRawType]:[],(function(base){base=base[0];var baseClass;var basePrototype;if(baseClassRawType){baseClass=base.registeredClass;basePrototype=baseClass.instancePrototype}else{basePrototype=ClassHandle.prototype}var constructor=createNamedFunction(legalFunctionName,(function(){if(Object.getPrototypeOf(this)!==instancePrototype){throw new BindingError("Use 'new' to construct "+name)}if(undefined===registeredClass.constructor_body){throw new BindingError(name+" has no accessible constructor")}var body=registeredClass.constructor_body[arguments.length];if(undefined===body){throw new BindingError("Tried to invoke ctor of "+name+" with invalid number of parameters ("+arguments.length+") - expected ("+Object.keys(registeredClass.constructor_body).toString()+") parameters instead!")}return body.apply(this,arguments)}));var instancePrototype=Object.create(basePrototype,{constructor:{value:constructor}});constructor.prototype=instancePrototype;var registeredClass=new RegisteredClass(name,constructor,instancePrototype,rawDestructor,baseClass,getActualType,upcast,downcast);var referenceConverter=new RegisteredPointer(name,registeredClass,true,false,false);var pointerConverter=new RegisteredPointer(name+"*",registeredClass,false,false,false);var constPointerConverter=new RegisteredPointer(name+" const*",registeredClass,false,true,false);registeredPointers[rawType]={pointerType:pointerConverter,constPointerType:constPointerConverter};replacePublicSymbol(legalFunctionName,constructor);return[referenceConverter,pointerConverter,constPointerConverter]}))}var emval_free_list=[];var emval_handle_array=[{},{value:undefined},{value:null},{value:true},{value:false}];function __emval_decref(handle){if(handle>4&&0===--emval_handle_array[handle].refcount){emval_handle_array[handle]=undefined;emval_free_list.push(handle)}}function count_emval_handles(){var count=0;for(var i=5;i<emval_handle_array.length;++i){if(emval_handle_array[i]!==undefined){++count}}return count}function get_first_emval(){for(var i=5;i<emval_handle_array.length;++i){if(emval_handle_array[i]!==undefined){return emval_handle_array[i]}}return null}function init_emval(){Module["count_emval_handles"]=count_emval_handles;Module["get_first_emval"]=get_first_emval}function __emval_register(value){switch(value){case undefined:{return 1};case null:{return 2};case true:{return 3};case false:{return 4};default:{var handle=emval_free_list.length?emval_free_list.pop():emval_handle_array.length;emval_handle_array[handle]={refcount:1,value:value};return handle}}}function __embind_register_emval(rawType,name){name=readLatin1String(name);registerType(rawType,{name:name,"fromWireType":(function(handle){var rv=emval_handle_array[handle].value;__emval_decref(handle);return rv}),"toWireType":(function(destructors,value){return __emval_register(value)}),"argPackAdvance":8,"readValueFromPointer":simpleReadValueFromPointer,destructorFunction:null})}function enumReadValueFromPointer(name,shift,signed){switch(shift){case 0:return(function(pointer){var heap=signed?HEAP8:HEAPU8;return this["fromWireType"](heap[pointer])});case 1:return(function(pointer){var heap=signed?HEAP16:HEAPU16;return this["fromWireType"](heap[pointer>>1])});case 2:return(function(pointer){var heap=signed?HEAP32:HEAPU32;return this["fromWireType"](heap[pointer>>2])});default:throw new TypeError("Unknown integer type: "+name)}}function __embind_register_enum(rawType,name,size,isSigned){var shift=getShiftFromSize(size);name=readLatin1String(name);function ctor(){}ctor.values={};registerType(rawType,{name:name,constructor:ctor,"fromWireType":(function(c){return this.constructor.values[c]}),"toWireType":(function(destructors,c){return c.value}),"argPackAdvance":8,"readValueFromPointer":enumReadValueFromPointer(name,shift,isSigned),destructorFunction:null});exposePublicSymbol(name,ctor)}function requireRegisteredType(rawType,humanName){var impl=registeredTypes[rawType];if(undefined===impl){throwBindingError(humanName+" has unknown type "+getTypeName(rawType))}return impl}function __embind_register_enum_value(rawEnumType,name,enumValue){var enumType=requireRegisteredType(rawEnumType,"enum");name=readLatin1String(name);var Enum=enumType.constructor;var Value=Object.create(enumType.constructor.prototype,{value:{value:enumValue},constructor:{value:createNamedFunction(enumType.name+"_"+name,(function(){}))}});Enum.values[enumValue]=Value;Enum[name]=Value}function _embind_repr(v){if(v===null){return"null"}var t=typeof v;if(t==="object"||t==="array"||t==="function"){return v.toString()}else{return""+v}}function floatReadValueFromPointer(name,shift){switch(shift){case 2:return(function(pointer){return this["fromWireType"](HEAPF32[pointer>>2])});case 3:return(function(pointer){return this["fromWireType"](HEAPF64[pointer>>3])});default:throw new TypeError("Unknown float type: "+name)}}function __embind_register_float(rawType,name,size){var shift=getShiftFromSize(size);name=readLatin1String(name);registerType(rawType,{name:name,"fromWireType":(function(value){return value}),"toWireType":(function(destructors,value){if(typeof value!=="number"&&typeof value!=="boolean"){throw new TypeError('Cannot convert "'+_embind_repr(value)+'" to '+this.name)}return value}),"argPackAdvance":8,"readValueFromPointer":floatReadValueFromPointer(name,shift),destructorFunction:null})}function new_(constructor,argumentList){if(!(constructor instanceof Function)){throw new TypeError("new_ called with constructor type "+typeof constructor+" which is not a function")}var dummy=createNamedFunction(constructor.name||"unknownFunctionName",(function(){}));dummy.prototype=constructor.prototype;var obj=new dummy;var r=constructor.apply(obj,argumentList);return r instanceof Object?r:obj}function craftInvokerFunction(humanName,argTypes,classType,cppInvokerFunc,cppTargetFunc){var argCount=argTypes.length;if(argCount<2){throwBindingError("argTypes array size mismatch! Must at least get return value and 'this' types!")}var isClassMethodFunc=argTypes[1]!==null&&classType!==null;var needsDestructorStack=false;for(var i=1;i<argTypes.length;++i){if(argTypes[i]!==null&&argTypes[i].destructorFunction===undefined){needsDestructorStack=true;break}}var returns=argTypes[0].name!=="void";var argsList="";var argsListWired="";for(var i=0;i<argCount-2;++i){argsList+=(i!==0?", ":"")+"arg"+i;argsListWired+=(i!==0?", ":"")+"arg"+i+"Wired"}var invokerFnBody="return function "+makeLegalFunctionName(humanName)+"("+argsList+") {\n"+"if (arguments.length !== "+(argCount-2)+") {\n"+"throwBindingError('function "+humanName+" called with ' + arguments.length + ' arguments, expected "+(argCount-2)+" args!');\n"+"}\n";if(needsDestructorStack){invokerFnBody+="var destructors = [];\n"}var dtorStack=needsDestructorStack?"destructors":"null";var args1=["throwBindingError","invoker","fn","runDestructors","retType","classParam"];var args2=[throwBindingError,cppInvokerFunc,cppTargetFunc,runDestructors,argTypes[0],argTypes[1]];if(isClassMethodFunc){invokerFnBody+="var thisWired = classParam.toWireType("+dtorStack+", this);\n"}for(var i=0;i<argCount-2;++i){invokerFnBody+="var arg"+i+"Wired = argType"+i+".toWireType("+dtorStack+", arg"+i+"); // "+argTypes[i+2].name+"\n";args1.push("argType"+i);args2.push(argTypes[i+2])}if(isClassMethodFunc){argsListWired="thisWired"+(argsListWired.length>0?", ":"")+argsListWired}invokerFnBody+=(returns?"var rv = ":"")+"invoker(fn"+(argsListWired.length>0?", ":"")+argsListWired+");\n";if(needsDestructorStack){invokerFnBody+="runDestructors(destructors);\n"}else{for(var i=isClassMethodFunc?1:2;i<argTypes.length;++i){var paramName=i===1?"thisWired":"arg"+(i-2)+"Wired";if(argTypes[i].destructorFunction!==null){invokerFnBody+=paramName+"_dtor("+paramName+"); // "+argTypes[i].name+"\n";args1.push(paramName+"_dtor");args2.push(argTypes[i].destructorFunction)}}}if(returns){invokerFnBody+="var ret = retType.fromWireType(rv);\n"+"return ret;\n"}else{}invokerFnBody+="}\n";args1.push(invokerFnBody);var invokerFunction=new_(Function,args1).apply(null,args2);return invokerFunction}function heap32VectorToArray(count,firstElement){var array=[];for(var i=0;i<count;i++){array.push(HEAP32[(firstElement>>2)+i])}return array}function __embind_register_function(name,argCount,rawArgTypesAddr,signature,rawInvoker,fn){var argTypes=heap32VectorToArray(argCount,rawArgTypesAddr);name=readLatin1String(name);rawInvoker=requireFunction(signature,rawInvoker);exposePublicSymbol(name,(function(){throwUnboundTypeError("Cannot call "+name+" due to unbound types",argTypes)}),argCount-1);whenDependentTypesAreResolved([],argTypes,(function(argTypes){var invokerArgsArray=[argTypes[0],null].concat(argTypes.slice(1));replacePublicSymbol(name,craftInvokerFunction(name,invokerArgsArray,null,rawInvoker,fn),argCount-1);return[]}))}function integerReadValueFromPointer(name,shift,signed){switch(shift){case 0:return signed?function readS8FromPointer(pointer){return HEAP8[pointer]}:function readU8FromPointer(pointer){return HEAPU8[pointer]};case 1:return signed?function readS16FromPointer(pointer){return HEAP16[pointer>>1]}:function readU16FromPointer(pointer){return HEAPU16[pointer>>1]};case 2:return signed?function readS32FromPointer(pointer){return HEAP32[pointer>>2]}:function readU32FromPointer(pointer){return HEAPU32[pointer>>2]};default:throw new TypeError("Unknown integer type: "+name)}}function __embind_register_integer(primitiveType,name,size,minRange,maxRange){name=readLatin1String(name);if(maxRange===-1){maxRange=4294967295}var shift=getShiftFromSize(size);var fromWireType=(function(value){return value});if(minRange===0){var bitshift=32-8*size;fromWireType=(function(value){return value<<bitshift>>>bitshift})}var isUnsignedType=name.indexOf("unsigned")!=-1;registerType(primitiveType,{name:name,"fromWireType":fromWireType,"toWireType":(function(destructors,value){if(typeof value!=="number"&&typeof value!=="boolean"){throw new TypeError('Cannot convert "'+_embind_repr(value)+'" to '+this.name)}if(value<minRange||value>maxRange){throw new TypeError('Passing a number "'+_embind_repr(value)+'" from JS side to C/C++ side to an argument of type "'+name+'", which is outside the valid range ['+minRange+", "+maxRange+"]!")}return isUnsignedType?value>>>0:value|0}),"argPackAdvance":8,"readValueFromPointer":integerReadValueFromPointer(name,shift,minRange!==0),destructorFunction:null})}function __embind_register_memory_view(rawType,dataTypeIndex,name){var typeMapping=[Int8Array,Uint8Array,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];var TA=typeMapping[dataTypeIndex];function decodeMemoryView(handle){handle=handle>>2;var heap=HEAPU32;var size=heap[handle];var data=heap[handle+1];return new TA(heap["buffer"],data,size)}name=readLatin1String(name);registerType(rawType,{name:name,"fromWireType":decodeMemoryView,"argPackAdvance":8,"readValueFromPointer":decodeMemoryView},{ignoreDuplicateRegistrations:true})}function __embind_register_std_string(rawType,name){name=readLatin1String(name);registerType(rawType,{name:name,"fromWireType":(function(value){var length=HEAPU32[value>>2];var a=new Array(length);for(var i=0;i<length;++i){a[i]=String.fromCharCode(HEAPU8[value+4+i])}_free(value);return a.join("")}),"toWireType":(function(destructors,value){if(value instanceof ArrayBuffer){value=new Uint8Array(value)}function getTAElement(ta,index){return ta[index]}function getStringElement(string,index){return string.charCodeAt(index)}var getElement;if(value instanceof Uint8Array){getElement=getTAElement}else if(value instanceof Uint8ClampedArray){getElement=getTAElement}else if(value instanceof Int8Array){getElement=getTAElement}else if(typeof value==="string"){getElement=getStringElement}else{throwBindingError("Cannot pass non-string to std::string")}var length=value.length;var ptr=_malloc(4+length);HEAPU32[ptr>>2]=length;for(var i=0;i<length;++i){var charCode=getElement(value,i);if(charCode>255){_free(ptr);throwBindingError("String has UTF-16 code units that do not fit in 8 bits")}HEAPU8[ptr+4+i]=charCode}if(destructors!==null){destructors.push(_free,ptr)}return ptr}),"argPackAdvance":8,"readValueFromPointer":simpleReadValueFromPointer,destructorFunction:(function(ptr){_free(ptr)})})}function __embind_register_std_wstring(rawType,charSize,name){name=readLatin1String(name);var getHeap,shift;if(charSize===2){getHeap=(function(){return HEAPU16});shift=1}else if(charSize===4){getHeap=(function(){return HEAPU32});shift=2}registerType(rawType,{name:name,"fromWireType":(function(value){var HEAP=getHeap();var length=HEAPU32[value>>2];var a=new Array(length);var start=value+4>>shift;for(var i=0;i<length;++i){a[i]=String.fromCharCode(HEAP[start+i])}_free(value);return a.join("")}),"toWireType":(function(destructors,value){var HEAP=getHeap();var length=value.length;var ptr=_malloc(4+length*charSize);HEAPU32[ptr>>2]=length;var start=ptr+4>>shift;for(var i=0;i<length;++i){HEAP[start+i]=value.charCodeAt(i)}if(destructors!==null){destructors.push(_free,ptr)}return ptr}),"argPackAdvance":8,"readValueFromPointer":simpleReadValueFromPointer,destructorFunction:(function(ptr){_free(ptr)})})}function __embind_register_value_object(rawType,name,constructorSignature,rawConstructor,destructorSignature,rawDestructor){structRegistrations[rawType]={name:readLatin1String(name),rawConstructor:requireFunction(constructorSignature,rawConstructor),rawDestructor:requireFunction(destructorSignature,rawDestructor),fields:[]}}function __embind_register_value_object_field(structType,fieldName,getterReturnType,getterSignature,getter,getterContext,setterArgumentType,setterSignature,setter,setterContext){structRegistrations[structType].fields.push({fieldName:readLatin1String(fieldName),getterReturnType:getterReturnType,getter:requireFunction(getterSignature,getter),getterContext:getterContext,setterArgumentType:setterArgumentType,setter:requireFunction(setterSignature,setter),setterContext:setterContext})}function __embind_register_void(rawType,name){name=readLatin1String(name);registerType(rawType,{isVoid:true,name:name,"argPackAdvance":0,"fromWireType":(function(){return undefined}),"toWireType":(function(destructors,o){return undefined})})}function __emval_incref(handle){if(handle>4){emval_handle_array[handle].refcount+=1}}function __emval_new_array(){return __emval_register([])}var emval_symbols={};function getStringOrSymbol(address){var symbol=emval_symbols[address];if(symbol===undefined){return readLatin1String(address)}else{return symbol}}function __emval_new_cstring(v){return __emval_register(getStringOrSymbol(v))}function __emval_new_object(){return __emval_register({})}function requireHandle(handle){if(!handle){throwBindingError("Cannot use deleted val. handle = "+handle)}return emval_handle_array[handle].value}function __emval_set_property(handle,key,value){handle=requireHandle(handle);key=requireHandle(key);value=requireHandle(value);handle[key]=value}function __emval_take_value(type,argv){type=requireRegisteredType(type,"_emval_take_value");var v=type["readValueFromPointer"](argv);return __emval_register(v)}function _abort(){Module["abort"]()}var _environ=STATICTOP;STATICTOP+=16;function ___buildEnvironment(env){var MAX_ENV_VALUES=64;var TOTAL_ENV_SIZE=1024;var poolPtr;var envPtr;if(!___buildEnvironment.called){___buildEnvironment.called=true;ENV["USER"]=ENV["LOGNAME"]="web_user";ENV["PATH"]="/";ENV["PWD"]="/";ENV["HOME"]="/home/web_user";ENV["LANG"]="C.UTF-8";ENV["_"]=Module["thisProgram"];poolPtr=allocate(TOTAL_ENV_SIZE,"i8",ALLOC_STATIC);envPtr=allocate(MAX_ENV_VALUES*4,"i8*",ALLOC_STATIC);HEAP32[envPtr>>2]=poolPtr;HEAP32[_environ>>2]=envPtr}else{envPtr=HEAP32[_environ>>2];poolPtr=HEAP32[envPtr>>2]}var strings=[];var totalSize=0;for(var key in env){if(typeof env[key]==="string"){var line=key+"="+env[key];strings.push(line);totalSize+=line.length}}if(totalSize>TOTAL_ENV_SIZE){throw new Error("Environment size exceeded TOTAL_ENV_SIZE!")}var ptrSize=4;for(var i=0;i<strings.length;i++){var line=strings[i];writeAsciiToMemory(line,poolPtr);HEAP32[envPtr+i*ptrSize>>2]=poolPtr;poolPtr+=line.length+1}HEAP32[envPtr+strings.length*ptrSize>>2]=0}var ENV={};function _getenv(name){if(name===0)return 0;name=Pointer_stringify(name);if(!ENV.hasOwnProperty(name))return 0;if(_getenv.ret)_free(_getenv.ret);_getenv.ret=allocate(intArrayFromString(ENV[name]),"i8",ALLOC_NORMAL);return _getenv.ret}function _emscripten_memcpy_big(dest,src,num){HEAPU8.set(HEAPU8.subarray(src,src+num),dest);return dest}function _pthread_cond_destroy(){return 0}function _pthread_cond_init(){return 0}function _pthread_cond_signal(){return 0}function _pthread_cond_wait(){return 0}var PTHREAD_SPECIFIC={};function _pthread_getspecific(key){return PTHREAD_SPECIFIC[key]||0}function _pthread_join(){}var PTHREAD_SPECIFIC_NEXT_KEY=1;function _pthread_key_create(key,destructor){if(key==0){return ERRNO_CODES.EINVAL}HEAP32[key>>2]=PTHREAD_SPECIFIC_NEXT_KEY;PTHREAD_SPECIFIC[PTHREAD_SPECIFIC_NEXT_KEY]=0;PTHREAD_SPECIFIC_NEXT_KEY++;return 0}function _pthread_mutex_destroy(){}function _pthread_mutex_init(){}function _pthread_once(ptr,func){if(!_pthread_once.seen)_pthread_once.seen={};if(ptr in _pthread_once.seen)return;Module["dynCall_v"](func);_pthread_once.seen[ptr]=1}function _pthread_setspecific(key,value){if(!(key in PTHREAD_SPECIFIC)){return ERRNO_CODES.EINVAL}PTHREAD_SPECIFIC[key]=value;return 0}function __isLeapYear(year){return year%4===0&&(year%100!==0||year%400===0)}function __arraySum(array,index){var sum=0;for(var i=0;i<=index;sum+=array[i++]);return sum}var __MONTH_DAYS_LEAP=[31,29,31,30,31,30,31,31,30,31,30,31];var __MONTH_DAYS_REGULAR=[31,28,31,30,31,30,31,31,30,31,30,31];function __addDays(date,days){var newDate=new Date(date.getTime());while(days>0){var leap=__isLeapYear(newDate.getFullYear());var currentMonth=newDate.getMonth();var daysInCurrentMonth=(leap?__MONTH_DAYS_LEAP:__MONTH_DAYS_REGULAR)[currentMonth];if(days>daysInCurrentMonth-newDate.getDate()){days-=daysInCurrentMonth-newDate.getDate()+1;newDate.setDate(1);if(currentMonth<11){newDate.setMonth(currentMonth+1)}else{newDate.setMonth(0);newDate.setFullYear(newDate.getFullYear()+1)}}else{newDate.setDate(newDate.getDate()+days);return newDate}}return newDate}function _strftime(s,maxsize,format,tm){var tm_zone=HEAP32[tm+40>>2];var date={tm_sec:HEAP32[tm>>2],tm_min:HEAP32[tm+4>>2],tm_hour:HEAP32[tm+8>>2],tm_mday:HEAP32[tm+12>>2],tm_mon:HEAP32[tm+16>>2],tm_year:HEAP32[tm+20>>2],tm_wday:HEAP32[tm+24>>2],tm_yday:HEAP32[tm+28>>2],tm_isdst:HEAP32[tm+32>>2],tm_gmtoff:HEAP32[tm+36>>2],tm_zone:tm_zone?Pointer_stringify(tm_zone):""};var pattern=Pointer_stringify(format);var EXPANSION_RULES_1={"%c":"%a %b %d %H:%M:%S %Y","%D":"%m/%d/%y","%F":"%Y-%m-%d","%h":"%b","%r":"%I:%M:%S %p","%R":"%H:%M","%T":"%H:%M:%S","%x":"%m/%d/%y","%X":"%H:%M:%S"};for(var rule in EXPANSION_RULES_1){pattern=pattern.replace(new RegExp(rule,"g"),EXPANSION_RULES_1[rule])}var WEEKDAYS=["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"];var MONTHS=["January","February","March","April","May","June","July","August","September","October","November","December"];function leadingSomething(value,digits,character){var str=typeof value==="number"?value.toString():value||"";while(str.length<digits){str=character[0]+str}return str}function leadingNulls(value,digits){return leadingSomething(value,digits,"0")}function compareByDay(date1,date2){function sgn(value){return value<0?-1:value>0?1:0}var compare;if((compare=sgn(date1.getFullYear()-date2.getFullYear()))===0){if((compare=sgn(date1.getMonth()-date2.getMonth()))===0){compare=sgn(date1.getDate()-date2.getDate())}}return compare}function getFirstWeekStartDate(janFourth){switch(janFourth.getDay()){case 0:return new Date(janFourth.getFullYear()-1,11,29);case 1:return janFourth;case 2:return new Date(janFourth.getFullYear(),0,3);case 3:return new Date(janFourth.getFullYear(),0,2);case 4:return new Date(janFourth.getFullYear(),0,1);case 5:return new Date(janFourth.getFullYear()-1,11,31);case 6:return new Date(janFourth.getFullYear()-1,11,30)}}function getWeekBasedYear(date){var thisDate=__addDays(new Date(date.tm_year+1900,0,1),date.tm_yday);var janFourthThisYear=new Date(thisDate.getFullYear(),0,4);var janFourthNextYear=new Date(thisDate.getFullYear()+1,0,4);var firstWeekStartThisYear=getFirstWeekStartDate(janFourthThisYear);var firstWeekStartNextYear=getFirstWeekStartDate(janFourthNextYear);if(compareByDay(firstWeekStartThisYear,thisDate)<=0){if(compareByDay(firstWeekStartNextYear,thisDate)<=0){return thisDate.getFullYear()+1}else{return thisDate.getFullYear()}}else{return thisDate.getFullYear()-1}}var EXPANSION_RULES_2={"%a":(function(date){return WEEKDAYS[date.tm_wday].substring(0,3)}),"%A":(function(date){return WEEKDAYS[date.tm_wday]}),"%b":(function(date){return MONTHS[date.tm_mon].substring(0,3)}),"%B":(function(date){return MONTHS[date.tm_mon]}),"%C":(function(date){var year=date.tm_year+1900;return leadingNulls(year/100|0,2)}),"%d":(function(date){return leadingNulls(date.tm_mday,2)}),"%e":(function(date){return leadingSomething(date.tm_mday,2," ")}),"%g":(function(date){return getWeekBasedYear(date).toString().substring(2)}),"%G":(function(date){return getWeekBasedYear(date)}),"%H":(function(date){return leadingNulls(date.tm_hour,2)}),"%I":(function(date){var twelveHour=date.tm_hour;if(twelveHour==0)twelveHour=12;else if(twelveHour>12)twelveHour-=12;return leadingNulls(twelveHour,2)}),"%j":(function(date){return leadingNulls(date.tm_mday+__arraySum(__isLeapYear(date.tm_year+1900)?__MONTH_DAYS_LEAP:__MONTH_DAYS_REGULAR,date.tm_mon-1),3)}),"%m":(function(date){return leadingNulls(date.tm_mon+1,2)}),"%M":(function(date){return leadingNulls(date.tm_min,2)}),"%n":(function(){return"\n"}),"%p":(function(date){if(date.tm_hour>=0&&date.tm_hour<12){return"AM"}else{return"PM"}}),"%S":(function(date){return leadingNulls(date.tm_sec,2)}),"%t":(function(){return"\t"}),"%u":(function(date){var day=new Date(date.tm_year+1900,date.tm_mon+1,date.tm_mday,0,0,0,0);return day.getDay()||7}),"%U":(function(date){var janFirst=new Date(date.tm_year+1900,0,1);var firstSunday=janFirst.getDay()===0?janFirst:__addDays(janFirst,7-janFirst.getDay());var endDate=new Date(date.tm_year+1900,date.tm_mon,date.tm_mday);if(compareByDay(firstSunday,endDate)<0){var februaryFirstUntilEndMonth=__arraySum(__isLeapYear(endDate.getFullYear())?__MONTH_DAYS_LEAP:__MONTH_DAYS_REGULAR,endDate.getMonth()-1)-31;var firstSundayUntilEndJanuary=31-firstSunday.getDate();var days=firstSundayUntilEndJanuary+februaryFirstUntilEndMonth+endDate.getDate();return leadingNulls(Math.ceil(days/7),2)}return compareByDay(firstSunday,janFirst)===0?"01":"00"}),"%V":(function(date){var janFourthThisYear=new Date(date.tm_year+1900,0,4);var janFourthNextYear=new Date(date.tm_year+1901,0,4);var firstWeekStartThisYear=getFirstWeekStartDate(janFourthThisYear);var firstWeekStartNextYear=getFirstWeekStartDate(janFourthNextYear);var endDate=__addDays(new Date(date.tm_year+1900,0,1),date.tm_yday);if(compareByDay(endDate,firstWeekStartThisYear)<0){return"53"}if(compareByDay(firstWeekStartNextYear,endDate)<=0){return"01"}var daysDifference;if(firstWeekStartThisYear.getFullYear()<date.tm_year+1900){daysDifference=date.tm_yday+32-firstWeekStartThisYear.getDate()}else{daysDifference=date.tm_yday+1-firstWeekStartThisYear.getDate()}return leadingNulls(Math.ceil(daysDifference/7),2)}),"%w":(function(date){var day=new Date(date.tm_year+1900,date.tm_mon+1,date.tm_mday,0,0,0,0);return day.getDay()}),"%W":(function(date){var janFirst=new Date(date.tm_year,0,1);var firstMonday=janFirst.getDay()===1?janFirst:__addDays(janFirst,janFirst.getDay()===0?1:7-janFirst.getDay()+1);var endDate=new Date(date.tm_year+1900,date.tm_mon,date.tm_mday);if(compareByDay(firstMonday,endDate)<0){var februaryFirstUntilEndMonth=__arraySum(__isLeapYear(endDate.getFullYear())?__MONTH_DAYS_LEAP:__MONTH_DAYS_REGULAR,endDate.getMonth()-1)-31;var firstMondayUntilEndJanuary=31-firstMonday.getDate();var days=firstMondayUntilEndJanuary+februaryFirstUntilEndMonth+endDate.getDate();return leadingNulls(Math.ceil(days/7),2)}return compareByDay(firstMonday,janFirst)===0?"01":"00"}),"%y":(function(date){return(date.tm_year+1900).toString().substring(2)}),"%Y":(function(date){return date.tm_year+1900}),"%z":(function(date){var off=date.tm_gmtoff;var ahead=off>=0;off=Math.abs(off)/60;off=off/60*100+off%60;return(ahead?"+":"-")+String("0000"+off).slice(-4)}),"%Z":(function(date){return date.tm_zone}),"%%":(function(){return"%"})};for(var rule in EXPANSION_RULES_2){if(pattern.indexOf(rule)>=0){pattern=pattern.replace(new RegExp(rule,"g"),EXPANSION_RULES_2[rule](date))}}var bytes=intArrayFromString(pattern,false);if(bytes.length>maxsize){return 0}writeArrayToMemory(bytes,s);return bytes.length-1}function _strftime_l(s,maxsize,format,tm){return _strftime(s,maxsize,format,tm)}FS.staticInit();__ATINIT__.unshift((function(){if(!Module["noFSInit"]&&!FS.init.initialized)FS.init()}));__ATMAIN__.push((function(){FS.ignorePermissions=false}));__ATEXIT__.push((function(){FS.quit()}));Module["FS_createFolder"]=FS.createFolder;Module["FS_createPath"]=FS.createPath;Module["FS_createDataFile"]=FS.createDataFile;Module["FS_createPreloadedFile"]=FS.createPreloadedFile;Module["FS_createLazyFile"]=FS.createLazyFile;Module["FS_createLink"]=FS.createLink;Module["FS_createDevice"]=FS.createDevice;Module["FS_unlink"]=FS.unlink;__ATINIT__.unshift((function(){TTY.init()}));__ATEXIT__.push((function(){TTY.shutdown()}));if(ENVIRONMENT_IS_NODE){var fs=__webpack_require__(/*! fs */ "fs");var NODEJS_PATH=__webpack_require__(/*! path */ "path");NODEFS.staticInit()}InternalError=Module["InternalError"]=extendError(Error,"InternalError");embind_init_charCodes();BindingError=Module["BindingError"]=extendError(Error,"BindingError");init_ClassHandle();init_RegisteredPointer();init_embind();UnboundTypeError=Module["UnboundTypeError"]=extendError(Error,"UnboundTypeError");init_emval();___buildEnvironment(ENV);DYNAMICTOP_PTR=Runtime.staticAlloc(4);STACK_BASE=STACKTOP=Runtime.alignMemory(STATICTOP);STACK_MAX=STACK_BASE+TOTAL_STACK;DYNAMIC_BASE=Runtime.alignMemory(STACK_MAX);HEAP32[DYNAMICTOP_PTR>>2]=DYNAMIC_BASE;staticSealed=true;var ASSERTIONS=false;function intArrayFromString(stringy,dontAddNull,length){var len=length>0?length:lengthBytesUTF8(stringy)+1;var u8array=new Array(len);var numBytesWritten=stringToUTF8Array(stringy,u8array,0,u8array.length);if(dontAddNull)u8array.length=numBytesWritten;return u8array}function intArrayToString(array){var ret=[];for(var i=0;i<array.length;i++){var chr=array[i];if(chr>255){if(ASSERTIONS){assert(false,"Character code "+chr+" ("+String.fromCharCode(chr)+")  at offset "+i+" not in 0x00-0xFF.")}chr&=255}ret.push(String.fromCharCode(chr))}return ret.join("")}var keyStr="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";var decodeBase64=typeof atob==="function"?atob:(function(input){var output="";var chr1,chr2,chr3;var enc1,enc2,enc3,enc4;var i=0;input=input.replace(/[^A-Za-z0-9\+\/\=]/g,"");do{enc1=keyStr.indexOf(input.charAt(i++));enc2=keyStr.indexOf(input.charAt(i++));enc3=keyStr.indexOf(input.charAt(i++));enc4=keyStr.indexOf(input.charAt(i++));chr1=enc1<<2|enc2>>4;chr2=(enc2&15)<<4|enc3>>2;chr3=(enc3&3)<<6|enc4;output=output+String.fromCharCode(chr1);if(enc3!==64){output=output+String.fromCharCode(chr2)}if(enc4!==64){output=output+String.fromCharCode(chr3)}}while(i<input.length);return output});function intArrayFromBase64(s){if(typeof ENVIRONMENT_IS_NODE==="boolean"&&ENVIRONMENT_IS_NODE){var buf;try{buf=Buffer.from(s,"base64")}catch(_){buf=new Buffer(s,"base64")}return new Uint8Array(buf.buffer,buf.byteOffset,buf.byteLength)}try{var decoded=decodeBase64(s);var bytes=new Uint8Array(decoded.length);for(var i=0;i<decoded.length;++i){bytes[i]=decoded.charCodeAt(i)}return bytes}catch(_){throw new Error("Converting base64 string to bytes failed.")}}function tryParseAsDataURI(filename){var dataURIPrefix="data:application/octet-stream;base64,";if(!(String.prototype.startsWith?filename.startsWith(dataURIPrefix):filename.indexOf(dataURIPrefix)===0)){return}return intArrayFromBase64(filename.slice(dataURIPrefix.length))}function invoke_i(index){try{return Module["dynCall_i"](index)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_ii(index,a1){try{return Module["dynCall_ii"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iii(index,a1,a2){try{return Module["dynCall_iii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiii(index,a1,a2,a3){try{return Module["dynCall_iiii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiiii(index,a1,a2,a3,a4){try{return Module["dynCall_iiiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiiiid(index,a1,a2,a3,a4,a5){try{return Module["dynCall_iiiiid"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiiiii(index,a1,a2,a3,a4,a5){try{return Module["dynCall_iiiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiiiiid(index,a1,a2,a3,a4,a5,a6){try{return Module["dynCall_iiiiiid"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiiiiii(index,a1,a2,a3,a4,a5,a6){try{return Module["dynCall_iiiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiiiiiii(index,a1,a2,a3,a4,a5,a6,a7){try{return Module["dynCall_iiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8){try{return Module["dynCall_iiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_v(index){try{Module["dynCall_v"](index)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_vi(index,a1){try{Module["dynCall_vi"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_vii(index,a1,a2){try{Module["dynCall_vii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viii(index,a1,a2,a3){try{Module["dynCall_viii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiii(index,a1,a2,a3,a4){try{Module["dynCall_viiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiiii(index,a1,a2,a3,a4,a5){try{Module["dynCall_viiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiiiii(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiiiiii(index,a1,a2,a3,a4,a5,a6,a7){try{Module["dynCall_viiiiiii"](index,a1,a2,a3,a4,a5,a6,a7)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8){try{Module["dynCall_viiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9){try{Module["dynCall_viiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){try{Module["dynCall_viiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiiiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12){try{Module["dynCall_viiiiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiiiiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13){try{Module["dynCall_viiiiiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}Module.asmGlobalArg={"Math":Math,"Int8Array":Int8Array,"Int16Array":Int16Array,"Int32Array":Int32Array,"Uint8Array":Uint8Array,"Uint16Array":Uint16Array,"Uint32Array":Uint32Array,"Float32Array":Float32Array,"Float64Array":Float64Array,"NaN":NaN,"Infinity":Infinity,"byteLength":byteLength};Module.asmLibraryArg={"abort":abort,"assert":assert,"enlargeMemory":enlargeMemory,"getTotalMemory":getTotalMemory,"abortOnCannotGrowMemory":abortOnCannotGrowMemory,"invoke_i":invoke_i,"invoke_ii":invoke_ii,"invoke_iii":invoke_iii,"invoke_iiii":invoke_iiii,"invoke_iiiii":invoke_iiiii,"invoke_iiiiid":invoke_iiiiid,"invoke_iiiiii":invoke_iiiiii,"invoke_iiiiiid":invoke_iiiiiid,"invoke_iiiiiii":invoke_iiiiiii,"invoke_iiiiiiii":invoke_iiiiiiii,"invoke_iiiiiiiii":invoke_iiiiiiiii,"invoke_v":invoke_v,"invoke_vi":invoke_vi,"invoke_vii":invoke_vii,"invoke_viii":invoke_viii,"invoke_viiii":invoke_viiii,"invoke_viiiii":invoke_viiiii,"invoke_viiiiii":invoke_viiiiii,"invoke_viiiiiii":invoke_viiiiiii,"invoke_viiiiiiii":invoke_viiiiiiii,"invoke_viiiiiiiii":invoke_viiiiiiiii,"invoke_viiiiiiiiii":invoke_viiiiiiiiii,"invoke_viiiiiiiiiiii":invoke_viiiiiiiiiiii,"invoke_viiiiiiiiiiiii":invoke_viiiiiiiiiiiii,"ClassHandle":ClassHandle,"ClassHandle_clone":ClassHandle_clone,"ClassHandle_delete":ClassHandle_delete,"ClassHandle_deleteLater":ClassHandle_deleteLater,"ClassHandle_isAliasOf":ClassHandle_isAliasOf,"ClassHandle_isDeleted":ClassHandle_isDeleted,"RegisteredClass":RegisteredClass,"RegisteredPointer":RegisteredPointer,"RegisteredPointer_deleteObject":RegisteredPointer_deleteObject,"RegisteredPointer_destructor":RegisteredPointer_destructor,"RegisteredPointer_fromWireType":RegisteredPointer_fromWireType,"RegisteredPointer_getPointee":RegisteredPointer_getPointee,"__ZSt18uncaught_exceptionv":__ZSt18uncaught_exceptionv,"___assert_fail":___assert_fail,"___buildEnvironment":___buildEnvironment,"___cxa_allocate_exception":___cxa_allocate_exception,"___cxa_begin_catch":___cxa_begin_catch,"___cxa_find_matching_catch":___cxa_find_matching_catch,"___cxa_pure_virtual":___cxa_pure_virtual,"___cxa_throw":___cxa_throw,"___gxx_personality_v0":___gxx_personality_v0,"___lock":___lock,"___map_file":___map_file,"___resumeException":___resumeException,"___setErrNo":___setErrNo,"___syscall140":___syscall140,"___syscall145":___syscall145,"___syscall146":___syscall146,"___syscall54":___syscall54,"___syscall6":___syscall6,"___syscall91":___syscall91,"___unlock":___unlock,"__addDays":__addDays,"__arraySum":__arraySum,"__embind_finalize_value_object":__embind_finalize_value_object,"__embind_register_bool":__embind_register_bool,"__embind_register_class":__embind_register_class,"__embind_register_emval":__embind_register_emval,"__embind_register_enum":__embind_register_enum,"__embind_register_enum_value":__embind_register_enum_value,"__embind_register_float":__embind_register_float,"__embind_register_function":__embind_register_function,"__embind_register_integer":__embind_register_integer,"__embind_register_memory_view":__embind_register_memory_view,"__embind_register_std_string":__embind_register_std_string,"__embind_register_std_wstring":__embind_register_std_wstring,"__embind_register_value_object":__embind_register_value_object,"__embind_register_value_object_field":__embind_register_value_object_field,"__embind_register_void":__embind_register_void,"__emval_decref":__emval_decref,"__emval_incref":__emval_incref,"__emval_new_array":__emval_new_array,"__emval_new_cstring":__emval_new_cstring,"__emval_new_object":__emval_new_object,"__emval_register":__emval_register,"__emval_set_property":__emval_set_property,"__emval_take_value":__emval_take_value,"__isLeapYear":__isLeapYear,"_abort":_abort,"_embind_repr":_embind_repr,"_emscripten_memcpy_big":_emscripten_memcpy_big,"_getenv":_getenv,"_pthread_cond_destroy":_pthread_cond_destroy,"_pthread_cond_init":_pthread_cond_init,"_pthread_cond_signal":_pthread_cond_signal,"_pthread_cond_wait":_pthread_cond_wait,"_pthread_getspecific":_pthread_getspecific,"_pthread_join":_pthread_join,"_pthread_key_create":_pthread_key_create,"_pthread_mutex_destroy":_pthread_mutex_destroy,"_pthread_mutex_init":_pthread_mutex_init,"_pthread_once":_pthread_once,"_pthread_setspecific":_pthread_setspecific,"_strftime":_strftime,"_strftime_l":_strftime_l,"constNoSmartPtrRawPointerToWireType":constNoSmartPtrRawPointerToWireType,"count_emval_handles":count_emval_handles,"craftInvokerFunction":craftInvokerFunction,"createNamedFunction":createNamedFunction,"downcastPointer":downcastPointer,"embind_init_charCodes":embind_init_charCodes,"ensureOverloadTable":ensureOverloadTable,"enumReadValueFromPointer":enumReadValueFromPointer,"exposePublicSymbol":exposePublicSymbol,"extendError":extendError,"floatReadValueFromPointer":floatReadValueFromPointer,"flushPendingDeletes":flushPendingDeletes,"genericPointerToWireType":genericPointerToWireType,"getBasestPointer":getBasestPointer,"getInheritedInstance":getInheritedInstance,"getInheritedInstanceCount":getInheritedInstanceCount,"getLiveInheritedInstances":getLiveInheritedInstances,"getShiftFromSize":getShiftFromSize,"getStringOrSymbol":getStringOrSymbol,"getTypeName":getTypeName,"get_first_emval":get_first_emval,"heap32VectorToArray":heap32VectorToArray,"init_ClassHandle":init_ClassHandle,"init_RegisteredPointer":init_RegisteredPointer,"init_embind":init_embind,"init_emval":init_emval,"integerReadValueFromPointer":integerReadValueFromPointer,"makeClassHandle":makeClassHandle,"makeLegalFunctionName":makeLegalFunctionName,"new_":new_,"nonConstNoSmartPtrRawPointerToWireType":nonConstNoSmartPtrRawPointerToWireType,"readLatin1String":readLatin1String,"registerType":registerType,"replacePublicSymbol":replacePublicSymbol,"requireFunction":requireFunction,"requireHandle":requireHandle,"requireRegisteredType":requireRegisteredType,"runDestructor":runDestructor,"runDestructors":runDestructors,"setDelayFunction":setDelayFunction,"shallowCopyInternalPointer":shallowCopyInternalPointer,"simpleReadValueFromPointer":simpleReadValueFromPointer,"throwBindingError":throwBindingError,"throwInstanceAlreadyDeleted":throwInstanceAlreadyDeleted,"throwInternalError":throwInternalError,"throwUnboundTypeError":throwUnboundTypeError,"upcastPointer":upcastPointer,"whenDependentTypesAreResolved":whenDependentTypesAreResolved,"DYNAMICTOP_PTR":DYNAMICTOP_PTR,"tempDoublePtr":tempDoublePtr,"ABORT":ABORT,"STACKTOP":STACKTOP,"STACK_MAX":STACK_MAX,"cttz_i8":cttz_i8};// EMSCRIPTEN_START_ASM
var asm=(/** @suppress {uselessCode} */ function(global,env,buffer) {
"almost asm";var a=global.Int8Array;var b=new a(buffer);var c=global.Int16Array;var d=new c(buffer);var e=global.Int32Array;var f=new e(buffer);var g=global.Uint8Array;var h=new g(buffer);var i=global.Uint16Array;var j=new i(buffer);var k=global.Uint32Array;var l=new k(buffer);var m=global.Float32Array;var n=new m(buffer);var o=global.Float64Array;var p=new o(buffer);var q=global.byteLength;var r=env.DYNAMICTOP_PTR|0;var s=env.tempDoublePtr|0;var t=env.ABORT|0;var u=env.STACKTOP|0;var v=env.STACK_MAX|0;var w=env.cttz_i8|0;var x=0;var y=0;var z=0;var A=0;var B=global.NaN,C=global.Infinity;var D=0,E=0,F=0,G=0,H=0.0;var I=0;var J=global.Math.floor;var K=global.Math.abs;var L=global.Math.sqrt;var M=global.Math.pow;var N=global.Math.cos;var O=global.Math.sin;var P=global.Math.tan;var Q=global.Math.acos;var R=global.Math.asin;var S=global.Math.atan;var T=global.Math.atan2;var U=global.Math.exp;var V=global.Math.log;var W=global.Math.ceil;var X=global.Math.imul;var Y=global.Math.min;var Z=global.Math.max;var _=global.Math.clz32;var $=env.abort;var aa=env.assert;var ba=env.enlargeMemory;var ca=env.getTotalMemory;var da=env.abortOnCannotGrowMemory;var ea=env.invoke_i;var fa=env.invoke_ii;var ga=env.invoke_iii;var ha=env.invoke_iiii;var ia=env.invoke_iiiii;var ja=env.invoke_iiiiid;var ka=env.invoke_iiiiii;var la=env.invoke_iiiiiid;var ma=env.invoke_iiiiiii;var na=env.invoke_iiiiiiii;var oa=env.invoke_iiiiiiiii;var pa=env.invoke_v;var qa=env.invoke_vi;var ra=env.invoke_vii;var sa=env.invoke_viii;var ta=env.invoke_viiii;var ua=env.invoke_viiiii;var va=env.invoke_viiiiii;var wa=env.invoke_viiiiiii;var xa=env.invoke_viiiiiiii;var ya=env.invoke_viiiiiiiii;var za=env.invoke_viiiiiiiiii;var Aa=env.invoke_viiiiiiiiiiii;var Ba=env.invoke_viiiiiiiiiiiii;var Ca=env.ClassHandle;var Da=env.ClassHandle_clone;var Ea=env.ClassHandle_delete;var Fa=env.ClassHandle_deleteLater;var Ga=env.ClassHandle_isAliasOf;var Ha=env.ClassHandle_isDeleted;var Ia=env.RegisteredClass;var Ja=env.RegisteredPointer;var Ka=env.RegisteredPointer_deleteObject;var La=env.RegisteredPointer_destructor;var Ma=env.RegisteredPointer_fromWireType;var Na=env.RegisteredPointer_getPointee;var Oa=env.__ZSt18uncaught_exceptionv;var Pa=env.___assert_fail;var Qa=env.___buildEnvironment;var Ra=env.___cxa_allocate_exception;var Sa=env.___cxa_begin_catch;var Ta=env.___cxa_find_matching_catch;var Ua=env.___cxa_pure_virtual;var Va=env.___cxa_throw;var Wa=env.___gxx_personality_v0;var Xa=env.___lock;var Ya=env.___map_file;var Za=env.___resumeException;var _a=env.___setErrNo;var $a=env.___syscall140;var ab=env.___syscall145;var bb=env.___syscall146;var cb=env.___syscall54;var db=env.___syscall6;var eb=env.___syscall91;var fb=env.___unlock;var gb=env.__addDays;var hb=env.__arraySum;var ib=env.__embind_finalize_value_object;var jb=env.__embind_register_bool;var kb=env.__embind_register_class;var lb=env.__embind_register_emval;var mb=env.__embind_register_enum;var nb=env.__embind_register_enum_value;var ob=env.__embind_register_float;var pb=env.__embind_register_function;var qb=env.__embind_register_integer;var rb=env.__embind_register_memory_view;var sb=env.__embind_register_std_string;var tb=env.__embind_register_std_wstring;var ub=env.__embind_register_value_object;var vb=env.__embind_register_value_object_field;var wb=env.__embind_register_void;var xb=env.__emval_decref;var yb=env.__emval_incref;var zb=env.__emval_new_array;var Ab=env.__emval_new_cstring;var Bb=env.__emval_new_object;var Cb=env.__emval_register;var Db=env.__emval_set_property;var Eb=env.__emval_take_value;var Fb=env.__isLeapYear;var Gb=env._abort;var Hb=env._embind_repr;var Ib=env._emscripten_memcpy_big;var Jb=env._getenv;var Kb=env._pthread_cond_destroy;var Lb=env._pthread_cond_init;var Mb=env._pthread_cond_signal;var Nb=env._pthread_cond_wait;var Ob=env._pthread_getspecific;var Pb=env._pthread_join;var Qb=env._pthread_key_create;var Rb=env._pthread_mutex_destroy;var Sb=env._pthread_mutex_init;var Tb=env._pthread_once;var Ub=env._pthread_setspecific;var Vb=env._strftime;var Wb=env._strftime_l;var Xb=env.constNoSmartPtrRawPointerToWireType;var Yb=env.count_emval_handles;var Zb=env.craftInvokerFunction;var _b=env.createNamedFunction;var $b=env.downcastPointer;var ac=env.embind_init_charCodes;var bc=env.ensureOverloadTable;var cc=env.enumReadValueFromPointer;var dc=env.exposePublicSymbol;var ec=env.extendError;var fc=env.floatReadValueFromPointer;var gc=env.flushPendingDeletes;var hc=env.genericPointerToWireType;var ic=env.getBasestPointer;var jc=env.getInheritedInstance;var kc=env.getInheritedInstanceCount;var lc=env.getLiveInheritedInstances;var mc=env.getShiftFromSize;var nc=env.getStringOrSymbol;var oc=env.getTypeName;var pc=env.get_first_emval;var qc=env.heap32VectorToArray;var rc=env.init_ClassHandle;var sc=env.init_RegisteredPointer;var tc=env.init_embind;var uc=env.init_emval;var vc=env.integerReadValueFromPointer;var wc=env.makeClassHandle;var xc=env.makeLegalFunctionName;var yc=env.new_;var zc=env.nonConstNoSmartPtrRawPointerToWireType;var Ac=env.readLatin1String;var Bc=env.registerType;var Cc=env.replacePublicSymbol;var Dc=env.requireFunction;var Ec=env.requireHandle;var Fc=env.requireRegisteredType;var Gc=env.runDestructor;var Hc=env.runDestructors;var Ic=env.setDelayFunction;var Jc=env.shallowCopyInternalPointer;var Kc=env.simpleReadValueFromPointer;var Lc=env.throwBindingError;var Mc=env.throwInstanceAlreadyDeleted;var Nc=env.throwInternalError;var Oc=env.throwUnboundTypeError;var Pc=env.upcastPointer;var Qc=env.whenDependentTypesAreResolved;var Rc=0.0;function Sc(newBuffer){if(q(newBuffer)&16777215||q(newBuffer)<=16777215||q(newBuffer)>2147483648)return false;b=new a(newBuffer);d=new c(newBuffer);f=new e(newBuffer);h=new g(newBuffer);j=new i(newBuffer);l=new k(newBuffer);n=new m(newBuffer);p=new o(newBuffer);buffer=newBuffer;return true}
// EMSCRIPTEN_START_FUNCS
function OC(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0.0;E=u;r=u=u+31&-32;u=u+240|0;s=r+200|0;t=r+199|0;v=r+198|0;D=r+184|0;C=r+172|0;w=r+168|0;x=r+8|0;y=r+4|0;z=r;A=r+197|0;r=r+196|0;KC(D,e,s,t,v);f[C>>2]=0;f[C+4>>2]=0;f[C+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[C+(a<<2)>>2]=0;a=a+1|0}o=C+11|0;q=C+8|0;if((b[o>>0]|0)<0)a=(f[q>>2]&2147483647)+-1|0;else a=10;fL(C,a,0);a=(b[o>>0]|0)<0?f[C>>2]|0:C;f[w>>2]=a;f[y>>2]=x;f[z>>2]=0;b[A>>0]=1;b[r>>0]=69;n=C+4|0;j=f[c>>2]|0;i=j;a:while(1){if(i){e=f[i+12>>2]|0;if((e|0)==(f[i+16>>2]|0))e=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else e=eA(b[e>>0]|0)|0;if(cB(e,dA()|0)|0){f[c>>2]=0;m=0;j=0;k=1}else{m=i;k=0}}else{m=0;j=0;k=1}i=f[d>>2]|0;do if(i){e=f[i+12>>2]|0;if((e|0)==(f[i+16>>2]|0))e=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else e=eA(b[e>>0]|0)|0;if(!(cB(e,dA()|0)|0))if(k)break;else break a;else{f[d>>2]=0;F=19;break}}else F=19;while(0);if((F|0)==19){F=0;if(k){i=0;break}else i=0}e=b[o>>0]|0;e=e<<24>>24<0?f[n>>2]|0:e&255;if((f[w>>2]|0)==(a+e|0)){fL(C,e<<1,0);if((b[o>>0]|0)<0)a=(f[q>>2]&2147483647)+-1|0;else a=10;fL(C,a,0);a=(b[o>>0]|0)<0?f[C>>2]|0:C;f[w>>2]=a+e}k=m+12|0;e=f[k>>2]|0;l=m+16|0;if((e|0)==(f[l>>2]|0))e=Uc[f[(f[m>>2]|0)+36>>2]&127](m)|0;else e=eA(b[e>>0]|0)|0;if(LC(e&255,A,r,a,w,b[t>>0]|0,b[v>>0]|0,D,x,y,z,s)|0)break;e=f[k>>2]|0;if((e|0)==(f[l>>2]|0)){Uc[f[(f[m>>2]|0)+40>>2]&127](m)|0;i=m;continue}else{f[k>>2]=e+1;eA(b[e>>0]|0)|0;i=m;continue}}v=b[D+11>>0]|0;if(!((b[A>>0]|0)==0?1:((v<<24>>24<0?f[D+4>>2]|0:v&255)|0)==0)?(B=f[y>>2]|0,(B-x|0)<160):0){A=f[z>>2]|0;f[y>>2]=B+4;f[B>>2]=A}G=+PC(a,f[w>>2]|0,g);p[h>>3]=G;NC(D,x,f[y>>2]|0,g);if(m){a=f[m+12>>2]|0;if((a|0)==(f[m+16>>2]|0))a=Uc[f[(f[j>>2]|0)+36>>2]&127](m)|0;else a=eA(b[a>>0]|0)|0;if(cB(a,dA()|0)|0){f[c>>2]=0;e=1}else e=0}else e=1;do if(i){a=f[i+12>>2]|0;if((a|0)==(f[i+16>>2]|0))a=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else a=eA(b[a>>0]|0)|0;if(!(cB(a,dA()|0)|0))if(e)break;else{F=49;break}else{f[d>>2]=0;F=47;break}}else F=47;while(0);if((F|0)==47?e:0)F=49;if((F|0)==49)f[g>>2]=f[g>>2]|2;F=f[c>>2]|0;_K(C);_K(D);u=E;return F|0}function PC(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0,g=0,h=0,i=0,j=0;i=u;e=u=u+31&-32;u=u+16|0;if((a|0)==(b|0)){f[c>>2]=4;d=0.0}else{g=ox()|0;g=f[g>>2]|0;j=ox()|0;f[j>>2]=0;d=+Kz(a,e,BC()|0);a=ox()|0;a=f[a>>2]|0;if(!a){j=ox()|0;f[j>>2]=g}if((f[e>>2]|0)==(b|0)){if((a|0)==34)h=6}else{d=0.0;h=6}if((h|0)==6)f[c>>2]=4}u=i;return +d}function QC(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0.0;E=u;r=u=u+31&-32;u=u+240|0;s=r+200|0;t=r+199|0;v=r+198|0;D=r+184|0;C=r+172|0;w=r+168|0;x=r+8|0;y=r+4|0;z=r;A=r+197|0;r=r+196|0;KC(D,e,s,t,v);f[C>>2]=0;f[C+4>>2]=0;f[C+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[C+(a<<2)>>2]=0;a=a+1|0}p=C+11|0;q=C+8|0;if((b[p>>0]|0)<0)a=(f[q>>2]&2147483647)+-1|0;else a=10;fL(C,a,0);a=(b[p>>0]|0)<0?f[C>>2]|0:C;f[w>>2]=a;f[y>>2]=x;f[z>>2]=0;b[A>>0]=1;b[r>>0]=69;o=C+4|0;j=f[c>>2]|0;i=j;a:while(1){if(i){e=f[i+12>>2]|0;if((e|0)==(f[i+16>>2]|0))e=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else e=eA(b[e>>0]|0)|0;if(cB(e,dA()|0)|0){f[c>>2]=0;m=0;j=0;k=1}else{m=i;k=0}}else{m=0;j=0;k=1}i=f[d>>2]|0;do if(i){e=f[i+12>>2]|0;if((e|0)==(f[i+16>>2]|0))e=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else e=eA(b[e>>0]|0)|0;if(!(cB(e,dA()|0)|0))if(k)break;else break a;else{f[d>>2]=0;F=19;break}}else F=19;while(0);if((F|0)==19){F=0;if(k){i=0;break}else i=0}e=b[p>>0]|0;e=e<<24>>24<0?f[o>>2]|0:e&255;if((f[w>>2]|0)==(a+e|0)){fL(C,e<<1,0);if((b[p>>0]|0)<0)a=(f[q>>2]&2147483647)+-1|0;else a=10;fL(C,a,0);a=(b[p>>0]|0)<0?f[C>>2]|0:C;f[w>>2]=a+e}k=m+12|0;e=f[k>>2]|0;l=m+16|0;if((e|0)==(f[l>>2]|0))e=Uc[f[(f[m>>2]|0)+36>>2]&127](m)|0;else e=eA(b[e>>0]|0)|0;if(LC(e&255,A,r,a,w,b[t>>0]|0,b[v>>0]|0,D,x,y,z,s)|0)break;e=f[k>>2]|0;if((e|0)==(f[l>>2]|0)){Uc[f[(f[m>>2]|0)+40>>2]&127](m)|0;i=m;continue}else{f[k>>2]=e+1;eA(b[e>>0]|0)|0;i=m;continue}}v=b[D+11>>0]|0;if(!((b[A>>0]|0)==0?1:((v<<24>>24<0?f[D+4>>2]|0:v&255)|0)==0)?(B=f[y>>2]|0,(B-x|0)<160):0){A=f[z>>2]|0;f[y>>2]=B+4;f[B>>2]=A}G=+RC(a,f[w>>2]|0,g);n[h>>2]=G;NC(D,x,f[y>>2]|0,g);if(m){a=f[m+12>>2]|0;if((a|0)==(f[m+16>>2]|0))a=Uc[f[(f[j>>2]|0)+36>>2]&127](m)|0;else a=eA(b[a>>0]|0)|0;if(cB(a,dA()|0)|0){f[c>>2]=0;e=1}else e=0}else e=1;do if(i){a=f[i+12>>2]|0;if((a|0)==(f[i+16>>2]|0))a=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else a=eA(b[a>>0]|0)|0;if(!(cB(a,dA()|0)|0))if(e)break;else{F=49;break}else{f[d>>2]=0;F=47;break}}else F=47;while(0);if((F|0)==47?e:0)F=49;if((F|0)==49)f[g>>2]=f[g>>2]|2;F=f[c>>2]|0;_K(C);_K(D);u=E;return F|0}function RC(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0,g=0,h=0,i=0,j=0;i=u;e=u=u+31&-32;u=u+16|0;if((a|0)==(b|0)){f[c>>2]=4;d=0.0}else{g=ox()|0;g=f[g>>2]|0;j=ox()|0;f[j>>2]=0;d=+Jz(a,e,BC()|0);a=ox()|0;a=f[a>>2]|0;if(!a){j=ox()|0;f[j>>2]=g}if((f[e>>2]|0)==(b|0)){if((a|0)==34)h=6}else{d=0.0;h=6}if((h|0)==6)f[c>>2]=4}u=i;return +d}function SC(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;B=u;w=u=u+31&-32;u=u+224|0;q=w+198|0;r=w+196|0;z=w+184|0;A=w+172|0;s=w+168|0;t=w+8|0;v=w+4|0;x=TC(e)|0;UC(z,e,q,r);f[A>>2]=0;f[A+4>>2]=0;f[A+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[A+(a<<2)>>2]=0;a=a+1|0}o=A+11|0;p=A+8|0;if((b[o>>0]|0)<0)a=(f[p>>2]&2147483647)+-1|0;else a=10;fL(A,a,0);a=(b[o>>0]|0)<0?f[A>>2]|0:A;f[s>>2]=a;f[v>>2]=t;f[w>>2]=0;n=A+4|0;j=f[c>>2]|0;i=j;a:while(1){if(i){e=f[i+12>>2]|0;if((e|0)==(f[i+16>>2]|0))e=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else e=eA(b[e>>0]|0)|0;if(cB(e,dA()|0)|0){f[c>>2]=0;m=0;j=0;k=1}else{m=i;k=0}}else{m=0;j=0;k=1}i=f[d>>2]|0;do if(i){e=f[i+12>>2]|0;if((e|0)==(f[i+16>>2]|0))e=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else e=eA(b[e>>0]|0)|0;if(!(cB(e,dA()|0)|0))if(k)break;else break a;else{f[d>>2]=0;C=19;break}}else C=19;while(0);if((C|0)==19){C=0;if(k){i=0;break}else i=0}e=b[o>>0]|0;e=e<<24>>24<0?f[n>>2]|0:e&255;if((f[s>>2]|0)==(a+e|0)){fL(A,e<<1,0);if((b[o>>0]|0)<0)a=(f[p>>2]&2147483647)+-1|0;else a=10;fL(A,a,0);a=(b[o>>0]|0)<0?f[A>>2]|0:A;f[s>>2]=a+e}k=m+12|0;e=f[k>>2]|0;l=m+16|0;if((e|0)==(f[l>>2]|0))e=Uc[f[(f[m>>2]|0)+36>>2]&127](m)|0;else e=eA(b[e>>0]|0)|0;if(AC(e&255,x,a,s,w,b[r>>0]|0,z,t,v,q)|0)break;e=f[k>>2]|0;if((e|0)==(f[l>>2]|0)){Uc[f[(f[m>>2]|0)+40>>2]&127](m)|0;i=m;continue}else{f[k>>2]=e+1;eA(b[e>>0]|0)|0;i=m;continue}}r=b[z+11>>0]|0;if((r<<24>>24<0?f[z+4>>2]|0:r&255)|0?(y=f[v>>2]|0,(y-t|0)<160):0){w=f[w>>2]|0;f[v>>2]=y+4;f[y>>2]=w}y=VC(a,f[s>>2]|0,g,x)|0;f[h>>2]=y;f[h+4>>2]=I;NC(z,t,f[v>>2]|0,g);if(m){a=f[m+12>>2]|0;if((a|0)==(f[m+16>>2]|0))a=Uc[f[(f[j>>2]|0)+36>>2]&127](m)|0;else a=eA(b[a>>0]|0)|0;if(cB(a,dA()|0)|0){f[c>>2]=0;e=1}else e=0}else e=1;do if(i){a=f[i+12>>2]|0;if((a|0)==(f[i+16>>2]|0))a=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else a=eA(b[a>>0]|0)|0;if(!(cB(a,dA()|0)|0))if(e)break;else{C=49;break}else{f[d>>2]=0;C=47;break}}else C=47;while(0);if((C|0)==47?e:0)C=49;if((C|0)==49)f[g>>2]=f[g>>2]|2;C=f[c>>2]|0;_K(A);_K(z);u=B;return C|0}function TC(a){a=a|0;switch(f[a+4>>2]&74){case 64:{a=8;break}case 8:{a=16;break}case 0:{a=0;break}default:a=10}return a|0}function UC(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0;g=u;h=u=u+31&-32;u=u+16|0;dB(h,c);c=yC(h,59456)|0;Xc[f[(f[c>>2]|0)+32>>2]&7](c,53865,53891,d)|0;d=yC(h,59472)|0;c=Uc[f[(f[d>>2]|0)+16>>2]&127](d)|0;b[e>>0]=c;ed[f[(f[d>>2]|0)+20>>2]&63](a,d);zC(h);u=g;return}function VC(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0;k=u;h=u=u+31&-32;u=u+16|0;do if((a|0)==(c|0)){f[d>>2]=4;e=0;a=0}else{if((b[a>>0]|0)==45){f[d>>2]=4;e=0;a=0;break}i=ox()|0;i=f[i>>2]|0;g=ox()|0;f[g>>2]=0;a=rz(a,h,e,BC()|0)|0;e=I;g=ox()|0;g=f[g>>2]|0;if(!g){l=ox()|0;f[l>>2]=i}if((f[h>>2]|0)==(c|0)){if((g|0)==34){a=-1;e=-1;j=8}}else{a=0;e=0;j=8}if((j|0)==8)f[d>>2]=4}while(0);I=e;u=k;return a|0}function WC(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;B=u;w=u=u+31&-32;u=u+224|0;q=w+198|0;r=w+196|0;z=w+184|0;A=w+172|0;s=w+168|0;t=w+8|0;v=w+4|0;x=TC(e)|0;UC(z,e,q,r);f[A>>2]=0;f[A+4>>2]=0;f[A+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[A+(a<<2)>>2]=0;a=a+1|0}o=A+11|0;p=A+8|0;if((b[o>>0]|0)<0)a=(f[p>>2]&2147483647)+-1|0;else a=10;fL(A,a,0);a=(b[o>>0]|0)<0?f[A>>2]|0:A;f[s>>2]=a;f[v>>2]=t;f[w>>2]=0;n=A+4|0;j=f[c>>2]|0;i=j;a:while(1){if(i){e=f[i+12>>2]|0;if((e|0)==(f[i+16>>2]|0))e=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else e=eA(b[e>>0]|0)|0;if(cB(e,dA()|0)|0){f[c>>2]=0;m=0;j=0;k=1}else{m=i;k=0}}else{m=0;j=0;k=1}i=f[d>>2]|0;do if(i){e=f[i+12>>2]|0;if((e|0)==(f[i+16>>2]|0))e=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else e=eA(b[e>>0]|0)|0;if(!(cB(e,dA()|0)|0))if(k)break;else break a;else{f[d>>2]=0;C=19;break}}else C=19;while(0);if((C|0)==19){C=0;if(k){i=0;break}else i=0}e=b[o>>0]|0;e=e<<24>>24<0?f[n>>2]|0:e&255;if((f[s>>2]|0)==(a+e|0)){fL(A,e<<1,0);if((b[o>>0]|0)<0)a=(f[p>>2]&2147483647)+-1|0;else a=10;fL(A,a,0);a=(b[o>>0]|0)<0?f[A>>2]|0:A;f[s>>2]=a+e}k=m+12|0;e=f[k>>2]|0;l=m+16|0;if((e|0)==(f[l>>2]|0))e=Uc[f[(f[m>>2]|0)+36>>2]&127](m)|0;else e=eA(b[e>>0]|0)|0;if(AC(e&255,x,a,s,w,b[r>>0]|0,z,t,v,q)|0)break;e=f[k>>2]|0;if((e|0)==(f[l>>2]|0)){Uc[f[(f[m>>2]|0)+40>>2]&127](m)|0;i=m;continue}else{f[k>>2]=e+1;eA(b[e>>0]|0)|0;i=m;continue}}r=b[z+11>>0]|0;if((r<<24>>24<0?f[z+4>>2]|0:r&255)|0?(y=f[v>>2]|0,(y-t|0)<160):0){w=f[w>>2]|0;f[v>>2]=y+4;f[y>>2]=w}y=XC(a,f[s>>2]|0,g,x)|0;f[h>>2]=y;NC(z,t,f[v>>2]|0,g);if(m){a=f[m+12>>2]|0;if((a|0)==(f[m+16>>2]|0))a=Uc[f[(f[j>>2]|0)+36>>2]&127](m)|0;else a=eA(b[a>>0]|0)|0;if(cB(a,dA()|0)|0){f[c>>2]=0;e=1}else e=0}else e=1;do if(i){a=f[i+12>>2]|0;if((a|0)==(f[i+16>>2]|0))a=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else a=eA(b[a>>0]|0)|0;if(!(cB(a,dA()|0)|0))if(e)break;else{C=49;break}else{f[d>>2]=0;C=47;break}}else C=47;while(0);if((C|0)==47?e:0)C=49;if((C|0)==49)f[g>>2]=f[g>>2]|2;C=f[c>>2]|0;_K(A);_K(z);u=B;return C|0}function XC(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0;j=u;h=u=u+31&-32;u=u+16|0;do if((a|0)==(c|0)){f[d>>2]=4;a=0}else{if((b[a>>0]|0)==45){f[d>>2]=4;a=0;break}i=ox()|0;i=f[i>>2]|0;g=ox()|0;f[g>>2]=0;a=rz(a,h,e,BC()|0)|0;e=I;g=ox()|0;g=f[g>>2]|0;if(!g){k=ox()|0;f[k>>2]=i}do if((f[h>>2]|0)==(c|0))if(e>>>0>0|(e|0)==0&a>>>0>4294967295|(g|0)==34){f[d>>2]=4;a=-1;break}else break;else{f[d>>2]=4;a=0}while(0)}while(0);u=j;return a|0}function YC(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;B=u;w=u=u+31&-32;u=u+224|0;q=w+198|0;r=w+196|0;z=w+184|0;A=w+172|0;s=w+168|0;t=w+8|0;v=w+4|0;x=TC(e)|0;UC(z,e,q,r);f[A>>2]=0;f[A+4>>2]=0;f[A+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[A+(a<<2)>>2]=0;a=a+1|0}o=A+11|0;p=A+8|0;if((b[o>>0]|0)<0)a=(f[p>>2]&2147483647)+-1|0;else a=10;fL(A,a,0);a=(b[o>>0]|0)<0?f[A>>2]|0:A;f[s>>2]=a;f[v>>2]=t;f[w>>2]=0;n=A+4|0;j=f[c>>2]|0;i=j;a:while(1){if(i){e=f[i+12>>2]|0;if((e|0)==(f[i+16>>2]|0))e=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else e=eA(b[e>>0]|0)|0;if(cB(e,dA()|0)|0){f[c>>2]=0;m=0;j=0;k=1}else{m=i;k=0}}else{m=0;j=0;k=1}i=f[d>>2]|0;do if(i){e=f[i+12>>2]|0;if((e|0)==(f[i+16>>2]|0))e=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else e=eA(b[e>>0]|0)|0;if(!(cB(e,dA()|0)|0))if(k)break;else break a;else{f[d>>2]=0;C=19;break}}else C=19;while(0);if((C|0)==19){C=0;if(k){i=0;break}else i=0}e=b[o>>0]|0;e=e<<24>>24<0?f[n>>2]|0:e&255;if((f[s>>2]|0)==(a+e|0)){fL(A,e<<1,0);if((b[o>>0]|0)<0)a=(f[p>>2]&2147483647)+-1|0;else a=10;fL(A,a,0);a=(b[o>>0]|0)<0?f[A>>2]|0:A;f[s>>2]=a+e}k=m+12|0;e=f[k>>2]|0;l=m+16|0;if((e|0)==(f[l>>2]|0))e=Uc[f[(f[m>>2]|0)+36>>2]&127](m)|0;else e=eA(b[e>>0]|0)|0;if(AC(e&255,x,a,s,w,b[r>>0]|0,z,t,v,q)|0)break;e=f[k>>2]|0;if((e|0)==(f[l>>2]|0)){Uc[f[(f[m>>2]|0)+40>>2]&127](m)|0;i=m;continue}else{f[k>>2]=e+1;eA(b[e>>0]|0)|0;i=m;continue}}r=b[z+11>>0]|0;if((r<<24>>24<0?f[z+4>>2]|0:r&255)|0?(y=f[v>>2]|0,(y-t|0)<160):0){w=f[w>>2]|0;f[v>>2]=y+4;f[y>>2]=w}y=ZC(a,f[s>>2]|0,g,x)|0;f[h>>2]=y;NC(z,t,f[v>>2]|0,g);if(m){a=f[m+12>>2]|0;if((a|0)==(f[m+16>>2]|0))a=Uc[f[(f[j>>2]|0)+36>>2]&127](m)|0;else a=eA(b[a>>0]|0)|0;if(cB(a,dA()|0)|0){f[c>>2]=0;e=1}else e=0}else e=1;do if(i){a=f[i+12>>2]|0;if((a|0)==(f[i+16>>2]|0))a=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else a=eA(b[a>>0]|0)|0;if(!(cB(a,dA()|0)|0))if(e)break;else{C=49;break}else{f[d>>2]=0;C=47;break}}else C=47;while(0);if((C|0)==47?e:0)C=49;if((C|0)==49)f[g>>2]=f[g>>2]|2;C=f[c>>2]|0;_K(A);_K(z);u=B;return C|0}function ZC(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0;j=u;h=u=u+31&-32;u=u+16|0;do if((a|0)==(c|0)){f[d>>2]=4;a=0}else{if((b[a>>0]|0)==45){f[d>>2]=4;a=0;break}i=ox()|0;i=f[i>>2]|0;g=ox()|0;f[g>>2]=0;a=rz(a,h,e,BC()|0)|0;e=I;g=ox()|0;g=f[g>>2]|0;if(!g){k=ox()|0;f[k>>2]=i}do if((f[h>>2]|0)==(c|0))if(e>>>0>0|(e|0)==0&a>>>0>4294967295|(g|0)==34){f[d>>2]=4;a=-1;break}else break;else{f[d>>2]=4;a=0}while(0)}while(0);u=j;return a|0}function _C(a,c,e,g,h,i){a=a|0;c=c|0;e=e|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;C=u;x=u=u+31&-32;u=u+224|0;r=x+198|0;s=x+196|0;A=x+184|0;B=x+172|0;t=x+168|0;v=x+8|0;w=x+4|0;y=TC(g)|0;UC(A,g,r,s);f[B>>2]=0;f[B+4>>2]=0;f[B+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[B+(a<<2)>>2]=0;a=a+1|0}p=B+11|0;q=B+8|0;if((b[p>>0]|0)<0)a=(f[q>>2]&2147483647)+-1|0;else a=10;fL(B,a,0);a=(b[p>>0]|0)<0?f[B>>2]|0:B;f[t>>2]=a;f[w>>2]=v;f[x>>2]=0;o=B+4|0;k=f[c>>2]|0;j=k;a:while(1){if(j){g=f[j+12>>2]|0;if((g|0)==(f[j+16>>2]|0))g=Uc[f[(f[j>>2]|0)+36>>2]&127](j)|0;else g=eA(b[g>>0]|0)|0;if(cB(g,dA()|0)|0){f[c>>2]=0;n=0;k=0;l=1}else{n=j;l=0}}else{n=0;k=0;l=1}j=f[e>>2]|0;do if(j){g=f[j+12>>2]|0;if((g|0)==(f[j+16>>2]|0))g=Uc[f[(f[j>>2]|0)+36>>2]&127](j)|0;else g=eA(b[g>>0]|0)|0;if(!(cB(g,dA()|0)|0))if(l)break;else break a;else{f[e>>2]=0;D=19;break}}else D=19;while(0);if((D|0)==19){D=0;if(l){j=0;break}else j=0}g=b[p>>0]|0;g=g<<24>>24<0?f[o>>2]|0:g&255;if((f[t>>2]|0)==(a+g|0)){fL(B,g<<1,0);if((b[p>>0]|0)<0)a=(f[q>>2]&2147483647)+-1|0;else a=10;fL(B,a,0);a=(b[p>>0]|0)<0?f[B>>2]|0:B;f[t>>2]=a+g}l=n+12|0;g=f[l>>2]|0;m=n+16|0;if((g|0)==(f[m>>2]|0))g=Uc[f[(f[n>>2]|0)+36>>2]&127](n)|0;else g=eA(b[g>>0]|0)|0;if(AC(g&255,y,a,t,x,b[s>>0]|0,A,v,w,r)|0)break;g=f[l>>2]|0;if((g|0)==(f[m>>2]|0)){Uc[f[(f[n>>2]|0)+40>>2]&127](n)|0;j=n;continue}else{f[l>>2]=g+1;eA(b[g>>0]|0)|0;j=n;continue}}s=b[A+11>>0]|0;if((s<<24>>24<0?f[A+4>>2]|0:s&255)|0?(z=f[w>>2]|0,(z-v|0)<160):0){x=f[x>>2]|0;f[w>>2]=z+4;f[z>>2]=x}z=$C(a,f[t>>2]|0,h,y)|0;d[i>>1]=z;NC(A,v,f[w>>2]|0,h);if(n){a=f[n+12>>2]|0;if((a|0)==(f[n+16>>2]|0))a=Uc[f[(f[k>>2]|0)+36>>2]&127](n)|0;else a=eA(b[a>>0]|0)|0;if(cB(a,dA()|0)|0){f[c>>2]=0;g=1}else g=0}else g=1;do if(j){a=f[j+12>>2]|0;if((a|0)==(f[j+16>>2]|0))a=Uc[f[(f[j>>2]|0)+36>>2]&127](j)|0;else a=eA(b[a>>0]|0)|0;if(!(cB(a,dA()|0)|0))if(g)break;else{D=49;break}else{f[e>>2]=0;D=47;break}}else D=47;while(0);if((D|0)==47?g:0)D=49;if((D|0)==49)f[h>>2]=f[h>>2]|2;D=f[c>>2]|0;_K(B);_K(A);u=C;return D|0}function $C(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0;j=u;h=u=u+31&-32;u=u+16|0;do if((a|0)==(c|0)){f[d>>2]=4;a=0}else{if((b[a>>0]|0)==45){f[d>>2]=4;a=0;break}i=ox()|0;i=f[i>>2]|0;g=ox()|0;f[g>>2]=0;a=rz(a,h,e,BC()|0)|0;e=I;g=ox()|0;g=f[g>>2]|0;if(!g){k=ox()|0;f[k>>2]=i}do if((f[h>>2]|0)==(c|0))if(e>>>0>0|(e|0)==0&a>>>0>65535|(g|0)==34){f[d>>2]=4;a=-1;break}else{a=a&65535;break}else{f[d>>2]=4;a=0}while(0)}while(0);u=j;return a|0}function aD(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;B=u;w=u=u+31&-32;u=u+224|0;q=w+198|0;r=w+196|0;z=w+184|0;A=w+172|0;s=w+168|0;t=w+8|0;v=w+4|0;x=TC(e)|0;UC(z,e,q,r);f[A>>2]=0;f[A+4>>2]=0;f[A+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[A+(a<<2)>>2]=0;a=a+1|0}o=A+11|0;p=A+8|0;if((b[o>>0]|0)<0)a=(f[p>>2]&2147483647)+-1|0;else a=10;fL(A,a,0);a=(b[o>>0]|0)<0?f[A>>2]|0:A;f[s>>2]=a;f[v>>2]=t;f[w>>2]=0;n=A+4|0;j=f[c>>2]|0;i=j;a:while(1){if(i){e=f[i+12>>2]|0;if((e|0)==(f[i+16>>2]|0))e=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else e=eA(b[e>>0]|0)|0;if(cB(e,dA()|0)|0){f[c>>2]=0;m=0;j=0;k=1}else{m=i;k=0}}else{m=0;j=0;k=1}i=f[d>>2]|0;do if(i){e=f[i+12>>2]|0;if((e|0)==(f[i+16>>2]|0))e=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else e=eA(b[e>>0]|0)|0;if(!(cB(e,dA()|0)|0))if(k)break;else break a;else{f[d>>2]=0;C=19;break}}else C=19;while(0);if((C|0)==19){C=0;if(k){i=0;break}else i=0}e=b[o>>0]|0;e=e<<24>>24<0?f[n>>2]|0:e&255;if((f[s>>2]|0)==(a+e|0)){fL(A,e<<1,0);if((b[o>>0]|0)<0)a=(f[p>>2]&2147483647)+-1|0;else a=10;fL(A,a,0);a=(b[o>>0]|0)<0?f[A>>2]|0:A;f[s>>2]=a+e}k=m+12|0;e=f[k>>2]|0;l=m+16|0;if((e|0)==(f[l>>2]|0))e=Uc[f[(f[m>>2]|0)+36>>2]&127](m)|0;else e=eA(b[e>>0]|0)|0;if(AC(e&255,x,a,s,w,b[r>>0]|0,z,t,v,q)|0)break;e=f[k>>2]|0;if((e|0)==(f[l>>2]|0)){Uc[f[(f[m>>2]|0)+40>>2]&127](m)|0;i=m;continue}else{f[k>>2]=e+1;eA(b[e>>0]|0)|0;i=m;continue}}r=b[z+11>>0]|0;if((r<<24>>24<0?f[z+4>>2]|0:r&255)|0?(y=f[v>>2]|0,(y-t|0)<160):0){w=f[w>>2]|0;f[v>>2]=y+4;f[y>>2]=w}y=bD(a,f[s>>2]|0,g,x)|0;f[h>>2]=y;f[h+4>>2]=I;NC(z,t,f[v>>2]|0,g);if(m){a=f[m+12>>2]|0;if((a|0)==(f[m+16>>2]|0))a=Uc[f[(f[j>>2]|0)+36>>2]&127](m)|0;else a=eA(b[a>>0]|0)|0;if(cB(a,dA()|0)|0){f[c>>2]=0;e=1}else e=0}else e=1;do if(i){a=f[i+12>>2]|0;if((a|0)==(f[i+16>>2]|0))a=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else a=eA(b[a>>0]|0)|0;if(!(cB(a,dA()|0)|0))if(e)break;else{C=49;break}else{f[d>>2]=0;C=47;break}}else C=47;while(0);if((C|0)==47?e:0)C=49;if((C|0)==49)f[g>>2]=f[g>>2]|2;C=f[c>>2]|0;_K(A);_K(z);u=B;return C|0}function bD(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0;i=u;g=u=u+31&-32;u=u+16|0;if((a|0)==(b|0)){f[c>>2]=4;d=0;a=0}else{h=ox()|0;h=f[h>>2]|0;e=ox()|0;f[e>>2]=0;a=sz(a,g,d,BC()|0)|0;d=I;e=ox()|0;e=f[e>>2]|0;if(!e){j=ox()|0;f[j>>2]=h}if((f[g>>2]|0)==(b|0)){if((e|0)==34){f[c>>2]=4;d=(d|0)>0|(d|0)==0&a>>>0>0;a=d?-1:0;d=d?2147483647:-2147483648}}else{f[c>>2]=4;a=0;d=0}}I=d;u=i;return a|0}function cD(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;B=u;w=u=u+31&-32;u=u+224|0;q=w+198|0;r=w+196|0;z=w+184|0;A=w+172|0;s=w+168|0;t=w+8|0;v=w+4|0;x=TC(e)|0;UC(z,e,q,r);f[A>>2]=0;f[A+4>>2]=0;f[A+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[A+(a<<2)>>2]=0;a=a+1|0}o=A+11|0;p=A+8|0;if((b[o>>0]|0)<0)a=(f[p>>2]&2147483647)+-1|0;else a=10;fL(A,a,0);a=(b[o>>0]|0)<0?f[A>>2]|0:A;f[s>>2]=a;f[v>>2]=t;f[w>>2]=0;n=A+4|0;j=f[c>>2]|0;i=j;a:while(1){if(i){e=f[i+12>>2]|0;if((e|0)==(f[i+16>>2]|0))e=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else e=eA(b[e>>0]|0)|0;if(cB(e,dA()|0)|0){f[c>>2]=0;m=0;j=0;k=1}else{m=i;k=0}}else{m=0;j=0;k=1}i=f[d>>2]|0;do if(i){e=f[i+12>>2]|0;if((e|0)==(f[i+16>>2]|0))e=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else e=eA(b[e>>0]|0)|0;if(!(cB(e,dA()|0)|0))if(k)break;else break a;else{f[d>>2]=0;C=19;break}}else C=19;while(0);if((C|0)==19){C=0;if(k){i=0;break}else i=0}e=b[o>>0]|0;e=e<<24>>24<0?f[n>>2]|0:e&255;if((f[s>>2]|0)==(a+e|0)){fL(A,e<<1,0);if((b[o>>0]|0)<0)a=(f[p>>2]&2147483647)+-1|0;else a=10;fL(A,a,0);a=(b[o>>0]|0)<0?f[A>>2]|0:A;f[s>>2]=a+e}k=m+12|0;e=f[k>>2]|0;l=m+16|0;if((e|0)==(f[l>>2]|0))e=Uc[f[(f[m>>2]|0)+36>>2]&127](m)|0;else e=eA(b[e>>0]|0)|0;if(AC(e&255,x,a,s,w,b[r>>0]|0,z,t,v,q)|0)break;e=f[k>>2]|0;if((e|0)==(f[l>>2]|0)){Uc[f[(f[m>>2]|0)+40>>2]&127](m)|0;i=m;continue}else{f[k>>2]=e+1;eA(b[e>>0]|0)|0;i=m;continue}}r=b[z+11>>0]|0;if((r<<24>>24<0?f[z+4>>2]|0:r&255)|0?(y=f[v>>2]|0,(y-t|0)<160):0){w=f[w>>2]|0;f[v>>2]=y+4;f[y>>2]=w}y=dD(a,f[s>>2]|0,g,x)|0;f[h>>2]=y;NC(z,t,f[v>>2]|0,g);if(m){a=f[m+12>>2]|0;if((a|0)==(f[m+16>>2]|0))a=Uc[f[(f[j>>2]|0)+36>>2]&127](m)|0;else a=eA(b[a>>0]|0)|0;if(cB(a,dA()|0)|0){f[c>>2]=0;e=1}else e=0}else e=1;do if(i){a=f[i+12>>2]|0;if((a|0)==(f[i+16>>2]|0))a=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else a=eA(b[a>>0]|0)|0;if(!(cB(a,dA()|0)|0))if(e)break;else{C=49;break}else{f[d>>2]=0;C=47;break}}else C=47;while(0);if((C|0)==47?e:0)C=49;if((C|0)==49)f[g>>2]=f[g>>2]|2;C=f[c>>2]|0;_K(A);_K(z);u=B;return C|0}function dD(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0;i=u;g=u=u+31&-32;u=u+16|0;if((a|0)==(b|0)){f[c>>2]=4;a=0}else{h=ox()|0;h=f[h>>2]|0;e=ox()|0;f[e>>2]=0;a=sz(a,g,d,BC()|0)|0;d=I;e=ox()|0;e=f[e>>2]|0;if(!e){j=ox()|0;f[j>>2]=h}a:do if((f[g>>2]|0)==(b|0)){do if((e|0)==34){f[c>>2]=4;if((d|0)>0|(d|0)==0&a>>>0>0){a=2147483647;break a}}else{if((d|0)<-1|(d|0)==-1&a>>>0<2147483648){f[c>>2]=4;break}if((d|0)>0|(d|0)==0&a>>>0>2147483647){f[c>>2]=4;a=2147483647;break a}else break a}while(0);a=-2147483648}else{f[c>>2]=4;a=0}while(0)}u=i;return a|0}function eD(a,c,d,e,g,h,i){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0;y=u;k=u=u+31&-32;u=u+112|0;l=(e-d|0)/12|0;if(l>>>0>100){k=dx(l)|0;if(!k)SK();else{j=k;w=k}}else{j=k;w=0}n=d;o=j;k=0;while(1){if((n|0)==(e|0))break;m=b[n+11>>0]|0;if(m<<24>>24<0)m=f[n+4>>2]|0;else m=m&255;if(!m){b[o>>0]=2;l=l+-1|0;k=k+1|0}else b[o>>0]=1;n=n+12|0;o=o+1|0}v=0;s=k;a:while(1){k=f[a>>2]|0;do if(k){m=f[k+12>>2]|0;if((m|0)==(f[k+16>>2]|0))k=Uc[f[(f[k>>2]|0)+36>>2]&127](k)|0;else k=eA(b[m>>0]|0)|0;if(cB(k,dA()|0)|0){f[a>>2]=0;o=1;break}else{o=(f[a>>2]|0)==0;break}}else o=1;while(0);m=f[c>>2]|0;if(m){k=f[m+12>>2]|0;if((k|0)==(f[m+16>>2]|0))k=Uc[f[(f[m>>2]|0)+36>>2]&127](m)|0;else k=eA(b[k>>0]|0)|0;if(cB(k,dA()|0)|0){f[c>>2]=0;m=0;k=1}else k=0}else{m=0;k=1}n=f[a>>2]|0;if(!((l|0)!=0&(o^k)))break;k=f[n+12>>2]|0;if((k|0)==(f[n+16>>2]|0))k=Uc[f[(f[n>>2]|0)+36>>2]&127](n)|0;else k=eA(b[k>>0]|0)|0;k=k&255;if(!i)k=Vc[f[(f[g>>2]|0)+12>>2]&31](g,k)|0;t=v+1|0;q=d;p=0;r=j;while(1){if((q|0)==(e|0))break;do if((b[r>>0]|0)==1){n=q+11|0;if((b[n>>0]|0)<0)m=f[q>>2]|0;else m=q;m=b[m+v>>0]|0;if(!i)m=Vc[f[(f[g>>2]|0)+12>>2]&31](g,m)|0;o=l+-1|0;if(k<<24>>24!=m<<24>>24){b[r>>0]=0;m=p;n=s;l=o;break}m=b[n>>0]|0;if(m<<24>>24<0)m=f[q+4>>2]|0;else m=m&255;if((m|0)==(t|0)){b[r>>0]=2;m=1;n=s+1|0;l=o}else{m=1;n=s}}else{m=p;n=s}while(0);q=q+12|0;p=m;r=r+1|0;s=n}if(!p){v=t;continue}k=f[a>>2]|0;m=k+12|0;n=f[m>>2]|0;if((n|0)==(f[k+16>>2]|0))Uc[f[(f[k>>2]|0)+40>>2]&127](k)|0;else{f[m>>2]=n+1;eA(b[n>>0]|0)|0}if((s+l|0)>>>0>1){n=d;o=j;k=s}else{v=t;continue}while(1){if((n|0)==(e|0)){v=t;s=k;continue a}if((b[o>>0]|0)==2){m=b[n+11>>0]|0;if(m<<24>>24<0)m=f[n+4>>2]|0;else m=m&255;if((m|0)!=(t|0)){b[o>>0]=0;k=k+-1|0}}n=n+12|0;o=o+1|0}}do if(n){k=f[n+12>>2]|0;if((k|0)==(f[n+16>>2]|0))k=Uc[f[(f[n>>2]|0)+36>>2]&127](n)|0;else k=eA(b[k>>0]|0)|0;if(cB(k,dA()|0)|0){f[a>>2]=0;l=1;break}else{l=(f[a>>2]|0)==0;break}}else l=1;while(0);do if(m){k=f[m+12>>2]|0;if((k|0)==(f[m+16>>2]|0))k=Uc[f[(f[m>>2]|0)+36>>2]&127](m)|0;else k=eA(b[k>>0]|0)|0;if(!(cB(k,dA()|0)|0))if(l)break;else{x=77;break}else{f[c>>2]=0;x=41;break}}else x=41;while(0);if((x|0)==41)if(l)x=77;if((x|0)==77)f[h>>2]=f[h>>2]|2;while(1){if((d|0)==(e|0)){x=81;break}if((b[j>>0]|0)==2)break;d=d+12|0;j=j+1|0}if((x|0)==81){f[h>>2]=f[h>>2]|4;d=e}ex(w);u=y;return d|0}function fD(a){a=a|0;eC(a);return}function gD(a){a=a|0;eC(a);QK(a);return}function hD(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0;o=u;m=u=u+31&-32;u=u+48|0;i=m+40|0;n=m+16|0;j=m+8|0;k=m+12|0;l=m+4|0;if(!(f[e+4>>2]&1)){f[j>>2]=-1;m=f[(f[a>>2]|0)+16>>2]|0;f[k>>2]=f[c>>2];f[l>>2]=f[d>>2];f[n>>2]=f[k>>2];f[i>>2]=f[l>>2];n=$c[m&63](a,n,i,e,g,j)|0;f[c>>2]=n;switch(f[j>>2]|0){case 0:{b[h>>0]=0;break}case 1:{b[h>>0]=1;break}default:{b[h>>0]=1;f[g>>2]=4}}i=f[c>>2]|0}else{dB(i,e);l=yC(i,59488)|0;zC(i);dB(i,e);a=yC(i,59496)|0;zC(i);ed[f[(f[a>>2]|0)+24>>2]&63](n,a);ed[f[(f[a>>2]|0)+28>>2]&63](n+12|0,a);f[m>>2]=f[d>>2];a=n+24|0;f[i>>2]=f[m>>2];i=(FD(c,i,n,a,l,g,1)|0)==(n|0)&1;b[h>>0]=i;i=f[c>>2]|0;do{a=a+-12|0;lL(a)}while((a|0)!=(n|0))}u=o;return i|0}function iD(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0;h=u;k=u=u+31&-32;u=u+16|0;i=k+12|0;j=k+8|0;l=k+4|0;f[l>>2]=f[b>>2];f[k>>2]=f[c>>2];f[j>>2]=f[l>>2];f[i>>2]=f[k>>2];g=ED(a,j,i,d,e,g)|0;u=h;return g|0}function jD(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0;h=u;k=u=u+31&-32;u=u+16|0;i=k+12|0;j=k+8|0;l=k+4|0;f[l>>2]=f[b>>2];f[k>>2]=f[c>>2];f[j>>2]=f[l>>2];f[i>>2]=f[k>>2];g=DD(a,j,i,d,e,g)|0;u=h;return g|0}function kD(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0;h=u;k=u=u+31&-32;u=u+16|0;i=k+12|0;j=k+8|0;l=k+4|0;f[l>>2]=f[b>>2];f[k>>2]=f[c>>2];f[j>>2]=f[l>>2];f[i>>2]=f[k>>2];g=CD(a,j,i,d,e,g)|0;u=h;return g|0}function lD(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0;h=u;k=u=u+31&-32;u=u+16|0;i=k+12|0;j=k+8|0;l=k+4|0;f[l>>2]=f[b>>2];f[k>>2]=f[c>>2];f[j>>2]=f[l>>2];f[i>>2]=f[k>>2];g=BD(a,j,i,d,e,g)|0;u=h;return g|0}function mD(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0;h=u;k=u=u+31&-32;u=u+16|0;i=k+12|0;j=k+8|0;l=k+4|0;f[l>>2]=f[b>>2];f[k>>2]=f[c>>2];f[j>>2]=f[l>>2];f[i>>2]=f[k>>2];g=AD(a,j,i,d,e,g)|0;u=h;return g|0}function nD(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0;h=u;k=u=u+31&-32;u=u+16|0;i=k+12|0;j=k+8|0;l=k+4|0;f[l>>2]=f[b>>2];f[k>>2]=f[c>>2];f[j>>2]=f[l>>2];f[i>>2]=f[k>>2];g=yD(a,j,i,d,e,g)|0;u=h;return g|0}function oD(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0;h=u;k=u=u+31&-32;u=u+16|0;i=k+12|0;j=k+8|0;l=k+4|0;f[l>>2]=f[b>>2];f[k>>2]=f[c>>2];f[j>>2]=f[l>>2];f[i>>2]=f[k>>2];g=xD(a,j,i,d,e,g)|0;u=h;return g|0}function pD(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0;h=u;k=u=u+31&-32;u=u+16|0;i=k+12|0;j=k+8|0;l=k+4|0;f[l>>2]=f[b>>2];f[k>>2]=f[c>>2];f[j>>2]=f[l>>2];f[i>>2]=f[k>>2];g=wD(a,j,i,d,e,g)|0;u=h;return g|0}function qD(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0;h=u;k=u=u+31&-32;u=u+16|0;i=k+12|0;j=k+8|0;l=k+4|0;f[l>>2]=f[b>>2];f[k>>2]=f[c>>2];f[j>>2]=f[l>>2];f[i>>2]=f[k>>2];g=tD(a,j,i,d,e,g)|0;u=h;return g|0}function rD(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0;z=u;s=u=u+31&-32;u=u+320|0;w=s;t=s+208|0;x=s+192|0;y=s+180|0;v=s+176|0;q=s+16|0;r=s+8|0;s=s+4|0;f[x>>2]=0;f[x+4>>2]=0;f[x+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[x+(a<<2)>>2]=0;a=a+1|0}dB(y,e);a=yC(y,59488)|0;Xc[f[(f[a>>2]|0)+48>>2]&7](a,53865,53891,t)|0;zC(y);f[y>>2]=0;f[y+4>>2]=0;f[y+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[y+(a<<2)>>2]=0;a=a+1|0}p=y+11|0;o=y+8|0;if((b[p>>0]|0)<0)a=(f[o>>2]&2147483647)+-1|0;else a=10;fL(y,a,0);a=(b[p>>0]|0)<0?f[y>>2]|0:y;f[v>>2]=a;f[r>>2]=q;f[s>>2]=0;n=y+4|0;j=f[c>>2]|0;i=j;a:while(1){if(i){e=f[i+12>>2]|0;if((e|0)==(f[i+16>>2]|0))e=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else e=wA(f[e>>2]|0)|0;if(eB(e,vA()|0)|0){f[c>>2]=0;m=0;j=0;k=1}else{m=i;k=0}}else{m=0;j=0;k=1}i=f[d>>2]|0;do if(i){e=f[i+12>>2]|0;if((e|0)==(f[i+16>>2]|0))e=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else e=wA(f[e>>2]|0)|0;if(!(eB(e,vA()|0)|0))if(k)break;else break a;else{f[d>>2]=0;A=22;break}}else A=22;while(0);if((A|0)==22){A=0;if(k){i=0;break}else i=0}e=b[p>>0]|0;e=e<<24>>24<0?f[n>>2]|0:e&255;if((f[v>>2]|0)==(a+e|0)){fL(y,e<<1,0);if((b[p>>0]|0)<0)a=(f[o>>2]&2147483647)+-1|0;else a=10;fL(y,a,0);a=(b[p>>0]|0)<0?f[y>>2]|0:y;f[v>>2]=a+e}k=m+12|0;e=f[k>>2]|0;l=m+16|0;if((e|0)==(f[l>>2]|0))e=Uc[f[(f[m>>2]|0)+36>>2]&127](m)|0;else e=wA(f[e>>2]|0)|0;if(sD(e,16,a,v,s,0,x,q,r,t)|0)break;e=f[k>>2]|0;if((e|0)==(f[l>>2]|0)){Uc[f[(f[m>>2]|0)+40>>2]&127](m)|0;i=m;continue}else{f[k>>2]=e+4;wA(f[e>>2]|0)|0;i=m;continue}}fL(y,(f[v>>2]|0)-a|0,0);t=(b[p>>0]|0)<0?f[y>>2]|0:y;v=BC()|0;f[w>>2]=h;if((CC(t,v,53898,w)|0)!=1)f[g>>2]=4;if(m){a=f[m+12>>2]|0;if((a|0)==(f[m+16>>2]|0))a=Uc[f[(f[j>>2]|0)+36>>2]&127](m)|0;else a=wA(f[a>>2]|0)|0;if(eB(a,vA()|0)|0){f[c>>2]=0;e=1}else e=0}else e=1;do if(i){a=f[i+12>>2]|0;if((a|0)==(f[i+16>>2]|0))a=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else a=wA(f[a>>2]|0)|0;if(!(eB(a,vA()|0)|0))if(e)break;else{A=51;break}else{f[d>>2]=0;A=49;break}}else A=49;while(0);if((A|0)==49?e:0)A=51;if((A|0)==51)f[g>>2]=f[g>>2]|2;A=f[c>>2]|0;_K(y);_K(x);u=z;return A|0}function sD(a,c,d,e,g,h,i,j,k,l){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0;o=f[e>>2]|0;p=(o|0)==(d|0);do if(p){m=(f[l+96>>2]|0)==(a|0);if(!m?(f[l+100>>2]|0)!=(a|0):0){n=5;break}f[e>>2]=d+1;b[d>>0]=m?43:45;f[g>>2]=0;m=0}else n=5;while(0);a:do if((n|0)==5){n=b[i+11>>0]|0;if((a|0)==(h|0)?((n<<24>>24<0?f[i+4>>2]|0:n&255)|0)!=0:0){m=f[k>>2]|0;if((m-j|0)>=160){m=0;break}e=f[g>>2]|0;f[k>>2]=m+4;f[m>>2]=e;f[g>>2]=0;m=0;break}i=l+104|0;h=0;while(1){m=l+(h<<2)|0;if((h|0)==26){m=i;break}if((f[m>>2]|0)==(a|0))break;else h=h+1|0}m=m-l|0;h=m>>2;if((m|0)>92)m=-1;else{i=53865+h|0;switch(c|0){case 10:case 8:{if((h|0)>=(c|0)){m=-1;break a}break}case 16:{if((m|0)>=88){if(p){m=-1;break a}if((o-d|0)>=3){m=-1;break a}if((b[o+-1>>0]|0)!=48){m=-1;break a}f[g>>2]=0;m=b[i>>0]|0;f[e>>2]=o+1;b[o>>0]=m;m=0;break a}break}default:{}}m=b[i>>0]|0;f[e>>2]=o+1;b[o>>0]=m;f[g>>2]=(f[g>>2]|0)+1;m=0}}while(0);return m|0}function tD(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0.0;E=u;r=u=u+31&-32;u=u+352|0;s=r+208|0;t=r+200|0;v=r+196|0;D=r+184|0;C=r+172|0;w=r+168|0;x=r+8|0;y=r+4|0;z=r;A=r+337|0;r=r+336|0;uD(D,e,s,t,v);f[C>>2]=0;f[C+4>>2]=0;f[C+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[C+(a<<2)>>2]=0;a=a+1|0}o=C+11|0;q=C+8|0;if((b[o>>0]|0)<0)a=(f[q>>2]&2147483647)+-1|0;else a=10;fL(C,a,0);a=(b[o>>0]|0)<0?f[C>>2]|0:C;f[w>>2]=a;f[y>>2]=x;f[z>>2]=0;b[A>>0]=1;b[r>>0]=69;n=C+4|0;j=f[c>>2]|0;i=j;a:while(1){if(i){e=f[i+12>>2]|0;if((e|0)==(f[i+16>>2]|0))e=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else e=wA(f[e>>2]|0)|0;if(eB(e,vA()|0)|0){f[c>>2]=0;m=0;j=0;k=1}else{m=i;k=0}}else{m=0;j=0;k=1}i=f[d>>2]|0;do if(i){e=f[i+12>>2]|0;if((e|0)==(f[i+16>>2]|0))e=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else e=wA(f[e>>2]|0)|0;if(!(eB(e,vA()|0)|0))if(k)break;else break a;else{f[d>>2]=0;F=19;break}}else F=19;while(0);if((F|0)==19){F=0;if(k){i=0;break}else i=0}e=b[o>>0]|0;e=e<<24>>24<0?f[n>>2]|0:e&255;if((f[w>>2]|0)==(a+e|0)){fL(C,e<<1,0);if((b[o>>0]|0)<0)a=(f[q>>2]&2147483647)+-1|0;else a=10;fL(C,a,0);a=(b[o>>0]|0)<0?f[C>>2]|0:C;f[w>>2]=a+e}k=m+12|0;e=f[k>>2]|0;l=m+16|0;if((e|0)==(f[l>>2]|0))e=Uc[f[(f[m>>2]|0)+36>>2]&127](m)|0;else e=wA(f[e>>2]|0)|0;if(vD(e,A,r,a,w,f[t>>2]|0,f[v>>2]|0,D,x,y,z,s)|0)break;e=f[k>>2]|0;if((e|0)==(f[l>>2]|0)){Uc[f[(f[m>>2]|0)+40>>2]&127](m)|0;i=m;continue}else{f[k>>2]=e+4;wA(f[e>>2]|0)|0;i=m;continue}}v=b[D+11>>0]|0;if(!((b[A>>0]|0)==0?1:((v<<24>>24<0?f[D+4>>2]|0:v&255)|0)==0)?(B=f[y>>2]|0,(B-x|0)<160):0){A=f[z>>2]|0;f[y>>2]=B+4;f[B>>2]=A}G=+MC(a,f[w>>2]|0,g);p[h>>3]=G;NC(D,x,f[y>>2]|0,g);if(m){a=f[m+12>>2]|0;if((a|0)==(f[m+16>>2]|0))a=Uc[f[(f[j>>2]|0)+36>>2]&127](m)|0;else a=wA(f[a>>2]|0)|0;if(eB(a,vA()|0)|0){f[c>>2]=0;e=1}else e=0}else e=1;do if(i){a=f[i+12>>2]|0;if((a|0)==(f[i+16>>2]|0))a=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else a=wA(f[a>>2]|0)|0;if(!(eB(a,vA()|0)|0))if(e)break;else{F=49;break}else{f[d>>2]=0;F=47;break}}else F=47;while(0);if((F|0)==47?e:0)F=49;if((F|0)==49)f[g>>2]=f[g>>2]|2;F=f[c>>2]|0;_K(C);_K(D);u=E;return F|0}function uD(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0,h=0;g=u;h=u=u+31&-32;u=u+16|0;dB(h,b);b=yC(h,59488)|0;Xc[f[(f[b>>2]|0)+48>>2]&7](b,53865,53897,c)|0;c=yC(h,59496)|0;b=Uc[f[(f[c>>2]|0)+12>>2]&127](c)|0;f[d>>2]=b;d=Uc[f[(f[c>>2]|0)+16>>2]&127](c)|0;f[e>>2]=d;ed[f[(f[c>>2]|0)+20>>2]&63](a,c);zC(h);u=g;return}function vD(a,c,d,e,g,h,i,j,k,l,m,n){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;var o=0,p=0,q=0;p=k;a:do if((a|0)==(h|0))if(b[c>>0]|0){b[c>>0]=0;d=f[g>>2]|0;f[g>>2]=d+1;b[d>>0]=46;g=b[j+11>>0]|0;if(((g<<24>>24<0?f[j+4>>2]|0:g&255)|0)!=0?(o=f[l>>2]|0,(o-p|0)<160):0){k=f[m>>2]|0;f[l>>2]=o+4;f[o>>2]=k;k=0}else k=0}else k=-1;else{if((a|0)==(i|0)?(i=b[j+11>>0]|0,(i<<24>>24<0?f[j+4>>2]|0:i&255)|0):0){if(!(b[c>>0]|0)){k=-1;break}k=f[l>>2]|0;if((k-p|0)>=160){k=0;break}g=f[m>>2]|0;f[l>>2]=k+4;f[k>>2]=g;f[m>>2]=0;k=0;break}h=n+128|0;o=0;while(1){k=n+(o<<2)|0;if((o|0)==32){k=h;break}if((f[k>>2]|0)==(a|0))break;else o=o+1|0}o=k-n|0;k=o>>2;if((o|0)<=124){h=b[53865+k>>0]|0;switch(k|0){case 24:case 25:{k=f[g>>2]|0;if((k|0)!=(e|0)?(b[k+-1>>0]&95)!=(b[d>>0]&127):0){k=-1;break a}f[g>>2]=k+1;b[k>>0]=h;k=0;break a}case 23:case 22:{b[d>>0]=80;break}default:{k=h&95;if((((k|0)==(b[d>>0]|0)?(b[d>>0]=k|128,b[c>>0]|0):0)?(b[c>>0]=0,d=b[j+11>>0]|0,(d<<24>>24<0?f[j+4>>2]|0:d&255)|0):0)?(q=f[l>>2]|0,(q-p|0)<160):0){d=f[m>>2]|0;f[l>>2]=q+4;f[q>>2]=d}}}l=f[g>>2]|0;f[g>>2]=l+1;b[l>>0]=h;if((o|0)>84)k=0;else{f[m>>2]=(f[m>>2]|0)+1;k=0}}else k=-1}while(0);return k|0}function wD(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0.0;E=u;r=u=u+31&-32;u=u+352|0;s=r+208|0;t=r+200|0;v=r+196|0;D=r+184|0;C=r+172|0;w=r+168|0;x=r+8|0;y=r+4|0;z=r;A=r+337|0;r=r+336|0;uD(D,e,s,t,v);f[C>>2]=0;f[C+4>>2]=0;f[C+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[C+(a<<2)>>2]=0;a=a+1|0}o=C+11|0;q=C+8|0;if((b[o>>0]|0)<0)a=(f[q>>2]&2147483647)+-1|0;else a=10;fL(C,a,0);a=(b[o>>0]|0)<0?f[C>>2]|0:C;f[w>>2]=a;f[y>>2]=x;f[z>>2]=0;b[A>>0]=1;b[r>>0]=69;n=C+4|0;j=f[c>>2]|0;i=j;a:while(1){if(i){e=f[i+12>>2]|0;if((e|0)==(f[i+16>>2]|0))e=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else e=wA(f[e>>2]|0)|0;if(eB(e,vA()|0)|0){f[c>>2]=0;m=0;j=0;k=1}else{m=i;k=0}}else{m=0;j=0;k=1}i=f[d>>2]|0;do if(i){e=f[i+12>>2]|0;if((e|0)==(f[i+16>>2]|0))e=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else e=wA(f[e>>2]|0)|0;if(!(eB(e,vA()|0)|0))if(k)break;else break a;else{f[d>>2]=0;F=19;break}}else F=19;while(0);if((F|0)==19){F=0;if(k){i=0;break}else i=0}e=b[o>>0]|0;e=e<<24>>24<0?f[n>>2]|0:e&255;if((f[w>>2]|0)==(a+e|0)){fL(C,e<<1,0);if((b[o>>0]|0)<0)a=(f[q>>2]&2147483647)+-1|0;else a=10;fL(C,a,0);a=(b[o>>0]|0)<0?f[C>>2]|0:C;f[w>>2]=a+e}k=m+12|0;e=f[k>>2]|0;l=m+16|0;if((e|0)==(f[l>>2]|0))e=Uc[f[(f[m>>2]|0)+36>>2]&127](m)|0;else e=wA(f[e>>2]|0)|0;if(vD(e,A,r,a,w,f[t>>2]|0,f[v>>2]|0,D,x,y,z,s)|0)break;e=f[k>>2]|0;if((e|0)==(f[l>>2]|0)){Uc[f[(f[m>>2]|0)+40>>2]&127](m)|0;i=m;continue}else{f[k>>2]=e+4;wA(f[e>>2]|0)|0;i=m;continue}}v=b[D+11>>0]|0;if(!((b[A>>0]|0)==0?1:((v<<24>>24<0?f[D+4>>2]|0:v&255)|0)==0)?(B=f[y>>2]|0,(B-x|0)<160):0){A=f[z>>2]|0;f[y>>2]=B+4;f[B>>2]=A}G=+PC(a,f[w>>2]|0,g);p[h>>3]=G;NC(D,x,f[y>>2]|0,g);if(m){a=f[m+12>>2]|0;if((a|0)==(f[m+16>>2]|0))a=Uc[f[(f[j>>2]|0)+36>>2]&127](m)|0;else a=wA(f[a>>2]|0)|0;if(eB(a,vA()|0)|0){f[c>>2]=0;e=1}else e=0}else e=1;do if(i){a=f[i+12>>2]|0;if((a|0)==(f[i+16>>2]|0))a=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else a=wA(f[a>>2]|0)|0;if(!(eB(a,vA()|0)|0))if(e)break;else{F=49;break}else{f[d>>2]=0;F=47;break}}else F=47;while(0);if((F|0)==47?e:0)F=49;if((F|0)==49)f[g>>2]=f[g>>2]|2;F=f[c>>2]|0;_K(C);_K(D);u=E;return F|0}function xD(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0.0;E=u;r=u=u+31&-32;u=u+352|0;s=r+208|0;t=r+200|0;v=r+196|0;D=r+184|0;C=r+172|0;w=r+168|0;x=r+8|0;y=r+4|0;z=r;A=r+337|0;r=r+336|0;uD(D,e,s,t,v);f[C>>2]=0;f[C+4>>2]=0;f[C+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[C+(a<<2)>>2]=0;a=a+1|0}p=C+11|0;q=C+8|0;if((b[p>>0]|0)<0)a=(f[q>>2]&2147483647)+-1|0;else a=10;fL(C,a,0);a=(b[p>>0]|0)<0?f[C>>2]|0:C;f[w>>2]=a;f[y>>2]=x;f[z>>2]=0;b[A>>0]=1;b[r>>0]=69;o=C+4|0;j=f[c>>2]|0;i=j;a:while(1){if(i){e=f[i+12>>2]|0;if((e|0)==(f[i+16>>2]|0))e=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else e=wA(f[e>>2]|0)|0;if(eB(e,vA()|0)|0){f[c>>2]=0;m=0;j=0;k=1}else{m=i;k=0}}else{m=0;j=0;k=1}i=f[d>>2]|0;do if(i){e=f[i+12>>2]|0;if((e|0)==(f[i+16>>2]|0))e=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else e=wA(f[e>>2]|0)|0;if(!(eB(e,vA()|0)|0))if(k)break;else break a;else{f[d>>2]=0;F=19;break}}else F=19;while(0);if((F|0)==19){F=0;if(k){i=0;break}else i=0}e=b[p>>0]|0;e=e<<24>>24<0?f[o>>2]|0:e&255;if((f[w>>2]|0)==(a+e|0)){fL(C,e<<1,0);if((b[p>>0]|0)<0)a=(f[q>>2]&2147483647)+-1|0;else a=10;fL(C,a,0);a=(b[p>>0]|0)<0?f[C>>2]|0:C;f[w>>2]=a+e}k=m+12|0;e=f[k>>2]|0;l=m+16|0;if((e|0)==(f[l>>2]|0))e=Uc[f[(f[m>>2]|0)+36>>2]&127](m)|0;else e=wA(f[e>>2]|0)|0;if(vD(e,A,r,a,w,f[t>>2]|0,f[v>>2]|0,D,x,y,z,s)|0)break;e=f[k>>2]|0;if((e|0)==(f[l>>2]|0)){Uc[f[(f[m>>2]|0)+40>>2]&127](m)|0;i=m;continue}else{f[k>>2]=e+4;wA(f[e>>2]|0)|0;i=m;continue}}v=b[D+11>>0]|0;if(!((b[A>>0]|0)==0?1:((v<<24>>24<0?f[D+4>>2]|0:v&255)|0)==0)?(B=f[y>>2]|0,(B-x|0)<160):0){A=f[z>>2]|0;f[y>>2]=B+4;f[B>>2]=A}G=+RC(a,f[w>>2]|0,g);n[h>>2]=G;NC(D,x,f[y>>2]|0,g);if(m){a=f[m+12>>2]|0;if((a|0)==(f[m+16>>2]|0))a=Uc[f[(f[j>>2]|0)+36>>2]&127](m)|0;else a=wA(f[a>>2]|0)|0;if(eB(a,vA()|0)|0){f[c>>2]=0;e=1}else e=0}else e=1;do if(i){a=f[i+12>>2]|0;if((a|0)==(f[i+16>>2]|0))a=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else a=wA(f[a>>2]|0)|0;if(!(eB(a,vA()|0)|0))if(e)break;else{F=49;break}else{f[d>>2]=0;F=47;break}}else F=47;while(0);if((F|0)==47?e:0)F=49;if((F|0)==49)f[g>>2]=f[g>>2]|2;F=f[c>>2]|0;_K(C);_K(D);u=E;return F|0}function yD(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;B=u;w=u=u+31&-32;u=u+304|0;q=w+200|0;r=w+196|0;z=w+184|0;A=w+172|0;s=w+168|0;t=w+8|0;v=w+4|0;x=TC(e)|0;zD(z,e,q,r);f[A>>2]=0;f[A+4>>2]=0;f[A+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[A+(a<<2)>>2]=0;a=a+1|0}o=A+11|0;p=A+8|0;if((b[o>>0]|0)<0)a=(f[p>>2]&2147483647)+-1|0;else a=10;fL(A,a,0);a=(b[o>>0]|0)<0?f[A>>2]|0:A;f[s>>2]=a;f[v>>2]=t;f[w>>2]=0;n=A+4|0;j=f[c>>2]|0;i=j;a:while(1){if(i){e=f[i+12>>2]|0;if((e|0)==(f[i+16>>2]|0))e=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else e=wA(f[e>>2]|0)|0;if(eB(e,vA()|0)|0){f[c>>2]=0;m=0;j=0;k=1}else{m=i;k=0}}else{m=0;j=0;k=1}i=f[d>>2]|0;do if(i){e=f[i+12>>2]|0;if((e|0)==(f[i+16>>2]|0))e=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else e=wA(f[e>>2]|0)|0;if(!(eB(e,vA()|0)|0))if(k)break;else break a;else{f[d>>2]=0;C=19;break}}else C=19;while(0);if((C|0)==19){C=0;if(k){i=0;break}else i=0}e=b[o>>0]|0;e=e<<24>>24<0?f[n>>2]|0:e&255;if((f[s>>2]|0)==(a+e|0)){fL(A,e<<1,0);if((b[o>>0]|0)<0)a=(f[p>>2]&2147483647)+-1|0;else a=10;fL(A,a,0);a=(b[o>>0]|0)<0?f[A>>2]|0:A;f[s>>2]=a+e}k=m+12|0;e=f[k>>2]|0;l=m+16|0;if((e|0)==(f[l>>2]|0))e=Uc[f[(f[m>>2]|0)+36>>2]&127](m)|0;else e=wA(f[e>>2]|0)|0;if(sD(e,x,a,s,w,f[r>>2]|0,z,t,v,q)|0)break;e=f[k>>2]|0;if((e|0)==(f[l>>2]|0)){Uc[f[(f[m>>2]|0)+40>>2]&127](m)|0;i=m;continue}else{f[k>>2]=e+4;wA(f[e>>2]|0)|0;i=m;continue}}r=b[z+11>>0]|0;if((r<<24>>24<0?f[z+4>>2]|0:r&255)|0?(y=f[v>>2]|0,(y-t|0)<160):0){w=f[w>>2]|0;f[v>>2]=y+4;f[y>>2]=w}y=VC(a,f[s>>2]|0,g,x)|0;f[h>>2]=y;f[h+4>>2]=I;NC(z,t,f[v>>2]|0,g);if(m){a=f[m+12>>2]|0;if((a|0)==(f[m+16>>2]|0))a=Uc[f[(f[j>>2]|0)+36>>2]&127](m)|0;else a=wA(f[a>>2]|0)|0;if(eB(a,vA()|0)|0){f[c>>2]=0;e=1}else e=0}else e=1;do if(i){a=f[i+12>>2]|0;if((a|0)==(f[i+16>>2]|0))a=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else a=wA(f[a>>2]|0)|0;if(!(eB(a,vA()|0)|0))if(e)break;else{C=49;break}else{f[d>>2]=0;C=47;break}}else C=47;while(0);if((C|0)==47?e:0)C=49;if((C|0)==49)f[g>>2]=f[g>>2]|2;C=f[c>>2]|0;_K(A);_K(z);u=B;return C|0}function zD(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0;e=u;g=u=u+31&-32;u=u+16|0;dB(g,b);b=yC(g,59488)|0;Xc[f[(f[b>>2]|0)+48>>2]&7](b,53865,53891,c)|0;c=yC(g,59496)|0;b=Uc[f[(f[c>>2]|0)+16>>2]&127](c)|0;f[d>>2]=b;ed[f[(f[c>>2]|0)+20>>2]&63](a,c);zC(g);u=e;return}function AD(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;B=u;w=u=u+31&-32;u=u+304|0;q=w+200|0;r=w+196|0;z=w+184|0;A=w+172|0;s=w+168|0;t=w+8|0;v=w+4|0;x=TC(e)|0;zD(z,e,q,r);f[A>>2]=0;f[A+4>>2]=0;f[A+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[A+(a<<2)>>2]=0;a=a+1|0}o=A+11|0;p=A+8|0;if((b[o>>0]|0)<0)a=(f[p>>2]&2147483647)+-1|0;else a=10;fL(A,a,0);a=(b[o>>0]|0)<0?f[A>>2]|0:A;f[s>>2]=a;f[v>>2]=t;f[w>>2]=0;n=A+4|0;j=f[c>>2]|0;i=j;a:while(1){if(i){e=f[i+12>>2]|0;if((e|0)==(f[i+16>>2]|0))e=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else e=wA(f[e>>2]|0)|0;if(eB(e,vA()|0)|0){f[c>>2]=0;m=0;j=0;k=1}else{m=i;k=0}}else{m=0;j=0;k=1}i=f[d>>2]|0;do if(i){e=f[i+12>>2]|0;if((e|0)==(f[i+16>>2]|0))e=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else e=wA(f[e>>2]|0)|0;if(!(eB(e,vA()|0)|0))if(k)break;else break a;else{f[d>>2]=0;C=19;break}}else C=19;while(0);if((C|0)==19){C=0;if(k){i=0;break}else i=0}e=b[o>>0]|0;e=e<<24>>24<0?f[n>>2]|0:e&255;if((f[s>>2]|0)==(a+e|0)){fL(A,e<<1,0);if((b[o>>0]|0)<0)a=(f[p>>2]&2147483647)+-1|0;else a=10;fL(A,a,0);a=(b[o>>0]|0)<0?f[A>>2]|0:A;f[s>>2]=a+e}k=m+12|0;e=f[k>>2]|0;l=m+16|0;if((e|0)==(f[l>>2]|0))e=Uc[f[(f[m>>2]|0)+36>>2]&127](m)|0;else e=wA(f[e>>2]|0)|0;if(sD(e,x,a,s,w,f[r>>2]|0,z,t,v,q)|0)break;e=f[k>>2]|0;if((e|0)==(f[l>>2]|0)){Uc[f[(f[m>>2]|0)+40>>2]&127](m)|0;i=m;continue}else{f[k>>2]=e+4;wA(f[e>>2]|0)|0;i=m;continue}}r=b[z+11>>0]|0;if((r<<24>>24<0?f[z+4>>2]|0:r&255)|0?(y=f[v>>2]|0,(y-t|0)<160):0){w=f[w>>2]|0;f[v>>2]=y+4;f[y>>2]=w}y=XC(a,f[s>>2]|0,g,x)|0;f[h>>2]=y;NC(z,t,f[v>>2]|0,g);if(m){a=f[m+12>>2]|0;if((a|0)==(f[m+16>>2]|0))a=Uc[f[(f[j>>2]|0)+36>>2]&127](m)|0;else a=wA(f[a>>2]|0)|0;if(eB(a,vA()|0)|0){f[c>>2]=0;e=1}else e=0}else e=1;do if(i){a=f[i+12>>2]|0;if((a|0)==(f[i+16>>2]|0))a=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else a=wA(f[a>>2]|0)|0;if(!(eB(a,vA()|0)|0))if(e)break;else{C=49;break}else{f[d>>2]=0;C=47;break}}else C=47;while(0);if((C|0)==47?e:0)C=49;if((C|0)==49)f[g>>2]=f[g>>2]|2;C=f[c>>2]|0;_K(A);_K(z);u=B;return C|0}function BD(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;B=u;w=u=u+31&-32;u=u+304|0;q=w+200|0;r=w+196|0;z=w+184|0;A=w+172|0;s=w+168|0;t=w+8|0;v=w+4|0;x=TC(e)|0;zD(z,e,q,r);f[A>>2]=0;f[A+4>>2]=0;f[A+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[A+(a<<2)>>2]=0;a=a+1|0}o=A+11|0;p=A+8|0;if((b[o>>0]|0)<0)a=(f[p>>2]&2147483647)+-1|0;else a=10;fL(A,a,0);a=(b[o>>0]|0)<0?f[A>>2]|0:A;f[s>>2]=a;f[v>>2]=t;f[w>>2]=0;n=A+4|0;j=f[c>>2]|0;i=j;a:while(1){if(i){e=f[i+12>>2]|0;if((e|0)==(f[i+16>>2]|0))e=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else e=wA(f[e>>2]|0)|0;if(eB(e,vA()|0)|0){f[c>>2]=0;m=0;j=0;k=1}else{m=i;k=0}}else{m=0;j=0;k=1}i=f[d>>2]|0;do if(i){e=f[i+12>>2]|0;if((e|0)==(f[i+16>>2]|0))e=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else e=wA(f[e>>2]|0)|0;if(!(eB(e,vA()|0)|0))if(k)break;else break a;else{f[d>>2]=0;C=19;break}}else C=19;while(0);if((C|0)==19){C=0;if(k){i=0;break}else i=0}e=b[o>>0]|0;e=e<<24>>24<0?f[n>>2]|0:e&255;if((f[s>>2]|0)==(a+e|0)){fL(A,e<<1,0);if((b[o>>0]|0)<0)a=(f[p>>2]&2147483647)+-1|0;else a=10;fL(A,a,0);a=(b[o>>0]|0)<0?f[A>>2]|0:A;f[s>>2]=a+e}k=m+12|0;e=f[k>>2]|0;l=m+16|0;if((e|0)==(f[l>>2]|0))e=Uc[f[(f[m>>2]|0)+36>>2]&127](m)|0;else e=wA(f[e>>2]|0)|0;if(sD(e,x,a,s,w,f[r>>2]|0,z,t,v,q)|0)break;e=f[k>>2]|0;if((e|0)==(f[l>>2]|0)){Uc[f[(f[m>>2]|0)+40>>2]&127](m)|0;i=m;continue}else{f[k>>2]=e+4;wA(f[e>>2]|0)|0;i=m;continue}}r=b[z+11>>0]|0;if((r<<24>>24<0?f[z+4>>2]|0:r&255)|0?(y=f[v>>2]|0,(y-t|0)<160):0){w=f[w>>2]|0;f[v>>2]=y+4;f[y>>2]=w}y=ZC(a,f[s>>2]|0,g,x)|0;f[h>>2]=y;NC(z,t,f[v>>2]|0,g);if(m){a=f[m+12>>2]|0;if((a|0)==(f[m+16>>2]|0))a=Uc[f[(f[j>>2]|0)+36>>2]&127](m)|0;else a=wA(f[a>>2]|0)|0;if(eB(a,vA()|0)|0){f[c>>2]=0;e=1}else e=0}else e=1;do if(i){a=f[i+12>>2]|0;if((a|0)==(f[i+16>>2]|0))a=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else a=wA(f[a>>2]|0)|0;if(!(eB(a,vA()|0)|0))if(e)break;else{C=49;break}else{f[d>>2]=0;C=47;break}}else C=47;while(0);if((C|0)==47?e:0)C=49;if((C|0)==49)f[g>>2]=f[g>>2]|2;C=f[c>>2]|0;_K(A);_K(z);u=B;return C|0}function CD(a,c,e,g,h,i){a=a|0;c=c|0;e=e|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;C=u;x=u=u+31&-32;u=u+304|0;r=x+200|0;s=x+196|0;A=x+184|0;B=x+172|0;t=x+168|0;v=x+8|0;w=x+4|0;y=TC(g)|0;zD(A,g,r,s);f[B>>2]=0;f[B+4>>2]=0;f[B+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[B+(a<<2)>>2]=0;a=a+1|0}p=B+11|0;q=B+8|0;if((b[p>>0]|0)<0)a=(f[q>>2]&2147483647)+-1|0;else a=10;fL(B,a,0);a=(b[p>>0]|0)<0?f[B>>2]|0:B;f[t>>2]=a;f[w>>2]=v;f[x>>2]=0;o=B+4|0;k=f[c>>2]|0;j=k;a:while(1){if(j){g=f[j+12>>2]|0;if((g|0)==(f[j+16>>2]|0))g=Uc[f[(f[j>>2]|0)+36>>2]&127](j)|0;else g=wA(f[g>>2]|0)|0;if(eB(g,vA()|0)|0){f[c>>2]=0;n=0;k=0;l=1}else{n=j;l=0}}else{n=0;k=0;l=1}j=f[e>>2]|0;do if(j){g=f[j+12>>2]|0;if((g|0)==(f[j+16>>2]|0))g=Uc[f[(f[j>>2]|0)+36>>2]&127](j)|0;else g=wA(f[g>>2]|0)|0;if(!(eB(g,vA()|0)|0))if(l)break;else break a;else{f[e>>2]=0;D=19;break}}else D=19;while(0);if((D|0)==19){D=0;if(l){j=0;break}else j=0}g=b[p>>0]|0;g=g<<24>>24<0?f[o>>2]|0:g&255;if((f[t>>2]|0)==(a+g|0)){fL(B,g<<1,0);if((b[p>>0]|0)<0)a=(f[q>>2]&2147483647)+-1|0;else a=10;fL(B,a,0);a=(b[p>>0]|0)<0?f[B>>2]|0:B;f[t>>2]=a+g}l=n+12|0;g=f[l>>2]|0;m=n+16|0;if((g|0)==(f[m>>2]|0))g=Uc[f[(f[n>>2]|0)+36>>2]&127](n)|0;else g=wA(f[g>>2]|0)|0;if(sD(g,y,a,t,x,f[s>>2]|0,A,v,w,r)|0)break;g=f[l>>2]|0;if((g|0)==(f[m>>2]|0)){Uc[f[(f[n>>2]|0)+40>>2]&127](n)|0;j=n;continue}else{f[l>>2]=g+4;wA(f[g>>2]|0)|0;j=n;continue}}s=b[A+11>>0]|0;if((s<<24>>24<0?f[A+4>>2]|0:s&255)|0?(z=f[w>>2]|0,(z-v|0)<160):0){x=f[x>>2]|0;f[w>>2]=z+4;f[z>>2]=x}z=$C(a,f[t>>2]|0,h,y)|0;d[i>>1]=z;NC(A,v,f[w>>2]|0,h);if(n){a=f[n+12>>2]|0;if((a|0)==(f[n+16>>2]|0))a=Uc[f[(f[k>>2]|0)+36>>2]&127](n)|0;else a=wA(f[a>>2]|0)|0;if(eB(a,vA()|0)|0){f[c>>2]=0;g=1}else g=0}else g=1;do if(j){a=f[j+12>>2]|0;if((a|0)==(f[j+16>>2]|0))a=Uc[f[(f[j>>2]|0)+36>>2]&127](j)|0;else a=wA(f[a>>2]|0)|0;if(!(eB(a,vA()|0)|0))if(g)break;else{D=49;break}else{f[e>>2]=0;D=47;break}}else D=47;while(0);if((D|0)==47?g:0)D=49;if((D|0)==49)f[h>>2]=f[h>>2]|2;D=f[c>>2]|0;_K(B);_K(A);u=C;return D|0}function DD(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;B=u;w=u=u+31&-32;u=u+304|0;q=w+200|0;r=w+196|0;z=w+184|0;A=w+172|0;s=w+168|0;t=w+8|0;v=w+4|0;x=TC(e)|0;zD(z,e,q,r);f[A>>2]=0;f[A+4>>2]=0;f[A+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[A+(a<<2)>>2]=0;a=a+1|0}o=A+11|0;p=A+8|0;if((b[o>>0]|0)<0)a=(f[p>>2]&2147483647)+-1|0;else a=10;fL(A,a,0);a=(b[o>>0]|0)<0?f[A>>2]|0:A;f[s>>2]=a;f[v>>2]=t;f[w>>2]=0;n=A+4|0;j=f[c>>2]|0;i=j;a:while(1){if(i){e=f[i+12>>2]|0;if((e|0)==(f[i+16>>2]|0))e=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else e=wA(f[e>>2]|0)|0;if(eB(e,vA()|0)|0){f[c>>2]=0;m=0;j=0;k=1}else{m=i;k=0}}else{m=0;j=0;k=1}i=f[d>>2]|0;do if(i){e=f[i+12>>2]|0;if((e|0)==(f[i+16>>2]|0))e=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else e=wA(f[e>>2]|0)|0;if(!(eB(e,vA()|0)|0))if(k)break;else break a;else{f[d>>2]=0;C=19;break}}else C=19;while(0);if((C|0)==19){C=0;if(k){i=0;break}else i=0}e=b[o>>0]|0;e=e<<24>>24<0?f[n>>2]|0:e&255;if((f[s>>2]|0)==(a+e|0)){fL(A,e<<1,0);if((b[o>>0]|0)<0)a=(f[p>>2]&2147483647)+-1|0;else a=10;fL(A,a,0);a=(b[o>>0]|0)<0?f[A>>2]|0:A;f[s>>2]=a+e}k=m+12|0;e=f[k>>2]|0;l=m+16|0;if((e|0)==(f[l>>2]|0))e=Uc[f[(f[m>>2]|0)+36>>2]&127](m)|0;else e=wA(f[e>>2]|0)|0;if(sD(e,x,a,s,w,f[r>>2]|0,z,t,v,q)|0)break;e=f[k>>2]|0;if((e|0)==(f[l>>2]|0)){Uc[f[(f[m>>2]|0)+40>>2]&127](m)|0;i=m;continue}else{f[k>>2]=e+4;wA(f[e>>2]|0)|0;i=m;continue}}r=b[z+11>>0]|0;if((r<<24>>24<0?f[z+4>>2]|0:r&255)|0?(y=f[v>>2]|0,(y-t|0)<160):0){w=f[w>>2]|0;f[v>>2]=y+4;f[y>>2]=w}y=bD(a,f[s>>2]|0,g,x)|0;f[h>>2]=y;f[h+4>>2]=I;NC(z,t,f[v>>2]|0,g);if(m){a=f[m+12>>2]|0;if((a|0)==(f[m+16>>2]|0))a=Uc[f[(f[j>>2]|0)+36>>2]&127](m)|0;else a=wA(f[a>>2]|0)|0;if(eB(a,vA()|0)|0){f[c>>2]=0;e=1}else e=0}else e=1;do if(i){a=f[i+12>>2]|0;if((a|0)==(f[i+16>>2]|0))a=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else a=wA(f[a>>2]|0)|0;if(!(eB(a,vA()|0)|0))if(e)break;else{C=49;break}else{f[d>>2]=0;C=47;break}}else C=47;while(0);if((C|0)==47?e:0)C=49;if((C|0)==49)f[g>>2]=f[g>>2]|2;C=f[c>>2]|0;_K(A);_K(z);u=B;return C|0}function ED(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;B=u;w=u=u+31&-32;u=u+304|0;q=w+200|0;r=w+196|0;z=w+184|0;A=w+172|0;s=w+168|0;t=w+8|0;v=w+4|0;x=TC(e)|0;zD(z,e,q,r);f[A>>2]=0;f[A+4>>2]=0;f[A+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[A+(a<<2)>>2]=0;a=a+1|0}o=A+11|0;p=A+8|0;if((b[o>>0]|0)<0)a=(f[p>>2]&2147483647)+-1|0;else a=10;fL(A,a,0);a=(b[o>>0]|0)<0?f[A>>2]|0:A;f[s>>2]=a;f[v>>2]=t;f[w>>2]=0;n=A+4|0;j=f[c>>2]|0;i=j;a:while(1){if(i){e=f[i+12>>2]|0;if((e|0)==(f[i+16>>2]|0))e=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else e=wA(f[e>>2]|0)|0;if(eB(e,vA()|0)|0){f[c>>2]=0;m=0;j=0;k=1}else{m=i;k=0}}else{m=0;j=0;k=1}i=f[d>>2]|0;do if(i){e=f[i+12>>2]|0;if((e|0)==(f[i+16>>2]|0))e=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else e=wA(f[e>>2]|0)|0;if(!(eB(e,vA()|0)|0))if(k)break;else break a;else{f[d>>2]=0;C=19;break}}else C=19;while(0);if((C|0)==19){C=0;if(k){i=0;break}else i=0}e=b[o>>0]|0;e=e<<24>>24<0?f[n>>2]|0:e&255;if((f[s>>2]|0)==(a+e|0)){fL(A,e<<1,0);if((b[o>>0]|0)<0)a=(f[p>>2]&2147483647)+-1|0;else a=10;fL(A,a,0);a=(b[o>>0]|0)<0?f[A>>2]|0:A;f[s>>2]=a+e}k=m+12|0;e=f[k>>2]|0;l=m+16|0;if((e|0)==(f[l>>2]|0))e=Uc[f[(f[m>>2]|0)+36>>2]&127](m)|0;else e=wA(f[e>>2]|0)|0;if(sD(e,x,a,s,w,f[r>>2]|0,z,t,v,q)|0)break;e=f[k>>2]|0;if((e|0)==(f[l>>2]|0)){Uc[f[(f[m>>2]|0)+40>>2]&127](m)|0;i=m;continue}else{f[k>>2]=e+4;wA(f[e>>2]|0)|0;i=m;continue}}r=b[z+11>>0]|0;if((r<<24>>24<0?f[z+4>>2]|0:r&255)|0?(y=f[v>>2]|0,(y-t|0)<160):0){w=f[w>>2]|0;f[v>>2]=y+4;f[y>>2]=w}y=dD(a,f[s>>2]|0,g,x)|0;f[h>>2]=y;NC(z,t,f[v>>2]|0,g);if(m){a=f[m+12>>2]|0;if((a|0)==(f[m+16>>2]|0))a=Uc[f[(f[j>>2]|0)+36>>2]&127](m)|0;else a=wA(f[a>>2]|0)|0;if(eB(a,vA()|0)|0){f[c>>2]=0;e=1}else e=0}else e=1;do if(i){a=f[i+12>>2]|0;if((a|0)==(f[i+16>>2]|0))a=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else a=wA(f[a>>2]|0)|0;if(!(eB(a,vA()|0)|0))if(e)break;else{C=49;break}else{f[d>>2]=0;C=47;break}}else C=47;while(0);if((C|0)==47?e:0)C=49;if((C|0)==49)f[g>>2]=f[g>>2]|2;C=f[c>>2]|0;_K(A);_K(z);u=B;return C|0}function FD(a,c,d,e,g,h,i){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0;y=u;k=u=u+31&-32;u=u+112|0;l=(e-d|0)/12|0;if(l>>>0>100){k=dx(l)|0;if(!k)SK();else{j=k;w=k}}else{j=k;w=0}k=0;n=d;o=j;while(1){if((n|0)==(e|0))break;m=b[n+8+3>>0]|0;if(m<<24>>24<0)m=f[n+4>>2]|0;else m=m&255;if(!m){b[o>>0]=2;k=k+1|0;l=l+-1|0}else b[o>>0]=1;n=n+12|0;o=o+1|0}v=0;s=k;a:while(1){k=f[a>>2]|0;do if(k){m=f[k+12>>2]|0;if((m|0)==(f[k+16>>2]|0))k=Uc[f[(f[k>>2]|0)+36>>2]&127](k)|0;else k=wA(f[m>>2]|0)|0;if(eB(k,vA()|0)|0){f[a>>2]=0;o=1;break}else{o=(f[a>>2]|0)==0;break}}else o=1;while(0);m=f[c>>2]|0;if(m){k=f[m+12>>2]|0;if((k|0)==(f[m+16>>2]|0))k=Uc[f[(f[m>>2]|0)+36>>2]&127](m)|0;else k=wA(f[k>>2]|0)|0;if(eB(k,vA()|0)|0){f[c>>2]=0;m=0;k=1}else k=0}else{m=0;k=1}n=f[a>>2]|0;if(!((l|0)!=0&(o^k)))break;k=f[n+12>>2]|0;if((k|0)==(f[n+16>>2]|0))k=Uc[f[(f[n>>2]|0)+36>>2]&127](n)|0;else k=wA(f[k>>2]|0)|0;if(!i)k=Vc[f[(f[g>>2]|0)+28>>2]&31](g,k)|0;t=v+1|0;q=d;p=0;r=j;while(1){if((q|0)==(e|0))break;do if((b[r>>0]|0)==1){n=q+8+3|0;if((b[n>>0]|0)<0)m=f[q>>2]|0;else m=q;m=f[m+(v<<2)>>2]|0;if(!i)m=Vc[f[(f[g>>2]|0)+28>>2]&31](g,m)|0;o=l+-1|0;if((k|0)!=(m|0)){b[r>>0]=0;m=p;n=s;l=o;break}m=b[n>>0]|0;if(m<<24>>24<0)m=f[q+4>>2]|0;else m=m&255;if((m|0)==(t|0)){b[r>>0]=2;m=1;n=s+1|0;l=o}else{m=1;n=s}}else{m=p;n=s}while(0);q=q+12|0;p=m;r=r+1|0;s=n}if(!p){v=t;continue}k=f[a>>2]|0;m=k+12|0;n=f[m>>2]|0;if((n|0)==(f[k+16>>2]|0))Uc[f[(f[k>>2]|0)+40>>2]&127](k)|0;else{f[m>>2]=n+4;wA(f[n>>2]|0)|0}if((s+l|0)>>>0>1){n=d;o=j;k=s}else{v=t;continue}while(1){if((n|0)==(e|0)){v=t;s=k;continue a}if((b[o>>0]|0)==2){m=b[n+8+3>>0]|0;if(m<<24>>24<0)m=f[n+4>>2]|0;else m=m&255;if((m|0)!=(t|0)){b[o>>0]=0;k=k+-1|0}}n=n+12|0;o=o+1|0}}do if(n){k=f[n+12>>2]|0;if((k|0)==(f[n+16>>2]|0))k=Uc[f[(f[n>>2]|0)+36>>2]&127](n)|0;else k=wA(f[k>>2]|0)|0;if(eB(k,vA()|0)|0){f[a>>2]=0;l=1;break}else{l=(f[a>>2]|0)==0;break}}else l=1;while(0);do if(m){k=f[m+12>>2]|0;if((k|0)==(f[m+16>>2]|0))k=Uc[f[(f[m>>2]|0)+36>>2]&127](m)|0;else k=wA(f[k>>2]|0)|0;if(!(eB(k,vA()|0)|0))if(l)break;else{x=77;break}else{f[c>>2]=0;x=41;break}}else x=41;while(0);if((x|0)==41)if(l)x=77;if((x|0)==77)f[h>>2]=f[h>>2]|2;while(1){if((d|0)==(e|0)){x=81;break}if((b[j>>0]|0)==2)break;d=d+12|0;j=j+1|0}if((x|0)==81){f[h>>2]=f[h>>2]|4;d=e}ex(w);u=y;return d|0}function GD(a){a=a|0;eC(a);return}function HD(a){a=a|0;eC(a);QK(a);return}function ID(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0;l=u;h=u=u+31&-32;u=u+16|0;k=h+4|0;if(!(f[d+4>>2]&1)){j=f[(f[a>>2]|0)+24>>2]|0;f[h>>2]=f[c>>2];f[k>>2]=f[h>>2];a=Zc[j&31](a,k,d,e,g&1)|0}else{dB(k,d);a=yC(k,59472)|0;zC(k);d=f[a>>2]|0;if(g)ed[f[d+24>>2]&63](k,a);else ed[f[d+28>>2]&63](k,a);i=k+11|0;a=b[i>>0]|0;if(a<<24>>24<0){d=a;a=f[k>>2]|0;j=8}else g=k;while(1){if((j|0)==8){g=a;a=d}j=a<<24>>24<0;if((g|0)==((j?f[k>>2]|0:k)+(j?f[k+4>>2]|0:a&255)|0))break;a=b[g>>0]|0;d=f[c>>2]|0;if(d|0){e=d+24|0;h=f[e>>2]|0;if((h|0)==(f[d+28>>2]|0)){j=f[(f[d>>2]|0)+52>>2]|0;a=eA(a)|0;a=Vc[j&31](d,a)|0}else{f[e>>2]=h+1;b[h>>0]=a;a=eA(a)|0}if(cB(a,dA()|0)|0)f[c>>2]=0}d=b[i>>0]|0;a=g+1|0;j=8}a=f[c>>2]|0;_K(k)}u=l;return a|0}function JD(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;a=u;j=u=u+31&-32;u=u+64|0;i=j;m=j+52|0;n=j+39|0;h=j+16|0;l=j+12|0;k=j+4|0;j=j+8|0;b[m>>0]=b[54119]|0;b[m+1>>0]=b[54120]|0;b[m+2>>0]=b[54121]|0;b[m+3>>0]=b[54122]|0;b[m+4>>0]=b[54123]|0;b[m+5>>0]=b[54124]|0;VD(m+1|0,54125,1,f[d+4>>2]|0);o=BC()|0;f[i>>2]=g;g=n+(QD(n,13,o,m,i)|0)|0;m=RD(n,g,d)|0;dB(i,d);WD(n,m,g,h,l,k,i);zC(i);f[j>>2]=f[c>>2];c=f[l>>2]|0;g=f[k>>2]|0;f[i>>2]=f[j>>2];g=ge(i,h,c,g,d,e)|0;u=a;return g|0}function KD(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;a=u;j=u=u+31&-32;u=u+96|0;i=j+8|0;n=j;m=j+71|0;h=j+28|0;l=j+24|0;k=j+16|0;j=j+20|0;o=n;f[o>>2]=37;f[o+4>>2]=0;VD(n+1|0,54116,1,f[c+4>>2]|0);o=BC()|0;p=i;f[p>>2]=e;f[p+4>>2]=g;e=m+(QD(m,23,o,n,i)|0)|0;g=RD(m,e,c)|0;dB(i,c);WD(m,g,e,h,l,k,i);zC(i);f[j>>2]=f[b>>2];e=f[l>>2]|0;g=f[k>>2]|0;f[i>>2]=f[j>>2];g=ge(i,h,e,g,c,d)|0;u=a;return g|0}function LD(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;a=u;j=u=u+31&-32;u=u+64|0;i=j;m=j+52|0;n=j+40|0;h=j+16|0;l=j+12|0;k=j+4|0;j=j+8|0;b[m>>0]=b[54119]|0;b[m+1>>0]=b[54120]|0;b[m+2>>0]=b[54121]|0;b[m+3>>0]=b[54122]|0;b[m+4>>0]=b[54123]|0;b[m+5>>0]=b[54124]|0;VD(m+1|0,54125,0,f[d+4>>2]|0);o=BC()|0;f[i>>2]=g;g=n+(QD(n,12,o,m,i)|0)|0;m=RD(n,g,d)|0;dB(i,d);WD(n,m,g,h,l,k,i);zC(i);f[j>>2]=f[c>>2];c=f[l>>2]|0;g=f[k>>2]|0;f[i>>2]=f[j>>2];g=ge(i,h,c,g,d,e)|0;u=a;return g|0}function MD(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;a=u;j=u=u+31&-32;u=u+96|0;i=j+8|0;n=j;m=j+71|0;h=j+28|0;l=j+24|0;k=j+16|0;j=j+20|0;o=n;f[o>>2]=37;f[o+4>>2]=0;VD(n+1|0,54116,0,f[c+4>>2]|0);o=BC()|0;p=i;f[p>>2]=e;f[p+4>>2]=g;e=m+(QD(m,23,o,n,i)|0)|0;g=RD(m,e,c)|0;dB(i,c);WD(m,g,e,h,l,k,i);zC(i);f[j>>2]=f[b>>2];e=f[l>>2]|0;g=f[k>>2]|0;f[i>>2]=f[j>>2];g=ge(i,h,e,g,c,d)|0;u=a;return g|0}function ND(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0;w=u;t=u=u+31&-32;u=u+176|0;r=t+72|0;l=t+48|0;k=t+32|0;h=t+24|0;g=t+8|0;j=t;n=t+134|0;m=t+68|0;o=t+76|0;v=t+64|0;s=t+60|0;t=t+56|0;i=j;f[i>>2]=37;f[i+4>>2]=0;i=SD(j+1|0,79883,f[c+4>>2]|0)|0;f[m>>2]=n;a=BC()|0;if(i){f[g>>2]=f[c+8>>2];p[g+8>>3]=e;a=QD(n,30,a,j,g)|0}else{p[h>>3]=e;a=QD(n,30,a,j,h)|0}if((a|0)>29){a=BC()|0;if(i){f[k>>2]=f[c+8>>2];p[k+8>>3]=e;g=TD(m,a,j,k)|0}else{p[l>>3]=e;g=TD(m,a,j,l)|0}a=f[m>>2]|0;if(!a)SK();else{q=g;z=a;A=a}}else{q=a;z=0;A=f[m>>2]|0}g=A+q|0;h=RD(A,g,c)|0;if((A|0)!=(n|0)){a=dx(q<<1)|0;if(!a)SK();else{x=a;y=a}}else{x=o;y=0}dB(r,c);UD(A,h,g,x,v,s,r);zC(r);f[t>>2]=f[b>>2];b=f[v>>2]|0;A=f[s>>2]|0;f[r>>2]=f[t>>2];A=ge(r,x,b,A,c,d)|0;ex(y);ex(z);u=w;return A|0}function OD(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0;w=u;t=u=u+31&-32;u=u+176|0;r=t+72|0;l=t+48|0;k=t+32|0;h=t+24|0;g=t+8|0;j=t;n=t+134|0;m=t+68|0;o=t+76|0;v=t+64|0;s=t+60|0;t=t+56|0;i=j;f[i>>2]=37;f[i+4>>2]=0;i=SD(j+1|0,54114,f[c+4>>2]|0)|0;f[m>>2]=n;a=BC()|0;if(i){f[g>>2]=f[c+8>>2];p[g+8>>3]=e;a=QD(n,30,a,j,g)|0}else{p[h>>3]=e;a=QD(n,30,a,j,h)|0}if((a|0)>29){a=BC()|0;if(i){f[k>>2]=f[c+8>>2];p[k+8>>3]=e;g=TD(m,a,j,k)|0}else{p[l>>3]=e;g=TD(m,a,j,l)|0}a=f[m>>2]|0;if(!a)SK();else{q=g;z=a;A=a}}else{q=a;z=0;A=f[m>>2]|0}g=A+q|0;h=RD(A,g,c)|0;if((A|0)!=(n|0)){a=dx(q<<1)|0;if(!a)SK();else{x=a;y=a}}else{x=o;y=0}dB(r,c);UD(A,h,g,x,v,s,r);zC(r);f[t>>2]=f[b>>2];b=f[v>>2]|0;A=f[s>>2]|0;f[r>>2]=f[t>>2];A=ge(r,x,b,A,c,d)|0;ex(y);ex(z);u=w;return A|0}function PD(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0;a=u;m=u=u+31&-32;u=u+80|0;l=m;k=m+68|0;h=m+48|0;j=m+8|0;m=m+4|0;b[k>>0]=b[54108]|0;b[k+1>>0]=b[54109]|0;b[k+2>>0]=b[54110]|0;b[k+3>>0]=b[54111]|0;b[k+4>>0]=b[54112]|0;b[k+5>>0]=b[54113]|0;i=BC()|0;f[l>>2]=g;g=QD(h,20,i,k,l)|0;k=h+g|0;i=RD(h,k,d)|0;dB(l,d);n=yC(l,59456)|0;zC(l);Xc[f[(f[n>>2]|0)+32>>2]&7](n,h,k,j)|0;g=j+g|0;f[m>>2]=f[c>>2];f[l>>2]=f[m>>2];g=ge(l,j,(i|0)==(k|0)?g:j+(i-h)|0,g,d,e)|0;u=a;return g|0}function QD(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0,h=0;g=u;h=u=u+31&-32;u=u+16|0;f[h>>2]=e;e=Dz(c)|0;c=xx(a,b,d,h)|0;if(e|0)Dz(e)|0;u=g;return c|0}function RD(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0;a:do switch((f[d+4>>2]&176)<<24>>24){case 16:{d=b[a>>0]|0;e=a+1|0;switch(d<<24>>24){case 43:case 45:{a=e;break a}default:{}}if((c-a|0)>1&d<<24>>24==48){switch(b[e>>0]|0){case 88:case 120:break;default:{g=6;break a}}a=a+2|0}else g=6;break}case 32:{a=c;break}default:g=6}while(0);return a|0}function SD(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0;if(d&2048){b[a>>0]=43;a=a+1|0}if(d&1024){b[a>>0]=35;a=a+1|0}h=d&260;e=(d&16384|0)!=0;f=(h|0)==260;if(f)g=0;else{b[a>>0]=46;b[a+1>>0]=42;g=1;a=a+2|0}while(1){d=b[c>>0]|0;if(!(d<<24>>24))break;b[a>>0]=d;c=c+1|0;a=a+1|0}a:do switch(h&511){case 4:{d=e?70:102;break}case 256:{d=e?69:101;break}default:if(f){d=e?65:97;break a}else{d=e?71:103;break a}}while(0);b[a>>0]=d;return g|0}function TD(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0;e=u;g=u=u+31&-32;u=u+16|0;f[g>>2]=d;d=Dz(b)|0;b=iz(a,c,g)|0;if(d|0)Dz(d)|0;u=e;return b|0}function UD(a,c,d,e,g,h,i){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0;w=u;s=u=u+31&-32;u=u+16|0;t=yC(i,59456)|0;r=yC(i,59472)|0;ed[f[(f[r>>2]|0)+20>>2]&63](s,r);f[h>>2]=e;i=b[a>>0]|0;switch(i<<24>>24){case 43:case 45:{q=Vc[f[(f[t>>2]|0)+28>>2]&31](t,i)|0;j=f[h>>2]|0;f[h>>2]=j+1;b[j>>0]=q;j=a+1|0;break}default:j=a}q=d;a:do if((q-j|0)>1?(b[j>>0]|0)==48:0){i=j+1|0;switch(b[i>>0]|0){case 88:case 120:break;default:{i=j;v=10;break a}}o=Vc[f[(f[t>>2]|0)+28>>2]&31](t,48)|0;p=f[h>>2]|0;f[h>>2]=p+1;b[p>>0]=o;j=j+2|0;p=Vc[f[(f[t>>2]|0)+28>>2]&31](t,b[i>>0]|0)|0;i=f[h>>2]|0;f[h>>2]=i+1;b[i>>0]=p;i=j;while(1){if(i>>>0>=d>>>0)break a;p=b[i>>0]|0;if(!(Bz(p,BC()|0)|0))break a;i=i+1|0}}else{i=j;v=10}while(0);b:do if((v|0)==10)while(1){v=0;if(i>>>0>=d>>>0)break b;p=b[i>>0]|0;if(!(uz(p,BC()|0)|0))break b;i=i+1|0;v=10}while(0);m=s+11|0;l=b[m>>0]|0;n=s+4|0;o=j;p=a;c:do if((l<<24>>24<0?f[n>>2]|0:l&255)|0){d:do if((j|0)!=(i|0)){a=i;k=j;while(1){a=a+-1|0;if(k>>>0>=a>>>0)break d;l=b[k>>0]|0;b[k>>0]=b[a>>0]|0;b[a>>0]=l;k=k+1|0}}while(0);l=Uc[f[(f[r>>2]|0)+16>>2]&127](r)|0;k=0;a=0;while(1){if(j>>>0>=i>>>0)break;x=b[((b[m>>0]|0)<0?f[s>>2]|0:s)+a>>0]|0;if(x<<24>>24>0&(k|0)==(x<<24>>24|0)){k=f[h>>2]|0;f[h>>2]=k+1;b[k>>0]=l;k=b[m>>0]|0;a=(a>>>0<((k<<24>>24<0?f[n>>2]|0:k&255)+-1|0)>>>0&1)+a|0;k=0}y=Vc[f[(f[t>>2]|0)+28>>2]&31](t,b[j>>0]|0)|0;x=f[h>>2]|0;f[h>>2]=x+1;b[x>>0]=y;j=j+1|0;k=k+1|0}a=e+(o-p)|0;j=f[h>>2]|0;if((a|0)==(j|0))a=t;else while(1){j=j+-1|0;if(a>>>0>=j>>>0){a=t;break c}y=b[a>>0]|0;b[a>>0]=b[j>>0]|0;b[j>>0]=y;a=a+1|0}}else{Xc[f[(f[t>>2]|0)+32>>2]&7](t,j,i,f[h>>2]|0)|0;f[h>>2]=(f[h>>2]|0)+(i-o);a=t}while(0);while(1){if(i>>>0>=d>>>0)break;j=b[i>>0]|0;i=i+1|0;if(j<<24>>24==46){v=29;break}x=Vc[f[(f[a>>2]|0)+28>>2]&31](t,j)|0;y=f[h>>2]|0;f[h>>2]=y+1;b[y>>0]=x}if((v|0)==29){x=Uc[f[(f[r>>2]|0)+12>>2]&127](r)|0;y=f[h>>2]|0;f[h>>2]=y+1;b[y>>0]=x}Xc[f[(f[t>>2]|0)+32>>2]&7](t,i,d,f[h>>2]|0)|0;y=(f[h>>2]|0)+(q-i)|0;f[h>>2]=y;f[g>>2]=(c|0)==(d|0)?y:e+(c-p)|0;_K(s);u=w;return}function VD(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var f=0;if(e&2048){b[a>>0]=43;a=a+1|0}if(!(e&512))f=a;else{b[a>>0]=35;f=a+1|0}while(1){a=b[c>>0]|0;if(!(a<<24>>24))break;b[f>>0]=a;c=c+1|0;f=f+1|0}switch(e&74){case 64:{a=111;break}case 8:{a=e&16384|0?88:120;break}default:a=d?100:117}b[f>>0]=a;return}function WD(a,c,d,e,g,h,i){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;r=u;q=u=u+31&-32;u=u+16|0;o=yC(i,59456)|0;k=yC(i,59472)|0;ed[f[(f[k>>2]|0)+20>>2]&63](q,k);m=q+11|0;l=b[m>>0]|0;n=q+4|0;p=a;j=d;if((l<<24>>24<0?f[n>>2]|0:l&255)|0){f[h>>2]=e;i=b[a>>0]|0;switch(i<<24>>24){case 43:case 45:{i=Vc[f[(f[o>>2]|0)+28>>2]&31](o,i)|0;l=f[h>>2]|0;f[h>>2]=l+1;b[l>>0]=i;a=a+1|0;break}default:{}}a:do if((j-a|0)>1?(b[a>>0]|0)==48:0){i=a+1|0;switch(b[i>>0]|0){case 88:case 120:break;default:break a}l=Vc[f[(f[o>>2]|0)+28>>2]&31](o,48)|0;j=f[h>>2]|0;f[h>>2]=j+1;b[j>>0]=l;j=Vc[f[(f[o>>2]|0)+28>>2]&31](o,b[i>>0]|0)|0;l=f[h>>2]|0;f[h>>2]=l+1;b[l>>0]=j;a=a+2|0}while(0);b:do if((a|0)!=(d|0)){i=d;j=a;while(1){i=i+-1|0;if(j>>>0>=i>>>0)break b;l=b[j>>0]|0;b[j>>0]=b[i>>0]|0;b[i>>0]=l;j=j+1|0}}while(0);l=Uc[f[(f[k>>2]|0)+16>>2]&127](k)|0;k=a;i=0;j=0;while(1){if(k>>>0>=d>>>0)break;s=b[((b[m>>0]|0)<0?f[q>>2]|0:q)+i>>0]|0;if(s<<24>>24!=0&(j|0)==(s<<24>>24|0)){j=f[h>>2]|0;f[h>>2]=j+1;b[j>>0]=l;j=b[m>>0]|0;i=(i>>>0<((j<<24>>24<0?f[n>>2]|0:j&255)+-1|0)>>>0&1)+i|0;j=0}t=Vc[f[(f[o>>2]|0)+28>>2]&31](o,b[k>>0]|0)|0;s=f[h>>2]|0;f[h>>2]=s+1;b[s>>0]=t;k=k+1|0;j=j+1|0}i=e+(a-p)|0;a=f[h>>2]|0;if((i|0)!=(a|0)){while(1){a=a+-1|0;if(i>>>0>=a>>>0)break;t=b[i>>0]|0;b[i>>0]=b[a>>0]|0;b[a>>0]=t;i=i+1|0}i=f[h>>2]|0}}else{Xc[f[(f[o>>2]|0)+32>>2]&7](o,a,d,e)|0;i=e+(j-p)|0;f[h>>2]=i}f[g>>2]=(c|0)==(d|0)?i:e+(c-p)|0;_K(q);u=r;return}function XD(a){a=a|0;eC(a);return}function YD(a){a=a|0;eC(a);QK(a);return}function ZD(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0;l=u;h=u=u+31&-32;u=u+16|0;k=h+4|0;if(!(f[d+4>>2]&1)){j=f[(f[a>>2]|0)+24>>2]|0;f[h>>2]=f[c>>2];f[k>>2]=f[h>>2];a=Zc[j&31](a,k,d,e,g&1)|0}else{dB(k,d);a=yC(k,59496)|0;zC(k);d=f[a>>2]|0;if(g)ed[f[d+24>>2]&63](k,a);else ed[f[d+28>>2]&63](k,a);i=k+8+3|0;a=b[i>>0]|0;d=f[k>>2]|0;j=k+4|0;g=a<<24>>24<0?d:k;while(1){h=a<<24>>24<0;if((g|0)==((h?d:k)+((h?f[j>>2]|0:a&255)<<2)|0))break;a=f[g>>2]|0;d=f[c>>2]|0;if(d|0){e=d+24|0;h=f[e>>2]|0;if((h|0)==(f[d+28>>2]|0)){h=f[(f[d>>2]|0)+52>>2]|0;a=wA(a)|0;a=Vc[h&31](d,a)|0}else{f[e>>2]=h+4;f[h>>2]=a;a=wA(a)|0}if(eB(a,vA()|0)|0)f[c>>2]=0}g=g+4|0;a=b[i>>0]|0;d=f[k>>2]|0}a=f[c>>2]|0;lL(k)}u=l;return a|0}function _D(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;a=u;j=u=u+31&-32;u=u+128|0;i=j;m=j+122|0;n=j+108|0;h=j+16|0;l=j+12|0;k=j+4|0;j=j+8|0;b[m>>0]=b[54119]|0;b[m+1>>0]=b[54120]|0;b[m+2>>0]=b[54121]|0;b[m+3>>0]=b[54122]|0;b[m+4>>0]=b[54123]|0;b[m+5>>0]=b[54124]|0;VD(m+1|0,54125,1,f[d+4>>2]|0);o=BC()|0;f[i>>2]=g;g=n+(QD(n,13,o,m,i)|0)|0;m=RD(n,g,d)|0;dB(i,d);iE(n,m,g,h,l,k,i);zC(i);f[j>>2]=f[c>>2];c=f[l>>2]|0;g=f[k>>2]|0;f[i>>2]=f[j>>2];g=fE(i,h,c,g,d,e)|0;u=a;return g|0}function $D(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;a=u;j=u=u+31&-32;u=u+224|0;i=j+8|0;n=j;m=j+200|0;h=j+28|0;l=j+24|0;k=j+16|0;j=j+20|0;o=n;f[o>>2]=37;f[o+4>>2]=0;VD(n+1|0,54116,1,f[c+4>>2]|0);o=BC()|0;p=i;f[p>>2]=e;f[p+4>>2]=g;e=m+(QD(m,23,o,n,i)|0)|0;g=RD(m,e,c)|0;dB(i,c);iE(m,g,e,h,l,k,i);zC(i);f[j>>2]=f[b>>2];e=f[l>>2]|0;g=f[k>>2]|0;f[i>>2]=f[j>>2];g=fE(i,h,e,g,c,d)|0;u=a;return g|0}function aE(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;a=u;j=u=u+31&-32;u=u+128|0;i=j;m=j+112|0;n=j+100|0;h=j+16|0;l=j+12|0;k=j+4|0;j=j+8|0;b[m>>0]=b[54119]|0;b[m+1>>0]=b[54120]|0;b[m+2>>0]=b[54121]|0;b[m+3>>0]=b[54122]|0;b[m+4>>0]=b[54123]|0;b[m+5>>0]=b[54124]|0;VD(m+1|0,54125,0,f[d+4>>2]|0);o=BC()|0;f[i>>2]=g;g=n+(QD(n,12,o,m,i)|0)|0;m=RD(n,g,d)|0;dB(i,d);iE(n,m,g,h,l,k,i);zC(i);f[j>>2]=f[c>>2];c=f[l>>2]|0;g=f[k>>2]|0;f[i>>2]=f[j>>2];g=fE(i,h,c,g,d,e)|0;u=a;return g|0}function bE(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;a=u;j=u=u+31&-32;u=u+224|0;i=j+8|0;n=j;m=j+200|0;h=j+28|0;l=j+24|0;k=j+16|0;j=j+20|0;o=n;f[o>>2]=37;f[o+4>>2]=0;VD(n+1|0,54116,0,f[c+4>>2]|0);o=BC()|0;p=i;f[p>>2]=e;f[p+4>>2]=g;e=m+(QD(m,23,o,n,i)|0)|0;g=RD(m,e,c)|0;dB(i,c);iE(m,g,e,h,l,k,i);zC(i);f[j>>2]=f[b>>2];e=f[l>>2]|0;g=f[k>>2]|0;f[i>>2]=f[j>>2];g=fE(i,h,e,g,c,d)|0;u=a;return g|0}function cE(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;y=u;t=u=u+31&-32;u=u+336|0;r=t+300|0;l=t+48|0;k=t+32|0;h=t+24|0;g=t+8|0;j=t;n=t+304|0;m=t+296|0;o=t+68|0;v=t+64|0;s=t+60|0;t=t+56|0;i=j;f[i>>2]=37;f[i+4>>2]=0;i=SD(j+1|0,79883,f[c+4>>2]|0)|0;f[m>>2]=n;a=BC()|0;if(i){f[g>>2]=f[c+8>>2];p[g+8>>3]=e;a=QD(n,30,a,j,g)|0}else{p[h>>3]=e;a=QD(n,30,a,j,h)|0}if((a|0)>29){a=BC()|0;if(i){f[k>>2]=f[c+8>>2];p[k+8>>3]=e;g=TD(m,a,j,k)|0}else{p[l>>3]=e;g=TD(m,a,j,l)|0}a=f[m>>2]|0;if(!a)SK();else{q=g;A=a;x=a}}else{q=a;A=0;x=f[m>>2]|0}g=x+q|0;h=RD(x,g,c)|0;do if((x|0)!=(n|0)){a=dx(q<<3)|0;if(!a)SK();else{w=a;z=0;B=a;break}}else{w=o;z=1;B=0}while(0);dB(r,c);hE(x,h,g,w,v,s,r);zC(r);f[t>>2]=f[b>>2];x=f[v>>2]|0;a=f[s>>2]|0;f[r>>2]=f[t>>2];a=fE(r,w,x,a,c,d)|0;f[b>>2]=a;if(!z)ex(B);ex(A);u=y;return a|0}function dE(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;y=u;t=u=u+31&-32;u=u+336|0;r=t+300|0;l=t+48|0;k=t+32|0;h=t+24|0;g=t+8|0;j=t;n=t+304|0;m=t+296|0;o=t+68|0;v=t+64|0;s=t+60|0;t=t+56|0;i=j;f[i>>2]=37;f[i+4>>2]=0;i=SD(j+1|0,54114,f[c+4>>2]|0)|0;f[m>>2]=n;a=BC()|0;if(i){f[g>>2]=f[c+8>>2];p[g+8>>3]=e;a=QD(n,30,a,j,g)|0}else{p[h>>3]=e;a=QD(n,30,a,j,h)|0}if((a|0)>29){a=BC()|0;if(i){f[k>>2]=f[c+8>>2];p[k+8>>3]=e;g=TD(m,a,j,k)|0}else{p[l>>3]=e;g=TD(m,a,j,l)|0}a=f[m>>2]|0;if(!a)SK();else{q=g;A=a;x=a}}else{q=a;A=0;x=f[m>>2]|0}g=x+q|0;h=RD(x,g,c)|0;do if((x|0)!=(n|0)){a=dx(q<<3)|0;if(!a)SK();else{w=a;z=0;B=a;break}}else{w=o;z=1;B=0}while(0);dB(r,c);hE(x,h,g,w,v,s,r);zC(r);f[t>>2]=f[b>>2];x=f[v>>2]|0;a=f[s>>2]|0;f[r>>2]=f[t>>2];a=fE(r,w,x,a,c,d)|0;f[b>>2]=a;if(!z)ex(B);ex(A);u=y;return a|0}function eE(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0;a=u;m=u=u+31&-32;u=u+192|0;l=m;k=m+176|0;h=m+156|0;j=m+4|0;m=m+152|0;b[k>>0]=b[54108]|0;b[k+1>>0]=b[54109]|0;b[k+2>>0]=b[54110]|0;b[k+3>>0]=b[54111]|0;b[k+4>>0]=b[54112]|0;b[k+5>>0]=b[54113]|0;i=BC()|0;f[l>>2]=g;g=QD(h,20,i,k,l)|0;k=h+g|0;i=RD(h,k,d)|0;dB(l,d);n=yC(l,59488)|0;zC(l);Xc[f[(f[n>>2]|0)+48>>2]&7](n,h,k,j)|0;g=j+(g<<2)|0;f[m>>2]=f[c>>2];f[l>>2]=f[m>>2];g=fE(l,j,(i|0)==(k|0)?g:j+(i-h<<2)|0,g,d,e)|0;u=a;return g|0}function fE(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;r=u;q=u=u+31&-32;u=u+16|0;p=q+12|0;i=f[a>>2]|0;a:do if(!i)i=0;else{s=c;j=e-s>>2;l=g+12|0;k=f[l>>2]|0;j=(k|0)>(j|0)?k-j|0:0;k=d;s=k-s|0;g=s>>2;if((s|0)>0?(Wc[f[(f[i>>2]|0)+48>>2]&63](i,c,g)|0)!=(g|0):0){f[a>>2]=0;i=0;break}do if((j|0)>0){f[q>>2]=0;f[q+4>>2]=0;f[q+8>>2]=0;if(j>>>0>1073741807)XK(q);do if(j>>>0>=2){g=j+4&2147483644;if(g>>>0>1073741823)Gb();else{m=OK(g<<2)|0;f[q>>2]=m;n=q+8|0;f[n>>2]=g|-2147483648;f[q+4>>2]=j;n=n+3|0;o=q;break}}else{n=q+8+3|0;b[n>>0]=j;m=q;o=q}while(0);gE(m,j,h)|0;f[p>>2]=0;kC(m+(j<<2)|0,p);if((Wc[f[(f[i>>2]|0)+48>>2]&63](i,(b[n>>0]|0)<0?f[q>>2]|0:o,j)|0)==(j|0)){lL(q);break}else{f[a>>2]=0;lL(q);i=0;break a}}while(0);s=e-k|0;e=s>>2;if((s|0)>0?(Wc[f[(f[i>>2]|0)+48>>2]&63](i,d,e)|0)!=(e|0):0){f[a>>2]=0;i=0;break}f[l>>2]=0}while(0);u=r;return i|0}function gE(a,b,c){a=a|0;b=b|0;c=c|0;if(b)nz(a,c,b)|0;return a|0}function hE(a,c,d,e,g,h,i){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0;y=u;v=u=u+31&-32;u=u+16|0;w=yC(i,59488)|0;s=yC(i,59496)|0;ed[f[(f[s>>2]|0)+20>>2]&63](v,s);f[h>>2]=e;i=b[a>>0]|0;switch(i<<24>>24){case 43:case 45:{t=Vc[f[(f[w>>2]|0)+44>>2]&31](w,i)|0;i=f[h>>2]|0;f[h>>2]=i+4;f[i>>2]=t;i=a+1|0;break}default:i=a}t=d;a:do if((t-i|0)>1?(b[i>>0]|0)==48:0){j=i+1|0;switch(b[j>>0]|0){case 88:case 120:break;default:{j=i;x=10;break a}}q=Vc[f[(f[w>>2]|0)+44>>2]&31](w,48)|0;r=f[h>>2]|0;f[h>>2]=r+4;f[r>>2]=q;i=i+2|0;r=Vc[f[(f[w>>2]|0)+44>>2]&31](w,b[j>>0]|0)|0;j=f[h>>2]|0;f[h>>2]=j+4;f[j>>2]=r;j=i;while(1){if(j>>>0>=d>>>0)break a;r=b[j>>0]|0;if(!(Bz(r,BC()|0)|0))break a;j=j+1|0}}else{j=i;x=10}while(0);b:do if((x|0)==10)while(1){x=0;if(j>>>0>=d>>>0)break b;r=b[j>>0]|0;if(!(uz(r,BC()|0)|0))break b;j=j+1|0;x=10}while(0);o=v+11|0;n=b[o>>0]|0;p=v+4|0;q=i;r=a;c:do if((n<<24>>24<0?f[p>>2]|0:n&255)|0){d:do if((i|0)!=(j|0)){a=j;k=i;while(1){a=a+-1|0;if(k>>>0>=a>>>0)break d;n=b[k>>0]|0;b[k>>0]=b[a>>0]|0;b[a>>0]=n;k=k+1|0}}while(0);n=Uc[f[(f[s>>2]|0)+16>>2]&127](s)|0;a=0;k=0;while(1){if(i>>>0>=j>>>0)break;l=b[o>>0]|0;m=l<<24>>24<0;z=b[(m?f[v>>2]|0:v)+a>>0]|0;if(z<<24>>24>0&(k|0)==(z<<24>>24|0)){k=f[h>>2]|0;f[h>>2]=k+4;f[k>>2]=n;a=(a>>>0<((m?f[p>>2]|0:l&255)+-1|0)>>>0&1)+a|0;k=0}m=Vc[f[(f[w>>2]|0)+44>>2]&31](w,b[i>>0]|0)|0;z=f[h>>2]|0;f[h>>2]=z+4;f[z>>2]=m;i=i+1|0;k=k+1|0}i=e+(q-r<<2)|0;k=f[h>>2]|0;if((i|0)==(k|0))a=w;else{a=k;while(1){a=a+-4|0;if(i>>>0>=a>>>0){a=w;i=k;break c}z=f[i>>2]|0;f[i>>2]=f[a>>2];f[a>>2]=z;i=i+4|0}}}else{Xc[f[(f[w>>2]|0)+48>>2]&7](w,i,j,f[h>>2]|0)|0;i=(f[h>>2]|0)+(j-q<<2)|0;f[h>>2]=i;a=w}while(0);while(1){if(j>>>0>=d>>>0)break;i=b[j>>0]|0;j=j+1|0;if(i<<24>>24==46){x=29;break}q=Vc[f[(f[a>>2]|0)+44>>2]&31](w,i)|0;z=f[h>>2]|0;i=z+4|0;f[h>>2]=i;f[z>>2]=q}if((x|0)==29){x=Uc[f[(f[s>>2]|0)+12>>2]&127](s)|0;z=f[h>>2]|0;i=z+4|0;f[h>>2]=i;f[z>>2]=x}Xc[f[(f[w>>2]|0)+48>>2]&7](w,j,d,i)|0;z=(f[h>>2]|0)+(t-j<<2)|0;f[h>>2]=z;f[g>>2]=(c|0)==(d|0)?z:e+(c-r<<2)|0;_K(v);u=y;return}function iE(a,c,d,e,g,h,i){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0;t=u;s=u=u+31&-32;u=u+16|0;q=yC(i,59488)|0;k=yC(i,59496)|0;ed[f[(f[k>>2]|0)+20>>2]&63](s,k);o=s+11|0;n=b[o>>0]|0;p=s+4|0;r=a;j=d;if((n<<24>>24<0?f[p>>2]|0:n&255)|0){f[h>>2]=e;i=b[a>>0]|0;switch(i<<24>>24){case 43:case 45:{m=Vc[f[(f[q>>2]|0)+44>>2]&31](q,i)|0;n=f[h>>2]|0;f[h>>2]=n+4;f[n>>2]=m;a=a+1|0;break}default:{}}a:do if((j-a|0)>1?(b[a>>0]|0)==48:0){i=a+1|0;switch(b[i>>0]|0){case 88:case 120:break;default:break a}n=Vc[f[(f[q>>2]|0)+44>>2]&31](q,48)|0;m=f[h>>2]|0;f[h>>2]=m+4;f[m>>2]=n;m=Vc[f[(f[q>>2]|0)+44>>2]&31](q,b[i>>0]|0)|0;n=f[h>>2]|0;f[h>>2]=n+4;f[n>>2]=m;a=a+2|0}while(0);b:do if((a|0)!=(d|0)){i=d;j=a;while(1){i=i+-1|0;if(j>>>0>=i>>>0)break b;n=b[j>>0]|0;b[j>>0]=b[i>>0]|0;b[i>>0]=n;j=j+1|0}}while(0);n=Uc[f[(f[k>>2]|0)+16>>2]&127](k)|0;m=a;i=0;j=0;while(1){if(m>>>0>=d>>>0)break;k=b[o>>0]|0;l=k<<24>>24<0;v=b[(l?f[s>>2]|0:s)+i>>0]|0;if(v<<24>>24!=0&(j|0)==(v<<24>>24|0)){j=f[h>>2]|0;f[h>>2]=j+4;f[j>>2]=n;i=(i>>>0<((l?f[p>>2]|0:k&255)+-1|0)>>>0&1)+i|0;j=0}l=Vc[f[(f[q>>2]|0)+44>>2]&31](q,b[m>>0]|0)|0;v=f[h>>2]|0;f[h>>2]=v+4;f[v>>2]=l;m=m+1|0;j=j+1|0}i=e+(a-r<<2)|0;a=f[h>>2]|0;if((i|0)!=(a|0)){while(1){a=a+-4|0;if(i>>>0>=a>>>0)break;v=f[i>>2]|0;f[i>>2]=f[a>>2];f[a>>2]=v;i=i+4|0}i=f[h>>2]|0}}else{Xc[f[(f[q>>2]|0)+48>>2]&7](q,a,d,e)|0;i=e+(j-r<<2)|0;f[h>>2]=i}f[g>>2]=(c|0)==(d|0)?i:e+(c-r<<2)|0;_K(s);u=t;return}function jE(a){a=a|0;eC(a);return}function kE(a){a=a|0;eC(a);QK(a);return}function lE(a){a=a|0;return 2}function mE(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0;h=u;k=u=u+31&-32;u=u+16|0;i=k+12|0;j=k+8|0;l=k+4|0;f[l>>2]=f[b>>2];f[k>>2]=f[c>>2];f[j>>2]=f[l>>2];f[i>>2]=f[k>>2];g=EE(a,j,i,d,e,g,54644,54652)|0;u=h;return g|0}function nE(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0;i=u;l=u=u+31&-32;u=u+16|0;j=l+12|0;k=l+8|0;m=l+4|0;n=a+8|0;n=Uc[f[(f[n>>2]|0)+20>>2]&127](n)|0;f[m>>2]=f[c>>2];f[l>>2]=f[d>>2];d=b[n+11>>0]|0;o=d<<24>>24<0;c=o?f[n>>2]|0:n;d=c+(o?f[n+4>>2]|0:d&255)|0;f[k>>2]=f[m>>2];f[j>>2]=f[l>>2];h=EE(a,k,j,e,g,h,c,d)|0;u=i;return h|0}function oE(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0;h=u;j=u=u+31&-32;u=u+16|0;i=j+4|0;dB(i,d);d=yC(i,59456)|0;zC(i);f[j>>2]=f[c>>2];f[i>>2]=f[j>>2];CE(a,g+24|0,b,i,e,d);u=h;return f[b>>2]|0}function pE(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0;h=u;j=u=u+31&-32;u=u+16|0;i=j+4|0;dB(i,d);d=yC(i,59456)|0;zC(i);f[j>>2]=f[c>>2];f[i>>2]=f[j>>2];DE(a,g+16|0,b,i,e,d);u=h;return f[b>>2]|0}function qE(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0;h=u;j=u=u+31&-32;u=u+16|0;i=j+4|0;dB(i,d);d=yC(i,59456)|0;zC(i);f[j>>2]=f[c>>2];f[i>>2]=f[j>>2];PE(a,g+20|0,b,i,e,d);u=h;return f[b>>2]|0}function rE(a,c,d,e,g,h,i,j){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0;X=u;O=u=u+31&-32;u=u+144|0;k=O+128|0;j=O+112|0;V=O+124|0;W=O+120|0;l=O+116|0;m=O+108|0;n=O+104|0;o=O+100|0;p=O+96|0;q=O+92|0;r=O+88|0;s=O+84|0;t=O+80|0;v=O+76|0;w=O+72|0;x=O+68|0;y=O+64|0;z=O+60|0;A=O+56|0;B=O+52|0;C=O+48|0;D=O+44|0;E=O+40|0;F=O+36|0;G=O+32|0;H=O+28|0;I=O+24|0;J=O+20|0;K=O+16|0;L=O+12|0;M=O+8|0;N=O+4|0;f[g>>2]=0;dB(k,e);P=yC(k,59456)|0;zC(k);Q=h+8|0;R=h+20|0;S=h+16|0;T=h+24|0;U=a+8|0;do switch(i<<24>>24|0){case 65:case 97:{f[V>>2]=f[d>>2];f[k>>2]=f[V>>2];CE(a,T,c,k,g,P);Y=26;break}case 104:case 66:case 98:{f[W>>2]=f[d>>2];f[k>>2]=f[W>>2];DE(a,S,c,k,g,P);Y=26;break}case 99:{W=Uc[f[(f[U>>2]|0)+12>>2]&127](U)|0;f[l>>2]=f[c>>2];f[m>>2]=f[d>>2];Y=b[W+11>>0]|0;d=Y<<24>>24<0;i=d?f[W>>2]|0:W;Y=i+(d?f[W+4>>2]|0:Y&255)|0;f[j>>2]=f[l>>2];f[k>>2]=f[m>>2];Y=EE(a,j,k,e,g,h,i,Y)|0;f[c>>2]=Y;Y=26;break}case 101:case 100:{f[n>>2]=f[d>>2];f[k>>2]=f[n>>2];FE(a,h+12|0,c,k,g,P);Y=26;break}case 68:{f[o>>2]=f[c>>2];f[p>>2]=f[d>>2];f[j>>2]=f[o>>2];f[k>>2]=f[p>>2];Y=EE(a,j,k,e,g,h,54604,54612)|0;f[c>>2]=Y;Y=26;break}case 70:{f[q>>2]=f[c>>2];f[r>>2]=f[d>>2];f[j>>2]=f[q>>2];f[k>>2]=f[r>>2];Y=EE(a,j,k,e,g,h,54612,54620)|0;f[c>>2]=Y;Y=26;break}case 72:{f[s>>2]=f[d>>2];f[k>>2]=f[s>>2];GE(a,Q,c,k,g,P);Y=26;break}case 73:{f[t>>2]=f[d>>2];f[k>>2]=f[t>>2];HE(a,Q,c,k,g,P);Y=26;break}case 106:{f[v>>2]=f[d>>2];f[k>>2]=f[v>>2];IE(a,h+28|0,c,k,g,P);Y=26;break}case 109:{f[w>>2]=f[d>>2];f[k>>2]=f[w>>2];JE(a,S,c,k,g,P);Y=26;break}case 77:{f[x>>2]=f[d>>2];f[k>>2]=f[x>>2];KE(a,h+4|0,c,k,g,P);Y=26;break}case 116:case 110:{f[y>>2]=f[d>>2];f[k>>2]=f[y>>2];LE(a,c,k,g,P);Y=26;break}case 112:{f[z>>2]=f[d>>2];f[k>>2]=f[z>>2];ME(a,Q,c,k,g,P);Y=26;break}case 114:{f[A>>2]=f[c>>2];f[B>>2]=f[d>>2];f[j>>2]=f[A>>2];f[k>>2]=f[B>>2];Y=EE(a,j,k,e,g,h,54620,54631)|0;f[c>>2]=Y;Y=26;break}case 82:{f[C>>2]=f[c>>2];f[D>>2]=f[d>>2];f[j>>2]=f[C>>2];f[k>>2]=f[D>>2];Y=EE(a,j,k,e,g,h,54631,54636)|0;f[c>>2]=Y;Y=26;break}case 83:{f[E>>2]=f[d>>2];f[k>>2]=f[E>>2];NE(a,h,c,k,g,P);Y=26;break}case 84:{f[F>>2]=f[c>>2];f[G>>2]=f[d>>2];f[j>>2]=f[F>>2];f[k>>2]=f[G>>2];Y=EE(a,j,k,e,g,h,54636,54644)|0;f[c>>2]=Y;Y=26;break}case 119:{f[H>>2]=f[d>>2];f[k>>2]=f[H>>2];OE(a,T,c,k,g,P);Y=26;break}case 120:{i=f[(f[a>>2]|0)+20>>2]|0;f[I>>2]=f[c>>2];f[J>>2]=f[d>>2];f[j>>2]=f[I>>2];f[k>>2]=f[J>>2];j=$c[i&63](a,j,k,e,g,h)|0;break}case 88:{W=Uc[f[(f[U>>2]|0)+24>>2]&127](U)|0;f[K>>2]=f[c>>2];f[L>>2]=f[d>>2];Y=b[W+11>>0]|0;d=Y<<24>>24<0;i=d?f[W>>2]|0:W;Y=i+(d?f[W+4>>2]|0:Y&255)|0;f[j>>2]=f[K>>2];f[k>>2]=f[L>>2];Y=EE(a,j,k,e,g,h,i,Y)|0;f[c>>2]=Y;Y=26;break}case 121:{f[M>>2]=f[d>>2];f[k>>2]=f[M>>2];PE(a,R,c,k,g,P);Y=26;break}case 89:{f[N>>2]=f[d>>2];f[k>>2]=f[N>>2];QE(a,R,c,k,g,P);Y=26;break}case 37:{f[O>>2]=f[d>>2];f[k>>2]=f[O>>2];RE(a,c,k,g,P);Y=26;break}default:{f[g>>2]=f[g>>2]|4;Y=26}}while(0);if((Y|0)==26)j=f[c>>2]|0;u=X;return j|0}function sE(a){a=a|0;if((b[56920]|0)==0?oM(56920)|0:0){BE();f[15082]=60160}return f[15082]|0}function tE(a){a=a|0;if((b[56904]|0)==0?oM(56904)|0:0){AE();f[15039]=59868}return f[15039]|0}function uE(a){a=a|0;if((b[56888]|0)==0?oM(56888)|0:0){zE();f[14966]=59576}return f[14966]|0}function vE(a){a=a|0;var c=0,d=0,e=0,g=0;e=u;c=u=u+31&-32;u=u+16|0;if((b[56880]|0)==0?oM(56880)|0:0){f[14891]=0;f[14892]=0;f[14893]=0;d=_A(54362)|0;if(d>>>0>4294967279)XK(59564);if(d>>>0<11){b[59575]=d;a=59564}else{g=d+16&-16;a=OK(g)|0;f[14891]=a;f[14893]=g|-2147483648;f[14892]=d}fA(a,54362,d)|0;b[c>>0]=0;$A(a+d|0,c)}u=e;return 59564}function wE(a){a=a|0;var c=0,d=0,e=0,g=0;e=u;c=u=u+31&-32;u=u+16|0;if((b[56872]|0)==0?oM(56872)|0:0){f[14888]=0;f[14889]=0;f[14890]=0;d=_A(54350)|0;if(d>>>0>4294967279)XK(59552);if(d>>>0<11){b[59563]=d;a=59552}else{g=d+16&-16;a=OK(g)|0;f[14888]=a;f[14890]=g|-2147483648;f[14889]=d}fA(a,54350,d)|0;b[c>>0]=0;$A(a+d|0,c)}u=e;return 59552}function xE(a){a=a|0;var c=0,d=0,e=0,g=0;e=u;c=u=u+31&-32;u=u+16|0;if((b[56864]|0)==0?oM(56864)|0:0){f[14885]=0;f[14886]=0;f[14887]=0;d=_A(54341)|0;if(d>>>0>4294967279)XK(59540);if(d>>>0<11){b[59551]=d;a=59540}else{g=d+16&-16;a=OK(g)|0;f[14885]=a;f[14887]=g|-2147483648;f[14886]=d}fA(a,54341,d)|0;b[c>>0]=0;$A(a+d|0,c)}u=e;return 59540}function yE(a){a=a|0;var c=0,d=0,e=0,g=0;e=u;c=u=u+31&-32;u=u+16|0;if((b[56856]|0)==0?oM(56856)|0:0){f[14882]=0;f[14883]=0;f[14884]=0;d=_A(54332)|0;if(d>>>0>4294967279)XK(59528);if(d>>>0<11){b[59539]=d;a=59528}else{g=d+16&-16;a=OK(g)|0;f[14882]=a;f[14884]=g|-2147483648;f[14883]=d}fA(a,54332,d)|0;b[c>>0]=0;$A(a+d|0,c)}u=e;return 59528}function zE(){var a=0,c=0;if((b[56896]|0)==0?oM(56896)|0:0){c=59576;do{f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[c+(a<<2)>>2]=0;a=a+1|0}c=c+12|0}while((c|0)!=59864)}eL(59576,54383)|0;eL(59588,54386)|0;return}function AE(){var a=0,c=0;if((b[56912]|0)==0?oM(56912)|0:0){c=59868;do{f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[c+(a<<2)>>2]=0;a=a+1|0}c=c+12|0}while((c|0)!=60156)}eL(59868,54389)|0;eL(59880,54397)|0;eL(59892,54406)|0;eL(59904,54412)|0;eL(59916,54418)|0;eL(59928,54422)|0;eL(59940,54427)|0;eL(59952,54432)|0;eL(59964,54439)|0;eL(59976,54449)|0;eL(59988,54457)|0;eL(6e4,54466)|0;eL(60012,54475)|0;eL(60024,54479)|0;eL(60036,54483)|0;eL(60048,54487)|0;eL(60060,54418)|0;eL(60072,54491)|0;eL(60084,54495)|0;eL(60096,54499)|0;eL(60108,54503)|0;eL(60120,54507)|0;eL(60132,54511)|0;eL(60144,54515)|0;return}function BE(){var a=0,c=0;if((b[56928]|0)==0?oM(56928)|0:0){c=60160;do{f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[c+(a<<2)>>2]=0;a=a+1|0}c=c+12|0}while((c|0)!=60328)}eL(60160,54519)|0;eL(60172,54526)|0;eL(60184,54533)|0;eL(60196,54541)|0;eL(60208,54551)|0;eL(60220,54560)|0;eL(60232,54567)|0;eL(60244,54576)|0;eL(60256,54580)|0;eL(60268,54584)|0;eL(60280,54588)|0;eL(60292,54592)|0;eL(60304,54596)|0;eL(60316,54600)|0;return}function CE(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0;h=u;j=u=u+31&-32;u=u+16|0;i=j+4|0;a=a+8|0;a=Uc[f[f[a>>2]>>2]&127](a)|0;f[j>>2]=f[d>>2];f[i>>2]=f[j>>2];a=(eD(c,i,a,a+168|0,g,e,0)|0)-a|0;if((a|0)<168)f[b>>2]=((a|0)/12|0|0)%7|0;u=h;return}function DE(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0;h=u;j=u=u+31&-32;u=u+16|0;i=j+4|0;a=a+8|0;a=Uc[f[(f[a>>2]|0)+4>>2]&127](a)|0;f[j>>2]=f[d>>2];f[i>>2]=f[j>>2];a=(eD(c,i,a,a+288|0,g,e,0)|0)-a|0;if((a|0)<288)f[b>>2]=((a|0)/12|0|0)%12|0;u=h;return}function EE(a,c,e,g,h,i,j,k){a=a|0;c=c|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;B=u;z=u=u+31&-32;u=u+16|0;t=z+12|0;s=z+8|0;y=z+4|0;dB(t,g);v=yC(t,59456)|0;zC(t);f[h>>2]=0;w=v+8|0;l=0;a:while(1){r=(j|0)!=(k|0);m=l;while(1){l=f[c>>2]|0;if(!(r&(m|0)==0))break a;n=l;if(l){m=f[l+12>>2]|0;if((m|0)==(f[l+16>>2]|0))m=Uc[f[(f[l>>2]|0)+36>>2]&127](l)|0;else m=eA(b[m>>0]|0)|0;if(cB(m,dA()|0)|0){f[c>>2]=0;l=0;p=1;q=0}else{p=0;q=n}}else{l=0;p=1;q=n}o=f[e>>2]|0;m=o;do if(o){n=f[o+12>>2]|0;if((n|0)==(f[o+16>>2]|0))n=Uc[f[(f[o>>2]|0)+36>>2]&127](o)|0;else n=eA(b[n>>0]|0)|0;if(!(cB(n,dA()|0)|0))if(p)break;else{A=61;break a}else{f[e>>2]=0;m=0;A=16;break}}else A=16;while(0);if((A|0)==16){A=0;if(p){A=61;break a}else o=0}if((Wc[f[(f[v>>2]|0)+36>>2]&63](v,b[j>>0]|0,0)|0)<<24>>24==37){A=19;break}m=b[j>>0]|0;if(m<<24>>24>-1?(x=f[w>>2]|0,d[x+(m<<24>>24<<1)>>1]&8192):0){A=27;break}n=l+12|0;m=f[n>>2]|0;o=l+16|0;if((m|0)==(f[o>>2]|0))m=Uc[f[(f[l>>2]|0)+36>>2]&127](l)|0;else m=eA(b[m>>0]|0)|0;q=Vc[f[(f[v>>2]|0)+12>>2]&31](v,m&255)|0;if(q<<24>>24==(Vc[f[(f[v>>2]|0)+12>>2]&31](v,b[j>>0]|0)|0)<<24>>24){A=57;break}f[h>>2]=4;m=4}b:do if((A|0)==19){A=0;p=j+1|0;if((p|0)==(k|0)){A=61;break a}n=Wc[f[(f[v>>2]|0)+36>>2]&63](v,b[p>>0]|0,0)|0;switch(n<<24>>24){case 48:case 69:{j=j+2|0;if((j|0)==(k|0)){A=61;break a}o=n;l=Wc[f[(f[v>>2]|0)+36>>2]&63](v,b[j>>0]|0,0)|0;j=p;break}default:{o=0;l=n}}r=f[(f[a>>2]|0)+36>>2]|0;f[y>>2]=q;f[z>>2]=m;f[s>>2]=f[y>>2];f[t>>2]=f[z>>2];r=bd[r&15](a,s,t,g,h,i,l,o)|0;f[c>>2]=r;j=j+2|0}else if((A|0)==27){while(1){A=0;j=j+1|0;if((j|0)==(k|0)){j=k;break}m=b[j>>0]|0;if(m<<24>>24<=-1)break;if(!(d[x+(m<<24>>24<<1)>>1]&8192))break;else A=27}m=o;while(1){if(l){n=f[l+12>>2]|0;if((n|0)==(f[l+16>>2]|0))n=Uc[f[(f[l>>2]|0)+36>>2]&127](l)|0;else n=eA(b[n>>0]|0)|0;if(cB(n,dA()|0)|0){f[c>>2]=0;p=1;l=0}else p=0}else{p=1;l=0}do if(o){n=f[o+12>>2]|0;if((n|0)==(f[o+16>>2]|0))n=Uc[f[(f[o>>2]|0)+36>>2]&127](o)|0;else n=eA(b[n>>0]|0)|0;if(!(cB(n,dA()|0)|0))if(p^(m|0)==0){q=m;o=m;break}else break b;else{f[e>>2]=0;m=0;A=43;break}}else A=43;while(0);if((A|0)==43){A=0;if(p)break b;else{q=m;o=0}}n=l+12|0;m=f[n>>2]|0;p=l+16|0;if((m|0)==(f[p>>2]|0))m=Uc[f[(f[l>>2]|0)+36>>2]&127](l)|0;else m=eA(b[m>>0]|0)|0;if((m&255)<<24>>24<=-1)break b;if(!(d[(f[w>>2]|0)+(m<<24>>24<<1)>>1]&8192))break b;m=f[n>>2]|0;if((m|0)==(f[p>>2]|0)){Uc[f[(f[l>>2]|0)+40>>2]&127](l)|0;m=q;continue}else{f[n>>2]=m+1;eA(b[m>>0]|0)|0;m=q;continue}}}else if((A|0)==57){A=0;j=j+1|0;m=f[n>>2]|0;if((m|0)==(f[o>>2]|0)){Uc[f[(f[l>>2]|0)+40>>2]&127](l)|0;break}else{f[n>>2]=m+1;eA(b[m>>0]|0)|0;break}}while(0);l=f[h>>2]|0}if((A|0)==61)f[h>>2]=4;if(l){j=f[l+12>>2]|0;if((j|0)==(f[l+16>>2]|0))j=Uc[f[(f[l>>2]|0)+36>>2]&127](l)|0;else j=eA(b[j>>0]|0)|0;if(cB(j,dA()|0)|0){f[c>>2]=0;l=0;n=1}else n=0}else{l=0;n=1}j=f[e>>2]|0;do if(j){m=f[j+12>>2]|0;if((m|0)==(f[j+16>>2]|0))j=Uc[f[(f[j>>2]|0)+36>>2]&127](j)|0;else j=eA(b[m>>0]|0)|0;if(!(cB(j,dA()|0)|0))if(n)break;else{A=76;break}else{f[e>>2]=0;A=74;break}}else A=74;while(0);if((A|0)==74?n:0)A=76;if((A|0)==76)f[h>>2]=f[h>>2]|2;u=B;return l|0}function FE(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0;h=u;i=u=u+31&-32;u=u+16|0;a=i+4|0;f[i>>2]=f[d>>2];f[a>>2]=f[i>>2];a=SE(c,a,e,g,2)|0;c=f[e>>2]|0;if((a+-1|0)>>>0<31&(c&4|0)==0)f[b>>2]=a;else f[e>>2]=c|4;u=h;return}function GE(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0;h=u;i=u=u+31&-32;u=u+16|0;a=i+4|0;f[i>>2]=f[d>>2];f[a>>2]=f[i>>2];a=SE(c,a,e,g,2)|0;c=f[e>>2]|0;if((a|0)<24&(c&4|0)==0)f[b>>2]=a;else f[e>>2]=c|4;u=h;return}function HE(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0;h=u;i=u=u+31&-32;u=u+16|0;a=i+4|0;f[i>>2]=f[d>>2];f[a>>2]=f[i>>2];a=SE(c,a,e,g,2)|0;c=f[e>>2]|0;if((a+-1|0)>>>0<12&(c&4|0)==0)f[b>>2]=a;else f[e>>2]=c|4;u=h;return}function IE(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0;h=u;i=u=u+31&-32;u=u+16|0;a=i+4|0;f[i>>2]=f[d>>2];f[a>>2]=f[i>>2];a=SE(c,a,e,g,3)|0;c=f[e>>2]|0;if((a|0)<366&(c&4|0)==0)f[b>>2]=a;else f[e>>2]=c|4;u=h;return}function JE(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0;h=u;i=u=u+31&-32;u=u+16|0;a=i+4|0;f[i>>2]=f[d>>2];f[a>>2]=f[i>>2];a=SE(c,a,e,g,2)|0;c=f[e>>2]|0;if((a|0)<13&(c&4|0)==0)f[b>>2]=a+-1;else f[e>>2]=c|4;u=h;return}function KE(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0;h=u;i=u=u+31&-32;u=u+16|0;a=i+4|0;f[i>>2]=f[d>>2];f[a>>2]=f[i>>2];a=SE(c,a,e,g,2)|0;c=f[e>>2]|0;if((a|0)<60&(c&4|0)==0)f[b>>2]=a;else f[e>>2]=c|4;u=h;return}function LE(a,c,e,g,h){a=a|0;c=c|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0;j=h+8|0;a:while(1){a=f[c>>2]|0;do if(a){h=f[a+12>>2]|0;if((h|0)==(f[a+16>>2]|0))a=Uc[f[(f[a>>2]|0)+36>>2]&127](a)|0;else a=eA(b[h>>0]|0)|0;if(cB(a,dA()|0)|0){f[c>>2]=0;i=1;break}else{i=(f[c>>2]|0)==0;break}}else i=1;while(0);h=f[e>>2]|0;do if(h){a=f[h+12>>2]|0;if((a|0)==(f[h+16>>2]|0))a=Uc[f[(f[h>>2]|0)+36>>2]&127](h)|0;else a=eA(b[a>>0]|0)|0;if(!(cB(a,dA()|0)|0))if(i){i=h;break}else{i=h;break a}else{f[e>>2]=0;k=15;break}}else k=15;while(0);if((k|0)==15){k=0;if(i){i=0;break}else i=0}a=f[c>>2]|0;h=f[a+12>>2]|0;if((h|0)==(f[a+16>>2]|0))a=Uc[f[(f[a>>2]|0)+36>>2]&127](a)|0;else a=eA(b[h>>0]|0)|0;if((a&255)<<24>>24<=-1)break;if(!(d[(f[j>>2]|0)+(a<<24>>24<<1)>>1]&8192))break;a=f[c>>2]|0;h=a+12|0;i=f[h>>2]|0;if((i|0)==(f[a+16>>2]|0)){Uc[f[(f[a>>2]|0)+40>>2]&127](a)|0;continue}else{f[h>>2]=i+1;eA(b[i>>0]|0)|0;continue}}a=f[c>>2]|0;do if(a){h=f[a+12>>2]|0;if((h|0)==(f[a+16>>2]|0))a=Uc[f[(f[a>>2]|0)+36>>2]&127](a)|0;else a=eA(b[h>>0]|0)|0;if(cB(a,dA()|0)|0){f[c>>2]=0;h=1;break}else{h=(f[c>>2]|0)==0;break}}else h=1;while(0);do if(i){a=f[i+12>>2]|0;if((a|0)==(f[i+16>>2]|0))a=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else a=eA(b[a>>0]|0)|0;if(!(cB(a,dA()|0)|0))if(h)break;else{k=40;break}else{f[e>>2]=0;k=38;break}}else k=38;while(0);if((k|0)==38?h:0)k=40;if((k|0)==40)f[g>>2]=f[g>>2]|2;return}function ME(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0;m=u;l=u=u+31&-32;u=u+16|0;k=l+4|0;j=a+8|0;j=Uc[f[(f[j>>2]|0)+8>>2]&127](j)|0;a=b[j+11>>0]|0;if(a<<24>>24<0)i=f[j+4>>2]|0;else i=a&255;a=b[j+12+11>>0]|0;if(a<<24>>24<0)a=f[j+16>>2]|0;else a=a&255;do if((i|0)!=(0-a|0)){f[l>>2]=f[e>>2];f[k>>2]=f[l>>2];a=(eD(d,k,j,j+24|0,h,g,0)|0)-j|0;i=f[c>>2]|0;if((i|0)==12&(a|0)==0){f[c>>2]=0;break}if((i|0)<12&(a|0)==12)f[c>>2]=i+12}else f[g>>2]=f[g>>2]|4;while(0);u=m;return}function NE(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0;h=u;i=u=u+31&-32;u=u+16|0;a=i+4|0;f[i>>2]=f[d>>2];f[a>>2]=f[i>>2];a=SE(c,a,e,g,2)|0;c=f[e>>2]|0;if((a|0)<61&(c&4|0)==0)f[b>>2]=a;else f[e>>2]=c|4;u=h;return}function OE(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0;h=u;i=u=u+31&-32;u=u+16|0;a=i+4|0;f[i>>2]=f[d>>2];f[a>>2]=f[i>>2];a=SE(c,a,e,g,1)|0;c=f[e>>2]|0;if((a|0)<7&(c&4|0)==0)f[b>>2]=a;else f[e>>2]=c|4;u=h;return}function PE(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0;h=u;i=u=u+31&-32;u=u+16|0;a=i+4|0;f[i>>2]=f[d>>2];f[a>>2]=f[i>>2];a=SE(c,a,e,g,4)|0;if(!(f[e>>2]&4)){if((a|0)<69)a=a+2e3|0;else a=(a|0)<100?a+1900|0:a;f[b>>2]=a+-1900}u=h;return}function QE(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0;h=u;i=u=u+31&-32;u=u+16|0;a=i+4|0;f[i>>2]=f[d>>2];f[a>>2]=f[i>>2];a=SE(c,a,e,g,4)|0;if(!(f[e>>2]&4))f[b>>2]=a+-1900;u=h;return}function RE(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0;a=f[c>>2]|0;do if(a){h=f[a+12>>2]|0;if((h|0)==(f[a+16>>2]|0))a=Uc[f[(f[a>>2]|0)+36>>2]&127](a)|0;else a=eA(b[h>>0]|0)|0;if(cB(a,dA()|0)|0){f[c>>2]=0;i=1;break}else{i=(f[c>>2]|0)==0;break}}else i=1;while(0);h=f[d>>2]|0;do if(h){a=f[h+12>>2]|0;if((a|0)==(f[h+16>>2]|0))a=Uc[f[(f[h>>2]|0)+36>>2]&127](h)|0;else a=eA(b[a>>0]|0)|0;if(!(cB(a,dA()|0)|0))if(i){j=h;k=16;break}else{a=6;k=38;break}else{f[d>>2]=0;k=14;break}}else k=14;while(0);if((k|0)==14)if(i){a=6;k=38}else{j=0;k=16}a:do if((k|0)==16){a=f[c>>2]|0;h=f[a+12>>2]|0;if((h|0)==(f[a+16>>2]|0))a=Uc[f[(f[a>>2]|0)+36>>2]&127](a)|0;else a=eA(b[h>>0]|0)|0;if((Wc[f[(f[g>>2]|0)+36>>2]&63](g,a&255,0)|0)<<24>>24==37){a=f[c>>2]|0;h=a+12|0;i=f[h>>2]|0;if((i|0)==(f[a+16>>2]|0))Uc[f[(f[a>>2]|0)+40>>2]&127](a)|0;else{f[h>>2]=i+1;eA(b[i>>0]|0)|0}a=f[c>>2]|0;do if(a){h=f[a+12>>2]|0;if((h|0)==(f[a+16>>2]|0))a=Uc[f[(f[a>>2]|0)+36>>2]&127](a)|0;else a=eA(b[h>>0]|0)|0;if(cB(a,dA()|0)|0){f[c>>2]=0;h=1;break}else{h=(f[c>>2]|0)==0;break}}else h=1;while(0);do if(j|0){a=f[j+12>>2]|0;if((a|0)==(f[j+16>>2]|0))a=Uc[f[(f[j>>2]|0)+36>>2]&127](j)|0;else a=eA(b[a>>0]|0)|0;if(!(cB(a,dA()|0)|0))if(h)break a;else{a=2;k=38;break a}else{f[d>>2]=0;break}}while(0);if(h){a=2;k=38}}else{a=4;k=38}}while(0);if((k|0)==38)f[e>>2]=f[e>>2]|a;return}function SE(a,c,e,g,h){a=a|0;c=c|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;i=f[a>>2]|0;do if(i){j=f[i+12>>2]|0;if((j|0)==(f[i+16>>2]|0))i=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else i=eA(b[j>>0]|0)|0;if(cB(i,dA()|0)|0){f[a>>2]=0;k=1;break}else{k=(f[a>>2]|0)==0;break}}else k=1;while(0);j=f[c>>2]|0;do if(j){i=f[j+12>>2]|0;if((i|0)==(f[j+16>>2]|0))i=Uc[f[(f[j>>2]|0)+36>>2]&127](j)|0;else i=eA(b[i>>0]|0)|0;if(!(cB(i,dA()|0)|0))if(k){s=17;break}else{s=16;break}else{f[c>>2]=0;s=14;break}}else s=14;while(0);if((s|0)==14)if(k)s=16;else{j=0;s=17}a:do if((s|0)==16){f[e>>2]=f[e>>2]|6;i=0}else if((s|0)==17){i=f[a>>2]|0;k=f[i+12>>2]|0;if((k|0)==(f[i+16>>2]|0))i=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else i=eA(b[k>>0]|0)|0;k=i&255;if(k<<24>>24>-1?(r=g+8|0,d[(f[r>>2]|0)+(i<<24>>24<<1)>>1]&2048):0){i=(Wc[f[(f[g>>2]|0)+36>>2]&63](g,k,0)|0)<<24>>24;k=f[a>>2]|0;l=k+12|0;m=f[l>>2]|0;if((m|0)==(f[k+16>>2]|0)){Uc[f[(f[k>>2]|0)+40>>2]&127](k)|0;n=j;l=j}else{f[l>>2]=m+1;eA(b[m>>0]|0)|0;n=j;l=j}while(1){i=i+-48|0;q=h+-1|0;j=f[a>>2]|0;do if(j){k=f[j+12>>2]|0;if((k|0)==(f[j+16>>2]|0))j=Uc[f[(f[j>>2]|0)+36>>2]&127](j)|0;else j=eA(b[k>>0]|0)|0;if(cB(j,dA()|0)|0){f[a>>2]=0;m=1;break}else{m=(f[a>>2]|0)==0;break}}else m=1;while(0);do if(l){j=f[l+12>>2]|0;if((j|0)==(f[l+16>>2]|0))j=Uc[f[(f[l>>2]|0)+36>>2]&127](l)|0;else j=eA(b[j>>0]|0)|0;if(cB(j,dA()|0)|0){f[c>>2]=0;p=0;j=1;o=0;break}else{p=n;j=(n|0)==0;o=n;break}}else{p=n;j=1;o=0}while(0);k=f[a>>2]|0;if(!((h|0)>1&(m^j)))break;j=f[k+12>>2]|0;if((j|0)==(f[k+16>>2]|0))j=Uc[f[(f[k>>2]|0)+36>>2]&127](k)|0;else j=eA(b[j>>0]|0)|0;k=j&255;if(k<<24>>24<=-1)break a;if(!(d[(f[r>>2]|0)+(j<<24>>24<<1)>>1]&2048))break a;i=((Wc[f[(f[g>>2]|0)+36>>2]&63](g,k,0)|0)<<24>>24)+(i*10|0)|0;j=f[a>>2]|0;k=j+12|0;l=f[k>>2]|0;if((l|0)==(f[j+16>>2]|0)){Uc[f[(f[j>>2]|0)+40>>2]&127](j)|0;h=q;n=p;l=o;continue}else{f[k>>2]=l+1;eA(b[l>>0]|0)|0;h=q;n=p;l=o;continue}}do if(k){j=f[k+12>>2]|0;if((j|0)==(f[k+16>>2]|0))j=Uc[f[(f[k>>2]|0)+36>>2]&127](k)|0;else j=eA(b[j>>0]|0)|0;if(cB(j,dA()|0)|0){f[a>>2]=0;k=1;break}else{k=(f[a>>2]|0)==0;break}}else k=1;while(0);do if(p){j=f[p+12>>2]|0;if((j|0)==(f[p+16>>2]|0))j=Uc[f[(f[p>>2]|0)+36>>2]&127](p)|0;else j=eA(b[j>>0]|0)|0;if(!(cB(j,dA()|0)|0))if(k)break a;else break;else{f[c>>2]=0;s=62;break}}else s=62;while(0);if((s|0)==62?!k:0)break;f[e>>2]=f[e>>2]|2;break}f[e>>2]=f[e>>2]|4;i=0}while(0);return i|0}function TE(a){a=a|0;eC(a);return}function UE(a){a=a|0;eC(a);QK(a);return}function VE(a){a=a|0;return 2}function WE(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0;h=u;k=u=u+31&-32;u=u+16|0;i=k+12|0;j=k+8|0;l=k+4|0;f[l>>2]=f[b>>2];f[k>>2]=f[c>>2];f[j>>2]=f[l>>2];f[i>>2]=f[k>>2];g=nF(a,j,i,d,e,g,16404,16436)|0;u=h;return g|0}function XE(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0;i=u;l=u=u+31&-32;u=u+16|0;j=l+12|0;k=l+8|0;m=l+4|0;n=a+8|0;n=Uc[f[(f[n>>2]|0)+20>>2]&127](n)|0;f[m>>2]=f[c>>2];f[l>>2]=f[d>>2];d=b[n+8+3>>0]|0;o=d<<24>>24<0;c=o?f[n>>2]|0:n;d=c+((o?f[n+4>>2]|0:d&255)<<2)|0;f[k>>2]=f[m>>2];f[j>>2]=f[l>>2];h=nF(a,k,j,e,g,h,c,d)|0;u=i;return h|0}function YE(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0;h=u;j=u=u+31&-32;u=u+16|0;i=j+4|0;dB(i,d);d=yC(i,59488)|0;zC(i);f[j>>2]=f[c>>2];f[i>>2]=f[j>>2];lF(a,g+24|0,b,i,e,d);u=h;return f[b>>2]|0}function ZE(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0;h=u;j=u=u+31&-32;u=u+16|0;i=j+4|0;dB(i,d);d=yC(i,59488)|0;zC(i);f[j>>2]=f[c>>2];f[i>>2]=f[j>>2];mF(a,g+16|0,b,i,e,d);u=h;return f[b>>2]|0}function _E(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0;h=u;j=u=u+31&-32;u=u+16|0;i=j+4|0;dB(i,d);d=yC(i,59488)|0;zC(i);f[j>>2]=f[c>>2];f[i>>2]=f[j>>2];yF(a,g+20|0,b,i,e,d);u=h;return f[b>>2]|0}function $E(a,c,d,e,g,h,i,j){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0;X=u;O=u=u+31&-32;u=u+144|0;k=O+128|0;j=O+112|0;V=O+124|0;W=O+120|0;l=O+116|0;m=O+108|0;n=O+104|0;o=O+100|0;p=O+96|0;q=O+92|0;r=O+88|0;s=O+84|0;t=O+80|0;v=O+76|0;w=O+72|0;x=O+68|0;y=O+64|0;z=O+60|0;A=O+56|0;B=O+52|0;C=O+48|0;D=O+44|0;E=O+40|0;F=O+36|0;G=O+32|0;H=O+28|0;I=O+24|0;J=O+20|0;K=O+16|0;L=O+12|0;M=O+8|0;N=O+4|0;f[g>>2]=0;dB(k,e);P=yC(k,59488)|0;zC(k);Q=h+8|0;R=h+20|0;S=h+16|0;T=h+24|0;U=a+8|0;do switch(i<<24>>24|0){case 65:case 97:{f[V>>2]=f[d>>2];f[k>>2]=f[V>>2];lF(a,T,c,k,g,P);Y=26;break}case 104:case 66:case 98:{f[W>>2]=f[d>>2];f[k>>2]=f[W>>2];mF(a,S,c,k,g,P);Y=26;break}case 99:{W=Uc[f[(f[U>>2]|0)+12>>2]&127](U)|0;f[l>>2]=f[c>>2];f[m>>2]=f[d>>2];Y=b[W+8+3>>0]|0;d=Y<<24>>24<0;i=d?f[W>>2]|0:W;Y=i+((d?f[W+4>>2]|0:Y&255)<<2)|0;f[j>>2]=f[l>>2];f[k>>2]=f[m>>2];Y=nF(a,j,k,e,g,h,i,Y)|0;f[c>>2]=Y;Y=26;break}case 101:case 100:{f[n>>2]=f[d>>2];f[k>>2]=f[n>>2];oF(a,h+12|0,c,k,g,P);Y=26;break}case 68:{f[o>>2]=f[c>>2];f[p>>2]=f[d>>2];f[j>>2]=f[o>>2];f[k>>2]=f[p>>2];Y=nF(a,j,k,e,g,h,16244,16276)|0;f[c>>2]=Y;Y=26;break}case 70:{f[q>>2]=f[c>>2];f[r>>2]=f[d>>2];f[j>>2]=f[q>>2];f[k>>2]=f[r>>2];Y=nF(a,j,k,e,g,h,16276,16308)|0;f[c>>2]=Y;Y=26;break}case 72:{f[s>>2]=f[d>>2];f[k>>2]=f[s>>2];pF(a,Q,c,k,g,P);Y=26;break}case 73:{f[t>>2]=f[d>>2];f[k>>2]=f[t>>2];qF(a,Q,c,k,g,P);Y=26;break}case 106:{f[v>>2]=f[d>>2];f[k>>2]=f[v>>2];rF(a,h+28|0,c,k,g,P);Y=26;break}case 109:{f[w>>2]=f[d>>2];f[k>>2]=f[w>>2];sF(a,S,c,k,g,P);Y=26;break}case 77:{f[x>>2]=f[d>>2];f[k>>2]=f[x>>2];tF(a,h+4|0,c,k,g,P);Y=26;break}case 116:case 110:{f[y>>2]=f[d>>2];f[k>>2]=f[y>>2];uF(a,c,k,g,P);Y=26;break}case 112:{f[z>>2]=f[d>>2];f[k>>2]=f[z>>2];vF(a,Q,c,k,g,P);Y=26;break}case 114:{f[A>>2]=f[c>>2];f[B>>2]=f[d>>2];f[j>>2]=f[A>>2];f[k>>2]=f[B>>2];Y=nF(a,j,k,e,g,h,16308,16352)|0;f[c>>2]=Y;Y=26;break}case 82:{f[C>>2]=f[c>>2];f[D>>2]=f[d>>2];f[j>>2]=f[C>>2];f[k>>2]=f[D>>2];Y=nF(a,j,k,e,g,h,16352,16372)|0;f[c>>2]=Y;Y=26;break}case 83:{f[E>>2]=f[d>>2];f[k>>2]=f[E>>2];wF(a,h,c,k,g,P);Y=26;break}case 84:{f[F>>2]=f[c>>2];f[G>>2]=f[d>>2];f[j>>2]=f[F>>2];f[k>>2]=f[G>>2];Y=nF(a,j,k,e,g,h,16372,16404)|0;f[c>>2]=Y;Y=26;break}case 119:{f[H>>2]=f[d>>2];f[k>>2]=f[H>>2];xF(a,T,c,k,g,P);Y=26;break}case 120:{i=f[(f[a>>2]|0)+20>>2]|0;f[I>>2]=f[c>>2];f[J>>2]=f[d>>2];f[j>>2]=f[I>>2];f[k>>2]=f[J>>2];j=$c[i&63](a,j,k,e,g,h)|0;break}case 88:{W=Uc[f[(f[U>>2]|0)+24>>2]&127](U)|0;f[K>>2]=f[c>>2];f[L>>2]=f[d>>2];Y=b[W+8+3>>0]|0;d=Y<<24>>24<0;i=d?f[W>>2]|0:W;Y=i+((d?f[W+4>>2]|0:Y&255)<<2)|0;f[j>>2]=f[K>>2];f[k>>2]=f[L>>2];Y=nF(a,j,k,e,g,h,i,Y)|0;f[c>>2]=Y;Y=26;break}case 121:{f[M>>2]=f[d>>2];f[k>>2]=f[M>>2];yF(a,R,c,k,g,P);Y=26;break}case 89:{f[N>>2]=f[d>>2];f[k>>2]=f[N>>2];zF(a,R,c,k,g,P);Y=26;break}case 37:{f[O>>2]=f[d>>2];f[k>>2]=f[O>>2];AF(a,c,k,g,P);Y=26;break}default:{f[g>>2]=f[g>>2]|4;Y=26}}while(0);if((Y|0)==26)j=f[c>>2]|0;u=X;return j|0}function aF(a){a=a|0;if((b[57e3]|0)==0?oM(57e3)|0:0){kF();f[15285]=60972}return f[15285]|0}function bF(a){a=a|0;if((b[56984]|0)==0?oM(56984)|0:0){jF();f[15242]=60680}return f[15242]|0}function cF(a){a=a|0;if((b[56968]|0)==0?oM(56968)|0:0){iF();f[15169]=60388}return f[15169]|0}function dF(a){a=a|0;var c=0,d=0,e=0,g=0;e=u;a=u=u+31&-32;u=u+16|0;if((b[56960]|0)==0?oM(56960)|0:0){f[15094]=0;f[15095]=0;f[15096]=0;d=hF(15276)|0;if(d>>>0>1073741807)XK(60376);do if(d>>>0>=2){c=d+4&-4;if(c>>>0>1073741823)Gb();else{g=OK(c<<2)|0;f[15094]=g;f[15096]=c|-2147483648;f[15095]=d;break}}else{b[60387]=d;g=60376}while(0);xA(g,15276,d)|0;f[a>>2]=0;kC(g+(d<<2)|0,a)}u=e;return 60376}function eF(a){a=a|0;var c=0,d=0,e=0,g=0;e=u;a=u=u+31&-32;u=u+16|0;if((b[56952]|0)==0?oM(56952)|0:0){f[15091]=0;f[15092]=0;f[15093]=0;d=hF(15228)|0;if(d>>>0>1073741807)XK(60364);do if(d>>>0>=2){c=d+4&-4;if(c>>>0>1073741823)Gb();else{g=OK(c<<2)|0;f[15091]=g;f[15093]=c|-2147483648;f[15092]=d;break}}else{b[60375]=d;g=60364}while(0);xA(g,15228,d)|0;f[a>>2]=0;kC(g+(d<<2)|0,a)}u=e;return 60364}function fF(a){a=a|0;var c=0,d=0,e=0,g=0;e=u;a=u=u+31&-32;u=u+16|0;if((b[56944]|0)==0?oM(56944)|0:0){f[15088]=0;f[15089]=0;f[15090]=0;d=hF(15192)|0;if(d>>>0>1073741807)XK(60352);do if(d>>>0>=2){c=d+4&-4;if(c>>>0>1073741823)Gb();else{g=OK(c<<2)|0;f[15088]=g;f[15090]=c|-2147483648;f[15089]=d;break}}else{b[60363]=d;g=60352}while(0);xA(g,15192,d)|0;f[a>>2]=0;kC(g+(d<<2)|0,a)}u=e;return 60352}function gF(a){a=a|0;var c=0,d=0,e=0,g=0;e=u;a=u=u+31&-32;u=u+16|0;if((b[56936]|0)==0?oM(56936)|0:0){f[15085]=0;f[15086]=0;f[15087]=0;d=hF(15156)|0;if(d>>>0>1073741807)XK(60340);do if(d>>>0>=2){c=d+4&-4;if(c>>>0>1073741823)Gb();else{g=OK(c<<2)|0;f[15085]=g;f[15087]=c|-2147483648;f[15086]=d;break}}else{b[60351]=d;g=60340}while(0);xA(g,15156,d)|0;f[a>>2]=0;kC(g+(d<<2)|0,a)}u=e;return 60340}function hF(a){a=a|0;return dy(a)|0}function iF(){var a=0,c=0;if((b[56976]|0)==0?oM(56976)|0:0){c=60388;do{f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[c+(a<<2)>>2]=0;a=a+1|0}c=c+12|0}while((c|0)!=60676)}qL(60388,15360)|0;qL(60400,15372)|0;return}function jF(){var a=0,c=0;if((b[56992]|0)==0?oM(56992)|0:0){c=60680;do{f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[c+(a<<2)>>2]=0;a=a+1|0}c=c+12|0}while((c|0)!=60968)}qL(60680,15384)|0;qL(60692,15416)|0;qL(60704,15452)|0;qL(60716,15476)|0;qL(60728,15500)|0;qL(60740,15516)|0;qL(60752,15536)|0;qL(60764,15556)|0;qL(60776,15584)|0;qL(60788,15624)|0;qL(60800,15656)|0;qL(60812,15692)|0;qL(60824,15728)|0;qL(60836,15744)|0;qL(60848,15760)|0;qL(60860,15776)|0;qL(60872,15500)|0;qL(60884,15792)|0;qL(60896,15808)|0;qL(60908,15824)|0;qL(60920,15840)|0;qL(60932,15856)|0;qL(60944,15872)|0;qL(60956,15888)|0;return}function kF(){var a=0,c=0;if((b[57008]|0)==0?oM(57008)|0:0){c=60972;do{f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[c+(a<<2)>>2]=0;a=a+1|0}c=c+12|0}while((c|0)!=61140)}qL(60972,15904)|0;qL(60984,15932)|0;qL(60996,15960)|0;qL(61008,15992)|0;qL(61020,16032)|0;qL(61032,16068)|0;qL(61044,16096)|0;qL(61056,16132)|0;qL(61068,16148)|0;qL(61080,16164)|0;qL(61092,16180)|0;qL(61104,16196)|0;qL(61116,16212)|0;qL(61128,16228)|0;return}function lF(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0;h=u;j=u=u+31&-32;u=u+16|0;i=j+4|0;a=a+8|0;a=Uc[f[f[a>>2]>>2]&127](a)|0;f[j>>2]=f[d>>2];f[i>>2]=f[j>>2];a=(FD(c,i,a,a+168|0,g,e,0)|0)-a|0;if((a|0)<168)f[b>>2]=((a|0)/12|0|0)%7|0;u=h;return}function mF(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0;h=u;j=u=u+31&-32;u=u+16|0;i=j+4|0;a=a+8|0;a=Uc[f[(f[a>>2]|0)+4>>2]&127](a)|0;f[j>>2]=f[d>>2];f[i>>2]=f[j>>2];a=(FD(c,i,a,a+288|0,g,e,0)|0)-a|0;if((a|0)<288)f[b>>2]=((a|0)/12|0|0)%12|0;u=h;return}function nF(a,b,c,d,e,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0;x=u;v=u=u+31&-32;u=u+16|0;r=v+12|0;q=v+8|0;t=v+4|0;dB(r,d);s=yC(r,59488)|0;zC(r);f[e>>2]=0;j=0;a:while(1){p=(h|0)!=(i|0);k=j;while(1){j=f[b>>2]|0;if(!(p&(k|0)==0))break a;l=j;if(j){k=f[j+12>>2]|0;if((k|0)==(f[j+16>>2]|0))k=Uc[f[(f[j>>2]|0)+36>>2]&127](j)|0;else k=wA(f[k>>2]|0)|0;if(eB(k,vA()|0)|0){f[b>>2]=0;j=0;n=1;o=0}else{n=0;o=l}}else{j=0;n=1;o=l}m=f[c>>2]|0;k=m;do if(m){l=f[m+12>>2]|0;if((l|0)==(f[m+16>>2]|0))l=Uc[f[(f[m>>2]|0)+36>>2]&127](m)|0;else l=wA(f[l>>2]|0)|0;if(!(eB(l,vA()|0)|0))if(n)break;else{w=58;break a}else{f[c>>2]=0;k=0;w=16;break}}else w=16;while(0);if((w|0)==16){w=0;if(n){w=58;break a}else m=0}if((Wc[f[(f[s>>2]|0)+52>>2]&63](s,f[h>>2]|0,0)|0)<<24>>24==37){w=19;break}if(Wc[f[(f[s>>2]|0)+12>>2]&63](s,8192,f[h>>2]|0)|0){w=26;break}l=j+12|0;k=f[l>>2]|0;m=j+16|0;if((k|0)==(f[m>>2]|0))k=Uc[f[(f[j>>2]|0)+36>>2]&127](j)|0;else k=wA(f[k>>2]|0)|0;o=Vc[f[(f[s>>2]|0)+28>>2]&31](s,k)|0;if((o|0)==(Vc[f[(f[s>>2]|0)+28>>2]&31](s,f[h>>2]|0)|0)){w=54;break}f[e>>2]=4;k=4}b:do if((w|0)==19){w=0;n=h+4|0;if((n|0)==(i|0)){w=58;break a}l=Wc[f[(f[s>>2]|0)+52>>2]&63](s,f[n>>2]|0,0)|0;switch(l<<24>>24){case 48:case 69:{h=h+8|0;if((h|0)==(i|0)){w=58;break a}m=l;j=Wc[f[(f[s>>2]|0)+52>>2]&63](s,f[h>>2]|0,0)|0;h=n;break}default:{m=0;j=l}}p=f[(f[a>>2]|0)+36>>2]|0;f[t>>2]=o;f[v>>2]=k;f[q>>2]=f[t>>2];f[r>>2]=f[v>>2];p=bd[p&15](a,q,r,d,e,g,j,m)|0;f[b>>2]=p;h=h+8|0}else if((w|0)==26){while(1){w=0;h=h+4|0;if((h|0)==(i|0)){h=i;break}if(Wc[f[(f[s>>2]|0)+12>>2]&63](s,8192,f[h>>2]|0)|0)w=26;else break}k=m;while(1){if(j){l=f[j+12>>2]|0;if((l|0)==(f[j+16>>2]|0))l=Uc[f[(f[j>>2]|0)+36>>2]&127](j)|0;else l=wA(f[l>>2]|0)|0;if(eB(l,vA()|0)|0){f[b>>2]=0;n=1;j=0}else n=0}else{n=1;j=0}do if(m){l=f[m+12>>2]|0;if((l|0)==(f[m+16>>2]|0))l=Uc[f[(f[m>>2]|0)+36>>2]&127](m)|0;else l=wA(f[l>>2]|0)|0;if(!(eB(l,vA()|0)|0))if(n^(k|0)==0){o=k;m=k;break}else break b;else{f[c>>2]=0;k=0;w=41;break}}else w=41;while(0);if((w|0)==41){w=0;if(n)break b;else{o=k;m=0}}l=j+12|0;k=f[l>>2]|0;n=j+16|0;if((k|0)==(f[n>>2]|0))k=Uc[f[(f[j>>2]|0)+36>>2]&127](j)|0;else k=wA(f[k>>2]|0)|0;if(!(Wc[f[(f[s>>2]|0)+12>>2]&63](s,8192,k)|0))break b;k=f[l>>2]|0;if((k|0)==(f[n>>2]|0)){Uc[f[(f[j>>2]|0)+40>>2]&127](j)|0;k=o;continue}else{f[l>>2]=k+4;wA(f[k>>2]|0)|0;k=o;continue}}}else if((w|0)==54){w=0;h=h+4|0;k=f[l>>2]|0;if((k|0)==(f[m>>2]|0)){Uc[f[(f[j>>2]|0)+40>>2]&127](j)|0;break}else{f[l>>2]=k+4;wA(f[k>>2]|0)|0;break}}while(0);j=f[e>>2]|0}if((w|0)==58)f[e>>2]=4;if(j){h=f[j+12>>2]|0;if((h|0)==(f[j+16>>2]|0))h=Uc[f[(f[j>>2]|0)+36>>2]&127](j)|0;else h=wA(f[h>>2]|0)|0;if(eB(h,vA()|0)|0){f[b>>2]=0;j=0;l=1}else l=0}else{j=0;l=1}h=f[c>>2]|0;do if(h){k=f[h+12>>2]|0;if((k|0)==(f[h+16>>2]|0))h=Uc[f[(f[h>>2]|0)+36>>2]&127](h)|0;else h=wA(f[k>>2]|0)|0;if(!(eB(h,vA()|0)|0))if(l)break;else{w=73;break}else{f[c>>2]=0;w=71;break}}else w=71;while(0);if((w|0)==71?l:0)w=73;if((w|0)==73)f[e>>2]=f[e>>2]|2;u=x;return j|0}function oF(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0;h=u;i=u=u+31&-32;u=u+16|0;a=i+4|0;f[i>>2]=f[d>>2];f[a>>2]=f[i>>2];a=BF(c,a,e,g,2)|0;c=f[e>>2]|0;if((a+-1|0)>>>0<31&(c&4|0)==0)f[b>>2]=a;else f[e>>2]=c|4;u=h;return}function pF(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0;h=u;i=u=u+31&-32;u=u+16|0;a=i+4|0;f[i>>2]=f[d>>2];f[a>>2]=f[i>>2];a=BF(c,a,e,g,2)|0;c=f[e>>2]|0;if((a|0)<24&(c&4|0)==0)f[b>>2]=a;else f[e>>2]=c|4;u=h;return}function qF(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0;h=u;i=u=u+31&-32;u=u+16|0;a=i+4|0;f[i>>2]=f[d>>2];f[a>>2]=f[i>>2];a=BF(c,a,e,g,2)|0;c=f[e>>2]|0;if((a+-1|0)>>>0<12&(c&4|0)==0)f[b>>2]=a;else f[e>>2]=c|4;u=h;return}function rF(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0;h=u;i=u=u+31&-32;u=u+16|0;a=i+4|0;f[i>>2]=f[d>>2];f[a>>2]=f[i>>2];a=BF(c,a,e,g,3)|0;c=f[e>>2]|0;if((a|0)<366&(c&4|0)==0)f[b>>2]=a;else f[e>>2]=c|4;u=h;return}function sF(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0;h=u;i=u=u+31&-32;u=u+16|0;a=i+4|0;f[i>>2]=f[d>>2];f[a>>2]=f[i>>2];a=BF(c,a,e,g,2)|0;c=f[e>>2]|0;if((a|0)<13&(c&4|0)==0)f[b>>2]=a+-1;else f[e>>2]=c|4;u=h;return}function tF(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0;h=u;i=u=u+31&-32;u=u+16|0;a=i+4|0;f[i>>2]=f[d>>2];f[a>>2]=f[i>>2];a=BF(c,a,e,g,2)|0;c=f[e>>2]|0;if((a|0)<60&(c&4|0)==0)f[b>>2]=a;else f[e>>2]=c|4;u=h;return}function uF(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0;a:while(1){a=f[b>>2]|0;do if(a){g=f[a+12>>2]|0;if((g|0)==(f[a+16>>2]|0))a=Uc[f[(f[a>>2]|0)+36>>2]&127](a)|0;else a=wA(f[g>>2]|0)|0;if(eB(a,vA()|0)|0){f[b>>2]=0;h=1;break}else{h=(f[b>>2]|0)==0;break}}else h=1;while(0);g=f[c>>2]|0;do if(g){a=f[g+12>>2]|0;if((a|0)==(f[g+16>>2]|0))a=Uc[f[(f[g>>2]|0)+36>>2]&127](g)|0;else a=wA(f[a>>2]|0)|0;if(!(eB(a,vA()|0)|0))if(h){h=g;break}else{h=g;break a}else{f[c>>2]=0;i=15;break}}else i=15;while(0);if((i|0)==15){i=0;if(h){h=0;break}else h=0}a=f[b>>2]|0;g=f[a+12>>2]|0;if((g|0)==(f[a+16>>2]|0))a=Uc[f[(f[a>>2]|0)+36>>2]&127](a)|0;else a=wA(f[g>>2]|0)|0;if(!(Wc[f[(f[e>>2]|0)+12>>2]&63](e,8192,a)|0))break;a=f[b>>2]|0;g=a+12|0;h=f[g>>2]|0;if((h|0)==(f[a+16>>2]|0)){Uc[f[(f[a>>2]|0)+40>>2]&127](a)|0;continue}else{f[g>>2]=h+4;wA(f[h>>2]|0)|0;continue}}a=f[b>>2]|0;do if(a){g=f[a+12>>2]|0;if((g|0)==(f[a+16>>2]|0))a=Uc[f[(f[a>>2]|0)+36>>2]&127](a)|0;else a=wA(f[g>>2]|0)|0;if(eB(a,vA()|0)|0){f[b>>2]=0;g=1;break}else{g=(f[b>>2]|0)==0;break}}else g=1;while(0);do if(h){a=f[h+12>>2]|0;if((a|0)==(f[h+16>>2]|0))a=Uc[f[(f[h>>2]|0)+36>>2]&127](h)|0;else a=wA(f[a>>2]|0)|0;if(!(eB(a,vA()|0)|0))if(g)break;else{i=39;break}else{f[c>>2]=0;i=37;break}}else i=37;while(0);if((i|0)==37?g:0)i=39;if((i|0)==39)f[d>>2]=f[d>>2]|2;return}function vF(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0;m=u;l=u=u+31&-32;u=u+16|0;k=l+4|0;j=a+8|0;j=Uc[f[(f[j>>2]|0)+8>>2]&127](j)|0;a=b[j+8+3>>0]|0;if(a<<24>>24<0)i=f[j+4>>2]|0;else i=a&255;a=b[j+20+3>>0]|0;if(a<<24>>24<0)a=f[j+16>>2]|0;else a=a&255;do if((i|0)!=(0-a|0)){f[l>>2]=f[e>>2];f[k>>2]=f[l>>2];a=(FD(d,k,j,j+24|0,h,g,0)|0)-j|0;i=f[c>>2]|0;if((i|0)==12&(a|0)==0){f[c>>2]=0;break}if((i|0)<12&(a|0)==12)f[c>>2]=i+12}else f[g>>2]=f[g>>2]|4;while(0);u=m;return}function wF(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0;h=u;i=u=u+31&-32;u=u+16|0;a=i+4|0;f[i>>2]=f[d>>2];f[a>>2]=f[i>>2];a=BF(c,a,e,g,2)|0;c=f[e>>2]|0;if((a|0)<61&(c&4|0)==0)f[b>>2]=a;else f[e>>2]=c|4;u=h;return}function xF(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0;h=u;i=u=u+31&-32;u=u+16|0;a=i+4|0;f[i>>2]=f[d>>2];f[a>>2]=f[i>>2];a=BF(c,a,e,g,1)|0;c=f[e>>2]|0;if((a|0)<7&(c&4|0)==0)f[b>>2]=a;else f[e>>2]=c|4;u=h;return}function yF(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0;h=u;i=u=u+31&-32;u=u+16|0;a=i+4|0;f[i>>2]=f[d>>2];f[a>>2]=f[i>>2];a=BF(c,a,e,g,4)|0;if(!(f[e>>2]&4)){if((a|0)<69)a=a+2e3|0;else a=(a|0)<100?a+1900|0:a;f[b>>2]=a+-1900}u=h;return}function zF(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0;h=u;i=u=u+31&-32;u=u+16|0;a=i+4|0;f[i>>2]=f[d>>2];f[a>>2]=f[i>>2];a=BF(c,a,e,g,4)|0;if(!(f[e>>2]&4))f[b>>2]=a+-1900;u=h;return}function AF(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0;a=f[b>>2]|0;do if(a){g=f[a+12>>2]|0;if((g|0)==(f[a+16>>2]|0))a=Uc[f[(f[a>>2]|0)+36>>2]&127](a)|0;else a=wA(f[g>>2]|0)|0;if(eB(a,vA()|0)|0){f[b>>2]=0;h=1;break}else{h=(f[b>>2]|0)==0;break}}else h=1;while(0);g=f[c>>2]|0;do if(g){a=f[g+12>>2]|0;if((a|0)==(f[g+16>>2]|0))a=Uc[f[(f[g>>2]|0)+36>>2]&127](g)|0;else a=wA(f[a>>2]|0)|0;if(!(eB(a,vA()|0)|0))if(h){i=g;j=16;break}else{a=6;j=38;break}else{f[c>>2]=0;j=14;break}}else j=14;while(0);if((j|0)==14)if(h){a=6;j=38}else{i=0;j=16}a:do if((j|0)==16){a=f[b>>2]|0;g=f[a+12>>2]|0;if((g|0)==(f[a+16>>2]|0))a=Uc[f[(f[a>>2]|0)+36>>2]&127](a)|0;else a=wA(f[g>>2]|0)|0;if((Wc[f[(f[e>>2]|0)+52>>2]&63](e,a,0)|0)<<24>>24==37){a=f[b>>2]|0;g=a+12|0;h=f[g>>2]|0;if((h|0)==(f[a+16>>2]|0))Uc[f[(f[a>>2]|0)+40>>2]&127](a)|0;else{f[g>>2]=h+4;wA(f[h>>2]|0)|0}a=f[b>>2]|0;do if(a){g=f[a+12>>2]|0;if((g|0)==(f[a+16>>2]|0))a=Uc[f[(f[a>>2]|0)+36>>2]&127](a)|0;else a=wA(f[g>>2]|0)|0;if(eB(a,vA()|0)|0){f[b>>2]=0;g=1;break}else{g=(f[b>>2]|0)==0;break}}else g=1;while(0);do if(i|0){a=f[i+12>>2]|0;if((a|0)==(f[i+16>>2]|0))a=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else a=wA(f[a>>2]|0)|0;if(!(eB(a,vA()|0)|0))if(g)break a;else{a=2;j=38;break a}else{f[c>>2]=0;break}}while(0);if(g){a=2;j=38}}else{a=4;j=38}}while(0);if((j|0)==38)f[d>>2]=f[d>>2]|a;return}function BF(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;g=f[a>>2]|0;do if(g){h=f[g+12>>2]|0;if((h|0)==(f[g+16>>2]|0))g=Uc[f[(f[g>>2]|0)+36>>2]&127](g)|0;else g=wA(f[h>>2]|0)|0;if(eB(g,vA()|0)|0){f[a>>2]=0;i=1;break}else{i=(f[a>>2]|0)==0;break}}else i=1;while(0);h=f[b>>2]|0;do if(h){g=f[h+12>>2]|0;if((g|0)==(f[h+16>>2]|0))g=Uc[f[(f[h>>2]|0)+36>>2]&127](h)|0;else g=wA(f[g>>2]|0)|0;if(!(eB(g,vA()|0)|0))if(i){p=17;break}else{p=16;break}else{f[b>>2]=0;p=14;break}}else p=14;while(0);if((p|0)==14)if(i)p=16;else{h=0;p=17}a:do if((p|0)==16){f[c>>2]=f[c>>2]|6;g=0}else if((p|0)==17){g=f[a>>2]|0;i=f[g+12>>2]|0;if((i|0)==(f[g+16>>2]|0))g=Uc[f[(f[g>>2]|0)+36>>2]&127](g)|0;else g=wA(f[i>>2]|0)|0;if(!(Wc[f[(f[d>>2]|0)+12>>2]&63](d,2048,g)|0)){f[c>>2]=f[c>>2]|4;g=0;break}g=(Wc[f[(f[d>>2]|0)+52>>2]&63](d,g,0)|0)<<24>>24;i=f[a>>2]|0;j=i+12|0;k=f[j>>2]|0;if((k|0)==(f[i+16>>2]|0)){Uc[f[(f[i>>2]|0)+40>>2]&127](i)|0;l=h;j=h}else{f[j>>2]=k+4;wA(f[k>>2]|0)|0;l=h;j=h}while(1){g=g+-48|0;o=e+-1|0;h=f[a>>2]|0;do if(h){i=f[h+12>>2]|0;if((i|0)==(f[h+16>>2]|0))h=Uc[f[(f[h>>2]|0)+36>>2]&127](h)|0;else h=wA(f[i>>2]|0)|0;if(eB(h,vA()|0)|0){f[a>>2]=0;k=1;break}else{k=(f[a>>2]|0)==0;break}}else k=1;while(0);do if(j){h=f[j+12>>2]|0;if((h|0)==(f[j+16>>2]|0))h=Uc[f[(f[j>>2]|0)+36>>2]&127](j)|0;else h=wA(f[h>>2]|0)|0;if(eB(h,vA()|0)|0){f[b>>2]=0;n=0;h=1;m=0;break}else{n=l;h=(l|0)==0;m=l;break}}else{n=l;h=1;m=0}while(0);i=f[a>>2]|0;if(!((e|0)>1&(k^h)))break;h=f[i+12>>2]|0;if((h|0)==(f[i+16>>2]|0))h=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else h=wA(f[h>>2]|0)|0;if(!(Wc[f[(f[d>>2]|0)+12>>2]&63](d,2048,h)|0))break a;g=((Wc[f[(f[d>>2]|0)+52>>2]&63](d,h,0)|0)<<24>>24)+(g*10|0)|0;h=f[a>>2]|0;i=h+12|0;j=f[i>>2]|0;if((j|0)==(f[h+16>>2]|0)){Uc[f[(f[h>>2]|0)+40>>2]&127](h)|0;e=o;l=n;j=m;continue}else{f[i>>2]=j+4;wA(f[j>>2]|0)|0;e=o;l=n;j=m;continue}}do if(i){h=f[i+12>>2]|0;if((h|0)==(f[i+16>>2]|0))h=Uc[f[(f[i>>2]|0)+36>>2]&127](i)|0;else h=wA(f[h>>2]|0)|0;if(eB(h,vA()|0)|0){f[a>>2]=0;i=1;break}else{i=(f[a>>2]|0)==0;break}}else i=1;while(0);do if(n){h=f[n+12>>2]|0;if((h|0)==(f[n+16>>2]|0))h=Uc[f[(f[n>>2]|0)+36>>2]&127](n)|0;else h=wA(f[h>>2]|0)|0;if(!(eB(h,vA()|0)|0))if(i)break a;else break;else{f[b>>2]=0;p=60;break}}else p=60;while(0);if((p|0)==60?!i:0)break;f[c>>2]=f[c>>2]|2}while(0);return g|0}function CF(a){a=a|0;HF(a+8|0);eC(a);return}function DF(a){a=a|0;HF(a+8|0);eC(a);QK(a);return}function EF(a,c,d,e,g,h,i){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;var j=0;j=u;e=u=u+31&-32;u=u+112|0;d=e+4|0;f[e>>2]=d+100;FF(a+8|0,d,e,g,h,i);i=f[e>>2]|0;h=d;d=f[c>>2]|0;while(1){if((h|0)==(i|0))break;e=b[h>>0]|0;if(!d)d=0;else{a=d+24|0;g=f[a>>2]|0;if((g|0)==(f[d+28>>2]|0)){c=f[(f[d>>2]|0)+52>>2]|0;e=eA(e)|0;e=Vc[c&31](d,e)|0}else{f[a>>2]=g+1;b[g>>0]=e;e=eA(e)|0}c=cB(e,dA()|0)|0;d=c?0:d}h=h+1|0}u=j;return d|0}function FF(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0;l=u;i=u=u+31&-32;u=u+16|0;b[i>>0]=37;j=i+1|0;b[j>>0]=g;k=i+2|0;b[k>>0]=h;b[i+3>>0]=0;if(h<<24>>24){b[j>>0]=h;b[k>>0]=g}k=GF(c,f[d>>2]|0)|0;k=c+(Wb(c|0,k|0,i|0,e|0,f[a>>2]|0)|0)|0;f[d>>2]=k;u=l;return}function GF(a,b){a=a|0;b=b|0;return b-a|0}function HF(a){a=a|0;var b=0;b=f[a>>2]|0;if((b|0)!=(BC()|0))zz(f[a>>2]|0);return}function IF(a){a=a|0;HF(a+8|0);eC(a);return}function JF(a){a=a|0;HF(a+8|0);eC(a);QK(a);return}function KF(a,b,c,d,e,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0;i=u;d=u=u+31&-32;u=u+416|0;c=d+8|0;f[d>>2]=c+400;LF(a+8|0,c,d,e,g,h);h=f[d>>2]|0;g=c;c=f[b>>2]|0;while(1){if((g|0)==(h|0))break;d=f[g>>2]|0;if(!c)c=0;else{a=c+24|0;e=f[a>>2]|0;if((e|0)==(f[c+28>>2]|0)){b=f[(f[c>>2]|0)+52>>2]|0;d=wA(d)|0;d=Vc[b&31](c,d)|0}else{f[a>>2]=e+4;f[e>>2]=d;d=wA(d)|0}b=eB(d,vA()|0)|0;c=b?0:c}g=g+4|0}u=i;return c|0}function LF(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0;h=u;j=u=u+31&-32;u=u+128|0;k=j+16|0;l=j+12|0;i=j;j=j+8|0;f[l>>2]=k+100;FF(a,k,l,d,e,g);d=i;f[d>>2]=0;f[d+4>>2]=0;f[j>>2]=k;d=MF(b,f[c>>2]|0)|0;a=Dz(f[a>>2]|0)|0;d=jy(b,j,d,i)|0;if(a|0)Dz(a)|0;if((d|0)==-1)NF(0);else{f[c>>2]=b+(d<<2);u=h;return}}function MF(a,b){a=a|0;b=b|0;return b-a>>2|0}function NF(a){a=a|0;Gb()}function OF(a){a=a|0;eC(a);return}function PF(a){a=a|0;eC(a);QK(a);return}function QF(a){a=a|0;return 127}function RF(a){a=a|0;return 127}function SF(a,b){a=a|0;b=b|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;b=0;while(1){if((b|0)==3)break;f[a+(b<<2)>>2]=0;b=b+1|0}return}function TF(a,b){a=a|0;b=b|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;b=0;while(1){if((b|0)==3)break;f[a+(b<<2)>>2]=0;b=b+1|0}return}function UF(a,b){a=a|0;b=b|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;b=0;while(1){if((b|0)==3)break;f[a+(b<<2)>>2]=0;b=b+1|0}return}function VF(a,c){a=a|0;c=c|0;var d=0;c=u;d=u=u+31&-32;u=u+16|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;b[a+11>>0]=1;ZF(a,1,45)|0;b[d>>0]=0;$A(a+1|0,d);u=c;return}function WF(a){a=a|0;return 0}function XF(a,c){a=a|0;c=c|0;b[a>>0]=2;b[a+1>>0]=3;b[a+2>>0]=0;b[a+3>>0]=4;return}function YF(a,c){a=a|0;c=c|0;b[a>>0]=2;b[a+1>>0]=3;b[a+2>>0]=0;b[a+3>>0]=4;return}function ZF(a,b,c){a=a|0;b=b|0;c=c|0;if(b|0)IM(a|0,(eA(c)|0)&255|0,b|0)|0;return a|0}function _F(a){a=a|0;eC(a);return}function $F(a){a=a|0;eC(a);QK(a);return}function aG(a){a=a|0;return 127}function bG(a){a=a|0;return 127}function cG(a,b){a=a|0;b=b|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;b=0;while(1){if((b|0)==3)break;f[a+(b<<2)>>2]=0;b=b+1|0}return}function dG(a,b){a=a|0;b=b|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;b=0;while(1){if((b|0)==3)break;f[a+(b<<2)>>2]=0;b=b+1|0}return}function eG(a,b){a=a|0;b=b|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;b=0;while(1){if((b|0)==3)break;f[a+(b<<2)>>2]=0;b=b+1|0}return}function fG(a,c){a=a|0;c=c|0;var d=0;c=u;d=u=u+31&-32;u=u+16|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;b[a+11>>0]=1;ZF(a,1,45)|0;b[d>>0]=0;$A(a+1|0,d);u=c;return}function gG(a){a=a|0;return 0}function hG(a,c){a=a|0;c=c|0;b[a>>0]=2;b[a+1>>0]=3;b[a+2>>0]=0;b[a+3>>0]=4;return}function iG(a,c){a=a|0;c=c|0;b[a>>0]=2;b[a+1>>0]=3;b[a+2>>0]=0;b[a+3>>0]=4;return}function jG(a){a=a|0;eC(a);return}function kG(a){a=a|0;eC(a);QK(a);return}function lG(a){a=a|0;return 2147483647}function mG(a){a=a|0;return 2147483647}function nG(a,b){a=a|0;b=b|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;b=0;while(1){if((b|0)==3)break;f[a+(b<<2)>>2]=0;b=b+1|0}return}function oG(a,b){a=a|0;b=b|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;b=0;while(1){if((b|0)==3)break;f[a+(b<<2)>>2]=0;b=b+1|0}return}function pG(a,b){a=a|0;b=b|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;b=0;while(1){if((b|0)==3)break;f[a+(b<<2)>>2]=0;b=b+1|0}return}function qG(a,c){a=a|0;c=c|0;var d=0;c=u;d=u=u+31&-32;u=u+16|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;b[a+8+3>>0]=1;gE(a,1,45)|0;f[d>>2]=0;kC(a+4|0,d);u=c;return}function rG(a){a=a|0;return 0}function sG(a,c){a=a|0;c=c|0;b[a>>0]=2;b[a+1>>0]=3;b[a+2>>0]=0;b[a+3>>0]=4;return}function tG(a,c){a=a|0;c=c|0;b[a>>0]=2;b[a+1>>0]=3;b[a+2>>0]=0;b[a+3>>0]=4;return}function uG(a){a=a|0;eC(a);return}function vG(a){a=a|0;eC(a);QK(a);return}function wG(a){a=a|0;return 2147483647}function xG(a){a=a|0;return 2147483647}function yG(a,b){a=a|0;b=b|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;b=0;while(1){if((b|0)==3)break;f[a+(b<<2)>>2]=0;b=b+1|0}return}function zG(a,b){a=a|0;b=b|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;b=0;while(1){if((b|0)==3)break;f[a+(b<<2)>>2]=0;b=b+1|0}return}function AG(a,b){a=a|0;b=b|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;b=0;while(1){if((b|0)==3)break;f[a+(b<<2)>>2]=0;b=b+1|0}return}function BG(a,c){a=a|0;c=c|0;var d=0;c=u;d=u=u+31&-32;u=u+16|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;b[a+8+3>>0]=1;gE(a,1,45)|0;f[d>>2]=0;kC(a+4|0,d);u=c;return}function CG(a){a=a|0;return 0}function DG(a,c){a=a|0;c=c|0;b[a>>0]=2;b[a+1>>0]=3;b[a+2>>0]=0;b[a+3>>0]=4;return}function EG(a,c){a=a|0;c=c|0;b[a>>0]=2;b[a+1>>0]=3;b[a+2>>0]=0;b[a+3>>0]=4;return}function FG(a){a=a|0;eC(a);return}function GG(a){a=a|0;eC(a);QK(a);return}function HG(a,c,d,e,g,h,i){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0;x=u;o=u=u+31&-32;u=u+240|0;n=o+24|0;q=o;m=o+140|0;w=o+16|0;p=o+12|0;s=o+8|0;j=o+136|0;y=o+4|0;o=o+36|0;f[w>>2]=m;v=w+4|0;f[v>>2]=444;dB(s,g);a=yC(s,59456)|0;b[j>>0]=0;f[y>>2]=f[d>>2];l=f[g+4>>2]|0;f[n>>2]=f[y>>2];if(KG(c,n,e,s,l,h,j,a,w,p,m+100|0)|0){Xc[f[(f[a>>2]|0)+32>>2]&7](a,55169,55179,n)|0;l=f[p>>2]|0;e=f[w>>2]|0;a=l-e|0;if((a|0)>98){a=dx(a+2|0)|0;if(!a)SK();else{k=a;r=a}}else{k=o;r=0}if(!(b[j>>0]|0))a=k;else{b[k>>0]=45;a=k+1|0}k=n+10|0;m=n;j=e;g=a;a=l;while(1){if(j>>>0>=a>>>0)break;e=b[j>>0]|0;a=n;while(1){if((a|0)==(k|0)){a=k;break}if((b[a>>0]|0)==e<<24>>24)break;a=a+1|0}b[g>>0]=b[55169+(a-m)>>0]|0;j=j+1|0;g=g+1|0;a=f[p>>2]|0}b[g>>0]=0;f[q>>2]=i;if((hz(o,55180,q)|0)!=1)NF(0);if(r|0)ex(r)}a=f[c>>2]|0;do if(a){e=f[a+12>>2]|0;if((e|0)==(f[a+16>>2]|0))a=Uc[f[(f[a>>2]|0)+36>>2]&127](a)|0;else a=eA(b[e>>0]|0)|0;if(cB(a,dA()|0)|0){f[c>>2]=0;g=1;break}else{g=(f[c>>2]|0)==0;break}}else g=1;while(0);a=f[d>>2]|0;do if(a){e=f[a+12>>2]|0;if((e|0)==(f[a+16>>2]|0))a=Uc[f[(f[a>>2]|0)+36>>2]&127](a)|0;else a=eA(b[e>>0]|0)|0;if(!(cB(a,dA()|0)|0))if(g)break;else{t=34;break}else{f[d>>2]=0;t=32;break}}else t=32;while(0);if((t|0)==32?g:0)t=34;if((t|0)==34)f[h>>2]=f[h>>2]|2;e=f[c>>2]|0;zC(s);a=f[w>>2]|0;f[w>>2]=0;if(a|0)dd[f[v>>2]&511](a);u=x;return e|0}function IG(a,c,d,e,g,h,i){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;t=u;n=u=u+31&-32;u=u+144|0;j=n+24|0;a=n+32|0;s=n+16|0;m=n+8|0;p=n;k=n+28|0;n=n+4|0;f[s>>2]=a;r=s+4|0;f[r>>2]=444;dB(p,g);l=yC(p,59456)|0;b[k>>0]=0;o=f[d>>2]|0;f[n>>2]=o;g=f[g+4>>2]|0;f[j>>2]=f[n>>2];n=o;if(KG(c,j,e,p,g,h,k,l,s,m,a+100|0)|0){a=i+11|0;if((b[a>>0]|0)<0){e=f[i>>2]|0;b[j>>0]=0;$A(e,j);f[i+4>>2]=0}else{b[j>>0]=0;$A(i,j);b[a>>0]=0}if(b[k>>0]|0)jL(i,Vc[f[(f[l>>2]|0)+28>>2]&31](l,45)|0);k=Vc[f[(f[l>>2]|0)+28>>2]&31](l,48)|0;g=f[m>>2]|0;j=g+-1|0;a=f[s>>2]|0;while(1){if(a>>>0>=j>>>0)break;if((b[a>>0]|0)!=k<<24>>24)break;a=a+1|0}LG(i,a,g)|0}a=f[c>>2]|0;do if(a){g=f[a+12>>2]|0;if((g|0)==(f[a+16>>2]|0))a=Uc[f[(f[a>>2]|0)+36>>2]&127](a)|0;else a=eA(b[g>>0]|0)|0;if(cB(a,dA()|0)|0){f[c>>2]=0;g=1;break}else{g=(f[c>>2]|0)==0;break}}else g=1;while(0);do if(o){a=f[n+12>>2]|0;if((a|0)==(f[n+16>>2]|0))a=Uc[f[(f[o>>2]|0)+36>>2]&127](n)|0;else a=eA(b[a>>0]|0)|0;if(!(cB(a,dA()|0)|0))if(g)break;else{q=27;break}else{f[d>>2]=0;q=25;break}}else q=25;while(0);if((q|0)==25?g:0)q=27;if((q|0)==27)f[h>>2]=f[h>>2]|2;g=f[c>>2]|0;zC(p);a=f[s>>2]|0;f[s>>2]=0;if(a|0)dd[f[r>>2]&511](a);u=t;return g|0}function JG(a){a=a|0;return}function KG(a,c,e,g,i,j,k,l,m,n,o){a=a|0;c=c|0;e=e|0;g=g|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;var p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0;_=u;S=u=u+31&-32;u=u+512|0;J=S+88|0;P=S+96|0;Z=S+80|0;R=S+72|0;K=S+68|0;L=S+500|0;M=S+497|0;N=S+496|0;T=S+56|0;U=S+44|0;V=S+32|0;W=S+20|0;X=S+8|0;O=S+4|0;f[J>>2]=o;f[Z>>2]=P;Y=Z+4|0;f[Y>>2]=444;f[R>>2]=P;f[K>>2]=P+400;f[T>>2]=0;f[T+4>>2]=0;f[T+8>>2]=0;o=0;while(1){if((o|0)==3)break;f[T+(o<<2)>>2]=0;o=o+1|0}f[U>>2]=0;f[U+4>>2]=0;f[U+8>>2]=0;o=0;while(1){if((o|0)==3)break;f[U+(o<<2)>>2]=0;o=o+1|0}f[V>>2]=0;f[V+4>>2]=0;f[V+8>>2]=0;o=0;while(1){if((o|0)==3)break;f[V+(o<<2)>>2]=0;o=o+1|0}f[W>>2]=0;f[W+4>>2]=0;f[W+8>>2]=0;o=0;while(1){if((o|0)==3)break;f[W+(o<<2)>>2]=0;o=o+1|0}f[X>>2]=0;f[X+4>>2]=0;f[X+8>>2]=0;o=0;while(1){if((o|0)==3)break;f[X+(o<<2)>>2]=0;o=o+1|0}NG(e,g,L,M,N,T,U,V,W,O);f[n>>2]=f[m>>2];E=l+8|0;F=V+11|0;G=V+4|0;H=W+11|0;I=W+4|0;w=(i&512|0)!=0;x=U+11|0;y=U+4|0;z=X+11|0;A=X+4|0;B=L+3|0;C=T+11|0;D=T+4|0;P=0;v=0;a:while(1){l=(P|0)!=0;if(v>>>0>=4){Q=234;break}o=f[a>>2]|0;do if(o){e=f[o+12>>2]|0;if((e|0)==(f[o+16>>2]|0))o=Uc[f[(f[o>>2]|0)+36>>2]&127](o)|0;else o=eA(b[e>>0]|0)|0;if(cB(o,dA()|0)|0){f[a>>2]=0;g=1;break}else{g=(f[a>>2]|0)==0;break}}else g=1;while(0);e=f[c>>2]|0;do if(e){o=f[e+12>>2]|0;if((o|0)==(f[e+16>>2]|0))o=Uc[f[(f[e>>2]|0)+36>>2]&127](e)|0;else o=eA(b[o>>0]|0)|0;if(!(cB(o,dA()|0)|0))if(g){t=e;break}else{Q=234;break a}else{f[c>>2]=0;Q=31;break}}else Q=31;while(0);if((Q|0)==31){Q=0;if(g){Q=234;break}else t=0}o=(v|0)!=3;b:do switch(b[L+v>>0]|0){case 1:{if(o){o=f[a>>2]|0;e=f[o+12>>2]|0;if((e|0)==(f[o+16>>2]|0))o=Uc[f[(f[o>>2]|0)+36>>2]&127](o)|0;else o=eA(b[e>>0]|0)|0;if((o&255)<<24>>24<=-1){Q=44;break a}if(!(d[(f[E>>2]|0)+(o<<24>>24<<1)>>1]&8192)){Q=44;break a}o=f[a>>2]|0;e=o+12|0;g=f[e>>2]|0;if((g|0)==(f[o+16>>2]|0))o=Uc[f[(f[o>>2]|0)+40>>2]&127](o)|0;else{f[e>>2]=g+1;o=eA(b[g>>0]|0)|0}jL(X,o&255);o=t;l=t;Q=46}else o=P;break}case 0:{if(o){o=t;l=t;Q=46}else o=P;break}case 3:{o=b[F>>0]|0;o=o<<24>>24<0?f[G>>2]|0:o&255;l=b[H>>0]|0;l=l<<24>>24<0?f[I>>2]|0:l&255;if((o|0)==(0-l|0))o=P;else{i=(o|0)==0;o=f[a>>2]|0;e=f[o+12>>2]|0;g=(e|0)==(f[o+16>>2]|0);if(i|(l|0)==0){if(g)o=Uc[f[(f[o>>2]|0)+36>>2]&127](o)|0;else o=eA(b[e>>0]|0)|0;o=o&255;if(i){if(o<<24>>24!=(b[((b[H>>0]|0)<0?f[W>>2]|0:W)>>0]|0)){o=P;break b}o=f[a>>2]|0;e=o+12|0;g=f[e>>2]|0;if((g|0)==(f[o+16>>2]|0))Uc[f[(f[o>>2]|0)+40>>2]&127](o)|0;else{f[e>>2]=g+1;eA(b[g>>0]|0)|0}b[k>>0]=1;o=b[H>>0]|0;o=(o<<24>>24<0?f[I>>2]|0:o&255)>>>0>1?W:P;break b}if(o<<24>>24!=(b[((b[F>>0]|0)<0?f[V>>2]|0:V)>>0]|0)){b[k>>0]=1;o=P;break b}o=f[a>>2]|0;e=o+12|0;g=f[e>>2]|0;if((g|0)==(f[o+16>>2]|0))Uc[f[(f[o>>2]|0)+40>>2]&127](o)|0;else{f[e>>2]=g+1;eA(b[g>>0]|0)|0}o=b[F>>0]|0;o=(o<<24>>24<0?f[G>>2]|0:o&255)>>>0>1?V:P;break b}if(g)o=Uc[f[(f[o>>2]|0)+36>>2]&127](o)|0;else o=eA(b[e>>0]|0)|0;e=f[a>>2]|0;g=e+12|0;l=f[g>>2]|0;i=(l|0)==(f[e+16>>2]|0);if((o&255)<<24>>24==(b[((b[F>>0]|0)<0?f[V>>2]|0:V)>>0]|0)){if(i)Uc[f[(f[e>>2]|0)+40>>2]&127](e)|0;else{f[g>>2]=l+1;eA(b[l>>0]|0)|0}o=b[F>>0]|0;o=(o<<24>>24<0?f[G>>2]|0:o&255)>>>0>1?V:P;break b}if(i)o=Uc[f[(f[e>>2]|0)+36>>2]&127](e)|0;else o=eA(b[l>>0]|0)|0;if((o&255)<<24>>24!=(b[((b[H>>0]|0)<0?f[W>>2]|0:W)>>0]|0)){Q=103;break a}o=f[a>>2]|0;e=o+12|0;g=f[e>>2]|0;if((g|0)==(f[o+16>>2]|0))Uc[f[(f[o>>2]|0)+40>>2]&127](o)|0;else{f[e>>2]=g+1;eA(b[g>>0]|0)|0}b[k>>0]=1;o=b[H>>0]|0;o=(o<<24>>24<0?f[I>>2]|0:o&255)>>>0>1?W:P}break}case 2:{if(!(v>>>0<2|l)?!(w|(v|0)==2&(b[B>>0]|0)!=0):0){o=0;break b}e=b[x>>0]|0;o=e<<24>>24<0;r=f[U>>2]|0;g=o?r:U;q=g;c:do if((v|0)!=0?(h[L+(v+-1)>>0]|0)<2:0){o=g+(o?f[y>>2]|0:e&255)|0;p=q;while(1){l=p;if((l|0)==(o|0))break;i=b[l>>0]|0;if(i<<24>>24<=-1)break;if(!(d[(f[E>>2]|0)+(i<<24>>24<<1)>>1]&8192))break;p=l+1|0}i=p-q|0;l=b[z>>0]|0;o=l<<24>>24<0;l=o?f[A>>2]|0:l&255;if(i>>>0<=l>>>0){l=(o?f[X>>2]|0:X)+l|0;o=l+(0-i)|0;while(1){if((o|0)==(l|0)){s=t;g=p;o=r;l=t;break c}if((b[o>>0]|0)!=(b[g>>0]|0)){s=t;g=q;o=r;l=t;break c}g=g+1|0;o=o+1|0}}else{s=t;g=q;o=r;l=t}}else{s=t;g=q;o=r;l=t}while(0);d:while(1){p=e<<24>>24<0;o=(p?o:U)+(p?f[y>>2]|0:e&255)|0;p=g;if((p|0)==(o|0))break;o=f[a>>2]|0;do if(o){e=f[o+12>>2]|0;if((e|0)==(f[o+16>>2]|0))o=Uc[f[(f[o>>2]|0)+36>>2]&127](o)|0;else o=eA(b[e>>0]|0)|0;if(cB(o,dA()|0)|0){f[a>>2]=0;e=1;break}else{e=(f[a>>2]|0)==0;break}}else e=1;while(0);do if(l){o=f[l+12>>2]|0;if((o|0)==(f[l+16>>2]|0))o=Uc[f[(f[l>>2]|0)+36>>2]&127](l)|0;else o=eA(b[o>>0]|0)|0;if(!(cB(o,dA()|0)|0))if(e^(s|0)==0){o=s;i=s;break}else{o=p;break d}else{f[c>>2]=0;o=0;Q=132;break}}else{o=s;Q=132}while(0);if((Q|0)==132){Q=0;if(e){o=p;break}else i=0}e=f[a>>2]|0;g=f[e+12>>2]|0;if((g|0)==(f[e+16>>2]|0))e=Uc[f[(f[e>>2]|0)+36>>2]&127](e)|0;else e=eA(b[g>>0]|0)|0;if((e&255)<<24>>24!=(b[p>>0]|0)){o=p;break}e=f[a>>2]|0;g=e+12|0;l=f[g>>2]|0;if((l|0)==(f[e+16>>2]|0))Uc[f[(f[e>>2]|0)+40>>2]&127](e)|0;else{f[g>>2]=l+1;eA(b[l>>0]|0)|0}s=o;g=p+1|0;e=b[x>>0]|0;o=f[U>>2]|0;l=i}if(w?(t=b[x>>0]|0,s=t<<24>>24<0,(o|0)!=((s?f[U>>2]|0:U)+(s?f[y>>2]|0:t&255)|0)):0){Q=144;break a}else o=P;break}case 4:{q=0;o=t;l=t;e:while(1){e=f[a>>2]|0;do if(e){g=f[e+12>>2]|0;if((g|0)==(f[e+16>>2]|0))e=Uc[f[(f[e>>2]|0)+36>>2]&127](e)|0;else e=eA(b[g>>0]|0)|0;if(cB(e,dA()|0)|0){f[a>>2]=0;g=1;break}else{g=(f[a>>2]|0)==0;break}}else g=1;while(0);do if(l){e=f[l+12>>2]|0;if((e|0)==(f[l+16>>2]|0))e=Uc[f[(f[l>>2]|0)+36>>2]&127](l)|0;else e=eA(b[e>>0]|0)|0;if(!(cB(e,dA()|0)|0))if(g^(o|0)==0){i=o;p=o;break}else{l=o;break e}else{f[c>>2]=0;o=0;Q=158;break}}else Q=158;while(0);if((Q|0)==158){Q=0;if(g){l=o;break}else{i=o;p=0}}o=f[a>>2]|0;e=f[o+12>>2]|0;if((e|0)==(f[o+16>>2]|0))o=Uc[f[(f[o>>2]|0)+36>>2]&127](o)|0;else o=eA(b[e>>0]|0)|0;e=o&255;if(e<<24>>24>-1?(d[(f[E>>2]|0)+(o<<24>>24<<1)>>1]&2048)!=0:0){o=f[n>>2]|0;if((o|0)==(f[J>>2]|0)){OG(m,n,J);o=f[n>>2]|0}f[n>>2]=o+1;b[o>>0]=e;o=q+1|0}else{t=b[C>>0]|0;if(!(e<<24>>24==(b[N>>0]|0)&(q|0?((t<<24>>24<0?f[D>>2]|0:t&255)|0)!=0:0))){l=i;break}o=f[R>>2]|0;if((o|0)==(f[K>>2]|0)){PG(Z,R,K);o=f[R>>2]|0}f[R>>2]=o+4;f[o>>2]=q;o=0}e=f[a>>2]|0;g=e+12|0;l=f[g>>2]|0;if((l|0)==(f[e+16>>2]|0)){Uc[f[(f[e>>2]|0)+40>>2]&127](e)|0;q=o;o=i;l=p;continue}else{f[g>>2]=l+1;eA(b[l>>0]|0)|0;q=o;o=i;l=p;continue}}o=f[R>>2]|0;if(q|0?(f[Z>>2]|0)!=(o|0):0){if((o|0)==(f[K>>2]|0)){PG(Z,R,K);o=f[R>>2]|0}f[R>>2]=o+4;f[o>>2]=q}f:do if((f[O>>2]|0)>0){o=f[a>>2]|0;do if(o){e=f[o+12>>2]|0;if((e|0)==(f[o+16>>2]|0))o=Uc[f[(f[o>>2]|0)+36>>2]&127](o)|0;else o=eA(b[e>>0]|0)|0;if(cB(o,dA()|0)|0){f[a>>2]=0;e=1;break}else{e=(f[a>>2]|0)==0;break}}else e=1;while(0);do if(l){o=f[l+12>>2]|0;if((o|0)==(f[l+16>>2]|0))o=Uc[f[(f[l>>2]|0)+36>>2]&127](l)|0;else o=eA(b[o>>0]|0)|0;if(!(cB(o,dA()|0)|0))if(e)break;else{Q=232;break a}else{f[c>>2]=0;Q=193;break}}else Q=193;while(0);if((Q|0)==193){Q=0;if(e){Q=232;break a}else l=0}o=f[a>>2]|0;e=f[o+12>>2]|0;if((e|0)==(f[o+16>>2]|0))o=Uc[f[(f[o>>2]|0)+36>>2]&127](o)|0;else o=eA(b[e>>0]|0)|0;if((o&255)<<24>>24!=(b[M>>0]|0)){Q=232;break a}o=f[a>>2]|0;e=o+12|0;g=f[e>>2]|0;if((g|0)==(f[o+16>>2]|0)){Uc[f[(f[o>>2]|0)+40>>2]&127](o)|0;o=l}else{f[e>>2]=g+1;eA(b[g>>0]|0)|0;o=l}while(1){if((f[O>>2]|0)<=0)break f;e=f[a>>2]|0;do if(e){g=f[e+12>>2]|0;if((g|0)==(f[e+16>>2]|0))e=Uc[f[(f[e>>2]|0)+36>>2]&127](e)|0;else e=eA(b[g>>0]|0)|0;if(cB(e,dA()|0)|0){f[a>>2]=0;g=1;break}else{g=(f[a>>2]|0)==0;break}}else g=1;while(0);do if(l){e=f[l+12>>2]|0;if((e|0)==(f[l+16>>2]|0))e=Uc[f[(f[l>>2]|0)+36>>2]&127](l)|0;else e=eA(b[e>>0]|0)|0;if(!(cB(e,dA()|0)|0))if(g^(o|0)==0){i=o;l=o;break}else{Q=232;break a}else{f[c>>2]=0;o=0;Q=216;break}}else Q=216;while(0);if((Q|0)==216){Q=0;if(g){Q=232;break a}else{i=o;l=0}}o=f[a>>2]|0;e=f[o+12>>2]|0;if((e|0)==(f[o+16>>2]|0))o=Uc[f[(f[o>>2]|0)+36>>2]&127](o)|0;else o=eA(b[e>>0]|0)|0;if((o&255)<<24>>24<=-1){Q=232;break a}if(!(d[(f[E>>2]|0)+(o<<24>>24<<1)>>1]&2048)){Q=232;break a}if((f[n>>2]|0)==(f[J>>2]|0))OG(m,n,J);o=f[a>>2]|0;e=f[o+12>>2]|0;if((e|0)==(f[o+16>>2]|0))o=Uc[f[(f[o>>2]|0)+36>>2]&127](o)|0;else o=eA(b[e>>0]|0)|0;e=f[n>>2]|0;f[n>>2]=e+1;b[e>>0]=o;f[O>>2]=(f[O>>2]|0)+-1;o=f[a>>2]|0;e=o+12|0;g=f[e>>2]|0;if((g|0)==(f[o+16>>2]|0)){Uc[f[(f[o>>2]|0)+40>>2]&127](o)|0;o=i;continue}else{f[e>>2]=g+1;eA(b[g>>0]|0)|0;o=i;continue}}}while(0);if((f[n>>2]|0)==(f[m>>2]|0)){Q=232;break a}else o=P;break}default:o=P}while(0);g:do if((Q|0)==46)while(1){Q=0;e=f[a>>2]|0;do if(e){g=f[e+12>>2]|0;if((g|0)==(f[e+16>>2]|0))e=Uc[f[(f[e>>2]|0)+36>>2]&127](e)|0;else e=eA(b[g>>0]|0)|0;if(cB(e,dA()|0)|0){f[a>>2]=0;g=1;break}else{g=(f[a>>2]|0)==0;break}}else g=1;while(0);do if(l){e=f[l+12>>2]|0;if((e|0)==(f[l+16>>2]|0))e=Uc[f[(f[l>>2]|0)+36>>2]&127](l)|0;else e=eA(b[e>>0]|0)|0;if(!(cB(e,dA()|0)|0))if(g^(o|0)==0){i=o;l=o;break}else{o=P;break g}else{f[c>>2]=0;o=0;Q=59;break}}else Q=59;while(0);if((Q|0)==59){Q=0;if(g){o=P;break g}else{i=o;l=0}}o=f[a>>2]|0;e=f[o+12>>2]|0;if((e|0)==(f[o+16>>2]|0))o=Uc[f[(f[o>>2]|0)+36>>2]&127](o)|0;else o=eA(b[e>>0]|0)|0;if((o&255)<<24>>24<=-1){o=P;break g}if(!(d[(f[E>>2]|0)+(o<<24>>24<<1)>>1]&8192)){o=P;break g}o=f[a>>2]|0;e=o+12|0;g=f[e>>2]|0;if((g|0)==(f[o+16>>2]|0))o=Uc[f[(f[o>>2]|0)+40>>2]&127](o)|0;else{f[e>>2]=g+1;o=eA(b[g>>0]|0)|0}jL(X,o&255);o=i;Q=46}while(0);P=o;v=v+1|0}h:do if((Q|0)==44){f[j>>2]=f[j>>2]|4;e=0}else if((Q|0)==103){f[j>>2]=f[j>>2]|4;e=0}else if((Q|0)==144){f[j>>2]=f[j>>2]|4;e=0}else if((Q|0)==232){f[j>>2]=f[j>>2]|4;e=0}else if((Q|0)==234){i:do if(l){i=P+11|0;p=P+4|0;l=1;j:while(1){o=b[i>>0]|0;if(o<<24>>24<0)o=f[p>>2]|0;else o=o&255;if(l>>>0>=o>>>0)break i;o=f[a>>2]|0;do if(o){e=f[o+12>>2]|0;if((e|0)==(f[o+16>>2]|0))o=Uc[f[(f[o>>2]|0)+36>>2]&127](o)|0;else o=eA(b[e>>0]|0)|0;if(cB(o,dA()|0)|0){f[a>>2]=0;g=1;break}else{g=(f[a>>2]|0)==0;break}}else g=1;while(0);o=f[c>>2]|0;do if(o){e=f[o+12>>2]|0;if((e|0)==(f[o+16>>2]|0))o=Uc[f[(f[o>>2]|0)+36>>2]&127](o)|0;else o=eA(b[e>>0]|0)|0;if(!(cB(o,dA()|0)|0))if(g)break;else break j;else{f[c>>2]=0;Q=253;break}}else Q=253;while(0);if((Q|0)==253?(Q=0,g):0)break;o=f[a>>2]|0;e=f[o+12>>2]|0;if((e|0)==(f[o+16>>2]|0))o=Uc[f[(f[o>>2]|0)+36>>2]&127](o)|0;else o=eA(b[e>>0]|0)|0;if((b[i>>0]|0)<0)e=f[P>>2]|0;else e=P;if((o&255)<<24>>24!=(b[e+l>>0]|0))break;o=l+1|0;e=f[a>>2]|0;g=e+12|0;l=f[g>>2]|0;if((l|0)==(f[e+16>>2]|0)){Uc[f[(f[e>>2]|0)+40>>2]&127](e)|0;l=o;continue}else{f[g>>2]=l+1;eA(b[l>>0]|0)|0;l=o;continue}}f[j>>2]=f[j>>2]|4;e=0;break h}while(0);e=f[Z>>2]|0;o=f[R>>2]|0;if((e|0)!=(o|0)){f[S>>2]=0;NC(T,e,o,S);if(!(f[S>>2]|0)){e=1;break}else{f[j>>2]=f[j>>2]|4;e=0;break}}else e=1}while(0);_K(X);_K(W);_K(V);_K(U);_K(T);o=f[Z>>2]|0;f[Z>>2]=0;if(o|0)dd[f[Y>>2]&511](o);u=_;return e|0}function LG(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=u;i=u=u+31&-32;u=u+16|0;k=c;o=i+12|0;n=a+11|0;g=b[n>>0]|0;e=g<<24>>24<0;if(e){l=f[a+4>>2]|0;j=(f[a+8>>2]&2147483647)+-1|0}else{l=g&255;j=10}m=d-k|0;do if(m|0){if(e){g=f[a>>2]|0;h=g;e=f[a+4>>2]|0}else{h=a;e=g&255;g=a}if(MG(c,g,h+e|0)|0){f[i>>2]=0;f[i+4>>2]=0;f[i+8>>2]=0;if(m>>>0>4294967279)XK(i);if(m>>>0<11){b[i+11>>0]=m;g=i}else{n=m+16&-16;g=OK(n)|0;f[i>>2]=g;f[i+8>>2]=n|-2147483648;f[i+4>>2]=m}e=g;while(1){if((c|0)==(d|0))break;$A(e,c);c=c+1|0;e=e+1|0}b[o>>0]=0;$A(g+m|0,o);o=b[i+11>>0]|0;d=o<<24>>24<0;iL(a,d?f[i>>2]|0:i,d?f[i+4>>2]|0:o&255)|0;_K(i);break}i=l+m|0;if((j-l|0)>>>0<m>>>0)hL(a,j,i-j|0,l,l,0,0);if((b[n>>0]|0)<0)h=f[a>>2]|0;else h=a;g=d+(l-k)|0;e=h+l|0;while(1){if((c|0)==(d|0))break;$A(e,c);e=e+1|0;c=c+1|0}b[o>>0]=0;$A(h+g|0,o);if((b[n>>0]|0)<0){f[a+4>>2]=i;break}else{b[n>>0]=i;break}}while(0);u=p;return a|0}function MG(a,b,c){a=a|0;b=b|0;c=c|0;return b>>>0<=a>>>0&a>>>0<c>>>0|0}function NG(a,c,d,e,g,h,i,j,k,l){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0;o=u;n=u=u+31&-32;u=u+16|0;m=n+12|0;if(a){c=yC(c,61176)|0;ed[f[(f[c>>2]|0)+44>>2]&63](m,c);a=f[m>>2]|0;b[d>>0]=a;b[d+1>>0]=a>>8;b[d+2>>0]=a>>16;b[d+3>>0]=a>>24;ed[f[(f[c>>2]|0)+32>>2]&63](n,c);a=k+11|0;if((b[a>>0]|0)<0){a=f[k>>2]|0;b[m>>0]=0;$A(a,m);f[k+4>>2]=0;a=k}else{b[m>>0]=0;$A(k,m);b[a>>0]=0;a=k}dL(k,0);f[a>>2]=f[n>>2];f[a+4>>2]=f[n+4>>2];f[a+8>>2]=f[n+8>>2];a=0;while(1){if((a|0)==3)break;f[n+(a<<2)>>2]=0;a=a+1|0}_K(n);ed[f[(f[c>>2]|0)+28>>2]&63](n,c);a=j+11|0;if((b[a>>0]|0)<0){a=f[j>>2]|0;b[m>>0]=0;$A(a,m);f[j+4>>2]=0;a=j}else{b[m>>0]=0;$A(j,m);b[a>>0]=0;a=j}dL(j,0);f[a>>2]=f[n>>2];f[a+4>>2]=f[n+4>>2];f[a+8>>2]=f[n+8>>2];a=0;while(1){if((a|0)==3)break;f[n+(a<<2)>>2]=0;a=a+1|0}_K(n);a=Uc[f[(f[c>>2]|0)+12>>2]&127](c)|0;b[e>>0]=a;a=Uc[f[(f[c>>2]|0)+16>>2]&127](c)|0;b[g>>0]=a;ed[f[(f[c>>2]|0)+20>>2]&63](n,c);a=h+11|0;if((b[a>>0]|0)<0){a=f[h>>2]|0;b[m>>0]=0;$A(a,m);f[h+4>>2]=0;a=h}else{b[m>>0]=0;$A(h,m);b[a>>0]=0;a=h}dL(h,0);f[a>>2]=f[n>>2];f[a+4>>2]=f[n+4>>2];f[a+8>>2]=f[n+8>>2];a=0;while(1){if((a|0)==3)break;f[n+(a<<2)>>2]=0;a=a+1|0}_K(n);ed[f[(f[c>>2]|0)+24>>2]&63](n,c);a=i+11|0;if((b[a>>0]|0)<0){a=f[i>>2]|0;b[m>>0]=0;$A(a,m);f[i+4>>2]=0;a=i}else{b[m>>0]=0;$A(i,m);b[a>>0]=0;a=i}dL(i,0);f[a>>2]=f[n>>2];f[a+4>>2]=f[n+4>>2];f[a+8>>2]=f[n+8>>2];a=0;while(1){if((a|0)==3)break;f[n+(a<<2)>>2]=0;a=a+1|0}_K(n);a=Uc[f[(f[c>>2]|0)+36>>2]&127](c)|0}else{c=yC(c,61168)|0;ed[f[(f[c>>2]|0)+44>>2]&63](m,c);a=f[m>>2]|0;b[d>>0]=a;b[d+1>>0]=a>>8;b[d+2>>0]=a>>16;b[d+3>>0]=a>>24;ed[f[(f[c>>2]|0)+32>>2]&63](n,c);a=k+11|0;if((b[a>>0]|0)<0){a=f[k>>2]|0;b[m>>0]=0;$A(a,m);f[k+4>>2]=0;a=k}else{b[m>>0]=0;$A(k,m);b[a>>0]=0;a=k}dL(k,0);f[a>>2]=f[n>>2];f[a+4>>2]=f[n+4>>2];f[a+8>>2]=f[n+8>>2];a=0;while(1){if((a|0)==3)break;f[n+(a<<2)>>2]=0;a=a+1|0}_K(n);ed[f[(f[c>>2]|0)+28>>2]&63](n,c);a=j+11|0;if((b[a>>0]|0)<0){a=f[j>>2]|0;b[m>>0]=0;$A(a,m);f[j+4>>2]=0;a=j}else{b[m>>0]=0;$A(j,m);b[a>>0]=0;a=j}dL(j,0);f[a>>2]=f[n>>2];f[a+4>>2]=f[n+4>>2];f[a+8>>2]=f[n+8>>2];a=0;while(1){if((a|0)==3)break;f[n+(a<<2)>>2]=0;a=a+1|0}_K(n);a=Uc[f[(f[c>>2]|0)+12>>2]&127](c)|0;b[e>>0]=a;a=Uc[f[(f[c>>2]|0)+16>>2]&127](c)|0;b[g>>0]=a;ed[f[(f[c>>2]|0)+20>>2]&63](n,c);a=h+11|0;if((b[a>>0]|0)<0){a=f[h>>2]|0;b[m>>0]=0;$A(a,m);f[h+4>>2]=0;a=h}else{b[m>>0]=0;$A(h,m);b[a>>0]=0;a=h}dL(h,0);f[a>>2]=f[n>>2];f[a+4>>2]=f[n+4>>2];f[a+8>>2]=f[n+8>>2];a=0;while(1){if((a|0)==3)break;f[n+(a<<2)>>2]=0;a=a+1|0}_K(n);ed[f[(f[c>>2]|0)+24>>2]&63](n,c);a=i+11|0;if((b[a>>0]|0)<0){a=f[i>>2]|0;b[m>>0]=0;$A(a,m);f[i+4>>2]=0;a=i}else{b[m>>0]=0;$A(i,m);b[a>>0]=0;a=i}dL(i,0);f[a>>2]=f[n>>2];f[a+4>>2]=f[n+4>>2];f[a+8>>2]=f[n+8>>2];a=0;while(1){if((a|0)==3)break;f[n+(a<<2)>>2]=0;a=a+1|0}_K(n);a=Uc[f[(f[c>>2]|0)+36>>2]&127](c)|0}f[l>>2]=a;u=o;return}function OG(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0;i=a+4|0;e=(f[i>>2]|0)!=444;d=f[a>>2]|0;g=(f[c>>2]|0)-d|0;g=g>>>0<2147483647?g<<1:-1;g=(g|0)==0?1:g;h=(f[b>>2]|0)-d|0;d=fx(e?d:0,g)|0;if(!d)SK();if(!e){e=f[a>>2]|0;f[a>>2]=d;if(e){dd[f[i>>2]&511](e);d=f[a>>2]|0}}else f[a>>2]=d;f[i>>2]=445;f[b>>2]=d+h;f[c>>2]=(f[a>>2]|0)+g;return}function PG(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0;i=a+4|0;e=(f[i>>2]|0)!=444;d=f[a>>2]|0;g=(f[c>>2]|0)-d|0;g=g>>>0<2147483647?g<<1:-1;g=(g|0)==0?4:g;h=(f[b>>2]|0)-d>>2;d=fx(e?d:0,g)|0;if(!d)SK();if(!e){e=f[a>>2]|0;f[a>>2]=d;if(e){dd[f[i>>2]&511](e);d=f[a>>2]|0}}else f[a>>2]=d;f[i>>2]=445;f[b>>2]=d+(h<<2);f[c>>2]=(f[a>>2]|0)+(g>>>2<<2);return}function QG(a){a=a|0;eC(a);return}function RG(a){a=a|0;eC(a);QK(a);return}function SG(a,c,d,e,g,h,i){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0;x=u;o=u=u+31&-32;u=u+576|0;n=o+424|0;q=o;m=o+24|0;w=o+16|0;p=o+12|0;s=o+8|0;j=o+564|0;y=o+4|0;o=o+464|0;f[w>>2]=m;v=w+4|0;f[v>>2]=444;dB(s,g);a=yC(s,59488)|0;b[j>>0]=0;f[y>>2]=f[d>>2];l=f[g+4>>2]|0;f[n>>2]=f[y>>2];if(UG(c,n,e,s,l,h,j,a,w,p,m+400|0)|0){Xc[f[(f[a>>2]|0)+48>>2]&7](a,55279,55289,n)|0;l=f[p>>2]|0;e=f[w>>2]|0;a=l-e|0;if((a|0)>392){a=dx((a>>>2)+2|0)|0;if(!a)SK();else{k=a;r=a}}else{k=o;r=0}if(!(b[j>>0]|0))a=k;else{b[k>>0]=45;a=k+1|0}k=n+40|0;m=n;j=e;g=a;a=l;while(1){if(j>>>0>=a>>>0)break;e=f[j>>2]|0;a=n;while(1){if((a|0)==(k|0)){a=k;break}if((f[a>>2]|0)==(e|0))break;a=a+4|0}b[g>>0]=b[55279+(a-m>>2)>>0]|0;j=j+4|0;g=g+1|0;a=f[p>>2]|0}b[g>>0]=0;f[q>>2]=i;if((hz(o,55180,q)|0)!=1)NF(0);if(r|0)ex(r)}a=f[c>>2]|0;do if(a){e=f[a+12>>2]|0;if((e|0)==(f[a+16>>2]|0))a=Uc[f[(f[a>>2]|0)+36>>2]&127](a)|0;else a=wA(f[e>>2]|0)|0;if(eB(a,vA()|0)|0){f[c>>2]=0;g=1;break}else{g=(f[c>>2]|0)==0;break}}else g=1;while(0);a=f[d>>2]|0;do if(a){e=f[a+12>>2]|0;if((e|0)==(f[a+16>>2]|0))a=Uc[f[(f[a>>2]|0)+36>>2]&127](a)|0;else a=wA(f[e>>2]|0)|0;if(!(eB(a,vA()|0)|0))if(g)break;else{t=34;break}else{f[d>>2]=0;t=32;break}}else t=32;while(0);if((t|0)==32?g:0)t=34;if((t|0)==34)f[h>>2]=f[h>>2]|2;e=f[c>>2]|0;zC(s);a=f[w>>2]|0;f[w>>2]=0;if(a|0)dd[f[v>>2]&511](a);u=x;return e|0}function TG(a,c,d,e,g,h,i){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;t=u;n=u=u+31&-32;u=u+432|0;j=n+424|0;a=n+24|0;s=n+16|0;m=n+8|0;p=n;k=n+428|0;n=n+4|0;f[s>>2]=a;r=s+4|0;f[r>>2]=444;dB(p,g);l=yC(p,59488)|0;b[k>>0]=0;o=f[d>>2]|0;f[n>>2]=o;g=f[g+4>>2]|0;f[j>>2]=f[n>>2];n=o;if(UG(c,j,e,p,g,h,k,l,s,m,a+400|0)|0){a=i+8+3|0;if((b[a>>0]|0)<0){e=f[i>>2]|0;f[j>>2]=0;kC(e,j);f[i+4>>2]=0}else{f[j>>2]=0;kC(i,j);b[a>>0]=0}if(b[k>>0]|0)tL(i,Vc[f[(f[l>>2]|0)+44>>2]&31](l,45)|0);k=Vc[f[(f[l>>2]|0)+44>>2]&31](l,48)|0;g=f[m>>2]|0;j=g+-4|0;a=f[s>>2]|0;while(1){if(a>>>0>=j>>>0)break;if((f[a>>2]|0)!=(k|0))break;a=a+4|0}VG(i,a,g)|0}a=f[c>>2]|0;do if(a){g=f[a+12>>2]|0;if((g|0)==(f[a+16>>2]|0))a=Uc[f[(f[a>>2]|0)+36>>2]&127](a)|0;else a=wA(f[g>>2]|0)|0;if(eB(a,vA()|0)|0){f[c>>2]=0;g=1;break}else{g=(f[c>>2]|0)==0;break}}else g=1;while(0);do if(o){a=f[n+12>>2]|0;if((a|0)==(f[n+16>>2]|0))a=Uc[f[(f[o>>2]|0)+36>>2]&127](n)|0;else a=wA(f[a>>2]|0)|0;if(!(eB(a,vA()|0)|0))if(g)break;else{q=27;break}else{f[d>>2]=0;q=25;break}}else q=25;while(0);if((q|0)==25?g:0)q=27;if((q|0)==27)f[h>>2]=f[h>>2]|2;g=f[c>>2]|0;zC(p);a=f[s>>2]|0;f[s>>2]=0;if(a|0)dd[f[r>>2]&511](a);u=t;return g|0}function UG(a,c,d,e,g,i,j,k,l,m,n){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;var o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0;Y=u;Q=u=u+31&-32;u=u+512|0;H=Q+96|0;N=Q+104|0;X=Q+88|0;P=Q+80|0;I=Q+76|0;J=Q+504|0;K=Q+72|0;L=Q+68|0;R=Q+56|0;S=Q+44|0;T=Q+32|0;U=Q+20|0;V=Q+8|0;M=Q+4|0;f[H>>2]=n;f[X>>2]=N;W=X+4|0;f[W>>2]=444;f[P>>2]=N;f[I>>2]=N+400;f[R>>2]=0;f[R+4>>2]=0;f[R+8>>2]=0;n=0;while(1){if((n|0)==3)break;f[R+(n<<2)>>2]=0;n=n+1|0}f[S>>2]=0;f[S+4>>2]=0;f[S+8>>2]=0;n=0;while(1){if((n|0)==3)break;f[S+(n<<2)>>2]=0;n=n+1|0}f[T>>2]=0;f[T+4>>2]=0;f[T+8>>2]=0;n=0;while(1){if((n|0)==3)break;f[T+(n<<2)>>2]=0;n=n+1|0}f[U>>2]=0;f[U+4>>2]=0;f[U+8>>2]=0;n=0;while(1){if((n|0)==3)break;f[U+(n<<2)>>2]=0;n=n+1|0}f[V>>2]=0;f[V+4>>2]=0;f[V+8>>2]=0;n=0;while(1){if((n|0)==3)break;f[V+(n<<2)>>2]=0;n=n+1|0}XG(d,e,J,K,L,R,S,T,U,M);f[m>>2]=f[l>>2];D=T+8+3|0;E=T+4|0;F=U+8+3|0;G=U+4|0;v=(g&512|0)!=0;w=S+8+3|0;x=S+4|0;y=V+8+3|0;z=V+4|0;A=J+3|0;B=R+11|0;C=R+4|0;N=0;t=0;a:while(1){g=(N|0)!=0;if(t>>>0>=4){O=229;break}n=f[a>>2]|0;do if(n){d=f[n+12>>2]|0;if((d|0)==(f[n+16>>2]|0))n=Uc[f[(f[n>>2]|0)+36>>2]&127](n)|0;else n=wA(f[d>>2]|0)|0;if(eB(n,vA()|0)|0){f[a>>2]=0;e=1;break}else{e=(f[a>>2]|0)==0;break}}else e=1;while(0);d=f[c>>2]|0;do if(d){n=f[d+12>>2]|0;if((n|0)==(f[d+16>>2]|0))n=Uc[f[(f[d>>2]|0)+36>>2]&127](d)|0;else n=wA(f[n>>2]|0)|0;if(!(eB(n,vA()|0)|0))if(e){s=d;break}else{O=229;break a}else{f[c>>2]=0;O=31;break}}else O=31;while(0);if((O|0)==31){O=0;if(e){O=229;break}else s=0}n=(t|0)!=3;b:do switch(b[J+t>>0]|0){case 1:{if(n){n=f[a>>2]|0;d=f[n+12>>2]|0;if((d|0)==(f[n+16>>2]|0))n=Uc[f[(f[n>>2]|0)+36>>2]&127](n)|0;else n=wA(f[d>>2]|0)|0;if(!(Wc[f[(f[k>>2]|0)+12>>2]&63](k,8192,n)|0)){O=43;break a}n=f[a>>2]|0;d=n+12|0;e=f[d>>2]|0;if((e|0)==(f[n+16>>2]|0))n=Uc[f[(f[n>>2]|0)+40>>2]&127](n)|0;else{f[d>>2]=e+4;n=wA(f[e>>2]|0)|0}tL(V,n);n=s;g=s;O=45}else n=N;break}case 0:{if(n){n=s;g=s;O=45}else n=N;break}case 3:{n=b[D>>0]|0;n=n<<24>>24<0?f[E>>2]|0:n&255;g=b[F>>0]|0;g=g<<24>>24<0?f[G>>2]|0:g&255;if((n|0)==(0-g|0))n=N;else{o=(n|0)==0;n=f[a>>2]|0;d=f[n+12>>2]|0;e=(d|0)==(f[n+16>>2]|0);if(o|(g|0)==0){if(e)n=Uc[f[(f[n>>2]|0)+36>>2]&127](n)|0;else n=wA(f[d>>2]|0)|0;if(o){if((n|0)!=(f[((b[F>>0]|0)<0?f[U>>2]|0:U)>>2]|0)){n=N;break b}n=f[a>>2]|0;d=n+12|0;e=f[d>>2]|0;if((e|0)==(f[n+16>>2]|0))Uc[f[(f[n>>2]|0)+40>>2]&127](n)|0;else{f[d>>2]=e+4;wA(f[e>>2]|0)|0}b[j>>0]=1;n=b[F>>0]|0;n=(n<<24>>24<0?f[G>>2]|0:n&255)>>>0>1?U:N;break b}if((n|0)!=(f[((b[D>>0]|0)<0?f[T>>2]|0:T)>>2]|0)){b[j>>0]=1;n=N;break b}n=f[a>>2]|0;d=n+12|0;e=f[d>>2]|0;if((e|0)==(f[n+16>>2]|0))Uc[f[(f[n>>2]|0)+40>>2]&127](n)|0;else{f[d>>2]=e+4;wA(f[e>>2]|0)|0}n=b[D>>0]|0;n=(n<<24>>24<0?f[E>>2]|0:n&255)>>>0>1?T:N;break b}if(e)n=Uc[f[(f[n>>2]|0)+36>>2]&127](n)|0;else n=wA(f[d>>2]|0)|0;d=f[a>>2]|0;e=d+12|0;g=f[e>>2]|0;o=(g|0)==(f[d+16>>2]|0);if((n|0)==(f[((b[D>>0]|0)<0?f[T>>2]|0:T)>>2]|0)){if(o)Uc[f[(f[d>>2]|0)+40>>2]&127](d)|0;else{f[e>>2]=g+4;wA(f[g>>2]|0)|0}n=b[D>>0]|0;n=(n<<24>>24<0?f[E>>2]|0:n&255)>>>0>1?T:N;break b}if(o)n=Uc[f[(f[d>>2]|0)+36>>2]&127](d)|0;else n=wA(f[g>>2]|0)|0;if((n|0)!=(f[((b[F>>0]|0)<0?f[U>>2]|0:U)>>2]|0)){O=101;break a}n=f[a>>2]|0;d=n+12|0;e=f[d>>2]|0;if((e|0)==(f[n+16>>2]|0))Uc[f[(f[n>>2]|0)+40>>2]&127](n)|0;else{f[d>>2]=e+4;wA(f[e>>2]|0)|0}b[j>>0]=1;n=b[F>>0]|0;n=(n<<24>>24<0?f[G>>2]|0:n&255)>>>0>1?U:N}break}case 2:{if(!(t>>>0<2|g)?!(v|(t|0)==2&(b[A>>0]|0)!=0):0){n=0;break b}e=b[w>>0]|0;g=f[S>>2]|0;n=e<<24>>24<0?g:S;c:do if((t|0)!=0?(h[J+(t+-1)>>0]|0)<2:0){while(1){r=e<<24>>24<0;d=n;if((d|0)==((r?g:S)+((r?f[x>>2]|0:e&255)<<2)|0))break;if(!(Wc[f[(f[k>>2]|0)+12>>2]&63](k,8192,f[d>>2]|0)|0)){O=108;break}n=d+4|0;e=b[w>>0]|0;g=f[S>>2]|0}if((O|0)==108){O=0;e=b[w>>0]|0;g=f[S>>2]|0}o=e<<24>>24<0?g:S;r=o;q=n-r>>2;p=b[y>>0]|0;d=p<<24>>24<0;p=d?f[z>>2]|0:p&255;if(q>>>0>p>>>0){q=s;d=r;o=s}else{p=(d?f[V>>2]|0:V)+(p<<2)|0;d=p+(0-q<<2)|0;while(1){if((d|0)==(p|0)){q=s;d=n;o=s;break c}if((f[d>>2]|0)!=(f[o>>2]|0)){q=s;d=r;o=s;break c}o=o+4|0;d=d+4|0}}}else{q=s;d=n;o=s}while(0);d:while(1){n=e<<24>>24<0;n=(n?g:S)+((n?f[x>>2]|0:e&255)<<2)|0;p=d;if((p|0)==(n|0))break;n=f[a>>2]|0;do if(n){d=f[n+12>>2]|0;if((d|0)==(f[n+16>>2]|0))n=Uc[f[(f[n>>2]|0)+36>>2]&127](n)|0;else n=wA(f[d>>2]|0)|0;if(eB(n,vA()|0)|0){f[a>>2]=0;d=1;break}else{d=(f[a>>2]|0)==0;break}}else d=1;while(0);do if(o){n=f[o+12>>2]|0;if((n|0)==(f[o+16>>2]|0))n=Uc[f[(f[o>>2]|0)+36>>2]&127](o)|0;else n=wA(f[n>>2]|0)|0;if(!(eB(n,vA()|0)|0))if(d^(q|0)==0){n=q;o=q;break}else{n=p;break d}else{f[c>>2]=0;n=0;O=129;break}}else{n=q;O=129}while(0);if((O|0)==129){O=0;if(d){n=p;break}else o=0}d=f[a>>2]|0;e=f[d+12>>2]|0;if((e|0)==(f[d+16>>2]|0))d=Uc[f[(f[d>>2]|0)+36>>2]&127](d)|0;else d=wA(f[e>>2]|0)|0;if((d|0)!=(f[p>>2]|0)){n=p;break}d=f[a>>2]|0;e=d+12|0;g=f[e>>2]|0;if((g|0)==(f[d+16>>2]|0))Uc[f[(f[d>>2]|0)+40>>2]&127](d)|0;else{f[e>>2]=g+4;wA(f[g>>2]|0)|0}q=n;d=p+4|0;e=b[w>>0]|0;g=f[S>>2]|0}if(v?(s=b[w>>0]|0,r=s<<24>>24<0,(n|0)!=((r?f[S>>2]|0:S)+((r?f[x>>2]|0:s&255)<<2)|0)):0){O=141;break a}else n=N;break}case 4:{q=0;n=s;g=s;e:while(1){d=f[a>>2]|0;do if(d){e=f[d+12>>2]|0;if((e|0)==(f[d+16>>2]|0))d=Uc[f[(f[d>>2]|0)+36>>2]&127](d)|0;else d=wA(f[e>>2]|0)|0;if(eB(d,vA()|0)|0){f[a>>2]=0;e=1;break}else{e=(f[a>>2]|0)==0;break}}else e=1;while(0);do if(g){d=f[g+12>>2]|0;if((d|0)==(f[g+16>>2]|0))d=Uc[f[(f[g>>2]|0)+36>>2]&127](g)|0;else d=wA(f[d>>2]|0)|0;if(!(eB(d,vA()|0)|0))if(e^(n|0)==0){o=n;p=n;break}else{g=n;break e}else{f[c>>2]=0;n=0;O=155;break}}else O=155;while(0);if((O|0)==155){O=0;if(e){g=n;break}else{o=n;p=0}}n=f[a>>2]|0;d=f[n+12>>2]|0;if((d|0)==(f[n+16>>2]|0))d=Uc[f[(f[n>>2]|0)+36>>2]&127](n)|0;else d=wA(f[d>>2]|0)|0;if(Wc[f[(f[k>>2]|0)+12>>2]&63](k,2048,d)|0){n=f[m>>2]|0;if((n|0)==(f[H>>2]|0)){YG(l,m,H);n=f[m>>2]|0}f[m>>2]=n+4;f[n>>2]=d;n=q+1|0}else{s=b[B>>0]|0;if(!((d|0)==(f[L>>2]|0)&(q|0?((s<<24>>24<0?f[C>>2]|0:s&255)|0)!=0:0))){g=o;break}n=f[P>>2]|0;if((n|0)==(f[I>>2]|0)){PG(X,P,I);n=f[P>>2]|0}f[P>>2]=n+4;f[n>>2]=q;n=0}d=f[a>>2]|0;e=d+12|0;g=f[e>>2]|0;if((g|0)==(f[d+16>>2]|0)){Uc[f[(f[d>>2]|0)+40>>2]&127](d)|0;q=n;n=o;g=p;continue}else{f[e>>2]=g+4;wA(f[g>>2]|0)|0;q=n;n=o;g=p;continue}}n=f[P>>2]|0;if(q|0?(f[X>>2]|0)!=(n|0):0){if((n|0)==(f[I>>2]|0)){PG(X,P,I);n=f[P>>2]|0}f[P>>2]=n+4;f[n>>2]=q}f:do if((f[M>>2]|0)>0){n=f[a>>2]|0;do if(n){d=f[n+12>>2]|0;if((d|0)==(f[n+16>>2]|0))n=Uc[f[(f[n>>2]|0)+36>>2]&127](n)|0;else n=wA(f[d>>2]|0)|0;if(eB(n,vA()|0)|0){f[a>>2]=0;d=1;break}else{d=(f[a>>2]|0)==0;break}}else d=1;while(0);do if(g){n=f[g+12>>2]|0;if((n|0)==(f[g+16>>2]|0))n=Uc[f[(f[g>>2]|0)+36>>2]&127](g)|0;else n=wA(f[n>>2]|0)|0;if(!(eB(n,vA()|0)|0))if(d)break;else{O=227;break a}else{f[c>>2]=0;O=189;break}}else O=189;while(0);if((O|0)==189){O=0;if(d){O=227;break a}else g=0}n=f[a>>2]|0;d=f[n+12>>2]|0;if((d|0)==(f[n+16>>2]|0))n=Uc[f[(f[n>>2]|0)+36>>2]&127](n)|0;else n=wA(f[d>>2]|0)|0;if((n|0)!=(f[K>>2]|0)){O=227;break a}n=f[a>>2]|0;d=n+12|0;e=f[d>>2]|0;if((e|0)==(f[n+16>>2]|0)){Uc[f[(f[n>>2]|0)+40>>2]&127](n)|0;n=g}else{f[d>>2]=e+4;wA(f[e>>2]|0)|0;n=g}while(1){if((f[M>>2]|0)<=0)break f;d=f[a>>2]|0;do if(d){e=f[d+12>>2]|0;if((e|0)==(f[d+16>>2]|0))d=Uc[f[(f[d>>2]|0)+36>>2]&127](d)|0;else d=wA(f[e>>2]|0)|0;if(eB(d,vA()|0)|0){f[a>>2]=0;e=1;break}else{e=(f[a>>2]|0)==0;break}}else e=1;while(0);do if(g){d=f[g+12>>2]|0;if((d|0)==(f[g+16>>2]|0))d=Uc[f[(f[g>>2]|0)+36>>2]&127](g)|0;else d=wA(f[d>>2]|0)|0;if(!(eB(d,vA()|0)|0))if(e^(n|0)==0){o=n;g=n;break}else{O=227;break a}else{f[c>>2]=0;n=0;O=212;break}}else O=212;while(0);if((O|0)==212){O=0;if(e){O=227;break a}else{o=n;g=0}}n=f[a>>2]|0;d=f[n+12>>2]|0;if((d|0)==(f[n+16>>2]|0))n=Uc[f[(f[n>>2]|0)+36>>2]&127](n)|0;else n=wA(f[d>>2]|0)|0;if(!(Wc[f[(f[k>>2]|0)+12>>2]&63](k,2048,n)|0)){O=227;break a}if((f[m>>2]|0)==(f[H>>2]|0))YG(l,m,H);n=f[a>>2]|0;d=f[n+12>>2]|0;if((d|0)==(f[n+16>>2]|0))n=Uc[f[(f[n>>2]|0)+36>>2]&127](n)|0;else n=wA(f[d>>2]|0)|0;d=f[m>>2]|0;f[m>>2]=d+4;f[d>>2]=n;f[M>>2]=(f[M>>2]|0)+-1;n=f[a>>2]|0;d=n+12|0;e=f[d>>2]|0;if((e|0)==(f[n+16>>2]|0)){Uc[f[(f[n>>2]|0)+40>>2]&127](n)|0;n=o;continue}else{f[d>>2]=e+4;wA(f[e>>2]|0)|0;n=o;continue}}}while(0);if((f[m>>2]|0)==(f[l>>2]|0)){O=227;break a}else n=N;break}default:n=N}while(0);g:do if((O|0)==45)while(1){O=0;d=f[a>>2]|0;do if(d){e=f[d+12>>2]|0;if((e|0)==(f[d+16>>2]|0))d=Uc[f[(f[d>>2]|0)+36>>2]&127](d)|0;else d=wA(f[e>>2]|0)|0;if(eB(d,vA()|0)|0){f[a>>2]=0;e=1;break}else{e=(f[a>>2]|0)==0;break}}else e=1;while(0);do if(g){d=f[g+12>>2]|0;if((d|0)==(f[g+16>>2]|0))d=Uc[f[(f[g>>2]|0)+36>>2]&127](g)|0;else d=wA(f[d>>2]|0)|0;if(!(eB(d,vA()|0)|0))if(e^(n|0)==0){o=n;g=n;break}else{n=N;break g}else{f[c>>2]=0;n=0;O=58;break}}else O=58;while(0);if((O|0)==58){O=0;if(e){n=N;break g}else{o=n;g=0}}n=f[a>>2]|0;d=f[n+12>>2]|0;if((d|0)==(f[n+16>>2]|0))n=Uc[f[(f[n>>2]|0)+36>>2]&127](n)|0;else n=wA(f[d>>2]|0)|0;if(!(Wc[f[(f[k>>2]|0)+12>>2]&63](k,8192,n)|0)){n=N;break g}n=f[a>>2]|0;d=n+12|0;e=f[d>>2]|0;if((e|0)==(f[n+16>>2]|0))n=Uc[f[(f[n>>2]|0)+40>>2]&127](n)|0;else{f[d>>2]=e+4;n=wA(f[e>>2]|0)|0}tL(V,n);n=o;O=45}while(0);N=n;t=t+1|0}h:do if((O|0)==43){f[i>>2]=f[i>>2]|4;d=0}else if((O|0)==101){f[i>>2]=f[i>>2]|4;d=0}else if((O|0)==141){f[i>>2]=f[i>>2]|4;d=0}else if((O|0)==227){f[i>>2]=f[i>>2]|4;d=0}else if((O|0)==229){i:do if(g){o=N+8+3|0;p=N+4|0;g=1;j:while(1){n=b[o>>0]|0;if(n<<24>>24<0)n=f[p>>2]|0;else n=n&255;if(g>>>0>=n>>>0)break i;n=f[a>>2]|0;do if(n){d=f[n+12>>2]|0;if((d|0)==(f[n+16>>2]|0))n=Uc[f[(f[n>>2]|0)+36>>2]&127](n)|0;else n=wA(f[d>>2]|0)|0;if(eB(n,vA()|0)|0){f[a>>2]=0;e=1;break}else{e=(f[a>>2]|0)==0;break}}else e=1;while(0);n=f[c>>2]|0;do if(n){d=f[n+12>>2]|0;if((d|0)==(f[n+16>>2]|0))n=Uc[f[(f[n>>2]|0)+36>>2]&127](n)|0;else n=wA(f[d>>2]|0)|0;if(!(eB(n,vA()|0)|0))if(e)break;else break j;else{f[c>>2]=0;O=248;break}}else O=248;while(0);if((O|0)==248?(O=0,e):0)break;n=f[a>>2]|0;d=f[n+12>>2]|0;if((d|0)==(f[n+16>>2]|0))n=Uc[f[(f[n>>2]|0)+36>>2]&127](n)|0;else n=wA(f[d>>2]|0)|0;if((b[o>>0]|0)<0)d=f[N>>2]|0;else d=N;if((n|0)!=(f[d+(g<<2)>>2]|0))break;n=g+1|0;d=f[a>>2]|0;e=d+12|0;g=f[e>>2]|0;if((g|0)==(f[d+16>>2]|0)){Uc[f[(f[d>>2]|0)+40>>2]&127](d)|0;g=n;continue}else{f[e>>2]=g+4;wA(f[g>>2]|0)|0;g=n;continue}}f[i>>2]=f[i>>2]|4;d=0;break h}while(0);d=f[X>>2]|0;n=f[P>>2]|0;if((d|0)!=(n|0)){f[Q>>2]=0;NC(R,d,n,Q);if(!(f[Q>>2]|0)){d=1;break}else{f[i>>2]=f[i>>2]|4;d=0;break}}else d=1}while(0);lL(V);lL(U);lL(T);lL(S);_K(R);n=f[X>>2]|0;f[X>>2]=0;if(n|0)dd[f[W>>2]&511](n);u=Y;return d|0}function VG(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=u;n=u=u+31&-32;u=u+16|0;q=n+12|0;e=a+8|0;p=e+3|0;i=b[p>>0]|0;g=i<<24>>24<0;if(g){o=f[a+4>>2]|0;j=(f[e>>2]&2147483647)+-1|0}else{o=i&255;j=1}m=d-c>>2;do if(m|0){if(g){g=f[a>>2]|0;h=g;e=f[a+4>>2]|0}else{h=a;e=i&255;g=a}if(WG(c,g,h+(e<<2)|0)|0){f[n>>2]=0;f[n+4>>2]=0;f[n+8>>2]=0;if(m>>>0>1073741807)XK(n);do if(m>>>0>=2){e=m+4&-4;if(e>>>0>1073741823)Gb();else{l=OK(e<<2)|0;f[n>>2]=l;f[n+8>>2]=e|-2147483648;f[n+4>>2]=m;k=c;break}}else{b[n+8+3>>0]=m;k=c;l=n}while(0);while(1){if((k|0)==(d|0))break;kC(l,k);k=k+4|0;l=l+4|0}f[q>>2]=0;kC(l,q);q=b[n+8+3>>0]|0;d=q<<24>>24<0;sL(a,d?f[n>>2]|0:n,d?f[n+4>>2]|0:q&255)|0;lL(n);break}g=o+m|0;if((j-o|0)>>>0<m>>>0)rL(a,j,g-j|0,o,o,0,0);if((b[p>>0]|0)<0)e=f[a>>2]|0;else e=a;e=e+(o<<2)|0;while(1){if((c|0)==(d|0))break;kC(e,c);e=e+4|0;c=c+4|0}f[q>>2]=0;kC(e,q);if((b[p>>0]|0)<0){f[a+4>>2]=g;break}else{b[p>>0]=g;break}}while(0);u=r;return a|0}function WG(a,b,c){a=a|0;b=b|0;c=c|0;return b>>>0<=a>>>0&a>>>0<c>>>0|0}function XG(a,c,d,e,g,h,i,j,k,l){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0;o=u;n=u=u+31&-32;u=u+16|0;m=n+12|0;if(a){c=yC(c,61192)|0;ed[f[(f[c>>2]|0)+44>>2]&63](m,c);a=f[m>>2]|0;b[d>>0]=a;b[d+1>>0]=a>>8;b[d+2>>0]=a>>16;b[d+3>>0]=a>>24;ed[f[(f[c>>2]|0)+32>>2]&63](n,c);a=k+8+3|0;if((b[a>>0]|0)<0){d=f[k>>2]|0;f[m>>2]=0;kC(d,m);f[k+4>>2]=0}else{f[m>>2]=0;kC(k,m);b[a>>0]=0}pL(k,0);f[k>>2]=f[n>>2];f[k+4>>2]=f[n+4>>2];f[k+8>>2]=f[n+8>>2];a=0;while(1){if((a|0)==3)break;f[n+(a<<2)>>2]=0;a=a+1|0}lL(n);ed[f[(f[c>>2]|0)+28>>2]&63](n,c);a=j+8+3|0;if((b[a>>0]|0)<0){k=f[j>>2]|0;f[m>>2]=0;kC(k,m);f[j+4>>2]=0}else{f[m>>2]=0;kC(j,m);b[a>>0]=0}pL(j,0);f[j>>2]=f[n>>2];f[j+4>>2]=f[n+4>>2];f[j+8>>2]=f[n+8>>2];a=0;while(1){if((a|0)==3)break;f[n+(a<<2)>>2]=0;a=a+1|0}lL(n);a=Uc[f[(f[c>>2]|0)+12>>2]&127](c)|0;f[e>>2]=a;a=Uc[f[(f[c>>2]|0)+16>>2]&127](c)|0;f[g>>2]=a;ed[f[(f[c>>2]|0)+20>>2]&63](n,c);a=h+11|0;if((b[a>>0]|0)<0){a=f[h>>2]|0;b[m>>0]=0;$A(a,m);f[h+4>>2]=0;a=h}else{b[m>>0]=0;$A(h,m);b[a>>0]=0;a=h}dL(h,0);f[a>>2]=f[n>>2];f[a+4>>2]=f[n+4>>2];f[a+8>>2]=f[n+8>>2];a=0;while(1){if((a|0)==3)break;f[n+(a<<2)>>2]=0;a=a+1|0}_K(n);ed[f[(f[c>>2]|0)+24>>2]&63](n,c);a=i+8+3|0;if((b[a>>0]|0)<0){h=f[i>>2]|0;f[m>>2]=0;kC(h,m);f[i+4>>2]=0}else{f[m>>2]=0;kC(i,m);b[a>>0]=0}pL(i,0);f[i>>2]=f[n>>2];f[i+4>>2]=f[n+4>>2];f[i+8>>2]=f[n+8>>2];a=0;while(1){if((a|0)==3)break;f[n+(a<<2)>>2]=0;a=a+1|0}lL(n);a=Uc[f[(f[c>>2]|0)+36>>2]&127](c)|0}else{c=yC(c,61184)|0;ed[f[(f[c>>2]|0)+44>>2]&63](m,c);a=f[m>>2]|0;b[d>>0]=a;b[d+1>>0]=a>>8;b[d+2>>0]=a>>16;b[d+3>>0]=a>>24;ed[f[(f[c>>2]|0)+32>>2]&63](n,c);a=k+8+3|0;if((b[a>>0]|0)<0){d=f[k>>2]|0;f[m>>2]=0;kC(d,m);f[k+4>>2]=0}else{f[m>>2]=0;kC(k,m);b[a>>0]=0}pL(k,0);f[k>>2]=f[n>>2];f[k+4>>2]=f[n+4>>2];f[k+8>>2]=f[n+8>>2];a=0;while(1){if((a|0)==3)break;f[n+(a<<2)>>2]=0;a=a+1|0}lL(n);ed[f[(f[c>>2]|0)+28>>2]&63](n,c);a=j+8+3|0;if((b[a>>0]|0)<0){k=f[j>>2]|0;f[m>>2]=0;kC(k,m);f[j+4>>2]=0}else{f[m>>2]=0;kC(j,m);b[a>>0]=0}pL(j,0);f[j>>2]=f[n>>2];f[j+4>>2]=f[n+4>>2];f[j+8>>2]=f[n+8>>2];a=0;while(1){if((a|0)==3)break;f[n+(a<<2)>>2]=0;a=a+1|0}lL(n);a=Uc[f[(f[c>>2]|0)+12>>2]&127](c)|0;f[e>>2]=a;a=Uc[f[(f[c>>2]|0)+16>>2]&127](c)|0;f[g>>2]=a;ed[f[(f[c>>2]|0)+20>>2]&63](n,c);a=h+11|0;if((b[a>>0]|0)<0){a=f[h>>2]|0;b[m>>0]=0;$A(a,m);f[h+4>>2]=0;a=h}else{b[m>>0]=0;$A(h,m);b[a>>0]=0;a=h}dL(h,0);f[a>>2]=f[n>>2];f[a+4>>2]=f[n+4>>2];f[a+8>>2]=f[n+8>>2];a=0;while(1){if((a|0)==3)break;f[n+(a<<2)>>2]=0;a=a+1|0}_K(n);ed[f[(f[c>>2]|0)+24>>2]&63](n,c);a=i+8+3|0;if((b[a>>0]|0)<0){h=f[i>>2]|0;f[m>>2]=0;kC(h,m);f[i+4>>2]=0}else{f[m>>2]=0;kC(i,m);b[a>>0]=0}pL(i,0);f[i>>2]=f[n>>2];f[i+4>>2]=f[n+4>>2];f[i+8>>2]=f[n+8>>2];a=0;while(1){if((a|0)==3)break;f[n+(a<<2)>>2]=0;a=a+1|0}lL(n);a=Uc[f[(f[c>>2]|0)+36>>2]&127](c)|0}f[l>>2]=a;u=o;return}function YG(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0;i=a+4|0;e=(f[i>>2]|0)!=444;d=f[a>>2]|0;g=(f[c>>2]|0)-d|0;g=g>>>0<2147483647?g<<1:-1;g=(g|0)==0?4:g;h=(f[b>>2]|0)-d>>2;d=fx(e?d:0,g)|0;if(!d)SK();if(!e){e=f[a>>2]|0;f[a>>2]=d;if(e){dd[f[i>>2]&511](e);d=f[a>>2]|0}}else f[a>>2]=d;f[i>>2]=445;f[b>>2]=d+(h<<2);f[c>>2]=(f[a>>2]|0)+(g>>>2<<2);return}function ZG(a){a=a|0;eC(a);return}function _G(a){a=a|0;eC(a);QK(a);return}function $G(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=+h;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0;F=u;x=u=u+31&-32;u=u+384|0;q=x+8|0;j=x;a=x+284|0;k=x+72|0;i=x+184|0;E=x+68|0;r=x+180|0;s=x+177|0;t=x+176|0;B=x+56|0;C=x+44|0;D=x+32|0;n=x+28|0;o=x+76|0;v=x+24|0;w=x+16|0;x=x+20|0;f[k>>2]=a;p[q>>3]=h;a=wx(a,100,55385,q)|0;if(a>>>0>99){a=BC()|0;p[j>>3]=h;a=TD(k,a,55385,j)|0;i=f[k>>2]|0;if(!i)SK();j=dx(a)|0;if(!j)SK();else{y=j;A=a;H=j;I=i}}else{y=i;A=a;H=0;I=0}dB(E,e);m=yC(E,59456)|0;l=f[k>>2]|0;Xc[f[(f[m>>2]|0)+32>>2]&7](m,l,l+A|0,y)|0;if(!A)l=0;else l=(b[f[k>>2]>>0]|0)==45;f[B>>2]=0;f[B+4>>2]=0;f[B+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[B+(a<<2)>>2]=0;a=a+1|0}f[C>>2]=0;f[C+4>>2]=0;f[C+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[C+(a<<2)>>2]=0;a=a+1|0}f[D>>2]=0;f[D+4>>2]=0;f[D+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[D+(a<<2)>>2]=0;a=a+1|0}bH(d,l,E,r,s,t,B,C,D,n);k=f[n>>2]|0;if((A|0)>(k|0)){i=b[D+11>>0]|0;j=b[C+11>>0]|0;a=1;i=(i<<24>>24<0?f[D+4>>2]|0:i&255)+(A-k<<1)|0;j=j<<24>>24<0?f[C+4>>2]|0:j&255}else{j=b[D+11>>0]|0;i=b[C+11>>0]|0;a=2;i=i<<24>>24<0?f[C+4>>2]|0:i&255;j=j<<24>>24<0?f[D+4>>2]|0:j&255}a=j+k+i+a|0;if(a>>>0>100){a=dx(a)|0;if(!a)SK();else{z=a;G=a}}else{z=o;G=0}cH(z,v,w,f[e+4>>2]|0,y,y+A|0,m,l,r,b[s>>0]|0,b[t>>0]|0,B,C,D,k);f[x>>2]=f[c>>2];c=f[v>>2]|0;a=f[w>>2]|0;f[q>>2]=f[x>>2];a=ge(q,z,c,a,e,g)|0;if(G|0)ex(G);_K(D);_K(C);_K(B);zC(E);if(H|0)ex(H);if(I|0)ex(I);u=F;return a|0}function aH(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;D=u;s=u=u+31&-32;u=u+176|0;p=s+56|0;C=s+52|0;v=s+164|0;w=s+161|0;x=s+160|0;z=s+40|0;A=s+28|0;B=s+16|0;l=s+12|0;n=s+60|0;q=s+8|0;r=s+4|0;dB(C,e);t=yC(C,59456)|0;i=h+11|0;o=b[i>>0]|0;a=o<<24>>24<0;j=h+4|0;if(!((a?f[j>>2]|0:o&255)|0))o=0;else{o=b[(a?f[h>>2]|0:h)>>0]|0;o=o<<24>>24==(Vc[f[(f[t>>2]|0)+28>>2]&31](t,45)|0)<<24>>24};f[z>>2]=0;f[z+4>>2]=0;f[z+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[z+(a<<2)>>2]=0;a=a+1|0}f[A>>2]=0;f[A+4>>2]=0;f[A+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[A+(a<<2)>>2]=0;a=a+1|0}f[B>>2]=0;f[B+4>>2]=0;f[B+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[B+(a<<2)>>2]=0;a=a+1|0}bH(d,o,C,v,w,x,z,A,B,l);k=b[i>>0]|0;m=k<<24>>24<0;k=m?f[j>>2]|0:k&255;j=f[l>>2]|0;if((k|0)>(j|0)){i=b[B+11>>0]|0;d=b[A+11>>0]|0;a=1;i=(i<<24>>24<0?f[B+4>>2]|0:i&255)+(k-j<<1)|0;d=d<<24>>24<0?f[A+4>>2]|0:d&255}else{d=b[B+11>>0]|0;i=b[A+11>>0]|0;a=2;i=i<<24>>24<0?f[A+4>>2]|0:i&255;d=d<<24>>24<0?f[B+4>>2]|0:d&255}a=d+j+i+a|0;if(a>>>0>100){a=dx(a)|0;if(!a)SK();else{y=a;E=a}}else{y=n;E=0}h=m?f[h>>2]|0:h;cH(y,q,r,f[e+4>>2]|0,h,h+k|0,t,o,v,b[w>>0]|0,b[x>>0]|0,z,A,B,j);f[s>>2]=f[c>>2];h=f[q>>2]|0;a=f[r>>2]|0;f[p>>2]=f[s>>2];a=ge(p,y,h,a,e,g)|0;if(E|0)ex(E);_K(B);_K(A);_K(z);zC(C);u=D;return a|0}function bH(a,c,d,e,g,h,i,j,k,l){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0;p=u;o=u=u+31&-32;u=u+16|0;n=o+12|0;if(a){m=yC(d,61176)|0;if(c){ed[f[(f[m>>2]|0)+44>>2]&63](n,m);a=f[n>>2]|0;b[e>>0]=a;b[e+1>>0]=a>>8;b[e+2>>0]=a>>16;b[e+3>>0]=a>>24;ed[f[(f[m>>2]|0)+32>>2]&63](o,m);a=k+11|0;if((b[a>>0]|0)<0){a=f[k>>2]|0;b[n>>0]=0;$A(a,n);f[k+4>>2]=0;a=k}else{b[n>>0]=0;$A(k,n);b[a>>0]=0;a=k}dL(k,0);f[a>>2]=f[o>>2];f[a+4>>2]=f[o+4>>2];f[a+8>>2]=f[o+8>>2];a=0;while(1){if((a|0)==3)break;f[o+(a<<2)>>2]=0;a=a+1|0}_K(o);d=m}else{ed[f[(f[m>>2]|0)+40>>2]&63](n,m);a=f[n>>2]|0;b[e>>0]=a;b[e+1>>0]=a>>8;b[e+2>>0]=a>>16;b[e+3>>0]=a>>24;ed[f[(f[m>>2]|0)+28>>2]&63](o,m);a=k+11|0;if((b[a>>0]|0)<0){a=f[k>>2]|0;b[n>>0]=0;$A(a,n);f[k+4>>2]=0;a=k}else{b[n>>0]=0;$A(k,n);b[a>>0]=0;a=k}dL(k,0);f[a>>2]=f[o>>2];f[a+4>>2]=f[o+4>>2];f[a+8>>2]=f[o+8>>2];a=0;while(1){if((a|0)==3)break;f[o+(a<<2)>>2]=0;a=a+1|0}_K(o);d=m}a=Uc[f[(f[m>>2]|0)+12>>2]&127](m)|0;b[g>>0]=a;a=Uc[f[(f[m>>2]|0)+16>>2]&127](m)|0;b[h>>0]=a;ed[f[(f[d>>2]|0)+20>>2]&63](o,m);a=i+11|0;if((b[a>>0]|0)<0){a=f[i>>2]|0;b[n>>0]=0;$A(a,n);f[i+4>>2]=0;a=i}else{b[n>>0]=0;$A(i,n);b[a>>0]=0;a=i}dL(i,0);f[a>>2]=f[o>>2];f[a+4>>2]=f[o+4>>2];f[a+8>>2]=f[o+8>>2];a=0;while(1){if((a|0)==3)break;f[o+(a<<2)>>2]=0;a=a+1|0}_K(o);ed[f[(f[d>>2]|0)+24>>2]&63](o,m);a=j+11|0;if((b[a>>0]|0)<0){a=f[j>>2]|0;b[n>>0]=0;$A(a,n);f[j+4>>2]=0;a=j}else{b[n>>0]=0;$A(j,n);b[a>>0]=0;a=j}dL(j,0);f[a>>2]=f[o>>2];f[a+4>>2]=f[o+4>>2];f[a+8>>2]=f[o+8>>2];a=0;while(1){if((a|0)==3)break;f[o+(a<<2)>>2]=0;a=a+1|0}_K(o);a=Uc[f[(f[m>>2]|0)+36>>2]&127](m)|0}else{m=yC(d,61168)|0;if(c){ed[f[(f[m>>2]|0)+44>>2]&63](n,m);a=f[n>>2]|0;b[e>>0]=a;b[e+1>>0]=a>>8;b[e+2>>0]=a>>16;b[e+3>>0]=a>>24;ed[f[(f[m>>2]|0)+32>>2]&63](o,m);a=k+11|0;if((b[a>>0]|0)<0){a=f[k>>2]|0;b[n>>0]=0;$A(a,n);f[k+4>>2]=0;a=k}else{b[n>>0]=0;$A(k,n);b[a>>0]=0;a=k}dL(k,0);f[a>>2]=f[o>>2];f[a+4>>2]=f[o+4>>2];f[a+8>>2]=f[o+8>>2];a=0;while(1){if((a|0)==3)break;f[o+(a<<2)>>2]=0;a=a+1|0}_K(o);d=m}else{ed[f[(f[m>>2]|0)+40>>2]&63](n,m);a=f[n>>2]|0;b[e>>0]=a;b[e+1>>0]=a>>8;b[e+2>>0]=a>>16;b[e+3>>0]=a>>24;ed[f[(f[m>>2]|0)+28>>2]&63](o,m);a=k+11|0;if((b[a>>0]|0)<0){a=f[k>>2]|0;b[n>>0]=0;$A(a,n);f[k+4>>2]=0;a=k}else{b[n>>0]=0;$A(k,n);b[a>>0]=0;a=k}dL(k,0);f[a>>2]=f[o>>2];f[a+4>>2]=f[o+4>>2];f[a+8>>2]=f[o+8>>2];a=0;while(1){if((a|0)==3)break;f[o+(a<<2)>>2]=0;a=a+1|0}_K(o);d=m}a=Uc[f[(f[m>>2]|0)+12>>2]&127](m)|0;b[g>>0]=a;a=Uc[f[(f[m>>2]|0)+16>>2]&127](m)|0;b[h>>0]=a;ed[f[(f[d>>2]|0)+20>>2]&63](o,m);a=i+11|0;if((b[a>>0]|0)<0){a=f[i>>2]|0;b[n>>0]=0;$A(a,n);f[i+4>>2]=0;a=i}else{b[n>>0]=0;$A(i,n);b[a>>0]=0;a=i}dL(i,0);f[a>>2]=f[o>>2];f[a+4>>2]=f[o+4>>2];f[a+8>>2]=f[o+8>>2];a=0;while(1){if((a|0)==3)break;f[o+(a<<2)>>2]=0;a=a+1|0}_K(o);ed[f[(f[d>>2]|0)+24>>2]&63](o,m);a=j+11|0;if((b[a>>0]|0)<0){a=f[j>>2]|0;b[n>>0]=0;$A(a,n);f[j+4>>2]=0;a=j}else{b[n>>0]=0;$A(j,n);b[a>>0]=0;a=j}dL(j,0);f[a>>2]=f[o>>2];f[a+4>>2]=f[o+4>>2];f[a+8>>2]=f[o+8>>2];a=0;while(1){if((a|0)==3)break;f[o+(a<<2)>>2]=0;a=a+1|0}_K(o);a=Uc[f[(f[m>>2]|0)+36>>2]&127](m)|0}f[l>>2]=a;u=p;return}function cH(a,c,e,g,h,i,j,k,l,m,n,o,p,q,r){a=a|0;c=c|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;p=p|0;q=q|0;r=r|0;var s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0;f[e>>2]=a;z=q+11|0;H=q+4|0;A=p+11|0;B=p+4|0;C=(g&512|0)==0;D=j+8|0;E=(r|0)>0;F=o+11|0;G=o+4|0;y=0;while(1){if((y|0)==4)break;a:do switch(b[l+y>>0]|0){case 0:{f[c>>2]=f[e>>2];break}case 1:{f[c>>2]=f[e>>2];w=Vc[f[(f[j>>2]|0)+28>>2]&31](j,32)|0;x=f[e>>2]|0;f[e>>2]=x+1;b[x>>0]=w;break}case 3:{x=b[z>>0]|0;s=x<<24>>24<0;if((s?f[H>>2]|0:x&255)|0){w=b[(s?f[q>>2]|0:q)>>0]|0;x=f[e>>2]|0;f[e>>2]=x+1;b[x>>0]=w}break}case 2:{t=b[A>>0]|0;s=t<<24>>24<0;t=s?f[B>>2]|0:t&255;if(!(C|(t|0)==0)){x=s?f[p>>2]|0:p;u=x+t|0;s=f[e>>2]|0;t=x;while(1){if((t|0)==(u|0))break;b[s>>0]=b[t>>0]|0;s=s+1|0;t=t+1|0}f[e>>2]=s}break}case 4:{t=f[e>>2]|0;h=k?h+1|0:h;u=h;while(1){if(u>>>0>=i>>>0)break;s=b[u>>0]|0;if(s<<24>>24<=-1)break;if(!(d[(f[D>>2]|0)+(s<<24>>24<<1)>>1]&2048))break;u=u+1|0}if(E){v=r;while(1){s=(v|0)>0;if(!(u>>>0>h>>>0&s))break;x=u+-1|0;s=b[x>>0]|0;w=f[e>>2]|0;f[e>>2]=w+1;b[w>>0]=s;v=v+-1|0;u=x}if(s)w=Vc[f[(f[j>>2]|0)+28>>2]&31](j,48)|0;else w=0;s=v;while(1){v=f[e>>2]|0;f[e>>2]=v+1;if((s|0)<=0)break;b[v>>0]=w;s=s+-1|0}b[v>>0]=m}b:do if((u|0)==(h|0)){w=Vc[f[(f[j>>2]|0)+28>>2]&31](j,48)|0;x=f[e>>2]|0;f[e>>2]=x+1;b[x>>0]=w}else{x=b[F>>0]|0;s=x<<24>>24<0;if(!((s?f[G>>2]|0:x&255)|0)){w=-1;v=0;x=0}else{w=b[(s?f[o>>2]|0:o)>>0]|0;v=0;x=0}while(1){if((u|0)==(h|0))break b;if((x|0)==(w|0)){w=f[e>>2]|0;f[e>>2]=w+1;b[w>>0]=n;v=v+1|0;w=b[F>>0]|0;s=w<<24>>24<0;if(v>>>0<(s?f[G>>2]|0:w&255)>>>0){w=b[(s?f[o>>2]|0:o)+v>>0]|0;w=w<<24>>24==127?-1:w<<24>>24;s=0}else{w=x;s=0}}else s=x;I=u+-1|0;J=b[I>>0]|0;x=f[e>>2]|0;f[e>>2]=x+1;b[x>>0]=J;x=s+1|0;u=I}}while(0);s=f[e>>2]|0;if((t|0)!=(s|0))while(1){s=s+-1|0;if(t>>>0>=s>>>0)break a;J=b[t>>0]|0;b[t>>0]=b[s>>0]|0;b[s>>0]=J;t=t+1|0}break}default:{}}while(0);y=y+1|0}h=b[z>>0]|0;s=h<<24>>24<0;h=s?f[H>>2]|0:h&255;if(h>>>0>1){J=s?f[q>>2]|0:q;t=J+h|0;s=f[e>>2]|0;h=J;while(1){h=h+1|0;if((h|0)==(t|0))break;b[s>>0]=b[h>>0]|0;s=s+1|0}f[e>>2]=s}switch((g&176)<<24>>24){case 32:{f[c>>2]=f[e>>2];break}case 16:break;default:f[c>>2]=a}return}function dH(a){a=a|0;eC(a);return}function eH(a){a=a|0;eC(a);QK(a);return}function fH(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=+h;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0;F=u;x=u=u+31&-32;u=u+1008|0;q=x+8|0;j=x;a=x+896|0;k=x+888|0;i=x+488|0;E=x+480|0;r=x+892|0;s=x+476|0;t=x+472|0;B=x+460|0;C=x+448|0;D=x+436|0;n=x+432|0;o=x+32|0;v=x+24|0;w=x+16|0;x=x+20|0;f[k>>2]=a;p[q>>3]=h;a=wx(a,100,55385,q)|0;if(a>>>0>99){a=BC()|0;p[j>>3]=h;a=TD(k,a,55385,j)|0;i=f[k>>2]|0;if(!i)SK();j=dx(a<<2)|0;if(!j)SK();else{y=j;A=a;H=j;I=i}}else{y=i;A=a;H=0;I=0}dB(E,e);m=yC(E,59488)|0;l=f[k>>2]|0;Xc[f[(f[m>>2]|0)+48>>2]&7](m,l,l+A|0,y)|0;if(!A)l=0;else l=(b[f[k>>2]>>0]|0)==45;f[B>>2]=0;f[B+4>>2]=0;f[B+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[B+(a<<2)>>2]=0;a=a+1|0}f[C>>2]=0;f[C+4>>2]=0;f[C+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[C+(a<<2)>>2]=0;a=a+1|0}f[D>>2]=0;f[D+4>>2]=0;f[D+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[D+(a<<2)>>2]=0;a=a+1|0}hH(d,l,E,r,s,t,B,C,D,n);k=f[n>>2]|0;if((A|0)>(k|0)){i=b[D+8+3>>0]|0;j=b[C+8+3>>0]|0;a=1;i=(i<<24>>24<0?f[D+4>>2]|0:i&255)+(A-k<<1)|0;j=j<<24>>24<0?f[C+4>>2]|0:j&255}else{j=b[D+8+3>>0]|0;i=b[C+8+3>>0]|0;a=2;i=i<<24>>24<0?f[C+4>>2]|0:i&255;j=j<<24>>24<0?f[D+4>>2]|0:j&255}a=j+k+i+a|0;if(a>>>0>100){a=dx(a<<2)|0;if(!a)SK();else{z=a;G=a}}else{z=o;G=0}iH(z,v,w,f[e+4>>2]|0,y,y+(A<<2)|0,m,l,r,f[s>>2]|0,f[t>>2]|0,B,C,D,k);f[x>>2]=f[c>>2];c=f[v>>2]|0;a=f[w>>2]|0;f[q>>2]=f[x>>2];a=fE(q,z,c,a,e,g)|0;if(G|0)ex(G);lL(D);lL(C);_K(B);zC(E);if(H|0)ex(H);if(I|0)ex(I);u=F;return a|0}function gH(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;D=u;s=u=u+31&-32;u=u+480|0;p=s+468|0;C=s+464|0;v=s+472|0;w=s+460|0;x=s+456|0;z=s+444|0;A=s+432|0;B=s+420|0;l=s+416|0;n=s+16|0;q=s+8|0;r=s+4|0;dB(C,e);t=yC(C,59488)|0;i=h+8+3|0;o=b[i>>0]|0;a=o<<24>>24<0;j=h+4|0;if(!((a?f[j>>2]|0:o&255)|0))o=0;else{o=f[(a?f[h>>2]|0:h)>>2]|0;o=(o|0)==(Vc[f[(f[t>>2]|0)+44>>2]&31](t,45)|0)};f[z>>2]=0;f[z+4>>2]=0;f[z+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[z+(a<<2)>>2]=0;a=a+1|0}f[A>>2]=0;f[A+4>>2]=0;f[A+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[A+(a<<2)>>2]=0;a=a+1|0}f[B>>2]=0;f[B+4>>2]=0;f[B+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[B+(a<<2)>>2]=0;a=a+1|0}hH(d,o,C,v,w,x,z,A,B,l);k=b[i>>0]|0;m=k<<24>>24<0;k=m?f[j>>2]|0:k&255;j=f[l>>2]|0;if((k|0)>(j|0)){i=b[B+8+3>>0]|0;d=b[A+8+3>>0]|0;a=1;i=(i<<24>>24<0?f[B+4>>2]|0:i&255)+(k-j<<1)|0;d=d<<24>>24<0?f[A+4>>2]|0:d&255}else{d=b[B+8+3>>0]|0;i=b[A+8+3>>0]|0;a=2;i=i<<24>>24<0?f[A+4>>2]|0:i&255;d=d<<24>>24<0?f[B+4>>2]|0:d&255}a=d+j+i+a|0;if(a>>>0>100){a=dx(a<<2)|0;if(!a)SK();else{y=a;E=a}}else{y=n;E=0}h=m?f[h>>2]|0:h;iH(y,q,r,f[e+4>>2]|0,h,h+(k<<2)|0,t,o,v,f[w>>2]|0,f[x>>2]|0,z,A,B,j);f[s>>2]=f[c>>2];h=f[q>>2]|0;a=f[r>>2]|0;f[p>>2]=f[s>>2];a=fE(p,y,h,a,e,g)|0;if(E|0)ex(E);lL(B);lL(A);_K(z);zC(C);u=D;return a|0}function hH(a,c,d,e,g,h,i,j,k,l){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0;o=u;n=u=u+31&-32;u=u+16|0;m=n+12|0;if(a){d=yC(d,61192)|0;if(c){ed[f[(f[d>>2]|0)+44>>2]&63](m,d);a=f[m>>2]|0;b[e>>0]=a;b[e+1>>0]=a>>8;b[e+2>>0]=a>>16;b[e+3>>0]=a>>24;ed[f[(f[d>>2]|0)+32>>2]&63](n,d);a=k+8+3|0;if((b[a>>0]|0)<0){e=f[k>>2]|0;f[m>>2]=0;kC(e,m);f[k+4>>2]=0}else{f[m>>2]=0;kC(k,m);b[a>>0]=0}pL(k,0);f[k>>2]=f[n>>2];f[k+4>>2]=f[n+4>>2];f[k+8>>2]=f[n+8>>2];a=0;while(1){if((a|0)==3)break;f[n+(a<<2)>>2]=0;a=a+1|0}lL(n)}else{ed[f[(f[d>>2]|0)+40>>2]&63](m,d);a=f[m>>2]|0;b[e>>0]=a;b[e+1>>0]=a>>8;b[e+2>>0]=a>>16;b[e+3>>0]=a>>24;ed[f[(f[d>>2]|0)+28>>2]&63](n,d);a=k+8+3|0;if((b[a>>0]|0)<0){e=f[k>>2]|0;f[m>>2]=0;kC(e,m);f[k+4>>2]=0}else{f[m>>2]=0;kC(k,m);b[a>>0]=0}pL(k,0);f[k>>2]=f[n>>2];f[k+4>>2]=f[n+4>>2];f[k+8>>2]=f[n+8>>2];a=0;while(1){if((a|0)==3)break;f[n+(a<<2)>>2]=0;a=a+1|0}lL(n)}a=Uc[f[(f[d>>2]|0)+12>>2]&127](d)|0;f[g>>2]=a;a=Uc[f[(f[d>>2]|0)+16>>2]&127](d)|0;f[h>>2]=a;ed[f[(f[d>>2]|0)+20>>2]&63](n,d);a=i+11|0;if((b[a>>0]|0)<0){a=f[i>>2]|0;b[m>>0]=0;$A(a,m);f[i+4>>2]=0;a=i}else{b[m>>0]=0;$A(i,m);b[a>>0]=0;a=i}dL(i,0);f[a>>2]=f[n>>2];f[a+4>>2]=f[n+4>>2];f[a+8>>2]=f[n+8>>2];a=0;while(1){if((a|0)==3)break;f[n+(a<<2)>>2]=0;a=a+1|0}_K(n);ed[f[(f[d>>2]|0)+24>>2]&63](n,d);a=j+8+3|0;if((b[a>>0]|0)<0){i=f[j>>2]|0;f[m>>2]=0;kC(i,m);f[j+4>>2]=0}else{f[m>>2]=0;kC(j,m);b[a>>0]=0}pL(j,0);f[j>>2]=f[n>>2];f[j+4>>2]=f[n+4>>2];f[j+8>>2]=f[n+8>>2];a=0;while(1){if((a|0)==3)break;f[n+(a<<2)>>2]=0;a=a+1|0}lL(n);a=Uc[f[(f[d>>2]|0)+36>>2]&127](d)|0}else{d=yC(d,61184)|0;if(c){ed[f[(f[d>>2]|0)+44>>2]&63](m,d);a=f[m>>2]|0;b[e>>0]=a;b[e+1>>0]=a>>8;b[e+2>>0]=a>>16;b[e+3>>0]=a>>24;ed[f[(f[d>>2]|0)+32>>2]&63](n,d);a=k+8+3|0;if((b[a>>0]|0)<0){e=f[k>>2]|0;f[m>>2]=0;kC(e,m);f[k+4>>2]=0}else{f[m>>2]=0;kC(k,m);b[a>>0]=0}pL(k,0);f[k>>2]=f[n>>2];f[k+4>>2]=f[n+4>>2];f[k+8>>2]=f[n+8>>2];a=0;while(1){if((a|0)==3)break;f[n+(a<<2)>>2]=0;a=a+1|0}lL(n)}else{ed[f[(f[d>>2]|0)+40>>2]&63](m,d);a=f[m>>2]|0;b[e>>0]=a;b[e+1>>0]=a>>8;b[e+2>>0]=a>>16;b[e+3>>0]=a>>24;ed[f[(f[d>>2]|0)+28>>2]&63](n,d);a=k+8+3|0;if((b[a>>0]|0)<0){e=f[k>>2]|0;f[m>>2]=0;kC(e,m);f[k+4>>2]=0}else{f[m>>2]=0;kC(k,m);b[a>>0]=0}pL(k,0);f[k>>2]=f[n>>2];f[k+4>>2]=f[n+4>>2];f[k+8>>2]=f[n+8>>2];a=0;while(1){if((a|0)==3)break;f[n+(a<<2)>>2]=0;a=a+1|0}lL(n)}a=Uc[f[(f[d>>2]|0)+12>>2]&127](d)|0;f[g>>2]=a;a=Uc[f[(f[d>>2]|0)+16>>2]&127](d)|0;f[h>>2]=a;ed[f[(f[d>>2]|0)+20>>2]&63](n,d);a=i+11|0;if((b[a>>0]|0)<0){a=f[i>>2]|0;b[m>>0]=0;$A(a,m);f[i+4>>2]=0;a=i}else{b[m>>0]=0;$A(i,m);b[a>>0]=0;a=i}dL(i,0);f[a>>2]=f[n>>2];f[a+4>>2]=f[n+4>>2];f[a+8>>2]=f[n+8>>2];a=0;while(1){if((a|0)==3)break;f[n+(a<<2)>>2]=0;a=a+1|0}_K(n);ed[f[(f[d>>2]|0)+24>>2]&63](n,d);a=j+8+3|0;if((b[a>>0]|0)<0){i=f[j>>2]|0;f[m>>2]=0;kC(i,m);f[j+4>>2]=0}else{f[m>>2]=0;kC(j,m);b[a>>0]=0}pL(j,0);f[j>>2]=f[n>>2];f[j+4>>2]=f[n+4>>2];f[j+8>>2]=f[n+8>>2];a=0;while(1){if((a|0)==3)break;f[n+(a<<2)>>2]=0;a=a+1|0}lL(n);a=Uc[f[(f[d>>2]|0)+36>>2]&127](d)|0}f[l>>2]=a;u=o;return}function iH(a,c,d,e,g,h,i,j,k,l,m,n,o,p,q){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;p=p|0;q=q|0;var r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0;f[d>>2]=a;B=p+8+3|0;I=p+4|0;C=o+8+3|0;D=o+4|0;E=(e&512|0)==0;F=(q|0)>0;G=n+11|0;H=n+4|0;A=0;while(1){if((A|0)==4)break;a:do switch(b[k+A>>0]|0){case 0:{f[c>>2]=f[d>>2];break}case 1:{f[c>>2]=f[d>>2];y=Vc[f[(f[i>>2]|0)+44>>2]&31](i,32)|0;z=f[d>>2]|0;f[d>>2]=z+4;f[z>>2]=y;break}case 3:{z=b[B>>0]|0;r=z<<24>>24<0;if((r?f[I>>2]|0:z&255)|0){y=f[(r?f[p>>2]|0:p)>>2]|0;z=f[d>>2]|0;f[d>>2]=z+4;f[z>>2]=y}break}case 2:{v=b[C>>0]|0;r=v<<24>>24<0;v=r?f[D>>2]|0:v&255;if(!(E|(v|0)==0)){u=r?f[o>>2]|0:o;s=u+(v<<2)|0;t=f[d>>2]|0;r=t;while(1){if((u|0)==(s|0))break;f[r>>2]=f[u>>2];r=r+4|0;u=u+4|0}f[d>>2]=t+(v<<2)}break}case 4:{s=f[d>>2]|0;g=j?g+4|0:g;r=g;while(1){if(r>>>0>=h>>>0)break;if(!(Wc[f[(f[i>>2]|0)+12>>2]&63](i,2048,f[r>>2]|0)|0))break;r=r+4|0}if(F){u=q;while(1){t=(u|0)>0;if(!(r>>>0>g>>>0&t))break;z=r+-4|0;x=f[z>>2]|0;y=f[d>>2]|0;f[d>>2]=y+4;f[y>>2]=x;u=u+-1|0;r=z}if(t)w=Vc[f[(f[i>>2]|0)+44>>2]&31](i,48)|0;else w=0;v=f[d>>2]|0;while(1){t=v+4|0;if((u|0)<=0)break;f[v>>2]=w;u=u+-1|0;v=t}f[d>>2]=t;f[v>>2]=l}if((r|0)==(g|0)){y=Vc[f[(f[i>>2]|0)+44>>2]&31](i,48)|0;z=f[d>>2]|0;r=z+4|0;f[d>>2]=r;f[z>>2]=y}else{z=b[G>>0]|0;y=z<<24>>24<0;z=z&255;if(!((y?f[H>>2]|0:z)|0)){v=-1;t=0;w=0}else{v=b[(y?f[n>>2]|0:n)>>0]|0;t=0;w=0}while(1){if((r|0)==(g|0))break;u=f[d>>2]|0;if((w|0)==(v|0)){x=u+4|0;f[d>>2]=x;f[u>>2]=m;t=t+1|0;if(t>>>0<(y?f[H>>2]|0:z)>>>0){v=b[(y?f[n>>2]|0:n)+t>>0]|0;v=v<<24>>24==127?-1:v<<24>>24;w=0;u=x}else{v=w;w=0;u=x}}x=r+-4|0;J=f[x>>2]|0;f[d>>2]=u+4;f[u>>2]=J;w=w+1|0;r=x}r=f[d>>2]|0}if((s|0)!=(r|0))while(1){r=r+-4|0;if(s>>>0>=r>>>0)break a;J=f[s>>2]|0;f[s>>2]=f[r>>2];f[r>>2]=J;s=s+4|0}break}default:{}}while(0);A=A+1|0}g=b[B>>0]|0;r=g<<24>>24<0;g=r?f[I>>2]|0:g&255;if(g>>>0>1){r=r?f[p>>2]|0:p;u=r+4|0;r=r+(g<<2)|0;s=f[d>>2]|0;t=r-u|0;g=s;while(1){if((u|0)==(r|0))break;f[g>>2]=f[u>>2];g=g+4|0;u=u+4|0}f[d>>2]=s+(t>>>2<<2)}switch((e&176)<<24>>24){case 32:{f[c>>2]=f[d>>2];break}case 16:break;default:f[c>>2]=a}return}function jH(a){a=a|0;eC(a);return}function kH(a){a=a|0;eC(a);QK(a);return}function lH(a,c,d){a=a|0;c=c|0;d=d|0;d=Az((b[c+11>>0]|0)<0?f[c>>2]|0:c,1)|0;return d>>>((d|0)!=(-1|0)&1)|0}function mH(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0;j=u;i=u=u+31&-32;u=u+16|0;f[i>>2]=0;f[i+4>>2]=0;f[i+8>>2]=0;c=0;while(1){if((c|0)==3)break;f[i+(c<<2)>>2]=0;c=c+1|0}k=b[h+11>>0]|0;l=k<<24>>24<0;c=l?f[h>>2]|0:h;h=c+(l?f[h+4>>2]|0:k&255)|0;while(1){if(c>>>0>=h>>>0)break;jL(i,b[c>>0]|0);c=c+1|0}c=(b[i+11>>0]|0)<0?f[i>>2]|0:i;d=yz((d|0)==-1?-1:d<<1,e,g,c)|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;h=0;while(1){if((h|0)==3)break;f[a+(h<<2)>>2]=0;h=h+1|0}h=c+(vx(d)|0)|0;while(1){if(c>>>0>=h>>>0)break;jL(a,b[c>>0]|0);c=c+1|0}_K(i);u=j;return}function nH(a,b){a=a|0;b=b|0;return}function oH(a){a=a|0;eC(a);return}function pH(a){a=a|0;eC(a);QK(a);return}function qH(a,c,d){a=a|0;c=c|0;d=d|0;d=Az((b[c+11>>0]|0)<0?f[c>>2]|0:c,1)|0;return d>>>((d|0)!=(-1|0)&1)|0}function rH(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;t=u;o=u=u+31&-32;u=u+176|0;p=o+168|0;q=o+40|0;r=o+36|0;s=o+32|0;n=o;l=o+24|0;o=o+16|0;f[n>>2]=0;f[n+4>>2]=0;f[n+8>>2]=0;c=0;while(1){if((c|0)==3)break;f[n+(c<<2)>>2]=0;c=c+1|0}f[l+4>>2]=0;f[l>>2]=16892;j=b[h+8+3>>0]|0;k=j<<24>>24<0;c=k?f[h>>2]|0:h;j=c+((k?f[h+4>>2]|0:j&255)<<2)|0;k=q+32|0;h=c;c=0;while(1){if(!((c|0)!=2&h>>>0<j>>>0))break;f[s>>2]=h;i=bd[f[(f[l>>2]|0)+12>>2]&15](l,p,h,j,s,q,k,r)|0;if((i|0)==2?1:(f[s>>2]|0)==(h|0)){m=7;break}else c=q;while(1){if(c>>>0>=(f[r>>2]|0)>>>0)break;jL(n,b[c>>0]|0);c=c+1|0}h=f[s>>2]|0;c=i}if((m|0)==7)NF(0);eC(l);i=(b[n+11>>0]|0)<0?f[n>>2]|0:n;h=yz((d|0)==-1?-1:d<<1,e,g,i)|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;c=0;while(1){if((c|0)==3)break;f[a+(c<<2)>>2]=0;c=c+1|0}f[o+4>>2]=0;f[o>>2]=16940;j=i+(vx(h)|0)|0;k=j;l=q+128|0;h=i;c=0;while(1){if(!((c|0)!=2&h>>>0<j>>>0)){m=21;break}f[s>>2]=h;i=bd[f[(f[o>>2]|0)+16>>2]&15](o,p,h,(k-h|0)>32?h+32|0:j,s,q,l,r)|0;if((i|0)==2?1:(f[s>>2]|0)==(h|0)){m=17;break}else c=q;while(1){if(c>>>0>=(f[r>>2]|0)>>>0)break;tL(a,f[c>>2]|0);c=c+4|0}h=f[s>>2]|0;c=i}if((m|0)==17)NF(0);else if((m|0)==21){eC(o);_K(n);u=t;return}}function sH(a,b){a=a|0;b=b|0;return}function tH(a){a=a|0;eC(a);QK(a);return}function uH(a,b,c,d,e,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;var j=0;b=u;a=u=u+31&-32;u=u+16|0;j=a+4|0;f[j>>2]=c;f[a>>2]=g;h=DH(c,d,j,g,h,a,1114111,0)|0;f[e>>2]=f[j>>2];f[i>>2]=f[a>>2];u=b;return h|0}function vH(a,b,c,d,e,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;var j=0;b=u;a=u=u+31&-32;u=u+16|0;j=a+4|0;f[j>>2]=c;f[a>>2]=g;h=CH(c,d,j,g,h,a,1114111,0)|0;f[e>>2]=f[j>>2];f[i>>2]=f[a>>2];u=b;return h|0}function wH(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f[e>>2]=c;return 3}function xH(a){a=a|0;return 0}function yH(a){a=a|0;return 0}function zH(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return BH(c,d,e,1114111,0)|0}function AH(a){a=a|0;return 4}function BH(a,c,d,e,f){a=a|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;o=c;p=a;if(((o-p|0)>2&(f&4|0)!=0?(b[a>>0]|0)==-17:0)?(b[a+1>>0]|0)==-69:0){n=0;a=(b[a+2>>0]|0)==-65?a+3|0:a}else n=0;a:while(1){if(!(n>>>0<d>>>0&a>>>0<c>>>0)){q=30;break}k=b[a>>0]|0;m=k&255;g=a+1|0;do if(k<<24>>24>-1)if(m>>>0>e>>>0){q=30;break a}else a=g;else{if((k&255)<194){q=30;break a}i=a+2|0;l=a;f=o-l|0;if((k&255)<224){if((f|0)<2){q=30;break a}f=h[g>>0]|0;if((f&192|0)!=128){q=30;break a}if((f&63|m<<6&1984)>>>0>e>>>0){q=30;break a}else{a=i;break}}j=a+3|0;if((k&255)<240){if((f|0)<3){q=30;break a}i=b[i>>0]|0;g=h[g>>0]|0;f=g&224;switch(k<<24>>24){case -32:{if((f|0)!=160){a=l;break a}break}case -19:{if((f|0)!=128){a=l;break a}break}default:if((g&192|0)!=128){a=l;break a}}f=i&255;if((f&192|0)!=128){q=30;break a}if((g<<6&4032|m<<12&61440|f&63)>>>0>e>>>0){q=30;break a}else{a=j;break}}if((f|0)<4|(k&255)>244){q=30;break a}g=b[g>>0]|0;f=b[i>>0]|0;i=b[j>>0]|0;j=g&255;switch(k<<24>>24){case -16:{if((g+112&255)>=48){a=l;break a}break}case -12:{if((j&240|0)!=128){a=l;break a}break}default:if((j&192|0)!=128){a=l;break a}}g=f&255;if((g&192|0)!=128){q=30;break a}f=i&255;if((f&192|0)!=128){q=30;break a}if((j<<12&258048|m<<18&1835008|g<<6&4032|f&63)>>>0>e>>>0){q=30;break a}else a=a+4|0}while(0);n=n+1|0}return a-p|0}function CH(a,c,d,e,g,i,j,k){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;i=i|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0;f[d>>2]=a;f[i>>2]=e;q=c;if((((k&4|0?(l=f[d>>2]|0,(q-l|0)>2):0)?(b[l>>0]|0)==-17:0)?(b[l+1>>0]|0)==-69:0)?(b[l+2>>0]|0)==-65:0)f[d>>2]=l+3;a:while(1){m=f[d>>2]|0;if(m>>>0>=c>>>0){a=0;break}p=f[i>>2]|0;if(p>>>0>=g>>>0){a=1;break}n=b[m>>0]|0;o=n&255;a=m+1|0;do if(n<<24>>24>-1){if(o>>>0>j>>>0){a=2;break a}f[p>>2]=o}else{if((n&255)<194){a=2;break a}l=m+2|0;e=q-m|0;if((n&255)<224){if((e|0)<2){a=1;break a}a=h[a>>0]|0;if((a&192|0)!=128){a=2;break a}a=a&63|o<<6&1984;if(a>>>0>j>>>0){a=2;break a}f[p>>2]=a;a=l;break}k=m+3|0;if((n&255)<240){if((e|0)<3){a=1;break a}e=b[l>>0]|0;l=h[a>>0]|0;a=l&224;switch(n<<24>>24){case -32:{if((a|0)!=160){a=2;break a}break}case -19:{if((a|0)!=128){a=2;break a}break}default:if((l&192|0)!=128){a=2;break a}}a=e&255;if((a&192|0)!=128){a=2;break a}a=l<<6&4032|o<<12&61440|a&63;if(a>>>0>j>>>0){a=2;break a}f[p>>2]=a;a=k;break}if((n&255)>=245){a=2;break a}if((e|0)<4){a=1;break a}e=b[a>>0]|0;a=b[l>>0]|0;l=b[k>>0]|0;k=e&255;switch(n<<24>>24){case -16:{if((e+112&255)>=48){a=2;break a}break}case -12:{if((k&240|0)!=128){a=2;break a}break}default:if((k&192|0)!=128){a=2;break a}}e=a&255;if((e&192|0)!=128){a=2;break a}a=l&255;if((a&192|0)!=128){a=2;break a}a=k<<12&258048|o<<18&1835008|e<<6&4032|a&63;if(a>>>0>j>>>0){a=2;break a}f[p>>2]=a;a=m+4|0}while(0);f[d>>2]=a;f[i>>2]=(f[i>>2]|0)+4}return a|0}function DH(a,c,d,e,g,h,i,j){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0;f[d>>2]=a;f[h>>2]=e;if(j&2)if((g-e|0)<3)a=1;else{f[h>>2]=e+1;b[e>>0]=-17;k=f[h>>2]|0;f[h>>2]=k+1;b[k>>0]=-69;k=f[h>>2]|0;f[h>>2]=k+1;b[k>>0]=-65;k=4}else k=4;a:do if((k|0)==4){a=f[d>>2]|0;while(1){if(a>>>0>=c>>>0){a=0;break a}m=f[a>>2]|0;if(m>>>0>i>>>0|(m&-2048|0)==55296){a=2;break a}do if(m>>>0>=128){l=(m&63|128)&255;if(m>>>0<2048){a=f[h>>2]|0;if((g-a|0)<2){a=1;break a}f[h>>2]=a+1;b[a>>0]=m>>>6|192;m=f[h>>2]|0;f[h>>2]=m+1;b[m>>0]=l;break}a=f[h>>2]|0;e=g-a|0;j=a+1|0;k=(m>>>6&63|128)&255;if(m>>>0<65536){if((e|0)<3){a=1;break a}f[h>>2]=j;b[a>>0]=m>>>12|224;m=f[h>>2]|0;f[h>>2]=m+1;b[m>>0]=k;m=f[h>>2]|0;f[h>>2]=m+1;b[m>>0]=l;break}else{if((e|0)<4){a=1;break a}f[h>>2]=j;b[a>>0]=m>>>18|240;j=f[h>>2]|0;f[h>>2]=j+1;b[j>>0]=m>>>12&63|128;m=f[h>>2]|0;f[h>>2]=m+1;b[m>>0]=k;m=f[h>>2]|0;f[h>>2]=m+1;b[m>>0]=l;break}}else{a=f[h>>2]|0;if((g-a|0)<1){a=1;break a}f[h>>2]=a+1;b[a>>0]=m}while(0);a=(f[d>>2]|0)+4|0;f[d>>2]=a}}while(0);return a|0}function EH(a){a=a|0;eC(a);QK(a);return}function FH(a,b,c,d,e,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;f[e>>2]=c;f[i>>2]=g;return 3}function GH(a,b,c,d,e,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;f[e>>2]=c;f[i>>2]=g;return 3}function HH(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f[e>>2]=c;return 3}function IH(a){a=a|0;return 1}function JH(a){a=a|0;return 1}function KH(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;d=d-c|0;return (d>>>0<e>>>0?d:e)|0}function LH(a){a=a|0;return 1}function MH(a,c,d,e,g,h,i,j){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;q=u;n=u=u+31&-32;u=u+16|0;p=n;n=n+8|0;k=d;while(1){if((k|0)==(e|0)){k=e;break}if(!(f[k>>2]|0))break;k=k+4|0}f[j>>2]=h;f[g>>2]=d;m=i;o=a+8|0;a:while(1){if((h|0)==(i|0)|(d|0)==(e|0)){k=35;break}r=c;l=f[r+4>>2]|0;a=p;f[a>>2]=f[r>>2];f[a+4>>2]=l;a=Dz(f[o>>2]|0)|0;l=ny(h,g,k-d>>2,m-h|0,c)|0;if(a|0)Dz(a)|0;switch(l|0){case -1:{k=10;break a}case 0:{d=1;k=32;break a}default:{}}h=(f[j>>2]|0)+l|0;f[j>>2]=h;if((h|0)==(i|0)){k=33;break}if((k|0)==(e|0)){k=e;d=f[g>>2]|0}else{h=Dz(f[o>>2]|0)|0;d=Qx(n,0,c)|0;if(h|0)Dz(h)|0;if((d|0)==-1){d=2;k=31;break}if(d>>>0>(m-(f[j>>2]|0)|0)>>>0){d=1;k=31;break}else h=n;while(1){if(!d)break;l=b[h>>0]|0;r=f[j>>2]|0;f[j>>2]=r+1;b[r>>0]=l;h=h+1|0;d=d+-1|0}d=(f[g>>2]|0)+4|0;f[g>>2]=d;k=d;while(1){if((k|0)==(e|0)){k=e;break}if(!(f[k>>2]|0))break;k=k+4|0}h=f[j>>2]|0}}if((k|0)==10){f[j>>2]=h;while(1){if((d|0)==(f[g>>2]|0))break;r=f[d>>2]|0;k=Dz(f[o>>2]|0)|0;h=Qx(h,r,p)|0;if(k|0)Dz(k)|0;if((h|0)==-1)break;h=(f[j>>2]|0)+h|0;f[j>>2]=h;d=d+4|0}f[g>>2]=d;d=2;k=32}else if((k|0)==31)k=32;else if((k|0)==33){d=f[g>>2]|0;k=35}if((k|0)!=32)if((k|0)==35)d=(d|0)!=(e|0)&1;u=q;return d|0}function NH(a,c,d,e,g,h,i,j){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=u;p=u=u+31&-32;u=u+16|0;k=d;while(1){if((k|0)==(e|0)){k=e;break}if(!(b[k>>0]|0))break;k=k+1|0}f[j>>2]=h;f[g>>2]=d;n=i;o=a+8|0;a=h;while(1){if((a|0)==(i|0)|(d|0)==(e|0)){a=32;break}l=c;h=f[l+4>>2]|0;m=p;f[m>>2]=f[l>>2];f[m+4>>2]=h;m=k;h=Dz(f[o>>2]|0)|0;l=ly(a,g,m-d|0,n-a>>2,c)|0;if(h|0)Dz(h)|0;if((l|0)==-1){k=a;a=10;break}a=(f[j>>2]|0)+(l<<2)|0;f[j>>2]=a;if((a|0)==(i|0)){a=29;break}d=f[g>>2]|0;if((k|0)==(e|0))k=e;else{k=Dz(f[o>>2]|0)|0;d=hy(a,d,1,c)|0;if(k|0)Dz(k)|0;if(d|0){d=2;a=28;break}f[j>>2]=(f[j>>2]|0)+4;d=(f[g>>2]|0)+1|0;f[g>>2]=d;k=d;while(1){if((k|0)==(e|0)){k=e;break}if(!(b[k>>0]|0))break;k=k+1|0}a=f[j>>2]|0}}do if((a|0)==10){a:while(1){f[j>>2]=k;if((d|0)==(f[g>>2]|0)){a=18;break}a=Dz(f[o>>2]|0)|0;k=hy(k,d,m-d|0,p)|0;if(a|0)Dz(a)|0;switch(k|0){case -1:{a=15;break a}case -2:{a=16;break a}case 0:{k=1;break}default:{}}d=d+k|0;k=(f[j>>2]|0)+4|0;a=10}if((a|0)==15){f[g>>2]=d;d=2;a=28;break}else if((a|0)==16){f[g>>2]=d;d=1;a=28;break}else if((a|0)==18){f[g>>2]=d;d=(d|0)!=(e|0)&1;a=28;break}}else if((a|0)==29){d=f[g>>2]|0;a=32}while(0);if((a|0)!=28)if((a|0)==32)d=(d|0)!=(e|0)&1;u=q;return d|0}function OH(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0;i=u;h=u=u+31&-32;u=u+16|0;f[g>>2]=d;d=Dz(f[a+8>>2]|0)|0;a=Qx(h,0,c)|0;if(d|0)Dz(d)|0;a:do switch(a|0){case 0:case -1:{a=2;break}default:{a=a+-1|0;if(a>>>0>(e-(f[g>>2]|0)|0)>>>0)a=1;else while(1){if(!a){a=0;break a}c=b[h>>0]|0;e=f[g>>2]|0;f[g>>2]=e+1;b[e>>0]=c;h=h+1|0;a=a+-1|0}}}while(0);u=i;return a|0}function PH(a){a=a|0;var b=0,c=0;a=a+8|0;b=Dz(f[a>>2]|0)|0;c=cy(0,0,4)|0;if(b|0)Dz(b)|0;if(!c){a=f[a>>2]|0;if(!a)a=1;else{b=Dz(a)|0;a=ry()|0;if(b|0)Dz(b)|0;return (a|0)==1|0}}else a=-1;return a|0}function QH(a){a=a|0;return 0}function RH(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0;k=d;j=a+8|0;h=0;i=0;a:while(1){if((c|0)==(d|0)|h>>>0>=e>>>0)break;g=Dz(f[j>>2]|0)|0;a=oy(c,k-c|0,b)|0;if(g|0)Dz(g)|0;switch(a|0){case -2:case -1:break a;case 0:{a=1;break}default:{}}h=h+1|0;i=a+i|0;c=c+a|0}return i|0}function SH(a){a=a|0;var b=0;a=f[a+8>>2]|0;if(a){b=Dz(a)|0;a=ry()|0;if(b)Dz(b)|0}else a=1;return a|0}function TH(a){a=a|0;var b=0,c=0;f[a>>2]=16988;b=a+8|0;c=f[b>>2]|0;if((c|0)!=(BC()|0))zz(f[b>>2]|0);eC(a);return}function UH(a){a=a|0;TH(a);QK(a);return}function VH(a,b,c,d,e,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;var j=0;b=u;a=u=u+31&-32;u=u+16|0;j=a+4|0;f[j>>2]=c;f[a>>2]=g;h=cI(c,d,j,g,h,a,1114111,0)|0;f[e>>2]=f[j>>2];f[i>>2]=f[a>>2];u=b;return h|0}function WH(a,b,c,d,e,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;var j=0;b=u;a=u=u+31&-32;u=u+16|0;j=a+4|0;f[j>>2]=c;f[a>>2]=g;h=bI(c,d,j,g,h,a,1114111,0)|0;f[e>>2]=f[j>>2];f[i>>2]=f[a>>2];u=b;return h|0}function XH(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f[e>>2]=c;return 3}function YH(a){a=a|0;return 0}function ZH(a){a=a|0;return 0}function _H(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return aI(c,d,e,1114111,0)|0}function $H(a){a=a|0;return 4}function aI(a,c,d,e,f){a=a|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;p=c;q=a;if(((p-q|0)>2&(f&4|0)!=0?(b[a>>0]|0)==-17:0)?(b[a+1>>0]|0)==-69:0){o=0;a=(b[a+2>>0]|0)==-65?a+3|0:a}else o=0;a:while(1){if(!(o>>>0<d>>>0&a>>>0<c>>>0)){r=31;break}k=b[a>>0]|0;n=k&255;if(n>>>0>e>>>0){r=31;break}i=a+1|0;do if(k<<24>>24<=-1){if((k&255)<194){r=31;break a}j=a+2|0;l=a;f=p-l|0;if((k&255)<224){if((f|0)<2){r=31;break a}f=h[i>>0]|0;if((f&192|0)!=128){r=31;break a}if((f&63|n<<6&1984)>>>0>e>>>0){r=31;break a}else{f=o;a=j;break}}m=a+3|0;if((k&255)<240){if((f|0)<3){r=31;break a}g=b[j>>0]|0;i=h[i>>0]|0;f=i&224;switch(k<<24>>24){case -32:{if((f|0)!=160){a=l;break a}break}case -19:{if((f|0)!=128){a=l;break a}break}default:if((i&192|0)!=128){a=l;break a}}f=g&255;if((f&192|0)!=128){r=31;break a}if((i<<6&4032|n<<12&61440|f&63)>>>0>e>>>0){r=31;break a}else{f=o;a=m;break}}if((k&255)>=245){r=31;break a}if((d-o|0)>>>0<2|(f|0)<4){r=31;break a}g=b[i>>0]|0;f=b[j>>0]|0;i=b[m>>0]|0;j=g&255;switch(k<<24>>24){case -16:{if((g+112&255)>=48){a=l;break a}break}case -12:{if((j&240|0)!=128){a=l;break a}break}default:if((j&192|0)!=128){a=l;break a}}g=f&255;if((g&192|0)!=128){r=31;break a}f=i&255;if((f&192|0)!=128){r=31;break a}if((j<<12&258048|n<<18&1835008|g<<6&4032|f&63)>>>0>e>>>0){r=31;break a}else{f=o+1|0;a=a+4|0}}else{f=o;a=i}while(0);o=f+1|0}return a-q|0}function bI(a,c,e,g,i,j,k,l){a=a|0;c=c|0;e=e|0;g=g|0;i=i|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;f[e>>2]=a;f[j>>2]=g;s=c;if((((l&4|0?(m=f[e>>2]|0,(s-m|0)>2):0)?(b[m>>0]|0)==-17:0)?(b[m+1>>0]|0)==-69:0)?(b[m+2>>0]|0)==-65:0)f[e>>2]=m+3;r=i;a:while(1){g=f[e>>2]|0;a=g>>>0<c>>>0;if(!a){t=40;break}q=f[j>>2]|0;if(q>>>0>=i>>>0){t=40;break}o=b[g>>0]|0;p=o&255;if(p>>>0>k>>>0){a=2;break}a=g+1|0;do if(o<<24>>24>-1)d[q>>1]=o&255;else{if((o&255)<194){a=2;break a}m=s-g|0;l=g+2|0;if((o&255)<224){if((m|0)<2){a=1;break a}a=h[a>>0]|0;if((a&192|0)!=128){a=2;break a}a=a&63|p<<6&1984;if(a>>>0>k>>>0){a=2;break a}d[q>>1]=a;a=l;break}n=g+3|0;if((o&255)<240){if((m|0)<3){a=1;break a}g=b[l>>0]|0;m=h[a>>0]|0;a=m&224;switch(o<<24>>24){case -32:{if((a|0)!=160){a=2;break a}break}case -19:{if((a|0)!=128){a=2;break a}break}default:if((m&192|0)!=128){a=2;break a}}a=g&255;if((a&192|0)!=128){a=2;break a}a=m<<6&4032|p<<12|a&63;if((a&65535)>>>0>k>>>0){a=2;break a}d[q>>1]=a;a=n;break}if((o&255)>=245){a=2;break a}if((m|0)<4){a=1;break a}m=b[a>>0]|0;a=b[l>>0]|0;g=b[n>>0]|0;n=m&255;switch(o<<24>>24){case -16:{if((m+112&255)>=48){a=2;break a}break}case -12:{if((n&240|0)!=128){a=2;break a}break}default:if((n&192|0)!=128){a=2;break a}}l=a&255;if((l&192|0)!=128){a=2;break a}a=g&255;if((a&192|0)!=128){a=2;break a}if((r-q|0)<4){a=1;break a}g=p&7;m=l<<6;a=a&63;if((n<<12&258048|g<<18|m&4032|a)>>>0>k>>>0){a=2;break a}d[q>>1]=n<<2&60|l>>>4&3|((n>>>4&3|g<<2)<<6)+16320|55296;q=q+2|0;f[j>>2]=q;d[q>>1]=a|m&960|56320;a=(f[e>>2]|0)+4|0}while(0);f[e>>2]=a;f[j>>2]=(f[j>>2]|0)+2}if((t|0)==40)a=a&1;return a|0}function cI(a,c,e,g,h,i,k,l){a=a|0;c=c|0;e=e|0;g=g|0;h=h|0;i=i|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0;f[e>>2]=a;f[i>>2]=g;if(l&2)if((h-g|0)<3)a=1;else{f[i>>2]=g+1;b[g>>0]=-17;m=f[i>>2]|0;f[i>>2]=m+1;b[m>>0]=-69;m=f[i>>2]|0;f[i>>2]=m+1;b[m>>0]=-65;m=4}else m=4;a:do if((m|0)==4){q=c;a=f[e>>2]|0;while(1){if(a>>>0>=c>>>0){a=0;break a}g=d[a>>1]|0;p=g&65535;if(p>>>0>k>>>0){a=2;break a}do if((g&65535)<128){a=f[i>>2]|0;if((h-a|0)<1){a=1;break a}f[i>>2]=a+1;b[a>>0]=g}else{n=p&63;o=(n|128)&255;if((g&65535)<2048){a=f[i>>2]|0;if((h-a|0)<2){a=1;break a}f[i>>2]=a+1;b[a>>0]=p>>>6|192;p=f[i>>2]|0;f[i>>2]=p+1;b[p>>0]=o;break}l=(p>>>12|224)&255;m=(p>>>6&63|128)&255;if((g&65535)<55296){a=f[i>>2]|0;if((h-a|0)<3){a=1;break a}f[i>>2]=a+1;b[a>>0]=l;p=f[i>>2]|0;f[i>>2]=p+1;b[p>>0]=m;p=f[i>>2]|0;f[i>>2]=p+1;b[p>>0]=o;break}if((g&65535)>=56320){if((g&65535)<57344){a=2;break a}a=f[i>>2]|0;if((h-a|0)<3){a=1;break a}f[i>>2]=a+1;b[a>>0]=l;p=f[i>>2]|0;f[i>>2]=p+1;b[p>>0]=m;p=f[i>>2]|0;f[i>>2]=p+1;b[p>>0]=o;break}if((q-a|0)<4){a=1;break a}a=a+2|0;g=j[a>>1]|0;if((g&64512|0)!=56320){a=2;break a}if((h-(f[i>>2]|0)|0)<4){a=1;break a}l=p&960;if(((l<<10)+65536|n<<10|g&1023)>>>0>k>>>0){a=2;break a}f[e>>2]=a;n=(l>>>6)+1|0;o=f[i>>2]|0;f[i>>2]=o+1;b[o>>0]=n>>>2|240;o=f[i>>2]|0;f[i>>2]=o+1;b[o>>0]=p>>>2&15|n<<4&48|128;o=f[i>>2]|0;f[i>>2]=o+1;b[o>>0]=p<<4&48|g>>>6&15|128;p=f[i>>2]|0;f[i>>2]=p+1;b[p>>0]=g&63|128}while(0);a=(f[e>>2]|0)+2|0;f[e>>2]=a}}while(0);return a|0}function dI(a){a=a|0;var b=0,c=0,d=0,e=0;f[a>>2]=17036;d=a+8|0;e=a+12|0;c=0;while(1){b=f[d>>2]|0;if(c>>>0>=(f[e>>2]|0)-b>>2>>>0)break;b=f[b+(c<<2)>>2]|0;if(b|0)GK(b)|0;c=c+1|0}_K(a+144|0);fI(d);eC(a);return}function eI(a){a=a|0;dI(a);QK(a);return}function fI(a){a=a|0;var c=0,d=0,e=0,g=0;c=f[a>>2]|0;do if(c|0){d=a+4|0;e=f[d>>2]|0;while(1){if((e|0)==(c|0))break;g=e+-4|0;f[d>>2]=g;e=g}if((a+16|0)==(c|0)){b[a+128>>0]=0;break}else{QK(c);break}}while(0);return}function gI(a){a=a|0;var c=0;f[a>>2]=17056;c=f[a+8>>2]|0;if(c|0?b[a+12>>0]|0:0)RK(c);eC(a);return}function hI(a){a=a|0;gI(a);QK(a);return}function iI(a,b){a=a|0;b=b|0;if(b<<24>>24>-1){b=(rI()|0)+((b&255)<<2)|0;b=f[b>>2]&255}return b|0}function jI(a,c,d){a=a|0;c=c|0;d=d|0;while(1){if((c|0)==(d|0))break;a=b[c>>0]|0;if(a<<24>>24>-1){a=rI()|0;a=f[a+(b[c>>0]<<2)>>2]&255}b[c>>0]=a;c=c+1|0}return d|0}function kI(a,b){a=a|0;b=b|0;if(b<<24>>24>-1){b=(qI()|0)+(b<<24>>24<<2)|0;b=f[b>>2]&255}return b|0}function lI(a,c,d){a=a|0;c=c|0;d=d|0;while(1){if((c|0)==(d|0))break;a=b[c>>0]|0;if(a<<24>>24>-1){a=qI()|0;a=f[a+(b[c>>0]<<2)>>2]&255}b[c>>0]=a;c=c+1|0}return d|0}function mI(a,b){a=a|0;b=b|0;return b|0}function nI(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;while(1){if((c|0)==(d|0))break;b[e>>0]=b[c>>0]|0;e=e+1|0;c=c+1|0}return d|0}function oI(a,b,c){a=a|0;b=b|0;c=c|0;return (b<<24>>24>-1?b:c)|0}function pI(a,c,d,e,f){a=a|0;c=c|0;d=d|0;e=e|0;f=f|0;while(1){if((c|0)==(d|0))break;a=b[c>>0]|0;b[f>>0]=a<<24>>24>-1?a:e;f=f+1|0;c=c+1|0}return d|0}function qI(){var a=0;a=vy()|0;return f[a>>2]|0}function rI(){var a=0;a=ty()|0;return f[a>>2]|0}function sI(){var a=0;a=qy()|0;return f[a>>2]|0}function tI(a){a=a|0;f[a>>2]=17108;_K(a+12|0);eC(a);return}function uI(a){a=a|0;tI(a);QK(a);return}function vI(a){a=a|0;return b[a+8>>0]|0}function wI(a){a=a|0;return b[a+9>>0]|0}function xI(a,b){a=a|0;b=b|0;ZK(a,b+12|0);return}function yI(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0;g=u;d=u=u+31&-32;u=u+16|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;e=_A(55962)|0;if(e>>>0>4294967279)XK(a);if(e>>>0<11){b[a+11>>0]=e;c=a}else{h=e+16&-16;c=OK(h)|0;f[a>>2]=c;f[a+8>>2]=h|-2147483648;f[a+4>>2]=e}fA(c,55962,e)|0;b[d>>0]=0;$A(c+e|0,d);u=g;return}function zI(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0;g=u;d=u=u+31&-32;u=u+16|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;e=_A(55956)|0;if(e>>>0>4294967279)XK(a);if(e>>>0<11){b[a+11>>0]=e;c=a}else{h=e+16&-16;c=OK(h)|0;f[a>>2]=c;f[a+8>>2]=h|-2147483648;f[a+4>>2]=e}fA(c,55956,e)|0;b[d>>0]=0;$A(c+e|0,d);u=g;return}function AI(a){a=a|0;f[a>>2]=17148;_K(a+16|0);eC(a);return}function BI(a){a=a|0;AI(a);QK(a);return}function CI(a){a=a|0;return f[a+8>>2]|0}function DI(a){a=a|0;return f[a+12>>2]|0}function EI(a,b){a=a|0;b=b|0;ZK(a,b+16|0);return}function FI(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0;g=u;d=u=u+31&-32;u=u+16|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;e=hF(17204)|0;if(e>>>0>1073741807)XK(a);do if(e>>>0>=2){c=e+4&-4;if(c>>>0>1073741823)Gb();else{h=OK(c<<2)|0;f[a>>2]=h;f[a+8>>2]=c|-2147483648;f[a+4>>2]=e;break}}else{b[a+8+3>>0]=e;h=a}while(0);xA(h,17204,e)|0;f[d>>2]=0;kC(h+(e<<2)|0,d);u=g;return}function GI(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0;g=u;d=u=u+31&-32;u=u+16|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;e=hF(17180)|0;if(e>>>0>1073741807)XK(a);do if(e>>>0>=2){c=e+4&-4;if(c>>>0>1073741823)Gb();else{h=OK(c<<2)|0;f[a>>2]=h;f[a+8>>2]=c|-2147483648;f[a+4>>2]=e;break}}else{b[a+8+3>>0]=e;h=a}while(0);xA(h,17180,e)|0;f[d>>2]=0;kC(h+(e<<2)|0,d);u=g;return}function HI(a){a=a|0;eC(a);QK(a);return}function II(a){a=a|0;eC(a);QK(a);return}function JI(a,b,c){a=a|0;b=b|0;c=c|0;if(c>>>0<128){a=(sI()|0)+(c<<1)|0;a=(d[a>>1]&b)<<16>>16!=0}else a=0;return a|0}function KI(a,b,c,e){a=a|0;b=b|0;c=c|0;e=e|0;while(1){if((b|0)==(c|0))break;if((f[b>>2]|0)>>>0<128){a=sI()|0;a=j[a+(f[b>>2]<<1)>>1]|0}else a=0;d[e>>1]=a;e=e+2|0;b=b+4|0}return c|0}function LI(a,b,c,e){a=a|0;b=b|0;c=c|0;e=e|0;while(1){if((c|0)==(e|0)){c=e;break}if((f[c>>2]|0)>>>0<128?(a=sI()|0,(d[a+(f[c>>2]<<1)>>1]&b)<<16>>16):0)break;c=c+4|0}return c|0}function MI(a,b,c,e){a=a|0;b=b|0;c=c|0;e=e|0;while(1){if((c|0)==(e|0)){c=e;break}if((f[c>>2]|0)>>>0>=128)break;a=sI()|0;if(!((d[a+(f[c>>2]<<1)>>1]&b)<<16>>16))break;c=c+4|0}return c|0}function NI(a,b){a=a|0;b=b|0;if(b>>>0<128){b=(rI()|0)+(b<<2)|0;b=f[b>>2]|0}return b|0}function OI(a,b,c){a=a|0;b=b|0;c=c|0;while(1){if((b|0)==(c|0))break;a=f[b>>2]|0;if(a>>>0<128){a=rI()|0;a=f[a+(f[b>>2]<<2)>>2]|0}f[b>>2]=a;b=b+4|0}return c|0}function PI(a,b){a=a|0;b=b|0;if(b>>>0<128){b=(qI()|0)+(b<<2)|0;b=f[b>>2]|0}return b|0}function QI(a,b,c){a=a|0;b=b|0;c=c|0;while(1){if((b|0)==(c|0))break;a=f[b>>2]|0;if(a>>>0<128){a=qI()|0;a=f[a+(f[b>>2]<<2)>>2]|0}f[b>>2]=a;b=b+4|0}return c|0}function RI(a,b){a=a|0;b=b|0;return b<<24>>24|0}function SI(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;while(1){if((c|0)==(d|0))break;f[e>>2]=b[c>>0];e=e+4|0;c=c+1|0}return d|0}function TI(a,b,c){a=a|0;b=b|0;c=c|0;return (b>>>0<128?b&255:c)|0}function UI(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0;h=(d-c|0)>>>2;a=g;g=c;while(1){if((g|0)==(d|0))break;i=f[g>>2]|0;b[a>>0]=i>>>0<128?i&255:e;a=a+1|0;g=g+4|0}return c+(h<<2)|0}function VI(a){a=a|0;eC(a);QK(a);return}function WI(a){a=a|0;eC(a);QK(a);return}function XI(a){a=a|0;eC(a);QK(a);return}function YI(a){a=a|0;f[a>>2]=17464;return}function ZI(a){a=a|0;f[a>>2]=17500;return}function _I(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;f[a+4>>2]=e+-1;f[a>>2]=17056;e=a+8|0;f[e>>2]=c;b[a+12>>0]=d&1;if(!c){d=sI()|0;f[e>>2]=d}return}function $I(a){a=a|0;Gb()}function aJ(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0;h=u;g=u=u+31&-32;u=u+16|0;f[a+4>>2]=c+-1;f[a>>2]=17036;d=a+8|0;bJ(d,28);c=a+144|0;f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;e=_A(53901)|0;if(e>>>0>4294967279)XK(c);if(e>>>0<11)b[c+11>>0]=e;else{j=e+16&-16;i=OK(j)|0;f[c>>2]=i;f[a+152>>2]=j|-2147483648;f[a+148>>2]=e;c=i}fA(c,53901,e)|0;b[g>>0]=0;$A(c+e|0,g);c=f[d>>2]|0;d=a+12|0;e=f[d>>2]|0;while(1){if((e|0)==(c|0))break;j=e+-4|0;f[d>>2]=j;e=j}cJ();dJ(a,57016);eJ();fJ(a,57024);gJ();hJ(a,57032);iJ();jJ(a,57048);kJ();lJ(a,57056);mJ();nJ(a,57064);oJ();pJ(a,57080);qJ();rJ(a,57088);sJ();tJ(a,57096);uJ();vJ(a,57120);wJ();xJ(a,57152);yJ();zJ(a,57160);AJ();BJ(a,57168);CJ();DJ(a,57176);EJ();FJ(a,57184);GJ();HJ(a,57192);IJ();JJ(a,57200);KJ();LJ(a,57208);MJ();NJ(a,57216);OJ();PJ(a,57224);QJ();RJ(a,57232);SJ();TJ(a,57240);UJ();VJ(a,57248);WJ();XJ(a,57264);YJ();ZJ(a,57280);_J();$J(a,57296);aK();bK(a,57312);cK();dK(a,57320);u=h;return}function bJ(a,c){a=a|0;c=c|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;b[a+128>>0]=0;if(c|0){qK(a,c);hK(a,c)}return}function cJ(){f[14255]=0;f[14254]=14700;return}function dJ(a,b){a=a|0;b=b|0;eK(a,b,DC(59440)|0);return}function eJ(){f[14257]=0;f[14256]=14732;return}function fJ(a,b){a=a|0;b=b|0;eK(a,b,DC(59448)|0);return}function gJ(){_I(57032,0,0,1);return}function hJ(a,b){a=a|0;b=b|0;eK(a,b,DC(59456)|0);return}function iJ(){f[14263]=0;f[14262]=17252;return}function jJ(a,b){a=a|0;b=b|0;eK(a,b,DC(59488)|0);return}function kJ(){f[14265]=0;f[14264]=17320;return}function lJ(a,b){a=a|0;b=b|0;eK(a,b,DC(61248)|0);return}function mJ(){pK(57064,1);return}function nJ(a,b){a=a|0;b=b|0;eK(a,b,DC(61256)|0);return}function oJ(){f[14271]=0;f[14270]=17368;return}function pJ(a,b){a=a|0;b=b|0;eK(a,b,DC(61264)|0);return}function qJ(){f[14273]=0;f[14272]=17416;return}function rJ(a,b){a=a|0;b=b|0;eK(a,b,DC(61272)|0);return}function sJ(){oK(57096,1);return}function tJ(a,b){a=a|0;b=b|0;eK(a,b,DC(59472)|0);return}function uJ(){nK(57120,1);return}function vJ(a,b){a=a|0;b=b|0;eK(a,b,DC(59496)|0);return}function wJ(){f[14289]=0;f[14288]=14764;return}function xJ(a,b){a=a|0;b=b|0;eK(a,b,DC(59480)|0);return}function yJ(){f[14291]=0;f[14290]=14828;return}function zJ(a,b){a=a|0;b=b|0;eK(a,b,DC(59504)|0);return}function AJ(){f[14293]=0;f[14292]=14892;return}function BJ(a,b){a=a|0;b=b|0;eK(a,b,DC(59512)|0);return}function CJ(){f[14295]=0;f[14294]=14944;return}function DJ(a,b){a=a|0;b=b|0;eK(a,b,DC(59520)|0);return}function EJ(){f[14297]=0;f[14296]=16492;return}function FJ(a,b){a=a|0;b=b|0;eK(a,b,DC(61168)|0);return}function GJ(){f[14299]=0;f[14298]=16548;return}function HJ(a,b){a=a|0;b=b|0;eK(a,b,DC(61176)|0);return}function IJ(){f[14301]=0;f[14300]=16604;return}function JJ(a,b){a=a|0;b=b|0;eK(a,b,DC(61184)|0);return}function KJ(){f[14303]=0;f[14302]=16660;return}function LJ(a,b){a=a|0;b=b|0;eK(a,b,DC(61192)|0);return}function MJ(){f[14305]=0;f[14304]=16716;return}function NJ(a,b){a=a|0;b=b|0;eK(a,b,DC(61200)|0);return}function OJ(){f[14307]=0;f[14306]=16744;return}function PJ(a,b){a=a|0;b=b|0;eK(a,b,DC(61208)|0);return}function QJ(){f[14309]=0;f[14308]=16772;return}function RJ(a,b){a=a|0;b=b|0;eK(a,b,DC(61216)|0);return}function SJ(){f[14311]=0;f[14310]=16800;return}function TJ(a,b){a=a|0;b=b|0;eK(a,b,DC(61224)|0);return}function UJ(){f[14313]=0;f[14312]=17232;YI(57256);f[14312]=14996;f[14314]=15044;return}function VJ(a,b){a=a|0;b=b|0;eK(a,b,DC(60332)|0);return}function WJ(){f[14317]=0;f[14316]=17232;ZI(57272);f[14316]=15080;f[14318]=15128;return}function XJ(a,b){a=a|0;b=b|0;eK(a,b,DC(61144)|0);return}function YJ(){var a=0;f[14321]=0;f[14320]=17232;a=BC()|0;f[14322]=a;f[14320]=16444;return}function ZJ(a,b){a=a|0;b=b|0;eK(a,b,DC(61152)|0);return}function _J(){var a=0;f[14325]=0;f[14324]=17232;a=BC()|0;f[14326]=a;f[14324]=16468;return}function $J(a,b){a=a|0;b=b|0;eK(a,b,DC(61160)|0);return}function aK(){f[14329]=0;f[14328]=16828;return}function bK(a,b){a=a|0;b=b|0;eK(a,b,DC(61232)|0);return}function cK(){f[14331]=0;f[14330]=16860;return}function dK(a,b){a=a|0;b=b|0;eK(a,b,DC(61240)|0);return}function eK(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;EK(b);e=a+8|0;d=f[e>>2]|0;if((f[a+12>>2]|0)-d>>2>>>0>c>>>0)a=e;else{fK(e,c+1|0);a=e;d=f[e>>2]|0}d=f[d+(c<<2)>>2]|0;if(d|0)GK(d)|0;f[(f[a>>2]|0)+(c<<2)>>2]=b;return}function fK(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0;g=a+4|0;c=f[g>>2]|0;e=f[a>>2]|0;d=c-e>>2;a:do if(d>>>0>=b>>>0){if(d>>>0>b>>>0){a=e+(b<<2)|0;while(1){if((c|0)==(a|0))break a;e=c+-4|0;f[g>>2]=e;c=e}}}else gK(a,b-d|0);while(0);return}function gK(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0;i=u;e=u=u+31&-32;u=u+32|0;g=a+8|0;h=a+4|0;c=f[h>>2]|0;do if((f[g>>2]|0)-c>>2>>>0<b>>>0){c=(c-(f[a>>2]|0)>>2)+b|0;d=iK(a)|0;if(d>>>0<c>>>0)$I(a);else{j=f[a>>2]|0;k=(f[g>>2]|0)-j|0;g=k>>1;jK(e,k>>2>>>0<d>>>1>>>0?(g>>>0<c>>>0?c:g):d,(f[h>>2]|0)-j>>2,a+16|0);kK(e,b);lK(a,e);mK(e);break}}else hK(a,b);while(0);u=i;return}function hK(a,b){a=a|0;b=b|0;var c=0;c=a+4|0;a=b;b=f[c>>2]|0;do{f[b>>2]=0;b=(f[c>>2]|0)+4|0;f[c>>2]=b;a=a+-1|0}while((a|0)!=0);return}function iK(a){a=a|0;return 1073741823}function jK(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0;f[a+12>>2]=0;f[a+16>>2]=e;do if(c){g=e+112|0;if(c>>>0<29&(b[g>>0]|0)==0){b[g>>0]=1;break}else{e=OK(c<<2)|0;break}}else e=0;while(0);f[a>>2]=e;d=e+(d<<2)|0;f[a+8>>2]=d;f[a+4>>2]=d;f[a+12>>2]=e+(c<<2);return}function kK(a,b){a=a|0;b=b|0;var c=0;c=a+8|0;a=b;b=f[c>>2]|0;do{f[b>>2]=0;b=(f[c>>2]|0)+4|0;f[c>>2]=b;a=a+-1|0}while((a|0)!=0);return}function lK(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0;d=f[a>>2]|0;h=a+4|0;g=b+4|0;e=(f[h>>2]|0)-d|0;c=(f[g>>2]|0)+(0-(e>>2)<<2)|0;f[g>>2]=c;if((e|0)>0){GM(c|0,d|0,e|0)|0;d=g;c=f[g>>2]|0}else d=g;g=f[a>>2]|0;f[a>>2]=c;f[d>>2]=g;g=b+8|0;e=f[h>>2]|0;f[h>>2]=f[g>>2];f[g>>2]=e;g=a+8|0;h=b+12|0;a=f[g>>2]|0;f[g>>2]=f[h>>2];f[h>>2]=a;f[b>>2]=f[d>>2];return}function mK(a){a=a|0;var c=0,d=0,e=0,g=0;c=f[a+4>>2]|0;d=a+8|0;e=f[d>>2]|0;while(1){if((e|0)==(c|0))break;g=e+-4|0;f[d>>2]=g;e=g}d=f[a>>2]|0;do if(d|0){c=f[a+16>>2]|0;if((c|0)==(d|0)){b[c+112>>0]=0;break}else{QK(d);break}}while(0);return}function nK(a,b){a=a|0;b=b|0;f[a+4>>2]=b+-1;f[a>>2]=17148;f[a+8>>2]=46;f[a+12>>2]=44;b=a+16|0;f[b>>2]=0;f[b+4>>2]=0;f[b+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[b+(a<<2)>>2]=0;a=a+1|0}return}function oK(a,c){a=a|0;c=c|0;f[a+4>>2]=c+-1;f[a>>2]=17108;b[a+8>>0]=46;b[a+9>>0]=44;c=a+12|0;f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[c+(a<<2)>>2]=0;a=a+1|0}return}function pK(a,b){a=a|0;b=b|0;f[a+4>>2]=b+-1;f[a>>2]=16988;b=BC()|0;f[a+8>>2]=b;return}function qK(a,c){a=a|0;c=c|0;var d=0;if((iK(a)|0)>>>0<c>>>0)$I(a);d=a+128|0;if(c>>>0<29&(b[d>>0]|0)==0){b[d>>0]=1;d=a+16|0}else d=OK(c<<2)|0;f[a+4>>2]=d;f[a>>2]=d;f[a+8>>2]=d+(c<<2);return}function rK(){if((b[57328]|0)==0?oM(57328)|0:0){sK()|0;f[15321]=61280}return f[15321]|0}function sK(){tK();f[15320]=57336;return 61280}function tK(){aJ(57336,1);return}function uK(){vK(61288,rK()|0);return 61288}function vK(a,b){a=a|0;b=b|0;b=f[b>>2]|0;f[a>>2]=b;EK(b);return}function wK(){if((b[57496]|0)==0?oM(57496)|0:0){uK()|0;f[15323]=61288}return f[15323]|0}function xK(a){a=a|0;var b=0;b=wK()|0;b=f[b>>2]|0;f[a>>2]=b;EK(b);return}function yK(a,b,c){a=a|0;b=b|0;c=c|0;if(!c)a=0;else a=xy(a,b,c)|0;return a|0}function zK(a){a=a|0;return}function AK(a,b){a=a|0;b=b|0;return 0}function BK(a){a=a|0;return}function CK(a){a=a|0;BK(a);QK(a);return}function DK(a){a=a|0;return 56064}function EK(a){a=a|0;FK(a+4|0);return}function FK(a){a=a|0;f[a>>2]=(f[a>>2]|0)+1;return}function GK(a){a=a|0;if((HK(a+4|0)|0)==-1){dd[f[(f[a>>2]|0)+8>>2]&511](a);a=1}else a=0;return a|0}function HK(a){a=a|0;var b=0;b=f[a>>2]|0;f[a>>2]=b+-1;return b+-1|0}function IK(a){a=a|0;EK(a);return}function JK(a){a=a|0;FK(a+8|0);return}function KK(a){a=a|0;if(GK(a)|0)LK(a);return}function LK(a){a=a|0;var b=0;b=a+8|0;if(!((f[b>>2]|0)!=0?(HK(b)|0)!=-1:0))dd[f[(f[a>>2]|0)+16>>2]&511](a);return}function MK(a){a=a|0;var b=0,c=0,d=0;c=a+4|0;b=f[c>>2]|0;while(1){if((b|0)==-1){a=0;break}d=f[c>>2]|0;if((d|0)==(b|0))f[c>>2]=b+1;if((d|0)==(b|0))break;b=d}return a|0}function NK(a,b,c){a=a|0;b=b|0;c=c|0;KM(61296)|0;while(1){if((f[a>>2]|0)!=1)break;Nb(61324,61296)|0}if(!(f[a>>2]|0)){f[a>>2]=1;LM(61296)|0;dd[c&511](b);KM(61296)|0;f[a>>2]=-1;LM(61296)|0;JM(61324)|0}else LM(61296)|0;return}function OK(a){a=a|0;var b=0;b=(a|0)==0?1:a;while(1){a=dx(b)|0;if(a|0)break;a=qM()|0;if(!a){a=0;break}cd[a&7]()}return a|0}function PK(a){a=a|0;return OK(a)|0}function QK(a){a=a|0;ex(a);return}function RK(a){a=a|0;QK(a);return}function SK(){Gb()}function TK(a,b){a=a|0;b=b|0;var c=0,d=0;d=vx(b)|0;c=OK(d+13|0)|0;f[c>>2]=d;f[c+4>>2]=d;f[c+8>>2]=0;c=UK(c)|0;GM(c|0,b|0,d+1|0)|0;f[a>>2]=c;return}function UK(a){a=a|0;return a+12|0}function VK(a,b){a=a|0;b=b|0;f[a>>2]=17640;TK(a+4|0,b);return}function WK(a){a=a|0;return 1}function XK(a){a=a|0;Gb()}function YK(a){a=a|0;Gb()}function ZK(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0;g=u;d=u=u+31&-32;u=u+16|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;if((b[c+11>>0]|0)<0){e=f[c>>2]|0;c=f[c+4>>2]|0;if(c>>>0>4294967279)XK(a);if(c>>>0<11)b[a+11>>0]=c;else{i=c+16&-16;h=OK(i)|0;f[a>>2]=h;f[a+8>>2]=i|-2147483648;f[a+4>>2]=c;a=h}fA(a,e,c)|0;b[d>>0]=0;$A(a+c|0,d)}else{f[a>>2]=f[c>>2];f[a+4>>2]=f[c+4>>2];f[a+8>>2]=f[c+8>>2]}u=g;return}function _K(a){a=a|0;if((b[a+11>>0]|0)<0)QK(f[a>>2]|0);return}function $K(a,c){a=a|0;c=c|0;var d=0,e=0;if((a|0)!=(c|0)){d=b[c+11>>0]|0;e=d<<24>>24<0;aL(a,e?f[c>>2]|0:c,e?f[c+4>>2]|0:d&255)|0}return a|0}function aL(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0;k=u;i=u=u+31&-32;u=u+16|0;j=a+11|0;e=b[j>>0]|0;g=e<<24>>24<0;if(g)h=(f[a+8>>2]&2147483647)+-1|0;else h=10;do if(h>>>0>=d>>>0){if(g)e=f[a>>2]|0;else e=a;bL(e,c,d)|0;b[i>>0]=0;$A(e+d|0,i);if((b[j>>0]|0)<0){f[a+4>>2]=d;break}else{b[j>>0]=d;break}}else{if(g)e=f[a+4>>2]|0;else e=e&255;cL(a,h,d-h|0,e,0,e,d,c)}while(0);u=k;return a|0}function bL(a,b,c){a=a|0;b=b|0;c=c|0;if(c|0)HM(a|0,b|0,c|0)|0;return a|0}function cL(a,c,d,e,g,h,i,j){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0,n=0,o=0;o=u;n=u=u+31&-32;u=u+16|0;if((-18-c|0)>>>0<d>>>0)XK(a);if((b[a+11>>0]|0)<0)m=f[a>>2]|0;else m=a;if(c>>>0<2147483623){k=d+c|0;l=c<<1;k=k>>>0<l>>>0?l:k;k=k>>>0<11?11:k+16&-16}else k=-17;l=OK(k)|0;if(g|0)fA(l,m,g)|0;if(i|0)fA(l+g|0,j,i)|0;d=e-h|0;e=d-g|0;if(e|0)fA(l+g+i|0,m+g+h|0,e)|0;if((c|0)!=10)QK(m);f[a>>2]=l;f[a+8>>2]=k|-2147483648;i=d+i|0;f[a+4>>2]=i;b[n>>0]=0;$A(l+i|0,n);u=o;return}function dL(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0;if(c>>>0>4294967279)XK(a);i=a+11|0;e=b[i>>0]|0;g=e<<24>>24<0;if(g){j=f[a+4>>2]|0;d=(f[a+8>>2]&2147483647)+-1|0}else{j=e&255;d=10}h=j>>>0>c>>>0?j:c;c=h>>>0<11;h=c?10:(h+16&-16)+-1|0;do if((h|0)!=(d|0)){do if(c){c=f[a>>2]|0;if(g){g=0;d=c;c=a;e=13}else{fA(a,c,(e&255)+1|0)|0;QK(c);e=15}}else{c=OK(h+1|0)|0;if(g){g=1;d=f[a>>2]|0;e=13;break}else{fA(c,a,(e&255)+1|0)|0;e=14;break}}while(0);if((e|0)==13){fA(c,d,(f[a+4>>2]|0)+1|0)|0;QK(d);if(g)e=14;else e=15}if((e|0)==14){f[a+8>>2]=h+1|-2147483648;f[a+4>>2]=j;f[a>>2]=c;break}else if((e|0)==15){b[i>>0]=j;break}}while(0);return}function eL(a,b){a=a|0;b=b|0;return aL(a,b,_A(b)|0)|0}function fL(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0;j=u;g=u=u+31&-32;u=u+16|0;h=a+11|0;e=b[h>>0]|0;i=e<<24>>24<0;if(i)e=f[a+4>>2]|0;else e=e&255;do if(e>>>0>=c>>>0)if(i){i=(f[a>>2]|0)+c|0;b[g>>0]=0;$A(i,g);f[a+4>>2]=c;break}else{b[g>>0]=0;$A(a+c|0,g);b[h>>0]=c;break}else gL(a,c-e|0,d)|0;while(0);u=j;return}function gL(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0;l=u;j=u=u+31&-32;u=u+16|0;if(c|0){k=a+11|0;e=b[k>>0]|0;if(e<<24>>24<0){h=f[a+4>>2]|0;g=(f[a+8>>2]&2147483647)+-1|0}else{h=e&255;g=10}i=h+c|0;if((g-h|0)>>>0<c>>>0){hL(a,g,i-g|0,h,h,0,0);e=b[k>>0]|0}if(e<<24>>24<0)e=f[a>>2]|0;else e=a;ZF(e+h|0,c,d)|0;if((b[k>>0]|0)<0)f[a+4>>2]=i;else b[k>>0]=i;b[j>>0]=0;$A(e+i|0,j)}u=l;return a|0}function hL(a,c,d,e,g,h,i){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0;if((-17-c|0)>>>0<d>>>0)XK(a);if((b[a+11>>0]|0)<0)l=f[a>>2]|0;else l=a;if(c>>>0<2147483623){j=d+c|0;k=c<<1;j=j>>>0<k>>>0?k:j;j=j>>>0<11?11:j+16&-16}else j=-17;k=OK(j)|0;if(g|0)fA(k,l,g)|0;d=e-h-g|0;if(d|0)fA(k+g+i|0,l+g+h|0,d)|0;if((c|0)!=10)QK(l);f[a>>2]=k;f[a+8>>2]=j|-2147483648;return}function iL(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0;l=u;j=u=u+31&-32;u=u+16|0;k=a+11|0;e=b[k>>0]|0;i=e<<24>>24<0;if(i){g=f[a+4>>2]|0;e=(f[a+8>>2]&2147483647)+-1|0}else{g=e&255;e=10}h=g+d|0;if((e-g|0)>>>0>=d>>>0){if(d|0){if(i)e=f[a>>2]|0;else e=a;fA(e+g|0,c,d)|0;if((b[k>>0]|0)<0)f[a+4>>2]=h;else b[k>>0]=h;b[j>>0]=0;$A(e+h|0,j)}}else cL(a,e,h-e|0,g,g,0,d,c);u=l;return a|0}function jL(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0;j=u;i=u=u+31&-32;u=u+16|0;h=i;i=i+1|0;b[h>>0]=c;e=a+11|0;c=b[e>>0]|0;d=c<<24>>24<0;if(d){g=f[a+4>>2]|0;c=(f[a+8>>2]&2147483647)+-1|0}else{g=c&255;c=10}if((g|0)==(c|0)){hL(a,c,1,c,c,0,0);c=c+1|0;if((b[e>>0]|0)<0)d=8;else d=7}else{c=g+1|0;if(d)d=8;else d=7}if((d|0)==7){b[e>>0]=c;c=a}else if((d|0)==8){e=f[a>>2]|0;f[a+4>>2]=c;c=e}a=c+g|0;$A(a,h);b[i>>0]=0;$A(a+1|0,i);u=j;return}function kL(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0;h=b[a+11>>0]|0;i=h<<24>>24<0;if(i)h=f[a+4>>2]|0;else h=h&255;if((g|0)==-1|h>>>0<c>>>0)YK(a);h=h-c|0;d=h>>>0<d>>>0?h:d;if(i)a=f[a>>2]|0;h=d>>>0>g>>>0;a=yK(a+c|0,e,h?g:d)|0;if(!a)return (d>>>0<g>>>0?-1:h&1)|0;else return a|0;return 0}function lL(a){a=a|0;if((b[a+8+3>>0]|0)<0)QK(f[a>>2]|0);return}function mL(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0;l=u;j=u=u+31&-32;u=u+16|0;e=a+8|0;k=e+3|0;h=b[k>>0]|0;i=h<<24>>24<0;if(i)g=(f[e>>2]&2147483647)+-1|0;else g=1;do if(g>>>0>=d>>>0){if(i)e=f[a>>2]|0;else e=a;nL(e,c,d)|0;f[j>>2]=0;kC(e+(d<<2)|0,j);if((b[k>>0]|0)<0){f[a+4>>2]=d;break}else{b[k>>0]=d;break}}else{if(i)e=f[a+4>>2]|0;else e=h&255;oL(a,g,d-g|0,e,0,e,d,c)}while(0);u=l;return a|0}function nL(a,b,c){a=a|0;b=b|0;c=c|0;if(c)oz(a,b,c)|0;return a|0}function oL(a,c,d,e,g,h,i,j){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0;p=u;o=u=u+31&-32;u=u+16|0;if((1073741806-c|0)>>>0<d>>>0)XK(a);l=a+8|0;if((b[l+3>>0]|0)<0)n=f[a>>2]|0;else n=a;if(c>>>0<536870887){d=d+c|0;k=c<<1;d=d>>>0<k>>>0?k:d;d=d>>>0<2?2:d+4&-4;if(d>>>0>1073741823)Gb();else m=d}else m=1073741807;k=OK(m<<2)|0;if(g|0)xA(k,n,g)|0;if(i|0)xA(k+(g<<2)|0,j,i)|0;d=e-h|0;e=d-g|0;if(e|0)xA(k+(g<<2)+(i<<2)|0,n+(g<<2)+(h<<2)|0,e)|0;if((c|0)!=1)QK(n);f[a>>2]=k;f[l>>2]=m|-2147483648;i=d+i|0;f[a+4>>2]=i;f[o>>2]=0;kC(k+(i<<2)|0,o);u=p;return}function pL(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0;if(c>>>0>1073741807)XK(a);k=a+8|0;i=k+3|0;e=b[i>>0]|0;g=e<<24>>24<0;if(g){j=f[a+4>>2]|0;d=(f[k>>2]&2147483647)+-1|0}else{j=e&255;d=1}h=j>>>0>c>>>0?j:c;c=h>>>0<2;h=c?1:(h+4&-4)+-1|0;do if((h|0)!=(d|0)){do if(c){c=f[a>>2]|0;if(g){g=0;d=c;c=a;e=15}else{xA(a,c,(e&255)+1|0)|0;QK(c);e=17}}else{c=h+1|0;if(c>>>0>1073741823)Gb();c=OK(c<<2)|0;if(g){g=1;d=f[a>>2]|0;e=15;break}else{xA(c,a,(e&255)+1|0)|0;e=16;break}}while(0);if((e|0)==15){xA(c,d,(f[a+4>>2]|0)+1|0)|0;QK(d);if(g)e=16;else e=17}if((e|0)==16){f[k>>2]=h+1|-2147483648;f[a+4>>2]=j;f[a>>2]=c;break}else if((e|0)==17){b[i>>0]=j;break}}while(0);return}function qL(a,b){a=a|0;b=b|0;return mL(a,b,hF(b)|0)|0}function rL(a,c,d,e,g,h,i){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0;if((1073741807-c|0)>>>0<d>>>0)XK(a);m=a+8|0;if((b[m+3>>0]|0)<0)l=f[a>>2]|0;else l=a;if(c>>>0<536870887){d=d+c|0;j=c<<1;d=d>>>0<j>>>0?j:d;d=d>>>0<2?2:d+4&-4;if(d>>>0>1073741823)Gb();else k=d}else k=1073741807;j=OK(k<<2)|0;if(g|0)xA(j,l,g)|0;d=e-h-g|0;if(d|0)xA(j+(g<<2)+(i<<2)|0,l+(g<<2)+(h<<2)|0,d)|0;if((c|0)!=1)QK(l);f[a>>2]=j;f[m>>2]=k|-2147483648;return}
function pd(a){a=a|0;var b=0;b=u;u=u+a|0;u=u+15&-16;return b|0}function qd(){return u|0}function rd(a){a=a|0;u=a}function sd(a,b){a=a|0;b=b|0;u=a;v=b}function td(a,b){a=a|0;b=b|0;if(!x){x=a;y=b}}function ud(a){a=a|0;I=a}function vd(){return I|0}function wd(a){a=a|0;f[a>>2]=4232;a=f[a+24>>2]|0;if(!a)return;RK(a);return}function xd(a){a=a|0;var b=0;f[a>>2]=4232;b=f[a+24>>2]|0;if(!b){QK(a);return}RK(b);QK(a);return}function yd(a){a=a|0;a=a+16|0;I=f[a+4>>2]|0;return f[a>>2]|0}function zd(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;a=a+8|0;d=f[a+4>>2]|0;return ((d|0)<(c|0)|((d|0)==(c|0)?(f[a>>2]|0)>>>0<b>>>0:0)?2:0)|0}function Ad(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0;d=a+16|0;h=d;e=f[h>>2]|0;h=wM(e|0,f[h+4>>2]|0,c|0,0)|0;j=I;g=a+8|0;i=f[g+4>>2]|0;if((j|0)>(i|0)|((j|0)==(i|0)?h>>>0>(f[g>>2]|0)>>>0:0)){j=0;return j|0}GM(b|0,(f[a+4>>2]|0)+e|0,c|0)|0;i=d;i=wM(f[i>>2]|0,f[i+4>>2]|0,c|0,0)|0;j=d;f[j>>2]=i;f[j+4>>2]=I;j=1;return j|0}function Bd(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;d=a+8|0;e=f[d+4>>2]|0;if((c|0)<0|((e|0)<(c|0)|((e|0)==(c|0)?(f[d>>2]|0)>>>0<b>>>0:0))){e=0;return e|0}e=a+16|0;f[e>>2]=b;f[e+4>>2]=c;e=1;return e|0}function Cd(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0,h=0;f[a>>2]=4232;g=a+8|0;f[g>>2]=c;f[g+4>>2]=d;g=a+16|0;f[g>>2]=0;f[g+4>>2]=0;g=a+24|0;f[g>>2]=0;if(!e){d=b;e=a+4|0;f[e>>2]=d;return}h=d>>>0<0|(d|0)==0&c>>>0<4294967295;e=h?c:-1;d=PK(e)|0;f[g>>2]=d;GM(d|0,b|0,c|0)|0;e=a+4|0;f[e>>2]=d;return}function Dd(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0;i=a+4|0;j=a+8|0;k=a+12|0;b[a+24>>0]=0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;f[a+12>>2]=0;h=a+16|0;f[h>>2]=d;f[h+4>>2]=e;h=f[c>>2]|0;d=f[c+4>>2]|0;e=d;if(d){IK(d);d=f[i>>2]|0;f[a>>2]=h;f[i>>2]=e;if(d|0)KK(d)}else{f[a>>2]=h;f[i>>2]=e}f[j>>2]=g;if(!g)return;f[k>>2]=(f[g+12>>2]|0)+1;return}function Ed(a){a=a|0;var c=0,d=0,e=0,g=0,h=0;h=u;u=u+16|0;c=h;if(!(Fd(a,1,0)|0)){g=0;u=h;return g|0}d=f[a>>2]|0;e=f[a+4>>2]|0;g=(e|0)==0;if(!g)IK(e);if(Wc[f[(f[d>>2]|0)+16>>2]&63](d,c,1)|0)a=b[c>>0]|0;else{Gd(a);a=0}if(!g)KK(e);g=a;u=h;return g|0}function Fd(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0;if((d|0)<0)Pa(55956,47599,290,18687);l=a+16|0;e=l;k=f[e>>2]|0;e=f[e+4>>2]|0;if(!((e|0)<(d|0)|(e|0)==(d|0)&k>>>0<c>>>0)){g=f[a+8>>2]|0;do if(g)if(Fd(g,c,d)|0){e=l;g=f[e>>2]|0;e=f[e+4>>2]|0;break}else{l=0;return l|0}else g=k;while(0);k=xM(g|0,e|0,c|0,d|0)|0;f[l>>2]=k;f[l+4>>2]=I;l=1;return l|0}if((e|0)>0|(e|0)==0&k>>>0>0){g=f[a+8>>2]|0;do if(g){while(1){c=g+16|0;h=c;d=f[h>>2]|0;h=f[h+4>>2]|0;if((h|0)<(e|0)|(h|0)==(e|0)&d>>>0<k>>>0){e=7;break}d=xM(d|0,h|0,k|0,e|0)|0;h=c;f[h>>2]=d;f[h+4>>2]=I;g=f[g+8>>2]|0;if(!g){e=9;break}}if((e|0)==7)Pa(18700,47599,327,18717);else if((e|0)==9){j=l;i=f[j>>2]|0;j=f[j+4>>2]|0;break}}else{i=k;j=e}while(0);h=f[a>>2]|0;k=f[h>>2]|0;d=f[k+20>>2]|0;k=Uc[f[k+8>>2]&127](h)|0;k=wM(k|0,I|0,i|0,j|0)|0;Wc[d&63](h,k,I)|0;f[l>>2]=0;f[l+4>>2]=0}b[a+24>>0]=1;l=0;return l|0}function Gd(a){a=a|0;var c=0;c=a+16|0;f[c>>2]=0;f[c+4>>2]=0;c=f[a+8>>2]|0;if(!c){c=a+24|0;b[c>>0]=1;return}Gd(c);c=a+24|0;b[c>>0]=1;return}function Hd(a){a=a|0;var b=0,c=0,d=0,e=0,g=0;g=u;u=u+16|0;b=g;if(!(Fd(a,2,0)|0)){e=0;u=g;return e|0}c=f[a>>2]|0;d=f[a+4>>2]|0;e=(d|0)==0;if(!e)IK(d);if(Wc[f[(f[c>>2]|0)+16>>2]&63](c,b,2)|0)a=((h[b>>0]|0)<<8|(h[b+1>>0]|0))&65535;else{Gd(a);a=0}if(!e)KK(d);e=a;u=g;return e|0}function Id(a){a=a|0;var b=0,c=0,d=0,e=0,g=0;g=u;u=u+16|0;b=g;if(!(Fd(a,4,0)|0)){e=0;u=g;return e|0}c=f[a>>2]|0;d=f[a+4>>2]|0;e=(d|0)==0;if(!e)IK(d);if(Wc[f[(f[c>>2]|0)+16>>2]&63](c,b,4)|0)a=(h[b+1>>0]|0)<<16|(h[b>>0]|0)<<24|(h[b+2>>0]|0)<<8|(h[b+3>>0]|0);else{Gd(a);a=0}if(!e)KK(d);e=a;u=g;return e|0}function Jd(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0;k=u;u=u+16|0;j=k;i=k+12|0;f[j>>2]=0;f[j+4>>2]=0;f[j+8>>2]=0;h=c+16|0;a:do if(!((f[h>>2]|0)==0&(f[h+4>>2]|0)==0)){e=c+4|0;b:while(1){if(!(Fd(c,1,0)|0)){d=5;break}d=f[c>>2]|0;g=f[e>>2]|0;h=(g|0)==0;if(!h)IK(g);if(Wc[f[(f[d>>2]|0)+16>>2]&63](d,i,1)|0){d=b[i>>0]|0;if(!(d<<24>>24))d=2;else{jL(j,d);d=0}}else{Gd(c);f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;d=1}if(!h)KK(g);switch(d&3){case 0:break;case 2:{d=15;break b}default:break a}}if((d|0)==5){f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;break}else if((d|0)==15){f[a>>2]=f[j>>2];f[a+4>>2]=f[j+4>>2];f[a+8>>2]=f[j+8>>2];f[j>>2]=0;f[j+4>>2]=0;f[j+8>>2]=0;break}}else{f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0}while(0);if((b[j+11>>0]|0)>=0){u=k;return}QK(f[j>>2]|0);u=k;return}function Kd(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0;if(!(Fd(a,c,d)|0)){a=0;return a|0}d=f[a>>2]|0;e=f[a+4>>2]|0;g=(e|0)==0;if(!g)IK(e);d=Wc[f[(f[d>>2]|0)+16>>2]&63](d,b,c)|0;if(!d)Gd(a);if(g){a=d;return a|0}KK(e);a=d;return a|0}function Ld(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=f[a>>2]|0;d=Uc[f[(f[d>>2]|0)+8>>2]&127](d)|0;c=wM(d|0,I|0,b|0,c|0)|0;b=f[a>>2]|0;return Wc[f[(f[b>>2]|0)+12>>2]&63](b,c,I)|0}function Md(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0;while(1){d=a+16|0;g=d;e=f[g>>2]|0;g=f[g+4>>2]|0;if((g|0)<(c|0)|(g|0)==(c|0)&e>>>0<b>>>0){a=3;break}e=xM(e|0,g|0,b|0,c|0)|0;g=d;f[g>>2]=e;f[g+4>>2]=I;a=f[a+8>>2]|0;if(!a){a=5;break}}if((a|0)==3)Pa(18700,47599,327,18717);else if((a|0)==5)return}function Nd(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,i=0,j=0,k=0,l=0,m=0;f[a>>2]=b;f[a+4>>2]=c;k=a+8|0;f[k>>2]=c;l=a+16|0;j=l;f[j>>2]=0;f[j+4>>2]=0;j=a+24|0;f[j>>2]=0;if(!c){l=64;l=64-l|0;f[j>>2]=l;return}d=b+1|0;f[a>>2]=d;e=h[b>>0]|0;i=c+-1|0;f[k>>2]=i;e=EM(e|0,0,56)|0;g=I;m=l;f[m>>2]=e;f[m+4>>2]=g;if(!i){m=56;m=64-m|0;f[j>>2]=m;return}i=b+2|0;f[a>>2]=i;d=h[d>>0]|0;m=c+-2|0;f[k>>2]=m;d=EM(d|0,0,48)|0;d=e|d;e=g|I;g=l;f[g>>2]=d;f[g+4>>2]=e;if(!m){m=48;m=64-m|0;f[j>>2]=m;return}g=b+3|0;f[a>>2]=g;i=h[i>>0]|0;m=c+-3|0;f[k>>2]=m;i=EM(i|0,0,40)|0;i=d|i;d=e|I;e=l;f[e>>2]=i;f[e+4>>2]=d;if(!m){m=40;m=64-m|0;f[j>>2]=m;return}e=b+4|0;f[a>>2]=e;g=h[g>>0]|0;m=c+-4|0;f[k>>2]=m;d=d|g;g=l;f[g>>2]=i;f[g+4>>2]=d;if(!m){m=32;m=64-m|0;f[j>>2]=m;return}g=b+5|0;f[a>>2]=g;e=h[e>>0]|0;m=c+-5|0;f[k>>2]=m;e=EM(e|0,0,24)|0;e=i|e;d=d|I;i=l;f[i>>2]=e;f[i+4>>2]=d;if(!m){m=24;m=64-m|0;f[j>>2]=m;return}i=b+6|0;f[a>>2]=i;g=h[g>>0]|0;m=c+-6|0;f[k>>2]=m;g=EM(g|0,0,16)|0;e=e|g;d=d|I;g=l;f[g>>2]=e;f[g+4>>2]=d;if(!m){m=16;m=64-m|0;f[j>>2]=m;return}g=b+7|0;f[a>>2]=g;i=h[i>>0]|0;m=c+-7|0;f[k>>2]=m;i=EM(i|0,0,8)|0;e=e|i;d=d|I;i=l;f[i>>2]=e;f[i+4>>2]=d;if(!m){m=8;m=64-m|0;f[j>>2]=m;return}f[a>>2]=b+8;b=h[g>>0]|0;f[k>>2]=c+-8;m=l;f[m>>2]=e|b;f[m+4>>2]=d;m=0;m=64-m|0;f[j>>2]=m;return}function Od(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,i=0,j=0,k=0,l=0,m=0;i=a+24|0;c=f[i>>2]|0;if((c|0)<(b|0)){c=64-c|0;e=a+8|0;a:do if((c|0)>7){g=a+16|0;d=f[e>>2]|0;do{if(!d)break a;l=f[a>>2]|0;f[a>>2]=l+1;l=h[l>>0]|0;d=d+-1|0;f[e>>2]=d;c=c+-8|0;l=EM(l|0,0,c|0)|0;m=g;k=f[m+4>>2]|I;j=g;f[j>>2]=f[m>>2]|l;f[j+4>>2]=k}while((c|0)>7)}while(0);c=64-c|0;f[i>>2]=c}l=a+16|0;k=l;j=f[k>>2]|0;k=f[k+4>>2]|0;m=DM(j|0,k|0,64-b|0)|0;k=EM(j|0,k|0,b|0)|0;f[l>>2]=k;f[l+4>>2]=I;f[i>>2]=c-b;return m|0}function Pd(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,i=0,j=0,k=0,l=0,m=0;i=a+24|0;c=f[i>>2]|0;if((c|0)<(b|0)){c=64-c|0;e=a+8|0;a:do if((c|0)>7){g=a+16|0;d=f[e>>2]|0;do{if(!d)break a;l=f[a>>2]|0;f[a>>2]=l+1;l=h[l>>0]|0;d=d+-1|0;f[e>>2]=d;c=c+-8|0;l=EM(l|0,0,c|0)|0;m=g;k=f[m+4>>2]|I;j=g;f[j>>2]=f[m>>2]|l;f[j+4>>2]=k}while((c|0)>7)}while(0);c=64-c|0;f[i>>2]=c}m=a+16|0;l=m;l=EM(f[l>>2]|0,f[l+4>>2]|0,b|0)|0;f[m>>2]=l;f[m+4>>2]=I;f[i>>2]=c-b;return}function Qd(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;l=a+24|0;j=a+8|0;m=a+16|0;k=0;c=f[l>>2]|0;while(1){if((c|0)<1){c=64-c|0;a:do if((c|0)>7){d=f[j>>2]|0;do{if(!d)break a;n=f[a>>2]|0;f[a>>2]=n+1;n=h[n>>0]|0;d=d+-1|0;f[j>>2]=d;c=c+-8|0;n=EM(n|0,0,c|0)|0;o=m;e=f[o+4>>2]|I;g=m;f[g>>2]=f[o>>2]|n;f[g+4>>2]=e}while((c|0)>7)}while(0);g=64-c|0;f[l>>2]=g}else g=c;n=m;o=f[n>>2]|0;n=f[n+4>>2]|0;e=EM(o|0,n|0,1)|0;d=I;c=m;f[c>>2]=e;f[c+4>>2]=d;c=g+-1|0;f[l>>2]=c;if(!((n|0)>-1|(n|0)==-1&o>>>0>4294967295))break;if((k|0)>19){c=0;i=20;break}else k=k+1|0}if((i|0)==20)return c|0;if(!k){f[b>>2]=0;o=1;return o|0}if((g|0)<=(k|0)){c=65-g|0;b:do if((c|0)>7){g=f[j>>2]|0;do{if(!g)break b;o=f[a>>2]|0;f[a>>2]=o+1;o=h[o>>0]|0;g=g+-1|0;f[j>>2]=g;c=c+-8|0;o=EM(o|0,0,c|0)|0;e=e|o;d=d|I;o=m;f[o>>2]=e;f[o+4>>2]=d}while((c|0)>7)}while(0);c=64-c|0;f[l>>2]=c}o=DM(e|0,d|0,64-k|0)|0;j=EM(e|0,d|0,k|0)|0;n=m;f[n>>2]=j;f[n+4>>2]=I;f[l>>2]=c-k;o=o+(1<<k)|0;f[b>>2]=o+-1;if((o|0)>1){o=1;return o|0}else Pa(18749,47599,435,47620);return 0}function Rd(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;k=a+12|0;d=f[k>>2]|0;l=a+4|0;j=f[l>>2]|0;m=f[a>>2]|0;n=m;e=j;if((d|0)!=(j-m|0)){f[k>>2]=d+1;b[n+d>>0]=c;return}j=a+8|0;d=f[j>>2]|0;if((e|0)==(d|0)){i=d-m|0;d=i+1|0;if((d|0)<0)$I(a);e=i<<1;e=i>>>0<1073741823?(e>>>0<d>>>0?d:e):2147483647;if(!e)h=0;else h=OK(e)|0;g=h+i|0;b[g>>0]=c;d=g+(0-i)|0;if((i|0)>0)GM(d|0,n|0,i|0)|0;f[a>>2]=d;f[l>>2]=g+1;f[j>>2]=h+e;if(m|0)QK(n)}else{b[e>>0]=c;f[l>>2]=(f[l>>2]|0)+1}f[k>>2]=(f[k>>2]|0)+1;return}function Sd(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0;i=a+12|0;e=f[i>>2]|0;g=e+2|0;d=f[a>>2]|0;h=(f[a+4>>2]|0)-d|0;if(g>>>0>h>>>0){Td(a,g-h|0);g=a;e=f[i>>2]|0;d=f[a>>2]|0}else g=a;f[i>>2]=e+1;b[d+e>>0]=(c&65535)>>>8;a=f[i>>2]|0;f[i>>2]=a+1;b[(f[g>>2]|0)+a>>0]=c;return}function Td(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0;j=a+8|0;g=f[j>>2]|0;k=a+4|0;d=f[k>>2]|0;if((g-d|0)>>>0>=c>>>0){do{b[d>>0]=0;d=(f[k>>2]|0)+1|0;f[k>>2]=d;c=c+-1|0}while((c|0)!=0);return}e=f[a>>2]|0;h=d-e|0;d=h+c|0;if((d|0)<0)$I(a);g=g-e|0;i=g<<1;d=g>>>0<1073741823?(i>>>0<d>>>0?d:i):2147483647;if(!d)e=0;else e=OK(d)|0;i=e+h|0;h=e+d|0;g=i;d=i;do{b[d>>0]=0;d=g+1|0;g=d;c=c+-1|0}while((c|0)!=0);c=f[a>>2]|0;e=(f[k>>2]|0)-c|0;d=i+(0-e)|0;if((e|0)>0)GM(d|0,c|0,e|0)|0;f[a>>2]=d;f[k>>2]=g;f[j>>2]=h;if(!c)return;QK(c);return}function Ud(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0;i=a+12|0;e=f[i>>2]|0;g=e+4|0;d=f[a>>2]|0;h=(f[a+4>>2]|0)-d|0;if(g>>>0>h>>>0){Td(a,g-h|0);g=a;e=f[i>>2]|0;d=f[a>>2]|0}else g=a;f[i>>2]=e+1;b[d+e>>0]=c>>>24;a=f[i>>2]|0;f[i>>2]=a+1;b[(f[g>>2]|0)+a>>0]=c>>>16;a=f[i>>2]|0;f[i>>2]=a+1;b[(f[g>>2]|0)+a>>0]=c>>>8;a=f[i>>2]|0;f[i>>2]=a+1;b[(f[g>>2]|0)+a>>0]=c;return}function Vd(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0;j=a+12|0;g=f[j>>2]|0;h=g+8|0;e=f[a>>2]|0;i=(f[a+4>>2]|0)-e|0;if(h>>>0>i>>>0){Td(a,h-i|0);h=a;g=f[j>>2]|0;e=f[a>>2]|0}else h=a;a=DM(c|0,d|0,56)|0;f[j>>2]=g+1;b[e+g>>0]=a;a=DM(c|0,d|0,48)|0;i=f[j>>2]|0;f[j>>2]=i+1;b[(f[h>>2]|0)+i>>0]=a;i=DM(c|0,d|0,40)|0;a=f[j>>2]|0;f[j>>2]=a+1;b[(f[h>>2]|0)+a>>0]=i;a=f[j>>2]|0;f[j>>2]=a+1;b[(f[h>>2]|0)+a>>0]=d;a=DM(c|0,d|0,24)|0;i=f[j>>2]|0;f[j>>2]=i+1;b[(f[h>>2]|0)+i>>0]=a;i=DM(c|0,d|0,16)|0;a=f[j>>2]|0;f[j>>2]=a+1;b[(f[h>>2]|0)+a>>0]=i;a=DM(c|0,d|0,8)|0;d=f[j>>2]|0;f[j>>2]=d+1;b[(f[h>>2]|0)+d>>0]=a;d=f[j>>2]|0;f[j>>2]=d+1;b[(f[h>>2]|0)+d>>0]=c;return}function Wd(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0;switch(c|0){case 1:{if(!(e>>>0<0|(e|0)==0&d>>>0<256))Pa(18760,47599,551,19563);Rd(a,d&255);return}case 2:{if(!(e>>>0<0|(e|0)==0&d>>>0<65536))Pa(18774,47599,555,19563);i=a+12|0;h=f[i>>2]|0;e=h+2|0;c=f[a>>2]|0;g=(f[a+4>>2]|0)-c|0;if(e>>>0>g>>>0){Td(a,e-g|0);g=a;e=f[i>>2]|0;c=f[a>>2]|0}else{g=a;e=h}f[i>>2]=e+1;b[c+e>>0]=(d&65535)>>>8;a=f[i>>2]|0;f[i>>2]=a+1;b[(f[g>>2]|0)+a>>0]=d;return}case 4:{if(!(e>>>0<1|(e|0)==1&d>>>0<0))Pa(18790,47599,559,19563);i=a+12|0;h=f[i>>2]|0;e=h+4|0;c=f[a>>2]|0;g=(f[a+4>>2]|0)-c|0;if(e>>>0>g>>>0){Td(a,e-g|0);g=a;e=f[i>>2]|0;c=f[a>>2]|0}else{g=a;e=h}f[i>>2]=e+1;b[c+e>>0]=d>>>24;a=f[i>>2]|0;f[i>>2]=a+1;b[(f[g>>2]|0)+a>>0]=d>>>16;a=f[i>>2]|0;f[i>>2]=a+1;b[(f[g>>2]|0)+a>>0]=d>>>8;a=f[i>>2]|0;f[i>>2]=a+1;b[(f[g>>2]|0)+a>>0]=d;return}case 8:{Vd(a,d,e);return}default:Pa(55956,47599,566,19563)}}function Xd(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0;k=a+12|0;i=c+11|0;h=b[i>>0]|0;j=c+4|0;d=f[j>>2]|0;e=(f[k>>2]|0)+1+(h<<24>>24<0?d:h&255)|0;g=(f[a+4>>2]|0)-(f[a>>2]|0)|0;if(e>>>0>g>>>0){Td(a,e-g|0);g=b[i>>0]|0;d=f[j>>2]|0}else g=h;if(!((g<<24>>24<0?d:g&255)|0)){i=a;j=f[k>>2]|0;c=j+1|0;f[k>>2]=c;k=f[i>>2]|0;k=k+j|0;b[k>>0]=0;return}e=0;d=g;do{g=b[(d<<24>>24<0?f[c>>2]|0:c)+e>>0]|0;h=f[k>>2]|0;f[k>>2]=h+1;b[(f[a>>2]|0)+h>>0]=g;e=e+1|0;d=b[i>>0]|0}while(e>>>0<(d<<24>>24<0?f[j>>2]|0:d&255)>>>0);j=f[k>>2]|0;i=j+1|0;f[k>>2]=i;k=f[a>>2]|0;k=k+j|0;b[k>>0]=0;return}function Yd(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0;j=a+12|0;e=f[j>>2]|0;k=b+4|0;c=f[k>>2]|0;d=f[b>>2]|0;i=c-d+e|0;g=f[a>>2]|0;h=(f[a+4>>2]|0)-g|0;if(i>>>0>h>>>0){Td(a,i-h|0);g=f[a>>2]|0;e=f[j>>2]|0;d=f[b>>2]|0;c=f[k>>2]|0}GM(g+e|0,d|0,c-d|0)|0;f[j>>2]=(f[k>>2]|0)-(f[b>>2]|0)+(f[j>>2]|0);return}function Zd(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0;j=a+12|0;c=f[j>>2]|0;h=a+4|0;d=f[h>>2]|0;e=f[a>>2]|0;if((c|0)!=(d-e|0))Pa(18810,47599,618,18838);i=c+b|0;if(c>>>0>=i>>>0){if(c>>>0>i>>>0?(g=e+i|0,(d|0)!=(g|0)):0)f[h>>2]=g}else{Td(a,b);c=f[j>>2]|0}f[j>>2]=c+b;return}function _d(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0;if((b|0)<=-1)Pa(18843,47599,626,18855);if(!b)return;j=a+4|0;k=f[j>>2]|0;g=f[a>>2]|0;h=k-g|0;i=h+b|0;e=g;d=k;if(h>>>0>=i>>>0)if(h>>>0>i>>>0?(c=e+i|0,(d|0)!=(c|0)):0)f[j>>2]=c;else c=k;else{Td(a,b);e=f[a>>2]|0;g=e;c=f[j>>2]|0}d=f[a+12>>2]|0;c=c-g-b|0;if(c>>>0<=d>>>0)return;a=e+d|0;HM(a+b|0,a|0,c-d|0)|0;return}function $d(a){a=a|0;var b=0;f[a>>2]=4264;b=f[a+24>>2]|0;if(!b)return;a=a+28|0;if((f[a>>2]|0)!=(b|0))f[a>>2]=b;QK(b);return}function ae(a){a=a|0;var b=0,c=0;f[a>>2]=4264;b=f[a+24>>2]|0;if(!b){QK(a);return}c=a+28|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);QK(a);return}function be(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;m=u;u=u+160|0;g=m+136|0;j=m;k=j+56|0;l=j+4|0;f[j>>2]=292;f[k>>2]=312;bB(j+56|0,l);f[j+128>>2]=0;f[j+132>>2]=-1;f[j>>2]=4304;f[k>>2]=4324;fB(l);f[l>>2]=4340;i=j+36|0;f[i>>2]=0;f[i+4>>2]=0;f[i+8>>2]=0;f[i+12>>2]=0;f[j+52>>2]=16;f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;ce(l,g);if((b[g+11>>0]|0)<0)QK(f[g>>2]|0);if((f[d>>2]|0)>0){e=0;do{de(j,18862,2)|0;e=e+1|0}while((e|0)<(f[d>>2]|0))}p=de(j,18865,5)|0;ee(g,c);e=g+11|0;n=b[e>>0]|0;o=n<<24>>24<0;de(de(p,o?f[g>>2]|0:g,o?f[g+4>>2]|0:n&255)|0,18871,7)|0;if((b[e>>0]|0)<0)QK(f[g>>2]|0);if((f[d>>2]|0)>0){e=0;do{de(j,18862,2)|0;e=e+1|0}while((e|0)<(f[d>>2]|0))}o=de(j,18879,6)|0;p=c+8|0;p=de(oB(o,f[p>>2]|0,f[p+4>>2]|0)|0,18886,17)|0;de(nB(p,f[c+16>>2]|0)|0,18904,2)|0;if(b[c+36>>0]|0){if((f[d>>2]|0)>0){e=0;do{de(j,18862,2)|0;e=e+1|0}while((e|0)<(f[d>>2]|0))}g=de(j,18907,9)|0;g=de(mB(g,h[c+37>>0]|0)|0,30204,1)|0;if((f[d>>2]|0)>0){e=0;do{de(g,18862,2)|0;e=e+1|0}while((e|0)<(f[d>>2]|0))}p=de(g,18917,7)|0;o=p+(f[(f[p>>2]|0)+-12>>2]|0)+4|0;f[o>>2]=f[o>>2]&-75|8;de(nB(p,f[c+40>>2]|0)|0,30204,1)|0}fe(a,l);f[j>>2]=4304;f[k>>2]=4324;f[l>>2]=4340;if((b[i+11>>0]|0)>=0){Rz(l);NA(j,4280);Mz(k);u=m;return}QK(f[i>>2]|0);Rz(l);NA(j,4280);Mz(k);u=m;return}function ce(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0;i=a+32|0;$K(i,c)|0;h=a+44|0;f[h>>2]=0;j=a+48|0;g=f[j>>2]|0;if(g&8|0){c=b[i+11>>0]|0;if(c<<24>>24<0){c=f[i>>2]|0;d=c;e=c;c=c+(f[a+36>>2]|0)|0}else{d=i;e=i;c=i+(c&255)|0}f[h>>2]=c;f[a+8>>2]=d;f[a+12>>2]=e;f[a+16>>2]=c}if(!(g&16))return;d=i+11|0;c=b[d>>0]|0;if(c<<24>>24<0){g=f[a+36>>2]|0;f[h>>2]=(f[i>>2]|0)+g;c=(f[a+40>>2]&2147483647)+-1|0;h=g}else{g=c&255;f[h>>2]=i+g;c=10;h=g}fL(i,c,0);c=b[d>>0]|0;if(c<<24>>24<0){d=f[i>>2]|0;g=d;e=f[a+36>>2]|0}else{g=i;e=c&255;d=i}c=a+24|0;f[c>>2]=d;f[a+20>>2]=d;f[a+28>>2]=g+e;if(!(f[j>>2]&3))return;f[c>>2]=d+h;return}function de(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;m=u;u=u+16|0;h=m+12|0;k=m;l=m+8|0;iB(k,a);if(!(b[k>>0]|0)){jB(k);u=m;return a|0}i=(f[a>>2]|0)+-12|0;f[l>>2]=f[a+(f[i>>2]|0)+24>>2];i=a+(f[i>>2]|0)|0;j=f[i+4>>2]|0;g=c+d|0;e=i+76|0;d=f[e>>2]|0;if((d|0)==-1){dB(h,i);d=yC(h,59456)|0;d=Vc[f[(f[d>>2]|0)+28>>2]&31](d,32)|0;zC(h);d=d<<24>>24;f[e>>2]=d}f[h>>2]=f[l>>2];if(ge(h,c,(j&176|0)==32?g:c,g,i,d&255)|0){jB(k);u=m;return a|0}l=a+(f[(f[a>>2]|0)+-12>>2]|0)|0;aB(l,f[l+16>>2]|5);jB(k);u=m;return a|0}function ee(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,i=0,j=0,k=0,l=0;l=u;u=u+160|0;j=l+136|0;k=l;d=f[c+20>>2]|0;if((d|0)!=1970628964){f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;b[a+11>>0]=4;b[a+4>>0]=0;b[a>>0]=d>>>24;b[a+1>>0]=d>>>16;b[a+2>>0]=d>>>8;b[a+3>>0]=d;u=l;return}g=k+56|0;i=k+4|0;f[k>>2]=292;f[g>>2]=312;bB(k+56|0,i);f[k+128>>2]=0;f[k+132>>2]=-1;f[k>>2]=4304;f[g>>2]=4324;fB(i);f[i>>2]=4340;e=k+36|0;f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;f[e+12>>2]=0;f[k+52>>2]=16;f[j>>2]=0;f[j+4>>2]=0;f[j+8>>2]=0;ce(i,j);if((b[j+11>>0]|0)<0)QK(f[j>>2]|0);d=k+(f[(f[k>>2]|0)+-12>>2]|0)+4|0;f[d>>2]=f[d>>2]&-75|8;f[k+(f[(f[k>>2]|0)+-12>>2]|0)+76>>2]=48;f[k+(f[(f[k>>2]|0)+-12>>2]|0)+12>>2]=2;c=c+24|0;d=0;do{switch(d|0){case 4:case 6:case 8:case 10:{b[j>>0]=45;de(k,j,1)|0;break}default:{}}mB(k,h[(f[c>>2]|0)+d>>0]|0)|0;d=d+1|0}while((d|0)<16);fe(a,i);f[k>>2]=4304;f[g>>2]=4324;f[i>>2]=4340;if((b[e+11>>0]|0)<0)QK(f[e>>2]|0);Rz(i);NA(k,4280);Mz(g);u=l;return}function fe(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0;d=f[c+48>>2]|0;if(d&16|0){d=c+44|0;e=f[d>>2]|0;g=f[c+24>>2]|0;if(e>>>0<g>>>0){f[d>>2]=g;e=g}d=f[c+20>>2]|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;c=e-d|0;if(c>>>0>4294967279)XK(a);if(c>>>0<11)b[a+11>>0]=c;else{h=c+16&-16;g=OK(h)|0;f[a>>2]=g;f[a+8>>2]=h|-2147483648;f[a+4>>2]=c;a=g}if((d|0)!=(e|0)){g=a;while(1){b[g>>0]=b[d>>0]|0;d=d+1|0;if((d|0)==(e|0))break;else g=g+1|0}a=a+c|0}b[a>>0]=0;return}if(!(d&8)){f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;return}d=f[c+8>>2]|0;g=f[c+16>>2]|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;c=g-d|0;if(c>>>0>4294967279)XK(a);if(c>>>0<11)b[a+11>>0]=c;else{e=c+16&-16;h=OK(e)|0;f[a>>2]=h;f[a+8>>2]=e|-2147483648;f[a+4>>2]=c;a=h}if((d|0)!=(g|0)){e=a;while(1){b[e>>0]=b[d>>0]|0;d=d+1|0;if((d|0)==(g|0))break;else e=e+1|0}a=a+c|0}b[a>>0]=0;return}function ge(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0;o=u;u=u+16|0;m=o;n=f[a>>2]|0;if(!n){n=0;u=o;return n|0}i=c;j=e-i|0;l=g+12|0;k=f[l>>2]|0;j=(k|0)>(j|0)?k-j|0:0;k=d;g=k-i|0;if((g|0)>0?(Wc[f[(f[n>>2]|0)+48>>2]&63](n,c,g)|0)!=(g|0):0){f[a>>2]=0;n=0;u=o;return n|0}do if((j|0)>0){f[m>>2]=0;f[m+4>>2]=0;f[m+8>>2]=0;if(j>>>0<11){c=m+11|0;b[c>>0]=j;g=m;i=m}else{c=j+16&-16;g=OK(c)|0;f[m>>2]=g;f[m+8>>2]=c|-2147483648;f[m+4>>2]=j;c=m+11|0;i=m}IM(g|0,h|0,j|0)|0;b[g+j>>0]=0;if((Wc[f[(f[n>>2]|0)+48>>2]&63](n,(b[c>>0]|0)<0?f[i>>2]|0:m,j)|0)==(j|0)){if((b[c>>0]|0)<0)QK(f[i>>2]|0);break}f[a>>2]=0;if((b[c>>0]|0)<0)QK(f[i>>2]|0);n=0;u=o;return n|0}while(0);e=e-k|0;if((e|0)>0?(Wc[f[(f[n>>2]|0)+48>>2]&63](n,d,e)|0)!=(e|0):0){f[a>>2]=0;n=0;u=o;return n|0}f[l>>2]=0;u=o;return n|0}function he(a){a=a|0;Sa(a|0)|0;RL()}function ie(a){a=a|0;var c=0;f[a>>2]=4340;c=a+32|0;if((b[c+11>>0]|0)<0)QK(f[c>>2]|0);Rz(a);return}function je(a){a=a|0;var c=0;f[a>>2]=4340;c=a+32|0;if((b[c+11>>0]|0)<0)QK(f[c>>2]|0);Rz(a);QK(a);return}function ke(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0;i=c+44|0;j=f[i>>2]|0;m=c+24|0;n=f[m>>2]|0;k=n;if(j>>>0<n>>>0){f[i>>2]=n;l=k}else l=j;j=h&24;a:do if((j|0)!=0?!((g|0)==1&(j|0)==24):0){b:do switch(g|0){case 0:{i=0;j=0;break}case 1:if(!(h&8)){j=k-(f[c+20>>2]|0)|0;i=j;j=((j|0)<0)<<31>>31;break b}else{j=(f[c+12>>2]|0)-(f[c+8>>2]|0)|0;i=j;j=((j|0)<0)<<31>>31;break b}case 2:{i=c+32|0;if((b[i+11>>0]|0)<0)i=f[i>>2]|0;j=l-i|0;i=j;j=((j|0)<0)<<31>>31;break}default:{j=-1;i=-1;break a}}while(0);j=wM(i|0,j|0,d|0,e|0)|0;i=I;if((i|0)>=0){k=c+32|0;if((b[k+11>>0]|0)<0)k=f[k>>2]|0;e=l-k|0;d=((e|0)<0)<<31>>31;if(!((d|0)<(i|0)|(d|0)==(i|0)&e>>>0<j>>>0)){k=h&8;if(!((j|0)==0&(i|0)==0)){if(k|0?(f[c+12>>2]|0)==0:0){j=-1;i=-1;break}if((h&16|0)!=0&(n|0)==0){j=-1;i=-1;break}}if(k|0){f[c+12>>2]=(f[c+8>>2]|0)+j;f[c+16>>2]=l}if(h&16)f[m>>2]=(f[c+20>>2]|0)+j}else{j=-1;i=-1}}else{j=-1;i=-1}}else{j=-1;i=-1}while(0);n=a;f[n>>2]=0;f[n+4>>2]=0;a=a+8|0;f[a>>2]=j;f[a+4>>2]=i;return}function le(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;c=c+8|0;id[f[(f[b>>2]|0)+16>>2]&15](a,b,f[c>>2]|0,f[c+4>>2]|0,0,d);return}function me(a){a=a|0;var b=0,c=0,d=0;b=a+44|0;d=f[b>>2]|0;c=f[a+24>>2]|0;if(d>>>0<c>>>0){f[b>>2]=c;d=c}if(!(f[a+48>>2]&8)){a=-1;return a|0}b=a+16|0;c=f[b>>2]|0;if(c>>>0<d>>>0){f[b>>2]=d;c=d}b=f[a+12>>2]|0;if(b>>>0>=c>>>0){a=-1;return a|0}a=h[b>>0]|0;return a|0}function ne(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0;e=a+44|0;d=f[e>>2]|0;g=f[a+24>>2]|0;if(d>>>0<g>>>0){f[e>>2]=g;d=g}h=a+12|0;e=f[h>>2]|0;if((f[a+8>>2]|0)>>>0>=e>>>0){c=-1;return c|0}if((c|0)==-1){f[h>>2]=e+-1;f[a+16>>2]=d;c=0;return c|0}if(!(f[a+48>>2]&16)){g=c&255;e=e+-1|0;if(g<<24>>24!=(b[e>>0]|0)){c=-1;return c|0}}else{g=c&255;e=e+-1|0}f[h>>2]=e;f[a+16>>2]=d;b[e>>0]=g;return c|0}function oe(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;t=u;u=u+16|0;o=t;if((c|0)==-1){s=0;u=t;return s|0}p=a+12|0;q=a+8|0;r=(f[p>>2]|0)-(f[q>>2]|0)|0;s=a+24|0;k=f[s>>2]|0;m=a+28|0;d=f[m>>2]|0;if((k|0)==(d|0)){j=a+48|0;if(!(f[j>>2]&16)){s=-1;u=t;return s|0}h=a+20|0;i=f[h>>2]|0;n=a+44|0;l=(f[n>>2]|0)-i|0;g=a+32|0;jL(g,0);d=g+11|0;if((b[d>>0]|0)<0)e=(f[a+40>>2]&2147483647)+-1|0;else e=10;fL(g,e,0);d=b[d>>0]|0;if(d<<24>>24<0){e=f[g>>2]|0;d=f[a+36>>2]|0}else{e=g;d=d&255}d=e+d|0;f[h>>2]=e;f[m>>2]=d;k=e+(k-i)|0;f[s>>2]=k;e=e+l|0;f[n>>2]=e;l=n;g=n;i=d}else{e=a+44|0;l=e;j=a+48|0;g=e;e=f[e>>2]|0;i=d}h=k+1|0;f[o>>2]=h;e=f[(h>>>0<e>>>0?g:o)>>2]|0;f[l>>2]=e;if(f[j>>2]&8|0){d=a+32|0;if((b[d+11>>0]|0)<0)d=f[d>>2]|0;f[q>>2]=d;f[p>>2]=d+r;f[a+16>>2]=e}if((k|0)==(i|0)){s=Vc[f[(f[a>>2]|0)+52>>2]&31](a,c&255)|0;u=t;return s|0}else{f[s>>2]=h;b[k>>0]=c;s=c&255;u=t;return s|0}return 0}function pe(a){a=a|0;var c=0,d=0,e=0;f[a>>2]=4304;c=a+56|0;f[c>>2]=4324;d=a+4|0;f[d>>2]=4340;e=a+36|0;if((b[e+11>>0]|0)<0)QK(f[e>>2]|0);Rz(d);NA(a,4280);Mz(c);return}function qe(a){a=a|0;var c=0,d=0,e=0;f[a>>2]=4304;c=a+56|0;f[c>>2]=4324;d=a+4|0;f[d>>2]=4340;e=a+36|0;if((b[e+11>>0]|0)<0)QK(f[e>>2]|0);Rz(d);NA(a,4280);Mz(c);QK(a);return}function re(a){a=a|0;var c=0,d=0,e=0;a=a+(f[(f[a>>2]|0)+-12>>2]|0)|0;f[a>>2]=4304;c=a+56|0;f[c>>2]=4324;d=a+4|0;f[d>>2]=4340;e=a+36|0;if((b[e+11>>0]|0)<0)QK(f[e>>2]|0);Rz(d);NA(a,4280);Mz(c);return}function se(a){a=a|0;var c=0,d=0,e=0;a=a+(f[(f[a>>2]|0)+-12>>2]|0)|0;f[a>>2]=4304;c=a+56|0;f[c>>2]=4324;d=a+4|0;f[d>>2]=4340;e=a+36|0;if((b[e+11>>0]|0)<0)QK(f[e>>2]|0);Rz(d);NA(a,4280);Mz(c);QK(a);return}function te(a){a=a|0;var b=0,c=0,d=0,e=0,g=0;f[a>>2]=4404;e=a+44|0;b=f[e>>2]|0;if(b|0){g=a+48|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[a>>2]=4264;c=f[a+24>>2]|0;if(!c)return;b=a+28|0;if((f[b>>2]|0)!=(c|0))f[b>>2]=c;QK(c);return}function ue(a){a=a|0;var b=0,c=0,d=0,e=0,g=0;f[a>>2]=4404;e=a+44|0;b=f[e>>2]|0;if(b|0){g=a+48|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[a>>2]=4264;b=f[a+24>>2]|0;if(!b){QK(a);return}c=a+28|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);QK(a);return}function ve(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0;k=u;u=u+160|0;g=k+136|0;h=k;i=h+56|0;j=h+4|0;f[h>>2]=292;f[i>>2]=312;bB(h+56|0,j);f[h+128>>2]=0;f[h+132>>2]=-1;f[h>>2]=4304;f[i>>2]=4324;fB(j);f[j>>2]=4340;e=h+36|0;f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;f[e+12>>2]=0;f[h+52>>2]=16;f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;ce(j,g);if((b[g+11>>0]|0)<0)QK(f[g>>2]|0);be(g,c,d);d=g+11|0;c=b[d>>0]|0;l=c<<24>>24<0;de(h,l?f[g>>2]|0:g,l?f[g+4>>2]|0:c&255)|0;if((b[d>>0]|0)<0)QK(f[g>>2]|0);fe(a,j);f[h>>2]=4304;f[i>>2]=4324;f[j>>2]=4340;if((b[e+11>>0]|0)>=0){Rz(j);NA(h,4280);Mz(i);u=k;return}QK(f[e>>2]|0);Rz(j);NA(h,4280);Mz(i);u=k;return}function we(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;m=u;u=u+32|0;j=m;k=f[d+12>>2]|0;Zd(d,b[c+36>>0]|0?12:8);g=f[c+44>>2]|0;h=f[c+48>>2]|0;a:do if((g|0)==(h|0)){e=a+8|0;l=8}else{e=a+8|0;i=e+11|0;while(1){n=f[g>>2]|0;fd[f[(f[n>>2]|0)+12>>2]&127](a,n,d);if(f[a>>2]|0)break a;if((b[i>>0]|0)<0)QK(f[e>>2]|0);g=g+8|0;if((g|0)==(h|0)){l=8;break}}}while(0);if((l|0)==8){i=56816;l=f[i+4>>2]|0;n=a;f[n>>2]=f[i>>2];f[n+4>>2]=l;ZK(e,56824)}ze(j,c,d,k);e=j+8|0;if((b[e+11>>0]|0)>=0){u=m;return}QK(f[e>>2]|0);u=m;return}function xe(a){a=a|0;b[a+37>>0]=0;return}function ye(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;l=u;u=u+32|0;k=l+12|0;h=l;j=c+8|0;e=j;g=f[e>>2]|0;e=f[e+4>>2]|0;do if(!((g|0)==0&(e|0)==0)){i=c+16|0;c=xM(g|0,e|0,f[i>>2]|0,0)|0;e=I;if(Fd(d,c,e)|0)if(e>>>0>0|(e|0)==0&c>>>0>2147483647){f[h>>2]=0;f[h+4>>2]=0;f[h+8>>2]=0;Rj(a,2,101,h);if((b[h+11>>0]|0)>=0){u=l;return}QK(f[h>>2]|0);u=l;return}else{c=f[d>>2]|0;e=f[d+4>>2]|0;g=(e|0)==0;if(!g)IK(e);n=j;o=f[n>>2]|0;n=f[n+4>>2]|0;m=f[i>>2]|0;h=f[c>>2]|0;i=f[h+20>>2]|0;h=Uc[f[h+8>>2]&127](c)|0;j=I;m=xM(o|0,n|0,m|0,0)|0;j=wM(m|0,I|0,h|0,j|0)|0;Wc[i&63](c,j,I)|0;if(g)break;KK(e);break}}else{c=d;do{o=c+16|0;f[o>>2]=0;f[o+4>>2]=0;c=f[c+8>>2]|0}while((c|0)!=0)}while(0);if(b[d+24>>0]|0){f[k>>2]=0;f[k+4>>2]=0;f[k+8>>2]=0;Rj(a,2,100,k);if((b[k+11>>0]|0)<0)QK(f[k>>2]|0)}else{m=56816;n=f[m+4>>2]|0;o=a;f[o>>2]=f[m>>2];f[o+4>>2]=n;ZK(a+8|0,56824)}u=l;return}function ze(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,i=0,j=0,k=0,l=0,m=0,n=0;g=c+36|0;m=b[g>>0]|0?12:8;k=c+20|0;n=(f[k>>2]|0)==1970628964?m|16:m;i=d+4|0;l=(f[i>>2]|0)-e-m-(f[d>>2]|0)+n|0;j=d+12|0;f[j>>2]=e;_d(d,n-m|0);Ud(d,l);Ud(d,f[k>>2]|0);do if((f[k>>2]|0)==1970628964){e=c+24|0;if(((f[c+28>>2]|0)-(f[e>>2]|0)|0)==16){Yd(d,e);break}else Pa(19079,19104,309,19111)}while(0);do if(b[g>>0]|0){e=f[c+40>>2]|0;if(e>>>0<16777216){Ud(d,h[c+37>>0]<<24|e);break}else Pa(19126,19104,314,19111)}while(0);f[j>>2]=(f[i>>2]|0)-(f[d>>2]|0);l=56816;m=f[l+4>>2]|0;n=a;f[n>>2]=f[l>>2];f[n+4>>2]=m;ZK(a+8|0,56824);return}function Ae(a){a=a|0;var b=0,c=0,d=0,e=0,g=0;f[a>>2]=4436;b=f[a+64>>2]|0;if(b|0){c=a+68|0;d=f[c>>2]|0;if((d|0)!=(b|0))f[c>>2]=d+(~((d+-4-b|0)>>>2)<<2);QK(b)}f[a>>2]=4404;e=a+44|0;b=f[e>>2]|0;if(b|0){g=a+48|0;c=f[g>>2]|0;if((c|0)!=(b|0)){do{d=c+-8|0;f[g>>2]=d;c=f[c+-4>>2]|0;if(!c)c=d;else{KK(c);c=f[g>>2]|0}}while((c|0)!=(b|0));b=f[e>>2]|0}QK(b)}f[a>>2]=4264;c=f[a+24>>2]|0;if(!c)return;b=a+28|0;if((f[b>>2]|0)!=(c|0))f[b>>2]=c;QK(c);return}function Be(a){a=a|0;var b=0,c=0,d=0,e=0,g=0;f[a>>2]=4436;b=f[a+64>>2]|0;if(b|0){c=a+68|0;d=f[c>>2]|0;if((d|0)!=(b|0))f[c>>2]=d+(~((d+-4-b|0)>>>2)<<2);QK(b)}f[a>>2]=4404;e=a+44|0;b=f[e>>2]|0;if(b|0){g=a+48|0;c=f[g>>2]|0;if((c|0)!=(b|0)){do{d=c+-8|0;f[g>>2]=d;c=f[c+-4>>2]|0;if(!c)c=d;else{KK(c);c=f[g>>2]|0}}while((c|0)!=(b|0));b=f[e>>2]|0}QK(b)}f[a>>2]=4264;b=f[a+24>>2]|0;if(!b){QK(a);return}c=a+28|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);QK(a);return}function Ce(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=u;u=u+160|0;n=r+136|0;o=r;p=o+56|0;q=o+4|0;f[o>>2]=292;f[p>>2]=312;bB(o+56|0,q);f[o+128>>2]=0;f[o+132>>2]=-1;f[o>>2]=4304;f[p>>2]=4324;fB(q);f[q>>2]=4340;m=o+36|0;f[m>>2]=0;f[m+4>>2]=0;f[m+8>>2]=0;f[m+12>>2]=0;f[o+52>>2]=16;f[n>>2]=0;f[n+4>>2]=0;f[n+8>>2]=0;ce(q,n);if((b[n+11>>0]|0)<0)QK(f[n>>2]|0);be(n,c,d);l=n+11|0;k=b[l>>0]|0;j=k<<24>>24<0;de(o,j?f[n>>2]|0:n,j?f[n+4>>2]|0:k&255)|0;if((b[l>>0]|0)<0)QK(f[n>>2]|0);if((f[d>>2]|0)>0){e=0;do{de(o,18862,2)|0;e=e+1|0}while((e|0)<(f[d>>2]|0))}g=de(o,19206,13)|0;l=f[c+56>>2]|0;f[n>>2]=0;f[n+4>>2]=0;f[n+8>>2]=0;h=n+11|0;b[h>>0]=4;b[n+4>>0]=0;b[n>>0]=l>>>24;b[n+1>>0]=l>>>16;b[n+2>>0]=l>>>8;b[n+3>>0]=l;g=de(de(g,n,4)|0,30204,1)|0;if((f[d>>2]|0)>0){e=0;do{de(g,18862,2)|0;e=e+1|0}while((e|0)<(f[d>>2]|0))}g=de(g,19220,15)|0;g=de(nB(g,f[c+60>>2]|0)|0,30204,1)|0;if((f[d>>2]|0)>0){e=0;do{de(g,18862,2)|0;e=e+1|0}while((e|0)<(f[d>>2]|0))}de(g,19236,19)|0;if((b[h>>0]|0)<0)QK(f[n>>2]|0);e=f[c+64>>2]|0;d=f[c+68>>2]|0;if((e|0)!=(d|0)){c=n+11|0;i=n+4|0;j=n+1|0;k=n+2|0;l=n+3|0;h=1;while(1){g=f[e>>2]|0;if(!h){b[n>>0]=44;de(o,n,1)|0};f[n>>2]=0;f[n+4>>2]=0;f[n+8>>2]=0;b[c>>0]=4;b[i>>0]=0;b[n>>0]=g>>>24;b[j>>0]=g>>>16;b[k>>0]=g>>>8;b[l>>0]=g;de(o,n,4)|0;if((b[c>>0]|0)<0)QK(f[n>>2]|0);e=e+4|0;if((e|0)==(d|0))break;else h=0}}de(o,30204,1)|0;fe(a,q);f[o>>2]=4304;f[p>>2]=4324;f[q>>2]=4340;if((b[m+11>>0]|0)>=0){Rz(q);NA(o,4280);Mz(p);u=r;return}QK(f[m>>2]|0);Rz(q);NA(o,4280);Mz(p);u=r;return}function De(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0;j=u;u=u+32|0;h=j;i=f[d+12>>2]|0;Zd(d,b[c+36>>0]|0?12:8);Ud(d,f[c+56>>2]|0);Ud(d,f[c+60>>2]|0);e=f[c+64>>2]|0;g=f[c+68>>2]|0;if((e|0)!=(g|0))do{Ud(d,f[e>>2]|0);e=e+4|0}while((e|0)!=(g|0));ze(h,c,d,i);e=h+8|0;if((b[e+11>>0]|0)<0)QK(f[e>>2]|0);d=56816;h=f[d+4>>2]|0;i=a;f[i>>2]=f[d>>2];f[i+4>>2]=h;ZK(a+8|0,56824);u=j;return}function Ee(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=u;u=u+32|0;o=p+12|0;i=p;g=Id(d)|0;f[c+56>>2]=g;g=Id(d)|0;f[c+60>>2]=g;g=c+8|0;e=f[g>>2]|0;g=f[g+4>>2]|0;h=f[c+16>>2]|0;if(!(g>>>0>0|(g|0)==0&e>>>0>(h+8|0)>>>0)){e=OK(48)|0;f[i>>2]=e;f[i+8>>2]=-2147483600;f[i+4>>2]=38;g=e;h=19167;c=g+38|0;do{b[g>>0]=b[h>>0]|0;g=g+1|0;h=h+1|0}while((g|0)<(c|0));b[e+38>>0]=0;Rj(a,2,101,i);if((b[i+11>>0]|0)>=0){u=p;return}QK(f[i>>2]|0);u=p;return}j=wM(e|0,g|0,-8,-1)|0;j=xM(j|0,I|0,h|0,0)|0;j=DM(j|0,I|0,2)|0;k=I;l=d+24|0;a:do if(!((j|0)==0&(k|0)==0)){m=c+68|0;n=c+72|0;e=c+64|0;c=0;i=0;do{if(b[l>>0]|0)break a;g=Id(d)|0;f[o>>2]=g;h=f[m>>2]|0;if(h>>>0<(f[n>>2]|0)>>>0){f[h>>2]=g;f[m>>2]=h+4}else Fe(e,o);c=wM(c|0,i|0,1,0)|0;i=I}while(i>>>0<k>>>0|(i|0)==(k|0)&c>>>0<j>>>0)}while(0);if(b[l>>0]|0){f[o>>2]=0;f[o+4>>2]=0;f[o+8>>2]=0;Rj(a,2,100,o);if((b[o+11>>0]|0)<0)QK(f[o>>2]|0)}else{n=56816;d=f[n+4>>2]|0;o=a;f[o>>2]=f[n>>2];f[o+4>>2]=d;ZK(a+8|0,56824)}u=p;return}function Fe(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0;i=a+4|0;j=f[a>>2]|0;k=(f[i>>2]|0)-j|0;h=k>>2;c=h+1|0;if(c>>>0>1073741823)$I(a);l=a+8|0;g=(f[l>>2]|0)-j|0;d=g>>1;d=g>>2>>>0<536870911?(d>>>0<c>>>0?c:d):1073741823;do if(d)if(d>>>0>1073741823){l=Ra(8)|0;VK(l,44736);f[l>>2]=17660;Va(l|0,4016,428)}else{g=OK(d<<2)|0;break}else g=0;while(0);e=g+(h<<2)|0;f[e>>2]=f[b>>2];c=e+(0-h<<2)|0;if((k|0)>0)GM(c|0,j|0,k|0)|0;f[a>>2]=c;f[i>>2]=e+4;f[l>>2]=g+(d<<2);if(!j)return;QK(j);return}function Ge(a){a=a|0;var b=0,c=0,d=0,e=0,g=0;f[a>>2]=4404;e=a+44|0;b=f[e>>2]|0;if(b|0){g=a+48|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[a>>2]=4264;b=f[a+24>>2]|0;if(!b){QK(a);return}c=a+28|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);QK(a);return}function He(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;k=u;u=u+160|0;g=k+136|0;h=k;i=h+56|0;j=h+4|0;f[h>>2]=292;f[i>>2]=312;bB(h+56|0,j);f[h+128>>2]=0;f[h+132>>2]=-1;f[h>>2]=4304;f[i>>2]=4324;fB(j);f[j>>2]=4340;e=h+36|0;f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;f[e+12>>2]=0;f[h+52>>2]=16;f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;ce(j,g);if((b[g+11>>0]|0)<0)QK(f[g>>2]|0);ve(g,c,d);l=g+11|0;m=b[l>>0]|0;n=m<<24>>24<0;de(h,n?f[g>>2]|0:g,n?f[g+4>>2]|0:m&255)|0;if((b[l>>0]|0)<0)QK(f[g>>2]|0);Uf(g,c,d);n=g+11|0;m=b[n>>0]|0;l=m<<24>>24<0;de(h,l?f[g>>2]|0:g,l?f[g+4>>2]|0:m&255)|0;if((b[n>>0]|0)<0)QK(f[g>>2]|0);fe(a,j);f[h>>2]=4304;f[i>>2]=4324;f[j>>2]=4340;if((b[e+11>>0]|0)>=0){Rz(j);NA(h,4280);Mz(i);u=k;return}QK(f[e>>2]|0);Rz(j);NA(h,4280);Mz(i);u=k;return}function Ie(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0;g=u;u=u+32|0;e=g;Je(e,c,d);e=e+8|0;if((b[e+11>>0]|0)<0)QK(f[e>>2]|0);Ke(a,c,d,-1);u=g;return}function Je(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0;g=u;u=u+16|0;e=g;h=Id(d)|0;b[c+37>>0]=h>>>24;f[c+40>>2]=h&16777215;b[c+36>>0]=1;c=c+16|0;f[c>>2]=(f[c>>2]|0)+4;if(!(b[d+24>>0]|0)){d=56816;e=f[d+4>>2]|0;h=a;f[h>>2]=f[d>>2];f[h+4>>2]=e;ZK(a+8|0,56824);u=g;return}f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;Rj(a,2,100,e);if((b[e+11>>0]|0)>=0){u=g;return}QK(f[e>>2]|0);u=g;return}function Ke(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0;M=u;u=u+208|0;F=M+192|0;G=M+184|0;H=M;I=M+24|0;J=M+168|0;K=d+16|0;n=d+24|0;o=G+4|0;p=c+44|0;q=c+48|0;r=I+64|0;s=I+8|0;t=I+12|0;v=I+4|0;w=I+64|0;x=I+136|0;y=I+140|0;z=I+44|0;A=I+60|0;B=F+11|0;C=I+8|0;D=J+11|0;E=z+11|0;i=c+52|0;j=(e|0)!=-1;k=H+8|0;l=k+11|0;m=a+8|0;c=0;a:while(1){h=K;if((f[h>>2]|0)==0&(f[h+4>>2]|0)==0)break;if(b[n>>0]|0)break;f[G>>2]=0;f[o>>2]=0;Le(H,d,G);do if((f[H>>2]|0)==(f[14204]|0)){g=f[q>>2]|0;h=g;if(g-(f[p>>2]|0)>>3>>>0<=2e4){if(h>>>0<(f[i>>2]|0)>>>0){f[g>>2]=f[G>>2];f[h+4>>2]=f[o>>2];f[G>>2]=0;f[o>>2]=0;f[q>>2]=h+8}else Me(p,G);c=c+1|0;h=(j&(c|0)==(e|0))<<31>>31;break}f[s>>2]=4524;f[I>>2]=188;f[r>>2]=208;f[v>>2]=0;bB(w,t);f[x>>2]=0;f[y>>2]=-1;f[I>>2]=4504;f[r>>2]=4544;f[s>>2]=4524;fB(t);f[t>>2]=4340;f[z>>2]=0;f[z+4>>2]=0;f[z+8>>2]=0;f[z+12>>2]=0;f[A>>2]=24;f[F>>2]=0;f[F+4>>2]=0;f[F+8>>2]=0;ce(t,F);if((b[B>>0]|0)<0)QK(f[F>>2]|0);de(nB(de(C,19273,30)|0,2e4)|0,19304,10)|0;fe(J,t);Rj(a,6,1e3,J);if((b[D>>0]|0)<0)QK(f[J>>2]|0);f[I>>2]=4504;f[r>>2]=4544;f[C>>2]=4524;f[t>>2]=4340;if((b[E>>0]|0)<0)QK(f[z>>2]|0);Rz(t);ZA(I,4556);Mz(r);h=1}else{N=H;g=f[N+4>>2]|0;h=a;f[h>>2]=f[N>>2];f[h+4>>2]=g;f[m>>2]=f[k>>2];f[m+4>>2]=f[k+4>>2];f[m+8>>2]=f[k+8>>2];f[k>>2]=0;f[k+4>>2]=0;f[k+8>>2]=0;h=1}while(0);if((b[l>>0]|0)<0)QK(f[k>>2]|0);g=f[o>>2]|0;if(g|0)KK(g);switch(h&3){case 0:break;case 3:break a;default:{L=28;break a}}}if((L|0)==28){u=M;return}if(b[n>>0]|0){f[F>>2]=0;f[F+4>>2]=0;f[F+8>>2]=0;Rj(a,2,100,F);if((b[F+11>>0]|0)<0)QK(f[F>>2]|0)}else{K=56816;L=f[K+4>>2]|0;N=a;f[N>>2]=f[K>>2];f[N+4>>2]=L;ZK(m,56824)}u=M;return}function Le(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;A=u;u=u+320|0;x=A+216|0;z=A+168|0;y=A+144|0;w=A;t=A+304|0;q=A+292|0;o=A+280|0;p=A+268|0;r=A+256|0;v=A+248|0;f[z>>2]=4264;s=z+8|0;f[z+40>>2]=0;f[s>>2]=0;f[s+4>>2]=0;f[s+8>>2]=0;f[s+12>>2]=0;f[s+16>>2]=0;f[s+20>>2]=0;f[s+24>>2]=0;d[s+28>>1]=0;Te(y,z,c);a:do if(!(f[y>>2]|0)){if(b[c+24>>0]|0){f[x>>2]=0;f[x+4>>2]=0;f[x+8>>2]=0;Rj(a,2,100,x);if((b[x+11>>0]|0)<0)QK(f[x>>2]|0);break}g=f[z+20>>2]|0;b:do if((g|0)<1768714083)if((g|0)<1718909296)if((g|0)<1668246642){if((g|0)<1635135811){switch(g|0){case 1635088451:break;default:{n=133;break b}}g=OK(96)|0;f[g+4>>2]=0;f[g+8>>2]=0;f[g>>2]=5196;m=g+16|0;f[m>>2]=4264;h=g+24|0;f[h>>2]=f[s>>2];f[h+4>>2]=f[s+4>>2];f[h+8>>2]=f[s+8>>2];f[h+12>>2]=f[s+12>>2];h=g+40|0;f[h>>2]=0;i=g+44|0;f[i>>2]=0;j=g+48|0;f[j>>2]=0;l=f[z+24>>2]|0;k=(f[z+28>>2]|0)-l|0;do if(k|0)if((k|0)<0)$I(h);else{B=OK(k)|0;f[i>>2]=B;f[h>>2]=B;h=B+k|0;f[j>>2]=h;GM(B|0,l|0,k|0)|0;f[i>>2]=h;break}while(0);k=z+36|0;l=f[k+4>>2]|0;B=g+52|0;f[B>>2]=f[k>>2];f[B+4>>2]=l;f[g+60>>2]=0;f[g+64>>2]=0;f[g+68>>2]=0;f[m>>2]=5224;B=g+72|0;f[B>>2]=0;f[B+4>>2]=0;f[B+8>>2]=0;f[B+12>>2]=0;f[B+16>>2]=0;f[B+20>>2]=0;break}if((g|0)<1668047216){switch(g|0){case 1635135811:break;default:{n=133;break b}}g=OK(96)|0;f[g+4>>2]=0;f[g+8>>2]=0;f[g>>2]=5556;m=g+16|0;f[m>>2]=4264;h=g+24|0;f[h>>2]=f[s>>2];f[h+4>>2]=f[s+4>>2];f[h+8>>2]=f[s+8>>2];f[h+12>>2]=f[s+12>>2];h=g+40|0;f[h>>2]=0;i=g+44|0;f[i>>2]=0;j=g+48|0;f[j>>2]=0;l=f[z+24>>2]|0;k=(f[z+28>>2]|0)-l|0;do if(k|0)if((k|0)<0)$I(h);else{C=OK(k)|0;f[i>>2]=C;f[h>>2]=C;B=C+k|0;f[j>>2]=B;GM(C|0,l|0,k|0)|0;f[i>>2]=B;break}while(0);C=z+36|0;k=f[C+4>>2]|0;j=g+52|0;f[j>>2]=f[C>>2];f[j+4>>2]=k;f[g+60>>2]=0;f[g+64>>2]=0;f[g+68>>2]=0;f[m>>2]=5584;b[g+72>>0]=1;j=g+73|0;k=j+23|0;do{b[j>>0]=0;j=j+1|0}while((j|0)<(k|0));break}else{switch(g|0){case 1668047216:break;default:{n=133;break b}}g=OK(104)|0;f[g+4>>2]=0;f[g+8>>2]=0;f[g>>2]=5376;m=g+16|0;f[m>>2]=4264;h=g+24|0;f[h>>2]=f[s>>2];f[h+4>>2]=f[s+4>>2];f[h+8>>2]=f[s+8>>2];f[h+12>>2]=f[s+12>>2];h=g+40|0;f[h>>2]=0;i=g+44|0;f[i>>2]=0;j=g+48|0;f[j>>2]=0;l=f[z+24>>2]|0;k=(f[z+28>>2]|0)-l|0;do if(k|0)if((k|0)<0)$I(h);else{B=OK(k)|0;f[i>>2]=B;f[h>>2]=B;C=B+k|0;f[j>>2]=C;GM(B|0,l|0,k|0)|0;f[i>>2]=C;break}while(0);l=z+36|0;B=f[l+4>>2]|0;C=g+52|0;f[C>>2]=f[l>>2];f[C+4>>2]=B;f[g+60>>2]=0;f[g+64>>2]=0;f[g+68>>2]=0;f[m>>2]=5404;f[g+72>>2]=0;f[g+76>>2]=1;f[g+80>>2]=0;f[g+84>>2]=1;f[g+88>>2]=0;f[g+92>>2]=1;f[g+96>>2]=0;f[g+100>>2]=1;break}}else{if((g|0)<1684631142){switch(g|0){case 1668246642:break;default:{n=133;break b}}g=OK(80)|0;f[g+4>>2]=0;f[g+8>>2]=0;f[g>>2]=5916;m=g+16|0;f[m>>2]=4264;h=g+24|0;f[h>>2]=f[s>>2];f[h+4>>2]=f[s+4>>2];f[h+8>>2]=f[s+8>>2];f[h+12>>2]=f[s+12>>2];h=g+40|0;f[h>>2]=0;i=g+44|0;f[i>>2]=0;j=g+48|0;f[j>>2]=0;l=f[z+24>>2]|0;k=(f[z+28>>2]|0)-l|0;do if(k|0)if((k|0)<0)$I(h);else{B=OK(k)|0;f[i>>2]=B;f[h>>2]=B;C=B+k|0;f[j>>2]=C;GM(B|0,l|0,k|0)|0;f[i>>2]=C;break}while(0);l=z+36|0;B=f[l+4>>2]|0;C=g+52|0;f[C>>2]=f[l>>2];f[C+4>>2]=B;f[g+60>>2]=0;f[g+64>>2]=0;f[g+68>>2]=0;f[m>>2]=5944;f[g+72>>2]=0;f[g+76>>2]=0;break}if((g|0)<1685218662){switch(g|0){case 1684631142:break;default:{n=133;break b}}g=OK(72)|0;f[g+4>>2]=0;f[g+8>>2]=0;f[g>>2]=5736;m=g+16|0;f[m>>2]=4264;h=g+24|0;f[h>>2]=f[s>>2];f[h+4>>2]=f[s+4>>2];f[h+8>>2]=f[s+8>>2];f[h+12>>2]=f[s+12>>2];h=g+40|0;f[h>>2]=0;i=g+44|0;f[i>>2]=0;j=g+48|0;f[j>>2]=0;l=f[z+24>>2]|0;k=(f[z+28>>2]|0)-l|0;do if(k|0)if((k|0)<0)$I(h);else{B=OK(k)|0;f[i>>2]=B;f[h>>2]=B;C=B+k|0;f[j>>2]=C;GM(B|0,l|0,k|0)|0;f[i>>2]=C;break}while(0);l=z+36|0;B=f[l+4>>2]|0;C=g+52|0;f[C>>2]=f[l>>2];f[C+4>>2]=B;f[g+60>>2]=0;f[g+64>>2]=0;f[g+68>>2]=0;f[m>>2]=5764;break}else{switch(g|0){case 1685218662:break;default:{n=133;break b}}g=OK(72)|0;f[g+4>>2]=0;f[g+8>>2]=0;f[g>>2]=5796;m=g+16|0;f[m>>2]=4264;h=g+24|0;f[h>>2]=f[s>>2];f[h+4>>2]=f[s+4>>2];f[h+8>>2]=f[s+8>>2];f[h+12>>2]=f[s+12>>2];h=g+40|0;f[h>>2]=0;i=g+44|0;f[i>>2]=0;j=g+48|0;f[j>>2]=0;l=f[z+24>>2]|0;k=(f[z+28>>2]|0)-l|0;do if(k|0)if((k|0)<0)$I(h);else{B=OK(k)|0;f[i>>2]=B;f[h>>2]=B;C=B+k|0;f[j>>2]=C;GM(B|0,l|0,k|0)|0;f[i>>2]=C;break}while(0);l=z+36|0;B=f[l+4>>2]|0;C=g+52|0;f[C>>2]=f[l>>2];f[C+4>>2]=B;f[g+60>>2]=0;f[g+64>>2]=0;f[g+68>>2]=0;f[m>>2]=5824;break}}else if((g|0)<1752589123){if((g|0)<1735553132){switch(g|0){case 1718909296:break;default:{n=133;break b}}g=OK(96)|0;f[g+4>>2]=0;f[g+8>>2]=0;f[g>>2]=4600;m=g+16|0;f[m>>2]=4264;h=g+24|0;f[h>>2]=f[s>>2];f[h+4>>2]=f[s+4>>2];f[h+8>>2]=f[s+8>>2];f[h+12>>2]=f[s+12>>2];h=g+40|0;f[h>>2]=0;i=g+44|0;f[i>>2]=0;j=g+48|0;f[j>>2]=0;l=f[z+24>>2]|0;k=(f[z+28>>2]|0)-l|0;do if(k|0)if((k|0)<0)$I(h);else{B=OK(k)|0;f[i>>2]=B;f[h>>2]=B;C=B+k|0;f[j>>2]=C;GM(B|0,l|0,k|0)|0;f[i>>2]=C;break}while(0);l=z+36|0;B=f[l+4>>2]|0;C=g+52|0;f[C>>2]=f[l>>2];f[C+4>>2]=B;f[g+60>>2]=0;f[g+64>>2]=0;f[g+68>>2]=0;f[m>>2]=4436;C=g+72|0;f[C>>2]=0;f[C+4>>2]=0;f[C+8>>2]=0;f[C+12>>2]=0;f[C+16>>2]=0;break}if((g|0)<1751411826){switch(g|0){case 1735553132:break;default:{n=133;break b}}g=OK(88)|0;f[g+4>>2]=0;f[g+8>>2]=0;f[g>>2]=5676;m=g+16|0;f[m>>2]=4264;h=g+24|0;f[h>>2]=f[s>>2];f[h+4>>2]=f[s+4>>2];f[h+8>>2]=f[s+8>>2];f[h+12>>2]=f[s+12>>2];h=g+40|0;f[h>>2]=0;i=g+44|0;f[i>>2]=0;j=g+48|0;f[j>>2]=0;l=f[z+24>>2]|0;k=(f[z+28>>2]|0)-l|0;do if(k|0)if((k|0)<0)$I(h);else{B=OK(k)|0;f[i>>2]=B;f[h>>2]=B;C=B+k|0;f[j>>2]=C;GM(B|0,l|0,k|0)|0;f[i>>2]=C;break}while(0);l=z+36|0;B=f[l+4>>2]|0;C=g+52|0;f[C>>2]=f[l>>2];f[C+4>>2]=B;f[g+60>>2]=0;f[g+64>>2]=0;f[g+68>>2]=0;f[m>>2]=5704;f[g+72>>2]=0;f[g+76>>2]=0;f[g+80>>2]=0;break}else{switch(g|0){case 1751411826:break;default:{n=133;break b}}g=OK(104)|0;f[g+4>>2]=0;f[g+8>>2]=0;f[g>>2]=4656;m=g+16|0;f[m>>2]=4264;h=g+24|0;f[h>>2]=f[s>>2];f[h+4>>2]=f[s+4>>2];f[h+8>>2]=f[s+8>>2];f[h+12>>2]=f[s+12>>2];h=g+40|0;f[h>>2]=0;i=g+44|0;f[i>>2]=0;j=g+48|0;f[j>>2]=0;l=f[z+24>>2]|0;k=(f[z+28>>2]|0)-l|0;do if(k|0)if((k|0)<0)$I(h);else{B=OK(k)|0;f[i>>2]=B;f[h>>2]=B;C=B+k|0;f[j>>2]=C;GM(B|0,l|0,k|0)|0;f[i>>2]=C;break}while(0);l=z+36|0;B=f[l+4>>2]|0;C=g+52|0;f[C>>2]=f[l>>2];f[C+4>>2]=B;f[g+60>>2]=0;f[g+64>>2]=0;f[g+68>>2]=0;f[m>>2]=4684;f[g+72>>2]=0;f[g+76>>2]=1885954932;C=g+80|0;f[C>>2]=0;f[C+4>>2]=0;f[C+8>>2]=0;f[C+12>>2]=0;f[C+16>>2]=0;f[C+20>>2]=0;break}}else{if((g|0)<1768186228){switch(g|0){case 1752589123:break;default:{n=133;break b}}g=OK(120)|0;f[g+4>>2]=0;f[g+8>>2]=0;f[g>>2]=5496;m=g+16|0;f[m>>2]=4264;h=g+24|0;f[h>>2]=f[s>>2];f[h+4>>2]=f[s+4>>2];f[h+8>>2]=f[s+8>>2];f[h+12>>2]=f[s+12>>2];h=g+40|0;f[h>>2]=0;i=g+44|0;f[i>>2]=0;j=g+48|0;f[j>>2]=0;l=f[z+24>>2]|0;k=(f[z+28>>2]|0)-l|0;do if(k|0)if((k|0)<0)$I(h);else{B=OK(k)|0;f[i>>2]=B;f[h>>2]=B;C=B+k|0;f[j>>2]=C;GM(B|0,l|0,k|0)|0;f[i>>2]=C;break}while(0);l=z+36|0;B=f[l+4>>2]|0;C=g+52|0;f[C>>2]=f[l>>2];f[C+4>>2]=B;f[g+60>>2]=0;f[g+64>>2]=0;f[g+68>>2]=0;f[m>>2]=5524;f[g+80>>2]=0;f[g+84>>2]=0;b[g+104>>0]=4;f[g+108>>2]=0;f[g+112>>2]=0;f[g+116>>2]=0;break}if((g|0)<1768517222){switch(g|0){case 1768186228:break;default:{n=133;break b}}g=OK(104)|0;f[g+4>>2]=0;f[g+8>>2]=0;f[g>>2]=5616;m=g+16|0;f[m>>2]=4264;h=g+24|0;f[h>>2]=f[s>>2];f[h+4>>2]=f[s+4>>2];f[h+8>>2]=f[s+8>>2];f[h+12>>2]=f[s+12>>2];h=g+40|0;f[h>>2]=0;i=g+44|0;f[i>>2]=0;j=g+48|0;f[j>>2]=0;l=f[z+24>>2]|0;k=(f[z+28>>2]|0)-l|0;do if(k|0)if((k|0)<0)$I(h);else{B=OK(k)|0;f[i>>2]=B;f[h>>2]=B;C=B+k|0;f[j>>2]=C;GM(B|0,l|0,k|0)|0;f[i>>2]=C;break}while(0);l=z+36|0;B=f[l+4>>2]|0;C=g+52|0;f[C>>2]=f[l>>2];f[C+4>>2]=B;f[g+60>>2]=0;f[g+64>>2]=0;f[g+68>>2]=0;f[m>>2]=5644;C=g+72|0;f[C>>2]=0;f[C+4>>2]=0;f[C+8>>2]=0;f[C+12>>2]=0;f[C+16>>2]=0;f[C+20>>2]=0;f[C+24>>2]=0;break}else{switch(g|0){case 1768517222:break;default:{n=133;break b}}g=OK(72)|0;f[g+4>>2]=0;f[g+8>>2]=0;f[g>>2]=4836;m=g+16|0;f[m>>2]=4264;h=g+24|0;f[h>>2]=f[s>>2];f[h+4>>2]=f[s+4>>2];f[h+8>>2]=f[s+8>>2];f[h+12>>2]=f[s+12>>2];h=g+40|0;f[h>>2]=0;i=g+44|0;f[i>>2]=0;j=g+48|0;f[j>>2]=0;l=f[z+24>>2]|0;k=(f[z+28>>2]|0)-l|0;do if(k|0)if((k|0)<0)$I(h);else{B=OK(k)|0;f[i>>2]=B;f[h>>2]=B;C=B+k|0;f[j>>2]=C;GM(B|0,l|0,k|0)|0;f[i>>2]=C;break}while(0);l=z+36|0;B=f[l+4>>2]|0;C=g+52|0;f[C>>2]=f[l>>2];f[C+4>>2]=B;f[g+60>>2]=0;f[g+64>>2]=0;f[g+68>>2]=0;f[m>>2]=4864;break}}else{if((g|0)<1769104742){if((g|0)>=1768973167){if((g|0)<1768975713){switch(g|0){case 1768973167:break;default:{n=133;break b}}g=OK(72)|0;f[g+4>>2]=0;f[g+8>>2]=0;f[g>>2]=5016;m=g+16|0;f[m>>2]=4264;h=g+24|0;f[h>>2]=f[s>>2];f[h+4>>2]=f[s+4>>2];f[h+8>>2]=f[s+8>>2];f[h+12>>2]=f[s+12>>2];h=g+40|0;f[h>>2]=0;i=g+44|0;f[i>>2]=0;j=g+48|0;f[j>>2]=0;l=f[z+24>>2]|0;k=(f[z+28>>2]|0)-l|0;do if(k|0)if((k|0)<0)$I(h);else{B=OK(k)|0;f[i>>2]=B;f[h>>2]=B;C=B+k|0;f[j>>2]=C;GM(B|0,l|0,k|0)|0;f[i>>2]=C;break}while(0);l=z+36|0;B=f[l+4>>2]|0;C=g+52|0;f[C>>2]=f[l>>2];f[C+4>>2]=B;f[g+60>>2]=0;f[g+64>>2]=0;f[g+68>>2]=0;f[m>>2]=5044;break}switch(g|0){case 1768977008:{g=OK(72)|0;f[g+4>>2]=0;f[g+8>>2]=0;f[g>>2]=4956;m=g+16|0;f[m>>2]=4264;h=g+24|0;f[h>>2]=f[s>>2];f[h+4>>2]=f[s+4>>2];f[h+8>>2]=f[s+8>>2];f[h+12>>2]=f[s+12>>2];h=g+40|0;f[h>>2]=0;i=g+44|0;f[i>>2]=0;j=g+48|0;f[j>>2]=0;l=f[z+24>>2]|0;k=(f[z+28>>2]|0)-l|0;do if(k|0)if((k|0)<0)$I(h);else{B=OK(k)|0;f[i>>2]=B;f[h>>2]=B;C=B+k|0;f[j>>2]=C;GM(B|0,l|0,k|0)|0;f[i>>2]=C;break}while(0);l=z+36|0;B=f[l+4>>2]|0;C=g+52|0;f[C>>2]=f[l>>2];f[C+4>>2]=B;f[g+60>>2]=0;f[g+64>>2]=0;f[g+68>>2]=0;f[m>>2]=4984;break b}case 1768975713:{g=OK(88)|0;f[g+4>>2]=0;f[g+8>>2]=0;f[g>>2]=5076;m=g+16|0;f[m>>2]=4264;h=g+24|0;f[h>>2]=f[s>>2];f[h+4>>2]=f[s+4>>2];f[h+8>>2]=f[s+8>>2];f[h+12>>2]=f[s+12>>2];h=g+40|0;f[h>>2]=0;i=g+44|0;f[i>>2]=0;j=g+48|0;f[j>>2]=0;l=f[z+24>>2]|0;k=(f[z+28>>2]|0)-l|0;do if(k|0)if((k|0)<0)$I(h);else{B=OK(k)|0;f[i>>2]=B;f[h>>2]=B;C=B+k|0;f[j>>2]=C;GM(B|0,l|0,k|0)|0;f[i>>2]=C;break}while(0);l=z+36|0;B=f[l+4>>2]|0;C=g+52|0;f[C>>2]=f[l>>2];f[C+4>>2]=B;f[g+60>>2]=0;f[g+64>>2]=0;f[g+68>>2]=0;f[m>>2]=5104;f[g+72>>2]=0;f[g+76>>2]=0;f[g+80>>2]=0;break b}default:{n=133;break b}}}if((g|0)<1768778098){switch(g|0){case 1768714083:break;default:{n=133;break b}}g=OK(104)|0;f[g+4>>2]=0;f[g+8>>2]=0;f[g>>2]=4776;m=g+16|0;f[m>>2]=4264;h=g+24|0;f[h>>2]=f[s>>2];f[h+4>>2]=f[s+4>>2];f[h+8>>2]=f[s+8>>2];f[h+12>>2]=f[s+12>>2];h=g+40|0;f[h>>2]=0;i=g+44|0;f[i>>2]=0;j=g+48|0;f[j>>2]=0;l=f[z+24>>2]|0;k=(f[z+28>>2]|0)-l|0;do if(k|0)if((k|0)<0)$I(h);else{B=OK(k)|0;f[i>>2]=B;f[h>>2]=B;C=B+k|0;f[j>>2]=C;GM(B|0,l|0,k|0)|0;f[i>>2]=C;break}while(0);l=z+36|0;B=f[l+4>>2]|0;C=g+52|0;f[C>>2]=f[l>>2];f[C+4>>2]=B;f[g+60>>2]=0;f[g+64>>2]=0;f[g+68>>2]=0;f[m>>2]=4804;C=g+72|0;f[g+96>>2]=0;f[C>>2]=0;f[C+4>>2]=0;f[C+8>>2]=0;f[C+12>>2]=0;f[C+16>>2]=0;b[C+20>>0]=0;break}if((g|0)<1768842853){switch(g|0){case 1768778098:break;default:{n=133;break b}}g=OK(80)|0;f[g+4>>2]=0;f[g+8>>2]=0;f[g>>2]=5316;m=g+16|0;f[m>>2]=4264;h=g+24|0;f[h>>2]=f[s>>2];f[h+4>>2]=f[s+4>>2];f[h+8>>2]=f[s+8>>2];f[h+12>>2]=f[s+12>>2];h=g+40|0;f[h>>2]=0;i=g+44|0;f[i>>2]=0;j=g+48|0;f[j>>2]=0;l=f[z+24>>2]|0;k=(f[z+28>>2]|0)-l|0;do if(k|0)if((k|0)<0)$I(h);else{B=OK(k)|0;f[i>>2]=B;f[h>>2]=B;C=B+k|0;f[j>>2]=C;GM(B|0,l|0,k|0)|0;f[i>>2]=C;break}while(0);l=z+36|0;B=f[l+4>>2]|0;C=g+52|0;f[C>>2]=f[l>>2];f[C+4>>2]=B;f[g+60>>2]=0;f[g+64>>2]=0;f[g+68>>2]=0;f[m>>2]=5344;b[g+72>>0]=0;break}else{switch(g|0){case 1768842853:break;default:{n=133;break b}}g=OK(144)|0;f[g+4>>2]=0;f[g+8>>2]=0;f[g>>2]=4896;m=g+16|0;f[m>>2]=4264;h=g+24|0;f[h>>2]=f[s>>2];f[h+4>>2]=f[s+4>>2];f[h+8>>2]=f[s+8>>2];f[h+12>>2]=f[s+12>>2];h=g+40|0;f[h>>2]=0;i=g+44|0;f[i>>2]=0;j=g+48|0;f[j>>2]=0;l=f[z+24>>2]|0;k=(f[z+28>>2]|0)-l|0;do if(k|0)if((k|0)<0)$I(h);else{B=OK(k)|0;f[i>>2]=B;f[h>>2]=B;C=B+k|0;f[j>>2]=C;GM(B|0,l|0,k|0)|0;f[i>>2]=C;break}while(0);k=z+36|0;j=f[k+4>>2]|0;h=g+52|0;f[h>>2]=f[k>>2];f[h+4>>2]=j;f[g+60>>2]=0;f[g+64>>2]=0;f[g+68>>2]=0;f[m>>2]=4924;f[g+72>>2]=0;d[g+76>>1]=0;h=g+80|0;j=h;k=j+60|0;do{f[j>>2]=0;j=j+4|0}while((j|0)<(k|0));b[h+60>>0]=0;break}}if((g|0)<1835365473){if((g|0)<1769107316){switch(g|0){case 1769104742:break;default:{n=133;break b}}g=OK(88)|0;f[g+4>>2]=0;f[g+8>>2]=0;f[g>>2]=5436;m=g+16|0;f[m>>2]=4264;h=g+24|0;f[h>>2]=f[s>>2];f[h+4>>2]=f[s+4>>2];f[h+8>>2]=f[s+8>>2];f[h+12>>2]=f[s+12>>2];h=g+40|0;f[h>>2]=0;i=g+44|0;f[i>>2]=0;j=g+48|0;f[j>>2]=0;l=f[z+24>>2]|0;k=(f[z+28>>2]|0)-l|0;do if(k|0)if((k|0)<0)$I(h);else{B=OK(k)|0;f[i>>2]=B;f[h>>2]=B;C=B+k|0;f[j>>2]=C;GM(B|0,l|0,k|0)|0;f[i>>2]=C;break}while(0);l=z+36|0;B=f[l+4>>2]|0;C=g+52|0;f[C>>2]=f[l>>2];f[C+4>>2]=B;f[g+60>>2]=0;f[g+64>>2]=0;f[g+68>>2]=0;f[m>>2]=5464;f[g+72>>2]=0;f[g+76>>2]=0;f[g+80>>2]=0;break}if((g|0)<1769173093){switch(g|0){case 1769107316:break;default:{n=133;break b}}g=OK(80)|0;f[g+4>>2]=0;f[g+8>>2]=0;f[g>>2]=5256;m=g+16|0;f[m>>2]=4264;h=g+24|0;f[h>>2]=f[s>>2];f[h+4>>2]=f[s+4>>2];f[h+8>>2]=f[s+8>>2];f[h+12>>2]=f[s+12>>2];h=g+40|0;f[h>>2]=0;i=g+44|0;f[i>>2]=0;j=g+48|0;f[j>>2]=0;l=f[z+24>>2]|0;k=(f[z+28>>2]|0)-l|0;do if(k|0)if((k|0)<0)$I(h);else{B=OK(k)|0;f[i>>2]=B;f[h>>2]=B;C=B+k|0;f[j>>2]=C;GM(B|0,l|0,k|0)|0;f[i>>2]=C;break}while(0);l=z+36|0;B=f[l+4>>2]|0;C=g+52|0;f[C>>2]=f[l>>2];f[C+4>>2]=B;f[g+60>>2]=0;f[g+64>>2]=0;f[g+68>>2]=0;f[m>>2]=5284;f[g+72>>2]=0;break}else{switch(g|0){case 1769173093:break;default:{n=133;break b}}g=OK(80)|0;f[g+4>>2]=0;f[g+8>>2]=0;f[g>>2]=5136;m=g+16|0;f[m>>2]=4264;h=g+24|0;f[h>>2]=f[s>>2];f[h+4>>2]=f[s+4>>2];f[h+8>>2]=f[s+8>>2];f[h+12>>2]=f[s+12>>2];h=g+40|0;f[h>>2]=0;i=g+44|0;f[i>>2]=0;j=g+48|0;f[j>>2]=0;l=f[z+24>>2]|0;k=(f[z+28>>2]|0)-l|0;do if(k|0)if((k|0)<0)$I(h);else{B=OK(k)|0;f[i>>2]=B;f[h>>2]=B;C=B+k|0;f[j>>2]=C;GM(B|0,l|0,k|0)|0;f[i>>2]=C;break}while(0);l=z+36|0;B=f[l+4>>2]|0;C=g+52|0;f[C>>2]=f[l>>2];f[C+4>>2]=B;f[g+60>>2]=0;f[g+64>>2]=0;f[g+68>>2]=0;f[m>>2]=5164;f[g+72>>2]=0;f[g+76>>2]=0;break}}if((g|0)<1885960297)if((g|0)<1885959277){switch(g|0){case 1835365473:break;default:{n=133;break b}}g=OK(72)|0;f[g+4>>2]=0;f[g+8>>2]=0;f[g>>2]=4628;m=g+16|0;f[m>>2]=4264;h=g+24|0;f[h>>2]=f[s>>2];f[h+4>>2]=f[s+4>>2];f[h+8>>2]=f[s+8>>2];f[h+12>>2]=f[s+12>>2];h=g+40|0;f[h>>2]=0;i=g+44|0;f[i>>2]=0;j=g+48|0;f[j>>2]=0;l=f[z+24>>2]|0;k=(f[z+28>>2]|0)-l|0;do if(k|0)if((k|0)<0)$I(h);else{B=OK(k)|0;f[i>>2]=B;f[h>>2]=B;C=B+k|0;f[j>>2]=C;GM(B|0,l|0,k|0)|0;f[i>>2]=C;break}while(0);l=z+36|0;B=f[l+4>>2]|0;C=g+52|0;f[C>>2]=f[l>>2];f[C+4>>2]=B;f[g+60>>2]=0;f[g+64>>2]=0;f[g+68>>2]=0;f[m>>2]=4468;break}else{switch(g|0){case 1885959277:break;default:{n=133;break b}}g=OK(80)|0;f[g+4>>2]=0;f[g+8>>2]=0;f[g>>2]=4716;m=g+16|0;f[m>>2]=4264;h=g+24|0;f[h>>2]=f[s>>2];f[h+4>>2]=f[s+4>>2];f[h+8>>2]=f[s+8>>2];f[h+12>>2]=f[s+12>>2];h=g+40|0;f[h>>2]=0;i=g+44|0;f[i>>2]=0;j=g+48|0;f[j>>2]=0;l=f[z+24>>2]|0;k=(f[z+28>>2]|0)-l|0;do if(k|0)if((k|0)<0)$I(h);else{B=OK(k)|0;f[i>>2]=B;f[h>>2]=B;C=B+k|0;f[j>>2]=C;GM(B|0,l|0,k|0)|0;f[i>>2]=C;break}while(0);l=z+36|0;B=f[l+4>>2]|0;C=g+52|0;f[C>>2]=f[l>>2];f[C+4>>2]=B;f[g+60>>2]=0;f[g+64>>2]=0;f[g+68>>2]=0;f[m>>2]=4744;f[g+72>>2]=0;break}else if((g|0)<1970433056){switch(g|0){case 1885960297:break;default:{n=133;break b}}g=OK(88)|0;f[g+4>>2]=0;f[g+8>>2]=0;f[g>>2]=5976;m=g+16|0;f[m>>2]=4264;h=g+24|0;f[h>>2]=f[s>>2];f[h+4>>2]=f[s+4>>2];f[h+8>>2]=f[s+8>>2];f[h+12>>2]=f[s+12>>2];h=g+40|0;f[h>>2]=0;i=g+44|0;f[i>>2]=0;j=g+48|0;f[j>>2]=0;l=f[z+24>>2]|0;k=(f[z+28>>2]|0)-l|0;do if(k|0)if((k|0)<0)$I(h);else{B=OK(k)|0;f[i>>2]=B;f[h>>2]=B;C=B+k|0;f[j>>2]=C;GM(B|0,l|0,k|0)|0;f[i>>2]=C;break}while(0);l=z+36|0;B=f[l+4>>2]|0;C=g+52|0;f[C>>2]=f[l>>2];f[C+4>>2]=B;f[g+60>>2]=0;f[g+64>>2]=0;f[g+68>>2]=0;f[m>>2]=6004;f[g+72>>2]=0;f[g+76>>2]=0;f[g+80>>2]=0;break}else{switch(g|0){case 1970433056:break;default:{n=133;break b}}g=OK(88)|0;f[g+4>>2]=0;f[g+8>>2]=0;f[g>>2]=5856;m=g+16|0;f[m>>2]=4264;h=g+24|0;f[h>>2]=f[s>>2];f[h+4>>2]=f[s+4>>2];f[h+8>>2]=f[s+8>>2];f[h+12>>2]=f[s+12>>2];h=g+40|0;f[h>>2]=0;i=g+44|0;f[i>>2]=0;j=g+48|0;f[j>>2]=0;l=f[z+24>>2]|0;k=(f[z+28>>2]|0)-l|0;do if(k|0)if((k|0)<0)$I(h);else{B=OK(k)|0;f[i>>2]=B;f[h>>2]=B;C=B+k|0;f[j>>2]=C;GM(B|0,l|0,k|0)|0;f[i>>2]=C;break}while(0);l=z+36|0;B=f[l+4>>2]|0;C=g+52|0;f[C>>2]=f[l>>2];f[C+4>>2]=B;f[g+60>>2]=0;f[g+64>>2]=0;f[g+68>>2]=0;f[m>>2]=5884;C=g+72|0;f[C>>2]=0;f[C+4>>2]=0;f[C+8>>2]=0;break}}while(0);if((n|0)==133){g=OK(72)|0;f[g+4>>2]=0;f[g+8>>2]=0;f[g>>2]=6036;m=g+16|0;f[m>>2]=4264;h=g+24|0;f[h>>2]=f[s>>2];f[h+4>>2]=f[s+4>>2];f[h+8>>2]=f[s+8>>2];f[h+12>>2]=f[s+12>>2];h=g+40|0;f[h>>2]=0;i=g+44|0;f[i>>2]=0;j=g+48|0;f[j>>2]=0;l=f[z+24>>2]|0;k=(f[z+28>>2]|0)-l|0;do if(k|0)if((k|0)<0)$I(h);else{B=OK(k)|0;f[i>>2]=B;f[h>>2]=B;C=B+k|0;f[j>>2]=C;GM(B|0,l|0,k|0)|0;f[i>>2]=C;break}while(0);n=z+36|0;B=f[n+4>>2]|0;C=g+52|0;f[C>>2]=f[n>>2];f[C+4>>2]=B;f[m>>2]=4404;f[g+60>>2]=0;f[g+64>>2]=0;f[g+68>>2]=0}n=m;i=s;h=f[i>>2]|0;i=f[i+4>>2]|0;l=z+16|0;j=f[l>>2]|0;do if(!(i>>>0<0|(i|0)==0&h>>>0<j>>>0)){if((f[c+12>>2]|0)>20){f[q>>2]=0;f[q+4>>2]=0;f[q+8>>2]=0;h=OK(64)|0;f[q>>2]=h;f[q+8>>2]=-2147483584;f[q+4>>2]=61;j=h;i=19438;k=j+61|0;do{b[j>>0]=b[i>>0]|0;j=j+1|0;i=i+1|0}while((j|0)<(k|0));b[h+61>>0]=0;Rj(a,6,1e3,q);if((b[q+11>>0]|0)>=0)break;QK(f[q>>2]|0);break}C=xM(h|0,i|0,j|0,0)|0;if(Ld(c,C,I)|0){f[o>>2]=0;f[o+4>>2]=0;f[o+8>>2]=0;Rj(a,2,100,o);if((b[o+11>>0]|0)>=0)break;QK(f[o>>2]|0);break}i=s;h=f[i>>2]|0;i=f[i+4>>2]|0;if((i|0)<0){f[p>>2]=0;f[p+4>>2]=0;f[p+8>>2]=0;Rj(a,2,101,p);if((b[p+11>>0]|0)>=0)break;QK(f[p>>2]|0);break}j=xM(h|0,i|0,f[l>>2]|0,0)|0;k=I;C=c+16|0;B=f[C+4>>2]|0;if((B|0)<(k|0)|((B|0)==(k|0)?(f[C>>2]|0)>>>0<j>>>0:0)){f[r>>2]=0;f[r+4>>2]=0;f[r+8>>2]=0;Rj(a,2,101,r);if((b[r+11>>0]|0)>=0)break;QK(f[r>>2]|0);break}f[v>>2]=f[c>>2];h=v+4|0;i=f[c+4>>2]|0;f[h>>2]=i;if(i|0)IK(i);Dd(x,v,j,k,c);h=f[h>>2]|0;if(h|0)KK(h);fd[f[(f[m>>2]|0)+20>>2]&127](w,m,x);i=w;h=f[i+4>>2]|0;l=y;f[l>>2]=f[i>>2];f[l+4>>2]=h;l=y+8|0;h=w+8|0;i=l+11|0;if((b[i>>0]|0)<0){b[f[l>>2]>>0]=0;f[y+12>>2]=0}else{b[l>>0]=0;b[i>>0]=0}dL(l,0);f[l>>2]=f[h>>2];f[l+4>>2]=f[h+4>>2];f[l+8>>2]=f[h+8>>2];if((f[y>>2]|0)==(f[14204]|0)){f[e>>2]=n;C=e+4|0;h=f[C>>2]|0;f[C>>2]=g;if(!h)g=0;else{KK(h);g=0}}k=x+16|0;h=k;i=f[h>>2]|0;h=f[h+4>>2]|0;if((h|0)>0|(h|0)==0&i>>>0>0){j=f[x+8>>2]|0;if(j){Md(j,i,h);h=k;i=f[h>>2]|0;h=f[h+4>>2]|0}B=f[x>>2]|0;C=f[B>>2]|0;w=f[C+20>>2]|0;C=Uc[f[C+8>>2]&127](B)|0;C=wM(C|0,I|0,i|0,h|0)|0;Wc[w&63](B,C,I)|0;C=k;f[C>>2]=0;f[C+4>>2]=0}B=y;C=f[B+4>>2]|0;h=a;f[h>>2]=f[B>>2];f[h+4>>2]=C;h=a+8|0;f[h>>2]=f[l>>2];f[h+4>>2]=f[l+4>>2];f[h+8>>2]=f[l+8>>2];f[l>>2]=0;f[l+4>>2]=0;f[l+8>>2]=0;h=f[x+4>>2]|0;if(h|0)KK(h);if(!g)break a}else{i=w+64|0;k=w+8|0;f[k>>2]=4524;j=w+12|0;f[w>>2]=188;f[i>>2]=208;f[w+4>>2]=0;bB(w+64|0,j);f[w+136>>2]=0;f[w+140>>2]=-1;f[w>>2]=4504;f[i>>2]=4544;f[k>>2]=4524;fB(j);f[j>>2]=4340;k=w+44|0;f[k>>2]=0;f[k+4>>2]=0;f[k+8>>2]=0;f[k+12>>2]=0;f[w+60>>2]=24;f[x>>2]=0;f[x+4>>2]=0;f[x+8>>2]=0;ce(j,x);if((b[x+11>>0]|0)<0)QK(f[x>>2]|0);h=w+8|0;B=de(h,19384,10)|0;C=s;C=de(oB(B,f[C>>2]|0,f[C+4>>2]|0)|0,19395,34)|0;de(nB(C,f[l>>2]|0)|0,19430,7)|0;fe(t,j);Rj(a,2,101,t);if((b[t+11>>0]|0)<0)QK(f[t>>2]|0);f[w>>2]=4504;f[i>>2]=4544;f[h>>2]=4524;f[j>>2]=4340;if((b[k+11>>0]|0)<0)QK(f[k>>2]|0);Rz(j);ZA(w,4556);Mz(i)}while(0);KK(g)}else{x=y;C=f[x+4>>2]|0;B=a;f[B>>2]=f[x>>2];f[B+4>>2]=C;B=a+8|0;C=y+8|0;f[B>>2]=f[C>>2];f[B+4>>2]=f[C+4>>2];f[B+8>>2]=f[C+8>>2];f[C>>2]=0;f[C+4>>2]=0;f[C+8>>2]=0}while(0);g=y+8|0;if((b[g+11>>0]|0)<0)QK(f[g>>2]|0);f[z>>2]=4264;h=f[z+24>>2]|0;if(!h){u=A;return}g=z+28|0;if((f[g>>2]|0)!=(h|0))f[g>>2]=h;QK(h);u=A;return}function Me(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=a+4|0;e=f[n>>2]|0;g=f[a>>2]|0;j=e-g>>3;c=j+1|0;k=g;if(c>>>0>536870911)$I(a);m=a+8|0;l=(f[m>>2]|0)-g|0;h=l>>2;h=l>>3>>>0<268435455?(h>>>0<c>>>0?c:h):536870911;do if(h)if(h>>>0>536870911){n=Ra(8)|0;VK(n,44736);f[n>>2]=17660;Va(n|0,4016,428)}else{i=OK(h<<3)|0;break}else i=0;while(0);d=i+(j<<3)|0;c=d;l=i+(h<<3)|0;f[d>>2]=f[b>>2];h=b+4|0;f[i+(j<<3)+4>>2]=f[h>>2];f[b>>2]=0;f[h>>2]=0;h=d+8|0;if((e|0)!=(k|0)){do{j=e;e=e+-8|0;f[d+-8>>2]=f[e>>2];j=j+-4|0;f[d+-4>>2]=f[j>>2];f[e>>2]=0;f[j>>2]=0;d=c+-8|0;c=d}while((e|0)!=(k|0));g=f[a>>2]|0}f[a>>2]=c;c=f[n>>2]|0;f[n>>2]=h;f[m>>2]=l;e=g;if((c|0)!=(e|0))do{d=f[c+-4>>2]|0;c=c+-8|0;if(d|0)KK(d)}while((c|0)!=(e|0));if(!g)return;QK(g);return}function Ne(a){a=a|0;var c=0,d=0,e=0;f[a>>2]=4504;c=a+64|0;f[c>>2]=4544;f[a+8>>2]=4524;d=a+12|0;f[d>>2]=4340;e=a+44|0;if((b[e+11>>0]|0)<0)QK(f[e>>2]|0);Rz(d);ZA(a,4556);Mz(c);return}function Oe(a){a=a|0;var c=0,d=0,e=0;f[a>>2]=4504;c=a+64|0;f[c>>2]=4544;f[a+8>>2]=4524;d=a+12|0;f[d>>2]=4340;e=a+44|0;if((b[e+11>>0]|0)<0)QK(f[e>>2]|0);Rz(d);ZA(a,4556);Mz(c);QK(a);return}function Pe(a){a=a|0;var c=0,d=0,e=0;a=a+-8|0;f[a>>2]=4504;c=a+64|0;f[c>>2]=4544;f[a+8>>2]=4524;d=a+12|0;f[d>>2]=4340;e=a+44|0;if((b[e+11>>0]|0)<0)QK(f[e>>2]|0);Rz(d);ZA(a,4556);Mz(c);return}function Qe(a){a=a|0;var c=0,d=0,e=0;a=a+-8|0;f[a>>2]=4504;c=a+64|0;f[c>>2]=4544;f[a+8>>2]=4524;d=a+12|0;f[d>>2]=4340;e=a+44|0;if((b[e+11>>0]|0)<0)QK(f[e>>2]|0);Rz(d);ZA(a,4556);Mz(c);QK(a);return}function Re(a){a=a|0;var c=0,d=0,e=0;a=a+(f[(f[a>>2]|0)+-12>>2]|0)|0;f[a>>2]=4504;c=a+64|0;f[c>>2]=4544;f[a+8>>2]=4524;d=a+12|0;f[d>>2]=4340;e=a+44|0;if((b[e+11>>0]|0)<0)QK(f[e>>2]|0);Rz(d);ZA(a,4556);Mz(c);return}function Se(a){a=a|0;var c=0,d=0,e=0;a=a+(f[(f[a>>2]|0)+-12>>2]|0)|0;f[a>>2]=4504;c=a+64|0;f[c>>2]=4544;f[a+8>>2]=4524;d=a+12|0;f[d>>2]=4340;e=a+44|0;if((b[e+11>>0]|0)<0)QK(f[e>>2]|0);Rz(d);ZA(a,4556);Mz(c);QK(a);return}function Te(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;r=u;u=u+208|0;q=r+196|0;e=r+184|0;g=r+24|0;l=r+40|0;m=r+12|0;n=r;if(Ld(d,8,0)|0){f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;Rj(a,2,100,e);if((b[e+11>>0]|0)>=0){u=r;return}QK(f[e>>2]|0);u=r;return}k=Id(d)|0;j=c+8|0;e=j;f[e>>2]=k;f[e+4>>2]=0;e=Id(d)|0;k=c+20|0;f[k>>2]=e;p=c+16|0;f[p>>2]=8;i=j;do if((f[i>>2]|0)==1&(f[i+4>>2]|0)==0){if(Ld(d,8,0)|0){f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;Rj(a,2,100,g);if((b[g+11>>0]|0)>=0){u=r;return}QK(f[g>>2]|0);u=r;return}h=Id(d)|0;g=Id(d)|0;e=j;f[e>>2]=g;f[e+4>>2]=h;f[p>>2]=(f[p>>2]|0)+8;e=l+64|0;h=l+8|0;f[h>>2]=4524;g=l+12|0;f[l>>2]=188;f[e>>2]=208;f[l+4>>2]=0;bB(l+64|0,g);f[l+136>>2]=0;f[l+140>>2]=-1;f[l>>2]=4504;f[e>>2]=4544;f[h>>2]=4524;fB(g);f[g>>2]=4340;h=l+44|0;f[h>>2]=0;f[h+4>>2]=0;f[h+8>>2]=0;f[h+12>>2]=0;f[l+60>>2]=24;f[q>>2]=0;f[q+4>>2]=0;f[q+8>>2]=0;ce(g,q);if((b[q+11>>0]|0)<0)QK(f[q>>2]|0);i=l+8|0;t=de(i,23427,9)|0;s=j;de(oB(t,f[s>>2]|0,f[s+4>>2]|0)|0,23437,24)|0;s=f[j+4>>2]|0;if(!(s>>>0>268435455|(s|0)==268435455&(f[j>>2]|0)>>>0>4294967295)){f[l>>2]=4504;f[e>>2]=4544;f[i>>2]=4524;f[g>>2]=4340;if((b[h+11>>0]|0)<0)QK(f[h>>2]|0);Rz(g);ZA(l,4556);Mz(e);e=f[k>>2]|0;break}fe(m,g);Rj(a,6,1e3,m);if((b[m+11>>0]|0)<0)QK(f[m>>2]|0);f[l>>2]=4504;f[e>>2]=4544;f[i>>2]=4524;f[g>>2]=4340;if((b[h+11>>0]|0)<0)QK(f[h>>2]|0);Rz(g);ZA(l,4556);Mz(e);u=r;return}while(0);if((e|0)==1970628964){if(Ld(d,16,0)|0){f[n>>2]=0;f[n+4>>2]=0;f[n+8>>2]=0;Rj(a,2,100,n);if((b[n+11>>0]|0)>=0){u=r;return}QK(f[n>>2]|0);u=r;return}do if(Fd(d,16,0)|0){j=c+24|0;e=c+28|0;i=f[e>>2]|0;h=f[j>>2]|0;g=i-h|0;if(g>>>0>=16){if((g|0)!=16?(o=h+16|0,(i|0)!=(o|0)):0)f[e>>2]=o}else Td(j,16-g|0);e=f[d>>2]|0;g=f[d+4>>2]|0;if(!g){Wc[f[(f[e>>2]|0)+16>>2]&63](e,f[j>>2]|0,16)|0;break}else{IK(g);Wc[f[(f[e>>2]|0)+16>>2]&63](e,f[j>>2]|0,16)|0;KK(g);break}}while(0);f[p>>2]=(f[p>>2]|0)+16}if(b[d+24>>0]|0){f[q>>2]=0;f[q+4>>2]=0;f[q+8>>2]=0;Rj(a,2,100,q);if((b[q+11>>0]|0)<0)QK(f[q>>2]|0)}else{q=56816;s=f[q+4>>2]|0;t=a;f[t>>2]=f[q>>2];f[t+4>>2]=s;ZK(a+8|0,56824)}u=r;return}function Ue(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;f[a>>2]=6036;h=a+16|0;f[h>>2]=4404;e=a+60|0;b=f[e>>2]|0;if(b|0){g=a+64|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[h>>2]=4264;b=f[a+40>>2]|0;if(!b){zK(a);return}c=a+44|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);return}function Ve(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;f[a>>2]=6036;h=a+16|0;f[h>>2]=4404;e=a+60|0;b=f[e>>2]|0;if(b|0){g=a+64|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[h>>2]=4264;b=f[a+40>>2]|0;if(!b){zK(a);QK(a);return}c=a+44|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);QK(a);return}function We(a){a=a|0;a=a+16|0;dd[f[f[a>>2]>>2]&511](a);return}function Xe(a){a=a|0;QK(a);return}function Ye(a){a=a|0;var b=0,c=0,d=0,e=0,g=0;f[a>>2]=6004;b=f[a+56>>2]|0;if(b|0){c=a+60|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b)}f[a>>2]=4404;g=a+44|0;b=f[g>>2]|0;if(b|0){e=a+48|0;c=f[e>>2]|0;if((c|0)!=(b|0)){do{d=c+-8|0;f[e>>2]=d;c=f[c+-4>>2]|0;if(!c)c=d;else{KK(c);c=f[e>>2]|0}}while((c|0)!=(b|0));b=f[g>>2]|0}QK(b)}f[a>>2]=4264;c=f[a+24>>2]|0;if(!c)return;b=a+28|0;if((f[b>>2]|0)!=(c|0))f[b>>2]=c;QK(c);return}function Ze(a){a=a|0;var b=0,c=0,d=0,e=0,g=0;f[a>>2]=6004;b=f[a+56>>2]|0;if(b|0){c=a+60|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b)}f[a>>2]=4404;g=a+44|0;b=f[g>>2]|0;if(b|0){e=a+48|0;c=f[e>>2]|0;if((c|0)!=(b|0)){do{d=c+-8|0;f[e>>2]=d;c=f[c+-4>>2]|0;if(!c)c=d;else{KK(c);c=f[e>>2]|0}}while((c|0)!=(b|0));b=f[g>>2]|0}QK(b)}f[a>>2]=4264;b=f[a+24>>2]|0;if(!b){QK(a);return}c=a+28|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);QK(a);return}function _e(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;m=u;u=u+160|0;e=m+136|0;j=m;k=j+56|0;l=j+4|0;f[j>>2]=292;f[k>>2]=312;bB(j+56|0,l);f[j+128>>2]=0;f[j+132>>2]=-1;f[j>>2]=4304;f[k>>2]=4324;fB(l);f[l>>2]=4340;i=j+36|0;f[i>>2]=0;f[i+4>>2]=0;f[i+8>>2]=0;f[i+12>>2]=0;f[j+52>>2]=16;f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;ce(l,e);if((b[e+11>>0]|0)<0)QK(f[e>>2]|0);ve(e,c,d);g=e+11|0;n=b[g>>0]|0;o=n<<24>>24<0;de(j,o?f[e>>2]|0:e,o?f[e+4>>2]|0:n&255)|0;if((b[g>>0]|0)<0)QK(f[e>>2]|0);if((f[d>>2]|0)>0){e=0;do{de(j,18862,2)|0;e=e+1|0}while((e|0)<(f[d>>2]|0))}de(j,19569,18)|0;g=c+56|0;c=c+60|0;e=f[g>>2]|0;if((f[c>>2]|0)!=(e|0)){d=0;do{if(d){de(j,19588,1)|0;e=f[g>>2]|0}mB(j,h[e+d>>0]|0)|0;d=d+1|0;e=f[g>>2]|0}while(d>>>0<((f[c>>2]|0)-e|0)>>>0)}de(j,30204,1)|0;fe(a,l);f[j>>2]=4304;f[k>>2]=4324;f[l>>2]=4340;if((b[i+11>>0]|0)>=0){Rz(l);NA(j,4280);Mz(k);u=m;return}QK(f[i>>2]|0);Rz(l);NA(j,4280);Mz(k);u=m;return}function $e(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;m=u;u=u+32|0;k=m;l=f[d+12>>2]|0;Zd(d,b[c+36>>0]|0?12:8);i=c+56|0;j=c+60|0;e=f[j>>2]|0;g=f[i>>2]|0;h=e-g|0;if(h>>>0>255)Pa(55956,19104,1919,19563);if((g|0)==(e|0))Pa(55956,19104,1919,19563);Rd(d,h&255);e=f[i>>2]|0;if((f[j>>2]|0)!=(e|0)){g=0;do{Rd(d,b[e+g>>0]|0);g=g+1|0;e=f[i>>2]|0}while(g>>>0<((f[j>>2]|0)-e|0)>>>0)}ze(k,c,d,l);e=k+8|0;if((b[e+11>>0]|0)<0)QK(f[e>>2]|0);d=56816;k=f[d+4>>2]|0;l=a;f[l>>2]=f[d>>2];f[l+4>>2]=k;ZK(a+8|0,56824);u=m;return}function af(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=u;u=u+48|0;m=n+32|0;e=n+12|0;g=n;Je(e,c,d);e=e+8|0;if((b[e+11>>0]|0)<0)QK(f[e>>2]|0);i=Ed(d)|0;if(Ld(d,i&255,0)|0){f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;Rj(a,2,100,g);if((b[g+11>>0]|0)>=0){u=n;return}QK(f[g>>2]|0);u=n;return}j=c+56|0;k=i&255;e=c+60|0;h=f[e>>2]|0;c=f[j>>2]|0;g=h-c|0;if(k>>>0<=g>>>0){if(k>>>0<g>>>0?(l=c+k|0,(h|0)!=(l|0)):0)f[e>>2]=l}else Td(j,k-g|0);if(i<<24>>24){e=0;do{l=Ed(d)|0;b[(f[j>>2]|0)+e>>0]=l;e=e+1|0}while((e|0)!=(k|0))}if(b[d+24>>0]|0){f[m>>2]=0;f[m+4>>2]=0;f[m+8>>2]=0;Rj(a,2,100,m);if((b[m+11>>0]|0)<0)QK(f[m>>2]|0)}else{l=56816;d=f[l+4>>2]|0;m=a;f[m>>2]=f[l>>2];f[m+4>>2]=d;ZK(a+8|0,56824)}u=n;return}function bf(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;f[a>>2]=5976;h=a+16|0;f[h>>2]=6004;b=f[a+72>>2]|0;if(b|0){c=a+76|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b)}f[h>>2]=4404;g=a+60|0;b=f[g>>2]|0;if(b|0){e=a+64|0;c=f[e>>2]|0;if((c|0)!=(b|0)){do{d=c+-8|0;f[e>>2]=d;c=f[c+-4>>2]|0;if(!c)c=d;else{KK(c);c=f[e>>2]|0}}while((c|0)!=(b|0));b=f[g>>2]|0}QK(b)}f[h>>2]=4264;b=f[a+40>>2]|0;if(!b){zK(a);return}c=a+44|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);return}function cf(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;f[a>>2]=5976;h=a+16|0;f[h>>2]=6004;b=f[a+72>>2]|0;if(b|0){c=a+76|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b)}f[h>>2]=4404;g=a+60|0;b=f[g>>2]|0;if(b|0){e=a+64|0;c=f[e>>2]|0;if((c|0)!=(b|0)){do{d=c+-8|0;f[e>>2]=d;c=f[c+-4>>2]|0;if(!c)c=d;else{KK(c);c=f[e>>2]|0}}while((c|0)!=(b|0));b=f[g>>2]|0}QK(b)}f[h>>2]=4264;b=f[a+40>>2]|0;if(!b){zK(a);QK(a);return}c=a+44|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);QK(a);return}function df(a){a=a|0;a=a+16|0;dd[f[f[a>>2]>>2]&511](a);return}function ef(a){a=a|0;QK(a);return}function ff(a){a=a|0;var b=0,c=0,d=0,e=0,g=0;f[a>>2]=5944;b=f[a+60>>2]|0;if(b|0)KK(b);f[a>>2]=4404;e=a+44|0;b=f[e>>2]|0;if(b|0){g=a+48|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[a>>2]=4264;c=f[a+24>>2]|0;if(!c)return;b=a+28|0;if((f[b>>2]|0)!=(c|0))f[b>>2]=c;QK(c);return}function gf(a){a=a|0;var b=0,c=0,d=0,e=0,g=0;f[a>>2]=5944;b=f[a+60>>2]|0;if(b|0)KK(b);f[a>>2]=4404;e=a+44|0;b=f[e>>2]|0;if(b|0){g=a+48|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[a>>2]=4264;b=f[a+24>>2]|0;if(!b){QK(a);return}c=a+28|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);QK(a);return}function hf(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;l=u;u=u+160|0;h=l+136|0;i=l;j=i+56|0;k=i+4|0;f[i>>2]=292;f[j>>2]=312;bB(i+56|0,k);f[i+128>>2]=0;f[i+132>>2]=-1;f[i>>2]=4304;f[j>>2]=4324;fB(k);f[k>>2]=4340;g=i+36|0;f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;f[g+12>>2]=0;f[i+52>>2]=16;f[h>>2]=0;f[h+4>>2]=0;f[h+8>>2]=0;ce(k,h);if((b[h+11>>0]|0)<0)QK(f[h>>2]|0);ve(h,c,d);e=h+11|0;m=b[e>>0]|0;n=m<<24>>24<0;de(i,n?f[h>>2]|0:h,n?f[h+4>>2]|0:m&255)|0;if((b[e>>0]|0)<0)QK(f[h>>2]|0);if((f[d>>2]|0)>0){e=0;do{de(i,18862,2)|0;e=e+1|0}while((e|0)<(f[d>>2]|0))}m=de(i,20027,13)|0;e=c+56|0;c=f[e>>2]|0;c=Uc[f[(f[c>>2]|0)+8>>2]&127](c)|0;f[h>>2]=0;f[h+4>>2]=0;f[h+8>>2]=0;n=h+11|0;b[n>>0]=4;b[h+4>>0]=0;b[h>>0]=c>>>24;b[h+1>>0]=c>>>16;b[h+2>>0]=c>>>8;b[h+3>>0]=c;de(de(m,h,4)|0,30204,1)|0;if((b[n>>0]|0)<0)QK(f[h>>2]|0);e=f[e>>2]|0;if(e){fd[f[(f[e>>2]|0)+12>>2]&127](h,e,d);n=h+11|0;m=b[n>>0]|0;d=m<<24>>24<0;de(i,d?f[h>>2]|0:h,d?f[h+4>>2]|0:m&255)|0;if((b[n>>0]|0)<0)QK(f[h>>2]|0)}else de(i,20041,17)|0;fe(a,k);f[i>>2]=4304;f[j>>2]=4324;f[k>>2]=4340;if((b[g+11>>0]|0)>=0){Rz(k);NA(i,4280);Mz(j);u=l;return}QK(f[g>>2]|0);Rz(k);NA(i,4280);Mz(j);u=l;return}function jf(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0;k=u;u=u+48|0;j=k;h=k+20|0;i=f[d+12>>2]|0;Zd(d,b[c+36>>0]|0?12:8);e=c+56|0;g=f[e>>2]|0;if(!g)Pa(20011,19104,1857,19563);Ud(d,Uc[f[(f[g>>2]|0)+8>>2]&127](g)|0);g=f[e>>2]|0;fd[f[(f[g>>2]|0)+16>>2]&127](j,g,d);if(f[j>>2]|0){d=j;h=f[d+4>>2]|0;i=a;f[i>>2]=f[d>>2];f[i+4>>2]=h;a=a+8|0;j=j+8|0;f[a>>2]=f[j>>2];f[a+4>>2]=f[j+4>>2];f[a+8>>2]=f[j+8>>2];f[j>>2]=0;f[j+4>>2]=0;f[j+8>>2]=0;u=k;return}ze(h,c,d,i);c=h+8|0;if((b[c+11>>0]|0)<0)QK(f[c>>2]|0);d=56816;h=f[d+4>>2]|0;i=a;f[i>>2]=f[d>>2];f[i+4>>2]=h;ZK(a+8|0,56824);if((b[j+8+11>>0]|0)>=0){u=k;return}QK(f[j+8>>2]|0);u=k;return}function kf(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=u;u=u+64|0;o=q+40|0;l=q+36|0;i=q+24|0;m=q+16|0;g=q;h=Id(e)|0;f[l>>2]=h;a:do if((h|0)>=1886547814){if((h|0)<1917403971)switch(h|0){case 1886547814:break;default:{p=26;break a}}else switch(h|0){case 1917403971:break;default:{p=26;break a}}j=c+8|0;j=xM(f[j>>2]|0,f[j+4>>2]|0,f[c+16>>2]|0,0)|0;j=wM(j|0,I|0,-4,-1)|0;k=I;if(Ld(e,j,k)|0){f[i>>2]=0;f[i+4>>2]=0;f[i+8>>2]=0;Rj(a,2,100,i);if((b[i+11>>0]|0)>=0){u=q;return}QK(f[i>>2]|0);u=q;return}f[o>>2]=0;i=o+4|0;f[i>>2]=0;f[o+8>>2]=0;if(j|0){if((j|0)<0)$I(o);h=OK(j)|0;f[i>>2]=h;f[o>>2]=h;f[o+8>>2]=h+j;g=j;do{b[h>>0]=0;h=(f[i>>2]|0)+1|0;f[i>>2]=h;g=g+-1|0}while((g|0)!=0)}if(!((j|0)==0&(k|0)==0)){g=0;do{h=Ed(e)|0;b[(f[o>>2]|0)+g>>0]=h;g=g+1|0}while(0<k>>>0|0==(k|0)&g>>>0<j>>>0)}mf(m,l,o);g=f[m>>2]|0;h=m+4|0;l=f[h>>2]|0;f[m>>2]=0;f[h>>2]=0;f[c+56>>2]=g;c=c+60|0;g=f[c>>2]|0;f[c>>2]=l;if(g|0?(KK(g),n=f[h>>2]|0,n|0):0)KK(n);g=f[o>>2]|0;if(g|0){if((f[i>>2]|0)!=(g|0))f[i>>2]=g;QK(g)}}else{switch(h|0){case 1852009592:break;default:{p=26;break a}}i=OK(24)|0;f[i+4>>2]=0;f[i+8>>2]=0;f[i>>2]=6064;h=i+12|0;f[h>>2]=6092;d[i+16>>1]=2;d[i+18>>1]=2;d[i+20>>1]=6;b[i+22>>0]=1;IK(i);f[c+56>>2]=h;c=c+60|0;g=f[c>>2]|0;f[c>>2]=i;if(g|0)KK(g);lf(a,h,e);if(f[a>>2]|0){KK(i);u=q;return}g=a+8|0;if((b[g+11>>0]|0)<0)QK(f[g>>2]|0);KK(i)}while(0);if((p|0)==26){f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;Rj(a,2,126,g);if((b[g+11>>0]|0)>=0){u=q;return}QK(f[g>>2]|0);u=q;return}if(b[e+24>>0]|0){f[o>>2]=0;f[o+4>>2]=0;f[o+8>>2]=0;Rj(a,2,100,o);if((b[o+11>>0]|0)<0)QK(f[o>>2]|0)}else{e=56816;o=f[e+4>>2]|0;p=a;f[p>>2]=f[e>>2];f[p+4>>2]=o;ZK(a+8|0,56824)}u=q;return}function lf(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,h=0;h=u;u=u+16|0;g=h;if(!(Ld(e,7,0)|0)){g=Hd(e)|0;d[c+4>>1]=g;g=Hd(e)|0;d[c+6>>1]=g;g=Hd(e)|0;d[c+8>>1]=g;e=((Ed(e)|0)&255)>>>7;b[c+10>>0]=e;c=56816;e=f[c+4>>2]|0;g=a;f[g>>2]=f[c>>2];f[g+4>>2]=e;ZK(a+8|0,56824);u=h;return}f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;Rj(a,2,100,g);if((b[g+11>>0]|0)>=0){u=h;return}QK(f[g>>2]|0);u=h;return}function mf(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;o=u;u=u+16|0;d=o;m=OK(32)|0;f[m+4>>2]=0;f[m+8>>2]=0;f[m>>2]=6120;e=f[b>>2]|0;f[d>>2]=0;k=d+4|0;f[k>>2]=0;f[d+8>>2]=0;h=f[c>>2]|0;b=(f[c+4>>2]|0)-h|0;c=h;do if(b)if((b|0)<0)$I(d);else{l=OK(b)|0;f[d>>2]=l;n=l+b|0;f[d+8>>2]=n;GM(l|0,c|0,b|0)|0;f[k>>2]=n;i=l;j=n;break}else{i=0;j=0;l=0;n=0}while(0);h=m+12|0;f[h>>2]=6148;f[m+16>>2]=e;c=m+20|0;f[c>>2]=0;g=m+24|0;f[g>>2]=0;d=m+28|0;f[d>>2]=0;b=j-i|0;if(b|0){if((b|0)<0)$I(c);e=OK(b)|0;f[g>>2]=e;f[c>>2]=e;f[d>>2]=e+b;b=j-l|0;if((b|0)>0){GM(e|0,l|0,b|0)|0;f[g>>2]=e+b}}if(!l){n=a+4|0;f[a>>2]=h;f[n>>2]=m;u=o;return}if((n|0)!=(l|0))f[k>>2]=l;QK(l);n=a+4|0;f[a>>2]=h;f[n>>2]=m;u=o;return}function nf(a){a=a|0;var b=0;f[a>>2]=6148;b=f[a+8>>2]|0;if(!b)return;a=a+12|0;if((f[a>>2]|0)!=(b|0))f[a>>2]=b;QK(b);return}function of(a){a=a|0;var b=0,c=0;f[a>>2]=6148;b=f[a+8>>2]|0;if(!b){QK(a);return}c=a+12|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);QK(a);return}function pf(a){a=a|0;return f[a+4>>2]|0}function qf(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0;k=u;u=u+160|0;e=k+136|0;h=k;i=h+56|0;j=h+4|0;f[h>>2]=292;f[i>>2]=312;bB(h+56|0,j);f[h+128>>2]=0;f[h+132>>2]=-1;f[h>>2]=4304;f[i>>2]=4324;fB(j);f[j>>2]=4340;g=h+36|0;f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;f[g+12>>2]=0;f[h+52>>2]=16;f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;ce(j,e);if((b[e+11>>0]|0)<0)QK(f[e>>2]|0);if((f[d>>2]|0)>0){e=0;do{de(h,18862,2)|0;e=e+1|0}while((e|0)<(f[d>>2]|0))}d=de(h,19675,14)|0;de(nB(d,(f[c+12>>2]|0)-(f[c+8>>2]|0)|0)|0,30204,1)|0;fe(a,j);f[h>>2]=4304;f[i>>2]=4324;f[j>>2]=4340;if((b[g+11>>0]|0)>=0){Rz(j);NA(h,4280);Mz(i);u=k;return}QK(f[g>>2]|0);Rz(j);NA(h,4280);Mz(i);u=k;return}function rf(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;Yd(c,b+8|0);d=56816;b=f[d+4>>2]|0;c=a;f[c>>2]=f[d>>2];f[c+4>>2]=b;ZK(a+8|0,56824);return}function sf(a){a=a|0;var b=0,c=0;f[a>>2]=6120;f[a+12>>2]=6148;b=f[a+20>>2]|0;if(!b){zK(a);return}c=a+24|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);return}function tf(a){a=a|0;var b=0,c=0;f[a>>2]=6120;f[a+12>>2]=6148;b=f[a+20>>2]|0;if(!b){zK(a);QK(a);return}c=a+24|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);QK(a);return}function uf(a){a=a|0;a=a+12|0;dd[f[f[a>>2]>>2]&511](a);return}function vf(a){a=a|0;QK(a);return}function wf(a){a=a|0;return}function xf(a){a=a|0;QK(a);return}function yf(a){a=a|0;return 1852009592}function zf(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0;m=u;u=u+160|0;g=m+136|0;j=m;k=j+56|0;l=j+4|0;f[j>>2]=292;f[k>>2]=312;bB(j+56|0,l);f[j+128>>2]=0;f[j+132>>2]=-1;f[j>>2]=4304;f[k>>2]=4324;fB(l);f[l>>2]=4340;i=j+36|0;f[i>>2]=0;f[i+4>>2]=0;f[i+8>>2]=0;f[i+12>>2]=0;f[j+52>>2]=16;f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;ce(l,g);if((b[g+11>>0]|0)<0)QK(f[g>>2]|0);if((f[e>>2]|0)>0){g=0;do{de(j,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}h=de(j,19818,18)|0;h=de(lB(h,d[c+4>>1]|0)|0,30204,1)|0;if((f[e>>2]|0)>0){g=0;do{de(h,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}h=de(h,19837,26)|0;h=de(lB(h,d[c+6>>1]|0)|0,30204,1)|0;if((f[e>>2]|0)>0){g=0;do{de(h,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}h=de(h,19864,21)|0;h=de(lB(h,d[c+8>>1]|0)|0,30204,1)|0;if((f[e>>2]|0)>0){g=0;do{de(h,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}e=de(h,19886,17)|0;de(kB(e,(b[c+10>>0]|0)!=0)|0,30204,1)|0;fe(a,l);f[j>>2]=4304;f[k>>2]=4324;f[l>>2]=4340;if((b[i+11>>0]|0)>=0){Rz(l);NA(j,4280);Mz(k);u=m;return}QK(f[i>>2]|0);Rz(l);NA(j,4280);Mz(k);u=m;return}function Af(a,c,e){a=a|0;c=c|0;e=e|0;var g=0;Sd(e,d[c+4>>1]|0);Sd(e,d[c+6>>1]|0);Sd(e,d[c+8>>1]|0);Rd(e,b[c+10>>0]|0?-128:0);g=56816;c=f[g+4>>2]|0;e=a;f[e>>2]=f[g>>2];f[e+4>>2]=c;ZK(a+8|0,56824);return}function Bf(a){a=a|0;zK(a);return}function Cf(a){a=a|0;zK(a);QK(a);return}function Df(a){a=a|0;a=a+12|0;dd[f[f[a>>2]>>2]&511](a);return}function Ef(a){a=a|0;QK(a);return}function Ff(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;f[a>>2]=5916;h=a+16|0;f[h>>2]=5944;b=f[a+76>>2]|0;if(b|0)KK(b);f[h>>2]=4404;e=a+60|0;b=f[e>>2]|0;if(b|0){g=a+64|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[h>>2]=4264;b=f[a+40>>2]|0;if(!b){zK(a);return}c=a+44|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);return}function Gf(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;f[a>>2]=5916;h=a+16|0;f[h>>2]=5944;b=f[a+76>>2]|0;if(b|0)KK(b);f[h>>2]=4404;e=a+60|0;b=f[e>>2]|0;if(b|0){g=a+64|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[h>>2]=4264;b=f[a+40>>2]|0;if(!b){zK(a);QK(a);return}c=a+44|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);QK(a);return}function Hf(a){a=a|0;a=a+16|0;dd[f[f[a>>2]>>2]&511](a);return}function If(a){a=a|0;QK(a);return}function Jf(a){a=a|0;var c=0,d=0,e=0,g=0,h=0;f[a>>2]=5884;c=a+56|0;if((b[c+11>>0]|0)<0)QK(f[c>>2]|0);f[a>>2]=4404;g=a+44|0;c=f[g>>2]|0;if(c|0){h=a+48|0;d=f[h>>2]|0;if((d|0)!=(c|0)){do{e=d+-8|0;f[h>>2]=e;d=f[d+-4>>2]|0;if(!d)d=e;else{KK(d);d=f[h>>2]|0}}while((d|0)!=(c|0));c=f[g>>2]|0}QK(c)}f[a>>2]=4264;d=f[a+24>>2]|0;if(!d)return;c=a+28|0;if((f[c>>2]|0)!=(d|0))f[c>>2]=d;QK(d);return}function Kf(a){a=a|0;var c=0,d=0,e=0,g=0,h=0;f[a>>2]=5884;c=a+56|0;if((b[c+11>>0]|0)<0)QK(f[c>>2]|0);f[a>>2]=4404;g=a+44|0;c=f[g>>2]|0;if(c|0){h=a+48|0;d=f[h>>2]|0;if((d|0)!=(c|0)){do{e=d+-8|0;f[h>>2]=e;d=f[d+-4>>2]|0;if(!d)d=e;else{KK(d);d=f[h>>2]|0}}while((d|0)!=(c|0));c=f[g>>2]|0}QK(c)}f[a>>2]=4264;c=f[a+24>>2]|0;if(!c){QK(a);return}d=a+28|0;if((f[d>>2]|0)!=(c|0))f[d>>2]=c;QK(c);QK(a);return}function Lf(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;k=u;u=u+160|0;e=k+136|0;h=k;i=h+56|0;j=h+4|0;f[h>>2]=292;f[i>>2]=312;bB(h+56|0,j);f[h+128>>2]=0;f[h+132>>2]=-1;f[h>>2]=4304;f[i>>2]=4324;fB(j);f[j>>2]=4340;g=h+36|0;f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;f[g+12>>2]=0;f[h+52>>2]=16;f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;ce(j,e);if((b[e+11>>0]|0)<0)QK(f[e>>2]|0);ve(e,c,d);l=e+11|0;m=b[l>>0]|0;n=m<<24>>24<0;de(h,n?f[e>>2]|0:e,n?f[e+4>>2]|0:m&255)|0;if((b[l>>0]|0)<0)QK(f[e>>2]|0);if((f[d>>2]|0)>0){e=0;do{de(h,18862,2)|0;e=e+1|0}while((e|0)<(f[d>>2]|0))}d=de(h,20144,10)|0;l=c+56|0;n=b[l+11>>0]|0;m=n<<24>>24<0;de(de(d,m?f[l>>2]|0:l,m?f[c+60>>2]|0:n&255)|0,30204,1)|0;fe(a,j);f[h>>2]=4304;f[i>>2]=4324;f[j>>2]=4340;if((b[g+11>>0]|0)>=0){Rz(j);NA(h,4280);Mz(i);u=k;return}QK(f[g>>2]|0);Rz(j);NA(h,4280);Mz(i);u=k;return}function Mf(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0;i=u;u=u+32|0;h=i+20|0;e=i;Je(e,c,d);e=e+8|0;if((b[e+11>>0]|0)<0)QK(f[e>>2]|0);Jd(h,d);e=c+56|0;g=e+11|0;if((b[g>>0]|0)<0){b[f[e>>2]>>0]=0;f[c+60>>2]=0}else{b[e>>0]=0;b[g>>0]=0}dL(e,0);f[e>>2]=f[h>>2];f[e+4>>2]=f[h+4>>2];f[e+8>>2]=f[h+8>>2];if(!(b[d+24>>0]|0)){c=56816;d=f[c+4>>2]|0;h=a;f[h>>2]=f[c>>2];f[h+4>>2]=d;ZK(a+8|0,56824);u=i;return}f[h>>2]=0;f[h+4>>2]=0;f[h+8>>2]=0;Rj(a,2,100,h);if((b[h+11>>0]|0)>=0){u=i;return}QK(f[h>>2]|0);u=i;return}function Nf(a){a=a|0;var c=0,d=0,e=0,g=0,h=0,i=0;f[a>>2]=5856;i=a+16|0;f[i>>2]=5884;c=a+72|0;if((b[c+11>>0]|0)<0)QK(f[c>>2]|0);f[i>>2]=4404;h=a+60|0;c=f[h>>2]|0;if(c|0){g=a+64|0;d=f[g>>2]|0;if((d|0)!=(c|0)){do{e=d+-8|0;f[g>>2]=e;d=f[d+-4>>2]|0;if(!d)d=e;else{KK(d);d=f[g>>2]|0}}while((d|0)!=(c|0));c=f[h>>2]|0}QK(c)}f[i>>2]=4264;c=f[a+40>>2]|0;if(!c){zK(a);return}d=a+44|0;if((f[d>>2]|0)!=(c|0))f[d>>2]=c;QK(c);zK(a);return}function Of(a){a=a|0;var c=0,d=0,e=0,g=0,h=0,i=0;f[a>>2]=5856;i=a+16|0;f[i>>2]=5884;c=a+72|0;if((b[c+11>>0]|0)<0)QK(f[c>>2]|0);f[i>>2]=4404;h=a+60|0;c=f[h>>2]|0;if(c|0){g=a+64|0;d=f[g>>2]|0;if((d|0)!=(c|0)){do{e=d+-8|0;f[g>>2]=e;d=f[d+-4>>2]|0;if(!d)d=e;else{KK(d);d=f[g>>2]|0}}while((d|0)!=(c|0));c=f[h>>2]|0}QK(c)}f[i>>2]=4264;c=f[a+40>>2]|0;if(!c){zK(a);QK(a);return}d=a+44|0;if((f[d>>2]|0)!=(c|0))f[d>>2]=c;QK(c);zK(a);QK(a);return}function Pf(a){a=a|0;a=a+16|0;dd[f[f[a>>2]>>2]&511](a);return}function Qf(a){a=a|0;QK(a);return}function Rf(a){a=a|0;var b=0,c=0,d=0,e=0,g=0;f[a>>2]=4404;e=a+44|0;b=f[e>>2]|0;if(b|0){g=a+48|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[a>>2]=4264;b=f[a+24>>2]|0;if(!b){QK(a);return}c=a+28|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);QK(a);return}function Sf(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;k=u;u=u+160|0;g=k+136|0;h=k;i=h+56|0;j=h+4|0;f[h>>2]=292;f[i>>2]=312;bB(h+56|0,j);f[h+128>>2]=0;f[h+132>>2]=-1;f[h>>2]=4304;f[i>>2]=4324;fB(j);f[j>>2]=4340;e=h+36|0;f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;f[e+12>>2]=0;f[h+52>>2]=16;f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;ce(j,g);if((b[g+11>>0]|0)<0)QK(f[g>>2]|0);ve(g,c,d);l=g+11|0;m=b[l>>0]|0;n=m<<24>>24<0;de(h,n?f[g>>2]|0:g,n?f[g+4>>2]|0:m&255)|0;if((b[l>>0]|0)<0)QK(f[g>>2]|0);Uf(g,c,d);n=g+11|0;m=b[n>>0]|0;l=m<<24>>24<0;de(h,l?f[g>>2]|0:g,l?f[g+4>>2]|0:m&255)|0;if((b[n>>0]|0)<0)QK(f[g>>2]|0);fe(a,j);f[h>>2]=4304;f[i>>2]=4324;f[j>>2]=4340;if((b[e+11>>0]|0)>=0){Rz(j);NA(h,4280);Mz(i);u=k;return}QK(f[e>>2]|0);Rz(j);NA(h,4280);Mz(i);u=k;return}function Tf(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0;g=u;u=u+32|0;e=g;Je(e,c,d);e=e+8|0;if((b[e+11>>0]|0)<0)QK(f[e>>2]|0);Ke(a,c,d,Id(d)|0);u=g;return}function Uf(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=u;u=u+160|0;k=p+136|0;m=p;n=m+56|0;o=m+4|0;f[m>>2]=292;f[n>>2]=312;bB(m+56|0,o);f[m+128>>2]=0;f[m+132>>2]=-1;f[m>>2]=4304;f[n>>2]=4324;fB(o);f[o>>2]=4340;l=m+36|0;f[l>>2]=0;f[l+4>>2]=0;f[l+8>>2]=0;f[l+12>>2]=0;f[m+52>>2]=16;f[k>>2]=0;f[k+4>>2]=0;f[k+8>>2]=0;ce(o,k);if((b[k+11>>0]|0)<0)QK(f[k>>2]|0);e=(f[d>>2]|0)+1|0;f[d>>2]=e;g=f[c+44>>2]|0;j=f[c+48>>2]|0;if((g|0)!=(j|0)){h=k+11|0;i=k+4|0;e=1;c=g;while(1){if(!e){if((f[d>>2]|0)>0){e=0;do{de(m,18862,2)|0;e=e+1|0}while((e|0)<(f[d>>2]|0))}de(m,30204,1)|0}g=f[c>>2]|0;fd[f[(f[g>>2]|0)+8>>2]&127](k,g,d);g=b[h>>0]|0;e=g<<24>>24<0;de(m,e?f[k>>2]|0:k,e?f[i>>2]|0:g&255)|0;if((b[h>>0]|0)<0)QK(f[k>>2]|0);c=c+8|0;if((c|0)==(j|0))break;else e=0}e=f[d>>2]|0}f[d>>2]=(e|0)<1?0:e+-1|0;fe(a,o);f[m>>2]=4304;f[n>>2]=4324;f[o>>2]=4340;if((b[l+11>>0]|0)>=0){Rz(o);NA(m,4280);Mz(n);u=p;return}QK(f[l>>2]|0);Rz(o);NA(m,4280);Mz(n);u=p;return}function Vf(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;f[a>>2]=5796;h=a+16|0;f[h>>2]=4404;e=a+60|0;b=f[e>>2]|0;if(b|0){g=a+64|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[h>>2]=4264;b=f[a+40>>2]|0;if(!b){zK(a);return}c=a+44|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);return}function Wf(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;f[a>>2]=5796;h=a+16|0;f[h>>2]=4404;e=a+60|0;b=f[e>>2]|0;if(b|0){g=a+64|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[h>>2]=4264;b=f[a+40>>2]|0;if(!b){zK(a);QK(a);return}c=a+44|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);QK(a);return}function Xf(a){a=a|0;a=a+16|0;dd[f[f[a>>2]>>2]&511](a);return}function Yf(a){a=a|0;QK(a);return}function Zf(a){a=a|0;var b=0,c=0,d=0,e=0,g=0;f[a>>2]=4404;e=a+44|0;b=f[e>>2]|0;if(b|0){g=a+48|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[a>>2]=4264;b=f[a+24>>2]|0;if(!b){QK(a);return}c=a+28|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);QK(a);return}function _f(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;k=u;u=u+160|0;g=k+136|0;h=k;i=h+56|0;j=h+4|0;f[h>>2]=292;f[i>>2]=312;bB(h+56|0,j);f[h+128>>2]=0;f[h+132>>2]=-1;f[h>>2]=4304;f[i>>2]=4324;fB(j);f[j>>2]=4340;e=h+36|0;f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;f[e+12>>2]=0;f[h+52>>2]=16;f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;ce(j,g);if((b[g+11>>0]|0)<0)QK(f[g>>2]|0);ve(g,c,d);l=g+11|0;m=b[l>>0]|0;n=m<<24>>24<0;de(h,n?f[g>>2]|0:g,n?f[g+4>>2]|0:m&255)|0;if((b[l>>0]|0)<0)QK(f[g>>2]|0);Uf(g,c,d);n=g+11|0;m=b[n>>0]|0;l=m<<24>>24<0;de(h,l?f[g>>2]|0:g,l?f[g+4>>2]|0:m&255)|0;if((b[n>>0]|0)<0)QK(f[g>>2]|0);fe(a,j);f[h>>2]=4304;f[i>>2]=4324;f[j>>2]=4340;if((b[e+11>>0]|0)>=0){Rz(j);NA(h,4280);Mz(i);u=k;return}QK(f[e>>2]|0);Rz(j);NA(h,4280);Mz(i);u=k;return}function $f(a,b,c){a=a|0;b=b|0;c=c|0;Ke(a,b,c,-1);return}function ag(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;f[a>>2]=5736;h=a+16|0;f[h>>2]=4404;e=a+60|0;b=f[e>>2]|0;if(b|0){g=a+64|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[h>>2]=4264;b=f[a+40>>2]|0;if(!b){zK(a);return}c=a+44|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);return}function bg(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;f[a>>2]=5736;h=a+16|0;f[h>>2]=4404;e=a+60|0;b=f[e>>2]|0;if(b|0){g=a+64|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[h>>2]=4264;b=f[a+40>>2]|0;if(!b){zK(a);QK(a);return}c=a+44|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);QK(a);return}function cg(a){a=a|0;a=a+16|0;dd[f[f[a>>2]>>2]&511](a);return}function dg(a){a=a|0;QK(a);return}function eg(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0,i=0,j=0;f[a>>2]=5704;i=a+56|0;b=f[i>>2]|0;if(b|0){j=a+60|0;c=f[j>>2]|0;if((c|0)!=(b|0)){do{h=c+-64|0;f[j>>2]=h;d=f[c+-12>>2]|0;if(d|0){e=c+-8|0;g=f[e>>2]|0;if((g|0)!=(d|0))f[e>>2]=g+(~((g+-4-d|0)>>>2)<<2);QK(d)}f[h>>2]=4264;d=f[c+-40>>2]|0;if(d|0){c=c+-36|0;if((f[c>>2]|0)!=(d|0))f[c>>2]=d;QK(d)}c=f[j>>2]|0}while((c|0)!=(b|0));b=f[i>>2]|0}QK(b)}f[a>>2]=4404;e=a+44|0;b=f[e>>2]|0;if(b|0){g=a+48|0;c=f[g>>2]|0;if((c|0)!=(b|0)){do{d=c+-8|0;f[g>>2]=d;c=f[c+-4>>2]|0;if(!c)c=d;else{KK(c);c=f[g>>2]|0}}while((c|0)!=(b|0));b=f[e>>2]|0}QK(b)}f[a>>2]=4264;c=f[a+24>>2]|0;if(!c)return;b=a+28|0;if((f[b>>2]|0)!=(c|0))f[b>>2]=c;QK(c);return}function fg(a){a=a|0;eg(a);QK(a);return}function gg(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;p=u;u=u+160|0;l=p+136|0;m=p;n=m+56|0;o=m+4|0;f[m>>2]=292;f[n>>2]=312;bB(m+56|0,o);f[m+128>>2]=0;f[m+132>>2]=-1;f[m>>2]=4304;f[n>>2]=4324;fB(o);f[o>>2]=4340;k=m+36|0;f[k>>2]=0;f[k+4>>2]=0;f[k+8>>2]=0;f[k+12>>2]=0;f[m+52>>2]=16;f[l>>2]=0;f[l+4>>2]=0;f[l+8>>2]=0;ce(o,l);if((b[l+11>>0]|0)<0)QK(f[l>>2]|0);ve(l,c,d);j=l+11|0;i=b[j>>0]|0;h=i<<24>>24<0;de(m,h?f[l>>2]|0:l,h?f[l+4>>2]|0:i&255)|0;if((b[j>>0]|0)<0)QK(f[l>>2]|0);e=f[c+56>>2]|0;h=f[c+60>>2]|0;if((e|0)!=(h|0)){i=l+11|0;j=l+4|0;do{if((f[d>>2]|0)>0){c=0;do{de(m,18862,2)|0;c=c+1|0}while((c|0)<(f[d>>2]|0))}q=de(m,20408,12)|0;ee(l,e);g=b[i>>0]|0;c=g<<24>>24<0;g=de(de(q,c?f[l>>2]|0:l,c?f[j>>2]|0:g&255)|0,30204,1)|0;if((f[d>>2]|0)>0){c=0;do{de(g,18862,2)|0;c=c+1|0}while((c|0)<(f[d>>2]|0))}g=de(g,20421,12)|0;g=de(nB(g,f[e+48>>2]|0)|0,30204,1)|0;if((f[d>>2]|0)>0){c=0;do{de(g,18862,2)|0;c=c+1|0}while((c|0)<(f[d>>2]|0))}de(g,20434,14)|0;if((b[i>>0]|0)<0)QK(f[l>>2]|0);c=f[e+52>>2]|0;g=f[e+56>>2]|0;if((c|0)!=(g|0))do{de(nB(m,f[c>>2]|0)|0,20449,1)|0;c=c+4|0}while((c|0)!=(g|0));de(m,30204,1)|0;e=e+64|0}while((e|0)!=(h|0))}fe(a,o);f[m>>2]=4304;f[n>>2]=4324;f[o>>2]=4340;if((b[k+11>>0]|0)>=0){Rz(o);NA(m,4280);Mz(n);u=p;return}QK(f[k>>2]|0);Rz(o);NA(m,4280);Mz(n);u=p;return}function hg(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0;F=u;u=u+96|0;x=F+24|0;y=F;z=e+16|0;A=x+8|0;B=x+40|0;C=x+52|0;D=x+56|0;o=x+60|0;p=a+8|0;q=y+8|0;r=p+11|0;s=a+12|0;t=x+48|0;v=c+60|0;w=c+64|0;j=c+56|0;k=x+60|0;l=x+52|0;m=x+24|0;n=x+28|0;while(1){i=z;if((f[i>>2]|0)==0&(f[i+4>>2]|0)==0)break;f[x>>2]=4264;f[B>>2]=0;f[A>>2]=0;f[A+4>>2]=0;f[A+8>>2]=0;f[A+12>>2]=0;f[A+16>>2]=0;f[A+20>>2]=0;f[A+24>>2]=0;d[A+28>>1]=0;f[C>>2]=0;f[D>>2]=0;f[o>>2]=0;Te(a,x,e);if((f[a>>2]|0)==(f[14204]|0)){Je(y,x,e);g=y;h=f[g+4>>2]|0;i=a;f[i>>2]=f[g>>2];f[i+4>>2]=h;if((b[r>>0]|0)<0){b[f[p>>2]>>0]=0;f[s>>2]=0}else{b[p>>0]=0;b[r>>0]=0}dL(p,0);f[p>>2]=f[q>>2];f[p+4>>2]=f[q+4>>2];f[p+8>>2]=f[q+8>>2];if((f[a>>2]|0)==(f[14204]|0)){g=Id(e)|0;f[t>>2]=g;g=Id(e)|0;a:do if((g|0)>0){c=0;do{i=z;if((f[i>>2]|0)==0&(f[i+4>>2]|0)==0)break a;h=Id(e)|0;f[y>>2]=h;i=f[D>>2]|0;if(i>>>0<(f[k>>2]|0)>>>0){f[i>>2]=h;f[D>>2]=i+4}else Fe(l,y);c=c+1|0}while((c|0)<(g|0))}while(0);c=f[v>>2]|0;if((c|0)==(f[w>>2]|0))jg(j,x);else{ig(c,x);f[v>>2]=(f[v>>2]|0)+64}if((b[r>>0]|0)<0){QK(f[p>>2]|0);h=0}else h=0}else h=1}else h=1;c=f[C>>2]|0;if(c|0){g=f[D>>2]|0;if((g|0)!=(c|0))f[D>>2]=g+(~((g+-4-c|0)>>>2)<<2);QK(c)}f[x>>2]=4264;c=f[m>>2]|0;if(c|0){if((f[n>>2]|0)!=(c|0))f[n>>2]=c;QK(c)}if((h|0)==1){E=33;break}}if((E|0)==33){u=F;return}if(b[e+24>>0]|0){f[x>>2]=0;f[x+4>>2]=0;f[x+8>>2]=0;Rj(a,2,100,x);if((b[x+11>>0]|0)<0)QK(f[x>>2]|0)}else{C=56816;D=f[C+4>>2]|0;E=a;f[E>>2]=f[C>>2];f[E+4>>2]=D;ZK(p,56824)}u=F;return}function ig(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0;f[a>>2]=4264;d=a+8|0;e=b+8|0;f[d>>2]=f[e>>2];f[d+4>>2]=f[e+4>>2];f[d+8>>2]=f[e+8>>2];f[d+12>>2]=f[e+12>>2];d=a+24|0;e=b+24|0;f[d>>2]=0;i=a+28|0;f[i>>2]=0;f[a+32>>2]=0;g=b+28|0;c=(f[g>>2]|0)-(f[e>>2]|0)|0;if(c|0){if((c|0)<0)$I(d);h=OK(c)|0;f[i>>2]=h;f[d>>2]=h;f[a+32>>2]=h+c;d=f[e>>2]|0;c=(f[g>>2]|0)-d|0;if((c|0)>0){GM(h|0,d|0,c|0)|0;f[i>>2]=h+c}}g=b+36|0;h=f[g+4>>2]|0;i=a+36|0;f[i>>2]=f[g>>2];f[i+4>>2]=h;f[a+48>>2]=f[b+48>>2];kg(a+52|0,b+52|0);return}function jg(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0;k=a+4|0;c=f[a>>2]|0;e=(f[k>>2]|0)-c>>6;d=e+1|0;if(d>>>0>67108863)$I(a);l=a+8|0;j=(f[l>>2]|0)-c|0;c=j>>5;c=j>>6>>>0<33554431?(c>>>0<d>>>0?d:c):67108863;do if(c)if(c>>>0>67108863){l=Ra(8)|0;VK(l,44736);f[l>>2]=17660;Va(l|0,4016,428)}else{d=OK(c<<6)|0;break}else d=0;while(0);g=d+(e<<6)|0;e=g;i=d+(c<<6)|0;ig(g,b);h=g+64|0;b=f[a>>2]|0;c=f[k>>2]|0;if((c|0)==(b|0)){c=e;j=b;d=b}else{d=g;do{c=c+-64|0;ig(d+-64|0,c);d=e+-64|0;e=d}while((c|0)!=(b|0));c=e;j=f[a>>2]|0;d=f[k>>2]|0}f[a>>2]=c;f[k>>2]=h;f[l>>2]=i;h=j;if((d|0)!=(h|0)){g=d;do{b=g;g=g+-64|0;c=f[b+-12>>2]|0;if(c|0){d=b+-8|0;e=f[d>>2]|0;if((e|0)!=(c|0))f[d>>2]=e+(~((e+-4-c|0)>>>2)<<2);QK(c)}f[g>>2]=4264;d=f[b+-40>>2]|0;if(d|0){c=b+-36|0;if((f[c>>2]|0)!=(d|0))f[c>>2]=d;QK(d)}}while((g|0)!=(h|0))}if(!j)return;QK(j);return}function kg(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0;f[a>>2]=0;h=a+4|0;f[h>>2]=0;f[a+8>>2]=0;g=b+4|0;c=(f[g>>2]|0)-(f[b>>2]|0)|0;d=c>>2;if(!d)return;if(d>>>0>1073741823)$I(a);e=OK(c)|0;f[h>>2]=e;f[a>>2]=e;f[a+8>>2]=e+(d<<2);a=f[b>>2]|0;c=(f[g>>2]|0)-a|0;if((c|0)<=0)return;GM(e|0,a|0,c|0)|0;f[h>>2]=e+(c>>>2<<2);return}function lg(a){a=a|0;f[a>>2]=5676;eg(a+16|0);zK(a);return}function mg(a){a=a|0;f[a>>2]=5676;eg(a+16|0);zK(a);QK(a);return}function ng(a){a=a|0;a=a+16|0;dd[f[f[a>>2]>>2]&511](a);return}function og(a){a=a|0;QK(a);return}function pg(a){a=a|0;var b=0,c=0,d=0,e=0,g=0;f[a>>2]=5644;b=f[a+72>>2]|0;if(b|0){c=a+76|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b)}f[a>>2]=4404;g=a+44|0;b=f[g>>2]|0;if(b|0){e=a+48|0;c=f[e>>2]|0;if((c|0)!=(b|0)){do{d=c+-8|0;f[e>>2]=d;c=f[c+-4>>2]|0;if(!c)c=d;else{KK(c);c=f[e>>2]|0}}while((c|0)!=(b|0));b=f[g>>2]|0}QK(b)}f[a>>2]=4264;c=f[a+24>>2]|0;if(!c)return;b=a+28|0;if((f[b>>2]|0)!=(c|0))f[b>>2]=c;QK(c);return}function qg(a){a=a|0;var b=0,c=0,d=0,e=0,g=0;f[a>>2]=5644;b=f[a+72>>2]|0;if(b|0){c=a+76|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b)}f[a>>2]=4404;g=a+44|0;b=f[g>>2]|0;if(b|0){e=a+48|0;c=f[e>>2]|0;if((c|0)!=(b|0)){do{d=c+-8|0;f[e>>2]=d;c=f[c+-4>>2]|0;if(!c)c=d;else{KK(c);c=f[e>>2]|0}}while((c|0)!=(b|0));b=f[g>>2]|0}QK(b)}f[a>>2]=4264;b=f[a+24>>2]|0;if(!b){QK(a);return}c=a+28|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);QK(a);return}function rg(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;k=u;u=u+160|0;e=k+136|0;h=k;i=h+56|0;j=h+4|0;f[h>>2]=292;f[i>>2]=312;bB(h+56|0,j);f[h+128>>2]=0;f[h+132>>2]=-1;f[h>>2]=4304;f[i>>2]=4324;fB(j);f[j>>2]=4340;g=h+36|0;f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;f[g+12>>2]=0;f[h+52>>2]=16;f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;ce(j,e);if((b[e+11>>0]|0)<0)QK(f[e>>2]|0);ve(e,c,d);l=e+11|0;m=b[l>>0]|0;n=m<<24>>24<0;de(h,n?f[e>>2]|0:e,n?f[e+4>>2]|0:m&255)|0;if((b[l>>0]|0)<0)QK(f[e>>2]|0);if((f[d>>2]|0)>0){e=0;do{de(h,18862,2)|0;e=e+1|0}while((e|0)<(f[d>>2]|0))}m=de(h,20536,22)|0;n=c+8|0;n=xM(f[n>>2]|0,f[n+4>>2]|0,f[c+16>>2]|0,0)|0;de(oB(m,n,I)|0,30204,1)|0;fe(a,j);f[h>>2]=4304;f[i>>2]=4324;f[j>>2]=4340;if((b[g+11>>0]|0)>=0){Rz(j);NA(h,4280);Mz(i);u=k;return}QK(f[g>>2]|0);Rz(j);NA(h,4280);Mz(i);u=k;return}function sg(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0;e=u;u=u+32|0;g=e;h=f[d+12>>2]|0;Zd(d,b[c+36>>0]|0?12:8);Yd(d,c+72|0);ze(g,c,d,h);c=g+8|0;if((b[c+11>>0]|0)<0)QK(f[c>>2]|0);d=56816;g=f[d+4>>2]|0;h=a;f[h>>2]=f[d>>2];f[h+4>>2]=g;ZK(a+8|0,56824);u=e;return}function tg(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0;i=u;u=u+16|0;e=i;g=f[d>>2]|0;h=f[d+4>>2]|0;if(!h){g=Uc[f[(f[g>>2]|0)+8>>2]&127](g)|0;h=c+56|0;f[h>>2]=0;f[h+4>>2]=0;h=c+64|0;f[h>>2]=g;f[h+4>>2]=I}else{IK(h);j=Uc[f[(f[g>>2]|0)+8>>2]&127](g)|0;g=c+56|0;f[g>>2]=0;f[g+4>>2]=0;g=c+64|0;f[g>>2]=j;f[g+4>>2]=I;KK(h)}if(!(b[d+24>>0]|0)){g=56816;h=f[g+4>>2]|0;j=a;f[j>>2]=f[g>>2];f[j+4>>2]=h;ZK(a+8|0,56824);u=i;return}f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;Rj(a,2,100,e);if((b[e+11>>0]|0)>=0){u=i;return}QK(f[e>>2]|0);u=i;return}function ug(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;f[a>>2]=5616;h=a+16|0;f[h>>2]=5644;b=f[a+88>>2]|0;if(b|0){c=a+92|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b)}f[h>>2]=4404;g=a+60|0;b=f[g>>2]|0;if(b|0){e=a+64|0;c=f[e>>2]|0;if((c|0)!=(b|0)){do{d=c+-8|0;f[e>>2]=d;c=f[c+-4>>2]|0;if(!c)c=d;else{KK(c);c=f[e>>2]|0}}while((c|0)!=(b|0));b=f[g>>2]|0}QK(b)}f[h>>2]=4264;b=f[a+40>>2]|0;if(!b){zK(a);return}c=a+44|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);return}function vg(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;f[a>>2]=5616;h=a+16|0;f[h>>2]=5644;b=f[a+88>>2]|0;if(b|0){c=a+92|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b)}f[h>>2]=4404;g=a+60|0;b=f[g>>2]|0;if(b|0){e=a+64|0;c=f[e>>2]|0;if((c|0)!=(b|0)){do{d=c+-8|0;f[e>>2]=d;c=f[c+-4>>2]|0;if(!c)c=d;else{KK(c);c=f[e>>2]|0}}while((c|0)!=(b|0));b=f[g>>2]|0}QK(b)}f[h>>2]=4264;b=f[a+40>>2]|0;if(!b){zK(a);QK(a);return}c=a+44|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);QK(a);return}function wg(a){a=a|0;a=a+16|0;dd[f[f[a>>2]>>2]&511](a);return}function xg(a){a=a|0;QK(a);return}function yg(a){a=a|0;var b=0,c=0,d=0,e=0,g=0;f[a>>2]=5584;b=f[a+68>>2]|0;if(b|0){c=a+72|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b)}f[a>>2]=4404;g=a+44|0;b=f[g>>2]|0;if(b|0){e=a+48|0;c=f[e>>2]|0;if((c|0)!=(b|0)){do{d=c+-8|0;f[e>>2]=d;c=f[c+-4>>2]|0;if(!c)c=d;else{KK(c);c=f[e>>2]|0}}while((c|0)!=(b|0));b=f[g>>2]|0}QK(b)}f[a>>2]=4264;c=f[a+24>>2]|0;if(!c)return;b=a+28|0;if((f[b>>2]|0)!=(c|0))f[b>>2]=c;QK(c);return}function zg(a){a=a|0;var b=0,c=0,d=0,e=0,g=0;f[a>>2]=5584;b=f[a+68>>2]|0;if(b|0){c=a+72|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b)}f[a>>2]=4404;g=a+44|0;b=f[g>>2]|0;if(b|0){e=a+48|0;c=f[e>>2]|0;if((c|0)!=(b|0)){do{d=c+-8|0;f[e>>2]=d;c=f[c+-4>>2]|0;if(!c)c=d;else{KK(c);c=f[e>>2]|0}}while((c|0)!=(b|0));b=f[g>>2]|0}QK(b)}f[a>>2]=4264;b=f[a+24>>2]|0;if(!b){QK(a);return}c=a+28|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);QK(a);return}function Ag(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;m=u;u=u+160|0;e=m+136|0;j=m;k=j+56|0;l=j+4|0;f[j>>2]=292;f[k>>2]=312;bB(j+56|0,l);f[j+128>>2]=0;f[j+132>>2]=-1;f[j>>2]=4304;f[k>>2]=4324;fB(l);f[l>>2]=4340;i=j+36|0;f[i>>2]=0;f[i+4>>2]=0;f[i+8>>2]=0;f[i+12>>2]=0;f[j+52>>2]=16;f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;ce(l,e);if((b[e+11>>0]|0)<0)QK(f[e>>2]|0);ve(e,c,d);g=e+11|0;n=b[g>>0]|0;o=n<<24>>24<0;de(j,o?f[e>>2]|0:e,o?f[e+4>>2]|0:n&255)|0;if((b[g>>0]|0)<0)QK(f[e>>2]|0);if((f[d>>2]|0)>0){e=0;do{de(j,18862,2)|0;e=e+1|0}while((e|0)<(f[d>>2]|0))}g=de(j,18907,9)|0;g=de(mB(g,h[c+56>>0]|0)|0,30204,1)|0;if((f[d>>2]|0)>0){e=0;do{de(g,18862,2)|0;e=e+1|0}while((e|0)<(f[d>>2]|0))}g=de(g,20644,13)|0;g=de(mB(g,h[c+57>>0]|0)|0,30204,1)|0;if((f[d>>2]|0)>0){e=0;do{de(g,18862,2)|0;e=e+1|0}while((e|0)<(f[d>>2]|0))}g=de(g,20658,17)|0;g=de(mB(g,h[c+58>>0]|0)|0,30204,1)|0;if((f[d>>2]|0)>0){e=0;do{de(g,18862,2)|0;e=e+1|0}while((e|0)<(f[d>>2]|0))}g=de(g,20676,15)|0;g=de(mB(g,h[c+60>>0]|0)|0,30204,1)|0;if((f[d>>2]|0)>0){e=0;do{de(g,18862,2)|0;e=e+1|0}while((e|0)<(f[d>>2]|0))}g=de(g,20692,12)|0;g=de(mB(g,h[c+61>>0]|0)|0,30204,1)|0;if((f[d>>2]|0)>0){e=0;do{de(g,18862,2)|0;e=e+1|0}while((e|0)<(f[d>>2]|0))}g=de(g,20705,22)|0;g=de(mB(g,h[c+63>>0]|0)|0,30204,1)|0;if((f[d>>2]|0)>0){e=0;do{de(g,18862,2)|0;e=e+1|0}while((e|0)<(f[d>>2]|0))}g=de(g,20728,22)|0;g=de(mB(g,h[c+64>>0]|0)|0,30204,1)|0;if((f[d>>2]|0)>0){e=0;do{de(g,18862,2)|0;e=e+1|0}while((e|0)<(f[d>>2]|0))}g=de(g,20751,24)|0;g=de(mB(g,h[c+65>>0]|0)|0,30204,1)|0;if((f[d>>2]|0)>0){e=0;do{de(g,18862,2)|0;e=e+1|0}while((e|0)<(f[d>>2]|0))}de(g,20776,28)|0;if(!(b[c+66>>0]|0))de(j,20805,12)|0;else de(mB(j,(h[c+67>>0]|0)+1|0)|0,30204,1)|0;if((f[d>>2]|0)>0){e=0;do{de(j,18862,2)|0;e=e+1|0}while((e|0)<(f[d>>2]|0))}de(j,20818,12)|0;d=c+68|0;g=c+72|0;if((f[g>>2]|0)!=(f[d>>2]|0)){e=0;do{o=de(j,20449,1)|0;n=o+(f[(f[o>>2]|0)+-12>>2]|0)+4|0;f[n>>2]=f[n>>2]&-75|8;f[o+(f[(f[o>>2]|0)+-12>>2]|0)+76>>2]=48;f[o+(f[(f[o>>2]|0)+-12>>2]|0)+12>>2]=2;mB(o,h[(f[d>>2]|0)+e>>0]|0)|0;e=e+1|0}while(e>>>0<((f[g>>2]|0)-(f[d>>2]|0)|0)>>>0)}o=j+(f[(f[j>>2]|0)+-12>>2]|0)+4|0;f[o>>2]=f[o>>2]&-75|2;de(j,30204,1)|0;fe(a,l);f[j>>2]=4304;f[k>>2]=4324;f[l>>2]=4340;if((b[i+11>>0]|0)>=0){Rz(l);NA(j,4280);Mz(k);u=m;return}QK(f[i>>2]|0);Rz(l);NA(j,4280);Mz(k);u=m;return}function Bg(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0;e=u;u=u+32|0;g=e;h=f[d+12>>2]|0;Zd(d,b[c+36>>0]|0?12:8);Rd(d,b[c+56>>0]|-128);Rd(d,b[c+58>>0]&31|b[c+57>>0]<<5&255);Rd(d,((b[c+60>>0]|0?64:0)|(b[c+59>>0]|0?128:0)|(b[c+61>>0]|0?32:0)|(b[c+62>>0]|0?16:0)|(b[c+63>>0]|0?8:0)|(b[c+64>>0]|0?4:0)|b[c+65>>0]&3)&255);Rd(d,0);ze(g,c,d,h);c=g+8|0;if((b[c+11>>0]|0)>=0){g=56816;c=g;c=f[c>>2]|0;g=g+4|0;g=f[g>>2]|0;h=a;d=h;f[d>>2]=c;h=h+4|0;f[h>>2]=g;h=a+8|0;ZK(h,56824);u=e;return}QK(f[c>>2]|0);g=56816;c=g;c=f[c>>2]|0;g=g+4|0;g=f[g>>2]|0;h=a;d=h;f[d>>2]=c;h=h+4|0;f[h>>2]=g;h=a+8|0;ZK(h,56824);u=e;return}function Cg(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=u;u=u+16|0;m=n;k=(Ed(d)|0)&127;b[c+56>>0]=k;k=Ed(d)|0;b[c+57>>0]=(k&255)>>>5;b[c+58>>0]=k&31;k=Ed(d)|0;e=k&255;b[c+59>>0]=(k&255)>>>7;b[c+60>>0]=e>>>6&1;b[c+61>>0]=e>>>5&1;b[c+62>>0]=e>>>4&1;b[c+63>>0]=e>>>3&1;b[c+64>>0]=e>>>2&1;b[c+65>>0]=e&3;e=(Ed(d)|0)&255;k=e>>>4&1;b[c+66>>0]=k;if(k<<24>>24)b[c+67>>0]=e&15;k=d+16|0;j=f[k>>2]|0;k=f[k+4>>2]|0;i=c+68|0;c=c+72|0;h=f[c>>2]|0;e=f[i>>2]|0;g=h-e|0;if(j>>>0<=g>>>0){if(j>>>0<g>>>0?(l=e+j|0,(h|0)!=(l|0)):0)f[c>>2]=l}else{Td(i,j-g|0);e=f[i>>2]|0}Kd(d,e,j,k)|0;if(!(b[d+24>>0]|0)){l=56816;d=f[l+4>>2]|0;m=a;f[m>>2]=f[l>>2];f[m+4>>2]=d;ZK(a+8|0,56824);u=n;return}f[m>>2]=0;f[m+4>>2]=0;f[m+8>>2]=0;Rj(a,2,100,m);if((b[m+11>>0]|0)>=0){u=n;return}QK(f[m>>2]|0);u=n;return}function Dg(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;f[a>>2]=5556;h=a+16|0;f[h>>2]=5584;b=f[a+84>>2]|0;if(b|0){c=a+88|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b)}f[h>>2]=4404;g=a+60|0;b=f[g>>2]|0;if(b|0){e=a+64|0;c=f[e>>2]|0;if((c|0)!=(b|0)){do{d=c+-8|0;f[e>>2]=d;c=f[c+-4>>2]|0;if(!c)c=d;else{KK(c);c=f[e>>2]|0}}while((c|0)!=(b|0));b=f[g>>2]|0}QK(b)}f[h>>2]=4264;b=f[a+40>>2]|0;if(!b){zK(a);return}c=a+44|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);return}function Eg(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;f[a>>2]=5556;h=a+16|0;f[h>>2]=5584;b=f[a+84>>2]|0;if(b|0){c=a+88|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b)}f[h>>2]=4404;g=a+60|0;b=f[g>>2]|0;if(b|0){e=a+64|0;c=f[e>>2]|0;if((c|0)!=(b|0)){do{d=c+-8|0;f[e>>2]=d;c=f[c+-4>>2]|0;if(!c)c=d;else{KK(c);c=f[e>>2]|0}}while((c|0)!=(b|0));b=f[g>>2]|0}QK(b)}f[h>>2]=4264;b=f[a+40>>2]|0;if(!b){zK(a);QK(a);return}c=a+44|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);QK(a);return}function Fg(a){a=a|0;a=a+16|0;dd[f[f[a>>2]>>2]&511](a);return}function Gg(a){a=a|0;QK(a);return}function Hg(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0;f[a>>2]=5524;j=a+92|0;b=f[j>>2]|0;if(b|0){k=a+96|0;c=f[k>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-16|0;f[k>>2]=c;i=d+-12|0;h=f[i>>2]|0;if(h){g=d+-8|0;c=f[g>>2]|0;if((c|0)==(h|0))c=h;else{do{d=c+-12|0;f[g>>2]=d;e=f[d>>2]|0;if(!e)c=d;else{c=c+-8|0;if((f[c>>2]|0)!=(e|0))f[c>>2]=e;QK(e);c=f[g>>2]|0}}while((c|0)!=(h|0));c=f[i>>2]|0}QK(c);c=f[k>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[j>>2]|0}QK(b)}f[a>>2]=4404;e=a+44|0;b=f[e>>2]|0;if(b|0){g=a+48|0;c=f[g>>2]|0;if((c|0)!=(b|0)){do{d=c+-8|0;f[g>>2]=d;c=f[c+-4>>2]|0;if(!c)c=d;else{KK(c);c=f[g>>2]|0}}while((c|0)!=(b|0));b=f[e>>2]|0}QK(b)}f[a>>2]=4264;c=f[a+24>>2]|0;if(!c)return;b=a+28|0;if((f[b>>2]|0)!=(c|0))f[b>>2]=c;QK(c);return}function Ig(a){a=a|0;Hg(a);QK(a);return}function Jg(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;q=u;u=u+160|0;j=q+136|0;n=q;o=n+56|0;p=n+4|0;f[n>>2]=292;f[o>>2]=312;bB(n+56|0,p);f[n+128>>2]=0;f[n+132>>2]=-1;f[n>>2]=4304;f[o>>2]=4324;fB(p);f[p>>2]=4340;m=n+36|0;f[m>>2]=0;f[m+4>>2]=0;f[m+8>>2]=0;f[m+12>>2]=0;f[n+52>>2]=16;f[j>>2]=0;f[j+4>>2]=0;f[j+8>>2]=0;ce(p,j);if((b[j+11>>0]|0)<0)QK(f[j>>2]|0);ve(j,c,e);l=j+11|0;k=b[l>>0]|0;i=k<<24>>24<0;de(n,i?f[j>>2]|0:j,i?f[j+4>>2]|0:k&255)|0;if((b[l>>0]|0)<0)QK(f[j>>2]|0);if((f[e>>2]|0)>0){g=0;do{de(n,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}i=de(n,20916,23)|0;i=de(mB(i,h[c+56>>0]|0)|0,30204,1)|0;if((f[e>>2]|0)>0){g=0;do{de(i,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}i=de(i,20940,23)|0;i=de(mB(i,h[c+57>>0]|0)|0,30204,1)|0;if((f[e>>2]|0)>0){g=0;do{de(i,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}i=de(i,20964,19)|0;i=de(kB(i,(b[c+58>>0]|0)!=0)|0,30204,1)|0;if((f[e>>2]|0)>0){g=0;do{de(i,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}l=de(i,20984,21)|0;de(mB(l,h[c+59>>0]|0)|0,30204,1)|0;if((f[e>>2]|0)>0){g=0;do{de(n,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}de(n,21006,37)|0;i=c+60|0;g=0;do{nB(n,(f[i>>2]|0)>>>(31-g|0)&1)|0;if(((g|0)%8|0|0)!=7){if(((g|0)%4|0|0)==3){b[j>>0]=46;de(n,j,1)|0}}else{b[j>>0]=32;de(n,j,1)|0}g=g+1|0}while((g|0)<32);de(n,30204,1)|0;if((f[e>>2]|0)>0){g=0;do{de(n,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}de(n,21044,36)|0;g=0;do{mB(n,(f[c+64+(g>>>5<<2)>>2]&1<<(g&31)|0)!=0&1)|0;g=g+1|0;if(!(g&7)){b[j>>0]=32;de(n,j,1)|0}}while((g|0)<48);de(n,30204,1)|0;if((f[e>>2]|0)>0){g=0;do{de(n,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}i=de(n,21081,19)|0;i=de(mB(i,h[c+72>>0]|0)|0,30204,1)|0;if((f[e>>2]|0)>0){g=0;do{de(i,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}i=de(i,21101,30)|0;i=de(lB(i,d[c+74>>1]|0)|0,30204,1)|0;if((f[e>>2]|0)>0){g=0;do{de(i,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}i=de(i,21132,18)|0;i=de(mB(i,h[c+76>>0]|0)|0,30204,1)|0;if((f[e>>2]|0)>0){g=0;do{de(i,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}i=de(i,21151,15)|0;i=de(mB(i,h[c+77>>0]|0)|0,30204,1)|0;if((f[e>>2]|0)>0){g=0;do{de(i,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}i=de(i,21167,16)|0;i=de(mB(i,h[c+78>>0]|0)|0,30204,1)|0;if((f[e>>2]|0)>0){g=0;do{de(i,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}i=de(i,21184,18)|0;i=de(mB(i,h[c+79>>0]|0)|0,30204,1)|0;if((f[e>>2]|0)>0){g=0;do{de(i,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}i=de(i,21203,16)|0;i=de(lB(i,d[c+80>>1]|0)|0,30204,1)|0;if((f[e>>2]|0)>0){g=0;do{de(i,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}i=de(i,21220,21)|0;i=de(mB(i,h[c+82>>0]|0)|0,30204,1)|0;if((f[e>>2]|0)>0){g=0;do{de(i,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}i=de(i,21242,21)|0;i=de(mB(i,h[c+83>>0]|0)|0,30204,1)|0;if((f[e>>2]|0)>0){g=0;do{de(i,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}i=de(i,21264,20)|0;i=de(mB(i,h[c+84>>0]|0)|0,30204,1)|0;if((f[e>>2]|0)>0){g=0;do{de(i,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}g=de(i,21285,13)|0;de(mB(g,h[c+88>>0]|0)|0,30204,1)|0;g=f[c+92>>2]|0;l=f[c+96>>2]|0;if((g|0)!=(l|0)){k=g;g=f[e>>2]|0;do{if((g|0)>0){g=0;do{de(n,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}de(n,21299,8)|0;c=f[e>>2]|0;f[e>>2]=c+1;if((c|0)>-1){g=0;do{de(n,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}i=de(n,21308,20)|0;i=de(mB(i,h[k>>0]|0)|0,30204,1)|0;if((f[e>>2]|0)>0){g=0;do{de(i,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}i=de(i,21329,15)|0;de(mB(i,h[k+1>>0]|0)|0,30204,1)|0;i=f[k+4>>2]|0;c=f[k+8>>2]|0;g=f[e>>2]|0;if((i|0)!=(c|0))do{if((g|0)>0){g=0;do{de(n,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}g=f[i>>2]|0;j=f[i+4>>2]|0;if((g|0)!=(j|0))do{r=b[g>>0]|0;f[n+(f[(f[n>>2]|0)+-12>>2]|0)+76>>2]=48;f[n+(f[(f[n>>2]|0)+-12>>2]|0)+12>>2]=2;s=n+(f[(f[n>>2]|0)+-12>>2]|0)+4|0;f[s>>2]=f[s>>2]&-75|8;de(mB(n,r&255)|0,20449,1)|0;g=g+1|0}while((g|0)!=(j|0));de(n,30204,1)|0;g=n+(f[(f[n>>2]|0)+-12>>2]|0)+4|0;f[g>>2]=f[g>>2]&-75|2;i=i+12|0;g=f[e>>2]|0}while((i|0)!=(c|0));g=(g|0)<1?0:g+-1|0;f[e>>2]=g;k=k+16|0}while((k|0)!=(l|0))}fe(a,p);f[n>>2]=4304;f[o>>2]=4324;f[p>>2]=4340;if((b[m+11>>0]|0)>=0){Rz(p);NA(n,4280);Mz(o);u=q;return}QK(f[m>>2]|0);Rz(p);NA(n,4280);Mz(o);u=q;return}function Kg(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,i=0,j=0,k=0,l=0,m=0,n=0;n=u;u=u+32|0;l=n;m=f[e+12>>2]|0;Zd(e,b[c+36>>0]|0?12:8);Rd(e,b[c+56>>0]|0);Rd(e,b[c+58>>0]<<5&255|b[c+57>>0]<<6&255|b[c+59>>0]&31);Ud(e,f[c+60>>2]|0);g=0;do{k=g<<3;Rd(e,((f[c+64+((g>>>2&134217727)<<2)>>2]&1<<(k&24|7)|0)!=0|((f[c+64+((g>>>2&134217727)<<2)>>2]&1<<(k&24|6)|0)!=0|((f[c+64+((g>>>2&134217727)<<2)>>2]&1<<(k&24|5)|0)!=0|((f[c+64+((g>>>2&134217727)<<2)>>2]&1<<(k&24|4)|0)!=0|((f[c+64+((g>>>2&134217727)<<2)>>2]&1<<(k&24|3)|0)!=0|((f[c+64+((g>>>2&134217727)<<2)>>2]&1<<(k&24|2)|0)!=0|((f[c+64+((g>>>2&134217727)<<2)>>2]&1<<(k&24|1)|0)!=0&1)<<1)<<1)<<1&14)<<1&30)<<1&62)<<1&126)<<1&255);g=g+1|0}while((g|0)!=6);Rd(e,b[c+72>>0]|0);Sd(e,d[c+74>>1]|-4096);Rd(e,b[c+76>>0]|-4);Rd(e,b[c+77>>0]|-4);Rd(e,b[c+78>>0]|-8);Rd(e,b[c+79>>0]|-8);Sd(e,d[c+80>>1]|0);Rd(e,((b[c+83>>0]<<3&56|b[c+82>>0]<<6&255|b[c+84>>0]<<2&4)&255|(h[c+88>>0]|0)+3&3)&255);g=c+92|0;k=c+96|0;Rd(e,((f[k>>2]|0)-(f[g>>2]|0)|0)>>>4&255);g=f[g>>2]|0;k=f[k>>2]|0;if((g|0)!=(k|0))do{Rd(e,b[g>>0]<<6&64|b[g+1>>0]&63);i=g+4|0;j=g+8|0;Sd(e,(((f[j>>2]|0)-(f[i>>2]|0)|0)/12|0)&65535);i=f[i>>2]|0;j=f[j>>2]|0;if((i|0)!=(j|0))do{Sd(e,(f[i+4>>2]|0)-(f[i>>2]|0)&65535);Yd(e,i);i=i+12|0}while((i|0)!=(j|0));g=g+16|0}while((g|0)!=(k|0));ze(l,c,e,m);g=l+8|0;if((b[g+11>>0]|0)>=0){l=56816;c=l;c=f[c>>2]|0;l=l+4|0;l=f[l>>2]|0;m=a;e=m;f[e>>2]=c;m=m+4|0;f[m>>2]=l;a=a+8|0;ZK(a,56824);u=n;return}QK(f[g>>2]|0);l=56816;c=l;c=f[c>>2]|0;l=l+4|0;l=f[l>>2]|0;m=a;e=m;f[e>>2]=c;m=m+4|0;f[m>>2]=l;a=a+8|0;ZK(a,56824);u=n;return}function Lg(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0;G=u;u=u+32|0;F=G+16|0;E=G;h=Ed(e)|0;b[c+56>>0]=h;h=Ed(e)|0;g=h&255;b[c+57>>0]=(h&255)>>>6;b[c+58>>0]=g>>>5&1;b[c+59>>0]=g&31;g=Id(e)|0;f[c+60>>2]=g;g=0;h=Ed(e)|0;do{z=h&255;B=g<<3;C=c+64+((g>>>2&134217727)<<2)|0;A=1<<(B&24);y=f[C>>2]|0;f[C>>2]=z&128|0?y|A:y&~A;C=c+64+((g>>>2&134217727)<<2)|0;A=1<<(B&24|1);y=f[C>>2]|0;f[C>>2]=z&64|0?y|A:y&~A;C=c+64+((g>>>2&134217727)<<2)|0;A=1<<(B&24|2);y=f[C>>2]|0;f[C>>2]=z&32|0?y|A:y&~A;C=c+64+((g>>>2&134217727)<<2)|0;A=1<<(B&24|3);y=f[C>>2]|0;f[C>>2]=z&16|0?y|A:y&~A;C=c+64+((g>>>2&134217727)<<2)|0;A=1<<(B&24|4);y=f[C>>2]|0;f[C>>2]=z&8|0?y|A:y&~A;C=c+64+((g>>>2&134217727)<<2)|0;A=1<<(B&24|5);y=f[C>>2]|0;f[C>>2]=z&4|0?y|A:y&~A;C=c+64+((g>>>2&134217727)<<2)|0;A=1<<(B&24|6);y=f[C>>2]|0;f[C>>2]=z&2|0?y|A:y&~A;C=c+64+((g>>>2&134217727)<<2)|0;B=1<<(B&24|7);A=f[C>>2]|0;f[C>>2]=z&1|0?A|B:A&~B;g=g+1|0;h=Ed(e)|0}while((g|0)!=6);b[c+72>>0]=h;r=(Hd(e)|0)&4095;d[c+74>>1]=r;r=(Ed(e)|0)&3;b[c+76>>0]=r;r=(Ed(e)|0)&3;b[c+77>>0]=r;r=(Ed(e)|0)&7|8;b[c+78>>0]=r;r=(Ed(e)|0)&7|8;b[c+79>>0]=r;r=Hd(e)|0;d[c+80>>1]=r;r=Ed(e)|0;C=r&255;b[c+82>>0]=(r&255)>>>6;b[c+83>>0]=C>>>3&7;b[c+84>>0]=C>>>2&1;b[c+88>>0]=(C&3)+1;C=Ed(e)|0;r=C&255;a:do if(C<<24>>24){s=e+24|0;t=F+4|0;v=F+8|0;w=F+12|0;x=F+1|0;y=c+96|0;z=c+100|0;A=F+4|0;B=F+12|0;C=F+4|0;m=c+92|0;n=E+4|0;o=E+8|0;p=e+4|0;q=E+8|0;l=0;do{if(b[s>>0]|0)break a;j=Ed(e)|0;f[t>>2]=0;f[v>>2]=0;f[w>>2]=0;j=j&255;b[F>>0]=j>>>6&1;b[x>>0]=j&63;j=Hd(e)|0;k=j&65535;b:do if(j<<16>>16){j=0;do{if(b[s>>0]|0)break b;f[E>>2]=0;f[n>>2]=0;f[o>>2]=0;g=Hd(e)|0;i=g&65535;do if(g<<16>>16){do if(Fd(e,g&65535,0)|0){c=f[n>>2]|0;h=f[E>>2]|0;g=c-h|0;if(i>>>0<=g>>>0){if(i>>>0<g>>>0?(D=h+i|0,(c|0)!=(D|0)):0)f[n>>2]=D}else Td(E,i-g|0);g=f[e>>2]|0;h=f[p>>2]|0;if(!h){Wc[f[(f[g>>2]|0)+16>>2]&63](g,f[E>>2]|0,i)|0;break}else{IK(h);Wc[f[(f[g>>2]|0)+16>>2]&63](g,f[E>>2]|0,i)|0;KK(h);break}}while(0);g=f[v>>2]|0;if(g>>>0<(f[B>>2]|0)>>>0){f[g>>2]=0;i=g+4|0;f[i>>2]=0;f[g+8>>2]=0;f[g>>2]=f[E>>2];f[i>>2]=f[n>>2];f[g+8>>2]=f[q>>2];f[q>>2]=0;f[n>>2]=0;f[E>>2]=0;f[v>>2]=(f[v>>2]|0)+12;break}else{Ng(A,E);break}}while(0);g=f[E>>2]|0;if(g|0){if((f[n>>2]|0)!=(g|0))f[n>>2]=g;QK(g)}j=j+1|0}while((j|0)<(k|0))}while(0);g=f[y>>2]|0;if(g>>>0>=(f[z>>2]|0)>>>0){Mg(m,F);g=f[C>>2]|0;if(g|0){h=f[v>>2]|0;if((h|0)!=(g|0)){do{c=h+-12|0;f[v>>2]=c;i=f[c>>2]|0;if(!i)h=c;else{h=h+-8|0;if((f[h>>2]|0)!=(i|0))f[h>>2]=i;QK(i);h=f[v>>2]|0}}while((h|0)!=(g|0));g=f[C>>2]|0}QK(g)}}else{d[g>>1]=d[F>>1]|0;j=g+4|0;f[j>>2]=0;k=g+8|0;f[k>>2]=0;f[g+12>>2]=0;f[j>>2]=f[A>>2];f[k>>2]=f[v>>2];f[g+12>>2]=f[B>>2];f[B>>2]=0;f[v>>2]=0;f[A>>2]=0;f[y>>2]=(f[y>>2]|0)+16}l=l+1|0}while((l|0)<(r|0))}while(0);i=e+16|0;g=i;h=f[g>>2]|0;g=f[g+4>>2]|0;if((g|0)>0|(g|0)==0&h>>>0>0){c=f[e+8>>2]|0;if(c){Md(c,h,g);g=i;h=f[g>>2]|0;g=f[g+4>>2]|0}D=f[e>>2]|0;E=f[D>>2]|0;C=f[E+20>>2]|0;E=Uc[f[E+8>>2]&127](D)|0;E=wM(E|0,I|0,h|0,g|0)|0;Wc[C&63](D,E,I)|0;E=i;f[E>>2]=0;f[E+4>>2]=0}if(!(b[e+24>>0]|0)){E=56816;e=f[E+4>>2]|0;F=a;f[F>>2]=f[E>>2];f[F+4>>2]=e;ZK(a+8|0,56824);u=G;return}f[F>>2]=0;f[F+4>>2]=0;f[F+8>>2]=0;Rj(a,2,100,F);if((b[F+11>>0]|0)>=0){u=G;return}QK(f[F>>2]|0);u=G;return}function Mg(a,b){a=a|0;b=b|0;var c=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;k=a+4|0;c=f[a>>2]|0;i=(f[k>>2]|0)-c>>4;e=i+1|0;if(e>>>0>268435455)$I(a);m=a+8|0;l=(f[m>>2]|0)-c|0;c=l>>3;c=l>>4>>>0<134217727?(c>>>0<e>>>0?e:c):268435455;do if(c)if(c>>>0>268435455){m=Ra(8)|0;VK(m,44736);f[m>>2]=17660;Va(m|0,4016,428)}else{h=OK(c<<4)|0;break}else h=0;while(0);e=h+(i<<4)|0;g=e;j=h+(c<<4)|0;d[e>>1]=d[b>>1]|0;c=b+4|0;f[h+(i<<4)+12>>2]=0;f[h+(i<<4)+4>>2]=f[c>>2];l=b+8|0;f[h+(i<<4)+8>>2]=f[l>>2];b=b+12|0;f[h+(i<<4)+12>>2]=f[b>>2];f[b>>2]=0;f[l>>2]=0;f[c>>2]=0;b=e+16|0;h=f[a>>2]|0;c=f[k>>2]|0;if((c|0)==(h|0)){c=g;l=h;e=h}else{do{n=c;c=c+-16|0;d[e+-16>>1]=d[c>>1]|0;i=e+-12|0;l=n+-12|0;f[i>>2]=0;o=e+-8|0;f[o>>2]=0;f[e+-4>>2]=0;f[i>>2]=f[l>>2];i=n+-8|0;f[o>>2]=f[i>>2];n=n+-4|0;f[e+-4>>2]=f[n>>2];f[n>>2]=0;f[i>>2]=0;f[l>>2]=0;e=g+-16|0;g=e}while((c|0)!=(h|0));c=g;l=f[a>>2]|0;e=f[k>>2]|0}f[a>>2]=c;f[k>>2]=b;f[m>>2]=j;a=l;if((e|0)!=(a|0)){j=e;do{b=j+-12|0;c=f[b>>2]|0;if(c|0){i=j+-8|0;e=f[i>>2]|0;if((e|0)!=(c|0)){do{g=e+-12|0;f[i>>2]=g;h=f[g>>2]|0;if(!h)e=g;else{e=e+-8|0;if((f[e>>2]|0)!=(h|0))f[e>>2]=h;QK(h);e=f[i>>2]|0}}while((e|0)!=(c|0));c=f[b>>2]|0}QK(c)}j=j+-16|0}while((j|0)!=(a|0))}if(!l)return;QK(a);return}function Ng(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;j=a+4|0;c=f[a>>2]|0;h=((f[j>>2]|0)-c|0)/12|0;d=h+1|0;if(d>>>0>357913941)$I(a);k=a+8|0;i=((f[k>>2]|0)-c|0)/12|0;c=i<<1;c=i>>>0<178956970?(c>>>0<d>>>0?d:c):357913941;do if(c)if(c>>>0>357913941){k=Ra(8)|0;VK(k,44736);f[k>>2]=17660;Va(k|0,4016,428)}else{g=OK(c*12|0)|0;break}else g=0;while(0);d=g+(h*12|0)|0;e=d;i=g+(c*12|0)|0;f[g+(h*12|0)+8>>2]=0;f[d>>2]=f[b>>2];c=b+4|0;f[g+(h*12|0)+4>>2]=f[c>>2];l=b+8|0;f[g+(h*12|0)+8>>2]=f[l>>2];f[l>>2]=0;f[c>>2]=0;f[b>>2]=0;h=d+12|0;g=f[a>>2]|0;c=f[j>>2]|0;if((c|0)==(g|0)){c=e;b=g;d=g}else{do{l=d+-12|0;b=c;c=c+-12|0;f[l>>2]=0;m=d+-8|0;f[m>>2]=0;f[d+-4>>2]=0;f[l>>2]=f[c>>2];l=b+-8|0;f[m>>2]=f[l>>2];b=b+-4|0;f[d+-4>>2]=f[b>>2];f[b>>2]=0;f[l>>2]=0;f[c>>2]=0;d=e+-12|0;e=d}while((c|0)!=(g|0));c=e;b=f[a>>2]|0;d=f[j>>2]|0}f[a>>2]=c;f[j>>2]=h;f[k>>2]=i;g=b;if((d|0)!=(g|0))do{c=d;d=d+-12|0;e=f[d>>2]|0;if(e|0){c=c+-8|0;if((f[c>>2]|0)!=(e|0))f[c>>2]=e;QK(e)}}while((d|0)!=(g|0));if(!b)return;QK(b);return}function Og(a){a=a|0;f[a>>2]=5496;Hg(a+16|0);zK(a);return}function Pg(a){a=a|0;f[a>>2]=5496;Hg(a+16|0);zK(a);QK(a);return}function Qg(a){a=a|0;a=a+16|0;dd[f[f[a>>2]>>2]&511](a);return}function Rg(a){a=a|0;QK(a);return}function Sg(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0,i=0,j=0;f[a>>2]=5464;i=a+56|0;b=f[i>>2]|0;if(b|0){j=a+60|0;c=f[j>>2]|0;if((c|0)!=(b|0)){do{h=c+-64|0;f[j>>2]=h;d=f[c+-12>>2]|0;if(d|0){e=c+-8|0;g=f[e>>2]|0;if((g|0)!=(d|0))f[e>>2]=g+(~((g+-4-d|0)>>>2)<<2);QK(d)}f[h>>2]=4264;d=f[c+-40>>2]|0;if(d|0){c=c+-36|0;if((f[c>>2]|0)!=(d|0))f[c>>2]=d;QK(d)}c=f[j>>2]|0}while((c|0)!=(b|0));b=f[i>>2]|0}QK(b)}f[a>>2]=4404;e=a+44|0;b=f[e>>2]|0;if(b|0){g=a+48|0;c=f[g>>2]|0;if((c|0)!=(b|0)){do{d=c+-8|0;f[g>>2]=d;c=f[c+-4>>2]|0;if(!c)c=d;else{KK(c);c=f[g>>2]|0}}while((c|0)!=(b|0));b=f[e>>2]|0}QK(b)}f[a>>2]=4264;c=f[a+24>>2]|0;if(!c)return;b=a+28|0;if((f[b>>2]|0)!=(c|0))f[b>>2]=c;QK(c);return}function Tg(a){a=a|0;Sg(a);QK(a);return}function Ug(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;p=u;u=u+160|0;l=p+136|0;m=p;n=m+56|0;o=m+4|0;f[m>>2]=292;f[n>>2]=312;bB(m+56|0,o);f[m+128>>2]=0;f[m+132>>2]=-1;f[m>>2]=4304;f[n>>2]=4324;fB(o);f[o>>2]=4340;k=m+36|0;f[k>>2]=0;f[k+4>>2]=0;f[k+8>>2]=0;f[k+12>>2]=0;f[m+52>>2]=16;f[l>>2]=0;f[l+4>>2]=0;f[l+8>>2]=0;ce(o,l);if((b[l+11>>0]|0)<0)QK(f[l>>2]|0);ve(l,c,d);j=l+11|0;i=b[j>>0]|0;h=i<<24>>24<0;de(m,h?f[l>>2]|0:l,h?f[l+4>>2]|0:i&255)|0;if((b[j>>0]|0)<0)QK(f[l>>2]|0);e=f[c+56>>2]|0;h=f[c+60>>2]|0;if((e|0)!=(h|0)){i=l+11|0;j=l+4|0;do{if((f[d>>2]|0)>0){c=0;do{de(m,18862,2)|0;c=c+1|0}while((c|0)<(f[d>>2]|0))}q=de(m,21430,21)|0;ee(l,e);g=b[i>>0]|0;c=g<<24>>24<0;g=de(de(de(q,c?f[l>>2]|0:l,c?f[j>>2]|0:g&255)|0,21452,1)|0,21454,10)|0;de(nB(g,f[e+48>>2]|0)|0,21465,9)|0;if((b[i>>0]|0)<0)QK(f[l>>2]|0);c=f[e+52>>2]|0;g=f[e+56>>2]|0;if((c|0)!=(g|0))do{de(nB(m,f[c>>2]|0)|0,20449,1)|0;c=c+4|0}while((c|0)!=(g|0));de(m,30204,1)|0;e=e+64|0}while((e|0)!=(h|0))}fe(a,o);f[m>>2]=4304;f[n>>2]=4324;f[o>>2]=4340;if((b[k+11>>0]|0)>=0){Rz(o);NA(m,4280);Mz(n);u=p;return}QK(f[k>>2]|0);Rz(o);NA(m,4280);Mz(n);u=p;return}function Vg(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;m=u;u=u+32|0;k=m;l=f[d+12>>2]|0;Zd(d,b[c+36>>0]|0?12:8);i=(b[c+37>>0]|0)==0?2:4;e=f[c+56>>2]|0;j=f[c+60>>2]|0;if((e|0)!=(j|0))do{g=e+52|0;h=e+56|0;Ud(d,(X(((f[h>>2]|0)-(f[g>>2]|0)>>2)+1|0,i)|0)+10|0);Ud(d,f[e+20>>2]|0);Wd(d,i,f[e+48>>2]|0,0);Sd(d,((f[h>>2]|0)-(f[g>>2]|0)|0)>>>2&65535);g=f[g>>2]|0;h=f[h>>2]|0;if((g|0)!=(h|0))do{Wd(d,i,f[g>>2]|0,0);g=g+4|0}while((g|0)!=(h|0));e=e+64|0}while((e|0)!=(j|0));ze(k,c,d,l);e=k+8|0;if((b[e+11>>0]|0)>=0){k=56816;j=k;j=f[j>>2]|0;k=k+4|0;k=f[k>>2]|0;l=a;d=l;f[d>>2]=j;l=l+4|0;f[l>>2]=k;a=a+8|0;ZK(a,56824);u=m;return}QK(f[e>>2]|0);k=56816;j=k;j=f[j>>2]|0;k=k+4|0;k=f[k>>2]|0;l=a;d=l;f[d>>2]=j;l=l+4|0;f[l>>2]=k;a=a+8|0;ZK(a,56824);u=m;return}function Wg(a){a=a|0;var c=0,d=0,e=0,g=0,h=0,i=0;d=f[a+56>>2]|0;h=f[a+60>>2]|0;if((d|0)==(h|0)){h=0;a=a+37|0;b[a>>0]=h;return}else c=0;while(1){if((f[d+48>>2]|0)>>>0>65535){c=1;d=6;break}e=f[d+52>>2]|0;g=f[d+56>>2]|0;if((e|0)!=(g|0))do{i=(f[e>>2]|0)>>>0>65535;c=i?1:c;e=e+4|0}while(!(i|(e|0)==(g|0)));d=d+64|0;if((d|0)==(h|0)){d=6;break}}if((d|0)==6){i=a+37|0;b[i>>0]=c;return}}function Xg(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;E=u;u=u+96|0;B=E;g=E+68|0;C=E+64|0;Je(g,c,e);g=g+8|0;if((b[g+11>>0]|0)<0)QK(f[g>>2]|0);o=e+16|0;p=B+8|0;q=B+40|0;r=B+52|0;s=B+56|0;t=B+60|0;v=c+37|0;w=B+48|0;x=B+60|0;y=B+52|0;z=c+60|0;A=c+64|0;j=c+56|0;k=a+8|0;l=k+11|0;m=B+24|0;n=B+28|0;while(1){i=o;if((f[i>>2]|0)==0&(f[i+4>>2]|0)==0)break;f[B>>2]=4264;f[q>>2]=0;f[p>>2]=0;f[p+4>>2]=0;f[p+8>>2]=0;f[p+12>>2]=0;f[p+16>>2]=0;f[p+20>>2]=0;f[p+24>>2]=0;d[p+28>>1]=0;f[r>>2]=0;f[s>>2]=0;f[t>>2]=0;Te(a,B,e);if((f[a>>2]|0)==(f[14204]|0)){if(!(b[v>>0]|0)){i=(Hd(e)|0)&65535;f[w>>2]=i;i=Hd(e)|0;c=i&65535;if(i<<16>>16){g=0;do{h=(Hd(e)|0)&65535;f[C>>2]=h;i=f[s>>2]|0;if(i>>>0<(f[x>>2]|0)>>>0){f[i>>2]=h;f[s>>2]=i+4}else Fe(y,C);i=o;g=g+1|0}while(((f[i>>2]|0)!=0|(f[i+4>>2]|0)!=0)&(g|0)<(c|0))}}else{i=Id(e)|0;f[w>>2]=i;i=Hd(e)|0;c=i&65535;if(i<<16>>16){g=0;do{h=Id(e)|0;f[C>>2]=h;i=f[s>>2]|0;if(i>>>0<(f[x>>2]|0)>>>0){f[i>>2]=h;f[s>>2]=i+4}else Fe(y,C);i=o;g=g+1|0}while(((f[i>>2]|0)!=0|(f[i+4>>2]|0)!=0)&(g|0)<(c|0))}}g=f[z>>2]|0;if((g|0)==(f[A>>2]|0))Zg(j,B);else{Yg(g,B);f[z>>2]=(f[z>>2]|0)+64}if((b[l>>0]|0)<0){QK(f[k>>2]|0);h=0}else h=0}else h=1;g=f[r>>2]|0;if(g|0){c=f[s>>2]|0;if((c|0)!=(g|0))f[s>>2]=c+(~((c+-4-g|0)>>>2)<<2);QK(g)}f[B>>2]=4264;g=f[m>>2]|0;if(g|0){if((f[n>>2]|0)!=(g|0))f[n>>2]=g;QK(g)}if((h|0)==1){D=36;break}}if((D|0)==36){u=E;return}if(b[e+24>>0]|0){f[B>>2]=0;f[B+4>>2]=0;f[B+8>>2]=0;Rj(a,2,100,B);if((b[B+11>>0]|0)<0)QK(f[B>>2]|0)}else{B=56816;C=f[B+4>>2]|0;D=a;f[D>>2]=f[B>>2];f[D+4>>2]=C;ZK(k,56824)}u=E;return}function Yg(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0;f[a>>2]=4264;d=a+8|0;e=b+8|0;f[d>>2]=f[e>>2];f[d+4>>2]=f[e+4>>2];f[d+8>>2]=f[e+8>>2];f[d+12>>2]=f[e+12>>2];d=a+24|0;e=b+24|0;f[d>>2]=0;i=a+28|0;f[i>>2]=0;f[a+32>>2]=0;g=b+28|0;c=(f[g>>2]|0)-(f[e>>2]|0)|0;if(c|0){if((c|0)<0)$I(d);h=OK(c)|0;f[i>>2]=h;f[d>>2]=h;f[a+32>>2]=h+c;d=f[e>>2]|0;c=(f[g>>2]|0)-d|0;if((c|0)>0){GM(h|0,d|0,c|0)|0;f[i>>2]=h+c}}g=b+36|0;h=f[g+4>>2]|0;i=a+36|0;f[i>>2]=f[g>>2];f[i+4>>2]=h;f[a+48>>2]=f[b+48>>2];kg(a+52|0,b+52|0);return}function Zg(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0;k=a+4|0;c=f[a>>2]|0;e=(f[k>>2]|0)-c>>6;d=e+1|0;if(d>>>0>67108863)$I(a);l=a+8|0;j=(f[l>>2]|0)-c|0;c=j>>5;c=j>>6>>>0<33554431?(c>>>0<d>>>0?d:c):67108863;do if(c)if(c>>>0>67108863){l=Ra(8)|0;VK(l,44736);f[l>>2]=17660;Va(l|0,4016,428)}else{d=OK(c<<6)|0;break}else d=0;while(0);g=d+(e<<6)|0;e=g;i=d+(c<<6)|0;Yg(g,b);h=g+64|0;b=f[a>>2]|0;c=f[k>>2]|0;if((c|0)==(b|0)){c=e;j=b;d=b}else{d=g;do{c=c+-64|0;Yg(d+-64|0,c);d=e+-64|0;e=d}while((c|0)!=(b|0));c=e;j=f[a>>2]|0;d=f[k>>2]|0}f[a>>2]=c;f[k>>2]=h;f[l>>2]=i;h=j;if((d|0)!=(h|0)){g=d;do{b=g;g=g+-64|0;c=f[b+-12>>2]|0;if(c|0){d=b+-8|0;e=f[d>>2]|0;if((e|0)!=(c|0))f[d>>2]=e+(~((e+-4-c|0)>>>2)<<2);QK(c)}f[g>>2]=4264;d=f[b+-40>>2]|0;if(d|0){c=b+-36|0;if((f[c>>2]|0)!=(d|0))f[c>>2]=d;QK(d)}}while((g|0)!=(h|0))}if(!j)return;QK(j);return}function _g(a){a=a|0;f[a>>2]=5436;Sg(a+16|0);zK(a);return}function $g(a){a=a|0;f[a>>2]=5436;Sg(a+16|0);zK(a);QK(a);return}function ah(a){a=a|0;a=a+16|0;dd[f[f[a>>2]>>2]&511](a);return}function bh(a){a=a|0;QK(a);return}function ch(a){a=a|0;var b=0,c=0,d=0,e=0,g=0;f[a>>2]=4404;e=a+44|0;b=f[e>>2]|0;if(b|0){g=a+48|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[a>>2]=4264;b=f[a+24>>2]|0;if(!b){QK(a);return}c=a+28|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);QK(a);return}function dh(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;k=u;u=u+160|0;e=k+136|0;h=k;i=h+56|0;j=h+4|0;f[h>>2]=292;f[i>>2]=312;bB(h+56|0,j);f[h+128>>2]=0;f[h+132>>2]=-1;f[h>>2]=4304;f[i>>2]=4324;fB(j);f[j>>2]=4340;g=h+36|0;f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;f[g+12>>2]=0;f[h+52>>2]=16;f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;ce(j,e);if((b[e+11>>0]|0)<0)QK(f[e>>2]|0);ve(e,c,d);l=e+11|0;m=b[l>>0]|0;n=m<<24>>24<0;de(h,n?f[e>>2]|0:e,n?f[e+4>>2]|0:m&255)|0;if((b[l>>0]|0)<0)QK(f[e>>2]|0);if((f[d>>2]|0)>0){e=0;do{de(h,18862,2)|0;e=e+1|0}while((e|0)<(f[d>>2]|0))}n=de(h,21560,16)|0;n=de(mB(n,f[c+56>>2]|0)|0,21577,1)|0;n=de(mB(n,f[c+60>>2]|0)|0,21579,3)|0;n=de(mB(n,f[c+64>>2]|0)|0,21577,1)|0;de(mB(n,f[c+68>>2]|0)|0,30204,1)|0;if((f[d>>2]|0)>0){e=0;do{de(h,18862,2)|0;e=e+1|0}while((e|0)<(f[d>>2]|0))}n=de(h,21583,8)|0;n=de(mB(n,f[c+72>>2]|0)|0,21577,1)|0;n=de(mB(n,f[c+76>>2]|0)|0,21592,3)|0;n=de(mB(n,f[c+80>>2]|0)|0,21577,1)|0;de(mB(n,f[c+84>>2]|0)|0,30204,1)|0;fe(a,j);f[h>>2]=4304;f[i>>2]=4324;f[j>>2]=4340;if((b[g+11>>0]|0)>=0){Rz(j);NA(h,4280);Mz(i);u=k;return}QK(f[g>>2]|0);Rz(j);NA(h,4280);Mz(i);u=k;return}function eh(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0;e=u;u=u+32|0;g=e;h=f[d+12>>2]|0;Zd(d,b[c+36>>0]|0?12:8);Ud(d,f[c+56>>2]|0);Ud(d,f[c+60>>2]|0);Ud(d,f[c+64>>2]|0);Ud(d,f[c+68>>2]|0);Ud(d,f[c+72>>2]|0);Ud(d,f[c+76>>2]|0);Ud(d,f[c+80>>2]|0);Ud(d,f[c+84>>2]|0);ze(g,c,d,h);c=g+8|0;if((b[c+11>>0]|0)<0)QK(f[c>>2]|0);d=56816;g=f[d+4>>2]|0;h=a;f[h>>2]=f[d>>2];f[h+4>>2]=g;ZK(a+8|0,56824);u=e;return}function fh(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;p=u;u=u+32|0;n=p+12|0;o=p;l=Id(d)|0;m=Id(d)|0;j=Id(d)|0;k=Id(d)|0;h=Id(d)|0;i=Id(d)|0;g=Id(d)|0;e=Id(d)|0;if((m+65536|0)>>>0>131072)do{l=(l|0)/2|0;m=(m|0)/2|0}while((m+65536|0)>>>0>131072);if((l+65536|0)>>>0>131072)do{l=(l|0)/2|0;m=(m|0)/2|0}while((l+65536|0)>>>0>131072);q=c+56|0;f[q>>2]=l;f[q+4>>2]=m;if((k+65536|0)>>>0>131072)do{j=(j|0)/2|0;k=(k|0)/2|0}while((k+65536|0)>>>0>131072);if((j+65536|0)>>>0>131072)do{j=(j|0)/2|0;k=(k|0)/2|0}while((j+65536|0)>>>0>131072);q=c+64|0;f[q>>2]=j;f[q+4>>2]=k;if((i+65536|0)>>>0>131072)do{h=(h|0)/2|0;i=(i|0)/2|0}while((i+65536|0)>>>0>131072);if((h+65536|0)>>>0>131072)do{h=(h|0)/2|0;i=(i|0)/2|0}while((h+65536|0)>>>0>131072);q=c+72|0;f[q>>2]=h;f[q+4>>2]=i;if((e+65536|0)>>>0>131072)do{g=(g|0)/2|0;e=(e|0)/2|0}while((e+65536|0)>>>0>131072);if((g+65536|0)>>>0>131072)do{g=(g|0)/2|0;e=(e|0)/2|0}while((g+65536|0)>>>0>131072);q=c+80|0;f[q>>2]=g;f[q+4>>2]=e;if((m|0)==0|(k|0)==0|(i|0)==0|(e|0)==0){f[o>>2]=0;f[o+4>>2]=0;f[o+8>>2]=0;Rj(a,2,128,o);if((b[o+11>>0]|0)>=0){u=p;return}QK(f[o>>2]|0);u=p;return}if(b[d+24>>0]|0){f[n>>2]=0;f[n+4>>2]=0;f[n+8>>2]=0;Rj(a,2,100,n);if((b[n+11>>0]|0)<0)QK(f[n>>2]|0)}else{n=56816;o=f[n+4>>2]|0;q=a;f[q>>2]=f[n>>2];f[q+4>>2]=o;ZK(a+8|0,56824)}u=p;return}function gh(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;f[a>>2]=5376;h=a+16|0;f[h>>2]=4404;e=a+60|0;b=f[e>>2]|0;if(b|0){g=a+64|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[h>>2]=4264;b=f[a+40>>2]|0;if(!b){zK(a);return}c=a+44|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);return}function hh(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;f[a>>2]=5376;h=a+16|0;f[h>>2]=4404;e=a+60|0;b=f[e>>2]|0;if(b|0){g=a+64|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[h>>2]=4264;b=f[a+40>>2]|0;if(!b){zK(a);QK(a);return}c=a+44|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);QK(a);return}function ih(a){a=a|0;a=a+16|0;dd[f[f[a>>2]>>2]&511](a);return}function jh(a){a=a|0;QK(a);return}function kh(a){a=a|0;var b=0,c=0,d=0,e=0,g=0;f[a>>2]=4404;e=a+44|0;b=f[e>>2]|0;if(b|0){g=a+48|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[a>>2]=4264;b=f[a+24>>2]|0;if(!b){QK(a);return}c=a+28|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);QK(a);return}function lh(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;k=u;u=u+160|0;e=k+136|0;h=k;i=h+56|0;j=h+4|0;f[h>>2]=292;f[i>>2]=312;bB(h+56|0,j);f[h+128>>2]=0;f[h+132>>2]=-1;f[h>>2]=4304;f[i>>2]=4324;fB(j);f[j>>2]=4340;g=h+36|0;f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;f[g+12>>2]=0;f[h+52>>2]=16;f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;ce(j,e);if((b[e+11>>0]|0)<0)QK(f[e>>2]|0);ve(e,c,d);l=e+11|0;m=b[l>>0]|0;n=m<<24>>24<0;de(h,n?f[e>>2]|0:e,n?f[e+4>>2]|0:m&255)|0;if((b[l>>0]|0)<0)QK(f[e>>2]|0);if((f[d>>2]|0)>0){e=0;do{de(h,18862,2)|0;e=e+1|0}while((e|0)<(f[d>>2]|0))}de(h,21681,13)|0;switch(b[c+56>>0]|0){case 0:{de(h,21695,9)|0;break}case 1:{de(h,21705,11)|0;break}default:{}}fe(a,j);f[h>>2]=4304;f[i>>2]=4324;f[j>>2]=4340;if((b[g+11>>0]|0)>=0){Rz(j);NA(h,4280);Mz(i);u=k;return}QK(f[g>>2]|0);Rz(j);NA(h,4280);Mz(i);u=k;return}function mh(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0;g=u;u=u+16|0;e=g;h=(Ed(d)|0)&1;b[c+56>>0]=h;if(!(b[d+24>>0]|0)){d=56816;e=f[d+4>>2]|0;h=a;f[h>>2]=f[d>>2];f[h+4>>2]=e;ZK(a+8|0,56824);u=g;return}f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;Rj(a,2,100,e);if((b[e+11>>0]|0)>=0){u=g;return}QK(f[e>>2]|0);u=g;return}function nh(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;f[a>>2]=5316;h=a+16|0;f[h>>2]=4404;e=a+60|0;b=f[e>>2]|0;if(b|0){g=a+64|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[h>>2]=4264;b=f[a+40>>2]|0;if(!b){zK(a);return}c=a+44|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);return}function oh(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;f[a>>2]=5316;h=a+16|0;f[h>>2]=4404;e=a+60|0;b=f[e>>2]|0;if(b|0){g=a+64|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[h>>2]=4264;b=f[a+40>>2]|0;if(!b){zK(a);QK(a);return}c=a+44|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);QK(a);return}function ph(a){a=a|0;a=a+16|0;dd[f[f[a>>2]>>2]&511](a);return}function qh(a){a=a|0;QK(a);return}function rh(a){a=a|0;var b=0,c=0,d=0,e=0,g=0;f[a>>2]=4404;e=a+44|0;b=f[e>>2]|0;if(b|0){g=a+48|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[a>>2]=4264;b=f[a+24>>2]|0;if(!b){QK(a);return}c=a+28|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);QK(a);return}function sh(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;k=u;u=u+160|0;e=k+136|0;h=k;i=h+56|0;j=h+4|0;f[h>>2]=292;f[i>>2]=312;bB(h+56|0,j);f[h+128>>2]=0;f[h+132>>2]=-1;f[h>>2]=4304;f[i>>2]=4324;fB(j);f[j>>2]=4340;g=h+36|0;f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;f[g+12>>2]=0;f[h+52>>2]=16;f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;ce(j,e);if((b[e+11>>0]|0)<0)QK(f[e>>2]|0);ve(e,c,d);l=e+11|0;m=b[l>>0]|0;n=m<<24>>24<0;de(h,n?f[e>>2]|0:e,n?f[e+4>>2]|0:m&255)|0;if((b[l>>0]|0)<0)QK(f[e>>2]|0);if((f[d>>2]|0)>0){e=0;do{de(h,18862,2)|0;e=e+1|0}while((e|0)<(f[d>>2]|0))}n=de(h,21802,10)|0;de(mB(n,f[c+56>>2]|0)|0,21813,15)|0;fe(a,j);f[h>>2]=4304;f[i>>2]=4324;f[j>>2]=4340;if((b[g+11>>0]|0)>=0){Rz(j);NA(h,4280);Mz(i);u=k;return}QK(f[g>>2]|0);Rz(j);NA(h,4280);Mz(i);u=k;return}function th(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0;g=u;u=u+16|0;e=g;h=((Ed(d)|0)&3)*90|0;f[c+56>>2]=h;if(!(b[d+24>>0]|0)){d=56816;e=f[d+4>>2]|0;h=a;f[h>>2]=f[d>>2];f[h+4>>2]=e;ZK(a+8|0,56824);u=g;return}f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;Rj(a,2,100,e);if((b[e+11>>0]|0)>=0){u=g;return}QK(f[e>>2]|0);u=g;return}function uh(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;f[a>>2]=5256;h=a+16|0;f[h>>2]=4404;e=a+60|0;b=f[e>>2]|0;if(b|0){g=a+64|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[h>>2]=4264;b=f[a+40>>2]|0;if(!b){zK(a);return}c=a+44|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);return}function vh(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;f[a>>2]=5256;h=a+16|0;f[h>>2]=4404;e=a+60|0;b=f[e>>2]|0;if(b|0){g=a+64|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[h>>2]=4264;b=f[a+40>>2]|0;if(!b){zK(a);QK(a);return}c=a+44|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);QK(a);return}function wh(a){a=a|0;a=a+16|0;dd[f[f[a>>2]>>2]&511](a);return}function xh(a){a=a|0;QK(a);return}function yh(a){a=a|0;var c=0,d=0,e=0,g=0,h=0;f[a>>2]=5224;c=f[a+68>>2]|0;if(c|0){d=a+72|0;if((f[d>>2]|0)!=(c|0))f[d>>2]=c;QK(c)}c=a+56|0;if((b[c+11>>0]|0)<0)QK(f[c>>2]|0);f[a>>2]=4404;g=a+44|0;c=f[g>>2]|0;if(c|0){h=a+48|0;d=f[h>>2]|0;if((d|0)!=(c|0)){do{e=d+-8|0;f[h>>2]=e;d=f[d+-4>>2]|0;if(!d)d=e;else{KK(d);d=f[h>>2]|0}}while((d|0)!=(c|0));c=f[g>>2]|0}QK(c)}f[a>>2]=4264;d=f[a+24>>2]|0;if(!d)return;c=a+28|0;if((f[c>>2]|0)!=(d|0))f[c>>2]=d;QK(d);return}function zh(a){a=a|0;var c=0,d=0,e=0,g=0,h=0;f[a>>2]=5224;c=f[a+68>>2]|0;if(c|0){d=a+72|0;if((f[d>>2]|0)!=(c|0))f[d>>2]=c;QK(c)}c=a+56|0;if((b[c+11>>0]|0)<0)QK(f[c>>2]|0);f[a>>2]=4404;g=a+44|0;c=f[g>>2]|0;if(c|0){h=a+48|0;d=f[h>>2]|0;if((d|0)!=(c|0)){do{e=d+-8|0;f[h>>2]=e;d=f[d+-4>>2]|0;if(!d)d=e;else{KK(d);d=f[h>>2]|0}}while((d|0)!=(c|0));c=f[g>>2]|0}QK(c)}f[a>>2]=4264;c=f[a+24>>2]|0;if(!c){QK(a);return}d=a+28|0;if((f[d>>2]|0)!=(c|0))f[d>>2]=c;QK(c);QK(a);return}function Ah(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;l=u;u=u+160|0;e=l+136|0;i=l;j=i+56|0;k=i+4|0;f[i>>2]=292;f[j>>2]=312;bB(i+56|0,k);f[i+128>>2]=0;f[i+132>>2]=-1;f[i>>2]=4304;f[j>>2]=4324;fB(k);f[k>>2]=4340;h=i+36|0;f[h>>2]=0;f[h+4>>2]=0;f[h+8>>2]=0;f[h+12>>2]=0;f[i+52>>2]=16;f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;ce(k,e);if((b[e+11>>0]|0)<0)QK(f[e>>2]|0);ve(e,c,d);g=e+11|0;m=b[g>>0]|0;n=m<<24>>24<0;de(i,n?f[e>>2]|0:e,n?f[e+4>>2]|0:m&255)|0;if((b[g>>0]|0)<0)QK(f[e>>2]|0);if((f[d>>2]|0)>0){e=0;do{de(i,18862,2)|0;e=e+1|0}while((e|0)<(f[d>>2]|0))}e=de(i,21914,10)|0;m=c+56|0;g=b[m+11>>0]|0;n=g<<24>>24<0;g=de(de(e,n?f[m>>2]|0:m,n?f[c+60>>2]|0:g&255)|0,30204,1)|0;if((f[d>>2]|0)>0){e=0;do{de(g,18862,2)|0;e=e+1|0}while((e|0)<(f[d>>2]|0))}de(g,21925,14)|0;e=f[c+68>>2]|0;g=f[c+72>>2]|0;if((e|0)!=(g|0))do{n=b[e>>0]|0;m=i+(f[(f[i>>2]|0)+-12>>2]|0)+4|0;f[m>>2]=f[m>>2]&-75|8;f[i+(f[(f[i>>2]|0)+-12>>2]|0)+12>>2]=2;f[i+(f[(f[i>>2]|0)+-12>>2]|0)+76>>2]=48;de(mB(i,n&255)|0,20449,1)|0;e=e+1|0}while((e|0)!=(g|0));de(i,30204,1)|0;fe(a,k);f[i>>2]=4304;f[j>>2]=4324;f[k>>2]=4340;if((b[h+11>>0]|0)>=0){Rz(k);NA(i,4280);Mz(j);u=l;return}QK(f[h>>2]|0);Rz(k);NA(i,4280);Mz(j);u=l;return}function Bh(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0;j=u;u=u+32|0;h=j;i=f[d+12>>2]|0;Zd(d,b[c+36>>0]|0?12:8);Xd(d,c+56|0);e=f[c+68>>2]|0;g=f[c+72>>2]|0;if((e|0)!=(g|0))do{Rd(d,b[e>>0]|0);e=e+1|0}while((e|0)!=(g|0));ze(h,c,d,i);e=h+8|0;if((b[e+11>>0]|0)<0)QK(f[e>>2]|0);d=56816;h=f[d+4>>2]|0;i=a;f[i>>2]=f[d>>2];f[i+4>>2]=h;ZK(a+8|0,56824);u=j;return}function Ch(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=u;u=u+32|0;q=r+20|0;e=r;Je(e,c,d);e=e+8|0;if((b[e+11>>0]|0)<0)QK(f[e>>2]|0);Jd(q,d);e=c+56|0;g=e+11|0;if((b[g>>0]|0)<0){b[f[e>>2]>>0]=0;f[c+60>>2]=0}else{b[e>>0]=0;b[g>>0]=0}dL(e,0);f[e>>2]=f[q>>2];f[e+4>>2]=f[q+4>>2];f[e+8>>2]=f[q+8>>2];n=d+16|0;p=n;a:do if(!((f[p>>2]|0)==0&(f[p+4>>2]|0)==0)){o=c+68|0;p=c+72|0;l=c+76|0;while(1){i=Ed(d)|0;e=f[p>>2]|0;m=f[l>>2]|0;g=m;if(e>>>0>=m>>>0){m=f[o>>2]|0;j=e-m|0;e=j+1|0;k=m;if((e|0)<0)break;h=g-m|0;g=h<<1;g=h>>>0<1073741823?(g>>>0<e>>>0?e:g):2147483647;if(!g)h=0;else h=OK(g)|0;c=h+j|0;b[c>>0]=i;e=c+(0-j)|0;if((j|0)>0)GM(e|0,k|0,j|0)|0;f[o>>2]=e;f[p>>2]=c+1;f[l>>2]=h+g;if(m|0)QK(k)}else{b[e>>0]=i;f[p>>2]=(f[p>>2]|0)+1}m=n;if((f[m>>2]|0)==0&(f[m+4>>2]|0)==0)break a}$I(o)}while(0);if(!(b[d+24>>0]|0)){p=56816;d=f[p+4>>2]|0;q=a;f[q>>2]=f[p>>2];f[q+4>>2]=d;ZK(a+8|0,56824);u=r;return}f[q>>2]=0;f[q+4>>2]=0;f[q+8>>2]=0;Rj(a,2,100,q);if((b[q+11>>0]|0)>=0){u=r;return}QK(f[q>>2]|0);u=r;return}function Dh(a){a=a|0;var c=0,d=0,e=0,g=0,h=0,i=0;f[a>>2]=5196;i=a+16|0;f[i>>2]=5224;c=f[a+84>>2]|0;if(c|0){d=a+88|0;if((f[d>>2]|0)!=(c|0))f[d>>2]=c;QK(c)}c=a+72|0;if((b[c+11>>0]|0)<0)QK(f[c>>2]|0);f[i>>2]=4404;g=a+60|0;c=f[g>>2]|0;if(c|0){h=a+64|0;d=f[h>>2]|0;if((d|0)!=(c|0)){do{e=d+-8|0;f[h>>2]=e;d=f[d+-4>>2]|0;if(!d)d=e;else{KK(d);d=f[h>>2]|0}}while((d|0)!=(c|0));c=f[g>>2]|0}QK(c)}f[i>>2]=4264;c=f[a+40>>2]|0;if(!c){zK(a);return}d=a+44|0;if((f[d>>2]|0)!=(c|0))f[d>>2]=c;QK(c);zK(a);return}function Eh(a){a=a|0;Dh(a);QK(a);return}function Fh(a){a=a|0;a=a+16|0;dd[f[f[a>>2]>>2]&511](a);return}function Gh(a){a=a|0;QK(a);return}function Hh(a){a=a|0;var b=0,c=0,d=0,e=0,g=0;f[a>>2]=4404;e=a+44|0;b=f[e>>2]|0;if(b|0){g=a+48|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[a>>2]=4264;b=f[a+24>>2]|0;if(!b){QK(a);return}c=a+28|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);QK(a);return}function Ih(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;l=u;u=u+160|0;e=l+136|0;i=l;j=i+56|0;k=i+4|0;f[i>>2]=292;f[j>>2]=312;bB(i+56|0,k);f[i+128>>2]=0;f[i+132>>2]=-1;f[i>>2]=4304;f[j>>2]=4324;fB(k);f[k>>2]=4340;h=i+36|0;f[h>>2]=0;f[h+4>>2]=0;f[h+8>>2]=0;f[h+12>>2]=0;f[i+52>>2]=16;f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;ce(k,e);if((b[e+11>>0]|0)<0)QK(f[e>>2]|0);ve(e,c,d);g=e+11|0;m=b[g>>0]|0;n=m<<24>>24<0;de(i,n?f[e>>2]|0:e,n?f[e+4>>2]|0:m&255)|0;if((b[g>>0]|0)<0)QK(f[e>>2]|0);if((f[d>>2]|0)>0){e=0;do{de(i,18862,2)|0;e=e+1|0}while((e|0)<(f[d>>2]|0))}g=de(i,22025,13)|0;g=de(nB(g,f[c+56>>2]|0)|0,30204,1)|0;if((f[d>>2]|0)>0){e=0;do{de(g,18862,2)|0;e=e+1|0}while((e|0)<(f[d>>2]|0))}n=de(g,22039,14)|0;de(nB(n,f[c+60>>2]|0)|0,30204,1)|0;fe(a,k);f[i>>2]=4304;f[j>>2]=4324;f[k>>2]=4340;if((b[h+11>>0]|0)>=0){Rz(k);NA(i,4280);Mz(j);u=l;return}QK(f[h>>2]|0);Rz(k);NA(i,4280);Mz(j);u=l;return}function Jh(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0;e=u;u=u+32|0;g=e;h=f[d+12>>2]|0;Zd(d,b[c+36>>0]|0?12:8);Ud(d,f[c+56>>2]|0);Ud(d,f[c+60>>2]|0);ze(g,c,d,h);c=g+8|0;if((b[c+11>>0]|0)<0)QK(f[c>>2]|0);d=56816;g=f[d+4>>2]|0;h=a;f[h>>2]=f[d>>2];f[h+4>>2]=g;ZK(a+8|0,56824);u=e;return}function Kh(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0;h=u;u=u+32|0;e=h+20|0;g=h;Je(g,c,d);g=g+8|0;if((b[g+11>>0]|0)<0)QK(f[g>>2]|0);g=Id(d)|0;f[c+56>>2]=g;g=Id(d)|0;f[c+60>>2]=g;if(!(b[d+24>>0]|0)){d=56816;e=f[d+4>>2]|0;g=a;f[g>>2]=f[d>>2];f[g+4>>2]=e;ZK(a+8|0,56824);u=h;return}f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;Rj(a,2,100,e);if((b[e+11>>0]|0)>=0){u=h;return}QK(f[e>>2]|0);u=h;return}function Lh(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;f[a>>2]=5136;h=a+16|0;f[h>>2]=4404;e=a+60|0;b=f[e>>2]|0;if(b|0){g=a+64|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[h>>2]=4264;b=f[a+40>>2]|0;if(!b){zK(a);return}c=a+44|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);return}function Mh(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;f[a>>2]=5136;h=a+16|0;f[h>>2]=4404;e=a+60|0;b=f[e>>2]|0;if(b|0){g=a+64|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[h>>2]=4264;b=f[a+40>>2]|0;if(!b){zK(a);QK(a);return}c=a+44|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);QK(a);return}function Nh(a){a=a|0;a=a+16|0;dd[f[f[a>>2]>>2]&511](a);return}function Oh(a){a=a|0;QK(a);return}function Ph(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;f[a>>2]=5104;g=a+56|0;b=f[g>>2]|0;if(b|0){h=a+60|0;c=f[h>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-16|0;f[h>>2]=c;e=f[d+-12>>2]|0;if(e){c=d+-8|0;d=f[c>>2]|0;if((d|0)!=(e|0))f[c>>2]=d+(~((d+-4-e|0)>>>2)<<2);QK(e);c=f[h>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[g>>2]|0}QK(b)}f[a>>2]=4404;e=a+44|0;b=f[e>>2]|0;if(b|0){g=a+48|0;c=f[g>>2]|0;if((c|0)!=(b|0)){do{d=c+-8|0;f[g>>2]=d;c=f[c+-4>>2]|0;if(!c)c=d;else{KK(c);c=f[g>>2]|0}}while((c|0)!=(b|0));b=f[e>>2]|0}QK(b)}f[a>>2]=4264;c=f[a+24>>2]|0;if(!c)return;b=a+28|0;if((f[b>>2]|0)!=(c|0))f[b>>2]=c;QK(c);return}function Qh(a){a=a|0;Ph(a);QK(a);return}function Rh(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;o=u;u=u+160|0;g=o+136|0;l=o;m=l+56|0;n=l+4|0;f[l>>2]=292;f[m>>2]=312;bB(l+56|0,n);f[l+128>>2]=0;f[l+132>>2]=-1;f[l>>2]=4304;f[m>>2]=4324;fB(n);f[n>>2]=4340;k=l+36|0;f[k>>2]=0;f[k+4>>2]=0;f[k+8>>2]=0;f[k+12>>2]=0;f[l+52>>2]=16;f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;ce(n,g);if((b[g+11>>0]|0)<0)QK(f[g>>2]|0);ve(g,c,e);j=g+11|0;i=b[j>>0]|0;h=i<<24>>24<0;de(l,h?f[g>>2]|0:g,h?f[g+4>>2]|0:i&255)|0;if((b[j>>0]|0)<0)QK(f[g>>2]|0);g=f[c+56>>2]|0;j=f[c+60>>2]|0;if((g|0)!=(j|0)){i=g;g=f[e>>2]|0;do{if((g|0)>0){g=0;do{de(l,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}g=de(l,22139,26)|0;de(nB(g,f[i>>2]|0)|0,30204,1)|0;g=(f[e>>2]|0)+1|0;f[e>>2]=g;c=f[i+4>>2]|0;h=f[i+8>>2]|0;if((c|0)!=(h|0))do{if((g|0)>0){g=0;do{de(l,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}g=de(l,22166,16)|0;g=de(lB(g,d[c+2>>1]|0)|0,22183,13)|0;p=g+(f[(f[g>>2]|0)+-12>>2]|0)+4|0;f[p>>2]=f[p>>2]|1;de(kB(g,(b[c>>0]|0)!=0)|0,18904,2)|0;c=c+4|0;g=f[e>>2]|0}while((c|0)!=(h|0));g=(g|0)<1?0:g+-1|0;f[e>>2]=g;i=i+16|0}while((i|0)!=(j|0))}fe(a,n);f[l>>2]=4304;f[m>>2]=4324;f[n>>2]=4340;if((b[k+11>>0]|0)>=0){Rz(n);NA(l,4280);Mz(m);u=o;return}QK(f[k>>2]|0);Rz(n);NA(l,4280);Mz(m);u=o;return}function Sh(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=u;u=u+32|0;o=q;p=f[d+12>>2]|0;Zd(d,b[c+36>>0]|0?12:8);e=c+56|0;l=c+60|0;Ud(d,(f[l>>2]|0)-(f[e>>2]|0)>>4);e=f[e>>2]|0;l=f[l>>2]|0;if((e|0)!=(l|0)){m=c+37|0;n=c+40|0;do{g=f[e>>2]|0;if(!(b[m>>0]|0))Sd(d,g&65535);else Ud(d,g);g=e+4|0;k=e+8|0;Rd(d,((f[k>>2]|0)-(f[g>>2]|0)|0)>>>2&255);g=f[g>>2]|0;k=f[k>>2]|0;if((g|0)!=(k|0))do{h=(b[g>>0]|0)!=0;i=j[g+2>>1]|0;if(!(f[n>>2]&1))Rd(d,(i&127|(h?128:0))&255);else Sd(d,(i&32767|(h?32768:0))&65535);g=g+4|0}while((g|0)!=(k|0));e=e+16|0}while((e|0)!=(l|0))}ze(o,c,d,p);e=o+8|0;if((b[e+11>>0]|0)>=0){o=56816;d=o;d=f[d>>2]|0;o=o+4|0;o=f[o>>2]|0;p=a;n=p;f[n>>2]=d;p=p+4|0;f[p>>2]=o;a=a+8|0;ZK(a,56824);u=q;return}QK(f[e>>2]|0);o=56816;d=o;d=f[d>>2]|0;o=o+4|0;o=f[o>>2]|0;p=a;n=p;f[n>>2]=d;p=p+4|0;f[p>>2]=o;a=a+8|0;ZK(a,56824);u=q;return}function Th(a){a=a|0;var c=0,d=0,e=0,g=0,h=0,i=0;d=f[a+56>>2]|0;i=f[a+60>>2]|0;if((d|0)==(i|0)){g=0;h=0;i=a+37|0;b[i>>0]=g;h=h&1;i=a+40|0;f[i>>2]=h;return}else{c=0;h=0}do{h=(f[d>>2]|0)>>>0>65535?1:h;e=f[d+4>>2]|0;g=f[d+8>>2]|0;if((e|0)!=(g|0))do{c=c|(j[e+2>>1]|0)>127;e=e+4|0}while((e|0)!=(g|0));d=d+16|0}while((d|0)!=(i|0));g=h&255;h=c;i=a+37|0;b[i>>0]=g;h=h&1;i=a+40|0;f[i>>2]=h;return}function Uh(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;E=u;u=u+48|0;C=E+24|0;g=E+4|0;D=E;Je(g,c,e);g=g+8|0;if((b[g+11>>0]|0)<0)QK(f[g>>2]|0);q=Id(e)|0;r=e+24|0;a:do if((q|0)>0){s=e+16|0;t=C+4|0;v=C+8|0;w=C+12|0;x=c+37|0;y=c+60|0;z=c+64|0;A=c+56|0;B=C+4|0;n=c+40|0;o=D+2|0;p=C+12|0;m=0;while(1){if(b[r>>0]|0)break a;l=s;if((f[l>>2]|0)==0&(f[l+4>>2]|0)==0)break a;f[t>>2]=0;f[v>>2]=0;f[w>>2]=0;if(!(b[x>>0]|0))g=(Hd(e)|0)&65535;else g=Id(e)|0;f[C>>2]=g;l=Ed(e)|0;j=l&255;if(l<<24>>24){i=0;do{if(!(f[n>>2]&1)){h=Ed(e)|0;g=(h&255)>>>7;c=127;h=h&255}else{h=Hd(e)|0;g=(h&65535)>>>15&255;c=32767}b[D>>0]=g;d[o>>1]=h&65535&c;g=f[v>>2]|0;if((g|0)==(f[p>>2]|0))Wh(B,D);else{l=f[D>>2]|0;d[g>>1]=l;d[g+2>>1]=l>>>16;f[v>>2]=(f[v>>2]|0)+4}i=i+1|0}while((i|0)<(j|0))}h=f[y>>2]|0;if((h|0)==(f[z>>2]|0)){Vh(A,C);g=f[t>>2]|0}else{f[h>>2]=f[C>>2];i=h+4|0;f[i>>2]=0;l=h+8|0;f[l>>2]=0;f[h+12>>2]=0;g=f[B>>2]|0;c=(f[v>>2]|0)-g|0;j=c>>2;if(j){if(j>>>0>1073741823)break;k=OK(c)|0;f[l>>2]=k;f[i>>2]=k;f[h+12>>2]=k+(j<<2);g=f[B>>2]|0;c=(f[v>>2]|0)-g|0;if((c|0)>0){GM(k|0,g|0,c|0)|0;f[l>>2]=k+(c>>>2<<2)}}f[y>>2]=(f[y>>2]|0)+16}if(g|0){c=f[v>>2]|0;if((c|0)!=(g|0))f[v>>2]=c+(~((c+-4-g|0)>>>2)<<2);QK(g)}m=m+1|0;if((m|0)>=(q|0))break a}$I(i)}while(0);if(!(b[r>>0]|0)){e=56816;C=f[e+4>>2]|0;D=a;f[D>>2]=f[e>>2];f[D+4>>2]=C;ZK(a+8|0,56824);u=E;return}f[C>>2]=0;f[C+4>>2]=0;f[C+8>>2]=0;Rj(a,2,100,C);if((b[C+11>>0]|0)>=0){u=E;return}QK(f[C>>2]|0);u=E;return}function Vh(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;j=a+4|0;c=f[a>>2]|0;h=(f[j>>2]|0)-c>>4;d=h+1|0;if(d>>>0>268435455)$I(a);k=a+8|0;i=(f[k>>2]|0)-c|0;c=i>>3;c=i>>4>>>0<134217727?(c>>>0<d>>>0?d:c):268435455;do if(c)if(c>>>0>268435455){k=Ra(8)|0;VK(k,44736);f[k>>2]=17660;Va(k|0,4016,428)}else{g=OK(c<<4)|0;break}else g=0;while(0);d=g+(h<<4)|0;e=d;i=g+(c<<4)|0;f[d>>2]=f[b>>2];Xh(g+(h<<4)+4|0,b+4|0);b=d+16|0;g=f[a>>2]|0;c=f[j>>2]|0;if((c|0)==(g|0)){d=e;h=g;c=g}else{do{m=c;c=c+-16|0;f[d+-16>>2]=f[c>>2];l=d+-12|0;h=m+-12|0;f[l>>2]=0;n=d+-8|0;f[n>>2]=0;f[d+-4>>2]=0;f[l>>2]=f[h>>2];l=m+-8|0;f[n>>2]=f[l>>2];m=m+-4|0;f[d+-4>>2]=f[m>>2];f[m>>2]=0;f[l>>2]=0;f[h>>2]=0;d=e+-16|0;e=d}while((c|0)!=(g|0));d=e;h=f[a>>2]|0;c=f[j>>2]|0}f[a>>2]=d;f[j>>2]=b;f[k>>2]=i;b=h;if((c|0)!=(b|0))do{d=f[c+-12>>2]|0;if(d|0){e=c+-8|0;g=f[e>>2]|0;if((g|0)!=(d|0))f[e>>2]=g+(~((g+-4-d|0)>>>2)<<2);QK(d)}c=c+-16|0}while((c|0)!=(b|0));if(!h)return;QK(h);return}function Wh(a,b){a=a|0;b=b|0;var c=0,e=0,g=0,h=0,i=0,k=0,l=0,m=0,n=0,o=0;l=a+4|0;m=f[a>>2]|0;n=(f[l>>2]|0)-m|0;i=n>>2;c=i+1|0;o=m;if(c>>>0>1073741823)$I(a);k=a+8|0;h=(f[k>>2]|0)-m|0;e=h>>1;e=h>>2>>>0<536870911?(e>>>0<c>>>0?c:e):1073741823;do if(e)if(e>>>0>1073741823){o=Ra(8)|0;VK(o,44736);f[o>>2]=17660;Va(o|0,4016,428)}else{h=OK(e<<2)|0;break}else h=0;while(0);g=h+(i<<2)|0;c=j[b>>1]|j[b+2>>1]<<16;d[g>>1]=c;d[g+2>>1]=c>>>16;c=g+(0-i<<2)|0;if((n|0)>0)GM(c|0,o|0,n|0)|0;f[a>>2]=c;f[l>>2]=g+4;f[k>>2]=h+(e<<2);if(!m)return;QK(o);return}function Xh(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0;f[a>>2]=0;h=a+4|0;f[h>>2]=0;f[a+8>>2]=0;g=b+4|0;c=(f[g>>2]|0)-(f[b>>2]|0)|0;d=c>>2;if(!d)return;if(d>>>0>1073741823)$I(a);e=OK(c)|0;f[h>>2]=e;f[a>>2]=e;f[a+8>>2]=e+(d<<2);a=f[b>>2]|0;c=(f[g>>2]|0)-a|0;if((c|0)<=0)return;GM(e|0,a|0,c|0)|0;f[h>>2]=e+(c>>>2<<2);return}function Yh(a){a=a|0;f[a>>2]=5076;Ph(a+16|0);zK(a);return}function Zh(a){a=a|0;f[a>>2]=5076;Ph(a+16|0);zK(a);QK(a);return}function _h(a){a=a|0;a=a+16|0;dd[f[f[a>>2]>>2]&511](a);return}function $h(a){a=a|0;QK(a);return}function ai(a){a=a|0;var b=0,c=0,d=0,e=0,g=0;f[a>>2]=4404;e=a+44|0;b=f[e>>2]|0;if(b|0){g=a+48|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[a>>2]=4264;b=f[a+24>>2]|0;if(!b){QK(a);return}c=a+28|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);QK(a);return}function bi(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;k=u;u=u+160|0;g=k+136|0;h=k;i=h+56|0;j=h+4|0;f[h>>2]=292;f[i>>2]=312;bB(h+56|0,j);f[h+128>>2]=0;f[h+132>>2]=-1;f[h>>2]=4304;f[i>>2]=4324;fB(j);f[j>>2]=4340;e=h+36|0;f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;f[e+12>>2]=0;f[h+52>>2]=16;f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;ce(j,g);if((b[g+11>>0]|0)<0)QK(f[g>>2]|0);ve(g,c,d);l=g+11|0;m=b[l>>0]|0;n=m<<24>>24<0;de(h,n?f[g>>2]|0:g,n?f[g+4>>2]|0:m&255)|0;if((b[l>>0]|0)<0)QK(f[g>>2]|0);Uf(g,c,d);n=g+11|0;m=b[n>>0]|0;l=m<<24>>24<0;de(h,l?f[g>>2]|0:g,l?f[g+4>>2]|0:m&255)|0;if((b[n>>0]|0)<0)QK(f[g>>2]|0);fe(a,j);f[h>>2]=4304;f[i>>2]=4324;f[j>>2]=4340;if((b[e+11>>0]|0)>=0){Rz(j);NA(h,4280);Mz(i);u=k;return}QK(f[e>>2]|0);Rz(j);NA(h,4280);Mz(i);u=k;return}function ci(a,b,c){a=a|0;b=b|0;c=c|0;Ke(a,b,c,-1);return}function di(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;f[a>>2]=5016;h=a+16|0;f[h>>2]=4404;e=a+60|0;b=f[e>>2]|0;if(b|0){g=a+64|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[h>>2]=4264;b=f[a+40>>2]|0;if(!b){zK(a);return}c=a+44|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);return}function ei(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;f[a>>2]=5016;h=a+16|0;f[h>>2]=4404;e=a+60|0;b=f[e>>2]|0;if(b|0){g=a+64|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[h>>2]=4264;b=f[a+40>>2]|0;if(!b){zK(a);QK(a);return}c=a+44|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);QK(a);return}function fi(a){a=a|0;a=a+16|0;dd[f[f[a>>2]>>2]&511](a);return}function gi(a){a=a|0;QK(a);return}function hi(a){a=a|0;var b=0,c=0,d=0,e=0,g=0;f[a>>2]=4404;e=a+44|0;b=f[e>>2]|0;if(b|0){g=a+48|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[a>>2]=4264;b=f[a+24>>2]|0;if(!b){QK(a);return}c=a+28|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);QK(a);return}function ii(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;k=u;u=u+160|0;g=k+136|0;h=k;i=h+56|0;j=h+4|0;f[h>>2]=292;f[i>>2]=312;bB(h+56|0,j);f[h+128>>2]=0;f[h+132>>2]=-1;f[h>>2]=4304;f[i>>2]=4324;fB(j);f[j>>2]=4340;e=h+36|0;f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;f[e+12>>2]=0;f[h+52>>2]=16;f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;ce(j,g);if((b[g+11>>0]|0)<0)QK(f[g>>2]|0);ve(g,c,d);l=g+11|0;m=b[l>>0]|0;n=m<<24>>24<0;de(h,n?f[g>>2]|0:g,n?f[g+4>>2]|0:m&255)|0;if((b[l>>0]|0)<0)QK(f[g>>2]|0);Uf(g,c,d);n=g+11|0;m=b[n>>0]|0;l=m<<24>>24<0;de(h,l?f[g>>2]|0:g,l?f[g+4>>2]|0:m&255)|0;if((b[n>>0]|0)<0)QK(f[g>>2]|0);fe(a,j);f[h>>2]=4304;f[i>>2]=4324;f[j>>2]=4340;if((b[e+11>>0]|0)>=0){Rz(j);NA(h,4280);Mz(i);u=k;return}QK(f[e>>2]|0);Rz(j);NA(h,4280);Mz(i);u=k;return}function ji(a,b,c){a=a|0;b=b|0;c=c|0;Ke(a,b,c,-1);return}function ki(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;f[a>>2]=4956;h=a+16|0;f[h>>2]=4404;e=a+60|0;b=f[e>>2]|0;if(b|0){g=a+64|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[h>>2]=4264;b=f[a+40>>2]|0;if(!b){zK(a);return}c=a+44|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);return}function li(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;f[a>>2]=4956;h=a+16|0;f[h>>2]=4404;e=a+60|0;b=f[e>>2]|0;if(b|0){g=a+64|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[h>>2]=4264;b=f[a+40>>2]|0;if(!b){zK(a);QK(a);return}c=a+44|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);QK(a);return}function mi(a){a=a|0;a=a+16|0;dd[f[f[a>>2]>>2]&511](a);return}function ni(a){a=a|0;QK(a);return}function oi(a){a=a|0;var c=0,d=0,e=0,g=0,h=0;f[a>>2]=4924;c=a+112|0;if((b[c+11>>0]|0)<0)QK(f[c>>2]|0);c=a+100|0;if((b[c+11>>0]|0)<0)QK(f[c>>2]|0);c=a+88|0;if((b[c+11>>0]|0)<0)QK(f[c>>2]|0);c=a+76|0;if((b[c+11>>0]|0)<0)QK(f[c>>2]|0);c=a+64|0;if((b[c+11>>0]|0)<0)QK(f[c>>2]|0);f[a>>2]=4404;g=a+44|0;c=f[g>>2]|0;if(c|0){h=a+48|0;d=f[h>>2]|0;if((d|0)!=(c|0)){do{e=d+-8|0;f[h>>2]=e;d=f[d+-4>>2]|0;if(!d)d=e;else{KK(d);d=f[h>>2]|0}}while((d|0)!=(c|0));c=f[g>>2]|0}QK(c)}f[a>>2]=4264;d=f[a+24>>2]|0;if(!d)return;c=a+28|0;if((f[c>>2]|0)!=(d|0))f[c>>2]=d;QK(d);return}function pi(a){a=a|0;oi(a);QK(a);return}function qi(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;m=u;u=u+160|0;g=m+136|0;j=m;k=j+56|0;l=j+4|0;f[j>>2]=292;f[k>>2]=312;bB(j+56|0,l);f[j+128>>2]=0;f[j+132>>2]=-1;f[j>>2]=4304;f[k>>2]=4324;fB(l);f[l>>2]=4340;i=j+36|0;f[i>>2]=0;f[i+4>>2]=0;f[i+8>>2]=0;f[i+12>>2]=0;f[j+52>>2]=16;f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;ce(l,g);if((b[g+11>>0]|0)<0)QK(f[g>>2]|0);ve(g,c,e);h=g+11|0;n=b[h>>0]|0;o=n<<24>>24<0;de(j,o?f[g>>2]|0:g,o?f[g+4>>2]|0:n&255)|0;if((b[h>>0]|0)<0)QK(f[g>>2]|0);if((f[e>>2]|0)>0){g=0;do{de(j,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}h=de(j,22462,9)|0;h=de(nB(h,f[c+56>>2]|0)|0,30204,1)|0;if((f[e>>2]|0)>0){g=0;do{de(h,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}h=de(h,22472,23)|0;h=de(lB(h,d[c+60>>1]|0)|0,30204,1)|0;if((f[e>>2]|0)>0){g=0;do{de(h,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}g=de(h,22496,11)|0;n=c+64|0;h=b[n+11>>0]|0;o=h<<24>>24<0;h=de(de(g,o?f[n>>2]|0:n,o?f[c+68>>2]|0:h&255)|0,30204,1)|0;if((f[e>>2]|0)>0){g=0;do{de(h,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}g=de(h,22508,11)|0;n=c+76|0;h=b[n+11>>0]|0;o=h<<24>>24<0;h=de(de(g,o?f[n>>2]|0:n,o?f[c+80>>2]|0:h&255)|0,30204,1)|0;if((f[e>>2]|0)>0){g=0;do{de(h,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}g=de(h,22520,14)|0;n=c+88|0;h=b[n+11>>0]|0;o=h<<24>>24<0;h=de(de(g,o?f[n>>2]|0:n,o?f[c+92>>2]|0:h&255)|0,30204,1)|0;if((f[e>>2]|0)>0){g=0;do{de(h,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}g=de(h,22535,18)|0;n=c+100|0;h=b[n+11>>0]|0;o=h<<24>>24<0;h=de(de(g,o?f[n>>2]|0:n,o?f[c+104>>2]|0:h&255)|0,30204,1)|0;if((f[e>>2]|0)>0){g=0;do{de(h,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}g=de(h,22554,15)|0;n=c+112|0;h=b[n+11>>0]|0;o=h<<24>>24<0;h=de(de(g,o?f[n>>2]|0:n,o?f[c+116>>2]|0:h&255)|0,30204,1)|0;if((f[e>>2]|0)>0){g=0;do{de(h,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}o=de(h,22570,13)|0;n=o+(f[(f[o>>2]|0)+-12>>2]|0)+4|0;f[n>>2]=f[n>>2]|1;de(kB(o,(b[c+124>>0]|0)!=0)|0,30204,1)|0;fe(a,l);f[j>>2]=4304;f[k>>2]=4324;f[l>>2]=4340;if((b[i+11>>0]|0)>=0){Rz(l);NA(j,4280);Mz(k);u=m;return}QK(f[i>>2]|0);Rz(l);NA(j,4280);Mz(k);u=m;return}function ri(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;o=u;u=u+32|0;m=o;n=f[e+12>>2]|0;Zd(e,b[c+36>>0]|0?12:8);i=c+37|0;g=b[i>>0]|0;if((g&255)<2){Sd(e,f[c+56>>2]&65535);Sd(e,d[c+60>>1]|0);Xd(e,c+76|0);Xd(e,c+88|0);Xd(e,c+100|0);g=b[i>>0]|0;if((g&255)>1)j=3}else j=3;a:do if((j|0)==3){switch(g<<24>>24){case 2:{Sd(e,f[c+56>>2]&65535);break}case 3:{Ud(e,f[c+56>>2]|0);break}default:{}}Sd(e,d[c+60>>1]|0);l=c+64|0;k=l+11|0;g=b[k>>0]|0;i=g<<24>>24<0;if(i)g=f[c+68>>2]|0;else g=g&255;if(!g)Ud(e,0);else{if(i)g=f[l>>2]|0;else g=l;Ud(e,b[g+1>>0]<<16|h[g>>0]<<24|b[g+2>>0]<<8|b[g+3>>0])}Xd(e,c+76|0);i=b[k>>0]|0;j=c+68|0;g=f[j>>2]|0;do if(((i<<24>>24<0?g:i&255)|0)==4)if(!(kL(l,0,-1,22452,4)|0)){Xd(e,c+88|0);Xd(e,c+100|0);break a}else{i=b[k>>0]|0;g=f[j>>2]|0;break}while(0);if(((i<<24>>24<0?g:i&255)|0)==4?(kL(l,0,-1,22457,4)|0)==0:0)Xd(e,c+112|0)}while(0);ze(m,c,e,n);g=m+8|0;if((b[g+11>>0]|0)>=0){m=56816;c=m;c=f[c>>2]|0;m=m+4|0;m=f[m>>2]|0;n=a;e=n;f[e>>2]=c;n=n+4|0;f[n>>2]=m;a=a+8|0;ZK(a,56824);u=o;return}QK(f[g>>2]|0);m=56816;c=m;c=f[c>>2]|0;m=m+4|0;m=f[m>>2]|0;n=a;e=n;f[e>>2]=c;n=n+4|0;f[n>>2]=m;a=a+8|0;ZK(a,56824);u=o;return}function si(a){a=a|0;var c=0,d=0,e=0,g=0;d=(f[a+56>>2]|0)>>>0>65535;c=d?3:(b[a+124>>0]|0)==0?0:2;e=a+64|0;g=b[e+11>>0]|0;if(((g<<24>>24<0?f[a+68>>2]|0:g&255)|0)==0?(g=(kL(e,0,-1,79883,0)|0)==0,g):0){e=c;e=e&255;g=a+37|0;b[g>>0]=e;return}else c=d?3:2;e=c;e=e&255;g=a+37|0;b[g>>0]=e;return}function ti(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0;l=u;u=u+32|0;k=l+20|0;g=l;Je(g,c,e);g=g+8|0;if((b[g+11>>0]|0)<0)QK(f[g>>2]|0);i=c+37|0;g=b[i>>0]|0;if((g&255)<2){g=(Hd(e)|0)&65535;f[c+56>>2]=g;g=Hd(e)|0;d[c+60>>1]=g;Jd(k,e);g=c+76|0;h=g+11|0;if((b[h>>0]|0)<0){b[f[g>>2]>>0]=0;f[c+80>>2]=0}else{b[g>>0]=0;b[h>>0]=0}dL(g,0);f[g>>2]=f[k>>2];f[g+4>>2]=f[k+4>>2];f[g+8>>2]=f[k+8>>2];Jd(k,e);g=c+88|0;h=g+11|0;if((b[h>>0]|0)<0){b[f[g>>2]>>0]=0;f[c+92>>2]=0}else{b[g>>0]=0;b[h>>0]=0}dL(g,0);f[g>>2]=f[k>>2];f[g+4>>2]=f[k+4>>2];f[g+8>>2]=f[k+8>>2];Jd(k,e);g=c+100|0;h=g+11|0;if((b[h>>0]|0)<0){b[f[g>>2]>>0]=0;f[c+104>>2]=0}else{b[g>>0]=0;b[h>>0]=0}dL(g,0);f[g>>2]=f[k>>2];f[g+4>>2]=f[k+4>>2];f[g+8>>2]=f[k+8>>2];g=b[i>>0]|0;if((g&255)>1)j=14}else j=14;a:do if((j|0)==14){b[c+124>>0]=f[c+40>>2]&1;if(g<<24>>24==2)g=(Hd(e)|0)&65535;else g=Id(e)|0;f[c+56>>2]=g;j=Hd(e)|0;d[c+60>>1]=j;j=Id(e)|0;if(j|0){b[k>>0]=0;b[k+1>>0]=0;b[k+2>>0]=0;b[k+3>>0]=0;b[k+4>>0]=0;b[k+5>>0]=0;g=FM(j|0)|0;h=c+64|0;i=h+11|0;if((b[i>>0]|0)<0){b[f[h>>2]>>0]=0;f[c+68>>2]=0}else{b[h>>0]=0;b[i>>0]=0}dL(h,0);f[c+64>>2]=g;b[c+68>>0]=0;i=c+69|0;b[i>>0]=b[k>>0]|0;b[i+1>>0]=b[k+1>>0]|0;b[i+2>>0]=b[k+2>>0]|0;b[i+3>>0]=b[k+3>>0]|0;b[i+4>>0]=b[k+4>>0]|0;b[i+5>>0]=b[k+5>>0]|0;b[c+75>>0]=4}Jd(k,e);g=c+76|0;h=g+11|0;if((b[h>>0]|0)<0){b[f[g>>2]>>0]=0;f[c+80>>2]=0}else{b[g>>0]=0;b[h>>0]=0}dL(g,0);f[g>>2]=f[k>>2];f[g+4>>2]=f[k+4>>2];f[g+8>>2]=f[k+8>>2];if((j|0)>=1970432288){switch(j|0){case 1970432288:break;default:break a}Jd(k,e);g=c+112|0;h=g+11|0;if((b[h>>0]|0)<0){b[f[g>>2]>>0]=0;f[c+116>>2]=0}else{b[g>>0]=0;b[h>>0]=0}dL(g,0);f[g>>2]=f[k>>2];f[g+4>>2]=f[k+4>>2];f[g+8>>2]=f[k+8>>2];break}switch(j|0){case 1835625829:break;default:break a}Jd(k,e);g=c+88|0;h=g+11|0;if((b[h>>0]|0)<0){b[f[g>>2]>>0]=0;f[c+92>>2]=0}else{b[g>>0]=0;b[h>>0]=0}dL(g,0);f[g>>2]=f[k>>2];f[g+4>>2]=f[k+4>>2];f[g+8>>2]=f[k+8>>2];Jd(k,e);g=c+100|0;h=g+11|0;if((b[h>>0]|0)<0){b[f[g>>2]>>0]=0;f[c+104>>2]=0}else{b[g>>0]=0;b[h>>0]=0}dL(g,0);f[g>>2]=f[k>>2];f[g+4>>2]=f[k+4>>2];f[g+8>>2]=f[k+8>>2]}while(0);if(!(b[e+24>>0]|0)){c=56816;e=f[c+4>>2]|0;k=a;f[k>>2]=f[c>>2];f[k+4>>2]=e;ZK(a+8|0,56824);u=l;return}f[k>>2]=0;f[k+4>>2]=0;f[k+8>>2]=0;Rj(a,2,100,k);if((b[k+11>>0]|0)>=0){u=l;return}QK(f[k>>2]|0);u=l;return}function ui(a){a=a|0;f[a>>2]=4896;oi(a+16|0);zK(a);return}function vi(a){a=a|0;f[a>>2]=4896;oi(a+16|0);zK(a);QK(a);return}function wi(a){a=a|0;a=a+16|0;dd[f[f[a>>2]>>2]&511](a);return}function xi(a){a=a|0;QK(a);return}function yi(a){a=a|0;var b=0,c=0,d=0,e=0,g=0;f[a>>2]=4404;e=a+44|0;b=f[e>>2]|0;if(b|0){g=a+48|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[a>>2]=4264;b=f[a+24>>2]|0;if(!b){QK(a);return}c=a+28|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);QK(a);return}function zi(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;k=u;u=u+160|0;g=k+136|0;h=k;i=h+56|0;j=h+4|0;f[h>>2]=292;f[i>>2]=312;bB(h+56|0,j);f[h+128>>2]=0;f[h+132>>2]=-1;f[h>>2]=4304;f[i>>2]=4324;fB(j);f[j>>2]=4340;e=h+36|0;f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;f[e+12>>2]=0;f[h+52>>2]=16;f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;ce(j,g);if((b[g+11>>0]|0)<0)QK(f[g>>2]|0);ve(g,c,d);l=g+11|0;m=b[l>>0]|0;n=m<<24>>24<0;de(h,n?f[g>>2]|0:g,n?f[g+4>>2]|0:m&255)|0;if((b[l>>0]|0)<0)QK(f[g>>2]|0);Uf(g,c,d);n=g+11|0;m=b[n>>0]|0;l=m<<24>>24<0;de(h,l?f[g>>2]|0:g,l?f[g+4>>2]|0:m&255)|0;if((b[n>>0]|0)<0)QK(f[g>>2]|0);fe(a,j);f[h>>2]=4304;f[i>>2]=4324;f[j>>2]=4340;if((b[e+11>>0]|0)>=0){Rz(j);NA(h,4280);Mz(i);u=k;return}QK(f[e>>2]|0);Rz(j);NA(h,4280);Mz(i);u=k;return}function Ai(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;m=u;u=u+32|0;j=m;k=f[d+12>>2]|0;Zd(d,b[c+36>>0]|0?12:8);h=c+48|0;Wd(d,b[c+37>>0]|0?4:2,(f[h>>2]|0)-(f[c+44>>2]|0)>>3,0);g=f[c+44>>2]|0;h=f[h>>2]|0;a:do if((g|0)==(h|0)){e=a+8|0;l=8}else{e=a+8|0;i=e+11|0;while(1){n=f[g>>2]|0;fd[f[(f[n>>2]|0)+12>>2]&127](a,n,d);if(f[a>>2]|0)break a;if((b[i>>0]|0)<0)QK(f[e>>2]|0);g=g+8|0;if((g|0)==(h|0)){l=8;break}}}while(0);if((l|0)==8){i=56816;l=f[i+4>>2]|0;n=a;f[n>>2]=f[i>>2];f[n+4>>2]=l;ZK(e,56824)}ze(j,c,d,k);e=j+8|0;if((b[e+11>>0]|0)>=0){u=m;return}QK(f[e>>2]|0);u=m;return}function Bi(a){a=a|0;b[a+37>>0]=(f[a+48>>2]|0)-(f[a+44>>2]|0)>>3>>>0>65535&1;return}function Ci(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0;g=u;u=u+32|0;e=g;Je(e,c,d);e=e+8|0;if((b[e+11>>0]|0)<0)QK(f[e>>2]|0);if(!(b[c+37>>0]|0))e=(Hd(d)|0)&65535;else e=Id(d)|0;if(!e){e=56816;c=f[e+4>>2]|0;d=a;f[d>>2]=f[e>>2];f[d+4>>2]=c;ZK(a+8|0,56824);u=g;return}else{Ke(a,c,d,-1);u=g;return}}function Di(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;f[a>>2]=4836;h=a+16|0;f[h>>2]=4404;e=a+60|0;b=f[e>>2]|0;if(b|0){g=a+64|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[h>>2]=4264;b=f[a+40>>2]|0;if(!b){zK(a);return}c=a+44|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);return}function Ei(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;f[a>>2]=4836;h=a+16|0;f[h>>2]=4404;e=a+60|0;b=f[e>>2]|0;if(b|0){g=a+64|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[h>>2]=4264;b=f[a+40>>2]|0;if(!b){zK(a);QK(a);return}c=a+44|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);QK(a);return}function Fi(a){a=a|0;a=a+16|0;dd[f[f[a>>2]>>2]&511](a);return}function Gi(a){a=a|0;QK(a);return}function Hi(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0;f[a>>2]=4804;j=a+56|0;b=f[j>>2]|0;if(b|0){k=a+60|0;c=f[k>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-32|0;f[k>>2]=c;i=d+-16|0;h=f[i>>2]|0;if(h){g=d+-12|0;c=f[g>>2]|0;if((c|0)==(h|0))c=h;else{do{d=c+-40|0;f[g>>2]=d;e=f[c+-16>>2]|0;if(!e)c=d;else{c=c+-12|0;if((f[c>>2]|0)!=(e|0))f[c>>2]=e;QK(e);c=f[g>>2]|0}}while((c|0)!=(h|0));c=f[i>>2]|0}QK(c);c=f[k>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[j>>2]|0}QK(b)}f[a>>2]=4404;e=a+44|0;b=f[e>>2]|0;if(b|0){g=a+48|0;c=f[g>>2]|0;if((c|0)!=(b|0)){do{d=c+-8|0;f[g>>2]=d;c=f[c+-4>>2]|0;if(!c)c=d;else{KK(c);c=f[g>>2]|0}}while((c|0)!=(b|0));b=f[e>>2]|0}QK(b)}f[a>>2]=4264;c=f[a+24>>2]|0;if(!c)return;b=a+28|0;if((f[b>>2]|0)!=(c|0))f[b>>2]=c;QK(c);return}function Ii(a){a=a|0;Hi(a);QK(a);return}function Ji(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;o=u;u=u+160|0;g=o+136|0;l=o;m=l+56|0;n=l+4|0;f[l>>2]=292;f[m>>2]=312;bB(l+56|0,n);f[l+128>>2]=0;f[l+132>>2]=-1;f[l>>2]=4304;f[m>>2]=4324;fB(n);f[n>>2]=4340;k=l+36|0;f[k>>2]=0;f[k+4>>2]=0;f[k+8>>2]=0;f[k+12>>2]=0;f[l+52>>2]=16;f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;ce(n,g);if((b[g+11>>0]|0)<0)QK(f[g>>2]|0);ve(g,c,e);j=g+11|0;i=b[j>>0]|0;p=i<<24>>24<0;de(l,p?f[g>>2]|0:g,p?f[g+4>>2]|0:i&255)|0;if((b[j>>0]|0)<0)QK(f[g>>2]|0);g=f[c+56>>2]|0;j=f[c+60>>2]|0;if((g|0)!=(j|0)){i=g;do{if((f[e>>2]|0)>0){g=0;do{de(l,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}c=de(l,22885,9)|0;c=de(nB(c,f[i>>2]|0)|0,30204,1)|0;if((f[e>>2]|0)>0){g=0;do{de(c,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}c=de(c,22895,23)|0;c=de(mB(c,h[i+4>>0]|0)|0,30204,1)|0;if((f[e>>2]|0)>0){g=0;do{de(c,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}c=de(c,22919,24)|0;p=c+(f[(f[c>>2]|0)+-12>>2]|0)+4|0;f[p>>2]=f[p>>2]&-75|8;c=lB(c,d[i+6>>1]|0)|0;p=c+(f[(f[c>>2]|0)+-12>>2]|0)+4|0;f[p>>2]=f[p>>2]&-75|2;c=de(c,30204,1)|0;if((f[e>>2]|0)>0){g=0;do{de(c,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}c=de(c,22944,15)|0;p=i+8|0;de(oB(c,f[p>>2]|0,f[p+4>>2]|0)|0,30204,1)|0;if((f[e>>2]|0)>0){g=0;do{de(l,18862,2)|0;g=g+1|0}while((g|0)<(f[e>>2]|0))}de(l,22960,11)|0;g=f[i+16>>2]|0;c=f[i+20>>2]|0;if((g|0)!=(c|0))do{q=g+8|0;q=de(oB(l,f[q>>2]|0,f[q+4>>2]|0)|0,19588,1)|0;p=g+16|0;oB(q,f[p>>2]|0,f[p+4>>2]|0)|0;p=g;if(!((f[p>>2]|0)==0&(f[p+4>>2]|0)==0)){p=de(l,22972,7)|0;q=g;oB(p,f[q>>2]|0,f[q+4>>2]|0)|0}de(l,20449,1)|0;g=g+40|0}while((g|0)!=(c|0));de(l,30204,1)|0;i=i+32|0}while((i|0)!=(j|0))}fe(a,n);f[l>>2]=4304;f[m>>2]=4324;f[n>>2]=4340;if((b[k+11>>0]|0)>=0){Rz(n);NA(l,4280);Mz(m);u=o;return}QK(f[k>>2]|0);Rz(n);NA(l,4280);Mz(m);u=o;return}function Ki(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0;A=u;u=u+32|0;z=A;q=c+56|0;i=f[q>>2]|0;r=c+60|0;m=f[r>>2]|0;if((i|0)!=(m|0)){e=0;do{if((b[i+4>>0]|0)==1?(k=f[i+16>>2]|0,l=f[i+20>>2]|0,(k|0)!=(l|0)):0){j=k;do{e=(f[j+28>>2]|0)+e-(f[j+24>>2]|0)|0;j=j+40|0}while((j|0)!=(l|0))}i=i+32|0}while((i|0)!=(m|0));if(e|0?(Ud(d,e+8|0),Ud(d,1768186228),g=f[q>>2]|0,n=f[r>>2]|0,(g|0)!=(n|0)):0)do{if((b[g+4>>0]|0)==1?(o=f[g+16>>2]|0,p=f[g+20>>2]|0,(o|0)!=(p|0)):0){e=o;do{Yd(d,e+24|0);e=e+40|0}while((e|0)!=(p|0))}g=g+32|0}while((g|0)!=(n|0))}j=d+12|0;y=f[j>>2]|0;Zd(d,b[c+36>>0]|0?12:8);f[c+68>>2]=f[j>>2];j=b[c+37>>0]|0;g=(j&255)<2;e=g?4:6;i=f[q>>2]|0;x=f[r>>2]|0;if((i|0)!=(x|0)){p=g?2:4;q=j<<24>>24?2:0;r=h[c+75>>0]|0;s=c+73|0;t=c+74|0;v=c+76|0;w=p+q+r+4|0;g=j;do{l=e+4+r+p+q|0;j=f[i+16>>2]|0;k=j;o=f[i+20>>2]|0;do if((j|0)==(o|0))e=l;else{m=h[s>>0]|0;n=h[t>>0]|0;if(!(g<<24>>24)){e=w+e+(X(((o+-40-k|0)>>>0)/40|0,m+n|0)|0)+m+n|0;g=0;break}k=h[v>>0]|0;e=l;do{e=m+(k+e)+n|0;j=j+40|0}while((j|0)!=(o|0))}while(0);i=i+32|0}while((i|0)!=(x|0))}Zd(d,e);ze(z,c,d,y);e=z+8|0;if((b[e+11>>0]|0)>=0){d=56816;y=d;y=f[y>>2]|0;d=d+4|0;d=f[d>>2]|0;z=a;c=z;f[c>>2]=y;z=z+4|0;f[z>>2]=d;a=a+8|0;ZK(a,56824);u=A;return}QK(f[e>>2]|0);d=56816;y=d;y=f[y>>2]|0;d=d+4|0;d=f[d>>2]|0;z=a;c=z;f[c>>2]=y;z=z+4|0;f[z>>2]=d;a=a+8|0;ZK(a,56824);u=A;return}function Li(a){a=a|0;var c=0,d=0,e=0,g=0,i=0,j=0,k=0;c=h[a+72>>0]|0;e=f[a+60>>2]|0;d=f[a+56>>2]|0;c=e-d>>5>>>0>65535?(c>>>0>2?c:2):c;g=a+73|0;i=a+74|0;j=a+75|0;k=a+76|0;b[g>>0]=0;b[g+1>>0]=0;b[g+2>>0]=0;b[g+3>>0]=0;if((d|0)==(e|0)){e=c;b[g>>0]=4;b[i>>0]=4;b[j>>0]=4;b[k>>0]=0;j=e&255;k=a+37|0;b[k>>0]=j;return}do{c=(f[d>>2]|0)>>>0>65535?((c|0)>2?c:2):c;c=(b[d+4>>0]|0)==0|(c|0)>1?c:1;d=d+32|0}while((d|0)!=(e|0));b[g>>0]=4;b[i>>0]=4;b[j>>0]=4;b[k>>0]=0;j=c&255;k=a+37|0;b[k>>0]=j;return}function Mi(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0;ea=u;u=u+384|0;ca=ea+144|0;g=ea+352|0;da=ea;k=ea+340|0;_=ea+184|0;$=ea+328|0;Je(g,c,e);g=g+8|0;if((b[g+11>>0]|0)<0)QK(f[g>>2]|0);i=Hd(e)|0;Y=c+37|0;ba=b[Y>>0]|0;g=(ba&255)>1?i&15:0;if((ba&255)<2)ba=(Hd(e)|0)&65535;else ba=Id(e)|0;if((ba|0)>2e4){c=da+64|0;j=da+8|0;f[j>>2]=4524;i=da+12|0;f[da>>2]=188;f[c>>2]=208;f[da+4>>2]=0;bB(da+64|0,i);f[da+136>>2]=0;f[da+140>>2]=-1;f[da>>2]=4504;f[c>>2]=4544;f[j>>2]=4524;fB(i);f[i>>2]=4340;j=da+44|0;f[j>>2]=0;f[j+4>>2]=0;f[j+8>>2]=0;f[j+12>>2]=0;f[da+60>>2]=24;f[ca>>2]=0;f[ca+4>>2]=0;f[ca+8>>2]=0;ce(i,ca);if((b[ca+11>>0]|0)<0)QK(f[ca>>2]|0);g=da+8|0;de(mB(de(mB(de(g,22754,18)|0,ba)|0,22773,44)|0,2e4)|0,22818,7)|0;fe(k,i);Rj(a,6,1e3,k);if((b[k+11>>0]|0)<0)QK(f[k>>2]|0);f[da>>2]=4504;f[c>>2]=4544;f[g>>2]=4524;f[i>>2]=4340;if((b[j+11>>0]|0)<0)QK(f[j>>2]|0);Rz(i);ZA(da,4556);Mz(c);u=ea;return}a:do if((ba|0)>0){C=da+4|0;D=da+6|0;E=da+8|0;X=(i&65535)>>>4&255;F=_+64|0;G=_+8|0;H=_+12|0;I=_+4|0;J=_+64|0;K=_+136|0;L=_+140|0;M=_+44|0;N=_+60|0;O=ca+11|0;P=_+8|0;Q=$+11|0;R=M+11|0;S=da+16|0;T=da+20|0;U=e+24|0;V=c+60|0;W=c+64|0;z=c+56|0;A=da+16|0;B=(g|0)!=0;y=g&255;v=ca+8|0;x=(i&65535)>>>12&255;w=ca+16|0;t=(i&65535)>>>8&255;p=da+24|0;q=ca+24|0;r=ca+28|0;s=ca+24|0;o=0;b:while(1){f[da>>2]=0;b[C>>0]=0;g=D;c=g+22|0;do{d[g>>1]=0;g=g+2|0}while((g|0)<(c|0));if((h[Y>>0]|0)<2)g=(Hd(e)|0)&65535;else g=Id(e)|0;f[da>>2]=g;if(b[Y>>0]|0){n=(Hd(e)|0)&15;b[C>>0]=n}n=Hd(e)|0;d[D>>1]=n;n=E;f[n>>2]=0;f[n+4>>2]=0;switch(X&15){case 4:{g=Id(e)|0;c=0;aa=26;break}case 8:{g=Id(e)|0;c=E;f[c>>2]=0;f[c+4>>2]=g;c=E;g=Id(e)|0|f[c>>2];c=f[c+4>>2]|0;aa=26;break}default:{}}if((aa|0)==26){aa=0;n=E;f[n>>2]=g;f[n+4>>2]=c}g=Hd(e)|0;n=g&65535;do if((g&65535)<=32){c:do if(g<<16>>16){m=0;while(1){g=ca;c=g+36|0;do{f[g>>2]=0;g=g+4|0}while((g|0)<(c|0));d:do if(B&(h[Y>>0]|0)>1)switch(y&15){case 4:{k=Id(e)|0;l=ca;f[l>>2]=k;f[l+4>>2]=0;break d}case 8:{i=Id(e)|0;j=ca;f[j>>2]=0;f[j+4>>2]=i;j=Id(e)|0;i=ca;k=f[i+4>>2]|0;l=ca;f[l>>2]=f[i>>2]|j;f[l+4>>2]=k;break d}default:break d}while(0);l=v;f[l>>2]=0;f[l+4>>2]=0;switch(x&15){case 4:{g=Id(e)|0;c=0;aa=44;break}case 8:{g=Id(e)|0;c=v;f[c>>2]=0;f[c+4>>2]=g;c=v;g=Id(e)|0|f[c>>2];c=f[c+4>>2]|0;aa=44;break}default:{}}if((aa|0)==44){aa=0;l=v;f[l>>2]=g;f[l+4>>2]=c}l=w;f[l>>2]=0;f[l+4>>2]=0;switch(t&15){case 4:{g=Id(e)|0;c=0;aa=48;break}case 8:{g=Id(e)|0;c=w;f[c>>2]=0;f[c+4>>2]=g;c=w;g=Id(e)|0|f[c>>2];c=f[c+4>>2]|0;aa=48;break}default:{}}if((aa|0)==48){aa=0;l=w;f[l>>2]=g;f[l+4>>2]=c}c=f[T>>2]|0;if((c|0)==(f[p>>2]|0)){Ni(A,ca);g=f[q>>2]|0}else{f[c>>2]=f[ca>>2];f[c+4>>2]=f[ca+4>>2];f[c+8>>2]=f[ca+8>>2];f[c+12>>2]=f[ca+12>>2];f[c+16>>2]=f[ca+16>>2];f[c+20>>2]=f[ca+20>>2];i=c+24|0;f[i>>2]=0;l=c+28|0;f[l>>2]=0;f[c+32>>2]=0;g=f[s>>2]|0;j=(f[r>>2]|0)-g|0;if(j){if((j|0)<0){aa=52;break b}k=OK(j)|0;f[l>>2]=k;f[i>>2]=k;f[c+32>>2]=k+j;g=f[s>>2]|0;c=(f[r>>2]|0)-g|0;if((c|0)>0){GM(k|0,g|0,c|0)|0;f[l>>2]=k+c}}f[T>>2]=(f[T>>2]|0)+40}if(g|0){if((f[r>>2]|0)!=(g|0))f[r>>2]=g;QK(g)}m=m+1|0;if((m|0)>=(n|0))break c}}while(0);if(!(b[U>>0]|0)){g=f[V>>2]|0;if((g|0)==(f[W>>2]|0)){Pi(z,da);k=0;break}else{f[g>>2]=f[da>>2];f[g+4>>2]=f[da+4>>2];f[g+8>>2]=f[da+8>>2];f[g+12>>2]=f[da+12>>2];Oi(g+16|0,A);f[V>>2]=(f[V>>2]|0)+32;k=0;break}}else k=0}else{f[G>>2]=4524;f[_>>2]=188;f[F>>2]=208;f[I>>2]=0;bB(J,H);f[K>>2]=0;f[L>>2]=-1;f[_>>2]=4504;f[F>>2]=4544;f[G>>2]=4524;fB(H);f[H>>2]=4340;f[M>>2]=0;f[M+4>>2]=0;f[M+8>>2]=0;f[M+12>>2]=0;f[N>>2]=24;f[ca>>2]=0;f[ca+4>>2]=0;f[ca+8>>2]=0;ce(H,ca);if((b[O>>0]|0)<0)QK(f[ca>>2]|0);de(mB(de(mB(de(P,22826,31)|0,n)|0,22858,26)|0,32)|0,18904,2)|0;fe($,H);Rj(a,6,1e3,$);if((b[Q>>0]|0)<0)QK(f[$>>2]|0);f[_>>2]=4504;f[F>>2]=4544;f[P>>2]=4524;f[H>>2]=4340;if((b[R>>0]|0)<0)QK(f[M>>2]|0);Rz(H);ZA(_,4556);Mz(F);k=1}while(0);g=f[S>>2]|0;if(g|0){c=f[T>>2]|0;if((c|0)!=(g|0)){do{i=c+-40|0;f[T>>2]=i;j=f[c+-16>>2]|0;if(!j)c=i;else{c=c+-12|0;if((f[c>>2]|0)!=(j|0))f[c>>2]=j;QK(j);c=f[T>>2]|0}}while((c|0)!=(g|0));g=f[S>>2]|0}QK(g)}o=o+1|0;if(k|0){aa=80;break}if((o|0)>=(ba|0)){Z=U;break a}}if((aa|0)==52)$I(i);else if((aa|0)==80){u=ea;return}}else Z=e+24|0;while(0);if(b[Z>>0]|0){f[ca>>2]=0;f[ca+4>>2]=0;f[ca+8>>2]=0;Rj(a,2,100,ca);if((b[ca+11>>0]|0)<0)QK(f[ca>>2]|0)}else{ba=56816;ca=f[ba+4>>2]|0;da=a;f[da>>2]=f[ba>>2];f[da+4>>2]=ca;ZK(a+8|0,56824)}u=ea;return}function Ni(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;p=a+4|0;m=f[p>>2]|0;d=f[a>>2]|0;l=(m-d|0)/40|0;e=l+1|0;c=d;g=m;if(e>>>0>107374182)$I(a);o=a+8|0;n=((f[o>>2]|0)-d|0)/40|0;h=n<<1;h=n>>>0<53687091?(h>>>0<e>>>0?e:h):107374182;do if(h)if(h>>>0>107374182){p=Ra(8)|0;VK(p,44736);f[p>>2]=17660;Va(p|0,4016,428)}else{k=OK(h*40|0)|0;break}else k=0;while(0);d=k+(l*40|0)|0;e=d;n=k+(h*40|0)|0;f[d>>2]=f[b>>2];f[d+4>>2]=f[b+4>>2];f[d+8>>2]=f[b+8>>2];f[d+12>>2]=f[b+12>>2];f[d+16>>2]=f[b+16>>2];f[d+20>>2]=f[b+20>>2];i=k+(l*40|0)+24|0;f[i>>2]=0;j=k+(l*40|0)+28|0;f[j>>2]=0;f[k+(l*40|0)+32>>2]=0;q=f[b+24>>2]|0;h=(f[b+28>>2]|0)-q|0;b=q;do if(h|0)if((h|0)<0)$I(i);else{r=OK(h)|0;f[j>>2]=r;f[i>>2]=r;q=r+h|0;f[k+(l*40|0)+32>>2]=q;GM(r|0,b|0,h|0)|0;f[j>>2]=q;break}while(0);b=d+40|0;if((g|0)==(c|0))h=m;else{do{q=d+-40|0;m=g;g=g+-40|0;f[q>>2]=f[g>>2];f[q+4>>2]=f[g+4>>2];f[q+8>>2]=f[g+8>>2];f[q+12>>2]=f[g+12>>2];f[q+16>>2]=f[g+16>>2];f[q+20>>2]=f[g+20>>2];q=d+-16|0;r=m+-16|0;f[q>>2]=0;l=d+-12|0;f[l>>2]=0;f[d+-8>>2]=0;f[q>>2]=f[r>>2];q=m+-12|0;f[l>>2]=f[q>>2];m=m+-8|0;f[d+-8>>2]=f[m>>2];f[m>>2]=0;f[q>>2]=0;f[r>>2]=0;d=e+-40|0;e=d}while((g|0)!=(c|0));h=f[a>>2]|0;c=f[p>>2]|0}f[a>>2]=e;f[p>>2]=b;f[o>>2]=n;g=h;if((c|0)!=(g|0))do{d=f[c+-16>>2]|0;if(d|0){e=c+-12|0;if((f[e>>2]|0)!=(d|0))f[e>>2]=d;QK(d)}c=c+-40|0}while((c|0)!=(g|0));if(!h)return;QK(h);return}function Oi(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0;f[a>>2]=0;c=a+4|0;f[c>>2]=0;f[a+8>>2]=0;d=b+4|0;e=(f[d>>2]|0)-(f[b>>2]|0)|0;g=(e|0)/40|0;if(!e)return;if(g>>>0>107374182)$I(a);e=OK(e)|0;f[c>>2]=e;f[a>>2]=e;f[a+8>>2]=e+(g*40|0);Qi(a,f[b>>2]|0,f[d>>2]|0,g);return}function Pi(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;j=a+4|0;c=f[a>>2]|0;h=(f[j>>2]|0)-c>>5;d=h+1|0;if(d>>>0>134217727)$I(a);l=a+8|0;k=(f[l>>2]|0)-c|0;c=k>>4;c=k>>5>>>0<67108863?(c>>>0<d>>>0?d:c):134217727;do if(c)if(c>>>0>134217727){l=Ra(8)|0;VK(l,44736);f[l>>2]=17660;Va(l|0,4016,428)}else{g=OK(c<<5)|0;break}else g=0;while(0);d=g+(h<<5)|0;e=d;i=g+(c<<5)|0;f[d>>2]=f[b>>2];f[d+4>>2]=f[b+4>>2];f[d+8>>2]=f[b+8>>2];f[d+12>>2]=f[b+12>>2];Oi(g+(h<<5)+16|0,b+16|0);b=d+32|0;g=f[a>>2]|0;c=f[j>>2]|0;if((c|0)==(g|0)){c=e;k=g;d=g}else{do{h=d+-32|0;m=c;c=c+-32|0;f[h>>2]=f[c>>2];f[h+4>>2]=f[c+4>>2];f[h+8>>2]=f[c+8>>2];f[h+12>>2]=f[c+12>>2];h=d+-16|0;k=m+-16|0;f[h>>2]=0;n=d+-12|0;f[n>>2]=0;f[d+-8>>2]=0;f[h>>2]=f[k>>2];h=m+-12|0;f[n>>2]=f[h>>2];m=m+-8|0;f[d+-8>>2]=f[m>>2];f[m>>2]=0;f[h>>2]=0;f[k>>2]=0;d=e+-32|0;e=d}while((c|0)!=(g|0));c=e;k=f[a>>2]|0;d=f[j>>2]|0}f[a>>2]=c;f[j>>2]=b;f[l>>2]=i;a=k;if((d|0)!=(a|0)){i=d;do{b=i+-16|0;c=f[b>>2]|0;if(c|0){h=i+-12|0;d=f[h>>2]|0;if((d|0)!=(c|0)){do{e=d+-40|0;f[h>>2]=e;g=f[d+-16>>2]|0;if(!g)d=e;else{d=d+-12|0;if((f[d>>2]|0)!=(g|0))f[d>>2]=g;QK(g);d=f[h>>2]|0}}while((d|0)!=(c|0));c=f[b>>2]|0}QK(c)}i=i+-32|0}while((i|0)!=(a|0))}if(!k)return;QK(k);return}function Qi(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0;k=a+4|0;if((b|0)==(c|0))return;d=f[k>>2]|0;while(1){f[d>>2]=f[b>>2];f[d+4>>2]=f[b+4>>2];f[d+8>>2]=f[b+8>>2];f[d+12>>2]=f[b+12>>2];f[d+16>>2]=f[b+16>>2];f[d+20>>2]=f[b+20>>2];h=d+24|0;e=b+24|0;f[h>>2]=0;j=d+28|0;f[j>>2]=0;f[d+32>>2]=0;g=b+28|0;a=(f[g>>2]|0)-(f[e>>2]|0)|0;if(a|0){if((a|0)<0){a=5;break}i=OK(a)|0;f[j>>2]=i;f[h>>2]=i;f[d+32>>2]=i+a;d=f[e>>2]|0;a=(f[g>>2]|0)-d|0;if((a|0)>0){GM(i|0,d|0,a|0)|0;f[j>>2]=i+a}}b=b+40|0;d=(f[k>>2]|0)+40|0;f[k>>2]=d;if((b|0)==(c|0)){a=9;break}}if((a|0)==5)$I(h);else if((a|0)==9)return}function Ri(a){a=a|0;f[a>>2]=4776;Hi(a+16|0);zK(a);return}function Si(a){a=a|0;f[a>>2]=4776;Hi(a+16|0);zK(a);QK(a);return}function Ti(a){a=a|0;a=a+16|0;dd[f[f[a>>2]>>2]&511](a);return}function Ui(a){a=a|0;QK(a);return}function Vi(a){a=a|0;var b=0,c=0,d=0,e=0,g=0;f[a>>2]=4404;e=a+44|0;b=f[e>>2]|0;if(b|0){g=a+48|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[a>>2]=4264;b=f[a+24>>2]|0;if(!b){QK(a);return}c=a+28|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);QK(a);return}function Wi(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;k=u;u=u+160|0;e=k+136|0;h=k;i=h+56|0;j=h+4|0;f[h>>2]=292;f[i>>2]=312;bB(h+56|0,j);f[h+128>>2]=0;f[h+132>>2]=-1;f[h>>2]=4304;f[i>>2]=4324;fB(j);f[j>>2]=4340;g=h+36|0;f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;f[g+12>>2]=0;f[h+52>>2]=16;f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;ce(j,e);if((b[e+11>>0]|0)<0)QK(f[e>>2]|0);ve(e,c,d);l=e+11|0;m=b[l>>0]|0;n=m<<24>>24<0;de(h,n?f[e>>2]|0:e,n?f[e+4>>2]|0:m&255)|0;if((b[l>>0]|0)<0)QK(f[e>>2]|0);if((f[d>>2]|0)>0){e=0;do{de(h,18862,2)|0;e=e+1|0}while((e|0)<(f[d>>2]|0))}n=de(h,22462,9)|0;de(nB(n,f[c+56>>2]|0)|0,30204,1)|0;fe(a,j);f[h>>2]=4304;f[i>>2]=4324;f[j>>2]=4340;if((b[g+11>>0]|0)>=0){Rz(j);NA(h,4280);Mz(i);u=k;return}QK(f[g>>2]|0);Rz(j);NA(h,4280);Mz(i);u=k;return}function Xi(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0;i=u;u=u+32|0;g=i;h=f[d+12>>2]|0;Zd(d,b[c+36>>0]|0?12:8);e=f[c+56>>2]|0;do if(!(b[c+37>>0]|0))if(e>>>0<65536){Sd(d,e&65535);break}else Pa(23065,19104,891,19563);else Ud(d,e);while(0);ze(g,c,d,h);c=g+8|0;if((b[c+11>>0]|0)<0)QK(f[c>>2]|0);d=56816;g=f[d+4>>2]|0;h=a;f[h>>2]=f[d>>2];f[h+4>>2]=g;ZK(a+8|0,56824);u=i;return}function Yi(a){a=a|0;b[a+37>>0]=(f[a+56>>2]|0)>>>0>65535&1;return}function Zi(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0;h=u;u=u+32|0;g=h+20|0;e=h;Je(e,c,d);e=e+8|0;if((b[e+11>>0]|0)<0)QK(f[e>>2]|0);if(!(b[c+37>>0]|0))e=(Hd(d)|0)&65535;else e=Id(d)|0;f[c+56>>2]=e;if(!(b[d+24>>0]|0)){c=56816;d=f[c+4>>2]|0;g=a;f[g>>2]=f[c>>2];f[g+4>>2]=d;ZK(a+8|0,56824);u=h;return}f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;Rj(a,2,100,g);if((b[g+11>>0]|0)>=0){u=h;return}QK(f[g>>2]|0);u=h;return}function _i(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;f[a>>2]=4716;h=a+16|0;f[h>>2]=4404;e=a+60|0;b=f[e>>2]|0;if(b|0){g=a+64|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[h>>2]=4264;b=f[a+40>>2]|0;if(!b){zK(a);return}c=a+44|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);return}function $i(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;f[a>>2]=4716;h=a+16|0;f[h>>2]=4404;e=a+60|0;b=f[e>>2]|0;if(b|0){g=a+64|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[h>>2]=4264;b=f[a+40>>2]|0;if(!b){zK(a);QK(a);return}c=a+44|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);QK(a);return}function aj(a){a=a|0;a=a+16|0;dd[f[f[a>>2]>>2]&511](a);return}function bj(a){a=a|0;QK(a);return}function cj(a){a=a|0;var c=0,d=0,e=0,g=0,h=0;f[a>>2]=4684;c=a+76|0;if((b[c+11>>0]|0)<0)QK(f[c>>2]|0);f[a>>2]=4404;g=a+44|0;c=f[g>>2]|0;if(c|0){h=a+48|0;d=f[h>>2]|0;if((d|0)!=(c|0)){do{e=d+-8|0;f[h>>2]=e;d=f[d+-4>>2]|0;if(!d)d=e;else{KK(d);d=f[h>>2]|0}}while((d|0)!=(c|0));c=f[g>>2]|0}QK(c)}f[a>>2]=4264;d=f[a+24>>2]|0;if(!d)return;c=a+28|0;if((f[c>>2]|0)!=(d|0))f[c>>2]=d;QK(d);return}function dj(a){a=a|0;var c=0,d=0,e=0,g=0,h=0;f[a>>2]=4684;c=a+76|0;if((b[c+11>>0]|0)<0)QK(f[c>>2]|0);f[a>>2]=4404;g=a+44|0;c=f[g>>2]|0;if(c|0){h=a+48|0;d=f[h>>2]|0;if((d|0)!=(c|0)){do{e=d+-8|0;f[h>>2]=e;d=f[d+-4>>2]|0;if(!d)d=e;else{KK(d);d=f[h>>2]|0}}while((d|0)!=(c|0));c=f[g>>2]|0}QK(c)}f[a>>2]=4264;c=f[a+24>>2]|0;if(!c){QK(a);return}d=a+28|0;if((f[d>>2]|0)!=(c|0))f[d>>2]=c;QK(c);QK(a);return}function ej(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;n=u;u=u+160|0;j=n+136|0;k=n;l=k+56|0;m=k+4|0;f[k>>2]=292;f[l>>2]=312;bB(k+56|0,m);f[k+128>>2]=0;f[k+132>>2]=-1;f[k>>2]=4304;f[l>>2]=4324;fB(m);f[m>>2]=4340;i=k+36|0;f[i>>2]=0;f[i+4>>2]=0;f[i+8>>2]=0;f[i+12>>2]=0;f[k+52>>2]=16;f[j>>2]=0;f[j+4>>2]=0;f[j+8>>2]=0;ce(m,j);if((b[j+11>>0]|0)<0)QK(f[j>>2]|0);ve(j,c,d);h=j+11|0;g=b[h>>0]|0;e=g<<24>>24<0;de(k,e?f[j>>2]|0:j,e?f[j+4>>2]|0:g&255)|0;if((b[h>>0]|0)<0)QK(f[j>>2]|0);if((f[d>>2]|0)>0){e=0;do{de(k,18862,2)|0;e=e+1|0}while((e|0)<(f[d>>2]|0))}g=de(k,23170,13)|0;g=de(nB(g,f[c+56>>2]|0)|0,30204,1)|0;if((f[d>>2]|0)>0){e=0;do{de(g,18862,2)|0;e=e+1|0}while((e|0)<(f[d>>2]|0))}h=de(g,23184,14)|0;e=f[c+60>>2]|0;f[j>>2]=0;f[j+4>>2]=0;f[j+8>>2]=0;g=j+11|0;b[g>>0]=4;b[j+4>>0]=0;b[j>>0]=e>>>24;b[j+1>>0]=e>>>16;b[j+2>>0]=e>>>8;b[j+3>>0]=e;h=de(de(h,j,4)|0,30204,1)|0;if((f[d>>2]|0)>0){e=0;do{de(h,18862,2)|0;e=e+1|0}while((e|0)<(f[d>>2]|0))}o=de(h,23199,6)|0;e=c+76|0;d=b[e+11>>0]|0;h=d<<24>>24<0;de(de(o,h?f[e>>2]|0:e,h?f[c+80>>2]|0:d&255)|0,30204,1)|0;if((b[g>>0]|0)<0)QK(f[j>>2]|0);fe(a,m);f[k>>2]=4304;f[l>>2]=4324;f[m>>2]=4340;if((b[i+11>>0]|0)>=0){Rz(m);NA(k,4280);Mz(l);u=n;return}QK(f[i>>2]|0);Rz(m);NA(k,4280);Mz(l);u=n;return}function fj(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0;e=u;u=u+32|0;g=e;h=f[d+12>>2]|0;Zd(d,b[c+36>>0]|0?12:8);Ud(d,f[c+56>>2]|0);Ud(d,f[c+60>>2]|0);Ud(d,f[c+64>>2]|0);Ud(d,f[c+68>>2]|0);Ud(d,f[c+72>>2]|0);Xd(d,c+76|0);ze(g,c,d,h);c=g+8|0;if((b[c+11>>0]|0)<0)QK(f[c>>2]|0);d=56816;g=f[d+4>>2]|0;h=a;f[h>>2]=f[d>>2];f[h+4>>2]=g;ZK(a+8|0,56824);u=e;return}function gj(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0;i=u;u=u+32|0;h=i+20|0;e=i;Je(e,c,d);e=e+8|0;if((b[e+11>>0]|0)<0)QK(f[e>>2]|0);e=Id(d)|0;f[c+56>>2]=e;e=Id(d)|0;f[c+60>>2]=e;e=Id(d)|0;f[c+64>>2]=e;e=Id(d)|0;f[c+68>>2]=e;e=Id(d)|0;f[c+72>>2]=e;Jd(h,d);e=c+76|0;g=e+11|0;if((b[g>>0]|0)<0){b[f[e>>2]>>0]=0;f[c+80>>2]=0}else{b[e>>0]=0;b[g>>0]=0}dL(e,0);f[e>>2]=f[h>>2];f[e+4>>2]=f[h+4>>2];f[e+8>>2]=f[h+8>>2];if(!(b[d+24>>0]|0)){c=56816;d=f[c+4>>2]|0;h=a;f[h>>2]=f[c>>2];f[h+4>>2]=d;ZK(a+8|0,56824);u=i;return}f[h>>2]=0;f[h+4>>2]=0;f[h+8>>2]=0;Rj(a,2,100,h);if((b[h+11>>0]|0)>=0){u=i;return}QK(f[h>>2]|0);u=i;return}function hj(a){a=a|0;var c=0,d=0,e=0,g=0,h=0,i=0;f[a>>2]=4656;i=a+16|0;f[i>>2]=4684;c=a+92|0;if((b[c+11>>0]|0)<0)QK(f[c>>2]|0);f[i>>2]=4404;h=a+60|0;c=f[h>>2]|0;if(c|0){g=a+64|0;d=f[g>>2]|0;if((d|0)!=(c|0)){do{e=d+-8|0;f[g>>2]=e;d=f[d+-4>>2]|0;if(!d)d=e;else{KK(d);d=f[g>>2]|0}}while((d|0)!=(c|0));c=f[h>>2]|0}QK(c)}f[i>>2]=4264;c=f[a+40>>2]|0;if(!c){zK(a);return}d=a+44|0;if((f[d>>2]|0)!=(c|0))f[d>>2]=c;QK(c);zK(a);return}function ij(a){a=a|0;var c=0,d=0,e=0,g=0,h=0,i=0;f[a>>2]=4656;i=a+16|0;f[i>>2]=4684;c=a+92|0;if((b[c+11>>0]|0)<0)QK(f[c>>2]|0);f[i>>2]=4404;h=a+60|0;c=f[h>>2]|0;if(c|0){g=a+64|0;d=f[g>>2]|0;if((d|0)!=(c|0)){do{e=d+-8|0;f[g>>2]=e;d=f[d+-4>>2]|0;if(!d)d=e;else{KK(d);d=f[g>>2]|0}}while((d|0)!=(c|0));c=f[h>>2]|0}QK(c)}f[i>>2]=4264;c=f[a+40>>2]|0;if(!c){zK(a);QK(a);return}d=a+44|0;if((f[d>>2]|0)!=(c|0))f[d>>2]=c;QK(c);zK(a);QK(a);return}function jj(a){a=a|0;a=a+16|0;dd[f[f[a>>2]>>2]&511](a);return}function kj(a){a=a|0;QK(a);return}function lj(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;f[a>>2]=4628;h=a+16|0;f[h>>2]=4404;e=a+60|0;b=f[e>>2]|0;if(b|0){g=a+64|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[h>>2]=4264;b=f[a+40>>2]|0;if(!b){zK(a);return}c=a+44|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);return}function mj(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;f[a>>2]=4628;h=a+16|0;f[h>>2]=4404;e=a+60|0;b=f[e>>2]|0;if(b|0){g=a+64|0;c=f[g>>2]|0;if((c|0)!=(b|0)){d=c;while(1){c=d+-8|0;f[g>>2]=c;d=f[d+-4>>2]|0;if(d){KK(d);c=f[g>>2]|0}if((c|0)==(b|0))break;else d=c}b=f[e>>2]|0}QK(b)}f[h>>2]=4264;b=f[a+40>>2]|0;if(!b){zK(a);QK(a);return}c=a+44|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);QK(a);return}function nj(a){a=a|0;a=a+16|0;dd[f[f[a>>2]>>2]&511](a);return}function oj(a){a=a|0;QK(a);return}function pj(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;f[a>>2]=4600;h=a+16|0;f[h>>2]=4436;b=f[a+80>>2]|0;if(b|0){c=a+84|0;d=f[c>>2]|0;if((d|0)!=(b|0))f[c>>2]=d+(~((d+-4-b|0)>>>2)<<2);QK(b)}f[h>>2]=4404;e=a+60|0;b=f[e>>2]|0;if(b|0){g=a+64|0;c=f[g>>2]|0;if((c|0)!=(b|0)){do{d=c+-8|0;f[g>>2]=d;c=f[c+-4>>2]|0;if(!c)c=d;else{KK(c);c=f[g>>2]|0}}while((c|0)!=(b|0));b=f[e>>2]|0}QK(b)}f[h>>2]=4264;b=f[a+40>>2]|0;if(!b){zK(a);return}c=a+44|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);return}function qj(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;f[a>>2]=4600;h=a+16|0;f[h>>2]=4436;b=f[a+80>>2]|0;if(b|0){c=a+84|0;d=f[c>>2]|0;if((d|0)!=(b|0))f[c>>2]=d+(~((d+-4-b|0)>>>2)<<2);QK(b)}f[h>>2]=4404;e=a+60|0;b=f[e>>2]|0;if(b|0){g=a+64|0;c=f[g>>2]|0;if((c|0)!=(b|0)){do{d=c+-8|0;f[g>>2]=d;c=f[c+-4>>2]|0;if(!c)c=d;else{KK(c);c=f[g>>2]|0}}while((c|0)!=(b|0));b=f[e>>2]|0}QK(b)}f[h>>2]=4264;b=f[a+40>>2]|0;if(!b){zK(a);QK(a);return}c=a+44|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b);zK(a);QK(a);return}function rj(a){a=a|0;a=a+16|0;dd[f[f[a>>2]>>2]&511](a);return}function sj(a){a=a|0;QK(a);return}function tj(){var a=0,c=0;c=u;u=u+16|0;a=c;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;Rj(56816,0,0,a);if((b[a+11>>0]|0)>=0){u=c;return}QK(f[a>>2]|0);u=c;return}function uj(a){a=a|0;var b=0;f[a>>2]=4264;b=a+8|0;f[a+40>>2]=0;f[b>>2]=0;f[b+4>>2]=0;f[b+8>>2]=0;f[b+12>>2]=0;f[b+16>>2]=0;f[b+20>>2]=0;f[b+24>>2]=0;d[b+28>>1]=0;return}function vj(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;d=f[b+44>>2]|0;e=f[b+48>>2]|0;a:do if((d|0)!=(e|0)){b=d;while(1){d=f[b>>2]|0;if((f[d+20>>2]|0)==(c|0))break;b=b+8|0;if((b|0)==(e|0))break a}f[a>>2]=d;b=f[b+4>>2]|0;f[a+4>>2]=b;if(!b)return;IK(b);return}while(0);f[a>>2]=0;f[a+4>>2]=0;return}function wj(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0;f[a>>2]=0;i=a+4|0;f[i>>2]=0;f[a+8>>2]=0;d=f[b+44>>2]|0;h=f[b+48>>2]|0;if((d|0)==(h|0))return;g=a+8|0;do{b=f[d>>2]|0;e=b;do if((f[b+20>>2]|0)==(c|0)){b=f[i>>2]|0;if((b|0)==(f[g>>2]|0)){xj(a,d);break}f[b>>2]=e;e=f[d+4>>2]|0;f[b+4>>2]=e;if(e){IK(e);b=f[i>>2]|0}f[i>>2]=b+8}while(0);d=d+8|0}while((d|0)!=(h|0));return}function xj(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;m=a+4|0;c=f[m>>2]|0;d=f[a>>2]|0;i=c-d>>3;e=i+1|0;j=d;if(e>>>0>536870911)$I(a);l=a+8|0;k=(f[l>>2]|0)-d|0;g=k>>2;g=k>>3>>>0<268435455?(g>>>0<e>>>0?e:g):536870911;do if(g)if(g>>>0>536870911){m=Ra(8)|0;VK(m,44736);f[m>>2]=17660;Va(m|0,4016,428)}else{h=OK(g<<3)|0;break}else h=0;while(0);d=h+(i<<3)|0;e=d;k=h+(g<<3)|0;f[d>>2]=f[b>>2];g=f[b+4>>2]|0;f[h+(i<<3)+4>>2]=g;if(!g)g=j;else{IK(g);c=f[m>>2]|0;g=f[a>>2]|0}h=d+8|0;if((c|0)!=(g|0)){do{j=c;c=c+-8|0;f[d+-8>>2]=f[c>>2];j=j+-4|0;f[d+-4>>2]=f[j>>2];f[c>>2]=0;f[j>>2]=0;d=e+-8|0;e=d}while((c|0)!=(g|0));g=f[a>>2]|0;c=f[m>>2]|0}f[a>>2]=e;f[m>>2]=h;f[l>>2]=k;e=g;if((c|0)!=(e|0))do{d=f[c+-4>>2]|0;c=c+-8|0;if(d|0)KK(d)}while((c|0)!=(e|0));if(!g)return;QK(g);return}function yj(a,b){a=a|0;b=b|0;var c=0;c=f[a+64>>2]|0;a=f[a+68>>2]|0;if((c|0)==(a|0)){b=0;return b|0}while(1){if((f[c>>2]|0)==(b|0)){c=1;a=4;break}c=c+4|0;if((c|0)==(a|0)){c=0;a=4;break}}if((a|0)==4)return c|0;return 0}function zj(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,J=0,K=0,L=0,M=0,N=0,O=0;L=u;u=u+272|0;J=L+252|0;K=L+72|0;F=L+240|0;G=L+228|0;H=L+216|0;y=L+56|0;B=L+44|0;t=L+24|0;v=L+16|0;C=L;c=f[d+16>>2]|0;w=f[d+20>>2]|0;a:do if((c|0)!=(w|0)){D=d+4|0;A=h+4|0;E=d+8|0;p=v+4|0;q=e+4|0;r=t+8|0;s=r+11|0;b:while(1){switch(b[D>>0]|0){case 0:{x=(f[A>>2]|0)-(f[h>>2]|0)|0;o=c+16|0;k=o;j=f[k>>2]|0;k=f[k+4>>2]|0;if(0<k>>>0|0==(k|0)&(536870912-x|0)>>>0<j>>>0){c=5;break b}n=c+8|0;m=n;l=f[m>>2]|0;m=f[m+4>>2]|0;if(m>>>0>8388607|(m|0)==8388607&l>>>0>4294967295){c=14;break b}i=E;d=f[i>>2]|0;i=f[i+4>>2]|0;M=i|k;if(M>>>0>8388607|(M|0)==8388607&(d|j)>>>0>4294967295){c=14;break b}N=f[e>>2]|0;O=f[(f[N>>2]|0)+12>>2]|0;M=wM(wM(l|0,m|0,j|0,k|0)|0,I|0,d|0,i|0)|0;switch(Wc[O&63](N,M,I)|0){case 2:{c=17;break b}case 1:{c=26;break b}default:{}}N=f[e>>2]|0;M=f[(f[N>>2]|0)+20>>2]|0;O=n;n=E;O=wM(f[n>>2]|0,f[n+4>>2]|0,f[O>>2]|0,f[O+4>>2]|0)|0;if(!(Wc[M&63](N,O,I)|0)){c=29;break b}j=o;i=f[j>>2]|0;j=wM(i|0,f[j+4>>2]|0,x|0,0)|0;l=f[A>>2]|0;d=f[h>>2]|0;k=l-d|0;if(j>>>0<=k>>>0){if(j>>>0<k>>>0?(z=d+j|0,(l|0)!=(z|0)):0)f[A>>2]=z}else{Td(h,j-k|0);i=f[o>>2]|0;d=f[h>>2]|0}O=f[e>>2]|0;if(!(Wc[f[(f[O>>2]|0)+16>>2]&63](O,d+x|0,i)|0)){c=36;break b}break}case 1:{d=f[g>>2]|0;if(!d){c=38;break b}f[v>>2]=f[e>>2];i=f[q>>2]|0;f[p>>2]=i;j=(i|0)==0;if(!j)IK(i);N=c+8|0;M=E;O=c+16|0;Aj(t,d,v,wM(f[M>>2]|0,f[M+4>>2]|0,f[N>>2]|0,f[N+4>>2]|0)|0,I,f[O>>2]|0,f[O+4>>2]|0,h);if((b[s>>0]|0)<0)QK(f[r>>2]|0);if(!j)KK(i);break}default:{c=46;break b}}c=c+40|0;if((c|0)==(w|0))break a}if((c|0)==5){d=K+64|0;j=K+8|0;f[j>>2]=4524;i=K+12|0;f[K>>2]=188;f[d>>2]=208;f[K+4>>2]=0;bB(K+64|0,i);f[K+136>>2]=0;f[K+140>>2]=-1;f[K>>2]=4504;f[d>>2]=4544;f[j>>2]=4524;fB(i);f[i>>2]=4340;j=K+44|0;f[j>>2]=0;f[j+4>>2]=0;f[j+8>>2]=0;f[j+12>>2]=0;f[K+60>>2]=24;f[J>>2]=0;f[J+4>>2]=0;f[J+8>>2]=0;ce(i,J);if((b[J+11>>0]|0)<0)QK(f[J>>2]|0);c=K+8|0;O=de(c,23479,19)|0;N=o;N=de(oB(O,f[N>>2]|0,f[N+4>>2]|0)|0,23499,35)|0;O=o;O=wM(f[O>>2]|0,f[O+4>>2]|0,x|0,0)|0;de(mB(de(oB(N,O,I)|0,23535,40)|0,536870912)|0,23576,6)|0;fe(F,i);Rj(a,6,1e3,F);if((b[F+11>>0]|0)<0)QK(f[F>>2]|0);f[K>>2]=4504;f[d>>2]=4544;f[c>>2]=4524;f[i>>2]=4340;if((b[j+11>>0]|0)<0)QK(f[j>>2]|0);Rz(i);ZA(K,4556);Mz(d);u=L;return}else if((c|0)==14){c=OK(48)|0;f[G>>2]=c;f[G+8>>2]=-2147483600;f[G+4>>2]=39;d=c;i=23583;j=d+39|0;do{b[d>>0]=b[i>>0]|0;d=d+1|0;i=i+1|0}while((d|0)<(j|0));b[c+39>>0]=0;Rj(a,2,1e3,G);if((b[G+11>>0]|0)>=0){u=L;return}QK(f[G>>2]|0);u=L;return}else if((c|0)==17){c=f[h>>2]|0;if((f[A>>2]|0)!=(c|0))f[A>>2]=c;d=K+64|0;j=K+8|0;f[j>>2]=4524;i=K+12|0;f[K>>2]=188;f[d>>2]=208;f[K+4>>2]=0;bB(K+64|0,i);f[K+136>>2]=0;f[K+140>>2]=-1;f[K>>2]=4504;f[d>>2]=4544;f[j>>2]=4524;fB(i);f[i>>2]=4340;j=K+44|0;f[j>>2]=0;f[j+4>>2]=0;f[j+8>>2]=0;f[j+12>>2]=0;f[K+60>>2]=24;f[J>>2]=0;f[J+4>>2]=0;f[J+8>>2]=0;ce(i,J);if((b[J+11>>0]|0)<0)QK(f[J>>2]|0);c=K+8|0;N=de(de(c,23623,58)|0,23682,25)|0;O=n;M=E;O=wM(f[M>>2]|0,f[M+4>>2]|0,f[O>>2]|0,f[O+4>>2]|0)|0;de(oB(N,O,I)|0,18904,2)|0;fe(H,i);Rj(a,2,100,H);if((b[H+11>>0]|0)<0)QK(f[H>>2]|0);f[K>>2]=4504;f[d>>2]=4544;f[c>>2]=4524;f[i>>2]=4340;if((b[j+11>>0]|0)<0)QK(f[j>>2]|0);Rz(i);ZA(K,4556);Mz(d);u=L;return}else if((c|0)==26){f[y>>2]=0;f[y+4>>2]=0;f[y+8>>2]=0;Rj(a,2,100,y);if((b[y+11>>0]|0)>=0){u=L;return}QK(f[y>>2]|0);u=L;return}else if((c|0)==29)Pa(23708,19104,1114,23716);else if((c|0)==36)Pa(23708,19104,1122,23716);else if((c|0)==38){c=OK(64)|0;f[B>>2]=c;f[B+8>>2]=-2147483584;f[B+4>>2]=54;d=c;i=23726;j=d+54|0;do{b[d>>0]=b[i>>0]|0;d=d+1|0;i=i+1|0}while((d|0)<(j|0));b[c+54>>0]=0;Rj(a,2,103,B);if((b[B+11>>0]|0)>=0){u=L;return}QK(f[B>>2]|0);u=L;return}else if((c|0)==46){c=K+64|0;i=K+8|0;f[i>>2]=4524;d=K+12|0;f[K>>2]=188;f[c>>2]=208;f[K+4>>2]=0;bB(K+64|0,d);f[K+136>>2]=0;f[K+140>>2]=-1;f[K>>2]=4504;f[c>>2]=4544;f[i>>2]=4524;fB(d);f[d>>2]=4340;i=K+44|0;f[i>>2]=0;f[i+4>>2]=0;f[i+8>>2]=0;f[i+12>>2]=0;f[K+60>>2]=24;f[J>>2]=0;f[J+4>>2]=0;f[J+8>>2]=0;ce(d,J);if((b[J+11>>0]|0)<0)QK(f[J>>2]|0);j=K+8|0;O=de(j,23781,25)|0;b[J>>0]=b[D>>0]|0;de(de(O,J,1)|0,23807,16)|0;fe(C,d);Rj(a,4,103,C);if((b[C+11>>0]|0)<0)QK(f[C>>2]|0);f[K>>2]=4504;f[c>>2]=4544;f[j>>2]=4524;f[d>>2]=4340;if((b[i+11>>0]|0)<0)QK(f[i>>2]|0);Rz(d);ZA(K,4556);Mz(c);u=L;return}}while(0);M=56816;N=f[M+4>>2]|0;O=a;f[O>>2]=f[M>>2];f[O+4>>2]=N;ZK(a+8|0,56824);u=L;return}function Aj(a,c,d,e,g,h,i,j){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0;w=u;u=u+208|0;n=w+192|0;p=w+48|0;o=w+36|0;k=w+24|0;q=w+12|0;r=w;t=j+4|0;v=(f[t>>2]|0)-(f[j>>2]|0)|0;if(0<i>>>0|0==(i|0)&(536870912-v|0)>>>0<h>>>0){k=p+64|0;m=p+8|0;f[m>>2]=4524;l=p+12|0;f[p>>2]=188;f[k>>2]=208;f[p+4>>2]=0;bB(p+64|0,l);f[p+136>>2]=0;f[p+140>>2]=-1;f[p>>2]=4504;f[k>>2]=4544;f[m>>2]=4524;fB(l);f[l>>2]=4340;m=p+44|0;f[m>>2]=0;f[m+4>>2]=0;f[m+8>>2]=0;f[m+12>>2]=0;f[p+60>>2]=24;f[n>>2]=0;f[n+4>>2]=0;f[n+8>>2]=0;ce(l,n);if((b[n+11>>0]|0)<0)QK(f[n>>2]|0);c=p+8|0;d=de(oB(de(c,23824,19)|0,h,i)|0,23499,35)|0;h=wM(v|0,0,h|0,i|0)|0;de(mB(de(oB(d,h,I)|0,23535,40)|0,536870912)|0,23576,6)|0;fe(o,l);Rj(a,6,1e3,o);if((b[o+11>>0]|0)<0)QK(f[o>>2]|0);f[p>>2]=4504;f[k>>2]=4544;f[c>>2]=4524;f[l>>2]=4340;if((b[m+11>>0]|0)<0)QK(f[m>>2]|0);Rz(l);ZA(p,4556);Mz(k);u=w;return}n=c+64|0;p=n;o=f[p>>2]|0;p=f[p+4>>2]|0;m=c+8|0;l=f[m>>2]|0;m=f[m+4>>2]|0;c=wM(l|0,m|0,o|0,p|0)|0;x=I;if(x>>>0<g>>>0|(x|0)==(g|0)&c>>>0<e>>>0){f[k>>2]=0;f[k+4>>2]=0;f[k+8>>2]=0;Rj(a,2,100,k);if((b[k+11>>0]|0)>=0){u=w;return}QK(f[k>>2]|0);u=w;return}c=wM(h|0,i|0,e|0,g|0)|0;k=I;if(m>>>0<i>>>0|(m|0)==(i|0)&l>>>0<h>>>0|(k>>>0>m>>>0|(k|0)==(m|0)&c>>>0>l>>>0)){f[q>>2]=0;f[q+4>>2]=0;f[q+8>>2]=0;Rj(a,2,100,q);if((b[q+11>>0]|0)>=0){u=w;return}QK(f[q>>2]|0);u=w;return}q=f[d>>2]|0;m=f[(f[q>>2]|0)+12>>2]|0;x=wM(c|0,k|0,o|0,p|0)|0;if(((Wc[m&63](q,x,I)|0)+-1|0)>>>0<2){f[r>>2]=0;f[r+4>>2]=0;f[r+8>>2]=0;Rj(a,2,100,r);if((b[r+11>>0]|0)>=0){u=w;return}QK(f[r>>2]|0);u=w;return}r=f[d>>2]|0;q=f[(f[r>>2]|0)+20>>2]|0;x=n;x=wM(f[x>>2]|0,f[x+4>>2]|0,e|0,g|0)|0;if(!(Wc[q&63](r,x,I)|0))Pa(23708,19104,3031,23716);if(!((h|0)==0&(i|0)==0)){k=wM(v|0,0,h|0,i|0)|0;m=f[t>>2]|0;c=f[j>>2]|0;l=m-c|0;if(k>>>0<=l>>>0){if(k>>>0<l>>>0?(s=c+k|0,(m|0)!=(s|0)):0)f[t>>2]=s}else{Td(j,k-l|0);c=f[j>>2]|0}x=f[d>>2]|0;if(!(Wc[f[(f[x>>2]|0)+16>>2]&63](x,c+v|0,h)|0))Pa(23708,19104,3040,23716)}v=56816;h=f[v+4>>2]|0;x=a;f[x>>2]=f[v>>2];f[x+4>>2]=h;ZK(a+8|0,56824);u=w;return}function Bj(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0;k=c;h=b;i=k-h|0;g=a+8|0;d=f[g>>2]|0;e=f[a>>2]|0;j=e;if(i>>>0>(d-e|0)>>>0){if(e){d=a+4|0;if((f[d>>2]|0)!=(j|0))f[d>>2]=j;QK(j);f[g>>2]=0;f[d>>2]=0;f[a>>2]=0;d=0}if((i|0)<0)$I(a);k=d<<1;d=d>>>0<1073741823?(k>>>0<i>>>0?i:k):2147483647;if((d|0)<0)$I(a);j=OK(d)|0;k=a+4|0;f[k>>2]=j;f[a>>2]=j;f[g>>2]=j+d;GM(j|0,b|0,i|0)|0;f[k>>2]=j+i;return}g=a+4|0;e=(f[g>>2]|0)-e|0;a=i>>>0>e>>>0;c=a?b+e|0:c;e=c;d=e-h|0;if(d|0)HM(j|0,b|0,d|0)|0;d=j+d|0;if(a){d=k-e|0;if((d|0)<=0)return;GM(f[g>>2]|0,c|0,d|0)|0;f[g>>2]=(f[g>>2]|0)+d;return}else{if((f[g>>2]|0)==(d|0))return;f[g>>2]=d;return}}function Cj(a){a=a|0;d[a+4>>1]=2;d[a+6>>1]=2;d[a+8>>1]=6;b[a+10>>0]=1;return}function Dj(a,c,e,g,h){a=a|0;c=c|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0;y=u;u=u+192|0;w=y+172|0;x=y+16|0;k=y+160|0;v=y;j=f[g>>2]|0;g=f[j+56>>2]|0;j=f[j+60>>2]|0;a:do if((g|0)!=(j|0)){while(1){i=g+16|0;if((f[g>>2]|0)==(e|0))break;if((i|0)==(j|0))break a;else g=i}i=f[g+4>>2]|0;s=f[g+8>>2]|0;b:do if((i|0)!=(s|0)){t=c+44|0;m=c+48|0;n=w+4|0;o=w+8|0;p=w+4|0;q=h+4|0;r=h+8|0;l=i;while(1){k=l+2|0;g=d[k>>1]|0;i=g&65535;c=f[t>>2]|0;j=c;if(i>>>0>(f[m>>2]|0)-c>>3>>>0)break;f[n>>2]=0;f[o>>2]=0;b[w>>0]=b[l>>0]|0;do if(g<<16>>16){g=i+-1|0;c=f[j+(g<<3)>>2]|0;g=f[j+(g<<3)+4>>2]|0;i=g;if(g){IK(g);g=f[o>>2]|0;f[p>>2]=c;f[o>>2]=i;if(g|0)KK(g)}else{f[p>>2]=c;f[o>>2]=i}g=f[q>>2]|0;if((g|0)==(f[r>>2]|0)){Ej(h,w);break}b[g>>0]=b[w>>0]|0;f[g+4>>2]=f[p>>2];i=f[o>>2]|0;f[g+8>>2]=i;if(i){IK(i);g=f[q>>2]|0}f[q>>2]=g+12}while(0);g=f[o>>2]|0;if(g|0)KK(g);l=l+4|0;if((l|0)==(s|0))break b}i=x+64|0;c=x+8|0;f[c>>2]=4524;j=x+12|0;f[x>>2]=188;f[i>>2]=208;f[x+4>>2]=0;bB(x+64|0,j);f[x+136>>2]=0;f[x+140>>2]=-1;f[x>>2]=4504;f[i>>2]=4544;f[c>>2]=4524;fB(j);f[j>>2]=4340;c=x+44|0;f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;f[c+12>>2]=0;f[x+60>>2]=24;f[w>>2]=0;f[w+4>>2]=0;f[w+8>>2]=0;ce(j,w);if((b[w+11>>0]|0)<0)QK(f[w>>2]|0);g=x+8|0;w=de(g,23901,28)|0;de(nB(de(de(lB(w,d[k>>1]|0)|0,23930,11)|0,23942,4)|0,e)|0,23947,23)|0;fe(v,j);Rj(a,2,115,v);if((b[v+11>>0]|0)<0)QK(f[v>>2]|0);f[x>>2]=4504;f[i>>2]=4544;f[g>>2]=4524;f[j>>2]=4340;if((b[c+11>>0]|0)<0)QK(f[c>>2]|0);Rz(j);ZA(x,4556);Mz(i);u=y;return}while(0);w=56816;e=f[w+4>>2]|0;x=a;f[x>>2]=f[w>>2];f[x+4>>2]=e;ZK(a+8|0,56824);u=y;return}while(0);i=x+64|0;c=x+8|0;f[c>>2]=4524;j=x+12|0;f[x>>2]=188;f[i>>2]=208;f[x+4>>2]=0;bB(x+64|0,j);f[x+136>>2]=0;f[x+140>>2]=-1;f[x>>2]=4504;f[i>>2]=4544;f[c>>2]=4524;fB(j);f[j>>2]=4340;c=x+44|0;f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;f[c+12>>2]=0;f[x+60>>2]=24;f[w>>2]=0;f[w+4>>2]=0;f[w+8>>2]=0;ce(j,w);if((b[w+11>>0]|0)<0)QK(f[w>>2]|0);g=x+8|0;de(nB(de(g,23844,9)|0,e)|0,23854,46)|0;fe(k,j);Rj(a,2,116,k);if((b[k+11>>0]|0)<0)QK(f[k>>2]|0);f[x>>2]=4504;f[i>>2]=4544;f[g>>2]=4524;f[j>>2]=4340;if((b[c+11>>0]|0)<0)QK(f[c>>2]|0);Rz(j);ZA(x,4556);Mz(i);u=y;return}function Ej(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=a+4|0;g=f[n>>2]|0;d=f[a>>2]|0;j=(g-d|0)/12|0;e=j+1|0;k=d;if(e>>>0>357913941)$I(a);m=a+8|0;l=((f[m>>2]|0)-d|0)/12|0;h=l<<1;h=l>>>0<178956970?(h>>>0<e>>>0?e:h):357913941;do if(h)if(h>>>0>357913941){n=Ra(8)|0;VK(n,44736);f[n>>2]=17660;Va(n|0,4016,428)}else{i=OK(h*12|0)|0;break}else i=0;while(0);d=i+(j*12|0)|0;e=d;l=i+(h*12|0)|0;b[d>>0]=b[c>>0]|0;f[i+(j*12|0)+4>>2]=f[c+4>>2];h=f[c+8>>2]|0;f[i+(j*12|0)+8>>2]=h;if(!h)h=k;else{IK(h);g=f[n>>2]|0;h=f[a>>2]|0}i=d+12|0;if((g|0)==(h|0)){h=g;d=g}else{do{k=g;g=g+-12|0;b[d+-12>>0]=b[g>>0]|0;j=k+-8|0;f[d+-8>>2]=f[j>>2];k=k+-4|0;f[d+-4>>2]=f[k>>2];f[j>>2]=0;f[k>>2]=0;d=e+-12|0;e=d}while((g|0)!=(h|0));h=f[a>>2]|0;d=f[n>>2]|0}f[a>>2]=e;f[n>>2]=i;f[m>>2]=l;g=h;if((d|0)!=(g|0))do{e=f[d+-4>>2]|0;d=d+-12|0;if(e|0)KK(e)}while((d|0)!=(g|0));if(!h)return;QK(g);return}function Fj(a,b,c,e,g){a=a|0;b=b|0;c=c|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0;i=f[e>>2]|0;e=f[i+56>>2]|0;i=f[i+60>>2]|0;a:do if((e|0)!=(i|0)){while(1){h=e+16|0;if((f[e>>2]|0)==(c|0))break;if((h|0)==(i|0))break a;else e=h}h=f[e+4>>2]|0;j=f[e+8>>2]|0;b:do if((h|0)!=(j|0)){i=f[b+44>>2]|0;c=(f[b+48>>2]|0)-i>>3;b=i;while(1){i=d[h+2>>1]|0;e=i&65535;if(i<<16>>16==0|e>>>0>c>>>0){k=9;break}e=e+-1|0;i=f[b+(e<<3)>>2]|0;h=h+4|0;if((f[i+20>>2]|0)==(g|0))break;if((h|0)==(j|0))break b}if((k|0)==9){f[a>>2]=0;f[a+4>>2]=0;return}f[a>>2]=i;e=f[b+(e<<3)+4>>2]|0;f[a+4>>2]=e;if(!e)return;IK(e);return}while(0);f[a>>2]=0;f[a+4>>2]=0;return}while(0);f[a>>2]=0;f[a+4>>2]=0;return}function Gj(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;c=b+-1|0;if((b+65535|0)>>>0>131072){b=2;do{c=(c|0)/2|0;b=(b|0)/2|0}while((c+65536|0)>>>0>131072)}else b=2;e=f[a+76>>2]|0;d=f[a+72>>2]|0;if((e|0)==(b|0)){c=d+c|0;if((b+65536|0)>>>0>131072)do{c=(c|0)/2|0;b=(b|0)/2|0}while((b+65536|0)>>>0>131072);if((c+65536|0)>>>0>131072)do{c=(c|0)/2|0;b=(b|0)/2|0}while((c+65536|0)>>>0>131072)}else{c=(X(d,b)|0)+(X(e,c)|0)|0;b=X(e,b)|0;if((b+65536|0)>>>0>131072)do{c=(c|0)/2|0;b=(b|0)/2|0}while((b+65536|0)>>>0>131072);if((c+65536|0)>>>0>131072)do{c=(c|0)/2|0;b=(b|0)/2|0}while((c+65536|0)>>>0>131072)}d=f[a+60>>2]|0;e=(f[a+56>>2]|0)-d|0;if((d+65536|0)>>>0>131072)do{e=(e|0)/2|0;d=(d|0)/2|0}while((d+65536|0)>>>0>131072);if((e+65536|0)>>>0>131072)do{e=(e|0)/2|0;d=(d|0)/2|0}while((e+65536|0)>>>0>131072);d=d<<1;if((d+65536|0)>>>0>131072)do{e=(e|0)/2|0;d=(d|0)/2|0}while((d+65536|0)>>>0>131072);if((e+65536|0)>>>0>131072)do{e=(e|0)/2|0;d=(d|0)/2|0}while((e+65536|0)>>>0>131072);if((b|0)==(d|0)){c=c-e|0;if((b+65536|0)>>>0>131072)do{c=(c|0)/2|0;b=(b|0)/2|0}while((b+65536|0)>>>0>131072);if((c+65536|0)>>>0<=131072){e=c;a=b;a=(e|0)/(a|0)|0;return a|0}do{c=(c|0)/2|0;b=(b|0)/2|0}while((c+65536|0)>>>0>131072);a=(c|0)/(b|0)|0;return a|0}else{c=(X(d,c)|0)-(X(e,b)|0)|0;b=X(d,b)|0;if((b+65536|0)>>>0>131072)do{c=(c|0)/2|0;b=(b|0)/2|0}while((b+65536|0)>>>0>131072);if((c+65536|0)>>>0<=131072){e=c;a=b;a=(e|0)/(a|0)|0;return a|0}do{c=(c|0)/2|0;b=(b|0)/2|0}while((c+65536|0)>>>0>131072);a=(c|0)/(b|0)|0;return a|0}return 0}function Hj(a,b){a=a|0;b=b|0;var c=0,d=0;c=f[a+60>>2]|0;d=(f[a+56>>2]|0)-c|0;if((c+65536|0)>>>0>131072)do{d=(d|0)/2|0;c=(c|0)/2|0}while((c+65536|0)>>>0>131072);if((d+65536|0)>>>0>131072)do{d=(d|0)/2|0;c=(c|0)/2|0}while((d+65536|0)>>>0>131072);d=(X(Gj(a,b)|0,c)|0)+d|0;if((c+65536|0)>>>0>131072)do{d=(d|0)/2|0;c=(c|0)/2|0}while((c+65536|0)>>>0>131072);if((d+65536|0)>>>0<=131072){a=d;b=c;d=(b|0)/2|0;a=d+a|0;b=(a|0)/(b|0)|0;return b|0}do{d=(d|0)/2|0;c=(c|0)/2|0}while((d+65536|0)>>>0>131072);b=(c|0)/2|0;b=b+d|0;b=(b|0)/(c|0)|0;return b|0}function Ij(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;c=b+-1|0;if((b+65535|0)>>>0>131072){b=2;do{c=(c|0)/2|0;b=(b|0)/2|0}while((c+65536|0)>>>0>131072)}else b=2;e=f[a+84>>2]|0;d=f[a+80>>2]|0;if((e|0)==(b|0)){c=d+c|0;if((b+65536|0)>>>0>131072)do{c=(c|0)/2|0;b=(b|0)/2|0}while((b+65536|0)>>>0>131072);if((c+65536|0)>>>0>131072)do{c=(c|0)/2|0;b=(b|0)/2|0}while((c+65536|0)>>>0>131072)}else{c=(X(d,b)|0)+(X(e,c)|0)|0;b=X(e,b)|0;if((b+65536|0)>>>0>131072)do{c=(c|0)/2|0;b=(b|0)/2|0}while((b+65536|0)>>>0>131072);if((c+65536|0)>>>0>131072)do{c=(c|0)/2|0;b=(b|0)/2|0}while((c+65536|0)>>>0>131072)}d=f[a+68>>2]|0;e=(f[a+64>>2]|0)-d|0;if((d+65536|0)>>>0>131072)do{e=(e|0)/2|0;d=(d|0)/2|0}while((d+65536|0)>>>0>131072);if((e+65536|0)>>>0>131072)do{e=(e|0)/2|0;d=(d|0)/2|0}while((e+65536|0)>>>0>131072);d=d<<1;if((d+65536|0)>>>0>131072)do{e=(e|0)/2|0;d=(d|0)/2|0}while((d+65536|0)>>>0>131072);if((e+65536|0)>>>0>131072)do{e=(e|0)/2|0;d=(d|0)/2|0}while((e+65536|0)>>>0>131072);if((b|0)==(d|0)){c=c-e|0;if((b+65536|0)>>>0>131072)do{c=(c|0)/2|0;b=(b|0)/2|0}while((b+65536|0)>>>0>131072);if((c+65536|0)>>>0<=131072){e=c;a=b;d=(a|0)/2|0;e=d+e|0;a=(e|0)/(a|0)|0;return a|0}do{c=(c|0)/2|0;b=(b|0)/2|0}while((c+65536|0)>>>0>131072);a=(b|0)/2|0;a=a+c|0;a=(a|0)/(b|0)|0;return a|0}else{c=(X(d,c)|0)-(X(e,b)|0)|0;b=X(d,b)|0;if((b+65536|0)>>>0>131072)do{c=(c|0)/2|0;b=(b|0)/2|0}while((b+65536|0)>>>0>131072);if((c+65536|0)>>>0<=131072){e=c;a=b;d=(a|0)/2|0;e=d+e|0;a=(e|0)/(a|0)|0;return a|0}do{c=(c|0)/2|0;b=(b|0)/2|0}while((c+65536|0)>>>0>131072);a=(b|0)/2|0;a=a+c|0;a=(a|0)/(b|0)|0;return a|0}return 0}function Jj(a,b){a=a|0;b=b|0;var c=0,d=0;c=f[a+68>>2]|0;d=(f[a+64>>2]|0)-c|0;if((c+65536|0)>>>0>131072)do{d=(d|0)/2|0;c=(c|0)/2|0}while((c+65536|0)>>>0>131072);if((d+65536|0)>>>0>131072)do{d=(d|0)/2|0;c=(c|0)/2|0}while((d+65536|0)>>>0>131072);d=(X(Ij(a,b)|0,c)|0)+d|0;if((c+65536|0)>>>0>131072)do{d=(d|0)/2|0;c=(c|0)/2|0}while((c+65536|0)>>>0>131072);if((d+65536|0)>>>0<=131072){a=d;b=c;d=(b|0)/2|0;a=d+a|0;b=(a|0)/(b|0)|0;return b|0}do{d=(d|0)/2|0;c=(c|0)/2|0}while((d+65536|0)>>>0>131072);b=(c|0)/2|0;b=b+d|0;b=(b|0)/(c|0)|0;return b|0}function Kj(a){a=a|0;var b=0,c=0,d=0,e=0,g=0;g=f[a+60>>2]|0;b=(f[a+56>>2]|0)-g|0;e=(g+65536|0)>>>0>131072;if(e){c=b;a=g;do{c=(c|0)/2|0;a=(a|0)/2|0}while((a+65536|0)>>>0>131072)}else{c=b;a=g}if((c+65536|0)>>>0>131072)do{c=(c|0)/2|0;a=(a|0)/2|0}while((c+65536|0)>>>0>131072);a=a<<1;if((a+65536|0)>>>0>131072)do{c=(c|0)/2|0;a=(a|0)/2|0}while((a+65536|0)>>>0>131072);if((c+65536|0)>>>0>131072)do{c=(c|0)/2|0;a=(a|0)/2|0}while((c+65536|0)>>>0>131072);d=0-c|0;if((a|0)==1)if((65536-c|0)>>>0>131072){a=1;do{d=(d|0)/2|0;a=(a|0)/2|0}while((d+65536|0)>>>0>131072)}else a=1;else{if((a+65536|0)>>>0>131072)do{d=(d|0)/2|0;a=(a|0)/2|0}while((a+65536|0)>>>0>131072);if((d+65536|0)>>>0>131072)do{d=(d|0)/2|0;a=(a|0)/2|0}while((d+65536|0)>>>0>131072)}c=(((a|0)/2|0)+d|0)/(a|0)|0;if(e){a=g;do{b=(b|0)/2|0;a=(a|0)/2|0}while((a+65536|0)>>>0>131072)}else a=g;if((b+65536|0)>>>0>131072)do{b=(b|0)/2|0;a=(a|0)/2|0}while((b+65536|0)>>>0>131072);a=a<<1;if((a+65536|0)>>>0>131072)do{b=(b|0)/2|0;a=(a|0)/2|0}while((a+65536|0)>>>0>131072);if((b+65536|0)>>>0<=131072){e=b;g=a;d=(g|0)/2|0;e=d+e|0;g=(e|0)/(g|0)|0;e=1-c|0;g=e+g|0;return g|0}do{b=(b|0)/2|0;a=(a|0)/2|0}while((b+65536|0)>>>0>131072);g=(a|0)/2|0;g=g+b|0;g=(g|0)/(a|0)|0;e=1-c|0;g=e+g|0;return g|0}function Lj(a){a=a|0;var b=0,c=0,d=0,e=0,g=0;g=f[a+68>>2]|0;b=(f[a+64>>2]|0)-g|0;e=(g+65536|0)>>>0>131072;if(e){c=b;a=g;do{c=(c|0)/2|0;a=(a|0)/2|0}while((a+65536|0)>>>0>131072)}else{c=b;a=g}if((c+65536|0)>>>0>131072)do{c=(c|0)/2|0;a=(a|0)/2|0}while((c+65536|0)>>>0>131072);a=a<<1;if((a+65536|0)>>>0>131072)do{c=(c|0)/2|0;a=(a|0)/2|0}while((a+65536|0)>>>0>131072);if((c+65536|0)>>>0>131072)do{c=(c|0)/2|0;a=(a|0)/2|0}while((c+65536|0)>>>0>131072);d=0-c|0;if((a|0)==1)if((65536-c|0)>>>0>131072){a=1;do{d=(d|0)/2|0;a=(a|0)/2|0}while((d+65536|0)>>>0>131072)}else a=1;else{if((a+65536|0)>>>0>131072)do{d=(d|0)/2|0;a=(a|0)/2|0}while((a+65536|0)>>>0>131072);if((d+65536|0)>>>0>131072)do{d=(d|0)/2|0;a=(a|0)/2|0}while((d+65536|0)>>>0>131072)}c=(((a|0)/2|0)+d|0)/(a|0)|0;if(e){a=g;do{b=(b|0)/2|0;a=(a|0)/2|0}while((a+65536|0)>>>0>131072)}else a=g;if((b+65536|0)>>>0>131072)do{b=(b|0)/2|0;a=(a|0)/2|0}while((b+65536|0)>>>0>131072);a=a<<1;if((a+65536|0)>>>0>131072)do{b=(b|0)/2|0;a=(a|0)/2|0}while((a+65536|0)>>>0>131072);if((b+65536|0)>>>0<=131072){e=b;g=a;d=(g|0)/2|0;e=d+e|0;g=(e|0)/(g|0)|0;e=1-c|0;g=e+g|0;return g|0}do{b=(b|0)/2|0;a=(a|0)/2|0}while((b+65536|0)>>>0>131072);g=(a|0)/2|0;g=g+b|0;g=(g|0)/(a|0)|0;e=1-c|0;g=e+g|0;return g|0}function Mj(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0;f[a>>2]=0;h=a+4|0;f[h>>2]=0;f[a+8>>2]=0;d=f[b+56>>2]|0;g=f[b+60>>2]|0;if((d|0)==(g|0))return;e=a+8|0;b=d;do{do if((f[b+48>>2]|0)==(c|0)){d=f[h>>2]|0;if((d|0)==(f[e>>2]|0)){Zg(a,b);break}else{Yg(d,b);f[h>>2]=(f[h>>2]|0)+64;break}}while(0);b=b+64|0}while((b|0)!=(g|0));return}function Nj(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=f[b+56>>2]|0;b=f[b+60>>2]|0;a:do if((e|0)!=(b|0)){while(1){if((f[e+48>>2]|0)==(c|0)?(f[e+20>>2]|0)==(d|0):0)break;e=e+64|0;if((e|0)==(b|0))break a}kg(a,e+52|0);return}while(0);f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;return}function Oj(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0;z=u;u=u+32|0;v=z+20|0;t=z+16|0;s=z+12|0;w=z+8|0;x=z+4|0;y=z;d=f[a+92>>2]|0;r=f[a+96>>2]|0;if((d|0)==(r|0)){u=z;return 1}p=c+4|0;q=c+8|0;a:while(1){a=f[d+4>>2]|0;o=f[d+8>>2]|0;if((a|0)!=(o|0))do{n=a+4|0;j=((f[n>>2]|0)-(f[a>>2]|0)|0)>>>24&255;e=f[p>>2]|0;m=f[q>>2]|0;g=m;if(e>>>0>=m>>>0){m=f[c>>2]|0;k=e-m|0;e=k+1|0;l=m;if((e|0)<0){a=9;break a}i=g-m|0;h=i<<1;h=i>>>0<1073741823?(h>>>0<e>>>0?e:h):2147483647;if(!h)i=0;else i=OK(h)|0;g=i+k|0;b[g>>0]=j;e=g+1|0;g=g+(0-k)|0;if((k|0)>0)GM(g|0,l|0,k|0)|0;f[c>>2]=g;f[p>>2]=e;f[q>>2]=i+h;if(m){QK(l);e=f[p>>2]|0}}else{b[e>>0]=j;e=(f[p>>2]|0)+1|0;f[p>>2]=e}j=((f[n>>2]|0)-(f[a>>2]|0)|0)>>>16&255;m=f[q>>2]|0;g=m;if(e>>>0>=m>>>0){m=f[c>>2]|0;k=e-m|0;e=k+1|0;l=m;if((e|0)<0){a=19;break a}i=g-m|0;h=i<<1;h=i>>>0<1073741823?(h>>>0<e>>>0?e:h):2147483647;if(!h)i=0;else i=OK(h)|0;g=i+k|0;b[g>>0]=j;e=g+1|0;g=g+(0-k)|0;if((k|0)>0)GM(g|0,l|0,k|0)|0;f[c>>2]=g;f[p>>2]=e;f[q>>2]=i+h;if(m){QK(l);e=f[p>>2]|0}}else{b[e>>0]=j;e=(f[p>>2]|0)+1|0;f[p>>2]=e}j=((f[n>>2]|0)-(f[a>>2]|0)|0)>>>8&255;m=f[q>>2]|0;g=m;if(e>>>0>=m>>>0){m=f[c>>2]|0;k=e-m|0;e=k+1|0;l=m;if((e|0)<0){a=29;break a}i=g-m|0;h=i<<1;h=i>>>0<1073741823?(h>>>0<e>>>0?e:h):2147483647;if(!h)i=0;else i=OK(h)|0;g=i+k|0;b[g>>0]=j;e=g+1|0;g=g+(0-k)|0;if((k|0)>0)GM(g|0,l|0,k|0)|0;f[c>>2]=g;f[p>>2]=e;f[q>>2]=i+h;if(m){QK(l);e=f[p>>2]|0}}else{b[e>>0]=j;e=(f[p>>2]|0)+1|0;f[p>>2]=e}j=(f[n>>2]|0)-(f[a>>2]|0)&255;m=f[q>>2]|0;g=m;if(e>>>0>=m>>>0){m=f[c>>2]|0;k=e-m|0;e=k+1|0;l=m;if((e|0)<0){a=39;break a}i=g-m|0;h=i<<1;h=i>>>0<1073741823?(h>>>0<e>>>0?e:h):2147483647;if(!h)i=0;else i=OK(h)|0;g=i+k|0;b[g>>0]=j;e=g+1|0;g=g+(0-k)|0;if((k|0)>0)GM(g|0,l|0,k|0)|0;f[c>>2]=g;f[p>>2]=e;f[q>>2]=i+h;if(m){QK(l);e=f[p>>2]|0}}else{b[e>>0]=j;e=(f[p>>2]|0)+1|0;f[p>>2]=e}f[w>>2]=e;f[x>>2]=f[a>>2];f[y>>2]=f[n>>2];f[s>>2]=f[w>>2];f[t>>2]=f[x>>2];f[v>>2]=f[y>>2];Pj(c,s,t,v)|0;a=a+12|0}while((a|0)!=(o|0));d=d+16|0;if((d|0)==(r|0)){a=3;break}}if((a|0)==3){u=z;return 1}else if((a|0)==9)$I(c);else if((a|0)==19)$I(c);else if((a|0)==29)$I(c);else if((a|0)==39)$I(c);return 0}function Pj(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;m=f[a>>2]|0;j=m;k=(f[c>>2]|0)-j|0;c=m+k|0;g=f[d>>2]|0;h=f[e>>2]|0;l=h-g|0;o=h;if((l|0)<=0){q=c;return q|0}p=a+8|0;i=f[p>>2]|0;q=a+4|0;n=f[q>>2]|0;e=n;if((l|0)<=(i-e|0)){i=e-c|0;if((l|0)>(i|0)){e=g+i|0;h=e;if((e|0)==(o|0))e=n;else{g=n;do{b[g>>0]=b[e>>0]|0;e=e+1|0;g=(f[q>>2]|0)+1|0;f[q>>2]=g}while((e|0)!=(o|0));e=g}if((i|0)>0)j=e;else{q=c;return q|0}}else j=n;i=j-(c+l)|0;e=c+i|0;if(e>>>0<n>>>0){g=j;do{b[g>>0]=b[e>>0]|0;e=e+1|0;g=(f[q>>2]|0)+1|0;f[q>>2]=g}while((e|0)!=(n|0))}if(i|0)HM(j+(0-i)|0,c|0,i|0)|0;e=f[d>>2]|0;if((e|0)==(h|0)){q=c;return q|0}else g=c;while(1){b[g>>0]=b[e>>0]|0;e=e+1|0;if((e|0)==(h|0))break;else g=g+1|0}return c|0}e=e-j+l|0;if((e|0)<0)$I(a);j=i-j|0;h=j<<1;h=j>>>0<1073741823?(h>>>0<e>>>0?e:h):2147483647;j=c;if(!h)i=0;else i=OK(h)|0;l=i+k|0;e=l;k=i+h|0;if((g|0)==(o|0))h=m;else{h=l;do{b[h>>0]=b[g>>0]|0;h=e+1|0;e=h;g=g+1|0}while((g|0)!=(o|0));h=f[a>>2]|0}g=j-h|0;i=l+(0-g)|0;if((g|0)>0)GM(i|0,h|0,g|0)|0;g=(f[q>>2]|0)-j|0;if((g|0)>0){GM(e|0,c|0,g|0)|0;e=e+g|0;c=f[a>>2]|0}else c=h;f[a>>2]=i;f[q>>2]=e;f[p>>2]=k;if(!c){q=l;return q|0}QK(c);q=l;return q|0}function Qj(a){a=a|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;f[a+12>>2]=0;f[a+16>>2]=0;return}function Rj(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;f[a>>2]=b;f[a+4>>2]=c;ZK(a+8|0,d);return}function Sj(a){a=a|0;var b=0;do switch(a|0){case 0:{b=25409;break}case 100:{b=25386;break}case 101:{b=25369;break}case 118:{b=25351;break}case 119:{b=25331;break}case 102:{b=25317;break}case 103:{b=25303;break}case 104:{b=25289;break}case 105:{b=25275;break}case 106:{b=25261;break}case 131:{b=25247;break}case 107:{b=25233;break}case 108:{b=25219;break}case 109:{b=25205;break}case 110:{b=25191;break}case 111:{b=25177;break}case 112:{b=25163;break}case 113:{b=25149;break}case 125:{b=25135;break}case 114:{b=25114;break}case 115:{b=25068;break}case 116:{b=25037;break}case 117:{b=25020;break}case 120:{b=24983;break}case 121:{b=24962;break}case 122:{b=24925;break}case 123:{b=24889;break}case 124:{b=24862;break}case 126:{b=24835;break}case 127:{b=24804;break}case 128:{b=24778;break}case 129:{b=24759;break}case 130:{b=24742;break}case 132:{b=24713;break}case 1e3:{b=24689;break}case 2e3:{b=24657;break}case 2001:{b=24634;break}case 2002:{b=24596;break}case 2003:{b=24546;break}case 2004:{b=24496;break}case 2005:{b=24474;break}case 2006:{b=24450;break}case 3e3:{b=24432;break}case 3001:{b=24409;break}case 3002:{b=24384;break}case 3003:{b=24355;break}case 3004:{b=24318;break}case 4e3:{b=24296;break}case 5e3:{b=24271;break}default:Pa(55956,23985,200,23994)}while(0);return b|0}function Tj(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;p=u;u=u+176|0;g=p+160|0;n=p+16|0;o=p;e=f[c>>2]|0;if(!d){f[a>>2]=e;f[a+4>>2]=f[c+4>>2];c=6168;c=f[c>>2]|0;a=a+8|0;f[a>>2]=c;u=p;return}if(!e){h=d+12|0;f[h>>2]=32432;g=c+4|0;e=0}else{k=n+64|0;m=n+8|0;f[m>>2]=4524;l=n+12|0;f[n>>2]=188;f[k>>2]=208;f[n+4>>2]=0;bB(n+64|0,l);f[n+136>>2]=0;f[n+140>>2]=-1;f[n>>2]=4504;f[k>>2]=4544;f[m>>2]=4524;fB(l);f[l>>2]=4340;m=n+44|0;f[m>>2]=0;f[m+4>>2]=0;f[m+8>>2]=0;f[m+12>>2]=0;f[n+60>>2]=24;f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;ce(l,g);if((b[g+11>>0]|0)<0)QK(f[g>>2]|0);j=n+8|0;do switch(f[c>>2]|0){case 0:{h=32432;break}case 1:{h=24245;break}case 2:{h=24231;break}case 3:{h=24209;break}case 4:{h=24189;break}case 5:{h=24177;break}case 6:{h=24153;break}case 7:{h=24119;break}case 8:{h=24085;break}case 9:{h=24040;break}case 10:{h=24011;break}default:Pa(55956,23985,74,23994)}while(0);i=de(de(j,h,vx(h)|0)|0,25421,2)|0;g=c+4|0;h=Sj(f[g>>2]|0)|0;de(i,h,vx(h)|0)|0;h=c+8|0;i=h+11|0;e=b[i>>0]|0;if(e<<24>>24<0)e=f[c+12>>2]|0;else e=e&255;if(e|0){q=de(j,25421,2)|0;i=b[i>>0]|0;e=i<<24>>24<0;de(q,e?f[h>>2]|0:h,e?f[c+12>>2]|0:i&255)|0}fe(o,l);$K(d,o)|0;if((b[d+11>>0]|0)<0)e=f[d>>2]|0;else e=d;h=d+12|0;f[h>>2]=e;if((b[o+11>>0]|0)<0)QK(f[o>>2]|0);f[n>>2]=4504;f[k>>2]=4544;f[j>>2]=4524;f[l>>2]=4340;if((b[m+11>>0]|0)<0)QK(f[m>>2]|0);Rz(l);ZA(n,4556);Mz(k);e=f[c>>2]|0}f[a>>2]=e;f[a+4>>2]=f[g>>2];c=h;c=f[c>>2]|0;q=a+8|0;f[q>>2]=c;u=p;return}function Uj(a){a=a|0;var b=0,c=0,d=0;f[a+112>>2]=0;f[a+116>>2]=0;c=a+112|0;d=a+108|0;b=a+108|0;do{f[a>>2]=0;a=a+4|0}while((a|0)<(b|0));f[d>>2]=c;return}function Vj(a){a=a|0;var b=0,c=0,d=0,e=0,g=0;Wj(a+108|0,f[a+112>>2]|0);b=f[a+104>>2]|0;if(b|0)KK(b);b=f[a+96>>2]|0;if(b|0)KK(b);b=f[a+88>>2]|0;if(b|0)KK(b);b=f[a+80>>2]|0;if(b|0)KK(b);b=f[a+72>>2]|0;if(b|0)KK(b);b=f[a+64>>2]|0;if(b|0)KK(b);b=f[a+56>>2]|0;if(b|0)KK(b);b=f[a+48>>2]|0;if(b|0)KK(b);b=f[a+40>>2]|0;if(b|0)KK(b);b=f[a+32>>2]|0;if(b|0)KK(b);b=f[a+24>>2]|0;if(b|0)KK(b);e=a+8|0;b=f[e>>2]|0;if(b|0){g=a+12|0;c=f[g>>2]|0;if((c|0)!=(b|0)){do{d=c+-8|0;f[g>>2]=d;c=f[c+-4>>2]|0;if(!c)c=d;else{KK(c);c=f[g>>2]|0}}while((c|0)!=(b|0));b=f[e>>2]|0}QK(b)}b=f[a+4>>2]|0;if(!b)return;KK(b);return}function Wj(a,b){a=a|0;b=b|0;if(!b)return;Wj(a,f[b>>2]|0);Wj(a,f[b+4>>2]|0);a=f[b+24>>2]|0;if(a|0)KK(a);QK(b);return}function Xj(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0;k=u;u=u+16|0;i=k;f[a>>2]=0;j=a+4|0;f[j>>2]=0;f[a+8>>2]=0;c=f[b+108>>2]|0;g=b+112|0;if((c|0)==(g|0)){u=k;return}h=a+8|0;e=c;c=0;d=0;while(1){b=f[(f[e+20>>2]|0)+56>>2]|0;f[i>>2]=b;if(c>>>0<d>>>0){f[c>>2]=b;f[j>>2]=c+4}else Fe(a,i);b=f[e+4>>2]|0;if(!b){c=e+8|0;b=f[c>>2]|0;if((f[b>>2]|0)!=(e|0))do{e=f[c>>2]|0;c=e+8|0;b=f[c>>2]|0}while((f[b>>2]|0)!=(e|0))}else while(1){c=f[b>>2]|0;if(!c)break;else b=c}if((b|0)==(g|0))break;e=b;c=f[j>>2]|0;d=f[h>>2]|0}u=k;return}function Yj(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0;j=u;u=u+48|0;i=j;h=j+32|0;g=f[c>>2]|0;d=f[c+4>>2]|0;if(d|0)IK(d);f[b>>2]=g;e=b+4|0;c=f[e>>2]|0;f[e>>2]=d;if(!c)c=g;else{KK(c);c=f[b>>2]|0;d=f[e>>2]|0}f[h>>2]=c;c=h+4|0;f[c>>2]=d;if(d|0)IK(d);Dd(i,h,-1,2147483647,0);c=f[c>>2]|0;if(c|0)KK(c);Zj(a,b,i);c=f[i+4>>2]|0;if(!c){u=j;return}KK(c);u=j;return}
function Cn(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,o=0,p=0,q=0,r=0.0,s=0.0,t=0.0,v=0.0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0;xa=u;u=u+256|0;ia=xa+96|0;wa=xa+232|0;va=xa+168|0;ta=xa+156|0;w=xa+80|0;oa=xa+144|0;pa=xa+208|0;qa=xa+184|0;na=xa+180|0;la=xa;ka=xa+244|0;ma=xa+64|0;ja=xa+48|0;i=f[a>>2]|0;sa=a+4|0;g=f[sa>>2]|0;if((g|0)!=(i|0))do{h=g+-8|0;f[sa>>2]=h;g=f[g+-4>>2]|0;if(!g)g=h;else{KK(g);g=f[sa>>2]|0}}while((g|0)!=(i|0));ga=a+12|0;f[ga>>2]=f[d>>2];f[ga+4>>2]=f[d+4>>2];f[ga+8>>2]=f[d+8>>2];f[ga+12>>2]=f[d+12>>2];ga=d+16|0;g=f[ga>>2]|0;ha=d+20|0;h=f[ha>>2]|0;if(h|0)IK(h);f[a+28>>2]=g;ua=a+32|0;g=f[ua>>2]|0;f[ua>>2]=h;if(g|0)KK(g);f[a+36>>2]=f[e>>2];if((((f[c>>2]|0)==(f[d>>2]|0)?(f[c+4>>2]|0)==(f[d+4>>2]|0):0)?(b[c+8>>0]|0)==(b[d+8>>0]|0):0)?(f[c+12>>2]|0)==(f[d+12>>2]|0):0){wa=1;u=xa;return wa|0}f[wa>>2]=0;ua=wa+4|0;f[ua>>2]=0;f[wa+8>>2]=0;k=OK(16)|0;f[k+4>>2]=0;f[k+8>>2]=0;f[k>>2]=6932;g=k+12|0;f[g>>2]=6492;f[ia>>2]=g;g=ia+4|0;f[g>>2]=k;k=wa+8|0;Dn(wa,ia);g=f[g>>2]|0;if(g|0)KK(g);h=OK(16)|0;f[h+4>>2]=0;f[h+8>>2]=0;f[h>>2]=6960;g=h+12|0;f[g>>2]=6988;f[ia>>2]=g;i=ia+4|0;f[i>>2]=h;j=f[ua>>2]|0;if(j>>>0>=(f[k>>2]|0)>>>0){Dn(wa,ia);g=f[i>>2]|0;if(g|0)KK(g)}else{f[j>>2]=g;f[j+4>>2]=h;f[ia>>2]=0;f[i>>2]=0;f[ua>>2]=j+8}h=OK(16)|0;f[h+4>>2]=0;f[h+8>>2]=0;f[h>>2]=7012;g=h+12|0;f[g>>2]=7040;f[ia>>2]=g;i=ia+4|0;f[i>>2]=h;j=f[ua>>2]|0;if(j>>>0>=(f[k>>2]|0)>>>0){Dn(wa,ia);g=f[i>>2]|0;if(g|0)KK(g)}else{f[j>>2]=g;f[j+4>>2]=h;f[ia>>2]=0;f[i>>2]=0;f[ua>>2]=j+8}h=OK(16)|0;f[h+4>>2]=0;f[h+8>>2]=0;f[h>>2]=7064;g=h+12|0;f[g>>2]=6516;f[ia>>2]=g;i=ia+4|0;f[i>>2]=h;j=f[ua>>2]|0;if(j>>>0>=(f[k>>2]|0)>>>0){Dn(wa,ia);g=f[i>>2]|0;if(g|0)KK(g)}else{f[j>>2]=g;f[j+4>>2]=h;f[ia>>2]=0;f[i>>2]=0;f[ua>>2]=j+8}h=OK(16)|0;f[h+4>>2]=0;f[h+8>>2]=0;f[h>>2]=7092;g=h+12|0;f[g>>2]=6540;f[ia>>2]=g;i=ia+4|0;f[i>>2]=h;j=f[ua>>2]|0;if(j>>>0>=(f[k>>2]|0)>>>0){Dn(wa,ia);g=f[i>>2]|0;if(g|0)KK(g)}else{f[j>>2]=g;f[j+4>>2]=h;f[ia>>2]=0;f[i>>2]=0;f[ua>>2]=j+8}h=OK(16)|0;f[h+4>>2]=0;f[h+8>>2]=0;f[h>>2]=7120;g=h+12|0;f[g>>2]=6908;f[ia>>2]=g;i=ia+4|0;f[i>>2]=h;j=f[ua>>2]|0;if(j>>>0>=(f[k>>2]|0)>>>0){Dn(wa,ia);g=f[i>>2]|0;if(g|0)KK(g)}else{f[j>>2]=g;f[j+4>>2]=h;f[ia>>2]=0;f[i>>2]=0;f[ua>>2]=j+8}h=OK(16)|0;f[h+4>>2]=0;f[h+8>>2]=0;f[h>>2]=7148;g=h+12|0;f[g>>2]=6564;f[ia>>2]=g;i=ia+4|0;f[i>>2]=h;j=f[ua>>2]|0;if(j>>>0>=(f[k>>2]|0)>>>0){Dn(wa,ia);g=f[i>>2]|0;if(g|0)KK(g)}else{f[j>>2]=g;f[j+4>>2]=h;f[ia>>2]=0;f[i>>2]=0;f[ua>>2]=j+8}h=OK(16)|0;f[h+4>>2]=0;f[h+8>>2]=0;f[h>>2]=7176;g=h+12|0;f[g>>2]=6588;f[ia>>2]=g;i=ia+4|0;f[i>>2]=h;j=f[ua>>2]|0;if(j>>>0>=(f[k>>2]|0)>>>0){Dn(wa,ia);g=f[i>>2]|0;if(g|0)KK(g)}else{f[j>>2]=g;f[j+4>>2]=h;f[ia>>2]=0;f[i>>2]=0;f[ua>>2]=j+8}h=OK(16)|0;f[h+4>>2]=0;f[h+8>>2]=0;f[h>>2]=7204;g=h+12|0;f[g>>2]=6660;f[ia>>2]=g;i=ia+4|0;f[i>>2]=h;j=f[ua>>2]|0;if(j>>>0>=(f[k>>2]|0)>>>0){Dn(wa,ia);g=f[i>>2]|0;if(g|0)KK(g)}else{f[j>>2]=g;f[j+4>>2]=h;f[ia>>2]=0;f[i>>2]=0;f[ua>>2]=j+8}h=OK(16)|0;f[h+4>>2]=0;f[h+8>>2]=0;f[h>>2]=7232;g=h+12|0;f[g>>2]=6684;f[ia>>2]=g;i=ia+4|0;f[i>>2]=h;j=f[ua>>2]|0;if(j>>>0>=(f[k>>2]|0)>>>0){Dn(wa,ia);g=f[i>>2]|0;if(g|0)KK(g)}else{f[j>>2]=g;f[j+4>>2]=h;f[ia>>2]=0;f[i>>2]=0;f[ua>>2]=j+8}h=OK(16)|0;f[h+4>>2]=0;f[h+8>>2]=0;f[h>>2]=7260;g=h+12|0;f[g>>2]=6636;f[ia>>2]=g;i=ia+4|0;f[i>>2]=h;j=f[ua>>2]|0;if(j>>>0>=(f[k>>2]|0)>>>0){Dn(wa,ia);g=f[i>>2]|0;if(g|0)KK(g)}else{f[j>>2]=g;f[j+4>>2]=h;f[ia>>2]=0;f[i>>2]=0;f[ua>>2]=j+8}h=OK(16)|0;f[h+4>>2]=0;f[h+8>>2]=0;f[h>>2]=7288;g=h+12|0;f[g>>2]=6612;f[ia>>2]=g;i=ia+4|0;f[i>>2]=h;j=f[ua>>2]|0;if(j>>>0>=(f[k>>2]|0)>>>0){Dn(wa,ia);g=f[i>>2]|0;if(g|0)KK(g)}else{f[j>>2]=g;f[j+4>>2]=h;f[ia>>2]=0;f[i>>2]=0;f[ua>>2]=j+8}h=OK(16)|0;f[h+4>>2]=0;f[h+8>>2]=0;f[h>>2]=7316;g=h+12|0;f[g>>2]=6708;f[ia>>2]=g;i=ia+4|0;f[i>>2]=h;j=f[ua>>2]|0;if(j>>>0>=(f[k>>2]|0)>>>0){Dn(wa,ia);g=f[i>>2]|0;if(g|0)KK(g)}else{f[j>>2]=g;f[j+4>>2]=h;f[ia>>2]=0;f[i>>2]=0;f[ua>>2]=j+8}h=OK(16)|0;f[h+4>>2]=0;f[h+8>>2]=0;f[h>>2]=7344;g=h+12|0;f[g>>2]=6732;f[ia>>2]=g;i=ia+4|0;f[i>>2]=h;j=f[ua>>2]|0;if(j>>>0>=(f[k>>2]|0)>>>0){Dn(wa,ia);g=f[i>>2]|0;if(g|0)KK(g)}else{f[j>>2]=g;f[j+4>>2]=h;f[ia>>2]=0;f[i>>2]=0;f[ua>>2]=j+8}h=OK(16)|0;f[h+4>>2]=0;f[h+8>>2]=0;f[h>>2]=7372;g=h+12|0;f[g>>2]=7400;f[ia>>2]=g;i=ia+4|0;f[i>>2]=h;j=f[ua>>2]|0;do if(j>>>0<(f[k>>2]|0)>>>0){f[j>>2]=g;f[j+4>>2]=h;f[ia>>2]=0;f[i>>2]=0;f[ua>>2]=j+8}else{Dn(wa,ia);g=f[i>>2]|0;if(!g)break;KK(g)}while(0);h=OK(16)|0;f[h+4>>2]=0;f[h+8>>2]=0;f[h>>2]=7424;g=h+12|0;f[g>>2]=7452;f[ia>>2]=g;i=ia+4|0;f[i>>2]=h;j=f[ua>>2]|0;do if(j>>>0<(f[k>>2]|0)>>>0){f[j>>2]=g;f[j+4>>2]=h;f[ia>>2]=0;f[i>>2]=0;f[ua>>2]=j+8}else{Dn(wa,ia);g=f[i>>2]|0;if(!g)break;KK(g)}while(0);h=OK(16)|0;f[h+4>>2]=0;f[h+8>>2]=0;f[h>>2]=7476;g=h+12|0;f[g>>2]=6756;f[ia>>2]=g;i=ia+4|0;f[i>>2]=h;j=f[ua>>2]|0;do if(j>>>0<(f[k>>2]|0)>>>0){f[j>>2]=g;f[j+4>>2]=h;f[ia>>2]=0;f[i>>2]=0;f[ua>>2]=j+8}else{Dn(wa,ia);g=f[i>>2]|0;if(!g)break;KK(g)}while(0);h=OK(16)|0;f[h+4>>2]=0;f[h+8>>2]=0;f[h>>2]=7504;g=h+12|0;f[g>>2]=6780;f[ia>>2]=g;i=ia+4|0;f[i>>2]=h;j=f[ua>>2]|0;do if(j>>>0<(f[k>>2]|0)>>>0){f[j>>2]=g;f[j+4>>2]=h;f[ia>>2]=0;f[i>>2]=0;f[ua>>2]=j+8}else{Dn(wa,ia);g=f[i>>2]|0;if(!g)break;KK(g)}while(0);h=OK(16)|0;f[h+4>>2]=0;f[h+8>>2]=0;f[h>>2]=7532;g=h+12|0;f[g>>2]=6832;f[ia>>2]=g;i=ia+4|0;f[i>>2]=h;j=f[ua>>2]|0;do if(j>>>0<(f[k>>2]|0)>>>0){f[j>>2]=g;f[j+4>>2]=h;f[ia>>2]=0;f[i>>2]=0;f[ua>>2]=j+8}else{Dn(wa,ia);g=f[i>>2]|0;if(!g)break;KK(g)}while(0);h=OK(16)|0;f[h+4>>2]=0;f[h+8>>2]=0;f[h>>2]=7560;g=h+12|0;f[g>>2]=6884;f[ia>>2]=g;i=ia+4|0;f[i>>2]=h;j=f[ua>>2]|0;do if(j>>>0<(f[k>>2]|0)>>>0){f[j>>2]=g;f[j+4>>2]=h;f[ia>>2]=0;f[i>>2]=0;f[ua>>2]=j+8}else{Dn(wa,ia);g=f[i>>2]|0;if(!g)break;KK(g)}while(0);f[va>>2]=0;fa=va+4|0;f[fa>>2]=0;f[va+8>>2]=0;f[ta>>2]=0;ea=ta+4|0;f[ea>>2]=0;f[ta+8>>2]=0;f[w>>2]=f[c>>2];f[w+4>>2]=f[c+4>>2];f[w+8>>2]=f[c+8>>2];f[w+12>>2]=f[c+12>>2];j=f[c+16>>2]|0;p=f[c+20>>2]|0;q=(p|0)==0;if(!q)IK(p);l=ia+4|0;o=ia+8|0;m=ia+12|0;c=ia+28|0;f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;f[c+12>>2]=0;f[c+16>>2]=0;f[ia>>2]=-1;f[l>>2]=0;f[o>>2]=0;f[m>>2]=f[w>>2];f[m+4>>2]=f[w+4>>2];f[m+8>>2]=f[w+8>>2];f[m+12>>2]=f[w+12>>2];c=ia+28|0;h=p;do if(q){da=ia+32|0;f[c>>2]=j;f[da>>2]=h;j=da;k=c;h=da}else{IK(p);i=ia+32|0;g=f[i>>2]|0;f[c>>2]=j;f[i>>2]=h;if(!g){j=i;k=c;h=i;break}KK(g);j=i;k=c;h=i}while(0);n[ia+36>>2]=0.0;n[ia+40>>2]=0.0;n[ia+44>>2]=0.0;g=f[ea>>2]|0;da=ta+8|0;do if(g>>>0<(f[da>>2]|0)>>>0){f[g>>2]=f[ia>>2];f[g+4>>2]=f[l>>2];f[g+8>>2]=f[o>>2];f[l>>2]=0;f[o>>2]=0;ca=g+12|0;f[ca>>2]=f[m>>2];f[ca+4>>2]=f[m+4>>2];f[ca+8>>2]=f[m+8>>2];f[ca+12>>2]=f[m+12>>2];f[g+28>>2]=f[k>>2];f[g+32>>2]=f[h>>2];f[c>>2]=0;f[j>>2]=0;ca=g+36|0;ba=ia+36|0;f[ca>>2]=f[ba>>2];f[ca+4>>2]=f[ba+4>>2];f[ca+8>>2]=f[ba+8>>2];f[ea>>2]=g+48}else{En(ta,ia);g=f[j>>2]|0;if(!g)break;KK(g)}while(0);g=f[o>>2]|0;if(g|0)KK(g);if(!q)KK(p);g=f[ta>>2]|0;h=f[ea>>2]|0;a:do if((g|0)==(h|0))j=0;else{M=va+8|0;N=d+4|0;O=d+8|0;P=d+12|0;Q=pa+16|0;R=pa+20|0;S=qa+16|0;T=qa+20|0;U=oa+4|0;V=la+4|0;W=la+8|0;X=la+12|0;Y=la+16|0;Z=la+20|0;_=la+24|0;$=la+28|0;aa=la+28|0;ba=la+32|0;J=la+36|0;K=la+40|0;L=la+44|0;ca=la+36|0;r=0.0;b:while(1){if((h|0)==(g|0))h=-1;else{j=(h-g|0)/48|0;h=-1;i=0;do{v=+n[g+(i*48|0)+36>>2]*.30000001192092896+ +n[g+(i*48|0)+40>>2]*.6000000238418579+ +n[g+(i*48|0)+44>>2]*.10000000149011612;I=(i|0)==0|v<r;r=I?v:r;h=I?i:h;i=i+1|0}while(i>>>0<j>>>0)}i=g+(h*48|0)|0;j=f[fa>>2]|0;if((j|0)==(f[M>>2]|0))Fn(va,i);else{f[j>>2]=f[i>>2];f[j+4>>2]=f[g+(h*48|0)+4>>2];i=f[g+(h*48|0)+8>>2]|0;f[j+8>>2]=i;if(i|0)IK(i);i=j+12|0;I=g+(h*48|0)+12|0;f[i>>2]=f[I>>2];f[i+4>>2]=f[I+4>>2];f[i+8>>2]=f[I+8>>2];f[i+12>>2]=f[I+12>>2];f[j+28>>2]=f[g+(h*48|0)+28>>2];i=f[g+(h*48|0)+32>>2]|0;f[j+32>>2]=i;if(i|0)IK(i);I=j+36|0;H=g+(h*48|0)+36|0;f[I>>2]=f[H>>2];f[I+4>>2]=f[H+4>>2];f[I+8>>2]=f[H+8>>2];f[fa>>2]=(f[fa>>2]|0)+48}j=f[ea>>2]|0;k=f[ta>>2]|0;f[k+(h*48|0)>>2]=f[j+-48>>2];g=f[j+-44>>2]|0;i=f[j+-40>>2]|0;if(i|0)IK(i);f[k+(h*48|0)+4>>2]=g;I=k+(h*48|0)+8|0;g=f[I>>2]|0;f[I>>2]=i;if(g|0)KK(g);g=k+(h*48|0)+12|0;i=j+-36|0;f[g>>2]=f[i>>2];f[g+4>>2]=f[i+4>>2];f[g+8>>2]=f[i+8>>2];f[g+12>>2]=f[i+12>>2];g=f[j+-20>>2]|0;i=f[j+-16>>2]|0;if(i|0)IK(i);f[k+(h*48|0)+28>>2]=g;I=k+(h*48|0)+32|0;g=f[I>>2]|0;f[I>>2]=i;if(g|0)KK(g);g=k+(h*48|0)+36|0;h=j+-12|0;f[g>>2]=f[h>>2];f[g+4>>2]=f[h+4>>2];f[g+8>>2]=f[h+8>>2];g=f[ea>>2]|0;h=g+-48|0;do{f[ea>>2]=g+-48;i=f[g+-16>>2]|0;if(i|0)KK(i);g=f[g+-40>>2]|0;if(g|0)KK(g);g=f[ea>>2]|0}while((g|0)!=(h|0));i=f[fa>>2]|0;do if((f[i+-36>>2]|0)==(f[d>>2]|0)){if((f[i+-32>>2]|0)!=(f[N>>2]|0))break;if((b[i+-28>>0]|0)!=(b[O>>0]|0))break;if((f[i+-24>>2]|0)==(f[P>>2]|0))break b}while(0);g=f[wa>>2]|0;I=f[ua>>2]|0;if((g|0)!=(I|0)){while(1){j=f[g>>2]|0;k=f[(f[j>>2]|0)+8>>2]|0;h=i+-36|0;f[pa>>2]=f[h>>2];f[pa+4>>2]=f[h+4>>2];f[pa+8>>2]=f[h+8>>2];f[pa+12>>2]=f[h+12>>2];f[Q>>2]=f[i+-20>>2];h=f[i+-16>>2]|0;f[R>>2]=h;if(h|0)IK(h);f[qa>>2]=f[d>>2];f[qa+4>>2]=f[d+4>>2];f[qa+8>>2]=f[d+8>>2];f[qa+12>>2]=f[d+12>>2];f[S>>2]=f[ga>>2];h=f[ha>>2]|0;f[T>>2]=h;if(h|0)IK(h);f[na>>2]=f[e>>2];f[ia>>2]=f[na>>2];hd[k&63](oa,j,pa,qa,ia);h=f[T>>2]|0;if(h|0)KK(h);h=f[R>>2]|0;if(h|0)KK(h);h=f[oa>>2]|0;G=f[U>>2]|0;if((h|0)!=(G|0)){H=g+4|0;do{j=f[va>>2]|0;p=f[fa>>2]|0;F=p;k=j;if((j|0)!=(p|0)){c=f[h>>2]|0;l=h+4|0;m=h+8|0;o=h+12|0;i=0;c:do{do if((f[j+12>>2]|0)==(c|0)){if((f[j+16>>2]|0)!=(f[l>>2]|0))break;if((b[j+20>>0]|0)!=(b[m>>0]|0))break;E=(f[j+24>>2]|0)==(f[o>>2]|0);i=i|E;if(E)break c}while(0);j=j+48|0}while((j|0)!=(p|0));if(!i)ra=182}else ra=182;d:do if((ra|0)==182){ra=0;i=f[ta>>2]|0;j=f[ea>>2]|0;e:do if((i|0)!=(j|0)){E=f[h>>2]|0;c=h+4|0;l=h+8|0;m=h+12|0;f:while(1){x=i+12|0;do if((f[x>>2]|0)==(E|0)){y=i+16|0;z=f[y>>2]|0;if((z|0)!=(f[c>>2]|0))break;A=i+20|0;B=b[A>>0]|0;if(B<<24>>24!=(b[l>>0]|0))break;C=i+24|0;D=f[C>>2]|0;if((D|0)==(f[m>>2]|0))break f}while(0);i=i+48|0;if((i|0)==(j|0))break e}j=h+24|0;t=+n[j>>2]+ +n[p+-12>>2];v=+n[h+28>>2]+ +n[p+-8>>2];s=+n[h+32>>2]+ +n[p+-4>>2];m=i+36|0;o=i+40|0;p=i+44|0;if(!(+n[m>>2]*.30000001192092896+ +n[o>>2]*.6000000238418579+ +n[p>>2]*.10000000149011612>t*.30000001192092896+v*.6000000238418579+s*.10000000149011612))break d;l=h+9|0;b[ka>>0]=b[l>>0]|0;b[ka+1>>0]=b[l+1>>0]|0;b[ka+2>>0]=b[l+2>>0]|0;l=f[h+16>>2]|0;q=f[h+20>>2]|0;w=(q|0)==0;if(!w)IK(q);f[ma>>2]=f[j>>2];f[ma+4>>2]=f[j+4>>2];f[ma+8>>2]=f[j+8>>2];f[la>>2]=0;f[la+4>>2]=0;f[la+8>>2]=0;j=f[g>>2]|0;c=f[H>>2]|0;if(c|0)IK(c);b[ia>>0]=b[ka>>0]|0;b[ia+1>>0]=b[ka+1>>0]|0;b[ia+2>>0]=b[ka+2>>0]|0;if(!w)IK(q);f[la>>2]=f[ma>>2];f[la+4>>2]=f[ma+4>>2];f[la+8>>2]=f[ma+8>>2];f[i>>2]=((F-k|0)/48|0)+-1;f[i+4>>2]=j;F=i+8|0;j=f[F>>2]|0;f[F>>2]=c;if(j|0)KK(j);f[x>>2]=E;f[y>>2]=z;b[A>>0]=B;F=i+21|0;b[F>>0]=b[ia>>0]|0;b[F+1>>0]=b[ia+1>>0]|0;b[F+2>>0]=b[ia+2>>0]|0;f[C>>2]=D;f[i+28>>2]=l;F=i+32|0;j=f[F>>2]|0;f[F>>2]=q;if(j|0)KK(j);f[m>>2]=f[la>>2];f[m+4>>2]=f[la+4>>2];f[m+8>>2]=f[la+8>>2];if(!w)KK(q);n[i+36>>2]=t;n[o>>2]=v;n[p>>2]=s;break d}while(0);f[ia>>2]=f[h>>2];f[ia+4>>2]=f[h+4>>2];f[ia+8>>2]=f[h+8>>2];f[ia+12>>2]=f[h+12>>2];c=f[h+16>>2]|0;l=f[h+20>>2]|0;m=(l|0)==0;if(m){j=p;i=F}else{IK(l);i=f[fa>>2]|0;j=i;k=f[va>>2]|0}t=+n[h+24>>2]+ +n[j+-12>>2];v=+n[h+28>>2]+ +n[j+-8>>2];s=+n[h+32>>2]+ +n[j+-4>>2];f[ja>>2]=f[ia>>2];f[ja+4>>2]=f[ia+4>>2];f[ja+8>>2]=f[ia+8>>2];f[ja+12>>2]=f[ia+12>>2];if(!m)IK(l);f[V>>2]=0;f[W>>2]=0;f[X>>2]=99;f[Y>>2]=99;b[Z>>0]=0;f[_>>2]=8;f[$>>2]=0;f[$+4>>2]=0;f[$+8>>2]=0;f[$+12>>2]=0;f[$+16>>2]=0;f[la>>2]=((i-k|0)/48|0)+-1;j=f[g>>2]|0;i=f[H>>2]|0;k=i;do if(!i){f[V>>2]=j;f[W>>2]=k}else{IK(i);i=f[W>>2]|0;f[V>>2]=j;f[W>>2]=k;if(!i)break;KK(i)}while(0);f[X>>2]=f[ja>>2];f[X+4>>2]=f[ja+4>>2];f[X+8>>2]=f[ja+8>>2];f[X+12>>2]=f[ja+12>>2];if(!m)IK(l);f[aa>>2]=c;i=f[ba>>2]|0;f[ba>>2]=l;if(i|0)KK(i);n[J>>2]=t;n[K>>2]=v;n[L>>2]=s;i=f[ea>>2]|0;do if(i>>>0<(f[da>>2]|0)>>>0){f[i>>2]=f[la>>2];f[i+4>>2]=f[V>>2];f[i+8>>2]=f[W>>2];f[V>>2]=0;f[W>>2]=0;F=i+12|0;f[F>>2]=f[X>>2];f[F+4>>2]=f[X+4>>2];f[F+8>>2]=f[X+8>>2];f[F+12>>2]=f[X+12>>2];f[i+28>>2]=f[aa>>2];f[i+32>>2]=f[ba>>2];f[aa>>2]=0;f[ba>>2]=0;F=i+36|0;f[F>>2]=f[ca>>2];f[F+4>>2]=f[ca+4>>2];f[F+8>>2]=f[ca+8>>2];f[ea>>2]=i+48}else{En(ta,la);i=f[ba>>2]|0;if(!i)break;KK(i)}while(0);i=f[W>>2]|0;if(i|0)KK(i);if(!m){KK(l);KK(l)}}while(0);h=h+36|0}while((h|0)!=(G|0));h=f[oa>>2]|0}if(h|0){i=f[U>>2]|0;if((i|0)!=(h|0)){do{j=i+-36|0;f[U>>2]=j;i=f[i+-16>>2]|0;if(!i)i=j;else{KK(i);i=f[U>>2]|0}}while((i|0)!=(h|0));h=f[oa>>2]|0}QK(h)}g=g+8|0;if((g|0)==(I|0))break;i=f[fa>>2]|0}h=f[ea>>2]|0}g=f[ta>>2]|0;if((g|0)==(h|0)){j=0;break a}}ra=f[va>>2]|0;g=((i-ra|0)/48|0)+-1|0;i=ra;if(!g)h=0;else{h=0;do{g=f[i+(g*48|0)>>2]|0;h=h+1|0}while((g|0)!=0)}j=f[sa>>2]|0;i=f[a>>2]|0;g=j-i>>3;do if(h>>>0>g>>>0)Gn(a,h-g|0);else{if(h>>>0>=g>>>0)break;k=i+(h<<3)|0;if((j|0)==(k|0))break;else i=j;while(1){g=i+-8|0;f[sa>>2]=g;i=f[i+-4>>2]|0;if(i){KK(i);g=f[sa>>2]|0}if((g|0)==(k|0))break;else i=g}}while(0);i=f[va>>2]|0;g=(((f[fa>>2]|0)-i|0)/48|0)+-1|0;if(g|0){l=h+-1|0;c=0;while(1){h=l-c|0;j=f[a>>2]|0;k=f[i+(g*48|0)+4>>2]|0;i=f[i+(g*48|0)+8>>2]|0;if(i|0)IK(i);f[j+(h<<3)>>2]=k;sa=j+(h<<3)+4|0;h=f[sa>>2]|0;f[sa>>2]=i;if(h|0)KK(h);i=f[va>>2]|0;g=f[i+(g*48|0)>>2]|0;if(!g)break;else c=c+1|0}}j=1;g=f[ta>>2]|0}while(0);if(g|0){h=f[ea>>2]|0;if((h|0)!=(g|0)){do{f[ea>>2]=h+-48;i=f[h+-16>>2]|0;if(i|0)KK(i);h=f[h+-40>>2]|0;if(h|0)KK(h);h=f[ea>>2]|0}while((h|0)!=(g|0));g=f[ta>>2]|0}QK(g)}g=f[va>>2]|0;if(g|0){h=f[fa>>2]|0;if((h|0)!=(g|0)){do{f[fa>>2]=h+-48;i=f[h+-16>>2]|0;if(i|0)KK(i);h=f[h+-40>>2]|0;if(h|0)KK(h);h=f[fa>>2]|0}while((h|0)!=(g|0));g=f[va>>2]|0}QK(g)}g=f[wa>>2]|0;if(g|0){h=f[ua>>2]|0;if((h|0)!=(g|0)){do{i=h+-8|0;f[ua>>2]=i;h=f[h+-4>>2]|0;if(!h)h=i;else{KK(h);h=f[ua>>2]|0}}while((h|0)!=(g|0));g=f[wa>>2]|0}QK(g)}wa=j;u=xa;return wa|0}function Dn(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=a+4|0;e=f[n>>2]|0;g=f[a>>2]|0;j=e-g>>3;c=j+1|0;k=g;if(c>>>0>536870911)$I(a);m=a+8|0;l=(f[m>>2]|0)-g|0;h=l>>2;h=l>>3>>>0<268435455?(h>>>0<c>>>0?c:h):536870911;do if(h)if(h>>>0>536870911){n=Ra(8)|0;VK(n,44736);f[n>>2]=17660;Va(n|0,4016,428)}else{i=OK(h<<3)|0;break}else i=0;while(0);d=i+(j<<3)|0;c=d;l=i+(h<<3)|0;f[d>>2]=f[b>>2];h=b+4|0;f[i+(j<<3)+4>>2]=f[h>>2];f[b>>2]=0;f[h>>2]=0;h=d+8|0;if((e|0)!=(k|0)){do{j=e;e=e+-8|0;f[d+-8>>2]=f[e>>2];j=j+-4|0;f[d+-4>>2]=f[j>>2];f[e>>2]=0;f[j>>2]=0;d=c+-8|0;c=d}while((e|0)!=(k|0));g=f[a>>2]|0}f[a>>2]=c;c=f[n>>2]|0;f[n>>2]=h;f[m>>2]=l;e=g;if((c|0)!=(e|0))do{d=f[c+-4>>2]|0;c=c+-8|0;if(d|0)KK(d)}while((c|0)!=(e|0));if(!g)return;QK(g);return}function En(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;n=a+4|0;j=f[n>>2]|0;c=f[a>>2]|0;i=(j-c|0)/48|0;d=i+1|0;l=c;e=j;if(d>>>0>89478485)$I(a);m=a+8|0;k=((f[m>>2]|0)-c|0)/48|0;g=k<<1;g=k>>>0<44739242?(g>>>0<d>>>0?d:g):89478485;do if(g)if(g>>>0>89478485){n=Ra(8)|0;VK(n,44736);f[n>>2]=17660;Va(n|0,4016,428)}else{h=OK(g*48|0)|0;break}else h=0;while(0);d=h+(i*48|0)|0;c=d;k=h+(g*48|0)|0;f[d>>2]=f[b>>2];g=b+4|0;f[h+(i*48|0)+4>>2]=f[g>>2];o=b+8|0;f[h+(i*48|0)+8>>2]=f[o>>2];f[g>>2]=0;f[o>>2]=0;o=h+(i*48|0)+12|0;g=b+12|0;f[o>>2]=f[g>>2];f[o+4>>2]=f[g+4>>2];f[o+8>>2]=f[g+8>>2];f[o+12>>2]=f[g+12>>2];o=b+28|0;f[h+(i*48|0)+28>>2]=f[o>>2];g=b+32|0;f[h+(i*48|0)+32>>2]=f[g>>2];f[o>>2]=0;f[g>>2]=0;h=h+(i*48|0)+36|0;i=b+36|0;f[h>>2]=f[i>>2];f[h+4>>2]=f[i+4>>2];f[h+8>>2]=f[i+8>>2];h=d+48|0;if((e|0)==(l|0))g=j;else{do{j=e;e=e+-48|0;f[d+-48>>2]=f[e>>2];o=j+-44|0;f[d+-44>>2]=f[o>>2];i=j+-40|0;f[d+-40>>2]=f[i>>2];f[o>>2]=0;f[i>>2]=0;i=d+-36|0;o=j+-36|0;f[i>>2]=f[o>>2];f[i+4>>2]=f[o+4>>2];f[i+8>>2]=f[o+8>>2];f[i+12>>2]=f[o+12>>2];i=j+-20|0;f[d+-20>>2]=f[i>>2];o=j+-16|0;f[d+-16>>2]=f[o>>2];f[i>>2]=0;f[o>>2]=0;o=d+-12|0;j=j+-12|0;f[o>>2]=f[j>>2];f[o+4>>2]=f[j+4>>2];f[o+8>>2]=f[j+8>>2];d=c+-48|0;c=d}while((e|0)!=(l|0));g=f[a>>2]|0}f[a>>2]=c;d=f[n>>2]|0;f[n>>2]=h;f[m>>2]=k;e=g;if((d|0)!=(e|0))do{c=f[d+-16>>2]|0;if(c|0)KK(c);c=f[d+-40>>2]|0;d=d+-48|0;if(c|0)KK(c)}while((d|0)!=(e|0));if(!g)return;QK(g);return}function Fn(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;j=a+4|0;c=f[a>>2]|0;h=((f[j>>2]|0)-c|0)/48|0;d=h+1|0;if(d>>>0>89478485)$I(a);k=a+8|0;i=((f[k>>2]|0)-c|0)/48|0;c=i<<1;c=i>>>0<44739242?(c>>>0<d>>>0?d:c):89478485;do if(c)if(c>>>0>89478485){k=Ra(8)|0;VK(k,44736);f[k>>2]=17660;Va(k|0,4016,428)}else{g=OK(c*48|0)|0;break}else g=0;while(0);d=g+(h*48|0)|0;e=d;i=g+(c*48|0)|0;f[d>>2]=f[b>>2];f[g+(h*48|0)+4>>2]=f[b+4>>2];c=f[b+8>>2]|0;f[g+(h*48|0)+8>>2]=c;if(c|0)IK(c);c=g+(h*48|0)+12|0;l=b+12|0;f[c>>2]=f[l>>2];f[c+4>>2]=f[l+4>>2];f[c+8>>2]=f[l+8>>2];f[c+12>>2]=f[l+12>>2];f[g+(h*48|0)+28>>2]=f[b+28>>2];c=f[b+32>>2]|0;f[g+(h*48|0)+32>>2]=c;if(c|0)IK(c);h=g+(h*48|0)+36|0;b=b+36|0;f[h>>2]=f[b>>2];f[h+4>>2]=f[b+4>>2];f[h+8>>2]=f[b+8>>2];h=d+48|0;b=f[a>>2]|0;c=f[j>>2]|0;if((c|0)==(b|0)){c=e;g=b;d=b}else{do{g=c;c=c+-48|0;f[d+-48>>2]=f[c>>2];l=g+-44|0;f[d+-44>>2]=f[l>>2];m=g+-40|0;f[d+-40>>2]=f[m>>2];f[l>>2]=0;f[m>>2]=0;m=d+-36|0;l=g+-36|0;f[m>>2]=f[l>>2];f[m+4>>2]=f[l+4>>2];f[m+8>>2]=f[l+8>>2];f[m+12>>2]=f[l+12>>2];m=g+-20|0;f[d+-20>>2]=f[m>>2];l=g+-16|0;f[d+-16>>2]=f[l>>2];f[m>>2]=0;f[l>>2]=0;l=d+-12|0;g=g+-12|0;f[l>>2]=f[g>>2];f[l+4>>2]=f[g+4>>2];f[l+8>>2]=f[g+8>>2];d=e+-48|0;e=d}while((c|0)!=(b|0));c=e;g=f[a>>2]|0;d=f[j>>2]|0}f[a>>2]=c;f[j>>2]=h;f[k>>2]=i;e=g;if((d|0)!=(e|0))do{c=f[d+-16>>2]|0;if(c|0)KK(c);c=f[d+-40>>2]|0;d=d+-48|0;if(c|0)KK(c)}while((d|0)!=(e|0));if(!g)return;QK(g);return}function Gn(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;l=a+8|0;e=f[l>>2]|0;m=a+4|0;d=f[m>>2]|0;c=d;if(e-d>>3>>>0>=b>>>0){IM(d|0,0,b<<3|0)|0;f[m>>2]=c+(b<<3);return}j=f[a>>2]|0;h=d-j>>3;d=h+b|0;k=j;if(d>>>0>536870911)$I(a);i=e-j|0;g=i>>2;g=i>>3>>>0<268435455?(g>>>0<d>>>0?d:g):536870911;do if(g)if(g>>>0>536870911){m=Ra(8)|0;VK(m,44736);f[m>>2]=17660;Va(m|0,4016,428)}else{i=OK(g<<3)|0;break}else i=0;while(0);d=i+(h<<3)|0;e=d;i=i+(g<<3)|0;IM(d|0,0,b<<3|0)|0;h=d+(b<<3)|0;if((c|0)==(k|0))g=j;else{do{j=c;c=c+-8|0;f[d+-8>>2]=f[c>>2];j=j+-4|0;f[d+-4>>2]=f[j>>2];f[c>>2]=0;f[j>>2]=0;d=e+-8|0;e=d}while((c|0)!=(k|0));g=f[a>>2]|0;c=f[m>>2]|0}f[a>>2]=e;f[m>>2]=h;f[l>>2]=i;e=g;if((c|0)!=(e|0))do{d=f[c+-4>>2]|0;c=c+-8|0;if(d|0)KK(d)}while((c|0)!=(e|0));if(!g)return;QK(g);return}function Hn(a){a=a|0;zK(a);return}function In(a){a=a|0;zK(a);QK(a);return}function Jn(a){a=a|0;a=a+12|0;dd[f[f[a>>2]>>2]&511](a);return}function Kn(a){a=a|0;QK(a);return}function Ln(a){a=a|0;zK(a);return}function Mn(a){a=a|0;zK(a);QK(a);return}function Nn(a){a=a|0;a=a+12|0;dd[f[f[a>>2]>>2]&511](a);return}function On(a){a=a|0;QK(a);return}function Pn(a){a=a|0;zK(a);return}function Qn(a){a=a|0;zK(a);QK(a);return}function Rn(a){a=a|0;a=a+12|0;dd[f[f[a>>2]>>2]&511](a);return}function Sn(a){a=a|0;QK(a);return}function Tn(a){a=a|0;zK(a);return}function Un(a){a=a|0;zK(a);QK(a);return}function Vn(a){a=a|0;a=a+12|0;dd[f[f[a>>2]>>2]&511](a);return}function Wn(a){a=a|0;QK(a);return}function Xn(a){a=a|0;QK(a);return}function Yn(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0;j=u;u=u+48|0;i=j+36|0;c=j;g=f[d+12>>2]|0;if((g|0)==8){f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;u=j;return}if((f[d>>2]|0)==1?(f[d+4>>2]|0)==3:0){f[i>>2]=0;h=i+4|0;f[h>>2]=0;f[i+8>>2]=0;k=f[e+4>>2]|0;e=b[d+8>>0]|0;f[c>>2]=0;f[c+4>>2]=k;b[c+8>>0]=e;f[c+12>>2]=g;f[c+16>>2]=0;e=c+20|0;f[e>>2]=0;n[c+24>>2]=.75;n[c+28>>2]=.5;n[c+32>>2]=0.0;Jm(i,c);c=f[e>>2]|0;if(c|0)KK(c);f[a>>2]=f[i>>2];f[a+4>>2]=f[h>>2];f[a+8>>2]=f[i+8>>2];u=j;return}f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;u=j;return}function Zn(a,c,e,g,h){a=a|0;c=c|0;e=e|0;g=g|0;h=h|0;var i=0,k=0,l=0,m=0,o=0,p=0,q=0.0,r=0,s=0.0,t=0.0,v=0,w=0,x=0,y=0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0.0,ia=0.0,ja=0.0;fa=u;u=u+112|0;I=fa+108|0;J=fa+104|0;G=fa+100|0;ea=fa+96|0;r=fa+92|0;H=fa+88|0;M=fa+84|0;ca=fa+80|0;L=fa+40|0;p=fa;da=f[e>>2]|0;_=f[da+24>>2]|0;da=f[da+28>>2]|0;i=f[g+4>>2]|0;$=(lk(i)|0)&255;aa=(mk(i)|0)&255;c=zk(f[e>>2]|0,3)|0;l=c&255;if(c<<24>>24==8){f[a>>2]=0;f[a+4>>2]=0;u=fa;return}ba=tk(f[e>>2]|0,6)|0;if(ba?(zk(f[e>>2]|0,6)|0)<<24>>24!=c<<24>>24:0){f[a>>2]=0;f[a+4>>2]=0;u=fa;return}h=OK(84)|0;f[h+4>>2]=0;f[h+8>>2]=0;f[h>>2]=6208;k=h+12|0;c=h+32|0;m=k;o=m+44|0;do{f[m>>2]=0;m=m+4|0}while((m|0)<(o|0));f[c>>2]=32432;f[h+36>>2]=0;f[h+40>>2]=0;f[h+44>>2]=99;f[h+48>>2]=99;b[h+52>>0]=0;Z=h+56|0;Y=h+76|0;f[Y>>2]=0;f[h+80>>2]=0;f[Z>>2]=0;f[Z+4>>2]=0;f[Z+8>>2]=0;f[Z+12>>2]=0;f[h+72>>2]=Y;Y=k;Z=h;W=h+16|0;IK(h);JK(h);c=f[W>>2]|0;f[k>>2]=Y;f[W>>2]=Z;if(c|0)LK(c);KK(h);qk(k,_,da,0,i);V=(_+-1+$|0)/($|0)|0;W=(da+-1+aa|0)/(aa|0)|0;rk(k,0,_,da,l)|0;rk(k,1,V,W,l)|0;rk(k,2,V,W,l)|0;if(ba)rk(k,6,_,da,l)|0;f[I>>2]=0;f[J>>2]=0;f[G>>2]=0;f[ea>>2]=0;f[r>>2]=0;f[H>>2]=0;f[M>>2]=0;f[ca>>2]=0;S=Bk(f[e>>2]|0,3,I)|0;T=Bk(f[e>>2]|0,4,J)|0;U=Bk(f[e>>2]|0,5,G)|0;E=Ak(k,0,r)|0;V=Ak(k,1,H)|0;W=Ak(k,2,M)|0;if(ba){R=Bk(f[e>>2]|0,6,ea)|0;Q=Ak(k,6,ca)|0}else{R=0;Q=0}f[I>>2]=(f[I>>2]|0)/2|0;f[J>>2]=(f[J>>2]|0)/2|0;f[G>>2]=(f[G>>2]|0)/2|0;f[ea>>2]=(f[ea>>2]|0)/2|0;f[r>>2]=(f[r>>2]|0)/2|0;f[H>>2]=(f[H>>2]|0)/2|0;f[M>>2]=(f[M>>2]|0)/2|0;f[ca>>2]=(f[ca>>2]|0)/2|0;K=1<<l+-1;O=1<<l;P=O+-1|0;yp(L);c=f[g+16>>2]|0;if(!c){h=2;i=1}else{i=b[c+10>>0]|0;h=d[c+8>>1]|0;xp(p,h,d[c+4>>1]|0);i=i<<24>>24!=0;h=h&65535;m=L;c=p;o=m+40|0;do{f[m>>2]=f[c>>2];m=m+4|0;c=c+4|0}while((m|0)<(o|0))}N=(da|0)>0;if(N){w=(_|0)>0;x=(h|0)==0;y=f[J>>2]|0;o=f[r>>2]|0;g=f[I>>2]|0;p=f[G>>2]|0;q=+n[L+4>>2];s=+n[L+8>>2];t=+n[L+12>>2];m=0;do{a:do if(w){r=X(y,m)|0;v=X(o,m)|0;e=X(g,m)|0;l=X(p,m)|0;if(x)k=0;else{k=0;while(1){D=+(j[S+(e+k<<1)>>1]|0)*q+ +(j[T+(r+k<<1)>>1]|0)*s+ +(j[U+(l+k<<1)>>1]|0)*t;c=lz(i?D:D*219.0*.00390625+16.0)|0;if((c|0)<0)c=0;else c=((c|0)<(O|0)?c:P)&65535;d[E+(v+k<<1)>>1]=c;k=k+1|0;if((k|0)==(_|0))break a}}do{c=d[T+(r+k<<1)>>1]|0;if(!i){c=lz(+(c&65535)*219.0*.00390625+16.0)|0;if((c|0)<0)c=0;else c=((c|0)<(O|0)?c:P)&65535}d[E+(v+k<<1)>>1]=c;k=k+1|0}while((k|0)!=(_|0))}while(0);m=m+1|0}while((m|0)!=(da|0));if(N){F=(_|0)>0;E=(h|0)==0;y=f[G>>2]|0;x=f[H>>2]|0;w=f[I>>2]|0;v=f[J>>2]|0;z=+n[L+16>>2];A=+n[L+20>>2];B=+n[L+24>>2];C=+n[L+28>>2];D=+n[L+32>>2];t=+n[L+36>>2];s=+(K&65535|0);o=f[M>>2]|0;m=0;do{if(F){g=X(y,m)|0;p=X(w,m)|0;r=X(v,m)|0;l=0;do{h=g+l|0;c=d[U+(h<<1)>>1]|0;if(E){if(!i){c=lz(+(c&65535)*219.0*.00390625+16.0)|0;if((c|0)<0)c=0;else c=((c|0)<(O|0)?c:P)&65535;k=X(x,(m|0)/(aa|0)|0)|0;e=(l|0)/($|0)|0;d[V+(k+e<<1)>>1]=c;c=lz(+(j[S+(h<<1)>>1]|0)*219.0*.00390625+16.0)|0;if((c|0)<0){h=0;c=e}else{h=((c|0)<(O|0)?c:P)&65535;c=e}}else{k=X(x,(m|0)/(aa|0)|0)|0;M=(l|0)/($|0)|0;d[V+(k+M<<1)>>1]=c;h=d[S+(h<<1)>>1]|0;c=M}c=k+c|0}else{ja=+(j[S+(p+l<<1)>>1]|0);ia=+(j[T+(r+l<<1)>>1]|0);q=+(c&65535);ha=ja*z+ia*A+q*B;q=ja*C+ia*D+q*t;c=lz(s+(i?ha:ha*224.0*.00390625))|0;if((c|0)<0)c=0;else c=((c|0)<(O|0)?c:P)&65535;k=(m|0)/(aa|0)|0;e=(l|0)/($|0)|0;M=V+((X(x,k)|0)+e<<1)|0;d[M>>1]=c;c=lz(s+(i?q:q*224.0*.00390625))|0;if((c|0)<0)c=0;else c=((c|0)<(O|0)?c:P)&65535;h=c;c=(X(o,k)|0)+e|0}d[W+(c<<1)>>1]=h;l=l+$|0}while((l|0)<(_|0))}m=m+aa|0}while((m|0)<(da|0))}}if(ba?(ga=_<<1,N):0){c=0;do{ba=Q+((X(f[ca>>2]|0,c)|0)<<1)|0;GM(ba|0,R+((X(f[ea>>2]|0,c)|0)<<1)|0,ga|0)|0;c=c+1|0}while((c|0)!=(da|0))}f[a>>2]=Y;f[a+4>>2]=Z;u=fa;return}function _n(a){a=a|0;zK(a);return}function $n(a){a=a|0;zK(a);QK(a);return}function ao(a){a=a|0;a=a+12|0;dd[f[f[a>>2]>>2]&511](a);return}function bo(a){a=a|0;QK(a);return}function co(a){a=a|0;QK(a);return}function eo(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0;i=u;u=u+48|0;h=i+36|0;c=i;if((f[d+12>>2]|0)!=8){f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;u=i;return}if((f[d>>2]|0)==1?(f[d+4>>2]|0)==3:0){f[h>>2]=0;g=h+4|0;f[g>>2]=0;f[h+8>>2]=0;j=f[e+4>>2]|0;e=b[d+8>>0]|0;f[c>>2]=0;f[c+4>>2]=j;b[c+8>>0]=e;f[c+12>>2]=8;f[c+16>>2]=0;e=c+20|0;f[e>>2]=0;n[c+24>>2]=.75;n[c+28>>2]=.5;n[c+32>>2]=0.0;Jm(h,c);c=f[e>>2]|0;if(c|0)KK(c);f[a>>2]=f[h>>2];f[a+4>>2]=f[g>>2];f[a+8>>2]=f[h+8>>2];u=i;return}f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;u=i;return}function fo(a,c,e,g,i){a=a|0;c=c|0;e=e|0;g=g|0;i=i|0;var j=0,k=0,l=0,m=0,o=0,p=0,q=0.0,r=0,s=0.0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,Y=0,Z=0,_=0.0,$=0.0,aa=0.0;Z=u;u=u+112|0;P=Z+108|0;S=Z+104|0;T=Z+100|0;Y=Z+96|0;t=Z+92|0;K=Z+88|0;L=Z+84|0;U=Z+80|0;z=Z+40|0;p=Z;W=f[e>>2]|0;V=f[W+24>>2]|0;W=f[W+28>>2]|0;i=f[g+4>>2]|0;M=(lk(i)|0)&255;N=(mk(i)|0)&255;R=zk(f[e>>2]|0,3)|0;l=R&255;if(R<<24>>24!=8){f[a>>2]=0;f[a+4>>2]=0;u=Z;return}O=tk(f[e>>2]|0,6)|0;if(O?(zk(f[e>>2]|0,6)|0)<<24>>24!=8:0){f[a>>2]=0;f[a+4>>2]=0;u=Z;return}j=OK(84)|0;f[j+4>>2]=0;f[j+8>>2]=0;f[j>>2]=6208;k=j+12|0;c=j+32|0;m=k;o=m+44|0;do{f[m>>2]=0;m=m+4|0}while((m|0)<(o|0));f[c>>2]=32432;f[j+36>>2]=0;f[j+40>>2]=0;f[j+44>>2]=99;f[j+48>>2]=99;b[j+52>>0]=0;R=j+56|0;Q=j+76|0;f[Q>>2]=0;f[j+80>>2]=0;f[R>>2]=0;f[R+4>>2]=0;f[R+8>>2]=0;f[R+12>>2]=0;f[j+72>>2]=Q;Q=k;R=j;J=j+16|0;IK(j);JK(j);c=f[J>>2]|0;f[k>>2]=Q;f[J>>2]=R;if(c|0)LK(c);KK(j);qk(k,V,W,0,i);I=(V+-1+M|0)/(M|0)|0;J=(W+-1+N|0)/(N|0)|0;rk(k,0,V,W,l)|0;rk(k,1,I,J,l)|0;rk(k,2,I,J,l)|0;if(O)rk(k,6,V,W,l)|0;f[P>>2]=0;f[S>>2]=0;f[T>>2]=0;f[Y>>2]=0;f[t>>2]=0;f[K>>2]=0;f[L>>2]=0;f[U>>2]=0;F=Bk(f[e>>2]|0,3,P)|0;G=Bk(f[e>>2]|0,4,S)|0;H=Bk(f[e>>2]|0,5,T)|0;r=Ak(k,0,t)|0;I=Ak(k,1,K)|0;J=Ak(k,2,L)|0;if(O){E=Bk(f[e>>2]|0,6,Y)|0;D=Ak(k,6,U)|0}else{E=0;D=0}y=1<<l+-1;B=1<<l;C=B+-1|0;yp(z);c=f[g+16>>2]|0;if(!c){i=2;j=1}else{j=b[c+10>>0]|0;i=d[c+8>>1]|0;xp(p,i,d[c+4>>1]|0);j=j<<24>>24!=0;i=i&65535;m=z;c=p;o=m+40|0;do{f[m>>2]=f[c>>2];m=m+4|0;c=c+4|0}while((m|0)<(o|0))}A=(W|0)>0;if(A){l=(V|0)>0;g=(i|0)==0;m=z+4|0;o=z+8|0;p=z+12|0;e=0;do{a:do if(l){if(g)k=0;else{k=0;while(1){x=G+((X(f[S>>2]|0,e)|0)+k)|0;w=F+((X(f[P>>2]|0,e)|0)+k)|0;c=H+((X(f[T>>2]|0,e)|0)+k)|0;s=+(h[w>>0]|0)*+n[m>>2]+ +(h[x>>0]|0)*+n[o>>2]+ +(h[c>>0]|0)*+n[p>>2];c=lz(j?s:s*219.0*.00390625+16.0)|0;if((c|0)<0)c=0;else c=((c|0)<(B|0)?c:C)&255;x=r+((X(f[t>>2]|0,e)|0)+k)|0;b[x>>0]=c;k=k+1|0;if((k|0)==(V|0))break a}}do{c=G+((X(f[S>>2]|0,e)|0)+k)|0;c=b[c>>0]|0;if(!j){c=lz(+(c&255)*219.0*.00390625+16.0)|0;if((c|0)<0)c=0;else c=((c|0)<(B|0)?c:C)&255}x=r+((X(f[t>>2]|0,e)|0)+k)|0;b[x>>0]=c;k=k+1|0}while((k|0)!=(V|0))}while(0);e=e+1|0}while((e|0)!=(W|0));if(A){x=(V|0)>0;o=(i|0)==0;p=z+16|0;r=z+20|0;t=z+24|0;v=z+28|0;w=z+32|0;m=z+36|0;s=+(y&65535|0);g=0;do{if(x){l=0;do{if(o){c=H+((X(f[T>>2]|0,g)|0)+l)|0;c=b[c>>0]|0;if(j){k=(g|0)/(N|0)|0;i=(l|0)/(M|0)|0;z=I+((X(f[K>>2]|0,k)|0)+i)|0;b[z>>0]=c;c=F+((X(f[T>>2]|0,g)|0)+l)|0;c=b[c>>0]|0;k=X(f[K>>2]|0,k)|0}else{c=lz(+(c&255)*219.0*.00390625+16.0)|0;if((c|0)<0)c=0;else c=((c|0)<(B|0)?c:C)&255;k=(g|0)/(N|0)|0;i=(l|0)/(M|0)|0;z=I+((X(f[K>>2]|0,k)|0)+i)|0;b[z>>0]=c;c=F+((X(f[T>>2]|0,g)|0)+l)|0;c=lz(+(h[c>>0]|0)*219.0*.00390625+16.0)|0;if((c|0)<0)c=0;else c=((c|0)<(B|0)?c:C)&255;k=X(f[K>>2]|0,k)|0}e=c;c=k+i|0}else{c=F+((X(f[P>>2]|0,g)|0)+l)|0;aa=+(h[c>>0]|0);c=G+((X(f[S>>2]|0,g)|0)+l)|0;$=+(h[c>>0]|0);c=H+((X(f[T>>2]|0,g)|0)+l)|0;q=+(h[c>>0]|0);_=aa*+n[p>>2]+$*+n[r>>2]+q*+n[t>>2];q=aa*+n[v>>2]+$*+n[w>>2]+q*+n[m>>2];c=lz(s+(j?_:_*224.0*.00390625))|0;if((c|0)<0)c=0;else c=((c|0)<(B|0)?c:C)&255;i=(g|0)/(N|0)|0;k=(l|0)/(M|0)|0;z=I+((X(f[K>>2]|0,i)|0)+k)|0;b[z>>0]=c;c=lz(s+(j?q:q*224.0*.00390625))|0;if((c|0)<0)c=0;else c=((c|0)<(B|0)?c:C)&255;e=c;c=(X(f[L>>2]|0,i)|0)+k|0}b[J+c>>0]=e;l=l+M|0}while((l|0)<(V|0))}g=g+N|0}while((g|0)<(W|0));if(O&A){c=0;do{T=D+(X(f[U>>2]|0,c)|0)|0;GM(T|0,E+(X(f[Y>>2]|0,c)|0)|0,V|0)|0;c=c+1|0}while((c|0)!=(W|0))}}}f[a>>2]=Q;f[a+4>>2]=R;u=Z;return}function go(a){a=a|0;zK(a);return}function ho(a){a=a|0;zK(a);QK(a);return}function io(a){a=a|0;a=a+12|0;dd[f[f[a>>2]>>2]&511](a);return}function jo(a){a=a|0;QK(a);return}function ko(a){a=a|0;zK(a);return}function lo(a){a=a|0;zK(a);QK(a);return}function mo(a){a=a|0;a=a+12|0;dd[f[f[a>>2]>>2]&511](a);return}function no(a){a=a|0;QK(a);return}function oo(a){a=a|0;zK(a);return}function po(a){a=a|0;zK(a);QK(a);return}function qo(a){a=a|0;a=a+12|0;dd[f[f[a>>2]>>2]&511](a);return}function ro(a){a=a|0;QK(a);return}function so(a){a=a|0;zK(a);return}function to(a){a=a|0;zK(a);QK(a);return}function uo(a){a=a|0;a=a+12|0;dd[f[f[a>>2]>>2]&511](a);return}function vo(a){a=a|0;QK(a);return}function wo(a){a=a|0;zK(a);return}function xo(a){a=a|0;zK(a);QK(a);return}function yo(a){a=a|0;a=a+12|0;dd[f[f[a>>2]>>2]&511](a);return}function zo(a){a=a|0;QK(a);return}function Ao(a){a=a|0;zK(a);return}function Bo(a){a=a|0;zK(a);QK(a);return}function Co(a){a=a|0;a=a+12|0;dd[f[f[a>>2]>>2]&511](a);return}function Do(a){a=a|0;QK(a);return}function Eo(a){a=a|0;zK(a);return}function Fo(a){a=a|0;zK(a);QK(a);return}function Go(a){a=a|0;a=a+12|0;dd[f[f[a>>2]>>2]&511](a);return}function Ho(a){a=a|0;QK(a);return}function Io(a){a=a|0;zK(a);return}function Jo(a){a=a|0;zK(a);QK(a);return}function Ko(a){a=a|0;a=a+12|0;dd[f[f[a>>2]>>2]&511](a);return}function Lo(a){a=a|0;QK(a);return}function Mo(a){a=a|0;zK(a);return}function No(a){a=a|0;zK(a);QK(a);return}function Oo(a){a=a|0;a=a+12|0;dd[f[f[a>>2]>>2]&511](a);return}function Po(a){a=a|0;QK(a);return}function Qo(a){a=a|0;zK(a);return}function Ro(a){a=a|0;zK(a);QK(a);return}function So(a){a=a|0;a=a+12|0;dd[f[f[a>>2]>>2]&511](a);return}function To(a){a=a|0;QK(a);return}function Uo(a){a=a|0;zK(a);return}function Vo(a){a=a|0;zK(a);QK(a);return}function Wo(a){a=a|0;a=a+12|0;dd[f[f[a>>2]>>2]&511](a);return}function Xo(a){a=a|0;QK(a);return}function Yo(a){a=a|0;zK(a);return}function Zo(a){a=a|0;zK(a);QK(a);return}function _o(a){a=a|0;a=a+12|0;dd[f[f[a>>2]>>2]&511](a);return}function $o(a){a=a|0;QK(a);return}function ap(a){a=a|0;QK(a);return}function bp(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0;h=u;u=u+48|0;g=h+36|0;c=h;if((f[d+12>>2]|0)!=8){f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;u=h;return}if(f[d>>2]|0){f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;u=h;return}f[g>>2]=0;e=g+4|0;f[e>>2]=0;f[g+8>>2]=0;d=b[d+8>>0]|0;f[c>>2]=1;f[c+4>>2]=3;b[c+8>>0]=d;f[c+12>>2]=8;f[c+16>>2]=0;d=c+20|0;f[d>>2]=0;n[c+24>>2]=.5;n[c+28>>2]=0.0;n[c+32>>2]=0.0;Jm(g,c);c=f[d>>2]|0;if(c|0)KK(c);f[a>>2]=f[g>>2];f[a+4>>2]=f[e>>2];f[a+8>>2]=f[g+8>>2];u=h;return}function cp(a,c,e,g,i){a=a|0;c=c|0;e=e|0;g=g|0;i=i|0;var j=0,k=0,l=0,m=0,o=0,p=0.0,q=0,r=0.0,s=0.0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0;ca=u;u=u+80|0;Z=ca+68|0;_=ca+64|0;$=ca+60|0;aa=ca+56|0;ba=ca+52|0;U=ca+48|0;V=ca+44|0;W=ca+40|0;v=ca+20|0;q=ca;c=f[e>>2]|0;o=f[c+36>>2]|0;c=zk(c,0)|0;t=c&255;g=zk(f[e>>2]|0,1)|0;i=zk(f[e>>2]|0,2)|0;Y=tk(f[e>>2]|0,6)|0;if(Y)k=(zk(f[e>>2]|0,6)|0)&255;else k=0;if(c<<24>>24!=8|g<<24>>24!=8|i<<24>>24!=8){f[a>>2]=0;f[a+4>>2]=0;u=ca;return}c=f[e>>2]|0;m=f[c+44>>2]|0;S=f[c+48>>2]|0;T=(S|0)==0;if(!T){IK(S);c=f[e>>2]|0}R=f[c+24>>2]|0;Q=f[c+28>>2]|0;j=OK(84)|0;f[j+4>>2]=0;f[j+8>>2]=0;f[j>>2]=6208;l=j+12|0;c=j+32|0;g=l;i=g+44|0;do{f[g>>2]=0;g=g+4|0}while((g|0)<(i|0));f[c>>2]=32432;f[j+36>>2]=0;f[j+40>>2]=0;f[j+44>>2]=99;f[j+48>>2]=99;b[j+52>>0]=0;P=j+56|0;O=j+76|0;f[O>>2]=0;f[j+80>>2]=0;f[P>>2]=0;f[P+4>>2]=0;f[P+8>>2]=0;f[P+12>>2]=0;f[j+72>>2]=O;O=l;P=j;N=j+16|0;IK(j);JK(j);c=f[N>>2]|0;f[l>>2]=O;f[N>>2]=P;if(c|0)LK(c);KK(j);qk(l,R,Q,1,3);rk(l,3,R,Q,t)|0;rk(l,4,R,Q,t)|0;rk(l,5,R,Q,t)|0;if(Y)rk(l,6,R,Q,k)|0;f[Z>>2]=0;f[_>>2]=0;f[$>>2]=0;f[aa>>2]=0;f[ba>>2]=0;f[U>>2]=0;f[V>>2]=0;f[W>>2]=0;I=Bk(f[e>>2]|0,0,Z)|0;J=Bk(f[e>>2]|0,1,_)|0;K=Bk(f[e>>2]|0,2,$)|0;L=Ak(l,3,ba)|0;M=Ak(l,4,U)|0;N=Ak(l,5,V)|0;if(Y){H=Bk(f[e>>2]|0,6,aa)|0;D=Ak(l,6,W)|0}else{H=0;D=0}E=1<<t;F=E+-1|0;G=((lk(o)|0)&255)+-1|0;C=((mk(o)|0)&255)+-1|0;vp(v);if(!m){y=1;c=2}else{c=d[m+8>>1]|0;y=b[m+10>>0]|0;wp(q,c,d[m+4>>1]|0);f[v>>2]=f[q>>2];f[v+4>>2]=f[q+4>>2];f[v+8>>2]=f[q+8>>2];f[v+12>>2]=f[q+12>>2];f[v+16>>2]=f[q+16>>2];y=y<<24>>24!=0;c=c&65535}if((Q|0)>0){z=(R|0)>0;A=R<<1;B=(c|0)==0;x=(c|0)==8;t=1<<t+-1&65535;w=v+4|0;o=v+8|0;q=v+12|0;e=v+16|0;k=0;do{if(z){m=k>>C;l=0;do{g=l>>G;i=K+((X(f[$>>2]|0,m)|0)+g)|0;i=b[i>>0]|0;do if(B){c=(X(f[ba>>2]|0,k)|0)+l|0;if(y){b[L+c>>0]=i;v=I+((X(f[Z>>2]|0,k)|0)+l)|0;c=M+((X(f[U>>2]|0,k)|0)+l)|0;b[c>>0]=b[v>>0]|0;c=J+((X(f[_>>2]|0,m)|0)+g)|0;c=b[c>>0]|0;break}else{b[L+c>>0]=((((i&255)*219|0)+128|0)>>>8)+16;v=I+((X(f[Z>>2]|0,k)|0)+l)|0;c=M+((X(f[U>>2]|0,k)|0)+l)|0;b[c>>0]=((((h[v>>0]|0)*219|0)+128|0)>>>8)+16;c=J+((X(f[_>>2]|0,m)|0)+g)|0;c=((((h[c>>0]|0)*219|0)+128|0)>>>8)+16&255;break}}else{c=X(f[_>>2]|0,m)|0;j=I+((X(f[Z>>2]|0,k)|0)+l)|0;j=b[j>>0]|0;g=(h[J+(c+g)>>0]|0)-t|0;c=(i&255)-t|0;if(x){i=j&255;v=i-g|0;da=v+c|0;j=L+((X(f[ba>>2]|0,k)|0)+l)|0;b[j>>0]=(da|0)<0?0:(da|0)>255?-1:da&255;i=g+i|0;j=M+((X(f[U>>2]|0,k)|0)+l)|0;b[j>>0]=(i|0)<0?0:(i|0)>255?-1:i&255;c=v-c|0;c=(c|0)<0?0:(c|0)>255?-1:c&255;break}r=+(j&255);s=+(g|0);p=+(c|0);r=y?r:(r+-16.0)*1.1689000129699707;s=y?s:s*1.142899990081787;p=y?p:p*1.142899990081787;c=lz(r+p*+n[w>>2])|0;if((c|0)<0)c=0;else c=((c|0)<(E|0)?c:F)&255;da=L+((X(f[ba>>2]|0,k)|0)+l)|0;b[da>>0]=c;c=lz(r+s*+n[o>>2]+p*+n[q>>2])|0;if((c|0)<0)c=0;else c=((c|0)<(E|0)?c:F)&255;da=M+((X(f[U>>2]|0,k)|0)+l)|0;b[da>>0]=c;c=lz(r+s*+n[e>>2])|0;if((c|0)<0)c=0;else c=((c|0)<(E|0)?c:F)&255}while(0);da=N+((X(f[V>>2]|0,k)|0)+l)|0;b[da>>0]=c;l=l+1|0}while((l|0)!=(R|0))}if(Y){da=D+(X(f[W>>2]|0,k)|0)|0;GM(da|0,H+(X(f[aa>>2]|0,k)|0)|0,A|0)|0}k=k+1|0}while((k|0)!=(Q|0))}f[a>>2]=O;f[a+4>>2]=P;if(T){u=ca;return}KK(S);u=ca;return}function dp(a){a=a|0;zK(a);return}function ep(a){a=a|0;zK(a);QK(a);return}function fp(a){a=a|0;a=a+12|0;dd[f[f[a>>2]>>2]&511](a);return}function gp(a){a=a|0;QK(a);return}function hp(a){a=a|0;QK(a);return}function ip(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0;i=u;u=u+48|0;h=i+36|0;c=i;e=f[d+12>>2]|0;if((e|0)==8){f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;u=i;return}if(f[d>>2]|0){f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;u=i;return}f[h>>2]=0;g=h+4|0;f[g>>2]=0;f[h+8>>2]=0;d=b[d+8>>0]|0;f[c>>2]=1;f[c+4>>2]=3;b[c+8>>0]=d;f[c+12>>2]=e;f[c+16>>2]=0;d=c+20|0;f[d>>2]=0;n[c+24>>2]=.5;n[c+28>>2]=0.0;n[c+32>>2]=0.0;Jm(h,c);c=f[d>>2]|0;if(c|0)KK(c);f[a>>2]=f[h>>2];f[a+4>>2]=f[g>>2];f[a+8>>2]=f[h+8>>2];u=i;return}function jp(a,c,e,g,h){a=a|0;c=c|0;e=e|0;g=g|0;h=h|0;var i=0,k=0,l=0,m=0,o=0,p=0,q=0,r=0.0,s=0,t=0.0,v=0.0,w=0,x=0,y=0,z=0.0,A=0.0,B=0.0,C=0.0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0;ma=u;u=u+80|0;ha=ma+68|0;ia=ma+64|0;ja=ma+60|0;ka=ma+56|0;la=ma+52|0;da=ma+48|0;ea=ma+44|0;fa=ma+40|0;s=ma+20|0;p=ma;c=f[e>>2]|0;o=f[c+36>>2]|0;c=zk(c,0)|0;q=c&255;g=zk(f[e>>2]|0,1)|0;h=zk(f[e>>2]|0,2)|0;ga=tk(f[e>>2]|0,6)|0;if(ga)k=(zk(f[e>>2]|0,6)|0)&255;else k=0;if(c<<24>>24==8|g<<24>>24==8|h<<24>>24==8){f[a>>2]=0;f[a+4>>2]=0;u=ma;return}if(!(c<<24>>24==g<<24>>24?c<<24>>24==h<<24>>24:0)){f[a>>2]=0;f[a+4>>2]=0;u=ma;return}c=f[e>>2]|0;m=f[c+44>>2]|0;ba=f[c+48>>2]|0;ca=(ba|0)==0;if(!ca){IK(ba);c=f[e>>2]|0}aa=f[c+24>>2]|0;$=f[c+28>>2]|0;i=OK(84)|0;f[i+4>>2]=0;f[i+8>>2]=0;f[i>>2]=6208;l=i+12|0;c=i+32|0;g=l;h=g+44|0;do{f[g>>2]=0;g=g+4|0}while((g|0)<(h|0));f[c>>2]=32432;f[i+36>>2]=0;f[i+40>>2]=0;f[i+44>>2]=99;f[i+48>>2]=99;b[i+52>>0]=0;_=i+56|0;Z=i+76|0;f[Z>>2]=0;f[i+80>>2]=0;f[_>>2]=0;f[_+4>>2]=0;f[_+8>>2]=0;f[_+12>>2]=0;f[i+72>>2]=Z;Z=l;_=i;Y=i+16|0;IK(i);JK(i);c=f[Y>>2]|0;f[l>>2]=Z;f[Y>>2]=_;if(c|0)LK(c);KK(i);qk(l,aa,$,1,3);rk(l,3,aa,$,q)|0;rk(l,4,aa,$,q)|0;rk(l,5,aa,$,q)|0;if(ga)rk(l,6,aa,$,k)|0;f[ha>>2]=0;f[ia>>2]=0;f[ja>>2]=0;f[ka>>2]=0;f[la>>2]=0;f[da>>2]=0;f[ea>>2]=0;f[fa>>2]=0;S=Bk(f[e>>2]|0,0,ha)|0;T=Bk(f[e>>2]|0,1,ia)|0;U=Bk(f[e>>2]|0,2,ja)|0;V=Ak(l,3,la)|0;W=Ak(l,4,da)|0;Y=Ak(l,5,ea)|0;if(ga){R=Bk(f[e>>2]|0,6,ka)|0;N=Ak(l,6,fa)|0}else{R=0;N=0}O=1<<q;P=O+-1|0;Q=((lk(o)|0)&255)+-1|0;M=((mk(o)|0)&255)+-1|0;f[ha>>2]=(f[ha>>2]|0)/2|0;f[ia>>2]=(f[ia>>2]|0)/2|0;f[ja>>2]=(f[ja>>2]|0)/2|0;f[ka>>2]=(f[ka>>2]|0)/2|0;f[la>>2]=(f[la>>2]|0)/2|0;f[da>>2]=(f[da>>2]|0)/2|0;f[ea>>2]=(f[ea>>2]|0)/2|0;f[fa>>2]=(f[fa>>2]|0)/2|0;vp(s);if(!m){I=1;c=2}else{c=d[m+8>>1]|0;I=b[m+10>>0]|0;wp(p,c,d[m+4>>1]|0);f[s>>2]=f[p>>2];f[s+4>>2]=f[p+4>>2];f[s+8>>2]=f[p+8>>2];f[s+12>>2]=f[p+12>>2];f[s+16>>2]=f[p+16>>2];I=I<<24>>24!=0;c=c&65535}if(($|0)>0){J=(aa|0)>0;K=aa<<1;L=(c|0)==0;H=(c|0)==8;D=1<<q+-1&65535;E=s+4|0;F=s+8|0;G=s+12|0;o=s+16|0;e=0;do{if(J){s=e>>M;p=X(f[ia>>2]|0,s)|0;q=X(f[ha>>2]|0,e)|0;s=X(f[ja>>2]|0,s)|0;w=X(f[la>>2]|0,e)|0;x=X(f[ea>>2]|0,e)|0;y=X(f[da>>2]|0,e)|0;z=+n[E>>2];A=+n[F>>2];B=+n[G>>2];C=+n[o>>2];m=0;do{c=m>>Q;l=p+c|0;k=q+m|0;c=d[U+(s+c<<1)>>1]|0;do if(L){g=x+m|0;h=w+m|0;i=y+m|0;if(I){d[V+(h<<1)>>1]=c;d[W+(i<<1)>>1]=d[S+(k<<1)>>1]|0;c=d[T+(l<<1)>>1]|0;break}else{d[V+(h<<1)>>1]=((((c&65535)*219|0)+128|0)>>>8)+16;d[W+(i<<1)>>1]=((((j[S+(k<<1)>>1]|0)*219|0)+128|0)>>>8)+16;c=((((j[T+(l<<1)>>1]|0)*219|0)+128|0)>>>8)+16&65535;break}}else{h=(c&65535)-D|0;g=d[S+(k<<1)>>1]|0;c=(j[T+(l<<1)>>1]|0)-D|0;if(H){l=g&65535;g=l-c|0;k=g+h|0;d[V+(w+m<<1)>>1]=(k|0)<0?0:(k|0)>255?255:k&255;c=l+c|0;d[W+(y+m<<1)>>1]=(c|0)<0?0:(c|0)>255?255:c&255;c=g-h|0;c=(c|0)<0?0:(c|0)>255?255:c&255;g=x+m|0;break}t=+(g&65535);v=+(c|0);r=+(h|0);t=I?t:(t+-16.0)*1.1689000129699707;v=I?v:v*1.142899990081787;r=I?r:r*1.142899990081787;c=lz(t+r*z)|0;if((c|0)<0)c=0;else c=((c|0)<(O|0)?c:P)&65535;d[V+(w+m<<1)>>1]=c;c=lz(t+v*A+r*B)|0;if((c|0)<0)c=0;else c=((c|0)<(O|0)?c:P)&65535;d[W+(y+m<<1)>>1]=c;c=lz(t+v*C)|0;if((c|0)<0)c=0;else c=((c|0)<(O|0)?c:P)&65535;g=x+m|0}while(0);d[Y+(g<<1)>>1]=c;m=m+1|0}while((m|0)!=(aa|0))}if(ga){y=N+((X(f[fa>>2]|0,e)|0)<<1)|0;GM(y|0,R+((X(f[ka>>2]|0,e)|0)<<1)|0,K|0)|0}e=e+1|0}while((e|0)!=($|0))}f[a>>2]=Z;f[a+4>>2]=_;if(ca){u=ma;return}KK(ba);u=ma;return}function kp(a){a=a|0;zK(a);return}function lp(a){a=a|0;zK(a);QK(a);return}function mp(a){a=a|0;a=a+12|0;dd[f[f[a>>2]>>2]&511](a);return}function np(a){a=a|0;QK(a);return}function op(a){a=a|0;zK(a);return}function pp(a){a=a|0;zK(a);QK(a);return}function qp(a){a=a|0;a=a+12|0;dd[f[f[a>>2]>>2]&511](a);return}function rp(a){a=a|0;QK(a);return}function sp(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0;E=u;u=u+64|0;x=E+48|0;z=E+40|0;A=E+32|0;B=E+8|0;C=E;e=f[d>>2]|0;g=f[d+4>>2]|0;d=g;if(g|0){IK(g);IK(g)}g=f[c>>2]|0;p=f[c+4>>2]|0;a:do if((g|0)!=(p|0)){q=A+4|0;r=c+12|0;s=B+16|0;t=c+28|0;v=B+20|0;w=c+32|0;n=c+36|0;o=z+4|0;i=e;while(1){e=f[g>>2]|0;c=f[(f[e>>2]|0)+12>>2]|0;f[A>>2]=i;l=d;f[q>>2]=l;m=(d|0)==0;if(!m)IK(l);f[B>>2]=f[r>>2];f[B+4>>2]=f[r+4>>2];f[B+8>>2]=f[r+8>>2];f[B+12>>2]=f[r+12>>2];f[s>>2]=f[t>>2];h=f[w>>2]|0;f[v>>2]=h;if(h|0)IK(h);f[C>>2]=f[n>>2];f[x>>2]=f[C>>2];hd[c&63](z,e,A,B,x);e=f[z>>2]|0;k=f[o>>2]|0;f[z>>2]=0;f[o>>2]=0;if(!m?(KK(l),y=f[o>>2]|0,y|0):0)KK(y);c=f[v>>2]|0;if(c|0)KK(c);c=f[q>>2]|0;if(c|0)KK(c);j=e;if(!e)break;d=f[t>>2]|0;c=f[w>>2]|0;h=(c|0)==0;if(!h){IK(c);IK(c)}f[j+44>>2]=d;F=j+48|0;d=f[F>>2]|0;f[F>>2]=c;if(d|0)KK(d);if(!h)KK(c);c=i;d=f[c+52>>2]|0;h=f[c+56>>2]|0;i=(h|0)==0;if(!i){IK(h);IK(h)}f[j+52>>2]=d;F=j+56|0;d=f[F>>2]|0;f[F>>2]=h;if(d|0)KK(d);if(!i)KK(h);b[j+40>>0]=b[c+40>>0]|0;if(k|0)IK(k);if(!m)KK(l);g=g+8|0;if((g|0)==(p|0)){d=k;D=34;break a}else{i=e;d=k}}f[a>>2]=0;f[a+4>>2]=0;if(k)KK(k)}else D=34;while(0);if((D|0)==34){f[a>>2]=e;f[a+4>>2]=d}if(!d){u=E;return}KK(d);u=E;return}function tp(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;D=u;u=u+128|0;q=D+108|0;r=D+115|0;C=D+96|0;s=D+112|0;B=D+56|0;v=D+32|0;w=D+8|0;t=D;A=f[c>>2]|0;i=f[A+24>>2]|0;j=f[A+28>>2]|0;do if(tk(A,6)|0){if((uk(f[c>>2]|0,6)|0)==(i|0)?(vk(f[c>>2]|0,6)|0)==(j|0):0)break;f[a>>2]=0;f[a+4>>2]=0;u=D;return}while(0);if((d|0)==0&e>>>0>3){f[a>>2]=0;f[a+4>>2]=0;u=D;return}A=f[c>>2]|0;m=f[A+32>>2]|0;n=f[A+36>>2]|0;if(tk(A,6)|0)o=1;else o=Fk(f[(f[c>>2]|0)+36>>2]|0)|0;i=f[c>>2]|0;p=f[i+44>>2]|0;z=f[i+48>>2]|0;A=(z|0)==0;if(!A){IK(z);i=f[c>>2]|0}wk(C,i);if(!(f[C+8>>2]|0))Pa(34594,32465,3093,32489);k=(zk(f[c>>2]|0,f[(f[C>>2]|0)+16>>2]|0)|0)&255;b[s>>0]=b[r>>0]|0;b[s+1>>0]=b[r+1>>0]|0;b[s+2>>0]=b[r+2>>0]|0;if(!A)IK(z);l=f[g>>2]|0;x=f[g+4>>2]|0;y=(x|0)==0;if(!y)IK(x);if(!A)KK(z);if((pk(e)|0)>1)j=Fk(e)|0;else j=o;i=(e|1|0)==11?8:(h|0)==0?k:h;f[B>>2]=0;h=B+4|0;f[h>>2]=0;f[B+8>>2]=0;f[B+12>>2]=99;f[B+16>>2]=99;b[B+20>>0]=0;f[B+24>>2]=8;f[B+28>>2]=0;g=B+32|0;f[g>>2]=0;f[B+36>>2]=3;f[v>>2]=m;f[v+4>>2]=n;b[v+8>>0]=o&1;o=v+9|0;b[o>>0]=b[r>>0]|0;b[o+1>>0]=b[r+1>>0]|0;b[o+2>>0]=b[r+2>>0]|0;f[v+12>>2]=k;f[v+16>>2]=p;f[v+20>>2]=z;if(!A)IK(z);f[w>>2]=d;f[w+4>>2]=e;b[w+8>>0]=j&1;d=w+9|0;b[d>>0]=b[s>>0]|0;b[d+1>>0]=b[s+1>>0]|0;b[d+2>>0]=b[s+2>>0]|0;f[w+12>>2]=(e&-4|0)==12&(i|0)<9?10:i;f[w+16>>2]=l;f[w+20>>2]=x;if(!y)IK(x);f[t>>2]=3;f[q>>2]=f[t>>2];i=Cn(B,v,w,q)|0;if(!y)KK(x);if(!A)KK(z);if(i)sp(a,B,c);else{f[a>>2]=0;f[a+4>>2]=0}i=f[g>>2]|0;if(i|0)KK(i);i=f[B>>2]|0;if(i|0){j=f[h>>2]|0;if((j|0)!=(i|0)){do{g=j+-8|0;f[h>>2]=g;j=f[j+-4>>2]|0;if(!j)j=g;else{KK(j);j=f[h>>2]|0}}while((j|0)!=(i|0));i=f[B>>2]|0}QK(i)}if(!y)KK(x);xk(C,f[C+4>>2]|0);if(!A)KK(z);u=D;return}function up(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0;n[a>>2]=0.0;l=a+4|0;n[l>>2]=0.0;switch(b<<16>>16){case 13:case 12:{do switch(c<<16>>16){case 1:{d=.30000001192092896;e=.6000000238418579;f=.15000000596046448;g=.05999999865889549;h=.6399999856948853;i=.33000001311302185;j=.3127000033855438;k=.32899999618530273;break}case 4:{d=.20999999344348907;e=.7099999785423279;f=.14000000059604645;g=.07999999821186066;h=.6700000166893005;i=.33000001311302185;j=.3100000023841858;k=.3160000145435333;break}case 5:{d=.28999999165534973;e=.6000000238418579;f=.15000000596046448;g=.05999999865889549;h=.6399999856948853;i=.33000001311302185;j=.3127000033855438;k=.32899999618530273;break}case 7:case 6:{d=.3100000023841858;e=.5950000286102295;f=.1550000011920929;g=.07000000029802322;h=.6299999952316284;i=.3400000035762787;j=.3127000033855438;k=.32899999618530273;break}case 8:{d=.24300000071525574;e=.6919999718666077;f=.14499999582767487;g=.04899999871850014;h=.6809999942779541;i=.3190000057220459;j=.3100000023841858;k=.3160000145435333;break}case 9:{d=.17000000178813934;e=.796999990940094;f=.13099999725818634;g=.04600000008940697;h=.7080000042915344;i=.2919999957084656;j=.3127000033855438;k=.32899999618530273;break}case 10:{d=0.0;e=1.0;f=0.0;g=0.0;h=1.0;i=0.0;j=.33333298563957214;k=.3333300054073334;break}case 11:{d=.26499998569488525;e=.6899999976158142;f=.15000000596046448;g=.05999999865889549;h=.6800000071525574;i=.3199999928474426;j=.3140000104904175;k=.35100001096725464;break}case 12:{d=.26499998569488525;e=.6899999976158142;f=.15000000596046448;g=.05999999865889549;h=.6800000071525574;i=.3199999928474426;j=.3127000033855438;k=.32899999618530273;break}case 22:{d=.29499998688697815;e=.6050000190734863;f=.1550000011920929;g=.07699999958276749;h=.6299999952316284;i=.3400000035762787;j=.3127000033855438;k=.32899999618530273;break}default:{d=0.0;e=0.0;f=0.0;g=0.0;h=0.0;i=0.0;j=0.0;k=0.0}}while(0);p=1.0-(i+h);o=1.0-(e+d);s=1.0-(g+f);r=1.0-(k+j);t=e*s-g*o;q=i*o-p*e;m=k*(f*q+(d*(g*p-i*s)+h*t));n[a>>2]=i*(r*(g*d-f*e)+(j*t+k*(f*o-d*s)))/m;d=g*(r*(h*e-i*d)+(j*q+k*(p*d-h*o)))/m;break}case 1:{n[a>>2]=.2125999927520752;d=.0722000002861023;break}case 4:{n[a>>2]=.30000001192092896;d=.10999999940395355;break}case 6:case 5:{n[a>>2]=.29899999499320984;d=.11400000005960464;break}case 7:{n[a>>2]=.21199999749660492;d=.08699999749660492;break}case 10:case 9:{n[a>>2]=.26269999146461487;d=.059300001710653305;break}default:return}n[l>>2]=d;return}function vp(a){a=a|0;b[a>>0]=1;n[a+4>>2]=1.4019999504089355;n[a+8>>2]=-.34413599967956543;n[a+12>>2]=-.714136004447937;n[a+16>>2]=1.7719999551773071;return}function wp(a,c,d){a=a|0;c=c|0;d=d|0;var e=0.0,g=0.0,h=0.0,i=0,j=0.0,k=0,l=0,m=0.0,o=0.0;k=u;u=u+16|0;l=k;b[a>>0]=0;i=a+4|0;f[i>>2]=0;f[i+4>>2]=0;f[i+8>>2]=0;f[i+12>>2]=0;up(l,c,d);j=+n[l+4>>2];e=+n[l>>2];b[a>>0]=1;if(j!=0.0|e!=0.0){g=1.0-e;n[i>>2]=g*2.0;o=1.0-j;m=e+j+-1.0;h=o*2.0;g=e*2.0*g/m;e=j*2.0*o/m}else{n[i>>2]=1.4019999504089355;h=1.7719999551773071;g=-.714136004447937;e=-.34413599967956543}n[a+8>>2]=e;n[a+12>>2]=g;n[a+16>>2]=h;u=k;return}function xp(a,c,d){a=a|0;c=c|0;d=d|0;var e=0.0,g=0.0,h=0,i=0,j=0.0,k=0.0,l=0.0,m=0,o=0,p=0,q=0.0;p=u;u=u+16|0;m=p;b[a>>0]=0;o=a+4|0;h=o;i=h+36|0;do{f[h>>2]=0;h=h+4|0}while((h|0)<(i|0));up(m,c,d);e=+n[m+4>>2];g=+n[m>>2];b[a>>0]=1;if(e!=0.0|g!=0.0){n[o>>2]=g;k=1.0-g;l=k-e;n[a+8>>2]=l;q=1.0-e;l=-l;j=-e/k*.5;k=l/k*.5;l=l/q*.5;g=-g/q*.5}else{n[o>>2]=.29899999499320984;n[a+8>>2]=.5870000123977661;j=-.08131200075149536;k=-.41868799924850464;l=-.3312639892101288;g=-.16873499751091003;e=.11400000005960464}n[a+12>>2]=e;n[a+16>>2]=g;n[a+20>>2]=l;n[a+24>>2]=.5;n[a+28>>2]=.5;n[a+32>>2]=k;n[a+36>>2]=j;u=p;return}function yp(a){a=a|0;b[a>>0]=1;n[a+4>>2]=.29899999499320984;n[a+8>>2]=.5870000123977661;n[a+12>>2]=.11400000005960464;n[a+16>>2]=-.16873499751091003;n[a+20>>2]=-.3312639892101288;n[a+24>>2]=.5;n[a+28>>2]=.5;n[a+32>>2]=-.41868799924850464;n[a+36>>2]=-.08131200075149536;return}function zp(){return 7580}function Ap(){var a=0,c=0,d=0,e=0;c=61385;d=34726;e=c+22|0;do{b[c>>0]=b[d>>0]|0;c=c+1|0;d=d+1|0}while((c|0)<(e|0));a=Ip()|0;if(((vx(a)|0)+10|0)>>>0>=80)return 61385;c=61385+(vx(61385)|0)|0;d=34748;e=c+11|0;do{b[c>>0]=b[d>>0]|0;c=c+1|0;d=d+1|0}while((c|0)<(e|0));pz(61385,a)|0;return 61385}function Bp(){Jp()|0;return}function Cp(){Kp()|0;return}function Dp(a){a=a|0;return ((a|0)==1?100:0)|0}function Ep(a,b){a=a|0;b=b|0;var c=0;c=OK(4)|0;f[c>>2]=0;f[a>>2]=f[1904];f[a+4>>2]=f[1905];f[a+8>>2]=f[1906];a=Lp()|0;f[c>>2]=a;Sp(a,7,1);Sp(a,8,1);f[b>>2]=c;return}function Fp(a){a=a|0;Mp(f[a>>2]|0)|0;if(!a)return;QK(a);return}function Gp(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0;a:do if(d|0){e=0;while(1){if((d-e|0)>>>0<4){e=4;break}g=(h[c+(e+1)>>0]|0)<<16|(h[c+e>>0]|0)<<24|(h[c+(e+2)>>0]|0)<<8|(h[c+(e+3)>>0]|0);e=e+4|0;if(g>>>0>(d-e|0)>>>0){e=7;break}Pp(f[b>>2]|0,c+e|0,g,0,0,0)|0;e=g+e|0;if(e>>>0>=d>>>0)break a}if((e|0)==4){f[a>>2]=f[1919];f[a+4>>2]=f[1920];f[a+8>>2]=f[1921];return}else if((e|0)==7){f[a>>2]=f[1919];f[a+4>>2]=f[1920];f[a+8>>2]=f[1921];return}}while(0);f[a>>2]=f[1904];f[a+4>>2]=f[1905];f[a+8>>2]=f[1906];return}function Hp(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0;z=u;u=u+32|0;v=z+20|0;w=z+16|0;x=z+12|0;y=z;f[a>>2]=f[1904];f[a+4>>2]=f[1905];f[a+8>>2]=f[1906];Np(f[c>>2]|0)|0;f[e>>2]=0;while(1){f[x>>2]=0;if(Op(f[c>>2]|0,x)|0){h=28;break}s=Qp(f[c>>2]|0)|0;if(s|0){g=f[e>>2]|0;if(g|0)Kl(g);j=(Wp(s)|0)==0;t=OK(84)|0;f[t+4>>2]=0;f[t+8>>2]=0;f[t>>2]=6208;r=t+12|0;g=t+32|0;h=r;i=h+44|0;do{f[h>>2]=0;h=h+4|0}while((h|0)<(i|0));f[g>>2]=34612;f[t+36>>2]=0;f[t+40>>2]=0;f[t+44>>2]=99;f[t+48>>2]=99;b[t+52>>0]=0;o=t+56|0;p=t+76|0;f[p>>2]=0;f[t+80>>2]=0;f[o>>2]=0;f[o+4>>2]=0;f[o+8>>2]=0;f[o+12>>2]=0;f[t+72>>2]=p;p=r;o=t+16|0;q=t;IK(t);JK(t);g=f[o>>2]|0;f[r>>2]=p;f[o>>2]=q;if(g|0)LK(g);KK(t);l=Tp(s,0)|0;k=Up(s,0)|0;o=Wp(s)|0;qk(r,l,k,j?2:0,o);o=Vp(s,0)|0;k=j?1:3;l=(o+7|0)/8|0;j=0;while(1){if((Vp(s,j)|0)!=(o|0)){h=10;break}m=Xp(s,j,v)|0;h=Tp(s,j)|0;n=Up(s,j)|0;if((h|0)<1|(n|0)<1){h=12;break}g=f[7628+(j<<2)>>2]|0;if(!(rk(r,g,h,n,o)|0)){h=14;break}i=Ak(r,g,w)|0;if((n|0)>0){h=X(h,l)|0;g=0;do{A=i+(X(f[w>>2]|0,g)|0)|0;GM(A|0,m+(X(f[v>>2]|0,g)|0)|0,h|0)|0;g=g+1|0}while((g|0)!=(n|0))}j=j+1|0;if((j|0)>=(k|0)){h=20;break}}if((h|0)==10){h=0;f[y>>2]=f[1910];f[y+4>>2]=f[1911];f[y+8>>2]=f[1912]}else if((h|0)==12){f[y>>2]=f[1913];f[y+4>>2]=f[1914];f[y+8>>2]=f[1915];h=18}else if((h|0)==14){f[y>>2]=f[1916];f[y+4>>2]=f[1917];f[y+8>>2]=f[1918];h=18}else if((h|0)==20){h=0;g=OK(8)|0;f[g>>2]=0;A=g+4|0;f[A>>2]=0;f[e>>2]=g;IK(t);f[g>>2]=p;g=f[A>>2]|0;f[A>>2]=q;if(g|0)KK(g);f[y>>2]=f[1904];f[y+4>>2]=f[1905];f[y+8>>2]=f[1906]}KK(t);f[a>>2]=f[y>>2];f[a+4>>2]=f[y+4>>2];f[a+8>>2]=f[y+8>>2];if(f[a>>2]|0){h=28;break}g=OK(24)|0;f[g+4>>2]=0;f[g+8>>2]=0;f[g>>2]=6064;h=g+12|0;f[h>>2]=6092;d[g+16>>1]=0;d[g+18>>1]=0;d[g+20>>1]=0;b[g+22>>0]=1;Cj(h);A=f[f[e>>2]>>2]|0;IK(g);IK(g);f[A+44>>2]=h;A=A+48|0;h=f[A>>2]|0;f[A>>2]=g;if(h|0)KK(h);KK(g);Rp(f[c>>2]|0);KK(g)}if(!(f[x>>2]|0)){h=28;break}}if((h|0)==28){u=z;return}}function Ip(){return 34759}function Jp(){var a=0;a=f[14210]|0;f[14210]=a+1;if((a+1|0)>1){a=0;return a|0}du();if(Hu()|0){a=0;return a|0}f[14210]=(f[14210]|0)-1;a=11;return a|0}function Kp(){var a=0;a=f[14210]|0;f[14210]=a-1;a=a+-1|0;if((a|0)<0){f[14210]=(f[14210]|0)+1;a=12;return a|0}if(a|0){a=0;return a|0}Iu();a=0;return a|0}function Lp(){var a=0;a=f[14210]|0;f[14210]=a+1;if((a+1|0)<=1?(du(),!(Hu()|0)):0){f[14210]=(f[14210]|0)-1;a=0;return a|0}a=OK(377232)|0;fq(a);return a|0}function Mp(a){a=a|0;gq(a);if(a|0)dd[f[(f[a>>2]|0)+4>>2]&511](a);a=f[14210]|0;f[14210]=a-1;a=a+-1|0;if((a|0)<0){f[14210]=(f[14210]|0)+1;a=12;return a|0}if(a|0){a=0;return a|0}Iu();a=0;return a|0}function Np(a){a=a|0;a=a+548|0;Kt(a)|0;Kt(a)|0;b[a>>0]=1;return 0}function Op(a,b){a=a|0;b=b|0;return Pq(a,b)|0}function Pp(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return Jt(a+548|0,b,c,d,e,f)|0}function Qp(a){a=a|0;var c=0;if((f[a+376200>>2]|0)<=0){c=0;return c|0}c=f[a+376196>>2]|0;c=f[(f[(f[a+376184>>2]|0)+(c>>>10<<2)>>2]|0)+((c&1023)<<2)>>2]|0;if(!c){c=0;return c|0}b[c+100>>0]=0;Ns(a+376148|0);return c|0}function Rp(a){a=a|0;var c=0;if(!(f[a+376200>>2]|0))return;c=f[a+376196>>2]|0;b[(f[(f[(f[a+376184>>2]|0)+(c>>>10<<2)>>2]|0)+((c&1023)<<2)>>2]|0)+100>>0]=0;Ns(a+376148|0);return}function Sp(a,c,d){a=a|0;c=c|0;d=d|0;switch(c|0){case 0:{b[a+512>>0]=(d|0)!=0&1;return}case 6:{b[a+514>>0]=(d|0)!=0&1;return}case 7:{b[a+532>>0]=(d|0)!=0&1;return}case 8:{b[a+533>>0]=(d|0)!=0&1;return}default:Pa(55956,34765,503,34774)}}function Tp(a,b){a=a|0;b=b|0;switch(b|0){case 0:{a=a+72|0;break}case 2:case 1:{a=a+80|0;break}default:{b=0;return b|0}}b=f[a>>2]|0;return b|0}function Up(a,b){a=a|0;b=b|0;switch(b|0){case 0:{a=a+76|0;break}case 2:case 1:{a=a+84|0;break}default:{b=0;return b|0}}b=f[a>>2]|0;return b|0}function Vp(a,b){a=a|0;b=b|0;switch(b|0){case 0:{a=a+5760|0;break}case 2:case 1:{a=a+5768|0;break}default:{b=0;return b|0}}b=f[a>>2]|0;return b|0}function Wp(a){a=a|0;return f[a+20>>2]|0}function Xp(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0;if(b>>>0>=3)Pa(34799,34765,639,34826);e=f[a+60+(b<<2)>>2]|0;if(!c)return e|0;d=f[((b|0)==0?a+40|0:a+44|0)>>2]|0;switch(b|0){case 0:{a=a+5760|0;g=7;break}case 2:case 1:{a=a+5768|0;g=7;break}default:a=0}if((g|0)==7)a=((f[a>>2]|0)+7|0)/8|0;g=X(a,d)|0;f[c>>2]=g;return e|0}function Yp(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0,i=0;f[a>>2]=7696;e=a+377216|0;b=f[e>>2]|0;g=a+377220|0;c=f[g>>2]|0;if((b|0)!=(c|0))do{d=f[c+-4>>2]|0;if(d){aq(d);QK(d);c=f[g>>2]|0;b=f[e>>2]|0}c=c+-4|0;f[g>>2]=c}while((b|0)!=(c|0));if(b|0)QK(b);ys(a+376148|0);bq(a+375396|0);Pt(a+370984|0);Pt(a+366584|0);Pt(a+362184|0);Pt(a+357784|0);Pt(a+353384|0);Pt(a+348984|0);Pt(a+344584|0);Pt(a+340184|0);Pt(a+335784|0);Pt(a+331384|0);Pt(a+326984|0);Pt(a+322584|0);Pt(a+318184|0);Pt(a+313784|0);Pt(a+309384|0);Pt(a+304984|0);Pt(a+300584|0);Pt(a+296184|0);Pt(a+291784|0);Pt(a+287384|0);Pt(a+282984|0);Pt(a+278584|0);Pt(a+274184|0);Pt(a+269784|0);Pt(a+265384|0);Pt(a+260984|0);Pt(a+256584|0);Pt(a+252184|0);Pt(a+247784|0);Pt(a+243384|0);Pt(a+238984|0);Pt(a+234584|0);Pt(a+230184|0);Pt(a+225784|0);Pt(a+221384|0);Pt(a+216984|0);Pt(a+212584|0);Pt(a+208184|0);Pt(a+203784|0);Pt(a+199384|0);Pt(a+194984|0);Pt(a+190584|0);Pt(a+186184|0);Pt(a+181784|0);Pt(a+177384|0);Pt(a+172984|0);Pt(a+168584|0);Pt(a+164184|0);Pt(a+159784|0);Pt(a+155384|0);Pt(a+150984|0);Pt(a+146584|0);Pt(a+142184|0);Pt(a+137784|0);Pt(a+133384|0);Pt(a+128984|0);Pt(a+124584|0);Pt(a+120184|0);Pt(a+115784|0);Pt(a+111384|0);Pt(a+106984|0);Pt(a+102584|0);Pt(a+98184|0);Pt(a+93784|0);Lu(a+88616|0);Lu(a+83448|0);Lu(a+78280|0);Lu(a+73112|0);Lu(a+67944|0);Lu(a+62776|0);Lu(a+57608|0);Lu(a+52440|0);Lu(a+47272|0);Lu(a+42104|0);Lu(a+36936|0);Lu(a+31768|0);Lu(a+26600|0);Lu(a+21432|0);Lu(a+16264|0);Lu(a+11096|0);i=a+600|0;h=a+11096|0;do{b=f[h+-16>>2]|0;if(b|0){c=h+-12|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b)}b=f[h+-28>>2]|0;if(b|0){c=h+-24|0;d=f[c>>2]|0;if((d|0)!=(b|0))f[c>>2]=d+(~((d+-2-b|0)>>>1)<<1);QK(b)}e=h+-64|0;b=f[e>>2]|0;if(b|0){g=h+-60|0;c=f[g>>2]|0;if((c|0)!=(b|0)){do{c=c+-12|0;f[g>>2]=c;d=f[c>>2]|0;if(d){QK(d);c=f[g>>2]|0}}while((c|0)!=(b|0));b=f[e>>2]|0}QK(b)}h=h+-656|0}while((h|0)!=(i|0));wt(a+548|0);return}function Zp(a){a=a|0;Yp(a);QK(a);return}function _p(a,b){a=a|0;b=b|0;var c=0;c=f[a+376156>>2]|0;if((f[a+376160>>2]|0)-c>>2>>>0<=b>>>0){c=0;return c|0}c=f[c+(b<<2)>>2]|0;return c|0}function $p(a,b){a=a|0;b=b|0;if((b|0)<=-1){b=0;return b|0}b=((f[a+376160>>2]|0)-(f[a+376156>>2]|0)>>2|0)>(b|0);return b|0}function aq(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0;k=a+10632|0;l=a+10636|0;c=f[l>>2]|0;b=f[k>>2]|0;if((c|0)!=(b|0)){g=0;do{e=f[b+(g<<2)>>2]|0;if(e){Ct((f[e+144>>2]|0)+548|0,f[e>>2]|0);c=f[e+136>>2]|0;if(c|0){d=c+-16|0;b=f[d+12>>2]|0;if(b|0){b=c+(b*18624|0)|0;do{bw(b+-44|0);b=b+-18624|0}while((b|0)!=(c|0))}RK(d)}cv(e+44|0);QK(e);b=f[k>>2]|0;c=f[l>>2]|0}g=g+1|0}while(g>>>0<c-b>>2>>>0)}i=a+10664|0;j=a+10668|0;b=f[j>>2]|0;d=f[i>>2]|0;c=d;if((b|0)!=(d|0)){h=0;g=c;e=d;while(1){d=f[g+(h<<2)>>2]|0;if(!d)d=e;else{dd[f[(f[d>>2]|0)+4>>2]&511](d);d=f[i>>2]|0;c=d;b=f[j>>2]|0}h=h+1|0;if(h>>>0>=b-d>>2>>>0)break;else{g=d;e=d}}}e=a+10676|0;b=f[e>>2]|0;if(!b)b=c;else{d=a+10680|0;c=f[d>>2]|0;if((c|0)!=(b|0)){do{h=c+-8|0;f[d>>2]=h;bw(h);c=f[d>>2]|0}while((c|0)!=(b|0));b=f[e>>2]|0}QK(b);b=f[i>>2]|0}if(b|0){c=f[j>>2]|0;if((c|0)!=(b|0))f[j>>2]=c+(~((c+-4-b|0)>>>2)<<2);QK(b)}b=f[a+10644>>2]|0;if(b|0){c=a+10648|0;d=f[c>>2]|0;if((d|0)!=(b|0))f[c>>2]=d+(~(((d+-80-b|0)>>>0)/80|0)*80|0);QK(b)}b=f[k>>2]|0;if(!b){l=a+8|0;Us(l);return}c=f[l>>2]|0;if((c|0)!=(b|0))f[l>>2]=c+(~((c+-4-b|0)>>>2)<<2);QK(b);l=a+8|0;Us(l);return}function bq(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;l=a+8|0;c=f[l>>2]|0;j=a+20|0;b=f[j>>2]|0;d=c+(b>>>10<<2)|0;m=a+12|0;i=f[m>>2]|0;e=i;g=c;if((i|0)==(c|0)){h=0;i=a+24|0;b=0}else{i=a+24|0;h=(f[i>>2]|0)+b|0;h=(f[c+(h>>>10<<2)>>2]|0)+((h&1023)<<2)|0;b=(f[d>>2]|0)+((b&1023)<<2)|0}a:while(1){do{if((b|0)==(h|0))break a;b=b+4|0}while((b-(f[d>>2]|0)|0)!=4096);b=d+4|0;d=b;b=f[b>>2]|0}f[i>>2]=0;b=e-g>>2;if(b>>>0>2)do{QK(f[c>>2]|0);c=(f[l>>2]|0)+4|0;f[l>>2]=c;b=(f[m>>2]|0)-c>>2}while(b>>>0>2);switch(b|0){case 1:{b=512;k=13;break}case 2:{b=1024;k=13;break}default:{}}if((k|0)==13)f[j>>2]=b;b=f[l>>2]|0;c=f[m>>2]|0;if((b|0)!=(c|0)){do{QK(f[b>>2]|0);b=b+4|0}while((b|0)!=(c|0));b=f[l>>2]|0;c=f[m>>2]|0;if((c|0)!=(b|0))f[m>>2]=c+(~((c+-4-b|0)>>>2)<<2)}b=f[a+4>>2]|0;if(!b)return;QK(b);return}function cq(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0;e=a+136|0;if(f[e>>2]|0)Pa(34895,34917,169,34927);g=b*18624|0;g=PK(b>>>0>230614|g>>>0>4294967279?-1:g+16|0)|0;f[g+12>>2]=b;g=g+16|0;if(!b){f[e>>2]=g;g=a+140|0;f[g>>2]=b;return}c=g+(b*18624|0)|0;d=g;do{$v(d+18580|0);j=d+18508|0;i=d+18592|0;k=d+48|0;h=k&15;h=(h|0)==0?k:k+(16-h)|0;f[j>>2]=0;f[j+4>>2]=0;f[j+8>>2]=0;f[j+12>>2]=0;f[j+16>>2]=0;f[i>>2]=0;f[i+4>>2]=0;f[i+8>>2]=0;f[i+12>>2]=0;f[i+16>>2]=0;f[d+2112>>2]=h;IM(h|0,0,2048)|0;d=d+18624|0}while((d|0)!=(c|0));f[e>>2]=g;k=a+140|0;f[k>>2]=b;return}function dq(a){a=a|0;return}function eq(a){a=a|0;QK(a);return}function fq(a){a=a|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0;f[a+84>>2]=0;f[a+168>>2]=0;f[a>>2]=7720;Qq(a+172|0);f[a>>2]=7696;vt(a+548|0);f[a+1192>>2]=0;f[a+1196>>2]=0;f[a+1200>>2]=0;c=a+1228|0;f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;f[c+12>>2]=0;f[c+16>>2]=0;f[c+20>>2]=0;f[a+1848>>2]=0;f[a+1852>>2]=0;f[a+1856>>2]=0;c=a+1884|0;f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;f[c+12>>2]=0;f[c+16>>2]=0;f[c+20>>2]=0;f[a+2504>>2]=0;f[a+2508>>2]=0;f[a+2512>>2]=0;c=a+2540|0;f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;f[c+12>>2]=0;f[c+16>>2]=0;f[c+20>>2]=0;f[a+3160>>2]=0;f[a+3164>>2]=0;f[a+3168>>2]=0;c=a+3196|0;f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;f[c+12>>2]=0;f[c+16>>2]=0;f[c+20>>2]=0;f[a+3816>>2]=0;f[a+3820>>2]=0;f[a+3824>>2]=0;c=a+3852|0;f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;f[c+12>>2]=0;f[c+16>>2]=0;f[c+20>>2]=0;f[a+4472>>2]=0;f[a+4476>>2]=0;f[a+4480>>2]=0;c=a+4508|0;f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;f[c+12>>2]=0;f[c+16>>2]=0;f[c+20>>2]=0;f[a+5128>>2]=0;f[a+5132>>2]=0;f[a+5136>>2]=0;c=a+5164|0;f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;f[c+12>>2]=0;f[c+16>>2]=0;f[c+20>>2]=0;f[a+5784>>2]=0;f[a+5788>>2]=0;f[a+5792>>2]=0;c=a+5820|0;f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;f[c+12>>2]=0;f[c+16>>2]=0;f[c+20>>2]=0;f[a+6440>>2]=0;f[a+6444>>2]=0;f[a+6448>>2]=0;c=a+6476|0;f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;f[c+12>>2]=0;f[c+16>>2]=0;f[c+20>>2]=0;f[a+7096>>2]=0;f[a+7100>>2]=0;f[a+7104>>2]=0;c=a+7132|0;f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;f[c+12>>2]=0;f[c+16>>2]=0;f[c+20>>2]=0;f[a+7752>>2]=0;f[a+7756>>2]=0;f[a+7760>>2]=0;c=a+7788|0;f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;f[c+12>>2]=0;f[c+16>>2]=0;f[c+20>>2]=0;f[a+8408>>2]=0;f[a+8412>>2]=0;f[a+8416>>2]=0;c=a+8444|0;f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;f[c+12>>2]=0;f[c+16>>2]=0;f[c+20>>2]=0;f[a+9064>>2]=0;f[a+9068>>2]=0;f[a+9072>>2]=0;c=a+9100|0;f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;f[c+12>>2]=0;f[c+16>>2]=0;f[c+20>>2]=0;f[a+9720>>2]=0;f[a+9724>>2]=0;f[a+9728>>2]=0;c=a+9756|0;f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;f[c+12>>2]=0;f[c+16>>2]=0;f[c+20>>2]=0;f[a+10376>>2]=0;f[a+10380>>2]=0;f[a+10384>>2]=0;c=a+10412|0;f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;f[c+12>>2]=0;f[c+16>>2]=0;f[c+20>>2]=0;f[a+11032>>2]=0;f[a+11036>>2]=0;f[a+11040>>2]=0;c=a+11068|0;f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;f[c+12>>2]=0;f[c+16>>2]=0;f[c+20>>2]=0;Ku(a+11096|0);Ku(a+16264|0);Ku(a+21432|0);Ku(a+26600|0);Ku(a+31768|0);Ku(a+36936|0);Ku(a+42104|0);Ku(a+47272|0);Ku(a+52440|0);Ku(a+57608|0);Ku(a+62776|0);Ku(a+67944|0);Ku(a+73112|0);Ku(a+78280|0);Ku(a+83448|0);Ku(a+88616|0);c=0;do{Nt(a+93784+(c*4400|0)|0);c=c+1|0}while((c|0)!=64);h=a+375400|0;f[h>>2]=0;f[h+4>>2]=0;f[h+8>>2]=0;f[h+12>>2]=0;f[h+16>>2]=0;f[h+20>>2]=0;xs(a+376148|0);f[a+377216>>2]=0;f[a+377220>>2]=0;f[a+377224>>2]=0;b[a+512>>0]=0;b[a+513>>0]=1;b[a+514>>0]=0;b[a+532>>0]=0;b[a+533>>0]=0;h=a+516|0;f[h>>2]=-1;f[h+4>>2]=-1;f[h+8>>2]=-1;f[h+12>>2]=-1;h=7736;c=f[h+4>>2]|0;i=a+536|0;f[i>>2]=f[h>>2];f[i+4>>2]=c;f[a+544>>2]=0;f[a+375384>>2]=0;f[a+375388>>2]=0;f[a+375392>>2]=0;f[a+375892>>2]=0;i=a+375896|0;f[i>>2]=6;f[a+375900>>2]=100;f[a+375904>>2]=6;f[a+375912>>2]=6;f[a+375908>>2]=100;c=6;while(1){h=c*100|0;e=(h|0)/7|0;h=(h+100|0)/7|0;if((h|0)>=(e|0)){g=h-e|0;d=e;while(1){k=f[i>>2]|0;j=(c|0)>(k|0);c=j?k:c;b[a+375916+(d<<1)>>0]=c;b[a+375916+(d<<1)+1>>0]=j?100:(((d-e|0)*100|0)/(g|0)|0)&255;if((d|0)<(h|0))d=d+1|0;else break}}f[a+376120+(c<<2)>>2]=h;if((c|0)>0)c=c+-1|0;else break}k=a+376204|0;f[k>>2]=0;f[k+4>>2]=0;f[k+8>>2]=0;f[k+12>>2]=0;f[k+16>>2]=0;f[k+20>>2]=0;b[a+376208>>0]=1;f[k>>2]=-1;return}function gq(a){a=a|0;if((f[a+375892>>2]|0)<=0)return;hv(a+375396|0);return}function hq(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0;IM(c+48|0,0,2064)|0;f[c+18532>>2]=-1;f[c+18536>>2]=-1;g=f[c+18596>>2]|0;a=f[(f[c+18600>>2]|0)+16>>2]|0;if((a|0)<=0)return;h=f[(f[g+10284>>2]|0)+((f[(f[g+10272>>2]|0)+(a<<2)>>2]|0)+-1<<2)>>2]|0;i=f[g+5820>>2]|0;e=f[g+5804>>2]|0;a=(((h|0)%(i|0)|0)+1<<e)+-1|0;e=(((h|0)/(i|0)|0)+1<<e)+-1|0;i=(f[g+1248>>2]|0)+-1|0;h=(f[g+1252>>2]|0)+-1|0;d=f[g+10368>>2]|0;a=((i|0)<(a|0)?i:a)>>d;d=((h|0)<(e|0)?h:e)>>d;if((a|0)<=-1)Pa(48699,48736,118,48756);e=f[g+10372>>2]|0;if((a|0)>=(e|0))Pa(48699,48736,118,48756);if((d|0)<=-1)Pa(48760,48736,119,48756);if((d|0)>=(f[g+10376>>2]|0))Pa(48760,48736,119,48756);i=(f[g+10360>>2]|0)+(((X(e,d)|0)+a|0)*3|0)+2|0;f[c+18528>>2]=b[i>>0];return}function iq(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0;i=a+4|0;j=f[a>>2]|0;k=(f[i>>2]|0)-j|0;h=k>>2;c=h+1|0;if(c>>>0>1073741823)$I(a);l=a+8|0;g=(f[l>>2]|0)-j|0;d=g>>1;d=g>>2>>>0<536870911?(d>>>0<c>>>0?c:d):1073741823;do if(d)if(d>>>0>1073741823){l=Ra(8)|0;VK(l,44736);f[l>>2]=17660;Va(l|0,4016,428)}else{g=OK(d<<2)|0;break}else g=0;while(0);e=g+(h<<2)|0;f[e>>2]=f[b>>2];c=e+(0-h<<2)|0;if((k|0)>0)GM(c|0,j|0,k|0)|0;f[a>>2]=c;f[i>>2]=e+4;f[l>>2]=g+(d<<2);if(!j)return;QK(j);return}function jq(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0;j=u;u=u+656|0;g=j;d=g+592|0;f[d>>2]=0;i=g+596|0;f[i>>2]=0;f[g+600>>2]=0;e=g+628|0;f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;f[e+12>>2]=0;f[e+16>>2]=0;f[e+20>>2]=0;c=yv(g,a+4|0,c)|0;if(!c){c=f[a+520>>2]|0;if((c|0)>-1)Hv(g,c);c=f[g>>2]|0;h=a+600+(c*656|0)|0;GM(h|0,g|0,592)|0;if((h|0)==(g|0)){h=a+600+(c*656|0)+604|0;d=g+604|0;f[h>>2]=f[d>>2];f[h+4>>2]=f[d+4>>2];f[h+8>>2]=f[d+8>>2];f[h+12>>2]=f[d+12>>2];f[h+16>>2]=f[d+16>>2];f[h+20>>2]=f[d+20>>2]}else{kq(a+600+(c*656|0)+592|0,f[d>>2]|0,f[i>>2]|0);h=a+600+(c*656|0)+604|0;d=g+604|0;f[h>>2]=f[d>>2];f[h+4>>2]=f[d+4>>2];f[h+8>>2]=f[d+8>>2];f[h+12>>2]=f[d+12>>2];f[h+16>>2]=f[d+16>>2];f[h+20>>2]=f[d+20>>2];lq(a+600+(c*656|0)+628|0,f[e>>2]|0,f[g+632>>2]|0);mq(a+600+(c*656|0)+640|0,f[g+640>>2]|0,f[g+644>>2]|0)}b[a+600+(c*656|0)+652>>0]=b[g+652>>0]|0;h=0}else h=c;c=f[g+640>>2]|0;if(c|0){a=g+644|0;if((f[a>>2]|0)!=(c|0))f[a>>2]=c;QK(c)}c=f[e>>2]|0;if(c|0){a=g+632|0;d=f[a>>2]|0;if((d|0)!=(c|0))f[a>>2]=d+(~((d+-2-c|0)>>>1)<<1);QK(c)}e=g+592|0;c=f[e>>2]|0;if(!c){u=j;return h|0}a=f[i>>2]|0;if((a|0)!=(c|0)){do{a=a+-12|0;f[i>>2]=a;d=f[a>>2]|0;if(d){QK(d);a=f[i>>2]|0}}while((a|0)!=(c|0));c=f[e>>2]|0}QK(c);u=j;return h|0}function kq(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0;w=u;u=u+32|0;s=w+24|0;r=w+16|0;t=w+8|0;v=w;p=(c-b|0)/12|0;i=a+8|0;e=f[i>>2]|0;o=f[a>>2]|0;d=o;if(p>>>0>((e-o|0)/12|0)>>>0){if(o){h=a+4|0;e=f[h>>2]|0;if((e|0)==(d|0))e=o;else{do{e=e+-12|0;f[h>>2]=e;g=f[e>>2]|0;if(g){QK(g);e=f[h>>2]|0}}while((e|0)!=(d|0));e=f[a>>2]|0}QK(e);f[i>>2]=0;f[h>>2]=0;f[a>>2]=0;e=0}if(p>>>0>357913941)$I(a);n=(e|0)/12|0;e=n<<1;e=n>>>0<178956970?(e>>>0<p>>>0?p:e):357913941;if(e>>>0>357913941)$I(a);g=OK(e*12|0)|0;n=a+4|0;f[n>>2]=g;f[a>>2]=g;f[i>>2]=g+(e*12|0);if((b|0)==(c|0)){u=w;return}l=t+4|0;m=v+4|0;k=b;while(1){f[g>>2]=0;e=g+4|0;f[e>>2]=0;h=g+8|0;f[h>>2]=0;i=k+4|0;j=f[i>>2]|0;if(j|0){if((j|0)<0){e=42;break}j=((j+-1|0)>>>5)+1|0;x=OK(j<<2)|0;f[g>>2]=x;f[e>>2]=0;f[h>>2]=j;h=f[k>>2]|0;f[t>>2]=h;f[l>>2]=0;j=f[i>>2]|0;f[v>>2]=h+(j>>>5<<2);f[m>>2]=j&31;f[r>>2]=f[t>>2];f[r+4>>2]=f[t+4>>2];f[s>>2]=f[v>>2];f[s+4>>2]=f[v+4>>2];nq(g,r,s)}k=k+12|0;e=(f[n>>2]|0)+12|0;f[n>>2]=e;if((k|0)==(c|0)){e=45;break}else g=e}if((e|0)==42)$I(g);else if((e|0)==45){u=w;return}}m=a+4|0;i=((f[m>>2]|0)-o|0)/12|0;l=p>>>0>i>>>0;i=b+(i*12|0)|0;k=l?i:c;a:do if((k|0)==(b|0))q=d;else{while(1){if((d|0)!=(b|0)){j=b+4|0;e=f[j>>2]|0;if(!e)e=0;else{h=d+8|0;if(e>>>0>f[h>>2]<<5>>>0){g=f[d>>2]|0;if(g){QK(g);f[d>>2]=0;f[h>>2]=0;f[d+4>>2]=0;e=f[j>>2]|0}if((e|0)<0)break;e=((e+-1|0)>>>5)+1|0;g=OK(e<<2)|0;f[d>>2]=g;f[d+4>>2]=0;f[h>>2]=e;e=f[j>>2]|0}else g=f[d>>2]|0;HM(g|0,f[b>>2]|0,((e+-1|0)>>>5<<2)+4|0)|0;e=f[j>>2]|0}f[d+4>>2]=e}b=b+12|0;d=d+12|0;if((b|0)==(k|0)){q=d;break a}}$I(d)}while(0);if(!l){d=f[m>>2]|0;if((d|0)==(q|0)){u=w;return}do{d=d+-12|0;f[m>>2]=d;e=f[d>>2]|0;if(e){QK(e);d=f[m>>2]|0}}while((d|0)!=(q|0));u=w;return}if((k|0)==(c|0)){u=w;return}j=t+4|0;b=v+4|0;k=f[m>>2]|0;while(1){f[k>>2]=0;d=k+4|0;f[d>>2]=0;e=k+8|0;f[e>>2]=0;g=i+4|0;h=f[g>>2]|0;if(h|0){if((h|0)<0){e=20;break}q=((h+-1|0)>>>5)+1|0;x=OK(q<<2)|0;f[k>>2]=x;f[d>>2]=0;f[e>>2]=q;q=f[i>>2]|0;f[t>>2]=q;f[j>>2]=0;x=f[g>>2]|0;f[v>>2]=q+(x>>>5<<2);f[b>>2]=x&31;f[r>>2]=f[t>>2];f[r+4>>2]=f[t+4>>2];f[s>>2]=f[v>>2];f[s+4>>2]=f[v+4>>2];nq(k,r,s)}i=i+12|0;d=(f[m>>2]|0)+12|0;f[m>>2]=d;if((i|0)==(c|0)){e=45;break}else k=d}if((e|0)==20)$I(k);else if((e|0)==45){u=w;return}}function lq(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;j=c;h=b;i=j-h|0;g=i>>1;k=a+8|0;d=f[k>>2]|0;m=f[a>>2]|0;l=m;if(g>>>0<=d-m>>1>>>0){i=a+4|0;e=(f[i>>2]|0)-m>>1;a=g>>>0>e>>>0;g=a?b+(e<<1)|0:c;e=g;d=e-h|0;c=d>>1;if(c|0)HM(m|0,b|0,d|0)|0;c=l+(c<<1)|0;if(a){d=j-e|0;if((d|0)<=0)return;GM(f[i>>2]|0,g|0,d|0)|0;f[i>>2]=(f[i>>2]|0)+(d>>>1<<1);return}else{d=f[i>>2]|0;if((d|0)==(c|0))return;f[i>>2]=d+(~((d+-2-c|0)>>>1)<<1);return}}e=m;if(m){d=a+4|0;c=f[d>>2]|0;if((c|0)!=(l|0))f[d>>2]=c+(~((c+-2-m|0)>>>1)<<1);QK(e);f[k>>2]=0;f[d>>2]=0;f[a>>2]=0;d=0}if((i|0)<0)$I(a);d=d>>1>>>0<1073741823?(d>>>0<g>>>0?g:d):2147483647;if((d|0)<0)$I(a);c=OK(d<<1)|0;e=a+4|0;f[e>>2]=c;f[a>>2]=c;f[k>>2]=c+(d<<1);if((i|0)<=0)return;GM(c|0,b|0,i|0)|0;f[e>>2]=c+(i>>>1<<1);return}function mq(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0;k=c;h=b;i=k-h|0;g=a+8|0;d=f[g>>2]|0;e=f[a>>2]|0;j=e;if(i>>>0>(d-e|0)>>>0){if(e){d=a+4|0;if((f[d>>2]|0)!=(j|0))f[d>>2]=j;QK(j);f[g>>2]=0;f[d>>2]=0;f[a>>2]=0;d=0}if((i|0)<0)$I(a);k=d<<1;d=d>>>0<1073741823?(k>>>0<i>>>0?i:k):2147483647;if((d|0)<0)$I(a);j=OK(d)|0;k=a+4|0;f[k>>2]=j;f[a>>2]=j;f[g>>2]=j+d;GM(j|0,b|0,i|0)|0;f[k>>2]=j+i;return}g=a+4|0;e=(f[g>>2]|0)-e|0;a=i>>>0>e>>>0;c=a?b+e|0:c;e=c;d=e-h|0;if(d|0)HM(j|0,b|0,d|0)|0;d=j+d|0;if(a){d=k-e|0;if((d|0)<=0)return;GM(f[g>>2]|0,c|0,d|0)|0;f[g>>2]=(f[g>>2]|0)+d;return}else{if((f[g>>2]|0)==(d|0))return;f[g>>2]=d;return}}function nq(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;q=u;u=u+48|0;n=q+40|0;m=q+32|0;j=q+8|0;k=q;l=q+24|0;p=q+16|0;g=a+4|0;r=f[g>>2]|0;d=b;o=f[d>>2]|0;d=f[d+4>>2]|0;h=c;e=f[h>>2]|0;h=f[h+4>>2]|0;i=e-o<<3;f[g>>2]=r-d+h+i;g=(f[a>>2]|0)+(r>>>5<<2)|0;c=r&31;b=g;if((d|0)!=(c|0)){r=j;f[r>>2]=o;f[r+4>>2]=d;r=k;f[r>>2]=e;f[r+4>>2]=h;f[l>>2]=b;f[l+4>>2]=c;f[m>>2]=f[j>>2];f[m+4>>2]=f[j+4>>2];f[n>>2]=f[k>>2];f[n+4>>2]=f[k+4>>2];oq(p,m,n,l);u=q;return}c=h-d+i|0;h=o;if((c|0)>0){if(!d){d=0;b=o}else{b=32-d|0;r=(c|0)<(b|0)?c:b;b=-1>>>(b-r|0)&-1<<d;f[g>>2]=f[g>>2]&~b|f[h>>2]&b;b=r+d|0;h=h+4|0;c=c-r|0;d=b&31;g=g+(b>>>5<<2)|0;b=h}e=(c|0)/32|0;HM(g|0,b|0,e<<2|0)|0;a=c-(e<<5)|0;c=g+(e<<2)|0;b=c;if((a|0)>0){d=-1>>>(32-a|0);f[c>>2]=f[c>>2]&~d|f[h+(e<<2)>>2]&d;d=a}}f[p>>2]=b;f[p+4>>2]=d;u=q;return}function oq(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;p=f[b>>2]|0;m=f[b+4>>2]|0;i=((f[c>>2]|0)-p<<3)+(f[c+4>>2]|0)-m|0;c=p;if((i|0)<=0){b=d+4|0;d=f[d>>2]|0;f[a>>2]=d;d=a+4|0;a=f[b>>2]|0;f[d>>2]=a;return}if(!m){e=d+4|0;n=e;e=f[e>>2]|0}else{h=32-m|0;l=(i|0)<(h|0)?i:h;h=-1>>>(h-l|0)&-1<<m&f[c>>2];n=d+4|0;e=f[n>>2]|0;k=32-e|0;g=k>>>0<l>>>0?k:l;j=f[d>>2]|0;e=f[j>>2]&~(-1>>>(k-g|0)&-1<<e);f[j>>2]=e;k=f[n>>2]|0;f[j>>2]=(k>>>0>m>>>0?h<<k-m:h>>>(m-k|0))|e;e=(f[n>>2]|0)+g|0;j=j+(e>>>5<<2)|0;f[d>>2]=j;e=e&31;f[n>>2]=e;k=l-g|0;if((k|0)>0){f[j>>2]=h>>>(m+g|0)|f[j>>2]&~(-1>>>(32-k|0));f[n>>2]=k;e=k}c=c+4|0;f[b>>2]=c;i=i-l|0}p=32-e|0;k=-1<<e;if((i|0)>31){l=~k;j=f[d>>2]|0;e=i+-32|0;o=e>>>5;m=o+1|0;o=e-(o<<5)|0;e=c;g=f[j>>2]|0;h=j;while(1){q=f[e>>2]|0;r=g&l;f[h>>2]=r;f[h>>2]=q<<f[n>>2]|r;h=h+4|0;g=f[h>>2]&k|q>>>p;f[h>>2]=g;i=i+-32|0;if((i|0)<=31)break;else e=e+4|0}c=c+(m<<2)|0;f[b>>2]=c;f[d>>2]=j+(m<<2);i=o}if((i|0)<=0){q=n;r=f[d>>2]|0;f[a>>2]=r;r=a+4|0;q=f[q>>2]|0;f[r>>2]=q;return}h=f[c>>2]&-1>>>(32-i|0);g=(p|0)<(i|0)?p:i;e=f[d>>2]|0;c=f[e>>2]&~(-1<<f[n>>2]&-1>>>(p-g|0));f[e>>2]=c;f[e>>2]=c|h<<f[n>>2];c=(f[n>>2]|0)+g|0;e=e+(c>>>5<<2)|0;f[d>>2]=e;f[n>>2]=c&31;c=i-g|0;if((c|0)<=0){q=n;r=f[d>>2]|0;f[a>>2]=r;r=a+4|0;q=f[q>>2]|0;f[r>>2]=q;return}f[e>>2]=f[e>>2]&~(-1>>>(32-c|0))|h>>>g;f[n>>2]=c;q=n;r=f[d>>2]|0;f[a>>2]=r;r=a+4|0;q=f[q>>2]|0;f[r>>2]=q;return}function pq(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;d=u;u=u+5168|0;c=d;Ku(c);b=Mu(c,a+4|0,b)|0;if(b|0){a=b;Lu(c);u=d;return a|0}b=f[a+516>>2]|0;if((b|0)>-1)Tu(c,b);b=f[c+472>>2]|0;e=a+11096+(b*5168|0)|0;GM(e|0,c|0,4717)|0;if((e|0)!=(c|0))qq(a+11096+(b*5168|0)+4720|0,f[c+4720>>2]|0,f[c+4724>>2]|0);GM(a+11096+(b*5168|0)+4732|0,c+4732|0,436)|0;e=0;Lu(c);u=d;return e|0}function qq(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;j=c;i=b;h=j-i|0;g=(h|0)/100|0;k=a+8|0;d=f[k>>2]|0;m=f[a>>2]|0;l=m;if(g>>>0<=((d-m|0)/100|0)>>>0){h=a+4|0;e=((f[h>>2]|0)-m|0)/100|0;a=g>>>0>e>>>0;g=a?b+(e*100|0)|0:c;e=g;d=e-i|0;if(d|0)HM(m|0,b|0,d|0)|0;c=l+(((d|0)/100|0)*100|0)|0;if(a){d=j-e|0;if((d|0)<=0)return;GM(f[h>>2]|0,g|0,d|0)|0;f[h>>2]=(f[h>>2]|0)+(((d>>>0)/100|0)*100|0);return}else{d=f[h>>2]|0;if((d|0)==(c|0))return;f[h>>2]=d+(~(((d+-100-c|0)>>>0)/100|0)*100|0);return}}e=m;if(m){d=a+4|0;c=f[d>>2]|0;if((c|0)!=(l|0))f[d>>2]=c+(~(((c+-100-m|0)>>>0)/100|0)*100|0);QK(e);f[k>>2]=0;f[d>>2]=0;f[a>>2]=0;d=0}if(g>>>0>42949672)$I(a);m=(d|0)/100|0;d=m<<1;d=m>>>0<21474836?(d>>>0<g>>>0?g:d):42949672;if(d>>>0>42949672)$I(a);c=OK(d*100|0)|0;e=a+4|0;f[e>>2]=c;f[a>>2]=c;f[k>>2]=c+(d*100|0);if((h|0)<=0)return;GM(c|0,b|0,h|0)|0;f[e>>2]=c+(((h>>>0)/100|0)*100|0);return}function rq(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0;g=u;u=u+4400|0;e=g;Nt(e);d=Qt(e,c,a)|0;c=f[a+524>>2]|0;if((c|0)>-1)Tt(e,c);if(!d){a=d?0:1006;Pt(e);u=g;return a|0}c=b[e+1>>0]|0;h=a+93784+(c*4400|0)|0;GM(h|0,e|0,4340)|0;if((h|0)==(e|0)){h=d?0:1006;Pt(e);u=g;return h|0}sq(a+93784+(c*4400|0)+4340|0,f[e+4340>>2]|0,f[e+4344>>2]|0);sq(a+93784+(c*4400|0)+4352|0,f[e+4352>>2]|0,f[e+4356>>2]|0);sq(a+93784+(c*4400|0)+4364|0,f[e+4364>>2]|0,f[e+4368>>2]|0);sq(a+93784+(c*4400|0)+4376|0,f[e+4376>>2]|0,f[e+4380>>2]|0);sq(a+93784+(c*4400|0)+4388|0,f[e+4388>>2]|0,f[e+4392>>2]|0);h=d?0:1006;Pt(e);u=g;return h|0}function sq(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;j=c;h=b;i=j-h|0;g=i>>2;k=a+8|0;d=f[k>>2]|0;m=f[a>>2]|0;l=m;if(g>>>0<=d-m>>2>>>0){i=a+4|0;e=(f[i>>2]|0)-m>>2;a=g>>>0>e>>>0;g=a?b+(e<<2)|0:c;e=g;d=e-h|0;c=d>>2;if(c|0)HM(m|0,b|0,d|0)|0;c=l+(c<<2)|0;if(a){d=j-e|0;if((d|0)<=0)return;GM(f[i>>2]|0,g|0,d|0)|0;f[i>>2]=(f[i>>2]|0)+(d>>>2<<2);return}else{d=f[i>>2]|0;if((d|0)==(c|0))return;f[i>>2]=d+(~((d+-4-c|0)>>>2)<<2);return}}e=m;if(m){d=a+4|0;c=f[d>>2]|0;if((c|0)!=(l|0))f[d>>2]=c+(~((c+-4-m|0)>>>2)<<2);QK(e);f[k>>2]=0;f[d>>2]=0;f[a>>2]=0;d=0}if(g>>>0>1073741823)$I(a);m=d>>1;d=d>>2>>>0<536870911?(m>>>0<g>>>0?g:m):1073741823;if(d>>>0>1073741823)$I(a);c=OK(d<<2)|0;e=a+4|0;f[e>>2]=c;f[a>>2]=c;f[k>>2]=c+(d<<2);if((i|0)<=0)return;GM(c|0,b|0,i|0)|0;f[e>>2]=c+(i>>>2<<2);return}function tq(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0;i=a+4|0;j=f[a>>2]|0;k=(f[i>>2]|0)-j|0;e=(k|0)/80|0;c=e+1|0;if(c>>>0>53687091)$I(a);l=a+8|0;g=((f[l>>2]|0)-j|0)/80|0;h=g<<1;c=g>>>0<26843545?(h>>>0<c>>>0?c:h):53687091;do if(c)if(c>>>0>53687091){l=Ra(8)|0;VK(l,44736);f[l>>2]=17660;Va(l|0,4016,428)}else{d=OK(c*80|0)|0;break}else d=0;while(0);h=d+(e*80|0)|0;g=d+(c*80|0)|0;e=h;c=b;d=e+80|0;do{f[e>>2]=f[c>>2];e=e+4|0;c=c+4|0}while((e|0)<(d|0));c=h+(((k|0)/-80|0)*80|0)|0;if((k|0)>0)GM(c|0,j|0,k|0)|0;f[a>>2]=c;f[i>>2]=h+80;f[l>>2]=g;if(!j)return;QK(j);return}function uq(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;a:do if(c){d=a+164|0;e=f[d>>2]|0;do if((e|0)>0){c=0;while(1){if((f[a+84+(c<<2)>>2]|0)==(b|0)){c=10;break}c=c+1|0;if((c|0)>=(e|0)){c=5;break}}if((c|0)==5)if((e|0)<20)break;else break a;else if((c|0)==10)return}while(0);f[d>>2]=e+1;f[a+84+(e<<2)>>2]=b}while(0);d=a+80|0;c=f[d>>2]|0;if((c|0)==20){b=1001;c=19}else f[d>>2]=c+1;f[a+(c<<2)>>2]=b;return}function vq(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;o=u;u=u+16|0;l=o+4|0;k=o+8|0;m=o;n=OK(1356)|0;wq(n);i=Fu(n,c,a,k)|0;f[m>>2]=i;if(!(b[k>>0]|0)){g=f[a+376224>>2]|0;if(g|0)b[g+10516>>0]=2;Ct(a+548|0,d);g=f[n+1344>>2]|0;if(g|0){e=n+1348|0;h=f[e>>2]|0;if((h|0)!=(g|0))f[e>>2]=h+(~((h+-4-g|0)>>>2)<<2);QK(g)}bw(n+1332|0);g=f[n+776>>2]|0;if(g|0){e=n+780|0;h=f[e>>2]|0;if((h|0)!=(g|0))f[e>>2]=h+(~((h+-4-g|0)>>>2)<<2);QK(g)}QK(n);n=i;u=o;return n|0}g=f[a+528>>2]|0;if((g|0)>-1)Gu(n,a,g);j=d+8|0;j=xq(a,a,n,m,f[j>>2]|0,f[j+4>>2]|0,e,f[d+16>>2]|0)|0;k=a+376224|0;g=f[k>>2]|0;if(!j){if(g|0)b[g+10516>>0]=2;Ct(a+548|0,d);g=f[n+1344>>2]|0;if(g|0){e=n+1348|0;h=f[e>>2]|0;if((h|0)!=(g|0))f[e>>2]=h+(~((h+-4-g|0)>>>2)<<2);QK(g)}bw(n+1332|0);g=f[n+776>>2]|0;if(g|0){e=n+780|0;h=f[e>>2]|0;if((h|0)!=(g|0))f[e>>2]=h+(~((h+-4-g|0)>>>2)<<2);QK(g)}QK(n);n=f[m>>2]|0;u=o;return n|0}f[l>>2]=n;e=g+48|0;h=g+52|0;i=f[h>>2]|0;f[n>>2]=i-(f[e>>2]|0)>>2;if((i|0)==(f[g+56>>2]|0))yq(e,l);else{f[i>>2]=n;f[h>>2]=(f[h>>2]|0)+4}Pv(c,1);Qv(c);i=(f[c>>2]|0)-(f[d+20>>2]|0)|0;j=n+768|0;if((f[j>>2]|0)>0){e=n+776|0;g=0;h=f[e>>2]|0;do{q=ut(d,f[h+(g<<2)>>2]|0,i)|0;h=f[e>>2]|0;p=h+(g<<2)|0;f[p>>2]=(f[p>>2]|0)-q;g=g+1|0}while((g|0)<(f[j>>2]|0))}if(!(b[n+4>>0]|0))g=a+377220|0;else{h=OK(10688)|0;Rs(h+8|0);g=h+10632|0;e=g+56|0;do{f[g>>2]=0;g=g+4|0}while((g|0)<(e|0));f[l>>2]=h;f[h>>2]=f[k>>2];g=a+377220|0;e=f[g>>2]|0;if((e|0)==(f[a+377224>>2]|0))zq(a+377216|0,l);else{f[e>>2]=h;f[g>>2]=(f[g>>2]|0)+4}}if((f[a+377216>>2]|0)!=(f[g>>2]|0)){i=OK(152)|0;f[i>>2]=0;e=i+4|0;f[e>>2]=0;f[i+32>>2]=0;b[i+36>>0]=0;bv(i+44|0);f[i+124>>2]=0;f[i+128>>2]=-1;f[i+132>>2]=-1;f[i+136>>2]=0;f[i+144>>2]=a;f[i+40>>2]=0;f[i+140>>2]=0;f[l>>2]=i;f[i>>2]=d;f[e>>2]=n;e=i+8|0;f[e>>2]=f[c>>2];f[e+4>>2]=f[c+4>>2];f[e+8>>2]=f[c+8>>2];f[e+12>>2]=f[c+12>>2];f[e+16>>2]=f[c+16>>2];f[e+20>>2]=f[c+20>>2];b[i+36>>0]=b[a+377228>>0]|0;g=f[(f[g>>2]|0)+-4>>2]|0;e=g+10636|0;h=f[e>>2]|0;if((h|0)==(f[g+10640>>2]|0))Aq(g+10632|0,l);else{f[h>>2]=i;f[e>>2]=(f[e>>2]|0)+4}}q=Bq(a,l)|0;f[m>>2]=q;q=0;u=o;return q|0}function wq(a){a=a|0;f[a+776>>2]=0;f[a+780>>2]=0;f[a+784>>2]=0;$v(a+1332|0);f[a+1344>>2]=0;f[a+1348>>2]=0;f[a+1352>>2]=0;Eu(a);return}function xq(a,c,d,e,g,h,i,j){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=u;u=u+16|0;k=q;f[e>>2]=0;b[a+377228>>0]=0;l=f[d+8>>2]|0;m=c+93784+(l*4400|0)|0;if(!(b[m>>0]|0)){f[k>>2]=l;vv(1,35106,k);Pa(55956,34917,1987,35132)}o=c+375392|0;f[o>>2]=m;p=b[c+93784+(l*4400|0)+2>>0]|0;k=c+375388|0;f[k>>2]=c+11096+(p*5168|0);n=c+375384|0;f[n>>2]=c+600+((b[c+11096+(p*5168|0)+1>>0]|0)*656|0);Iq(a);p=d+4|0;if(!(b[p>>0]|0)){if(!(f[c+376224>>2]|0)){d=0;u=q;return d|0}}else{f[c+376204>>2]=f[d+28>>2];k=f[k>>2]|0;if(!(b[k+4703>>0]|0))l=1;else l=(b[c+533>>0]|0)!=0;l=Ls(c+376148|0,k,a,g,h,j,l)|0;if((l|0)==-1){f[e>>2]=9;d=0;u=q;return d|0}k=f[c+376156>>2]|0;if((f[c+376160>>2]|0)-k>>2>>>0>l>>>0)l=f[k+(l<<2)>>2]|0;else l=0;m=l+10518|0;b[m>>0]=b[i>>0]|0;b[m+1>>0]=b[i+1>>0]|0;b[m+2>>0]=b[i+2>>0]|0;m=c+376224|0;f[m>>2]=l;k=f[n>>2]|0;i=l+108|0;GM(i|0,k|0,592)|0;if((i|0)==(k|0)){i=l+712|0;e=k+604|0;f[i>>2]=f[e>>2];f[i+4>>2]=f[e+4>>2];f[i+8>>2]=f[e+8>>2];f[i+12>>2]=f[e+12>>2];f[i+16>>2]=f[e+16>>2];f[i+20>>2]=f[e+20>>2]}else{kq(l+700|0,f[k+592>>2]|0,f[k+596>>2]|0);i=l+712|0;e=k+604|0;f[i>>2]=f[e>>2];f[i+4>>2]=f[e+4>>2];f[i+8>>2]=f[e+8>>2];f[i+12>>2]=f[e+12>>2];f[i+16>>2]=f[e+16>>2];f[i+20>>2]=f[e+20>>2];lq(l+736|0,f[k+628>>2]|0,f[k+632>>2]|0);mq(l+748|0,f[k+640>>2]|0,f[k+644>>2]|0)}b[l+760>>0]=b[k+652>>0]|0;k=f[o>>2]|0;o=l+5932|0;GM(o|0,k|0,4340)|0;if((o|0)!=(k|0)){sq(l+10272|0,f[k+4340>>2]|0,f[k+4344>>2]|0);sq(l+10284|0,f[k+4352>>2]|0,f[k+4356>>2]|0);sq(l+10296|0,f[k+4364>>2]|0,f[k+4368>>2]|0);sq(l+10308|0,f[k+4376>>2]|0,f[k+4380>>2]|0);sq(l+10320|0,f[k+4388>>2]|0,f[k+4392>>2]|0)}f[l+10332>>2]=c;it(l);k=c+377212|0;do if(qt(b[k>>0]|0)|0){if(((!(nt(b[k>>0]|0)|0)?!(ot(b[k>>0]|0)|0):0)?(b[c+376208>>0]|0)==0:0)?(b[c+376211>>0]|0)==0:0){b[c+376209>>0]=0;b[c+376210>>0]=0;break}b[c+376209>>0]=1;b[c+376211>>0]=0}while(0);if(pt(b[k>>0]|0)|0?(b[c+376209>>0]|0)!=0:0)b[(f[m>>2]|0)+100>>0]=0;else b[(f[m>>2]|0)+100>>0]=(b[d+24>>0]|0)!=0&1;Jq(a,c,d);k=l+96|0;if(b[p>>0]|0){f[k>>2]=1;Kq(a,c,d)}f[k>>2]=1;uv(f[(f[m>>2]|0)+92>>2]|0);b[a+376208>>0]=0}if((f[d+20>>2]|0)>>>0<2?!(Lq(0,c,d)|0):0){d=0;u=q;return d|0}if(!(b[d+12>>0]|0)){k=c+376228|0;l=d+16|0}else{l=c+376228|0;k=l;l=(f[l>>2]|0)+800|0}f[d+800>>2]=f[l>>2];f[k>>2]=d;d=1;u=q;return d|0}function yq(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0;i=a+4|0;j=f[a>>2]|0;k=(f[i>>2]|0)-j|0;h=k>>2;c=h+1|0;if(c>>>0>1073741823)$I(a);l=a+8|0;g=(f[l>>2]|0)-j|0;d=g>>1;d=g>>2>>>0<536870911?(d>>>0<c>>>0?c:d):1073741823;do if(d)if(d>>>0>1073741823){l=Ra(8)|0;VK(l,44736);f[l>>2]=17660;Va(l|0,4016,428)}else{g=OK(d<<2)|0;break}else g=0;while(0);e=g+(h<<2)|0;f[e>>2]=f[b>>2];c=e+(0-h<<2)|0;if((k|0)>0)GM(c|0,j|0,k|0)|0;f[a>>2]=c;f[i>>2]=e+4;f[l>>2]=g+(d<<2);if(!j)return;QK(j);return}function zq(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0;i=a+4|0;j=f[a>>2]|0;k=(f[i>>2]|0)-j|0;h=k>>2;c=h+1|0;if(c>>>0>1073741823)$I(a);l=a+8|0;g=(f[l>>2]|0)-j|0;d=g>>1;d=g>>2>>>0<536870911?(d>>>0<c>>>0?c:d):1073741823;do if(d)if(d>>>0>1073741823){l=Ra(8)|0;VK(l,44736);f[l>>2]=17660;Va(l|0,4016,428)}else{g=OK(d<<2)|0;break}else g=0;while(0);e=g+(h<<2)|0;f[e>>2]=f[b>>2];c=e+(0-h<<2)|0;if((k|0)>0)GM(c|0,j|0,k|0)|0;f[a>>2]=c;f[i>>2]=e+4;f[l>>2]=g+(d<<2);if(!j)return;QK(j);return}function Aq(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0;i=a+4|0;j=f[a>>2]|0;k=(f[i>>2]|0)-j|0;h=k>>2;c=h+1|0;if(c>>>0>1073741823)$I(a);l=a+8|0;g=(f[l>>2]|0)-j|0;d=g>>1;d=g>>2>>>0<536870911?(d>>>0<c>>>0?c:d):1073741823;do if(d)if(d>>>0>1073741823){l=Ra(8)|0;VK(l,44736);f[l>>2]=17660;Va(l|0,4016,428)}else{g=OK(d<<2)|0;break}else g=0;while(0);e=g+(h<<2)|0;f[e>>2]=f[b>>2];c=e+(0-h<<2)|0;if((k|0)>0)GM(c|0,j|0,k|0)|0;f[a>>2]=c;f[i>>2]=e+4;f[l>>2]=g+(d<<2);if(!j)return;QK(j);return}function Bq(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=u;u=u+16|0;n=q;b[c>>0]=0;o=a+377216|0;d=f[o>>2]|0;p=a+377220|0;l=f[p>>2]|0;g=l;e=d;if((d|0)==(l|0)){p=0;u=q;return p|0}k=f[d>>2]|0;h=f[k+10636>>2]|0;i=f[k+10632>>2]|0;l=i;a:do if((h|0)!=(i|0)){i=h-i>>2;h=0;while(1){j=f[l+(h<<2)>>2]|0;h=h+1|0;if(!(f[j+40>>2]|0))break;if(h>>>0>=i>>>0)break a}if(j){if(b[j+36>>0]|0)Ks(a+376148|0)|0;b[c>>0]=1;d=Cq(a,k,j)|0;if(!d){d=f[o>>2]|0;e=d;g=f[p>>2]|0;break}else{p=d;u=q;return p|0}}}while(0);if(g-e>>2>>>0>1){k=f[d>>2]|0;l=f[k+10636>>2]|0;if((l|0)!=(f[k+10632>>2]|0)?(f[(f[l+-4>>2]|0)+40>>2]|0)==0:0)m=14}else m=14;if((m|0)==14){m=f[o>>2]|0;d=m;if((g|0)==(m|0)){p=0;u=q;return p|0}l=f[d>>2]|0;m=f[l+10636>>2]|0;if((m|0)!=(f[l+10632>>2]|0)?(f[(f[m+-4>>2]|0)+40>>2]|0)==0:0){p=0;u=q;return p|0}if(((f[a+556>>2]|0)!=0|0)!=(0-(f[a+580>>2]|0)|0)){p=0;u=q;return p|0}if((b[a+548>>0]|0)==0?(b[a+549>>0]|0)==0:0){p=0;u=q;return p|0}}i=f[d>>2]|0;b[c>>0]=1;d=f[i>>2]|0;g=d+10344|0;if((f[g>>2]|0)>0){e=d+10524|0;d=0;do{ev((f[e>>2]|0)+(d*80|0)|0,1);d=d+1|0}while((d|0)<(f[g>>2]|0));h=f[i>>2]|0}else h=d;g=h+10332|0;d=f[g>>2]|0;e=(b[d+532>>0]|0)==0;if(!(f[(f[(f[a+376224>>2]|0)+10332>>2]|0)+375892>>2]|0)){if(e){tw(h);d=f[g>>2]|0}if(!(b[d+533>>0]|0))$t(h)}else{if(e){sw(i);e=3;d=f[g>>2]|0}else e=1;if(!(b[d+533>>0]|0))au(i,e)|0;ht(h)}g=i+10644|0;h=i+10648|0;d=f[g>>2]|0;b:do if((f[h>>2]|0)==(d|0))h=0;else{e=0;while(1){d=gu(d+(e*80|0)|0,f[i>>2]|0)|0;e=e+1|0;if(d|0){h=d;break b}d=f[g>>2]|0;if(e>>>0>=(((f[h>>2]|0)-d|0)/80|0)>>>0){h=0;break}}}while(0);d=f[i>>2]|0;if(d|0){do if(b[d+100>>0]|0){if(b[d+10516>>0]|0?b[a+514>>0]|0:0)break;f[n>>2]=d;e=a+376172|0;g=f[e>>2]|0;if((g|0)==(f[a+376176>>2]|0))Dq(a+376168|0,n);else{f[g>>2]=d;f[e>>2]=(f[e>>2]|0)+4}}while(0);if(((f[a+376172>>2]|0)-(f[a+376168>>2]|0)>>2|0)>(f[d+596+(((f[d+116>>2]|0)+-1|0)*12|0)+4>>2]|0))Es(a+376148|0)}aq(i);QK(i);d=f[p>>2]|0;e=f[o>>2]|0;if(d-e>>2>>>0>1){g=1;do{d=e;f[d+(g+-1<<2)>>2]=f[d+(g<<2)>>2];g=g+1|0;d=f[p>>2]|0;e=f[o>>2]|0}while(g>>>0<d-e>>2>>>0)}f[p>>2]=d+-4;p=h;u=q;return p|0}function Cq(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;u=d+4|0;l=f[u>>2]|0;k=l+1344|0;l=l+1348|0;g=f[k>>2]|0;if((f[l>>2]|0)!=(g|0)){i=a+376148|0;j=a+376156|0;h=0;do{g=Ds(i,f[g+(h<<2)>>2]|0)|0;if((g|0)>-1)f[(f[(f[j>>2]|0)+(g<<2)>>2]|0)+96>>2]=0;h=h+1|0;g=f[k>>2]|0}while(h>>>0<(f[l>>2]|0)-g>>2>>>0)}l=f[c>>2]|0;r=d+40|0;f[r>>2]=1;j=f[l+10332>>2]|0;a:do if((f[j+375892>>2]|0)>0){p=b[l+5965>>0]|0;k=p<<24>>24!=0;q=b[l+5966>>0]|0;g=q<<24>>24!=0;if(!((p|q)<<24>>24)){h=j+168|0;i=f[h>>2]|0;if((i|0)>0){g=0;do{if((f[j+88+(g<<2)>>2]|0)==1e3){o=0;break a}g=g+1|0}while((g|0)<(i|0));if((i|0)<20)t=12}else t=12;if((t|0)==12){f[h>>2]=i+1;f[j+88+(i<<2)>>2]=1e3}h=j+84|0;g=f[h>>2]|0;if((g|0)==20){h=1001;g=19}else{f[h>>2]=g+1;h=1e3}f[j+4+(g<<2)>>2]=h;o=0}else o=g}else{o=0;k=0}while(0);p=c+10632|0;q=c+10636|0;g=f[q>>2]|0;h=f[p>>2]|0;if((g|0)!=(h|0)){if((f[h>>2]|0)==(d|0)?(m=f[(f[u>>2]|0)+16>>2]|0,(m|0)>0):0){h=l+10524|0;g=0;do{ev((f[h>>2]|0)+(g*80|0)|0,1);g=g+1|0}while((g|0)!=(m|0));h=f[p>>2]|0;g=f[q>>2]|0}}else h=g;i=g-h>>2;b:do if(i>>>0>1){g=1;while(1){if((f[h+(g<<2)>>2]|0)==(d|0))break;g=g+1|0;if(g>>>0>=i>>>0)break b}j=f[h+(g+-1<<2)>>2]|0;if(j|0?(f[j+40>>2]|0)==2:0){i=i+-1|0;g=0;do{if(g>>>0>=i>>>0)break b;m=g;g=g+1|0}while((f[h+(m<<2)>>2]|0)!=(j|0));g=f[h+(g<<2)>>2]|0;if(g|0?(e=f[(f[j+4>>2]|0)+16>>2]|0,n=g+4|0,(e|0)<(f[(f[n>>2]|0)+16>>2]|0)):0)do{g=f[c>>2]|0;if((e|0)>=(f[g+10344>>2]|0))break b;ev((f[g+10524>>2]|0)+(e*80|0)|0,1);e=e+1|0}while((e|0)<(f[(f[n>>2]|0)+16>>2]|0))}}while(0);if(!(k|o)){i=Eq(a,c,d)|0;f[r>>2]=2;h=f[p>>2]|0;g=((f[q>>2]|0)-h>>2)+-1|0;e=0;do{if(e>>>0>=g>>>0){s=i;t=60;break}n=e;e=e+1|0}while((f[h+(n<<2)>>2]|0)!=(d|0));if((t|0)==60)return s|0;e=f[h+(e<<2)>>2]|0;if(!e){c=i;return c|0}g=f[(f[u>>2]|0)+16>>2]|0;h=e+4|0;if((g|0)<(f[(f[h>>2]|0)+16>>2]|0))e=g;else{c=i;return c|0}while(1){g=f[c>>2]|0;if((e|0)>=(f[g+10344>>2]|0)){s=i;t=60;break}ev((f[g+10524>>2]|0)+(e*80|0)|0,1);e=e+1|0;if((e|0)>=(f[(f[h>>2]|0)+16>>2]|0)){s=i;t=60;break}}if((t|0)==60)return s|0}if(k&o){c=1006;return c|0}if(k){Fq(a,c,d)|0;f[r>>2]=2;h=f[p>>2]|0;g=((f[q>>2]|0)-h>>2)+-1|0;e=0;do{if(e>>>0>=g>>>0){s=0;t=60;break}n=e;e=e+1|0}while((f[h+(n<<2)>>2]|0)!=(d|0));if((t|0)==60)return s|0;e=f[h+(e<<2)>>2]|0;if(!e){c=0;return c|0}g=f[(f[u>>2]|0)+16>>2]|0;h=e+4|0;if((g|0)<(f[(f[h>>2]|0)+16>>2]|0))e=g;else{c=0;return c|0}while(1){g=f[c>>2]|0;if((e|0)>=(f[g+10344>>2]|0)){s=0;t=60;break}ev((f[g+10524>>2]|0)+(e*80|0)|0,1);e=e+1|0;if((e|0)>=(f[(f[h>>2]|0)+16>>2]|0)){s=0;t=60;break}}if((t|0)==60)return s|0}if(!o)Pa(55956,34917,971,34952);i=Gq(a,c,d)|0;f[r>>2]=2;h=f[p>>2]|0;g=((f[q>>2]|0)-h>>2)+-1|0;e=0;do{if(e>>>0>=g>>>0){s=i;t=60;break}a=e;e=e+1|0}while((f[h+(a<<2)>>2]|0)!=(d|0));if((t|0)==60)return s|0;g=f[h+(e<<2)>>2]|0;if(!g){c=i;return c|0}e=f[(f[u>>2]|0)+16>>2]|0;h=g+4|0;if((e|0)>=(f[(f[h>>2]|0)+16>>2]|0)){c=i;return c|0}while(1){g=f[c>>2]|0;if((e|0)>=(f[g+10344>>2]|0)){s=i;t=60;break}ev((f[g+10524>>2]|0)+(e*80|0)|0,1);e=e+1|0;if((e|0)>=(f[(f[h>>2]|0)+16>>2]|0)){s=i;t=60;break}}if((t|0)==60)return s|0;return 0}function Dq(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0;i=a+4|0;j=f[a>>2]|0;k=(f[i>>2]|0)-j|0;h=k>>2;c=h+1|0;if(c>>>0>1073741823)$I(a);l=a+8|0;g=(f[l>>2]|0)-j|0;d=g>>1;d=g>>2>>>0<536870911?(d>>>0<c>>>0?c:d):1073741823;do if(d)if(d>>>0>1073741823){l=Ra(8)|0;VK(l,44736);f[l>>2]=17660;Va(l|0,4016,428)}else{g=OK(d<<2)|0;break}else g=0;while(0);e=g+(h<<2)|0;f[e>>2]=f[b>>2];c=e+(0-h<<2)|0;if((k|0)>0)GM(c|0,j|0,k|0)|0;f[a>>2]=c;f[i>>2]=e+4;f[l>>2]=g+(d<<2);if(!j)return;QK(j);return}function Eq(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=u;u=u+18624|0;n=p;m=d+4|0;e=f[m>>2]|0;k=e+1344|0;l=e+1348|0;g=f[k>>2]|0;if((f[l>>2]|0)!=(g|0)){i=a+376148|0;j=a+376156|0;h=0;e=g;do{e=Ds(i,f[e+(h<<2)>>2]|0)|0;if((e|0)>-1)f[(f[(f[j>>2]|0)+(e<<2)>>2]|0)+96>>2]=0;h=h+1|0;e=f[k>>2]|0}while(h>>>0<(f[l>>2]|0)-e>>2>>>0);e=f[m>>2]|0}l=f[c>>2]|0;if((f[e+16>>2]|0)>>>0>=(f[l+10276>>2]|0)-(f[l+10272>>2]|0)>>2>>>0){o=6;u=p;return o|0}l=n+18580|0;$v(l);k=n+18508|0;e=n+48|0;f[k>>2]=0;f[k+4>>2]=0;f[k+8>>2]=0;f[k+12>>2]=0;f[k+16>>2]=0;f[n+2112>>2]=e;IM(e|0,0,2048)|0;e=f[m>>2]|0;f[n+18600>>2]=e;k=f[c>>2]|0;f[n+18596>>2]=k;f[n+18592>>2]=a;f[n+18604>>2]=c;f[n+18608>>2]=d;f[n+4>>2]=f[(f[k+10272>>2]|0)+(f[e+16>>2]<<2)>>2];f[n+18612>>2]=0;hq(0,n);e=f[d+12>>2]|0;if((e|0)<1)e=17;else{Tv(n+18556|0,f[d+8>>2]|0,e);do if(b[a+93817>>0]|0?b[(f[m>>2]|0)+4>>0]|0:0){k=c+10676|0;i=(f[(f[a+376224>>2]|0)+5828>>2]|0)+-1|0;j=c+10680|0;e=f[j>>2]|0;g=f[k>>2]|0;h=e-g>>3;if(i>>>0>h>>>0){Hq(k,i-h|0);break}if(i>>>0<h>>>0?(o=g+(i<<3)|0,(e|0)!=(o|0)):0)do{c=e+-8|0;f[j>>2]=c;bw(c);e=f[j>>2]|0}while((e|0)!=(o|0))}while(0);f[d+124>>2]=1;e=Ju(n)|0;ev(d+44|0,1)}bw(l);o=e;u=p;return o|0}function Fq(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;D=u;u=u+16|0;B=D;C=f[c>>2]|0;A=f[d+4>>2]|0;z=f[A+768>>2]|0;m=z+1|0;y=f[C+5820>>2]|0;if((f[C+10536>>2]|0)!=(0-(f[C+10532>>2]|0)|0))Pa(34979,34917,989,35084);do if(b[A+4>>0]|0){g=c+10676|0;h=(f[C+5828>>2]|0)+-1|0;k=c+10680|0;e=f[k>>2]|0;i=f[g>>2]|0;j=e-i>>3;if(h>>>0>j>>>0){Hq(g,h-j|0);break}if(h>>>0<j>>>0?(l=i+(h<<3)|0,(e|0)!=(l|0)):0)do{x=e+-8|0;f[k>>2]=x;bw(x);e=f[k>>2]|0}while((e|0)!=(l|0))}while(0);cq(d,m);e=f[A+16>>2]|0;j=(e|0)/(y|0)|0;a:do if((z|0)>=0){p=d+140|0;q=d+136|0;r=C+10332|0;s=C+10272|0;t=d+12|0;v=d+8|0;w=d+124|0;x=a+375396|0;o=A+776|0;if(!z){if((f[p>>2]|0)<=0)Pa(35034,35054,170,35065);h=f[q>>2]|0;f[h+18600>>2]=A;f[h+18592>>2]=f[r>>2];f[h+18596>>2]=C;g=h+18604|0;f[g>>2]=c;f[h+18608>>2]=d;f[h+4>>2]=f[(f[s>>2]|0)+(e<<2)>>2];hq(0,h);e=f[t>>2]|0;if((e|0)<=0)break;Tv(h+18556|0,f[v>>2]|0,e);ct(C,1);f[w>>2]=(f[w>>2]|0)+1;i=OK(20)|0;f[i+4>>2]=0;f[i>>2]=7972;b[i+8>>0]=1;f[i+16>>2]=h;f[i+12>>2]=j;f[h+18612>>2]=i;iv(x,i);e=f[g>>2]|0;f[B>>2]=i;g=e+10668|0;h=f[g>>2]|0;if(h>>>0<(f[e+10672>>2]|0)>>>0){f[h>>2]=i;f[g>>2]=(f[g>>2]|0)+4}else iq(e+10664|0,B);break}else{g=j;n=0}while(1){if((n|0)<=0){if((e|0)%(y|0)|0)break a}else{e=g+1|0;g=e;e=X(e,y)|0}if((f[p>>2]|0)<=(n|0))break;j=f[q>>2]|0;k=j+(n*18624|0)|0;f[j+(n*18624|0)+18600>>2]=A;f[j+(n*18624|0)+18592>>2]=f[r>>2];f[j+(n*18624|0)+18596>>2]=C;l=j+(n*18624|0)+18604|0;f[l>>2]=c;f[j+(n*18624|0)+18608>>2]=d;f[j+(n*18624|0)+4>>2]=f[(f[s>>2]|0)+(e<<2)>>2];hq(0,k);m=(n|0)==0;if(m)i=0;else i=f[(f[o>>2]|0)+(n+-1<<2)>>2]|0;if((n|0)==(z|0))h=t;else h=(f[o>>2]|0)+(n<<2)|0;h=f[h>>2]|0;if((i|0)<0)break a;if(!((h|0)>(i|0)?(h|0)<=(f[t>>2]|0):0))break a;Tv(j+(n*18624|0)+18556|0,(f[v>>2]|0)+i|0,h-i|0);ct(C,1);f[w>>2]=(f[w>>2]|0)+1;a=OK(20)|0;f[a+4>>2]=0;f[a>>2]=7972;b[a+8>>0]=m&1;f[a+16>>2]=k;f[a+12>>2]=g;f[j+(n*18624|0)+18612>>2]=a;iv(x,a);j=f[l>>2]|0;f[B>>2]=a;h=j+10668|0;i=f[h>>2]|0;if(i>>>0<(f[j+10672>>2]|0)>>>0){f[i>>2]=a;f[h>>2]=(f[h>>2]|0)+4}else iq(j+10664|0,B);if((n|0)<(z|0))n=n+1|0;else break a}Pa(35034,35054,170,35065)}while(0);ht(C);k=c+10664|0;l=c+10668|0;g=f[l>>2]|0;i=f[k>>2]|0;h=i;e=g;if((g|0)!=(i|0)){j=0;do{h=f[h+(j<<2)>>2]|0;if(h){dd[f[(f[h>>2]|0)+4>>2]&511](h);e=f[l>>2]|0;i=f[k>>2]|0;g=e}j=j+1|0;h=i}while(j>>>0<g-i>>2>>>0);g=i}if((e|0)==(h|0)){u=D;return 0}f[l>>2]=e+(~((e+-4-g|0)>>>2)<<2);u=D;return 0}function Gq(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0;G=u;u=u+16|0;x=G;C=f[c>>2]|0;D=f[d+4>>2]|0;E=f[D+768>>2]|0;q=f[C+5820>>2]|0;if((f[C+10536>>2]|0)!=(0-(f[C+10532>>2]|0)|0))Pa(34979,34917,1103,35010);cq(d,E+1|0);e=f[D+16>>2]|0;a:do if((E|0)<0)F=0;else{r=C+5968|0;s=C+5972|0;t=d+140|0;v=d+136|0;w=C+10332|0;y=C+10272|0;z=d+12|0;A=d+8|0;B=d+124|0;o=a+375396|0;p=D+776|0;g=e;a=f[(f[C+10308>>2]|0)+(e<<2)>>2]|0;n=0;while(1){if((n|0)>0){e=a+1|0;a=f[r>>2]|0;if((e|0)>=(X(f[s>>2]|0,a)|0)){F=1007;break a}g=(X(f[C+10228+(((e|0)/(a|0)|0)<<2)>>2]|0,q)|0)+(f[C+10184+(((e|0)%(a|0)|0)<<2)>>2]|0)|0;a=e}if((f[t>>2]|0)<=(n|0))break;i=f[v>>2]|0;j=i+(n*18624|0)|0;f[i+(n*18624|0)+18600>>2]=D;f[i+(n*18624|0)+18592>>2]=f[w>>2];f[i+(n*18624|0)+18596>>2]=C;k=i+(n*18624|0)+18604|0;f[k>>2]=c;f[i+(n*18624|0)+18608>>2]=d;f[i+(n*18624|0)+4>>2]=f[(f[y>>2]|0)+(g<<2)>>2];hq(0,j);l=(n|0)==0;if(l)h=0;else h=f[(f[p>>2]|0)+(n+-1<<2)>>2]|0;if((n|0)==(E|0))e=z;else e=(f[p>>2]|0)+(n<<2)|0;e=f[e>>2]|0;if((h|0)<0){F=17;break a}if(!((e|0)>(h|0)?(e|0)<=(f[z>>2]|0):0)){F=17;break a}Tv(i+(n*18624|0)+18556|0,(f[A>>2]|0)+h|0,e-h|0);ct(C,1);f[B>>2]=(f[B>>2]|0)+1;m=OK(24)|0;f[m+4>>2]=0;f[m>>2]=7932;b[m+8>>0]=l&1;f[m+20>>2]=j;f[m+12>>2]=(g|0)%(q|0)|0;f[m+16>>2]=(g|0)/(q|0)|0;f[i+(n*18624|0)+18612>>2]=m;iv(o,m);e=f[k>>2]|0;f[x>>2]=m;h=e+10668|0;i=f[h>>2]|0;if(i>>>0<(f[e+10672>>2]|0)>>>0){f[i>>2]=m;f[h>>2]=(f[h>>2]|0)+4}else iq(e+10664|0,x);if((n|0)<(E|0))n=n+1|0;else{F=0;break a}}Pa(35034,35054,170,35065)}while(0);ht(C);j=c+10664|0;k=c+10668|0;e=f[k>>2]|0;h=f[j>>2]|0;g=h;a=e;if((e|0)!=(h|0)){i=0;do{g=f[g+(i<<2)>>2]|0;if(g){dd[f[(f[g>>2]|0)+4>>2]&511](g);a=f[k>>2]|0;h=f[j>>2]|0;e=a}i=i+1|0;g=h}while(i>>>0<e-h>>2>>>0);e=h}if((a|0)==(g|0)){u=G;return F|0}f[k>>2]=a+(~((a+-4-e|0)>>>2)<<2);u=G;return F|0}function Hq(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0;k=a+8|0;e=f[k>>2]|0;l=a+4|0;c=f[l>>2]|0;if(e-c>>3>>>0>=b>>>0){do{$v(c);c=(f[l>>2]|0)+8|0;f[l>>2]=c;b=b+-1|0}while((b|0)!=0);return}d=f[a>>2]|0;g=c-d>>3;c=g+b|0;if(c>>>0>536870911)$I(a);i=e-d|0;j=i>>2;c=i>>3>>>0<268435455?(j>>>0<c>>>0?c:j):536870911;do if(c)if(c>>>0>536870911){l=Ra(8)|0;VK(l,44736);f[l>>2]=17660;Va(l|0,4016,428)}else{d=OK(c<<3)|0;break}else d=0;while(0);h=d+(g<<3)|0;g=h;j=d+(c<<3)|0;i=g;c=h;do{$v(c);c=i+8|0;i=c;b=b+-1|0}while((b|0)!=0);e=f[a>>2]|0;c=f[l>>2]|0;if((c|0)==(e|0)){b=g;d=e;c=e}else{d=g;b=h;do{c=c+-8|0;aw(b+-8|0,c);b=d+-8|0;d=b}while((c|0)!=(e|0));b=d;d=f[a>>2]|0;c=f[l>>2]|0}f[a>>2]=b;f[l>>2]=i;f[k>>2]=j;b=d;if((c|0)!=(b|0))do{c=c+-8|0;bw(c)}while((c|0)!=(b|0));if(!d)return;QK(d);return}function Iq(a){a=a|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0;d=f[a+375388>>2]|0;e=(d|0)==0;if(e){c=f[a+375384>>2]|0;if(!c)c=6;else c=(f[c+8>>2]|0)+-1|0}else c=(b[d+2>>0]|0)+-1|0;do if((b[a+376116>>0]|0)!=(c|0)){if(e){c=f[a+375384>>2]|0;if(!c)c=6;else{c=f[c+8>>2]|0;g=10}}else{c=b[d+2>>0]|0;g=10}if((g|0)==10)if((c|0)>0)c=c+-1|0;else break;i=c+1|0;j=a+375896|0;while(1){h=c*100|0;e=(h|0)/(i|0)|0;h=(h+100|0)/(i|0)|0;if((h|0)>=(e|0)){g=h-e|0;d=e;while(1){l=f[j>>2]|0;k=(c|0)>(l|0);c=k?l:c;b[a+375916+(d<<1)>>0]=c;b[a+375916+(d<<1)+1>>0]=k?100:(((d-e|0)*100|0)/(g|0)|0)&255;if((d|0)<(h|0))d=d+1|0;else break}}f[a+376120+(c<<2)>>2]=h;if((c|0)>0)c=c+-1|0;else break}}while(0);k=f[a+375900>>2]|0;l=b[a+375916+(k<<1)>>0]|0;f[a+375904>>2]=l;f[a+375908>>2]=b[a+375916+(k<<1)+1>>0];f[a+375912>>2]=l;return}function Jq(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0;i=c+377212|0;if(qt(b[i>>0]|0)|0?(b[c+376209>>0]|0)!=0:0){g=c+376212|0;f[g>>2]=0;b[a+377228>>0]=1;a=d+28|0;e=a;d=0;a=f[a>>2]|0}else{g=f[(f[c+375388>>2]|0)+5032>>2]|0;h=d+28|0;a=f[h>>2]|0;e=f[c+376216>>2]|0;d=f[c+376220>>2]|0;if((a|0)<(e|0)?(e-a|0)>=((g|0)/2|0|0):0)d=d+g|0;else if((a|0)>(e|0))d=d-((a-e|0)>((g|0)/2|0|0)?g:0)|0;g=c+376212|0;f[g>>2]=d;e=h}h=f[c+376224>>2]|0;f[h+92>>2]=a+d;f[h+88>>2]=a;if(b[h+10520>>0]|0)return;if(st(b[i>>0]|0)|0)return;if(pt(b[i>>0]|0)|0)return;if(rt(b[i>>0]|0)|0)return;f[c+376216>>2]=f[e>>2];f[c+376220>>2]=f[g>>2];return}function Kq(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;C=u;u=u+32|0;A=C+16|0;z=C+4|0;x=C;f[A>>2]=0;B=A+4|0;f[B>>2]=0;f[A+8>>2]=0;y=c+376224|0;v=f[f[y>>2]>>2]|0;m=c+377212|0;if((qt(b[m>>0]|0)|0?b[c+376209>>0]|0:0)?(h=f[y>>2]|0,n=f[h+92>>2]|0,o=a+376156|0,p=a+376160|0,i=f[p>>2]|0,g=f[o>>2]|0,(i-g|0)>0):0){q=c+376156|0;r=c+376160|0;s=A+8|0;l=0;k=i;while(1){i=f[q>>2]|0;if((f[r>>2]|0)-i>>2>>>0>l>>>0)i=f[i+(l<<2)>>2]|0;else i=0;if(((f[i+96>>2]|0)!=0?(f[i+92>>2]|0)<(n|0):0)?(t=i+104|0,(f[t>>2]|0)>>>0>(f[h>>2]|0)>>>0):0){i=f[i>>2]|0;f[z>>2]=i;j=f[B>>2]|0;if(j>>>0<(f[s>>2]|0)>>>0){f[j>>2]=i;f[B>>2]=j+4;i=k}else{Mq(A,z);i=f[p>>2]|0;g=f[o>>2]|0;h=f[y>>2]|0}f[t>>2]=f[h>>2]}else i=k;l=l+1|0;if((l|0)>=(i-g>>2|0))break;else k=i}}if(!(nt(b[m>>0]|0)|0)){g=b[e+908>>0]|0;if(!(g<<24>>24)){h=0;g=0}else{l=g&255;i=0;j=0;k=0;while(1){t=(b[e+876+i>>0]|0)==0;g=(t&1)+k|0;h=((t^1)&1)+j|0;f[(t?c+376700+(k<<2)|0:c+376572+(j<<2)|0)>>2]=(d[e+812+(i<<1)>>1]|0)+(f[(f[y>>2]|0)+92>>2]|0);i=i+1|0;if((i|0)>=(l|0))break;else{j=h;k=g}}}f[c+376552>>2]=h;h=b[e+909>>0]|0;if(!(h<<24>>24))h=0;else{l=h&255;i=0;j=0;while(1){t=(b[e+892+i>>0]|0)==0;k=(t&1)+g|0;h=((t^1)&1)+j|0;f[(t?c+376700+(g<<2)|0:c+376636+(j<<2)|0)>>2]=(d[e+844+(i<<1)>>1]|0)+(f[(f[y>>2]|0)+92>>2]|0);i=i+1|0;if((i|0)>=(l|0)){g=k;break}else{j=h;g=k}}}f[c+376556>>2]=h;f[c+376560>>2]=g;l=e+140|0;m=e+144|0;if(((f[m>>2]|0)+(f[l>>2]|0)|0)>0){n=e+28|0;o=c+375388|0;k=0;g=0;h=0;do{i=f[c+376232+(k<<2)>>2]|0;j=e+244+k|0;if(b[j>>0]|0)i=(f[(f[y>>2]|0)+92>>2]|0)+i-(f[n>>2]|0)-(X(f[(f[o>>2]|0)+5032>>2]|0,f[c+376360+(k<<2)>>2]|0)|0)|0;if(!(f[c+376296+(k<<2)>>2]|0)){f[c+376828+(h<<2)>>2]=i;f[c+376488+(h<<2)>>2]=b[j>>0];h=h+1|0}else{f[c+376764+(g<<2)>>2]=i;f[c+376424+(g<<2)>>2]=b[j>>0];g=g+1|0}k=k+1|0}while((k|0)<((f[m>>2]|0)+(f[l>>2]|0)|0))}else{g=0;h=0}}else{f[c+376552>>2]=0;f[c+376556>>2]=0;f[c+376560>>2]=0;g=0;h=0}o=c+376564|0;f[o>>2]=g;n=c+376568|0;f[n>>2]=h;p=a+376156|0;q=a+376160|0;g=(f[q>>2]|0)-(f[p>>2]|0)|0;h=g>>2;f[z>>2]=0;i=z+4|0;f[i>>2]=0;j=z+8|0;f[j>>2]=0;if(h|0){if((g|0)<0)$I(z);t=((h+-1|0)>>>5)+1|0;s=OK(t<<2)|0;f[z>>2]=s;f[j>>2]=t;f[i>>2]=h;t=h>>>5;IM(s|0,0,t<<2|0)|0;g=h-(t<<5)|0;h=s+(t<<2)|0;if(g|0)f[h>>2]=f[h>>2]&~(-1>>>(32-g|0))}g=f[o>>2]|0;if((g|0)>0){k=c+376148|0;l=c+376156|0;m=c+375388|0;j=0;do{i=c+376764+(j<<2)|0;g=f[i>>2]|0;if(!(f[c+376424+(j<<2)>>2]|0))g=Cs(k,g,v,1)|0;else g=Bs(k,g,v,1)|0;h=c+377084+(j<<2)|0;f[h>>2]=g;if((g|0)<=-1){g=Nq(a,c,f[m>>2]|0,f[i>>2]|0,1)|0;f[h>>2]=g}t=(f[z>>2]|0)+(g>>>5<<2)|0;f[t>>2]=f[t>>2]|1<<(g&31);if(b[(f[(f[l>>2]|0)+(g<<2)>>2]|0)+10516>>0]|0)b[(f[y>>2]|0)+10516>>0]=4;j=j+1|0;g=f[o>>2]|0}while((j|0)<(g|0))}h=f[n>>2]|0;if((h|0)>0){l=c+376148|0;m=c+375388|0;k=0;do{i=c+376828+(k<<2)|0;g=f[i>>2]|0;if(!(f[c+376488+(k<<2)>>2]|0))g=Cs(l,g,v,1)|0;else g=Bs(l,g,v,1)|0;h=c+377148+(k<<2)|0;f[h>>2]=g;if((g|0)<=-1){g=Nq(a,c,f[m>>2]|0,f[i>>2]|0,1)|0;f[h>>2]=g}j=(f[z>>2]|0)+(g>>>5<<2)|0;f[j>>2]=f[j>>2]|1<<(g&31);k=k+1|0;j=f[n>>2]|0}while((k|0)<(j|0));g=f[o>>2]|0}else j=h;if((g|0)>0){i=f[c+376156>>2]|0;h=0;do{f[(f[i+(f[c+377084+(h<<2)>>2]<<2)>>2]|0)+96>>2]=2;h=h+1|0}while((h|0)<(g|0))}if((j|0)>0){h=f[c+376156>>2]|0;g=0;do{f[(f[h+(f[c+377148+(g<<2)>>2]<<2)>>2]|0)+96>>2]=2;g=g+1|0}while((g|0)<(j|0))}k=c+376552|0;if((f[k>>2]|0)>0){l=c+376148|0;m=c+376156|0;n=c+375388|0;j=0;do{h=c+376572+(j<<2)|0;g=Bs(l,f[h>>2]|0,v,0)|0;i=c+376892+(j<<2)|0;f[i>>2]=g;if((g|0)<=-1){g=Nq(a,c,f[n>>2]|0,f[h>>2]|0,0)|0;f[i>>2]=g}t=(f[z>>2]|0)+(g>>>5<<2)|0;f[t>>2]=f[t>>2]|1<<(g&31);if(b[(f[(f[m>>2]|0)+(g<<2)>>2]|0)+10516>>0]|0)b[(f[y>>2]|0)+10516>>0]=4;j=j+1|0}while((j|0)<(f[k>>2]|0))}k=c+376556|0;if((f[k>>2]|0)>0){l=c+376148|0;m=c+376156|0;n=c+375388|0;j=0;do{h=c+376636+(j<<2)|0;g=Bs(l,f[h>>2]|0,v,0)|0;i=c+376956+(j<<2)|0;f[i>>2]=g;if((g|0)<=-1){g=Nq(a,c,f[n>>2]|0,f[h>>2]|0,0)|0;f[i>>2]=g}t=(f[z>>2]|0)+(g>>>5<<2)|0;f[t>>2]=f[t>>2]|1<<(g&31);if(b[(f[(f[m>>2]|0)+(g<<2)>>2]|0)+10516>>0]|0)b[(f[y>>2]|0)+10516>>0]=4;j=j+1|0}while((j|0)<(f[k>>2]|0))}h=c+376560|0;if((f[h>>2]|0)>0){i=c+376148|0;g=0;do{j=Bs(i,f[c+376700+(g<<2)>>2]|0,v,0)|0;f[c+377020+(g<<2)>>2]=j;if((j|0)>-1){a=(f[z>>2]|0)+(j>>>5<<2)|0;f[a>>2]=f[a>>2]|1<<(j&31)}g=g+1|0}while((g|0)<(f[h>>2]|0))}h=f[q>>2]|0;g=f[p>>2]|0;if((h-g|0)>0){o=c+376156|0;m=c+376160|0;n=A+8|0;l=0;k=h;while(1){if(!(f[(f[z>>2]|0)+(l>>>5<<2)>>2]&1<<(l&31))){h=f[o>>2]|0;if((f[m>>2]|0)-h>>2>>>0>l>>>0)i=f[h+(l<<2)>>2]|0;else i=0;h=f[y>>2]|0;if(((i|0)!=(h|0)?(w=i+104|0,(f[w>>2]|0)>>>0>(f[h>>2]|0)>>>0):0)?(f[i+96>>2]|0)!=0:0){i=f[i>>2]|0;f[x>>2]=i;j=f[B>>2]|0;if(j>>>0<(f[n>>2]|0)>>>0){f[j>>2]=i;f[B>>2]=j+4;i=k}else{Mq(A,x);i=f[q>>2]|0;g=f[p>>2]|0;h=f[y>>2]|0}f[w>>2]=f[h>>2];h=i}else h=k}else h=k;l=l+1|0;if((l|0)>=(h-g>>2|0))break;else k=h}}g=e+1344|0;if((g|0)!=(A|0))sq(g,f[A>>2]|0,f[B>>2]|0);g=f[z>>2]|0;if(g|0)QK(g);g=f[A>>2]|0;if(!g){u=C;return}h=f[B>>2]|0;if((h|0)!=(g|0))f[B>>2]=h+(~((h+-4-g|0)>>>2)<<2);QK(g);u=C;return}function Lq(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0;z=u;u=u+480|0;l=z+192|0;x=z;y=z+384|0;n=f[d+912>>2]|0;m=d+328|0;j=f[m>>2]|0;i=(j|0)>(n|0)?j:n;a=y;e=a+96|0;do{b[a>>0]=0;a=a+1|0}while((a|0)<(e|0));o=c+376552|0;p=c+376556|0;q=c+376564|0;r=c+376892|0;s=c+376956|0;t=c+377084|0;a=0;while(1){if((a|0)>=(i|0))break;g=f[o>>2]|0;if((g|0)>0){k=0-g|0;e=a-i|0;GM(l+(a<<2)|0,r|0,X(e>>>0<k>>>0?k:e,-4)|0)|0;e=0;do{a=a+1|0;e=e+1|0}while((a|0)<(i|0)&(e|0)<(g|0))}g=f[p>>2]|0;if((a|0)<(i|0)&(g|0)>0){k=0-((g|0)>1?g:1)|0;e=a-i|0;GM(l+(a<<2)|0,s|0,X(e>>>0<k>>>0?k:e,-4)|0)|0;e=0;do{a=a+1|0;e=e+1|0}while((a|0)<(i|0)&(e|0)<(g|0))}g=f[q>>2]|0;if((a|0)<(i|0)&(g|0)>0){k=0-((g|0)>1?g:1)|0;e=a-i|0;e=e>>>0<k>>>0?k:e;IM(y+a|0,1,0-e|0)|0;GM(l+(a<<2)|0,t|0,X(e,-4)|0)|0;e=0;do{a=a+1|0;e=e+1|0}while((a|0)<(i|0)&(e|0)<(g|0))}if(!a){w=13;break}}if((w|0)==13){e=c+84|0;a=f[e>>2]|0;if((a|0)==20){e=1001;a=19}else{f[e>>2]=a+1;e=1016}f[c+4+(a<<2)>>2]=e;c=0;u=z;return c|0}if((j|0)>=17)Pa(35161,34917,1781,35194);a:do if((j|0)>0){i=d+336|0;j=c+376156|0;k=c+376160|0;g=0;while(1){if(!(b[i>>0]|0))a=g;else a=h[d+338+g>>0]|0;e=d+916+(g<<2)|0;f[e>>2]=f[l+(a<<2)>>2];b[d+1300+g>>0]=b[y+a>>0]|0;a=f[e>>2]|0;e=f[j>>2]|0;if((f[k>>2]|0)-e>>2>>>0<=a>>>0){a=0;w=54;break}a=f[e+(a<<2)>>2]|0;if(!a){a=0;w=54;break}f[d+1044+(g<<2)>>2]=f[a+92>>2];f[d+1172+(g<<2)>>2]=f[a+96>>2];g=g+1|0;a=f[m>>2]|0;if((g|0)>=(a|0)){v=a;break a}}if((w|0)==54){u=z;return a|0}}else v=j;while(0);if(f[d+20>>2]|0){c=1;u=z;return c|0}l=d+332|0;j=f[l>>2]|0;i=(j|0)>(n|0)?j:n;a=0;while(1){if((a|0)>=(i|0))break;g=f[p>>2]|0;if((g|0)>0){n=0-g|0;e=a-i|0;GM(x+(a<<2)|0,s|0,X(e>>>0<n>>>0?n:e,-4)|0)|0;e=0;do{a=a+1|0;e=e+1|0}while((a|0)<(i|0)&(e|0)<(g|0))}g=f[o>>2]|0;if((a|0)<(i|0)&(g|0)>0){n=0-((g|0)>1?g:1)|0;e=a-i|0;GM(x+(a<<2)|0,r|0,X(e>>>0<n>>>0?n:e,-4)|0)|0;e=0;do{a=a+1|0;e=e+1|0}while((a|0)<(i|0)&(e|0)<(g|0))}g=f[q>>2]|0;if((a|0)<(i|0)&(g|0)>0){n=0-((g|0)>1?g:1)|0;e=a-i|0;e=e>>>0<n>>>0?n:e;IM(y+48+a|0,1,0-e|0)|0;GM(x+(a<<2)|0,t|0,X(e,-4)|0)|0;e=0;do{a=a+1|0;e=e+1|0}while((a|0)<(i|0)&(e|0)<(g|0))}if(!a){w=38;break}}if((w|0)==38){e=c+84|0;a=f[e>>2]|0;if((a|0)==20){e=1001;a=19}else{f[e>>2]=a+1;e=1016}f[c+4+(a<<2)>>2]=e;c=0;u=z;return c|0}if((v|0)>16){e=c+84|0;a=f[e>>2]|0;if((a|0)==20){e=1001;a=19}else{f[e>>2]=a+1;e=1012}f[c+4+(a<<2)>>2]=e;c=0;u=z;return c|0}if((j|0)>=17)Pa(35228,34917,1834,35194);if((j|0)<=0){c=1;u=z;return c|0}j=d+337|0;k=c+376156|0;i=c+376160|0;g=0;while(1){if(!(b[j>>0]|0))a=g;else a=h[d+354+g>>0]|0;e=d+980+(g<<2)|0;f[e>>2]=f[x+(a<<2)>>2];b[d+1316+g>>0]=b[y+48+a>>0]|0;a=f[e>>2]|0;e=f[k>>2]|0;if((f[i>>2]|0)-e>>2>>>0<=a>>>0){a=0;w=54;break}a=f[e+(a<<2)>>2]|0;if(!a){a=0;w=54;break}f[d+1108+(g<<2)>>2]=f[a+92>>2];f[d+1236+(g<<2)>>2]=f[a+96>>2];g=g+1|0;if((g|0)>=(f[l>>2]|0)){a=1;w=54;break}}if((w|0)==54){u=z;return a|0}return 0}function Mq(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0;i=a+4|0;j=f[a>>2]|0;k=(f[i>>2]|0)-j|0;h=k>>2;c=h+1|0;if(c>>>0>1073741823)$I(a);l=a+8|0;g=(f[l>>2]|0)-j|0;d=g>>1;d=g>>2>>>0<536870911?(d>>>0<c>>>0?c:d):1073741823;do if(d)if(d>>>0>1073741823){l=Ra(8)|0;VK(l,44736);f[l>>2]=17660;Va(l|0,4016,428)}else{g=OK(d<<2)|0;break}else g=0;while(0);e=g+(h<<2)|0;f[e>>2]=f[b>>2];c=e+(0-h<<2)|0;if((k|0)>0)GM(c|0,j|0,k|0)|0;f[a>>2]=c;f[i>>2]=e+4;f[l>>2]=g+(d<<2);if(!j)return;QK(j);return}function Nq(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var i=0,j=0,k=0,l=0,m=0;i=c+376148|0;if(!(As(i,1)|0))Pa(35261,34917,1433,35297);k=Ls(i,f[c+375388>>2]|0,a,0,0,0,0)|0;if((k|0)<=-1)Pa(35336,34917,1436,35297);a=f[c+376156>>2]|0;if((f[c+376160>>2]|0)-a>>2>>>0>k>>>0)a=f[a+(k<<2)>>2]|0;else a=0;c=1<<(f[d+5004>>2]|0)+-1;$s(a,1<<(f[d+4996>>2]|0)+-1,c,c);c=a+10364|0;if((f[c>>2]|0)>0){j=a+10360|0;i=0;do{l=(f[j>>2]|0)+(i*3|0)|0;m=(h[l>>0]|h[l+1>>0]<<8)&-769;b[l>>0]=m;b[l+1>>0]=m>>8;i=i+1|0}while((i|0)<(f[c>>2]|0))}f[a+92>>2]=e;f[a+88>>2]=(f[d+5032>>2]|0)+-1&e;b[a+100>>0]=0;f[a+96>>2]=g?2:1;b[a+10516>>0]=1;return k|0}function Oq(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,i=0,j=0,k=0,l=0;l=u;u=u+112|0;j=l+24|0;i=l;g=l+104|0;Nv(i,f[c+20>>2]|0,f[c+24>>2]|0);b[g>>0]=0;k=g+1|0;b[k>>0]=0;d=g+2|0;b[d>>0]=0;mt(g,i);e=b[g>>0]|0;b[a+377212>>0]=e;b[a+377213>>0]=(e+-19&255)<2&1;b[a+377214>>0]=(e&-8)<<24>>24==16&1;if(b[k>>0]|0){Ct(a+548|0,c);c=0;u=l;return c|0}if((h[d>>0]|0)>(f[a+375912>>2]|0)){Ct(a+548|0,c);c=0;u=l;return c|0}if((e&255)<32){c=vq(a,i,c,g)|0;u=l;return c|0}switch(e<<24>>24){case 32:{k=jq(a,i)|0;Ct(a+548|0,c);c=k;u=l;return c|0}case 33:{k=pq(a,i)|0;Ct(a+548|0,c);c=k;u=l;return c|0}case 34:{k=rq(a,i)|0;Ct(a+548|0,c);c=k;u=l;return c|0}case 40:case 39:{e=e<<24>>24==40;k=eu(i,j,e,f[a+375388>>2]|0)|0;do if(!k){d=f[a+377220>>2]|0;if(!((f[a+377216>>2]|0)==(d|0)|e^1)){d=f[d+-4>>2]|0;i=d+10648|0;e=f[i>>2]|0;if((e|0)==(f[d+10652>>2]|0)){tq(d+10644|0,j);break}else{d=j;g=e+80|0;do{f[e>>2]=f[d>>2];e=e+4|0;d=d+4|0}while((e|0)<(g|0));f[i>>2]=(f[i>>2]|0)+80;break}}}else{e=a+84|0;d=f[e>>2]|0;if((d|0)==20){e=1001;d=19}else{f[e>>2]=d+1;e=k}f[a+4+(d<<2)>>2]=e}while(0);Ct(a+548|0,c);c=k;u=l;return c|0}case 36:{b[a+376211>>0]=1;Ct(a+548|0,c);c=0;u=l;return c|0}default:{Ct(a+548|0,c);c=0;u=l;return c|0}}return 0}function Pq(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0;l=u;u=u+16|0;j=l;e=a+548|0;g=a+580|0;h=(f[g>>2]|0)==0;i=b[e>>0]|0;do if(h){if(i<<24>>24==0?(b[a+549>>0]|0)==0:0){k=8;break}if((f[a+377216>>2]|0)==(f[a+377220>>2]|0)){Ks(a+376148|0)|0;if(!c){k=0;u=l;return k|0}f[c>>2]=f[a+376200>>2];k=0;u=l;return k|0}else k=7}else k=7;while(0);if((k|0)==7?i<<24>>24==0:0)k=8;if((k|0)==8?!((b[a+549>>0]|0)!=0|h^1):0){if(!c){k=13;u=l;return k|0}f[c>>2]=1;k=13;u=l;return k|0}if(!(As(a+376148|0,0)|0)){if(!c){k=9;u=l;return k|0}f[c>>2]=1;k=9;u=l;return k|0}b[j>>0]=0;do if(f[g>>2]|0){e=Bt(e)|0;if(!e)Pa(35343,34917,1314,35347);else{d=Oq(a,e)|0;b[j>>0]=1;k=23;break}}else{if(b[a+549>>0]|0?(f[a+377216>>2]|0)==(f[a+377220>>2]|0):0){if(!c){d=13;break}f[c>>2]=1;d=13;break}d=Bq(a,j)|0;k=23}while(0);if((k|0)==23)if(c)f[c>>2]=(d|0)==0&(b[j>>0]&1)!=0&1;k=d;u=l;return k|0}function Qq(a){a=a|0;f[a>>2]=1;f[a+4>>2]=9;f[a+8>>2]=1;f[a+12>>2]=1;f[a+16>>2]=1;f[a+20>>2]=2;f[a+24>>2]=1;f[a+28>>2]=1;f[a+32>>2]=2;f[a+36>>2]=2;f[a+40>>2]=2;f[a+44>>2]=2;f[a+48>>2]=3;f[a+52>>2]=4;f[a+56>>2]=5;f[a+60>>2]=6;f[a+64>>2]=7;f[a+68>>2]=8;f[a+72>>2]=9;f[a+76>>2]=10;f[a+80>>2]=11;f[a+84>>2]=12;f[a+88>>2]=13;f[a+92>>2]=14;f[a+96>>2]=15;f[a+100>>2]=16;f[a+104>>2]=17;f[a+108>>2]=18;f[a+112>>2]=3;f[a+116>>2]=4;f[a+120>>2]=4;f[a+124>>2]=4;f[a+128>>2]=2;f[a+132>>2]=3;f[a+136>>2]=4;f[a+140>>2]=5;f[a+144>>2]=6;f[a+148>>2]=7;f[a+152>>2]=8;f[a+156>>2]=9;f[a+160>>2]=10;f[a+164>>2]=11;f[a+168>>2]=12;f[a+172>>2]=13;f[a+176>>2]=14;f[a+180>>2]=15;f[a+184>>2]=16;f[a+188>>2]=17;f[a+204>>2]=81;f[a+212>>2]=11;f[a+208>>2]=12;f[a+192>>2]=82;f[a+200>>2]=83;f[a+196>>2]=84;f[a+216>>2]=85;f[a+220>>2]=86;f[a+224>>2]=87;f[a+228>>2]=88;f[a+232>>2]=89;f[a+236>>2]=13;f[a+240>>2]=14;f[a+244>>2]=15;f[a+248>>2]=16;f[a+252>>2]=17;f[a+256>>2]=18;f[a+260>>2]=47;f[a+284>>2]=44;f[a+288>>2]=45;f[a+296>>2]=46;f[a+292>>2]=47;f[a+300>>2]=48;f[a+264>>2]=19;f[a+268>>2]=20;f[a+272>>2]=21;f[a+276>>2]=22;f[a+280>>2]=23;f[a+304>>2]=90;f[a+308>>2]=91;f[a+312>>2]=92;f[a+316>>2]=93;f[a+320>>2]=94;f[a+324>>2]=95;f[a+328>>2]=96;f[a+332>>2]=97;f[a+336>>2]=98;return}function Rq(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0;if((e|0)<=0)return;j=1<<g;k=j+255|0;g=0;do{l=X(g,c)|0;m=X(g,e)|0;i=0;do{n=a+(i+l)|0;o=(h[n>>0]|0)+(f[d+(i+m<<2)>>2]|0)|0;b[n>>0]=(o|0)<0?0:((o|0)<(j|0)?o:k)&255;i=i+1|0}while((i|0)!=(e|0));g=g+1|0}while((g|0)!=(e|0));return}function Sq(a,b,c,e,g){a=a|0;b=b|0;c=c|0;e=e|0;g=g|0;var h=0,i=0,k=0,l=0,m=0,n=0,o=0;if((e|0)<=0)return;i=1<<g;k=i+65535|0;g=0;do{l=X(g,b)|0;m=X(g,e)|0;h=0;do{n=a+(h+l<<1)|0;o=(j[n>>1]|0)+(f[c+(h+m<<2)>>2]|0)|0;d[n>>1]=(o|0)<0?0:((o|0)<(i|0)?o:k)&65535;h=h+1|0}while((h|0)!=(e|0));g=g+1|0}while((g|0)!=(e|0));return}function Tq(a,b,c){a=a|0;b=b|0;c=c|0;Pa(44673,35354,51,35370)}function Uq(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;Pa(44673,35354,68,35396)}function Vq(a,b,c,e,g){a=a|0;b=b|0;c=c|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0;j=1<<g+-1;if((c|0)>0)i=0;else return;do{k=X(i,c)|0;h=0;do{l=h+k|0;f[a+(l<<2)>>2]=(d[b+(l<<1)>>1]<<e)+j>>g;h=h+1|0}while((h|0)!=(c|0));i=i+1|0}while((i|0)!=(c|0));return}function Wq(a,c,e,f){a=a|0;c=c|0;e=e|0;f=f|0;var g=0,i=0,j=0,k=0,l=0,m=0,n=0;k=e+5|0;l=1<<e;if((e|0)==31)return;else j=0;do{g=0;i=0;do{i=((d[c+((g<<e)+j<<1)>>1]<<k)+2048>>12)+i|0;m=a+((X(g,f)|0)+j)|0;n=i+(h[m>>0]|0)|0;b[m>>0]=(n|0)<0?0:((n|0)<255?n:255)&255;g=g+1|0}while((g|0)<(l|0));j=j+1|0}while((j|0)<(l|0));return}function Xq(a,c,e,f){a=a|0;c=c|0;e=e|0;f=f|0;var g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;k=e+5|0;l=1<<e;if((e|0)==31)return;else j=0;do{m=j<<e;n=X(j,f)|0;g=0;i=0;do{i=((d[c+(g+m<<1)>>1]<<k)+2048>>12)+i|0;o=a+(g+n)|0;p=i+(h[o>>0]|0)|0;b[o>>0]=(p|0)<0?0:((p|0)<255?p:255)&255;g=g+1|0}while((g|0)<(l|0));j=j+1|0}while((j|0)<(l|0));return}function Yq(a,b,c){a=a|0;b=b|0;c=c|0;var e=0,g=0,h=0,i=0;if((c|0)>0)g=0;else return;do{e=0;h=0;do{i=(X(h,c)|0)+g|0;e=(d[b+(i<<1)>>1]|0)+e|0;f[a+(i<<2)>>2]=e;h=h+1|0}while((h|0)!=(c|0));g=g+1|0}while((g|0)!=(c|0));return}function Zq(a,b,c){a=a|0;b=b|0;c=c|0;var e=0,g=0,h=0,i=0,j=0;if((c|0)>0)g=0;else return;do{i=X(g,c)|0;e=0;h=0;do{j=h+i|0;e=(d[b+(j<<1)>>1]|0)+e|0;f[a+(j<<2)>>2]=e;h=h+1|0}while((h|0)!=(c|0));g=g+1|0}while((g|0)!=(c|0));return}function _q(a,b,c,e,g){a=a|0;b=b|0;c=c|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0;k=1<<g+-1;if((c|0)>0)j=0;else return;do{h=0;i=0;do{l=(X(h,c)|0)+j|0;i=((d[b+(l<<1)>>1]<<e)+k>>g)+i|0;f[a+(l<<2)>>2]=i;h=h+1|0}while((h|0)!=(c|0));j=j+1|0}while((j|0)!=(c|0));return}function $q(a,b,c,e,g){a=a|0;b=b|0;c=c|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0;k=1<<g+-1;if((c|0)>0)j=0;else return;do{l=X(j,c)|0;h=0;i=0;do{m=h+l|0;i=((d[b+(m<<1)>>1]<<e)+k>>g)+i|0;f[a+(m<<2)>>2]=i;h=h+1|0}while((h|0)!=(c|0));j=j+1|0}while((j|0)!=(c|0));return}function ar(a,b,c){a=a|0;b=b|0;c=c|0;var e=0,g=0,h=0,i=0;if((c|0)>0)g=0;else return;do{h=X(g,c)|0;e=0;do{i=e+h|0;f[a+(i<<2)>>2]=d[b+(i<<1)>>1];e=e+1|0}while((e|0)!=(c|0));g=g+1|0}while((g|0)!=(c|0));return}function br(a,b){a=a|0;b=b|0;var c=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;f=(b|0)/2|0;if((b|0)<=1)return;g=b+-1|0;c=0;do{h=X(c,b)|0;i=g+(X(g-c|0,b)|0)|0;e=0;do{l=a+(e+h<<1)|0;j=a+(i-e<<1)|0;k=d[l>>1]|0;d[l>>1]=d[j>>1]|0;d[j>>1]=k;e=e+1|0}while((e|0)!=(b|0));c=c+1|0}while((c|0)<(f|0));return}function cr(a,c,e){a=a|0;c=c|0;e=e|0;var f=0,g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;i=u;u=u+32|0;g=i;f=0;do{j=d[c+(f<<1)>>1]|0;k=d[c+(f+4<<1)>>1]|0;l=d[c+(f+8<<1)>>1]|0;m=d[c+(f+12<<1)>>1]|0;n=(m*55|0)+((l*84|0)+((k*74|0)+(j*29|0)))+64>>7;d[g+(f<<1)>>1]=(n|0)<-32768?-32768:((n|0)<32767?n:32767)&65535;n=(X(m,-84)|0)+((X(l,-29)|0)+((k*74|0)+(j*55|0)))+64>>7;d[g+8+(f<<1)>>1]=(n|0)<-32768?-32768:((n|0)<32767?n:32767)&65535;n=(m*74|0)+((X(l,-74)|0)+(j*74|0))+64>>7;d[g+16+(f<<1)>>1]=(n|0)<-32768?-32768:((n|0)<32767?n:32767)&65535;j=(X(m,-29)|0)+((l*55|0)+((X(k,-74)|0)+(j*84|0)))+64>>7;d[g+24+(f<<1)>>1]=(j|0)<-32768?-32768:((j|0)<32767?j:32767)&65535;f=f+1|0}while((f|0)!=4);f=0;do{n=X(f,e)|0;m=d[g+(f<<3)>>1]|0;l=d[g+(f<<3)+2>>1]|0;k=d[g+(f<<3)+4>>1]|0;j=d[g+(f<<3)+6>>1]|0;o=(j*55|0)+((k*84|0)+((l*74|0)+(m*29|0)))+2048>>12;c=a+n|0;o=(h[c>>0]|0)+((o|0)<-32768?-32768:(o|0)<32767?o:32767)|0;b[c>>0]=(o|0)<0?0:((o|0)<255?o:255)&255;c=(X(j,-84)|0)+((X(k,-29)|0)+((l*74|0)+(m*55|0)))+2048>>12;o=a+(n+1)|0;c=(h[o>>0]|0)+((c|0)<-32768?-32768:(c|0)<32767?c:32767)|0;b[o>>0]=(c|0)<0?0:((c|0)<255?c:255)&255;o=(j*74|0)+((X(k,-74)|0)+(m*74|0))+2048>>12;c=a+(n+2)|0;o=(h[c>>0]|0)+((o|0)<-32768?-32768:(o|0)<32767?o:32767)|0;b[c>>0]=(o|0)<0?0:((o|0)<255?o:255)&255;m=(X(j,-29)|0)+((k*55|0)+((X(l,-74)|0)+(m*84|0)))+2048>>12;n=a+(n+3)|0;m=(h[n>>0]|0)+((m|0)<-32768?-32768:(m|0)<32767?m:32767)|0;b[n>>0]=(m|0)<0?0:((m|0)<255?m:255)&255;f=f+1|0}while((f|0)!=4);u=i;return}function dr(a,b,c,e){a=a|0;b=b|0;c=c|0;e=e|0;var f=0,g=0,h=0,i=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;l=u;u=u+32|0;i=l;k=20-e|0;g=k+-1|0;f=0;do{h=d[b+(f<<1)>>1]|0;m=d[b+(f+4<<1)>>1]|0;n=d[b+(f+8<<1)>>1]|0;o=d[b+(f+12<<1)>>1]|0;p=(o*55|0)+((n*84|0)+((m*74|0)+(h*29|0)))+64>>7;d[i+(f<<1)>>1]=(p|0)<-32768?-32768:((p|0)<32767?p:32767)&65535;p=(X(o,-84)|0)+((X(n,-29)|0)+((m*74|0)+(h*55|0)))+64>>7;d[i+8+(f<<1)>>1]=(p|0)<-32768?-32768:((p|0)<32767?p:32767)&65535;p=(o*74|0)+((X(n,-74)|0)+(h*74|0))+64>>7;d[i+16+(f<<1)>>1]=(p|0)<-32768?-32768:((p|0)<32767?p:32767)&65535;h=(X(o,-29)|0)+((n*55|0)+((X(m,-74)|0)+(h*84|0)))+64>>7;d[i+24+(f<<1)>>1]=(h|0)<-32768?-32768:((h|0)<32767?h:32767)&65535;f=f+1|0}while((f|0)!=4);h=1<<g;b=1<<e;g=b+65535|0;f=0;do{p=X(f,c)|0;o=d[i+(f<<3)>>1]|0;n=d[i+(f<<3)+2>>1]|0;m=d[i+(f<<3)+4>>1]|0;e=d[i+(f<<3)+6>>1]|0;r=(e*55|0)+((m*84|0)+((n*74|0)+(o*29|0)))+h>>k;q=a+(p<<1)|0;r=(j[q>>1]|0)+((r|0)<-32768?-32768:(r|0)<32767?r:32767)|0;d[q>>1]=(r|0)<0?0:((r|0)<(b|0)?r:g)&65535;q=(X(e,-84)|0)+((X(m,-29)|0)+((n*74|0)+(o*55|0)))+h>>k;r=a+(p+1<<1)|0;q=(j[r>>1]|0)+((q|0)<-32768?-32768:(q|0)<32767?q:32767)|0;d[r>>1]=(q|0)<0?0:((q|0)<(b|0)?q:g)&65535;r=(e*74|0)+((X(m,-74)|0)+(o*74|0))+h>>k;q=a+(p+2<<1)|0;r=(j[q>>1]|0)+((r|0)<-32768?-32768:(r|0)<32767?r:32767)|0;d[q>>1]=(r|0)<0?0:((r|0)<(b|0)?r:g)&65535;o=(X(e,-29)|0)+((m*55|0)+((X(n,-74)|0)+(o*84|0)))+h>>k;p=a+(p+3<<1)|0;o=(j[p>>1]|0)+((o|0)<-32768?-32768:(o|0)<32767?o:32767)|0;d[p>>1]=(o|0)<0?0:((o|0)<(b|0)?o:g)&65535;f=f+1|0}while((f|0)!=4);u=l;return}function er(a,b,c){a=a|0;b=b|0;c=c|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;i=u;u=u+32|0;h=i;f=c<<1;g=c*3|0;e=0;do{j=d[b+(e<<1)>>1]|0;k=d[b+(e+c<<1)>>1]|0;l=d[b+(f+e<<1)>>1]|0;m=d[b+(g+e<<1)>>1]|0;o=(m*84|0)+((l*74|0)+((k*55|0)+(j*29|0)))+1>>1;d[h+(e<<1)>>1]=(o|0)<-32768?-32768:((o|0)<32767?o:32767)&65535;o=(X(m,-74)|0)+((k+j|0)*74|0)|0;n=o>>1;d[h+(e+4<<1)>>1]=(o|0)<-65536?-32768:((n|0)<32767?n:32767)&65535;n=(m*55|0)+((X(l,-74)|0)+((X(k,-29)|0)+(j*84|0)))+1>>1;d[h+(e+8<<1)>>1]=(n|0)<-32768?-32768:((n|0)<32767?n:32767)&65535;j=(X(m,-29)|0)+((l*74|0)+((X(k,-84)|0)+(j*55|0)))+1>>1;d[h+(e+12<<1)>>1]=(j|0)<-32768?-32768:((j|0)<32767?j:32767)&65535;e=e+1|0}while((e|0)!=4);e=0;do{o=e<<2;n=d[h+(o<<1)>>1]|0;m=d[h+((o|1)<<1)>>1]|0;l=d[h+((o|2)<<1)>>1]|0;k=d[h+((o|3)<<1)>>1]|0;d[a+(o<<1)>>1]=((k*84|0)+((l*74|0)+((m*55|0)+(n*29|0)))+128|0)>>>8;j=((X(k,-74)|0)+((m+n|0)*74|0)+128|0)>>>8&65535;d[a+((o|1)<<1)>>1]=j;j=((k*55|0)+((X(l,-74)|0)+((X(m,-29)|0)+(n*84|0)))+128|0)>>>8&65535;d[a+((o|2)<<1)>>1]=j;n=((X(k,-29)|0)+((l*74|0)+((X(m,-84)|0)+(n*55|0)))+128|0)>>>8&65535;d[a+((o|3)<<1)>>1]=n;e=e+1|0}while((e|0)!=4);u=i;return}function fr(a,b,c,e){a=a|0;b=b|0;c=c|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;l=u;u=u+32|0;k=l;j=c+-1|0;g=1<<e;h=g+65535|0;i=0-g|0;e=0;do{m=d[b+(e<<1)>>1]|0;n=d[b+(e+4<<1)>>1]|0;o=d[b+(e+8<<1)>>1]|0;p=d[b+(e+12<<1)>>1]|0;q=(p*55|0)+((o*84|0)+((n*74|0)+(m*29|0)))+64>>7;d[k+(e<<1)>>1]=(q|0)<(i|0)?i:(q|0)<(g|0)?q:h;q=(X(p,-84)|0)+((X(o,-29)|0)+((n*74|0)+(m*55|0)))+64>>7;d[k+8+(e<<1)>>1]=(q|0)<(i|0)?i:(q|0)<(g|0)?q:h;q=(p*74|0)+((X(o,-74)|0)+(m*74|0))+64>>7;d[k+16+(e<<1)>>1]=(q|0)<(i|0)?i:(q|0)<(g|0)?q:h;m=(X(p,-29)|0)+((o*55|0)+((X(n,-74)|0)+(m*84|0)))+64>>7;d[k+24+(e<<1)>>1]=(m|0)<(i|0)?i:(m|0)<(g|0)?m:h;e=e+1|0}while((e|0)!=4);g=1<<j;e=0;do{q=e<<2;p=d[k+(e<<3)>>1]|0;o=d[k+(e<<3)+2>>1]|0;j=o*74|0;n=d[k+(e<<3)+4>>1]|0;m=d[k+(e<<3)+6>>1]|0;f[a+(q<<2)>>2]=(m*55|0)+((n*84|0)+(j+(p*29|0)))+g>>c;j=(X(m,-84)|0)+((X(n,-29)|0)+(j+(p*55|0)))+g>>c;f[a+((q|1)<<2)>>2]=j;j=(m*74|0)+((X(n,-74)|0)+(p*74|0))+g>>c;f[a+((q|2)<<2)>>2]=j;p=(X(m,-29)|0)+((n*55|0)+((X(o,-74)|0)+(p*84|0)))+g>>c;f[a+((q|3)<<2)>>2]=p;e=e+1|0}while((e|0)!=4);u=l;return}function gr(a,c,e,g,h){a=a|0;c=c|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0;v=u;u=u+2048|0;t=v;if((c|0)>1){j=c;i=0;while(1){i=i+1|0;if(j>>>0>3)j=j>>>1;else break}}else i=0;r=5-i|0;s=1<<g+-1;n=1<<h;o=n+65535|0;p=0-n|0;q=(c|0)>0;if(!q){u=v;return}m=((h|0)==31?p:(h|0)!=31?0:o)&65535;l=0;do{k=c;while(1){i=k+-1|0;if((k|0)<=0){i=0;j=8;break}h=e+((X(i,c)|0)+l<<1)|0;if(!(d[h>>1]|0))k=i;else{h=0;j=10;break}}if((j|0)==8)while(1){k=t+((X(i,c)|0)+l<<1)|0;d[k>>1]=m;i=i+1|0;if((i|0)==(c|0))break;else j=8}else if((j|0)==10)while(1){i=0;j=0;do{w=e+((X(i,c)|0)+l<<1)|0;j=(X(d[w>>1]|0,b[35423+(i<<r<<5)+h>>0]|0)|0)+j|0;i=i+1|0}while((i|0)!=(k|0));j=j+64>>7;w=t+((X(h,c)|0)+l<<1)|0;d[w>>1]=(j|0)<(p|0)?p:(j|0)<(n|0)?j:o;h=h+1|0;if((h|0)==(c|0))break;else j=10}l=l+1|0}while((l|0)!=(c|0));if(!q){u=v;return}m=s>>g;l=0;do{n=X(l,c)|0;k=c;while(1){i=k+-1|0;if((k|0)<=0){i=0;j=18;break}if(!(d[t+(i+n<<1)>>1]|0))k=i;else{h=0;j=20;break}}if((j|0)==18)while(1){f[a+(i+n<<2)>>2]=m;i=i+1|0;if((i|0)==(c|0))break;else j=18}else if((j|0)==20)while(1){i=0;j=0;do{j=(X(d[t+(i+n<<1)>>1]|0,b[35423+(i<<r<<5)+h>>0]|0)|0)+j|0;i=i+1|0}while((i|0)!=(k|0));f[a+(h+n<<2)>>2]=j+s>>g;h=h+1|0;if((h|0)==(c|0))break;else j=20}l=l+1|0}while((l|0)!=(c|0));u=v;return}function hr(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;gr(a,4,b,c,d);return}function ir(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;gr(a,8,b,c,d);return}function jr(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;gr(a,16,b,c,d);return}function kr(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;gr(a,32,b,c,d);return}function lr(a,b,c){a=a|0;b=b|0;c=c|0;mr(a,c,4,b,8);return}function mr(a,c,e,f,g){a=a|0;c=c|0;e=e|0;f=f|0;g=g|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0;v=u;u=u+2048|0;r=v;s=20-g|0;t=1<<s+-1;if((e|0)>1){j=e;i=0;while(1){i=i+1|0;if(j>>>0>3)j=j>>>1;else break}}else i=0;q=5-i|0;n=(e|0)>0;if(n)m=0;else{u=v;return}do{l=e;while(1){i=l+-1|0;if((l|0)<=0){i=0;j=7;break}p=f+((X(i,e)|0)+m<<1)|0;if(!(d[p>>1]|0))l=i;else{k=0;j=9;break}}if((j|0)==7)while(1){p=r+((X(i,e)|0)+m<<1)|0;d[p>>1]=0;i=i+1|0;if((i|0)==(e|0))break;else j=7}else if((j|0)==9)while(1){i=0;j=0;do{p=f+((X(i,e)|0)+m<<1)|0;j=(X(d[p>>1]|0,b[35423+(i<<q<<5)+k>>0]|0)|0)+j|0;i=i+1|0}while((i|0)!=(l|0));o=j+64>>7;p=r+((X(k,e)|0)+m<<1)|0;d[p>>1]=(o|0)<-32768?-32768:((o|0)<32767?o:32767)&65535;k=k+1|0;if((k|0)==(e|0))break;else j=9}m=m+1|0}while((m|0)!=(e|0));if(!n){u=v;return}g=1<<g;o=g+255|0;p=t>>s;f=0;do{n=X(f,e)|0;m=e;while(1){i=m+-1|0;if((m|0)<=0){j=18;break}if(!(d[r+(i+n<<1)>>1]|0))m=i;else{j=19;break}}if((j|0)==18){j=X(f,c)|0;i=0;do{n=a+(i+j)|0;m=(h[n>>0]|0)+p|0;b[n>>0]=(m|0)<0?0:((m|0)<(g|0)?m:o)&255;i=i+1|0}while((i|0)!=(e|0))}else if((j|0)==19){l=X(f,c)|0;k=0;do{i=0;j=0;do{j=(X(d[r+(i+n<<1)>>1]|0,b[35423+(i<<q<<5)+k>>0]|0)|0)+j|0;i=i+1|0}while((i|0)!=(m|0));i=a+(k+l)|0;j=(h[i>>0]|0)+(j+t>>s)|0;b[i>>0]=(j|0)<0?0:((j|0)<(g|0)?j:o)&255;k=k+1|0}while((k|0)!=(e|0))}f=f+1|0}while((f|0)!=(e|0));u=v;return}function nr(a,b,c){a=a|0;b=b|0;c=c|0;mr(a,c,8,b,8);return}function or(a,b,c){a=a|0;b=b|0;c=c|0;mr(a,c,16,b,8);return}function pr(a,b,c){a=a|0;b=b|0;c=c|0;mr(a,c,32,b,8);return}function qr(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;rr(a,c,4,b,d);return}function rr(a,c,e,f,g){a=a|0;c=c|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0;v=u;u=u+2048|0;r=v;s=20-g|0;t=1<<s+-1;if((e|0)>1){i=e;h=0;while(1){h=h+1|0;if(i>>>0>3)i=i>>>1;else break}}else h=0;q=5-h|0;n=(e|0)>0;if(n)m=0;else{u=v;return}do{l=e;while(1){h=l+-1|0;if((l|0)<=0){h=0;i=7;break}p=f+((X(h,e)|0)+m<<1)|0;if(!(d[p>>1]|0))l=h;else{k=0;i=9;break}}if((i|0)==7)while(1){p=r+((X(h,e)|0)+m<<1)|0;d[p>>1]=0;h=h+1|0;if((h|0)==(e|0))break;else i=7}else if((i|0)==9)while(1){h=0;i=0;do{p=f+((X(h,e)|0)+m<<1)|0;i=(X(d[p>>1]|0,b[35423+(h<<q<<5)+k>>0]|0)|0)+i|0;h=h+1|0}while((h|0)!=(l|0));o=i+64>>7;p=r+((X(k,e)|0)+m<<1)|0;d[p>>1]=(o|0)<-32768?-32768:((o|0)<32767?o:32767)&65535;k=k+1|0;if((k|0)==(e|0))break;else i=9}m=m+1|0}while((m|0)!=(e|0));if(!n){u=v;return}g=1<<g;o=g+65535|0;p=t>>s;f=0;do{n=X(f,e)|0;m=e;while(1){h=m+-1|0;if((m|0)<=0){i=18;break}if(!(d[r+(h+n<<1)>>1]|0))m=h;else{i=19;break}}if((i|0)==18){i=X(f,c)|0;h=0;do{n=a+(h+i<<1)|0;m=(j[n>>1]|0)+p|0;d[n>>1]=(m|0)<0?0:((m|0)<(g|0)?m:o)&65535;h=h+1|0}while((h|0)!=(e|0))}else if((i|0)==19){l=X(f,c)|0;k=0;do{h=0;i=0;do{i=(X(d[r+(h+n<<1)>>1]|0,b[35423+(h<<q<<5)+k>>0]|0)|0)+i|0;h=h+1|0}while((h|0)!=(m|0));h=a+(k+l<<1)|0;i=(j[h>>1]|0)+(i+t>>s)|0;d[h>>1]=(i|0)<0?0:((i|0)<(g|0)?i:o)&65535;k=k+1|0}while((k|0)!=(e|0))}f=f+1|0}while((f|0)!=(e|0));u=v;return}function sr(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;rr(a,c,8,b,d);return}function tr(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;rr(a,c,16,b,d);return}function ur(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;rr(a,c,32,b,d);return}function vr(a,b,c){a=a|0;b=b|0;c=c|0;wr(a,4,b,c);return}function wr(a,c,e,f){a=a|0;c=c|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;s=u;u=u+2048|0;r=s;if((c|0)>1){g=c;k=0;while(1)if(g>>>0>3){g=g>>>1;k=k+1|0}else{g=c;h=0;break}while(1)if(g>>>0>3){g=g>>>1;h=h+1|0}else break;l=h+7|0;i=1<<k+-1;j=1<<h+6;h=c;g=0;while(1){g=g+1|0;if(h>>>0>3)h=h>>>1;else{n=k;q=j;p=l;break}}}else{g=0;i=0;n=-1;q=32;p=6}o=5-g|0;l=(c|0)>0;if(l)g=0;else{u=s;return}do{k=0;do{m=k<<o;h=0;j=0;do{t=e+((X(h,f)|0)+g<<1)|0;j=(X(d[t>>1]|0,b[35423+(m<<5)+h>>0]|0)|0)+j|0;h=h+1|0}while((h|0)!=(c|0));t=r+((X(k,c)|0)+g<<1)|0;d[t>>1]=j+i>>n;k=k+1|0}while((k|0)!=(c|0));g=g+1|0}while((g|0)!=(c|0));if(l)j=0;else{u=s;return}do{k=X(j,c)|0;i=0;do{l=i<<o;g=0;h=0;do{h=(X(d[r+(g+k<<1)>>1]|0,b[35423+(l<<5)+g>>0]|0)|0)+h|0;g=g+1|0}while((g|0)!=(c|0));d[a+(i+k<<1)>>1]=h+q>>p;i=i+1|0}while((i|0)!=(c|0));j=j+1|0}while((j|0)!=(c|0));u=s;return}function xr(a,b,c){a=a|0;b=b|0;c=c|0;wr(a,8,b,c);return}function yr(a,b,c){a=a|0;b=b|0;c=c|0;wr(a,16,b,c);return}function zr(a,b,c){a=a|0;b=b|0;c=c|0;wr(a,32,b,c);return}function Ar(a,b,c,e){a=a|0;b=b|0;c=c|0;e=e|0;var f=0,g=0,h=0,i=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0;w=u;u=u+2176|0;v=w+128|0;t=(b|0)>0;if(!t){u=w;return}p=b>>>1;q=(p|0)==0;r=b>>>2;s=b>>>0>7;o=0;i=w;l=w+64|0;while(1){g=X(o,e)|0;if(!q){h=l;f=0;do{k=c+(f+g<<1)|0;n=f+p|0;m=c+(n+g<<1)|0;d[h+(f<<1)>>1]=(j[m>>1]|0)+(j[k>>1]|0);d[h+(n<<1)>>1]=(j[k>>1]|0)-(j[m>>1]|0);f=f+1|0}while((f|0)!=(p|0))}if(s){m=r;n=p;k=i;i=l;while(1){h=i;l=k;g=0;do{f=0;do{A=f+g|0;z=h+(A<<1)|0;x=A+m|0;y=h+(x<<1)|0;d[l+(A<<1)>>1]=(j[y>>1]|0)+(j[z>>1]|0);d[l+(x<<1)>>1]=(j[z>>1]|0)-(j[y>>1]|0);f=f+1|0}while((f|0)!=(m|0));g=g+n|0}while((g|0)<(b|0));m=m>>1;if((m|0)<=1)break;else{A=i;n=n>>1;i=k;k=A}}}else k=l;g=k;h=X(o,b)|0;f=0;do{y=d[g+(f<<1)>>1]|0;A=f|1;z=d[g+(A<<1)>>1]|0;d[v+(f+h<<1)>>1]=z+y;d[v+(A+h<<1)>>1]=y-z;f=f+2|0}while((f|0)<(b|0));o=o+1|0;if((o|0)==(b|0))break;else l=k}if(!t){u=w;return}p=b>>>1;q=(p|0)==0;r=b>>>2;s=b>>>0>7;o=0;while(1){if(!q){g=k;f=0;do{y=v+((X(f,b)|0)+o<<1)|0;y=d[y>>1]|0;A=f+p|0;z=v+((X(A,b)|0)+o<<1)|0;z=d[z>>1]|0;d[g+(f<<1)>>1]=z+y;d[g+(A<<1)>>1]=y-z;f=f+1|0}while((f|0)!=(p|0))}if(s){m=r;n=p;h=i;i=k;while(1){k=i;l=h;g=0;do{f=0;do{x=f+g|0;y=k+(x<<1)|0;A=x+m|0;z=k+(A<<1)|0;d[l+(x<<1)>>1]=(j[z>>1]|0)+(j[y>>1]|0);d[l+(A<<1)>>1]=(j[y>>1]|0)-(j[z>>1]|0);f=f+1|0}while((f|0)!=(m|0));g=g+n|0}while((g|0)<(b|0));m=m>>1;if((m|0)<=1)break;else{A=i;n=n>>1;i=h;h=A}}}else h=k;g=h;f=0;do{y=g+(f<<1)|0;A=f|1;z=g+(A<<1)|0;x=a+((X(f,b)|0)+o<<1)|0;d[x>>1]=(j[z>>1]|0)+(j[y>>1]|0);A=a+((X(A,b)|0)+o<<1)|0;d[A>>1]=(j[y>>1]|0)-(j[z>>1]|0);f=f+2|0}while((f|0)<(b|0));o=o+1|0;if((o|0)==(b|0))break;else k=h}u=w;return}function Br(a,b,c){a=a|0;b=b|0;c=c|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0;e=u;u=u+32|0;s=e;g=d[b>>1]|0;i=d[b+4>>1]|0;k=d[b+2>>1]|0;f=d[b+6>>1]|0;v=i+g<<16>>16;j=f+k<<16>>16;d[s>>1]=j+v;o=s+2|0;d[o>>1]=v-j;i=g-i<<16>>16;f=k-f<<16>>16;k=s+4|0;d[k>>1]=f+i;g=s+6|0;d[g>>1]=i-f;f=d[b+(c<<1)>>1]|0;i=d[b+(c+2<<1)>>1]|0;j=d[b+(c+1<<1)>>1]|0;v=d[b+(c+3<<1)>>1]|0;h=i+f<<16>>16;w=v+j<<16>>16;r=s+8|0;d[r>>1]=w+h;n=s+10|0;d[n>>1]=h-w;i=f-i<<16>>16;v=j-v<<16>>16;j=s+12|0;d[j>>1]=v+i;f=s+14|0;d[f>>1]=i-v;v=c<<1;i=d[b+(v<<1)>>1]|0;w=d[b+(v+2<<1)>>1]|0;h=d[b+((v|1)<<1)>>1]|0;v=d[b+(v+3<<1)>>1]|0;t=w+i<<16>>16;l=v+h<<16>>16;p=l+t|0;d[s+16>>1]=p;l=t-l|0;d[s+18>>1]=l;w=i-w<<16>>16;v=h-v<<16>>16;h=s+20|0;d[h>>1]=v+w;i=s+22|0;d[i>>1]=w-v;v=c*3|0;w=d[b+(v<<1)>>1]|0;t=d[b+(v+2<<1)>>1]|0;c=d[b+(v+1<<1)>>1]|0;v=d[b+(v+3<<1)>>1]|0;b=t+w<<16>>16;m=v+c<<16>>16;q=m+b|0;d[s+24>>1]=q;m=b-m|0;d[s+26>>1]=m;t=w-t<<16>>16;v=c-v<<16>>16;b=v+t|0;d[s+28>>1]=b;c=s+30|0;d[c>>1]=t-v;s=d[s>>1]|0;p=p<<16>>16;r=d[r>>1]|0;q=q<<16>>16;v=p+s<<16>>16;t=q+r<<16>>16;d[a>>1]=t+v;d[a+8>>1]=v-t;p=s-p<<16>>16;q=r-q<<16>>16;d[a+16>>1]=q+p;d[a+24>>1]=p-q;o=d[o>>1]|0;l=l<<16>>16;n=d[n>>1]|0;m=m<<16>>16;q=l+o<<16>>16;p=m+n<<16>>16;d[a+2>>1]=p+q;d[a+10>>1]=q-p;l=o-l<<16>>16;m=n-m<<16>>16;d[a+18>>1]=m+l;d[a+26>>1]=l-m;k=d[k>>1]|0;h=d[h>>1]|0;j=d[j>>1]|0;b=b<<16>>16;m=h+k<<16>>16;l=b+j<<16>>16;d[a+4>>1]=l+m;d[a+12>>1]=m-l;h=k-h<<16>>16;b=j-b<<16>>16;d[a+20>>1]=b+h;d[a+28>>1]=h-b;g=d[g>>1]|0;b=d[i>>1]|0;f=d[f>>1]|0;c=d[c>>1]|0;i=b+g<<16>>16;h=c+f<<16>>16;d[a+6>>1]=h+i;d[a+14>>1]=i-h;b=g-b<<16>>16;c=f-c<<16>>16;d[a+22>>1]=c+b;d[a+30>>1]=b-c;u=e;return}function Cr(a,b,c){a=a|0;b=b|0;c=c|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0;g=u;u=u+128|0;f=g;e=0;do{i=X(e,c)|0;s=d[b+(i<<1)>>1]|0;l=d[b+(i+4<<1)>>1]|0;q=d[b+(i+1<<1)>>1]|0;k=d[b+(i+5<<1)>>1]|0;h=d[b+(i+2<<1)>>1]|0;j=d[b+(i+6<<1)>>1]|0;r=d[b+(i+3<<1)>>1]|0;i=d[b+(i+7<<1)>>1]|0;p=l+s<<16>>16;m=j+h<<16>>16;o=k+q<<16>>16;n=i+r<<16>>16;l=s-l<<16>>16;j=h-j<<16>>16;k=q-k<<16>>16;i=r-i<<16>>16;r=m+p<<16>>16;q=n+o<<16>>16;h=e<<3;d[f+(h<<1)>>1]=q+r;d[f+((h|1)<<1)>>1]=r-q;m=p-m<<16>>16;n=o-n<<16>>16;d[f+((h|2)<<1)>>1]=n+m;d[f+((h|3)<<1)>>1]=m-n;n=j+l<<16>>16;m=i+k<<16>>16;d[f+((h|4)<<1)>>1]=m+n;d[f+((h|5)<<1)>>1]=n-m;j=l-j<<16>>16;i=k-i<<16>>16;d[f+((h|6)<<1)>>1]=i+j;d[f+((h|7)<<1)>>1]=j-i;e=e+1|0}while((e|0)!=8);e=0;do{y=d[f+(e<<1)>>1]|0;j=e+32|0;n=d[f+(j<<1)>>1]|0;t=e+8|0;v=d[f+(t<<1)>>1]|0;m=e+40|0;o=d[f+(m<<1)>>1]|0;h=e+16|0;x=d[f+(h<<1)>>1]|0;p=e+48|0;q=d[f+(p<<1)>>1]|0;k=e+24|0;w=d[f+(k<<1)>>1]|0;s=e+56|0;r=d[f+(s<<1)>>1]|0;b=n+y<<16>>16;i=q+x<<16>>16;c=o+v<<16>>16;l=r+w<<16>>16;n=y-n<<16>>16;q=x-q<<16>>16;o=v-o<<16>>16;r=w-r<<16>>16;w=i+b<<16>>16;v=l+c<<16>>16;d[a+(e<<1)>>1]=v+w;d[a+(t<<1)>>1]=w-v;i=b-i<<16>>16;l=c-l<<16>>16;d[a+(h<<1)>>1]=l+i;d[a+(k<<1)>>1]=i-l;k=q+n<<16>>16;l=r+o<<16>>16;d[a+(j<<1)>>1]=l+k;d[a+(m<<1)>>1]=k-l;q=n-q<<16>>16;r=o-r<<16>>16;d[a+(p<<1)>>1]=r+q;d[a+(s<<1)>>1]=q-r;e=e+1|0}while((e|0)!=8);u=g;return}function Dr(a,b,c){a=a|0;b=b|0;c=c|0;Ar(a,16,b,c);return}function Er(a,b,c){a=a|0;b=b|0;c=c|0;Ar(a,32,b,c);return}function Fr(a,c,e,f,g,h){a=a|0;c=c|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0;if(g&1|0)Pa(36447,36460,40,36479);if((h|0)>0&(g|0)>0)k=0;else return;do{i=a+(X(k,c)|0)|0;j=e+((X(k,f)|0)<<1)|0;l=0;while(1){m=(d[j>>1]|0)+32>>6;b[i>>0]=(m|0)<0?0:((m|0)<255?m:255)&255;m=(d[j+2>>1]|0)+32>>6;b[i+1>>0]=(m|0)<0?0:((m|0)<255?m:255)&255;l=l+2|0;if((l|0)>=(g|0))break;else{i=i+2|0;j=j+4|0}}k=k+1|0}while((k|0)!=(h|0));return}function Gr(a,c,e,f,g,h,i,j,k){a=a|0;c=c|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0;if((k|0)<=0)Pa(36510,36460,60,36520);p=1<<k+-1;if((h|0)>0&(g|0)>0)n=0;else return;do{l=a+(X(n,c)|0)|0;m=e+((X(n,f)|0)<<1)|0;o=0;while(1){q=((X(d[m>>1]|0,i)|0)+p>>k)+j|0;b[l>>0]=(q|0)<0?0:((q|0)<255?q:255)&255;o=o+1|0;if((o|0)==(g|0))break;else{l=l+1|0;m=m+2|0}}n=n+1|0}while((n|0)!=(h|0));return}function Hr(a,c,e,f,g,h,i,j,k,l,m,n){a=a|0;c=c|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;var o=0,p=0,q=0,r=0,s=0;if((n|0)<=0)Pa(36510,36460,80,36549);r=k+1+m<<n;if((i|0)<=0)return;q=n+1|0;if((h|0)>0)o=0;else return;do{n=X(o,g)|0;m=a+(X(o,c)|0)|0;k=f+(n<<1)|0;n=e+(n<<1)|0;p=0;while(1){s=X(d[n>>1]|0,j)|0;s=s+r+(X(d[k>>1]|0,l)|0)>>q;b[m>>0]=(s|0)<0?0:((s|0)<255?s:255)&255;p=p+1|0;if((p|0)==(h|0))break;else{m=m+1|0;k=k+2|0;n=n+2|0}}o=o+1|0}while((o|0)!=(i|0));return}function Ir(a,c,e,f,g,h,i){a=a|0;c=c|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0;if(h&1|0)Pa(36447,36460,105,36580);if((i|0)>0&(h|0)>0)m=0;else return;do{l=X(m,g)|0;j=a+(X(m,c)|0)|0;k=f+(l<<1)|0;l=e+(l<<1)|0;n=0;while(1){o=(d[l>>1]|0)+64+(d[k>>1]|0)>>7;b[j>>0]=(o|0)<0?0:((o|0)<255?o:255)&255;o=(d[l+2>>1]|0)+64+(d[k+2>>1]|0)>>7;b[j+1>>0]=(o|0)<0?0:((o|0)<255?o:255)&255;n=n+2|0;if((n|0)>=(h|0))break;else{j=j+2|0;k=k+4|0;l=l+4|0}}m=m+1|0}while((m|0)!=(i|0));return}function Jr(a,b,c,e,f,g,h){a=a|0;b=b|0;c=c|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;o=14-h|0;n=(o|0)>0?1<<o+-1:0;if(f&1|0)Pa(36447,36460,172,36613);if((g|0)<=0)return;l=1<<h;m=l+65535|0;if((f|0)>0)j=0;else return;do{h=a+((X(j,b)|0)<<1)|0;i=c+((X(j,e)|0)<<1)|0;k=0;while(1){p=(d[i>>1]|0)+n>>o;d[h>>1]=(p|0)<0?0:((p|0)<(l|0)?p:m)&65535;p=(d[i+2>>1]|0)+n>>o;d[h+2>>1]=(p|0)<0?0:((p|0)<(l|0)?p:m)&65535;k=k+2|0;if((k|0)>=(f|0))break;else{h=h+4|0;i=i+4|0}}j=j+1|0}while((j|0)!=(g|0));return}function Kr(a,b,c,e,f,g,h,i,j,k){a=a|0;b=b|0;c=c|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0;if((j|0)<=0)Pa(36510,36460,193,36645);q=1<<j+-1;if((g|0)<=0)return;o=1<<k;p=o+65535|0;if((f|0)>0)m=0;else return;do{k=a+((X(m,b)|0)<<1)|0;l=c+((X(m,e)|0)<<1)|0;n=0;while(1){r=((X(d[l>>1]|0,h)|0)+q>>j)+i|0;d[k>>1]=(r|0)<0?0:((r|0)<(o|0)?r:p)&65535;n=n+1|0;if((n|0)==(f|0))break;else{k=k+2|0;l=l+2|0}}m=m+1|0}while((m|0)!=(g|0));return}function Lr(a,b,c,e,f,g,h,i,j,k,l,m,n){a=a|0;b=b|0;c=c|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;var o=0,p=0,q=0,r=0,s=0,t=0;if((m|0)<=0)Pa(36510,36460,213,36675);s=j+1+l<<m;if((h|0)<=0)return;r=m+1|0;p=1<<n;q=p+65535|0;if((g|0)>0)n=0;else return;do{m=X(n,f)|0;l=a+((X(n,b)|0)<<1)|0;j=e+(m<<1)|0;m=c+(m<<1)|0;o=0;while(1){t=X(d[m>>1]|0,i)|0;t=t+s+(X(d[j>>1]|0,k)|0)>>r;d[l>>1]=(t|0)<0?0:((t|0)<(p|0)?t:q)&65535;o=o+1|0;if((o|0)==(g|0))break;else{l=l+2|0;j=j+2|0;m=m+2|0}}n=n+1|0}while((n|0)!=(h|0));return}function Mr(a,b,c,e,f,g,h,i){a=a|0;b=b|0;c=c|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;q=15-i|0;p=1<<q+-1;if(g&1|0)Pa(36447,36460,238,36707);if((h|0)<=0)return;n=1<<i;o=n+65535|0;if((g|0)>0)l=0;else return;do{k=X(l,f)|0;i=a+((X(l,b)|0)<<1)|0;j=e+(k<<1)|0;k=c+(k<<1)|0;m=0;while(1){r=(d[k>>1]|0)+p+(d[j>>1]|0)>>q;d[i>>1]=(r|0)<0?0:((r|0)<(n|0)?r:o)&65535;r=(d[k+2>>1]|0)+p+(d[j+2>>1]|0)>>q;d[i+2>>1]=(r|0)<0?0:((r|0)<(n|0)?r:o)&65535;m=m+2|0;if((m|0)>=(g|0))break;else{i=i+4|0;j=j+4|0;k=k+4|0}}l=l+1|0}while((l|0)!=(h|0));return}function Nr(a,b,c,e,f,g,i,j,k){a=a|0;b=b|0;c=c|0;e=e|0;f=f|0;g=g|0;i=i|0;j=j|0;k=k|0;var l=0;if((g|0)>0&(f|0)>0)k=0;else return;do{i=c+(X(k,e)|0)|0;j=a+((X(k,b)|0)<<1)|0;l=0;while(1){d[j>>1]=(h[i>>0]|0)<<6;l=l+1|0;if((l|0)==(f|0))break;else{i=i+1|0;j=j+2|0}}k=k+1|0}while((k|0)!=(g|0));return}function Or(a,b,c,e,f,g,h,i,k,l){a=a|0;b=b|0;c=c|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;k=k|0;l=l|0;var m=0;m=14-l|0;if((g|0)>0&(f|0)>0)k=0;else return;do{h=c+((X(k,e)|0)<<1)|0;i=a+((X(k,b)|0)<<1)|0;l=0;while(1){d[i>>1]=(j[h>>1]|0)<<m;l=l+1|0;if((l|0)==(f|0))break;else{h=h+2|0;i=i+2|0}}k=k+1|0}while((k|0)!=(g|0));return}function Pr(a,b,c,e,f,g,i,j,k,l){a=a|0;b=b|0;c=c|0;e=e|0;f=f|0;g=g|0;i=i|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0;t=u;o=l+-8|0;r=g+3|0;p=X(f<<1,r)|0;s=u;u=u+((1*p|0)+15&-16)|0;p=g+2|0;if((p|0)>-1){q=(f|0)>0;k=-1;do a:do if(q){n=k+1|0;m=0;k=c+((X(k,e)|0)+-1)|0;while(1){switch(i|0){case 0:{k=k+1|0;l=h[k>>0]|0;break}case 1:{v=k+1|0;l=(X(h[k>>0]|0,-2)|0)+((h[v>>0]|0)*58|0)+((h[k+2>>0]|0)*10|0)-(h[k+3>>0]<<1)>>o&65535;k=v;break}case 2:{v=k+1|0;l=(X(h[k>>0]|0,-4)|0)+((h[v>>0]|0)*54|0)+(h[k+2>>0]<<4)-(h[k+3>>0]<<1)>>o&65535;k=v;break}case 3:{v=k+1|0;l=(X(h[k>>0]|0,-6)|0)+((h[v>>0]|0)*46|0)+((h[k+2>>0]|0)*28|0)-(h[k+3>>0]<<2)>>o&65535;k=v;break}case 4:{v=k+1|0;l=(X(h[k>>0]|0,-4)|0)-(h[k+3>>0]<<2)+(((h[k+2>>0]|0)+(h[v>>0]|0)|0)*36|0)>>o&65535;k=v;break}case 5:{v=k+1|0;l=(X(h[k>>0]|0,-4)|0)+((h[v>>0]|0)*28|0)+((h[k+2>>0]|0)*46|0)+(X(h[k+3>>0]|0,-6)|0)>>o&65535;k=v;break}case 6:{v=k+1|0;l=(X(h[k>>0]|0,-2)|0)+(h[v>>0]<<4)+((h[k+2>>0]|0)*54|0)-(h[k+3>>0]<<2)>>o&65535;k=v;break}default:{v=k+1|0;l=(X(h[k>>0]|0,-2)|0)+((h[v>>0]|0)*10|0)+((h[k+2>>0]|0)*58|0)-(h[k+3>>0]<<1)>>o&65535;k=v}}v=s+(n+(X(m,r)|0)<<1)|0;d[v>>1]=l;m=m+1|0;if((m|0)==(f|0)){k=n;break a}}}else k=k+1|0;while(0);while((k|0)!=(p|0))}o=(i|0)==0?o:6;if((f|0)<=0){u=t;return}p=(g|0)>0;n=0;do{b:do if(p){m=0;k=s+((X(n,r)|0)<<1)|0;while(1){switch(j|0){case 0:{k=k+2|0;l=d[k>>1]|0;break}case 1:{v=k+2|0;l=(X(d[k>>1]|0,-2)|0)+((d[v>>1]|0)*58|0)+((d[k+4>>1]|0)*10|0)-(d[k+6>>1]<<1)>>o&65535;k=v;break}case 2:{v=k+2|0;l=(X(d[k>>1]|0,-4)|0)+((d[v>>1]|0)*54|0)+(d[k+4>>1]<<4)-(d[k+6>>1]<<1)>>o&65535;k=v;break}case 3:{v=k+2|0;l=(X(d[k>>1]|0,-6)|0)+((d[v>>1]|0)*46|0)+((d[k+4>>1]|0)*28|0)-(d[k+6>>1]<<2)>>o&65535;k=v;break}case 4:{v=k+2|0;l=(X(d[k>>1]|0,-4)|0)-(d[k+6>>1]<<2)+(((d[k+4>>1]|0)+(d[v>>1]|0)|0)*36|0)>>o&65535;k=v;break}case 5:{v=k+2|0;l=(X(d[k>>1]|0,-4)|0)+((d[v>>1]|0)*28|0)+((d[k+4>>1]|0)*46|0)+(X(d[k+6>>1]|0,-6)|0)>>o&65535;k=v;break}case 6:{v=k+2|0;l=(X(d[k>>1]|0,-2)|0)+(d[v>>1]<<4)+((d[k+4>>1]|0)*54|0)-(d[k+6>>1]<<2)>>o&65535;k=v;break}default:{v=k+2|0;l=(X(d[k>>1]|0,-2)|0)+((d[v>>1]|0)*10|0)+((d[k+4>>1]|0)*58|0)-(d[k+6>>1]<<1)>>o&65535;k=v}}v=a+((X(m,b)|0)+n<<1)|0;d[v>>1]=l;m=m+1|0;if((m|0)==(g|0))break b}}while(0);n=n+1|0}while((n|0)!=(f|0));u=t;return}function Qr(a,b,c,e,f,g,h,i,k,l){a=a|0;b=b|0;c=c|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0;t=u;o=l+-8|0;r=g+3|0;p=X(f<<1,r)|0;s=u;u=u+((1*p|0)+15&-16)|0;p=g+2|0;if((p|0)>-1){q=(f|0)>0;k=-1;do a:do if(q){n=k+1|0;m=0;k=c+((X(k,e)|0)+-1<<1)|0;while(1){switch(h|0){case 0:{k=k+2|0;l=d[k>>1]|0;break}case 1:{v=k+2|0;l=(X(j[k>>1]|0,-2)|0)+((j[v>>1]|0)*58|0)+((j[k+4>>1]|0)*10|0)-(j[k+6>>1]<<1)>>o&65535;k=v;break}case 2:{v=k+2|0;l=(X(j[k>>1]|0,-4)|0)+((j[v>>1]|0)*54|0)+(j[k+4>>1]<<4)-(j[k+6>>1]<<1)>>o&65535;k=v;break}case 3:{v=k+2|0;l=(X(j[k>>1]|0,-6)|0)+((j[v>>1]|0)*46|0)+((j[k+4>>1]|0)*28|0)-(j[k+6>>1]<<2)>>o&65535;k=v;break}case 4:{v=k+2|0;l=(X(j[k>>1]|0,-4)|0)-(j[k+6>>1]<<2)+(((j[k+4>>1]|0)+(j[v>>1]|0)|0)*36|0)>>o&65535;k=v;break}case 5:{v=k+2|0;l=(X(j[k>>1]|0,-4)|0)+((j[v>>1]|0)*28|0)+((j[k+4>>1]|0)*46|0)+(X(j[k+6>>1]|0,-6)|0)>>o&65535;k=v;break}case 6:{v=k+2|0;l=(X(j[k>>1]|0,-2)|0)+(j[v>>1]<<4)+((j[k+4>>1]|0)*54|0)-(j[k+6>>1]<<2)>>o&65535;k=v;break}default:{v=k+2|0;l=(X(j[k>>1]|0,-2)|0)+((j[v>>1]|0)*10|0)+((j[k+4>>1]|0)*58|0)-(j[k+6>>1]<<1)>>o&65535;k=v}}v=s+(n+(X(m,r)|0)<<1)|0;d[v>>1]=l;m=m+1|0;if((m|0)==(f|0)){k=n;break a}}}else k=k+1|0;while(0);while((k|0)!=(p|0))}o=(h|0)==0?o:6;if((f|0)<=0){u=t;return}p=(g|0)>0;n=0;do{b:do if(p){m=0;k=s+((X(n,r)|0)<<1)|0;while(1){switch(i|0){case 0:{k=k+2|0;l=d[k>>1]|0;break}case 1:{v=k+2|0;l=(X(d[k>>1]|0,-2)|0)+((d[v>>1]|0)*58|0)+((d[k+4>>1]|0)*10|0)-(d[k+6>>1]<<1)>>o&65535;k=v;break}case 2:{v=k+2|0;l=(X(d[k>>1]|0,-4)|0)+((d[v>>1]|0)*54|0)+(d[k+4>>1]<<4)-(d[k+6>>1]<<1)>>o&65535;k=v;break}case 3:{v=k+2|0;l=(X(d[k>>1]|0,-6)|0)+((d[v>>1]|0)*46|0)+((d[k+4>>1]|0)*28|0)-(d[k+6>>1]<<2)>>o&65535;k=v;break}case 4:{v=k+2|0;l=(X(d[k>>1]|0,-4)|0)-(d[k+6>>1]<<2)+(((d[k+4>>1]|0)+(d[v>>1]|0)|0)*36|0)>>o&65535;k=v;break}case 5:{v=k+2|0;l=(X(d[k>>1]|0,-4)|0)+((d[v>>1]|0)*28|0)+((d[k+4>>1]|0)*46|0)+(X(d[k+6>>1]|0,-6)|0)>>o&65535;k=v;break}case 6:{v=k+2|0;l=(X(d[k>>1]|0,-2)|0)+(d[v>>1]<<4)+((d[k+4>>1]|0)*54|0)-(d[k+6>>1]<<2)>>o&65535;k=v;break}default:{v=k+2|0;l=(X(d[k>>1]|0,-2)|0)+((d[v>>1]|0)*10|0)+((d[k+4>>1]|0)*58|0)-(d[k+6>>1]<<1)>>o&65535;k=v}}v=a+((X(m,b)|0)+n<<1)|0;d[v>>1]=l;m=m+1|0;if((m|0)==(g|0))break b}}while(0);n=n+1|0}while((n|0)!=(f|0));u=t;return}function Rr(a,b,c,e,f,g,i){a=a|0;b=b|0;c=c|0;e=e|0;f=f|0;g=g|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0;if((g|0)>0&(f|0)>0)l=0;else return;do{i=c+(X(l,e)|0)|0;j=a+((X(l,b)|0)<<1)|0;k=0;while(1){o=(h[i+1>>0]|0)<<6&65535;n=(h[i+2>>0]|0)<<6&65535;m=(h[i+3>>0]|0)<<6&65535;d[j>>1]=(h[i>>0]|0)<<6;d[j+2>>1]=o;d[j+4>>1]=n;d[j+6>>1]=m;k=k+4|0;if((k|0)>=(f|0))break;else{i=i+4|0;j=j+8|0}}l=l+1|0}while((l|0)!=(g|0));return}function Sr(a,b,c,e,f,g,h,i){a=a|0;b=b|0;c=c|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var k=0,l=0,m=0;m=14-i|0;if((g|0)>0&(f|0)>0)k=0;else return;do{h=a+((X(k,b)|0)<<1)|0;i=c+((X(k,e)|0)<<1)|0;l=0;while(1){d[h>>1]=(j[i>>1]|0)<<m;l=l+1|0;if((l|0)==(f|0))break;else{h=h+2|0;i=i+2|0}}k=k+1|0}while((k|0)!=(g|0));return}function Tr(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;Ur(a,b,c,d,e,f,g,0,1,8);return}function Ur(a,b,c,e,g,i,j,k,l,m){a=a|0;b=b|0;c=c|0;e=e|0;g=g|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;o=f[9768+(k<<2)>>2]|0;w=f[9768+(l<<2)>>2]|0;n=f[9784+(l<<2)>>2]|0;x=w+i+n|0;v=m+-8|0;switch(k|0){case 0:{m=0-w|0;q=n+i|0;if((q|0)>(m|0)?(s=0-o|0,(g|0)>0):0)do{n=0;o=j+(m+w<<1)|0;p=c+(X(m,e)|0)+s|0;while(1){d[o>>1]=h[p>>0]|0;n=n+1|0;if((n|0)==(g|0))break;else{o=o+(x<<1)|0;p=p+1|0}}m=m+1|0}while((m|0)!=(q|0));break}case 1:{m=0-w|0;q=n+i|0;if((q|0)>(m|0)?(t=0-o|0,(g|0)>0):0)do{n=0;o=j+(m+w<<1)|0;p=c+(X(m,e)|0)+t|0;while(1){u=p;p=p+1|0;s=(h[p>>0]<<2)-(h[u>>0]|0)+(X(h[u+2>>0]|0,-10)|0)|0;s=s+((h[u+3>>0]|0)*58|0)+((h[u+4>>0]|0)*17|0)+(X(h[u+5>>0]|0,-5)|0)|0;d[o>>1]=s+(h[u+6>>0]|0)>>v;n=n+1|0;if((n|0)==(g|0))break;else o=o+(x<<1)|0}m=m+1|0}while((m|0)!=(q|0));break}case 2:{m=0-w|0;q=n+i|0;if((q|0)>(m|0)?(u=0-o|0,(g|0)>0):0)do{n=0;o=j+(m+w<<1)|0;p=c+(X(m,e)|0)+u|0;while(1){t=p;p=p+1|0;t=(h[p>>0]<<2)-(h[t>>0]|0)+(((h[t+4>>0]|0)+(h[t+3>>0]|0)|0)*40|0)+(h[t+6>>0]<<2)-(h[t+7>>0]|0)+(X((h[t+5>>0]|0)+(h[t+2>>0]|0)|0,-11)|0)>>v&65535;d[o>>1]=t;n=n+1|0;if((n|0)==(g|0))break;else o=o+(x<<1)|0}m=m+1|0}while((m|0)!=(q|0));break}case 3:{m=0-w|0;q=n+i|0;if((q|0)>(m|0)?(r=0-o|0,(g|0)>0):0)do{n=0;o=j+(m+w<<1)|0;p=c+(X(m,e)|0)+r|0;while(1){u=p;p=p+1|0;t=(X(h[p>>0]|0,-5)|0)+(h[u>>0]|0)|0;t=t+((h[u+2>>0]|0)*17|0)+((h[u+3>>0]|0)*58|0)+(X(h[u+4>>0]|0,-10)|0)|0;d[o>>1]=t+(h[u+5>>0]<<2)-(h[u+6>>0]|0)>>v;n=n+1|0;if((n|0)==(g|0))break;else o=o+(x<<1)|0}m=m+1|0}while((m|0)!=(q|0));break}default:{}}q=(k|0)==0?v:6;switch(l|0){case 0:{if((g|0)>0&(i|0)>0)p=0;else return;do{m=0;n=a+(p<<1)|0;o=j+((X(p,x)|0)<<1)|0;while(1){d[n>>1]=d[o>>1]|0;m=m+1|0;if((m|0)==(i|0))break;else{n=n+(b<<1)|0;o=o+2|0}}p=p+1|0}while((p|0)!=(g|0));return}case 1:{if((g|0)>0&(i|0)>0)p=0;else return;do{m=0;n=a+(p<<1)|0;o=j+((X(p,x)|0)<<1)|0;while(1){l=o;o=o+2|0;k=(d[o>>1]<<2)-(d[l>>1]|0)+(X(d[l+4>>1]|0,-10)|0)|0;k=k+((d[l+6>>1]|0)*58|0)+((d[l+8>>1]|0)*17|0)+(X(d[l+10>>1]|0,-5)|0)|0;d[n>>1]=k+(d[l+12>>1]|0)>>q;m=m+1|0;if((m|0)==(i|0))break;else n=n+(b<<1)|0}p=p+1|0}while((p|0)!=(g|0));return}case 2:{if((g|0)>0&(i|0)>0)p=0;else return;do{m=0;n=a+(p<<1)|0;o=j+((X(p,x)|0)<<1)|0;while(1){l=o;o=o+2|0;l=(d[o>>1]<<2)-(d[l>>1]|0)+(((d[l+8>>1]|0)+(d[l+6>>1]|0)|0)*40|0)+(d[l+12>>1]<<2)-(d[l+14>>1]|0)+(X((d[l+10>>1]|0)+(d[l+4>>1]|0)|0,-11)|0)>>q&65535;d[n>>1]=l;m=m+1|0;if((m|0)==(i|0))break;else n=n+(b<<1)|0}p=p+1|0}while((p|0)!=(g|0));return}case 3:{if((g|0)>0&(i|0)>0)p=0;else return;do{m=0;n=a+(p<<1)|0;o=j+((X(p,x)|0)<<1)|0;while(1){l=o;o=o+2|0;k=(X(d[o>>1]|0,-5)|0)+(d[l>>1]|0)|0;k=k+((d[l+4>>1]|0)*17|0)+((d[l+6>>1]|0)*58|0)+(X(d[l+8>>1]|0,-10)|0)|0;d[n>>1]=k+(d[l+10>>1]<<2)-(d[l+12>>1]|0)>>q;m=m+1|0;if((m|0)==(i|0))break;else n=n+(b<<1)|0}p=p+1|0}while((p|0)!=(g|0));return}default:return}}function Vr(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;Ur(a,b,c,d,e,f,g,0,2,8);return}function Wr(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;Ur(a,b,c,d,e,f,g,0,3,8);return}function Xr(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;Ur(a,b,c,d,e,f,g,1,0,8);return}function Yr(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;Ur(a,b,c,d,e,f,g,1,1,8);return}function Zr(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;Ur(a,b,c,d,e,f,g,1,2,8);return}function _r(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;Ur(a,b,c,d,e,f,g,1,3,8);return}function $r(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;Ur(a,b,c,d,e,f,g,2,0,8);return}function as(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;Ur(a,b,c,d,e,f,g,2,1,8);return}function bs(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;Ur(a,b,c,d,e,f,g,2,2,8);return}function cs(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;Ur(a,b,c,d,e,f,g,2,3,8);return}function ds(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;Ur(a,b,c,d,e,f,g,3,0,8);return}function es(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;Ur(a,b,c,d,e,f,g,3,1,8);return}function fs(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;Ur(a,b,c,d,e,f,g,3,2,8);return}function gs(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;Ur(a,b,c,d,e,f,g,3,3,8);return}function hs(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;is(a,b,c,d,e,f,g,0,1,h);return}function is(a,b,c,e,g,h,i,k,l,m){a=a|0;b=b|0;c=c|0;e=e|0;g=g|0;h=h|0;i=i|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;o=f[9768+(k<<2)>>2]|0;w=f[9768+(l<<2)>>2]|0;n=f[9784+(l<<2)>>2]|0;x=w+h+n|0;v=m+-8|0;switch(k|0){case 0:{m=0-w|0;q=n+h|0;if((q|0)>(m|0)?(s=0-o|0,(g|0)>0):0)do{n=0;o=i+(m+w<<1)|0;p=c+((X(m,e)|0)<<1)+(s<<1)|0;while(1){d[o>>1]=d[p>>1]|0;n=n+1|0;if((n|0)==(g|0))break;else{o=o+(x<<1)|0;p=p+2|0}}m=m+1|0}while((m|0)!=(q|0));break}case 1:{m=0-w|0;q=n+h|0;if((q|0)>(m|0)?(t=0-o|0,(g|0)>0):0)do{n=0;o=i+(m+w<<1)|0;p=c+((X(m,e)|0)<<1)+(t<<1)|0;while(1){u=p;p=p+2|0;s=(j[p>>1]<<2)-(j[u>>1]|0)+(X(j[u+4>>1]|0,-10)|0)|0;s=s+((j[u+6>>1]|0)*58|0)+((j[u+8>>1]|0)*17|0)+(X(j[u+10>>1]|0,-5)|0)|0;d[o>>1]=s+(j[u+12>>1]|0)>>v;n=n+1|0;if((n|0)==(g|0))break;else o=o+(x<<1)|0}m=m+1|0}while((m|0)!=(q|0));break}case 2:{m=0-w|0;q=n+h|0;if((q|0)>(m|0)?(u=0-o|0,(g|0)>0):0)do{n=0;o=i+(m+w<<1)|0;p=c+((X(m,e)|0)<<1)+(u<<1)|0;while(1){t=p;p=p+2|0;t=(j[p>>1]<<2)-(j[t>>1]|0)+(((j[t+8>>1]|0)+(j[t+6>>1]|0)|0)*40|0)+(j[t+12>>1]<<2)-(j[t+14>>1]|0)+(X((j[t+10>>1]|0)+(j[t+4>>1]|0)|0,-11)|0)>>v&65535;d[o>>1]=t;n=n+1|0;if((n|0)==(g|0))break;else o=o+(x<<1)|0}m=m+1|0}while((m|0)!=(q|0));break}case 3:{m=0-w|0;q=n+h|0;if((q|0)>(m|0)?(r=0-o|0,(g|0)>0):0)do{n=0;o=i+(m+w<<1)|0;p=c+((X(m,e)|0)<<1)+(r<<1)|0;while(1){u=p;p=p+2|0;t=(X(j[p>>1]|0,-5)|0)+(j[u>>1]|0)|0;t=t+((j[u+4>>1]|0)*17|0)+((j[u+6>>1]|0)*58|0)+(X(j[u+8>>1]|0,-10)|0)|0;d[o>>1]=t+(j[u+10>>1]<<2)-(j[u+12>>1]|0)>>v;n=n+1|0;if((n|0)==(g|0))break;else o=o+(x<<1)|0}m=m+1|0}while((m|0)!=(q|0));break}default:{}}q=(k|0)==0?v:6;switch(l|0){case 0:{if((g|0)>0&(h|0)>0)p=0;else return;do{m=0;n=a+(p<<1)|0;o=i+((X(p,x)|0)<<1)|0;while(1){d[n>>1]=d[o>>1]|0;m=m+1|0;if((m|0)==(h|0))break;else{n=n+(b<<1)|0;o=o+2|0}}p=p+1|0}while((p|0)!=(g|0));return}case 1:{if((g|0)>0&(h|0)>0)p=0;else return;do{m=0;n=a+(p<<1)|0;o=i+((X(p,x)|0)<<1)|0;while(1){l=o;o=o+2|0;k=(d[o>>1]<<2)-(d[l>>1]|0)+(X(d[l+4>>1]|0,-10)|0)|0;k=k+((d[l+6>>1]|0)*58|0)+((d[l+8>>1]|0)*17|0)+(X(d[l+10>>1]|0,-5)|0)|0;d[n>>1]=k+(d[l+12>>1]|0)>>q;m=m+1|0;if((m|0)==(h|0))break;else n=n+(b<<1)|0}p=p+1|0}while((p|0)!=(g|0));return}case 2:{if((g|0)>0&(h|0)>0)p=0;else return;do{m=0;n=a+(p<<1)|0;o=i+((X(p,x)|0)<<1)|0;while(1){l=o;o=o+2|0;l=(d[o>>1]<<2)-(d[l>>1]|0)+(((d[l+8>>1]|0)+(d[l+6>>1]|0)|0)*40|0)+(d[l+12>>1]<<2)-(d[l+14>>1]|0)+(X((d[l+10>>1]|0)+(d[l+4>>1]|0)|0,-11)|0)>>q&65535;d[n>>1]=l;m=m+1|0;if((m|0)==(h|0))break;else n=n+(b<<1)|0}p=p+1|0}while((p|0)!=(g|0));return}case 3:{if((g|0)>0&(h|0)>0)p=0;else return;do{m=0;n=a+(p<<1)|0;o=i+((X(p,x)|0)<<1)|0;while(1){l=o;o=o+2|0;k=(X(d[o>>1]|0,-5)|0)+(d[l>>1]|0)|0;k=k+((d[l+4>>1]|0)*17|0)+((d[l+6>>1]|0)*58|0)+(X(d[l+8>>1]|0,-10)|0)|0;d[n>>1]=k+(d[l+10>>1]<<2)-(d[l+12>>1]|0)>>q;m=m+1|0;if((m|0)==(h|0))break;else n=n+(b<<1)|0}p=p+1|0}while((p|0)!=(g|0));return}default:return}}function js(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;is(a,b,c,d,e,f,g,0,2,h);return}function ks(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;is(a,b,c,d,e,f,g,0,3,h);return}function ls(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;is(a,b,c,d,e,f,g,1,0,h);return}function ms(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;is(a,b,c,d,e,f,g,1,1,h);return}function ns(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;is(a,b,c,d,e,f,g,1,2,h);return}function os(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;is(a,b,c,d,e,f,g,1,3,h);return}function ps(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;is(a,b,c,d,e,f,g,2,0,h);return}function qs(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;is(a,b,c,d,e,f,g,2,1,h);return}function rs(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;is(a,b,c,d,e,f,g,2,2,h);return}function ss(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;is(a,b,c,d,e,f,g,2,3,h);return}function ts(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;is(a,b,c,d,e,f,g,3,0,h);return}function us(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;is(a,b,c,d,e,f,g,3,1,h);return}function vs(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;is(a,b,c,d,e,f,g,3,2,h);return}function ws(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;is(a,b,c,d,e,f,g,3,3,h);return}function xs(a){a=a|0;var b=0,c=0;b=a+8|0;c=b+48|0;do{f[b>>2]=0;b=b+4|0}while((b|0)<(c|0));f[a>>2]=30;f[a+4>>2]=30;return}function ys(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;n=a+8|0;o=a+12|0;c=f[o>>2]|0;b=f[n>>2]|0;if((c|0)!=(b|0)){e=0;do{d=f[b+(e<<2)>>2]|0;if(d){Us(d);QK(d);b=f[n>>2]|0;c=f[o>>2]|0}e=e+1|0}while(e>>>0<c-b>>2>>>0)}k=a+36|0;c=f[k>>2]|0;j=a+48|0;b=f[j>>2]|0;d=c+(b>>>10<<2)|0;l=a+40|0;i=f[l>>2]|0;e=i;g=c;if((i|0)==(c|0)){h=0;i=a+52|0;b=0}else{i=a+52|0;h=(f[i>>2]|0)+b|0;h=(f[c+(h>>>10<<2)>>2]|0)+((h&1023)<<2)|0;b=(f[d>>2]|0)+((b&1023)<<2)|0}a:while(1){do{if((b|0)==(h|0))break a;b=b+4|0}while((b-(f[d>>2]|0)|0)!=4096);b=d+4|0;d=b;b=f[b>>2]|0}f[i>>2]=0;b=e-g>>2;if(b>>>0>2)do{QK(f[c>>2]|0);c=(f[k>>2]|0)+4|0;f[k>>2]=c;b=(f[l>>2]|0)-c>>2}while(b>>>0>2);switch(b|0){case 1:{b=512;m=14;break}case 2:{b=1024;m=14;break}default:{}}if((m|0)==14)f[j>>2]=b;b=f[k>>2]|0;c=f[l>>2]|0;if((b|0)!=(c|0)){do{QK(f[b>>2]|0);b=b+4|0}while((b|0)!=(c|0));b=f[k>>2]|0;c=f[l>>2]|0;if((c|0)!=(b|0))f[l>>2]=c+(~((c+-4-b|0)>>>2)<<2)}b=f[a+32>>2]|0;if(b|0)QK(b);d=f[a+20>>2]|0;if(d|0){b=a+24|0;c=f[b>>2]|0;if((c|0)!=(d|0))f[b>>2]=c+(~((c+-4-d|0)>>>2)<<2);QK(d)}b=f[n>>2]|0;if(!b)return;c=f[o>>2]|0;if((c|0)!=(b|0))f[o>>2]=c+(~((c+-4-b|0)>>>2)<<2);QK(b);return}function zs(a){a=a|0;return}function As(a,c){a=a|0;c=c|0;var d=0,e=0,g=0;if(c){g=1;return g|0}c=f[a+12>>2]|0;d=f[a+8>>2]|0;g=c-d>>2;e=d;if(g>>>0<(f[a>>2]|0)>>>0){g=1;return g|0}if((c|0)==(d|0)){g=0;return g|0}else c=0;while(1){a=f[e+(c<<2)>>2]|0;if((b[a+100>>0]|0)==0?(f[a+96>>2]|0)==0:0){c=1;d=7;break}c=c+1|0;if(c>>>0>=g>>>0){c=0;d=7;break}}if((d|0)==7)return c|0;return 0}function Bs(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0;a:do if(d){g=a+8|0;h=f[a+12>>2]|0;i=f[g>>2]|0;a=i;if((h|0)==(i|0)){c=-1;return c|0}e=h-i>>2;d=0;while(1){j=f[a+(d<<2)>>2]|0;if(((f[j+92>>2]|0)==(b|0)?(f[j+104>>2]|0)>(c|0):0)?(f[j+96>>2]|0)==2:0)break;d=d+1|0;if(d>>>0>=e>>>0){e=h;d=i;break a}}return d|0}else{g=a+8|0;j=f[g>>2]|0;e=f[a+12>>2]|0;d=j;a=j}while(0);if((e|0)==(d|0)){j=-1;return j|0}else d=0;while(1){j=f[a+(d<<2)>>2]|0;if(((f[j+92>>2]|0)==(b|0)?(f[j+104>>2]|0)>(c|0):0)?f[j+96>>2]|0:0){a=14;break}d=d+1|0;if(d>>>0>=e-(f[g>>2]|0)>>2>>>0){d=-1;a=14;break}}if((a|0)==14)return d|0;return 0}function Cs(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0;a:do if(d){g=a+8|0;h=f[a+12>>2]|0;i=f[g>>2]|0;a=i;if((h|0)==(i|0)){c=-1;return c|0}e=h-i>>2;d=0;while(1){j=f[a+(d<<2)>>2]|0;if(((f[j+88>>2]|0)==(b|0)?(f[j+104>>2]|0)>(c|0):0)?(f[j+96>>2]|0)==2:0)break;d=d+1|0;if(d>>>0>=e>>>0){e=h;d=i;break a}}return d|0}else{g=a+8|0;j=f[g>>2]|0;e=f[a+12>>2]|0;d=j;a=j}while(0);if((e|0)==(d|0)){j=-1;return j|0}else d=0;while(1){j=f[a+(d<<2)>>2]|0;if(((f[j+88>>2]|0)==(b|0)?(f[j+104>>2]|0)>(c|0):0)?f[j+96>>2]|0:0){a=14;break}d=d+1|0;if(d>>>0>=e-(f[g>>2]|0)>>2>>>0){d=-1;a=14;break}}if((a|0)==14)return d|0;return 0}function Ds(a,b){a=a|0;b=b|0;var c=0,d=0;c=f[a+12>>2]|0;a=f[a+8>>2]|0;d=a;if((c|0)==(a|0)){b=-1;return b|0}c=c-a>>2;a=0;while(1){if((f[f[d+(a<<2)>>2]>>2]|0)==(b|0)){c=5;break}a=a+1|0;if(a>>>0>=c>>>0){a=-1;c=5;break}}if((c|0)==5)return a|0;return 0}function Es(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;j=a+20|0;k=f[j>>2]|0;l=a+24|0;b=f[l>>2]|0;if((k|0)==(b|0))Pa(36741,36771,147,36778);h=b-k>>2;if(h>>>0>1){b=0;c=f[(f[k>>2]|0)+92>>2]|0;d=1;while(1){e=f[(f[k+(d<<2)>>2]|0)+92>>2]|0;g=(e|0)<(c|0);b=g?d:b;d=d+1|0;if(d>>>0>=h>>>0){h=b;break}else c=g?e:c}}else h=0;g=a+36|0;b=f[g>>2]|0;m=(f[a+40>>2]|0)-b|0;d=a+48|0;e=f[d>>2]|0;i=a+52|0;c=f[i>>2]|0;if((((m|0)==0?0:(m<<8)+-1|0)|0)==(c+e|0)){Fs(a+32|0);e=f[d>>2]|0;c=f[i>>2]|0;b=f[g>>2]|0}m=c+e|0;f[(f[b+(m>>>10<<2)>>2]|0)+((m&1023)<<2)>>2]=f[k+(h<<2)>>2];f[i>>2]=c+1;f[(f[j>>2]|0)+(h<<2)>>2]=f[(f[l>>2]|0)+-4>>2];f[l>>2]=(f[l>>2]|0)+-4;return}function Fs(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;o=u;u=u+32|0;k=o+4|0;j=o;b=a+16|0;c=f[b>>2]|0;if(c>>>0>1023){f[b>>2]=c+-1024;l=a+4|0;k=f[l>>2]|0;n=f[k>>2]|0;k=k+4|0;f[l>>2]=k;m=a+8|0;i=f[m>>2]|0;j=a+12|0;h=f[j>>2]|0;b=h;g=i;do if((i|0)==(h|0)){c=f[a>>2]|0;d=c;if(k>>>0>c>>>0){b=k;d=((b-d>>2)+1|0)/-2|0;e=k+(d<<2)|0;b=g-b|0;c=b>>2;if(!c)b=k;else{HM(e|0,k|0,b|0)|0;b=f[l>>2]|0}a=e+(c<<2)|0;f[m>>2]=a;f[l>>2]=b+(d<<2);b=a;break}b=b-d>>1;b=(b|0)==0?1:b;if(b>>>0>1073741823){o=Ra(8)|0;VK(o,44736);f[o>>2]=17660;Va(o|0,4016,428)}e=OK(b<<2)|0;g=e;d=e+(b>>>2<<2)|0;h=d;e=e+(b<<2)|0;if((k|0)==(i|0))b=h;else{b=h;c=k;do{f[d>>2]=f[c>>2];d=b+4|0;b=d;c=c+4|0}while((c|0)!=(i|0));c=f[a>>2]|0}f[a>>2]=g;f[l>>2]=h;f[m>>2]=b;f[j>>2]=e;if(c){QK(c);b=f[m>>2]|0}}else b=i;while(0);f[b>>2]=n;f[m>>2]=(f[m>>2]|0)+4;u=o;return}n=a+8|0;b=f[n>>2]|0;m=a+4|0;e=b-(f[m>>2]|0)|0;l=a+12|0;c=f[l>>2]|0;d=c-(f[a>>2]|0)|0;if(e>>>0>=d>>>0){b=d>>1;b=(b|0)==0?1:b;f[k+12>>2]=0;f[k+16>>2]=a+12;if(b>>>0>1073741823){o=Ra(8)|0;VK(o,44736);f[o>>2]=17660;Va(o|0,4016,428)}d=OK(b<<2)|0;f[k>>2]=d;h=d+(e>>2<<2)|0;i=k+8|0;f[i>>2]=h;g=k+4|0;f[g>>2]=h;h=k+12|0;f[h>>2]=d+(b<<2);e=OK(4096)|0;f[j>>2]=e;Is(k,j);e=f[n>>2]|0;while(1){b=f[m>>2]|0;if((e|0)==(b|0))break;j=e+-4|0;Js(k,j);e=j}c=b;d=f[a>>2]|0;f[a>>2]=f[k>>2];f[k>>2]=d;f[m>>2]=f[g>>2];f[g>>2]=c;b=f[n>>2]|0;f[n>>2]=f[i>>2];f[i>>2]=b;a=f[l>>2]|0;f[l>>2]=f[h>>2];f[h>>2]=a;if((b|0)!=(e|0))f[i>>2]=b+(~((b+-4-c|0)>>>2)<<2);if(d|0)QK(d);u=o;return}if((c|0)!=(b|0)){n=OK(4096)|0;f[k>>2]=n;Gs(a,k);u=o;return}j=OK(4096)|0;f[k>>2]=j;Hs(a,k);j=f[m>>2]|0;k=f[j>>2]|0;j=j+4|0;f[m>>2]=j;i=f[n>>2]|0;h=f[l>>2]|0;b=h;g=i;do if((i|0)==(h|0)){c=f[a>>2]|0;d=c;if(j>>>0>c>>>0){b=j;d=((b-d>>2)+1|0)/-2|0;e=j+(d<<2)|0;b=g-b|0;c=b>>2;if(!c)b=j;else{HM(e|0,j|0,b|0)|0;b=f[m>>2]|0}a=e+(c<<2)|0;f[n>>2]=a;f[m>>2]=b+(d<<2);b=a;break}b=b-d>>1;b=(b|0)==0?1:b;if(b>>>0>1073741823){o=Ra(8)|0;VK(o,44736);f[o>>2]=17660;Va(o|0,4016,428)}e=OK(b<<2)|0;g=e;d=e+(b>>>2<<2)|0;h=d;e=e+(b<<2)|0;if((j|0)==(i|0))b=h;else{b=h;c=j;do{f[d>>2]=f[c>>2];d=b+4|0;b=d;c=c+4|0}while((c|0)!=(i|0));c=f[a>>2]|0}f[a>>2]=g;f[m>>2]=h;f[n>>2]=b;f[l>>2]=e;if(c){QK(c);b=f[n>>2]|0}}else b=i;while(0);f[b>>2]=k;f[n>>2]=(f[n>>2]|0)+4;u=o;return}function Gs(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=a+8|0;j=f[n>>2]|0;k=a+12|0;m=f[k>>2]|0;e=m;h=j;do if((j|0)==(m|0)){m=a+4|0;l=f[m>>2]|0;d=f[a>>2]|0;c=d;if(l>>>0>d>>>0){d=l;e=((d-c>>2)+1|0)/-2|0;g=l+(e<<2)|0;c=h-d|0;d=c>>2;if(!d)c=l;else{HM(g|0,l|0,c|0)|0;c=f[m>>2]|0}l=g+(d<<2)|0;f[n>>2]=l;f[m>>2]=c+(e<<2);c=l;break}c=e-c>>1;c=(c|0)==0?1:c;if(c>>>0>1073741823){n=Ra(8)|0;VK(n,44736);f[n>>2]=17660;Va(n|0,4016,428)}g=OK(c<<2)|0;h=g;e=g+(c>>>2<<2)|0;i=e;g=g+(c<<2)|0;if((l|0)==(j|0))c=i;else{c=i;d=l;do{f[e>>2]=f[d>>2];e=c+4|0;c=e;d=d+4|0}while((d|0)!=(j|0));d=f[a>>2]|0}f[a>>2]=h;f[m>>2]=i;f[n>>2]=c;f[k>>2]=g;if(d){QK(d);c=f[n>>2]|0}}else c=j;while(0);f[c>>2]=f[b>>2];f[n>>2]=(f[n>>2]|0)+4;return}function Hs(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;o=a+4|0;m=f[o>>2]|0;n=f[a>>2]|0;e=n;do if((m|0)==(n|0)){n=a+8|0;d=f[n>>2]|0;l=a+12|0;k=f[l>>2]|0;c=k;if(d>>>0<k>>>0){e=d;h=((c-e>>2)+1|0)/2|0;c=d+(h<<2)|0;e=e-m|0;l=e>>2;g=c+(0-l<<2)|0;if(l){HM(g|0,m|0,e|0)|0;c=g;d=f[n>>2]|0}f[o>>2]=c;f[n>>2]=d+(h<<2);break}e=c-e>>1;e=(e|0)==0?1:e;if(e>>>0>1073741823){o=Ra(8)|0;VK(o,44736);f[o>>2]=17660;Va(o|0,4016,428)}i=OK(e<<2)|0;j=i;c=i+((e+3|0)>>>2<<2)|0;k=c;i=i+(e<<2)|0;if((m|0)==(d|0)){e=k;d=m}else{h=c;e=k;g=m;do{f[h>>2]=f[g>>2];h=e+4|0;e=h;g=g+4|0}while((g|0)!=(d|0));d=f[a>>2]|0}f[a>>2]=j;f[o>>2]=k;f[n>>2]=e;f[l>>2]=i;if(d){QK(d);c=f[o>>2]|0}}else c=m;while(0);f[c+-4>>2]=f[b>>2];f[o>>2]=(f[o>>2]|0)+-4;return}function Is(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=a+8|0;j=f[n>>2]|0;k=a+12|0;m=f[k>>2]|0;e=m;h=j;do if((j|0)==(m|0)){m=a+4|0;l=f[m>>2]|0;d=f[a>>2]|0;c=d;if(l>>>0>d>>>0){d=l;e=((d-c>>2)+1|0)/-2|0;g=l+(e<<2)|0;c=h-d|0;d=c>>2;if(!d)c=l;else{HM(g|0,l|0,c|0)|0;c=f[m>>2]|0}l=g+(d<<2)|0;f[n>>2]=l;f[m>>2]=c+(e<<2);c=l;break}c=e-c>>1;c=(c|0)==0?1:c;if(c>>>0>1073741823){n=Ra(8)|0;VK(n,44736);f[n>>2]=17660;Va(n|0,4016,428)}g=OK(c<<2)|0;h=g;e=g+(c>>>2<<2)|0;i=e;g=g+(c<<2)|0;if((l|0)==(j|0))c=i;else{c=i;d=l;do{f[e>>2]=f[d>>2];e=c+4|0;c=e;d=d+4|0}while((d|0)!=(j|0));d=f[a>>2]|0}f[a>>2]=h;f[m>>2]=i;f[n>>2]=c;f[k>>2]=g;if(d){QK(d);c=f[n>>2]|0}}else c=j;while(0);f[c>>2]=f[b>>2];f[n>>2]=(f[n>>2]|0)+4;return}function Js(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;o=a+4|0;m=f[o>>2]|0;n=f[a>>2]|0;e=n;do if((m|0)==(n|0)){n=a+8|0;d=f[n>>2]|0;l=a+12|0;k=f[l>>2]|0;c=k;if(d>>>0<k>>>0){e=d;h=((c-e>>2)+1|0)/2|0;c=d+(h<<2)|0;e=e-m|0;l=e>>2;g=c+(0-l<<2)|0;if(l){HM(g|0,m|0,e|0)|0;c=g;d=f[n>>2]|0}f[o>>2]=c;f[n>>2]=d+(h<<2);break}e=c-e>>1;e=(e|0)==0?1:e;if(e>>>0>1073741823){o=Ra(8)|0;VK(o,44736);f[o>>2]=17660;Va(o|0,4016,428)}i=OK(e<<2)|0;j=i;c=i+((e+3|0)>>>2<<2)|0;k=c;i=i+(e<<2)|0;if((m|0)==(d|0)){e=k;d=m}else{h=c;e=k;g=m;do{f[h>>2]=f[g>>2];h=e+4|0;e=h;g=g+4|0}while((g|0)!=(d|0));d=f[a>>2]|0}f[a>>2]=j;f[o>>2]=k;f[n>>2]=e;f[l>>2]=i;if(d){QK(d);c=f[o>>2]|0}}else c=m;while(0);f[c+-4>>2]=f[b>>2];f[o>>2]=(f[o>>2]|0)+-4;return}function Ks(a){a=a|0;var b=0,c=0;b=a+20|0;c=a+24|0;if((f[b>>2]|0)==(f[c>>2]|0)){c=0;return c|0}do Es(a);while((f[b>>2]|0)!=(f[c>>2]|0));a=1;return a|0}function Ls(a,c,d,e,g,h,i){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0;v=u;u=u+16|0;r=v;t=a+8|0;s=a+12|0;k=f[s>>2]|0;m=f[t>>2]|0;o=m;j=k;a:do if((k|0)==(m|0)){l=-1;m=k}else{p=k-m>>2;l=0;while(1){n=f[o+(l<<2)>>2]|0;if((b[n+100>>0]|0)==0?(f[n+96>>2]|0)==0:0)break;l=l+1|0;if(l>>>0>=p>>>0){l=-1;break a}}Ts(n);j=f[s>>2]|0;m=f[t>>2]|0;k=j}while(0);p=k-m>>2;if((!((l|0)==(p+-1|0)?1:p>>>0<=(f[a+4>>2]|0)>>>0)?(q=f[j+-4>>2]|0,(b[q+100>>0]|0)==0):0)?(f[q+96>>2]|0)==0:0){k=f[j+-4>>2]|0;if(k){Us(k);QK(k);j=f[s>>2]|0}j=j+-4|0;f[s>>2]=j}else j=k;if((l|0)==-1){l=j-(f[t>>2]|0)>>2;j=OK(10624)|0;Rs(j);f[r>>2]=j;k=f[s>>2]|0;if(k>>>0<(f[a+16>>2]|0)>>>0){f[k>>2]=j;f[s>>2]=(f[s>>2]|0)+4}else Ms(t,r)}j=f[(f[t>>2]|0)+(l<<2)>>2]|0;k=f[c+476>>2]|0;if(k>>>0<4){Ss(j,f[c+484>>2]|0,f[c+488>>2]|0,k,c,1,d,0,e,g,h,i)|0;b[j+10516>>0]=0;u=v;return l|0}else Pa(44673,36771,259,36816);return 0}function Ms(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0;i=a+4|0;j=f[a>>2]|0;k=(f[i>>2]|0)-j|0;h=k>>2;c=h+1|0;if(c>>>0>1073741823)$I(a);l=a+8|0;g=(f[l>>2]|0)-j|0;d=g>>1;d=g>>2>>>0<536870911?(d>>>0<c>>>0?c:d):1073741823;do if(d)if(d>>>0>1073741823){l=Ra(8)|0;VK(l,44736);f[l>>2]=17660;Va(l|0,4016,428)}else{g=OK(d<<2)|0;break}else g=0;while(0);e=g+(h<<2)|0;f[e>>2]=f[b>>2];c=e+(0-h<<2)|0;if((k|0)>0)GM(c|0,j|0,k|0)|0;f[a>>2]=c;f[i>>2]=e+4;f[l>>2]=g+(d<<2);if(!j)return;QK(j);return}function Ns(a){a=a|0;var b=0,c=0;b=a+36|0;c=a+48|0;a=a+52|0;f[a>>2]=(f[a>>2]|0)+-1;a=(f[c>>2]|0)+1|0;f[c>>2]=a;if(a>>>0<=2047)return;QK(f[f[b>>2]>>2]|0);f[b>>2]=(f[b>>2]|0)+4;f[c>>2]=(f[c>>2]|0)+-1024;return}function Os(a){a=a|0;return}function Ps(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0;a=f[b+4>>2]|0;d=f[b+8>>2]|0;g=(d|0)/(f[c+5784>>2]|0)|0;b=f[b+12>>2]|0;k=a+-1+b|0;k=k-((k|0)%(b|0)|0)|0;a=((a|0)/(f[c+5780>>2]|0)|0)+-1+b|0;b=a-((a|0)%(b|0)|0)|0;a=f[c+5760>>2]|0;if((a+-8|0)>>>0>=9)Pa(36826,36880,115,36889);e=f[c+5768>>2]|0;if((e+-8|0)>>>0>=9)Pa(36912,36880,116,36889);h=ix(16,X(X(k,d)|0,(a+7|0)/8|0)|0)|0;i=(h|0)==0;j=h;if(!(f[c+20>>2]|0))if(i){c=0;return c|0}else{b=0;d=0;a=0}else{g=X(X(b,g)|0,(e+7|0)/8|0)|0;e=ix(16,g)|0;g=ix(16,g)|0;d=e;a=g;if(i|((e|0)==0|(g|0)==0)){if(!i)ex(h);if(e|0)ex(e);if(!g){c=0;return c|0}ex(g);c=0;return c|0}}f[c+4>>2]=j;f[c+10492>>2]=0;f[c+40>>2]=k;f[c+8>>2]=d;f[c+10496>>2]=0;f[c+12>>2]=a;f[c+10500>>2]=0;f[c+44>>2]=b;c=1;return c|0}function Qs(a,b,c){a=a|0;b=b|0;c=c|0;a=f[b+4>>2]|0;if(a|0)ex(a);a=f[b+8>>2]|0;if(a|0)ex(a);a=f[b+12>>2]|0;if(!a)return;ex(a);return}function Rs(a){a=a|0;var c=0;f[a+48>>2]=0;f[a+52>>2]=0;f[a+56>>2]=0;f[a+700>>2]=0;f[a+704>>2]=0;f[a+708>>2]=0;c=a+736|0;f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;f[c+12>>2]=0;f[c+16>>2]=0;f[c+20>>2]=0;Ku(a+764|0);Nt(a+5932|0);b[a+10518>>0]=0;b[a+10519>>0]=0;b[a+10520>>0]=0;IM(a+10340|0,0,140)|0;f[a>>2]=-1;f[a+104>>2]=0;f[a+10332>>2]=0;f[a+10336>>2]=0;f[a+10512>>2]=0;f[a+4>>2]=0;f[a+60>>2]=0;f[a+8>>2]=0;f[a+64>>2]=0;f[a+12>>2]=0;f[a+68>>2]=0;f[a+28>>2]=0;f[a+24>>2]=0;c=a+10480|0;f[a+10524>>2]=0;f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;f[c+12>>2]=0;f[c+16>>2]=0;f[c+20>>2]=0;b[a+10516>>0]=2;f[a+88>>2]=-1;f[a+92>>2]=-1;f[a+96>>2]=0;b[a+100>>0]=0;c=a+10528|0;f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;f[c+12>>2]=0;f[c+16>>2]=0;Vu(a+10548|0);Zu(a+10576|0);return}function Ss(a,c,d,e,g,h,i,j,k,l,m,n){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;var o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0;z=u;u=u+48|0;x=z;if(!g)Pa(36966,36880,240,36970);q=a+764|0;GM(q|0,g|0,4717)|0;if((q|0)!=(g|0))qq(a+5484|0,f[g+4720>>2]|0,f[g+4724>>2]|0);GM(a+5496|0,g+4732|0,436)|0;Ts(a);p=f[14382]|0;f[14382]=p+1;f[a>>2]=p;f[a+104>>2]=2147483647;f[a+10332>>2]=i;f[a+10336>>2]=j;f[a+20>>2]=e;f[a+24>>2]=c;f[a+28>>2]=d;p=a+32|0;f[p>>2]=c;q=a+36|0;f[q>>2]=d;f[a+10488>>2]=m;m=a+10480|0;f[m>>2]=k;f[m+4>>2]=l;switch(e|0){case 3:case 0:{t=1;o=1;break}case 1:{o=2;y=8;break}case 2:{o=1;y=8;break}default:Pa(44673,36880,276,36970)}if((y|0)==8)t=2;switch(e|0){case 1:{f[x>>2]=2;r=(c+1|0)/2|0;f[p>>2]=r;s=(d+1|0)/2|0;f[q>>2]=s;break}case 2:{f[x>>2]=3;r=(c+1|0)/2|0;f[p>>2]=r;s=d;break}case 3:{f[x>>2]=4;r=c;s=d;break}case 0:{f[x>>2]=1;f[p>>2]=0;f[q>>2]=0;r=0;s=0;break}default:Pa(55956,36880,302,36970)}f[x+4>>2]=c;f[x+8>>2]=d;f[x+12>>2]=16;e=f[g+496>>2]|0;k=f[g+500>>2]|0;p=f[g+504>>2]|0;q=f[g+508>>2]|0;A=k+e|0;c=c-(X(A,t)|0)|0;f[a+72>>2]=c;l=q+p|0;m=d-(X(l,o)|0)|0;f[a+76>>2]=m;f[a+80>>2]=r-A;f[a+84>>2]=s-l;l=X(e,t)|0;f[x+16>>2]=l;k=X(k,t)|0;f[x+20>>2]=k;k=X(p,o)|0;f[x+24>>2]=k;t=X(q,o)|0;f[x+28>>2]=t;f[x+32>>2]=c;f[x+36>>2]=m;b[a+16>>0]=(f[g+4996>>2]|0)>8&1;m=(f[g+5004>>2]|0)>8&1;b[a+17>>0]=m;b[a+18>>0]=m;m=(i|0)==0;if(m)o=0;else o=f[i+544>>2]|0;do if(!j)if(m|n^1)y=24;else{y=i+536|0;w=f[y>>2]|0;y=f[y+4>>2]|0;v=a+10504|0;f[v>>2]=w;f[v+4>>2]=y;v=o;y=25}else{o=f[j+3060>>2]|0;if(n){A=f[j+3064>>2]|0;f[a+10512>>2]=A;m=a+10504|0;if(!A){y=7736;w=f[y>>2]|0;y=f[y+4>>2]|0;v=m;f[v>>2]=w;f[v+4>>2]=y;v=o;y=25;break}else{f[m>>2]=0;f[a+10508>>2]=0;break}}else y=24}while(0);if((y|0)==24){A=7736;w=f[A>>2]|0;A=f[A+4>>2]|0;v=a+10504|0;f[v>>2]=w;f[v+4>>2]=A;v=o;y=25}if(((y|0)==25?w|0:0)?(A=(Xc[w&7](i,x,a,v)|0)==0,i=(f[a+4>>2]|0)+l+(X(f[a+40>>2]|0,k)|0)|0,f[a+60>>2]=i,i=X(f[a+44>>2]|0,p)|0,f[a+64>>2]=(f[a+8>>2]|0)+e+i,f[a+68>>2]=(f[a+12>>2]|0)+e+i,A):0){A=7;u=z;return A|0}do if(h){c=g+5112|0;e=f[c>>2]|0;r=g+5116|0;p=f[r>>2]|0;s=g+5108|0;q=f[s>>2]|0;k=X(p,e)|0;l=a+10404|0;m=a+10400|0;o=f[m>>2]|0;do if((k|0)!=(f[l>>2]|0)){ex(o);o=dx(k)|0;f[m>>2]=o;if(!o){f[l>>2]=0;d=0;break}else{f[l>>2]=k;y=32;break}}else y=32;while(0);if((y|0)==32){f[a+10412>>2]=e;f[a+10416>>2]=p;f[a+10408>>2]=q;d=(o|0)!=0}q=f[c>>2]|0;p=f[r>>2]|0;e=f[s>>2]|0;k=X(p,q)|0;l=a+10424|0;m=a+10420|0;o=f[m>>2]|0;do if((k|0)!=(f[l>>2]|0)){ex(o);o=dx(k)|0;f[m>>2]=o;if(!o){f[l>>2]=0;o=0;break}else{f[l>>2]=k;y=37;break}}else y=37;while(0);if((y|0)==37){f[a+10432>>2]=q;f[a+10436>>2]=p;f[a+10428>>2]=e;o=(o|0)!=0}c=d&o;m=a+10360|0;d=g+5052|0;e=f[d>>2]|0;s=g+5060|0;p=f[s>>2]|0;r=g+5036|0;q=f[r>>2]|0;k=X(p,e)|0;l=a+10364|0;do if((k|0)!=(f[l>>2]|0)){ex(f[m>>2]|0);o=dx(k*3|0)|0;f[m>>2]=o;if(!o){f[l>>2]=0;o=0;break}else{f[l>>2]=k;y=43;break}}else{o=f[m>>2]|0;y=43}while(0);if((y|0)==43){f[a+10372>>2]=e;f[a+10376>>2]=p;f[a+10368>>2]=q;o=(o|0)!=0}q=c&o;e=(f[r>>2]|0)+-2|0;p=f[d>>2]<<e;e=f[s>>2]<<e;m=a+10380|0;k=X(e,p)|0;l=a+10384|0;do if((k|0)!=(f[l>>2]|0)){ex(f[m>>2]|0);o=dx(k*12|0)|0;f[m>>2]=o;if(!o){f[l>>2]=0;o=0;break}else{f[l>>2]=k;y=49;break}}else{o=f[m>>2]|0;y=49}while(0);if((y|0)==49){f[a+10392>>2]=p;f[a+10396>>2]=e;f[a+10388>>2]=2;o=(o|0)!=0}c=q&o;e=f[g+5088>>2]|0;p=f[g+5092>>2]|0;q=f[g+5100>>2]|0;k=X(p,e)|0;l=a+10444|0;m=a+10440|0;o=f[m>>2]|0;do if((k|0)!=(f[l>>2]|0)){ex(o);o=dx(k)|0;f[m>>2]=o;if(!o){f[l>>2]=0;o=0;break}else{f[l>>2]=k;y=54;break}}else y=54;while(0);if((y|0)==54){f[a+10452>>2]=e;f[a+10456>>2]=p;f[a+10448>>2]=q;o=(o|0)!=0}q=c&o;e=((f[g+484>>2]|0)+3|0)/4|0;p=((f[g+488>>2]|0)+3|0)/4|0;k=X(p,e)|0;l=a+10464|0;m=a+10460|0;o=f[m>>2]|0;do if((k|0)!=(f[l>>2]|0)){ex(o);o=dx(k)|0;f[m>>2]=o;if(!o){f[l>>2]=0;o=0;break}else{f[l>>2]=k;y=59;break}}else y=59;while(0);if((y|0)==59){f[a+10472>>2]=e;f[a+10476>>2]=p;f[a+10468>>2]=2;o=(o|0)!=0}d=q&o;q=a+10340|0;c=a+10344|0;o=f[c>>2]|0;if((o|0)==(f[g+5072>>2]|0)){if(d)break;else o=7;u=z;return o|0}r=a+10524|0;k=f[r>>2]|0;if(k){m=k+-4|0;o=f[m>>2]|0;if(o|0){o=k+(o*80|0)|0;do{o=o+-80|0;cv(o)}while((o|0)!=(k|0))}RK(m);o=f[c>>2]|0}e=f[g+5056>>2]|0;p=f[g+5064>>2]|0;l=f[g+5040>>2]|0;m=X(p,e)|0;do if((m|0)!=(o|0)){ex(f[q>>2]|0);o=dx(m*24|0)|0;f[q>>2]=o;if(!o){f[c>>2]=0;o=0;m=0;break}else{f[c>>2]=m;k=o;y=71;break}}else{k=f[q>>2]|0;m=o;y=71}while(0);if((y|0)==71){f[a+10352>>2]=e;f[a+10356>>2]=p;f[a+10348>>2]=l;o=(k|0)!=0}k=d&o;l=m*80|0;l=PK(m>>>0>53687091|l>>>0>4294967291?-1:l+4|0)|0;f[l>>2]=m;l=l+4|0;if(m|0){o=l+(m*80|0)|0;m=l;do{bv(m);m=m+80|0}while((m|0)!=(o|0))}f[r>>2]=l;if(!k){A=7;u=z;return A|0}}while(0);A=0;u=z;return A|0}function Ts(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0,i=0;d=a+4|0;if(f[d>>2]|0){b=f[a+10512>>2]|0;if(!b){b=f[a+10332>>2]|0;if(!b)c=0;else c=f[b+544>>2]|0;fd[f[a+10508>>2]&127](b,a,c)}else{i=f[a+10336>>2]|0;fd[b&127](i,a,f[i+3060>>2]|0)}f[d>>2]=0;f[a+60>>2]=0;f[a+8>>2]=0;f[a+64>>2]=0;f[a+12>>2]=0;f[a+68>>2]=0}h=a+48|0;i=a+52|0;c=f[i>>2]|0;a=f[h>>2]|0;d=a;b=c;if((c|0)!=(a|0)){g=0;do{e=f[d+(g<<2)>>2]|0;if(e){b=f[e+1344>>2]|0;if(b|0){c=e+1348|0;d=f[c>>2]|0;if((d|0)!=(b|0))f[c>>2]=d+(~((d+-4-b|0)>>>2)<<2);QK(b)}bw(e+1332|0);b=f[e+776>>2]|0;if(b|0){c=e+780|0;d=f[c>>2]|0;if((d|0)!=(b|0))f[c>>2]=d+(~((d+-4-b|0)>>>2)<<2);QK(b)}QK(e);b=f[i>>2]|0;a=f[h>>2]|0;c=b}g=g+1|0;d=a}while(g>>>0<c-a>>2>>>0);c=a}if((b|0)==(d|0))return;f[i>>2]=b+(~((b+-4-c|0)>>>2)<<2);return}function Us(a){a=a|0;var b=0,c=0,d=0,e=0,g=0;Ts(a);c=f[a+10524>>2]|0;if(c|0){d=c+-4|0;b=f[d>>2]|0;if(b|0){b=c+(b*80|0)|0;do{b=b+-80|0;cv(b)}while((b|0)!=(c|0))}RK(d)}_u(a+10576|0);Wu(a+10548|0);ex(f[a+10460>>2]|0);ex(f[a+10440>>2]|0);ex(f[a+10420>>2]|0);ex(f[a+10400>>2]|0);ex(f[a+10380>>2]|0);ex(f[a+10360>>2]|0);ex(f[a+10340>>2]|0);Pt(a+5932|0);Lu(a+764|0);b=f[a+748>>2]|0;if(b|0){c=a+752|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b)}b=f[a+736>>2]|0;if(b|0){c=a+740|0;d=f[c>>2]|0;if((d|0)!=(b|0))f[c>>2]=d+(~((d+-2-b|0)>>>1)<<1);QK(b)}e=a+700|0;b=f[e>>2]|0;if(b|0){g=a+704|0;c=f[g>>2]|0;if((c|0)!=(b|0)){do{c=c+-12|0;f[g>>2]=c;d=f[c>>2]|0;if(d){QK(d);c=f[g>>2]|0}}while((c|0)!=(b|0));b=f[e>>2]|0}QK(b)}d=f[a+48>>2]|0;if(!d)return;b=a+52|0;c=f[b>>2]|0;if((c|0)!=(d|0))f[b>>2]=c+(~((c+-4-d|0)>>>2)<<2);QK(d);return}function Vs(a){a=a|0;ex(f[a>>2]|0);return}function Ws(a){a=a|0;ex(f[a>>2]|0);return}function Xs(a){a=a|0;ex(f[a>>2]|0);return}function Ys(a){a=a|0;ex(f[a>>2]|0);return}function Zs(a){a=a|0;var b=0,c=0,d=0,e=0;b=f[a+640>>2]|0;if(b|0){c=a+644|0;if((f[c>>2]|0)!=(b|0))f[c>>2]=b;QK(b)}d=f[a+628>>2]|0;if(d|0){b=a+632|0;c=f[b>>2]|0;if((c|0)!=(d|0))f[b>>2]=c+(~((c+-2-d|0)>>>1)<<1);QK(d)}e=a+592|0;b=f[e>>2]|0;if(!b)return;a=a+596|0;c=f[a>>2]|0;if((c|0)!=(b|0)){do{c=c+-12|0;f[a>>2]=c;d=f[c>>2]|0;if(d){QK(d);c=f[a>>2]|0}}while((c|0)!=(b|0));b=f[e>>2]|0}QK(b);return}function _s(a){a=a|0;var b=0,c=0;c=f[a>>2]|0;if(!c)return;a=a+4|0;b=f[a>>2]|0;if((b|0)!=(c|0))f[a>>2]=b+(~((b+-4-c|0)>>>2)<<2);QK(c);return}function $s(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;if((b|0)>-1)IM(f[a+4>>2]|0,b&255|0,X(f[a+28>>2]|0,f[a+40>>2]|0)|0)|0;if((c|0)>-1)IM(f[a+8>>2]|0,c&255|0,X(f[a+36>>2]|0,f[a+44>>2]|0)|0)|0;if((d|0)<=-1)return;IM(f[a+12>>2]|0,d&255|0,X(f[a+36>>2]|0,f[a+44>>2]|0)|0)|0;return}function at(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;k=f[b+28>>2]|0;k=(k|0)<(d|0)?k:d;if(c&1|0)Pa(36982,36880,535,36997);if(k&1|0)Pa(37013,36880,536,36997);g=((f[a+5760>>2]|0)+7|0)/8|0;o=((f[a+5768>>2]|0)+7|0)/8|0;h=b+40|0;d=f[h>>2]|0;i=a+40|0;e=f[i>>2]|0;if((d|0)!=(e|0)){if((k|0)>(c|0)?(l=a+4|0,m=b+4|0,n=b+24|0,j=X(g,c)|0,e=(f[l>>2]|0)+(X(j,e)|0)|0,j=(f[m>>2]|0)+(X(j,d)|0)|0,GM(e|0,j|0,X(f[n>>2]|0,g)|0)|0,j=c+1|0,(j|0)<(k|0)):0){d=j;do{j=X(d,g)|0;e=(f[l>>2]|0)+(X(j,f[i>>2]|0)|0)|0;j=(f[m>>2]|0)+(X(j,f[h>>2]|0)|0)|0;GM(e|0,j|0,X(f[n>>2]|0,g)|0)|0;d=d+1|0}while((d|0)<(k|0))}}else{n=(f[a+4>>2]|0)+(X(X(g,c)|0,d)|0)|0;GM(n|0,(f[b+4>>2]|0)+(X(X(d,c)|0,g)|0)|0,X(X(g,k-c|0)|0,d)|0)|0}j=f[b+5784>>2]|0;d=(c|0)/(j|0)|0;j=(k|0)/(j|0)|0;if(!(f[b+20>>2]|0))return;k=b+44|0;e=f[k>>2]|0;c=a+44|0;g=f[c>>2]|0;if((e|0)==(g|0)){m=X(d,o)|0;l=X(m,e)|0;n=X(j-d|0,o)|0;GM((f[a+8>>2]|0)+l|0,(f[b+8>>2]|0)+l|0,X(n,e)|0)|0;o=f[c>>2]|0;m=X(m,o)|0;GM((f[a+12>>2]|0)+m|0,(f[b+12>>2]|0)+m|0,X(n,o)|0)|0;return}if((j|0)<=(d|0))return;l=a+8|0;m=b+8|0;n=b+32|0;i=a+12|0;h=b+12|0;while(1){b=X(d,o)|0;g=(f[l>>2]|0)+(X(b,g)|0)|0;a=(f[m>>2]|0)+(X(b,e)|0)|0;GM(g|0,a|0,X(f[n>>2]|0,o)|0)|0;a=(f[i>>2]|0)+(X(b,f[c>>2]|0)|0)|0;b=(f[h>>2]|0)+(X(b,f[k>>2]|0)|0)|0;GM(a|0,b|0,X(f[n>>2]|0,o)|0)|0;d=d+1|0;if((d|0)==(j|0))break;g=f[c>>2]|0;e=f[k>>2]|0}return}function bt(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0;c=a+4|0;g=b+4|0;d=f[c>>2]|0;f[c>>2]=f[g>>2];f[g>>2]=d;g=a+60|0;d=b+60|0;c=f[g>>2]|0;f[g>>2]=f[d>>2];f[d>>2]=c;d=a+10492|0;c=b+10492|0;g=f[d>>2]|0;f[d>>2]=f[c>>2];f[c>>2]=g;c=a+8|0;g=b+8|0;d=f[c>>2]|0;f[c>>2]=f[g>>2];f[g>>2]=d;g=a+64|0;d=b+64|0;c=f[g>>2]|0;f[g>>2]=f[d>>2];f[d>>2]=c;d=a+10496|0;c=b+10496|0;g=f[d>>2]|0;f[d>>2]=f[c>>2];f[c>>2]=g;c=a+12|0;g=b+12|0;d=f[c>>2]|0;f[c>>2]=f[g>>2];f[g>>2]=d;g=a+68|0;d=b+68|0;c=f[g>>2]|0;f[g>>2]=f[d>>2];f[d>>2]=c;d=a+10500|0;c=b+10500|0;g=f[d>>2]|0;f[d>>2]=f[c>>2];f[c>>2]=g;c=a+40|0;g=b+40|0;d=f[c>>2]|0;f[c>>2]=f[g>>2];f[g>>2]=d;g=a+44|0;d=b+44|0;c=f[g>>2]|0;f[g>>2]=f[d>>2];f[d>>2]=c;d=a+10504|0;b=b+10504|0;a=d;c=f[a>>2]|0;a=f[a+4>>2]|0;g=b;e=f[g+4>>2]|0;f[d>>2]=f[g>>2];f[d+4>>2]=e;f[b>>2]=c;f[b+4>>2]=a;return}function ct(a,b){a=a|0;b=b|0;var c=0,d=0;c=a+10548|0;Xu(c);d=a+10528|0;f[d>>2]=(f[d>>2]|0)+b;a=a+10544|0;f[a>>2]=(f[a>>2]|0)+b;Yu(c);return}function dt(a,b){a=a|0;b=b|0;var c=0;b=a+10548|0;Xu(b);c=a+10528|0;f[c>>2]=(f[c>>2]|0)+-1;a=a+10532|0;f[a>>2]=(f[a>>2]|0)+1;Yu(b);return}function et(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;b=a+10548|0;Xu(b);e=a+10532|0;d=f[e>>2]|0;f[e>>2]=d+-1;e=a+10540|0;c=(f[e>>2]|0)+1|0;f[e>>2]=c;if((d|0)<=0)Pa(37026,36880,642,37047);if((c|0)!=(f[a+10544>>2]|0)){Yu(b);return}$u(a+10576|0,b);Yu(b);return}function ft(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;gt(a,b,(X(f[a+5820>>2]|0,d)|0)+c|0,e);return}function gt(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0;if(!b)return;c=(f[a+10524>>2]|0)+(c*80|0)|0;if((gv(c)|0)>=(d|0))return;e=a+10548|0;Xu(e);g=a+10532|0;f[g>>2]=(f[g>>2]|0)+-1;a=a+10536|0;f[a>>2]=(f[a>>2]|0)+1;Yu(e);b=b+4|0;f[b>>2]=2;dv(c,d);f[b>>2]=1;Xu(e);f[a>>2]=(f[a>>2]|0)+-1;f[g>>2]=(f[g>>2]|0)+1;Yu(e);return}function ht(a){a=a|0;var b=0,c=0,d=0;b=a+10548|0;Xu(b);c=a+10540|0;d=a+10544|0;if((f[c>>2]|0)==(f[d>>2]|0)){Yu(b);return}a=a+10576|0;do av(a,b);while((f[c>>2]|0)!=(f[d>>2]|0));Yu(b);return}function it(a){a=a|0;var b=0,c=0;b=f[a+10360>>2]|0;if(b|0)IM(b|0,0,(f[a+10364>>2]|0)*3|0)|0;b=f[a+10340>>2]|0;if(b|0)IM(b|0,0,(f[a+10344>>2]|0)*24|0)|0;b=f[a+10460>>2]|0;if(b|0)IM(b|0,0,f[a+10464>>2]|0)|0;c=f[a+10344>>2]|0;if((c|0)<=0)return;a=f[a+10524>>2]|0;b=0;do{f[a+(b*80|0)>>2]=0;b=b+1|0}while((b|0)<(c|0));return}function jt(a,b,c,e,g,h){a=a|0;b=b|0;c=c|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0;m=b>>2;l=c>>2;k=e>>2;j=g>>2;i=f[a+10392>>2]|0;if((j|0)<=0)return;e=a+10380|0;if((k|0)>0)b=0;else return;do{g=(X(b+l|0,i)|0)+m|0;c=0;do{a=(f[e>>2]|0)+((g+c|0)*12|0)|0;d[a>>1]=d[h>>1]|0;d[a+2>>1]=d[h+2>>1]|0;d[a+4>>1]=d[h+4>>1]|0;d[a+6>>1]=d[h+6>>1]|0;d[a+8>>1]=d[h+8>>1]|0;d[a+10>>1]=d[h+10>>1]|0;c=c+1|0}while((c|0)!=(k|0));b=b+1|0}while((b|0)!=(j|0));return}function kt(a,b,c,e,g){a=a|0;b=b|0;c=c|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0;if((g|e|0)<0){a=0;return a|0}if((f[a+1248>>2]|0)<=(e|0)){a=0;return a|0}if((f[a+1252>>2]|0)<=(g|0)){a=0;return a|0}i=f[a+5864>>2]|0;k=f[a+5852>>2]|0;h=(X(g>>i,k)|0)+(e>>i)|0;j=f[a+10320>>2]|0;i=j+((X(c>>i,k)|0)+(b>>i)<<2)|0;if((f[j+(h<<2)>>2]|0)>(f[i>>2]|0)){k=0;return k|0}k=f[a+5804>>2]|0;i=b>>k;h=c>>k;c=e>>k;b=g>>k;k=f[a+10352>>2]|0;j=(X(k,h)|0)+i|0;g=f[a+10340>>2]|0;k=g+(((X(k,b)|0)+c|0)*24|0)|0;if((d[g+(j*24|0)>>1]|0)!=(d[k>>1]|0)){k=0;return k|0}k=f[a+5820>>2]|0;j=(X(k,h)|0)+i|0;a=f[a+10308>>2]|0;k=a+((X(k,b)|0)+c<<2)|0;k=(f[a+(j<<2)>>2]|0)==(f[k>>2]|0);return k|0}function lt(a,b,c,e,g,i,j,k,l,m,n){a=a|0;b=b|0;c=c|0;e=e|0;g=g|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;if((e+c|0)>(n|0)&(((e+b|0)<=(m|0)|(b|0)>(m|0)|(c|0)>(n|0))^1)){if((j<<1|0)==(e|0)?!((j+b|0)<=(m|0)|((l|0)!=1|(k<<1|0)!=(e|0)|(k+c|0)>(n|0))):0)return 0}else{if((n|m|0)<0)return 0;if((f[a+1248>>2]|0)<=(m|0))return 0;if((f[a+1252>>2]|0)<=(n|0))return 0;l=f[a+5864>>2]|0;e=f[a+5852>>2]|0;k=(X(n>>l,e)|0)+(m>>l)|0;j=f[a+10320>>2]|0;l=j+((X(i>>l,e)|0)+(g>>l)<<2)|0;if((f[j+(k<<2)>>2]|0)>(f[l>>2]|0))return 0;e=f[a+5804>>2]|0;g=g>>e;b=i>>e;c=m>>e;e=n>>e;i=f[a+10352>>2]|0;l=(X(i,b)|0)+g|0;k=f[a+10340>>2]|0;i=k+(((X(i,e)|0)+c|0)*24|0)|0;if((d[k+(l*24|0)>>1]|0)!=(d[i>>1]|0))return 0;i=f[a+5820>>2]|0;l=(X(i,b)|0)+g|0;k=f[a+10308>>2]|0;i=k+((X(i,e)|0)+c<<2)|0;if((f[k+(l<<2)>>2]|0)!=(f[i>>2]|0))return 0}b=f[a+10368>>2]|0;e=m>>b;b=n>>b;if((e|0)<=-1)Pa(48699,37063,118,48756);c=f[a+10372>>2]|0;if((e|0)>=(c|0))Pa(48699,37063,118,48756);if((b|0)<=-1)Pa(48760,37063,119,48756);if((b|0)<(f[a+10376>>2]|0)){a=(f[a+10360>>2]|0)+(((X(c,b)|0)+e|0)*3|0)|0;return ((h[a>>0]|h[a+1>>0]<<8)&768)!=0|0}else Pa(48760,37063,119,48756);return 0}function mt(a,c){a=a|0;c=c|0;var d=0;Pv(c,1);d=(Ov(c,6)|0)&255;b[a>>0]=d;d=(Ov(c,6)|0)&255;b[a+1>>0]=d;c=(Ov(c,3)|0)+255&255;b[a+2>>0]=c;return}function nt(a){a=a|0;return (a+-19&255)<2|0}function ot(a){a=a|0;return (a+-16&255)<3|0}function pt(a){a=a|0;return (a|1)<<24>>24==9|0}function qt(a){a=a|0;return (a&-8)<<24>>24==16|0}function rt(a){a=a|0;return (a|1)<<24>>24==7|0}function st(a){a=a|0;if((a&255)<15)return (a&1)==0|0;else return 0;return 0}function tt(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0;i=a+4|0;j=f[a>>2]|0;k=(f[i>>2]|0)-j|0;h=k>>2;c=h+1|0;if(c>>>0>1073741823)$I(a);l=a+8|0;g=(f[l>>2]|0)-j|0;d=g>>1;d=g>>2>>>0<536870911?(d>>>0<c>>>0?c:d):1073741823;do if(d)if(d>>>0>1073741823){l=Ra(8)|0;VK(l,44736);f[l>>2]=17660;Va(l|0,4016,428)}else{g=OK(d<<2)|0;break}else g=0;while(0);e=g+(h<<2)|0;f[e>>2]=f[b>>2];c=e+(0-h<<2)|0;if((k|0)>0)GM(c|0,j|0,k|0)|0;f[a>>2]=c;f[i>>2]=e+4;f[l>>2]=g+(d<<2);if(!j)return;QK(j);return}function ut(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;d=f[a+32>>2]|0;e=d;a=(f[a+36>>2]|0)-d>>2;while(1){d=a+-1|0;if((a|0)<=0){a=0;d=4;break}if(((f[e+(d<<2)>>2]|0)-c|0)>(b|0))a=d;else{d=4;break}}if((d|0)==4)return a|0;return 0}function vt(a){a=a|0;var c=0;b[a>>0]=0;b[a+1>>0]=0;a=a+4|0;c=a+48|0;do{f[a>>2]=0;a=a+4|0}while((a|0)<(c|0));return}function wt(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=u;u=u+16|0;m=p;n=a+32|0;b=f[n>>2]|0;a:do if(b|0){h=a+16|0;i=a+28|0;j=a+36|0;k=a+40|0;l=a+44|0;g=a+48|0;do{c=f[h>>2]|0;d=f[i>>2]|0;e=f[(f[c+(d>>>10<<2)>>2]|0)+((d&1023)<<2)>>2]|0;f[n>>2]=b+-1;d=d+1|0;f[i>>2]=d;if(d>>>0>2047){QK(f[c>>2]|0);f[h>>2]=(f[h>>2]|0)+4;f[i>>2]=(f[i>>2]|0)+-1024}f[j>>2]=(f[j>>2]|0)-(f[e+24>>2]|0);if(!e)break a;f[m>>2]=e;b=e;c=f[l>>2]|0;do if(c-(f[k>>2]|0)>>2>>>0<16)if((c|0)==(f[g>>2]|0)){xt(k,m);break}else{f[c>>2]=b;f[l>>2]=(f[l>>2]|0)+4;break}else{ex(f[e+20>>2]|0);b=f[e+32>>2]|0;if(b|0){c=e+36|0;d=f[c>>2]|0;if((d|0)!=(b|0))f[c>>2]=d+(~((d+-4-b|0)>>>2)<<2);QK(b)}QK(e)}while(0);b=f[n>>2]|0}while((b|0)!=0)}while(0);e=f[a+8>>2]|0;if(!e){j=a+44|0;k=j;h=a+40|0}else{f[m>>2]=e;b=e;h=a+40|0;g=a+44|0;c=f[g>>2]|0;do if(c-(f[h>>2]|0)>>2>>>0<16)if((c|0)==(f[a+48>>2]|0)){xt(h,m);break}else{f[c>>2]=b;f[g>>2]=(f[g>>2]|0)+4;break}else{ex(f[e+20>>2]|0);b=f[e+32>>2]|0;if(b|0){c=e+36|0;d=f[c>>2]|0;if((d|0)!=(b|0))f[c>>2]=d+(~((d+-4-b|0)>>>2)<<2);QK(b)}QK(e)}while(0);k=g;j=g}d=f[j>>2]|0;e=f[h>>2]|0;c=e;b=d;if((d|0)!=(e|0)){i=0;do{g=f[c+(i<<2)>>2]|0;if(g){ex(f[g+20>>2]|0);b=f[g+32>>2]|0;if(b|0){c=g+36|0;d=f[c>>2]|0;if((d|0)!=(b|0))f[c>>2]=d+(~((d+-4-b|0)>>>2)<<2);QK(b)}QK(g);b=f[j>>2]|0;e=f[h>>2]|0;d=b}i=i+1|0;c=e}while(i>>>0<d-e>>2>>>0)}if(c|0){if((b|0)!=(c|0))f[k>>2]=b+(~((b+-4-c|0)>>>2)<<2);QK(c)}k=a+16|0;b=f[k>>2]|0;j=a+28|0;c=f[j>>2]|0;e=b+(c>>>10<<2)|0;l=a+20|0;d=f[l>>2]|0;g=d;h=b;if((d|0)==(b|0)){i=0;c=0}else{i=(f[n>>2]|0)+c|0;i=(f[b+(i>>>10<<2)>>2]|0)+((i&1023)<<2)|0;c=(f[e>>2]|0)+((c&1023)<<2)|0}b:while(1){do{if((c|0)==(i|0))break b;c=c+4|0}while((c-(f[e>>2]|0)|0)!=4096);c=e+4|0;e=c;c=f[c>>2]|0}f[n>>2]=0;c=g-h>>2;if(c>>>0>2)do{QK(f[b>>2]|0);b=(f[k>>2]|0)+4|0;f[k>>2]=b;d=f[l>>2]|0;c=d-b>>2}while(c>>>0>2);switch(c|0){case 1:{c=512;o=45;break}case 2:{c=1024;o=45;break}default:{}}if((o|0)==45)f[j>>2]=c;if((b|0)!=(d|0)){do{QK(f[b>>2]|0);b=b+4|0}while((b|0)!=(d|0));b=f[k>>2]|0;c=f[l>>2]|0;if((c|0)!=(b|0))f[l>>2]=c+(~((c+-4-b|0)>>>2)<<2)}b=f[a+12>>2]|0;if(!b){u=p;return}QK(b);u=p;return}function xt(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0;i=a+4|0;j=f[a>>2]|0;k=(f[i>>2]|0)-j|0;h=k>>2;c=h+1|0;if(c>>>0>1073741823)$I(a);l=a+8|0;g=(f[l>>2]|0)-j|0;d=g>>1;d=g>>2>>>0<536870911?(d>>>0<c>>>0?c:d):1073741823;do if(d)if(d>>>0>1073741823){l=Ra(8)|0;VK(l,44736);f[l>>2]=17660;Va(l|0,4016,428)}else{g=OK(d<<2)|0;break}else g=0;while(0);e=g+(h<<2)|0;f[e>>2]=f[b>>2];c=e+(0-h<<2)|0;if((k|0)>0)GM(c|0,j|0,k|0)|0;f[a>>2]=c;f[i>>2]=e+4;f[l>>2]=g+(d<<2);if(!j)return;QK(j);return}function yt(a){a=a|0;var b=0,c=0;c=f[a>>2]|0;if(!c)return;a=a+4|0;b=f[a>>2]|0;if((b|0)!=(c|0))f[a>>2]=b+(~((b+-4-c|0)>>>2)<<2);QK(c);return}function zt(a){a=a|0;var b=0,c=0,d=0,e=0;At(a);c=a+4|0;b=f[c>>2]|0;e=a+8|0;d=f[e>>2]|0;if((b|0)!=(d|0)){do{QK(f[b>>2]|0);b=b+4|0}while((b|0)!=(d|0));b=f[c>>2]|0;c=f[e>>2]|0;if((c|0)!=(b|0))f[e>>2]=c+(~((c+-4-b|0)>>>2)<<2)}b=f[a>>2]|0;if(!b)return;QK(b);return}function At(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0;j=a+4|0;b=f[j>>2]|0;l=a+16|0;c=f[l>>2]|0;d=b+(c>>>10<<2)|0;k=a+8|0;i=f[k>>2]|0;g=i;h=b;if((i|0)==(b|0)){i=0;e=a+20|0;a=0}else{e=a+20|0;i=c+(f[e>>2]|0)|0;i=(f[b+(i>>>10<<2)>>2]|0)+((i&1023)<<2)|0;a=(f[d>>2]|0)+((c&1023)<<2)|0}a:while(1){do{if((a|0)==(i|0))break a;a=a+4|0}while((a-(f[d>>2]|0)|0)!=4096);a=d+4|0;d=a;a=f[a>>2]|0}f[e>>2]=0;a=g-h>>2;if(a>>>0>2)do{QK(f[b>>2]|0);b=(f[j>>2]|0)+4|0;f[j>>2]=b;a=(f[k>>2]|0)-b>>2}while(a>>>0>2);switch(a|0){case 1:{a=512;break}case 2:{a=1024;break}default:return}f[l>>2]=a;return}function Bt(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0,i=0;b=a+32|0;d=f[b>>2]|0;if(!d){h=0;return h|0}e=a+16|0;g=f[e>>2]|0;h=a+28|0;i=f[h>>2]|0;c=f[(f[g+(i>>>10<<2)>>2]|0)+((i&1023)<<2)>>2]|0;f[b>>2]=d+-1;d=i+1|0;f[h>>2]=d;if(d>>>0>2047){QK(f[g>>2]|0);f[e>>2]=(f[e>>2]|0)+4;f[h>>2]=(f[h>>2]|0)+-1024}i=a+36|0;f[i>>2]=(f[i>>2]|0)-(f[c+24>>2]|0);i=c;return i|0}function Ct(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0;i=u;u=u+16|0;c=i;f[c>>2]=b;d=b;if(!b){u=i;return}e=a+40|0;g=a+44|0;h=f[g>>2]|0;if(h-(f[e>>2]|0)>>2>>>0<16)if((h|0)==(f[a+48>>2]|0)){xt(e,c);u=i;return}else{f[h>>2]=d;f[g>>2]=(f[g>>2]|0)+4;u=i;return}ex(f[b+20>>2]|0);a=f[b+32>>2]|0;if(a|0){c=b+36|0;d=f[c>>2]|0;if((d|0)!=(a|0))f[c>>2]=d+(~((d+-4-a|0)>>>2)<<2);QK(a)}QK(b);u=i;return}function Dt(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=u;u=u+16|0;m=p;n=a+40|0;o=a+44|0;d=f[o>>2]|0;if((d|0)==(f[n>>2]|0)){d=OK(48)|0;b[d>>0]=0;b[d+1>>0]=0;b[d+2>>0]=0;g=d+32|0;f[g>>2]=0;e=d+36|0;f[e>>2]=0;i=d+40|0;f[i>>2]=0;h=OK(64)|0;f[g>>2]=h;g=h+64|0;f[i>>2]=g;i=h+64|0;do{f[h>>2]=0;h=h+4|0}while((h|0)<(i|0));f[e>>2]=g;l=d+8|0;f[l>>2]=0;f[l+4>>2]=0;f[l+8>>2]=0;f[l+12>>2]=0;f[l+16>>2]=0;f[l+20>>2]=0;l=d}else{k=d+-4|0;l=f[k>>2]|0;f[o>>2]=k}b[l>>0]=0;b[l+1>>0]=0;b[l+2>>0]=0;i=l+8|0;f[i>>2]=0;f[i+4>>2]=0;f[l+16>>2]=0;i=l+24|0;f[i>>2]=0;j=l+32|0;d=f[j>>2]|0;k=l+36|0;e=f[k>>2]|0;if((e|0)!=(d|0))f[k>>2]=e+(~((e+-4-d|0)>>>2)<<2);g=l+28|0;if((f[g>>2]|0)>=(c|0)){o=l;u=p;return o|0}h=dx(c)|0;if(h|0){d=l+20|0;e=f[d>>2]|0;if(e|0){GM(h|0,e|0,f[i>>2]|0)|0;ex(e)}f[d>>2]=h;f[g>>2]=c;o=l;u=p;return o|0}f[m>>2]=l;d=l;e=f[o>>2]|0;do if(e-(f[n>>2]|0)>>2>>>0<16)if((e|0)==(f[a+48>>2]|0)){xt(n,m);break}else{f[e>>2]=d;f[o>>2]=(f[o>>2]|0)+4;break}else{ex(f[l+20>>2]|0);d=f[j>>2]|0;if(d|0){e=f[k>>2]|0;if((e|0)!=(d|0))f[k>>2]=e+(~((e+-4-d|0)>>>2)<<2);QK(d)}QK(l)}while(0);o=0;u=p;return o|0}function Et(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;o=u;u=u+32|0;k=o+4|0;j=o;b=a+16|0;c=f[b>>2]|0;if(c>>>0>1023){f[b>>2]=c+-1024;l=a+4|0;k=f[l>>2]|0;n=f[k>>2]|0;k=k+4|0;f[l>>2]=k;m=a+8|0;i=f[m>>2]|0;j=a+12|0;h=f[j>>2]|0;b=h;g=i;do if((i|0)==(h|0)){c=f[a>>2]|0;d=c;if(k>>>0>c>>>0){b=k;d=((b-d>>2)+1|0)/-2|0;e=k+(d<<2)|0;b=g-b|0;c=b>>2;if(!c)b=k;else{HM(e|0,k|0,b|0)|0;b=f[l>>2]|0}a=e+(c<<2)|0;f[m>>2]=a;f[l>>2]=b+(d<<2);b=a;break}b=b-d>>1;b=(b|0)==0?1:b;if(b>>>0>1073741823){o=Ra(8)|0;VK(o,44736);f[o>>2]=17660;Va(o|0,4016,428)}e=OK(b<<2)|0;g=e;d=e+(b>>>2<<2)|0;h=d;e=e+(b<<2)|0;if((k|0)==(i|0))b=h;else{b=h;c=k;do{f[d>>2]=f[c>>2];d=b+4|0;b=d;c=c+4|0}while((c|0)!=(i|0));c=f[a>>2]|0}f[a>>2]=g;f[l>>2]=h;f[m>>2]=b;f[j>>2]=e;if(c){QK(c);b=f[m>>2]|0}}else b=i;while(0);f[b>>2]=n;f[m>>2]=(f[m>>2]|0)+4;u=o;return}n=a+8|0;b=f[n>>2]|0;m=a+4|0;e=b-(f[m>>2]|0)|0;l=a+12|0;c=f[l>>2]|0;d=c-(f[a>>2]|0)|0;if(e>>>0>=d>>>0){b=d>>1;b=(b|0)==0?1:b;f[k+12>>2]=0;f[k+16>>2]=a+12;if(b>>>0>1073741823){o=Ra(8)|0;VK(o,44736);f[o>>2]=17660;Va(o|0,4016,428)}d=OK(b<<2)|0;f[k>>2]=d;h=d+(e>>2<<2)|0;i=k+8|0;f[i>>2]=h;g=k+4|0;f[g>>2]=h;h=k+12|0;f[h>>2]=d+(b<<2);e=OK(4096)|0;f[j>>2]=e;Ht(k,j);e=f[n>>2]|0;while(1){b=f[m>>2]|0;if((e|0)==(b|0))break;j=e+-4|0;It(k,j);e=j}c=b;d=f[a>>2]|0;f[a>>2]=f[k>>2];f[k>>2]=d;f[m>>2]=f[g>>2];f[g>>2]=c;b=f[n>>2]|0;f[n>>2]=f[i>>2];f[i>>2]=b;a=f[l>>2]|0;f[l>>2]=f[h>>2];f[h>>2]=a;if((b|0)!=(e|0))f[i>>2]=b+(~((b+-4-c|0)>>>2)<<2);if(d|0)QK(d);u=o;return}if((c|0)!=(b|0)){n=OK(4096)|0;f[k>>2]=n;Ft(a,k);u=o;return}j=OK(4096)|0;f[k>>2]=j;Gt(a,k);j=f[m>>2]|0;k=f[j>>2]|0;j=j+4|0;f[m>>2]=j;i=f[n>>2]|0;h=f[l>>2]|0;b=h;g=i;do if((i|0)==(h|0)){c=f[a>>2]|0;d=c;if(j>>>0>c>>>0){b=j;d=((b-d>>2)+1|0)/-2|0;e=j+(d<<2)|0;b=g-b|0;c=b>>2;if(!c)b=j;else{HM(e|0,j|0,b|0)|0;b=f[m>>2]|0}a=e+(c<<2)|0;f[n>>2]=a;f[m>>2]=b+(d<<2);b=a;break}b=b-d>>1;b=(b|0)==0?1:b;if(b>>>0>1073741823){o=Ra(8)|0;VK(o,44736);f[o>>2]=17660;Va(o|0,4016,428)}e=OK(b<<2)|0;g=e;d=e+(b>>>2<<2)|0;h=d;e=e+(b<<2)|0;if((j|0)==(i|0))b=h;else{b=h;c=j;do{f[d>>2]=f[c>>2];d=b+4|0;b=d;c=c+4|0}while((c|0)!=(i|0));c=f[a>>2]|0}f[a>>2]=g;f[m>>2]=h;f[n>>2]=b;f[l>>2]=e;if(c){QK(c);b=f[n>>2]|0}}else b=i;while(0);f[b>>2]=k;f[n>>2]=(f[n>>2]|0)+4;u=o;return}function Ft(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=a+8|0;j=f[n>>2]|0;k=a+12|0;m=f[k>>2]|0;e=m;h=j;do if((j|0)==(m|0)){m=a+4|0;l=f[m>>2]|0;d=f[a>>2]|0;c=d;if(l>>>0>d>>>0){d=l;e=((d-c>>2)+1|0)/-2|0;g=l+(e<<2)|0;c=h-d|0;d=c>>2;if(!d)c=l;else{HM(g|0,l|0,c|0)|0;c=f[m>>2]|0}l=g+(d<<2)|0;f[n>>2]=l;f[m>>2]=c+(e<<2);c=l;break}c=e-c>>1;c=(c|0)==0?1:c;if(c>>>0>1073741823){n=Ra(8)|0;VK(n,44736);f[n>>2]=17660;Va(n|0,4016,428)}g=OK(c<<2)|0;h=g;e=g+(c>>>2<<2)|0;i=e;g=g+(c<<2)|0;if((l|0)==(j|0))c=i;else{c=i;d=l;do{f[e>>2]=f[d>>2];e=c+4|0;c=e;d=d+4|0}while((d|0)!=(j|0));d=f[a>>2]|0}f[a>>2]=h;f[m>>2]=i;f[n>>2]=c;f[k>>2]=g;if(d){QK(d);c=f[n>>2]|0}}else c=j;while(0);f[c>>2]=f[b>>2];f[n>>2]=(f[n>>2]|0)+4;return}function Gt(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;o=a+4|0;m=f[o>>2]|0;n=f[a>>2]|0;e=n;do if((m|0)==(n|0)){n=a+8|0;d=f[n>>2]|0;l=a+12|0;k=f[l>>2]|0;c=k;if(d>>>0<k>>>0){e=d;h=((c-e>>2)+1|0)/2|0;c=d+(h<<2)|0;e=e-m|0;l=e>>2;g=c+(0-l<<2)|0;if(l){HM(g|0,m|0,e|0)|0;c=g;d=f[n>>2]|0}f[o>>2]=c;f[n>>2]=d+(h<<2);break}e=c-e>>1;e=(e|0)==0?1:e;if(e>>>0>1073741823){o=Ra(8)|0;VK(o,44736);f[o>>2]=17660;Va(o|0,4016,428)}i=OK(e<<2)|0;j=i;c=i+((e+3|0)>>>2<<2)|0;k=c;i=i+(e<<2)|0;if((m|0)==(d|0)){e=k;d=m}else{h=c;e=k;g=m;do{f[h>>2]=f[g>>2];h=e+4|0;e=h;g=g+4|0}while((g|0)!=(d|0));d=f[a>>2]|0}f[a>>2]=j;f[o>>2]=k;f[n>>2]=e;f[l>>2]=i;if(d){QK(d);c=f[o>>2]|0}}else c=m;while(0);f[c+-4>>2]=f[b>>2];f[o>>2]=(f[o>>2]|0)+-4;return}function Ht(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=a+8|0;j=f[n>>2]|0;k=a+12|0;m=f[k>>2]|0;e=m;h=j;do if((j|0)==(m|0)){m=a+4|0;l=f[m>>2]|0;d=f[a>>2]|0;c=d;if(l>>>0>d>>>0){d=l;e=((d-c>>2)+1|0)/-2|0;g=l+(e<<2)|0;c=h-d|0;d=c>>2;if(!d)c=l;else{HM(g|0,l|0,c|0)|0;c=f[m>>2]|0}l=g+(d<<2)|0;f[n>>2]=l;f[m>>2]=c+(e<<2);c=l;break}c=e-c>>1;c=(c|0)==0?1:c;if(c>>>0>1073741823){n=Ra(8)|0;VK(n,44736);f[n>>2]=17660;Va(n|0,4016,428)}g=OK(c<<2)|0;h=g;e=g+(c>>>2<<2)|0;i=e;g=g+(c<<2)|0;if((l|0)==(j|0))c=i;else{c=i;d=l;do{f[e>>2]=f[d>>2];e=c+4|0;c=e;d=d+4|0}while((d|0)!=(j|0));d=f[a>>2]|0}f[a>>2]=h;f[m>>2]=i;f[n>>2]=c;f[k>>2]=g;if(d){QK(d);c=f[n>>2]|0}}else c=j;while(0);f[c>>2]=f[b>>2];f[n>>2]=(f[n>>2]|0)+4;return}function It(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;o=a+4|0;m=f[o>>2]|0;n=f[a>>2]|0;e=n;do if((m|0)==(n|0)){n=a+8|0;d=f[n>>2]|0;l=a+12|0;k=f[l>>2]|0;c=k;if(d>>>0<k>>>0){e=d;h=((c-e>>2)+1|0)/2|0;c=d+(h<<2)|0;e=e-m|0;l=e>>2;g=c+(0-l<<2)|0;if(l){HM(g|0,m|0,e|0)|0;c=g;d=f[n>>2]|0}f[o>>2]=c;f[n>>2]=d+(h<<2);break}e=c-e>>1;e=(e|0)==0?1:e;if(e>>>0>1073741823){o=Ra(8)|0;VK(o,44736);f[o>>2]=17660;Va(o|0,4016,428)}i=OK(e<<2)|0;j=i;c=i+((e+3|0)>>>2<<2)|0;k=c;i=i+(e<<2)|0;if((m|0)==(d|0)){e=k;d=m}else{h=c;e=k;g=m;do{f[h>>2]=f[g>>2];h=e+4|0;e=h;g=g+4|0}while((g|0)!=(d|0));d=f[a>>2]|0}f[a>>2]=j;f[o>>2]=k;f[n>>2]=e;f[l>>2]=i;if(d){QK(d);c=f[o>>2]|0}}else c=m;while(0);f[c+-4>>2]=f[b>>2];f[o>>2]=(f[o>>2]|0)+-4;return}function Jt(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=u;u=u+16|0;p=r;if(f[a+8>>2]|0)Pa(37073,37099,375,37113);b[a+1>>0]=0;q=Dt(a,d)|0;a:do if(!q)f[p>>2]=0;else{j=q+28|0;do if((f[j>>2]|0)<(d|0)){i=dx(d)|0;if(i|0){k=q+20|0;l=f[k>>2]|0;if(l|0){GM(i|0,l|0,f[q+24>>2]|0)|0;ex(l)}f[k>>2]=i;f[j>>2]=d;break}f[p>>2]=q;i=q;j=a+40|0;k=a+44|0;l=f[k>>2]|0;if(l-(f[j>>2]|0)>>2>>>0<16)if((l|0)==(f[a+48>>2]|0)){xt(j,p);break a}else{f[l>>2]=i;f[k>>2]=(f[k>>2]|0)+4;break a}ex(f[q+20>>2]|0);i=f[q+32>>2]|0;if(i|0){j=q+36|0;k=f[j>>2]|0;if((k|0)!=(i|0))f[j>>2]=k+(~((k+-4-i|0)>>>2)<<2);QK(i)}QK(q);break a}else i=f[q+20>>2]|0;while(0);GM(i|0,c|0,d|0)|0;o=q+24|0;f[o>>2]=d;m=q+8|0;f[m>>2]=e;f[m+4>>2]=g;f[q+16>>2]=h;b:do if((d|0)>2){g=q+32|0;h=q+36|0;m=q+40|0;i=f[q+20>>2]|0;e=0;l=d;while(1){c=i+2|0;j=b[c>>0]|0;switch(j<<24>>24){case 0:case 3:{if((b[i>>0]|0)==0?(n=i+1|0,j<<24>>24==3&(b[n>>0]|0)==0):0){k=f[h>>2]|0;j=e+2+(k-(f[g>>2]|0)>>2)|0;f[p>>2]=j;if((k|0)==(f[m>>2]|0))tt(g,p);else{f[k>>2]=j;f[h>>2]=k+4}HM(c|0,i+3|0,-3-e+(f[o>>2]|0)|0)|0;j=(f[o>>2]|0)+-1|0;f[o>>2]=j;k=e+1|0;i=n}else{k=e;j=l}break}default:{k=e+2|0;i=c;j=l}}e=k+1|0;if((e|0)>=(j+-2|0))break b;else{i=i+1|0;l=j}}}while(0);c=a+16|0;i=f[c>>2]|0;p=(f[a+20>>2]|0)-i|0;j=a+28|0;k=f[j>>2]|0;e=a+32|0;l=f[e>>2]|0;if((((p|0)==0?0:(p<<8)+-1|0)|0)==(l+k|0)){Et(a+12|0);k=f[j>>2]|0;j=f[e>>2]|0;i=f[c>>2]|0}else j=l;p=j+k|0;f[(f[i+(p>>>10<<2)>>2]|0)+((p&1023)<<2)>>2]=q;f[e>>2]=j+1;q=a+36|0;f[q>>2]=(f[q>>2]|0)+(f[o>>2]|0);q=0;u=r;return q|0}while(0);q=7;u=r;return q|0}function Kt(a){a=a|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;k=a+8|0;l=f[k>>2]|0;if(!l){m=0;return m|0}m=a+4|0;c=f[m>>2]|0;if((c|0)==6){j=l+24|0;c=f[j>>2]|0;i=c+1|0;g=l+28|0;if((f[g>>2]|0)>(c|0))d=f[l+20>>2]|0;else{d=dx(i)|0;if(!d){m=7;return m|0}h=l+20|0;e=f[h>>2]|0;if(e){GM(d|0,e|0,c|0)|0;ex(e);c=f[j>>2]|0}f[h>>2]=d;f[g>>2]=i}b[d+c>>0]=0;f[j>>2]=(f[j>>2]|0)+1;c=f[m>>2]|0}if((c|0)==7){j=l+24|0;c=f[j>>2]|0;g=c+2|0;h=l+28|0;if((f[h>>2]|0)<(g|0)){d=dx(g)|0;if(!d){m=7;return m|0}i=l+20|0;e=f[i>>2]|0;if(e){GM(d|0,e|0,c|0)|0;ex(e);c=f[j>>2]|0}f[i>>2]=d;f[h>>2]=g}else d=f[l+20>>2]|0;c=d+c|0;b[c>>0]=0;b[c+1>>0]=0;f[j>>2]=(f[j>>2]|0)+2;c=f[m>>2]|0}if((c|0)>4){h=a+16|0;c=f[h>>2]|0;j=(f[a+20>>2]|0)-c|0;d=a+28|0;e=f[d>>2]|0;i=a+32|0;g=f[i>>2]|0;if((((j|0)==0?0:(j<<8)+-1|0)|0)==(g+e|0)){Et(a+12|0);e=f[d>>2]|0;d=f[i>>2]|0;c=f[h>>2]|0}else d=g;j=d+e|0;f[(f[c+(j>>>10<<2)>>2]|0)+((j&1023)<<2)>>2]=l;f[i>>2]=d+1;a=a+36|0;f[a>>2]=(f[a>>2]|0)+(f[l+24>>2]|0);f[k>>2]=0}f[m>>2]=0;m=0;return m|0}function Lt(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,i=0,j=0,k=0;j=b[e+2>>0]|0;if(b[e+13>>0]|0){i=(Rv(c)|0)+2&255;b[a>>0]=i}i=(Ov(c,1)|0)!=0;b[a+1>>0]=i&1;g=d+11096+(j*5168|0)+5012|0;if(!((f[g>>2]|0)==3|i^1))uq(d+4|0,1006,0);k=(Ov(c,1)|0)!=0;i=a+2|0;e=k&1;b[i>>0]=e;if(!((f[g>>2]|0)!=0|k^1)){uq(d+4|0,1006,0);e=b[i>>0]|0}a:do if(e<<24>>24){e=Rv(c)|0;if((e|0)!=-99999?(e|0)<=(f[d+11096+(j*5168|0)+616>>2]|0):0){b[a+3>>0]=e;e=Rv(c)|0;if((e|0)==-99999|(e|0)>5){uq(d+4|0,1006,0);k=0;return k|0}k=e+1|0;i=a+4|0;b[i>>0]=k;if(!(k&255))break;else g=0;while(1){e=Sv(c)|0;if((e+12|0)>>>0>24){e=15;break}b[a+5+g>>0]=e;e=Sv(c)|0;if((e+12|0)>>>0>24){e=17;break}b[a+11+g>>0]=e;g=g+1|0;if((g|0)>=(h[i>>0]|0))break a}if((e|0)==15){uq(d+4|0,1006,0);k=0;return k|0}else if((e|0)==17){uq(d+4|0,1006,0);k=0;return k|0}}uq(d+4|0,1006,0);k=0;return k|0}while(0);e=Rv(c)|0;if((e|0)!=-99999?(k=f[d+11096+(j*5168|0)+4996>>2]|0,(e|0)<=(((k|0)<10?0:k+-10|0)|0)):0){b[a+17>>0]=e;e=Rv(c)|0;if((e|0)!=-99999?(k=f[d+11096+(j*5168|0)+5004>>2]|0,(e|0)<=(((k|0)<10?0:k+-10|0)|0)):0){b[a+18>>0]=e;k=1;return k|0}uq(d+4|0,1006,0);k=0;return k|0}uq(d+4|0,1006,0);k=0;return k|0}function Mt(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=u;u=u+80|0;q=r+72|0;p=r+64|0;o=r+56|0;n=r+48|0;i=r+40|0;l=r+32|0;k=r+24|0;j=r+16|0;g=r+8|0;e=r;switch(c|0){case 1:{c=10100;break}case 2:{c=10604;break}default:{u=r;return}}d=f[c>>2]|0;wv(d,37122,e);f[g>>2]=h[a>>0];wv(d,37165,g);f[j>>2]=h[a+1>>0];wv(d,37211,j);j=a+2|0;f[k>>2]=h[j>>0];wv(d,37257,k);if(b[j>>0]|0?(f[l>>2]=h[a+3>>0],wv(d,37303,l),m=a+4|0,f[i>>2]=h[m>>0],wv(d,37349,i),b[m>>0]|0):0){c=0;do{l=b[a+5+c>>0]|0;f[n>>2]=c;f[n+4>>2]=l;wv(d,37395,n);l=b[a+11+c>>0]|0;f[o>>2]=c;f[o+4>>2]=l;wv(d,37442,o);c=c+1|0}while((c|0)<(h[m>>0]|0))}f[p>>2]=h[a+17>>0];wv(d,37489,p);f[q>>2]=h[a+18>>0];wv(d,37535,q);u=r;return}function Nt(a){a=a|0;var c=0,d=0;b[a+4138>>0]=2;c=a+4139|0;b[a+4155>>0]=0;b[a+4156>>0]=0;b[c>>0]=0;b[c+1>>0]=0;b[c+2>>0]=0;b[c+3>>0]=0;c=a+4340|0;d=c+60|0;do{f[c>>2]=0;c=c+4|0}while((c|0)<(d|0));Ot(a,0);return}function Ot(a,c){a=a|0;c=c|0;var e=0,g=0;f[a>>2]=0;d[a+4>>1]=0;b[a+6>>0]=1;b[a+7>>0]=1;f[a+8>>2]=27;b[a+12>>0]=0;b[a+13>>0]=0;b[a+14>>0]=0;c=a+16|0;f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;f[c+12>>2]=0;d[c+16>>1]=0;b[c+18>>0]=0;f[a+36>>2]=1;f[a+40>>2]=1;b[a+44>>0]=1;b[a+45>>0]=1;b[a+46>>0]=1;IM(a+4172|0,0,168)|0;c=f[a+4340>>2]|0;e=a+4344|0;g=f[e>>2]|0;if((g|0)!=(c|0))f[e>>2]=g+(~((g+-4-c|0)>>>2)<<2);c=f[a+4352>>2]|0;e=a+4356|0;g=f[e>>2]|0;if((g|0)!=(c|0))f[e>>2]=g+(~((g+-4-c|0)>>>2)<<2);c=f[a+4364>>2]|0;e=a+4368|0;g=f[e>>2]|0;if((g|0)!=(c|0))f[e>>2]=g+(~((g+-4-c|0)>>>2)<<2);c=f[a+4376>>2]|0;e=a+4380|0;g=f[e>>2]|0;if((g|0)!=(c|0))f[e>>2]=g+(~((g+-4-c|0)>>>2)<<2);c=f[a+4388>>2]|0;e=a+4392|0;g=f[e>>2]|0;if((g|0)==(c|0)){g=a+4160|0;f[g>>2]=0;g=a+47|0;b[g>>0]=0;g=a+48|0;b[g>>0]=0;g=a+49|0;b[g>>0]=0;g=a+52|0;f[g>>2]=0;g=a+56|0;f[g>>2]=0;g=a+60|0;b[g>>0]=0;g=a+4125|0;b[g>>0]=0;g=a+4128|0;f[g>>2]=2;a=a+4132|0;f[a>>2]=0;d[a+4>>1]=0;return}f[e>>2]=g+(~((g+-4-c|0)>>>2)<<2);g=a+4160|0;f[g>>2]=0;g=a+47|0;b[g>>0]=0;g=a+48|0;b[g>>0]=0;g=a+49|0;b[g>>0]=0;g=a+52|0;f[g>>2]=0;g=a+56|0;f[g>>2]=0;g=a+60|0;b[g>>0]=0;g=a+4125|0;b[g>>0]=0;g=a+4128|0;f[g>>2]=2;a=a+4132|0;f[a>>2]=0;d[a+4>>1]=0;return}function Pt(a){a=a|0;var b=0,c=0,d=0;b=f[a+4388>>2]|0;if(b|0){c=a+4392|0;d=f[c>>2]|0;if((d|0)!=(b|0))f[c>>2]=d+(~((d+-4-b|0)>>>2)<<2);QK(b)}b=f[a+4376>>2]|0;if(b|0){c=a+4380|0;d=f[c>>2]|0;if((d|0)!=(b|0))f[c>>2]=d+(~((d+-4-b|0)>>>2)<<2);QK(b)}b=f[a+4364>>2]|0;if(b|0){c=a+4368|0;d=f[c>>2]|0;if((d|0)!=(b|0))f[c>>2]=d+(~((d+-4-b|0)>>>2)<<2);QK(b)}b=f[a+4352>>2]|0;if(b|0){c=a+4356|0;d=f[c>>2]|0;if((d|0)!=(b|0))f[c>>2]=d+(~((d+-4-b|0)>>>2)<<2);QK(b)}d=f[a+4340>>2]|0;if(!d)return;b=a+4344|0;c=f[b>>2]|0;if((c|0)!=(d|0))f[b>>2]=c+(~((c+-4-d|0)>>>2)<<2);QK(d);return}function Qt(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;Ot(a,0);n=Rv(c)|0;b[a+1>>0]=n;if((n|0)>63|(n|0)==-99999){uq(d+4|0,1009,0);d=0;return d|0}n=Rv(c)|0;h=a+2|0;b[h>>0]=n;if((n|0)>63|(n|0)==-99999){uq(d+4|0,1010,0);d=0;return d|0}n=(Ov(c,1)|0)&255;b[a+3>>0]=n;n=(Ov(c,1)|0)&255;b[a+31>>0]=n;n=(Ov(c,3)|0)&255;b[a+4132>>0]=n;n=(Ov(c,1)|0)&255;b[a+4>>0]=n;n=(Ov(c,1)|0)&255;b[a+5>>0]=n;n=Rv(c)|0;e=n&255;g=a+6|0;b[g>>0]=e;if((n|0)==-99999){uq(d+4|0,1006,0);d=0;return d|0}b[g>>0]=e+1<<24>>24;n=Rv(c)|0;e=n&255;g=a+7|0;b[g>>0]=e;if((n|0)==-99999){uq(d+4|0,1006,0);d=0;return d|0}b[g>>0]=e+1<<24>>24;m=b[h>>0]|0;n=d+11096+(m*5168|0)|0;if(!(b[n>>0]|0)){uq(d+4|0,1010,0);d=0;return d|0}e=Sv(c)|0;g=a+8|0;f[g>>2]=e;if((e|0)==-99999){uq(d+4|0,1006,0);d=0;return d|0}f[g>>2]=e+26;l=(Ov(c,1)|0)&255;b[a+12>>0]=l;l=(Ov(c,1)|0)&255;b[a+13>>0]=l;l=(Ov(c,1)|0)&255;b[a+14>>0]=l;if(l<<24>>24){l=Rv(c)|0;f[a+16>>2]=l;if((l|0)==-99999){uq(d+4|0,1006,0);d=0;return d|0}}else f[a+16>>2]=0;l=Sv(c)|0;f[a+20>>2]=l;if((l|0)==-99999){uq(d+4|0,1006,0);d=0;return d|0}l=Sv(c)|0;f[a+24>>2]=l;if((l|0)==-99999){uq(d+4|0,1006,0);d=0;return d|0}k=(Ov(c,1)|0)&255;b[a+28>>0]=k;k=(Ov(c,1)|0)&255;b[a+29>>0]=k;k=(Ov(c,1)|0)&255;b[a+30>>0]=k;k=(Ov(c,1)|0)&255;b[a+32>>0]=k;k=(Ov(c,1)|0)&255;l=a+34|0;b[l>>0]=k;k=(Ov(c,1)|0)&255;b[a+33>>0]=k;if(!(b[l>>0]|0)){f[a+36>>2]=1;f[a+40>>2]=1;b[a+44>>0]=1;e=0}else{e=Rv(c)|0;k=a+36|0;f[k>>2]=e;if((e|0)==-99999|(e|0)>9){uq(d+4|0,1006,0);d=0;return d|0}f[k>>2]=e+1;e=Rv(c)|0;l=a+40|0;f[l>>2]=e;if((e|0)==-99999|(e|0)>9){uq(d+4|0,1006,0);d=0;return d|0}f[l>>2]=e+1;j=Ov(c,1)|0;b[a+44>>0]=j;do if(!(j&255)){h=f[d+11096+(m*5168|0)+5056>>2]|0;g=f[d+11096+(m*5168|0)+5064>>2]|0;j=f[k>>2]|0;e=j+-1|0;a:do if((j|0)>1){j=0;while(1){e=Rv(c)|0;i=a+4172+(j<<2)|0;f[i>>2]=e;if((e|0)==-99999)break;e=e+1|0;f[i>>2]=e;h=h-e|0;j=j+1|0;e=(f[k>>2]|0)+-1|0;if((j|0)>=(e|0))break a}uq(d+4|0,1006,0);d=0;return d|0}while(0);if((h|0)<1){d=0;return d|0}f[a+4172+(e<<2)>>2]=h;k=f[l>>2]|0;e=k+-1|0;b:do if((k|0)>1){i=0;while(1){e=Rv(c)|0;h=a+4212+(i<<2)|0;f[h>>2]=e;if((e|0)==-99999)break;e=e+1|0;f[h>>2]=e;g=g-e|0;i=i+1|0;e=(f[l>>2]|0)+-1|0;if((i|0)>=(e|0))break b}uq(d+4|0,1006,0);d=0;return d|0}while(0);if((g|0)<1){d=0;return d|0}else{f[a+4212+(e<<2)>>2]=g;break}}while(0);e=(Ov(c,1)|0)&255}b[a+45>>0]=e;e=a+52|0;f[e>>2]=0;h=a+56|0;f[h>>2]=0;l=(Ov(c,1)|0)&255;b[a+46>>0]=l;l=(Ov(c,1)|0)&255;b[a+47>>0]=l;do if(l<<24>>24){l=(Ov(c,1)|0)&255;b[a+48>>0]=l;l=(Ov(c,1)|0)&255;b[a+49>>0]=l;if(!(l<<24>>24)){g=Sv(c)|0;f[e>>2]=g;if((g|0)==-99999){uq(d+4|0,1006,0);d=0;return d|0}f[e>>2]=g<<1;e=Sv(c)|0;f[h>>2]=e;if((e|0)!=-99999){f[h>>2]=e<<1;break}uq(d+4|0,1006,0);d=0;return d|0}}else{b[a+48>>0]=0;b[a+49>>0]=0}while(0);l=Ov(c,1)|0;e=l&255;b[a+60>>0]=e;if(!((l&255|0)==0?1:(b[d+11096+(m*5168|0)+636>>0]|0)!=0)){uq(d+4|0,1006,0);d=0;return d|0}if(e<<24>>24){e=Nu(c,n,a+61|0,1)|0;if(e|0){uq(d+4|0,e,0);d=0;return d|0}}else GM(a+61|0,d+11096+(m*5168|0)+638|0,4064)|0;e=(Ov(c,1)|0)&255;b[a+4125>>0]=e;e=Rv(c)|0;g=a+4128|0;f[g>>2]=e;if((e|0)==-99999){uq(d+4|0,1006,0);d=0;return d|0}f[g>>2]=e+2;if((e|0)>((f[d+11096+(m*5168|0)+612>>2]|0)+-2+(f[d+11096+(m*5168|0)+616>>2]|0)|0)){d=0;return d|0}m=(Ov(c,1)|0)&255;b[a+4133>>0]=m;m=(Ov(c,1)|0)&255;b[a+4134>>0]=m;if((m<<24>>24?(l=(Ov(c,1)|0)&255,m=a+4135|0,b[m>>0]=l,l=(Ov(c,1)|0)&255,b[a+4136>>0]=l,l=(Ov(c,6)|0)&255,b[a+4137>>0]=l,b[m>>0]|0):0)?!(Lt(a+4138|0,c,d,a)|0):0){d=0;return d|0}Rt(a,n);b[a>>0]=1;d=1;return d|0}function Rt(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;C=u;B=c+5040|0;z=f[B>>2]|0;f[a+4160>>2]=z-(f[a+16>>2]|0);f[a+4164>>2]=z-(h[a+4141>>0]|0);f[a+4168>>2]=h[a+4138>>0];z=a+36|0;if(b[a+44>>0]|0){e=f[z>>2]|0;i=u;u=u+((1*((e<<2)+4|0)|0)+15&-16)|0;if((e|0)>=0){g=f[c+5056>>2]|0;d=0;while(1){A=(X(g,d)|0)/(e|0)|0;f[i+(d<<2)>>2]=A;if((d|0)==(e|0))break;else d=d+1|0}if((e|0)>0){d=0;e=f[i>>2]|0;do{A=d;d=d+1|0;y=e;e=f[i+(d<<2)>>2]|0;f[a+4172+(A<<2)>>2]=e-y}while((d|0)<(f[z>>2]|0))}}i=a+40|0;e=f[i>>2]|0;j=u;u=u+((1*((e<<2)+4|0)|0)+15&-16)|0;if((e|0)>=0){g=f[c+5064>>2]|0;d=0;while(1){A=(X(g,d)|0)/(e|0)|0;f[j+(d<<2)>>2]=A;if((d|0)==(e|0))break;else d=d+1|0}if((e|0)>0){d=0;e=f[j>>2]|0;do{A=d;d=d+1|0;y=e;e=f[j+(d<<2)>>2]|0;f[a+4212+(A<<2)>>2]=e-y}while((d|0)<(f[i>>2]|0))}}}f[a+4252>>2]=0;if((f[z>>2]|0)>0){d=0;e=0;do{e=(f[a+4172+(d<<2)>>2]|0)+e|0;d=d+1|0;f[a+4252+(d<<2)>>2]=e}while((d|0)<(f[z>>2]|0))}f[a+4296>>2]=0;y=a+40|0;if((f[y>>2]|0)>0){d=0;e=0;do{d=(f[a+4212+(e<<2)>>2]|0)+d|0;e=e+1|0;f[a+4296+(e<<2)>>2]=d}while((e|0)<(f[y>>2]|0))}A=a+4340|0;q=c+5072|0;e=f[q>>2]|0;d=a+4344|0;j=f[d>>2]|0;i=f[A>>2]|0;g=j-i>>2;if(e>>>0<=g>>>0){if(e>>>0<g>>>0?(k=i+(e<<2)|0,(j|0)!=(k|0)):0)f[d>>2]=j+(~((j+-4-k|0)>>>2)<<2)}else{St(A,e-g|0);e=f[q>>2]|0}p=a+4352|0;j=a+4356|0;i=f[j>>2]|0;g=f[p>>2]|0;d=i-g>>2;if(e>>>0<=d>>>0){if(e>>>0<d>>>0?(l=g+(e<<2)|0,(i|0)!=(l|0)):0)f[j>>2]=i+(~((i+-4-l|0)>>>2)<<2)}else{St(p,e-d|0);e=f[q>>2]|0}w=a+4364|0;d=a+4368|0;j=f[d>>2]|0;i=f[w>>2]|0;g=j-i>>2;if(e>>>0<=g>>>0){if(e>>>0<g>>>0?(m=i+(e<<2)|0,(j|0)!=(m|0)):0)f[d>>2]=j+(~((j+-4-m|0)>>>2)<<2)}else{St(w,e-g|0);e=f[q>>2]|0}v=a+4376|0;d=a+4380|0;j=f[d>>2]|0;i=f[v>>2]|0;g=j-i>>2;if(e>>>0<=g>>>0){if(e>>>0<g>>>0?(n=i+(e<<2)|0,(j|0)!=(n|0)):0)f[d>>2]=j+(~((j+-4-n|0)>>>2)<<2)}else St(v,e-g|0);x=a+4388|0;d=f[c+5096>>2]|0;e=a+4392|0;j=f[e>>2]|0;i=f[x>>2]|0;g=j-i>>2;if(d>>>0<=g>>>0){if(d>>>0<g>>>0?(o=i+(d<<2)|0,(j|0)!=(o|0)):0)f[e>>2]=j+(~((j+-4-o|0)>>>2)<<2)}else St(x,d-g|0);a:do if((f[q>>2]|0)>0){m=c+5056|0;l=0;while(1){o=f[m>>2]|0;n=(l|0)%(o|0)|0;o=(l|0)/(o|0)|0;g=f[z>>2]|0;if((g|0)>0){e=0;d=-1;do{d=(n|0)<(f[a+4252+(e<<2)>>2]|0)?d:e;e=e+1|0}while((e|0)<(g|0))}else d=-1;i=f[y>>2]|0;if((i|0)>0){g=0;e=-1;do{e=(o|0)<(f[a+4296+(g<<2)>>2]|0)?e:g;g=g+1|0}while((g|0)<(i|0))}else e=-1;k=(f[A>>2]|0)+(l<<2)|0;f[k>>2]=0;if((d|0)>0){j=a+4212+(e<<2)|0;i=0;g=0;do{g=g+(X(f[a+4172+(i<<2)>>2]|0,f[j>>2]|0)|0)|0;f[k>>2]=g;i=i+1|0}while((i|0)!=(d|0))}else g=0;if((e|0)>0){i=0;do{g=g+(X(f[a+4212+(i<<2)>>2]|0,f[m>>2]|0)|0)|0;f[k>>2]=g;i=i+1|0}while((i|0)!=(e|0))}if((e|d|0)<=-1)break;t=g+(X(o-(f[a+4296+(e<<2)>>2]|0)|0,f[a+4172+(d<<2)>>2]|0)|0)|0;f[k>>2]=t;t=n-(f[a+4252+(d<<2)>>2]|0)+t|0;f[k>>2]=t;f[(f[p>>2]|0)+(t<<2)>>2]=l;l=l+1|0;if((l|0)>=(f[q>>2]|0))break a}Pa(37581,37602,618,37609)}while(0);d=f[y>>2]|0;if((d|0)>0){t=c+5056|0;i=0;g=0;e=f[z>>2]|0;do if((e|0)>0){s=a+4296+(g<<2)|0;g=g+1|0;r=a+4296+(g<<2)|0;q=0;p=i;d=f[r>>2]|0;do{j=f[s>>2]|0;i=q;q=q+1|0;if((j|0)<(d|0)){n=a+4252+(i<<2)|0;o=a+4252+(q<<2)|0;e=f[o>>2]|0;do{m=f[n>>2]|0;if((m|0)<(e|0)){i=f[A>>2]|0;k=f[w>>2]|0;l=f[v>>2]|0;d=m;do{e=i+((X(f[t>>2]|0,j)|0)+d<<2)|0;f[k+(f[e>>2]<<2)>>2]=p;e=l+((X(f[t>>2]|0,j)|0)+d<<2)|0;f[e>>2]=p;d=d+1|0;e=f[o>>2]|0}while((d|0)<(e|0));d=f[r>>2]|0}j=j+1|0}while((j|0)<(d|0));e=f[z>>2]|0}p=p+1|0}while((q|0)<(e|0));i=p;d=f[y>>2]|0}else g=g+1|0;while((g|0)<(d|0))}n=c+5092|0;d=f[n>>2]|0;if((d|0)<=0){u=C;return}o=c+5088|0;p=c+5100|0;m=c+5056|0;l=0;e=f[o>>2]|0;do{if((e|0)>0){j=f[A>>2]|0;k=f[x>>2]|0;i=0;do{c=f[p>>2]|0;a=f[B>>2]|0;z=j+((X(f[m>>2]|0,l<<c>>a)|0)+(i<<c>>a)<<2)|0;d=k+((X(e,l)|0)+i<<2)|0;f[d>>2]=f[z>>2]<<(a-c<<1);d=f[B>>2]|0;e=f[p>>2]|0;if((d|0)>(e|0)){g=d-e|0;e=0;d=0;do{c=1<<e;d=((c&l|0)==0?0:c<<1<<e)+d+((c&i|0)==0?0:c<<e)|0;e=e+1|0}while((e|0)<(g|0))}else d=0;e=k+((X(f[o>>2]|0,l)|0)+i<<2)|0;f[e>>2]=(f[e>>2]|0)+d;i=i+1|0;e=f[o>>2]|0}while((i|0)<(e|0));d=f[n>>2]|0}l=l+1|0}while((l|0)<(d|0));u=C;return}function St(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0;k=a+8|0;d=f[k>>2]|0;l=a+4|0;c=f[l>>2]|0;if(d-c>>2>>>0>=b>>>0){IM(c|0,0,b<<2|0)|0;f[l>>2]=c+(b<<2);return}j=f[a>>2]|0;i=c-j|0;h=i>>2;c=h+b|0;if(c>>>0>1073741823)$I(a);g=d-j|0;d=g>>1;d=g>>2>>>0<536870911?(d>>>0<c>>>0?c:d):1073741823;do if(d)if(d>>>0>1073741823){l=Ra(8)|0;VK(l,44736);f[l>>2]=17660;Va(l|0,4016,428)}else{g=OK(d<<2)|0;break}else g=0;while(0);e=g+(h<<2)|0;IM(e|0,0,b<<2|0)|0;c=e+(0-h<<2)|0;if((i|0)>0)GM(c|0,j|0,i|0)|0;f[a>>2]=c;f[l>>2]=e+(b<<2);f[k>>2]=g+(d<<2);if(!j)return;QK(j);return}function Tt(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0;da=u;u=u+400|0;X=da+392|0;W=da+384|0;V=da+376|0;U=da+368|0;T=da+360|0;S=da+352|0;R=da+344|0;Q=da+336|0;P=da+328|0;O=da+320|0;N=da+312|0;M=da+304|0;L=da+296|0;K=da+288|0;ca=da+280|0;ba=da+272|0;aa=da+264|0;$=da+256|0;_=da+248|0;Z=da+240|0;Y=da+232|0;J=da+224|0;I=da+216|0;H=da+208|0;F=da+200|0;E=da+192|0;D=da+184|0;C=da+176|0;A=da+168|0;y=da+160|0;x=da+152|0;w=da+144|0;v=da+136|0;t=da+128|0;s=da+120|0;r=da+112|0;q=da+104|0;p=da+96|0;o=da+88|0;m=da+80|0;l=da+72|0;k=da+64|0;j=da+56|0;i=da+48|0;h=da+40|0;B=da+32|0;z=da+24|0;n=da+16|0;g=da+8|0;e=da;switch(c|0){case 1:{d=10100;break}case 2:{d=10604;break}default:{u=da;return}}G=f[d>>2]|0;wv(G,37628,e);f[g>>2]=b[a+1>>0];wv(G,37669,g);f[n>>2]=b[a+2>>0];wv(G,37702,n);f[z>>2]=b[a+3>>0];wv(G,37735,z);f[B>>2]=b[a+4>>0];wv(G,37779,B);f[h>>2]=b[a+5>>0];wv(G,37812,h);f[i>>2]=b[a+6>>0];wv(G,37845,i);f[j>>2]=b[a+7>>0];wv(G,37881,j);f[k>>2]=f[a+8>>2];wv(G,37917,k);f[l>>2]=b[a+12>>0];wv(G,37950,l);f[m>>2]=b[a+13>>0];wv(G,37983,m);B=a+14|0;f[o>>2]=b[B>>0];wv(G,38016,o);if(b[B>>0]|0){f[p>>2]=f[a+16>>2];wv(G,38049,p)}f[q>>2]=f[a+20>>2];wv(G,38082,q);f[r>>2]=f[a+24>>2];wv(G,38117,r);f[s>>2]=b[a+28>>0];wv(G,38152,s);f[t>>2]=b[a+29>>0];wv(G,38199,t);f[v>>2]=b[a+30>>0];wv(G,38234,v);f[w>>2]=b[a+31>>0];wv(G,38269,w);f[x>>2]=b[a+32>>0];wv(G,38304,x);B=a+34|0;f[y>>2]=b[B>>0];wv(G,38339,y);f[A>>2]=b[a+33>>0];wv(G,38374,A);if(b[B>>0]|0){e=a+36|0;f[C>>2]=f[e>>2];wv(G,38412,C);g=a+40|0;f[D>>2]=f[g>>2];wv(G,38438,D);f[E>>2]=b[a+44>>0];wv(G,38464,E);wv(G,38490,F);if((f[e>>2]|0)>=0){d=0;while(1){f[J>>2]=f[a+4252+(d<<2)>>2];wv(G,38537,J);if((d|0)<(f[e>>2]|0))d=d+1|0;else break}}wv(G,45945,H);wv(G,38515,I);if((f[g>>2]|0)>=0){d=0;while(1){f[_>>2]=f[a+4296+(d<<2)>>2];wv(G,38537,_);if((d|0)<(f[g>>2]|0))d=d+1|0;else break}}wv(G,45945,Y);f[Z>>2]=b[a+45>>0];wv(G,38542,Z)}f[$>>2]=b[a+46>>0];wv(G,38586,$);$=a+47|0;f[aa>>2]=b[$>>0];wv(G,38634,aa);if(b[$>>0]|0){f[ba>>2]=b[a+48>>0];wv(G,38678,ba);f[ca>>2]=b[a+49>>0];wv(G,38723,ca);f[K>>2]=f[a+52>>2];wv(G,38763,K);f[L>>2]=f[a+56>>2];wv(G,38781,L)}f[M>>2]=b[a+60>>0];wv(G,38799,M);f[N>>2]=b[a+4125>>0];wv(G,38839,N);f[O>>2]=f[a+4128>>2];wv(G,38876,O);f[P>>2]=b[a+4132>>0];wv(G,38913,P);f[Q>>2]=b[a+4133>>0];wv(G,38950,Q);f[R>>2]=b[a+4134>>0];wv(G,39e3,R);ca=a+4135|0;f[S>>2]=b[ca>>0];wv(G,39036,S);f[T>>2]=b[a+4136>>0];wv(G,39072,T);f[U>>2]=b[a+4137>>0];wv(G,39108,U);f[V>>2]=f[a+4160>>2];wv(G,39144,V);f[W>>2]=f[a+4164>>2];wv(G,39180,W);f[X>>2]=f[a+4168>>2];wv(G,39221,X);if(!(b[ca>>0]|0)){u=da;return}Mt(a+4138|0,c);u=da;return}function Ut(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0;if(!(b[a+34>>0]|0))return (d|c|0)==0|0;g=f[a+36>>2]|0;a:do if((g|0)>0){e=0;while(1){if((f[a+4252+(e<<2)>>2]|0)==(c|0))break;e=e+1|0;if((e|0)>=(g|0)){e=0;c=0;break a}}c=f[a+40>>2]|0;if((c|0)>0){e=0;while(1){if((f[a+4296+(e<<2)>>2]|0)==(d|0)){e=1;c=1;break a}e=e+1|0;if((e|0)>=(c|0)){e=1;c=0;break}}}else{e=1;c=0}}else{e=0;c=0}while(0);return c&e|0}function Vt(a){a=a|0;return}function Wt(a){a=a|0;QK(a);return}function Xt(a){a=a|0;var c=0,d=0,e=0,g=0,h=0,i=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;u=a+4|0;f[u>>2]=1;s=a+12|0;dt(f[s>>2]|0,a);c=f[s>>2]|0;t=f[c+5820>>2]|0;h=t+-1|0;i=f[c+5804>>2]|0;q=1<<i;r=a+8|0;g=a+24|0;ft(c,a,h,f[r>>2]|0,f[g>>2]|0);c=f[r>>2]|0;if((c|0)>0){ft(f[s>>2]|0,a,h,c+-1|0,f[g>>2]|0);c=f[r>>2]|0}d=c+1|0;e=f[s>>2]|0;if((d|0)<(f[e+5828>>2]|0)){ft(e,a,h,d,f[g>>2]|0);c=f[r>>2]|0}o=a+20|0;p=a+16|0;at(f[o>>2]|0,f[p>>2]|0,c<<i,c+1<<i);c=f[s>>2]|0;a:do if((f[c+5820>>2]|0)>0){n=0;do{i=f[r>>2]|0;d=(X(f[c+10352>>2]|0,i)|0)+n|0;d=j[(f[c+10340>>2]|0)+(d*24|0)+2>>1]|0;e=f[c+48>>2]|0;if(d>>>0>=(f[c+52>>2]|0)-e>>2>>>0)break a;m=f[e+(d<<2)>>2]|0;if(!m)break a;do if(b[m+325>>0]|0){d=f[p>>2]|0;g=f[d+4>>2]|0;d=f[d+40>>2]|0;e=f[o>>2]|0;h=f[e+4>>2]|0;e=f[e+40>>2]|0;if((f[c+5760>>2]|0)>8){Zt(c,n,i,m,0,q,q,g,d,h,e);break}else{_t(c,n,i,m,0,q,q,g,d,h,e);break}}while(0);do if(b[m+326>>0]|0){e=f[s>>2]|0;k=(q|0)/(f[e+5780>>2]|0)|0;l=(q|0)/(f[e+5784>>2]|0)|0;g=f[r>>2]|0;d=f[p>>2]|0;h=f[d+8>>2]|0;d=f[d+44>>2]|0;c=f[o>>2]|0;i=f[c+8>>2]|0;c=f[c+44>>2]|0;if((f[e+5768>>2]|0)>8)Zt(e,n,g,m,1,k,l,h,d,i,c);else _t(e,n,g,m,1,k,l,h,d,i,c);h=f[s>>2]|0;i=f[r>>2]|0;d=f[p>>2]|0;e=f[d+12>>2]|0;d=f[d+44>>2]|0;c=f[o>>2]|0;g=f[c+12>>2]|0;c=f[c+44>>2]|0;if((f[h+5768>>2]|0)>8){Zt(h,n,i,m,2,k,l,e,d,g,c);break}else{_t(h,n,i,m,2,k,l,e,d,g,c);break}}while(0);n=n+1|0;c=f[s>>2]|0}while((n|0)<(f[c+5820>>2]|0))}while(0);if((t|0)>0)d=0;else{t=c;f[u>>2]=3;et(t,a);return}do{ev((f[c+10524>>2]|0)+(((X(f[r>>2]|0,f[c+5820>>2]|0)|0)+d|0)*80|0)|0,4);d=d+1|0;c=f[s>>2]|0}while((d|0)!=(t|0));f[u>>2]=3;et(c,a);return}function Yt(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0;e=u;u=u+112|0;g=e;d=e+4|0;f[g>>2]=f[c+8>>2];Hy(d,39262,g)|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;c=vx(d)|0;if(c>>>0>4294967279)XK(a);if(c>>>0<11){b[a+11>>0]=c;if(!c){g=a;g=g+c|0;b[g>>0]=0;u=e;return}}else{h=c+16&-16;g=OK(h)|0;f[a>>2]=g;f[a+8>>2]=h|-2147483648;f[a+4>>2]=c;a=g}GM(a|0,d|0,c|0)|0;h=a;h=h+c|0;b[h>>0]=0;u=e;return}
function Zt(a,c,e,g,i,k,l,m,n,o,p){a=a|0;c=c|0;e=e|0;g=g|0;i=i|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;p=p|0;var q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0;ra=u;u=u+144|0;na=ra+8|0;ba=ra;ca=ra+136|0;da=a+10352|0;q=f[da>>2]|0;F=(X(q,e)|0)+c|0;oa=f[a+10340>>2]|0;s=i<<1;t=(h[oa+(F*24|0)+4>>0]|0)>>>s&3;if(!t){u=ra;return}r=(i|0)==0;x=f[(r?a+5760|0:a+5768|0)>>2]|0;pa=1<<x;qa=pa+-1|0;ma=X(k,c)|0;la=X(l,e)|0;Z=f[(r?a+24|0:a+32|0)>>2]|0;_=f[(r?a+28|0:a+36|0)>>2]|0;$=f[a+10348>>2]|0;g=ma>>$;c=la>>$;if(!((g|0)>-1&(g|0)<(q|0)))Pa(48699,48736,118,48756);if((c|0)<=-1)Pa(48760,48736,119,48756);aa=f[a+10356>>2]|0;if((c|0)>=(aa|0))Pa(48760,48736,119,48756);U=oa+(((X(c,q)|0)+g|0)*24|0)+2|0;S=a+52|0;T=f[a+48>>2]|0;U=f[(f[T+(j[U>>1]<<2)>>2]|0)+800>>2]|0;V=f[a+5820>>2]|0;W=T;if(r){ga=0;ha=0}else{ga=(f[a+5780>>2]|0)+-1|0;ha=(f[a+5784>>2]|0)+-1|0}R=f[a+5804>>2]|0;Q=R-ga|0;R=R-ha|0;ja=(ma+k|0)>(Z|0)?Z-ma|0:k;ia=(la+l|0)>(_|0)?_-la|0:l;Y=(b[oa+(F*24|0)+22>>0]|0)!=0;if((t|0)!=2){g=h[oa+(F*24|0)+6+i>>0]|0;c=na;e=c+128|0;do{f[c>>2]=0;c=c+4|0}while((c|0)<(e|0));f[na+((g&31)<<2)>>2]=1;f[na+((g+1&31)<<2)>>2]=2;f[na+((g+2&31)<<2)>>2]=3;f[na+((g+3&31)<<2)>>2]=4;E=x+-5|0;g=(ia|0)>0;a:do if(Y){if(g){z=(ja|0)>0;A=a+5480|0;B=a+10368|0;C=a+10372|0;D=a+10376|0;x=a+10360|0;y=(E|0)>7;w=0;b:while(1){c:do if(z){s=w+la|0;v=s<<ha;l=X(s,n)|0;s=X(s,p)|0;a=(b[A>>0]|0)==0;if(y){l=f[B>>2]|0;s=v>>l;t=(s|0)>-1;r=v>>l;k=(r|0)>-1;q=0;while(1){g=q+ma<<ga;if(!a){c=g>>l;if((c|0)<=-1){ka=88;break b}e=f[C>>2]|0;if((c|0)>=(e|0)){ka=88;break b}if(!k){ka=91;break b}if((r|0)>=(f[D>>2]|0)){ka=91;break b}fa=(f[x>>2]|0)+(((X(e,r)|0)+c|0)*3|0)|0;if(!((h[fa>>0]|h[fa+1>>0]<<8)&1024))ka=79}else ka=79;if((ka|0)==79){ka=0;g=g>>l;if((g|0)<=-1){ka=95;break b}if((g|0)>=(f[C>>2]|0)){ka=95;break b}if(!t){ka=98;break b}if((s|0)>=(f[D>>2]|0)){ka=98;break b}}q=q+1|0;if((q|0)>=(ja|0))break c}}else k=0;do{t=k+ma|0;g=t<<ga;r=f[B>>2]|0;if(!a){c=g>>r;e=v>>r;if((c|0)<=-1){ka=88;break b}q=f[C>>2]|0;if((c|0)>=(q|0)){ka=88;break b}if((e|0)<=-1){ka=91;break b}if((e|0)>=(f[D>>2]|0)){ka=91;break b}fa=(f[x>>2]|0)+(((X(q,e)|0)+c|0)*3|0)|0;if(!((h[fa>>0]|h[fa+1>>0]<<8)&1024))ka=93}else ka=93;do if((ka|0)==93){ka=0;e=g>>r;g=v>>r;if((e|0)<=-1){ka=95;break b}c=f[C>>2]|0;if((e|0)>=(c|0)){ka=95;break b}if((g|0)<=-1){ka=98;break b}if((g|0)>=(f[D>>2]|0)){ka=98;break b}fa=(f[x>>2]|0)+(((X(c,g)|0)+e|0)*3|0)|0;if((h[fa>>0]|h[fa+1>>0]<<8)&2048)break;g=j[m+(t+l<<1)>>1]|0;c=f[na+(g>>>E<<2)>>2]|0;if((c|0)<=0)break;fa=(b[c+-1+(oa+(F*24|0)+9+(i<<2))>>0]|0)+g|0;d[o+(t+s<<1)>>1]=(fa|0)<0?0:((fa|0)<(pa|0)?fa:qa)&65535}while(0);k=k+1|0}while((k|0)<(ja|0))}while(0);w=w+1|0;if((w|0)>=(ia|0))break a}if((ka|0)==88)Pa(48699,48736,118,48756);else if((ka|0)==91)Pa(48760,48736,119,48756);else if((ka|0)==95)Pa(48699,48736,118,48756);else if((ka|0)==98)Pa(48760,48736,119,48756)}}else if(g?(y=(E|0)>7,(ja|0)>0):0){c=0;do{q=c+la|0;e=X(q,n)|0;q=X(q,p)|0;if(!y){g=0;do{r=g+ma|0;k=j[m+(r+e<<1)>>1]|0;l=f[na+(k>>>E<<2)>>2]|0;if((l|0)>0){ka=(b[l+-1+(oa+(F*24|0)+9+(i<<2))>>0]|0)+k|0;d[o+(r+q<<1)>>1]=(ka|0)<0?0:((ka|0)<(pa|0)?ka:qa)&65535}g=g+1|0}while((g|0)<(ja|0))}c=c+1|0}while((c|0)<(ia|0))}while(0);u=ra;return}switch((h[oa+(F*24|0)+5>>0]|0)>>>s&3){case 0:{w=0;v=0;ea=-1;fa=1;break}case 1:{w=1;v=-1;ea=0;fa=0;break}case 2:{w=1;v=-1;ea=-1;fa=1;break}case 3:{w=1;v=-1;ea=1;fa=-1;break}default:{}}f[na>>2]=ea;f[na+4>>2]=fa;f[ba>>2]=v;f[ba+4>>2]=w;P=X(v,n)|0;O=0-w&n;b[ca>>0]=b[oa+(F*24|0)+9+(i<<2)>>0]|0;b[ca+1>>0]=b[oa+(F*24|0)+9+(i<<2)+1>>0]|0;b[ca+2>>0]=0;b[ca+3>>0]=b[oa+(F*24|0)+9+(i<<2)+2>>0]|0;b[ca+4>>0]=b[oa+(F*24|0)+9+(i<<2)+3>>0]|0;if((ia|0)<=0){u=ra;return}i=(ja|0)>0;G=a+5480|0;H=a+10368|0;I=a+10372|0;J=a+10376|0;K=a+10360|0;L=ja+-1|0;M=ia+-1|0;N=a+5977|0;x=a+10308|0;y=(X(la>>R,V)|0)+(ma>>Q)|0;v=0;d:while(1){a=v+la|0;z=m+((X(a,n)|0)+ma<<1)|0;A=o+((X(a,p)|0)+ma<<1)|0;if(i){B=a<<ha;C=(v|0)==0;D=(v|0)==(M|0);E=B>>$;F=(E|0)<0|(E|0)>=(aa|0);w=0;do{if(Y?(b[G>>0]|0)!=0:0){c=f[H>>2]|0;g=w+ma<<ga>>c;c=B>>c;if((g|0)<=-1){ka=23;break d}e=f[I>>2]|0;if((g|0)>=(e|0)){ka=23;break d}if((c|0)<=-1){ka=26;break d}if((c|0)>=(f[J>>2]|0)){ka=26;break d}t=(f[K>>2]|0)+(((X(e,c)|0)+g|0)*3|0)|0;if(!((h[t>>0]|h[t+1>>0]<<8)&1024))ka=28}else ka=28;e:do if((ka|0)==28){ka=0;t=w+ma|0;g=t<<ga;e=f[H>>2]|0;c=g>>e;e=B>>e;if((c|0)<=-1){ka=30;break d}q=f[I>>2]|0;if((c|0)>=(q|0)){ka=30;break d}if((e|0)<=-1){ka=33;break d}if((e|0)>=(f[J>>2]|0)){ka=33;break d}s=(f[K>>2]|0)+(((X(q,e)|0)+c|0)*3|0)|0;if(!((h[s>>0]|h[s+1>>0]<<8)&2048)){if(D|((w|0)==(L|0)|(C|(w|0)==0))){q=g>>$;r=(q|0)>-1;e=0;do{k=(f[na+(e<<2)>>2]|0)+t|0;l=(f[ba+(e<<2)>>2]|0)+a|0;if(!((l|0)<(_|0)&((k|0)<(Z|0)&(l|k|0)>-1)))break e;g=k<<ga>>$;c=l<<ha>>$;if((g|0)<=-1){ka=40;break d}s=f[da>>2]|0;if((g|0)>=(s|0)){ka=40;break d}if(!((c|0)>-1&(c|0)<(aa|0))){ka=42;break d}c=oa+(((X(s,c)|0)+g|0)*24|0)+2|0;c=j[c>>1]|0;if(c>>>0>=(f[S>>2]|0)-W>>2>>>0){ka=59;break d}g=f[T+(c<<2)>>2]|0;if(!g){ka=59;break d}g=f[g+800>>2]|0;if((g|0)<(U|0)){if(!(r&(q|0)<(s|0))){ka=47;break d}if(F){ka=49;break d}s=oa+(((X(s,E)|0)+q|0)*24|0)+2|0;if(!(b[(f[T+(j[s>>1]<<2)>>2]|0)+764>>0]|0))break e}if((g|0)>(U|0)?(b[(f[T+(c<<2)>>2]|0)+764>>0]|0)==0:0)break e;if((b[N>>0]|0)==0?(l=(X(l>>R,V)|0)+(k>>Q)|0,s=f[x>>2]|0,(f[s+(l<<2)>>2]|0)!=(f[s+(y<<2)>>2]|0)):0)break e;e=e+1|0}while((e|0)<2)}t=j[z+(w<<1)>>1]|0;l=t-(j[z+(w+P+ea<<1)>>1]|0)|0;s=t-(j[z+(w+O+fa<<1)>>1]|0)|0;t=(b[ca+(((l|0)<0?1:l|0?3:2)+((s|0)<0?-1:(s|0)!=0&1))>>0]|0)+t|0;d[A+(w<<1)>>1]=(t|0)<0?0:((t|0)<(pa|0)?t:qa)&65535}}while(0);w=w+1|0}while((w|0)<(ja|0))}v=v+1|0;if((v|0)>=(ia|0)){ka=59;break}}if((ka|0)==23)Pa(48699,48736,118,48756);else if((ka|0)==26)Pa(48760,48736,119,48756);else if((ka|0)==30)Pa(48699,48736,118,48756);else if((ka|0)==33)Pa(48760,48736,119,48756);else if((ka|0)==40)Pa(48699,48736,118,48756);else if((ka|0)==42)Pa(48760,48736,119,48756);else if((ka|0)==47)Pa(48699,48736,118,48756);else if((ka|0)==49)Pa(48760,48736,119,48756);else if((ka|0)==59){u=ra;return}}function _t(a,c,d,e,g,i,k,l,m,n,o){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;i=i|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;var p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0;sa=u;u=u+144|0;pa=sa+8|0;ca=sa;da=sa+136|0;ea=a+10352|0;p=f[ea>>2]|0;E=(X(p,d)|0)+c|0;fa=a+10340|0;F=f[fa>>2]|0;r=g<<1;s=(h[F+(E*24|0)+4>>0]|0)>>>r&3;if(!s){u=sa;return}q=(g|0)==0;w=f[(q?a+5760|0:a+5768|0)>>2]|0;qa=1<<w;ra=qa+-1|0;oa=X(i,c)|0;na=X(k,d)|0;_=f[(q?a+24|0:a+32|0)>>2]|0;$=f[(q?a+28|0:a+36|0)>>2]|0;aa=a+10348|0;c=f[aa>>2]|0;e=oa>>c;c=na>>c;if(!((e|0)>-1&(e|0)<(p|0)))Pa(48699,48736,118,48756);if((c|0)<=-1)Pa(48760,48736,119,48756);ba=a+10356|0;if((c|0)>=(f[ba>>2]|0))Pa(48760,48736,119,48756);W=F+(((X(c,p)|0)+e|0)*24|0)+2|0;U=a+48|0;V=a+52|0;W=f[(f[(f[U>>2]|0)+(j[W>>1]<<2)>>2]|0)+800>>2]|0;Y=f[a+5820>>2]|0;if(q){ia=0;ja=0}else{ia=(f[a+5780>>2]|0)+-1|0;ja=(f[a+5784>>2]|0)+-1|0}T=f[a+5804>>2]|0;S=T-ia|0;T=T-ja|0;la=(oa+i|0)>(_|0)?_-oa|0:i;ka=(na+k|0)>($|0)?$-na|0:k;Z=(b[F+(E*24|0)+22>>0]|0)!=0;if((s|0)!=2){e=h[F+(E*24|0)+6+g>>0]|0;c=pa;d=c+128|0;do{f[c>>2]=0;c=c+4|0}while((c|0)<(d|0));f[pa+((e&31)<<2)>>2]=1;f[pa+((e+1&31)<<2)>>2]=2;f[pa+((e+2&31)<<2)>>2]=3;f[pa+((e+3&31)<<2)>>2]=4;D=w+-5|0;e=(ka|0)>0;a:do if(Z){if(e){y=(la|0)>0;z=a+5480|0;A=a+10368|0;B=a+10372|0;C=a+10376|0;x=a+10360|0;a=(D|0)>7;w=0;b:while(1){c:do if(y){r=w+na|0;v=r<<ja;k=X(r,m)|0;r=X(r,o)|0;if(a){r=(b[z>>0]|0)==0;k=f[A>>2]|0;s=v>>k;t=(s|0)>-1;q=v>>k;i=(q|0)>-1;p=0;while(1){e=p+oa<<ia;if(!r){c=e>>k;if((c|0)<=-1){ma=88;break b}d=f[B>>2]|0;if((c|0)>=(d|0)){ma=88;break b}if(!i){ma=91;break b}if((q|0)>=(f[C>>2]|0)){ma=91;break b}ha=(f[x>>2]|0)+(((X(d,q)|0)+c|0)*3|0)|0;if(!((h[ha>>0]|h[ha+1>>0]<<8)&1024))ma=79}else ma=79;if((ma|0)==79){ma=0;e=e>>k;if((e|0)<=-1){ma=95;break b}if((e|0)>=(f[B>>2]|0)){ma=95;break b}if(!t){ma=98;break b}if((s|0)>=(f[C>>2]|0)){ma=98;break b}}p=p+1|0;if((p|0)>=(la|0))break c}}else i=0;do{s=i+oa|0;e=s<<ia;q=f[A>>2]|0;if(b[z>>0]|0){c=e>>q;d=v>>q;if((c|0)<=-1){ma=88;break b}p=f[B>>2]|0;if((c|0)>=(p|0)){ma=88;break b}if((d|0)<=-1){ma=91;break b}if((d|0)>=(f[C>>2]|0)){ma=91;break b}ha=(f[x>>2]|0)+(((X(p,d)|0)+c|0)*3|0)|0;if(!((h[ha>>0]|h[ha+1>>0]<<8)&1024))ma=93}else ma=93;do if((ma|0)==93){ma=0;d=e>>q;e=v>>q;if((d|0)<=-1){ma=95;break b}c=f[B>>2]|0;if((d|0)>=(c|0)){ma=95;break b}if((e|0)<=-1){ma=98;break b}if((e|0)>=(f[C>>2]|0)){ma=98;break b}ha=(f[x>>2]|0)+(((X(c,e)|0)+d|0)*3|0)|0;if((h[ha>>0]|h[ha+1>>0]<<8)&2048)break;e=h[l+(s+k)>>0]|0;c=f[pa+(e>>>D<<2)>>2]|0;if((c|0)<=0)break;ha=(b[c+-1+(F+(E*24|0)+9+(g<<2))>>0]|0)+e|0;b[n+(s+r)>>0]=(ha|0)<0?0:((ha|0)<(qa|0)?ha:ra)&255}while(0);i=i+1|0}while((i|0)<(la|0))}while(0);w=w+1|0;if((w|0)>=(ka|0))break a}if((ma|0)==88)Pa(48699,48736,118,48756);else if((ma|0)==91)Pa(48760,48736,119,48756);else if((ma|0)==95)Pa(48699,48736,118,48756);else if((ma|0)==98)Pa(48760,48736,119,48756)}}else if(e?(x=(D|0)>7,(la|0)>0):0){c=0;do{p=c+na|0;d=X(p,m)|0;p=X(p,o)|0;if(!x){e=0;do{q=e+oa|0;i=h[l+(q+d)>>0]|0;k=f[pa+(i>>>D<<2)>>2]|0;if((k|0)>0){ma=(b[k+-1+(F+(E*24|0)+9+(g<<2))>>0]|0)+i|0;b[n+(q+p)>>0]=(ma|0)<0?0:((ma|0)<(qa|0)?ma:ra)&255}e=e+1|0}while((e|0)<(la|0))}c=c+1|0}while((c|0)<(ka|0))}while(0);u=sa;return}switch((h[F+(E*24|0)+5>>0]|0)>>>r&3){case 0:{v=0;t=0;ga=-1;ha=1;break}case 1:{v=1;t=-1;ga=0;ha=0;break}case 2:{v=1;t=-1;ga=-1;ha=1;break}case 3:{v=1;t=-1;ga=1;ha=-1;break}default:{}}f[pa>>2]=ga;f[pa+4>>2]=ha;f[ca>>2]=t;f[ca+4>>2]=v;R=X(t,m)|0;Q=0-v&m;b[da>>0]=b[F+(E*24|0)+9+(g<<2)>>0]|0;b[da+1>>0]=b[F+(E*24|0)+9+(g<<2)+1>>0]|0;b[da+2>>0]=0;b[da+3>>0]=b[F+(E*24|0)+9+(g<<2)+2>>0]|0;b[da+4>>0]=b[F+(E*24|0)+9+(g<<2)+3>>0]|0;if((ka|0)<=0){u=sa;return}H=(la|0)>0;I=a+5480|0;J=a+10368|0;K=a+10372|0;L=a+10376|0;M=a+10360|0;N=la+-1|0;O=ka+-1|0;P=a+5977|0;A=a+10308|0;B=(X(na>>T,Y)|0)+(oa>>S)|0;y=0;d:while(1){C=y+na|0;D=l+((X(C,m)|0)+oa)|0;E=n+((X(C,o)|0)+oa)|0;if(H){F=C<<ja;g=(y|0)==0;G=(y|0)==(O|0);z=0;do{if(Z?(b[I>>0]|0)!=0:0){c=f[J>>2]|0;e=z+oa<<ia>>c;c=F>>c;if((e|0)<=-1){ma=23;break d}d=f[K>>2]|0;if((e|0)>=(d|0)){ma=23;break d}if((c|0)<=-1){ma=26;break d}if((c|0)>=(f[L>>2]|0)){ma=26;break d}a=(f[M>>2]|0)+(((X(d,c)|0)+e|0)*3|0)|0;if(!((h[a>>0]|h[a+1>>0]<<8)&1024))ma=28}else ma=28;e:do if((ma|0)==28){ma=0;x=z+oa|0;a=x<<ia;c=f[J>>2]|0;e=a>>c;c=F>>c;if((e|0)<=-1){ma=30;break d}d=f[K>>2]|0;if((e|0)>=(d|0)){ma=30;break d}if((c|0)<=-1){ma=33;break d}if((c|0)>=(f[L>>2]|0)){ma=33;break d}w=(f[M>>2]|0)+(((X(d,c)|0)+e|0)*3|0)|0;if(!((h[w>>0]|h[w+1>>0]<<8)&2048)){if(G|((z|0)==(N|0)|(g|(z|0)==0))){k=0;do{r=(f[pa+(k<<2)>>2]|0)+x|0;s=(f[ca+(k<<2)>>2]|0)+C|0;if(!((s|0)<($|0)&((r|0)<(_|0)&(s|r|0)>-1)))break e;i=f[aa>>2]|0;e=r<<ia>>i;c=s<<ja>>i;if((e|0)<=-1){ma=39;break d}t=f[ea>>2]|0;if((e|0)>=(t|0)){ma=39;break d}if((c|0)<=-1){ma=42;break d}v=f[ba>>2]|0;if((c|0)>=(v|0)){ma=42;break d}w=f[fa>>2]|0;e=w+(((X(t,c)|0)+e|0)*24|0)+2|0;e=j[e>>1]|0;p=f[U>>2]|0;q=p;if(e>>>0>=(f[V>>2]|0)-p>>2>>>0){ma=59;break d}c=f[q+(e<<2)>>2]|0;if(!c){ma=59;break d}d=f[c+800>>2]|0;if((d|0)<(W|0)){p=a>>i;e=F>>i;if(!((p|0)>-1&(p|0)<(t|0))){ma=47;break d}if(!((e|0)>-1&(e|0)<(v|0))){ma=49;break d}w=w+(((X(t,e)|0)+p|0)*24|0)+2|0;if(!(b[(f[q+(j[w>>1]<<2)>>2]|0)+764>>0]|0))break e}if((d|0)>(W|0)?(b[c+764>>0]|0)==0:0)break e;if((b[P>>0]|0)==0?(v=(X(s>>T,Y)|0)+(r>>S)|0,w=f[A>>2]|0,(f[w+(v<<2)>>2]|0)!=(f[w+(B<<2)>>2]|0)):0)break e;k=k+1|0}while((k|0)<2)}a=h[D+z>>0]|0;w=a-(h[D+(z+R+ga)>>0]|0)|0;x=a-(h[D+(z+Q+ha)>>0]|0)|0;a=(b[da+(((w|0)<0?1:w|0?3:2)+((x|0)<0?-1:(x|0)!=0&1))>>0]|0)+a|0;b[E+z>>0]=(a|0)<0?0:((a|0)<(qa|0)?a:ra)&255}}while(0);z=z+1|0}while((z|0)<(la|0))}y=y+1|0;if((y|0)>=(ka|0)){ma=59;break}}if((ma|0)==23)Pa(48699,48736,118,48756);else if((ma|0)==26)Pa(48760,48736,119,48756);else if((ma|0)==30)Pa(48699,48736,118,48756);else if((ma|0)==33)Pa(48760,48736,119,48756);else if((ma|0)==39)Pa(48699,48736,118,48756);else if((ma|0)==42)Pa(48760,48736,119,48756);else if((ma|0)==47)Pa(48699,48736,118,48756);else if((ma|0)==49)Pa(48760,48736,119,48756);else if((ma|0)==59){u=sa;return}}function $t(a){a=a|0;var c=0,d=0,e=0,g=0,h=0,i=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0;if(!(b[a+5467>>0]|0))return;F=a+40|0;G=a+28|0;q=X(f[G>>2]|0,f[F>>2]|0)|0;H=a+5760|0;q=X(q,((f[H>>2]|0)+7|0)/8|0)|0;s=a+44|0;t=a+36|0;I=X(f[t>>2]|0,f[s>>2]|0)|0;u=a+5768|0;I=X(I,((f[u>>2]|0)+7|0)/8|0)|0;I=(q|0)>(I|0)?q:I;I=PK((I|0)>-1?I:-1)|0;q=(f[a+5776>>2]|0)==0?1:3;v=a+5828|0;w=a+5820|0;x=a+10352|0;y=a+10340|0;z=a+48|0;A=a+52|0;B=a+5804|0;C=a+4|0;D=a+5780|0;E=a+5784|0;r=0;c=f[v>>2]|0;a:while(1){o=(r|0)==0;n=o?F:s;l=f[n>>2]|0;p=a+4+(r<<2)|0;k=X(f[(o?G:t)>>2]|0,l)|0;m=o?H:u;GM(I|0,f[p>>2]|0,X(k,((f[m>>2]|0)+7|0)/8|0)|0)|0;if((c|0)>0){k=0;c=f[w>>2]|0;while(1){if((c|0)>0){i=0;while(1){c=(X(f[x>>2]|0,k)|0)+i|0;c=j[(f[y>>2]|0)+(c*24|0)+2>>1]|0;d=f[z>>2]|0;if(c>>>0>=(f[A>>2]|0)-d>>2>>>0){c=21;break a}h=f[d+(c<<2)>>2]|0;if(!h){c=21;break a}do if(o){if(b[h+325>>0]|0){d=1<<f[B>>2];e=f[C>>2]|0;c=f[F>>2]|0;if((f[H>>2]|0)>8){Zt(a,i,k,h,0,d,d,I,l,e,c);break}else{_t(a,i,k,h,0,d,d,I,l,e,c);break}}}else if(b[h+326>>0]|0){e=1<<f[B>>2];d=(e|0)/(f[D>>2]|0)|0;e=(e|0)/(f[E>>2]|0)|0;g=f[p>>2]|0;c=f[n>>2]|0;if((f[m>>2]|0)>8){Zt(a,i,k,h,r,d,e,I,l,g,c);break}else{_t(a,i,k,h,r,d,e,I,l,g,c);break}}while(0);i=i+1|0;c=f[w>>2]|0;if((i|0)>=(c|0)){d=c;break}}}else d=c;k=k+1|0;c=f[v>>2]|0;if((k|0)>=(c|0))break;else c=d}}r=r+1|0;if((r|0)>=(q|0)){c=20;break}}if((c|0)==20){RK(I);return}else if((c|0)==21)return}function au(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;o=u;u=u+16|0;m=o;n=f[a>>2]|0;if(!(b[n+5467>>0]|0)){n=0;u=o;return n|0}d=n+10332|0;e=f[d>>2]|0;l=a+8|0;k=n+10480|0;if(Ss(l,f[n+24>>2]|0,f[n+28>>2]|0,f[n+20>>2]|0,n+764|0,0,e,f[n+10336>>2]|0,f[k>>2]|0,f[k+4>>2]|0,f[n+10488>>2]|0,1)|0){uq((f[d>>2]|0)+4|0,1024,0);n=0;u=o;return n|0}i=f[n+5828>>2]|0;ct(n,i);if((i|0)>0){j=a+10668|0;k=a+10672|0;h=e+375396|0;e=a+10664|0;d=0;do{a=OK(28)|0;f[a+4>>2]=0;f[a>>2]=7752;f[a+16>>2]=n;f[a+20>>2]=l;f[a+12>>2]=n;f[a+8>>2]=d;f[a+24>>2]=c;f[m>>2]=a;g=f[j>>2]|0;if(g>>>0<(f[k>>2]|0)>>>0){f[g>>2]=a;f[j>>2]=(f[j>>2]|0)+4}else iq(e,m);iv(h,a);d=d+1|0}while((d|0)!=(i|0))}ht(n);bt(n,l);n=1;u=o;return n|0}function bu(a,b){a=a|0;b=b|0;var c=0;switch(b|0){case 0:{b=7796;c=4;break}case 1:{b=7824;c=4;break}case 2:{b=7768;c=4;break}default:b=0}if((c|0)==4)b=f[b+(a<<2)>>2]|0;return b|0}function cu(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;g=(f[7852+(e*24|0)+(g<<2)>>2]|0)+((d<<g)+c<<1)|0;g=h[g>>0]|h[g+1>>0]<<8;b[a>>0]=g;b[a+1>>0]=g>>8;return}function du(){var a=0,c=0,d=0,e=0,g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;j=1;do{g=f[7824+(j<<2)>>2]|0;k=1<<j;a=0;c=0;while(1){i=a&255;d=0;e=c;while(1){b[g+(e<<1)>>0]=d;b[g+(e<<1)+1>>0]=i;d=d+1|0;if((d|0)==(k|0))break;else e=e+1|0}a=a+1|0;if((a|0)==(k|0))break;else c=c+k|0}g=f[7768+(j<<2)>>2]|0;a=0;c=0;while(1){i=a&255;d=0;e=c;while(1){b[g+(e<<1)>>0]=i;b[g+(e<<1)+1>>0]=d;d=d+1|0;if((d|0)==(k|0))break;else e=e+1|0}a=a+1|0;if((a|0)==(k|0))break;else c=c+k|0}g=f[7796+(j<<2)>>2]|0;i=k<<j;c=0;a=0;do if((c|0)>-1){e=0;d=c;while(1){if((d|0)<(k|0)&(e|0)<(k|0)){b[g+(a<<1)>>0]=e;b[g+(a<<1)+1>>0]=d;a=a+1|0}c=e+1|0;if((d|0)>0){e=c;d=d+-1|0}else break}}else c=0;while((a|0)<(i|0));j=j+1|0}while((j|0)!=6);l=2;do{m=1<<l;q=l+-2|0;n=(1<<q<<q)+-1|0;o=7768+(q<<2)|0;p=7796+(q<<2)|0;q=7824+(q<<2)|0;k=0;do{r=f[7852+(k*24|0)+(l<<2)>>2]|0;t=(k|0)==2;i=t?66931:0;j=0;do{s=j<<l;switch(k|0){case 0:{e=f[p>>2]|0;d=0;do{a=16;c=n;while(1){g=(a|0)==0;c=(g<<31>>31)+c|0;a=g?15:a+-1|0;if((((h[e+(c<<1)>>0]|0)<<2)+(h[64203+(a<<1)>>0]|0)|0)!=(d|0))continue;if((((h[e+(c<<1)+1>>0]|0)<<2)+(h[64203+(a<<1)+1>>0]|0)|0)==(j|0))break}g=d+s|0;b[r+(g<<1)>>0]=c;b[r+(g<<1)+1>>0]=a;d=d+1|0}while((d|0)<(m|0));break}case 1:{e=f[q>>2]|0;d=0;do{a=16;c=n;while(1){g=(a|0)==0;c=(g<<31>>31)+c|0;a=g?15:a+-1|0;if((((h[e+(c<<1)>>0]|0)<<2)+(h[61475+(a<<1)>>0]|0)|0)!=(d|0))continue;if((((h[e+(c<<1)+1>>0]|0)<<2)+(h[61475+(a<<1)+1>>0]|0)|0)==(j|0))break}g=d+s|0;b[r+(g<<1)>>0]=c;b[r+(g<<1)+1>>0]=a;d=d+1|0}while((d|0)<(m|0));break}default:{e=0;do{g=e+s|0;if(t)c=f[o>>2]|0;else c=0;a=16;d=n;while(1){u=(a|0)==0;d=(u<<31>>31)+d|0;a=u?15:a+-1|0;if((((h[c+(d<<1)>>0]|0)<<2)+(h[i+(a<<1)>>0]|0)|0)!=(e|0))continue;if((((h[c+(d<<1)+1>>0]|0)<<2)+(h[i+(a<<1)+1>>0]|0)|0)==(j|0))break}b[r+(g<<1)>>0]=d;b[r+(g<<1)+1>>0]=a;e=e+1|0}while((e|0)<(m|0))}}j=j+1|0}while((j|0)<(m|0));k=k+1|0}while((k|0)!=3);l=l+1|0}while((l|0)!=6);return}function eu(a,c,e,g){a=a|0;c=c|0;e=e|0;g=g|0;var h=0,i=0;e=0;do{i=Ov(a,8)|0;e=i+e|0}while((i|0)==255);h=0;do{i=Ov(a,8)|0;h=i+h|0}while((i|0)==255);f[c>>2]=e;f[c+4>>2]=h;if((e|0)!=132){c=0;return c|0}h=Ov(a,8)|0;i=c+8|0;f[i>>2]=h;if(!g){c=1025;return c|0}g=(f[g+476>>2]|0)==0?1:3;e=0;while(1){switch(h|0){case 0:{h=(Ov(a,8)|0)&255;b[c+12+(e<<4)>>0]=h;h=(Ov(a,8)|0)&255;b[c+12+(e<<4)+1>>0]=h;h=(Ov(a,8)|0)&255;b[c+12+(e<<4)+2>>0]=h;h=(Ov(a,8)|0)&255;b[c+12+(e<<4)+3>>0]=h;h=(Ov(a,8)|0)&255;b[c+12+(e<<4)+4>>0]=h;h=(Ov(a,8)|0)&255;b[c+12+(e<<4)+5>>0]=h;h=(Ov(a,8)|0)&255;b[c+12+(e<<4)+6>>0]=h;h=(Ov(a,8)|0)&255;b[c+12+(e<<4)+7>>0]=h;h=(Ov(a,8)|0)&255;b[c+12+(e<<4)+8>>0]=h;h=(Ov(a,8)|0)&255;b[c+12+(e<<4)+9>>0]=h;h=(Ov(a,8)|0)&255;b[c+12+(e<<4)+10>>0]=h;h=(Ov(a,8)|0)&255;b[c+12+(e<<4)+11>>0]=h;h=(Ov(a,8)|0)&255;b[c+12+(e<<4)+12>>0]=h;h=(Ov(a,8)|0)&255;b[c+12+(e<<4)+13>>0]=h;h=(Ov(a,8)|0)&255;b[c+12+(e<<4)+14>>0]=h;h=(Ov(a,8)|0)&255;b[c+12+(e<<4)+15>>0]=h;break}case 1:{h=(Ov(a,16)|0)&65535;d[c+60+(e<<1)>>1]=h;break}case 2:{h=Ov(a,32)|0;f[c+68+(e<<2)>>2]=h;break}default:{}}e=e+1|0;if((e|0)>=(g|0)){e=0;break}h=f[i>>2]|0}return e|0}function fu(a,b){a=a|0;b=b|0;return}function gu(a,c){a=a|0;c=c|0;var e=0,g=0,i=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0;aa=u;u=u+208|0;$=aa+24|0;_=aa+8|0;Z=aa;B=aa+40|0;M=aa+192|0;if((f[a>>2]|0)!=132){$=0;u=aa;return $|0}if(!(b[(f[c+10332>>2]|0)+512>>0]|0)){$=0;u=aa;return $|0}if(!(b[c+100>>0]|0)){$=0;u=aa;return $|0}x=(f[c+1240>>2]|0)==0?1:3;y=c+32|0;z=c+24|0;A=c+36|0;C=c+28|0;D=c+40|0;E=c+44|0;F=a+8|0;G=c+5760|0;H=c+5768|0;I=M+1|0;J=M+2|0;K=M+3|0;L=M+4|0;N=M+5|0;O=M+6|0;P=M+7|0;Q=M+8|0;R=M+9|0;S=M+10|0;T=M+11|0;U=M+12|0;V=M+13|0;W=M+14|0;Y=M+15|0;w=0;a:while(1){g=(w|0)==0;r=f[(g?z:y)>>2]|0;t=f[(g?C:A)>>2]|0;s=f[c+4+(w<<2)>>2]|0;q=f[(g?D:E)>>2]|0;switch(f[F>>2]|0){case 0:{e=f[(g?G:H)>>2]|0;Hw(B);b:do if((t|0)>0){n=r<<1;o=(r|0)<0?-1:n;if((e|0)<=8){e=0;while(1){Iw(B,s+(X(e,q)|0)|0,r);e=e+1|0;if((e|0)>=(t|0)){e=0;break b}}}if((r|0)>0){m=0;e=0}else{g=0;e=0;while(1){if(!e){e=PK(o)|0;i=e}else i=e;Iw(B,i,n);g=g+1|0;if((g|0)>=(t|0))break b}}do{if(!e){e=PK(o)|0;i=e}else i=e;k=X(m,q)|0;l=e;g=0;while(1){ba=s+(g+k<<1)|0;p=g<<1;b[i+p>>0]=d[ba>>1];b[l+(p|1)>>0]=(j[ba>>1]|0)>>>8;g=g+1|0;if((g|0)==(r|0))break;else i=l}Iw(B,l,n);m=m+1|0}while((m|0)<(t|0))}else e=0;while(0);Kw(M,B);if(e|0)RK(e);if((b[M>>0]|0)!=(b[a+12+(w<<4)>>0]|0)){v=22;break a}if((b[I>>0]|0)!=(b[a+12+(w<<4)+1>>0]|0)){v=22;break a}if((b[J>>0]|0)!=(b[a+12+(w<<4)+2>>0]|0)){v=22;break a}if((b[K>>0]|0)!=(b[a+12+(w<<4)+3>>0]|0)){v=22;break a}if((b[L>>0]|0)!=(b[a+12+(w<<4)+4>>0]|0)){v=22;break a}if((b[N>>0]|0)!=(b[a+12+(w<<4)+5>>0]|0)){v=22;break a}if((b[O>>0]|0)!=(b[a+12+(w<<4)+6>>0]|0)){v=22;break a}if((b[P>>0]|0)!=(b[a+12+(w<<4)+7>>0]|0)){v=22;break a}if((b[Q>>0]|0)!=(b[a+12+(w<<4)+8>>0]|0)){v=22;break a}if((b[R>>0]|0)!=(b[a+12+(w<<4)+9>>0]|0)){v=22;break a}if((b[S>>0]|0)!=(b[a+12+(w<<4)+10>>0]|0)){v=22;break a}if((b[T>>0]|0)!=(b[a+12+(w<<4)+11>>0]|0)){v=22;break a}if((b[U>>0]|0)!=(b[a+12+(w<<4)+12>>0]|0)){v=22;break a}if((b[V>>0]|0)!=(b[a+12+(w<<4)+13>>0]|0)){v=22;break a}if((b[W>>0]|0)!=(b[a+12+(w<<4)+14>>0]|0)){v=22;break a}if((b[Y>>0]|0)!=(b[a+12+(w<<4)+15>>0]|0)){v=22;break a}break}case 1:{c:do if((t|0)>0){o=r<<1;p=(r|0)<0?-1:o;e=(r|0)>0;if((f[(g?G:H)>>2]|0)<=8){if(e){g=0;e=7439}else{e=7439;v=39;break}while(1){k=s+(X(g,q)|0)|0;i=0;do{v=e&65535;ba=h[k+i>>0]^v>>>8;ba=ba>>>4^ba;e=(ba|v<<8)^ba<<5^ba<<12;i=i+1|0}while((i|0)!=(r|0));g=g+1|0;if((g|0)==(t|0)){v=39;break c}}}if(e){n=0;e=7439;g=0;do{if(!g){g=PK(p)|0;k=g}else k=g;l=X(n,q)|0;m=g;i=0;while(1){ca=s+(i+l<<1)|0;ba=i<<1;b[k+ba>>0]=d[ca>>1];b[m+(ba|1)>>0]=(j[ca>>1]|0)>>>8;i=i+1|0;if((i|0)==(r|0)){i=0;break}else k=m}do{ba=e&65535;ca=h[m+i>>0]^ba>>>8;ca=ca>>>4^ca;e=(ca|ba<<8)^ca<<5^ca<<12;i=i+1|0}while((i|0)<(o|0));n=n+1|0}while((n|0)!=(t|0))}else{e=0;g=0;do{if(!g)g=PK(p)|0;e=e+1|0}while((e|0)!=(t|0));e=7439}e=e&65535;if(g)RK(g)}else{e=7439;v=39}while(0);if((v|0)==39){v=0;e=e&65535}g=j[a+60+(w<<1)>>1]|0;if((e|0)!=(g|0)){v=43;break a}break}case 2:{e=(r|0)>0&(t|0)>0;if((f[(g?G:H)>>2]|0)<9)if(e){g=0;e=0;do{k=g>>>8^g;l=X(g,q)|0;i=0;do{e=((k^i^i>>>8)&255^h[s+(i+l)>>0])+e|0;i=i+1|0}while((i|0)!=(r|0));g=g+1|0}while((g|0)!=(t|0))}else e=0;else if(e){i=0;e=0;do{k=i>>>8^i;l=X(i,q)|0;g=0;do{ca=(k^g^g>>>8)&255;e=ca+e+(ca^h[s+(g+l)>>0])|0;g=g+1|0}while((g|0)!=(r|0));i=i+1|0}while((i|0)!=(t|0))}else e=0;g=f[a+68+(w<<2)>>2]|0;if((e|0)!=(g|0)){v=54;break a}break}default:{}}w=w+1|0;if((w|0)>=(x|0)){e=0;v=71;break}}if((v|0)==22){ca=f[2651]|0;f[Z>>2]=f[c+92>>2];Gy(ca,39301,Z)|0;ca=5;u=aa;return ca|0}else if((v|0)==43){ca=f[2651]|0;ba=f[c+92>>2]|0;f[_>>2]=g;f[_+4>>2]=e;f[_+8>>2]=ba;Gy(ca,39344,_)|0;ca=5;u=aa;return ca|0}else if((v|0)==54){ca=f[2651]|0;ba=f[c+92>>2]|0;f[$>>2]=g;f[$+4>>2]=e;f[$+8>>2]=ba;Gy(ca,39344,$)|0;ca=5;u=aa;return ca|0}else if((v|0)==71){u=aa;return e|0}return 0}function hu(a){a=a|0;QK(a);return}function iu(a){a=a|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0;h=f[a+20>>2]|0;d=h+18596|0;i=f[d>>2]|0;j=a+4|0;f[j>>2]=1;dt(i,a);d=f[d>>2]|0;e=f[h+4>>2]|0;c=f[d+5836>>2]|0;g=f[d+5820>>2]|0;if((e|0)<(c|0))c=f[(f[d+10284>>2]|0)+(e<<2)>>2]|0;f[h>>2]=c;f[h+8>>2]=(c|0)%(g|0)|0;f[h+12>>2]=(c|0)/(g|0)|0;c=a+8|0;do if(!(b[c>>0]|0)){d=f[h+18600>>2]|0;e=f[d+796>>2]|0;if(e>>>0<3){cw(h+18580|0,e,f[d+792>>2]|0);g=h+18588|0;b[g>>0]=0;b[g+1>>0]=0;b[g+2>>0]=0;b[g+3>>0]=0;break}else Pa(39428,39459,1508,39468)}else if(!(ku(h)|0)){f[j>>2]=3;fv((f[h+18608>>2]|0)+44|0,1);et(i,a);return}while(0);Uv(h+18556|0);lu(h,0,(b[c>>0]|0)!=0)|0;f[j>>2]=3;fv((f[h+18608>>2]|0)+44|0,1);et(i,a);return}function ju(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0;e=u;u=u+112|0;g=e;d=e+8|0;h=f[c+16>>2]|0;f[g>>2]=f[c+12>>2];f[g+4>>2]=h;Hy(d,39408,g)|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;c=vx(d)|0;if(c>>>0>4294967279)XK(a);if(c>>>0<11){b[a+11>>0]=c;if(!c){h=a;h=h+c|0;b[h>>0]=0;u=e;return}}else{g=c+16&-16;h=OK(g)|0;f[a>>2]=h;f[a+8>>2]=g|-2147483648;f[a+4>>2]=c;a=h}GM(a|0,d|0,c|0)|0;h=a;h=h+c|0;b[h>>0]=0;u=e;return}function ku(a){a=a|0;var c=0,d=0,e=0,g=0,h=0,i=0,k=0,l=0;g=f[a+18596>>2]|0;h=g+5932|0;i=a+18600|0;d=f[i>>2]|0;if(!(b[d+12>>0]|0)){c=f[d+796>>2]|0;if(c>>>0>=3)Pa(39428,39459,1508,39468);cw(a+18580|0,c,f[d+792>>2]|0);a=a+18588|0;b[a>>0]=0;b[a+1>>0]=0;b[a+2>>0]=0;b[a+3>>0]=0;a=1;return a|0}e=f[d+16>>2]|0;c=j[(f[g+10340>>2]|0)+((f[(f[g+10284>>2]|0)+((f[(f[g+10272>>2]|0)+(e<<2)>>2]|0)+-1<<2)>>2]|0)*24|0)+2>>1]|0;d=f[g+48>>2]|0;if(c>>>0>=(f[g+52>>2]|0)-d>>2>>>0){a=0;return a|0}k=f[d+(c<<2)>>2]|0;g=f[g+5820>>2]|0;if(Ut(h,(e|0)%(g|0)|0,(e|0)/(g|0)|0)|0){c=f[i>>2]|0;d=f[c+796>>2]|0;if(d>>>0>=3)Pa(39428,39459,1508,39468);cw(a+18580|0,d,f[c+792>>2]|0);a=a+18588|0;b[a>>0]=0;b[a+1>>0]=0;b[a+2>>0]=0;b[a+3>>0]=0;a=1;return a|0}e=f[a+18604>>2]|0;d=f[a+18608>>2]|0;g=f[e+10632>>2]|0;e=(f[e+10636>>2]|0)-g>>2;if(e>>>0>1)c=1;else{a=0;return a|0}while(1){if((f[g+(c<<2)>>2]|0)==(d|0))break;c=c+1|0;if(c>>>0>=e>>>0){c=0;l=16;break}}if((l|0)==16)return c|0;c=f[g+(c+-1<<2)>>2]|0;if(!c){a=0;return a|0}dv(c+44|0,f[c+124>>2]|0);if(!(b[k+1340>>0]|0)){a=0;return a|0}l=k+1332|0;gw(a+18580|0,l)|0;ew(l);a=1;return a|0}function lu(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0;F=a+18596|0;g=f[F>>2]|0;D=f[g+5820>>2]|0;E=a+12|0;e=f[E>>2]|0;C=g+5965|0;do if((!d?(e|0)>0&(b[C>>0]|0)!=0:0)?(f[a+8>>2]|0)==0:0){d=e+-1|0;if((D|0)>1){e=a+18604|0;B=f[e>>2]|0;if(d>>>0<(f[B+10680>>2]|0)-(f[B+10676>>2]|0)>>3>>>0){ft(g,f[a+18612>>2]|0,1,d,1);gw(a+18580|0,(f[(f[e>>2]|0)+10676>>2]|0)+((f[E>>2]|0)+-1<<3)|0)|0;ew((f[(f[e>>2]|0)+10676>>2]|0)+((f[E>>2]|0)+-1<<3)|0);break}else{F=2;return F|0}}else{ft(g,f[a+18612>>2]|0,0,d,1);d=f[a+18600>>2]|0;e=f[d+796>>2]|0;if(e>>>0<3){cw(a+18580|0,e,f[d+792>>2]|0);B=a+18588|0;b[B>>0]=0;b[B+1>>0]=0;b[B+2>>0]=0;b[B+3>>0]=0;break}else Pa(39428,39459,1508,39468)}}while(0);q=a+8|0;r=D+-1|0;s=a+18612|0;t=a+18580|0;u=a+18584|0;v=g+5828|0;w=a+18604|0;B=a+18556|0;x=g+5935|0;y=a+18600|0;z=a+4|0;A=g+5966|0;p=g+10296|0;n=f[E>>2]|0;j=f[q>>2]|0;o=f[F>>2]|0;while(1){e=(X(n,D)|0)+j|0;if(e>>>0>=(f[o+10276>>2]|0)-(f[o+10272>>2]|0)>>2>>>0){d=2;e=35;break}if((j|0)>=(f[o+5820>>2]|0)){d=2;e=35;break}if((n|0)>=(f[o+5828>>2]|0)){d=2;e=35;break}if((j|0)<(r|0)&((n|0)>0&c))ft(o,f[s>>2]|0,j+1|0,n+-1|0,1);if(!(f[u>>2]|0)){d=2;e=35;break}mu(a);if((j|0)==1&(b[C>>0]|0)!=0?(n|0)<((f[v>>2]|0)+-1|0):0){o=f[w>>2]|0;d=f[o+10676>>2]|0;if((f[o+10680>>2]|0)-d>>3>>>0<=n>>>0){d=2;e=35;break}gw(d+(n<<3)|0,t)|0;fw((f[(f[w>>2]|0)+10676>>2]|0)+(n<<3)|0)}k=Wv(B)|0;l=(k|0)!=0;if(l?b[x>>0]|0:0){gw((f[y>>2]|0)+1332|0,t)|0;fw((f[y>>2]|0)+1332|0);b[(f[y>>2]|0)+1340>>0]=1}ev((f[(f[F>>2]|0)+10524>>2]|0)+(e*80|0)|0,1);m=f[E>>2]|0;h=f[z>>2]|0;i=h+1|0;f[z>>2]=i;o=f[F>>2]|0;d=f[o+5836>>2]|0;e=f[o+5820>>2]|0;if((i|0)<(d|0)){g=0;d=f[(f[o+10284>>2]|0)+(i<<2)>>2]|0}else g=1;n=(d|0)/(e|0)|0;j=(d|0)%(e|0)|0;f[a>>2]=d;f[q>>2]=j;f[E>>2]=n;if((k|0)==0&g){e=27;break}if(l){d=0;e=35;break}if(!(b[A>>0]|0))d=0;else{d=f[p>>2]|0;d=(f[d+(i<<2)>>2]|0)!=(f[d+(h<<2)>>2]|0)}if(d|(m|0)!=(n|0)&(b[C>>0]|0)!=0){e=32;break}}if((e|0)==27){uq((f[a+18592>>2]|0)+4|0,1004,0);b[(f[F>>2]|0)+10516>>0]=3;F=2;return F|0}else if((e|0)==32)if(!(Wv(B)|0)){uq((f[a+18592>>2]|0)+4|0,1017,0);b[(f[F>>2]|0)+10516>>0]=3;F=2;return F|0}else{Uv(B);F=1;return F|0}else if((e|0)==35)return d|0;return 0}function mu(a){a=a|0;var c=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;j=f[a+18600>>2]|0;o=f[a+18596>>2]|0;c=f[a>>2]|0;q=f[o+5820>>2]|0;p=(c|0)%(q|0)|0;q=(c|0)/(q|0)|0;c=o+5804|0;e=f[c>>2]|0;g=p<<e;h=q<<e;i=f[o+10352>>2]|0;l=(X(i,q)|0)+p|0;k=f[o+10340>>2]|0;d[k+(l*24|0)>>1]=f[j+800>>2];l=f[j>>2]&65535;n=f[o+10348>>2]|0;m=g>>n;n=h>>n;if(!((m|0)>-1&(m|0)<(i|0)))Pa(48699,48736,128,48756);if((n|0)<=-1)Pa(48760,48736,129,48756);if((n|0)>=(f[o+10356>>2]|0))Pa(48760,48736,129,48756);o=k+(((X(i,n)|0)+m|0)*24|0)+2|0;d[o>>1]=l;if((b[j+325>>0]|0)==0?(b[j+326>>0]|0)==0:0){q=e;ou(a,g,h,q,0);return}nu(a,p,q,0);q=f[c>>2]|0;ou(a,g,h,q,0);return}function nu(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0;I=u;u=u+32|0;e=I;j=f[a+18600>>2]|0;G=f[a+18596>>2]|0;g=e;i=g+17|0;do{b[g>>0]=0;g=g+1|0}while((g|0)<(i|0));if((c|0)>0?(F=X(f[G+5820>>2]|0,d)|0,E=f[G+10308>>2]|0,(f[a>>2]|0)>(f[j+800>>2]|0)?(f[E+(F+c<<2)>>2]|0)==(f[E+(c+-1+F<<2)>>2]|0):0):0)g=(Vv(a+18556|0,f[a+18580>>2]|0)|0)&255;else g=0;E=g<<24>>24==0;if((d|0)>0&E?(B=f[G+5820>>2]|0,D=(X(B,d)|0)+c|0,C=f[G+10308>>2]|0,F=C+((X(B,d+-1|0)|0)+c<<2)|0,((f[a>>2]|0)-B|0)>=(f[j+800>>2]|0)?(f[C+(D<<2)>>2]|0)==(f[F>>2]|0):0):0)i=(Vv(a+18556|0,f[a+18580>>2]|0)|0)&255;else i=0;F=i<<24>>24==0;if(!((i|g)<<24>>24)){B=(f[G+5776>>2]|0)==0?1:3;C=j+325|0;D=a+18556|0;v=a+18580|0;w=G+5760|0;x=G+5768|0;y=G+10087|0;z=G+10088|0;A=e+1|0;t=j+326|0;s=0;i=0;g=0;do{n=(s|0)==0;if(!(!(n&(b[C>>0]|0)!=0)?!((s|0)>0&(b[t>>0]|0)!=0):0)){do if(n){if(!(Vv(D,(f[v>>2]|0)+1|0)|0))i=0;else{i=(Xv(D)|0)==0;i=i?1:2}j=i;i=i&255}else{if((s|0)!=1){j=(i&255)>>>(s<<1)&3;break}if(!(Vv(D,(f[v>>2]|0)+1|0)|0))a=0;else{a=(Xv(D)|0)==0;a=a?1:2}j=a;i=(a<<4|a<<2|i&255)&255}while(0);a=j&255;if(a){m=n?w:x;j=f[m>>2]|0;j=(Yv(D,(1<<((j|0)<10?j:10)+-5)+-1|0)|0)&255;o=e+5+(s<<2)|0;b[o>>0]=j;k=f[m>>2]|0;k=(Yv(D,(1<<((k|0)<10?k:10)+-5)+-1|0)|0)&255;p=e+5+(s<<2)+1|0;b[p>>0]=k;l=f[m>>2]|0;l=(Yv(D,(1<<((l|0)<10?l:10)+-5)+-1|0)|0)&255;q=e+5+(s<<2)+2|0;b[q>>0]=l;m=f[m>>2]|0;m=(Yv(D,(1<<((m|0)<10?m:10)+-5)+-1|0)|0)&255;r=e+5+(s<<2)+3|0;b[r>>0]=m;do if((a|0)==1){if(!(j<<24>>24))a=0;else{a=(Xv(D)|0)!=0;a=a?-1:1}if(!(k<<24>>24))k=0;else{k=(Xv(D)|0)!=0;k=k?-1:1}if(!(l<<24>>24))l=0;else{l=(Xv(D)|0)!=0;l=l?-1:1}if(!(m<<24>>24))j=0;else{j=(Xv(D)|0)!=0;j=j?-1:1}m=(Zv(D,5)|0)&255;b[e+2+s>>0]=m;if(n)m=y;else H=30}else{if(n){m=y;a=1;k=1;l=-1;j=-1;g=(Zv(D,2)|0)&255;break}if((s|0)==1){H=(Zv(D,2)|0)&255;j=-1;l=-1;k=1;a=1;g=(g&255|H<<2|H<<4)&255;H=30}else{j=-1;l=-1;k=1;a=1;H=30}}while(0);if((H|0)==30){H=0;m=z}n=h[m>>0]|0;m=(X(b[o>>0]<<n,a)|0)&255;b[o>>0]=m;o=(X(b[p>>0]<<n,k)|0)&255;b[p>>0]=o;p=(X(b[q>>0]<<n,l)|0)&255;b[q>>0]=p;q=(X(b[r>>0]<<n,j)|0)&255;b[r>>0]=q}}s=s+1|0}while((s|0)<(B|0));b[e>>0]=i;b[A>>0]=g;g=(X(f[G+10352>>2]|0,d)|0)+c|0;g=(f[G+10340>>2]|0)+(g*24|0)+4|0;i=g+17|0;do{b[g>>0]=b[e>>0]|0;g=g+1|0;e=e+1|0}while((g|0)<(i|0))}if(!E){e=X(f[G+10352>>2]|0,d)|0;i=f[G+10340>>2]|0;g=i+((e+c|0)*24|0)+4|0;e=i+((c+-1+e|0)*24|0)+4|0;i=g+17|0;do{b[g>>0]=b[e>>0]|0;g=g+1|0;e=e+1|0}while((g|0)<(i|0))}if(F){u=I;return}g=f[G+10352>>2]|0;e=(X(g,d+-1|0)|0)+c|0;i=f[G+10340>>2]|0;g=i+(((X(g,d)|0)+c|0)*24|0)+4|0;e=i+(e*24|0)+4|0;i=g+17|0;do{b[g>>0]=b[e>>0]|0;g=g+1|0;e=e+1|0}while((g|0)<(i|0));u=I;return}function ou(a,c,e,g,i){a=a|0;c=c|0;e=e|0;g=g|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;r=a+18596|0;u=a+18600|0;v=a+18516|0;w=a+18508|0;x=a+18512|0;m=a+18556|0;n=a+18580|0;C=c;B=e;z=g;A=i;while(1){y=f[r>>2]|0;c=1<<z;l=y+1248|0;e=f[l>>2]|0;if(((c+C|0)<=(e|0)?(o=f[y+1252>>2]|0,(c+B|0)<=(o|0)):0)?(f[y+5800>>2]|0)<(z|0):0){g=C+-1|0;if((g|B|0)>-1&(e|0)>=(C|0)&(o|0)>(B|0)?(q=f[y+5804>>2]|0,k=X(B>>q,f[y+5820>>2]|0)|0,p=k+(C>>q)|0,q=k+(g>>q)|0,k=f[y+10340>>2]|0,(d[k+(p*24|0)>>1]|0)==(d[k+(q*24|0)>>1]|0)):0){c=f[y+10308>>2]|0;c=(f[c+(p<<2)>>2]|0)==(f[c+(q<<2)>>2]|0)&1}else c=0;k=B+-1|0;if(!((e|0)<=(C|0)|(k|C|0)<0|(o|0)<(B|0))?(i=f[y+5804>>2]|0,j=f[y+5820>>2]|0,t=C>>i,s=(X(B>>i,j)|0)+t|0,t=(X(k>>i,j)|0)+t|0,j=f[y+10340>>2]|0,(d[j+(s*24|0)>>1]|0)==(d[j+(t*24|0)>>1]|0)):0){j=f[y+10308>>2]|0;j=(f[j+(s<<2)>>2]|0)==(f[j+(t<<2)>>2]|0)&1}else j=0;if(!c)i=2;else{e=f[y+10368>>2]|0;c=g>>e;e=B>>e;if((c|0)<=-1){c=14;break}g=f[y+10372>>2]|0;if((c|0)>=(g|0)){c=14;break}if((e|0)<=-1){c=17;break}if((e|0)>=(f[y+10376>>2]|0)){c=17;break}i=(f[y+10360>>2]|0)+(((X(g,e)|0)+c|0)*3|0)|0;i=(((h[i>>0]|h[i+1>>0]<<8)&65535)>>>6&3|0)>(A|0)?3:2}if(!j)c=0;else{e=f[y+10368>>2]|0;g=C>>e;e=k>>e;if((g|0)<=-1){c=22;break}c=f[y+10372>>2]|0;if((g|0)>=(c|0)){c=22;break}if((e|0)<=-1){c=25;break}if((e|0)>=(f[y+10376>>2]|0)){c=25;break}c=(f[y+10360>>2]|0)+(((X(c,e)|0)+g|0)*3|0)|0;c=(((h[c>>0]|h[c+1>>0]<<8)&65535)>>>6&3|0)>(A|0)&1}c=Vv(m,(f[n>>2]|0)+(c+i)|0)|0}else c=(f[y+5800>>2]|0)<(z|0)&1;if(b[y+5946>>0]|0?(f[y+10092>>2]|0)<=(z|0):0){f[w>>2]=0;f[x>>2]=0}if(b[(f[u>>2]|0)+752>>0]|0?(f[y+10096>>2]|0)<=(z|0):0)f[v>>2]=0;if(!c){c=42;break}e=z+-1|0;i=1<<e;g=i+C|0;i=i+B|0;j=A+1|0;ou(a,C,B,e,j);if((g|0)<(f[l>>2]|0))ou(a,g,B,e,j);c=y+1252|0;if((i|0)<(f[c>>2]|0))ou(a,C,i,e,j);if((g|0)>=(f[l>>2]|0)){c=48;break}if((i|0)<(f[c>>2]|0)){C=g;B=i;z=e;A=j}else{c=48;break}}if((c|0)==14)Pa(48699,48736,118,48756);else if((c|0)==17)Pa(48760,48736,119,48756);else if((c|0)==22)Pa(48699,48736,118,48756);else if((c|0)==25)Pa(48760,48736,119,48756);else if((c|0)==42){x=f[y+10368>>2]|0;l=C>>x;e=B>>x;x=z-x|0;c=1<<x;m=c+e|0;if((x|0)!=31){j=c+l|0;k=y+10372|0;g=y+10360|0;i=(A&65535)<<6&192;c=e;do{e=l;do{y=(X(f[k>>2]|0,c)|0)+e|0;y=(f[g>>2]|0)+(y*3|0)|0;x=(h[y>>0]|h[y+1>>0]<<8)&-193|i;b[y>>0]=x;b[y+1>>0]=x>>8;e=e+1|0}while((e|0)<(j|0));c=c+1|0}while((c|0)<(m|0))}pu(a,C,B,z,A);return}else if((c|0)==48)return}function pu(a,c,e,g,i){a=a|0;c=c|0;e=e|0;g=g|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0;S=u;u=u+80|0;Q=S;M=S+56|0;N=S+40|0;O=S+24|0;D=a+18596|0;P=f[D>>2]|0;z=a+18600|0;r=f[z>>2]|0;qu(P,c,e,g,1);R=f[P+10448>>2]|0;p=c>>R;k=e>>R;R=g-R|0;j=1<<R;q=j+k|0;if((R|0)!=31){l=j+p|0;n=P+10452|0;o=P+10440|0;j=k;do{k=p;do{R=(X(f[n>>2]|0,j)|0)+k|0;b[(f[o>>2]|0)+R>>0]=0;k=k+1|0}while((k|0)<(l|0));j=j+1|0}while((j|0)<(q|0))}R=1<<g;ov(a,c,e,c,e);if(b[P+5964>>0]|0){L=Vv(a+18556|0,(f[a+18580>>2]|0)+161|0)|0;b[a+32>>0]=L;if(L|0)ru(P,c,e,g,1)}else b[a+32>>0]=0;q=r+20|0;do if((f[q>>2]|0)==2)L=0;else{p=f[D>>2]|0;k=c+-1|0;if((((k|e|0)>=0?(f[p+1248>>2]|0)>=(c|0):0)?(f[p+1252>>2]|0)>(e|0):0)?(t=f[p+5804>>2]|0,L=X(e>>t,f[p+5820>>2]|0)|0,s=L+(c>>t)|0,t=L+(k>>t)|0,L=f[p+10340>>2]|0,(d[L+(s*24|0)>>1]|0)==(d[L+(t*24|0)>>1]|0)):0){j=f[p+10308>>2]|0;j=(f[j+(s<<2)>>2]|0)==(f[j+(t<<2)>>2]|0)&1}else j=0;o=e+-1|0;if((((o|c|0)>=0?(f[p+1248>>2]|0)>(c|0):0)?(f[p+1252>>2]|0)>=(e|0):0)?(K=f[p+5804>>2]|0,L=f[p+5820>>2]|0,w=c>>K,v=(X(e>>K,L)|0)+w|0,w=(X(o>>K,L)|0)+w|0,L=f[p+10340>>2]|0,(d[L+(v*24|0)>>1]|0)==(d[L+(w*24|0)>>1]|0)):0){n=f[p+10308>>2]|0;n=(f[n+(v<<2)>>2]|0)==(f[n+(w<<2)>>2]|0)&1}else n=0;do if(j){L=f[p+10368>>2]|0;j=k>>L;k=e>>L;if((j|0)<=-1)Pa(48699,48736,118,48756);l=f[p+10372>>2]|0;if((j|0)>=(l|0))Pa(48699,48736,118,48756);if((k|0)<=-1)Pa(48760,48736,119,48756);if((k|0)<(f[p+10376>>2]|0)){x=(f[p+10360>>2]|0)+(((X(l,k)|0)+j|0)*3|0)|0;x=((h[x>>0]|h[x+1>>0]<<8)&768)==512?6:5;break}else Pa(48760,48736,119,48756)}else x=5;while(0);do if(n){j=f[p+10368>>2]|0;l=c>>j;j=o>>j;if((l|0)<=-1)Pa(48699,48736,118,48756);k=f[p+10372>>2]|0;if((l|0)>=(k|0))Pa(48699,48736,118,48756);if((j|0)<=-1)Pa(48760,48736,119,48756);if((j|0)<(f[p+10376>>2]|0)){y=(f[p+10360>>2]|0)+(((X(k,j)|0)+l|0)*3|0)|0;y=((h[y>>0]|h[y+1>>0]<<8)&768)==512&1;break}else Pa(48760,48736,119,48756)}else y=0;while(0);k=a+18556|0;j=a+18580|0;if(!(((Vv(k,(f[j>>2]|0)+(y+x)|0)|0)&255)<<24>>24)){if((f[q>>2]|0)==2){L=0;break}L=(Vv(k,(f[j>>2]|0)+149|0)|0)==0&1;break}a:do if((f[(f[z>>2]|0)+804>>2]|0)>=2?(Vv(k,(f[j>>2]|0)+148|0)|0)!=0:0)if(((f[(f[z>>2]|0)+804>>2]|0)+-1|0)>1){j=1;do{if(!(Xv(k)|0))break a;j=j+1|0}while((j|0)<((f[(f[z>>2]|0)+804>>2]|0)+-1|0))}else j=1;else j=0;while(0);l=a+26|0;b[l>>0]=b[l>>0]&15|(j&255)<<5&255|16;j=P+10368|0;l=f[j>>2]|0;k=c>>l;l=e>>l;if((k|0)<=-1)Pa(48699,48736,128,48756);p=P+10372|0;m=f[p>>2]|0;if((k|0)>=(m|0))Pa(48699,48736,128,48756);if((l|0)<=-1)Pa(48760,48736,129,48756);if((l|0)>=(f[P+10376>>2]|0))Pa(48760,48736,129,48756);o=P+10360|0;Q=(f[o>>2]|0)+(((X(m,l)|0)+k|0)*3|0)|0;n=(h[Q>>0]|h[Q+1>>0]<<8)&-57;b[Q>>0]=n;b[Q+1>>0]=n>>8;Q=f[j>>2]|0;n=c>>Q;k=e>>Q;Q=g-Q|0;j=1<<Q;m=j+k|0;if((Q|0)!=31){l=j+n|0;j=k;do{k=n;do{Q=(X(f[p>>2]|0,j)|0)+k|0;Q=(f[o>>2]|0)+(Q*3|0)|0;g=(h[Q>>0]|h[Q+1>>0]<<8)&-769|512;b[Q>>0]=g;b[Q+1>>0]=g>>8;k=k+1|0}while((k|0)<(l|0));j=j+1|0}while((j|0)<(m|0))}Yw(f[a+18592>>2]|0,f[z>>2]|0,f[D>>2]|0,a+16|0,c,e,0,0,R,R,R,0);u=S;return}while(0);s=P+10368|0;K=f[s>>2]|0;q=c>>K;k=e>>K;K=g-K|0;j=1<<K;r=j+k|0;if((K|0)!=31){l=j+q|0;n=P+10372|0;o=P+10360|0;p=(L&65535)<<8&65535;j=k;do{k=q;do{K=(X(f[n>>2]|0,j)|0)+k|0;K=(f[o>>2]|0)+(K*3|0)|0;J=(h[K>>0]|h[K+1>>0]<<8)&-769|p;b[K>>0]=J;b[K+1>>0]=J>>8;k=k+1|0}while((k|0)<(l|0));j=j+1|0}while((j|0)<(r|0))}K=(L|0)!=0;if(!K?(f[P+5800>>2]|0)!=(g|0):0){J=0;m=0}else{k=f[D>>2]|0;p=(L|0)==0;l=a+18556|0;n=a+18580|0;j=Vv(l,(f[n>>2]|0)+8|0)|0;do if(!p)if(!j){o=Vv(l,(f[n>>2]|0)+9|0)|0;if((f[k+5800>>2]|0)>=(g|0)){if(o|0){m=1;break}if((g|0)==3){m=2;break}m=3-(Vv(l,(f[n>>2]|0)+10|0)|0)|0;break}if(!(b[k+5466>>0]|0)){m=o|0?1:2;break}if(Vv(l,(f[n>>2]|0)+11|0)|0){m=o|0?1:2;break}j=Xv(l)|0;k=(j|0)!=0;if(!((o|0)!=0&k)){l=(o|0)==0;if(l|k)if(j|o)if(l&k)m=7;else Pa(55956,39459,1760,39492);else m=6;else m=4}else m=5}else m=0;else m=j|0?0:3;while(0);J=p&(m|0)==3&1}k=f[s>>2]|0;j=c>>k;k=e>>k;if((j|0)<=-1)Pa(48699,48736,128,48756);l=f[P+10372>>2]|0;if((j|0)>=(l|0))Pa(48699,48736,128,48756);if((k|0)<=-1)Pa(48760,48736,129,48756);if((k|0)>=(f[P+10376>>2]|0))Pa(48760,48736,129,48756);H=(f[P+10360>>2]|0)+(((X(l,k)|0)+j|0)*3|0)|0;I=(h[H>>0]|h[H+1>>0]<<8)&-57|(m&65535)<<3&56;b[H>>0]=I;b[H+1>>0]=I>>8;H=(L|0)==0;I=(m|0)==0;b:do if(H){if((((I?b[P+5468>>0]|0:0)?(f[P+5884>>2]|0)<=(g|0):0)?(f[P+5888>>2]|0)>=(g|0):0)?(E=a+18556|0,Wv(E)|0):0){su(P,c,e,g,1);v=a+18560|0;j=f[v>>2]|0;f[Q>>2]=j;f[Q+4>>2]=(f[a+18564>>2]|0)-j;j=Q+8|0;f[j>>2]=0;f[j+4>>2]=0;f[Q+16>>2]=0;j=f[D>>2]|0;l=f[j+5760>>2]|0;p=b[j+5469>>0]|0;o=f[j+40>>2]|0;j=f[j+4>>2]|0;k=(X(o,e)|0)+c|0;if((l|0)>8){n=j+(k<<1)|0;m=l-p|0;if((g|0)!=31){k=0;do{l=X(k,o)|0;j=0;do{g=(Ov(Q,p)|0)<<m&65535;d[n+(j+l<<1)>>1]=g;j=j+1|0}while((j|0)!=(R|0));k=k+1|0}while((k|0)!=(R|0))}}else{n=j+k|0;m=l-p|0;if((g|0)!=31){k=0;do{l=X(k,o)|0;j=0;do{g=(Ov(Q,p)|0)<<m&255;b[n+(j+l)>>0]=g;j=j+1|0}while((j|0)!=(R|0));k=k+1|0}while((k|0)!=(R|0))}}k=f[D>>2]|0;do if(f[k+5776>>2]|0){q=f[k+5768>>2]|0;o=f[k+5780>>2]|0;p=(R|0)/(o|0)|0;l=f[k+5784>>2]|0;r=(R|0)/(l|0)|0;j=b[k+5470>>0]|0;t=j<<24>>24;s=f[k+44>>2]|0;m=f[k+8>>2]|0;n=(X(s,(e|0)/(l|0)|0)|0)+((c|0)/(o|0)|0)|0;if((q|0)>8){m=m+(n<<1)|0;n=q-t|0;if((p|0)>0&(r|0)>0){k=0;do{l=X(k,s)|0;j=0;do{g=(Ov(Q,t)|0)<<n&65535;d[m+(j+l<<1)>>1]=g;j=j+1|0}while((j|0)!=(p|0));k=k+1|0}while((k|0)!=(r|0));k=f[D>>2]|0;s=f[k+44>>2]|0;q=f[k+5768>>2]|0;m=f[k+5780>>2]|0;l=f[k+5784>>2]|0;j=b[k+5470>>0]|0}else m=o;r=(R|0)/(m|0)|0;p=(R|0)/(l|0)|0;o=j<<24>>24;n=(f[k+12>>2]|0)+((X((e|0)/(l|0)|0,s)|0)+((c|0)/(m|0)|0)<<1)|0;l=q-o|0;if((r|0)>0&(p|0)>0)k=0;else break;do{m=X(k,s)|0;j=0;do{e=(Ov(Q,o)|0)<<l&65535;d[n+(j+m<<1)>>1]=e;j=j+1|0}while((j|0)!=(r|0));k=k+1|0}while((k|0)!=(p|0))}else{m=m+n|0;n=q-t|0;if((p|0)>0&(r|0)>0){k=0;do{l=X(k,s)|0;j=0;do{g=(Ov(Q,t)|0)<<n&255;b[m+(j+l)>>0]=g;j=j+1|0}while((j|0)!=(p|0));k=k+1|0}while((k|0)!=(r|0));k=f[D>>2]|0;s=f[k+44>>2]|0;q=f[k+5768>>2]|0;m=f[k+5780>>2]|0;l=f[k+5784>>2]|0;j=b[k+5470>>0]|0}else m=o;r=(R|0)/(m|0)|0;p=(R|0)/(l|0)|0;o=j<<24>>24;n=(f[k+12>>2]|0)+((X((e|0)/(l|0)|0,s)|0)+((c|0)/(m|0)|0))|0;l=q-o|0;if((r|0)>0&(p|0)>0)k=0;else break;do{m=X(k,s)|0;j=0;do{e=(Ov(Q,o)|0)<<l&255;b[n+(j+m)>>0]=e;j=j+1|0}while((j|0)!=(r|0));k=k+1|0}while((k|0)!=(p|0))}}while(0);Qv(Q);f[v>>2]=f[Q>>2];Uv(E);u=S;return}F=(m|0)==3;E=F?(R|0)/2|0:R;F=(F<<31>>31)+g|0;D=(g|0)==31;if(!D){m=a+18556|0;n=a+18580|0;j=0;k=0;do{l=0;do{z=Vv(m,(f[n>>2]|0)+12|0)|0;i=j;j=j+1|0;f[Q+(i<<2)>>2]=z;l=l+E|0}while((l|0)<(R|0));k=k+E|0}while((k|0)<(R|0))}j=c+-1|0;if((((j|e|0)>=0?(f[P+1248>>2]|0)>=(c|0):0)?(f[P+1252>>2]|0)>(e|0):0)?(B=f[P+5804>>2]|0,i=X(e>>B,f[P+5820>>2]|0)|0,A=i+(c>>B)|0,B=i+(j>>B)|0,i=f[P+10340>>2]|0,(d[i+(A*24|0)>>1]|0)==(d[i+(B*24|0)>>1]|0)):0){k=f[P+10308>>2]|0;k=(f[k+(A<<2)>>2]|0)==(f[k+(B<<2)>>2]|0)&1}else k=0;j=e+-1|0;if((((j|c|0)>=0?(f[P+1248>>2]|0)>(c|0):0)?(f[P+1252>>2]|0)>=(e|0):0)?(A=f[P+5804>>2]|0,B=f[P+5820>>2]|0,G=c>>A,C=(X(e>>A,B)|0)+G|0,G=(X(j>>A,B)|0)+G|0,B=f[P+10340>>2]|0,(d[B+(C*24|0)>>1]|0)==(d[B+(G*24|0)>>1]|0)):0){j=f[P+10308>>2]|0;j=(f[j+(C<<2)>>2]|0)==(f[j+(G<<2)>>2]|0)&1}else j=0;if(!D){C=a+18556|0;B=(k|0)!=0;r=(j|0)!=0;s=P+5872|0;t=P+5876|0;v=P+10408|0;w=P+10412|0;x=P+10400|0;y=O+4|0;z=O+8|0;p=0;j=0;do{i=p+e|0;A=r|(p|0)>0;q=0;do{m=f[Q+(j<<2)>>2]|0;if(!m){k=N;l=Zv(C,5)|0}else{k=M;l=Yv(C,2)|0}f[k+(j<<2)>>2]=l;G=q+c|0;o=f[s>>2]|0;o=(X(i>>o,f[t>>2]|0)|0)+(G>>o)|0;uw(O,G,i,o,B|(q|0)>0,A,P);if((m|0)==1)k=f[O+(f[M+(j<<2)>>2]<<2)>>2]|0;else{k=f[O>>2]|0;l=f[y>>2]|0;if((k|0)>(l|0)){f[O>>2]=l;f[y>>2]=k;m=l}else{m=k;k=l}l=f[z>>2]|0;if((m|0)>(l|0)){f[O>>2]=l;f[z>>2]=m;n=m}else{n=l;l=m}if((k|0)>(n|0)){f[y>>2]=n;f[z>>2]=k;m=n}else{m=k;k=n}G=f[N+(j<<2)>>2]|0;G=((G|0)>=(l|0)&1)+G|0;G=((G|0)>=(m|0)&1)+G|0;k=((G|0)>=(k|0)&1)+G|0}G=F-(f[v>>2]|0)|0;n=1<<G;if((G|0)!=31){m=k&255;k=0;do{l=0;do{G=l+o+(X(f[w>>2]|0,k)|0)|0;b[(f[x>>2]|0)+G>>0]=m;l=l+1|0}while((l|0)<(n|0));k=k+1|0}while((k|0)<(n|0))}j=j+1|0;q=q+E|0}while((q|0)<(R|0));p=p+E|0}while((p|0)<(R|0))}n=P+5776|0;c:do switch(f[n>>2]|0){case 3:{if(!D){p=a+18556|0;q=a+18580|0;r=P+10408|0;s=P+10412|0;t=P+10416|0;v=P+10400|0;o=0;d:while(1){w=o+e|0;n=0;do{x=n+c|0;if(!(Vv(p,(f[q>>2]|0)+13|0)|0))m=4;else m=Zv(p,2)|0;k=f[r>>2]|0;j=x>>k;k=w>>k;if((j|0)<=-1){j=174;break d}l=f[s>>2]|0;if((j|0)>=(l|0)){j=174;break d}if((k|0)<=-1){j=175;break d}if((k|0)>=(f[t>>2]|0)){j=175;break d}j=(f[v>>2]|0)+((X(l,k)|0)+j)|0;j=h[j>>0]|0;k=(m|0)==4;if(!k){Q=f[7948+(m<<2)>>2]|0;j=(Q|0)==(j|0)?34:Q}tu(P,x,w,F,j,k);n=n+E|0}while((n|0)<(R|0));o=o+E|0;if((o|0)>=(R|0))break c}if((j|0)==174)Pa(48699,48736,118,48756);else if((j|0)==175)Pa(48760,48736,119,48756)}break}case 0:break;default:{j=a+18556|0;if(!(Vv(j,(f[a+18580>>2]|0)+13|0)|0))m=4;else m=Zv(j,2)|0;k=f[P+10408>>2]|0;j=c>>k;k=e>>k;if((j|0)<=-1)Pa(48699,48736,118,48756);l=f[P+10412>>2]|0;if((j|0)>=(l|0))Pa(48699,48736,118,48756);if((k|0)<=-1)Pa(48760,48736,119,48756);if((k|0)>=(f[P+10416>>2]|0))Pa(48760,48736,119,48756);j=(f[P+10400>>2]|0)+((X(l,k)|0)+j)|0;j=h[j>>0]|0;k=(m|0)==4;if(!k){R=f[7948+(m<<2)>>2]|0;j=(R|0)==(j|0)?34:R}if((f[n>>2]|0)==2)j=h[39509+j>>0]|0;tu(P,c,e,g,j,k)}}while(0)}else{if(I){uu(a,c,e,0,0,R,R,i,R,0);break}switch(m|0){case 1:{Q=(R|0)/2|0;uu(a,c,e,0,0,R,Q,i,R,0);uu(a,c,e,0,Q,R,Q,i,R,1);break b}case 2:{Q=(R|0)/2|0;uu(a,c,e,0,0,Q,R,i,R,0);uu(a,c,e,Q,0,Q,R,i,R,1);break b}case 4:{Q=(R|0)/4|0;uu(a,c,e,0,0,R,Q,i,R,0);uu(a,c,e,0,Q,R,(3<<g|0)/4|0,i,R,1);break b}case 5:{Q=(3<<g|0)/4|0;uu(a,c,e,0,0,R,Q,i,R,0);uu(a,c,e,0,Q,R,(R|0)/4|0,i,R,1);break b}case 6:{Q=(R|0)/4|0;uu(a,c,e,0,0,Q,R,i,R,0);uu(a,c,e,Q,0,(3<<g|0)/4|0,R,i,R,1);break b}case 7:{Q=(3<<g|0)/4|0;uu(a,c,e,0,0,Q,R,i,R,0);uu(a,c,e,Q,0,(R|0)/4|0,R,i,R,1);break b}case 3:{Q=(R|0)/2|0;uu(a,c,e,0,0,Q,Q,i,R,0);uu(a,c,e,Q,0,Q,Q,i,R,1);uu(a,c,e,0,Q,Q,Q,i,R,2);uu(a,c,e,Q,Q,Q,Q,i,R,3);break b}default:Pa(44673,39459,4511,39544)}}while(0);if((K?!(I&(b[a+26>>0]&16)!=0):0)?(Vv(a+18556|0,(f[a+18580>>2]|0)+153|0)|0)==0:0){u=S;return}if(H)j=(f[P+1396>>2]|0)+J|0;else j=f[P+1392>>2]|0;R=(f[P+5776>>2]|0)!=0&1;vu(a,c,e,c,e,c,e,g,0,0,j,J,L,R,R);u=S;return}function qu(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;o=a+10368|0;if(g?(l=f[o>>2]|0,p=c>>l,m=d>>l,l=e-l|0,i=1<<l,n=i+m|0,(l|0)!=31):0){j=i+p|0;k=a+10372|0;l=a+10360|0;i=m;do{g=p;do{m=(X(f[k>>2]|0,i)|0)+g|0;m=(f[l>>2]|0)+(m*3|0)|0;q=(h[m>>0]|h[m+1>>0]<<8)&-8;b[m>>0]=q;b[m+1>>0]=q>>8;g=g+1|0}while((g|0)<(j|0));i=i+1|0}while((i|0)<(n|0))}i=f[o>>2]|0;j=c>>i;i=d>>i;if((j|0)<=-1)Pa(48699,48736,128,48756);g=f[a+10372>>2]|0;if((j|0)>=(g|0))Pa(48699,48736,128,48756);if((i|0)<=-1)Pa(48760,48736,129,48756);if((i|0)<(f[a+10376>>2]|0)){q=(f[a+10360>>2]|0)+(((X(g,i)|0)+j|0)*3|0)|0;e=(h[q>>0]|h[q+1>>0]<<8)&-8|e&7;b[q>>0]=e;b[q+1>>0]=e>>8;return}else Pa(48760,48736,129,48756)}function ru(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;l=f[a+10368>>2]|0;o=c>>l;m=d>>l;l=e-l|0;e=1<<l;n=e+m|0;if((l|0)!=31){j=e+o|0;k=a+10372|0;l=a+10360|0;i=(g&1)<<11&65535;e=m;do{g=o;do{m=(X(f[k>>2]|0,e)|0)+g|0;m=(f[l>>2]|0)+(m*3|0)|0;p=(h[m>>0]|h[m+1>>0]<<8)&-2049|i;b[m>>0]=p;b[m+1>>0]=p>>8;g=g+1|0}while((g|0)<(j|0));e=e+1|0}while((e|0)<(n|0))}e=f[a+10348>>2]|0;i=c>>e;e=d>>e;if((i|0)<=-1)Pa(48699,48736,128,48756);g=f[a+10352>>2]|0;if((i|0)>=(g|0))Pa(48699,48736,128,48756);if((e|0)<=-1)Pa(48760,48736,129,48756);if((e|0)<(f[a+10356>>2]|0)){p=(f[a+10340>>2]|0)+(((X(g,e)|0)+i|0)*24|0)+22|0;b[p>>0]=1;return}else Pa(48760,48736,129,48756)}function su(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;l=f[a+10368>>2]|0;o=c>>l;m=d>>l;l=e-l|0;e=1<<l;n=e+m|0;if((l|0)!=31){j=e+o|0;k=a+10372|0;l=a+10360|0;i=(g&1)<<10&65535;e=m;do{g=o;do{m=(X(f[k>>2]|0,e)|0)+g|0;m=(f[l>>2]|0)+(m*3|0)|0;p=(h[m>>0]|h[m+1>>0]<<8)&-1025|i;b[m>>0]=p;b[m+1>>0]=p>>8;g=g+1|0}while((g|0)<(j|0));e=e+1|0}while((e|0)<(n|0))}e=f[a+10348>>2]|0;i=c>>e;e=d>>e;if((i|0)<=-1)Pa(48699,48736,128,48756);g=f[a+10352>>2]|0;if((i|0)>=(g|0))Pa(48699,48736,128,48756);if((e|0)<=-1)Pa(48760,48736,129,48756);if((e|0)<(f[a+10356>>2]|0)){p=(f[a+10340>>2]|0)+(((X(g,e)|0)+i|0)*24|0)+22|0;b[p>>0]=1;return}else Pa(48760,48736,129,48756)}function tu(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0;n=(h?g|128:g)&255;k=e-(f[a+10408>>2]|0)|0;l=1<<k;j=f[a+5872>>2]|0;m=a+5876|0;d=(X(d>>j,f[m>>2]|0)|0)+(c>>j)|0;if((k|0)==31)return;i=a+5880|0;j=a+10432|0;k=a+10424|0;e=a+10420|0;h=0;a:while(1){g=0;do{if((g|0)>=(f[m>>2]|0)){g=10;break a}if((h|0)>=(f[i>>2]|0)){g=11;break a}c=d+g+(X(f[j>>2]|0,h)|0)|0;if((c|0)>=(f[k>>2]|0)){g=12;break a}b[(f[e>>2]|0)+c>>0]=n;g=g+1|0}while((g|0)<(l|0));h=h+1|0;if((h|0)>=(l|0)){g=9;break}}if((g|0)==9)return;else if((g|0)==10)Pa(39759,48736,659,39782);else if((g|0)==11)Pa(39801,48736,660,39782);else if((g|0)==12)Pa(39825,48736,663,39782)}function uu(a,c,e,g,h,i,j,k,l,m){a=a|0;c=c|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;t=a+18600|0;q=f[t>>2]|0;s=a+18556|0;r=a+18580|0;p=Vv(s,(f[r>>2]|0)+147|0)|0;u=a+16|0;v=a+26|0;b[v>>0]=(p&255)<<4&16|b[v>>0]&-17;if(!p){do if(!(f[q+20>>2]|0)){n=f[r>>2]|0;if((j+i|0)!=12?Vv(s,n+156+k|0)|0:0){p=3;break}p=(Vv(s,n+160|0)|0)+1|0}else p=1;while(0);b[v>>0]=b[v>>0]&-4|p&3;if((p|0)!=2){n=(f[q+328>>2]|0)+-1|0;a:do if((n|0)!=0?(Vv(s,(f[r>>2]|0)+154|0)|0)!=0:0){k=0;while(1){o=k+1|0;if((o|0)==(n|0))break a;if(!k)k=Vv(s,(f[r>>2]|0)+155|0)|0;else k=Xv(s)|0;if(!k){n=o;break}else k=o}}else n=0;while(0);b[u>>0]=n;zu(a,0,0,0);o=(Vv(s,(f[r>>2]|0)+152|0)|0)&255;b[v>>0]=o<<2&4|b[v>>0]&-5;if((p|0)==1){s=a+18592|0;s=f[s>>2]|0;t=f[t>>2]|0;v=a+18596|0;v=f[v>>2]|0;Yw(s,t,v,u,c,e,g,h,l,i,j,m);return}}o=(f[q+332>>2]|0)+-1|0;b:do if((o|0)!=0?(Vv(s,(f[r>>2]|0)+154|0)|0)!=0:0){k=0;while(1){n=k+1|0;if((n|0)==(o|0)){n=o;break b}if(!k)k=Vv(s,(f[r>>2]|0)+155|0)|0;else k=Xv(s)|0;if(!k)break;else k=n}}else n=0;while(0);b[a+17>>0]=n;if((p|0)==3&(b[q+370>>0]|0)!=0){d[a+22>>1]=0;d[a+24>>1]=0}else zu(a,0,0,1);n=(Vv(s,(f[r>>2]|0)+152|0)|0)&255;k=b[v>>0]&-9;n=n<<3&8}else{c:do if((f[(f[t>>2]|0)+804>>2]|0)>=2?(Vv(s,(f[r>>2]|0)+148|0)|0)!=0:0)if(((f[(f[t>>2]|0)+804>>2]|0)+-1|0)>1){n=1;do{if(!(Xv(s)|0))break c;n=n+1|0}while((n|0)<((f[(f[t>>2]|0)+804>>2]|0)+-1|0))}else n=1;else n=0;while(0);k=b[v>>0]&31;n=(n&255)<<5&255}b[v>>0]=k|n;s=a+18592|0;s=f[s>>2]|0;t=f[t>>2]|0;v=a+18596|0;v=f[v>>2]|0;Yw(s,t,v,u,c,e,g,h,l,i,j,m);return}function vu(a,c,d,e,g,i,j,k,l,m,n,o,p,q,r){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;p=p|0;q=q|0;r=r|0;var s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0;C=a+18596|0;t=f[C>>2]|0;s=f[t+10368>>2]|0;u=c>>s;if((u|0)<=-1)Pa(48699,48736,118,48756);D=(o|0)==1;E=a+18556|0;F=a+18580|0;G=(o|0)!=0;B=d;z=e;y=g;A=k;x=m;w=t;v=u;e=d>>s;while(1){m=f[w+10372>>2]|0;if((v|0)>=(m|0)){H=4;break}if((e|0)<=-1){H=7;break}t=f[w+10376>>2]|0;if((e|0)>=(t|0)){H=7;break}u=f[w+10360>>2]|0;d=u+(((X(m,e)|0)+v|0)*3|0)|0;d=((h[d>>0]|h[d+1>>0]<<8)&65535)>>>8&3;if((d&65535|0)!=(p|0)){H=9;break}g=(f[w+5868>>2]|0)<(A|0);if(!g?!(((l|0)>=(n|0)?1:(f[w+5864>>2]|0)>=(A|0))|G&(l|0)==0):0){e=5-A|0;if(e>>>0>=3){H=13;break}m=Vv(E,(f[F>>2]|0)+(e+20)|0)|0}else{k=c>>s;e=B>>s;if(!((k|0)>-1&(k|0)<(m|0))){H=16;break}if(!((e|0)>-1&(e|0)<(t|0))){H=18;break}m=u+(((X(m,e)|0)+k|0)*3|0)|0;m=(D&(l|0)==0|g|((h[m>>0]|h[m+1>>0]<<8)&56)!=0&(d<<16>>16==1?(f[w+1392>>2]|l|0)==0:0))&1}t=(m|0)!=0;if(t){g=f[w+10448>>2]|0;e=c>>g;g=B>>g;if((e|0)<=-1){H=23;break}s=f[w+10452>>2]|0;if((e|0)>=(s|0)){H=23;break}if((g|0)<=-1){H=26;break}if((g|0)>=(f[w+10456>>2]|0)){H=26;break}v=(f[w+10440>>2]|0)+((X(s,g)|0)+e)|0;b[v>>0]=h[v>>0]|0|1<<l}k=w+5776|0;w=f[k>>2]|0;if((w|0)==3|(A|0)>2&(w|0)!=0){if(q<<24>>24){e=l+16|0;g=Vv(E,(f[F>>2]|0)+e|0)|0;if((f[k>>2]|0)==2?(A|0)==3|(m|0)==0:0)g=(Vv(E,(f[F>>2]|0)+e|0)|0)<<1|g}else g=-1;if(r<<24>>24){s=l+16|0;e=Vv(E,(f[F>>2]|0)+s|0)|0;if((f[k>>2]|0)==2?(A|0)==3|(m|0)==0:0)e=(Vv(E,(f[F>>2]|0)+s|0)|0)<<1|e}else e=-1;if((g|0)<0)H=38;else m=g}else{e=-1;H=38}if((H|0)==38){H=0;g=(A|0)==2;if(g&(l|0)==0){H=39;break}m=g&(l|0)>0?q&255:0}s=(e|0)<0?((A|0)==2&(l|0)>0?r&255:0):e;if(!t){H=43;break}e=A+-1|0;k=1<<e;g=k+c|0;k=k+B|0;l=l+1|0;q=m&255;r=s&255;vu(a,c,B,c,B,i,j,e,l,0,n,o,p,q,r);vu(a,g,B,c,B,i,j,e,l,1,n,o,p,q,r);vu(a,c,k,c,B,i,j,e,l,2,n,o,p,q,r);w=f[C>>2]|0;s=f[w+10368>>2]|0;v=g>>s;if((v|0)<=-1){H=4;break}else{y=B;z=c;c=g;B=k;A=e;x=3;e=k>>s}}switch(H|0){case 4:{Pa(48699,48736,118,48756);break}case 7:{Pa(48760,48736,119,48756);break}case 9:{Pa(39561,39459,3827,39584);break}case 13:{Pa(39604,39459,1820,39633);break}case 16:{Pa(48699,48736,118,48756);break}case 18:{Pa(48760,48736,119,48756);break}case 23:{Pa(48699,48736,128,48756);break}case 26:{Pa(48760,48736,129,48756);break}case 39:{Pa(39661,39459,3894,39584);break}case 43:{if(!(d<<16>>16==0|(m|l|s|0)!=0)){H=1;wu(a,c,B,z,y,i,j,A,0,x,H,m,s)|0;return}H=Vv(E,(f[F>>2]|0)+((l|0)==0?15:14)|0)|0;wu(a,c,B,z,y,i,j,A,0,x,H,m,s)|0;return}}}function wu(a,c,d,e,g,i,j,k,l,m,n,o,p){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;p=p|0;var q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;if((o|0)==-1)Pa(39698,39459,3547,39711);if((p|0)==-1)Pa(39731,39459,3548,39711);if((n|0)==-1)Pa(39744,39459,3549,39711);D=a+18596|0;s=f[D>>2]|0;A=f[s+5776>>2]|0;z=(A|0)==3;B=((z^1)<<31>>31)+k|0;B=(B|0)>2?B:2;t=p|o;q=a+33|0;b[q>>0]=0;b[q+1>>0]=0;b[q+2>>0]=0;b[q+3>>0]=0;q=f[s+10368>>2]|0;l=c>>q;q=d>>q;if((l|0)<=-1)Pa(48699,48736,118,48756);r=f[s+10372>>2]|0;if((l|0)>=(r|0))Pa(48699,48736,118,48756);if((q|0)<=-1)Pa(48760,48736,119,48756);if((q|0)>=(f[s+10376>>2]|0))Pa(48760,48736,119,48756);x=(f[s+10360>>2]|0)+(((X(r,q)|0)+l|0)*3|0)|0;x=((h[x>>0]|h[x+1>>0]<<8)&65535)>>>8&3;C=x&65535;y=(n|0)!=0;r=(t|0)!=0;do if(t|n|0){if((b[s+5946>>0]|0)!=0?(u=a+18508|0,(f[u>>2]|0)==0):0){q=a+18556|0;l=a+18580|0;do if(!(Vv(q,(f[l>>2]|0)+139|0)|0)){q=0;l=0}else{if(Vv(q,(f[l>>2]|0)+140|0)|0)if(Vv(q,(f[l>>2]|0)+140|0)|0)if(Vv(q,(f[l>>2]|0)+140|0)|0)if(Vv(q,(f[l>>2]|0)+140|0)|0){l=(_v(q,0)|0)+5|0;if(!l){q=0;l=0;break}}else l=4;else l=3;else l=2;else l=1;q=Xv(q)|0}while(0);f[u>>2]=1;s=X(1-(q<<1)|0,l)|0;f[a+18512>>2]=s;s=1}else s=0;if((r&(b[(f[a+18600>>2]|0)+752>>0]|0)!=0?(b[a+32>>0]|0)==0:0)?(v=a+18516|0,(f[v>>2]|0)==0):0){q=a+18556|0;l=a+18580|0;u=Vv(q,(f[l>>2]|0)+23|0)|0;r=f[D>>2]|0;if(!u){f[v>>2]=1;f[a+18520>>2]=0;l=0}else{if((h[r+10074>>0]|0)>1)l=Vv(q,(f[l>>2]|0)+24|0)|0;else l=0;f[v>>2]=1;f[a+18520>>2]=b[r+10075+l>>0];l=b[r+10081+l>>0]|0}f[a+18524>>2]=l}else w=33;if((w|0)==33?!s:0)break;ov(a,c,d,i,j)}while(0);r=1<<k;u=1<<B;w=f[D>>2]|0;v=f[w+5780>>2]|0;w=f[w+5784>>2]|0;n=a+28|0;f[n>>2]=0;if(y)xu(a,c,d,k,0)|0;yu(a,c,d,i,j,r,0,C,y);if(!((k|0)>2|z)){if((m|0)!=3)return 0;l=(o&1|0)!=0;if(l)xu(a,e,g,k,1)|0;if(f[(f[D>>2]|0)+5776>>2]|0)yu(a,(e|0)/(v|0)|0,(g|0)/(w|0)|0,(i|0)/(v|0)|0,(j|0)/(w|0)|0,r,1,C,l);l=(o&2|0)!=0;if(l)xu(a,e,r+g|0,k,1)|0;q=(A|0)==2;if(q)yu(a,(e|0)/(v|0)|0,((g|0)/(w|0)|0)+r|0,(i|0)/(v|0)|0,(j|0)/(w|0)|0,r,1,C,l);l=(p&1|0)!=0;if(l)xu(a,e,g,k,2)|0;if(f[(f[D>>2]|0)+5776>>2]|0)yu(a,(e|0)/(v|0)|0,(g|0)/(w|0)|0,(i|0)/(v|0)|0,(j|0)/(w|0)|0,r,2,C,l);l=(p&2|0)!=0;if(l)xu(a,e,u+g|0,k,2)|0;if(!q)return 0;yu(a,(e|0)/(v|0)|0,((g|0)/(w|0)|0)+r|0,(i|0)/(v|0)|0,(j|0)/(w|0)|0,r,2,C,l);return 0}s=f[D>>2]|0;a:do if(y&(b[s+10071>>0]|0)!=0){do if(x<<16>>16!=1){q=f[s+10428>>2]|0;l=c>>q;q=d>>q;if((l|0)<=-1)Pa(48699,48736,118,48756);r=f[s+10432>>2]|0;if((l|0)>=(r|0))Pa(48699,48736,118,48756);if((q|0)<=-1)Pa(48760,48736,119,48756);if((q|0)<(f[s+10436>>2]|0)){k=(f[s+10420>>2]|0)+((X(r,q)|0)+l)|0;if((b[k>>0]|0)<0)break;else{l=0;q=0;break a}}else Pa(48760,48736,119,48756)}while(0);r=a+18556|0;s=a+18580|0;l=0;q=0;do{k=(Vv(r,(f[s>>2]|0)+(l+162)|0)|0)!=0;q=(k&1)+q|0;l=l+1|0}while((l|0)<4&k);if(!q){l=0;q=1}else{l=1-((Vv(r,(f[s>>2]|0)+170|0)|0)<<1)<<q+-1;q=1}}else{l=0;q=0}while(0);f[n>>2]=l;l=(o&1|0)!=0;if(l)xu(a,c,d,B,1)|0;if(f[(f[D>>2]|0)+5776>>2]|0)yu(a,(c|0)/(v|0)|0,(d|0)/(w|0)|0,(i|0)/(v|0)|0,(j|0)/(w|0)|0,u,1,C,l);t=(A|0)==2;if(t){l=(o&2|0)!=0;if(l)xu(a,c,(w<<B)+d|0,B,1)|0;yu(a,(c|0)/(v|0)|0,((d|0)/(w|0)|0)+u|0,(i|0)/(v|0)|0,((j|0)/(w|0)|0)+u|0,u,1,C,l)}if(q){r=a+18556|0;s=a+18580|0;l=0;q=0;do{o=(Vv(r,(f[s>>2]|0)+(l+166)|0)|0)!=0;q=(o&1)+q|0;l=l+1|0}while((l|0)<4&o);if(q)l=1-((Vv(r,(f[s>>2]|0)+171|0)|0)<<1)<<q+-1;else l=0}else l=0;f[n>>2]=l;l=(p&1|0)!=0;if(l)xu(a,c,d,B,2)|0;if(f[(f[D>>2]|0)+5776>>2]|0)yu(a,(c|0)/(v|0)|0,(d|0)/(w|0)|0,(i|0)/(v|0)|0,(j|0)/(w|0)|0,u,2,C,l);if(!t)return 0;l=(p&2|0)!=0;if(l)xu(a,c,(w<<B)+d|0,B,2)|0;yu(a,(c|0)/(v|0)|0,((d|0)/(w|0)|0)+u|0,(i|0)/(v|0)|0,((j|0)/(w|0)|0)+u|0,u,2,C,l);return 0}function xu(a,c,e,g,i){a=a|0;c=c|0;e=e|0;g=g|0;i=i|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0;oa=u;u=u+160|0;x=oa+144|0;ja=oa+80|0;ka=oa;la=oa+64|0;ma=oa+48|0;ia=oa+32|0;y=f[a+18596>>2]|0;w=y+764|0;l=f[y+10368>>2]|0;k=c>>l;l=e>>l;if((k|0)<=-1)Pa(48699,48736,118,48756);m=f[y+10372>>2]|0;if((k|0)>=(m|0))Pa(48699,48736,118,48756);if((l|0)<=-1)Pa(48760,48736,119,48756);if((l|0)>=(f[y+10376>>2]|0))Pa(48760,48736,119,48756);t=(f[y+10360>>2]|0)+(((X(m,l)|0)+k|0)*3|0)|0;t=((h[t>>0]|h[t+1>>0]<<8)&65535)>>>8&3;ha=(i|0)==0;if(ha?(ga=f[y+10448>>2]|0,q=c>>ga,p=e>>ga,ga=g-ga|0,n=1<<ga,r=n+p|0,(ga|0)!=31):0){m=n+q|0;n=y+10452|0;o=y+10440|0;k=p;do{l=q;do{ga=(X(f[n>>2]|0,k)|0)+l|0;ga=(f[o>>2]|0)+ga|0;b[ga>>0]=b[ga>>0]|-128;l=l+1|0}while((l|0)<(m|0));k=k+1|0}while((k|0)<(r|0))}if(((b[y+5945>>0]|0)!=0?(b[a+32>>0]|0)==0:0)?(f[y+10100>>2]|0)>=(g|0):0)k=(Vv(a+18556|0,(f[a+18580>>2]|0)+(i|0?142:141)|0)|0)&255;else k=0;ga=a+33+i|0;b[ga>>0]=k;fa=a+36|0;b[fa>>0]=0;do if(t<<16>>16==1?(b[y+5751>>0]|0)!=0:0){if((b[ga>>0]|0)==0?(b[a+32>>0]|0)==0:0){na=23;break}k=a+18580|0;l=a+18556|0;m=(i|0)!=0&1;ea=(Vv(l,(f[k>>2]|0)+143+m|0)|0)&255;b[fa>>0]=ea;if(ea<<24>>24){ea=(Vv(l,(f[k>>2]|0)+145+m|0)|0)&255;b[a+37>>0]=ea}}else na=23;while(0);if((na|0)==23)b[fa>>0]=0;k=ha?2:0;if(!((b[ga>>0]|0)==0?(b[a+32>>0]|0)==0:0))k=k|1;da=a+18580|0;n=(f[da>>2]|0)+25|0;ca=g<<1;s=ca+-1|0;ea=g+-2|0;p=ha?g+1>>2:ea;q=ha?(ea*3|0)+(g+-1>>2)|0:15;if((ca|0)>1){r=a+18556|0;l=s;m=0;do{ca=(Vv(r,n+((m>>p)+q)|0)|0)==0;l=ca?m:l;m=m+1|0}while((m|0)<(s|0)&(ca^1));o=(f[da>>2]|0)+43|0;n=s;m=0;do{ca=(Vv(r,o+((m>>p)+q)|0)|0)==0;n=ca?m:n;m=m+1|0}while((m|0)<(s|0)&(ca^1))}else{n=s;l=s}m=(l>>1)+-1|0;if((l|0)>3)l=(Zv(a+18556|0,m)|0)+((l&1|2)<<m)|0;m=(n>>1)+-1|0;if((n|0)>3)p=(Zv(a+18556|0,m)|0)+((n&1|2)<<m)|0;else p=n;ca=t<<16>>16==0;if(ca){do if(ha){n=f[y+10408>>2]|0;m=c>>n;n=e>>n;if((m|0)<=-1)Pa(48699,48736,118,48756);o=f[y+10412>>2]|0;if((m|0)>=(o|0))Pa(48699,48736,118,48756);if((n|0)<=-1)Pa(48760,48736,119,48756);if((n|0)<(f[y+10416>>2]|0)){v=(f[y+10400>>2]|0)+((X(o,n)|0)+m)|0;v=b[v>>0]|0;break}else Pa(48760,48736,119,48756)}else{n=f[y+10428>>2]|0;m=c>>n;n=e>>n;if((m|0)<=-1)Pa(48699,48736,118,48756);o=f[y+10432>>2]|0;if((m|0)>=(o|0))Pa(48699,48736,118,48756);if((n|0)<=-1)Pa(48760,48736,119,48756);if((n|0)<(f[y+10436>>2]|0)){v=(f[y+10420>>2]|0)+((X(o,n)|0)+m)|0;v=b[v>>0]&63;break}else Pa(48760,48736,119,48756)}while(0);n=vw(g,v&255,i,w)|0;ba=(n|0)==2;m=ba?l:p;l=ba?p:l}else{n=0;m=p}aa=bu(ea,n)|0;ba=bu(2,n)|0;cu(x,l,m,n,g);$=b[x+1>>0]|0;W=h[x>>0]|0;IM(ja|0,0,1<<ea<<ea|0)|0;Y=a+14404+(i<<1)|0;d[Y>>1]=0;Z=a+18556|0;_=(i|0)!=0&1;I=(n|0)!=0&1;J=($&255)+-1|0;K=y+5749|0;L=a+32|0;M=ha?42:43;N=$<<24>>24!=0;O=(i|0)>0;P=y+10408|0;Q=y+10412|0;R=y+10416|0;S=y+10400|0;T=y+5750|0;U=y+5936|0;V=y+5755|0;E=a+18588+k|0;F=y+10428|0;G=y+10432|0;H=y+10436|0;C=y+10420|0;D=($&255)>1;k=1;B=W;t=0;l=0;a:while(1){q=b[aa+(B<<1)>>0]|0;r=b[aa+(B<<1)+1>>0]|0;if((B|0)<(W|0)&(B|0)!=0){o=q&255;m=r&255;n=m<<ea;A=h[ja+(n+o)>>0]|0;A=A&1|A>>>1;if(!(Vv(Z,(f[da>>2]|0)+((ha?A:A+2|0)+61)|0)|0)){n=1;m=0}else{p=1;na=59}}else if((B|0)==0|(B|0)==(W|0)){n=r&255;p=0;m=n;n=n<<ea;o=q&255;na=59}else{n=0;m=0}if((na|0)==59){na=0;n=ja+(o+-1+n)|0;if(q<<24>>24)b[n>>0]=b[n>>0]|1;m=ja+((m+-1<<ea)+o)|0;if(!(r<<24>>24)){n=p;m=1}else{b[m>>0]=b[m>>0]|2;n=p;m=1}}do if(m){s=q&255;A=s<<2;r=r&255;z=r<<2;r=f[57532+(ea<<6)+(_<<5)+(I<<4)+(h[ja+((r<<ea)+s)>>0]<<2)>>2]|0;s=(B|0)==(W|0);if(s){d[ka>>1]=1;b[ia>>0]=1;b[la>>0]=$;if(D){q=J;m=n;n=1;na=67}else{m=n;n=1}}else{q=15;m=n;n=0;na=67}if((na|0)==67)while(1){na=0;o=(h[ba+(q<<1)>>0]|0)+A|0;p=(h[ba+(q<<1)+1>>0]|0)+z|0;do if(b[K>>0]|0){if(b[L>>0]|0){o=M;break}if(b[ga>>0]|0)o=M;else na=70}else na=70;while(0);if((na|0)==70){na=0;o=h[r+(o+(p<<g))>>0]|0}if(Vv(Z,(f[da>>2]|0)+(o+65)|0)|0){d[ka+(n<<1)>>1]=1;b[ia+n>>0]=1;b[la+n>>0]=q;m=0;n=n+1|0}if((q|0)>1){q=q+-1|0;na=67}else break}do if(N|s^1){if(m|0){d[ka+(n<<1)>>1]=1;b[ia+n>>0]=1;b[la+n>>0]=0;y=n+1|0;break}do if(b[K>>0]|0){if(b[L>>0]|0){m=M;break}if(b[ga>>0]|0)m=M;else na=78}else na=78;while(0);if((na|0)==78){na=0;m=h[r+((z<<g)+A)>>0]|0}if(!(Vv(Z,(f[da>>2]|0)+(m+65)|0)|0)){y=n;break}d[ka+(n<<1)>>1]=1;b[ia+n>>0]=1;b[la+n>>0]=0;y=n+1|0}else y=n;while(0);if(y){r=(k|0)==0|(O|(B|0)==0?0:2);p=(y|0)<8?y:8;s=(y|0)>0;do if(s){q=r<<2;if(O){o=0;n=-1;k=1;m=t;do{if(!o)l=1;else l=(l|0)>0?((m|0)==1?0:l+1|0):l;m=Vv(Z,(f[da>>2]|0)+(((l|0)<3?l:3)+q+125)|0)|0;if(!m){b[ia+o>>0]=0;k=((k+-1|0)>>>0<2&1)+k|0}else{k=ka+(o<<1)|0;d[k>>1]=(d[k>>1]|0)+1<<16>>16;n=(n|0)==-1?o:n;k=0}o=o+1|0}while((o|0)<(p|0))}else{o=0;n=-1;k=1;m=t;do{if(!o)l=1;else l=(l|0)>0?((m|0)==1?0:l+1|0):l;m=Vv(Z,(f[da>>2]|0)+(((l|0)<3?l:3)+q+109)|0)|0;if(!m){b[ia+o>>0]=0;k=((k+-1|0)>>>0<2&1)+k|0}else{k=ka+(o<<1)|0;d[k>>1]=(d[k>>1]|0)+1<<16>>16;n=(n|0)==-1?o:n;k=0}o=o+1|0}while((o|0)<(p|0))}if((n|0)==-1)break;x=Vv(Z,(f[da>>2]|0)+((O?r|4:r)+133)|0)|0;w=ka+(n<<1)|0;d[w>>1]=(j[w>>1]|0)+x;b[ia+n>>0]=x}else{k=1;m=t}while(0);if(ha){o=f[P>>2]|0;n=c>>o;o=e>>o;if((n|0)<=-1){na=102;break a}p=f[Q>>2]|0;if((n|0)>=(p|0)){na=102;break a}if((o|0)<=-1){na=105;break a}if((o|0)>=(f[R>>2]|0)){na=105;break a}n=(f[S>>2]|0)+((X(p,o)|0)+n)|0;n=b[n>>0]|0}else{o=f[F>>2]|0;n=c>>o;o=e>>o;if((n|0)<=-1){na=109;break a}p=f[G>>2]|0;if((n|0)>=(p|0)){na=109;break a}if((o|0)<=-1){na=112;break a}if((o|0)>=(f[H>>2]|0)){na=112;break a}n=(f[C>>2]|0)+((X(p,o)|0)+n)|0;n=b[n>>0]&63}b:do if(!(b[L>>0]|0)){do if(ca){if(!(b[T>>0]|0))break;if((n|16)<<24>>24==26&(b[ga>>0]|0)!=0){o=0;break b}}while(0);if(b[fa>>0]|0){o=0;break}o=((b[la>>0]|0)-(b[la+(y+-1)>>0]|0)|0)>3&1}else o=0;while(0);x=y+-1|0;if((y|0)>1){n=0;do{w=(Xv(Z)|0)&255;b[ma+n>>0]=w;n=n+1|0}while((n|0)!=(x|0))}w=(o|0)!=0;if(w&(b[U>>0]|0)!=0)n=0;else n=(Xv(Z)|0)&255;b[ma+x>>0]=n;if(!(b[V>>0]|0))n=0;else n=(h[E>>0]|0)>>>2&255;if(s){v=0;s=1;o=0}else break;do{t=d[ka+(v<<1)>>1]|0;do if(!(b[ia+v>>0]|0))r=0;else{q=-1;while(1){p=q+1|0;r=Xv(Z)|0;if((q|0)>63){r=0;break}if(!r){na=130;break}else q=p}if((na|0)==130){na=0;if((p|0)<4)q=Zv(Z,n)|0;else{p=q+-2|0;q=Zv(Z,p+n|0)|0;p=(1<<p)+2|0}r=(p<<n)+q|0}q=(b[V>>0]|0)==0;p=n+1|0;n=(r+t|0)>(3<<n|0)?(q?((p|0)<4?p:4):p):n;if(q|s^1){s=0;break}p=b[E>>0]|0;q=(p&255)>>>2&255;if((r|0)>=(3<<q|0)){b[E>>0]=p+1<<24>>24;s=0;break}if(p<<24>>24==0|(r<<1|0)>=(1<<q|0)){s=0;break}b[E>>0]=p+-1<<24>>24;s=0}while(0);q=r+t|0;r=(b[ma+v>>0]|0)==0?q:0-(q&65535)|0;p=r&65535;do if(w&(b[U>>0]|0)!=0){o=q+o|0;if((v|0)!=(x|0)|(o&1|0)==0)break;p=0-r&65535}while(0);t=b[la+v>>0]|0;r=(h[ba+(t<<1)>>0]|0)+A|0;t=(h[ba+(t<<1)+1>>0]|0)+z|0;d[a+2116+(i<<11)+(d[Y>>1]<<1)>>1]=p;d[a+8260+(i<<11)+(d[Y>>1]<<1)>>1]=r+(t<<g);d[Y>>1]=(d[Y>>1]|0)+1<<16>>16;v=v+1|0}while((v|0)!=(y|0))}else m=t}else m=t;while(0);if((B|0)>0){B=B+-1|0;t=m}else{na=54;break}}if((na|0)==54){u=oa;return 0}else if((na|0)==102)Pa(48699,48736,118,48756);else if((na|0)==105)Pa(48760,48736,119,48756);else if((na|0)==109)Pa(48699,48736,118,48756);else if((na|0)==112)Pa(48760,48736,119,48756);return 0}function yu(a,c,e,g,h,i,j,k,l){a=a|0;c=c|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0;q=a+18596|0;p=f[q>>2]|0;r=(k|0)==0;if(!r)if(!(b[a+36>>0]|0))k=0;else k=b[a+37>>0]|0?2:1;else{do if(!j){m=f[p+10408>>2]|0;k=c>>m;m=e>>m;if((k|0)<=-1)Pa(48699,48736,118,48756);n=f[p+10412>>2]|0;if((k|0)>=(n|0))Pa(48699,48736,118,48756);if((m|0)<=-1)Pa(48760,48736,119,48756);if((m|0)<(f[p+10416>>2]|0)){o=(f[p+10400>>2]|0)+((X(n,m)|0)+k)|0;o=b[o>>0]|0;break}else Pa(48760,48736,119,48756)}else{k=X(f[p+5780>>2]|0,c)|0;n=X(f[p+5784>>2]|0,e)|0;m=f[p+10428>>2]|0;k=k>>m;m=n>>m;if((k|0)<=-1)Pa(48699,48736,118,48756);n=f[p+10432>>2]|0;if((k|0)>=(n|0))Pa(48699,48736,118,48756);if((m|0)<=-1)Pa(48760,48736,119,48756);if((m|0)<(f[p+10436>>2]|0)){o=(f[p+10420>>2]|0)+((X(n,m)|0)+k)|0;o=b[o>>0]&63;break}else Pa(48760,48736,119,48756)}while(0);m=(o&255)>34?1:o&255;ww(p,c,e,m,i,j);do if(!(b[(f[q>>2]|0)+5750>>0]|0))k=0;else{if((b[a+32>>0]|0)==0?(b[a+33+j>>0]|0)==0:0){k=0;break}k=(m|16|0)==26}while(0);k=(m|0)==26&k?2:k&1}if(l){pv(a,c,e,g,h,i,j,(b[a+33+j>>0]|0)!=0,r,k);return}if(!j)return;if(!(f[a+28>>2]|0))return;d[a+14404+(j<<1)>>1]=0;pv(a,c,e,g,h,i,j,(b[a+33+j>>0]|0)!=0,r,0);return}function zu(a,b,c,e){a=a|0;b=b|0;c=c|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=u;u=u+16|0;l=n;k=a+18556|0;c=a+18580|0;g=Vv(k,(f[c>>2]|0)+150|0)|0;b=Vv(k,(f[c>>2]|0)+150|0)|0;g=(g|0)==0;if(g)h=0;else h=Vv(k,(f[c>>2]|0)+151|0)|0;j=(b|0)==0;if(j)i=0;else i=Vv(k,(f[c>>2]|0)+151|0)|0;if(!g){if(!h)g=-1;else g=_v(k,1)|0;h=Xv(k)|0;b=g+2|0;f[l>>2]=b;if(!h)h=b;else{c=l;b=-2-g|0;m=11}}else{c=l;b=0;m=11}if((m|0)==11){f[c>>2]=b;h=b}do if(!j){if(!i)g=-1;else g=_v(k,1)|0;m=Xv(k)|0;b=g+2|0;c=l+4|0;f[c>>2]=b;if(!m){m=b;k=h&65535;l=a+18+(e<<2)|0;d[l>>1]=k;m=m&65535;e=a+18+(e<<2)+2|0;d[e>>1]=m;u=n;return}else{b=-2-g|0;break}}else{c=l+4|0;b=0}while(0);f[c>>2]=b;m=b;k=h&65535;l=a+18+(e<<2)|0;d[l>>1]=k;m=m&65535;e=a+18+(e<<2)+2|0;d[e>>1]=m;u=n;return}function Au(a){a=a|0;QK(a);return}function Bu(a){a=a|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;m=f[a+16>>2]|0;g=m+18596|0;n=f[g>>2]|0;l=n+5820|0;j=f[l>>2]|0;o=a+4|0;f[o>>2]=1;dt(n,a);g=f[g>>2]|0;e=f[m+4>>2]|0;d=f[g+5836>>2]|0;h=f[g+5820>>2]|0;if((e|0)<(d|0))d=f[(f[g+10284>>2]|0)+(e<<2)>>2]|0;f[m>>2]=d;e=m+8|0;f[e>>2]=(d|0)%(h|0)|0;g=m+12|0;f[g>>2]=(d|0)/(h|0)|0;i=(d|0)/(j|0)|0;d=a+8|0;if(b[d>>0]|0?!(ku(m)|0):0){if((j|0)>0){e=n+10524|0;d=X(i,j)|0;c=0;do{ev((f[e>>2]|0)+((c+d|0)*80|0)|0,1);c=c+1|0}while((c|0)!=(j|0))}f[o>>2]=3;fv((f[m+18608>>2]|0)+44|0,1);et(n,a);return}Uv(m+18556|0);if(!(b[d>>0]|0))d=0;else d=(b[(f[m+18600>>2]|0)+12>>0]|0)==0;lu(m,1,d)|0;a:do if((f[g>>2]|0)==(i|0)?(k=f[l>>2]|0,c=f[e>>2]|0,(c|0)<(k|0)):0){h=n+5828|0;e=X(i,j)|0;g=n+10524|0;d=k;while(1){if((c|0)<(d|0)?(i|0)<(f[h>>2]|0):0)ev((f[g>>2]|0)+((c+e|0)*80|0)|0,1);c=c+1|0;if((c|0)==(k|0))break a;d=f[l>>2]|0}}while(0);f[o>>2]=3;fv((f[m+18608>>2]|0)+44|0,1);et(n,a);return}function Cu(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0;e=u;u=u+112|0;g=e;d=e+4|0;f[g>>2]=f[c+12>>2];Hy(d,39882,g)|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;c=vx(d)|0;if(c>>>0>4294967279)XK(a);if(c>>>0<11){b[a+11>>0]=c;if(!c){g=a;g=g+c|0;b[g>>0]=0;u=e;return}}else{h=c+16&-16;g=OK(h)|0;f[a>>2]=g;f[a+8>>2]=h|-2147483648;f[a+4>>2]=c;a=g}GM(a|0,d|0,c|0)|0;h=a;h=h+c|0;b[h>>0]=0;u=e;return}function Du(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;i=b[e+93784+((f[c+8>>2]|0)*4400|0)+2>>0]|0;s=Rv(a)|0;r=c+380|0;b[r>>0]=s;if(s>>>0>7){v=0;return v|0}s=e+11096+(i*5168|0)+476|0;do if(f[s>>2]|0){g=Sv(a)|0;g=(h[r>>0]|0)+g|0;if(g>>>0>7){v=0;return v|0}else{n=c+381|0;b[n>>0]=g;break}}else n=c+381|0;while(0);o=c+332|0;p=c+328|0;q=e+11096+(i*5168|0)+5164|0;l=e+11096+(i*5168|0)+5160|0;m=c+20|0;k=0;a:while(1){g=(k|0)==0;if(!g){if((k|0)==1)if(!(f[m>>2]|0))v=10;else{g=1;v=27;break}}else v=10;if((v|0)==10?(v=0,t=f[(g?p:o)>>2]|0,u=(t|0)>0,u):0){g=0;do{j=(Ov(a,1)|0)&255;b[c+382+(k<<4)+g>>0]=j;g=g+1|0}while((g|0)!=(t|0));if((f[s>>2]|0)!=0&u){g=0;do{j=(Ov(a,1)|0)&255;b[c+414+(k<<4)+g>>0]=j;g=g+1|0}while((g|0)!=(t|0))}if(u){j=0;do{if(!(b[c+382+(k<<4)+j>>0]|0)){d[c+446+(k<<5)+(j<<1)>>1]=1<<h[r>>0];g=0}else{g=Sv(a)|0;if((g+128|0)>>>0>255){g=0;v=27;break a}d[c+446+(k<<5)+(j<<1)>>1]=(1<<h[r>>0])+g;g=Sv(a)|0;i=f[l>>2]|0;if(!((g|0)>=(0-i|0)&(g|0)<(i|0))){g=0;v=27;break a}g=g&255}b[c+510+(k<<4)+j>>0]=g;if(!(b[c+414+(k<<4)+j>>0]|0)){g=1<<h[n>>0]&65535;d[c+542+(k<<6)+(j<<2)>>1]=g;b[c+670+(k<<5)+(j<<1)>>0]=0;d[c+542+(k<<6)+(j<<2)+2>>1]=g;g=0}else{g=Sv(a)|0;if((g+128|0)>>>0>255){g=0;v=27;break a}i=c+542+(k<<6)+(j<<2)|0;d[i>>1]=(1<<h[n>>0])+g;g=Sv(a)|0;e=f[q>>2]|0;if(!((g|0)>=(X(e,-4)|0)&(g|0)<(e<<2|0))){g=0;v=27;break a}i=X(d[i>>1]|0,e)|0;g=e+g-(i>>h[n>>0])|0;i=0-e|0;b[c+670+(k<<5)+(j<<1)>>0]=(g|0)<(i|0)?i:(g|0)<(e|0)?g:e+255|0;g=Sv(a)|0;if((g+128|0)>>>0>255){g=0;v=27;break a}i=c+542+(k<<6)+(j<<2)+2|0;d[i>>1]=(1<<h[n>>0])+g;g=Sv(a)|0;e=f[q>>2]|0;if(!((g|0)>=(X(e,-4)|0)&(g|0)<(e<<2|0))){g=0;v=27;break a}i=X(d[i>>1]|0,e)|0;g=e+g-(i>>h[n>>0])|0;i=0-e|0;g=((g|0)<(i|0)?i:(g|0)<(e|0)?g:e+255|0)&255}b[c+670+(k<<5)+(j<<1)+1>>0]=g;j=j+1|0}while((j|0)<(t|0))}}k=k+1|0;if((k|0)>=2){g=1;v=27;break}}if((v|0)==27)return g|0;return 0}function Eu(a){a=a|0;var c=0,e=0,g=0;f[a>>2]=0;b[a+4>>0]=0;b[a+5>>0]=0;f[a+8>>2]=0;b[a+12>>0]=0;c=a+16|0;f[a+28>>2]=0;b[a+32>>0]=0;f[c>>2]=0;f[c+4>>2]=0;d[c+8>>1]=0;Zw(a+34|0);f[a+136>>2]=0;f[a+140>>2]=0;f[a+144>>2]=0;c=0;do{b[a+148+c>>0]=0;f[a+164+(c<<2)>>2]=0;b[a+228+c>>0]=0;b[a+244+c>>0]=0;f[a+260+(c<<2)>>2]=0;c=c+1|0}while((c|0)!=16);c=a+324|0;f[a+376>>2]=0;b[a+380>>0]=0;b[a+381>>0]=0;e=c;g=e+48|0;do{f[e>>2]=0;e=e+4|0}while((e|0)<(g|0));b[c+48>>0]=0;c=0;do{b[a+382+c>>0]=0;b[a+414+c>>0]=0;d[a+446+(c<<1)>>1]=0;b[a+510+c>>0]=0;d[a+542+(c<<2)+2>>1]=0;d[a+542+(c<<2)>>1]=0;b[a+670+(c<<1)+1>>0]=0;b[a+670+(c<<1)>>0]=0;c=c+1|0}while((c|0)!=16);c=0;do{b[a+398+c>>0]=0;b[a+430+c>>0]=0;d[a+478+(c<<1)>>1]=0;b[a+526+c>>0]=0;d[a+606+(c<<2)+2>>1]=0;d[a+606+(c<<2)>>1]=0;b[a+702+(c<<1)+1>>0]=0;b[a+702+(c<<1)>>0]=0;c=c+1|0}while((c|0)!=16);e=a+736|0;f[a+756>>2]=0;f[a+760>>2]=0;b[a+764>>0]=0;f[a+768>>2]=0;f[a+772>>2]=0;f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;f[e+12>>2]=0;d[e+16>>1]=0;b[e+18>>0]=0;e=f[a+776>>2]|0;g=a+780|0;c=f[g>>2]|0;if((c|0)!=(e|0))f[g>>2]=c+(~((c+-4-e|0)>>>2)<<2);c=a+788|0;f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;f[c+12>>2]=0;f[c+16>>2]=0;f[c+20>>2]=0;Zw(a+812|0);f[a+912>>2]=0;c=0;do{f[a+916+(c<<6)>>2]=0;f[a+1044+(c<<6)>>2]=0;f[a+1172+(c<<6)>>2]=0;b[a+1300+(c<<4)>>0]=0;f[a+916+(c<<6)+4>>2]=0;f[a+1044+(c<<6)+4>>2]=0;f[a+1172+(c<<6)+4>>2]=0;b[a+1300+(c<<4)+1>>0]=0;f[a+916+(c<<6)+8>>2]=0;f[a+1044+(c<<6)+8>>2]=0;f[a+1172+(c<<6)+8>>2]=0;b[a+1300+(c<<4)+2>>0]=0;f[a+916+(c<<6)+12>>2]=0;f[a+1044+(c<<6)+12>>2]=0;f[a+1172+(c<<6)+12>>2]=0;b[a+1300+(c<<4)+3>>0]=0;f[a+916+(c<<6)+16>>2]=0;f[a+1044+(c<<6)+16>>2]=0;f[a+1172+(c<<6)+16>>2]=0;b[a+1300+(c<<4)+4>>0]=0;f[a+916+(c<<6)+20>>2]=0;f[a+1044+(c<<6)+20>>2]=0;f[a+1172+(c<<6)+20>>2]=0;b[a+1300+(c<<4)+5>>0]=0;f[a+916+(c<<6)+24>>2]=0;f[a+1044+(c<<6)+24>>2]=0;f[a+1172+(c<<6)+24>>2]=0;b[a+1300+(c<<4)+6>>0]=0;f[a+916+(c<<6)+28>>2]=0;f[a+1044+(c<<6)+28>>2]=0;f[a+1172+(c<<6)+28>>2]=0;b[a+1300+(c<<4)+7>>0]=0;f[a+916+(c<<6)+32>>2]=0;f[a+1044+(c<<6)+32>>2]=0;f[a+1172+(c<<6)+32>>2]=0;b[a+1300+(c<<4)+8>>0]=0;f[a+916+(c<<6)+36>>2]=0;f[a+1044+(c<<6)+36>>2]=0;f[a+1172+(c<<6)+36>>2]=0;b[a+1300+(c<<4)+9>>0]=0;f[a+916+(c<<6)+40>>2]=0;f[a+1044+(c<<6)+40>>2]=0;f[a+1172+(c<<6)+40>>2]=0;b[a+1300+(c<<4)+10>>0]=0;f[a+916+(c<<6)+44>>2]=0;f[a+1044+(c<<6)+44>>2]=0;f[a+1172+(c<<6)+44>>2]=0;b[a+1300+(c<<4)+11>>0]=0;f[a+916+(c<<6)+48>>2]=0;f[a+1044+(c<<6)+48>>2]=0;f[a+1172+(c<<6)+48>>2]=0;b[a+1300+(c<<4)+12>>0]=0;f[a+916+(c<<6)+52>>2]=0;f[a+1044+(c<<6)+52>>2]=0;f[a+1172+(c<<6)+52>>2]=0;b[a+1300+(c<<4)+13>>0]=0;f[a+916+(c<<6)+56>>2]=0;f[a+1044+(c<<6)+56>>2]=0;f[a+1172+(c<<6)+56>>2]=0;b[a+1300+(c<<4)+14>>0]=0;f[a+916+(c<<6)+60>>2]=0;f[a+1044+(c<<6)+60>>2]=0;f[a+1172+(c<<6)+60>>2]=0;b[a+1300+(c<<4)+15>>0]=0;c=c+1|0}while((c|0)!=2);c=f[a+1344>>2]|0;e=a+1348|0;g=f[e>>2]|0;if((g|0)==(c|0)){a=a+1340|0;b[a>>0]=0;return}f[e>>2]=g+(~((g+-4-c|0)>>>2)<<2);a=a+1340|0;b[a>>0]=0;return}function Fu(a,c,e,g){a=a|0;c=c|0;e=e|0;g=g|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;b[g>>0]=0;Eu(a);m=a+12|0;b[m>>0]=0;v=(Ov(c,1)|0)&255;l=a+4|0;b[l>>0]=v;if(b[e+377214>>0]|0){v=(Ov(c,1)|0)&255;b[a+5>>0]=v}v=Rv(c)|0;f[a+8>>2]=v;if((v|0)>64|(v|0)==-99999){uq(e+4|0,1009,0);g=0;return g|0}if(!(b[e+93784+(v*4400|0)>>0]|0)){uq(e+4|0,1009,0);g=0;return g|0}s=b[e+93784+(v*4400|0)+2>>0]|0;n=e+11096+(s*5168|0)|0;if(!(b[n>>0]|0)){uq(e+4|0,1010,0);b[g>>0]=0;g=0;return g|0}if(!(b[l>>0]|0)){if(!(b[e+93784+(v*4400|0)+3>>0]|0))i=0;else i=(Ov(c,1)|0)&255;b[m>>0]=i;j=f[e+11096+(s*5168|0)+5072>>2]|0;i=0;while(1)if((1<<i|0)<(j|0))i=i+1|0;else break;i=Ov(c,i)|0;if(!(b[m>>0]|0))j=0;else{if(!i){b[g>>0]=0;uq(e+4|0,1021,0);g=0;return g|0}j=f[e+376228>>2]|0;if(!j){g=16;return g|0}GM(a|0,j|0,776)|0;k=(j|0)==(a|0);if(!k)sq(a+776|0,f[j+776>>2]|0,f[j+780>>2]|0);GM(a+788|0,j+788|0,544)|0;gw(a+1332|0,j+1332|0)|0;b[a+1340>>0]=b[j+1340>>0]|0;if(!k)sq(a+1344|0,f[j+1344>>2]|0,f[j+1348>>2]|0);b[l>>0]=0;j=1;u=23}}else{i=0;j=0;u=23}if((u|0)==23)b[m>>0]=j;r=a+16|0;f[r>>2]=i;if((i|0)>=0?(i|0)<(f[e+11096+(s*5168|0)+5072>>2]|0):0){if(!(j<<24>>24)){j=e+93784+(v*4400|0)+4132|0;if((b[j>>0]|0)>0){i=0;do{Pv(c,1);i=i+1|0}while((i|0)<(b[j>>0]|0))}p=Rv(c)|0;q=a+20|0;f[q>>2]=p;if((p|0)>2|(p|0)==-99999){uq(e+4|0,1007,0);b[g>>0]=0;g=0;return g|0}if(!(b[e+93784+(v*4400|0)+31>>0]|0))i=1;else i=(Ov(c,1)|0)&255;b[a+24>>0]=i;if((b[e+11096+(s*5168|0)+480>>0]|0)==1){p=(Ov(c,2)|0)&255;b[a+25>>0]=p}i=a+28|0;f[i>>2]=0;j=a+32|0;b[j>>0]=0;if(((b[e+377212>>0]|0)+-19&255)<2){f[i>>2]=0;f[a+140>>2]=0;f[a+144>>2]=0;i=0}else{p=e+11096+(s*5168|0)+520|0;o=Ov(c,f[p>>2]|0)|0;f[i>>2]=o;o=(Ov(c,1)|0)&255;b[j>>0]=o;do if(!(o<<24>>24)){i=a+34|0;k=e+11096+(s*5168|0)+4720|0;j=e+11096+(s*5168|0)+4724|0;_w(e+4|0,n,c,i,((f[j>>2]|0)-(f[k>>2]|0)|0)/100|0,k,1)|0;f[a+808>>2]=((f[j>>2]|0)-(f[k>>2]|0)|0)/100|0;k=a+812|0;j=k+100|0;do{d[k>>1]=d[i>>1]|0;k=k+2|0;i=i+2|0}while((k|0)<(j|0))}else{k=e+11096+(s*5168|0)+4720|0;n=e+11096+(s*5168|0)+4724|0;i=f[n>>2]|0;l=f[k>>2]|0;m=(i-l|0)/100|0;j=0;while(1)if((1<<j|0)<(m|0))j=j+1|0;else break;if((j|0)>0){l=Ov(c,j)|0;j=f[k>>2]|0;i=f[n>>2]|0}else{j=l;l=0}f[a+136>>2]=l;if((l|0)<((i-j|0)/100|0|0)){f[a+808>>2]=l;k=a+812|0;i=j+(l*100|0)|0;j=k+100|0;do{d[k>>1]=d[i>>1]|0;k=k+2|0;i=i+2|0}while((k|0)<(j|0));break}uq(e+4|0,1015,0);g=8;return g|0}while(0);a:do if(!(b[e+11096+(s*5168|0)+4732>>0]|0)){f[a+140>>2]=0;f[a+144>>2]=0;i=0}else{m=e+11096+(s*5168|0)+4736|0;do if((f[m>>2]|0)>0){o=Rv(c)|0;f[a+140>>2]=o;if((o|0)==-99999)i=8;else break;return i|0}else f[a+140>>2]=0;while(0);i=Rv(c)|0;n=a+144|0;f[n>>2]=i;if((i|0)==-99999){g=8;return g|0}o=a+140|0;j=f[o>>2]|0;i=j+i|0;if((i+(h[a+908>>0]|0)+(h[a+909>>0]|0)|0)>(f[e+11096+(s*5168|0)+528+((b[e+11096+(s*5168|0)+2>>0]|0)+-1<<2)>>2]|0)){uq(e+4|0,1018,0);b[g>>0]=0;g=0;return g|0}if((i|0)>0){i=0;l=0}else{i=0;break}while(1){if((l|0)<(j|0)){k=f[m>>2]|0;j=0;while(1)if((1<<j|0)<(k|0))j=j+1|0;else break;k=Ov(c,j)|0;j=a+148+l|0;b[j>>0]=k;k=k&255;if((k|0)>=(f[m>>2]|0))break;f[e+376232+(l<<2)>>2]=f[e+11096+(s*5168|0)+4740+(k<<2)>>2];j=(h[j>>0]|0)+(e+11096+(s*5168|0)+4868)|0}else{w=Ov(c,f[p>>2]|0)|0;k=a+164+(l<<2)|0;f[k>>2]=w;w=(Ov(c,1)|0)&255;j=a+228+l|0;b[j>>0]=w;f[e+376232+(l<<2)>>2]=f[k>>2]}w=b[j>>0]|0;f[e+376296+(l<<2)>>2]=w<<24>>24;i=(w<<24>>24!=0&1)+i|0;w=(Ov(c,1)|0)&255;b[a+244+l>>0]=w;if(w<<24>>24){j=Rv(c)|0;f[a+260+(l<<2)>>2]=j;if((j|0)==-99999){i=8;u=189;break}}else{f[a+260+(l<<2)>>2]=0;j=0}do if(l){if((l|0)==(f[o>>2]|0))break;j=(f[e+376360+(l+-1<<2)>>2]|0)+j|0}while(0);f[e+376360+(l<<2)>>2]=j;l=l+1|0;j=f[o>>2]|0;if((l|0)>=((f[n>>2]|0)+j|0))break a}if((u|0)==189)return i|0;uq(e+4|0,1023,0);b[g>>0]=0;w=0;return w|0}while(0);if(!(b[e+11096+(s*5168|0)+4900>>0]|0))j=0;else j=(Ov(c,1)|0)&255;b[a+324>>0]=j}if(b[e+11096+(s*5168|0)+4703>>0]|0){w=(Ov(c,1)|0)&255;b[a+325>>0]=w;if(!(f[e+11096+(s*5168|0)+5012>>2]|0))j=0;else j=(Ov(c,1)|0)&255}else{b[a+325>>0]=0;j=0}n=a+326|0;b[n>>0]=j;l=a+328|0;f[l>>2]=0;m=a+332|0;f[m>>2]=0;do if((f[q>>2]|0)>>>0<2){w=(Ov(c,1)|0)&255;b[a+327>>0]=w;do if(!(w<<24>>24)){j=b[e+93784+(v*4400|0)+6>>0]|0;f[l>>2]=j;k=b[e+93784+(v*4400|0)+7>>0]|0;u=86}else{j=Rv(c)|0;f[l>>2]=j;if((j|0)==-99999){uq(e+4|0,1007,0);w=8;return w|0}j=j+1|0;f[l>>2]=j;if(f[q>>2]|0)break;k=Rv(c)|0;f[m>>2]=k;if((k|0)!=-99999){j=f[l>>2]|0;k=k+1|0;u=86;break}uq(e+4|0,1007,0);w=8;return w|0}while(0);if((u|0)==86)f[m>>2]=k;if((j|0)>16){w=8;return w|0}if((f[m>>2]|0)>16){w=8;return w|0}i=(h[a+911>>0]|0)+i|0;f[a+912>>2]=i;do if((i|0)>1?(b[e+93784+(v*4400|0)+4125>>0]|0)!=0:0){j=0;while(1)if((1<<j|0)<(i|0))j=j+1|0;else break;w=(Ov(c,1)|0)&255;b[a+336>>0]=w;do if(w<<24>>24){if((f[l>>2]|0)>0)i=0;else break;do{w=(Ov(c,j)|0)&255;b[a+338+i>>0]=w;i=i+1|0}while((i|0)<(f[l>>2]|0))}while(0);if(f[q>>2]|0){b[a+337>>0]=0;break}w=(Ov(c,1)|0)&255;b[a+337>>0]=w;if(!(w<<24>>24))break;if((f[m>>2]|0)>0)i=0;else break;do{w=(Ov(c,j)|0)&255;b[a+354+i>>0]=w;i=i+1|0}while((i|0)<(f[m>>2]|0))}else{b[a+336>>0]=0;b[a+337>>0]=0}while(0);if(!(f[q>>2]|0)){w=(Ov(c,1)|0)&255;b[a+370>>0]=w}if(!(b[e+93784+(v*4400|0)+5>>0]|0))i=0;else i=(Ov(c,1)|0)&255;b[a+371>>0]=i;do if(b[a+324>>0]|0){do if(!(f[q>>2]|0)){i=(Ov(c,1)|0)&255;j=a+372|0;b[j>>0]=i;if(i<<24>>24){u=108;break}if((f[m>>2]|0)>1)u=110;else{i=0;u=113}}else{j=a+372|0;b[j>>0]=1;i=1;u=108}while(0);if((u|0)==108)if((f[l>>2]|0)>1)u=110;else u=113;do if((u|0)==110){k=Rv(c)|0;f[a+376>>2]=k;if((k|0)!=-99999){i=b[j>>0]|0;break}uq(e+4|0,1007,0);w=8;return w|0}else if((u|0)==113){f[a+376>>2]=0;k=0}while(0);if(!(i<<24>>24)){if((k|0)<(f[m>>2]|0))break}else if((k|0)<(f[l>>2]|0))break;uq(e+4|0,8,0);w=8;return w|0}while(0);if((b[e+93784+(v*4400|0)+29>>0]|0)!=0?(f[q>>2]|0)==1:0)u=122;else u=120;do if((u|0)==120){if(!(b[e+93784+(v*4400|0)+30>>0]|0))break;if(!(f[q>>2]|0))u=122}while(0);do if((u|0)==122){if(Du(c,a,e)|0)break;uq(e+4|0,8,0);w=8;return w|0}while(0);i=Rv(c)|0;f[a+736>>2]=i;if((i|0)!=-99999){f[a+804>>2]=5-i;break}uq(e+4|0,1007,0);w=8;return w|0}while(0);w=Sv(c)|0;f[a+740>>2]=w;if((w|0)==-99999){uq(e+4|0,1007,0);w=8;return w|0}do if(!(b[e+93784+(v*4400|0)+28>>0]|0)){f[a+744>>2]=0;f[a+748>>2]=0}else{w=Sv(c)|0;f[a+744>>2]=w;if((w|0)==-99999){uq(e+4|0,1007,0);w=8;return w|0}w=Sv(c)|0;f[a+748>>2]=w;if((w|0)!=-99999)break;uq(e+4|0,1007,0);w=8;return w|0}while(0);if(b[e+93784+(v*4400|0)+4140>>0]|0){w=(Ov(c,1)|0)&255;b[a+752>>0]=w}if(!(b[e+93784+(v*4400|0)+48>>0]|0))i=0;else i=(Ov(c,1)|0)&255;b[a+753>>0]=i;j=a+756|0;f[j>>2]=f[e+93784+(v*4400|0)+52>>2];k=a+760|0;f[k>>2]=f[e+93784+(v*4400|0)+56>>2];do if(!(i<<24>>24))b[a+754>>0]=b[e+93784+(v*4400|0)+49>>0]|0;else{w=(Ov(c,1)|0)&255;b[a+754>>0]=w;if(w<<24>>24)break;i=Sv(c)|0;f[j>>2]=i;if((i|0)==-99999){uq(e+4|0,1007,0);w=8;return w|0}f[j>>2]=i<<1;i=Sv(c)|0;f[k>>2]=i;if((i|0)!=-99999){f[k>>2]=i<<1;break}uq(e+4|0,1007,0);w=8;return w|0}while(0);i=b[e+93784+(v*4400|0)+46>>0]|0;b:do if(!(i<<24>>24))i=0;else{do if(!(b[a+325>>0]|0)){if(b[n>>0]|0)break;if(b[a+754>>0]|0)break b}while(0);i=(Ov(c,1)|0)&255}while(0);b[a+764>>0]=i}j=e+93784+(v*4400|0)+34|0;if((b[j>>0]|0)==0?(b[e+93784+(v*4400|0)+33>>0]|0)==0:0)f[a+768>>2]=0;else u=155;c:do if((u|0)==155){i=Rv(c)|0;o=a+768|0;f[o>>2]=i;if((i|0)==-99999){uq(e+4|0,1007,0);w=8;return w|0}if(b[e+93784+(v*4400|0)+33>>0]|0?(((f[r>>2]|0)/(f[e+11096+(s*5168|0)+5056>>2]|0)|0)+i|0)>=(f[e+11096+(s*5168|0)+5064>>2]|0):0){uq(e+4|0,1007,0);w=8;return w|0}if(b[j>>0]|0?(i|0)>(X(f[e+93784+(v*4400|0)+40>>2]|0,f[e+93784+(v*4400|0)+36>>2]|0)|0):0){uq(e+4|0,1007,0);w=8;return w|0}n=a+776|0;j=a+780|0;m=f[j>>2]|0;l=f[n>>2]|0;k=m-l>>2;if(i>>>0<=k>>>0){if(i>>>0<k>>>0?(t=l+(i<<2)|0,(m|0)!=(t|0)):0)f[j>>2]=m+(~((m+-4-t|0)>>>2)<<2)}else{St(n,i-k|0);i=f[o>>2]|0}if((i|0)>0){i=Rv(c)|0;m=a+772|0;f[m>>2]=i;if((i|0)==-99999){uq(e+4|0,1007,0);w=8;return w|0}j=i+1|0;f[m>>2]=j;if((i|0)>31){w=8;return w|0}if((f[o>>2]|0)>0){i=0;while(1){j=(Ov(c,j)|0)+1|0;k=f[n>>2]|0;l=k+(i<<2)|0;f[l>>2]=j;if((i|0)>0)f[l>>2]=j+(f[k+(i+-1<<2)>>2]|0);i=i+1|0;if((i|0)>=(f[o>>2]|0))break c;j=f[m>>2]|0}}}}while(0);do if(b[e+93784+(v*4400|0)+4133>>0]|0){i=Rv(c)|0;j=a+788|0;f[j>>2]=i;if((i|0)==-99999|(i|0)>1e3){uq(e+4|0,1007,0);w=8;return w|0}else{if((i|0)>0)i=0;else break;do{Ov(c,8)|0;i=i+1|0}while((i|0)<(f[j>>2]|0))}}while(0);f[a+792>>2]=(f[a+740>>2]|0)+(f[e+93784+(v*4400|0)+8>>2]|0);switch(f[a+20>>2]|0){case 2:{i=0;u=187;break}case 1:{i=(b[a+371>>0]|0)+1|0;u=187;break}case 0:{i=2-(b[a+371>>0]|0)|0;u=187;break}default:{}}if((u|0)==187)f[a+796>>2]=i;f[a+804>>2]=5-(f[a+736>>2]|0);b[g>>0]=1;w=0;return w|0}uq(e+4|0,1020,0);w=8;return w|0}function Gu(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0;ia=u;u=u+448|0;ha=ia+432|0;ga=ia+424|0;fa=ia+416|0;da=ia+408|0;ca=ia+400|0;ba=ia+392|0;aa=ia+384|0;$=ia+376|0;Y=ia+368|0;X=ia+360|0;W=ia+352|0;V=ia+344|0;U=ia+328|0;T=ia+312|0;S=ia+296|0;R=ia+280|0;_=ia+264|0;Z=ia+248|0;P=ia+240|0;O=ia+232|0;N=ia+224|0;M=ia+216|0;L=ia+208|0;K=ia+200|0;J=ia+192|0;H=ia+184|0;G=ia+176|0;E=ia+168|0;D=ia+160|0;C=ia+152|0;B=ia+144|0;A=ia+136|0;z=ia+128|0;y=ia+120|0;x=ia+112|0;w=ia+104|0;v=ia+96|0;t=ia+88|0;s=ia+80|0;r=ia+72|0;q=ia+64|0;p=ia+56|0;o=ia+48|0;k=ia+40|0;n=ia+32|0;m=ia+24|0;l=ia+16|0;j=ia+8|0;g=ia;switch(e|0){case 1:{e=10100;break}case 2:{e=10604;break}default:{u=ia;return}}ea=f[e>>2]|0;i=a+8|0;Q=f[i>>2]|0;if(!(b[c+93784+(Q*4400|0)>>0]|0))Pa(39915,39459,1278,39929);F=b[c+93784+(Q*4400|0)+2>>0]|0;if(!(b[c+11096+(F*5168|0)>>0]|0))Pa(39955,39459,1281,39929);wv(ea,39969,g);e=a+4|0;f[j>>2]=b[e>>0];wv(ea,40012,j);g=c+377212|0;if((b[g>>0]&-8)<<24>>24==16){f[l>>2]=b[a+5>>0];wv(ea,40055,l)}f[m>>2]=f[i>>2];wv(ea,40098,m);if(!(b[e>>0]|0)){f[n>>2]=b[a+12>>0];wv(ea,40141,n);f[k>>2]=f[a+16>>2];wv(ea,40184,k)}m=a+20|0;n=f[m>>2]|0;f[o>>2]=(n|0)==0?66:(n|0)==1?80:73;wv(ea,40227,o);if(b[c+93784+(Q*4400|0)+31>>0]|0){f[p>>2]=b[a+24>>0];wv(ea,40270,p)}if((b[c+11096+(F*5168|0)+480>>0]|0)==1){f[q>>2]=b[a+25>>0];wv(ea,40313,q)}f[r>>2]=f[a+28>>2];wv(ea,40356,r);if(((b[g>>0]|0)+-19&255)>=2){r=a+32|0;f[s>>2]=b[r>>0];wv(ea,40399,s);e=c+11096+(F*5168|0)+4720|0;g=(f[c+11096+(F*5168|0)+4724>>2]|0)-(f[e>>2]|0)|0;if(b[r>>0]|0){if((g|0)>100){t=a+136|0;f[v>>2]=f[t>>2];wv(ea,40442,v);$w((f[e>>2]|0)+((f[t>>2]|0)*100|0)|0,16,ea)}}else{f[t>>2]=(g|0)/100|0;wv(ea,43584,t);$w(a+34|0,16,ea)}if(b[c+11096+(F*5168|0)+4732>>0]|0){if((f[c+11096+(F*5168|0)+4736>>2]|0)>0){f[w>>2]=f[a+140>>2];wv(ea,40485,w)}f[x>>2]=f[a+144>>2];wv(ea,40532,x)}if(b[c+11096+(F*5168|0)+4900>>0]|0){f[y>>2]=b[a+324>>0];wv(ea,40579,y)}}if(b[c+11096+(F*5168|0)+4703>>0]|0){f[z>>2]=b[a+325>>0];wv(ea,40617,z);f[A>>2]=b[a+326>>0];wv(ea,40655,A)}if((f[m>>2]|0)>>>0<2){e=a+327|0;f[B>>2]=b[e>>0];wv(ea,40693,B);l=a+328|0;B=b[e>>0]|0?79883:40732;f[C>>2]=f[l>>2];f[C+4>>2]=B;wv(ea,40743,C);if(!(f[m>>2]|0)){C=b[e>>0]|0?79883:40732;f[D>>2]=f[a+332>>2];f[D+4>>2]=C;wv(ea,40783,D)}if(b[c+93784+(Q*4400|0)+4125>>0]|0?(f[a+912>>2]|0)>1:0){D=a+336|0;f[E>>2]=b[D>>0];wv(ea,40823,E);if(b[D>>0]|0?(f[l>>2]|0)>0:0){e=0;do{E=h[a+338+e>>0]|0;f[G>>2]=e;f[G+4>>2]=E;wv(ea,40863,G);e=e+1|0}while((e|0)<(f[l>>2]|0))}G=a+337|0;f[H>>2]=b[G>>0];wv(ea,40873,H);if(b[G>>0]|0?(I=a+332|0,(f[I>>2]|0)>0):0){e=0;do{H=h[a+354+e>>0]|0;f[J>>2]=e;f[J+4>>2]=H;wv(ea,40863,J);e=e+1|0}while((e|0)<(f[I>>2]|0))}}if(!(f[m>>2]|0)){f[K>>2]=b[a+370>>0];wv(ea,40913,K)}f[L>>2]=b[a+371>>0];wv(ea,40950,L);if(b[a+324>>0]|0){f[M>>2]=b[a+372>>0];wv(ea,40987,M);f[N>>2]=f[a+376>>2];wv(ea,41024,N)}if((b[c+93784+(Q*4400|0)+29>>0]|0)!=0?(f[m>>2]|0)==1:0)k=47;else k=45;if(((k|0)==45?b[c+93784+(Q*4400|0)+30>>0]|0:0)?(f[m>>2]|0)==0:0)k=47;a:do if((k|0)==47){f[O>>2]=h[a+380>>0];wv(ea,41061,O);if(f[c+11096+(F*5168|0)+476>>2]|0){f[P>>2]=h[a+381>>0];wv(ea,41098,P)}j=a+332|0;i=0;do{e=(i|0)==0;do if(!e){if((i|0)!=1)break;if(f[m>>2]|0)break a;else k=53}else k=53;while(0);do if((k|0)==53){k=0;g=f[(e?l:j)>>2]|0;if((g|0)>0)e=0;else break;do{P=d[a+446+(i<<5)+(e<<1)>>1]|0;f[Z>>2]=i;f[Z+4>>2]=e;f[Z+8>>2]=P;wv(ea,41135,Z);P=b[a+510+(i<<4)+e>>0]|0;f[_>>2]=i;f[_+4>>2]=e;f[_+8>>2]=P;wv(ea,41172,_);P=d[a+542+(i<<6)+(e<<2)>>1]|0;f[R>>2]=i;f[R+4>>2]=e;f[R+8>>2]=0;f[R+12>>2]=P;wv(ea,41209,R);P=b[a+670+(i<<5)+(e<<1)>>0]|0;f[S>>2]=i;f[S+4>>2]=e;f[S+8>>2]=0;f[S+12>>2]=P;wv(ea,41247,S);P=d[a+542+(i<<6)+(e<<2)+2>>1]|0;f[T>>2]=i;f[T+4>>2]=e;f[T+8>>2]=1;f[T+12>>2]=P;wv(ea,41209,T);P=b[a+670+(i<<5)+(e<<1)+1>>0]|0;f[U>>2]=i;f[U+4>>2]=e;f[U+8>>2]=1;f[U+12>>2]=P;wv(ea,41247,U);e=e+1|0}while((e|0)!=(g|0))}while(0);i=i+1|0}while((i|0)!=2)}while(0);f[V>>2]=f[a+736>>2];wv(ea,41285,V)}f[W>>2]=f[a+740>>2];wv(ea,41322,W);if(b[c+93784+(Q*4400|0)+28>>0]|0){f[X>>2]=f[a+744>>2];wv(ea,41351,X);f[Y>>2]=f[a+748>>2];wv(ea,41380,Y)}g=a+753|0;if(b[c+93784+(Q*4400|0)+48>>0]|0){f[$>>2]=b[g>>0];wv(ea,41409,$)}e=a+754|0;$=b[g>>0]|0?41447:41458;f[aa>>2]=b[e>>0];f[aa+4>>2]=$;wv(ea,41469,aa);if(b[g>>0]|0?(b[e>>0]|0)==0:0){f[ba>>2]=f[a+756>>2];wv(ea,41516,ba);f[ca>>2]=f[a+760>>2];wv(ea,41541,ca)}do if(b[c+93784+(Q*4400|0)+46>>0]|0){if(((b[a+325>>0]|0)==0?(b[a+326>>0]|0)==0:0)?b[e>>0]|0:0)break;f[da>>2]=b[a+764>>0];wv(ea,41566,da)}while(0);if((b[c+93784+(Q*4400|0)+34>>0]|0)==0?(b[c+93784+(Q*4400|0)+33>>0]|0)==0:0){u=ia;return}i=a+768|0;f[fa>>2]=f[i>>2];wv(ea,41617,fa);if((f[i>>2]|0)<=0){u=ia;return}f[ga>>2]=f[a+772>>2];wv(ea,41650,ga);if((f[i>>2]|0)<=0){u=ia;return}g=a+776|0;e=0;do{ga=f[(f[g>>2]|0)+(e<<2)>>2]|0;f[ha>>2]=e;f[ha+4>>2]=ga;wv(ea,41683,ha);e=e+1|0}while((e|0)<(f[i>>2]|0));u=ia;return}function Hu(){var a=0,c=0,d=0,e=0,g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;a=dx(11296)|0;if(!a){x=0;return x|0}IM(a|0,-1,11296)|0;f[14383]=a;f[14384]=a;f[14385]=a;f[14386]=a;f[14387]=a;f[14388]=a;f[14389]=a;f[14390]=a;p=a+16|0;f[14391]=p;f[14392]=p;f[14393]=p;f[14394]=p;f[14395]=p;f[14396]=p;f[14397]=p;f[14398]=p;f[14399]=a+32;f[14400]=a+96;f[14401]=a+160;f[14402]=a+224;f[14403]=a+288;f[14404]=a+352;f[14405]=a+416;f[14406]=a+480;f[14407]=a+544;f[14408]=a+608;f[14409]=a+672;f[14410]=a+736;f[14411]=a+800;f[14412]=a+864;f[14413]=a+928;f[14414]=a+992;p=a+1056|0;f[14415]=p;f[14419]=p;p=a+1312|0;f[14416]=p;f[14420]=p;p=a+1568|0;f[14417]=p;f[14421]=p;p=a+1824|0;f[14418]=p;f[14422]=p;p=a+2080|0;f[14423]=p;f[14427]=p;p=a+2336|0;f[14424]=p;f[14428]=p;p=a+2592|0;f[14425]=p;f[14429]=p;p=a+2848|0;f[14426]=p;f[14430]=p;p=a+3104|0;f[14431]=p;f[14435]=p;p=a+4128|0;f[14432]=p;f[14436]=p;p=a+5152|0;f[14433]=p;f[14437]=p;p=a+6176|0;f[14434]=p;f[14438]=p;p=a+7200|0;f[14439]=p;f[14443]=p;p=a+8224|0;f[14440]=p;f[14444]=p;p=a+9248|0;f[14441]=p;f[14445]=p;p=a+10272|0;f[14442]=p;f[14446]=p;p=2;a:while(1){q=1<<p;t=q>>2;r=(t|0)==1;s=p+-2|0;t=(t|0)==2;o=0;do{u=(o|0)==0;n=0;do{v=(n|0)==0?9:15;m=0;do{w=57532+(s<<6)+(o<<5)+(n<<4)+(m<<2)|0;l=0;do{e=l<<2;x=l<<p;g=0-l|0;i=l>>2;j=l&3;k=(j|0)==0?2:(j|0)==1&1;if(r){c=0;do{a=h[41706+(c+e)>>0]|0;a=u?a:a+27|0;d=(f[w>>2]|0)+(c+x)|0;k=b[d>>0]|0;if(!(k<<24>>24==-1|(k&255|0)==(a|0))){c=28;break a}b[d>>0]=a;c=c+1|0}while((c|0)<(q|0))}else{d=0;do{do if((d|0)!=(g|0)){c=d>>2;a=d&3;switch(m|0){case 0:{a=a+j|0;a=a>>>0>2?0:a|0?1:2;break}case 1:{a=k;break}case 2:{a=(a|0)==0?2:(a|0)==1&1;break}default:a=2}if(u){a=(c+i|0)>0?a+3|0:a;if(t){a=a+v|0;break}else{a=a+21|0;break}}else if(t){a=a+9|0;break}else{a=a+12|0;break}}else a=0;while(0);a=u?a:a+27|0;c=(f[w>>2]|0)+(d+x)|0;e=b[c>>0]|0;if(!(e<<24>>24==-1|(e&255|0)==(a|0))){c=28;break a}b[c>>0]=a;d=d+1|0}while((d|0)<(q|0))}l=l+1|0}while((l|0)<(q|0));m=m+1|0}while((m|0)<4);n=n+1|0}while((n|0)<2);o=o+1|0}while((o|0)<2);p=p+1|0;if((p|0)>=6){a=1;c=30;break}}if((c|0)==28)Pa(41722,39459,2100,41798);else if((c|0)==30)return a|0;return 0}function Iu(){ex(f[14383]|0);f[14383]=0;return}function Ju(a){a=a|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;g=f[a+18596>>2]|0;d=f[a+4>>2]|0;c=f[g+5836>>2]|0;e=f[g+5820>>2]|0;if((d|0)<(c|0))c=f[(f[g+10284>>2]|0)+(d<<2)>>2]|0;f[a>>2]=c;f[a+8>>2]=(c|0)%(e|0)|0;f[a+12>>2]=(c|0)/(e|0)|0;j=a+18600|0;d=f[j>>2]|0;if(!(ku(a)|0)){a=18;return a|0}k=a+18556|0;Uv(k);l=a+18560|0;m=a+18592|0;g=g+5966|0;h=a+18580|0;i=a+18588|0;c=0;d=(b[d+12>>0]|0)==0;while(1){do if((c|0)>0){e=c+-1|0;o=f[j>>2]|0;n=f[o+776>>2]|0;if(e>>>0<(f[o+780>>2]|0)-n>>2>>>0?((f[l>>2]|0)+-2-(f[k>>2]|0)|0)==(f[n+(e<<2)>>2]|0):0)break;uq((f[m>>2]|0)+4|0,1003,1)}while(0);c=c+1|0;if((lu(a,0,d)|0|2|0)==2){c=0;d=14;break}if(!(b[g>>0]|0)){d=0;continue}d=f[j>>2]|0;e=f[d+796>>2]|0;if(e>>>0>=3){d=12;break}cw(h,e,f[d+792>>2]|0);b[i>>0]=0;b[i+1>>0]=0;b[i+2>>0]=0;b[i+3>>0]=0;d=0}if((d|0)==12)Pa(39428,39459,1508,39468);else if((d|0)==14)return c|0;return 0}function Ku(a){a=a|0;var c=0,d=0;f[a+4720>>2]=0;f[a+4724>>2]=0;f[a+4728>>2]=0;Kv(a+4904|0);c=a+4984|0;d=c+9|0;do{b[c>>0]=0;c=c+1|0}while((c|0)<(d|0));b[a>>0]=0;return}function Lu(a){a=a|0;var b=0,c=0;c=f[a+4720>>2]|0;if(!c)return;a=a+4724|0;b=f[a>>2]|0;if((b|0)!=(c|0))f[a>>2]=b+(~(((b+-100-c|0)>>>0)/100|0)*100|0);QK(c);return}function Mu(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;l=(Ov(d,4)|0)&255;b[a+1>>0]=l;l=(Ov(d,3)|0)+1|0;j=a+2|0;b[j>>0]=l;if((l<<24|0)>117440512){a=8;return a|0}e=(Ov(d,1)|0)&255;b[a+3>>0]=e;zv(a+4|0,d,b[j>>0]|0);e=Rv(d)|0;if((e|0)==-99999){uq(c,8,0);a=8;return a|0}f[a+472>>2]=e;if((e|0)>15){a=8;return a|0}e=Rv(d)|0;if((e|0)==-99999){uq(c,8,0);a=8;return a|0}g=a+476|0;f[g>>2]=e;if((e|0)==3){h=(Ov(d,1)|0)&255;e=f[g>>2]|0}else h=0;b[a+480>>0]=h;f[a+5012>>2]=h<<24>>24==0?e:0;if(e>>>0>3){uq(c,1019,0);a=8;return a|0}e=Rv(d)|0;if((e|0)==-99999){uq(c,8,0);a=8;return a|0}g=a+484|0;f[g>>2]=e;h=Rv(d)|0;if((h|0)==-99999){uq(c,8,0);a=8;return a|0}f[a+488>>2]=h;e=f[g>>2]|0;if((h|0)==0|(e|0)==0){a=8;return a|0}if((h|0)>7e4|(e|0)>7e4){a=8;return a|0}l=(Ov(d,1)|0)&255;b[a+492>>0]=l;if(l<<24>>24){e=Rv(d)|0;if((e|0)==-99999){uq(c,8,0);a=8;return a|0}f[a+496>>2]=e;e=Rv(d)|0;if((e|0)==-99999){uq(c,8,0);a=8;return a|0}f[a+500>>2]=e;e=Rv(d)|0;if((e|0)==-99999){uq(c,8,0);a=8;return a|0}f[a+504>>2]=e;e=Rv(d)|0;if((e|0)==-99999){uq(c,8,0);a=8;return a|0}}else{f[a+496>>2]=0;f[a+500>>2]=0;f[a+504>>2]=0;e=0}f[a+508>>2]=e;e=Rv(d)|0;if((e|0)==-99999){uq(c,8,0);a=8;return a|0}f[a+512>>2]=e+8;e=Rv(d)|0;if((e|0)==-99999){uq(c,8,0);a=8;return a|0}f[a+516>>2]=e+8;e=Rv(d)|0;if((e|0)==-99999){uq(c,8,0);a=8;return a|0}k=e+4|0;l=a+520|0;f[l>>2]=k;f[a+5032>>2]=1<<k;k=(Ov(d,1)|0)&255;i=a+524|0;b[i>>0]=k;if(!(k<<24>>24)){h=b[j>>0]|0;e=(h<<24>>24)+-1|0}else{e=0;m=35}while(1){if((m|0)==35)h=b[j>>0]|0;g=h<<24>>24;if((e|0)>=(g|0)){m=44;break}g=Rv(d)|0;if((g|0)==-99999|(g|0)>15){m=38;break}f[a+528+(e<<2)>>2]=g+1;g=Rv(d)|0;if((g|0)==-99999){m=40;break}h=a+556+(e<<2)|0;f[h>>2]=g;g=Rv(d)|0;if((g|0)==-99999){m=42;break}f[a+584+(e<<2)>>2]=g;f[a+5128+(e<<2)>>2]=g+-1+(f[h>>2]|0);e=e+1|0;m=35}if((m|0)==38){uq(c,8,0);a=8;return a|0}else if((m|0)==40){uq(c,8,0);a=8;return a|0}else if((m|0)==42){uq(c,8,0);a=8;return a|0}else if((m|0)==44){if(b[i>>0]|0){e=g+-1|0;if(h<<24>>24>=8)Pa(41850,41856,317,44844);if(h<<24>>24>1){h=a+528+(e<<2)|0;i=a+556+(e<<2)|0;g=a+584+(e<<2)|0;e=0;do{f[a+528+(e<<2)>>2]=f[h>>2];f[a+556+(e<<2)>>2]=f[i>>2];f[a+584+(e<<2)>>2]=f[g>>2];e=e+1|0}while((e|0)<((b[j>>0]|0)+-1|0))}}e=Rv(d)|0;if((e|0)==-99999){uq(c,8,0);a=8;return a|0}i=a+612|0;f[i>>2]=e+3;e=Rv(d)|0;if((e|0)==-99999){uq(c,8,0);a=8;return a|0}j=a+616|0;f[j>>2]=e;e=Rv(d)|0;if((e|0)==-99999){uq(c,8,0);a=8;return a|0}g=a+620|0;f[g>>2]=e+2;e=Rv(d)|0;if((e|0)==-99999){uq(c,8,0);a=8;return a|0}h=a+624|0;f[h>>2]=e;e=Rv(d)|0;if((e|0)==-99999){uq(c,8,0);a=8;return a|0}f[a+628>>2]=e;e=Rv(d)|0;if((e|0)==-99999){uq(c,8,0);a=8;return a|0}f[a+632>>2]=e;e=f[i>>2]|0;if((e|0)>6){a=8;return a|0}if(((f[j>>2]|0)+e|0)>6){a=8;return a|0}e=f[g>>2]|0;if((e|0)>5){a=8;return a|0}if(((f[h>>2]|0)+e|0)>5){a=8;return a|0}k=(Ov(d,1)|0)&255;b[a+636>>0]=k;do if(k<<24>>24){k=(Ov(d,1)|0)&255;b[a+637>>0]=k;e=a+638|0;if(!(k<<24>>24)){Ou(e);break}e=Nu(d,0,e,0)|0;if(!e)break;return e|0}while(0);k=(Ov(d,1)|0)&255;b[a+4702>>0]=k;k=(Ov(d,1)|0)&255;b[a+4703>>0]=k;k=(Ov(d,1)|0)&255;b[a+4704>>0]=k;do if(!(k<<24>>24)){b[a+4705>>0]=0;b[a+4706>>0]=0;f[a+4708>>2]=0;f[a+4712>>2]=0;e=0}else{e=(Ov(d,4)|0)+1&255;b[a+4705>>0]=e;e=(Ov(d,4)|0)+1&255;b[a+4706>>0]=e;e=Rv(d)|0;if((e|0)==-99999){uq(c,8,0);a=8;return a|0}f[a+4708>>2]=e+3;e=Rv(d)|0;if((e|0)!=-99999){f[a+4712>>2]=e;e=(Ov(d,1)|0)&255;break}uq(c,8,0);a=8;return a|0}while(0);b[a+4716>>0]=e;j=Rv(d)|0;if((j|0)==-99999){uq(c,8,0);a=8;return a|0}if(j>>>0>64){uq(c,1014,0);a=8;return a|0}k=a+4720|0;h=a+4724|0;i=f[h>>2]|0;g=f[k>>2]|0;e=(i-g|0)/100|0;if(j>>>0<=e>>>0){do if(j>>>0<e>>>0){e=g+(j*100|0)|0;if((i|0)==(e|0))break;f[h>>2]=i+(~(((i+-100-e|0)>>>0)/100|0)*100|0)}while(0);if((j|0)>0)m=87}else{Pu(k,j-e|0);m=87}a:do if((m|0)==87){e=0;while(1){if(!(_w(c,a,d,(f[k>>2]|0)+(e*100|0)|0,e,k,0)|0)){e=1005;break}e=e+1|0;if((e|0)>=(j|0))break a}return e|0}while(0);m=(Ov(d,1)|0)&255;b[a+4732>>0]=m;do if(!(m<<24>>24))f[a+4736>>2]=0;else{e=Rv(d)|0;if((e|0)==-99999){uq(c,8,0);a=8;return a|0}g=a+4736|0;f[g>>2]=e;if((e|0)>32){a=8;return a|0}if((e|0)>0)e=0;else break;do{m=Ov(d,f[l>>2]|0)|0;f[a+4740+(e<<2)>>2]=m;m=(Ov(d,1)|0)&255;b[a+4868+e>>0]=m;e=e+1|0}while((e|0)<(f[g>>2]|0))}while(0);m=(Ov(d,1)|0)&255;b[a+4900>>0]=m;m=(Ov(d,1)|0)&255;b[a+4901>>0]=m;m=(Ov(d,1)|0)&255;b[a+4902>>0]=m;if(m<<24>>24)Lv(a+4904|0,c,d,a)|0;c=(Ov(d,1)|0)&255;b[a+4980>>0]=c;do if(!(c<<24>>24))b[a+4981>>0]=0;else{m=(Ov(d,1)|0)&255;c=a+4981|0;b[c>>0]=m;m=(Ov(d,1)|0)&255;b[a+4982>>0]=m;m=(Ov(d,6)|0)&255;b[a+4983>>0]=m;if(!(b[c>>0]|0))break;Qu(a+4984|0,0,d)|0}while(0);e=Ru(a)|0;if(e|0){a=e;return a|0}b[a>>0]=1;a=0;return a|0}return 0}function Nu(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0;v=u;u=u+6240|0;o=v;p=v+96|0;k=0;a:while(1){q=(k|0)==3;r=q?2:6;s=(k|0)==0;t=(k|0)!=3;m=s?16:64;n=(k|0)>1;l=0;do{j=p+(l<<10)|0;g=q&(l|0)==1;do if(!(((Ov(a,1)|0)&255)<<24>>24)){c=Rv(a)|0;if((c|0)==-99999|(l|0)<(c|0)){i=31;break a}e=o+(k*24|0)+(l<<2)|0;f[e>>2]=16;if(c|0){if(!(t|(c|0)==1)){i=13;break a}g=l-c|0;GM(j|0,p+(g<<10)|0,m|0)|0;g=f[o+(k*24|0)+(g<<2)>>2]|0;f[e>>2]=g;i=21;break}if(s){c=j;e=41863;g=c+16|0;do{b[c>>0]=b[e>>0]|0;c=c+1|0;e=e+1|0}while((c|0)<(g|0));i=22;break}if((l|0)<3&(g^1)){c=j;e=41879;g=c+64|0;do{b[c>>0]=b[e>>0]|0;c=c+1|0;e=e+1|0}while((c|0)<(g|0));g=16;i=21;break}else{c=j;e=41943;g=c+64|0;do{b[c>>0]=b[e>>0]|0;c=c+1|0;e=e+1|0}while((c|0)<(g|0));g=16;i=21;break}}else{if(n){c=Sv(a)|0;if((c+7|0)>>>0>254){i=31;break a}g=c+8|0;f[o+(k*24|0)+(l<<2)>>2]=g;c=g}else{c=8;g=16}i=0;while(1){e=Sv(a)|0;if((e+128|0)>>>0>255){i=31;break a}c=(c+256+e|0)%256|0;b[p+(l<<10)+i>>0]=c;i=i+1|0;if((i|0)>=(m|0)){i=21;break}}}while(0);b:do if((i|0)==21){i=0;switch(k|0){case 0:{i=22;break b}case 1:{e=bu(3,0)|0;c=0;do{b[((h[e+(c<<1)+1>>0]|0)<<3)+(h[e+(c<<1)>>0]|0)+(d+96+(l<<6))>>0]=b[p+(l<<10)+c>>0]|0;c=c+1|0}while((c|0)!=64);break}case 2:{e=bu(3,0)|0;c=0;do{j=e+(c<<1)|0;w=e+(c<<1)+1|0;x=b[p+(l<<10)+c>>0]|0;b[((h[w>>0]|0)<<5)+((h[j>>0]|0)<<1)+(d+480+(l<<8))>>0]=x;b[((h[j>>0]|0)<<1|1)+((h[w>>0]|0)<<5)+(d+480+(l<<8))>>0]=x;b[((h[w>>0]|0)<<5|16)+((h[j>>0]|0)<<1)+(d+480+(l<<8))>>0]=x;b[((h[w>>0]|0)<<5|16)+((h[j>>0]|0)<<1|1)+(d+480+(l<<8))>>0]=x;c=c+1|0}while((c|0)!=64);b[d+480+(l<<8)>>0]=g;break b}case 3:{x=d+2016+(l<<10)|0;Su(x,j,3);b[x>>0]=g;break b}default:break b}}while(0);if((i|0)==22){e=bu(2,0)|0;c=0;do{b[((h[e+(c<<1)+1>>0]|0)<<2)+(h[e+(c<<1)>>0]|0)+(d+(l<<4))>>0]=b[p+(l<<10)+c>>0]|0;c=c+1|0}while((c|0)!=16)}l=l+1|0}while((l|0)<(r|0));k=k+1|0;if((k|0)>=4){c=0;i=32;break}}if((i|0)==13)Pa(42027,41856,873,42064);else if((i|0)==31){x=8;u=v;return x|0}else if((i|0)==32){u=v;return c|0}return 0}function Ou(a){a=a|0;var c=0,d=0,e=0,f=0,g=0,i=0,j=0;d=bu(2,0)|0;c=0;do{b[a+(((h[d+(c<<1)+1>>0]|0)<<2)+(h[d+(c<<1)>>0]|0))>>0]=b[41863+c>>0]|0;c=c+1|0}while((c|0)!=16);d=bu(2,0)|0;c=0;do{b[((h[d+(c<<1)+1>>0]|0)<<2)+(h[d+(c<<1)>>0]|0)+(a+16)>>0]=b[41863+c>>0]|0;c=c+1|0}while((c|0)!=16);d=bu(2,0)|0;c=0;do{b[((h[d+(c<<1)+1>>0]|0)<<2)+(h[d+(c<<1)>>0]|0)+(a+32)>>0]=b[41863+c>>0]|0;c=c+1|0}while((c|0)!=16);d=bu(2,0)|0;c=0;do{b[((h[d+(c<<1)+1>>0]|0)<<2)+(h[d+(c<<1)>>0]|0)+(a+48)>>0]=b[41863+c>>0]|0;c=c+1|0}while((c|0)!=16);d=bu(2,0)|0;c=0;do{b[((h[d+(c<<1)+1>>0]|0)<<2)+(h[d+(c<<1)>>0]|0)+(a+64)>>0]=b[41863+c>>0]|0;c=c+1|0}while((c|0)!=16);d=bu(2,0)|0;c=0;do{b[((h[d+(c<<1)+1>>0]|0)<<2)+(h[d+(c<<1)>>0]|0)+(a+80)>>0]=b[41863+c>>0]|0;c=c+1|0}while((c|0)!=16);d=bu(3,0)|0;c=0;do{b[((h[d+(c<<1)+1>>0]|0)<<3)+(h[d+(c<<1)>>0]|0)+(a+96)>>0]=b[41879+c>>0]|0;c=c+1|0}while((c|0)!=64);d=bu(3,0)|0;c=0;do{b[((h[d+(c<<1)+1>>0]|0)<<3)+(h[d+(c<<1)>>0]|0)+(a+288)>>0]=b[41943+c>>0]|0;c=c+1|0}while((c|0)!=64);d=bu(3,0)|0;c=0;do{b[((h[d+(c<<1)+1>>0]|0)<<3)+(h[d+(c<<1)>>0]|0)+(a+160)>>0]=b[41879+c>>0]|0;c=c+1|0}while((c|0)!=64);d=bu(3,0)|0;c=0;do{b[((h[d+(c<<1)+1>>0]|0)<<3)+(h[d+(c<<1)>>0]|0)+(a+352)>>0]=b[41943+c>>0]|0;c=c+1|0}while((c|0)!=64);d=bu(3,0)|0;c=0;do{b[((h[d+(c<<1)+1>>0]|0)<<3)+(h[d+(c<<1)>>0]|0)+(a+224)>>0]=b[41879+c>>0]|0;c=c+1|0}while((c|0)!=64);d=bu(3,0)|0;c=0;do{b[((h[d+(c<<1)+1>>0]|0)<<3)+(h[d+(c<<1)>>0]|0)+(a+416)>>0]=b[41943+c>>0]|0;c=c+1|0}while((c|0)!=64);f=0;do{d=bu(3,0)|0;c=0;do{e=d+(c<<1)|0;g=d+(c<<1)+1|0;i=41879+c|0;b[((h[g>>0]|0)<<5)+((h[e>>0]|0)<<1)+(a+480+(f<<8))>>0]=b[i>>0]|0;b[((h[e>>0]|0)<<1|1)+((h[g>>0]|0)<<5)+(a+480+(f<<8))>>0]=b[i>>0]|0;b[((h[g>>0]|0)<<5|16)+((h[e>>0]|0)<<1)+(a+480+(f<<8))>>0]=b[i>>0]|0;b[((h[g>>0]|0)<<5|16)+((h[e>>0]|0)<<1|1)+(a+480+(f<<8))>>0]=b[i>>0]|0;c=c+1|0}while((c|0)!=64);d=f+3|0;e=bu(3,0)|0;c=0;do{i=e+(c<<1)|0;g=e+(c<<1)+1|0;j=41943+c|0;b[((h[g>>0]|0)<<5)+((h[i>>0]|0)<<1)+(a+480+(d<<8))>>0]=b[j>>0]|0;b[((h[i>>0]|0)<<1|1)+((h[g>>0]|0)<<5)+(a+480+(d<<8))>>0]=b[j>>0]|0;b[((h[g>>0]|0)<<5|16)+((h[i>>0]|0)<<1)+(a+480+(d<<8))>>0]=b[j>>0]|0;b[((h[g>>0]|0)<<5|16)+((h[i>>0]|0)<<1|1)+(a+480+(d<<8))>>0]=b[j>>0]|0;c=c+1|0}while((c|0)!=64);f=f+1|0}while((f|0)!=3);Su(a+2016|0,41879,3);Su(a+3040|0,41943,3);return}function Pu(a,b){a=a|0;b=b|0;var c=0,e=0,g=0,h=0,i=0,j=0,k=0;j=a+8|0;g=f[j>>2]|0;k=a+4|0;c=f[k>>2]|0;if(((g-c|0)/100|0)>>>0>=b>>>0){do{e=c+100|0;do{d[c>>1]=0;c=c+2|0}while((c|0)<(e|0));c=(f[k>>2]|0)+100|0;f[k>>2]=c;b=b+-1|0}while((b|0)!=0);return}e=f[a>>2]|0;h=(c-e|0)/100|0;c=h+b|0;if(c>>>0>42949672)$I(a);g=(g-e|0)/100|0;i=g<<1;c=g>>>0<21474836?(i>>>0<c>>>0?c:i):42949672;do if(c)if(c>>>0>42949672){k=Ra(8)|0;VK(k,44736);f[k>>2]=17660;Va(k|0,4016,428)}else{e=OK(c*100|0)|0;break}else e=0;while(0);i=e+(h*100|0)|0;h=e+(c*100|0)|0;c=i;g=i;do{e=c+100|0;do{d[c>>1]=0;c=c+2|0}while((c|0)<(e|0));c=g+100|0;g=c;b=b+-1|0}while((b|0)!=0);b=f[a>>2]|0;e=(f[k>>2]|0)-b|0;c=i+(((e|0)/-100|0)*100|0)|0;if((e|0)>0)GM(c|0,b|0,e|0)|0;f[a>>2]=c;f[k>>2]=g;f[j>>2]=h;if(!b)return;QK(b);return}function Qu(a,c,d){a=a|0;c=c|0;d=d|0;c=(Ov(d,1)|0)&255;b[a>>0]=c;c=(Ov(d,1)|0)&255;b[a+1>>0]=c;c=(Ov(d,1)|0)&255;b[a+2>>0]=c;c=(Ov(d,1)|0)&255;b[a+3>>0]=c;c=(Ov(d,1)|0)&255;b[a+4>>0]=c;c=(Ov(d,1)|0)&255;b[a+5>>0]=c;c=(Ov(d,1)|0)&255;b[a+6>>0]=c;c=(Ov(d,1)|0)&255;b[a+7>>0]=c;d=(Ov(d,1)|0)&255;b[a+8>>0]=d;return 0}function Ru(a){a=a|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;j=f[a+476>>2]|0;d=f[7988+(j<<2)>>2]|0;f[a+5016>>2]=d;e=f[8004+(j<<2)>>2]|0;f[a+5020>>2]=e;k=(f[a+5012>>2]|0)==0;f[a+5024>>2]=k?1:d;f[a+5028>>2]=k?1:e;k=f[a+512>>2]|0;f[a+4996>>2]=k;f[a+5e3>>2]=(k*6|0)+-48;l=f[a+516>>2]|0;f[a+5004>>2]=l;f[a+5008>>2]=(l*6|0)+-48;m=f[a+612>>2]|0;f[a+5036>>2]=m;n=(f[a+616>>2]|0)+m|0;f[a+5040>>2]=n;o=1<<m;f[a+5044>>2]=o;c=1<<n;f[a+5048>>2]=c;p=f[a+484>>2]|0;i=(o+-1+p|0)/(o|0)|0;f[a+5052>>2]=i;g=(p+-1+c|0)/(c|0)|0;f[a+5056>>2]=g;q=f[a+488>>2]|0;h=q+-1|0;r=(h+o|0)/(o|0)|0;f[a+5060>>2]=r;h=(h+c|0)/(c|0)|0;f[a+5064>>2]=h;i=X(r,i)|0;f[a+5068>>2]=i;i=X(h,g)|0;f[a+5072>>2]=i;i=X(q,p)|0;f[a+5076>>2]=i;if((j|0)!=0?(b[a+480>>0]|0)==0:0){f[a+5080>>2]=(c|0)/(d|0)|0;c=(c|0)/(e|0)|0}else{f[a+5080>>2]=0;c=0}f[a+5084>>2]=c;i=f[a+620>>2]|0;f[a+5100>>2]=i;j=(f[a+624>>2]|0)+i|0;f[a+5104>>2]=j;c=n-i|0;if((f[a+628>>2]|0)>(c|0)){r=8;return r|0}if((f[a+632>>2]|0)>(c|0)){r=8;return r|0}r=m+-1|0;f[a+5108>>2]=r;r=n-r|0;f[a+5112>>2]=g<<r;f[a+5116>>2]=h<<r;r=f[a+4708>>2]|0;f[a+5120>>2]=r;f[a+5124>>2]=(f[a+4712>>2]|0)+r;r=g<<c;f[a+5088>>2]=r;h=h<<c;f[a+5092>>2]=h;r=X(h,r)|0;f[a+5096>>2]=r;if(!(b[a+4990>>0]|0)){c=l+248&255;d=k+248&255;e=128