/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.util.Currency;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.CurrencyField;
import org.apache.solr.schema.ExchangeRateProvider;

public class CurrencyValue
implements Comparable<CurrencyValue> {
    private long amount;
    private String currencyCode;

    public CurrencyValue(long amount, String currencyCode) {
        this.amount = amount;
        this.currencyCode = currencyCode;
    }

    public static CurrencyValue parse(String externalVal, String defaultCurrency) {
        if (externalVal == null) {
            return null;
        }
        String amount = externalVal;
        String code = defaultCurrency;
        if (externalVal.contains(",")) {
            String[] amountAndCode = externalVal.split(",");
            amount = amountAndCode[0];
            code = amountAndCode[1];
        }
        if (amount.equals("*")) {
            return null;
        }
        Currency currency = CurrencyField.getCurrency(code);
        if (currency == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Currency code not supported by this JVM: " + code);
        }
        try {
            double value = Double.parseDouble(amount);
            long currencyValue = Math.round(value * Math.pow(10.0, currency.getDefaultFractionDigits()));
            return new CurrencyValue(currencyValue, code);
        }
        catch (NumberFormatException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
    }

    public long getAmount() {
        return this.amount;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public static long convertAmount(ExchangeRateProvider exchangeRates, String sourceCurrencyCode, long sourceAmount, String targetCurrencyCode) {
        double exchangeRate = exchangeRates.getExchangeRate(sourceCurrencyCode, targetCurrencyCode);
        return CurrencyValue.convertAmount(exchangeRate, sourceCurrencyCode, sourceAmount, targetCurrencyCode);
    }

    public static long convertAmount(double exchangeRate, int sourceFractionDigits, long sourceAmount, int targetFractionDigits) {
        double value;
        block4: {
            int digitDelta = targetFractionDigits - sourceFractionDigits;
            value = (double)sourceAmount * exchangeRate;
            if (digitDelta == 0) break block4;
            if (digitDelta < 0) {
                for (int i = 0; i < -digitDelta; ++i) {
                    value *= 0.1;
                }
            } else {
                for (int i = 0; i < digitDelta; ++i) {
                    value *= 10.0;
                }
            }
        }
        return (long)value;
    }

    public static long convertAmount(double exchangeRate, String sourceCurrencyCode, long sourceAmount, String targetCurrencyCode) {
        if (targetCurrencyCode.equals(sourceCurrencyCode)) {
            return sourceAmount;
        }
        int sourceFractionDigits = Currency.getInstance(sourceCurrencyCode).getDefaultFractionDigits();
        Currency targetCurrency = Currency.getInstance(targetCurrencyCode);
        int targetFractionDigits = targetCurrency.getDefaultFractionDigits();
        return CurrencyValue.convertAmount(exchangeRate, sourceFractionDigits, sourceAmount, targetFractionDigits);
    }

    public CurrencyValue convertTo(ExchangeRateProvider exchangeRates, String targetCurrencyCode) {
        return new CurrencyValue(CurrencyValue.convertAmount(exchangeRates, this.getCurrencyCode(), this.getAmount(), targetCurrencyCode), targetCurrencyCode);
    }

    public String strValue() {
        int digits = 0;
        try {
            Currency currency = Currency.getInstance(this.getCurrencyCode());
            if (currency == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid currency code " + this.getCurrencyCode());
            }
            digits = currency.getDefaultFractionDigits();
        }
        catch (IllegalArgumentException exception) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid currency code " + this.getCurrencyCode());
        }
        String amount = Long.toString(this.getAmount());
        if (this.getAmount() == 0L) {
            amount = amount + "000000".substring(0, digits);
        }
        return amount.substring(0, amount.length() - digits) + "." + amount.substring(amount.length() - digits) + "," + this.getCurrencyCode();
    }

    @Override
    public int compareTo(CurrencyValue o) {
        if (o == null) {
            throw new NullPointerException("Cannot compare CurrencyValue to a null values");
        }
        if (!this.getCurrencyCode().equals(o.getCurrencyCode())) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot compare CurrencyValues when their currencies are not equal");
        }
        if (o.getAmount() < this.getAmount()) {
            return 1;
        }
        if (o.getAmount() == this.getAmount()) {
            return 0;
        }
        return -1;
    }

    public String toString() {
        return this.strValue();
    }
}

