/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.export;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.solr.common.MapWriter;
import org.apache.solr.handler.export.FieldWriter;
import org.apache.solr.handler.export.SortDoc;
import org.apache.solr.handler.export.SortValue;

class IntFieldWriter
extends FieldWriter {
    private String field;

    public IntFieldWriter(String field) {
        this.field = field;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean write(SortDoc sortDoc, LeafReader reader, MapWriter.EntryWriter ew, int fieldIndex) throws IOException {
        int val;
        SortValue sortValue = sortDoc.getSortValue(this.field);
        if (sortValue != null) {
            if (!sortValue.isPresent()) return false;
            val = (Integer)sortValue.getCurrentValue();
        } else {
            NumericDocValues vals = DocValues.getNumeric((LeafReader)reader, (String)this.field);
            if (vals.advance(sortDoc.docId) != sortDoc.docId) return false;
            val = (int)vals.longValue();
        }
        ew.put((CharSequence)this.field, val);
        return true;
    }
}

