/* Autogenerated by mlir-tblgen; don't manually edit */
#ifdef GEN_PASS_CLASSES

//===----------------------------------------------------------------------===//
// BufferReusePass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class BufferReusePassBase : public ::mlir::FunctionPass {
public:
  using Base = BufferReusePassBase;

  BufferReusePassBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  BufferReusePassBase(const BufferReusePassBase &other) : ::mlir::FunctionPass(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("buffer-reuse");
  }
  ::llvm::StringRef getArgument() const override { return "buffer-reuse"; }

  ::llvm::StringRef getDescription() const override { return "Pass to find and annotate candidates for buffer reuse."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("BufferReusePass");
  }
  ::llvm::StringRef getName() const override { return "BufferReusePass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// ComputeOpAndFuncBufferizePass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ComputeOpAndFuncBufferizePassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = ComputeOpAndFuncBufferizePassBase;

  ComputeOpAndFuncBufferizePassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ComputeOpAndFuncBufferizePassBase(const ComputeOpAndFuncBufferizePassBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("computeop-and-func-bufferize");
  }
  ::llvm::StringRef getArgument() const override { return "computeop-and-func-bufferize"; }

  ::llvm::StringRef getDescription() const override { return "Pass to transform compute operations (hlo and linalg) on values to buffer based ones."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ComputeOpAndFuncBufferizePass");
  }
  ::llvm::StringRef getName() const override { return "ComputeOpAndFuncBufferizePass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// ConvertToSignlessPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertToSignlessPassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = ConvertToSignlessPassBase;

  ConvertToSignlessPassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertToSignlessPassBase(const ConvertToSignlessPassBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("convert-to-signless");
  }
  ::llvm::StringRef getArgument() const override { return "convert-to-signless"; }

  ::llvm::StringRef getDescription() const override { return "Pass to transform the IR to be on signless integers."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ConvertToSignlessPass");
  }
  ::llvm::StringRef getName() const override { return "ConvertToSignlessPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// CopyCleanupPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class CopyCleanupPassBase : public ::mlir::FunctionPass {
public:
  using Base = CopyCleanupPassBase;

  CopyCleanupPassBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  CopyCleanupPassBase(const CopyCleanupPassBase &other) : ::mlir::FunctionPass(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("copy-cleanup");
  }
  ::llvm::StringRef getArgument() const override { return "copy-cleanup"; }

  ::llvm::StringRef getDescription() const override { return "Pass to remove copies which are consumed by a GenericOp."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("CopyCleanupPass");
  }
  ::llvm::StringRef getName() const override { return "CopyCleanupPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// EmbedMemRefPrintsPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class EmbedMemRefPrintsPassBase : public ::mlir::FunctionPass {
public:
  using Base = EmbedMemRefPrintsPassBase;

  EmbedMemRefPrintsPassBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  EmbedMemRefPrintsPassBase(const EmbedMemRefPrintsPassBase &other) : ::mlir::FunctionPass(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("embed-memref-prints");
  }
  ::llvm::StringRef getArgument() const override { return "embed-memref-prints"; }

  ::llvm::StringRef getDescription() const override { return "Pass to print content of memrefs"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("EmbedMemRefPrintsPass");
  }
  ::llvm::StringRef getName() const override { return "EmbedMemRefPrintsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// EmbedTFFrameworkPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class EmbedTFFrameworkPassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = EmbedTFFrameworkPassBase;

  EmbedTFFrameworkPassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  EmbedTFFrameworkPassBase(const EmbedTFFrameworkPassBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("embed-tf-framework");
  }
  ::llvm::StringRef getArgument() const override { return "embed-tf-framework"; }

  ::llvm::StringRef getDescription() const override { return "Pass to embed TF Framework for allocation and assertions,"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("EmbedTFFrameworkPass");
  }
  ::llvm::StringRef getName() const override { return "EmbedTFFrameworkPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// FinalBufferizePass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class FinalBufferizePassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = FinalBufferizePassBase;

  FinalBufferizePassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  FinalBufferizePassBase(const FinalBufferizePassBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("final-bufferize");
  }
  ::llvm::StringRef getArgument() const override { return "final-bufferize"; }

  ::llvm::StringRef getDescription() const override { return "Pass to transform late operations on values to buffer based ones."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("FinalBufferizePass");
  }
  ::llvm::StringRef getName() const override { return "FinalBufferizePass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// FuseInnerParallelLoopsPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class FuseInnerParallelLoopsPassBase : public ::mlir::FunctionPass {
public:
  using Base = FuseInnerParallelLoopsPassBase;

  FuseInnerParallelLoopsPassBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  FuseInnerParallelLoopsPassBase(const FuseInnerParallelLoopsPassBase &other) : ::mlir::FunctionPass(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("fuse-inner-parallel-loops");
  }
  ::llvm::StringRef getArgument() const override { return "fuse-inner-parallel-loops"; }

  ::llvm::StringRef getDescription() const override { return "Limited pass to forward stores to loads."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("FuseInnerParallelLoopsPass");
  }
  ::llvm::StringRef getName() const override { return "FuseInnerParallelLoopsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// GpuKernelToBlobPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class GpuKernelToBlobPassBase : public ::mlir::OperationPass<gpu::GPUModuleOp> {
public:
  using Base = GpuKernelToBlobPassBase;

  GpuKernelToBlobPassBase() : ::mlir::OperationPass<gpu::GPUModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  GpuKernelToBlobPassBase(const GpuKernelToBlobPassBase &other) : ::mlir::OperationPass<gpu::GPUModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("gpu-kernel-to-blob");
  }
  ::llvm::StringRef getArgument() const override { return "gpu-kernel-to-blob"; }

  ::llvm::StringRef getDescription() const override { return "Pass to annotate GPU Module with its PTX"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("GpuKernelToBlobPass");
  }
  ::llvm::StringRef getName() const override { return "GpuKernelToBlobPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
  ::mlir::Pass::Option<std::string> blob_annotation_{*this, "blob-annotation", ::llvm::cl::desc("Blob attribute name"), ::llvm::cl::init("gpu.binary_blob")};
  ::mlir::Pass::ListOption<std::string> architectures_{*this, "arch", ::llvm::cl::desc("GPU architectures")};
  ::mlir::Pass::Option<bool> generate_fatbin_{*this, "generate-fatbin", ::llvm::cl::desc("Bundle machine code for the different architectures in one fatbin."), ::llvm::cl::init(true)};
  ::mlir::Pass::Option<bool> print_ptx_{*this, "print-ptx", ::llvm::cl::desc("Print generated PTX code per target architecture."), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> print_llvmir_{*this, "print-llvmir", ::llvm::cl::desc("Print llvm ir when lowering code per target architecture."), ::llvm::cl::init(false)};
};

//===----------------------------------------------------------------------===//
// GpuKernelToNVVMPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class GpuKernelToNVVMPassBase : public ::mlir::OperationPass<gpu::GPUModuleOp> {
public:
  using Base = GpuKernelToNVVMPassBase;

  GpuKernelToNVVMPassBase() : ::mlir::OperationPass<gpu::GPUModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  GpuKernelToNVVMPassBase(const GpuKernelToNVVMPassBase &other) : ::mlir::OperationPass<gpu::GPUModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("gpu-kernel-to-nvvm");
  }
  ::llvm::StringRef getArgument() const override { return "gpu-kernel-to-nvvm"; }

  ::llvm::StringRef getDescription() const override { return "Pass to transform a gpu module to nvvm."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("GpuKernelToNVVMPass");
  }
  ::llvm::StringRef getName() const override { return "GpuKernelToNVVMPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// GpuKernelToROCDLPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class GpuKernelToROCDLPassBase : public ::mlir::OperationPass<gpu::GPUModuleOp> {
public:
  using Base = GpuKernelToROCDLPassBase;

  GpuKernelToROCDLPassBase() : ::mlir::OperationPass<gpu::GPUModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  GpuKernelToROCDLPassBase(const GpuKernelToROCDLPassBase &other) : ::mlir::OperationPass<gpu::GPUModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("gpu-kernel-to-rocdl");
  }
  ::llvm::StringRef getArgument() const override { return "gpu-kernel-to-rocdl"; }

  ::llvm::StringRef getDescription() const override { return "Pass to transform a gpu module to rocdl."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("GpuKernelToROCDLPass");
  }
  ::llvm::StringRef getName() const override { return "GpuKernelToROCDLPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// LowerIndexCastPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class LowerIndexCastPassBase : public ::mlir::FunctionPass {
public:
  using Base = LowerIndexCastPassBase;

  LowerIndexCastPassBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  LowerIndexCastPassBase(const LowerIndexCastPassBase &other) : ::mlir::FunctionPass(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("kernelgen-lower-index-cast");
  }
  ::llvm::StringRef getArgument() const override { return "kernelgen-lower-index-cast"; }

  ::llvm::StringRef getDescription() const override { return "Lower index cast on tensors to tensor dialect"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("LowerIndexCastPass");
  }
  ::llvm::StringRef getName() const override { return "LowerIndexCastPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// MapParallelLoopsPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class MapParallelLoopsPassBase : public ::mlir::FunctionPass {
public:
  using Base = MapParallelLoopsPassBase;

  MapParallelLoopsPassBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  MapParallelLoopsPassBase(const MapParallelLoopsPassBase &other) : ::mlir::FunctionPass(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("map-parallel-loops-to-gpu");
  }
  ::llvm::StringRef getArgument() const override { return "map-parallel-loops-to-gpu"; }

  ::llvm::StringRef getDescription() const override { return "Greedily maps loops to GPU hardware dimensions."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("MapParallelLoopsPass");
  }
  ::llvm::StringRef getName() const override { return "MapParallelLoopsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// ParallelLoopsToSequential
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ParallelLoopsToSequentialBase : public ::mlir::FunctionPass {
public:
  using Base = ParallelLoopsToSequentialBase;

  ParallelLoopsToSequentialBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  ParallelLoopsToSequentialBase(const ParallelLoopsToSequentialBase &other) : ::mlir::FunctionPass(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("parallel-loops-to-sequential");
  }
  ::llvm::StringRef getArgument() const override { return "parallel-loops-to-sequential"; }

  ::llvm::StringRef getDescription() const override { return "Pass to convert scf::ParallelOp to scf::ForOp"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ParallelLoopsToSequential");
  }
  ::llvm::StringRef getName() const override { return "ParallelLoopsToSequential"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// PropagateShapeKnowledgeToKernels
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class PropagateShapeKnowledgeToKernelsBase : public ::mlir::FunctionPass {
public:
  using Base = PropagateShapeKnowledgeToKernelsBase;

  PropagateShapeKnowledgeToKernelsBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  PropagateShapeKnowledgeToKernelsBase(const PropagateShapeKnowledgeToKernelsBase &other) : ::mlir::FunctionPass(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("propagate-shape-knowledge-to-kernels");
  }
  ::llvm::StringRef getArgument() const override { return "propagate-shape-knowledge-to-kernels"; }

  ::llvm::StringRef getDescription() const override { return "Pass to propagate shape information into kernels"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("PropagateShapeKnowledgeToKernels");
  }
  ::llvm::StringRef getName() const override { return "PropagateShapeKnowledgeToKernels"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// PropagateTfAbiKnowledgeToKernels
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class PropagateTfAbiKnowledgeToKernelsBase : public ::mlir::FunctionPass {
public:
  using Base = PropagateTfAbiKnowledgeToKernelsBase;

  PropagateTfAbiKnowledgeToKernelsBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  PropagateTfAbiKnowledgeToKernelsBase(const PropagateTfAbiKnowledgeToKernelsBase &other) : ::mlir::FunctionPass(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("propagate-tf-abi-knowledge-to-kernels");
  }
  ::llvm::StringRef getArgument() const override { return "propagate-tf-abi-knowledge-to-kernels"; }

  ::llvm::StringRef getDescription() const override { return "Pass to propagate tensorflow ABI knowledge to kernels"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("PropagateTfAbiKnowledgeToKernels");
  }
  ::llvm::StringRef getName() const override { return "PropagateTfAbiKnowledgeToKernels"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// RewriteTFFrameworkAssert
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class RewriteTFFrameworkAssertBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = RewriteTFFrameworkAssertBase;

  RewriteTFFrameworkAssertBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  RewriteTFFrameworkAssertBase(const RewriteTFFrameworkAssertBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("rewrite-tf-framework-assert");
  }
  ::llvm::StringRef getArgument() const override { return "rewrite-tf-framework-assert"; }

  ::llvm::StringRef getDescription() const override { return "Pass to rewrite TFAssertOps to CondBranchOp"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("RewriteTFFrameworkAssert");
  }
  ::llvm::StringRef getName() const override { return "RewriteTFFrameworkAssert"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// ShapeSimplification
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ShapeSimplificationBase : public ::mlir::FunctionPass {
public:
  using Base = ShapeSimplificationBase;

  ShapeSimplificationBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  ShapeSimplificationBase(const ShapeSimplificationBase &other) : ::mlir::FunctionPass(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("kernelgen-shape-simplification");
  }
  ::llvm::StringRef getArgument() const override { return "kernelgen-shape-simplification"; }

  ::llvm::StringRef getDescription() const override { return "Simplify shape ops"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ShapeSimplification");
  }
  ::llvm::StringRef getName() const override { return "ShapeSimplification"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// ShapeToDescriptorsPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ShapeToDescriptorsPassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = ShapeToDescriptorsPassBase;

  ShapeToDescriptorsPassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ShapeToDescriptorsPassBase(const ShapeToDescriptorsPassBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("shape-to-descriptors");
  }
  ::llvm::StringRef getArgument() const override { return "shape-to-descriptors"; }

  ::llvm::StringRef getDescription() const override { return "Pass to transform shape computations to descriptors"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ShapeToDescriptorsPass");
  }
  ::llvm::StringRef getName() const override { return "ShapeToDescriptorsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// TFKernelToLLVMPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class TFKernelToLLVMPassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = TFKernelToLLVMPassBase;

  TFKernelToLLVMPassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TFKernelToLLVMPassBase(const TFKernelToLLVMPassBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tf-kernel-to-llvm");
  }
  ::llvm::StringRef getArgument() const override { return "tf-kernel-to-llvm"; }

  ::llvm::StringRef getDescription() const override { return "Pass for applying LLVM legalization patterns."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TFKernelToLLVMPass");
  }
  ::llvm::StringRef getName() const override { return "TFKernelToLLVMPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
  ::mlir::Pass::Option<std::string> blob_annotation_{*this, "blob-annotation", ::llvm::cl::desc("Blob attribute name"), ::llvm::cl::init("gpu.binary_blob")};
};

//===----------------------------------------------------------------------===//
// TFToJITInvocationPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class TFToJITInvocationPassBase : public ::mlir::FunctionPass {
public:
  using Base = TFToJITInvocationPassBase;

  TFToJITInvocationPassBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  TFToJITInvocationPassBase(const TFToJITInvocationPassBase &other) : ::mlir::FunctionPass(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tf-to-jit-invocation");
  }
  ::llvm::StringRef getArgument() const override { return "tf-to-jit-invocation"; }

  ::llvm::StringRef getDescription() const override { return "Pass to rewrite all TF operations to JIT invocations"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TFToJITInvocationPass");
  }
  ::llvm::StringRef getName() const override { return "TFToJITInvocationPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
  ::mlir::Pass::ListOption<std::string> architectures_{*this, "architectures", ::llvm::cl::desc("Target architectures"), llvm::cl::ZeroOrMore, llvm::cl::MiscFlags::CommaSeparated};
  ::mlir::Pass::ListOption<int64_t> tile_sizes_{*this, "tile-sizes", ::llvm::cl::desc("Tiling sizes"), llvm::cl::ZeroOrMore, llvm::cl::MiscFlags::CommaSeparated};
  ::mlir::Pass::ListOption<int64_t> unroll_factors_{*this, "unroll-factors", ::llvm::cl::desc("Unrolling in each tile dimension"), llvm::cl::ZeroOrMore, llvm::cl::MiscFlags::CommaSeparated};
  ::mlir::Pass::Option<int64_t> max_supported_rank_{*this, "max-supported-rank", ::llvm::cl::desc("Max rank that this kernel supports")};
  ::mlir::Pass::Option<bool> enable_ftz_{*this, "enable-ftz", ::llvm::cl::desc("Enable the denormal flush to zero mode when generating code")};
  ::mlir::Pass::Option<bool> cpu_codegen_{*this, "cpu-codegen", ::llvm::cl::desc("CPU codegen (false implies GPU)")};
};

//===----------------------------------------------------------------------===//
// TiledLoopBufferizePass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class TiledLoopBufferizePassBase : public ::mlir::FunctionPass {
public:
  using Base = TiledLoopBufferizePassBase;

  TiledLoopBufferizePassBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  TiledLoopBufferizePassBase(const TiledLoopBufferizePassBase &other) : ::mlir::FunctionPass(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tiled-loop-bufferize");
  }
  ::llvm::StringRef getArgument() const override { return "tiled-loop-bufferize"; }

  ::llvm::StringRef getDescription() const override { return "Pass to bufferize linalg.tiled_loop with the ops inside it."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TiledLoopBufferizePass");
  }
  ::llvm::StringRef getName() const override { return "TiledLoopBufferizePass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// VectorizationCleanupPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class VectorizationCleanupPassBase : public ::mlir::FunctionPass {
public:
  using Base = VectorizationCleanupPassBase;

  VectorizationCleanupPassBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  VectorizationCleanupPassBase(const VectorizationCleanupPassBase &other) : ::mlir::FunctionPass(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("vectorization-cleanup");
  }
  ::llvm::StringRef getArgument() const override { return "vectorization-cleanup"; }

  ::llvm::StringRef getDescription() const override { return "Pass to remove dead code in VectorizationPass."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("VectorizationCleanupPass");
  }
  ::llvm::StringRef getName() const override { return "VectorizationCleanupPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// VectorizationPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class VectorizationPassBase : public ::mlir::FunctionPass {
public:
  using Base = VectorizationPassBase;

  VectorizationPassBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  VectorizationPassBase(const VectorizationPassBase &other) : ::mlir::FunctionPass(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("vectorization");
  }
  ::llvm::StringRef getArgument() const override { return "vectorization"; }

  ::llvm::StringRef getDescription() const override { return "Pass to create vectorized operations for CPU."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("VectorizationPass");
  }
  ::llvm::StringRef getName() const override { return "VectorizationPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};
#undef GEN_PASS_CLASSES
#endif // GEN_PASS_CLASSES
#ifdef GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// BufferReusePass Registration
//===----------------------------------------------------------------------===//

inline void registerBufferReusePassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return transforms::CreateBufferReusePass();
  });
}

//===----------------------------------------------------------------------===//
// ComputeOpAndFuncBufferizePass Registration
//===----------------------------------------------------------------------===//

inline void registerComputeOpAndFuncBufferizePassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return transforms::CreateComputeOpAndFuncBufferizePass();
  });
}

//===----------------------------------------------------------------------===//
// ConvertToSignlessPass Registration
//===----------------------------------------------------------------------===//

inline void registerConvertToSignlessPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return transforms::CreateConvertToSignlessPass();
  });
}

//===----------------------------------------------------------------------===//
// CopyCleanupPass Registration
//===----------------------------------------------------------------------===//

inline void registerCopyCleanupPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return transforms::CreateCopyCleanupPass();
  });
}

//===----------------------------------------------------------------------===//
// EmbedMemRefPrintsPass Registration
//===----------------------------------------------------------------------===//

inline void registerEmbedMemRefPrintsPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return transforms::CreateEmbedMemRefPrintsPass();
  });
}

//===----------------------------------------------------------------------===//
// EmbedTFFrameworkPass Registration
//===----------------------------------------------------------------------===//

inline void registerEmbedTFFrameworkPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return tf_framework::CreateEmbedTFFrameworkPass();
  });
}

//===----------------------------------------------------------------------===//
// FinalBufferizePass Registration
//===----------------------------------------------------------------------===//

inline void registerFinalBufferizePassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return transforms::CreateFinalBufferizePass();
  });
}

//===----------------------------------------------------------------------===//
// FuseInnerParallelLoopsPass Registration
//===----------------------------------------------------------------------===//

inline void registerFuseInnerParallelLoopsPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return transforms::CreateFuseInnerParallelLoopsPass();
  });
}

//===----------------------------------------------------------------------===//
// GpuKernelToBlobPass Registration
//===----------------------------------------------------------------------===//

inline void registerGpuKernelToBlobPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return transforms::CreateGpuKernelToBlobPass();
  });
}

//===----------------------------------------------------------------------===//
// GpuKernelToNVVMPass Registration
//===----------------------------------------------------------------------===//

inline void registerGpuKernelToNVVMPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return transforms::CreateGpuKernelToNvvmPass();
  });
}

//===----------------------------------------------------------------------===//
// GpuKernelToROCDLPass Registration
//===----------------------------------------------------------------------===//

inline void registerGpuKernelToROCDLPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return transforms::CreateGpuKernelToRocdlPass();
  });
}

//===----------------------------------------------------------------------===//
// LowerIndexCastPass Registration
//===----------------------------------------------------------------------===//

inline void registerLowerIndexCastPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return transforms::CreateLowerIndexCastPass();
  });
}

//===----------------------------------------------------------------------===//
// MapParallelLoopsPass Registration
//===----------------------------------------------------------------------===//

inline void registerMapParallelLoopsPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return transforms::CreateMapParallelLoopsPass();
  });
}

//===----------------------------------------------------------------------===//
// ParallelLoopsToSequential Registration
//===----------------------------------------------------------------------===//

inline void registerParallelLoopsToSequentialPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return transforms::CreateParallelLoopsToSequential();
  });
}

//===----------------------------------------------------------------------===//
// PropagateShapeKnowledgeToKernels Registration
//===----------------------------------------------------------------------===//

inline void registerPropagateShapeKnowledgeToKernelsPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return transforms::CreatePropagateShapeKnowledgeToKernels();
  });
}

//===----------------------------------------------------------------------===//
// PropagateTfAbiKnowledgeToKernels Registration
//===----------------------------------------------------------------------===//

inline void registerPropagateTfAbiKnowledgeToKernelsPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return transforms::CreatePropagateTfAbiKnowledgeToKernels();
  });
}

//===----------------------------------------------------------------------===//
// RewriteTFFrameworkAssert Registration
//===----------------------------------------------------------------------===//

inline void registerRewriteTFFrameworkAssertPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return tf_framework::CreateRewriteTFFrameworkAssert();
  });
}

//===----------------------------------------------------------------------===//
// ShapeSimplification Registration
//===----------------------------------------------------------------------===//

inline void registerShapeSimplificationPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return transforms::CreateShapeSimplification();
  });
}

//===----------------------------------------------------------------------===//
// ShapeToDescriptorsPass Registration
//===----------------------------------------------------------------------===//

inline void registerShapeToDescriptorsPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return transforms::CreateShapeToDescriptorsPass();
  });
}

//===----------------------------------------------------------------------===//
// TFKernelToLLVMPass Registration
//===----------------------------------------------------------------------===//

inline void registerTFKernelToLLVMPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return transforms::CreateTFKernelToLLVMPass();
  });
}

//===----------------------------------------------------------------------===//
// TFToJITInvocationPass Registration
//===----------------------------------------------------------------------===//

inline void registerTFToJITInvocationPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return transforms::CreateTFToJITInvocationPass();
  });
}

//===----------------------------------------------------------------------===//
// TiledLoopBufferizePass Registration
//===----------------------------------------------------------------------===//

inline void registerTiledLoopBufferizePassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return transforms::CreateTiledLoopBufferizePass();
  });
}

//===----------------------------------------------------------------------===//
// VectorizationCleanupPass Registration
//===----------------------------------------------------------------------===//

inline void registerVectorizationCleanupPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return transforms::CreateVectorizationCleanupPass();
  });
}

//===----------------------------------------------------------------------===//
// VectorizationPass Registration
//===----------------------------------------------------------------------===//

inline void registerVectorizationPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return transforms::CreateVectorizationPass();
  });
}

//===----------------------------------------------------------------------===//
// KernelGen Registration
//===----------------------------------------------------------------------===//

inline void registerKernelGenPasses() {
  registerBufferReusePassPass();
  registerComputeOpAndFuncBufferizePassPass();
  registerConvertToSignlessPassPass();
  registerCopyCleanupPassPass();
  registerEmbedMemRefPrintsPassPass();
  registerEmbedTFFrameworkPassPass();
  registerFinalBufferizePassPass();
  registerFuseInnerParallelLoopsPassPass();
  registerGpuKernelToBlobPassPass();
  registerGpuKernelToNVVMPassPass();
  registerGpuKernelToROCDLPassPass();
  registerLowerIndexCastPassPass();
  registerMapParallelLoopsPassPass();
  registerParallelLoopsToSequentialPass();
  registerPropagateShapeKnowledgeToKernelsPass();
  registerPropagateTfAbiKnowledgeToKernelsPass();
  registerRewriteTFFrameworkAssertPass();
  registerShapeSimplificationPass();
  registerShapeToDescriptorsPassPass();
  registerTFKernelToLLVMPassPass();
  registerTFToJITInvocationPassPass();
  registerTiledLoopBufferizePassPass();
  registerVectorizationCleanupPassPass();
  registerVectorizationPassPass();
}
#undef GEN_PASS_REGISTRATION
#endif // GEN_PASS_REGISTRATION
