import type { DesktopCapturer } from 'electron';
import type { WebAppEvents } from '@wireapp/webapp-events';
import type { Data as OpenGraphResult } from 'open-graph';
import type { Static as amplify } from 'amplify';
import type * as EnvironmentUtil from './runtime/EnvironmentUtil';
import type { i18nStrings, SupportedI18nLanguage } from './locale/locale';
declare global {
    interface Window {
        amplify: amplify;
        isMac: boolean;
        locale: SupportedI18nLanguage;
        locStrings: i18nStrings;
        locStringsDefault: i18nStrings;
        sendBadgeCount(count: number, ignoreFlash: boolean): void;
        sendConversationJoinToHost(accountId: string, code: string, key: string): void;
        sendDeleteAccount(accountId: string, sessionId?: string): Promise<void>;
        sendLogoutAccount(accountId: string): Promise<void>;
        submitDeepLink(url: string): void;
        wire: any;
        z: {
            event: {
                WebApp: typeof WebAppEvents;
            };
            lifecycle: {
                UPDATE_SOURCE: {
                    DESKTOP: string;
                };
            };
            util: {
                Environment: {
                    version(showWrapperVersion: boolean): string;
                };
            };
        };
    }
    namespace NodeJS {
        interface Global {
            _ConfigurationPersistence: Record<string, any>;
            desktopCapturer: DesktopCapturer;
            environment: typeof EnvironmentUtil;
            openGraphAsync(url: string): Promise<OpenGraphResult>;
        }
    }
}
